package OpenInteract::Session::MySQL;

# $Id: MySQL.pm,v 1.10 2001/02/01 05:24:32 cwinters Exp $

use strict;

@OpenInteract::Session::MySQL::ISA     = qw( OpenInteract::Session );
$OpenInteract::Session::MySQL::VERSION = sprintf("%d.%02d", q$Revision: 1.10 $ =~ /(\d+)\.(\d+)/);

use constant DEBUG => 0;

sub _create_session { 
  my ( $class, $session_id ) = @_;
  my $R     = OpenInteract::Request->instance;
  $R->scrib( 1, "Trying to fetch session $session_id" );
  my %session = ();
  eval { tie %session, 'Apache::Session::MySQL', $session_id, 
                       { Handle => $R->db, LockHandle => $R->db } };
  if ( $@ ) {
    $R->throw( { code => 310, type => 'session',
                 system_msg => $@,
                 extra => { class => 'Apache::Session::MySQL', 
                            session_id => $session_id } } );
    $R->{session} = undef;
    $R->cookies->create_cookie( { name => $OpenInteract::Session::COOKIE_NAME,
                                  path => '/',
                                  value => undef,
                                  expires => '-3d' } );
    return undef;
  }
  return \%session;
}

1;

__END__

=pod

=head1 NAME

OpenInteract::Session::MySQL - Create sessions within MySQL

=head1 DESCRIPTION

Provide a '_create_session' method for L<OpenInteract::Session> so we
can use MySQL as a backend for L<Apache::Session>.

=head1 BUGS 

None yet!

=head1 TO DO

=head1 SEE ALSO

L<Apache::Session>, L<Apache::Session::MySQL>

=head1 COPYRIGHT

Copyright (c) 2001 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

=cut
