package REST::Cypher;
{
  $REST::Cypher::DIST = 'REST-Cypher';
}
$REST::Cypher::VERSION = '0.0.1'; # TRIAL
use strict;
use warnings;

use Moo;
use MooX::Types::MooseLike::Base qw/Bool/;
use MooseX::Params::Validate;

use REST::Cypher::Agent;

has agent => (
    is      => 'rw',
    lazy    => 1,
    writer  => '_set_agent',

    default => sub {
        REST::Cypher::Agent->new(
            base_url => $_[0]->rest_base_url,
            debug    => $_[0]->debug,
        );
    },
);

has server => (
    is          => 'ro',
    required    => 1,
    default     => 'localhost',
);

has server_port => (
    is          => 'ro',
    required    => 1,
    default     => '7474',
);

has rest_base_url => (
    is          => 'ro',
    lazy        => 1,
    default     => sub {
        sprintf(
            'http://%s:%d',
            $_[0]->server,
            $_[0]->server_port,
        );
    },
);

has debug => (
    is      => 'rw',
    isa     => Bool,
    default => 0,
);

sub query {
    my ($self, %params) = validated_hash(
        \@_,
        query_string => { isa => 'Str' },
    );

    my $response = $self->agent->POST(
        query_string => $params{query_string}
    );
}

1;
# ABSTRACT: REST::Cypher needs a more meaningful abstract

=pod

=encoding UTF-8

=head1 NAME

REST::Cypher - REST::Cypher needs a more meaningful abstract

=head1 VERSION

version 0.0.1

=head1 ATTRIBUTES

=head2 agent

=head2 server

=head2 server_port

=head2 rest_base_url

=head2 debug

=head1 METHODS

=head2 query($self, %params)

Send a Cypher query to the server,

=head1 AUTHOR

Chisel <chisel@chizography.net>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Chisel Wright.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__END__
# vim: ts=8 sts=4 et sw=4 sr sta
