/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.24 from the
 * contents of Moment.xs. Do not edit this file, edit Moment.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "Moment.xs"
#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "ppport.h"
#include "moment.h"
#include "moment_fmt.h"
#include "moment_parse.h"

typedef enum {
    MOMENT_PARAM_UNKNOWN=0,
    MOMENT_PARAM_YEAR,
    MOMENT_PARAM_MONTH,
    MOMENT_PARAM_DAY,
    MOMENT_PARAM_HOUR,
    MOMENT_PARAM_MINUTE,
    MOMENT_PARAM_SECOND,
    MOMENT_PARAM_NANOSECOND,
    MOMENT_PARAM_OFFSET,
    MOMENT_PARAM_LENIENT,
    MOMENT_PARAM_REDUCED,
    MOMENT_PARAM_EPOCH,
    MOMENT_PARAM_PRECISION,
} moment_param_t;

typedef int64_t I64V;

#if IVSIZE >= 8
# define SvI64V(sv)         (I64V)SvIV(sv)
# define newSVi64v(i64)     newSViv((IV)i64)
# define XSRETURN_I64V(i64) XSRETURN_IV((IV)i64)
#else
# define SvI64V(sv)         (I64V)SvNV(sv)
# define newSVi64v(i64)     newSVnv((NV)i64)
# define XSRETURN_I64V(i64) XSRETURN_NV((NV)i64)
#endif

#ifndef STR_WITH_LEN
#define STR_WITH_LEN(s)  ("" s ""), (sizeof(s)-1)
#endif

#ifndef gv_stashpvs
#define gv_stashpvs(s, flags) gv_stashpvn(STR_WITH_LEN(s), flags)
#endif

#ifndef XSRETURN_BOOL
#define XSRETURN_BOOL(v) STMT_START { ST(0) = boolSV(v); XSRETURN(1); } STMT_END
#endif

#ifndef XSRETURN_SV
#define XSRETURN_SV(sv) STMT_START { ST(0) = sv; XSRETURN(1); } STMT_END
#endif

#ifndef cBOOL
#define cBOOL(cbool) ((cbool) ? (bool)1 : (bool)0)
#endif

#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(x) ((void)x)
#endif

#define MY_CXT_KEY "Time::Moment::_guts" XS_VERSION
typedef struct {
    HV *stash;
} my_cxt_t;

START_MY_CXT

static void
setup_my_cxt(pTHX_ pMY_CXT) {
    MY_CXT.stash = gv_stashpvs("Time::Moment", GV_ADD);
}

static moment_param_t
moment_param(const char *s, const STRLEN len) {
    switch (len) {
        case 3:
            if (memEQ(s, "day", 3))
                return MOMENT_PARAM_DAY;
            break;
        case 4:
            if (memEQ(s, "year", 4))
                return MOMENT_PARAM_YEAR;
            if (memEQ(s, "hour", 4))
                return MOMENT_PARAM_HOUR;
            break;
        case 5:
            if (memEQ(s, "month", 5))
                return MOMENT_PARAM_MONTH;
            if (memEQ(s, "epoch", 5))
                return MOMENT_PARAM_EPOCH;
            break;
        case 6:
            if (memEQ(s, "minute", 6))
                return MOMENT_PARAM_MINUTE;
            if (memEQ(s, "second", 6))
                return MOMENT_PARAM_SECOND;
            if (memEQ(s, "offset", 6))
                return MOMENT_PARAM_OFFSET;
            break;
        case 7:
            if (memEQ(s, "lenient", 7))
                return MOMENT_PARAM_LENIENT;
            if (memEQ(s, "reduced", 7))
                return MOMENT_PARAM_REDUCED;
            break;
        case 9:
            if (memEQ(s, "precision", 9))
                return MOMENT_PARAM_PRECISION;
            break;
        case 10:
            if (memEQ(s, "nanosecond", 10))
                return MOMENT_PARAM_NANOSECOND;
            break;
    }
    return MOMENT_PARAM_UNKNOWN;
}

static moment_param_t
THX_sv_moment_param(pTHX_ SV *sv) {
    const char *str;
    STRLEN len;

    str = SvPV_const(sv, len);
    return moment_param(str, len);
}

static SV *
THX_sv_as_object(pTHX_ SV *sv, const char *name) {
    dSP;
    SV *rv;
    GV *method;
    int count;

    if (!SvROK(sv))
        return NULL;
    rv = SvRV(sv);
    if (!SvOBJECT(rv) || !SvSTASH(rv))
        return NULL;
    if (!(method = gv_fetchmethod(SvSTASH(rv), name)))
        return NULL;

    ENTER;
    SAVETMPS;
    PUSHMARK(SP);
    XPUSHs(sv);
    PUTBACK;
    count = call_sv((SV *)method, G_SCALAR);
    SPAGAIN;
    if (count != 1)
        croak("method call returned %d values, 1 expected", count);
    rv = newSVsv(POPs);
    PUTBACK;
    FREETMPS;
    LEAVE;
    return sv_2mortal(rv);
}

static SV *
THX_sv_2neat(pTHX_ SV *sv) {
    if (sv_isobject(sv)) {
        const char *name = sv_reftype(SvRV(sv), 1);
        const char *type = sv_reftype(SvRV(sv), 0);
        SV *dsv = sv_newmortal();
        sv_setpvf(dsv, "%s=%s(0x%p)", name, type, SvRV(sv));
        sv = dsv;
    }
    return sv;
}

static void
THX_croak_cmp(pTHX_ SV *sv1, SV *sv2, const bool swap, const char *name) {
    if (swap) {
        SV * const tmp = sv1;
        sv1 = sv2;
        sv2 = tmp;
    }
    croak("A %s object can only be compared to another %s object ('%"SVf"', '%"SVf"')",
        name, name, THX_sv_2neat(aTHX_ sv1), THX_sv_2neat(aTHX_ sv2));
}

static SV *
THX_newSVmoment(pTHX_ const moment_t *m, HV *stash) {
    SV *pv = newSVpvn((const char *)m, sizeof(moment_t));
    SV *sv = newRV_noinc(pv);
    sv_bless(sv, stash);
    return sv;
}

static SV *
THX_sv_set_moment(pTHX_ SV *sv, const moment_t *m) {
    if (!SvROK(sv))
        croak("panic: sv_set_moment called with nonreference");
    sv_setpvn_mg(SvRV(sv), (const char *)m, sizeof(moment_t));
    SvTEMP_off(sv);
    return sv;
}

static bool
THX_sv_isa_stash(pTHX_ SV *sv, const char *klass, HV *stash, size_t size) {
    SV *rv;

    SvGETMAGIC(sv);
    if (!SvROK(sv))
        return FALSE;
    rv = SvRV(sv);
    if (!(SvOBJECT(rv) && SvSTASH(rv) && SvPOKp(rv) && SvCUR(rv) == size))
        return FALSE;
    if (!(SvSTASH(rv) == stash || sv_derived_from(sv, klass)))
        return FALSE;
    return TRUE;
}

static HV *
THX_stash_constructor(pTHX_ SV *sv, const char *name, STRLEN namelen, HV *stash) {
    const char *pv;
    STRLEN len;

    SvGETMAGIC(sv);
    if (SvROK(sv)) {
        SV * const rv = SvRV(sv);
        if (SvOBJECT(rv) && SvSTASH(rv))
            return SvSTASH(rv);
    }
    pv = SvPV_nomg_const(sv, len);
    if (len == namelen && memEQ(pv, name, namelen))
        return stash;
    return gv_stashpvn(pv, len, GV_ADD);
}

static bool
THX_sv_isa_moment(pTHX_ SV *sv) {
    dMY_CXT;
    return THX_sv_isa_stash(aTHX_ sv, "Time::Moment", MY_CXT.stash, sizeof(moment_t));
}

static moment_t *
THX_sv_2moment_ptr(pTHX_ SV *sv, const char *name) {
    if (!THX_sv_isa_moment(aTHX_ sv))
        croak("%s is not an instance of Time::Moment", name);
    return (moment_t *)SvPVX_const(SvRV(sv));
}

static moment_t
THX_sv_2moment(pTHX_ SV *sv, const char *name) {
    return *THX_sv_2moment_ptr(aTHX_ sv, name);
}

static SV *
THX_sv_2moment_coerce_sv(pTHX_ SV *sv) {
    SV *res;

    if (THX_sv_isa_moment(aTHX_ sv))
        return sv;
    res = THX_sv_as_object(aTHX_ sv, "__as_Time_Moment");
    if(!res || !THX_sv_isa_moment(aTHX_ res))
        croak("Cannot coerce object of type %"SVf" to Time::Moment", THX_sv_2neat(aTHX_ sv));
    return res;
}

#define dSTASH_CONSTRUCTOR(sv, name, dstash) \
    HV * const stash = THX_stash_constructor(aTHX_ sv, STR_WITH_LEN(name), dstash)

#define dSTASH_INVOCANT \
    HV * const stash = SvSTASH(SvRV(ST(0)))

#define dSTASH_CONSTRUCTOR_MOMENT(sv) \
    dMY_CXT; \
    dSTASH_CONSTRUCTOR(sv, "Time::Moment", MY_CXT.stash)

#define newSVmoment(m, stash) \
    THX_newSVmoment(aTHX_ m, stash)

#define sv_set_moment(sv, m) \
    THX_sv_set_moment(aTHX_ sv, m);

#define sv_2moment_ptr(sv, name) \
    THX_sv_2moment_ptr(aTHX_ sv, name)

#define sv_2moment(sv, name) \
    THX_sv_2moment(aTHX_ sv, name)

#define sv_2moment_coerce_sv(sv) \
    THX_sv_2moment_coerce_sv(aTHX_ sv)

#define sv_isa_moment(sv) \
    THX_sv_isa_moment(aTHX_ sv)

#define croak_cmp(sv1, sv2, swap, name) \
    THX_croak_cmp(aTHX_ sv1, sv2, swap, name)

#define sv_moment_param(sv) \
    THX_sv_moment_param(aTHX_ sv)

#define sv_reusable(sv) \
    (SvTEMP(sv) && SvREFCNT(sv) == 1 && SvROK(sv) && SvREFCNT(SvRV(sv)) == 1)

XS(XS_Time_Moment_nil) {
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(items);
    XSRETURN_EMPTY;
}

XS(XS_Time_Moment_stringify) {
    dVAR; dXSARGS;
    if (items < 1)
        croak("Wrong number of arguments to Time::Moment::(\"\"");
    ST(0) = moment_to_string(sv_2moment_ptr(ST(0), "self"), FALSE);
    XSRETURN(1);
}

XS(XS_Time_Moment_ncmp) {
    dVAR; dXSARGS;
    const moment_t *m1, *m2;
    bool swap;
    SV *svm1, *svm2;

    if (items < 3)
        croak("Wrong number of arguments to Time::Moment::(<=>");

    svm1 = ST(0);
    svm2 = ST(1);
    swap = cBOOL(SvTRUE(ST(2)));

    if (!sv_isa_moment(svm2))
        croak_cmp(svm1, svm2, swap, "Time::Moment");
    m1 = sv_2moment_ptr(svm1, "self");
    m2 = sv_2moment_ptr(svm2, "other");
    if (swap) {
        const moment_t *tmp = m1;
        m1 = m2;
        m2 = tmp;
    }
    XSRETURN_IV(moment_compare_instant(m1, m2));
}

#ifdef HAS_GETTIMEOFDAY
static moment_t
THX_moment_now(pTHX_ bool utc) {
    struct timeval tv;
    IV off, sec;

    gettimeofday(&tv, NULL);
    if (utc)
        off = 0;
    else {
        const time_t when = tv.tv_sec;
        struct tm *tm;
#ifdef HAS_LOCALTIME_R
        struct tm tmbuf;
#ifdef LOCALTIME_R_NEEDS_TZSET
        tzset();
#endif
        tm = localtime_r(&when, &tmbuf);
#else
        tm = localtime(&when);
#endif
        if (tm == NULL)
            croak("localtime() failed: %s", Strerror(errno));

        sec = ((1461 * (tm->tm_year - 1) >> 2) + tm->tm_yday - 25202) * 86400
            + tm->tm_hour * 3600 + tm->tm_min * 60 + tm->tm_sec;
        off = (sec - tv.tv_sec) / 60;
    }
    return moment_from_epoch(tv.tv_sec, tv.tv_usec * 1000, off);
}
#endif

#line 379 "Moment.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)    S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage        S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 521 "Moment.c"
#ifdef USE_ITHREADS
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Time__Moment_CLONE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_CLONE)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 391 "Moment.xs"
{
    MY_CXT_CLONE;
    setup_my_cxt(aTHX_ aMY_CXT);
    PERL_UNUSED_VAR(items);
}
#line 538 "Moment.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Time__Moment_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_new)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "klass, ...");
    {
	SV *	klass = ST(0)
;
#line 403 "Moment.xs"
    dSTASH_CONSTRUCTOR_MOMENT(klass);
    IV year = 1, month = 1, day = 1;
    IV hour = 0, minute = 0, second = 0, ns = 0, offset = 0;
    I32 i;
#line 559 "Moment.c"
	moment_t	RETVAL;
#line 408 "Moment.xs"
    if (((items - 1) % 2) != 0)
        croak("Odd number of elements in call to constructor when named parameters were expected");

    for (i = 1; i < items; i += 2) {
        switch (sv_moment_param(ST(i))) {
            case MOMENT_PARAM_YEAR:        year   = SvIV(ST(i+1)); break;
            case MOMENT_PARAM_MONTH:       month  = SvIV(ST(i+1)); break;
            case MOMENT_PARAM_DAY:         day    = SvIV(ST(i+1)); break;
            case MOMENT_PARAM_HOUR:        hour   = SvIV(ST(i+1)); break;
            case MOMENT_PARAM_MINUTE:      minute = SvIV(ST(i+1)); break;
            case MOMENT_PARAM_SECOND:      second = SvIV(ST(i+1)); break;
            case MOMENT_PARAM_NANOSECOND:  ns     = SvIV(ST(i+1)); break;
            case MOMENT_PARAM_OFFSET:      offset = SvIV(ST(i+1)); break;
            default: croak("Unrecognised parameter: '%"SVf"'", ST(i));
        }
    }
    RETVAL = moment_new(year, month, day, hour, minute, second, ns, offset);
#line 579 "Moment.c"
    ST(0) = newSVmoment(&RETVAL, stash);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#ifdef HAS_GETTIMEOFDAY
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Time__Moment_now); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_now)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "klass");
    {
	SV *	klass = ST(0)
;
#line 437 "Moment.xs"
    dSTASH_CONSTRUCTOR_MOMENT(klass);
#line 602 "Moment.c"
	moment_t	RETVAL;
#line 439 "Moment.xs"
    RETVAL = THX_moment_now(aTHX_ !!ix);
#line 606 "Moment.c"
    ST(0) = newSVmoment(&RETVAL, stash);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Time__Moment_from_epoch); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_from_epoch)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "klass, seconds, nanosecond=0");
    {
	SV *	klass = ST(0)
;
	SV *	seconds = ST(1)
;
	IV	nanosecond;
#line 451 "Moment.xs"
    dSTASH_CONSTRUCTOR_MOMENT(klass);
#line 629 "Moment.c"
	moment_t	RETVAL;

	if (items < 3)
	    nanosecond = 0;
	else {
	    nanosecond = (IV)SvIV(ST(2))
;
	}
#line 453 "Moment.xs"
    if (items != 2 || SvIOK(seconds))
        RETVAL = moment_from_epoch(SvI64V(seconds), nanosecond, 0);
    else
        RETVAL = moment_from_epoch_nv(SvNV(seconds));
#line 643 "Moment.c"
    ST(0) = newSVmoment(&RETVAL, stash);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Time__Moment_from_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_from_string)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "klass, string, ...");
    {
	SV *	klass = ST(0)
;
	SV *	string = ST(1)
;
#line 465 "Moment.xs"
    dSTASH_CONSTRUCTOR_MOMENT(klass);
    bool lenient;
    const char *str;
    STRLEN len;
    I32 i;
#line 668 "Moment.c"
	moment_t	RETVAL;
#line 471 "Moment.xs"
    if ((items % 2) != 0)
        croak("Odd number of elements in named parameters");

    lenient = FALSE;
    for (i = 2; i < items; i += 2) {
        switch (sv_moment_param(ST(i))) {
            case MOMENT_PARAM_LENIENT:
                lenient = cBOOL(SvTRUE((ST(i+1))));
                break;
            default: 
                croak("Unrecognised parameter: '%"SVf"'", ST(i));
        }
    }
    str = SvPV_const(string, len);
    RETVAL = moment_from_string(str, len, lenient);
#line 686 "Moment.c"
    ST(0) = newSVmoment(&RETVAL, stash);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Time__Moment_from_rd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_from_rd)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2)
       croak_xs_usage(cv,  "klass, jd, ...");
    {
	SV *	klass = ST(0)
;
	NV	jd = (NV)SvNV(ST(1))
;
#line 494 "Moment.xs"
    dSTASH_CONSTRUCTOR_MOMENT(klass);
    NV epoch = 0;
    IV precision = 3;
    IV offset = 0;
    I32 i;
#line 712 "Moment.c"
	moment_t	RETVAL;
#line 504 "Moment.xs"
    if ((items % 2) != 0)
        croak("Odd number of elements in named parameters");

    switch (ix) {
        case 1: epoch = -1721424.5; break;
        case 2: epoch = 678576;     break;
    }

    for (i = 2; i < items; i += 2) {
        switch (sv_moment_param(ST(i))) {
            case MOMENT_PARAM_PRECISION:
                precision = SvIV(ST(i+1));
                break;
            case MOMENT_PARAM_EPOCH:
                epoch = SvNV(ST(i+1));
                break;
            case MOMENT_PARAM_OFFSET:
                if (ix == 0) {
                    offset = SvIV(ST(i+1));
                    break;
                }
                /* FALLTROUGH */
            default:
                croak("Unrecognised parameter: '%"SVf"'", ST(i));
        }
    }
    if      (ix == 0) RETVAL = moment_from_rd(jd, epoch, precision, offset);
    else if (ix == 1) RETVAL = moment_from_jd(jd, epoch, precision);
    else              RETVAL = moment_from_mjd(jd, epoch, precision);

#line 745 "Moment.c"
    ST(0) = newSVmoment(&RETVAL, stash);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Time__Moment_from_object); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_from_object)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "klass, object");
    {
	SV *	klass = ST(0)
;
	SV *	object = ST(1)
;
#line 542 "Moment.xs"
    dSTASH_CONSTRUCTOR_MOMENT(klass);
    PERL_UNUSED_VAR(stash);
#line 767 "Moment.c"
#line 545 "Moment.xs"
    XSRETURN_SV(sv_2moment_coerce_sv(object));
#line 770 "Moment.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Time__Moment_at_utc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_at_utc)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
#line 551 "Moment.xs"
    dSTASH_INVOCANT;
#line 788 "Moment.c"
	moment_t	RETVAL;
#line 560 "Moment.xs"
    switch (ix) {
        case 0: RETVAL = moment_at_utc(self);                   break;
        case 1: RETVAL = moment_at_midnight(self);              break;
        case 2: RETVAL = moment_at_noon(self);                  break;
        case 3: RETVAL = moment_at_last_day_of_year(self);      break;
        case 4: RETVAL = moment_at_last_day_of_quarter(self);   break;
        case 5: RETVAL = moment_at_last_day_of_month(self);     break;
    }
    if (moment_equals(self, &RETVAL))
        XSRETURN(1);
    if (sv_reusable(ST(0))) {
        sv_set_moment(ST(0), &RETVAL);
        XSRETURN(1);
    }
#line 805 "Moment.c"
    ST(0) = newSVmoment(&RETVAL, stash);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Time__Moment_plus_seconds); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_plus_seconds)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, value");
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
	I64V    value = SvI64V(ST(1))
;
#line 582 "Moment.xs"
    dSTASH_INVOCANT;
#line 827 "Moment.c"
	moment_t	RETVAL;
#line 595 "Moment.xs"
    if (value == 0)
        XSRETURN(1);
    RETVAL = moment_plus_unit(self, (moment_unit_t)ix, value);
    if (sv_reusable(ST(0))) {
        sv_set_moment(ST(0), &RETVAL);
        XSRETURN(1);
    }
#line 837 "Moment.c"
    ST(0) = newSVmoment(&RETVAL, stash);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Time__Moment_minus_seconds); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_minus_seconds)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, value");
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
	I64V    value = SvI64V(ST(1))
;
#line 610 "Moment.xs"
    dSTASH_INVOCANT;
#line 859 "Moment.c"
	moment_t	RETVAL;
#line 623 "Moment.xs"
    if (value == 0)
        XSRETURN(1);
    RETVAL = moment_minus_unit(self, (moment_unit_t)ix, value);
    if (sv_reusable(ST(0))) {
        sv_set_moment(ST(0), &RETVAL);
        XSRETURN(1);
    }
#line 869 "Moment.c"
    ST(0) = newSVmoment(&RETVAL, stash);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Time__Moment_delta_years); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_delta_years)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, other");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
	const moment_t *    other = sv_2moment_ptr(ST(1), "other")
;
#line 638 "Moment.xs"
    int64_t delta;
#line 893 "Moment.c"
#line 651 "Moment.xs"
    delta = moment_delta_unit(self, other, (moment_unit_t)ix);
    XSRETURN_I64V(delta);
#line 897 "Moment.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Time__Moment_with); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_with)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, adjuster");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
	SV *	adjuster = ST(1)
;
#line 659 "Moment.xs"
    I32 count;
    PERL_UNUSED_VAR(self);
#line 920 "Moment.c"
#line 662 "Moment.xs"
    SvGETMAGIC(adjuster);
    if (SvROK(adjuster))
        adjuster = SvRV(adjuster);
    if (SvTYPE(adjuster) != SVt_PVCV || SvOBJECT(adjuster))
        croak("Parameter: 'adjuster' is not a CODE reference");
    PUSHMARK(SP);
    SP += 1;
    PUTBACK;
    count = call_sv(adjuster, G_SCALAR);
    if (count != 1)
        croak("Expected one return value from adjuster, got %d elements", count);
    if (!sv_isa_moment(ST(0)))
        croak("Expected an instance of Time::Moment from adjuster, got '%"SVf"'", 
          THX_sv_2neat(aTHX_ ST(0)));
    SPAGAIN;
#line 937 "Moment.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Time__Moment_with_year); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_with_year)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, value");
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
	I64V    value = SvI64V(ST(1))
;
#line 683 "Moment.xs"
    dSTASH_INVOCANT;
#line 958 "Moment.c"
	moment_t	RETVAL;
#line 705 "Moment.xs"
    RETVAL = moment_with_field(self, (moment_component_t)ix, value);
    if (moment_equals(self, &RETVAL))
        XSRETURN(1);
    if (sv_reusable(ST(0))) {
        sv_set_moment(ST(0), &RETVAL);
        XSRETURN(1);
    }
#line 968 "Moment.c"
    ST(0) = newSVmoment(&RETVAL, stash);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Time__Moment_with_offset_same_instant); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_with_offset_same_instant)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, offset");
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
	IV	offset = (IV)SvIV(ST(1))
;
#line 720 "Moment.xs"
    dSTASH_INVOCANT;
#line 990 "Moment.c"
	moment_t	RETVAL;
#line 725 "Moment.xs"
    if (ix == 0)
        RETVAL = moment_with_offset_same_instant(self, offset);
    else
        RETVAL = moment_with_offset_same_local(self, offset);

    if (moment_equals(self, &RETVAL))
        XSRETURN(1);
    if (sv_reusable(ST(0))) {
        sv_set_moment(ST(0), &RETVAL);
        XSRETURN(1);
    }
#line 1004 "Moment.c"
    ST(0) = newSVmoment(&RETVAL, stash);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Time__Moment_year); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_year)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
#line 762 "Moment.xs"
    IV v = 0;
#line 1026 "Moment.c"
#line 764 "Moment.xs"
    switch (ix) {
        case  0: v = moment_year(self);                 break;
        case  1: v = moment_quarter(self);              break;
        case  2: v = moment_month(self);                break;
        case  3: v = moment_week(self);                 break;
        case  4: v = moment_day_of_year(self);          break;
        case  5: v = moment_day_of_quarter(self);       break;
        case  6: v = moment_day_of_month(self);         break;
        case  7: v = moment_day_of_week(self);          break;
        case  8: v = moment_hour(self);                 break;
        case  9: v = moment_minute(self);               break;
        case 10: v = moment_minute_of_day(self);        break;
        case 11: v = moment_second(self);               break;
        case 12: v = moment_second_of_day(self);        break;
        case 13: v = moment_millisecond(self);          break;
        case 14: v = moment_millisecond_of_day(self);   break;
        case 15: v = moment_microsecond(self);          break;
        case 16: v = moment_nanosecond(self);           break;
        case 17: v = moment_offset(self);               break;
    }
    XSRETURN_IV(v);
#line 1049 "Moment.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Time__Moment_epoch); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_epoch)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
#line 796 "Moment.xs"
    int64_t v = 0;
#line 1070 "Moment.c"
#line 798 "Moment.xs"
    switch (ix) {
        case 0: v = moment_epoch(self);                 break;
        case 1: v = moment_instant_rd_seconds(self);    break;
        case 2: v = moment_local_rd_seconds(self);      break;
        case 3: v = moment_microsecond_of_day(self);    break;
        case 4: v = moment_nanosecond_of_day(self);     break;
    }
    XSRETURN_I64V(v);
#line 1080 "Moment.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Time__Moment_jd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_jd)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
#line 815 "Moment.xs"
    NV v = 0;
    IV precision = 3;
    moment_t adjusted;
    I32 i;
#line 1104 "Moment.c"
#line 820 "Moment.xs"
    if (((items - 1) % 2) != 0)
        croak("Odd number of elements in named parameters");

    for (i = 1; i < items; i += 2) {
        switch (sv_moment_param(ST(i))) {
            case MOMENT_PARAM_PRECISION:
                precision = SvIV(ST(i+1));
                break;
            default:
                croak("Unrecognised parameter: '%"SVf"'", ST(i));
        }
    }
    adjusted = moment_with_precision(self, precision);
    switch (ix) {
        case 0: v = moment_jd(&adjusted);   break;
        case 1: v = moment_mjd(&adjusted);  break;
        case 2: v = moment_rd(&adjusted);   break;
    }
    XSRETURN_NV(v);
#line 1125 "Moment.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Time__Moment_length_of_year); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_length_of_year)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
#line 849 "Moment.xs"
    IV v = 0;
#line 1146 "Moment.c"
#line 851 "Moment.xs"
    switch (ix) {
        case 0: v = moment_length_of_year(self);        break;
        case 1: v = moment_length_of_quarter(self);     break;
        case 2: v = moment_length_of_month(self);       break;
        case 3: v = moment_length_of_week_year(self);   break;
    }
    XSRETURN_IV(v);
#line 1155 "Moment.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Time__Moment_utc_rd_values); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_utc_rd_values)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
#line 866 "Moment.xs"
    IV rdn, sod, nos;
#line 1176 "Moment.c"
#line 868 "Moment.xs"
    if (ix == 0)
        moment_to_instant_rd_values(self, &rdn, &sod, &nos);
    else
        moment_to_local_rd_values(self, &rdn, &sod, &nos);
    EXTEND(SP, 3);
    mPUSHi(rdn);
    mPUSHi(sod);
    mPUSHi(nos);
    XSRETURN(3);
#line 1187 "Moment.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Time__Moment_compare); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_compare)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, other");
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
	const moment_t *    other = sv_2moment_ptr(ST(1), "other")
;
	IV	RETVAL;
	dXSTARG;
#line 883 "Moment.xs"
    RETVAL = moment_compare_instant(self, other);
#line 1209 "Moment.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Time__Moment_is_equal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_is_equal)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, other");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
	const moment_t *    other = sv_2moment_ptr(ST(1), "other")
;
#line 896 "Moment.xs"
    bool v = FALSE;
#line 1232 "Moment.c"
#line 898 "Moment.xs"
    switch (ix) {
        case 0: v = moment_compare_instant(self, other) == 0; break;
        case 1: v = moment_compare_instant(self, other) < 0;  break;
        case 2: v = moment_compare_instant(self, other) > 0;  break;
    }
    XSRETURN_BOOL(v);
#line 1240 "Moment.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Time__Moment_strftime); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_strftime)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, format");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
	SV *	format = ST(1)
;
#line 910 "Moment.xs"
    STRLEN len;
    const char *str;
    SV *ret;
#line 1264 "Moment.c"
#line 914 "Moment.xs"
    str = SvPV_const(format, len);
    ret = moment_strftime(self, str, len);
    if (SvUTF8(format))
        SvUTF8_on(ret);
    XSRETURN_SV(ret);
#line 1271 "Moment.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Time__Moment_to_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Time__Moment_to_string)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const moment_t *    self = sv_2moment_ptr(ST(0), "self")
;
#line 924 "Moment.xs"
    bool reduced;
    I32 i;
#line 1292 "Moment.c"
#line 927 "Moment.xs"
    if (((items - 1) % 2) != 0)
        croak("Odd number of elements in named parameters");

    reduced = FALSE;
    for (i = 1; i < items; i += 2) {
        switch (sv_moment_param(ST(i))) {
            case MOMENT_PARAM_REDUCED:
                reduced = cBOOL(SvTRUE((ST(i+1))));
                break;
            default: 
                croak("Unrecognised parameter: '%"SVf"'", ST(i));
        }
    }
    XSRETURN_SV(moment_to_string(self, reduced));
#line 1308 "Moment.c"
	PUTBACK;
	return;
    }
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Time__Moment); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Time__Moment)
{
    dVAR; dXSARGS;
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK;

#if XSubPPtmpAAAA
        newXS("Time::Moment::CLONE", XS_Time__Moment_CLONE, file);
#endif
        newXS("Time::Moment::new", XS_Time__Moment_new, file);
#if XSubPPtmpAAAB
        cv = newXS("Time::Moment::now", XS_Time__Moment_now, file);
        XSANY.any_i32 = 0;
        cv = newXS("Time::Moment::now_utc", XS_Time__Moment_now, file);
        XSANY.any_i32 = 1;
#endif
        newXS("Time::Moment::from_epoch", XS_Time__Moment_from_epoch, file);
        newXS("Time::Moment::from_string", XS_Time__Moment_from_string, file);
        cv = newXS("Time::Moment::from_jd", XS_Time__Moment_from_rd, file);
        XSANY.any_i32 = 1;
        cv = newXS("Time::Moment::from_mjd", XS_Time__Moment_from_rd, file);
        XSANY.any_i32 = 2;
        cv = newXS("Time::Moment::from_rd", XS_Time__Moment_from_rd, file);
        XSANY.any_i32 = 0;
        newXS("Time::Moment::from_object", XS_Time__Moment_from_object, file);
        cv = newXS("Time::Moment::at_last_day_of_month", XS_Time__Moment_at_utc, file);
        XSANY.any_i32 = 5;
        cv = newXS("Time::Moment::at_last_day_of_quarter", XS_Time__Moment_at_utc, file);
        XSANY.any_i32 = 4;
        cv = newXS("Time::Moment::at_last_day_of_year", XS_Time__Moment_at_utc, file);
        XSANY.any_i32 = 3;
        cv = newXS("Time::Moment::at_midnight", XS_Time__Moment_at_utc, file);
        XSANY.any_i32 = 1;
        cv = newXS("Time::Moment::at_noon", XS_Time__Moment_at_utc, file);
        XSANY.any_i32 = 2;
        cv = newXS("Time::Moment::at_utc", XS_Time__Moment_at_utc, file);
        XSANY.any_i32 = 0;
        cv = newXS("Time::Moment::plus_days", XS_Time__Moment_plus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_DAYS;
        cv = newXS("Time::Moment::plus_hours", XS_Time__Moment_plus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_HOURS;
        cv = newXS("Time::Moment::plus_microseconds", XS_Time__Moment_plus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_MICROS;
        cv = newXS("Time::Moment::plus_milliseconds", XS_Time__Moment_plus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_MILLIS;
        cv = newXS("Time::Moment::plus_minutes", XS_Time__Moment_plus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_MINUTES;
        cv = newXS("Time::Moment::plus_months", XS_Time__Moment_plus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_MONTHS;
        cv = newXS("Time::Moment::plus_nanoseconds", XS_Time__Moment_plus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_NANOS;
        cv = newXS("Time::Moment::plus_seconds", XS_Time__Moment_plus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_SECONDS;
        cv = newXS("Time::Moment::plus_weeks", XS_Time__Moment_plus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_WEEKS;
        cv = newXS("Time::Moment::plus_years", XS_Time__Moment_plus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_YEARS;
        cv = newXS("Time::Moment::minus_days", XS_Time__Moment_minus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_DAYS;
        cv = newXS("Time::Moment::minus_hours", XS_Time__Moment_minus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_HOURS;
        cv = newXS("Time::Moment::minus_microseconds", XS_Time__Moment_minus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_MICROS;
        cv = newXS("Time::Moment::minus_milliseconds", XS_Time__Moment_minus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_MILLIS;
        cv = newXS("Time::Moment::minus_minutes", XS_Time__Moment_minus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_MINUTES;
        cv = newXS("Time::Moment::minus_months", XS_Time__Moment_minus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_MONTHS;
        cv = newXS("Time::Moment::minus_nanoseconds", XS_Time__Moment_minus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_NANOS;
        cv = newXS("Time::Moment::minus_seconds", XS_Time__Moment_minus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_SECONDS;
        cv = newXS("Time::Moment::minus_weeks", XS_Time__Moment_minus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_WEEKS;
        cv = newXS("Time::Moment::minus_years", XS_Time__Moment_minus_seconds, file);
        XSANY.any_i32 = MOMENT_UNIT_YEARS;
        cv = newXS("Time::Moment::delta_days", XS_Time__Moment_delta_years, file);
        XSANY.any_i32 = MOMENT_UNIT_DAYS;
        cv = newXS("Time::Moment::delta_hours", XS_Time__Moment_delta_years, file);
        XSANY.any_i32 = MOMENT_UNIT_HOURS;
        cv = newXS("Time::Moment::delta_microseconds", XS_Time__Moment_delta_years, file);
        XSANY.any_i32 = MOMENT_UNIT_MICROS;
        cv = newXS("Time::Moment::delta_milliseconds", XS_Time__Moment_delta_years, file);
        XSANY.any_i32 = MOMENT_UNIT_MILLIS;
        cv = newXS("Time::Moment::delta_minutes", XS_Time__Moment_delta_years, file);
        XSANY.any_i32 = MOMENT_UNIT_MINUTES;
        cv = newXS("Time::Moment::delta_months", XS_Time__Moment_delta_years, file);
        XSANY.any_i32 = MOMENT_UNIT_MONTHS;
        cv = newXS("Time::Moment::delta_nanoseconds", XS_Time__Moment_delta_years, file);
        XSANY.any_i32 = MOMENT_UNIT_NANOS;
        cv = newXS("Time::Moment::delta_seconds", XS_Time__Moment_delta_years, file);
        XSANY.any_i32 = MOMENT_UNIT_SECONDS;
        cv = newXS("Time::Moment::delta_weeks", XS_Time__Moment_delta_years, file);
        XSANY.any_i32 = MOMENT_UNIT_WEEKS;
        cv = newXS("Time::Moment::delta_years", XS_Time__Moment_delta_years, file);
        XSANY.any_i32 = MOMENT_UNIT_YEARS;
        newXS("Time::Moment::with", XS_Time__Moment_with, file);
        cv = newXS("Time::Moment::with_day_of_month", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_DAY_OF_MONTH;
        cv = newXS("Time::Moment::with_day_of_quarter", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_DAY_OF_QUARTER;
        cv = newXS("Time::Moment::with_day_of_week", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_DAY_OF_WEEK;
        cv = newXS("Time::Moment::with_day_of_year", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_DAY_OF_YEAR;
        cv = newXS("Time::Moment::with_hour", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_HOUR_OF_DAY;
        cv = newXS("Time::Moment::with_microsecond", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_MICRO_OF_SECOND;
        cv = newXS("Time::Moment::with_microsecond_of_day", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_MICRO_OF_DAY;
        cv = newXS("Time::Moment::with_millisecond", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_MILLI_OF_SECOND;
        cv = newXS("Time::Moment::with_millisecond_of_day", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_MILLI_OF_DAY;
        cv = newXS("Time::Moment::with_minute", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_MINUTE_OF_HOUR;
        cv = newXS("Time::Moment::with_minute_of_day", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_MINUTE_OF_DAY;
        cv = newXS("Time::Moment::with_month", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_MONTH_OF_YEAR;
        cv = newXS("Time::Moment::with_nanosecond", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_NANO_OF_SECOND;
        cv = newXS("Time::Moment::with_nanosecond_of_day", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_NANO_OF_DAY;
        cv = newXS("Time::Moment::with_precision", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_PRECISION;
        cv = newXS("Time::Moment::with_second", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_SECOND_OF_MINUTE;
        cv = newXS("Time::Moment::with_second_of_day", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_SECOND_OF_DAY;
        cv = newXS("Time::Moment::with_week", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_WEEK_OF_YEAR;
        cv = newXS("Time::Moment::with_year", XS_Time__Moment_with_year, file);
        XSANY.any_i32 = MOMENT_FIELD_YEAR;
        cv = newXS("Time::Moment::with_offset_same_instant", XS_Time__Moment_with_offset_same_instant, file);
        XSANY.any_i32 = 0;
        cv = newXS("Time::Moment::with_offset_same_local", XS_Time__Moment_with_offset_same_instant, file);
        XSANY.any_i32 = 1;
        cv = newXS("Time::Moment::day_of_month", XS_Time__Moment_year, file);
        XSANY.any_i32 = 6;
        cv = newXS("Time::Moment::day_of_quarter", XS_Time__Moment_year, file);
        XSANY.any_i32 = 5;
        cv = newXS("Time::Moment::day_of_week", XS_Time__Moment_year, file);
        XSANY.any_i32 = 7;
        cv = newXS("Time::Moment::day_of_year", XS_Time__Moment_year, file);
        XSANY.any_i32 = 4;
        cv = newXS("Time::Moment::hour", XS_Time__Moment_year, file);
        XSANY.any_i32 = 8;
        cv = newXS("Time::Moment::microsecond", XS_Time__Moment_year, file);
        XSANY.any_i32 = 15;
        cv = newXS("Time::Moment::millisecond", XS_Time__Moment_year, file);
        XSANY.any_i32 = 13;
        cv = newXS("Time::Moment::millisecond_of_day", XS_Time__Moment_year, file);
        XSANY.any_i32 = 14;
        cv = newXS("Time::Moment::minute", XS_Time__Moment_year, file);
        XSANY.any_i32 = 9;
        cv = newXS("Time::Moment::minute_of_day", XS_Time__Moment_year, file);
        XSANY.any_i32 = 10;
        cv = newXS("Time::Moment::month", XS_Time__Moment_year, file);
        XSANY.any_i32 = 2;
        cv = newXS("Time::Moment::nanosecond", XS_Time__Moment_year, file);
        XSANY.any_i32 = 16;
        cv = newXS("Time::Moment::offset", XS_Time__Moment_year, file);
        XSANY.any_i32 = 17;
        cv = newXS("Time::Moment::quarter", XS_Time__Moment_year, file);
        XSANY.any_i32 = 1;
        cv = newXS("Time::Moment::second", XS_Time__Moment_year, file);
        XSANY.any_i32 = 11;
        cv = newXS("Time::Moment::second_of_day", XS_Time__Moment_year, file);
        XSANY.any_i32 = 12;
        cv = newXS("Time::Moment::week", XS_Time__Moment_year, file);
        XSANY.any_i32 = 3;
        cv = newXS("Time::Moment::year", XS_Time__Moment_year, file);
        XSANY.any_i32 = 0;
        cv = newXS("Time::Moment::epoch", XS_Time__Moment_epoch, file);
        XSANY.any_i32 = 0;
        cv = newXS("Time::Moment::local_rd_as_seconds", XS_Time__Moment_epoch, file);
        XSANY.any_i32 = 2;
        cv = newXS("Time::Moment::microsecond_of_day", XS_Time__Moment_epoch, file);
        XSANY.any_i32 = 3;
        cv = newXS("Time::Moment::nanosecond_of_day", XS_Time__Moment_epoch, file);
        XSANY.any_i32 = 4;
        cv = newXS("Time::Moment::utc_rd_as_seconds", XS_Time__Moment_epoch, file);
        XSANY.any_i32 = 1;
        cv = newXS("Time::Moment::jd", XS_Time__Moment_jd, file);
        XSANY.any_i32 = 0;
        cv = newXS("Time::Moment::mjd", XS_Time__Moment_jd, file);
        XSANY.any_i32 = 1;
        cv = newXS("Time::Moment::rd", XS_Time__Moment_jd, file);
        XSANY.any_i32 = 2;
        cv = newXS("Time::Moment::length_of_month", XS_Time__Moment_length_of_year, file);
        XSANY.any_i32 = 2;
        cv = newXS("Time::Moment::length_of_quarter", XS_Time__Moment_length_of_year, file);
        XSANY.any_i32 = 1;
        cv = newXS("Time::Moment::length_of_week_year", XS_Time__Moment_length_of_year, file);
        XSANY.any_i32 = 3;
        cv = newXS("Time::Moment::length_of_year", XS_Time__Moment_length_of_year, file);
        XSANY.any_i32 = 0;
        cv = newXS("Time::Moment::local_rd_values", XS_Time__Moment_utc_rd_values, file);
        XSANY.any_i32 = 1;
        cv = newXS("Time::Moment::utc_rd_values", XS_Time__Moment_utc_rd_values, file);
        XSANY.any_i32 = 0;
        newXS("Time::Moment::compare", XS_Time__Moment_compare, file);
        cv = newXS("Time::Moment::is_after", XS_Time__Moment_is_equal, file);
        XSANY.any_i32 = 2;
        cv = newXS("Time::Moment::is_before", XS_Time__Moment_is_equal, file);
        XSANY.any_i32 = 1;
        cv = newXS("Time::Moment::is_equal", XS_Time__Moment_is_equal, file);
        XSANY.any_i32 = 0;
        newXS("Time::Moment::strftime", XS_Time__Moment_strftime, file);
        newXS("Time::Moment::to_string", XS_Time__Moment_to_string, file);

    /* Initialisation Section */

#line 374 "Moment.xs"
{
    MY_CXT_INIT;
    setup_my_cxt(aTHX_ aMY_CXT);
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    PL_amagic_generation++;
#endif
    sv_setsv(get_sv("Time::Moment::()", GV_ADD), &PL_sv_yes);
    newXS("Time::Moment::()", XS_Time_Moment_nil, file);
    newXS("Time::Moment::(\"\"", XS_Time_Moment_stringify, file);
    newXS("Time::Moment::(<=>", XS_Time_Moment_ncmp, file);
}

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#line 1561 "Moment.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

