#!/usr/bin/env perl

use 5.008;

use strict;
use warnings;

use Test::More;
use Test2::API qw/intercept/;

use Test::Approximate;

subtest is_approx_passing_event => sub {
    set_dop(4);
    my $ev = intercept {
        is_approx 4 * atan2(1,1), 355/113, "pi is pi";
    };

    my $sif = $ev->squash_info->flatten;
    is scalar @$sif, 1, "one event generated";
    ok ! $sif->[0]->{causes_failure}, "and it was a pass";
};

subtest is_approx_failing_event => sub {
    set_dop(4);
    my $ev = intercept {
        is_approx 4 * atan2(1,1), 22/7, "pi isn't pi";
    };

    my $sif = $ev->squash_info->flatten;
    is scalar @$sif, 1, "one event generated";
    ok $sif->[0]->{causes_failure}, "and it was a fail";
    ok exists $sif->[0]->{diag}, "there are diagnostics";
    is scalar @{$sif->[0]->{diag}}, 2, "two of them";

    my $exp_diag = <<'EOD';
    DOP: 4
    Delta: 0.0012644\d+
    Multiplier: 1000 \(1e3\)
    Diff: round\(1.2644\d+\)
    Comparison: 1 == 0
EOD
    my @diag = @{$sif->[0]->{diag}};

    ok $diag[0] =~ m/^Failed /, 'diagnostics line 1 is "Failed ..."';
    ok $diag[1] =~ /$exp_diag/, 'diagnostics line 2 is as expected';
};

subtest isnt_approx_passing_event => sub {
    set_dop(2);

    my $ev = intercept {
        isnt_approx 10, 11;
    };

    my $sif = $ev->squash_info->flatten;
    is scalar @$sif, 1, "one event generated";
    ok ! $sif->[0]->{causes_failure}, "and it was a pass";
};

subtest is_approx_failing_event => sub {
    set_dop(2);
    my $ev = intercept {
        isnt_approx 11.1, 11.2;
    };

    my $sif = $ev->squash_info->flatten;
    is scalar @$sif, 1, "one event generated";
    ok $sif->[0]->{causes_failure}, "and it was a fail";
    ok exists $sif->[0]->{diag}, "there are diagnostics";
    is scalar @{$sif->[0]->{diag}}, 2, "two of them";

    my $exp_diag = <<'EOD';
    DOP: 2
    Delta: 0.0999\d+
    Multiplier: 1 \(1e0\)
    Diff: round\(0.0999\d+\)
    Comparison: 0 != 0
EOD
    my @diag = @{$sif->[0]->{diag}};

    ok $diag[0] =~ m/^Failed /, 'diagnostics line 1 is "Failed ..."';
    ok $diag[1] =~ /$exp_diag/, 'diagnostics line 2 is as expected';
};

done_testing;
