package Acme::MetaSyntactic::octothorpe;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::octothorpe - The octothorpe theme

=head1 DESCRIPTION

Names for the C<#> symbol.

See L<http://www.sigtel.com/tel_tech_octothorpe.html>
about how the name I<octothorpe> was created. See also
L<http://www.worldwidewords.org/weirdwords/ww-oct1.htm> for other stories.

If you know another name for C<#> that is not included in this list,
please send it to me, with a reference to back up your claim. Thanks.

=head1 CONTRIBUTOR

Philippe "BooK" Bruhat, inspired by David Landgren's presentation of
L<Acme::DonMartin>.

Introduced in version 0.32, published on July 25, 2005.

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
comment_sign
crosshatch
crunch
fence
flash
gate
grid
gridlet
hash
hash_mark
hash_sign
hex
mesh
noughts_and_crosses
number_sign
octalthorpe
octothorn
octothorp
octothorpe
pig_pen
pound
pound_sign
scratchmark
sharp
splat
square
thud
thump
tic_tac_toe
widget_mark
