# NAME

GCC::Builtins - access GCC compiler builtin functions via XS

# VERSION

Version 0.02

# SYNOPSIS

This module provides Perl access to GCC C compiler
builtin functions.

    use GCC::Builtins qw/:all/;
    # or use GCC::Builtins qw/ ... clz ... /;
    my $leading_zeros = GCC::Builtins::clz(10);

# EXPORT

- `unisgned int clz(int n)`

Export tag `:all` imports all exportable functions.

# SUBROUTINES/METHODS

## `int clz(unsigned int n)`

It returns the number of leading zeros in the input integer.
It can be used to find the most significant bit turned on
whose (zero-based) index will be the return of this function.

# AUTHOR

Andreas Hadjiprocopis, `<bliako ta cpan.org / andreashad2 ta gmail.com>`

# BUGS

Please report any bugs or feature requests to `bug-gcc-builtins at rt.cpan.org`, or through
the web interface at [https://rt.cpan.org/NoAuth/ReportBug.html?Queue=GCC-Builtins](https://rt.cpan.org/NoAuth/ReportBug.html?Queue=GCC-Builtins).  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.

# SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc GCC::Builtins

You can also look for information at:

- RT: CPAN's request tracker (report bugs here)

    [https://rt.cpan.org/NoAuth/Bugs.html?Dist=GCC-Builtins](https://rt.cpan.org/NoAuth/Bugs.html?Dist=GCC-Builtins)

- Review this module at PerlMonks

    [https://www.perlmonks.org/?node\_id=21144](https://www.perlmonks.org/?node_id=21144)

- Search CPAN

    [https://metacpan.org/release/GCC-Builtins](https://metacpan.org/release/GCC-Builtins)

# ACKNOWLEDGEMENTS

- This module started by this discussion at PerlMonks:

    \[Most Significant Set Bit | https://perlmonks.org/?node\_id=11158279\]

- Hackers of Free Software.
- GNU and the Free Software Foundation, providers of GNU Compiler Collection.

# HUGS

!Almaz!

# LICENSE AND COPYRIGHT

This software is Copyright (c) 2024 by Andreas Hadjiprocopis.

This is free software, licensed under:

    The Artistic License 2.0 (GPL Compatible)
