/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlFrameSet;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableDataCell;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.NamedNodeMap;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.BoxObject;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRect;
import com.gargoylesoftware.htmlunit.javascript.host.Document;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Event;
import com.gargoylesoftware.htmlunit.javascript.host.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import com.gargoylesoftware.htmlunit.javascript.host.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.StaticNodeList;
import com.gargoylesoftware.htmlunit.javascript.host.TextRange;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMStringMap;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMTokenList;
import com.gargoylesoftware.htmlunit.javascript.host.html.DocumentProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.FunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyberneko.html.HTMLElements;
import org.w3c.css.sac.CSSException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@JsxClass(domClasses={HtmlElement.class})
public class HTMLElement
extends Element
implements ScriptableWithFallbackGetter {
    private static final Pattern PERCENT_VALUE = Pattern.compile("\\d+%");
    private static final Map<String, String> COLORS_MAP_IE = new HashMap<String, String>();
    private static final Log LOG = LogFactory.getLog(HTMLElement.class);
    private static final int BEHAVIOR_ID_UNKNOWN = -1;
    public static final int BEHAVIOR_ID_CLIENT_CAPS = 0;
    public static final int BEHAVIOR_ID_HOMEPAGE = 1;
    public static final int BEHAVIOR_ID_DOWNLOAD = 2;
    private static final String BEHAVIOR_CLIENT_CAPS = "#default#clientCaps";
    private static final String BEHAVIOR_HOMEPAGE = "#default#homePage";
    private static final String BEHAVIOR_DOWNLOAD = "#default#download";
    private static final Pattern CLASS_NAMES_SPLIT_PATTERN = Pattern.compile("\\s");
    private static final Pattern PRINT_NODE_PATTERN = Pattern.compile("  ");
    private static final Pattern PRINT_NODE_QUOTE_PATTERN = Pattern.compile("\"");
    static final String POSITION_BEFORE_BEGIN = "beforeBegin";
    static final String POSITION_AFTER_BEGIN = "afterBegin";
    static final String POSITION_BEFORE_END = "beforeEnd";
    static final String POSITION_AFTER_END = "afterEnd";
    private static int UniqueID_Counter_ = 1;
    private final Set<String> behaviors_ = new HashSet<String>();
    private BoxObject boxObject_;
    private HTMLCollection all_;
    private int scrollLeft_;
    private int scrollTop_;
    private String uniqueID_;
    private String ch_ = "";
    private String chOff_ = "";
    private static final List<String> INNER_HTML_READONLY_IN_IE;
    private static final List<String> INNER_TEXT_READONLY;
    private static final List<String> OUTER_HTML_READONLY;

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public HTMLCollection getAll() {
        if (this.all_ == null) {
            this.all_ = new HTMLCollection(this.getDomNodeOrDie(), false, "HTMLElement.all"){

                @Override
                protected boolean isMatching(DomNode node) {
                    return true;
                }
            };
        }
        return this.all_;
    }

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        this.setParentScope((Scriptable)this.getWindow().getDocument());
        HtmlElement htmlElt = (HtmlElement)domNode;
        for (DomAttr attr : htmlElt.getAttributesMap().values()) {
            String eventName = attr.getName();
            if (!eventName.startsWith("on")) continue;
            this.createEventHandler(eventName, attr.getValue());
        }
    }

    protected void createEventHandler(String eventName, String attrValue) {
        HtmlElement htmlElt = this.getDomNodeOrDie();
        EventHandler eventHandler = new EventHandler(htmlElt, eventName, attrValue);
        this.setEventHandler(eventName, (Function)eventHandler);
        if (htmlElt instanceof HtmlBody || htmlElt instanceof HtmlFrameSet) {
            this.getWindow().getEventListenersContainer().setEventHandlerProp(eventName.substring(2), (Object)eventHandler);
        }
    }

    @JsxGetter
    public String getId() {
        return this.getDomNodeOrDie().getId();
    }

    @JsxSetter
    public void setId(String newId) {
        this.getDomNodeOrDie().setId(newId);
    }

    @JsxGetter
    public String getTitle() {
        return this.getDomNodeOrDie().getAttribute("title");
    }

    @JsxSetter
    public void setTitle(String newTitle) {
        this.getDomNodeOrDie().setAttribute("title", newTitle);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getDisabled() {
        return this.getDomNodeOrDie().hasAttribute("disabled");
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public DocumentProxy getDocument() {
        return this.getWindow().getDocument_js();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setDisabled(boolean disabled) {
        HtmlElement element = this.getDomNodeOrDie();
        if (disabled) {
            element.setAttribute("disabled", "disabled");
        } else {
            element.removeAttribute("disabled");
        }
    }

    @Override
    public String getNamespaceURI() {
        HtmlElement domNode = this.getDomNodeOrDie();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_65)) {
            return domNode.getNamespaceURI();
        }
        if (domNode.getPage() instanceof HtmlPage) {
            return null;
        }
        return domNode.getNamespaceURI();
    }

    @Override
    public String getLocalName() {
        HtmlElement domNode = this.getDomNodeOrDie();
        if (domNode.getPage() instanceof HtmlPage) {
            StringBuilder localName = new StringBuilder();
            String prefix = ((DomNode)domNode).getPrefix();
            if (prefix != null) {
                localName.append(prefix);
                localName.append(':');
            }
            localName.append(((DomNode)domNode).getLocalName());
            return localName.toString().toUpperCase();
        }
        return ((DomNode)domNode).getLocalName();
    }

    @Override
    public Object getWithFallback(String name) {
        String value;
        HtmlElement htmlElement;
        if (!"class".equals(name) && (htmlElement = this.getDomNodeOrNull()) != null && this.isAttributeName(name) && DomElement.ATTRIBUTE_NOT_DEFINED != (value = htmlElement.getAttribute(name))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found attribute for evaluation of property \"" + name + "\" for of " + this));
            }
            return value;
        }
        return NOT_FOUND;
    }

    protected boolean isAttributeName(String name) {
        return name.toLowerCase().equals(name);
    }

    @Override
    protected String fixAttributeName(String attributeName) {
        SgmlPage page;
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLELEMENT_ATTRIBUTE_FIX_IN_QUIRKS_MODE) && (page = this.getDomNodeOrDie().getPage()) instanceof HtmlPage && ((HtmlPage)page).isQuirksMode()) {
            if ("className".equals(attributeName)) {
                return "class";
            }
            if ("class".equals(attributeName)) {
                return "_class";
            }
        }
        return attributeName;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void clearAttributes() {
        HtmlElement node = this.getDomNodeOrDie();
        ArrayList<String> removals = new ArrayList<String>();
        for (String attributeName : node.getAttributesMap().keySet()) {
            if (ScriptableObject.hasProperty((Scriptable)this.getPrototype(), (String)attributeName)) continue;
            removals.add(attributeName);
        }
        for (String attributeName : removals) {
            node.removeAttribute(attributeName);
        }
        for (Object id : this.getAllIds()) {
            if (id instanceof Integer) {
                int i = (Integer)id;
                this.delete(i);
                continue;
            }
            if (!(id instanceof String)) continue;
            this.delete((String)id);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void mergeAttributes(HTMLElement source, Object preserveIdentity) {
        HtmlElement src = source.getDomNodeOrDie();
        HtmlElement target = this.getDomNodeOrDie();
        for (Map.Entry<String, DomAttr> attribute : src.getAttributesMap().entrySet()) {
            String attributeName = attribute.getKey();
            if (ScriptableObject.hasProperty((Scriptable)this.getPrototype(), (String)attributeName)) continue;
            String attributeValue = attribute.getValue().getNodeValue();
            target.setAttribute(attributeName, attributeValue);
        }
        for (Object id : source.getAllIds()) {
            if (id instanceof Integer) {
                int i = (Integer)id;
                this.put(i, this, source.get(i, source));
                continue;
            }
            if (!(id instanceof String)) continue;
            String s = (String)id;
            this.put(s, this, source.get(s, source));
        }
        if (preserveIdentity instanceof Boolean && !((Boolean)preserveIdentity).booleanValue()) {
            target.setId(src.getId());
            target.setAttribute("name", src.getAttribute("name"));
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public Object getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getDomNodeOrDie().getAttributeNodeNS(namespaceURI, localName).getScriptObject();
    }

    @Override
    public void setAttribute(String name, String value) {
        name = this.fixAttributeName(name);
        this.getDomNodeOrDie().setAttribute(name, value);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_167) && !name.isEmpty()) {
            try {
                name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                Method method = this.getClass().getMethod("set" + name, Object.class);
                String source = "function(){" + value + "}";
                method.invoke((Object)this, Context.getCurrentContext().compileFunction((Scriptable)this.getWindow(), source, "", 0, null));
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    @JsxFunction
    public void removeAttributeNode(Attr attribute) {
        String name = attribute.getName();
        String namespaceUri = attribute.getNamespaceURI();
        this.removeAttributeNS(namespaceUri, name);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public HTMLElement removeNode(boolean removeChildren) {
        HTMLElement parent = (HTMLElement)this.getParentElement();
        if (parent != null) {
            parent.removeChild(this);
            if (!removeChildren) {
                NodeList collection = this.getChildNodes();
                int length = collection.getLength();
                for (int i = 0; i < length; ++i) {
                    Node object = (Node)collection.item((Object)0);
                    parent.appendChild(object);
                }
            }
        }
        return this;
    }

    @Override
    @JsxFunction
    public Object getAttributeNode(String attributeName) {
        return ((NamedNodeMap)this.getAttributes()).getNamedItem(attributeName);
    }

    @JsxFunction
    public Attr setAttributeNode(Attr newAtt) {
        Attr replacedAtt;
        String name = newAtt.getName();
        boolean undefForClass = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SET_ATTRIBUTE_CONSIDERS_ATTR_FOR_CLASS_AS_REAL);
        if (undefForClass) {
            replacedAtt = (Attr)this.getAttributeNode(name);
        } else {
            NamedNodeMap nodes = (NamedNodeMap)this.getAttributes();
            replacedAtt = (Attr)nodes.getNamedItemWithoutSytheticClassAttr(name);
        }
        if (replacedAtt != null) {
            replacedAtt.detachFromParent();
        }
        DomAttr newDomAttr = newAtt.getDomNodeOrDie();
        this.getDomNodeOrDie().setAttributeNode(newDomAttr);
        return replacedAtt;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public HTMLCollection getElementsByClassName(String className) {
        HtmlElement elt = this.getDomNodeOrDie();
        String description = "HTMLElement.getElementsByClassName('" + className + "')";
        final String[] classNames = CLASS_NAMES_SPLIT_PATTERN.split(className, 0);
        HTMLCollection collection = new HTMLCollection(elt, true, description){

            @Override
            protected boolean isMatching(DomNode node) {
                if (!(node instanceof HtmlElement)) {
                    return false;
                }
                HtmlElement elt = (HtmlElement)node;
                String classAttribute = elt.getAttribute("class");
                if (classAttribute == DomElement.ATTRIBUTE_NOT_DEFINED) {
                    return false;
                }
                classAttribute = " " + classAttribute + " ";
                for (String aClassName : classNames) {
                    if (classAttribute.contains(" " + aClassName + " ")) continue;
                    return false;
                }
                return true;
            }
        };
        return collection;
    }

    @JsxGetter(propertyName="className")
    public Object getClassName_js() {
        return this.getDomNodeOrDie().getAttribute("class");
    }

    @JsxGetter
    public int getClientHeight() {
        boolean includePadding = !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ELEMENT_EXTENT_WITHOUT_PADDING);
        ComputedCSSStyleDeclaration style = this.getWindow().getComputedStyle(this, null);
        return style.getCalculatedHeight(false, includePadding);
    }

    @JsxGetter
    public int getClientWidth() {
        boolean includePadding = !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ELEMENT_EXTENT_WITHOUT_PADDING);
        ComputedCSSStyleDeclaration style = this.getWindow().getComputedStyle(this, null);
        return style.getCalculatedWidth(false, includePadding);
    }

    @JsxSetter
    public void setClassName(String className) {
        this.getDomNodeOrDie().setAttribute("class", className);
    }

    @JsxGetter
    public String getInnerHTML() {
        StringBuilder buf = new StringBuilder();
        String tagName = this.getTagName();
        boolean isPlain = "SCRIPT".equals(tagName);
        if (isPlain && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_NATIVE_FUNCTION_TOSTRING_NEW_LINE)) {
            buf.append("\r\n");
        }
        isPlain = isPlain || "STYLE".equals(tagName);
        this.printChildren(buf, this.getDomNodeOrDie(), !isPlain);
        return buf.toString();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public String getInnerText() {
        StringBuilder buf = new StringBuilder();
        this.printChildren(buf, this.getDomNodeOrDie(), false);
        return buf.toString();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=11.0f)})
    public String getOuterHTML() {
        StringBuilder buf = new StringBuilder();
        this.printNode(buf, this.getDomNodeOrDie(), true);
        return buf.toString();
    }

    private void printChildren(StringBuilder buffer, DomNode node, boolean html) {
        for (DomNode child : node.getChildren()) {
            this.printNode(buffer, child, html);
        }
    }

    private void printNode(StringBuilder buffer, DomNode node, boolean html) {
        if (node instanceof DomComment) {
            if (html) {
                String s = PRINT_NODE_PATTERN.matcher(node.getNodeValue()).replaceAll(" ");
                buffer.append("<!--").append(s).append("-->");
            }
        } else if (node instanceof DomCharacterData) {
            String s = node.getNodeValue();
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_HTML_REDUCE_WHITESPACES)) {
                s = PRINT_NODE_PATTERN.matcher(s).replaceAll(" ");
            }
            if (html) {
                s = StringUtils.escapeXmlChars(s);
            }
            buffer.append(s);
        } else if (html) {
            HtmlElement element = (HtmlElement)node;
            HTMLElement scriptObject = (HTMLElement)node.getScriptObject();
            boolean isUpperCase = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLELEMENT_OUTER_HTML_UPPER_CASE);
            String tag = element.getTagName();
            if (isUpperCase && !scriptObject.isLowerCaseInOuterHtml()) {
                tag = tag.toUpperCase();
            }
            buffer.append("<").append(tag);
            for (DomAttr attr : element.getAttributesMap().values()) {
                String name = attr.getName();
                String value = PRINT_NODE_QUOTE_PATTERN.matcher(attr.getValue()).replaceAll("&quot;");
                boolean quote = !isUpperCase || StringUtils.containsWhitespace(value) || value.isEmpty() || element instanceof HtmlAnchor && "href".equals(name);
                buffer.append(' ').append(name).append("=");
                if (quote) {
                    buffer.append("\"");
                }
                buffer.append(value);
                if (!quote) continue;
                buffer.append("\"");
            }
            buffer.append(">");
            this.printChildren(buffer, node, html);
            if (!scriptObject.isEndTagForbidden()) {
                buffer.append("</").append(tag).append(">");
            }
        } else {
            HtmlElement element = (HtmlElement)node;
            if ("p".equals(element.getTagName())) {
                buffer.append("\r\n");
            }
            if (!"script".equals(element.getTagName())) {
                this.printChildren(buffer, node, html);
            }
        }
    }

    @JsxSetter
    public void setInnerHTML(Object value) {
        HtmlElement domNode = this.getDomNodeOrDie();
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_70);
        if (ie && INNER_HTML_READONLY_IN_IE.contains(((DomNode)domNode).getNodeName())) {
            throw Context.reportRuntimeError((String)("innerHTML is read-only for tag " + ((DomNode)domNode).getNodeName()));
        }
        domNode.removeAllChildren();
        if (value == null && ie || value != null && !"".equals(value)) {
            String valueAsString = Context.toString((Object)value);
            HTMLElement.parseHtmlSnippet(domNode, true, valueAsString);
            if (domNode.getParentNode() == null && ie) {
                DomDocumentFragment fragment = ((HtmlPage)domNode.getPage()).createDomDocumentFragment();
                fragment.appendChild(domNode);
            }
        }
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public void setInnerText(String value) {
        this.setInnerTextImpl(Context.toString((Object)value));
    }

    private void setInnerTextImpl(String value) {
        HtmlElement domNode = this.getDomNodeOrDie();
        if (INNER_TEXT_READONLY.contains(((DomNode)domNode).getNodeName())) {
            throw Context.reportRuntimeError((String)("innerText is read-only for tag " + ((DomNode)domNode).getNodeName()));
        }
        domNode.removeAllChildren();
        if (value != null && !value.isEmpty()) {
            domNode.appendChild(new DomText(domNode.getPage(), Context.toString((Object)value)));
        }
        if (domNode.getParentNode() == null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_71)) {
            DomDocumentFragment fragment = ((HtmlPage)domNode.getPage()).createDomDocumentFragment();
            fragment.appendChild(domNode);
        }
    }

    @Override
    public void setTextContent(Object value) {
        this.setInnerTextImpl(value == null ? null : Context.toString((Object)value));
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)})
    public void setOuterHTML(String value) {
        HtmlElement domNode = this.getDomNodeOrDie();
        if (OUTER_HTML_READONLY.contains(((DomNode)domNode).getNodeName())) {
            throw Context.reportRuntimeError((String)("outerHTML is read-only for tag " + ((DomNode)domNode).getNodeName()));
        }
        DomDocumentFragment fragment = (DomDocumentFragment)domNode.getPage().createDocumentFragment();
        HTMLElement.parseHtmlSnippet(fragment, false, value);
        DomNode child = fragment.getFirstChild();
        if (child instanceof DomElement) {
            String parentName = domNode.getParentNode().getNodeName().toUpperCase();
            short[] closes = HTMLElements.getElement((String)child.getNodeName()).closes;
            if (closes != null) {
                for (short close : closes) {
                    if (!HTMLElements.getElement((short)close).name.equals(parentName)) continue;
                    throw Context.reportRuntimeError((String)("outerHTML can not set '" + value + "' while its parent is " + domNode.getParentNode()));
                }
            }
        }
        while (child != null) {
            domNode.insertBefore(child);
            child = fragment.getFirstChild();
        }
        domNode.remove();
    }

    public static void parseHtmlSnippet(DomNode target, boolean append, String source) {
        try {
            HTMLParser.parseFragment(target, source);
        }
        catch (IOException e) {
            LogFactory.getLog(HtmlElement.class).error((Object)"Unexpected exception occurred while parsing HTML snippet", (Throwable)e);
            throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage()));
        }
        catch (SAXException e) {
            LogFactory.getLog(HtmlElement.class).error((Object)"Unexpected exception occurred while parsing HTML snippet", (Throwable)e);
            throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage()));
        }
    }

    protected AttributesImpl readAttributes(HtmlElement element) {
        AttributesImpl attributes = new AttributesImpl();
        for (DomAttr entry : element.getAttributesMap().values()) {
            String name = entry.getName();
            String value = entry.getValue();
            attributes.addAttribute(null, name, name, null, value);
        }
        return attributes;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void insertAdjacentHTML(String where, String text) {
        Object[] values = this.getInsertAdjacentLocation(where);
        DomNode node = (DomNode)values[0];
        boolean append = (Boolean)values[1];
        ProxyDomNode proxyNode = new ProxyDomNode(node.getPage(), node, append);
        HTMLElement.parseHtmlSnippet(proxyNode, append, text);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object insertAdjacentElement(String where, Object object) {
        if (object instanceof Node) {
            Object childNode = ((Node)object).getDomNodeOrDie();
            Object[] values = this.getInsertAdjacentLocation(where);
            DomNode node = (DomNode)values[0];
            boolean append = (Boolean)values[1];
            if (append) {
                node.appendChild((org.w3c.dom.Node)childNode);
            } else {
                node.insertBefore((DomNode)childNode);
            }
            return object;
        }
        throw Context.reportRuntimeError((String)("Passed object is not an element: " + object));
    }

    private Object[] getInsertAdjacentLocation(String where) {
        boolean append;
        DomNode node;
        HtmlElement currentNode = this.getDomNodeOrDie();
        if (POSITION_AFTER_BEGIN.equalsIgnoreCase(where)) {
            if (currentNode.getFirstChild() == null) {
                node = currentNode;
                append = true;
            } else {
                node = currentNode.getFirstChild();
                append = false;
            }
        } else if (POSITION_BEFORE_BEGIN.equalsIgnoreCase(where)) {
            node = currentNode;
            append = false;
        } else if (POSITION_BEFORE_END.equalsIgnoreCase(where)) {
            node = currentNode;
            append = true;
        } else if (POSITION_AFTER_END.equalsIgnoreCase(where)) {
            if (currentNode.getNextSibling() == null) {
                node = currentNode.getParentNode();
                append = true;
            } else {
                node = currentNode.getNextSibling();
                append = false;
            }
        } else {
            throw Context.reportRuntimeError((String)("Illegal position value: \"" + where + "\""));
        }
        if (append) {
            return new Object[]{node, Boolean.TRUE};
        }
        return new Object[]{node, Boolean.FALSE};
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public int addBehavior(String behavior) {
        if (this.behaviors_.contains(behavior)) {
            return 0;
        }
        Class<?> c = this.getClass();
        if (BEHAVIOR_CLIENT_CAPS.equalsIgnoreCase(behavior)) {
            this.defineProperty("availHeight", c, 0);
            this.defineProperty("availWidth", c, 0);
            this.defineProperty("bufferDepth", c, 0);
            this.defineProperty("colorDepth", c, 0);
            this.defineProperty("connectionType", c, 0);
            this.defineProperty("cookieEnabled", c, 0);
            this.defineProperty("cpuClass", c, 0);
            this.defineProperty("height", c, 0);
            this.defineProperty("javaEnabled", c, 0);
            this.defineProperty("platform", c, 0);
            this.defineProperty("systemLanguage", c, 0);
            this.defineProperty("userLanguage", c, 0);
            this.defineProperty("width", c, 0);
            this.defineFunctionProperties(new String[]{"addComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"clearComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"compareVersions"}, c, 0);
            this.defineFunctionProperties(new String[]{"doComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"getComponentVersion"}, c, 0);
            this.defineFunctionProperties(new String[]{"isComponentInstalled"}, c, 0);
            this.behaviors_.add(BEHAVIOR_CLIENT_CAPS);
            return 0;
        }
        if (BEHAVIOR_HOMEPAGE.equalsIgnoreCase(behavior)) {
            this.defineFunctionProperties(new String[]{"isHomePage"}, c, 0);
            this.defineFunctionProperties(new String[]{"setHomePage"}, c, 0);
            this.defineFunctionProperties(new String[]{"navigateHomePage"}, c, 0);
            this.behaviors_.add(BEHAVIOR_CLIENT_CAPS);
            return 1;
        }
        if (BEHAVIOR_DOWNLOAD.equalsIgnoreCase(behavior)) {
            this.defineFunctionProperties(new String[]{"startDownload"}, c, 0);
            this.behaviors_.add(BEHAVIOR_DOWNLOAD);
            return 2;
        }
        LOG.warn((Object)("Unimplemented behavior: " + behavior));
        return -1;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void removeBehavior(int id) {
        switch (id) {
            case 0: {
                this.delete("availHeight");
                this.delete("availWidth");
                this.delete("bufferDepth");
                this.delete("colorDepth");
                this.delete("connectionType");
                this.delete("cookieEnabled");
                this.delete("cpuClass");
                this.delete("height");
                this.delete("javaEnabled");
                this.delete("platform");
                this.delete("systemLanguage");
                this.delete("userLanguage");
                this.delete("width");
                this.delete("addComponentRequest");
                this.delete("clearComponentRequest");
                this.delete("compareVersions");
                this.delete("doComponentRequest");
                this.delete("getComponentVersion");
                this.delete("isComponentInstalled");
                this.behaviors_.remove(BEHAVIOR_CLIENT_CAPS);
                break;
            }
            case 1: {
                this.delete("isHomePage");
                this.delete("setHomePage");
                this.delete("navigateHomePage");
                this.behaviors_.remove(BEHAVIOR_HOMEPAGE);
                break;
            }
            case 2: {
                this.delete("startDownload");
                this.behaviors_.remove(BEHAVIOR_DOWNLOAD);
                break;
            }
            default: {
                LOG.warn((Object)("Unexpected behavior id: " + id + ". Ignoring."));
            }
        }
    }

    public int getAvailHeight() {
        return this.getWindow().getScreen().getAvailHeight();
    }

    public int getAvailWidth() {
        return this.getWindow().getScreen().getAvailWidth();
    }

    public int getBufferDepth() {
        return this.getWindow().getScreen().getBufferDepth();
    }

    public BoxObject getBoxObject() {
        if (this.boxObject_ == null) {
            this.boxObject_ = new BoxObject(this);
            this.boxObject_.setParentScope(this.getWindow());
            this.boxObject_.setPrototype(this.getPrototype(this.boxObject_.getClass()));
        }
        return this.boxObject_;
    }

    public int getColorDepth() {
        return this.getWindow().getScreen().getColorDepth();
    }

    public String getConnectionType() {
        return "modem";
    }

    public boolean getCookieEnabled() {
        return this.getWindow().getNavigator().getCookieEnabled();
    }

    public String getCpuClass() {
        return this.getWindow().getNavigator().getCpuClass();
    }

    public int getHeight() {
        return this.getWindow().getScreen().getHeight();
    }

    public boolean getJavaEnabled() {
        return this.getWindow().getNavigator().javaEnabled();
    }

    public String getPlatform() {
        return this.getWindow().getNavigator().getPlatform();
    }

    public String getSystemLanguage() {
        return this.getWindow().getNavigator().getSystemLanguage();
    }

    public String getUserLanguage() {
        return this.getWindow().getNavigator().getUserLanguage();
    }

    public int getWidth() {
        return this.getWindow().getScreen().getWidth();
    }

    public void addComponentRequest(String id, String idType, String minVersion) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Call to addComponentRequest(" + id + ", " + idType + ", " + minVersion + ") ignored."));
        }
    }

    public void clearComponentRequest() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Call to clearComponentRequest() ignored.");
        }
    }

    public int compareVersions(String v1, String v2) {
        int i = v1.compareTo(v2);
        if (i == 0) {
            return 0;
        }
        if (i < 0) {
            return -1;
        }
        return 1;
    }

    public boolean doComponentRequest() {
        return false;
    }

    public String getComponentVersion(String id, String idType) {
        if ("{E5D12C4E-7B4F-11D3-B5C9-0050045C3C96}".equals(id)) {
            return "";
        }
        return "1.0";
    }

    public boolean isComponentInstalled(String id, String idType, String minVersion) {
        return false;
    }

    public void startDownload(String uri, Function callback) throws MalformedURLException {
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        URL url = page.getFullyQualifiedUrl(uri);
        if (!page.getUrl().getHost().equals(url.getHost())) {
            throw Context.reportRuntimeError((String)("Not authorized url: " + url));
        }
        JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createDownloadBehaviorJob(url, callback, this.getWindow().getWebWindow().getWebClient());
        page.getEnclosingWindow().getJobManager().addJob(job, page);
    }

    public boolean isHomePage(String url) {
        try {
            URL newUrl = new URL(url);
            URL currentUrl = this.getDomNodeOrDie().getPage().getUrl();
            String home = this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient().getOptions().getHomePage();
            boolean sameDomains = newUrl.getHost().equalsIgnoreCase(currentUrl.getHost());
            boolean isHomePage = home != null && home.equals(url);
            return sameDomains && isHomePage;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public void setHomePage(String url) {
        this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient().getOptions().setHomePage(url);
    }

    public void navigateHomePage() throws IOException {
        WebClient webClient = this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient();
        webClient.getPage(webClient.getOptions().getHomePage());
    }

    @JsxGetter
    public int getOffsetHeight() {
        if (this.isDislayNone()) {
            return 0;
        }
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return event.getClientY() - this.getPosY() + 50;
        }
        return this.getCurrentStyle().getCalculatedHeight(true, true);
    }

    private boolean isDislayNone() {
        for (HTMLElement element = this; element != null; element = element.getParentHTMLElement()) {
            ComputedCSSStyleDeclaration style = element.getCurrentStyle();
            String display = ((CSSStyleDeclaration)style).getDisplay();
            if (!"none".equals(display)) continue;
            return true;
        }
        return false;
    }

    @JsxGetter
    public int getOffsetWidth() {
        if (this.isDislayNone()) {
            return 0;
        }
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return event.getClientX() - this.getPosX() + 50;
        }
        return this.getCurrentStyle().getCalculatedWidth(true, true);
    }

    protected boolean isAncestorOfEventTarget(MouseEvent event) {
        if (event == null) {
            return false;
        }
        if (!(event.getSrcElement() instanceof HTMLElement)) {
            return false;
        }
        HTMLElement srcElement = (HTMLElement)event.getSrcElement();
        return this.getDomNodeOrDie().isAncestorOf(srcElement.getDomNodeOrDie());
    }

    public String toString() {
        return "HTMLElement for " + this.getDomNodeOrNull();
    }

    @JsxGetter
    public int getScrollTop() {
        if (this.scrollTop_ < 0) {
            this.scrollTop_ = 0;
        } else if (this.scrollTop_ > 0 && !this.getCurrentStyle().isScrollable(false)) {
            this.scrollTop_ = 0;
        }
        return this.scrollTop_;
    }

    @JsxSetter
    public void setScrollTop(int scroll) {
        this.scrollTop_ = scroll;
    }

    @JsxGetter
    public int getScrollLeft() {
        if (this.scrollLeft_ < 0) {
            this.scrollLeft_ = 0;
        } else if (this.scrollLeft_ > 0 && !this.getCurrentStyle().isScrollable(true)) {
            this.scrollLeft_ = 0;
        }
        return this.scrollLeft_;
    }

    @JsxSetter
    public void setScrollLeft(int scroll) {
        this.scrollLeft_ = scroll;
    }

    @JsxGetter
    public int getScrollHeight() {
        return 10;
    }

    @JsxGetter
    public int getScrollWidth() {
        return 10;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getScopeName() {
        String prefix = this.getDomNodeOrDie().getPrefix();
        return prefix != null ? prefix : "HTML";
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getTagUrn() {
        String urn = this.getDomNodeOrDie().getNamespaceURI();
        return urn != null ? urn : "";
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTagUrn(String tagUrn) {
        throw Context.reportRuntimeError((String)("Error trying to set tagUrn to '" + tagUrn + "'."));
    }

    public HTMLElement getParentHTMLElement() {
        Node parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof HTMLElement); parent = parent.getParent()) {
        }
        return (HTMLElement)parent;
    }

    @JsxFunction
    public void scrollIntoView() {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object getClientRects() {
        return new NativeArray(0L);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void setExpression(String propertyName, String expression, String language) {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public boolean removeExpression(String propertyName) {
        return true;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getUniqueID() {
        if (this.uniqueID_ == null) {
            this.uniqueID_ = "ms__id" + UniqueID_Counter_++;
        }
        return this.uniqueID_;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public boolean dispatchEvent(Event event) {
        event.setTarget(this);
        HtmlElement element = this.getDomNodeOrDie();
        ScriptResult result = null;
        if (event.getType().equals("click")) {
            try {
                element.click(event);
            }
            catch (IOException e) {
                throw Context.reportRuntimeError((String)("Error calling click(): " + e.getMessage()));
            }
        } else {
            result = this.fireEvent(event);
        }
        return !event.isAborted(result);
    }

    @Override
    public final HtmlElement getDomNodeOrDie() {
        return (HtmlElement)super.getDomNodeOrDie();
    }

    public HtmlElement getDomNodeOrNull() {
        return (HtmlElement)super.getDomNodeOrNull();
    }

    @JsxFunction
    public void blur() {
        this.getDomNodeOrDie().blur();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object createTextRange() {
        TextRange range = new TextRange(this);
        range.setParentScope(this.getParentScope());
        range.setPrototype(this.getPrototype(range.getClass()));
        return range;
    }

    @JsxFunction
    public void focus() {
        HtmlElement domNode = this.getDomNodeOrDie();
        if (domNode instanceof SubmittableElement || domNode instanceof HtmlAnchor || domNode instanceof HtmlArea) {
            domNode.focus();
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void setActive() {
        Window window = this.getWindow();
        HTMLDocument document = (HTMLDocument)window.getDocument();
        document.setActiveElement(this);
        if (window.getWebWindow() == window.getWebWindow().getWebClient().getCurrentWindow()) {
            HtmlElement element = this.getDomNodeOrDie();
            ((HtmlPage)element.getPage()).setFocusedElement(element);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public StaticNodeList querySelectorAll(String selectors) {
        try {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (DomNode domNode : this.getDomNodeOrDie().querySelectorAll(selectors)) {
                nodes.add((Node)domNode.getScriptObject());
            }
            return new StaticNodeList(nodes, this);
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, minVersion=8.0f), @WebBrowser(value=BrowserName.FF)})
    public Node querySelector(String selectors) {
        try {
            DomNode node = this.getDomNodeOrDie().querySelector(selectors);
            if (node != null) {
                return (Node)node.getScriptObject();
            }
            return null;
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError((String)("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ")."));
        }
    }

    @Override
    public Object get(String name, Scriptable start) {
        Document doc;
        Object response = super.get(name, start);
        if (response instanceof FunctionObject && ("querySelectorAll".equals(name) || "querySelector".equals(name)) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.QUERYSELECTORALL_NOT_IN_QUIRKS) && (doc = this.getWindow().getDocument()) instanceof HTMLDocument && ((HTMLDocument)doc).getDocumentMode() < 8) {
            return NOT_FOUND;
        }
        return response;
    }

    @Override
    public String getNodeName() {
        HtmlElement domNode = this.getDomNodeOrDie();
        String nodeName = ((DomNode)domNode).getNodeName();
        if (domNode.getPage() instanceof HtmlPage) {
            nodeName = nodeName.toUpperCase();
        }
        return nodeName;
    }

    @Override
    public String getPrefix() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_73)) {
            return "";
        }
        return null;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getFilters() {
        return this;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void click() throws IOException {
        this.getDomNodeOrDie().click();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public boolean getSpellcheck() {
        return Context.toBoolean((Object)this.getDomNodeOrDie().getAttribute("spellcheck"));
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setSpellcheck(boolean spellcheck) {
        this.getDomNodeOrDie().setAttribute("spellcheck", Boolean.toString(spellcheck));
    }

    @JsxGetter
    public String getLang() {
        return this.getDomNodeOrDie().getAttribute("lang");
    }

    @JsxSetter
    public void setLang(String lang) {
        this.getDomNodeOrDie().setAttribute("lang", lang);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getLanguage() {
        return this.getDomNodeOrDie().getAttribute("language");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setLanguage(String language) {
        this.getDomNodeOrDie().setAttribute("language", language);
    }

    @JsxGetter
    public String getDir() {
        return this.getDomNodeOrDie().getAttribute("dir");
    }

    @JsxSetter
    public void setDir(String dir) {
        this.getDomNodeOrDie().setAttribute("dir", dir);
    }

    @JsxGetter
    public int getTabIndex() {
        return (int)Context.toNumber((Object)this.getDomNodeOrDie().getAttribute("tabindex"));
    }

    @JsxSetter
    public void setTabIndex(int tabIndex) {
        this.getDomNodeOrDie().setAttribute("tabindex", Integer.toString(tabIndex));
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void doScroll(String scrollAction) {
        if (((HtmlPage)this.getDomNodeOrDie().getPage()).isBeingParsed()) {
            throw Context.reportRuntimeError((String)"The data necessary to complete this operation is not yet available.");
        }
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getAccessKey() {
        return this.getDomNodeOrDie().getAttribute("accesskey");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setAccessKey(String accessKey) {
        this.getDomNodeOrDie().setAttribute("accesskey", accessKey);
    }

    protected String getWidthOrHeight(String attributeName, Boolean returnNegativeValues) {
        String s;
        block3: {
            s = this.getDomNodeOrDie().getAttribute(attributeName);
            if (!PERCENT_VALUE.matcher(s).matches()) {
                try {
                    Float f = Float.valueOf(s);
                    int i = f.intValue();
                    s = i < 0 ? (returnNegativeValues == null ? "0" : (!returnNegativeValues.booleanValue() ? "" : Integer.toString(i))) : Integer.toString(i);
                }
                catch (NumberFormatException e) {
                    if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_74)) break block3;
                    s = "";
                }
            }
        }
        return s;
    }

    protected void setWidthOrHeight(String attributeName, String value, Boolean allowNegativeValues) {
        if (value.endsWith("px")) {
            value = value.substring(0, value.length() - 2);
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_75) && value.length() > 0) {
            boolean error = false;
            if (!PERCENT_VALUE.matcher(value).matches()) {
                try {
                    Float f = Float.valueOf(value);
                    int i = f.intValue();
                    if (i < 0) {
                        if (allowNegativeValues == null) {
                            value = "0";
                        } else if (!allowNegativeValues.booleanValue()) {
                            error = true;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    error = true;
                }
            }
            if (error) {
                Exception e = new Exception("Cannot set the width property to invalid value: " + value);
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
        this.getDomNodeOrDie().setAttribute(attributeName, value);
    }

    protected void setColorAttribute(String name, String value) {
        String s = value;
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_RESTRICT) && !s.isEmpty()) {
            s = null;
            for (String key : COLORS_MAP_IE.keySet()) {
                if (!key.equalsIgnoreCase(value)) continue;
                s = COLORS_MAP_IE.get(key).toLowerCase();
                break;
            }
            if (s == null) {
                s = value.toLowerCase();
                if (s.charAt(0) == '#') {
                    s = s.substring(1);
                }
                StringBuilder builder = new StringBuilder(7);
                for (int x = 0; x < 6 && x < s.length(); ++x) {
                    char ch = s.charAt(x);
                    if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f') {
                        builder.append(ch);
                        continue;
                    }
                    builder.append('0');
                }
                while (builder.length() < 6) {
                    builder.append('0');
                }
                builder.insert(0, '#');
                s = builder.toString();
            }
        }
        this.getDomNodeOrDie().setAttribute(name, s);
    }

    protected String getAlign(boolean returnInvalidValues) {
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_ACCEPTS_ARBITRARY_VALUES);
        String align = this.getDomNodeOrDie().getAttribute("align");
        if (returnInvalidValues || acceptArbitraryValues || "center".equals(align) || "justify".equals(align) || "left".equals(align) || "right".equals(align)) {
            return align;
        }
        return "";
    }

    protected void setAlign(String align, boolean ignoreIfNoError) {
        String alignLC = align.toLowerCase();
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_ACCEPTS_ARBITRARY_VALUES);
        if (acceptArbitraryValues || "center".equals(alignLC) || "justify".equals(alignLC) || "left".equals(alignLC) || "right".equals(alignLC)) {
            if (!ignoreIfNoError) {
                String newValue = acceptArbitraryValues ? align : alignLC;
                this.getDomNodeOrDie().setAttribute("align", newValue);
            }
            return;
        }
        throw Context.reportRuntimeError((String)("Cannot set the align property to invalid value: '" + align + "'"));
    }

    protected String getVAlign(String[] valid, String defaultValue) {
        String valign = this.getDomNodeOrDie().getAttribute("valign");
        if (valid == null || ArrayUtils.contains((Object[])valid, (Object)valign)) {
            return valign;
        }
        return defaultValue;
    }

    protected void setVAlign(Object vAlign, String[] valid) {
        String s = Context.toString((Object)vAlign).toLowerCase();
        if (valid != null && !ArrayUtils.contains((Object[])valid, (Object)s)) {
            throw Context.reportRuntimeError((String)("Cannot set the vAlign property to invalid value: " + vAlign));
        }
        this.getDomNodeOrDie().setAttribute("valign", s);
    }

    protected String getCh() {
        boolean emulated = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CHAR_EMULATED);
        if (emulated) {
            return this.ch_;
        }
        String ch = this.getDomNodeOrDie().getAttribute("char");
        if (ch == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CHAR_UNDEFINED_DOT)) {
            return ".";
        }
        return ch;
    }

    protected void setCh(String ch) {
        boolean emulated = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CHAR_EMULATED);
        if (emulated) {
            this.ch_ = ch;
        } else {
            this.getDomNodeOrDie().setAttribute("char", ch);
        }
    }

    protected String getChOff() {
        boolean emulated = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CHAR_OFF_EMULATED);
        if (emulated) {
            return this.chOff_;
        }
        return this.getDomNodeOrDie().getAttribute("charOff");
    }

    protected void setChOff(String chOff) {
        boolean emulated = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CHAR_OFF_EMULATED);
        if (emulated) {
            this.chOff_ = chOff;
            return;
        }
        try {
            int i;
            float f = Float.parseFloat(chOff);
            chOff = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CHAR_OFF_INTEGER) ? (f < 0.0f ? "0" : Integer.toString((int)f)) : ((float)(i = (int)f) == f ? Integer.toString(i) : Float.toString(f));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.getDomNodeOrDie().setAttribute("charOff", chOff);
    }

    @JsxGetter
    public int getOffsetLeft() {
        if (this instanceof HTMLBodyElement) {
            return 0;
        }
        int left = 0;
        HTMLElement offsetParent = this.getOffsetParent();
        DomNode node = this.getDomNodeOrDie();
        HTMLElement element = (HTMLElement)node.getScriptObject();
        left += element.getCurrentStyle().getLeft(true, false, false);
        String position = element.getCurrentStyle().getPositionWithInheritance();
        if ("absolute".equals(position)) {
            return left;
        }
        for (node = node.getParentNode(); node != null && node.getScriptObject() != offsetParent; node = node.getParentNode()) {
            if (!(node.getScriptObject() instanceof HTMLElement)) continue;
            element = (HTMLElement)node.getScriptObject();
            left += element.getCurrentStyle().getLeft(true, true, true);
        }
        if (offsetParent != null) {
            left += offsetParent.getCurrentStyle().getMarginLeftValue();
            left += offsetParent.getCurrentStyle().getPaddingLeftValue();
        }
        return left;
    }

    public int getPosX() {
        int cumulativeOffset = 0;
        for (HTMLElement element = this; element != null; element = element.getOffsetParent()) {
            cumulativeOffset += element.getOffsetLeft();
            if (element == this) continue;
            cumulativeOffset += element.getCurrentStyle().getBorderLeftValue();
        }
        return cumulativeOffset;
    }

    public int getPosY() {
        int cumulativeOffset = 0;
        for (HTMLElement element = this; element != null; element = element.getOffsetParent()) {
            cumulativeOffset += element.getOffsetTop();
            if (element == this) continue;
            cumulativeOffset += element.getCurrentStyle().getBorderTopValue();
        }
        return cumulativeOffset;
    }

    private HTMLElement getOffsetParent() {
        Object offsetParent = this.getOffsetParent_js();
        if (offsetParent instanceof HTMLElement) {
            return (HTMLElement)offsetParent;
        }
        return null;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF)})
    public int getClientLeft() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLIENT_LEFT_TOP_ZERO)) {
            return 0;
        }
        return this.getCurrentStyle().getBorderLeftValue();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF)})
    public int getClientTop() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CLIENT_LEFT_TOP_ZERO)) {
            return 0;
        }
        return this.getCurrentStyle().getBorderTopValue();
    }

    @JsxGetter
    public int getOffsetTop() {
        if (this instanceof HTMLBodyElement) {
            return 0;
        }
        int top = 0;
        HTMLElement offsetParent = this.getOffsetParent();
        DomNode node = this.getDomNodeOrDie();
        HTMLElement element = (HTMLElement)node.getScriptObject();
        top += element.getCurrentStyle().getTop(true, false, false);
        String position = element.getCurrentStyle().getPositionWithInheritance();
        if ("absolute".equals(position)) {
            return top;
        }
        for (node = node.getParentNode(); node != null && node.getScriptObject() != offsetParent; node = node.getParentNode()) {
            if (!(node.getScriptObject() instanceof HTMLElement)) continue;
            element = (HTMLElement)node.getScriptObject();
            top += element.getCurrentStyle().getTop(false, true, true);
        }
        if (offsetParent != null) {
            boolean thisElementHasTopMargin;
            HTMLElement thiz = (HTMLElement)this.getDomNodeOrDie().getScriptObject();
            boolean bl = thisElementHasTopMargin = thiz.getCurrentStyle().getMarginTopValue() != 0;
            if (!thisElementHasTopMargin) {
                top += offsetParent.getCurrentStyle().getMarginTopValue();
            }
            top += offsetParent.getCurrentStyle().getPaddingTopValue();
        }
        return top;
    }

    @JsxGetter(propertyName="offsetParent")
    public Object getOffsetParent_js() {
        boolean useTables;
        DomNode currentElement = this.getDomNodeOrDie();
        if (currentElement.getParentNode() == null) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OFFSET_PARENT_THROWS_NOT_ATTACHED)) {
                throw Context.reportRuntimeError((String)"Unspecified error");
            }
            return null;
        }
        ScriptableObject offsetParent = null;
        HTMLElement htmlElement = (HTMLElement)currentElement.getScriptObject();
        ComputedCSSStyleDeclaration style = htmlElement.getCurrentStyle();
        String position = style.getPositionWithInheritance();
        boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_72);
        boolean staticPos = "static".equals(position);
        boolean fixedPos = "fixed".equals(position);
        boolean bl = useTables = ie && (staticPos || fixedPos) || !ie && staticPos;
        while (currentElement != null) {
            DomNode parentNode = currentElement.getParentNode();
            if (parentNode instanceof HtmlBody || useTables && parentNode instanceof HtmlTableDataCell || useTables && parentNode instanceof HtmlTable) {
                offsetParent = parentNode.getScriptObject();
                break;
            }
            if (parentNode != null && parentNode.getScriptObject() instanceof HTMLElement) {
                HTMLElement parentElement = (HTMLElement)parentNode.getScriptObject();
                ComputedCSSStyleDeclaration parentStyle = parentElement.getCurrentStyle();
                String parentPosition = parentStyle.getPositionWithInheritance();
                boolean parentIsStatic = "static".equals(parentPosition);
                boolean parentIsFixed = "fixed".equals(parentPosition);
                if (ie && !parentIsStatic && !parentIsFixed || !ie && !parentIsStatic) {
                    offsetParent = parentNode.getScriptObject();
                    break;
                }
            }
            currentElement = currentElement.getParentNode();
        }
        return offsetParent;
    }

    @Override
    public ClientRect getBoundingClientRect() {
        int left = this.getPosX();
        int top = this.getPosY();
        Object parentNode = this.getOffsetParent_js();
        while (parentNode != null && parentNode instanceof HTMLElement && !(parentNode instanceof HTMLBodyElement)) {
            HTMLElement elem = (HTMLElement)parentNode;
            left -= elem.getScrollLeft();
            top -= elem.getScrollTop();
            parentNode = elem.getParentNode();
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_BOUNDING_CLIENT_RECT_OFFSET_TWO)) {
            left += 2;
            top += 2;
        }
        ClientRect textRectangle = new ClientRect(0, left, 0, top);
        textRectangle.setParentScope(this.getWindow());
        textRectangle.setPrototype(this.getPrototype(textRectangle.getClass()));
        return textRectangle;
    }

    @Override
    public DOMTokenList getClassList() {
        return new DOMTokenList(this, "class");
    }

    @Override
    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})
    public boolean hasAttribute(String name) {
        return super.hasAttribute(name);
    }

    @Override
    @JsxFunction
    public Object getAttribute(String attributeName, Integer flags) {
        return super.getAttribute(attributeName, flags);
    }

    @Override
    @JsxGetter
    public final String getTagName() {
        return super.getTagName();
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public HTMLCollection getChildren() {
        return super.getChildren();
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF, minVersion=10.0f), @WebBrowser(value=BrowserName.CHROME)})
    public Element getParentElement() {
        return super.getParentElement();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF, minVersion=10.0f), @WebBrowser(value=BrowserName.CHROME)})
    public DOMStringMap getDataset() {
        return new DOMStringMap(this);
    }

    protected boolean isEndTagForbidden() {
        return false;
    }

    protected boolean isLowerCaseInOuterHtml() {
        return false;
    }

    static {
        COLORS_MAP_IE.put("AliceBlue", "#F0F8FF");
        COLORS_MAP_IE.put("AntiqueWhite", "#FAEBD7");
        COLORS_MAP_IE.put("Aqua", "#00FFFF");
        COLORS_MAP_IE.put("Aquamarine", "#7FFFD4");
        COLORS_MAP_IE.put("Azure", "#F0FFFF");
        COLORS_MAP_IE.put("Beige", "#F5F5DC");
        COLORS_MAP_IE.put("Bisque", "#FFE4C4");
        COLORS_MAP_IE.put("Black", "#000000");
        COLORS_MAP_IE.put("BlanchedAlmond", "#FFEBCD");
        COLORS_MAP_IE.put("Blue", "#0000FF");
        COLORS_MAP_IE.put("BlueViolet", "#8A2BE2");
        COLORS_MAP_IE.put("Brown", "#A52A2A");
        COLORS_MAP_IE.put("BurlyWood", "#DEB887");
        COLORS_MAP_IE.put("CadetBlue", "#5F9EA0");
        COLORS_MAP_IE.put("Chartreuse", "#7FFF00");
        COLORS_MAP_IE.put("Chocolate", "#D2691E");
        COLORS_MAP_IE.put("Coral", "#FF7F50");
        COLORS_MAP_IE.put("CornflowerBlue", "#6495ED");
        COLORS_MAP_IE.put("Cornsilk", "#FFF8DC");
        COLORS_MAP_IE.put("Crimson", "#DC143C");
        COLORS_MAP_IE.put("Cyan", "#00FFFF");
        COLORS_MAP_IE.put("DarkBlue", "#00008B");
        COLORS_MAP_IE.put("DarkCyan", "#008B8B");
        COLORS_MAP_IE.put("DarkGoldenrod", "#B8860B");
        COLORS_MAP_IE.put("DarkGray", "#A9A9A9");
        COLORS_MAP_IE.put("DarkGrey", "#A9A9A9");
        COLORS_MAP_IE.put("DarkGreen", "#006400");
        COLORS_MAP_IE.put("DarkKhaki", "#BDB76B");
        COLORS_MAP_IE.put("DarkMagenta", "#8B008B");
        COLORS_MAP_IE.put("DarkOliveGreen", "#556B2F");
        COLORS_MAP_IE.put("DarkOrange", "#FF8C00");
        COLORS_MAP_IE.put("DarkOrchid", "#9932CC");
        COLORS_MAP_IE.put("DarkRed", "#8B0000");
        COLORS_MAP_IE.put("DarkSalmon", "#E9967A");
        COLORS_MAP_IE.put("DarkSeaGreen", "#8FBC8F");
        COLORS_MAP_IE.put("DarkSlateBlue", "#483D8B");
        COLORS_MAP_IE.put("DarkSlateGray", "#2F4F4F");
        COLORS_MAP_IE.put("DarkSlateGrey", "#2F4F4F");
        COLORS_MAP_IE.put("DarkTurquoise", "#00CED1");
        COLORS_MAP_IE.put("DarkViolet", "#9400D3");
        COLORS_MAP_IE.put("DeepPink", "#FF1493");
        COLORS_MAP_IE.put("DeepSkyBlue", "#00BFFF");
        COLORS_MAP_IE.put("DimGray", "#696969");
        COLORS_MAP_IE.put("DimGrey", "#696969");
        COLORS_MAP_IE.put("DodgerBlue", "#1E90FF");
        COLORS_MAP_IE.put("FireBrick", "#B22222");
        COLORS_MAP_IE.put("FloralWhite", "#FFFAF0");
        COLORS_MAP_IE.put("ForestGreen", "#228B22");
        COLORS_MAP_IE.put("Fuchsia", "#FF00FF");
        COLORS_MAP_IE.put("Gainsboro", "#DCDCDC");
        COLORS_MAP_IE.put("GhostWhite", "#F8F8FF");
        COLORS_MAP_IE.put("Gold", "#FFD700");
        COLORS_MAP_IE.put("Goldenrod", "#DAA520");
        COLORS_MAP_IE.put("Gray", "#808080");
        COLORS_MAP_IE.put("Grey", "#808080");
        COLORS_MAP_IE.put("Green", "#008000");
        COLORS_MAP_IE.put("GreenYellow", "#ADFF2F");
        COLORS_MAP_IE.put("Honeydew", "#F0FFF0");
        COLORS_MAP_IE.put("HotPink", "#FF69B4");
        COLORS_MAP_IE.put("IndianRed", "#CD5C5C");
        COLORS_MAP_IE.put("Indigo", "#4B0082");
        COLORS_MAP_IE.put("Ivory", "#FFFFF0");
        COLORS_MAP_IE.put("Khaki", "#F0E68C");
        COLORS_MAP_IE.put("Lavender", "#E6E6FA");
        COLORS_MAP_IE.put("LavenderBlush", "#FFF0F5");
        COLORS_MAP_IE.put("LawnGreen", "#7CFC00");
        COLORS_MAP_IE.put("LemonChiffon", "#FFFACD");
        COLORS_MAP_IE.put("LightBlue", "#ADD8E6");
        COLORS_MAP_IE.put("LightCoral", "#F08080");
        COLORS_MAP_IE.put("LightCyan", "#E0FFFF");
        COLORS_MAP_IE.put("LightGoldenrodYellow", "#FAFAD2");
        COLORS_MAP_IE.put("LightGreen", "#90EE90");
        COLORS_MAP_IE.put("LightGray", "#D3D3D3");
        COLORS_MAP_IE.put("LightGrey", "#D3D3D3");
        COLORS_MAP_IE.put("LightPink", "#FFB6C1");
        COLORS_MAP_IE.put("LightSalmon", "#FFA07A");
        COLORS_MAP_IE.put("LightSeaGreen", "#20B2AA");
        COLORS_MAP_IE.put("LightSkyBlue", "#87CEFA");
        COLORS_MAP_IE.put("LightSlateGray", "#778899");
        COLORS_MAP_IE.put("LightSlateGrey", "#778899");
        COLORS_MAP_IE.put("LightSteelBlue", "#B0C4DE");
        COLORS_MAP_IE.put("LightYellow", "#FFFFE0");
        COLORS_MAP_IE.put("Lime", "#00FF00");
        COLORS_MAP_IE.put("LimeGreen", "#32CD32");
        COLORS_MAP_IE.put("Linen", "#FAF0E6");
        COLORS_MAP_IE.put("Magenta", "#FF00FF");
        COLORS_MAP_IE.put("Maroon", "#800000");
        COLORS_MAP_IE.put("MediumAquamarine", "#66CDAA");
        COLORS_MAP_IE.put("MediumBlue", "#0000CD");
        COLORS_MAP_IE.put("MediumOrchid", "#BA55D3");
        COLORS_MAP_IE.put("MediumPurple", "#9370DB");
        COLORS_MAP_IE.put("MediumSeaGreen", "#3CB371");
        COLORS_MAP_IE.put("MediumSlateBlue", "#7B68EE");
        COLORS_MAP_IE.put("MediumSpringGreen", "#00FA9A");
        COLORS_MAP_IE.put("MediumTurquoise", "#48D1CC");
        COLORS_MAP_IE.put("MediumVioletRed", "#C71585");
        COLORS_MAP_IE.put("MidnightBlue", "#191970");
        COLORS_MAP_IE.put("MintCream", "#F5FFFA");
        COLORS_MAP_IE.put("MistyRose", "#FFE4E1");
        COLORS_MAP_IE.put("Moccasin", "#FFE4B5");
        COLORS_MAP_IE.put("NavajoWhite", "#FFDEAD");
        COLORS_MAP_IE.put("Navy", "#000080");
        COLORS_MAP_IE.put("OldLace", "#FDF5E6");
        COLORS_MAP_IE.put("Olive", "#808000");
        COLORS_MAP_IE.put("OliveDrab", "#6B8E23");
        COLORS_MAP_IE.put("Orange", "#FFA500");
        COLORS_MAP_IE.put("OrangeRed", "#FF4500");
        COLORS_MAP_IE.put("Orchid", "#DA70D6");
        COLORS_MAP_IE.put("PaleGoldenrod", "#EEE8AA");
        COLORS_MAP_IE.put("PaleGreen", "#98FB98");
        COLORS_MAP_IE.put("PaleTurquoise", "#AFEEEE");
        COLORS_MAP_IE.put("PaleVioletRed", "#DB7093");
        COLORS_MAP_IE.put("PapayaWhip", "#FFEFD5");
        COLORS_MAP_IE.put("PeachPuff", "#FFDAB9");
        COLORS_MAP_IE.put("Peru", "#CD853F");
        COLORS_MAP_IE.put("Pink", "#FFC0CB");
        COLORS_MAP_IE.put("Plum", "#DDA0DD");
        COLORS_MAP_IE.put("PowderBlue", "#B0E0E6");
        COLORS_MAP_IE.put("Purple", "#800080");
        COLORS_MAP_IE.put("Red", "#FF0000");
        COLORS_MAP_IE.put("RosyBrown", "#BC8F8F");
        COLORS_MAP_IE.put("RoyalBlue", "#4169E1");
        COLORS_MAP_IE.put("SaddleBrown", "#8B4513");
        COLORS_MAP_IE.put("Salmon", "#FA8072");
        COLORS_MAP_IE.put("SandyBrown", "#F4A460");
        COLORS_MAP_IE.put("SeaGreen", "#2E8B57");
        COLORS_MAP_IE.put("Seashell", "#FFF5EE");
        COLORS_MAP_IE.put("Sienna", "#A0522D");
        COLORS_MAP_IE.put("Silver", "#C0C0C0");
        COLORS_MAP_IE.put("SkyBlue", "#87CEEB");
        COLORS_MAP_IE.put("SlateBlue", "#6A5ACD");
        COLORS_MAP_IE.put("SlateGray", "#708090");
        COLORS_MAP_IE.put("SlateGrey", "#708090");
        COLORS_MAP_IE.put("Snow", "#FFFAFA");
        COLORS_MAP_IE.put("SpringGreen", "#00FF7F");
        COLORS_MAP_IE.put("SteelBlue", "#4682B4");
        COLORS_MAP_IE.put("Tan", "#D2B48C");
        COLORS_MAP_IE.put("Teal", "#008080");
        COLORS_MAP_IE.put("Thistle", "#D8BFD8");
        COLORS_MAP_IE.put("Tomato", "#FF6347");
        COLORS_MAP_IE.put("Turquoise", "#40E0D0");
        COLORS_MAP_IE.put("Violet", "#EE82EE");
        COLORS_MAP_IE.put("Wheat", "#F5DEB3");
        COLORS_MAP_IE.put("White", "#FFFFFF");
        COLORS_MAP_IE.put("WhiteSmoke", "#F5F5F5");
        COLORS_MAP_IE.put("Yellow", "#FFFF00");
        COLORS_MAP_IE.put("YellowGreen", "#9ACD32");
        INNER_HTML_READONLY_IN_IE = Arrays.asList("col", "colgroup", "frameset", "head", "html", "style", "table", "tbody", "tfoot", "thead", "title", "tr");
        INNER_TEXT_READONLY = Arrays.asList("html", "table", "tbody", "tfoot", "thead", "tr");
        OUTER_HTML_READONLY = Arrays.asList("body", "caption", "col", "colgroup", "frameset", "head", "html", "tbody", "td", "tfoot", "th", "thead", "tr");
    }

    public static class ProxyDomNode
    extends HtmlDivision {
        private final DomNode target_;
        private final boolean append_;

        public ProxyDomNode(SgmlPage page, DomNode target, boolean append) {
            super(null, "div", page, null);
            this.target_ = target;
            this.append_ = append;
        }

        @Override
        public DomNode appendChild(org.w3c.dom.Node node) {
            DomNode domNode = (DomNode)node;
            if (this.append_) {
                return this.target_.appendChild(domNode);
            }
            this.target_.insertBefore(domNode);
            return domNode;
        }

        public DomNode getDomNode() {
            return this.target_;
        }

        public boolean isAppend() {
            return this.append_;
        }
    }
}

