/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlRadioButtonInput
extends HtmlInput {
    private boolean defaultCheckedState_;
    private boolean valueAtFocus_;

    HtmlRadioButtonInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
        if (this.getAttribute("value") == ATTRIBUTE_NOT_DEFINED) {
            this.setAttribute("value", "on");
        }
        this.defaultCheckedState_ = this.hasAttribute("checked");
    }

    @Override
    public void reset() {
        if (this.defaultCheckedState_) {
            this.setAttribute("checked", "checked");
        } else {
            this.removeAttribute("checked");
        }
    }

    @Override
    public Page setChecked(boolean isChecked) {
        ScriptResult scriptResult;
        HtmlForm form = this.getEnclosingForm();
        boolean changed = this.isChecked() != isChecked;
        Page page = this.getPage();
        if (isChecked) {
            if (form != null) {
                form.setCheckedRadioButton(this);
            } else if (page instanceof HtmlPage) {
                ((HtmlPage)page).setCheckedRadioButton(this);
            }
        } else {
            this.removeAttribute("checked");
        }
        if (changed && !this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_LOSING_FOCUS) && (scriptResult = this.fireEvent("change")) != null) {
            page = scriptResult.getNewPage();
        }
        return page;
    }

    @Override
    protected boolean doClickStateUpdate() throws IOException {
        HtmlForm form = this.getEnclosingForm();
        boolean changed = !this.isChecked();
        SgmlPage page = this.getPage();
        if (form != null) {
            form.setCheckedRadioButton(this);
        } else if (page instanceof HtmlPage) {
            ((HtmlPage)page).setCheckedRadioButton(this);
        }
        super.doClickStateUpdate();
        return changed;
    }

    @Override
    protected void doClickFireChangeEvent() throws IOException {
        if (!this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_LOSING_FOCUS)) {
            HtmlRadioButtonInput.executeOnChangeHandlerIfAppropriate(this);
        }
    }

    @Override
    public String asText() {
        return super.asText();
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultCheckedState_ = defaultChecked;
        if (this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLINPUT_DEFAULT_IS_CHECKED)) {
            this.setChecked(defaultChecked);
        }
    }

    @Override
    public boolean isDefaultChecked() {
        return this.defaultCheckedState_;
    }

    @Override
    protected boolean isStateUpdateFirst() {
        return true;
    }

    @Override
    protected void onAddedToPage() {
        if (this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLRADIOINPUT_SET_CHECKED_TO_DEFAULT_WHEN_ADDED_TO_PAGE)) {
            this.setChecked(this.isDefaultChecked());
        }
    }

    @Override
    public void focus() {
        super.focus();
        this.valueAtFocus_ = this.isChecked();
    }

    @Override
    void removeFocus() {
        super.removeFocus();
        boolean fireOnChange = this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_LOSING_FOCUS);
        if (fireOnChange && this.valueAtFocus_ != this.isChecked()) {
            HtmlRadioButtonInput.executeOnChangeHandlerIfAppropriate(this);
        }
        this.valueAtFocus_ = this.isChecked();
    }
}

