/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSOMObjectImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.SACParserCSS2;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaListImpl
extends CSSOMObjectImpl
implements MediaList,
Serializable {
    private static final long serialVersionUID = 6662784733573034870L;
    private List<String> media = new ArrayList<String>();

    public void setMedia(List<String> media) {
        this.media = media;
    }

    private void setMediaList(SACMediaList mediaList) {
        for (int i = 0; i < mediaList.getLength(); ++i) {
            this.media.add(mediaList.item(i));
        }
    }

    public MediaListImpl(SACMediaList mediaList) {
        this.setMediaList(mediaList);
    }

    public MediaListImpl() {
    }

    @Override
    public String getMediaText() {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < this.media.size(); ++i) {
            sb.append(this.media.get(i));
            if (i >= this.media.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public void setMediaText(String mediaText) throws DOMException {
        InputSource source = new InputSource((Reader)new StringReader(mediaText));
        try {
            SACMediaList sml = new SACParserCSS2().parseMedia(source);
            this.setMediaList(sml);
        }
        catch (CSSParseException e) {
            throw new DOMException(12, e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new DOMException(8, e.getLocalizedMessage());
        }
    }

    @Override
    public int getLength() {
        return this.media.size();
    }

    @Override
    public String item(int index) {
        return index < this.media.size() ? this.media.get(index) : null;
    }

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        for (int i = 0; i < this.media.size(); ++i) {
            String str = this.media.get(i);
            if (!str.equalsIgnoreCase(oldMedium)) continue;
            this.media.remove(i);
            return;
        }
        throw new DOMExceptionImpl(8, 18);
    }

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        this.media.add(newMedium);
    }

    public String toString() {
        return this.getMediaText();
    }
}

