/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import java.util.AbstractSequentialList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SiblingDomNodeList
extends AbstractSequentialList<DomNode>
implements DomNodeList<DomNode> {
    private DomNode root_;

    public SiblingDomNodeList(DomNode root) {
        this.root_ = root;
    }

    @Override
    public int getLength() {
        int length = 0;
        for (DomNode node = this.root_; node != null; node = node.getNextSibling()) {
            ++length;
        }
        return length;
    }

    @Override
    public int size() {
        return this.getLength();
    }

    @Override
    public Node item(int index) {
        return this.get(index);
    }

    @Override
    public DomNode get(int index) {
        int i = 0;
        for (DomNode node = this.root_; node != null; node = node.getNextSibling()) {
            if (i == index) {
                return node;
            }
            ++i;
        }
        return null;
    }

    @Override
    public ListIterator<DomNode> listIterator(int index) {
        return new SiblingListIterator(index);
    }

    @Override
    public String toString() {
        return "SiblingDomNodeList[" + this.root_ + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SiblingListIterator
    implements ListIterator<DomNode> {
        private DomNode prev_;
        private DomNode next_;
        private int nextIndex_;

        public SiblingListIterator(int index) {
            this.next_ = SiblingDomNodeList.this.root_;
            this.nextIndex_ = 0;
            for (int i = 0; i < index; ++i) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next_ != null;
        }

        @Override
        public DomNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prev_ = this.next_;
            this.next_ = this.next_.getNextSibling();
            ++this.nextIndex_;
            return this.prev_;
        }

        @Override
        public boolean hasPrevious() {
            return this.prev_ != null;
        }

        @Override
        public DomNode previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next_ = this.prev_;
            this.prev_ = this.prev_.getPreviousSibling();
            --this.nextIndex_;
            return this.next_;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex_;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex_ - 1;
        }

        @Override
        public void add(DomNode e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(DomNode e) {
            throw new UnsupportedOperationException();
        }
    }
}

