![](https://img.shields.io/badge/REST%20API-v3.0-lightgrey) [![GitHub license](https://img.shields.io/github/license/aspose-cells-cloud/aspose-cells-cloud-perl)](https://github.com/aspose-cells-cloud/aspose-cells-cloud-perl/blob/master/LICENSE) ![CPAN](https://img.shields.io/cpan/v/AsposeCellsCloud-CellsApi)

Aspose.Cells Cloud for Perl enables you to handle various aspects of Excel files, including cell data, styles, formulas, charts, pivot tables, data validation, comments, drawing objects, images, hyperlinks, and so on. Additionally, it supports operations such as splitting, merging, repairing, and converting to other compatible file formats.


# Perl module for Aspose.Cells Cloud

Enhance your Perl applications with the [Aspose.Cells Cloud](https://products.aspose.cloud/cells/perl) , enabling seamless integration with [Excel, ODS, CSV, Json and other spreadsheet document formats](https://docs.aspose.cloud/cells/supported-file-formats/). With its powerful APIs, developers can effortlessly read, convert, create, edit, and manipulate the contents of Excel documents without the need for any office software installed on the machine

## Manipulate Excel and other spreadsheet files in the Cloud

- File Manipulation: Users can upload, download, delete, and manage Excel files stored in the cloud.
- Formatting: Supports formatting of cells, fonts, colors, and alignment modes in Excel files to cater to users' specific requirements.
- Data Processing: Powerful functions for data processing including reading, writing, modifying cell data, performing formula calculations, and formatting data.
- Formula Calculation: Built-in formula engine handles complex formula calculations in Excel and returns accurate results.
- Chart Manipulation: Users can create, edit, and delete charts from Excel files for data analysis and visualization needs.
- Table Processing: Offers robust processing capabilities for various form operations such as creation, editing, formatting, and conversion, meeting diverse form processing needs.
- Data Verification: Includes data verification function to set cell data type, range, uniqueness, ensuring data accuracy and integrity.
- Batch Processing: Supports batch processing of multiple Excel documents, such as batch format conversion, data extraction, and style application..
- Import/Export: Facilitates importing data from various sources into spreadsheets and exporting spreadsheet data to other formats.
- Security Management: Offers a range of security features like data encryption, access control, and permission management to safeguard the security and integrity of spreadsheet data.

## Feature & Enhancements in Version 24.7

Full list of issues covering all changes in this release:

- Add a new feature about adding text content. 
- Add get access token by client id and client secret.

## Support file format

|**Format**|**Description**|**Load**|**Save**|
| :- | :- | :- | :- |
|[XLS](https://docs.fileformat.com/spreadsheet/xls/)|Excel 95/5.0 - 2003 Workbook.|&radic;|&radic;|
|[XLSX](https://docs.fileformat.com/spreadsheet/xlsx/)|Office Open XML SpreadsheetML Workbook or template file, with or without macros.|&radic;|&radic;|
|[XLSB](https://docs.fileformat.com/spreadsheet/xlsb/)|Excel Binary Workbook.|&radic;|&radic;|
|[XLSM](https://docs.fileformat.com/spreadsheet/xlsm/)|Excel Macro-Enabled Workbook.|&radic;|&radic;|
|[XLT](https://docs.fileformat.com/spreadsheet/xlt/)|Excel 97 - Excel 2003 Template.|&radic;|&radic;|
|[XLTX](https://docs.fileformat.com/spreadsheet/xltx/)|Excel Template.|&radic;|&radic;|
|[XLTM](https://docs.fileformat.com/spreadsheet/xltm/)|Excel Macro-Enabled Template.|&radic;|&radic;|
|[XLAM](https://docs.fileformat.com/spreadsheet/xlam/)|An Excel Macro-Enabled Add-In file that's used to add new functions to Excel.| |&radic;|
|[CSV](https://docs.fileformat.com/spreadsheet/csv/)|CSV (Comma Separated Value) file.|&radic;|&radic;|
|[TSV](https://docs.fileformat.com/spreadsheet/tsv/)|TSV (Tab-separated values) file.|&radic;|&radic;|
|TabDelimited|Tab-delimited text file, same with TSV file.|&radic;|&radic;|
|[TXT](https://docs.fileformat.com/word-processing/txt/)|Delimited plain text file.|&radic;|&radic;|
|[HTML](https://docs.fileformat.com/web/html/)|HTML format.|&radic;|&radic;|
|[MHTML](https://docs.fileformat.com/web/mhtml/)|MHTML file.|&radic;|&radic;|
|[ODS](https://docs.fileformat.com/spreadsheet/ods/)|ODS (OpenDocument Spreadsheet).|&radic;|&radic;|
|SpreadsheetML|Excel 2003 XML file.|&radic;|&radic;|
|[Numbers](https://docs.fileformat.com/spreadsheet/numbers/)|The document is created by Apple's "Numbers" application which forms part of Apple's iWork office suite, a set of applications which run on the Mac OS X and iOS operating systems.|&radic;||
|[JSON](https://docs.fileformat.com/web/json/)|JavaScript Object Notation|&radic;|&radic;|
|[DIF](https://docs.fileformat.com/spreadsheet/dif/)|Data Interchange Format.| |&radic;|
|[PDF](https://docs.fileformat.com/pdf/)|Adobe Portable Document Format.| |&radic;|
|[XPS](https://docs.fileformat.com/page-description-language/xps/)|XML Paper Specification Format.| |&radic;|
|[SVG](https://docs.fileformat.com/page-description-language/svg/)|Scalable Vector Graphics Format.| |&radic;|
|[TIFF](https://docs.fileformat.com/image/tiff/)|Tagged Image File Format| |&radic;|
|[PNG](https://docs.fileformat.com/image/png/)|Portable Network Graphics Format| |&radic;|
|[BMP](https://docs.fileformat.com/image/bmp/)|Bitmap Image Format| |&radic;|
|[EMF](https://docs.fileformat.com/image/emf/)|Enhanced metafile Format| |&radic;|
|[JPEG](https://docs.fileformat.com/image/jpeg/)|JPEG is a type of image format that is saved using the method of lossy compression.| |&radic;|
|[GIF](https://docs.fileformat.com/image/gif/)|Graphical Interchange Format| |&radic;|
|[MARKDOWN](https://docs.fileformat.com/word-processing/md/)|Represents a markdown document.| |&radic;|
|[SXC](https://docs.fileformat.com/spreadsheet/sxc/)|An XML based format used by OpenOffice and StarOffice|&radic;|&radic;|
|[FODS](https://docs.fileformat.com/spreadsheet/fods/)|This is an Open Document format stored as flat XML.|&radic;|&radic;|
|[DOCX](https://docs.fileformat.com/word-processing/docx/)|A well-known format for Microsoft Word documents that is a combination of XML and binary files.||&radic;|
|[PPTX](https://docs.fileformat.com/presentation/pptx/)|The PPTX format is based on the Microsoft PowerPoint open XML presentation file format.||&radic;|

## Quick Start Guide

To begin with Aspose.Cells Cloud, here's what you need to do:

1. Sign up for an account at [Aspose for Cloud](https://dashboard.aspose.cloud/#/apps) to obtain your application details.
2. Install the Aspose.Cells Cloud Perl module from the [CPAN distribution](https://www.cpan.org/).
3. Use the conversion code provided below as a reference to add or modify your application.

## Convert an Excel File Using Perl

```perl
use lib 'lib';
use strict;
use warnings;
use File::Slurp;
use MIME::Base64;
use AsposeCellsCloud::CellsApi;

my $config = AsposeCellsCloud::Configuration->new( client_id => $ENV{'CellsCloudClientId'}, client_secret => $ENV{'CellsCloudClientSecret'});
my $instance = AsposeCellsCloud::CellsApi->new(AsposeCellsCloud::ApiClient->new( $config));

my $remoteFolder = 'TestData/In';
  
my $localName = 'Book1.xlsx';
my $remoteName = 'Book1.xlsx';

my $upload_file_request = AsposeCellsCloud::Request::UploadFileRequest->new( 'UploadFiles'=>{ $localName => $localName  }  ,'path'=>$remoteFolder . '/' . $remoteName );
 
my $format = 'csv';

my $mapFiles = {};           

 $mapFiles->{$localName}= "TestData/".$localName ;

my $request = AsposeCellsCloud::Request::PutConvertWorkbookRequest->new();
$request->{file} =  $mapFiles;
$request->{format} =  $format;
$instance->put_convert_workbook(request=> $request);
```

## Aspose.Cells Cloud in Popular Languages

| .NET | Java | PHP | Python | Ruby | Node.js | Android | Swift | GO |
|---|---|---|---|---|---|---|---|---|
| [GitHub](https://github.com/aspose-cells-cloud/aspose-cells-cloud-dotnet) | [GitHub](https://github.com/aspose-cells-cloud/aspose-cells-cloud-java) | [GitHub](https://github.com/aspose-cells-cloud/aspose-cells-cloud-php) | [GitHub](https://github.com/aspose-cells-cloud/aspose-cells-cloud-python)  | [GitHub](https://github.com/aspose-cells-cloud/aspose-cells-cloud-ruby) | [GitHub](https://github.com/aspose-cells-cloud/aspose-cells-cloud-node)  | [GitHub](https://github.com/aspose-cells-cloud/aspose-cells-cloud-android) | [GitHub](https://github.com/aspose-cells-cloud/aspose-cells-cloud-swift) | [GitHub](https://github.com/aspose-cells-cloud/aspose-cells-cloud-go) |
| [NuGet](https://www.nuget.org/packages/Aspose.Cells-Cloud/) | [Maven](https://repository.aspose.cloud/webapp/#/artifacts/browse/tree/General/repo/com/aspose/aspose-cells-cloud) | [Composer](https://packagist.org/packages/aspose/cells-sdk-php) | [PIP](https://pypi.org/project/asposecellscloud/)  | [GEM](https://rubygems.org/gems/aspose_cells_cloud) | [NPM](https://www.npmjs.com/package/asposecellscloud) | [Maven](https://repository.aspose.cloud/webapp/#/artifacts/browse/tree/General/repo/com/aspose/aspose-cells-cloud-android) |  [POD](https://cocoapods.org/pods/AsposeCellsCloud) | [GO](https://pkg.go.dev/github.com/aspose-cells-cloud/aspose-cells-cloud-go/v20?tab=overview) |

[Product Page](https://products.aspose.cloud/cells/perl) | [Documentation](https://docs.aspose.cloud/cells/) | [Live Demo](https://products.aspose.app/cells/family) | [API Reference](https://apireference.aspose.cloud/cells/) | [Code Samples](https://github.com/aspose-cells-cloud/aspose-cells-cloud-perl) | [Blog](https://blog.aspose.cloud/category/cells/) | [Free Support](https://forum.aspose.cloud/c/cells) | [Free Trial](https://dashboard.aspose.cloud/#/apps)

# Release history version

## Enhancements in Version 24.6

- Optimize load data function of data transformation.
- Optimize the data conversion applied steps.


## Enhancements in Version 24.5

- Add merge queries method for loading data of data transformation.
- Optimize chart data model.

## Enhancements in Version 24.4

- Support data transformation.

## Enhancements in Version 24.3

- Support data deduplication.
- Support data filling.
- Support to delete incomplete rows.
- Support data cleansing.

## Enhancements in Version 24.2.1

- Support data deduplication.

## Enhancements in Version 24.1.1

- Fixed spelling mistakes for several functions.
- Add the PostFitTallToPages method for page setup controller.
- Add the PostFitWideToPages method for page setup controller.
- Optimize save options about paginated.

## Enhancements in Version 23.12.0

- Conversion APIs add region parameter.
- Protection APIs add region parameter.
- Assemble data API adds region parameter.
- Merge files API adds region parameter.
- Split files API adds region parameter.
- Import data API adds region parameter.
- Watermark API adds region parameter.
- Clear object API adds region parameter.
- Reverse data API adds region parameter.
- Rotate data API adds region parameter.

## Enhancements in Version 23.11

- Optimize import xml data into Excel file.
- Optimize import json data into Excel file.
- Remove deprecated functions, class and test case.

## Enhancements in Version 23.10

- Fix protect workbook request.
- Fix range copy API.
- Optimize workbook protect API.

## Enhancements in Version 23.9

- Support to data sorting on range controller.
- Support to remove duplicate data on list object.
- Support to insert slicer for list object.
- Optimize list object and related objects.

## Enhancements in Version 23.8

- Support to lock API.
- Optimize protect API.

## Enhancements in Version 23.7

- Support to repair API.
- Remove GetExtractBarcodes API.

## Enhancements in Version 23.6

- Support to batch lock multi-files.
- Support to batch unlock multi-files.
- Support to protect lock multi-files.
- Support to split lock multi-files.
- Fix put document property api.

## Enhancements in Version 23.5

- Fix few method names for spelling error.

## Enhancements in Version 23.4

-Add import xml data api.
-Add export xml data api.

## Enhancements in Version 23.3

- Adopt the new model.

## Enhancements in Version 22.12

- Support chart axis operations.

## Enhancements in Version 22.11

- Add api for converting workbook to json.
- Add api for converting workbook to sql.
- Add api for converting workbook to csv.

## Enhancements in Version 22.10

- Add api for converting workbook to pptx.
- Add api for converting workbook to html.
- Add api for converting workbook to markdown.

## Enhancements in Version 22.9

- Add api for converting workbook to png.
- Add api for converting workbook to pdf.
- Add api for converting workbook to docx

## Enhancements in Version 22.8

- Support transposing Excel Rows to Columns.

## Enhancements in Version 22.7

- Add 4 kinds of Save Option.
- Add the checkExcelRestriction parameter for multiple APIs.

## Enhancements in Version 22.5

- Add a new API for getting barcode description.

## Enhancements in Version 22.4

- Export API adds extended query parameters.
- Convert API adds extended query parameters.
- SaveAs API adds extended query parameters.
- Get Workbook API adds extended query parameters.

## Enhancements in Version 22.3

-Add new API about adding digital signature for cloud file.

## Enhancements in Version 22.2

- Update return value for the DeleteUnprotectWorksheet API on Aspose.Cells Cloud.
- Update return value for the PutProtectWorksheet API on Aspose.Cells Cloud.
- Update return value for the PostSetCellHtmlString API on Aspose.Cells Cloud.
- Update return value for the PostUpdateWorksheetProperty API on Aspose.Cells Cloud.

## Enhancements in Version 22.1

- SaveAs API add the parameter of target storage name.
- Workbok merged API add the parameter of merged file storage name.
- Workbok split API add the parameter of target storage name
- Workbok smart marker API add the parameter of output storage name.
- Batch convert API add the parameters of intput and output storage name.
- Remove AutoshapesController from Aspose.Cells Cloud.
- Rename LiteCellsApi to LightCellsApi.

## Enhancements in Version 21.12

- Improvement for conversion API.
- Improvement for batch data import to support to set cell formula.
- Improvement for setting row height and column wight to support to set multi-rows and multi-columns.
- Support to set cell formula in batch data import.
- Add a new API for updating the list column.
- Add a new API for reversing columns and rows.
- Add new APIs for grouping and ungrouping shapes.

## Enhancements in Version 21.11

- Add new API for workbook get page count on Aspose.Cells Cloud.
- Add new API for worksheet get page count on Aspose.Cells Cloud.
- Add new API for compress excel file on Aspose.Cells Cloud.
- Add new feature for replace API.

## Enhancements in Version 21.10

- Add new API for support delete multiple worksheets in a single call.
- Add new API for supports batch convert excel files.

## Enhancements in Version 21.9

- Correct the return type of the following REST APIs.

## Enhancements in Version 21.8

- Improvement for getting list object Api.
- Add import Api.

## Enhancements in Version 21.7

- Fix search API.
- Fix split API.

## Enhancements in Version 21.6

- Improvement document properties.
- Update the return value of put/post/delete.
- Improvement export API.
- Improve split API.
- Improve merge API.
- Improve unlock API.
- Improve protected API.
- Improve watermark API.

## Enhancements in Version 21.5

- Support autofit columns for workbook and worksheet.
- Improve add and post row/column APIs.
- Improve Task APIs.

## Enhancements in Version 21.1

- Support to convert worksheet on task API
- Support to add and delete cell or range in worksheet.

## Enhancements in Version 20.11

- Support Aspose.Cells Cloud for Docker.

## Enhancements in Version 20.10

- Support to upload large file.

## Enhancements in Version 20.9

- Support sparkline groups.
- Add API about updating pivot field.

## Enhancements in Version 20.8

- Aspose.Cells Cloud API calls are not working with explicit storage name but only default storage.
- Get output file size without downloading during conversion.
- Enhancement for CellsShapesPutWorksheetShape API.
