#
#
#  Copyright (c) 2003 Andrew W. Speer <andrew.speer@isolutions.com.au>. All rights 
#  reserved.
#
#  This file is part of Bundle::WebMod::Base.
#
#  Bundle::WebMod::Base is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#  $Id: Base.pm,v 1.58 2005/09/28 15:15:36 aspeer Exp $



#
#
package Bundle::WebMod::Base;


#  Compiler Pragma
#
use strict qw(vars);
use vars qw($VERSION $PACKAGE);


#  Version information in a formate suitable for CPAN etc. Must be
#  all on one line
#
$VERSION=(qw$Revision: 1.58 $)[1];


#  Package object
#
$PACKAGE=__PACKAGE__;


#  All done
#
$VERSION;



__END__


=head1 NAME

Bundle::WebMod::Base - WebMod::Base Utilities

=head1 SYNOPSIS

C<perl -MCPAN -e 'install Bundle::WebMod::Base'>

=head1 CONTENTS

WebMod::Base

WebMod::Err

WebMod::Debug

WebMod::Log

WebMod::Constant

WebMod::Proto

=head1 DESCRIPTION

=head1 AUTHOR

Andrew Speer E<lt>F<andrew.speer@isolutions.com.au>E<gt>

=cut
