#  Makefile.PL for WebMod::Base
#
package WebMod::Base;


#  Compiler Pragma
#
use strict qw(vars);


#  External Modules
#
use ExtUtils::MakeMaker;



#  All done, init finished
#
#------------------------------------------------------------------------------


#  Create the Makefile
#
WriteMakefile(

    NAME				  =>  __PACKAGE__,
    VERSION_FROM			  =>  'VERSION.pm',

    PM					  =>  {
	'Base.pm'			  =>  '$(INST_LIBDIR)/Base.pm',
	'VERSION.pm'			  =>  '$(INST_LIBDIR)/Base/VERSION.pm',
	'LICENSE'			  =>  '$(INST_LIBDIR)/Base/LICENSE',
    },

    'dist'				  =>  {
	COMPRESS			  =>  'gzip -9f',
	SUFFIX				  =>  '.gz'
    },

    'depend'				  =>  { 
	Makefile			  =>  '$(VERSION_FROM)'
    },

    'macro'				 =>  {
        COPYRIGHT			 =>  'Copyright (c) 2003 Andrew Speer, All rights reserved',
    	LICENSE				 =>  'GPL: GNU General Public License',
    	statl				 =>  'g',
    },


    ($] >= 5.005 ?
      (#ABSTRACT_FROM 			 => 'Base.pm',
       AUTHOR     			 => 'Andrew Speer <andrew.speer@isolutions.com.au>') : ()
    ),

   );


