#=======================================================================
#    ____  ____  _____              _    ____ ___   ____
#   |  _ \|  _ \|  ___|  _   _     / \  |  _ \_ _| |___ \
#   | |_) | | | | |_    (_) (_)   / _ \ | |_) | |    __) |
#   |  __/| |_| |  _|    _   _   / ___ \|  __/| |   / __/
#   |_|   |____/|_|     (_) (_) /_/   \_\_|  |___| |_____|
#
#   A Perl Module Chain to faciliate the Creation and Modification
#   of High-Quality "Portable Document Format (PDF)" Files.
#
#   Copyright 1999-2004 Alfred Reibenschuh <areibens@cpan.org>.
#
#=======================================================================
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the
#   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#   Boston, MA 02111-1307, USA.
#
#   $Id: japanese.pm,v 1.6 2004/06/07 19:44:38 fredo Exp $
#
#=======================================================================

$cmap->{japanese}={
    'g2u' => [
        0x0000, # G+0  U+0000  .notdef,  UNDEFINED
        0x0020, # G+1  U+0020  space,  SPACE
        0x0021, # G+2  U+0021  exclam,  EXCLAMATION MARK
        0x0022, # G+3  U+0022  quotedbl,  QUOTATION MARK
        0x0023, # G+4  U+0023  numbersign,  NUMBER SIGN
        0x0024, # G+5  U+0024  dollar,  DOLLAR SIGN
        0x0025, # G+6  U+0025  percent,  PERCENT SIGN
        0x0026, # G+7  U+0026  ampersand,  AMPERSAND
        0x0027, # G+8  U+0027  quotesingle,  APOSTROPHE
        0x0028, # G+9  U+0028  parenleft,  LEFT PARENTHESIS
        0x0029, # G+10  U+0029  parenright,  RIGHT PARENTHESIS
        0x002A, # G+11  U+002A  asterisk,  ASTERISK
        0x002B, # G+12  U+002B  plus,  PLUS SIGN
        0x002C, # G+13  U+002C  comma,  COMMA
        0x002D, # G+14  U+002D  hyphen,  HYPHEN-MINUS
        0x002E, # G+15  U+002E  period,  FULL STOP
        0x002F, # G+16  U+002F  slash,  SOLIDUS
        0x0030, # G+17  U+0030  zero,  DIGIT ZERO
        0x0031, # G+18  U+0031  one,  DIGIT ONE
        0x0032, # G+19  U+0032  two,  DIGIT TWO
        0x0033, # G+20  U+0033  three,  DIGIT THREE
        0x0034, # G+21  U+0034  four,  DIGIT FOUR
        0x0035, # G+22  U+0035  five,  DIGIT FIVE
        0x0036, # G+23  U+0036  six,  DIGIT SIX
        0x0037, # G+24  U+0037  seven,  DIGIT SEVEN
        0x0038, # G+25  U+0038  eight,  DIGIT EIGHT
        0x0039, # G+26  U+0039  nine,  DIGIT NINE
        0x003A, # G+27  U+003A  colon,  COLON
        0x003B, # G+28  U+003B  semicolon,  SEMICOLON
        0x003C, # G+29  U+003C  less,  LESS-THAN SIGN
        0x003D, # G+30  U+003D  equal,  EQUALS SIGN
        0x003E, # G+31  U+003E  greater,  GREATER-THAN SIGN
        0x003F, # G+32  U+003F  question,  QUESTION MARK
        0x0040, # G+33  U+0040  at,  COMMERCIAL AT
        0x0041, # G+34  U+0041  A,  LATIN CAPITAL LETTER A
        0x0042, # G+35  U+0042  B,  LATIN CAPITAL LETTER B
        0x0043, # G+36  U+0043  C,  LATIN CAPITAL LETTER C
        0x0044, # G+37  U+0044  D,  LATIN CAPITAL LETTER D
        0x0045, # G+38  U+0045  E,  LATIN CAPITAL LETTER E
        0x0046, # G+39  U+0046  F,  LATIN CAPITAL LETTER F
        0x0047, # G+40  U+0047  G,  LATIN CAPITAL LETTER G
        0x0048, # G+41  U+0048  H,  LATIN CAPITAL LETTER H
        0x0049, # G+42  U+0049  I,  LATIN CAPITAL LETTER I
        0x004A, # G+43  U+004A  J,  LATIN CAPITAL LETTER J
        0x004B, # G+44  U+004B  K,  LATIN CAPITAL LETTER K
        0x004C, # G+45  U+004C  L,  LATIN CAPITAL LETTER L
        0x004D, # G+46  U+004D  M,  LATIN CAPITAL LETTER M
        0x004E, # G+47  U+004E  N,  LATIN CAPITAL LETTER N
        0x004F, # G+48  U+004F  O,  LATIN CAPITAL LETTER O
        0x0050, # G+49  U+0050  P,  LATIN CAPITAL LETTER P
        0x0051, # G+50  U+0051  Q,  LATIN CAPITAL LETTER Q
        0x0052, # G+51  U+0052  R,  LATIN CAPITAL LETTER R
        0x0053, # G+52  U+0053  S,  LATIN CAPITAL LETTER S
        0x0054, # G+53  U+0054  T,  LATIN CAPITAL LETTER T
        0x0055, # G+54  U+0055  U,  LATIN CAPITAL LETTER U
        0x0056, # G+55  U+0056  V,  LATIN CAPITAL LETTER V
        0x0057, # G+56  U+0057  W,  LATIN CAPITAL LETTER W
        0x0058, # G+57  U+0058  X,  LATIN CAPITAL LETTER X
        0x0059, # G+58  U+0059  Y,  LATIN CAPITAL LETTER Y
        0x005A, # G+59  U+005A  Z,  LATIN CAPITAL LETTER Z
        0x005B, # G+60  U+005B  bracketleft,  LEFT SQUARE BRACKET
        0x00A5, # G+61  U+00A5  yen,  YEN SIGN
        0x005D, # G+62  U+005D  bracketright,  RIGHT SQUARE BRACKET
        0x005E, # G+63  U+005E  asciicircum,  CIRCUMFLEX ACCENT
        0x005F, # G+64  U+005F  underscore,  LOW LINE
        0x0060, # G+65  U+0060  grave,  GRAVE ACCENT
        0x0061, # G+66  U+0061  a,  LATIN SMALL LETTER A
        0x0062, # G+67  U+0062  b,  LATIN SMALL LETTER B
        0x0063, # G+68  U+0063  c,  LATIN SMALL LETTER C
        0x0064, # G+69  U+0064  d,  LATIN SMALL LETTER D
        0x0065, # G+70  U+0065  e,  LATIN SMALL LETTER E
        0x0066, # G+71  U+0066  f,  LATIN SMALL LETTER F
        0x0067, # G+72  U+0067  g,  LATIN SMALL LETTER G
        0x0068, # G+73  U+0068  h,  LATIN SMALL LETTER H
        0x0069, # G+74  U+0069  i,  LATIN SMALL LETTER I
        0x006A, # G+75  U+006A  j,  LATIN SMALL LETTER J
        0x006B, # G+76  U+006B  k,  LATIN SMALL LETTER K
        0x006C, # G+77  U+006C  l,  LATIN SMALL LETTER L
        0x006D, # G+78  U+006D  m,  LATIN SMALL LETTER M
        0x006E, # G+79  U+006E  n,  LATIN SMALL LETTER N
        0x006F, # G+80  U+006F  o,  LATIN SMALL LETTER O
        0x0070, # G+81  U+0070  p,  LATIN SMALL LETTER P
        0x0071, # G+82  U+0071  q,  LATIN SMALL LETTER Q
        0x0072, # G+83  U+0072  r,  LATIN SMALL LETTER R
        0x0073, # G+84  U+0073  s,  LATIN SMALL LETTER S
        0x0074, # G+85  U+0074  t,  LATIN SMALL LETTER T
        0x0075, # G+86  U+0075  u,  LATIN SMALL LETTER U
        0x0076, # G+87  U+0076  v,  LATIN SMALL LETTER V
        0x0077, # G+88  U+0077  w,  LATIN SMALL LETTER W
        0x0078, # G+89  U+0078  x,  LATIN SMALL LETTER X
        0x0079, # G+90  U+0079  y,  LATIN SMALL LETTER Y
        0x007A, # G+91  U+007A  z,  LATIN SMALL LETTER Z
        0x007B, # G+92  U+007B  braceleft,  LEFT CURLY BRACKET
        0x007C, # G+93  U+007C  bar,  VERTICAL LINE
        0x007D, # G+94  U+007D  braceright,  RIGHT CURLY BRACKET
        0x007E, # G+95  U+007E  asciitilde,  TILDE
        0x0000, # G+96  U+0000  .notdef,  UNDEFINED
        0x005C, # G+97  U+005C  backslash,  REVERSE SOLIDUS
        0x0000, # G+98  U+0000  .notdef,  UNDEFINED
        0x00A6, # G+99  U+00A6  brokenbar,  BROKEN BAR
        0x0000, # G+100  U+0000  .notdef,  UNDEFINED
        0x00A1, # G+101  U+00A1  exclamdown,  INVERTED EXCLAMATION MARK
        0x00A2, # G+102  U+00A2  cent,  CENT SIGN
        0x00A3, # G+103  U+00A3  sterling,  POUND SIGN
        0x2044, # G+104  U+2044  fraction,  FRACTION SLASH
        0x0000, # G+105  U+0000  .notdef,  UNDEFINED
        0x0000, # G+106  U+0000  .notdef,  UNDEFINED
        0x00A4, # G+107  U+00A4  currency,  CURRENCY SIGN
        0x0000, # G+108  U+0000  .notdef,  UNDEFINED
        0x00AB, # G+109  U+00AB  guillemotleft,  LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
        0x2039, # G+110  U+2039  guilsinglleft,  SINGLE LEFT-POINTING ANGLE QUOTATION MARK
        0x203A, # G+111  U+203A  guilsinglright,  SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
        0xFB01, # G+112  U+FB01  fi,  LATIN SMALL LIGATURE FI
        0xFB02, # G+113  U+FB02  fl,  LATIN SMALL LIGATURE FL
        0x2012, # G+114  U+2012  figuredash,  FIGURE DASH
        0x0000, # G+115  U+0000  .notdef,  UNDEFINED
        0x0000, # G+116  U+0000  .notdef,  UNDEFINED
        0x00B7, # G+117  U+00B7  periodcentered,  MIDDLE DOT
        0x0000, # G+118  U+0000  .notdef,  UNDEFINED
        0x2022, # G+119  U+2022  bullet,  BULLET
        0x201A, # G+120  U+201A  quotesinglbase,  SINGLE LOW-9 QUOTATION MARK
        0x201E, # G+121  U+201E  quotedblbase,  DOUBLE LOW-9 QUOTATION MARK
        0x0000, # G+122  U+0000  .notdef,  UNDEFINED
        0x00BB, # G+123  U+00BB  guillemotright,  RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
        0x0000, # G+124  U+0000  .notdef,  UNDEFINED
        0x0000, # G+125  U+0000  .notdef,  UNDEFINED
        0x00BF, # G+126  U+00BF  questiondown,  INVERTED QUESTION MARK
        0x0301, # G+127  U+0301  acutecomb,  COMBINING ACUTE ACCENT
        0x0302, # G+128  U+0302  uni0302,  COMBINING CIRCUMFLEX ACCENT
        0x00AF, # G+129  U+00AF  macron,  MACRON
        0x0306, # G+130  U+0306  uni0306,  COMBINING BREVE
        0x0307, # G+131  U+0307  uni0307,  COMBINING DOT ABOVE
        0x0308, # G+132  U+0308  uni0308,  COMBINING DIAERESIS
        0x030A, # G+133  U+030A  uni030A,  COMBINING RING ABOVE
        0x00B8, # G+134  U+00B8  cedilla,  CEDILLA
        0x030B, # G+135  U+030B  uni030B,  COMBINING DOUBLE ACUTE ACCENT
        0x0328, # G+136  U+0328  uni0328,  COMBINING OGONEK
        0x030C, # G+137  U+030C  uni030C,  COMBINING CARON
        0x0336, # G+138  U+0336  uni0336,  COMBINING LONG STROKE OVERLAY
        0x00C6, # G+139  U+00C6  AE,  LATIN CAPITAL LETTER AE
        0x00AA, # G+140  U+00AA  ordfeminine,  FEMININE ORDINAL INDICATOR
        0x0141, # G+141  U+0141  Lslash,  LATIN CAPITAL LETTER L WITH STROKE
        0x00D8, # G+142  U+00D8  Oslash,  LATIN CAPITAL LETTER O WITH STROKE
        0x0152, # G+143  U+0152  OE,  LATIN CAPITAL LIGATURE OE
        0x00BA, # G+144  U+00BA  ordmasculine,  MASCULINE ORDINAL INDICATOR
        0x00E6, # G+145  U+00E6  ae,  LATIN SMALL LETTER AE
        0x0131, # G+146  U+0131  dotlessi,  LATIN SMALL LETTER DOTLESS I
        0x0142, # G+147  U+0142  lslash,  LATIN SMALL LETTER L WITH STROKE
        0x00F8, # G+148  U+00F8  oslash,  LATIN SMALL LETTER O WITH STROKE
        0x0153, # G+149  U+0153  oe,  LATIN SMALL LIGATURE OE
        0x00DF, # G+150  U+00DF  germandbls,  LATIN SMALL LETTER SHARP S
        0x00AD, # G+151  U+00AD  hyphen,  SOFT HYPHEN
        0x00A9, # G+152  U+00A9  copyright,  COPYRIGHT SIGN
        0x00AC, # G+153  U+00AC  logicalnot,  NOT SIGN
        0x00AE, # G+154  U+00AE  registered,  REGISTERED SIGN
        0x0000, # G+155  U+0000  .notdef,  UNDEFINED
        0x0000, # G+156  U+0000  .notdef,  UNDEFINED
        0x00B2, # G+157  U+00B2  twosuperior,  SUPERSCRIPT TWO
        0x00B3, # G+158  U+00B3  threesuperior,  SUPERSCRIPT THREE
        0x00B5, # G+159  U+00B5  mu,  MICRO SIGN
        0x00B9, # G+160  U+00B9  onesuperior,  SUPERSCRIPT ONE
        0x00BC, # G+161  U+00BC  onequarter,  VULGAR FRACTION ONE QUARTER
        0x00BD, # G+162  U+00BD  onehalf,  VULGAR FRACTION ONE HALF
        0x00BE, # G+163  U+00BE  threequarters,  VULGAR FRACTION THREE QUARTERS
        0x00C0, # G+164  U+00C0  Agrave,  LATIN CAPITAL LETTER A WITH GRAVE
        0x00C1, # G+165  U+00C1  Aacute,  LATIN CAPITAL LETTER A WITH ACUTE
        0x00C2, # G+166  U+00C2  Acircumflex,  LATIN CAPITAL LETTER A WITH CIRCUMFLEX
        0x00C3, # G+167  U+00C3  Atilde,  LATIN CAPITAL LETTER A WITH TILDE
        0x00C4, # G+168  U+00C4  Adieresis,  LATIN CAPITAL LETTER A WITH DIAERESIS
        0x00C5, # G+169  U+00C5  Aring,  LATIN CAPITAL LETTER A WITH RING ABOVE
        0x00C7, # G+170  U+00C7  Ccedilla,  LATIN CAPITAL LETTER C WITH CEDILLA
        0x00C8, # G+171  U+00C8  Egrave,  LATIN CAPITAL LETTER E WITH GRAVE
        0x00C9, # G+172  U+00C9  Eacute,  LATIN CAPITAL LETTER E WITH ACUTE
        0x00CA, # G+173  U+00CA  Ecircumflex,  LATIN CAPITAL LETTER E WITH CIRCUMFLEX
        0x00CB, # G+174  U+00CB  Edieresis,  LATIN CAPITAL LETTER E WITH DIAERESIS
        0x00CC, # G+175  U+00CC  Igrave,  LATIN CAPITAL LETTER I WITH GRAVE
        0x00CD, # G+176  U+00CD  Iacute,  LATIN CAPITAL LETTER I WITH ACUTE
        0x00CE, # G+177  U+00CE  Icircumflex,  LATIN CAPITAL LETTER I WITH CIRCUMFLEX
        0x00CF, # G+178  U+00CF  Idieresis,  LATIN CAPITAL LETTER I WITH DIAERESIS
        0x00D0, # G+179  U+00D0  Eth,  LATIN CAPITAL LETTER ETH
        0x00D1, # G+180  U+00D1  Ntilde,  LATIN CAPITAL LETTER N WITH TILDE
        0x00D2, # G+181  U+00D2  Ograve,  LATIN CAPITAL LETTER O WITH GRAVE
        0x00D3, # G+182  U+00D3  Oacute,  LATIN CAPITAL LETTER O WITH ACUTE
        0x00D4, # G+183  U+00D4  Ocircumflex,  LATIN CAPITAL LETTER O WITH CIRCUMFLEX
        0x00D5, # G+184  U+00D5  Otilde,  LATIN CAPITAL LETTER O WITH TILDE
        0x00D6, # G+185  U+00D6  Odieresis,  LATIN CAPITAL LETTER O WITH DIAERESIS
        0x0000, # G+186  U+0000  .notdef,  UNDEFINED
        0x00D9, # G+187  U+00D9  Ugrave,  LATIN CAPITAL LETTER U WITH GRAVE
        0x00DA, # G+188  U+00DA  Uacute,  LATIN CAPITAL LETTER U WITH ACUTE
        0x00DB, # G+189  U+00DB  Ucircumflex,  LATIN CAPITAL LETTER U WITH CIRCUMFLEX
        0x00DC, # G+190  U+00DC  Udieresis,  LATIN CAPITAL LETTER U WITH DIAERESIS
        0x00DD, # G+191  U+00DD  Yacute,  LATIN CAPITAL LETTER Y WITH ACUTE
        0x00DE, # G+192  U+00DE  Thorn,  LATIN CAPITAL LETTER THORN
        0x00E0, # G+193  U+00E0  agrave,  LATIN SMALL LETTER A WITH GRAVE
        0x00E1, # G+194  U+00E1  aacute,  LATIN SMALL LETTER A WITH ACUTE
        0x00E2, # G+195  U+00E2  acircumflex,  LATIN SMALL LETTER A WITH CIRCUMFLEX
        0x00E3, # G+196  U+00E3  atilde,  LATIN SMALL LETTER A WITH TILDE
        0x00E4, # G+197  U+00E4  adieresis,  LATIN SMALL LETTER A WITH DIAERESIS
        0x00E5, # G+198  U+00E5  aring,  LATIN SMALL LETTER A WITH RING ABOVE
        0x00E7, # G+199  U+00E7  ccedilla,  LATIN SMALL LETTER C WITH CEDILLA
        0x00E8, # G+200  U+00E8  egrave,  LATIN SMALL LETTER E WITH GRAVE
        0x00E9, # G+201  U+00E9  eacute,  LATIN SMALL LETTER E WITH ACUTE
        0x00EA, # G+202  U+00EA  ecircumflex,  LATIN SMALL LETTER E WITH CIRCUMFLEX
        0x00EB, # G+203  U+00EB  edieresis,  LATIN SMALL LETTER E WITH DIAERESIS
        0x00EC, # G+204  U+00EC  igrave,  LATIN SMALL LETTER I WITH GRAVE
        0x00ED, # G+205  U+00ED  iacute,  LATIN SMALL LETTER I WITH ACUTE
        0x00EE, # G+206  U+00EE  icircumflex,  LATIN SMALL LETTER I WITH CIRCUMFLEX
        0x00EF, # G+207  U+00EF  idieresis,  LATIN SMALL LETTER I WITH DIAERESIS
        0x00F0, # G+208  U+00F0  eth,  LATIN SMALL LETTER ETH
        0x00F1, # G+209  U+00F1  ntilde,  LATIN SMALL LETTER N WITH TILDE
        0x00F2, # G+210  U+00F2  ograve,  LATIN SMALL LETTER O WITH GRAVE
        0x00F3, # G+211  U+00F3  oacute,  LATIN SMALL LETTER O WITH ACUTE
        0x00F4, # G+212  U+00F4  ocircumflex,  LATIN SMALL LETTER O WITH CIRCUMFLEX
        0x00F5, # G+213  U+00F5  otilde,  LATIN SMALL LETTER O WITH TILDE
        0x00F6, # G+214  U+00F6  odieresis,  LATIN SMALL LETTER O WITH DIAERESIS
        0x0000, # G+215  U+0000  .notdef,  UNDEFINED
        0x00F9, # G+216  U+00F9  ugrave,  LATIN SMALL LETTER U WITH GRAVE
        0x00FA, # G+217  U+00FA  uacute,  LATIN SMALL LETTER U WITH ACUTE
        0x00FB, # G+218  U+00FB  ucircumflex,  LATIN SMALL LETTER U WITH CIRCUMFLEX
        0x00FC, # G+219  U+00FC  udieresis,  LATIN SMALL LETTER U WITH DIAERESIS
        0x00FD, # G+220  U+00FD  yacute,  LATIN SMALL LETTER Y WITH ACUTE
        0x00FE, # G+221  U+00FE  thorn,  LATIN SMALL LETTER THORN
        0x00FF, # G+222  U+00FF  ydieresis,  LATIN SMALL LETTER Y WITH DIAERESIS
        0x0160, # G+223  U+0160  Scaron,  LATIN CAPITAL LETTER S WITH CARON
        0x0178, # G+224  U+0178  Ydieresis,  LATIN CAPITAL LETTER Y WITH DIAERESIS
        0x017D, # G+225  U+017D  Zcaron,  LATIN CAPITAL LETTER Z WITH CARON
        0x0305, # G+226  U+0305  uni0305,  COMBINING OVERLINE
        0x0161, # G+227  U+0161  scaron,  LATIN SMALL LETTER S WITH CARON
        0x2122, # G+228  U+2122  trademark,  TRADE MARK SIGN
        0x017E, # G+229  U+017E  zcaron,  LATIN SMALL LETTER Z WITH CARON
        0x0000, # G+230  U+0000  .notdef,  UNDEFINED
        0x2002, # G+231  U+2002  uni2002,  EN SPACE
        0x0021, # G+232  U+0021  exclam,  EXCLAMATION MARK
        0x0022, # G+233  U+0022  quotedbl,  QUOTATION MARK
        0x0023, # G+234  U+0023  numbersign,  NUMBER SIGN
        0x0024, # G+235  U+0024  dollar,  DOLLAR SIGN
        0x0025, # G+236  U+0025  percent,  PERCENT SIGN
        0x0026, # G+237  U+0026  ampersand,  AMPERSAND
        0x0027, # G+238  U+0027  quotesingle,  APOSTROPHE
        0x0028, # G+239  U+0028  parenleft,  LEFT PARENTHESIS
        0x0029, # G+240  U+0029  parenright,  RIGHT PARENTHESIS
        0x002A, # G+241  U+002A  asterisk,  ASTERISK
        0x002B, # G+242  U+002B  plus,  PLUS SIGN
        0x002C, # G+243  U+002C  comma,  COMMA
        0x002D, # G+244  U+002D  hyphen,  HYPHEN-MINUS
        0x002E, # G+245  U+002E  period,  FULL STOP
        0x002F, # G+246  U+002F  slash,  SOLIDUS
        0x0030, # G+247  U+0030  zero,  DIGIT ZERO
        0x0031, # G+248  U+0031  one,  DIGIT ONE
        0x0032, # G+249  U+0032  two,  DIGIT TWO
        0x0033, # G+250  U+0033  three,  DIGIT THREE
        0x0034, # G+251  U+0034  four,  DIGIT FOUR
        0x0035, # G+252  U+0035  five,  DIGIT FIVE
        0x0036, # G+253  U+0036  six,  DIGIT SIX
        0x0037, # G+254  U+0037  seven,  DIGIT SEVEN
        0x0038, # G+255  U+0038  eight,  DIGIT EIGHT
        0x0039, # G+256  U+0039  nine,  DIGIT NINE
        0x003A, # G+257  U+003A  colon,  COLON
        0x003B, # G+258  U+003B  semicolon,  SEMICOLON
        0x003C, # G+259  U+003C  less,  LESS-THAN SIGN
        0x003D, # G+260  U+003D  equal,  EQUALS SIGN
        0x003E, # G+261  U+003E  greater,  GREATER-THAN SIGN
        0x003F, # G+262  U+003F  question,  QUESTION MARK
        0x0040, # G+263  U+0040  at,  COMMERCIAL AT
        0x0041, # G+264  U+0041  A,  LATIN CAPITAL LETTER A
        0x0042, # G+265  U+0042  B,  LATIN CAPITAL LETTER B
        0x0043, # G+266  U+0043  C,  LATIN CAPITAL LETTER C
        0x0044, # G+267  U+0044  D,  LATIN CAPITAL LETTER D
        0x0045, # G+268  U+0045  E,  LATIN CAPITAL LETTER E
        0x0046, # G+269  U+0046  F,  LATIN CAPITAL LETTER F
        0x0047, # G+270  U+0047  G,  LATIN CAPITAL LETTER G
        0x0048, # G+271  U+0048  H,  LATIN CAPITAL LETTER H
        0x0049, # G+272  U+0049  I,  LATIN CAPITAL LETTER I
        0x004A, # G+273  U+004A  J,  LATIN CAPITAL LETTER J
        0x004B, # G+274  U+004B  K,  LATIN CAPITAL LETTER K
        0x004C, # G+275  U+004C  L,  LATIN CAPITAL LETTER L
        0x004D, # G+276  U+004D  M,  LATIN CAPITAL LETTER M
        0x004E, # G+277  U+004E  N,  LATIN CAPITAL LETTER N
        0x004F, # G+278  U+004F  O,  LATIN CAPITAL LETTER O
        0x0050, # G+279  U+0050  P,  LATIN CAPITAL LETTER P
        0x0051, # G+280  U+0051  Q,  LATIN CAPITAL LETTER Q
        0x0052, # G+281  U+0052  R,  LATIN CAPITAL LETTER R
        0x0053, # G+282  U+0053  S,  LATIN CAPITAL LETTER S
        0x0054, # G+283  U+0054  T,  LATIN CAPITAL LETTER T
        0x0055, # G+284  U+0055  U,  LATIN CAPITAL LETTER U
        0x0056, # G+285  U+0056  V,  LATIN CAPITAL LETTER V
        0x0057, # G+286  U+0057  W,  LATIN CAPITAL LETTER W
        0x0058, # G+287  U+0058  X,  LATIN CAPITAL LETTER X
        0x0059, # G+288  U+0059  Y,  LATIN CAPITAL LETTER Y
        0x005A, # G+289  U+005A  Z,  LATIN CAPITAL LETTER Z
        0x005B, # G+290  U+005B  bracketleft,  LEFT SQUARE BRACKET
        0x00A5, # G+291  U+00A5  yen,  YEN SIGN
        0x005D, # G+292  U+005D  bracketright,  RIGHT SQUARE BRACKET
        0x005E, # G+293  U+005E  asciicircum,  CIRCUMFLEX ACCENT
        0x005F, # G+294  U+005F  underscore,  LOW LINE
        0x0060, # G+295  U+0060  grave,  GRAVE ACCENT
        0x0061, # G+296  U+0061  a,  LATIN SMALL LETTER A
        0x0062, # G+297  U+0062  b,  LATIN SMALL LETTER B
        0x0063, # G+298  U+0063  c,  LATIN SMALL LETTER C
        0x0064, # G+299  U+0064  d,  LATIN SMALL LETTER D
        0x0065, # G+300  U+0065  e,  LATIN SMALL LETTER E
        0x0066, # G+301  U+0066  f,  LATIN SMALL LETTER F
        0x0067, # G+302  U+0067  g,  LATIN SMALL LETTER G
        0x0068, # G+303  U+0068  h,  LATIN SMALL LETTER H
        0x0069, # G+304  U+0069  i,  LATIN SMALL LETTER I
        0x006A, # G+305  U+006A  j,  LATIN SMALL LETTER J
        0x006B, # G+306  U+006B  k,  LATIN SMALL LETTER K
        0x006C, # G+307  U+006C  l,  LATIN SMALL LETTER L
        0x006D, # G+308  U+006D  m,  LATIN SMALL LETTER M
        0x006E, # G+309  U+006E  n,  LATIN SMALL LETTER N
        0x006F, # G+310  U+006F  o,  LATIN SMALL LETTER O
        0x0070, # G+311  U+0070  p,  LATIN SMALL LETTER P
        0x0071, # G+312  U+0071  q,  LATIN SMALL LETTER Q
        0x0072, # G+313  U+0072  r,  LATIN SMALL LETTER R
        0x0073, # G+314  U+0073  s,  LATIN SMALL LETTER S
        0x0074, # G+315  U+0074  t,  LATIN SMALL LETTER T
        0x0075, # G+316  U+0075  u,  LATIN SMALL LETTER U
        0x0076, # G+317  U+0076  v,  LATIN SMALL LETTER V
        0x0077, # G+318  U+0077  w,  LATIN SMALL LETTER W
        0x0078, # G+319  U+0078  x,  LATIN SMALL LETTER X
        0x0079, # G+320  U+0079  y,  LATIN SMALL LETTER Y
        0x007A, # G+321  U+007A  z,  LATIN SMALL LETTER Z
        0x007B, # G+322  U+007B  braceleft,  LEFT CURLY BRACKET
        0xFFE8, # G+323  U+FFE8  uniFFE8,  HALFWIDTH FORMS LIGHT VERTICAL
        0x007D, # G+324  U+007D  braceright,  RIGHT CURLY BRACKET
        0x203E, # G+325  U+203E  overline,  OVERLINE
        0x0000, # G+326  U+0000  .notdef,  UNDEFINED
        0xFF61, # G+327  U+FF61  uniFF61,  HALFWIDTH IDEOGRAPHIC FULL STOP
        0xFF62, # G+328  U+FF62  uniFF62,  HALFWIDTH LEFT CORNER BRACKET
        0xFF63, # G+329  U+FF63  uniFF63,  HALFWIDTH RIGHT CORNER BRACKET
        0xFF64, # G+330  U+FF64  uniFF64,  HALFWIDTH IDEOGRAPHIC COMMA
        0xFF65, # G+331  U+FF65  uniFF65,  HALFWIDTH KATAKANA MIDDLE DOT
        0xFF66, # G+332  U+FF66  uniFF66,  HALFWIDTH KATAKANA LETTER WO
        0xFF67, # G+333  U+FF67  uniFF67,  HALFWIDTH KATAKANA LETTER SMALL A
        0xFF68, # G+334  U+FF68  uniFF68,  HALFWIDTH KATAKANA LETTER SMALL I
        0xFF69, # G+335  U+FF69  uniFF69,  HALFWIDTH KATAKANA LETTER SMALL U
        0xFF6A, # G+336  U+FF6A  uniFF6A,  HALFWIDTH KATAKANA LETTER SMALL E
        0xFF6B, # G+337  U+FF6B  uniFF6B,  HALFWIDTH KATAKANA LETTER SMALL O
        0xFF6C, # G+338  U+FF6C  uniFF6C,  HALFWIDTH KATAKANA LETTER SMALL YA
        0xFF6D, # G+339  U+FF6D  uniFF6D,  HALFWIDTH KATAKANA LETTER SMALL YU
        0xFF6E, # G+340  U+FF6E  uniFF6E,  HALFWIDTH KATAKANA LETTER SMALL YO
        0xFF6F, # G+341  U+FF6F  uniFF6F,  HALFWIDTH KATAKANA LETTER SMALL TU
        0xFF70, # G+342  U+FF70  uniFF70,  HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
        0xFF71, # G+343  U+FF71  uniFF71,  HALFWIDTH KATAKANA LETTER A
        0xFF72, # G+344  U+FF72  uniFF72,  HALFWIDTH KATAKANA LETTER I
        0xFF73, # G+345  U+FF73  uniFF73,  HALFWIDTH KATAKANA LETTER U
        0xFF74, # G+346  U+FF74  uniFF74,  HALFWIDTH KATAKANA LETTER E
        0xFF75, # G+347  U+FF75  uniFF75,  HALFWIDTH KATAKANA LETTER O
        0xFF76, # G+348  U+FF76  uniFF76,  HALFWIDTH KATAKANA LETTER KA
        0xFF77, # G+349  U+FF77  uniFF77,  HALFWIDTH KATAKANA LETTER KI
        0xFF78, # G+350  U+FF78  uniFF78,  HALFWIDTH KATAKANA LETTER KU
        0xFF79, # G+351  U+FF79  uniFF79,  HALFWIDTH KATAKANA LETTER KE
        0xFF7A, # G+352  U+FF7A  uniFF7A,  HALFWIDTH KATAKANA LETTER KO
        0xFF7B, # G+353  U+FF7B  uniFF7B,  HALFWIDTH KATAKANA LETTER SA
        0xFF7C, # G+354  U+FF7C  uniFF7C,  HALFWIDTH KATAKANA LETTER SI
        0xFF7D, # G+355  U+FF7D  uniFF7D,  HALFWIDTH KATAKANA LETTER SU
        0xFF7E, # G+356  U+FF7E  uniFF7E,  HALFWIDTH KATAKANA LETTER SE
        0xFF7F, # G+357  U+FF7F  uniFF7F,  HALFWIDTH KATAKANA LETTER SO
        0xFF80, # G+358  U+FF80  uniFF80,  HALFWIDTH KATAKANA LETTER TA
        0xFF81, # G+359  U+FF81  uniFF81,  HALFWIDTH KATAKANA LETTER TI
        0xFF82, # G+360  U+FF82  uniFF82,  HALFWIDTH KATAKANA LETTER TU
        0xFF83, # G+361  U+FF83  uniFF83,  HALFWIDTH KATAKANA LETTER TE
        0xFF84, # G+362  U+FF84  uniFF84,  HALFWIDTH KATAKANA LETTER TO
        0xFF85, # G+363  U+FF85  uniFF85,  HALFWIDTH KATAKANA LETTER NA
        0xFF86, # G+364  U+FF86  uniFF86,  HALFWIDTH KATAKANA LETTER NI
        0xFF87, # G+365  U+FF87  uniFF87,  HALFWIDTH KATAKANA LETTER NU
        0xFF88, # G+366  U+FF88  uniFF88,  HALFWIDTH KATAKANA LETTER NE
        0xFF89, # G+367  U+FF89  uniFF89,  HALFWIDTH KATAKANA LETTER NO
        0xFF8A, # G+368  U+FF8A  uniFF8A,  HALFWIDTH KATAKANA LETTER HA
        0xFF8B, # G+369  U+FF8B  uniFF8B,  HALFWIDTH KATAKANA LETTER HI
        0xFF8C, # G+370  U+FF8C  uniFF8C,  HALFWIDTH KATAKANA LETTER HU
        0xFF8D, # G+371  U+FF8D  uniFF8D,  HALFWIDTH KATAKANA LETTER HE
        0xFF8E, # G+372  U+FF8E  uniFF8E,  HALFWIDTH KATAKANA LETTER HO
        0xFF8F, # G+373  U+FF8F  uniFF8F,  HALFWIDTH KATAKANA LETTER MA
        0xFF90, # G+374  U+FF90  uniFF90,  HALFWIDTH KATAKANA LETTER MI
        0xFF91, # G+375  U+FF91  uniFF91,  HALFWIDTH KATAKANA LETTER MU
        0xFF92, # G+376  U+FF92  uniFF92,  HALFWIDTH KATAKANA LETTER ME
        0xFF93, # G+377  U+FF93  uniFF93,  HALFWIDTH KATAKANA LETTER MO
        0xFF94, # G+378  U+FF94  uniFF94,  HALFWIDTH KATAKANA LETTER YA
        0xFF95, # G+379  U+FF95  uniFF95,  HALFWIDTH KATAKANA LETTER YU
        0xFF96, # G+380  U+FF96  uniFF96,  HALFWIDTH KATAKANA LETTER YO
        0xFF97, # G+381  U+FF97  uniFF97,  HALFWIDTH KATAKANA LETTER RA
        0xFF98, # G+382  U+FF98  uniFF98,  HALFWIDTH KATAKANA LETTER RI
        0xFF99, # G+383  U+FF99  uniFF99,  HALFWIDTH KATAKANA LETTER RU
        0xFF9A, # G+384  U+FF9A  uniFF9A,  HALFWIDTH KATAKANA LETTER RE
        0xFF9B, # G+385  U+FF9B  uniFF9B,  HALFWIDTH KATAKANA LETTER RO
        0xFF9C, # G+386  U+FF9C  uniFF9C,  HALFWIDTH KATAKANA LETTER WA
        0xFF9D, # G+387  U+FF9D  uniFF9D,  HALFWIDTH KATAKANA LETTER N
        0xFF9E, # G+388  U+FF9E  uniFF9E,  HALFWIDTH KATAKANA VOICED SOUND MARK
        0xFF9F, # G+389  U+FF9F  uniFF9F,  HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
        0x0000, # G+390  U+0000  .notdef,  UNDEFINED
        0x0000, # G+391  U+0000  .notdef,  UNDEFINED
        0x0000, # G+392  U+0000  .notdef,  UNDEFINED
        0x0000, # G+393  U+0000  .notdef,  UNDEFINED
        0x0000, # G+394  U+0000  .notdef,  UNDEFINED
        0x0000, # G+395  U+0000  .notdef,  UNDEFINED
        0x0000, # G+396  U+0000  .notdef,  UNDEFINED
        0x0000, # G+397  U+0000  .notdef,  UNDEFINED
        0x0000, # G+398  U+0000  .notdef,  UNDEFINED
        0x0000, # G+399  U+0000  .notdef,  UNDEFINED
        0x0000, # G+400  U+0000  .notdef,  UNDEFINED
        0x0000, # G+401  U+0000  .notdef,  UNDEFINED
        0x0000, # G+402  U+0000  .notdef,  UNDEFINED
        0x0000, # G+403  U+0000  .notdef,  UNDEFINED
        0x0000, # G+404  U+0000  .notdef,  UNDEFINED
        0x0000, # G+405  U+0000  .notdef,  UNDEFINED
        0x0000, # G+406  U+0000  .notdef,  UNDEFINED
        0x0000, # G+407  U+0000  .notdef,  UNDEFINED
        0x0000, # G+408  U+0000  .notdef,  UNDEFINED
        0x0000, # G+409  U+0000  .notdef,  UNDEFINED
        0x0000, # G+410  U+0000  .notdef,  UNDEFINED
        0x0000, # G+411  U+0000  .notdef,  UNDEFINED
        0x0000, # G+412  U+0000  .notdef,  UNDEFINED
        0x0000, # G+413  U+0000  .notdef,  UNDEFINED
        0x0000, # G+414  U+0000  .notdef,  UNDEFINED
        0x0000, # G+415  U+0000  .notdef,  UNDEFINED
        0x0000, # G+416  U+0000  .notdef,  UNDEFINED
        0x0000, # G+417  U+0000  .notdef,  UNDEFINED
        0x0000, # G+418  U+0000  .notdef,  UNDEFINED
        0x0000, # G+419  U+0000  .notdef,  UNDEFINED
        0x0000, # G+420  U+0000  .notdef,  UNDEFINED
        0x0000, # G+421  U+0000  .notdef,  UNDEFINED
        0x0000, # G+422  U+0000  .notdef,  UNDEFINED
        0x0000, # G+423  U+0000  .notdef,  UNDEFINED
        0x0000, # G+424  U+0000  .notdef,  UNDEFINED
        0x0000, # G+425  U+0000  .notdef,  UNDEFINED
        0x0000, # G+426  U+0000  .notdef,  UNDEFINED
        0x0000, # G+427  U+0000  .notdef,  UNDEFINED
        0x0000, # G+428  U+0000  .notdef,  UNDEFINED
        0x0000, # G+429  U+0000  .notdef,  UNDEFINED
        0x0000, # G+430  U+0000  .notdef,  UNDEFINED
        0x0000, # G+431  U+0000  .notdef,  UNDEFINED
        0x0000, # G+432  U+0000  .notdef,  UNDEFINED
        0x0000, # G+433  U+0000  .notdef,  UNDEFINED
        0x0000, # G+434  U+0000  .notdef,  UNDEFINED
        0x0000, # G+435  U+0000  .notdef,  UNDEFINED
        0x0000, # G+436  U+0000  .notdef,  UNDEFINED
        0x0000, # G+437  U+0000  .notdef,  UNDEFINED
        0x0000, # G+438  U+0000  .notdef,  UNDEFINED
        0x0000, # G+439  U+0000  .notdef,  UNDEFINED
        0x0000, # G+440  U+0000  .notdef,  UNDEFINED
        0x0000, # G+441  U+0000  .notdef,  UNDEFINED
        0x0000, # G+442  U+0000  .notdef,  UNDEFINED
        0x0000, # G+443  U+0000  .notdef,  UNDEFINED
        0x0000, # G+444  U+0000  .notdef,  UNDEFINED
        0x0000, # G+445  U+0000  .notdef,  UNDEFINED
        0x0000, # G+446  U+0000  .notdef,  UNDEFINED
        0x0000, # G+447  U+0000  .notdef,  UNDEFINED
        0x0000, # G+448  U+0000  .notdef,  UNDEFINED
        0x0000, # G+449  U+0000  .notdef,  UNDEFINED
        0x0000, # G+450  U+0000  .notdef,  UNDEFINED
        0x0000, # G+451  U+0000  .notdef,  UNDEFINED
        0x0000, # G+452  U+0000  .notdef,  UNDEFINED
        0x0000, # G+453  U+0000  .notdef,  UNDEFINED
        0x0000, # G+454  U+0000  .notdef,  UNDEFINED
        0x0000, # G+455  U+0000  .notdef,  UNDEFINED
        0x0000, # G+456  U+0000  .notdef,  UNDEFINED
        0x0000, # G+457  U+0000  .notdef,  UNDEFINED
        0x0000, # G+458  U+0000  .notdef,  UNDEFINED
        0x0000, # G+459  U+0000  .notdef,  UNDEFINED
        0x0000, # G+460  U+0000  .notdef,  UNDEFINED
        0x0000, # G+461  U+0000  .notdef,  UNDEFINED
        0x0000, # G+462  U+0000  .notdef,  UNDEFINED
        0x0000, # G+463  U+0000  .notdef,  UNDEFINED
        0x0000, # G+464  U+0000  .notdef,  UNDEFINED
        0x0000, # G+465  U+0000  .notdef,  UNDEFINED
        0x0000, # G+466  U+0000  .notdef,  UNDEFINED
        0x0000, # G+467  U+0000  .notdef,  UNDEFINED
        0x0000, # G+468  U+0000  .notdef,  UNDEFINED
        0x0000, # G+469  U+0000  .notdef,  UNDEFINED
        0x0000, # G+470  U+0000  .notdef,  UNDEFINED
        0x0000, # G+471  U+0000  .notdef,  UNDEFINED
        0x0000, # G+472  U+0000  .notdef,  UNDEFINED
        0x0000, # G+473  U+0000  .notdef,  UNDEFINED
        0x0000, # G+474  U+0000  .notdef,  UNDEFINED
        0x0000, # G+475  U+0000  .notdef,  UNDEFINED
        0x0000, # G+476  U+0000  .notdef,  UNDEFINED
        0x0000, # G+477  U+0000  .notdef,  UNDEFINED
        0x0000, # G+478  U+0000  .notdef,  UNDEFINED
        0x0000, # G+479  U+0000  .notdef,  UNDEFINED
        0x0000, # G+480  U+0000  .notdef,  UNDEFINED
        0x0000, # G+481  U+0000  .notdef,  UNDEFINED
        0x0000, # G+482  U+0000  .notdef,  UNDEFINED
        0x0000, # G+483  U+0000  .notdef,  UNDEFINED
        0x0000, # G+484  U+0000  .notdef,  UNDEFINED
        0x0000, # G+485  U+0000  .notdef,  UNDEFINED
        0x0000, # G+486  U+0000  .notdef,  UNDEFINED
        0x0000, # G+487  U+0000  .notdef,  UNDEFINED
        0x0000, # G+488  U+0000  .notdef,  UNDEFINED
        0x0000, # G+489  U+0000  .notdef,  UNDEFINED
        0x0000, # G+490  U+0000  .notdef,  UNDEFINED
        0x0000, # G+491  U+0000  .notdef,  UNDEFINED
        0x0000, # G+492  U+0000  .notdef,  UNDEFINED
        0x0000, # G+493  U+0000  .notdef,  UNDEFINED
        0x0000, # G+494  U+0000  .notdef,  UNDEFINED
        0x0000, # G+495  U+0000  .notdef,  UNDEFINED
        0x0000, # G+496  U+0000  .notdef,  UNDEFINED
        0x0000, # G+497  U+0000  .notdef,  UNDEFINED
        0x0000, # G+498  U+0000  .notdef,  UNDEFINED
        0x0000, # G+499  U+0000  .notdef,  UNDEFINED
        0x0000, # G+500  U+0000  .notdef,  UNDEFINED
        0x0000, # G+501  U+0000  .notdef,  UNDEFINED
        0x0000, # G+502  U+0000  .notdef,  UNDEFINED
        0x0000, # G+503  U+0000  .notdef,  UNDEFINED
        0x0000, # G+504  U+0000  .notdef,  UNDEFINED
        0x0000, # G+505  U+0000  .notdef,  UNDEFINED
        0x0000, # G+506  U+0000  .notdef,  UNDEFINED
        0x0000, # G+507  U+0000  .notdef,  UNDEFINED
        0x0000, # G+508  U+0000  .notdef,  UNDEFINED
        0x0000, # G+509  U+0000  .notdef,  UNDEFINED
        0x0000, # G+510  U+0000  .notdef,  UNDEFINED
        0x0000, # G+511  U+0000  .notdef,  UNDEFINED
        0x0000, # G+512  U+0000  .notdef,  UNDEFINED
        0x0000, # G+513  U+0000  .notdef,  UNDEFINED
        0x0000, # G+514  U+0000  .notdef,  UNDEFINED
        0x0000, # G+515  U+0000  .notdef,  UNDEFINED
        0x0000, # G+516  U+0000  .notdef,  UNDEFINED
        0x0000, # G+517  U+0000  .notdef,  UNDEFINED
        0x0000, # G+518  U+0000  .notdef,  UNDEFINED
        0x0000, # G+519  U+0000  .notdef,  UNDEFINED
        0x0000, # G+520  U+0000  .notdef,  UNDEFINED
        0x0000, # G+521  U+0000  .notdef,  UNDEFINED
        0x0000, # G+522  U+0000  .notdef,  UNDEFINED
        0x0000, # G+523  U+0000  .notdef,  UNDEFINED
        0x0000, # G+524  U+0000  .notdef,  UNDEFINED
        0x0000, # G+525  U+0000  .notdef,  UNDEFINED
        0x0000, # G+526  U+0000  .notdef,  UNDEFINED
        0x0000, # G+527  U+0000  .notdef,  UNDEFINED
        0x0000, # G+528  U+0000  .notdef,  UNDEFINED
        0x0000, # G+529  U+0000  .notdef,  UNDEFINED
        0x0000, # G+530  U+0000  .notdef,  UNDEFINED
        0x0000, # G+531  U+0000  .notdef,  UNDEFINED
        0x0000, # G+532  U+0000  .notdef,  UNDEFINED
        0x0000, # G+533  U+0000  .notdef,  UNDEFINED
        0x0000, # G+534  U+0000  .notdef,  UNDEFINED
        0x0000, # G+535  U+0000  .notdef,  UNDEFINED
        0x0000, # G+536  U+0000  .notdef,  UNDEFINED
        0x0000, # G+537  U+0000  .notdef,  UNDEFINED
        0x0000, # G+538  U+0000  .notdef,  UNDEFINED
        0x0000, # G+539  U+0000  .notdef,  UNDEFINED
        0x0000, # G+540  U+0000  .notdef,  UNDEFINED
        0x0000, # G+541  U+0000  .notdef,  UNDEFINED
        0x0000, # G+542  U+0000  .notdef,  UNDEFINED
        0x0000, # G+543  U+0000  .notdef,  UNDEFINED
        0x0000, # G+544  U+0000  .notdef,  UNDEFINED
        0x0000, # G+545  U+0000  .notdef,  UNDEFINED
        0x0000, # G+546  U+0000  .notdef,  UNDEFINED
        0x0000, # G+547  U+0000  .notdef,  UNDEFINED
        0x0000, # G+548  U+0000  .notdef,  UNDEFINED
        0x0000, # G+549  U+0000  .notdef,  UNDEFINED
        0x0000, # G+550  U+0000  .notdef,  UNDEFINED
        0x0000, # G+551  U+0000  .notdef,  UNDEFINED
        0x0000, # G+552  U+0000  .notdef,  UNDEFINED
        0x0000, # G+553  U+0000  .notdef,  UNDEFINED
        0x0000, # G+554  U+0000  .notdef,  UNDEFINED
        0x0000, # G+555  U+0000  .notdef,  UNDEFINED
        0x0000, # G+556  U+0000  .notdef,  UNDEFINED
        0x0000, # G+557  U+0000  .notdef,  UNDEFINED
        0x0000, # G+558  U+0000  .notdef,  UNDEFINED
        0x0000, # G+559  U+0000  .notdef,  UNDEFINED
        0x0000, # G+560  U+0000  .notdef,  UNDEFINED
        0x0000, # G+561  U+0000  .notdef,  UNDEFINED
        0x0000, # G+562  U+0000  .notdef,  UNDEFINED
        0x0000, # G+563  U+0000  .notdef,  UNDEFINED
        0x0000, # G+564  U+0000  .notdef,  UNDEFINED
        0x0000, # G+565  U+0000  .notdef,  UNDEFINED
        0x0000, # G+566  U+0000  .notdef,  UNDEFINED
        0x0000, # G+567  U+0000  .notdef,  UNDEFINED
        0x0000, # G+568  U+0000  .notdef,  UNDEFINED
        0x0000, # G+569  U+0000  .notdef,  UNDEFINED
        0x0000, # G+570  U+0000  .notdef,  UNDEFINED
        0x0000, # G+571  U+0000  .notdef,  UNDEFINED
        0x0000, # G+572  U+0000  .notdef,  UNDEFINED
        0x0000, # G+573  U+0000  .notdef,  UNDEFINED
        0x0000, # G+574  U+0000  .notdef,  UNDEFINED
        0x0000, # G+575  U+0000  .notdef,  UNDEFINED
        0x0000, # G+576  U+0000  .notdef,  UNDEFINED
        0x0000, # G+577  U+0000  .notdef,  UNDEFINED
        0x0000, # G+578  U+0000  .notdef,  UNDEFINED
        0x0000, # G+579  U+0000  .notdef,  UNDEFINED
        0x0000, # G+580  U+0000  .notdef,  UNDEFINED
        0x0000, # G+581  U+0000  .notdef,  UNDEFINED
        0x0000, # G+582  U+0000  .notdef,  UNDEFINED
        0x0000, # G+583  U+0000  .notdef,  UNDEFINED
        0x0000, # G+584  U+0000  .notdef,  UNDEFINED
        0x0000, # G+585  U+0000  .notdef,  UNDEFINED
        0x0000, # G+586  U+0000  .notdef,  UNDEFINED
        0x0000, # G+587  U+0000  .notdef,  UNDEFINED
        0x0000, # G+588  U+0000  .notdef,  UNDEFINED
        0x0000, # G+589  U+0000  .notdef,  UNDEFINED
        0x0000, # G+590  U+0000  .notdef,  UNDEFINED
        0x0000, # G+591  U+0000  .notdef,  UNDEFINED
        0x0000, # G+592  U+0000  .notdef,  UNDEFINED
        0x0000, # G+593  U+0000  .notdef,  UNDEFINED
        0x0000, # G+594  U+0000  .notdef,  UNDEFINED
        0x0000, # G+595  U+0000  .notdef,  UNDEFINED
        0x0000, # G+596  U+0000  .notdef,  UNDEFINED
        0x0000, # G+597  U+0000  .notdef,  UNDEFINED
        0x0000, # G+598  U+0000  .notdef,  UNDEFINED
        0x0000, # G+599  U+0000  .notdef,  UNDEFINED
        0x0000, # G+600  U+0000  .notdef,  UNDEFINED
        0x0000, # G+601  U+0000  .notdef,  UNDEFINED
        0x0000, # G+602  U+0000  .notdef,  UNDEFINED
        0x0000, # G+603  U+0000  .notdef,  UNDEFINED
        0x0000, # G+604  U+0000  .notdef,  UNDEFINED
        0x0000, # G+605  U+0000  .notdef,  UNDEFINED
        0x0000, # G+606  U+0000  .notdef,  UNDEFINED
        0x0000, # G+607  U+0000  .notdef,  UNDEFINED
        0x0000, # G+608  U+0000  .notdef,  UNDEFINED
        0x0000, # G+609  U+0000  .notdef,  UNDEFINED
        0x0000, # G+610  U+0000  .notdef,  UNDEFINED
        0x0000, # G+611  U+0000  .notdef,  UNDEFINED
        0x0000, # G+612  U+0000  .notdef,  UNDEFINED
        0x0000, # G+613  U+0000  .notdef,  UNDEFINED
        0x0000, # G+614  U+0000  .notdef,  UNDEFINED
        0x0000, # G+615  U+0000  .notdef,  UNDEFINED
        0x0000, # G+616  U+0000  .notdef,  UNDEFINED
        0x0000, # G+617  U+0000  .notdef,  UNDEFINED
        0x0000, # G+618  U+0000  .notdef,  UNDEFINED
        0x0000, # G+619  U+0000  .notdef,  UNDEFINED
        0x0000, # G+620  U+0000  .notdef,  UNDEFINED
        0x0000, # G+621  U+0000  .notdef,  UNDEFINED
        0x0000, # G+622  U+0000  .notdef,  UNDEFINED
        0x0000, # G+623  U+0000  .notdef,  UNDEFINED
        0x0000, # G+624  U+0000  .notdef,  UNDEFINED
        0x0000, # G+625  U+0000  .notdef,  UNDEFINED
        0x0000, # G+626  U+0000  .notdef,  UNDEFINED
        0x0000, # G+627  U+0000  .notdef,  UNDEFINED
        0x0000, # G+628  U+0000  .notdef,  UNDEFINED
        0x0000, # G+629  U+0000  .notdef,  UNDEFINED
        0x0000, # G+630  U+0000  .notdef,  UNDEFINED
        0x0000, # G+631  U+0000  .notdef,  UNDEFINED
        0x0000, # G+632  U+0000  .notdef,  UNDEFINED
        0x2003, # G+633  U+2003  uni2003,  EM SPACE
        0x3001, # G+634  U+3001  uni3001,  IDEOGRAPHIC COMMA
        0x3002, # G+635  U+3002  uni3002,  IDEOGRAPHIC FULL STOP
        0xFF0C, # G+636  U+FF0C  uniFF0C,  FULLWIDTH COMMA
        0xFF0E, # G+637  U+FF0E  uniFF0E,  FULLWIDTH FULL STOP
        0x30FB, # G+638  U+30FB  uni30FB,  KATAKANA MIDDLE DOT
        0xFF1A, # G+639  U+FF1A  uniFF1A,  FULLWIDTH COLON
        0xFF1B, # G+640  U+FF1B  uniFF1B,  FULLWIDTH SEMICOLON
        0xFF1F, # G+641  U+FF1F  uniFF1F,  FULLWIDTH QUESTION MARK
        0xFF01, # G+642  U+FF01  uniFF01,  FULLWIDTH EXCLAMATION MARK
        0x309B, # G+643  U+309B  uni309B,  KATAKANA-HIRAGANA VOICED SOUND MARK
        0x309C, # G+644  U+309C  uni309C,  KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
        0x00B4, # G+645  U+00B4  acute,  ACUTE ACCENT
        0xFF40, # G+646  U+FF40  uniFF40,  FULLWIDTH GRAVE ACCENT
        0x00A8, # G+647  U+00A8  dieresis,  DIAERESIS
        0xFF3E, # G+648  U+FF3E  uniFF3E,  FULLWIDTH CIRCUMFLEX ACCENT
        0xFFE3, # G+649  U+FFE3  uniFFE3,  FULLWIDTH MACRON
        0xFF3F, # G+650  U+FF3F  uniFF3F,  FULLWIDTH LOW LINE
        0x30FD, # G+651  U+30FD  uni30FD,  KATAKANA ITERATION MARK
        0x30FE, # G+652  U+30FE  uni30FE,  KATAKANA VOICED ITERATION MARK
        0x309D, # G+653  U+309D  uni309D,  HIRAGANA ITERATION MARK
        0x309E, # G+654  U+309E  uni309E,  HIRAGANA VOICED ITERATION MARK
        0x3003, # G+655  U+3003  uni3003,  DITTO MARK
        0x4EDD, # G+656  U+4EDD  uni4EDD,  CJK UNIFIED IDEOGRAPH-4EDD
        0x3005, # G+657  U+3005  uni3005,  IDEOGRAPHIC ITERATION MARK
        0x3006, # G+658  U+3006  uni3006,  IDEOGRAPHIC CLOSING MARK
        0x3007, # G+659  U+3007  uni3007,  IDEOGRAPHIC NUMBER ZERO
        0x30FC, # G+660  U+30FC  uni30FC,  KATAKANA-HIRAGANA PROLONGED SOUND MARK
        0x2015, # G+661  U+2015  afii00208,  HORIZONTAL BAR
        0x2010, # G+662  U+2010  uni2010,  HYPHEN
        0xFF0F, # G+663  U+FF0F  uniFF0F,  FULLWIDTH SOLIDUS
        0xFF3C, # G+664  U+FF3C  uniFF3C,  FULLWIDTH REVERSE SOLIDUS
        0x223C, # G+665  U+223C  similar,  TILDE OPERATOR
        0x2016, # G+666  U+2016  uni2016,  DOUBLE VERTICAL LINE
        0xFF5C, # G+667  U+FF5C  uniFF5C,  FULLWIDTH VERTICAL LINE
        0x2026, # G+668  U+2026  ellipsis,  HORIZONTAL ELLIPSIS
        0x2025, # G+669  U+2025  twodotenleader,  TWO DOT LEADER
        0x2018, # G+670  U+2018  quoteleft,  LEFT SINGLE QUOTATION MARK
        0x2019, # G+671  U+2019  quoteright,  RIGHT SINGLE QUOTATION MARK
        0x201C, # G+672  U+201C  quotedblleft,  LEFT DOUBLE QUOTATION MARK
        0x201D, # G+673  U+201D  quotedblright,  RIGHT DOUBLE QUOTATION MARK
        0xFF08, # G+674  U+FF08  uniFF08,  FULLWIDTH LEFT PARENTHESIS
        0xFF09, # G+675  U+FF09  uniFF09,  FULLWIDTH RIGHT PARENTHESIS
        0x3014, # G+676  U+3014  uni3014,  LEFT TORTOISE SHELL BRACKET
        0x3015, # G+677  U+3015  uni3015,  RIGHT TORTOISE SHELL BRACKET
        0xFF3B, # G+678  U+FF3B  uniFF3B,  FULLWIDTH LEFT SQUARE BRACKET
        0xFF3D, # G+679  U+FF3D  uniFF3D,  FULLWIDTH RIGHT SQUARE BRACKET
        0xFF5B, # G+680  U+FF5B  uniFF5B,  FULLWIDTH LEFT CURLY BRACKET
        0xFF5D, # G+681  U+FF5D  uniFF5D,  FULLWIDTH RIGHT CURLY BRACKET
        0x3008, # G+682  U+3008  uni3008,  LEFT ANGLE BRACKET
        0x3009, # G+683  U+3009  uni3009,  RIGHT ANGLE BRACKET
        0x300A, # G+684  U+300A  uni300A,  LEFT DOUBLE ANGLE BRACKET
        0x300B, # G+685  U+300B  uni300B,  RIGHT DOUBLE ANGLE BRACKET
        0x300C, # G+686  U+300C  uni300C,  LEFT CORNER BRACKET
        0x300D, # G+687  U+300D  uni300D,  RIGHT CORNER BRACKET
        0x300E, # G+688  U+300E  uni300E,  LEFT WHITE CORNER BRACKET
        0x300F, # G+689  U+300F  uni300F,  RIGHT WHITE CORNER BRACKET
        0x3010, # G+690  U+3010  uni3010,  LEFT BLACK LENTICULAR BRACKET
        0x3011, # G+691  U+3011  uni3011,  RIGHT BLACK LENTICULAR BRACKET
        0xFF0B, # G+692  U+FF0B  uniFF0B,  FULLWIDTH PLUS SIGN
        0x2212, # G+693  U+2212  minus,  MINUS SIGN
        0x00B1, # G+694  U+00B1  plusminus,  PLUS-MINUS SIGN
        0x00D7, # G+695  U+00D7  multiply,  MULTIPLICATION SIGN
        0x00F7, # G+696  U+00F7  divide,  DIVISION SIGN
        0xFF1D, # G+697  U+FF1D  uniFF1D,  FULLWIDTH EQUALS SIGN
        0x2260, # G+698  U+2260  notequal,  NOT EQUAL TO
        0xFF1C, # G+699  U+FF1C  uniFF1C,  FULLWIDTH LESS-THAN SIGN
        0xFF1E, # G+700  U+FF1E  uniFF1E,  FULLWIDTH GREATER-THAN SIGN
        0x2266, # G+701  U+2266  uni2266,  LESS-THAN OVER EQUAL TO
        0x2267, # G+702  U+2267  uni2267,  GREATER-THAN OVER EQUAL TO
        0x221E, # G+703  U+221E  infinity,  INFINITY
        0x2234, # G+704  U+2234  therefore,  THEREFORE
        0x2642, # G+705  U+2642  male,  MALE SIGN
        0x2640, # G+706  U+2640  female,  FEMALE SIGN
        0x00B0, # G+707  U+00B0  degree,  DEGREE SIGN
        0x2032, # G+708  U+2032  minute,  PRIME
        0x2033, # G+709  U+2033  second,  DOUBLE PRIME
        0x2103, # G+710  U+2103  uni2103,  DEGREE CELSIUS
        0xFFE5, # G+711  U+FFE5  uniFFE5,  FULLWIDTH YEN SIGN
        0xFF04, # G+712  U+FF04  uniFF04,  FULLWIDTH DOLLAR SIGN
        0xFFE0, # G+713  U+FFE0  uniFFE0,  FULLWIDTH CENT SIGN
        0xFFE1, # G+714  U+FFE1  uniFFE1,  FULLWIDTH POUND SIGN
        0xFF05, # G+715  U+FF05  uniFF05,  FULLWIDTH PERCENT SIGN
        0xFF03, # G+716  U+FF03  uniFF03,  FULLWIDTH NUMBER SIGN
        0xFF06, # G+717  U+FF06  uniFF06,  FULLWIDTH AMPERSAND
        0xFF0A, # G+718  U+FF0A  uniFF0A,  FULLWIDTH ASTERISK
        0xFF20, # G+719  U+FF20  uniFF20,  FULLWIDTH COMMERCIAL AT
        0x00A7, # G+720  U+00A7  section,  SECTION SIGN
        0x2606, # G+721  U+2606  uni2606,  WHITE STAR
        0x2605, # G+722  U+2605  a35,  BLACK STAR
        0x25CB, # G+723  U+25CB  circle,  WHITE CIRCLE
        0x25CF, # G+724  U+25CF  H18533,  BLACK CIRCLE
        0x25CE, # G+725  U+25CE  uni25CE,  BULLSEYE
        0x25C7, # G+726  U+25C7  uni25C7,  WHITE DIAMOND
        0x25C6, # G+727  U+25C6  a78,  BLACK DIAMOND
        0x25A1, # G+728  U+25A1  H22073,  WHITE SQUARE
        0x25A0, # G+729  U+25A0  filledbox,  BLACK SQUARE
        0x25B3, # G+730  U+25B3  uni25B3,  WHITE UP-POINTING TRIANGLE
        0x25B2, # G+731  U+25B2  triagup,  BLACK UP-POINTING TRIANGLE
        0x25BD, # G+732  U+25BD  uni25BD,  WHITE DOWN-POINTING TRIANGLE
        0x25BC, # G+733  U+25BC  triagdn,  BLACK DOWN-POINTING TRIANGLE
        0x203B, # G+734  U+203B  uni203B,  REFERENCE MARK
        0x3012, # G+735  U+3012  uni3012,  POSTAL MARK
        0x2192, # G+736  U+2192  arrowright,  RIGHTWARDS ARROW
        0x2190, # G+737  U+2190  arrowleft,  LEFTWARDS ARROW
        0x2191, # G+738  U+2191  arrowup,  UPWARDS ARROW
        0x2193, # G+739  U+2193  arrowdown,  DOWNWARDS ARROW
        0x3013, # G+740  U+3013  uni3013,  GETA MARK
        0x2208, # G+741  U+2208  element,  ELEMENT OF
        0x220B, # G+742  U+220B  suchthat,  CONTAINS AS MEMBER
        0x2286, # G+743  U+2286  reflexsubset,  SUBSET OF OR EQUAL TO
        0x2287, # G+744  U+2287  reflexsuperset,  SUPERSET OF OR EQUAL TO
        0x2282, # G+745  U+2282  propersubset,  SUBSET OF
        0x2283, # G+746  U+2283  propersuperset,  SUPERSET OF
        0x222A, # G+747  U+222A  union,  UNION
        0x2229, # G+748  U+2229  intersection,  INTERSECTION
        0x2227, # G+749  U+2227  logicaland,  LOGICAL AND
        0x2228, # G+750  U+2228  logicalor,  LOGICAL OR
        0xFFE2, # G+751  U+FFE2  uniFFE2,  FULLWIDTH NOT SIGN
        0x21D2, # G+752  U+21D2  arrowdblright,  RIGHTWARDS DOUBLE ARROW
        0x21D4, # G+753  U+21D4  arrowdblboth,  LEFT RIGHT DOUBLE ARROW
        0x2200, # G+754  U+2200  universal,  FOR ALL
        0x2203, # G+755  U+2203  existential,  THERE EXISTS
        0x2220, # G+756  U+2220  angle,  ANGLE
        0x22A5, # G+757  U+22A5  perpendicular,  UP TACK
        0x0361, # G+758  U+0361  uni0361,  COMBINING DOUBLE INVERTED BREVE
        0x2202, # G+759  U+2202  partialdiff,  PARTIAL DIFFERENTIAL
        0x2207, # G+760  U+2207  gradient,  NABLA
        0x2261, # G+761  U+2261  equivalence,  IDENTICAL TO
        0x2252, # G+762  U+2252  uni2252,  APPROXIMATELY EQUAL TO OR THE IMAGE OF
        0x226A, # G+763  U+226A  uni226A,  MUCH LESS-THAN
        0x226B, # G+764  U+226B  uni226B,  MUCH GREATER-THAN
        0x221A, # G+765  U+221A  radical,  SQUARE ROOT
        0x223D, # G+766  U+223D  uni223D,  REVERSED TILDE
        0x221D, # G+767  U+221D  proportional,  PROPORTIONAL TO
        0x2235, # G+768  U+2235  uni2235,  BECAUSE
        0x222B, # G+769  U+222B  integral,  INTEGRAL
        0x222C, # G+770  U+222C  uni222C,  DOUBLE INTEGRAL
        0x212B, # G+771  U+212B  uni212B,  ANGSTROM SIGN
        0x2030, # G+772  U+2030  perthousand,  PER MILLE SIGN
        0x266F, # G+773  U+266F  uni266F,  MUSIC SHARP SIGN
        0x266D, # G+774  U+266D  uni266D,  MUSIC FLAT SIGN
        0x266A, # G+775  U+266A  musicalnote,  EIGHTH NOTE
        0x2020, # G+776  U+2020  dagger,  DAGGER
        0x2021, # G+777  U+2021  daggerdbl,  DOUBLE DAGGER
        0x00B6, # G+778  U+00B6  paragraph,  PILCROW SIGN
        0x20DD, # G+779  U+20DD  uni20DD,  COMBINING ENCLOSING CIRCLE
        0xFF10, # G+780  U+FF10  uniFF10,  FULLWIDTH DIGIT ZERO
        0xFF11, # G+781  U+FF11  uniFF11,  FULLWIDTH DIGIT ONE
        0xFF12, # G+782  U+FF12  uniFF12,  FULLWIDTH DIGIT TWO
        0xFF13, # G+783  U+FF13  uniFF13,  FULLWIDTH DIGIT THREE
        0xFF14, # G+784  U+FF14  uniFF14,  FULLWIDTH DIGIT FOUR
        0xFF15, # G+785  U+FF15  uniFF15,  FULLWIDTH DIGIT FIVE
        0xFF16, # G+786  U+FF16  uniFF16,  FULLWIDTH DIGIT SIX
        0xFF17, # G+787  U+FF17  uniFF17,  FULLWIDTH DIGIT SEVEN
        0xFF18, # G+788  U+FF18  uniFF18,  FULLWIDTH DIGIT EIGHT
        0xFF19, # G+789  U+FF19  uniFF19,  FULLWIDTH DIGIT NINE
        0xFF21, # G+790  U+FF21  uniFF21,  FULLWIDTH LATIN CAPITAL LETTER A
        0xFF22, # G+791  U+FF22  uniFF22,  FULLWIDTH LATIN CAPITAL LETTER B
        0xFF23, # G+792  U+FF23  uniFF23,  FULLWIDTH LATIN CAPITAL LETTER C
        0xFF24, # G+793  U+FF24  uniFF24,  FULLWIDTH LATIN CAPITAL LETTER D
        0xFF25, # G+794  U+FF25  uniFF25,  FULLWIDTH LATIN CAPITAL LETTER E
        0xFF26, # G+795  U+FF26  uniFF26,  FULLWIDTH LATIN CAPITAL LETTER F
        0xFF27, # G+796  U+FF27  uniFF27,  FULLWIDTH LATIN CAPITAL LETTER G
        0xFF28, # G+797  U+FF28  uniFF28,  FULLWIDTH LATIN CAPITAL LETTER H
        0xFF29, # G+798  U+FF29  uniFF29,  FULLWIDTH LATIN CAPITAL LETTER I
        0xFF2A, # G+799  U+FF2A  uniFF2A,  FULLWIDTH LATIN CAPITAL LETTER J
        0xFF2B, # G+800  U+FF2B  uniFF2B,  FULLWIDTH LATIN CAPITAL LETTER K
        0xFF2C, # G+801  U+FF2C  uniFF2C,  FULLWIDTH LATIN CAPITAL LETTER L
        0xFF2D, # G+802  U+FF2D  uniFF2D,  FULLWIDTH LATIN CAPITAL LETTER M
        0xFF2E, # G+803  U+FF2E  uniFF2E,  FULLWIDTH LATIN CAPITAL LETTER N
        0xFF2F, # G+804  U+FF2F  uniFF2F,  FULLWIDTH LATIN CAPITAL LETTER O
        0xFF30, # G+805  U+FF30  uniFF30,  FULLWIDTH LATIN CAPITAL LETTER P
        0xFF31, # G+806  U+FF31  uniFF31,  FULLWIDTH LATIN CAPITAL LETTER Q
        0xFF32, # G+807  U+FF32  uniFF32,  FULLWIDTH LATIN CAPITAL LETTER R
        0xFF33, # G+808  U+FF33  uniFF33,  FULLWIDTH LATIN CAPITAL LETTER S
        0xFF34, # G+809  U+FF34  uniFF34,  FULLWIDTH LATIN CAPITAL LETTER T
        0xFF35, # G+810  U+FF35  uniFF35,  FULLWIDTH LATIN CAPITAL LETTER U
        0xFF36, # G+811  U+FF36  uniFF36,  FULLWIDTH LATIN CAPITAL LETTER V
        0xFF37, # G+812  U+FF37  uniFF37,  FULLWIDTH LATIN CAPITAL LETTER W
        0xFF38, # G+813  U+FF38  uniFF38,  FULLWIDTH LATIN CAPITAL LETTER X
        0xFF39, # G+814  U+FF39  uniFF39,  FULLWIDTH LATIN CAPITAL LETTER Y
        0xFF3A, # G+815  U+FF3A  uniFF3A,  FULLWIDTH LATIN CAPITAL LETTER Z
        0xFF41, # G+816  U+FF41  uniFF41,  FULLWIDTH LATIN SMALL LETTER A
        0xFF42, # G+817  U+FF42  uniFF42,  FULLWIDTH LATIN SMALL LETTER B
        0xFF43, # G+818  U+FF43  uniFF43,  FULLWIDTH LATIN SMALL LETTER C
        0xFF44, # G+819  U+FF44  uniFF44,  FULLWIDTH LATIN SMALL LETTER D
        0xFF45, # G+820  U+FF45  uniFF45,  FULLWIDTH LATIN SMALL LETTER E
        0xFF46, # G+821  U+FF46  uniFF46,  FULLWIDTH LATIN SMALL LETTER F
        0xFF47, # G+822  U+FF47  uniFF47,  FULLWIDTH LATIN SMALL LETTER G
        0xFF48, # G+823  U+FF48  uniFF48,  FULLWIDTH LATIN SMALL LETTER H
        0xFF49, # G+824  U+FF49  uniFF49,  FULLWIDTH LATIN SMALL LETTER I
        0xFF4A, # G+825  U+FF4A  uniFF4A,  FULLWIDTH LATIN SMALL LETTER J
        0xFF4B, # G+826  U+FF4B  uniFF4B,  FULLWIDTH LATIN SMALL LETTER K
        0xFF4C, # G+827  U+FF4C  uniFF4C,  FULLWIDTH LATIN SMALL LETTER L
        0xFF4D, # G+828  U+FF4D  uniFF4D,  FULLWIDTH LATIN SMALL LETTER M
        0xFF4E, # G+829  U+FF4E  uniFF4E,  FULLWIDTH LATIN SMALL LETTER N
        0xFF4F, # G+830  U+FF4F  uniFF4F,  FULLWIDTH LATIN SMALL LETTER O
        0xFF50, # G+831  U+FF50  uniFF50,  FULLWIDTH LATIN SMALL LETTER P
        0xFF51, # G+832  U+FF51  uniFF51,  FULLWIDTH LATIN SMALL LETTER Q
        0xFF52, # G+833  U+FF52  uniFF52,  FULLWIDTH LATIN SMALL LETTER R
        0xFF53, # G+834  U+FF53  uniFF53,  FULLWIDTH LATIN SMALL LETTER S
        0xFF54, # G+835  U+FF54  uniFF54,  FULLWIDTH LATIN SMALL LETTER T
        0xFF55, # G+836  U+FF55  uniFF55,  FULLWIDTH LATIN SMALL LETTER U
        0xFF56, # G+837  U+FF56  uniFF56,  FULLWIDTH LATIN SMALL LETTER V
        0xFF57, # G+838  U+FF57  uniFF57,  FULLWIDTH LATIN SMALL LETTER W
        0xFF58, # G+839  U+FF58  uniFF58,  FULLWIDTH LATIN SMALL LETTER X
        0xFF59, # G+840  U+FF59  uniFF59,  FULLWIDTH LATIN SMALL LETTER Y
        0xFF5A, # G+841  U+FF5A  uniFF5A,  FULLWIDTH LATIN SMALL LETTER Z
        0x3041, # G+842  U+3041  uni3041,  HIRAGANA LETTER SMALL A
        0x3042, # G+843  U+3042  uni3042,  HIRAGANA LETTER A
        0x3043, # G+844  U+3043  uni3043,  HIRAGANA LETTER SMALL I
        0x3044, # G+845  U+3044  uni3044,  HIRAGANA LETTER I
        0x3045, # G+846  U+3045  uni3045,  HIRAGANA LETTER SMALL U
        0x3046, # G+847  U+3046  uni3046,  HIRAGANA LETTER U
        0x3047, # G+848  U+3047  uni3047,  HIRAGANA LETTER SMALL E
        0x3048, # G+849  U+3048  uni3048,  HIRAGANA LETTER E
        0x3049, # G+850  U+3049  uni3049,  HIRAGANA LETTER SMALL O
        0x304A, # G+851  U+304A  uni304A,  HIRAGANA LETTER O
        0x304B, # G+852  U+304B  uni304B,  HIRAGANA LETTER KA
        0x304C, # G+853  U+304C  uni304C,  HIRAGANA LETTER GA
        0x304D, # G+854  U+304D  uni304D,  HIRAGANA LETTER KI
        0x304E, # G+855  U+304E  uni304E,  HIRAGANA LETTER GI
        0x304F, # G+856  U+304F  uni304F,  HIRAGANA LETTER KU
        0x3050, # G+857  U+3050  uni3050,  HIRAGANA LETTER GU
        0x3051, # G+858  U+3051  uni3051,  HIRAGANA LETTER KE
        0x3052, # G+859  U+3052  uni3052,  HIRAGANA LETTER GE
        0x3053, # G+860  U+3053  uni3053,  HIRAGANA LETTER KO
        0x3054, # G+861  U+3054  uni3054,  HIRAGANA LETTER GO
        0x3055, # G+862  U+3055  uni3055,  HIRAGANA LETTER SA
        0x3056, # G+863  U+3056  uni3056,  HIRAGANA LETTER ZA
        0x3057, # G+864  U+3057  uni3057,  HIRAGANA LETTER SI
        0x3058, # G+865  U+3058  uni3058,  HIRAGANA LETTER ZI
        0x3059, # G+866  U+3059  uni3059,  HIRAGANA LETTER SU
        0x305A, # G+867  U+305A  uni305A,  HIRAGANA LETTER ZU
        0x305B, # G+868  U+305B  uni305B,  HIRAGANA LETTER SE
        0x305C, # G+869  U+305C  uni305C,  HIRAGANA LETTER ZE
        0x305D, # G+870  U+305D  uni305D,  HIRAGANA LETTER SO
        0x305E, # G+871  U+305E  uni305E,  HIRAGANA LETTER ZO
        0x305F, # G+872  U+305F  uni305F,  HIRAGANA LETTER TA
        0x3060, # G+873  U+3060  uni3060,  HIRAGANA LETTER DA
        0x3061, # G+874  U+3061  uni3061,  HIRAGANA LETTER TI
        0x3062, # G+875  U+3062  uni3062,  HIRAGANA LETTER DI
        0x3063, # G+876  U+3063  uni3063,  HIRAGANA LETTER SMALL TU
        0x3064, # G+877  U+3064  uni3064,  HIRAGANA LETTER TU
        0x3065, # G+878  U+3065  uni3065,  HIRAGANA LETTER DU
        0x3066, # G+879  U+3066  uni3066,  HIRAGANA LETTER TE
        0x3067, # G+880  U+3067  uni3067,  HIRAGANA LETTER DE
        0x3068, # G+881  U+3068  uni3068,  HIRAGANA LETTER TO
        0x3069, # G+882  U+3069  uni3069,  HIRAGANA LETTER DO
        0x306A, # G+883  U+306A  uni306A,  HIRAGANA LETTER NA
        0x306B, # G+884  U+306B  uni306B,  HIRAGANA LETTER NI
        0x306C, # G+885  U+306C  uni306C,  HIRAGANA LETTER NU
        0x306D, # G+886  U+306D  uni306D,  HIRAGANA LETTER NE
        0x306E, # G+887  U+306E  uni306E,  HIRAGANA LETTER NO
        0x306F, # G+888  U+306F  uni306F,  HIRAGANA LETTER HA
        0x3070, # G+889  U+3070  uni3070,  HIRAGANA LETTER BA
        0x3071, # G+890  U+3071  uni3071,  HIRAGANA LETTER PA
        0x3072, # G+891  U+3072  uni3072,  HIRAGANA LETTER HI
        0x3073, # G+892  U+3073  uni3073,  HIRAGANA LETTER BI
        0x3074, # G+893  U+3074  uni3074,  HIRAGANA LETTER PI
        0x3075, # G+894  U+3075  uni3075,  HIRAGANA LETTER HU
        0x3076, # G+895  U+3076  uni3076,  HIRAGANA LETTER BU
        0x3077, # G+896  U+3077  uni3077,  HIRAGANA LETTER PU
        0x3078, # G+897  U+3078  uni3078,  HIRAGANA LETTER HE
        0x3079, # G+898  U+3079  uni3079,  HIRAGANA LETTER BE
        0x307A, # G+899  U+307A  uni307A,  HIRAGANA LETTER PE
        0x307B, # G+900  U+307B  uni307B,  HIRAGANA LETTER HO
        0x307C, # G+901  U+307C  uni307C,  HIRAGANA LETTER BO
        0x307D, # G+902  U+307D  uni307D,  HIRAGANA LETTER PO
        0x307E, # G+903  U+307E  uni307E,  HIRAGANA LETTER MA
        0x307F, # G+904  U+307F  uni307F,  HIRAGANA LETTER MI
        0x3080, # G+905  U+3080  uni3080,  HIRAGANA LETTER MU
        0x3081, # G+906  U+3081  uni3081,  HIRAGANA LETTER ME
        0x3082, # G+907  U+3082  uni3082,  HIRAGANA LETTER MO
        0x3083, # G+908  U+3083  uni3083,  HIRAGANA LETTER SMALL YA
        0x3084, # G+909  U+3084  uni3084,  HIRAGANA LETTER YA
        0x3085, # G+910  U+3085  uni3085,  HIRAGANA LETTER SMALL YU
        0x3086, # G+911  U+3086  uni3086,  HIRAGANA LETTER YU
        0x3087, # G+912  U+3087  uni3087,  HIRAGANA LETTER SMALL YO
        0x3088, # G+913  U+3088  uni3088,  HIRAGANA LETTER YO
        0x3089, # G+914  U+3089  uni3089,  HIRAGANA LETTER RA
        0x308A, # G+915  U+308A  uni308A,  HIRAGANA LETTER RI
        0x308B, # G+916  U+308B  uni308B,  HIRAGANA LETTER RU
        0x308C, # G+917  U+308C  uni308C,  HIRAGANA LETTER RE
        0x308D, # G+918  U+308D  uni308D,  HIRAGANA LETTER RO
        0x308E, # G+919  U+308E  uni308E,  HIRAGANA LETTER SMALL WA
        0x308F, # G+920  U+308F  uni308F,  HIRAGANA LETTER WA
        0x3090, # G+921  U+3090  uni3090,  HIRAGANA LETTER WI
        0x3091, # G+922  U+3091  uni3091,  HIRAGANA LETTER WE
        0x3092, # G+923  U+3092  uni3092,  HIRAGANA LETTER WO
        0x3093, # G+924  U+3093  uni3093,  HIRAGANA LETTER N
        0x30A1, # G+925  U+30A1  uni30A1,  KATAKANA LETTER SMALL A
        0x30A2, # G+926  U+30A2  uni30A2,  KATAKANA LETTER A
        0x30A3, # G+927  U+30A3  uni30A3,  KATAKANA LETTER SMALL I
        0x30A4, # G+928  U+30A4  uni30A4,  KATAKANA LETTER I
        0x30A5, # G+929  U+30A5  uni30A5,  KATAKANA LETTER SMALL U
        0x30A6, # G+930  U+30A6  uni30A6,  KATAKANA LETTER U
        0x30A7, # G+931  U+30A7  uni30A7,  KATAKANA LETTER SMALL E
        0x30A8, # G+932  U+30A8  uni30A8,  KATAKANA LETTER E
        0x30A9, # G+933  U+30A9  uni30A9,  KATAKANA LETTER SMALL O
        0x30AA, # G+934  U+30AA  uni30AA,  KATAKANA LETTER O
        0x30AB, # G+935  U+30AB  uni30AB,  KATAKANA LETTER KA
        0x30AC, # G+936  U+30AC  uni30AC,  KATAKANA LETTER GA
        0x30AD, # G+937  U+30AD  uni30AD,  KATAKANA LETTER KI
        0x30AE, # G+938  U+30AE  uni30AE,  KATAKANA LETTER GI
        0x30AF, # G+939  U+30AF  uni30AF,  KATAKANA LETTER KU
        0x30B0, # G+940  U+30B0  uni30B0,  KATAKANA LETTER GU
        0x30B1, # G+941  U+30B1  uni30B1,  KATAKANA LETTER KE
        0x30B2, # G+942  U+30B2  uni30B2,  KATAKANA LETTER GE
        0x30B3, # G+943  U+30B3  uni30B3,  KATAKANA LETTER KO
        0x30B4, # G+944  U+30B4  uni30B4,  KATAKANA LETTER GO
        0x30B5, # G+945  U+30B5  uni30B5,  KATAKANA LETTER SA
        0x30B6, # G+946  U+30B6  uni30B6,  KATAKANA LETTER ZA
        0x30B7, # G+947  U+30B7  uni30B7,  KATAKANA LETTER SI
        0x30B8, # G+948  U+30B8  uni30B8,  KATAKANA LETTER ZI
        0x30B9, # G+949  U+30B9  uni30B9,  KATAKANA LETTER SU
        0x30BA, # G+950  U+30BA  uni30BA,  KATAKANA LETTER ZU
        0x30BB, # G+951  U+30BB  uni30BB,  KATAKANA LETTER SE
        0x30BC, # G+952  U+30BC  uni30BC,  KATAKANA LETTER ZE
        0x30BD, # G+953  U+30BD  uni30BD,  KATAKANA LETTER SO
        0x30BE, # G+954  U+30BE  uni30BE,  KATAKANA LETTER ZO
        0x30BF, # G+955  U+30BF  uni30BF,  KATAKANA LETTER TA
        0x30C0, # G+956  U+30C0  uni30C0,  KATAKANA LETTER DA
        0x30C1, # G+957  U+30C1  uni30C1,  KATAKANA LETTER TI
        0x30C2, # G+958  U+30C2  uni30C2,  KATAKANA LETTER DI
        0x30C3, # G+959  U+30C3  uni30C3,  KATAKANA LETTER SMALL TU
        0x30C4, # G+960  U+30C4  uni30C4,  KATAKANA LETTER TU
        0x30C5, # G+961  U+30C5  uni30C5,  KATAKANA LETTER DU
        0x30C6, # G+962  U+30C6  uni30C6,  KATAKANA LETTER TE
        0x30C7, # G+963  U+30C7  uni30C7,  KATAKANA LETTER DE
        0x30C8, # G+964  U+30C8  uni30C8,  KATAKANA LETTER TO
        0x30C9, # G+965  U+30C9  uni30C9,  KATAKANA LETTER DO
        0x30CA, # G+966  U+30CA  uni30CA,  KATAKANA LETTER NA
        0x30CB, # G+967  U+30CB  uni30CB,  KATAKANA LETTER NI
        0x30CC, # G+968  U+30CC  uni30CC,  KATAKANA LETTER NU
        0x30CD, # G+969  U+30CD  uni30CD,  KATAKANA LETTER NE
        0x30CE, # G+970  U+30CE  uni30CE,  KATAKANA LETTER NO
        0x30CF, # G+971  U+30CF  uni30CF,  KATAKANA LETTER HA
        0x30D0, # G+972  U+30D0  uni30D0,  KATAKANA LETTER BA
        0x30D1, # G+973  U+30D1  uni30D1,  KATAKANA LETTER PA
        0x30D2, # G+974  U+30D2  uni30D2,  KATAKANA LETTER HI
        0x30D3, # G+975  U+30D3  uni30D3,  KATAKANA LETTER BI
        0x30D4, # G+976  U+30D4  uni30D4,  KATAKANA LETTER PI
        0x30D5, # G+977  U+30D5  uni30D5,  KATAKANA LETTER HU
        0x30D6, # G+978  U+30D6  uni30D6,  KATAKANA LETTER BU
        0x30D7, # G+979  U+30D7  uni30D7,  KATAKANA LETTER PU
        0x30D8, # G+980  U+30D8  uni30D8,  KATAKANA LETTER HE
        0x30D9, # G+981  U+30D9  uni30D9,  KATAKANA LETTER BE
        0x30DA, # G+982  U+30DA  uni30DA,  KATAKANA LETTER PE
        0x30DB, # G+983  U+30DB  uni30DB,  KATAKANA LETTER HO
        0x30DC, # G+984  U+30DC  uni30DC,  KATAKANA LETTER BO
        0x30DD, # G+985  U+30DD  uni30DD,  KATAKANA LETTER PO
        0x30DE, # G+986  U+30DE  uni30DE,  KATAKANA LETTER MA
        0x30DF, # G+987  U+30DF  uni30DF,  KATAKANA LETTER MI
        0x30E0, # G+988  U+30E0  uni30E0,  KATAKANA LETTER MU
        0x30E1, # G+989  U+30E1  uni30E1,  KATAKANA LETTER ME
        0x30E2, # G+990  U+30E2  uni30E2,  KATAKANA LETTER MO
        0x30E3, # G+991  U+30E3  uni30E3,  KATAKANA LETTER SMALL YA
        0x30E4, # G+992  U+30E4  uni30E4,  KATAKANA LETTER YA
        0x30E5, # G+993  U+30E5  uni30E5,  KATAKANA LETTER SMALL YU
        0x30E6, # G+994  U+30E6  uni30E6,  KATAKANA LETTER YU
        0x30E7, # G+995  U+30E7  uni30E7,  KATAKANA LETTER SMALL YO
        0x30E8, # G+996  U+30E8  uni30E8,  KATAKANA LETTER YO
        0x30E9, # G+997  U+30E9  uni30E9,  KATAKANA LETTER RA
        0x30EA, # G+998  U+30EA  uni30EA,  KATAKANA LETTER RI
        0x30EB, # G+999  U+30EB  uni30EB,  KATAKANA LETTER RU
        0x30EC, # G+1000  U+30EC  uni30EC,  KATAKANA LETTER RE
        0x30ED, # G+1001  U+30ED  uni30ED,  KATAKANA LETTER RO
        0x30EE, # G+1002  U+30EE  uni30EE,  KATAKANA LETTER SMALL WA
        0x30EF, # G+1003  U+30EF  uni30EF,  KATAKANA LETTER WA
        0x30F0, # G+1004  U+30F0  uni30F0,  KATAKANA LETTER WI
        0x30F1, # G+1005  U+30F1  uni30F1,  KATAKANA LETTER WE
        0x30F2, # G+1006  U+30F2  uni30F2,  KATAKANA LETTER WO
        0x30F3, # G+1007  U+30F3  uni30F3,  KATAKANA LETTER N
        0x30F4, # G+1008  U+30F4  uni30F4,  KATAKANA LETTER VU
        0x30F5, # G+1009  U+30F5  uni30F5,  KATAKANA LETTER SMALL KA
        0x30F6, # G+1010  U+30F6  uni30F6,  KATAKANA LETTER SMALL KE
        0x0391, # G+1011  U+0391  Alpha,  GREEK CAPITAL LETTER ALPHA
        0x0392, # G+1012  U+0392  Beta,  GREEK CAPITAL LETTER BETA
        0x0393, # G+1013  U+0393  Gamma,  GREEK CAPITAL LETTER GAMMA
        0x0394, # G+1014  U+0394  Delta,  GREEK CAPITAL LETTER DELTA
        0x0395, # G+1015  U+0395  Epsilon,  GREEK CAPITAL LETTER EPSILON
        0x0396, # G+1016  U+0396  Zeta,  GREEK CAPITAL LETTER ZETA
        0x0397, # G+1017  U+0397  Eta,  GREEK CAPITAL LETTER ETA
        0x0398, # G+1018  U+0398  Theta,  GREEK CAPITAL LETTER THETA
        0x0399, # G+1019  U+0399  Iota,  GREEK CAPITAL LETTER IOTA
        0x039A, # G+1020  U+039A  Kappa,  GREEK CAPITAL LETTER KAPPA
        0x039B, # G+1021  U+039B  Lambda,  GREEK CAPITAL LETTER LAMDA
        0x039C, # G+1022  U+039C  Mu,  GREEK CAPITAL LETTER MU
        0x039D, # G+1023  U+039D  Nu,  GREEK CAPITAL LETTER NU
        0x039E, # G+1024  U+039E  Xi,  GREEK CAPITAL LETTER XI
        0x039F, # G+1025  U+039F  Omicron,  GREEK CAPITAL LETTER OMICRON
        0x03A0, # G+1026  U+03A0  Pi,  GREEK CAPITAL LETTER PI
        0x03A1, # G+1027  U+03A1  Rho,  GREEK CAPITAL LETTER RHO
        0x03A3, # G+1028  U+03A3  Sigma,  GREEK CAPITAL LETTER SIGMA
        0x03A4, # G+1029  U+03A4  Tau,  GREEK CAPITAL LETTER TAU
        0x03A5, # G+1030  U+03A5  Upsilon,  GREEK CAPITAL LETTER UPSILON
        0x03A6, # G+1031  U+03A6  Phi,  GREEK CAPITAL LETTER PHI
        0x03A7, # G+1032  U+03A7  Chi,  GREEK CAPITAL LETTER CHI
        0x03A8, # G+1033  U+03A8  Psi,  GREEK CAPITAL LETTER PSI
        0x03A9, # G+1034  U+03A9  Omega,  GREEK CAPITAL LETTER OMEGA
        0x03B1, # G+1035  U+03B1  alpha,  GREEK SMALL LETTER ALPHA
        0x03B2, # G+1036  U+03B2  beta,  GREEK SMALL LETTER BETA
        0x03B3, # G+1037  U+03B3  gamma,  GREEK SMALL LETTER GAMMA
        0x03B4, # G+1038  U+03B4  delta,  GREEK SMALL LETTER DELTA
        0x03B5, # G+1039  U+03B5  epsilon,  GREEK SMALL LETTER EPSILON
        0x03B6, # G+1040  U+03B6  zeta,  GREEK SMALL LETTER ZETA
        0x03B7, # G+1041  U+03B7  eta,  GREEK SMALL LETTER ETA
        0x03B8, # G+1042  U+03B8  theta,  GREEK SMALL LETTER THETA
        0x03B9, # G+1043  U+03B9  iota,  GREEK SMALL LETTER IOTA
        0x03BA, # G+1044  U+03BA  kappa,  GREEK SMALL LETTER KAPPA
        0x03BB, # G+1045  U+03BB  lambda,  GREEK SMALL LETTER LAMDA
        0x03BC, # G+1046  U+03BC  mu,  GREEK SMALL LETTER MU
        0x03BD, # G+1047  U+03BD  nu,  GREEK SMALL LETTER NU
        0x03BE, # G+1048  U+03BE  xi,  GREEK SMALL LETTER XI
        0x03BF, # G+1049  U+03BF  omicron,  GREEK SMALL LETTER OMICRON
        0x03C0, # G+1050  U+03C0  pi,  GREEK SMALL LETTER PI
        0x03C1, # G+1051  U+03C1  rho,  GREEK SMALL LETTER RHO
        0x03C3, # G+1052  U+03C3  sigma,  GREEK SMALL LETTER SIGMA
        0x03C4, # G+1053  U+03C4  tau,  GREEK SMALL LETTER TAU
        0x03C5, # G+1054  U+03C5  upsilon,  GREEK SMALL LETTER UPSILON
        0x03C6, # G+1055  U+03C6  phi,  GREEK SMALL LETTER PHI
        0x03C7, # G+1056  U+03C7  chi,  GREEK SMALL LETTER CHI
        0x03C8, # G+1057  U+03C8  psi,  GREEK SMALL LETTER PSI
        0x03C9, # G+1058  U+03C9  omega,  GREEK SMALL LETTER OMEGA
        0x0410, # G+1059  U+0410  afii10017,  CYRILLIC CAPITAL LETTER A
        0x0411, # G+1060  U+0411  afii10018,  CYRILLIC CAPITAL LETTER BE
        0x0412, # G+1061  U+0412  afii10019,  CYRILLIC CAPITAL LETTER VE
        0x0413, # G+1062  U+0413  afii10020,  CYRILLIC CAPITAL LETTER GHE
        0x0414, # G+1063  U+0414  afii10021,  CYRILLIC CAPITAL LETTER DE
        0x0415, # G+1064  U+0415  afii10022,  CYRILLIC CAPITAL LETTER IE
        0x0401, # G+1065  U+0401  afii10023,  CYRILLIC CAPITAL LETTER IO
        0x0416, # G+1066  U+0416  afii10024,  CYRILLIC CAPITAL LETTER ZHE
        0x0417, # G+1067  U+0417  afii10025,  CYRILLIC CAPITAL LETTER ZE
        0x0418, # G+1068  U+0418  afii10026,  CYRILLIC CAPITAL LETTER I
        0x0419, # G+1069  U+0419  afii10027,  CYRILLIC CAPITAL LETTER SHORT I
        0x041A, # G+1070  U+041A  afii10028,  CYRILLIC CAPITAL LETTER KA
        0x041B, # G+1071  U+041B  afii10029,  CYRILLIC CAPITAL LETTER EL
        0x041C, # G+1072  U+041C  afii10030,  CYRILLIC CAPITAL LETTER EM
        0x041D, # G+1073  U+041D  afii10031,  CYRILLIC CAPITAL LETTER EN
        0x041E, # G+1074  U+041E  afii10032,  CYRILLIC CAPITAL LETTER O
        0x041F, # G+1075  U+041F  afii10033,  CYRILLIC CAPITAL LETTER PE
        0x0420, # G+1076  U+0420  afii10034,  CYRILLIC CAPITAL LETTER ER
        0x0421, # G+1077  U+0421  afii10035,  CYRILLIC CAPITAL LETTER ES
        0x0422, # G+1078  U+0422  afii10036,  CYRILLIC CAPITAL LETTER TE
        0x0423, # G+1079  U+0423  afii10037,  CYRILLIC CAPITAL LETTER U
        0x0424, # G+1080  U+0424  afii10038,  CYRILLIC CAPITAL LETTER EF
        0x0425, # G+1081  U+0425  afii10039,  CYRILLIC CAPITAL LETTER HA
        0x0426, # G+1082  U+0426  afii10040,  CYRILLIC CAPITAL LETTER TSE
        0x0427, # G+1083  U+0427  afii10041,  CYRILLIC CAPITAL LETTER CHE
        0x0428, # G+1084  U+0428  afii10042,  CYRILLIC CAPITAL LETTER SHA
        0x0429, # G+1085  U+0429  afii10043,  CYRILLIC CAPITAL LETTER SHCHA
        0x042A, # G+1086  U+042A  afii10044,  CYRILLIC CAPITAL LETTER HARD SIGN
        0x042B, # G+1087  U+042B  afii10045,  CYRILLIC CAPITAL LETTER YERU
        0x042C, # G+1088  U+042C  afii10046,  CYRILLIC CAPITAL LETTER SOFT SIGN
        0x042D, # G+1089  U+042D  afii10047,  CYRILLIC CAPITAL LETTER E
        0x042E, # G+1090  U+042E  afii10048,  CYRILLIC CAPITAL LETTER YU
        0x042F, # G+1091  U+042F  afii10049,  CYRILLIC CAPITAL LETTER YA
        0x0430, # G+1092  U+0430  afii10065,  CYRILLIC SMALL LETTER A
        0x0431, # G+1093  U+0431  afii10066,  CYRILLIC SMALL LETTER BE
        0x0432, # G+1094  U+0432  afii10067,  CYRILLIC SMALL LETTER VE
        0x0433, # G+1095  U+0433  afii10068,  CYRILLIC SMALL LETTER GHE
        0x0434, # G+1096  U+0434  afii10069,  CYRILLIC SMALL LETTER DE
        0x0435, # G+1097  U+0435  afii10070,  CYRILLIC SMALL LETTER IE
        0x0451, # G+1098  U+0451  afii10071,  CYRILLIC SMALL LETTER IO
        0x0436, # G+1099  U+0436  afii10072,  CYRILLIC SMALL LETTER ZHE
        0x0437, # G+1100  U+0437  afii10073,  CYRILLIC SMALL LETTER ZE
        0x0438, # G+1101  U+0438  afii10074,  CYRILLIC SMALL LETTER I
        0x0439, # G+1102  U+0439  afii10075,  CYRILLIC SMALL LETTER SHORT I
        0x043A, # G+1103  U+043A  afii10076,  CYRILLIC SMALL LETTER KA
        0x043B, # G+1104  U+043B  afii10077,  CYRILLIC SMALL LETTER EL
        0x043C, # G+1105  U+043C  afii10078,  CYRILLIC SMALL LETTER EM
        0x043D, # G+1106  U+043D  afii10079,  CYRILLIC SMALL LETTER EN
        0x043E, # G+1107  U+043E  afii10080,  CYRILLIC SMALL LETTER O
        0x043F, # G+1108  U+043F  afii10081,  CYRILLIC SMALL LETTER PE
        0x0440, # G+1109  U+0440  afii10082,  CYRILLIC SMALL LETTER ER
        0x0441, # G+1110  U+0441  afii10083,  CYRILLIC SMALL LETTER ES
        0x0442, # G+1111  U+0442  afii10084,  CYRILLIC SMALL LETTER TE
        0x0443, # G+1112  U+0443  afii10085,  CYRILLIC SMALL LETTER U
        0x0444, # G+1113  U+0444  afii10086,  CYRILLIC SMALL LETTER EF
        0x0445, # G+1114  U+0445  afii10087,  CYRILLIC SMALL LETTER HA
        0x0446, # G+1115  U+0446  afii10088,  CYRILLIC SMALL LETTER TSE
        0x0447, # G+1116  U+0447  afii10089,  CYRILLIC SMALL LETTER CHE
        0x0448, # G+1117  U+0448  afii10090,  CYRILLIC SMALL LETTER SHA
        0x0449, # G+1118  U+0449  afii10091,  CYRILLIC SMALL LETTER SHCHA
        0x044A, # G+1119  U+044A  afii10092,  CYRILLIC SMALL LETTER HARD SIGN
        0x044B, # G+1120  U+044B  afii10093,  CYRILLIC SMALL LETTER YERU
        0x044C, # G+1121  U+044C  afii10094,  CYRILLIC SMALL LETTER SOFT SIGN
        0x044D, # G+1122  U+044D  afii10095,  CYRILLIC SMALL LETTER E
        0x044E, # G+1123  U+044E  afii10096,  CYRILLIC SMALL LETTER YU
        0x044F, # G+1124  U+044F  afii10097,  CYRILLIC SMALL LETTER YA
        0x4E9C, # G+1125  U+4E9C  uni4E9C,  CJK UNIFIED IDEOGRAPH-4E9C
        0x5516, # G+1126  U+5516  uni5516,  CJK UNIFIED IDEOGRAPH-5516
        0x5A03, # G+1127  U+5A03  uni5A03,  CJK UNIFIED IDEOGRAPH-5A03
        0x963F, # G+1128  U+963F  uni963F,  CJK UNIFIED IDEOGRAPH-963F
        0x54C0, # G+1129  U+54C0  uni54C0,  CJK UNIFIED IDEOGRAPH-54C0
        0x611B, # G+1130  U+611B  uni611B,  CJK UNIFIED IDEOGRAPH-611B
        0x6328, # G+1131  U+6328  uni6328,  CJK UNIFIED IDEOGRAPH-6328
        0x59F6, # G+1132  U+59F6  uni59F6,  CJK UNIFIED IDEOGRAPH-59F6
        0x9022, # G+1133  U+9022  uni9022,  CJK UNIFIED IDEOGRAPH-9022
        0x8475, # G+1134  U+8475  uni8475,  CJK UNIFIED IDEOGRAPH-8475
        0x831C, # G+1135  U+831C  uni831C,  CJK UNIFIED IDEOGRAPH-831C
        0x7A50, # G+1136  U+7A50  uni7A50,  CJK UNIFIED IDEOGRAPH-7A50
        0x60AA, # G+1137  U+60AA  uni60AA,  CJK UNIFIED IDEOGRAPH-60AA
        0x63E1, # G+1138  U+63E1  uni63E1,  CJK UNIFIED IDEOGRAPH-63E1
        0x6E25, # G+1139  U+6E25  uni6E25,  CJK UNIFIED IDEOGRAPH-6E25
        0x65ED, # G+1140  U+65ED  uni65ED,  CJK UNIFIED IDEOGRAPH-65ED
        0x8466, # G+1141  U+8466  uni8466,  CJK UNIFIED IDEOGRAPH-8466
        0x82A6, # G+1142  U+82A6  uni82A6,  CJK UNIFIED IDEOGRAPH-82A6
        0x9BF5, # G+1143  U+9BF5  uni9BF5,  CJK UNIFIED IDEOGRAPH-9BF5
        0x6893, # G+1144  U+6893  uni6893,  CJK UNIFIED IDEOGRAPH-6893
        0x5727, # G+1145  U+5727  uni5727,  CJK UNIFIED IDEOGRAPH-5727
        0x65A1, # G+1146  U+65A1  uni65A1,  CJK UNIFIED IDEOGRAPH-65A1
        0x6271, # G+1147  U+6271  uni6271,  CJK UNIFIED IDEOGRAPH-6271
        0x5B9B, # G+1148  U+5B9B  uni5B9B,  CJK UNIFIED IDEOGRAPH-5B9B
        0x59D0, # G+1149  U+59D0  uni59D0,  CJK UNIFIED IDEOGRAPH-59D0
        0x867B, # G+1150  U+867B  uni867B,  CJK UNIFIED IDEOGRAPH-867B
        0x98F4, # G+1151  U+98F4  uni98F4,  CJK UNIFIED IDEOGRAPH-98F4
        0x7D62, # G+1152  U+7D62  uni7D62,  CJK UNIFIED IDEOGRAPH-7D62
        0x7DBE, # G+1153  U+7DBE  uni7DBE,  CJK UNIFIED IDEOGRAPH-7DBE
        0x9B8E, # G+1154  U+9B8E  uni9B8E,  CJK UNIFIED IDEOGRAPH-9B8E
        0x6216, # G+1155  U+6216  uni6216,  CJK UNIFIED IDEOGRAPH-6216
        0x7C9F, # G+1156  U+7C9F  uni7C9F,  CJK UNIFIED IDEOGRAPH-7C9F
        0x88B7, # G+1157  U+88B7  uni88B7,  CJK UNIFIED IDEOGRAPH-88B7
        0x5B89, # G+1158  U+5B89  uni5B89,  CJK UNIFIED IDEOGRAPH-5B89
        0x5EB5, # G+1159  U+5EB5  uni5EB5,  CJK UNIFIED IDEOGRAPH-5EB5
        0x6309, # G+1160  U+6309  uni6309,  CJK UNIFIED IDEOGRAPH-6309
        0x6697, # G+1161  U+6697  uni6697,  CJK UNIFIED IDEOGRAPH-6697
        0x6848, # G+1162  U+6848  uni6848,  CJK UNIFIED IDEOGRAPH-6848
        0x95C7, # G+1163  U+95C7  uni95C7,  CJK UNIFIED IDEOGRAPH-95C7
        0x978D, # G+1164  U+978D  uni978D,  CJK UNIFIED IDEOGRAPH-978D
        0x674F, # G+1165  U+674F  uni674F,  CJK UNIFIED IDEOGRAPH-674F
        0x4EE5, # G+1166  U+4EE5  uni4EE5,  CJK UNIFIED IDEOGRAPH-4EE5
        0x4F0A, # G+1167  U+4F0A  uni4F0A,  CJK UNIFIED IDEOGRAPH-4F0A
        0x4F4D, # G+1168  U+4F4D  uni4F4D,  CJK UNIFIED IDEOGRAPH-4F4D
        0x4F9D, # G+1169  U+4F9D  uni4F9D,  CJK UNIFIED IDEOGRAPH-4F9D
        0x5049, # G+1170  U+5049  uni5049,  CJK UNIFIED IDEOGRAPH-5049
        0x56F2, # G+1171  U+56F2  uni56F2,  CJK UNIFIED IDEOGRAPH-56F2
        0x5937, # G+1172  U+5937  uni5937,  CJK UNIFIED IDEOGRAPH-5937
        0x59D4, # G+1173  U+59D4  uni59D4,  CJK UNIFIED IDEOGRAPH-59D4
        0x5A01, # G+1174  U+5A01  uni5A01,  CJK UNIFIED IDEOGRAPH-5A01
        0x5C09, # G+1175  U+5C09  uni5C09,  CJK UNIFIED IDEOGRAPH-5C09
        0x60DF, # G+1176  U+60DF  uni60DF,  CJK UNIFIED IDEOGRAPH-60DF
        0x610F, # G+1177  U+610F  uni610F,  CJK UNIFIED IDEOGRAPH-610F
        0x6170, # G+1178  U+6170  uni6170,  CJK UNIFIED IDEOGRAPH-6170
        0x6613, # G+1179  U+6613  uni6613,  CJK UNIFIED IDEOGRAPH-6613
        0x6905, # G+1180  U+6905  uni6905,  CJK UNIFIED IDEOGRAPH-6905
        0x70BA, # G+1181  U+70BA  uni70BA,  CJK UNIFIED IDEOGRAPH-70BA
        0x754F, # G+1182  U+754F  uni754F,  CJK UNIFIED IDEOGRAPH-754F
        0x7570, # G+1183  U+7570  uni7570,  CJK UNIFIED IDEOGRAPH-7570
        0x79FB, # G+1184  U+79FB  uni79FB,  CJK UNIFIED IDEOGRAPH-79FB
        0x7DAD, # G+1185  U+7DAD  uni7DAD,  CJK UNIFIED IDEOGRAPH-7DAD
        0x7DEF, # G+1186  U+7DEF  uni7DEF,  CJK UNIFIED IDEOGRAPH-7DEF
        0x80C3, # G+1187  U+80C3  uni80C3,  CJK UNIFIED IDEOGRAPH-80C3
        0x840E, # G+1188  U+840E  uni840E,  CJK UNIFIED IDEOGRAPH-840E
        0x2F90, # G+1189  U+2F90  uni2F90,  KANGXI RADICAL CLOTHES
        0x8B02, # G+1190  U+8B02  uni8B02,  CJK UNIFIED IDEOGRAPH-8B02
        0x9055, # G+1191  U+9055  uni9055,  CJK UNIFIED IDEOGRAPH-9055
        0x907A, # G+1192  U+907A  uni907A,  CJK UNIFIED IDEOGRAPH-907A
        0x533B, # G+1193  U+533B  uni533B,  CJK UNIFIED IDEOGRAPH-533B
        0x4E95, # G+1194  U+4E95  uni4E95,  CJK UNIFIED IDEOGRAPH-4E95
        0x4EA5, # G+1195  U+4EA5  uni4EA5,  CJK UNIFIED IDEOGRAPH-4EA5
        0x57DF, # G+1196  U+57DF  uni57DF,  CJK UNIFIED IDEOGRAPH-57DF
        0x80B2, # G+1197  U+80B2  uni80B2,  CJK UNIFIED IDEOGRAPH-80B2
        0x90C1, # G+1198  U+90C1  uni90C1,  CJK UNIFIED IDEOGRAPH-90C1
        0x78EF, # G+1199  U+78EF  uni78EF,  CJK UNIFIED IDEOGRAPH-78EF
        0x2F00, # G+1200  U+2F00  uni2F00,  KANGXI RADICAL ONE
        0x58F1, # G+1201  U+58F1  uni58F1,  CJK UNIFIED IDEOGRAPH-58F1
        0x6EA2, # G+1202  U+6EA2  uni6EA2,  CJK UNIFIED IDEOGRAPH-6EA2
        0x9038, # G+1203  U+9038  uni9038,  CJK UNIFIED IDEOGRAPH-9038
        0x7A32, # G+1204  U+7A32  uni7A32,  CJK UNIFIED IDEOGRAPH-7A32
        0x8328, # G+1205  U+8328  uni8328,  CJK UNIFIED IDEOGRAPH-8328
        0x828B, # G+1206  U+828B  uni828B,  CJK UNIFIED IDEOGRAPH-828B
        0x9C2F, # G+1207  U+9C2F  uni9C2F,  CJK UNIFIED IDEOGRAPH-9C2F
        0x5141, # G+1208  U+5141  uni5141,  CJK UNIFIED IDEOGRAPH-5141
        0x5370, # G+1209  U+5370  uni5370,  CJK UNIFIED IDEOGRAPH-5370
        0x54BD, # G+1210  U+54BD  uni54BD,  CJK UNIFIED IDEOGRAPH-54BD
        0x54E1, # G+1211  U+54E1  uni54E1,  CJK UNIFIED IDEOGRAPH-54E1
        0x56E0, # G+1212  U+56E0  uni56E0,  CJK UNIFIED IDEOGRAPH-56E0
        0x59FB, # G+1213  U+59FB  uni59FB,  CJK UNIFIED IDEOGRAPH-59FB
        0x5F15, # G+1214  U+5F15  uni5F15,  CJK UNIFIED IDEOGRAPH-5F15
        0x98F2, # G+1215  U+98F2  uni98F2,  CJK UNIFIED IDEOGRAPH-98F2
        0x6DEB, # G+1216  U+6DEB  uni6DEB,  CJK UNIFIED IDEOGRAPH-6DEB
        0x80E4, # G+1217  U+80E4  uni80E4,  CJK UNIFIED IDEOGRAPH-80E4
        0x852D, # G+1218  U+852D  uni852D,  CJK UNIFIED IDEOGRAPH-852D
        0x9662, # G+1219  U+9662  uni9662,  CJK UNIFIED IDEOGRAPH-9662
        0x9670, # G+1220  U+9670  uni9670,  CJK UNIFIED IDEOGRAPH-9670
        0x96A0, # G+1221  U+96A0  uni96A0,  CJK UNIFIED IDEOGRAPH-96A0
        0x97FB, # G+1222  U+97FB  uni97FB,  CJK UNIFIED IDEOGRAPH-97FB
        0x540B, # G+1223  U+540B  uni540B,  CJK UNIFIED IDEOGRAPH-540B
        0x53F3, # G+1224  U+53F3  uni53F3,  CJK UNIFIED IDEOGRAPH-53F3
        0x5B87, # G+1225  U+5B87  uni5B87,  CJK UNIFIED IDEOGRAPH-5B87
        0x70CF, # G+1226  U+70CF  uni70CF,  CJK UNIFIED IDEOGRAPH-70CF
        0x2F7B, # G+1227  U+2F7B  uni2F7B,  KANGXI RADICAL FEATHER
        0x8FC2, # G+1228  U+8FC2  uni8FC2,  CJK UNIFIED IDEOGRAPH-8FC2
        0x2FAC, # G+1229  U+2FAC  uni2FAC,  KANGXI RADICAL RAIN
        0x536F, # G+1230  U+536F  uni536F,  CJK UNIFIED IDEOGRAPH-536F
        0x9D5C, # G+1231  U+9D5C  uni9D5C,  CJK UNIFIED IDEOGRAPH-9D5C
        0x7ABA, # G+1232  U+7ABA  uni7ABA,  CJK UNIFIED IDEOGRAPH-7ABA
        0x4E11, # G+1233  U+4E11  uni4E11,  CJK UNIFIED IDEOGRAPH-4E11
        0x7893, # G+1234  U+7893  uni7893,  CJK UNIFIED IDEOGRAPH-7893
        0x2F85, # G+1235  U+2F85  uni2F85,  KANGXI RADICAL MORTAR
        0x6E26, # G+1236  U+6E26  uni6E26,  CJK UNIFIED IDEOGRAPH-6E26
        0x5618, # G+1237  U+5618  uni5618,  CJK UNIFIED IDEOGRAPH-5618
        0x5504, # G+1238  U+5504  uni5504,  CJK UNIFIED IDEOGRAPH-5504
        0x6B1D, # G+1239  U+6B1D  uni6B1D,  CJK UNIFIED IDEOGRAPH-6B1D
        0x851A, # G+1240  U+851A  uni851A,  CJK UNIFIED IDEOGRAPH-851A
        0x9C3B, # G+1241  U+9C3B  uni9C3B,  CJK UNIFIED IDEOGRAPH-9C3B
        0x59E5, # G+1242  U+59E5  uni59E5,  CJK UNIFIED IDEOGRAPH-59E5
        0x53A9, # G+1243  U+53A9  uni53A9,  CJK UNIFIED IDEOGRAPH-53A9
        0x6D66, # G+1244  U+6D66  uni6D66,  CJK UNIFIED IDEOGRAPH-6D66
        0x2F60, # G+1245  U+2F60  uni2F60,  KANGXI RADICAL MELON
        0x958F, # G+1246  U+958F  uni958F,  CJK UNIFIED IDEOGRAPH-958F
        0x5642, # G+1247  U+5642  uni5642,  CJK UNIFIED IDEOGRAPH-5642
        0x4E91, # G+1248  U+4E91  uni4E91,  CJK UNIFIED IDEOGRAPH-4E91
        0x904B, # G+1249  U+904B  uni904B,  CJK UNIFIED IDEOGRAPH-904B
        0x96F2, # G+1250  U+96F2  uni96F2,  CJK UNIFIED IDEOGRAPH-96F2
        0x834F, # G+1251  U+834F  uni834F,  CJK UNIFIED IDEOGRAPH-834F
        0x990C, # G+1252  U+990C  uni990C,  CJK UNIFIED IDEOGRAPH-990C
        0x53E1, # G+1253  U+53E1  uni53E1,  CJK UNIFIED IDEOGRAPH-53E1
        0x55B6, # G+1254  U+55B6  uni55B6,  CJK UNIFIED IDEOGRAPH-55B6
        0x5B30, # G+1255  U+5B30  uni5B30,  CJK UNIFIED IDEOGRAPH-5B30
        0x5F71, # G+1256  U+5F71  uni5F71,  CJK UNIFIED IDEOGRAPH-5F71
        0x6620, # G+1257  U+6620  uni6620,  CJK UNIFIED IDEOGRAPH-6620
        0x66F3, # G+1258  U+66F3  uni66F3,  CJK UNIFIED IDEOGRAPH-66F3
        0x6804, # G+1259  U+6804  uni6804,  CJK UNIFIED IDEOGRAPH-6804
        0x6C38, # G+1260  U+6C38  uni6C38,  CJK UNIFIED IDEOGRAPH-6C38
        0x6CF3, # G+1261  U+6CF3  uni6CF3,  CJK UNIFIED IDEOGRAPH-6CF3
        0x6D29, # G+1262  U+6D29  uni6D29,  CJK UNIFIED IDEOGRAPH-6D29
        0x745B, # G+1263  U+745B  uni745B,  CJK UNIFIED IDEOGRAPH-745B
        0x76C8, # G+1264  U+76C8  uni76C8,  CJK UNIFIED IDEOGRAPH-76C8
        0x7A4E, # G+1265  U+7A4E  uni7A4E,  CJK UNIFIED IDEOGRAPH-7A4E
        0x9834, # G+1266  U+9834  uni9834,  CJK UNIFIED IDEOGRAPH-9834
        0x82F1, # G+1267  U+82F1  uni82F1,  CJK UNIFIED IDEOGRAPH-82F1
        0x885B, # G+1268  U+885B  uni885B,  CJK UNIFIED IDEOGRAPH-885B
        0x8A60, # G+1269  U+8A60  uni8A60,  CJK UNIFIED IDEOGRAPH-8A60
        0x92ED, # G+1270  U+92ED  uni92ED,  CJK UNIFIED IDEOGRAPH-92ED
        0x6DB2, # G+1271  U+6DB2  uni6DB2,  CJK UNIFIED IDEOGRAPH-6DB2
        0x75AB, # G+1272  U+75AB  uni75AB,  CJK UNIFIED IDEOGRAPH-75AB
        0x76CA, # G+1273  U+76CA  uni76CA,  CJK UNIFIED IDEOGRAPH-76CA
        0x99C5, # G+1274  U+99C5  uni99C5,  CJK UNIFIED IDEOGRAPH-99C5
        0x60A6, # G+1275  U+60A6  uni60A6,  CJK UNIFIED IDEOGRAPH-60A6
        0x8B01, # G+1276  U+8B01  uni8B01,  CJK UNIFIED IDEOGRAPH-8B01
        0x8D8A, # G+1277  U+8D8A  uni8D8A,  CJK UNIFIED IDEOGRAPH-8D8A
        0x95B2, # G+1278  U+95B2  uni95B2,  CJK UNIFIED IDEOGRAPH-95B2
        0x698E, # G+1279  U+698E  uni698E,  CJK UNIFIED IDEOGRAPH-698E
        0x53AD, # G+1280  U+53AD  uni53AD,  CJK UNIFIED IDEOGRAPH-53AD
        0x5186, # G+1281  U+5186  uni5186,  CJK UNIFIED IDEOGRAPH-5186
        0x5712, # G+1282  U+5712  uni5712,  CJK UNIFIED IDEOGRAPH-5712
        0x5830, # G+1283  U+5830  uni5830,  CJK UNIFIED IDEOGRAPH-5830
        0x5944, # G+1284  U+5944  uni5944,  CJK UNIFIED IDEOGRAPH-5944
        0x5BB4, # G+1285  U+5BB4  uni5BB4,  CJK UNIFIED IDEOGRAPH-5BB4
        0x5EF6, # G+1286  U+5EF6  uni5EF6,  CJK UNIFIED IDEOGRAPH-5EF6
        0x6028, # G+1287  U+6028  uni6028,  CJK UNIFIED IDEOGRAPH-6028
        0x63A9, # G+1288  U+63A9  uni63A9,  CJK UNIFIED IDEOGRAPH-63A9
        0x63F4, # G+1289  U+63F4  uni63F4,  CJK UNIFIED IDEOGRAPH-63F4
        0x6CBF, # G+1290  U+6CBF  uni6CBF,  CJK UNIFIED IDEOGRAPH-6CBF
        0x6F14, # G+1291  U+6F14  uni6F14,  CJK UNIFIED IDEOGRAPH-6F14
        0x708E, # G+1292  U+708E  uni708E,  CJK UNIFIED IDEOGRAPH-708E
        0x7114, # G+1293  U+7114  uni7114,  CJK UNIFIED IDEOGRAPH-7114
        0x7159, # G+1294  U+7159  uni7159,  CJK UNIFIED IDEOGRAPH-7159
        0x71D5, # G+1295  U+71D5  uni71D5,  CJK UNIFIED IDEOGRAPH-71D5
        0x733F, # G+1296  U+733F  uni733F,  CJK UNIFIED IDEOGRAPH-733F
        0x7E01, # G+1297  U+7E01  uni7E01,  CJK UNIFIED IDEOGRAPH-7E01
        0x8276, # G+1298  U+8276  uni8276,  CJK UNIFIED IDEOGRAPH-8276
        0x82D1, # G+1299  U+82D1  uni82D1,  CJK UNIFIED IDEOGRAPH-82D1
        0x8597, # G+1300  U+8597  uni8597,  CJK UNIFIED IDEOGRAPH-8597
        0x9060, # G+1301  U+9060  uni9060,  CJK UNIFIED IDEOGRAPH-9060
        0x925B, # G+1302  U+925B  uni925B,  CJK UNIFIED IDEOGRAPH-925B
        0x9D1B, # G+1303  U+9D1B  uni9D1B,  CJK UNIFIED IDEOGRAPH-9D1B
        0x5869, # G+1304  U+5869  uni5869,  CJK UNIFIED IDEOGRAPH-5869
        0x65BC, # G+1305  U+65BC  uni65BC,  CJK UNIFIED IDEOGRAPH-65BC
        0x6C5A, # G+1306  U+6C5A  uni6C5A,  CJK UNIFIED IDEOGRAPH-6C5A
        0x7525, # G+1307  U+7525  uni7525,  CJK UNIFIED IDEOGRAPH-7525
        0x51F9, # G+1308  U+51F9  uni51F9,  CJK UNIFIED IDEOGRAPH-51F9
        0x592E, # G+1309  U+592E  uni592E,  CJK UNIFIED IDEOGRAPH-592E
        0x5965, # G+1310  U+5965  uni5965,  CJK UNIFIED IDEOGRAPH-5965
        0x5F80, # G+1311  U+5F80  uni5F80,  CJK UNIFIED IDEOGRAPH-5F80
        0x5FDC, # G+1312  U+5FDC  uni5FDC,  CJK UNIFIED IDEOGRAPH-5FDC
        0x62BC, # G+1313  U+62BC  uni62BC,  CJK UNIFIED IDEOGRAPH-62BC
        0x65FA, # G+1314  U+65FA  uni65FA,  CJK UNIFIED IDEOGRAPH-65FA
        0x6A2A, # G+1315  U+6A2A  uni6A2A,  CJK UNIFIED IDEOGRAPH-6A2A
        0x6B27, # G+1316  U+6B27  uni6B27,  CJK UNIFIED IDEOGRAPH-6B27
        0x6BB4, # G+1317  U+6BB4  uni6BB4,  CJK UNIFIED IDEOGRAPH-6BB4
        0x738B, # G+1318  U+738B  uni738B,  CJK UNIFIED IDEOGRAPH-738B
        0x7FC1, # G+1319  U+7FC1  uni7FC1,  CJK UNIFIED IDEOGRAPH-7FC1
        0x8956, # G+1320  U+8956  uni8956,  CJK UNIFIED IDEOGRAPH-8956
        0x9D2C, # G+1321  U+9D2C  uni9D2C,  CJK UNIFIED IDEOGRAPH-9D2C
        0x9D0E, # G+1322  U+9D0E  uni9D0E,  CJK UNIFIED IDEOGRAPH-9D0E
        0x2EE9, # G+1323  U+2EE9  uni2EE9,  CJK RADICAL SIMPLIFIED YELLOW
        0x5CA1, # G+1324  U+5CA1  uni5CA1,  CJK UNIFIED IDEOGRAPH-5CA1
        0x6C96, # G+1325  U+6C96  uni6C96,  CJK UNIFIED IDEOGRAPH-6C96
        0x837B, # G+1326  U+837B  uni837B,  CJK UNIFIED IDEOGRAPH-837B
        0x5104, # G+1327  U+5104  uni5104,  CJK UNIFIED IDEOGRAPH-5104
        0x5C4B, # G+1328  U+5C4B  uni5C4B,  CJK UNIFIED IDEOGRAPH-5C4B
        0x61B6, # G+1329  U+61B6  uni61B6,  CJK UNIFIED IDEOGRAPH-61B6
        0x81C6, # G+1330  U+81C6  uni81C6,  CJK UNIFIED IDEOGRAPH-81C6
        0x6876, # G+1331  U+6876  uni6876,  CJK UNIFIED IDEOGRAPH-6876
        0x7261, # G+1332  U+7261  uni7261,  CJK UNIFIED IDEOGRAPH-7261
        0x2F04, # G+1333  U+2F04  uni2F04,  KANGXI RADICAL SECOND
        0x4FFA, # G+1334  U+4FFA  uni4FFA,  CJK UNIFIED IDEOGRAPH-4FFA
        0x5378, # G+1335  U+5378  uni5378,  CJK UNIFIED IDEOGRAPH-5378
        0x6069, # G+1336  U+6069  uni6069,  CJK UNIFIED IDEOGRAPH-6069
        0x6E29, # G+1337  U+6E29  uni6E29,  CJK UNIFIED IDEOGRAPH-6E29
        0x7A4F, # G+1338  U+7A4F  uni7A4F,  CJK UNIFIED IDEOGRAPH-7A4F
        0x2FB3, # G+1339  U+2FB3  uni2FB3,  KANGXI RADICAL SOUND
        0x4E0B, # G+1340  U+4E0B  uni4E0B,  CJK UNIFIED IDEOGRAPH-4E0B
        0x5316, # G+1341  U+5316  uni5316,  CJK UNIFIED IDEOGRAPH-5316
        0x4EEE, # G+1342  U+4EEE  uni4EEE,  CJK UNIFIED IDEOGRAPH-4EEE
        0x4F55, # G+1343  U+4F55  uni4F55,  CJK UNIFIED IDEOGRAPH-4F55
        0x4F3D, # G+1344  U+4F3D  uni4F3D,  CJK UNIFIED IDEOGRAPH-4F3D
        0x4FA1, # G+1345  U+4FA1  uni4FA1,  CJK UNIFIED IDEOGRAPH-4FA1
        0x4F73, # G+1346  U+4F73  uni4F73,  CJK UNIFIED IDEOGRAPH-4F73
        0x52A0, # G+1347  U+52A0  uni52A0,  CJK UNIFIED IDEOGRAPH-52A0
        0x53EF, # G+1348  U+53EF  uni53EF,  CJK UNIFIED IDEOGRAPH-53EF
        0x5609, # G+1349  U+5609  uni5609,  CJK UNIFIED IDEOGRAPH-5609
        0x590F, # G+1350  U+590F  uni590F,  CJK UNIFIED IDEOGRAPH-590F
        0x5AC1, # G+1351  U+5AC1  uni5AC1,  CJK UNIFIED IDEOGRAPH-5AC1
        0x5BB6, # G+1352  U+5BB6  uni5BB6,  CJK UNIFIED IDEOGRAPH-5BB6
        0x5BE1, # G+1353  U+5BE1  uni5BE1,  CJK UNIFIED IDEOGRAPH-5BE1
        0x79D1, # G+1354  U+79D1  uni79D1,  CJK UNIFIED IDEOGRAPH-79D1
        0x6687, # G+1355  U+6687  uni6687,  CJK UNIFIED IDEOGRAPH-6687
        0x679C, # G+1356  U+679C  uni679C,  CJK UNIFIED IDEOGRAPH-679C
        0x67B6, # G+1357  U+67B6  uni67B6,  CJK UNIFIED IDEOGRAPH-67B6
        0x6B4C, # G+1358  U+6B4C  uni6B4C,  CJK UNIFIED IDEOGRAPH-6B4C
        0x6CB3, # G+1359  U+6CB3  uni6CB3,  CJK UNIFIED IDEOGRAPH-6CB3
        0x2F55, # G+1360  U+2F55  uni2F55,  KANGXI RADICAL FIRE
        0x73C2, # G+1361  U+73C2  uni73C2,  CJK UNIFIED IDEOGRAPH-73C2
        0x798D, # G+1362  U+798D  uni798D,  CJK UNIFIED IDEOGRAPH-798D
        0x2F72, # G+1363  U+2F72  uni2F72,  KANGXI RADICAL GRAIN
        0x7A3C, # G+1364  U+7A3C  uni7A3C,  CJK UNIFIED IDEOGRAPH-7A3C
        0x7B87, # G+1365  U+7B87  uni7B87,  CJK UNIFIED IDEOGRAPH-7B87
        0x82B1, # G+1366  U+82B1  uni82B1,  CJK UNIFIED IDEOGRAPH-82B1
        0x82DB, # G+1367  U+82DB  uni82DB,  CJK UNIFIED IDEOGRAPH-82DB
        0x8304, # G+1368  U+8304  uni8304,  CJK UNIFIED IDEOGRAPH-8304
        0x8377, # G+1369  U+8377  uni8377,  CJK UNIFIED IDEOGRAPH-8377
        0x83EF, # G+1370  U+83EF  uni83EF,  CJK UNIFIED IDEOGRAPH-83EF
        0x83D3, # G+1371  U+83D3  uni83D3,  CJK UNIFIED IDEOGRAPH-83D3
        0x8766, # G+1372  U+8766  uni8766,  CJK UNIFIED IDEOGRAPH-8766
        0x8AB2, # G+1373  U+8AB2  uni8AB2,  CJK UNIFIED IDEOGRAPH-8AB2
        0x5629, # G+1374  U+5629  uni5629,  CJK UNIFIED IDEOGRAPH-5629
        0x8CA8, # G+1375  U+8CA8  uni8CA8,  CJK UNIFIED IDEOGRAPH-8CA8
        0x8FE6, # G+1376  U+8FE6  uni8FE6,  CJK UNIFIED IDEOGRAPH-8FE6
        0x904E, # G+1377  U+904E  uni904E,  CJK UNIFIED IDEOGRAPH-904E
        0x971E, # G+1378  U+971E  uni971E,  CJK UNIFIED IDEOGRAPH-971E
        0x868A, # G+1379  U+868A  uni868A,  CJK UNIFIED IDEOGRAPH-868A
        0x4FC4, # G+1380  U+4FC4  uni4FC4,  CJK UNIFIED IDEOGRAPH-4FC4
        0x5CE8, # G+1381  U+5CE8  uni5CE8,  CJK UNIFIED IDEOGRAPH-5CE8
        0x6211, # G+1382  U+6211  uni6211,  CJK UNIFIED IDEOGRAPH-6211
        0x2F5B, # G+1383  U+2F5B  uni2F5B,  KANGXI RADICAL FANG
        0x753B, # G+1384  U+753B  uni753B,  CJK UNIFIED IDEOGRAPH-753B
        0x81E5, # G+1385  U+81E5  uni81E5,  CJK UNIFIED IDEOGRAPH-81E5
        0x82BD, # G+1386  U+82BD  uni82BD,  CJK UNIFIED IDEOGRAPH-82BD
        0x86FE, # G+1387  U+86FE  uni86FE,  CJK UNIFIED IDEOGRAPH-86FE
        0x8CC0, # G+1388  U+8CC0  uni8CC0,  CJK UNIFIED IDEOGRAPH-8CC0
        0x96C5, # G+1389  U+96C5  uni96C5,  CJK UNIFIED IDEOGRAPH-96C5
        0x9913, # G+1390  U+9913  uni9913,  CJK UNIFIED IDEOGRAPH-9913
        0x99D5, # G+1391  U+99D5  uni99D5,  CJK UNIFIED IDEOGRAPH-99D5
        0x4ECB, # G+1392  U+4ECB  uni4ECB,  CJK UNIFIED IDEOGRAPH-4ECB
        0x4F1A, # G+1393  U+4F1A  uni4F1A,  CJK UNIFIED IDEOGRAPH-4F1A
        0x89E3, # G+1394  U+89E3  uni89E3,  CJK UNIFIED IDEOGRAPH-89E3
        0x56DE, # G+1395  U+56DE  uni56DE,  CJK UNIFIED IDEOGRAPH-56DE
        0x584A, # G+1396  U+584A  uni584A,  CJK UNIFIED IDEOGRAPH-584A
        0x58CA, # G+1397  U+58CA  uni58CA,  CJK UNIFIED IDEOGRAPH-58CA
        0x5EFB, # G+1398  U+5EFB  uni5EFB,  CJK UNIFIED IDEOGRAPH-5EFB
        0x5FEB, # G+1399  U+5FEB  uni5FEB,  CJK UNIFIED IDEOGRAPH-5FEB
        0x602A, # G+1400  U+602A  uni602A,  CJK UNIFIED IDEOGRAPH-602A
        0x6094, # G+1401  U+6094  uni6094,  CJK UNIFIED IDEOGRAPH-6094
        0x6062, # G+1402  U+6062  uni6062,  CJK UNIFIED IDEOGRAPH-6062
        0x61D0, # G+1403  U+61D0  uni61D0,  CJK UNIFIED IDEOGRAPH-61D0
        0x6212, # G+1404  U+6212  uni6212,  CJK UNIFIED IDEOGRAPH-6212
        0x62D0, # G+1405  U+62D0  uni62D0,  CJK UNIFIED IDEOGRAPH-62D0
        0x6539, # G+1406  U+6539  uni6539,  CJK UNIFIED IDEOGRAPH-6539
        0x9B41, # G+1407  U+9B41  uni9B41,  CJK UNIFIED IDEOGRAPH-9B41
        0x6666, # G+1408  U+6666  uni6666,  CJK UNIFIED IDEOGRAPH-6666
        0x68B0, # G+1409  U+68B0  uni68B0,  CJK UNIFIED IDEOGRAPH-68B0
        0x6D77, # G+1410  U+6D77  uni6D77,  CJK UNIFIED IDEOGRAPH-6D77
        0x7070, # G+1411  U+7070  uni7070,  CJK UNIFIED IDEOGRAPH-7070
        0x754C, # G+1412  U+754C  uni754C,  CJK UNIFIED IDEOGRAPH-754C
        0x7686, # G+1413  U+7686  uni7686,  CJK UNIFIED IDEOGRAPH-7686
        0x7D75, # G+1414  U+7D75  uni7D75,  CJK UNIFIED IDEOGRAPH-7D75
        0x82A5, # G+1415  U+82A5  uni82A5,  CJK UNIFIED IDEOGRAPH-82A5
        0x87F9, # G+1416  U+87F9  uni87F9,  CJK UNIFIED IDEOGRAPH-87F9
        0x958B, # G+1417  U+958B  uni958B,  CJK UNIFIED IDEOGRAPH-958B
        0x968E, # G+1418  U+968E  uni968E,  CJK UNIFIED IDEOGRAPH-968E
        0x2F99, # G+1419  U+2F99  uni2F99,  KANGXI RADICAL SHELL
        0x51F1, # G+1420  U+51F1  uni51F1,  CJK UNIFIED IDEOGRAPH-51F1
        0x52BE, # G+1421  U+52BE  uni52BE,  CJK UNIFIED IDEOGRAPH-52BE
        0x5916, # G+1422  U+5916  uni5916,  CJK UNIFIED IDEOGRAPH-5916
        0x54B3, # G+1423  U+54B3  uni54B3,  CJK UNIFIED IDEOGRAPH-54B3
        0x5BB3, # G+1424  U+5BB3  uni5BB3,  CJK UNIFIED IDEOGRAPH-5BB3
        0x5D16, # G+1425  U+5D16  uni5D16,  CJK UNIFIED IDEOGRAPH-5D16
        0x6168, # G+1426  U+6168  uni6168,  CJK UNIFIED IDEOGRAPH-6168
        0x6982, # G+1427  U+6982  uni6982,  CJK UNIFIED IDEOGRAPH-6982
        0x6DAF, # G+1428  U+6DAF  uni6DAF,  CJK UNIFIED IDEOGRAPH-6DAF
        0x788D, # G+1429  U+788D  uni788D,  CJK UNIFIED IDEOGRAPH-788D
        0x84CB, # G+1430  U+84CB  uni84CB,  CJK UNIFIED IDEOGRAPH-84CB
        0x8857, # G+1431  U+8857  uni8857,  CJK UNIFIED IDEOGRAPH-8857
        0x8A72, # G+1432  U+8A72  uni8A72,  CJK UNIFIED IDEOGRAPH-8A72
        0x93A7, # G+1433  U+93A7  uni93A7,  CJK UNIFIED IDEOGRAPH-93A7
        0x9AB8, # G+1434  U+9AB8  uni9AB8,  CJK UNIFIED IDEOGRAPH-9AB8
        0x6D6C, # G+1435  U+6D6C  uni6D6C,  CJK UNIFIED IDEOGRAPH-6D6C
        0x99A8, # G+1436  U+99A8  uni99A8,  CJK UNIFIED IDEOGRAPH-99A8
        0x86D9, # G+1437  U+86D9  uni86D9,  CJK UNIFIED IDEOGRAPH-86D9
        0x57A3, # G+1438  U+57A3  uni57A3,  CJK UNIFIED IDEOGRAPH-57A3
        0x67FF, # G+1439  U+67FF  uni67FF,  CJK UNIFIED IDEOGRAPH-67FF
        0x86CE, # G+1440  U+86CE  uni86CE,  CJK UNIFIED IDEOGRAPH-86CE
        0x920E, # G+1441  U+920E  uni920E,  CJK UNIFIED IDEOGRAPH-920E
        0x5283, # G+1442  U+5283  uni5283,  CJK UNIFIED IDEOGRAPH-5283
        0x5687, # G+1443  U+5687  uni5687,  CJK UNIFIED IDEOGRAPH-5687
        0x5404, # G+1444  U+5404  uni5404,  CJK UNIFIED IDEOGRAPH-5404
        0x5ED3, # G+1445  U+5ED3  uni5ED3,  CJK UNIFIED IDEOGRAPH-5ED3
        0x62E1, # G+1446  U+62E1  uni62E1,  CJK UNIFIED IDEOGRAPH-62E1
        0x64B9, # G+1447  U+64B9  uni64B9,  CJK UNIFIED IDEOGRAPH-64B9
        0x683C, # G+1448  U+683C  uni683C,  CJK UNIFIED IDEOGRAPH-683C
        0x6838, # G+1449  U+6838  uni6838,  CJK UNIFIED IDEOGRAPH-6838
        0x6BBB, # G+1450  U+6BBB  uni6BBB,  CJK UNIFIED IDEOGRAPH-6BBB
        0x7372, # G+1451  U+7372  uni7372,  CJK UNIFIED IDEOGRAPH-7372
        0x78BA, # G+1452  U+78BA  uni78BA,  CJK UNIFIED IDEOGRAPH-78BA
        0x7A6B, # G+1453  U+7A6B  uni7A6B,  CJK UNIFIED IDEOGRAPH-7A6B
        0x899A, # G+1454  U+899A  uni899A,  CJK UNIFIED IDEOGRAPH-899A
        0x2F93, # G+1455  U+2F93  uni2F93,  KANGXI RADICAL HORN
        0x8D6B, # G+1456  U+8D6B  uni8D6B,  CJK UNIFIED IDEOGRAPH-8D6B
        0x8F03, # G+1457  U+8F03  uni8F03,  CJK UNIFIED IDEOGRAPH-8F03
        0x90ED, # G+1458  U+90ED  uni90ED,  CJK UNIFIED IDEOGRAPH-90ED
        0x95A3, # G+1459  U+95A3  uni95A3,  CJK UNIFIED IDEOGRAPH-95A3
        0x9694, # G+1460  U+9694  uni9694,  CJK UNIFIED IDEOGRAPH-9694
        0x2FB0, # G+1461  U+2FB0  uni2FB0,  KANGXI RADICAL LEATHER
        0x5B66, # G+1462  U+5B66  uni5B66,  CJK UNIFIED IDEOGRAPH-5B66
        0x5CB3, # G+1463  U+5CB3  uni5CB3,  CJK UNIFIED IDEOGRAPH-5CB3
        0x697D, # G+1464  U+697D  uni697D,  CJK UNIFIED IDEOGRAPH-697D
        0x984D, # G+1465  U+984D  uni984D,  CJK UNIFIED IDEOGRAPH-984D
        0x984E, # G+1466  U+984E  uni984E,  CJK UNIFIED IDEOGRAPH-984E
        0x639B, # G+1467  U+639B  uni639B,  CJK UNIFIED IDEOGRAPH-639B
        0x7B20, # G+1468  U+7B20  uni7B20,  CJK UNIFIED IDEOGRAPH-7B20
        0x6A2B, # G+1469  U+6A2B  uni6A2B,  CJK UNIFIED IDEOGRAPH-6A2B
        0x6A7F, # G+1470  U+6A7F  uni6A7F,  CJK UNIFIED IDEOGRAPH-6A7F
        0x68B6, # G+1471  U+68B6  uni68B6,  CJK UNIFIED IDEOGRAPH-68B6
        0x9C0D, # G+1472  U+9C0D  uni9C0D,  CJK UNIFIED IDEOGRAPH-9C0D
        0x6F5F, # G+1473  U+6F5F  uni6F5F,  CJK UNIFIED IDEOGRAPH-6F5F
        0x5272, # G+1474  U+5272  uni5272,  CJK UNIFIED IDEOGRAPH-5272
        0x559D, # G+1475  U+559D  uni559D,  CJK UNIFIED IDEOGRAPH-559D
        0x6070, # G+1476  U+6070  uni6070,  CJK UNIFIED IDEOGRAPH-6070
        0x62EC, # G+1477  U+62EC  uni62EC,  CJK UNIFIED IDEOGRAPH-62EC
        0x6D3B, # G+1478  U+6D3B  uni6D3B,  CJK UNIFIED IDEOGRAPH-6D3B
        0x6E07, # G+1479  U+6E07  uni6E07,  CJK UNIFIED IDEOGRAPH-6E07
        0x6ED1, # G+1480  U+6ED1  uni6ED1,  CJK UNIFIED IDEOGRAPH-6ED1
        0x845B, # G+1481  U+845B  uni845B,  CJK UNIFIED IDEOGRAPH-845B
        0x8910, # G+1482  U+8910  uni8910,  CJK UNIFIED IDEOGRAPH-8910
        0x8F44, # G+1483  U+8F44  uni8F44,  CJK UNIFIED IDEOGRAPH-8F44
        0x4E14, # G+1484  U+4E14  uni4E14,  CJK UNIFIED IDEOGRAPH-4E14
        0x9C39, # G+1485  U+9C39  uni9C39,  CJK UNIFIED IDEOGRAPH-9C39
        0x53F6, # G+1486  U+53F6  uni53F6,  CJK UNIFIED IDEOGRAPH-53F6
        0x691B, # G+1487  U+691B  uni691B,  CJK UNIFIED IDEOGRAPH-691B
        0x6A3A, # G+1488  U+6A3A  uni6A3A,  CJK UNIFIED IDEOGRAPH-6A3A
        0x9784, # G+1489  U+9784  uni9784,  CJK UNIFIED IDEOGRAPH-9784
        0x682A, # G+1490  U+682A  uni682A,  CJK UNIFIED IDEOGRAPH-682A
        0x515C, # G+1491  U+515C  uni515C,  CJK UNIFIED IDEOGRAPH-515C
        0x7AC3, # G+1492  U+7AC3  uni7AC3,  CJK UNIFIED IDEOGRAPH-7AC3
        0x84B2, # G+1493  U+84B2  uni84B2,  CJK UNIFIED IDEOGRAPH-84B2
        0x91DC, # G+1494  U+91DC  uni91DC,  CJK UNIFIED IDEOGRAPH-91DC
        0x938C, # G+1495  U+938C  uni938C,  CJK UNIFIED IDEOGRAPH-938C
        0x565B, # G+1496  U+565B  uni565B,  CJK UNIFIED IDEOGRAPH-565B
        0x9D28, # G+1497  U+9D28  uni9D28,  CJK UNIFIED IDEOGRAPH-9D28
        0x6822, # G+1498  U+6822  uni6822,  CJK UNIFIED IDEOGRAPH-6822
        0x8305, # G+1499  U+8305  uni8305,  CJK UNIFIED IDEOGRAPH-8305
        0x8431, # G+1500  U+8431  uni8431,  CJK UNIFIED IDEOGRAPH-8431
        0x7CA5, # G+1501  U+7CA5  uni7CA5,  CJK UNIFIED IDEOGRAPH-7CA5
        0x5208, # G+1502  U+5208  uni5208,  CJK UNIFIED IDEOGRAPH-5208
        0x82C5, # G+1503  U+82C5  uni82C5,  CJK UNIFIED IDEOGRAPH-82C5
        0x2F61, # G+1504  U+2F61  uni2F61,  KANGXI RADICAL TILE
        0x4E7E, # G+1505  U+4E7E  uni4E7E,  CJK UNIFIED IDEOGRAPH-4E7E
        0x4F83, # G+1506  U+4F83  uni4F83,  CJK UNIFIED IDEOGRAPH-4F83
        0x51A0, # G+1507  U+51A0  uni51A0,  CJK UNIFIED IDEOGRAPH-51A0
        0x5BD2, # G+1508  U+5BD2  uni5BD2,  CJK UNIFIED IDEOGRAPH-5BD2
        0x520A, # G+1509  U+520A  uni520A,  CJK UNIFIED IDEOGRAPH-520A
        0x52D8, # G+1510  U+52D8  uni52D8,  CJK UNIFIED IDEOGRAPH-52D8
        0x52E7, # G+1511  U+52E7  uni52E7,  CJK UNIFIED IDEOGRAPH-52E7
        0x5DFB, # G+1512  U+5DFB  uni5DFB,  CJK UNIFIED IDEOGRAPH-5DFB
        0x559A, # G+1513  U+559A  uni559A,  CJK UNIFIED IDEOGRAPH-559A
        0x582A, # G+1514  U+582A  uni582A,  CJK UNIFIED IDEOGRAPH-582A
        0x59E6, # G+1515  U+59E6  uni59E6,  CJK UNIFIED IDEOGRAPH-59E6
        0x5B8C, # G+1516  U+5B8C  uni5B8C,  CJK UNIFIED IDEOGRAPH-5B8C
        0x5B98, # G+1517  U+5B98  uni5B98,  CJK UNIFIED IDEOGRAPH-5B98
        0x5BDB, # G+1518  U+5BDB  uni5BDB,  CJK UNIFIED IDEOGRAPH-5BDB
        0x2F32, # G+1519  U+2F32  uni2F32,  KANGXI RADICAL DRY
        0x5E79, # G+1520  U+5E79  uni5E79,  CJK UNIFIED IDEOGRAPH-5E79
        0x60A3, # G+1521  U+60A3  uni60A3,  CJK UNIFIED IDEOGRAPH-60A3
        0x611F, # G+1522  U+611F  uni611F,  CJK UNIFIED IDEOGRAPH-611F
        0x6163, # G+1523  U+6163  uni6163,  CJK UNIFIED IDEOGRAPH-6163
        0x61BE, # G+1524  U+61BE  uni61BE,  CJK UNIFIED IDEOGRAPH-61BE
        0x63DB, # G+1525  U+63DB  uni63DB,  CJK UNIFIED IDEOGRAPH-63DB
        0x6562, # G+1526  U+6562  uni6562,  CJK UNIFIED IDEOGRAPH-6562
        0x67D1, # G+1527  U+67D1  uni67D1,  CJK UNIFIED IDEOGRAPH-67D1
        0x6853, # G+1528  U+6853  uni6853,  CJK UNIFIED IDEOGRAPH-6853
        0x68FA, # G+1529  U+68FA  uni68FA,  CJK UNIFIED IDEOGRAPH-68FA
        0x6B3E, # G+1530  U+6B3E  uni6B3E,  CJK UNIFIED IDEOGRAPH-6B3E
        0x6B53, # G+1531  U+6B53  uni6B53,  CJK UNIFIED IDEOGRAPH-6B53
        0x6C57, # G+1532  U+6C57  uni6C57,  CJK UNIFIED IDEOGRAPH-6C57
        0x6F22, # G+1533  U+6F22  uni6F22,  CJK UNIFIED IDEOGRAPH-6F22
        0x6F97, # G+1534  U+6F97  uni6F97,  CJK UNIFIED IDEOGRAPH-6F97
        0x6F45, # G+1535  U+6F45  uni6F45,  CJK UNIFIED IDEOGRAPH-6F45
        0x74B0, # G+1536  U+74B0  uni74B0,  CJK UNIFIED IDEOGRAPH-74B0
        0x2F62, # G+1537  U+2F62  uni2F62,  KANGXI RADICAL SWEET
        0x76E3, # G+1538  U+76E3  uni76E3,  CJK UNIFIED IDEOGRAPH-76E3
        0x770B, # G+1539  U+770B  uni770B,  CJK UNIFIED IDEOGRAPH-770B
        0x7AFF, # G+1540  U+7AFF  uni7AFF,  CJK UNIFIED IDEOGRAPH-7AFF
        0x7BA1, # G+1541  U+7BA1  uni7BA1,  CJK UNIFIED IDEOGRAPH-7BA1
        0x7C21, # G+1542  U+7C21  uni7C21,  CJK UNIFIED IDEOGRAPH-7C21
        0x7DE9, # G+1543  U+7DE9  uni7DE9,  CJK UNIFIED IDEOGRAPH-7DE9
        0x2F78, # G+1544  U+2F78  uni2F78,  KANGXI RADICAL JAR
        0x7FF0, # G+1545  U+7FF0  uni7FF0,  CJK UNIFIED IDEOGRAPH-7FF0
        0x809D, # G+1546  U+809D  uni809D,  CJK UNIFIED IDEOGRAPH-809D
        0x8266, # G+1547  U+8266  uni8266,  CJK UNIFIED IDEOGRAPH-8266
        0x839E, # G+1548  U+839E  uni839E,  CJK UNIFIED IDEOGRAPH-839E
        0x89B3, # G+1549  U+89B3  uni89B3,  CJK UNIFIED IDEOGRAPH-89B3
        0x8ACC, # G+1550  U+8ACC  uni8ACC,  CJK UNIFIED IDEOGRAPH-8ACC
        0x8CAB, # G+1551  U+8CAB  uni8CAB,  CJK UNIFIED IDEOGRAPH-8CAB
        0x9084, # G+1552  U+9084  uni9084,  CJK UNIFIED IDEOGRAPH-9084
        0x9451, # G+1553  U+9451  uni9451,  CJK UNIFIED IDEOGRAPH-9451
        0x9593, # G+1554  U+9593  uni9593,  CJK UNIFIED IDEOGRAPH-9593
        0x9591, # G+1555  U+9591  uni9591,  CJK UNIFIED IDEOGRAPH-9591
        0x95A2, # G+1556  U+95A2  uni95A2,  CJK UNIFIED IDEOGRAPH-95A2
        0x9665, # G+1557  U+9665  uni9665,  CJK UNIFIED IDEOGRAPH-9665
        0x97D3, # G+1558  U+97D3  uni97D3,  CJK UNIFIED IDEOGRAPH-97D3
        0x9928, # G+1559  U+9928  uni9928,  CJK UNIFIED IDEOGRAPH-9928
        0x8218, # G+1560  U+8218  uni8218,  CJK UNIFIED IDEOGRAPH-8218
        0x4E38, # G+1561  U+4E38  uni4E38,  CJK UNIFIED IDEOGRAPH-4E38
        0x542B, # G+1562  U+542B  uni542B,  CJK UNIFIED IDEOGRAPH-542B
        0x5CB8, # G+1563  U+5CB8  uni5CB8,  CJK UNIFIED IDEOGRAPH-5CB8
        0x5DCC, # G+1564  U+5DCC  uni5DCC,  CJK UNIFIED IDEOGRAPH-5DCC
        0x73A9, # G+1565  U+73A9  uni73A9,  CJK UNIFIED IDEOGRAPH-73A9
        0x764C, # G+1566  U+764C  uni764C,  CJK UNIFIED IDEOGRAPH-764C
        0x773C, # G+1567  U+773C  uni773C,  CJK UNIFIED IDEOGRAPH-773C
        0x5CA9, # G+1568  U+5CA9  uni5CA9,  CJK UNIFIED IDEOGRAPH-5CA9
        0x7FEB, # G+1569  U+7FEB  uni7FEB,  CJK UNIFIED IDEOGRAPH-7FEB
        0x8D0B, # G+1570  U+8D0B  uni8D0B,  CJK UNIFIED IDEOGRAPH-8D0B
        0x96C1, # G+1571  U+96C1  uni96C1,  CJK UNIFIED IDEOGRAPH-96C1
        0x9811, # G+1572  U+9811  uni9811,  CJK UNIFIED IDEOGRAPH-9811
        0x9854, # G+1573  U+9854  uni9854,  CJK UNIFIED IDEOGRAPH-9854
        0x9858, # G+1574  U+9858  uni9858,  CJK UNIFIED IDEOGRAPH-9858
        0x4F01, # G+1575  U+4F01  uni4F01,  CJK UNIFIED IDEOGRAPH-4F01
        0x4F0E, # G+1576  U+4F0E  uni4F0E,  CJK UNIFIED IDEOGRAPH-4F0E
        0x5371, # G+1577  U+5371  uni5371,  CJK UNIFIED IDEOGRAPH-5371
        0x559C, # G+1578  U+559C  uni559C,  CJK UNIFIED IDEOGRAPH-559C
        0x5668, # G+1579  U+5668  uni5668,  CJK UNIFIED IDEOGRAPH-5668
        0x57FA, # G+1580  U+57FA  uni57FA,  CJK UNIFIED IDEOGRAPH-57FA
        0x5947, # G+1581  U+5947  uni5947,  CJK UNIFIED IDEOGRAPH-5947
        0x5B09, # G+1582  U+5B09  uni5B09,  CJK UNIFIED IDEOGRAPH-5B09
        0x5BC4, # G+1583  U+5BC4  uni5BC4,  CJK UNIFIED IDEOGRAPH-5BC4
        0x5C90, # G+1584  U+5C90  uni5C90,  CJK UNIFIED IDEOGRAPH-5C90
        0x5E0C, # G+1585  U+5E0C  uni5E0C,  CJK UNIFIED IDEOGRAPH-5E0C
        0x5E7E, # G+1586  U+5E7E  uni5E7E,  CJK UNIFIED IDEOGRAPH-5E7E
        0x5FCC, # G+1587  U+5FCC  uni5FCC,  CJK UNIFIED IDEOGRAPH-5FCC
        0x63EE, # G+1588  U+63EE  uni63EE,  CJK UNIFIED IDEOGRAPH-63EE
        0x673A, # G+1589  U+673A  uni673A,  CJK UNIFIED IDEOGRAPH-673A
        0x65D7, # G+1590  U+65D7  uni65D7,  CJK UNIFIED IDEOGRAPH-65D7
        0x65E2, # G+1591  U+65E2  uni65E2,  CJK UNIFIED IDEOGRAPH-65E2
        0x671F, # G+1592  U+671F  uni671F,  CJK UNIFIED IDEOGRAPH-671F
        0x68CB, # G+1593  U+68CB  uni68CB,  CJK UNIFIED IDEOGRAPH-68CB
        0x68C4, # G+1594  U+68C4  uni68C4,  CJK UNIFIED IDEOGRAPH-68C4
        0x6A5F, # G+1595  U+6A5F  uni6A5F,  CJK UNIFIED IDEOGRAPH-6A5F
        0x5E30, # G+1596  U+5E30  uni5E30,  CJK UNIFIED IDEOGRAPH-5E30
        0x6BC5, # G+1597  U+6BC5  uni6BC5,  CJK UNIFIED IDEOGRAPH-6BC5
        0x6C17, # G+1598  U+6C17  uni6C17,  CJK UNIFIED IDEOGRAPH-6C17
        0x6C7D, # G+1599  U+6C7D  uni6C7D,  CJK UNIFIED IDEOGRAPH-6C7D
        0x757F, # G+1600  U+757F  uni757F,  CJK UNIFIED IDEOGRAPH-757F
        0x7948, # G+1601  U+7948  uni7948,  CJK UNIFIED IDEOGRAPH-7948
        0x5B63, # G+1602  U+5B63  uni5B63,  CJK UNIFIED IDEOGRAPH-5B63
        0x7A00, # G+1603  U+7A00  uni7A00,  CJK UNIFIED IDEOGRAPH-7A00
        0x7D00, # G+1604  U+7D00  uni7D00,  CJK UNIFIED IDEOGRAPH-7D00
        0x5FBD, # G+1605  U+5FBD  uni5FBD,  CJK UNIFIED IDEOGRAPH-5FBD
        0x898F, # G+1606  U+898F  uni898F,  CJK UNIFIED IDEOGRAPH-898F
        0x8A18, # G+1607  U+8A18  uni8A18,  CJK UNIFIED IDEOGRAPH-8A18
        0x8CB4, # G+1608  U+8CB4  uni8CB4,  CJK UNIFIED IDEOGRAPH-8CB4
        0x8D77, # G+1609  U+8D77  uni8D77,  CJK UNIFIED IDEOGRAPH-8D77
        0x8ECC, # G+1610  U+8ECC  uni8ECC,  CJK UNIFIED IDEOGRAPH-8ECC
        0x8F1D, # G+1611  U+8F1D  uni8F1D,  CJK UNIFIED IDEOGRAPH-8F1D
        0x98E2, # G+1612  U+98E2  uni98E2,  CJK UNIFIED IDEOGRAPH-98E2
        0x9A0E, # G+1613  U+9A0E  uni9A0E,  CJK UNIFIED IDEOGRAPH-9A0E
        0x2EE4, # G+1614  U+2EE4  uni2EE4,  CJK RADICAL GHOST
        0x2EF2, # G+1615  U+2EF2  uni2EF2,  CJK RADICAL J-SIMPLIFIED TURTLE
        0x507D, # G+1616  U+507D  uni507D,  CJK UNIFIED IDEOGRAPH-507D
        0x5100, # G+1617  U+5100  uni5100,  CJK UNIFIED IDEOGRAPH-5100
        0x5993, # G+1618  U+5993  uni5993,  CJK UNIFIED IDEOGRAPH-5993
        0x5B9C, # G+1619  U+5B9C  uni5B9C,  CJK UNIFIED IDEOGRAPH-5B9C
        0x622F, # G+1620  U+622F  uni622F,  CJK UNIFIED IDEOGRAPH-622F
        0x6280, # G+1621  U+6280  uni6280,  CJK UNIFIED IDEOGRAPH-6280
        0x64EC, # G+1622  U+64EC  uni64EC,  CJK UNIFIED IDEOGRAPH-64EC
        0x6B3A, # G+1623  U+6B3A  uni6B3A,  CJK UNIFIED IDEOGRAPH-6B3A
        0x72A0, # G+1624  U+72A0  uni72A0,  CJK UNIFIED IDEOGRAPH-72A0
        0x7591, # G+1625  U+7591  uni7591,  CJK UNIFIED IDEOGRAPH-7591
        0x7947, # G+1626  U+7947  uni7947,  CJK UNIFIED IDEOGRAPH-7947
        0x7FA9, # G+1627  U+7FA9  uni7FA9,  CJK UNIFIED IDEOGRAPH-7FA9
        0x87FB, # G+1628  U+87FB  uni87FB,  CJK UNIFIED IDEOGRAPH-87FB
        0x8ABC, # G+1629  U+8ABC  uni8ABC,  CJK UNIFIED IDEOGRAPH-8ABC
        0x8B70, # G+1630  U+8B70  uni8B70,  CJK UNIFIED IDEOGRAPH-8B70
        0x63AC, # G+1631  U+63AC  uni63AC,  CJK UNIFIED IDEOGRAPH-63AC
        0x83CA, # G+1632  U+83CA  uni83CA,  CJK UNIFIED IDEOGRAPH-83CA
        0x97A0, # G+1633  U+97A0  uni97A0,  CJK UNIFIED IDEOGRAPH-97A0
        0x5409, # G+1634  U+5409  uni5409,  CJK UNIFIED IDEOGRAPH-5409
        0x5403, # G+1635  U+5403  uni5403,  CJK UNIFIED IDEOGRAPH-5403
        0x55AB, # G+1636  U+55AB  uni55AB,  CJK UNIFIED IDEOGRAPH-55AB
        0x6854, # G+1637  U+6854  uni6854,  CJK UNIFIED IDEOGRAPH-6854
        0x6A58, # G+1638  U+6A58  uni6A58,  CJK UNIFIED IDEOGRAPH-6A58
        0x8A70, # G+1639  U+8A70  uni8A70,  CJK UNIFIED IDEOGRAPH-8A70
        0x7827, # G+1640  U+7827  uni7827,  CJK UNIFIED IDEOGRAPH-7827
        0x6775, # G+1641  U+6775  uni6775,  CJK UNIFIED IDEOGRAPH-6775
        0x2FC9, # G+1642  U+2FC9  uni2FC9,  KANGXI RADICAL MILLET
        0x5374, # G+1643  U+5374  uni5374,  CJK UNIFIED IDEOGRAPH-5374
        0x5BA2, # G+1644  U+5BA2  uni5BA2,  CJK UNIFIED IDEOGRAPH-5BA2
        0x811A, # G+1645  U+811A  uni811A,  CJK UNIFIED IDEOGRAPH-811A
        0x8650, # G+1646  U+8650  uni8650,  CJK UNIFIED IDEOGRAPH-8650
        0x9006, # G+1647  U+9006  uni9006,  CJK UNIFIED IDEOGRAPH-9006
        0x4E18, # G+1648  U+4E18  uni4E18,  CJK UNIFIED IDEOGRAPH-4E18
        0x4E45, # G+1649  U+4E45  uni4E45,  CJK UNIFIED IDEOGRAPH-4E45
        0x4EC7, # G+1650  U+4EC7  uni4EC7,  CJK UNIFIED IDEOGRAPH-4EC7
        0x4F11, # G+1651  U+4F11  uni4F11,  CJK UNIFIED IDEOGRAPH-4F11
        0x53CA, # G+1652  U+53CA  uni53CA,  CJK UNIFIED IDEOGRAPH-53CA
        0x5438, # G+1653  U+5438  uni5438,  CJK UNIFIED IDEOGRAPH-5438
        0x5BAE, # G+1654  U+5BAE  uni5BAE,  CJK UNIFIED IDEOGRAPH-5BAE
        0x2F38, # G+1655  U+2F38  uni2F38,  KANGXI RADICAL BOW
        0x6025, # G+1656  U+6025  uni6025,  CJK UNIFIED IDEOGRAPH-6025
        0x6551, # G+1657  U+6551  uni6551,  CJK UNIFIED IDEOGRAPH-6551
        0x673D, # G+1658  U+673D  uni673D,  CJK UNIFIED IDEOGRAPH-673D
        0x6C42, # G+1659  U+6C42  uni6C42,  CJK UNIFIED IDEOGRAPH-6C42
        0x6C72, # G+1660  U+6C72  uni6C72,  CJK UNIFIED IDEOGRAPH-6C72
        0x6CE3, # G+1661  U+6CE3  uni6CE3,  CJK UNIFIED IDEOGRAPH-6CE3
        0x7078, # G+1662  U+7078  uni7078,  CJK UNIFIED IDEOGRAPH-7078
        0x7403, # G+1663  U+7403  uni7403,  CJK UNIFIED IDEOGRAPH-7403
        0x7A76, # G+1664  U+7A76  uni7A76,  CJK UNIFIED IDEOGRAPH-7A76
        0x7AAE, # G+1665  U+7AAE  uni7AAE,  CJK UNIFIED IDEOGRAPH-7AAE
        0x7B08, # G+1666  U+7B08  uni7B08,  CJK UNIFIED IDEOGRAPH-7B08
        0x7D1A, # G+1667  U+7D1A  uni7D1A,  CJK UNIFIED IDEOGRAPH-7D1A
        0x7CFE, # G+1668  U+7CFE  uni7CFE,  CJK UNIFIED IDEOGRAPH-7CFE
        0x7D66, # G+1669  U+7D66  uni7D66,  CJK UNIFIED IDEOGRAPH-7D66
        0x65E7, # G+1670  U+65E7  uni65E7,  CJK UNIFIED IDEOGRAPH-65E7
        0x2F5C, # G+1671  U+2F5C  uni2F5C,  KANGXI RADICAL COW
        0x53BB, # G+1672  U+53BB  uni53BB,  CJK UNIFIED IDEOGRAPH-53BB
        0x5C45, # G+1673  U+5C45  uni5C45,  CJK UNIFIED IDEOGRAPH-5C45
        0x5DE8, # G+1674  U+5DE8  uni5DE8,  CJK UNIFIED IDEOGRAPH-5DE8
        0x62D2, # G+1675  U+62D2  uni62D2,  CJK UNIFIED IDEOGRAPH-62D2
        0x62E0, # G+1676  U+62E0  uni62E0,  CJK UNIFIED IDEOGRAPH-62E0
        0x6319, # G+1677  U+6319  uni6319,  CJK UNIFIED IDEOGRAPH-6319
        0x6E20, # G+1678  U+6E20  uni6E20,  CJK UNIFIED IDEOGRAPH-6E20
        0x865A, # G+1679  U+865A  uni865A,  CJK UNIFIED IDEOGRAPH-865A
        0x8A31, # G+1680  U+8A31  uni8A31,  CJK UNIFIED IDEOGRAPH-8A31
        0x8DDD, # G+1681  U+8DDD  uni8DDD,  CJK UNIFIED IDEOGRAPH-8DDD
        0x92F8, # G+1682  U+92F8  uni92F8,  CJK UNIFIED IDEOGRAPH-92F8
        0x6F01, # G+1683  U+6F01  uni6F01,  CJK UNIFIED IDEOGRAPH-6F01
        0x79A6, # G+1684  U+79A6  uni79A6,  CJK UNIFIED IDEOGRAPH-79A6
        0x2FC2, # G+1685  U+2FC2  uni2FC2,  KANGXI RADICAL FISH
        0x4EA8, # G+1686  U+4EA8  uni4EA8,  CJK UNIFIED IDEOGRAPH-4EA8
        0x4EAB, # G+1687  U+4EAB  uni4EAB,  CJK UNIFIED IDEOGRAPH-4EAB
        0x4EAC, # G+1688  U+4EAC  uni4EAC,  CJK UNIFIED IDEOGRAPH-4EAC
        0x4F9B, # G+1689  U+4F9B  uni4F9B,  CJK UNIFIED IDEOGRAPH-4F9B
        0x4FA0, # G+1690  U+4FA0  uni4FA0,  CJK UNIFIED IDEOGRAPH-4FA0
        0x50D1, # G+1691  U+50D1  uni50D1,  CJK UNIFIED IDEOGRAPH-50D1
        0x5147, # G+1692  U+5147  uni5147,  CJK UNIFIED IDEOGRAPH-5147
        0x7AF6, # G+1693  U+7AF6  uni7AF6,  CJK UNIFIED IDEOGRAPH-7AF6
        0x5171, # G+1694  U+5171  uni5171,  CJK UNIFIED IDEOGRAPH-5171
        0x51F6, # G+1695  U+51F6  uni51F6,  CJK UNIFIED IDEOGRAPH-51F6
        0x5354, # G+1696  U+5354  uni5354,  CJK UNIFIED IDEOGRAPH-5354
        0x5321, # G+1697  U+5321  uni5321,  CJK UNIFIED IDEOGRAPH-5321
        0x537F, # G+1698  U+537F  uni537F,  CJK UNIFIED IDEOGRAPH-537F
        0x53EB, # G+1699  U+53EB  uni53EB,  CJK UNIFIED IDEOGRAPH-53EB
        0x55AC, # G+1700  U+55AC  uni55AC,  CJK UNIFIED IDEOGRAPH-55AC
        0x5883, # G+1701  U+5883  uni5883,  CJK UNIFIED IDEOGRAPH-5883
        0x5CE1, # G+1702  U+5CE1  uni5CE1,  CJK UNIFIED IDEOGRAPH-5CE1
        0x5F37, # G+1703  U+5F37  uni5F37,  CJK UNIFIED IDEOGRAPH-5F37
        0x5F4A, # G+1704  U+5F4A  uni5F4A,  CJK UNIFIED IDEOGRAPH-5F4A
        0x602F, # G+1705  U+602F  uni602F,  CJK UNIFIED IDEOGRAPH-602F
        0x6050, # G+1706  U+6050  uni6050,  CJK UNIFIED IDEOGRAPH-6050
        0x606D, # G+1707  U+606D  uni606D,  CJK UNIFIED IDEOGRAPH-606D
        0x631F, # G+1708  U+631F  uni631F,  CJK UNIFIED IDEOGRAPH-631F
        0x6559, # G+1709  U+6559  uni6559,  CJK UNIFIED IDEOGRAPH-6559
        0x6A4B, # G+1710  U+6A4B  uni6A4B,  CJK UNIFIED IDEOGRAPH-6A4B
        0x6CC1, # G+1711  U+6CC1  uni6CC1,  CJK UNIFIED IDEOGRAPH-6CC1
        0x72C2, # G+1712  U+72C2  uni72C2,  CJK UNIFIED IDEOGRAPH-72C2
        0x72ED, # G+1713  U+72ED  uni72ED,  CJK UNIFIED IDEOGRAPH-72ED
        0x77EF, # G+1714  U+77EF  uni77EF,  CJK UNIFIED IDEOGRAPH-77EF
        0x80F8, # G+1715  U+80F8  uni80F8,  CJK UNIFIED IDEOGRAPH-80F8
        0x8105, # G+1716  U+8105  uni8105,  CJK UNIFIED IDEOGRAPH-8105
        0x8208, # G+1717  U+8208  uni8208,  CJK UNIFIED IDEOGRAPH-8208
        0x854E, # G+1718  U+854E  uni854E,  CJK UNIFIED IDEOGRAPH-854E
        0x90F7, # G+1719  U+90F7  uni90F7,  CJK UNIFIED IDEOGRAPH-90F7
        0x93E1, # G+1720  U+93E1  uni93E1,  CJK UNIFIED IDEOGRAPH-93E1
        0x97FF, # G+1721  U+97FF  uni97FF,  CJK UNIFIED IDEOGRAPH-97FF
        0x9957, # G+1722  U+9957  uni9957,  CJK UNIFIED IDEOGRAPH-9957
        0x9A5A, # G+1723  U+9A5A  uni9A5A,  CJK UNIFIED IDEOGRAPH-9A5A
        0x4EF0, # G+1724  U+4EF0  uni4EF0,  CJK UNIFIED IDEOGRAPH-4EF0
        0x51DD, # G+1725  U+51DD  uni51DD,  CJK UNIFIED IDEOGRAPH-51DD
        0x5C2D, # G+1726  U+5C2D  uni5C2D,  CJK UNIFIED IDEOGRAPH-5C2D
        0x6681, # G+1727  U+6681  uni6681,  CJK UNIFIED IDEOGRAPH-6681
        0x696D, # G+1728  U+696D  uni696D,  CJK UNIFIED IDEOGRAPH-696D
        0x5C40, # G+1729  U+5C40  uni5C40,  CJK UNIFIED IDEOGRAPH-5C40
        0x66F2, # G+1730  U+66F2  uni66F2,  CJK UNIFIED IDEOGRAPH-66F2
        0x6975, # G+1731  U+6975  uni6975,  CJK UNIFIED IDEOGRAPH-6975
        0x2F5F, # G+1732  U+2F5F  uni2F5F,  KANGXI RADICAL JADE
        0x6850, # G+1733  U+6850  uni6850,  CJK UNIFIED IDEOGRAPH-6850
        0x7C81, # G+1734  U+7C81  uni7C81,  CJK UNIFIED IDEOGRAPH-7C81
        0x50C5, # G+1735  U+50C5  uni50C5,  CJK UNIFIED IDEOGRAPH-50C5
        0x52E4, # G+1736  U+52E4  uni52E4,  CJK UNIFIED IDEOGRAPH-52E4
        0x5747, # G+1737  U+5747  uni5747,  CJK UNIFIED IDEOGRAPH-5747
        0x2F31, # G+1738  U+2F31  uni2F31,  KANGXI RADICAL TURBAN
        0x9326, # G+1739  U+9326  uni9326,  CJK UNIFIED IDEOGRAPH-9326
        0x2F44, # G+1740  U+2F44  uni2F44,  KANGXI RADICAL AXE
        0x6B23, # G+1741  U+6B23  uni6B23,  CJK UNIFIED IDEOGRAPH-6B23
        0x6B3D, # G+1742  U+6B3D  uni6B3D,  CJK UNIFIED IDEOGRAPH-6B3D
        0x7434, # G+1743  U+7434  uni7434,  CJK UNIFIED IDEOGRAPH-7434
        0x7981, # G+1744  U+7981  uni7981,  CJK UNIFIED IDEOGRAPH-7981
        0x79BD, # G+1745  U+79BD  uni79BD,  CJK UNIFIED IDEOGRAPH-79BD
        0x7B4B, # G+1746  U+7B4B  uni7B4B,  CJK UNIFIED IDEOGRAPH-7B4B
        0x7DCA, # G+1747  U+7DCA  uni7DCA,  CJK UNIFIED IDEOGRAPH-7DCA
        0x82B9, # G+1748  U+82B9  uni82B9,  CJK UNIFIED IDEOGRAPH-82B9
        0x83CC, # G+1749  U+83CC  uni83CC,  CJK UNIFIED IDEOGRAPH-83CC
        0x887F, # G+1750  U+887F  uni887F,  CJK UNIFIED IDEOGRAPH-887F
        0x895F, # G+1751  U+895F  uni895F,  CJK UNIFIED IDEOGRAPH-895F
        0x8B39, # G+1752  U+8B39  uni8B39,  CJK UNIFIED IDEOGRAPH-8B39
        0x8FD1, # G+1753  U+8FD1  uni8FD1,  CJK UNIFIED IDEOGRAPH-8FD1
        0x2FA6, # G+1754  U+2FA6  uni2FA6,  KANGXI RADICAL GOLD
        0x541F, # G+1755  U+541F  uni541F,  CJK UNIFIED IDEOGRAPH-541F
        0x9280, # G+1756  U+9280  uni9280,  CJK UNIFIED IDEOGRAPH-9280
        0x4E5D, # G+1757  U+4E5D  uni4E5D,  CJK UNIFIED IDEOGRAPH-4E5D
        0x5036, # G+1758  U+5036  uni5036,  CJK UNIFIED IDEOGRAPH-5036
        0x53E5, # G+1759  U+53E5  uni53E5,  CJK UNIFIED IDEOGRAPH-53E5
        0x533A, # G+1760  U+533A  uni533A,  CJK UNIFIED IDEOGRAPH-533A
        0x72D7, # G+1761  U+72D7  uni72D7,  CJK UNIFIED IDEOGRAPH-72D7
        0x7396, # G+1762  U+7396  uni7396,  CJK UNIFIED IDEOGRAPH-7396
        0x77E9, # G+1763  U+77E9  uni77E9,  CJK UNIFIED IDEOGRAPH-77E9
        0x82E6, # G+1764  U+82E6  uni82E6,  CJK UNIFIED IDEOGRAPH-82E6
        0x8EAF, # G+1765  U+8EAF  uni8EAF,  CJK UNIFIED IDEOGRAPH-8EAF
        0x99C6, # G+1766  U+99C6  uni99C6,  CJK UNIFIED IDEOGRAPH-99C6
        0x99C8, # G+1767  U+99C8  uni99C8,  CJK UNIFIED IDEOGRAPH-99C8
        0x99D2, # G+1768  U+99D2  uni99D2,  CJK UNIFIED IDEOGRAPH-99D2
        0x5177, # G+1769  U+5177  uni5177,  CJK UNIFIED IDEOGRAPH-5177
        0x611A, # G+1770  U+611A  uni611A,  CJK UNIFIED IDEOGRAPH-611A
        0x865E, # G+1771  U+865E  uni865E,  CJK UNIFIED IDEOGRAPH-865E
        0x55B0, # G+1772  U+55B0  uni55B0,  CJK UNIFIED IDEOGRAPH-55B0
        0x7A7A, # G+1773  U+7A7A  uni7A7A,  CJK UNIFIED IDEOGRAPH-7A7A
        0x5076, # G+1774  U+5076  uni5076,  CJK UNIFIED IDEOGRAPH-5076
        0x5BD3, # G+1775  U+5BD3  uni5BD3,  CJK UNIFIED IDEOGRAPH-5BD3
        0x9047, # G+1776  U+9047  uni9047,  CJK UNIFIED IDEOGRAPH-9047
        0x9685, # G+1777  U+9685  uni9685,  CJK UNIFIED IDEOGRAPH-9685
        0x4E32, # G+1778  U+4E32  uni4E32,  CJK UNIFIED IDEOGRAPH-4E32
        0x6ADB, # G+1779  U+6ADB  uni6ADB,  CJK UNIFIED IDEOGRAPH-6ADB
        0x91E7, # G+1780  U+91E7  uni91E7,  CJK UNIFIED IDEOGRAPH-91E7
        0x5C51, # G+1781  U+5C51  uni5C51,  CJK UNIFIED IDEOGRAPH-5C51
        0x5C48, # G+1782  U+5C48  uni5C48,  CJK UNIFIED IDEOGRAPH-5C48
        0x6398, # G+1783  U+6398  uni6398,  CJK UNIFIED IDEOGRAPH-6398
        0x7A9F, # G+1784  U+7A9F  uni7A9F,  CJK UNIFIED IDEOGRAPH-7A9F
        0x6C93, # G+1785  U+6C93  uni6C93,  CJK UNIFIED IDEOGRAPH-6C93
        0x9774, # G+1786  U+9774  uni9774,  CJK UNIFIED IDEOGRAPH-9774
        0x8F61, # G+1787  U+8F61  uni8F61,  CJK UNIFIED IDEOGRAPH-8F61
        0x7AAA, # G+1788  U+7AAA  uni7AAA,  CJK UNIFIED IDEOGRAPH-7AAA
        0x718A, # G+1789  U+718A  uni718A,  CJK UNIFIED IDEOGRAPH-718A
        0x9688, # G+1790  U+9688  uni9688,  CJK UNIFIED IDEOGRAPH-9688
        0x7C82, # G+1791  U+7C82  uni7C82,  CJK UNIFIED IDEOGRAPH-7C82
        0x6817, # G+1792  U+6817  uni6817,  CJK UNIFIED IDEOGRAPH-6817
        0x7E70, # G+1793  U+7E70  uni7E70,  CJK UNIFIED IDEOGRAPH-7E70
        0x6851, # G+1794  U+6851  uni6851,  CJK UNIFIED IDEOGRAPH-6851
        0x936C, # G+1795  U+936C  uni936C,  CJK UNIFIED IDEOGRAPH-936C
        0x52F2, # G+1796  U+52F2  uni52F2,  CJK UNIFIED IDEOGRAPH-52F2
        0x541B, # G+1797  U+541B  uni541B,  CJK UNIFIED IDEOGRAPH-541B
        0x85AB, # G+1798  U+85AB  uni85AB,  CJK UNIFIED IDEOGRAPH-85AB
        0x8A13, # G+1799  U+8A13  uni8A13,  CJK UNIFIED IDEOGRAPH-8A13
        0x7FA4, # G+1800  U+7FA4  uni7FA4,  CJK UNIFIED IDEOGRAPH-7FA4
        0x8ECD, # G+1801  U+8ECD  uni8ECD,  CJK UNIFIED IDEOGRAPH-8ECD
        0x90E1, # G+1802  U+90E1  uni90E1,  CJK UNIFIED IDEOGRAPH-90E1
        0x5366, # G+1803  U+5366  uni5366,  CJK UNIFIED IDEOGRAPH-5366
        0x8888, # G+1804  U+8888  uni8888,  CJK UNIFIED IDEOGRAPH-8888
        0x7941, # G+1805  U+7941  uni7941,  CJK UNIFIED IDEOGRAPH-7941
        0x4FC2, # G+1806  U+4FC2  uni4FC2,  CJK UNIFIED IDEOGRAPH-4FC2
        0x50BE, # G+1807  U+50BE  uni50BE,  CJK UNIFIED IDEOGRAPH-50BE
        0x5211, # G+1808  U+5211  uni5211,  CJK UNIFIED IDEOGRAPH-5211
        0x5144, # G+1809  U+5144  uni5144,  CJK UNIFIED IDEOGRAPH-5144
        0x5553, # G+1810  U+5553  uni5553,  CJK UNIFIED IDEOGRAPH-5553
        0x572D, # G+1811  U+572D  uni572D,  CJK UNIFIED IDEOGRAPH-572D
        0x73EA, # G+1812  U+73EA  uni73EA,  CJK UNIFIED IDEOGRAPH-73EA
        0x578B, # G+1813  U+578B  uni578B,  CJK UNIFIED IDEOGRAPH-578B
        0x5951, # G+1814  U+5951  uni5951,  CJK UNIFIED IDEOGRAPH-5951
        0x5F62, # G+1815  U+5F62  uni5F62,  CJK UNIFIED IDEOGRAPH-5F62
        0x5F84, # G+1816  U+5F84  uni5F84,  CJK UNIFIED IDEOGRAPH-5F84
        0x6075, # G+1817  U+6075  uni6075,  CJK UNIFIED IDEOGRAPH-6075
        0x6176, # G+1818  U+6176  uni6176,  CJK UNIFIED IDEOGRAPH-6176
        0x6167, # G+1819  U+6167  uni6167,  CJK UNIFIED IDEOGRAPH-6167
        0x61A9, # G+1820  U+61A9  uni61A9,  CJK UNIFIED IDEOGRAPH-61A9
        0x63B2, # G+1821  U+63B2  uni63B2,  CJK UNIFIED IDEOGRAPH-63B2
        0x643A, # G+1822  U+643A  uni643A,  CJK UNIFIED IDEOGRAPH-643A
        0x656C, # G+1823  U+656C  uni656C,  CJK UNIFIED IDEOGRAPH-656C
        0x666F, # G+1824  U+666F  uni666F,  CJK UNIFIED IDEOGRAPH-666F
        0x6842, # G+1825  U+6842  uni6842,  CJK UNIFIED IDEOGRAPH-6842
        0x6E13, # G+1826  U+6E13  uni6E13,  CJK UNIFIED IDEOGRAPH-6E13
        0x7566, # G+1827  U+7566  uni7566,  CJK UNIFIED IDEOGRAPH-7566
        0x7A3D, # G+1828  U+7A3D  uni7A3D,  CJK UNIFIED IDEOGRAPH-7A3D
        0x7CFB, # G+1829  U+7CFB  uni7CFB,  CJK UNIFIED IDEOGRAPH-7CFB
        0x7D4C, # G+1830  U+7D4C  uni7D4C,  CJK UNIFIED IDEOGRAPH-7D4C
        0x7D99, # G+1831  U+7D99  uni7D99,  CJK UNIFIED IDEOGRAPH-7D99
        0x7E4B, # G+1832  U+7E4B  uni7E4B,  CJK UNIFIED IDEOGRAPH-7E4B
        0x7F6B, # G+1833  U+7F6B  uni7F6B,  CJK UNIFIED IDEOGRAPH-7F6B
        0x830E, # G+1834  U+830E  uni830E,  CJK UNIFIED IDEOGRAPH-830E
        0x834A, # G+1835  U+834A  uni834A,  CJK UNIFIED IDEOGRAPH-834A
        0x86CD, # G+1836  U+86CD  uni86CD,  CJK UNIFIED IDEOGRAPH-86CD
        0x8A08, # G+1837  U+8A08  uni8A08,  CJK UNIFIED IDEOGRAPH-8A08
        0x8A63, # G+1838  U+8A63  uni8A63,  CJK UNIFIED IDEOGRAPH-8A63
        0x8B66, # G+1839  U+8B66  uni8B66,  CJK UNIFIED IDEOGRAPH-8B66
        0x8EFD, # G+1840  U+8EFD  uni8EFD,  CJK UNIFIED IDEOGRAPH-8EFD
        0x981A, # G+1841  U+981A  uni981A,  CJK UNIFIED IDEOGRAPH-981A
        0x9D8F, # G+1842  U+9D8F  uni9D8F,  CJK UNIFIED IDEOGRAPH-9D8F
        0x82B8, # G+1843  U+82B8  uni82B8,  CJK UNIFIED IDEOGRAPH-82B8
        0x8FCE, # G+1844  U+8FCE  uni8FCE,  CJK UNIFIED IDEOGRAPH-8FCE
        0x9BE8, # G+1845  U+9BE8  uni9BE8,  CJK UNIFIED IDEOGRAPH-9BE8
        0x5287, # G+1846  U+5287  uni5287,  CJK UNIFIED IDEOGRAPH-5287
        0x621F, # G+1847  U+621F  uni621F,  CJK UNIFIED IDEOGRAPH-621F
        0x6483, # G+1848  U+6483  uni6483,  CJK UNIFIED IDEOGRAPH-6483
        0x6FC0, # G+1849  U+6FC0  uni6FC0,  CJK UNIFIED IDEOGRAPH-6FC0
        0x9699, # G+1850  U+9699  uni9699,  CJK UNIFIED IDEOGRAPH-9699
        0x6841, # G+1851  U+6841  uni6841,  CJK UNIFIED IDEOGRAPH-6841
        0x5091, # G+1852  U+5091  uni5091,  CJK UNIFIED IDEOGRAPH-5091
        0x2F4B, # G+1853  U+2F4B  uni2F4B,  KANGXI RADICAL LACK
        0x6C7A, # G+1854  U+6C7A  uni6C7A,  CJK UNIFIED IDEOGRAPH-6C7A
        0x6F54, # G+1855  U+6F54  uni6F54,  CJK UNIFIED IDEOGRAPH-6F54
        0x2F73, # G+1856  U+2F73  uni2F73,  KANGXI RADICAL CAVE
        0x7D50, # G+1857  U+7D50  uni7D50,  CJK UNIFIED IDEOGRAPH-7D50
        0x2F8E, # G+1858  U+2F8E  uni2F8E,  KANGXI RADICAL BLOOD
        0x8A23, # G+1859  U+8A23  uni8A23,  CJK UNIFIED IDEOGRAPH-8A23
        0x2F49, # G+1860  U+2F49  uni2F49,  KANGXI RADICAL MOON
        0x4EF6, # G+1861  U+4EF6  uni4EF6,  CJK UNIFIED IDEOGRAPH-4EF6
        0x5039, # G+1862  U+5039  uni5039,  CJK UNIFIED IDEOGRAPH-5039
        0x5026, # G+1863  U+5026  uni5026,  CJK UNIFIED IDEOGRAPH-5026
        0x5065, # G+1864  U+5065  uni5065,  CJK UNIFIED IDEOGRAPH-5065
        0x517C, # G+1865  U+517C  uni517C,  CJK UNIFIED IDEOGRAPH-517C
        0x5238, # G+1866  U+5238  uni5238,  CJK UNIFIED IDEOGRAPH-5238
        0x5263, # G+1867  U+5263  uni5263,  CJK UNIFIED IDEOGRAPH-5263
        0x55A7, # G+1868  U+55A7  uni55A7,  CJK UNIFIED IDEOGRAPH-55A7
        0x570F, # G+1869  U+570F  uni570F,  CJK UNIFIED IDEOGRAPH-570F
        0x5805, # G+1870  U+5805  uni5805,  CJK UNIFIED IDEOGRAPH-5805
        0x5ACC, # G+1871  U+5ACC  uni5ACC,  CJK UNIFIED IDEOGRAPH-5ACC
        0x5EFA, # G+1872  U+5EFA  uni5EFA,  CJK UNIFIED IDEOGRAPH-5EFA
        0x61B2, # G+1873  U+61B2  uni61B2,  CJK UNIFIED IDEOGRAPH-61B2
        0x61F8, # G+1874  U+61F8  uni61F8,  CJK UNIFIED IDEOGRAPH-61F8
        0x62F3, # G+1875  U+62F3  uni62F3,  CJK UNIFIED IDEOGRAPH-62F3
        0x6372, # G+1876  U+6372  uni6372,  CJK UNIFIED IDEOGRAPH-6372
        0x691C, # G+1877  U+691C  uni691C,  CJK UNIFIED IDEOGRAPH-691C
        0x6A29, # G+1878  U+6A29  uni6A29,  CJK UNIFIED IDEOGRAPH-6A29
        0x727D, # G+1879  U+727D  uni727D,  CJK UNIFIED IDEOGRAPH-727D
        0x2F5D, # G+1880  U+2F5D  uni2F5D,  KANGXI RADICAL DOG
        0x732E, # G+1881  U+732E  uni732E,  CJK UNIFIED IDEOGRAPH-732E
        0x7814, # G+1882  U+7814  uni7814,  CJK UNIFIED IDEOGRAPH-7814
        0x786F, # G+1883  U+786F  uni786F,  CJK UNIFIED IDEOGRAPH-786F
        0x7D79, # G+1884  U+7D79  uni7D79,  CJK UNIFIED IDEOGRAPH-7D79
        0x770C, # G+1885  U+770C  uni770C,  CJK UNIFIED IDEOGRAPH-770C
        0x80A9, # G+1886  U+80A9  uni80A9,  CJK UNIFIED IDEOGRAPH-80A9
        0x2F92, # G+1887  U+2F92  uni2F92,  KANGXI RADICAL SEE
        0x8B19, # G+1888  U+8B19  uni8B19,  CJK UNIFIED IDEOGRAPH-8B19
        0x8CE2, # G+1889  U+8CE2  uni8CE2,  CJK UNIFIED IDEOGRAPH-8CE2
        0x8ED2, # G+1890  U+8ED2  uni8ED2,  CJK UNIFIED IDEOGRAPH-8ED2
        0x9063, # G+1891  U+9063  uni9063,  CJK UNIFIED IDEOGRAPH-9063
        0x9375, # G+1892  U+9375  uni9375,  CJK UNIFIED IDEOGRAPH-9375
        0x967A, # G+1893  U+967A  uni967A,  CJK UNIFIED IDEOGRAPH-967A
        0x9855, # G+1894  U+9855  uni9855,  CJK UNIFIED IDEOGRAPH-9855
        0x9A13, # G+1895  U+9A13  uni9A13,  CJK UNIFIED IDEOGRAPH-9A13
        0x9E78, # G+1896  U+9E78  uni9E78,  CJK UNIFIED IDEOGRAPH-9E78
        0x5143, # G+1897  U+5143  uni5143,  CJK UNIFIED IDEOGRAPH-5143
        0x539F, # G+1898  U+539F  uni539F,  CJK UNIFIED IDEOGRAPH-539F
        0x53B3, # G+1899  U+53B3  uni53B3,  CJK UNIFIED IDEOGRAPH-53B3
        0x5E7B, # G+1900  U+5E7B  uni5E7B,  CJK UNIFIED IDEOGRAPH-5E7B
        0x5F26, # G+1901  U+5F26  uni5F26,  CJK UNIFIED IDEOGRAPH-5F26
        0x6E1B, # G+1902  U+6E1B  uni6E1B,  CJK UNIFIED IDEOGRAPH-6E1B
        0x6E90, # G+1903  U+6E90  uni6E90,  CJK UNIFIED IDEOGRAPH-6E90
        0x2F5E, # G+1904  U+2F5E  uni2F5E,  KANGXI RADICAL PROFOUND
        0x73FE, # G+1905  U+73FE  uni73FE,  CJK UNIFIED IDEOGRAPH-73FE
        0x7D43, # G+1906  U+7D43  uni7D43,  CJK UNIFIED IDEOGRAPH-7D43
        0x8237, # G+1907  U+8237  uni8237,  CJK UNIFIED IDEOGRAPH-8237
        0x2F94, # G+1908  U+2F94  uni2F94,  KANGXI RADICAL SPEECH
        0x8AFA, # G+1909  U+8AFA  uni8AFA,  CJK UNIFIED IDEOGRAPH-8AFA
        0x9650, # G+1910  U+9650  uni9650,  CJK UNIFIED IDEOGRAPH-9650
        0x4E4E, # G+1911  U+4E4E  uni4E4E,  CJK UNIFIED IDEOGRAPH-4E4E
        0x500B, # G+1912  U+500B  uni500B,  CJK UNIFIED IDEOGRAPH-500B
        0x53E4, # G+1913  U+53E4  uni53E4,  CJK UNIFIED IDEOGRAPH-53E4
        0x547C, # G+1914  U+547C  uni547C,  CJK UNIFIED IDEOGRAPH-547C
        0x56FA, # G+1915  U+56FA  uni56FA,  CJK UNIFIED IDEOGRAPH-56FA
        0x59D1, # G+1916  U+59D1  uni59D1,  CJK UNIFIED IDEOGRAPH-59D1
        0x5B64, # G+1917  U+5B64  uni5B64,  CJK UNIFIED IDEOGRAPH-5B64
        0x2F30, # G+1918  U+2F30  uni2F30,  KANGXI RADICAL ONESELF
        0x5EAB, # G+1919  U+5EAB  uni5EAB,  CJK UNIFIED IDEOGRAPH-5EAB
        0x5F27, # G+1920  U+5F27  uni5F27,  CJK UNIFIED IDEOGRAPH-5F27
        0x2F3E, # G+1921  U+2F3E  uni2F3E,  KANGXI RADICAL DOOR
        0x6545, # G+1922  U+6545  uni6545,  CJK UNIFIED IDEOGRAPH-6545
        0x67AF, # G+1923  U+67AF  uni67AF,  CJK UNIFIED IDEOGRAPH-67AF
        0x6E56, # G+1924  U+6E56  uni6E56,  CJK UNIFIED IDEOGRAPH-6E56
        0x72D0, # G+1925  U+72D0  uni72D0,  CJK UNIFIED IDEOGRAPH-72D0
        0x7CCA, # G+1926  U+7CCA  uni7CCA,  CJK UNIFIED IDEOGRAPH-7CCA
        0x88B4, # G+1927  U+88B4  uni88B4,  CJK UNIFIED IDEOGRAPH-88B4
        0x80A1, # G+1928  U+80A1  uni80A1,  CJK UNIFIED IDEOGRAPH-80A1
        0x80E1, # G+1929  U+80E1  uni80E1,  CJK UNIFIED IDEOGRAPH-80E1
        0x83F0, # G+1930  U+83F0  uni83F0,  CJK UNIFIED IDEOGRAPH-83F0
        0x2EC1, # G+1931  U+2EC1  uni2EC1,  CJK RADICAL TIGER
        0x8A87, # G+1932  U+8A87  uni8A87,  CJK UNIFIED IDEOGRAPH-8A87
        0x8DE8, # G+1933  U+8DE8  uni8DE8,  CJK UNIFIED IDEOGRAPH-8DE8
        0x9237, # G+1934  U+9237  uni9237,  CJK UNIFIED IDEOGRAPH-9237
        0x96C7, # G+1935  U+96C7  uni96C7,  CJK UNIFIED IDEOGRAPH-96C7
        0x9867, # G+1936  U+9867  uni9867,  CJK UNIFIED IDEOGRAPH-9867
        0x2FCE, # G+1937  U+2FCE  uni2FCE,  KANGXI RADICAL DRUM
        0x4E94, # G+1938  U+4E94  uni4E94,  CJK UNIFIED IDEOGRAPH-4E94
        0x4E92, # G+1939  U+4E92  uni4E92,  CJK UNIFIED IDEOGRAPH-4E92
        0x4F0D, # G+1940  U+4F0D  uni4F0D,  CJK UNIFIED IDEOGRAPH-4F0D
        0x5348, # G+1941  U+5348  uni5348,  CJK UNIFIED IDEOGRAPH-5348
        0x5449, # G+1942  U+5449  uni5449,  CJK UNIFIED IDEOGRAPH-5449
        0x543E, # G+1943  U+543E  uni543E,  CJK UNIFIED IDEOGRAPH-543E
        0x5A2F, # G+1944  U+5A2F  uni5A2F,  CJK UNIFIED IDEOGRAPH-5A2F
        0x5F8C, # G+1945  U+5F8C  uni5F8C,  CJK UNIFIED IDEOGRAPH-5F8C
        0x5FA1, # G+1946  U+5FA1  uni5FA1,  CJK UNIFIED IDEOGRAPH-5FA1
        0x609F, # G+1947  U+609F  uni609F,  CJK UNIFIED IDEOGRAPH-609F
        0x68A7, # G+1948  U+68A7  uni68A7,  CJK UNIFIED IDEOGRAPH-68A7
        0x6A8E, # G+1949  U+6A8E  uni6A8E,  CJK UNIFIED IDEOGRAPH-6A8E
        0x745A, # G+1950  U+745A  uni745A,  CJK UNIFIED IDEOGRAPH-745A
        0x7881, # G+1951  U+7881  uni7881,  CJK UNIFIED IDEOGRAPH-7881
        0x8A9E, # G+1952  U+8A9E  uni8A9E,  CJK UNIFIED IDEOGRAPH-8A9E
        0x8AA4, # G+1953  U+8AA4  uni8AA4,  CJK UNIFIED IDEOGRAPH-8AA4
        0x8B77, # G+1954  U+8B77  uni8B77,  CJK UNIFIED IDEOGRAPH-8B77
        0x9190, # G+1955  U+9190  uni9190,  CJK UNIFIED IDEOGRAPH-9190
        0x4E5E, # G+1956  U+4E5E  uni4E5E,  CJK UNIFIED IDEOGRAPH-4E5E
        0x9BC9, # G+1957  U+9BC9  uni9BC9,  CJK UNIFIED IDEOGRAPH-9BC9
        0x4EA4, # G+1958  U+4EA4  uni4EA4,  CJK UNIFIED IDEOGRAPH-4EA4
        0x4F7C, # G+1959  U+4F7C  uni4F7C,  CJK UNIFIED IDEOGRAPH-4F7C
        0x4FAF, # G+1960  U+4FAF  uni4FAF,  CJK UNIFIED IDEOGRAPH-4FAF
        0x5019, # G+1961  U+5019  uni5019,  CJK UNIFIED IDEOGRAPH-5019
        0x5016, # G+1962  U+5016  uni5016,  CJK UNIFIED IDEOGRAPH-5016
        0x5149, # G+1963  U+5149  uni5149,  CJK UNIFIED IDEOGRAPH-5149
        0x516C, # G+1964  U+516C  uni516C,  CJK UNIFIED IDEOGRAPH-516C
        0x529F, # G+1965  U+529F  uni529F,  CJK UNIFIED IDEOGRAPH-529F
        0x52B9, # G+1966  U+52B9  uni52B9,  CJK UNIFIED IDEOGRAPH-52B9
        0x52FE, # G+1967  U+52FE  uni52FE,  CJK UNIFIED IDEOGRAPH-52FE
        0x539A, # G+1968  U+539A  uni539A,  CJK UNIFIED IDEOGRAPH-539A
        0x2F1D, # G+1969  U+2F1D  uni2F1D,  KANGXI RADICAL MOUTH
        0x5411, # G+1970  U+5411  uni5411,  CJK UNIFIED IDEOGRAPH-5411
        0x540E, # G+1971  U+540E  uni540E,  CJK UNIFIED IDEOGRAPH-540E
        0x5589, # G+1972  U+5589  uni5589,  CJK UNIFIED IDEOGRAPH-5589
        0x5751, # G+1973  U+5751  uni5751,  CJK UNIFIED IDEOGRAPH-5751
        0x57A2, # G+1974  U+57A2  uni57A2,  CJK UNIFIED IDEOGRAPH-57A2
        0x597D, # G+1975  U+597D  uni597D,  CJK UNIFIED IDEOGRAPH-597D
        0x5B54, # G+1976  U+5B54  uni5B54,  CJK UNIFIED IDEOGRAPH-5B54
        0x5B5D, # G+1977  U+5B5D  uni5B5D,  CJK UNIFIED IDEOGRAPH-5B5D
        0x5B8F, # G+1978  U+5B8F  uni5B8F,  CJK UNIFIED IDEOGRAPH-5B8F
        0x2F2F, # G+1979  U+2F2F  uni2F2F,  KANGXI RADICAL WORK
        0x5DE7, # G+1980  U+5DE7  uni5DE7,  CJK UNIFIED IDEOGRAPH-5DE7
        0x5DF7, # G+1981  U+5DF7  uni5DF7,  CJK UNIFIED IDEOGRAPH-5DF7
        0x5E78, # G+1982  U+5E78  uni5E78,  CJK UNIFIED IDEOGRAPH-5E78
        0x5E83, # G+1983  U+5E83  uni5E83,  CJK UNIFIED IDEOGRAPH-5E83
        0x5E9A, # G+1984  U+5E9A  uni5E9A,  CJK UNIFIED IDEOGRAPH-5E9A
        0x5EB7, # G+1985  U+5EB7  uni5EB7,  CJK UNIFIED IDEOGRAPH-5EB7
        0x5F18, # G+1986  U+5F18  uni5F18,  CJK UNIFIED IDEOGRAPH-5F18
        0x6052, # G+1987  U+6052  uni6052,  CJK UNIFIED IDEOGRAPH-6052
        0x614C, # G+1988  U+614C  uni614C,  CJK UNIFIED IDEOGRAPH-614C
        0x6297, # G+1989  U+6297  uni6297,  CJK UNIFIED IDEOGRAPH-6297
        0x62D8, # G+1990  U+62D8  uni62D8,  CJK UNIFIED IDEOGRAPH-62D8
        0x63A7, # G+1991  U+63A7  uni63A7,  CJK UNIFIED IDEOGRAPH-63A7
        0x653B, # G+1992  U+653B  uni653B,  CJK UNIFIED IDEOGRAPH-653B
        0x6602, # G+1993  U+6602  uni6602,  CJK UNIFIED IDEOGRAPH-6602
        0x6643, # G+1994  U+6643  uni6643,  CJK UNIFIED IDEOGRAPH-6643
        0x66F4, # G+1995  U+66F4  uni66F4,  CJK UNIFIED IDEOGRAPH-66F4
        0x676D, # G+1996  U+676D  uni676D,  CJK UNIFIED IDEOGRAPH-676D
        0x6821, # G+1997  U+6821  uni6821,  CJK UNIFIED IDEOGRAPH-6821
        0x6897, # G+1998  U+6897  uni6897,  CJK UNIFIED IDEOGRAPH-6897
        0x69CB, # G+1999  U+69CB  uni69CB,  CJK UNIFIED IDEOGRAPH-69CB
        0x6C5F, # G+2000  U+6C5F  uni6C5F,  CJK UNIFIED IDEOGRAPH-6C5F
        0x6D2A, # G+2001  U+6D2A  uni6D2A,  CJK UNIFIED IDEOGRAPH-6D2A
        0x6D69, # G+2002  U+6D69  uni6D69,  CJK UNIFIED IDEOGRAPH-6D69
        0x6E2F, # G+2003  U+6E2F  uni6E2F,  CJK UNIFIED IDEOGRAPH-6E2F
        0x6E9D, # G+2004  U+6E9D  uni6E9D,  CJK UNIFIED IDEOGRAPH-6E9D
        0x7532, # G+2005  U+7532  uni7532,  CJK UNIFIED IDEOGRAPH-7532
        0x7687, # G+2006  U+7687  uni7687,  CJK UNIFIED IDEOGRAPH-7687
        0x786C, # G+2007  U+786C  uni786C,  CJK UNIFIED IDEOGRAPH-786C
        0x7A3F, # G+2008  U+7A3F  uni7A3F,  CJK UNIFIED IDEOGRAPH-7A3F
        0x7CE0, # G+2009  U+7CE0  uni7CE0,  CJK UNIFIED IDEOGRAPH-7CE0
        0x7D05, # G+2010  U+7D05  uni7D05,  CJK UNIFIED IDEOGRAPH-7D05
        0x7D18, # G+2011  U+7D18  uni7D18,  CJK UNIFIED IDEOGRAPH-7D18
        0x7D5E, # G+2012  U+7D5E  uni7D5E,  CJK UNIFIED IDEOGRAPH-7D5E
        0x7DB1, # G+2013  U+7DB1  uni7DB1,  CJK UNIFIED IDEOGRAPH-7DB1
        0x8015, # G+2014  U+8015  uni8015,  CJK UNIFIED IDEOGRAPH-8015
        0x8003, # G+2015  U+8003  uni8003,  CJK UNIFIED IDEOGRAPH-8003
        0x80AF, # G+2016  U+80AF  uni80AF,  CJK UNIFIED IDEOGRAPH-80AF
        0x80B1, # G+2017  U+80B1  uni80B1,  CJK UNIFIED IDEOGRAPH-80B1
        0x8154, # G+2018  U+8154  uni8154,  CJK UNIFIED IDEOGRAPH-8154
        0x818F, # G+2019  U+818F  uni818F,  CJK UNIFIED IDEOGRAPH-818F
        0x822A, # G+2020  U+822A  uni822A,  CJK UNIFIED IDEOGRAPH-822A
        0x8352, # G+2021  U+8352  uni8352,  CJK UNIFIED IDEOGRAPH-8352
        0x2F8F, # G+2022  U+2F8F  uni2F8F,  KANGXI RADICAL WALK ENCLOSURE
        0x8861, # G+2023  U+8861  uni8861,  CJK UNIFIED IDEOGRAPH-8861
        0x8B1B, # G+2024  U+8B1B  uni8B1B,  CJK UNIFIED IDEOGRAPH-8B1B
        0x8CA2, # G+2025  U+8CA2  uni8CA2,  CJK UNIFIED IDEOGRAPH-8CA2
        0x8CFC, # G+2026  U+8CFC  uni8CFC,  CJK UNIFIED IDEOGRAPH-8CFC
        0x90CA, # G+2027  U+90CA  uni90CA,  CJK UNIFIED IDEOGRAPH-90CA
        0x9175, # G+2028  U+9175  uni9175,  CJK UNIFIED IDEOGRAPH-9175
        0x9271, # G+2029  U+9271  uni9271,  CJK UNIFIED IDEOGRAPH-9271
        0x783F, # G+2030  U+783F  uni783F,  CJK UNIFIED IDEOGRAPH-783F
        0x92FC, # G+2031  U+92FC  uni92FC,  CJK UNIFIED IDEOGRAPH-92FC
        0x95A4, # G+2032  U+95A4  uni95A4,  CJK UNIFIED IDEOGRAPH-95A4
        0x964D, # G+2033  U+964D  uni964D,  CJK UNIFIED IDEOGRAPH-964D
        0x9805, # G+2034  U+9805  uni9805,  CJK UNIFIED IDEOGRAPH-9805
        0x2FB9, # G+2035  U+2FB9  uni2FB9,  KANGXI RADICAL FRAGRANT
        0x2FBC, # G+2036  U+2FBC  uni2FBC,  KANGXI RADICAL TALL
        0x9D3B, # G+2037  U+9D3B  uni9D3B,  CJK UNIFIED IDEOGRAPH-9D3B
        0x525B, # G+2038  U+525B  uni525B,  CJK UNIFIED IDEOGRAPH-525B
        0x52AB, # G+2039  U+52AB  uni52AB,  CJK UNIFIED IDEOGRAPH-52AB
        0x53F7, # G+2040  U+53F7  uni53F7,  CJK UNIFIED IDEOGRAPH-53F7
        0x5408, # G+2041  U+5408  uni5408,  CJK UNIFIED IDEOGRAPH-5408
        0x58D5, # G+2042  U+58D5  uni58D5,  CJK UNIFIED IDEOGRAPH-58D5
        0x62F7, # G+2043  U+62F7  uni62F7,  CJK UNIFIED IDEOGRAPH-62F7
        0x6FE0, # G+2044  U+6FE0  uni6FE0,  CJK UNIFIED IDEOGRAPH-6FE0
        0x8C6A, # G+2045  U+8C6A  uni8C6A,  CJK UNIFIED IDEOGRAPH-8C6A
        0x8F5F, # G+2046  U+8F5F  uni8F5F,  CJK UNIFIED IDEOGRAPH-8F5F
        0x9EB9, # G+2047  U+9EB9  uni9EB9,  CJK UNIFIED IDEOGRAPH-9EB9
        0x514B, # G+2048  U+514B  uni514B,  CJK UNIFIED IDEOGRAPH-514B
        0x523B, # G+2049  U+523B  uni523B,  CJK UNIFIED IDEOGRAPH-523B
        0x544A, # G+2050  U+544A  uni544A,  CJK UNIFIED IDEOGRAPH-544A
        0x56FD, # G+2051  U+56FD  uni56FD,  CJK UNIFIED IDEOGRAPH-56FD
        0x7A40, # G+2052  U+7A40  uni7A40,  CJK UNIFIED IDEOGRAPH-7A40
        0x9177, # G+2053  U+9177  uni9177,  CJK UNIFIED IDEOGRAPH-9177
        0x9D60, # G+2054  U+9D60  uni9D60,  CJK UNIFIED IDEOGRAPH-9D60
        0x2FCA, # G+2055  U+2FCA  uni2FCA,  KANGXI RADICAL BLACK
        0x7344, # G+2056  U+7344  uni7344,  CJK UNIFIED IDEOGRAPH-7344
        0x6F09, # G+2057  U+6F09  uni6F09,  CJK UNIFIED IDEOGRAPH-6F09
        0x8170, # G+2058  U+8170  uni8170,  CJK UNIFIED IDEOGRAPH-8170
        0x7511, # G+2059  U+7511  uni7511,  CJK UNIFIED IDEOGRAPH-7511
        0x5FFD, # G+2060  U+5FFD  uni5FFD,  CJK UNIFIED IDEOGRAPH-5FFD
        0x60DA, # G+2061  U+60DA  uni60DA,  CJK UNIFIED IDEOGRAPH-60DA
        0x2FBB, # G+2062  U+2FBB  uni2FBB,  KANGXI RADICAL BONE
        0x72DB, # G+2063  U+72DB  uni72DB,  CJK UNIFIED IDEOGRAPH-72DB
        0x8FBC, # G+2064  U+8FBC  uni8FBC,  CJK UNIFIED IDEOGRAPH-8FBC
        0x6B64, # G+2065  U+6B64  uni6B64,  CJK UNIFIED IDEOGRAPH-6B64
        0x9803, # G+2066  U+9803  uni9803,  CJK UNIFIED IDEOGRAPH-9803
        0x4ECA, # G+2067  U+4ECA  uni4ECA,  CJK UNIFIED IDEOGRAPH-4ECA
        0x56F0, # G+2068  U+56F0  uni56F0,  CJK UNIFIED IDEOGRAPH-56F0
        0x5764, # G+2069  U+5764  uni5764,  CJK UNIFIED IDEOGRAPH-5764
        0x58BE, # G+2070  U+58BE  uni58BE,  CJK UNIFIED IDEOGRAPH-58BE
        0x5A5A, # G+2071  U+5A5A  uni5A5A,  CJK UNIFIED IDEOGRAPH-5A5A
        0x6068, # G+2072  U+6068  uni6068,  CJK UNIFIED IDEOGRAPH-6068
        0x61C7, # G+2073  U+61C7  uni61C7,  CJK UNIFIED IDEOGRAPH-61C7
        0x660F, # G+2074  U+660F  uni660F,  CJK UNIFIED IDEOGRAPH-660F
        0x6606, # G+2075  U+6606  uni6606,  CJK UNIFIED IDEOGRAPH-6606
        0x6839, # G+2076  U+6839  uni6839,  CJK UNIFIED IDEOGRAPH-6839
        0x68B1, # G+2077  U+68B1  uni68B1,  CJK UNIFIED IDEOGRAPH-68B1
        0x6DF7, # G+2078  U+6DF7  uni6DF7,  CJK UNIFIED IDEOGRAPH-6DF7
        0x75D5, # G+2079  U+75D5  uni75D5,  CJK UNIFIED IDEOGRAPH-75D5
        0x7D3A, # G+2080  U+7D3A  uni7D3A,  CJK UNIFIED IDEOGRAPH-7D3A
        0x2F89, # G+2081  U+2F89  uni2F89,  KANGXI RADICAL STOPPING
        0x9B42, # G+2082  U+9B42  uni9B42,  CJK UNIFIED IDEOGRAPH-9B42
        0x4E9B, # G+2083  U+4E9B  uni4E9B,  CJK UNIFIED IDEOGRAPH-4E9B
        0x4F50, # G+2084  U+4F50  uni4F50,  CJK UNIFIED IDEOGRAPH-4F50
        0x53C9, # G+2085  U+53C9  uni53C9,  CJK UNIFIED IDEOGRAPH-53C9
        0x5506, # G+2086  U+5506  uni5506,  CJK UNIFIED IDEOGRAPH-5506
        0x5D6F, # G+2087  U+5D6F  uni5D6F,  CJK UNIFIED IDEOGRAPH-5D6F
        0x5DE6, # G+2088  U+5DE6  uni5DE6,  CJK UNIFIED IDEOGRAPH-5DE6
        0x5DEE, # G+2089  U+5DEE  uni5DEE,  CJK UNIFIED IDEOGRAPH-5DEE
        0x67FB, # G+2090  U+67FB  uni67FB,  CJK UNIFIED IDEOGRAPH-67FB
        0x6C99, # G+2091  U+6C99  uni6C99,  CJK UNIFIED IDEOGRAPH-6C99
        0x7473, # G+2092  U+7473  uni7473,  CJK UNIFIED IDEOGRAPH-7473
        0x7802, # G+2093  U+7802  uni7802,  CJK UNIFIED IDEOGRAPH-7802
        0x8A50, # G+2094  U+8A50  uni8A50,  CJK UNIFIED IDEOGRAPH-8A50
        0x9396, # G+2095  U+9396  uni9396,  CJK UNIFIED IDEOGRAPH-9396
        0x88DF, # G+2096  U+88DF  uni88DF,  CJK UNIFIED IDEOGRAPH-88DF
        0x5750, # G+2097  U+5750  uni5750,  CJK UNIFIED IDEOGRAPH-5750
        0x5EA7, # G+2098  U+5EA7  uni5EA7,  CJK UNIFIED IDEOGRAPH-5EA7
        0x632B, # G+2099  U+632B  uni632B,  CJK UNIFIED IDEOGRAPH-632B
        0x50B5, # G+2100  U+50B5  uni50B5,  CJK UNIFIED IDEOGRAPH-50B5
        0x50AC, # G+2101  U+50AC  uni50AC,  CJK UNIFIED IDEOGRAPH-50AC
        0x518D, # G+2102  U+518D  uni518D,  CJK UNIFIED IDEOGRAPH-518D
        0x6700, # G+2103  U+6700  uni6700,  CJK UNIFIED IDEOGRAPH-6700
        0x54C9, # G+2104  U+54C9  uni54C9,  CJK UNIFIED IDEOGRAPH-54C9
        0x585E, # G+2105  U+585E  uni585E,  CJK UNIFIED IDEOGRAPH-585E
        0x59BB, # G+2106  U+59BB  uni59BB,  CJK UNIFIED IDEOGRAPH-59BB
        0x5BB0, # G+2107  U+5BB0  uni5BB0,  CJK UNIFIED IDEOGRAPH-5BB0
        0x5F69, # G+2108  U+5F69  uni5F69,  CJK UNIFIED IDEOGRAPH-5F69
        0x624D, # G+2109  U+624D  uni624D,  CJK UNIFIED IDEOGRAPH-624D
        0x63A1, # G+2110  U+63A1  uni63A1,  CJK UNIFIED IDEOGRAPH-63A1
        0x683D, # G+2111  U+683D  uni683D,  CJK UNIFIED IDEOGRAPH-683D
        0x6B73, # G+2112  U+6B73  uni6B73,  CJK UNIFIED IDEOGRAPH-6B73
        0x6E08, # G+2113  U+6E08  uni6E08,  CJK UNIFIED IDEOGRAPH-6E08
        0x707D, # G+2114  U+707D  uni707D,  CJK UNIFIED IDEOGRAPH-707D
        0x91C7, # G+2115  U+91C7  uni91C7,  CJK UNIFIED IDEOGRAPH-91C7
        0x7280, # G+2116  U+7280  uni7280,  CJK UNIFIED IDEOGRAPH-7280
        0x7815, # G+2117  U+7815  uni7815,  CJK UNIFIED IDEOGRAPH-7815
        0x7826, # G+2118  U+7826  uni7826,  CJK UNIFIED IDEOGRAPH-7826
        0x796D, # G+2119  U+796D  uni796D,  CJK UNIFIED IDEOGRAPH-796D
        0x658E, # G+2120  U+658E  uni658E,  CJK UNIFIED IDEOGRAPH-658E
        0x7D30, # G+2121  U+7D30  uni7D30,  CJK UNIFIED IDEOGRAPH-7D30
        0x83DC, # G+2122  U+83DC  uni83DC,  CJK UNIFIED IDEOGRAPH-83DC
        0x88C1, # G+2123  U+88C1  uni88C1,  CJK UNIFIED IDEOGRAPH-88C1
        0x8F09, # G+2124  U+8F09  uni8F09,  CJK UNIFIED IDEOGRAPH-8F09
        0x969B, # G+2125  U+969B  uni969B,  CJK UNIFIED IDEOGRAPH-969B
        0x5264, # G+2126  U+5264  uni5264,  CJK UNIFIED IDEOGRAPH-5264
        0x5728, # G+2127  U+5728  uni5728,  CJK UNIFIED IDEOGRAPH-5728
        0x6750, # G+2128  U+6750  uni6750,  CJK UNIFIED IDEOGRAPH-6750
        0x7F6A, # G+2129  U+7F6A  uni7F6A,  CJK UNIFIED IDEOGRAPH-7F6A
        0x8CA1, # G+2130  U+8CA1  uni8CA1,  CJK UNIFIED IDEOGRAPH-8CA1
        0x51B4, # G+2131  U+51B4  uni51B4,  CJK UNIFIED IDEOGRAPH-51B4
        0x5742, # G+2132  U+5742  uni5742,  CJK UNIFIED IDEOGRAPH-5742
        0x962A, # G+2133  U+962A  uni962A,  CJK UNIFIED IDEOGRAPH-962A
        0x583A, # G+2134  U+583A  uni583A,  CJK UNIFIED IDEOGRAPH-583A
        0x698A, # G+2135  U+698A  uni698A,  CJK UNIFIED IDEOGRAPH-698A
        0x80B4, # G+2136  U+80B4  uni80B4,  CJK UNIFIED IDEOGRAPH-80B4
        0x54B2, # G+2137  U+54B2  uni54B2,  CJK UNIFIED IDEOGRAPH-54B2
        0x5D0E, # G+2138  U+5D0E  uni5D0E,  CJK UNIFIED IDEOGRAPH-5D0E
        0x57FC, # G+2139  U+57FC  uni57FC,  CJK UNIFIED IDEOGRAPH-57FC
        0x7895, # G+2140  U+7895  uni7895,  CJK UNIFIED IDEOGRAPH-7895
        0x9DFA, # G+2141  U+9DFA  uni9DFA,  CJK UNIFIED IDEOGRAPH-9DFA
        0x4F5C, # G+2142  U+4F5C  uni4F5C,  CJK UNIFIED IDEOGRAPH-4F5C
        0x524A, # G+2143  U+524A  uni524A,  CJK UNIFIED IDEOGRAPH-524A
        0x548B, # G+2144  U+548B  uni548B,  CJK UNIFIED IDEOGRAPH-548B
        0x643E, # G+2145  U+643E  uni643E,  CJK UNIFIED IDEOGRAPH-643E
        0x6628, # G+2146  U+6628  uni6628,  CJK UNIFIED IDEOGRAPH-6628
        0x6714, # G+2147  U+6714  uni6714,  CJK UNIFIED IDEOGRAPH-6714
        0x67F5, # G+2148  U+67F5  uni67F5,  CJK UNIFIED IDEOGRAPH-67F5
        0x7A84, # G+2149  U+7A84  uni7A84,  CJK UNIFIED IDEOGRAPH-7A84
        0x7B56, # G+2150  U+7B56  uni7B56,  CJK UNIFIED IDEOGRAPH-7B56
        0x7D22, # G+2151  U+7D22  uni7D22,  CJK UNIFIED IDEOGRAPH-7D22
        0x932F, # G+2152  U+932F  uni932F,  CJK UNIFIED IDEOGRAPH-932F
        0x685C, # G+2153  U+685C  uni685C,  CJK UNIFIED IDEOGRAPH-685C
        0x9BAD, # G+2154  U+9BAD  uni9BAD,  CJK UNIFIED IDEOGRAPH-9BAD
        0x7B39, # G+2155  U+7B39  uni7B39,  CJK UNIFIED IDEOGRAPH-7B39
        0x5319, # G+2156  U+5319  uni5319,  CJK UNIFIED IDEOGRAPH-5319
        0x518A, # G+2157  U+518A  uni518A,  CJK UNIFIED IDEOGRAPH-518A
        0x5237, # G+2158  U+5237  uni5237,  CJK UNIFIED IDEOGRAPH-5237
        0x5BDF, # G+2159  U+5BDF  uni5BDF,  CJK UNIFIED IDEOGRAPH-5BDF
        0x62F6, # G+2160  U+62F6  uni62F6,  CJK UNIFIED IDEOGRAPH-62F6
        0x64AE, # G+2161  U+64AE  uni64AE,  CJK UNIFIED IDEOGRAPH-64AE
        0x64E6, # G+2162  U+64E6  uni64E6,  CJK UNIFIED IDEOGRAPH-64E6
        0x672D, # G+2163  U+672D  uni672D,  CJK UNIFIED IDEOGRAPH-672D
        0x6BBA, # G+2164  U+6BBA  uni6BBA,  CJK UNIFIED IDEOGRAPH-6BBA
        0x85A9, # G+2165  U+85A9  uni85A9,  CJK UNIFIED IDEOGRAPH-85A9
        0x96D1, # G+2166  U+96D1  uni96D1,  CJK UNIFIED IDEOGRAPH-96D1
        0x7690, # G+2167  U+7690  uni7690,  CJK UNIFIED IDEOGRAPH-7690
        0x9BD6, # G+2168  U+9BD6  uni9BD6,  CJK UNIFIED IDEOGRAPH-9BD6
        0x634C, # G+2169  U+634C  uni634C,  CJK UNIFIED IDEOGRAPH-634C
        0x9306, # G+2170  U+9306  uni9306,  CJK UNIFIED IDEOGRAPH-9306
        0x9BAB, # G+2171  U+9BAB  uni9BAB,  CJK UNIFIED IDEOGRAPH-9BAB
        0x2F6B, # G+2172  U+2F6B  uni2F6B,  KANGXI RADICAL DISH
        0x6652, # G+2173  U+6652  uni6652,  CJK UNIFIED IDEOGRAPH-6652
        0x4E09, # G+2174  U+4E09  uni4E09,  CJK UNIFIED IDEOGRAPH-4E09
        0x5098, # G+2175  U+5098  uni5098,  CJK UNIFIED IDEOGRAPH-5098
        0x53C2, # G+2176  U+53C2  uni53C2,  CJK UNIFIED IDEOGRAPH-53C2
        0x2F2D, # G+2177  U+2F2D  uni2F2D,  KANGXI RADICAL MOUNTAIN
        0x60E8, # G+2178  U+60E8  uni60E8,  CJK UNIFIED IDEOGRAPH-60E8
        0x6492, # G+2179  U+6492  uni6492,  CJK UNIFIED IDEOGRAPH-6492
        0x6563, # G+2180  U+6563  uni6563,  CJK UNIFIED IDEOGRAPH-6563
        0x685F, # G+2181  U+685F  uni685F,  CJK UNIFIED IDEOGRAPH-685F
        0x71E6, # G+2182  U+71E6  uni71E6,  CJK UNIFIED IDEOGRAPH-71E6
        0x73CA, # G+2183  U+73CA  uni73CA,  CJK UNIFIED IDEOGRAPH-73CA
        0x7523, # G+2184  U+7523  uni7523,  CJK UNIFIED IDEOGRAPH-7523
        0x7B97, # G+2185  U+7B97  uni7B97,  CJK UNIFIED IDEOGRAPH-7B97
        0x7E82, # G+2186  U+7E82  uni7E82,  CJK UNIFIED IDEOGRAPH-7E82
        0x8695, # G+2187  U+8695  uni8695,  CJK UNIFIED IDEOGRAPH-8695
        0x8B83, # G+2188  U+8B83  uni8B83,  CJK UNIFIED IDEOGRAPH-8B83
        0x8CDB, # G+2189  U+8CDB  uni8CDB,  CJK UNIFIED IDEOGRAPH-8CDB
        0x9178, # G+2190  U+9178  uni9178,  CJK UNIFIED IDEOGRAPH-9178
        0x9910, # G+2191  U+9910  uni9910,  CJK UNIFIED IDEOGRAPH-9910
        0x65AC, # G+2192  U+65AC  uni65AC,  CJK UNIFIED IDEOGRAPH-65AC
        0x66AB, # G+2193  U+66AB  uni66AB,  CJK UNIFIED IDEOGRAPH-66AB
        0x6B8B, # G+2194  U+6B8B  uni6B8B,  CJK UNIFIED IDEOGRAPH-6B8B
        0x4ED5, # G+2195  U+4ED5  uni4ED5,  CJK UNIFIED IDEOGRAPH-4ED5
        0x4ED4, # G+2196  U+4ED4  uni4ED4,  CJK UNIFIED IDEOGRAPH-4ED4
        0x4F3A, # G+2197  U+4F3A  uni4F3A,  CJK UNIFIED IDEOGRAPH-4F3A
        0x4F7F, # G+2198  U+4F7F  uni4F7F,  CJK UNIFIED IDEOGRAPH-4F7F
        0x523A, # G+2199  U+523A  uni523A,  CJK UNIFIED IDEOGRAPH-523A
        0x53F8, # G+2200  U+53F8  uni53F8,  CJK UNIFIED IDEOGRAPH-53F8
        0x53F2, # G+2201  U+53F2  uni53F2,  CJK UNIFIED IDEOGRAPH-53F2
        0x55E3, # G+2202  U+55E3  uni55E3,  CJK UNIFIED IDEOGRAPH-55E3
        0x56DB, # G+2203  U+56DB  uni56DB,  CJK UNIFIED IDEOGRAPH-56DB
        0x2F20, # G+2204  U+2F20  uni2F20,  KANGXI RADICAL SCHOLAR
        0x59CB, # G+2205  U+59CB  uni59CB,  CJK UNIFIED IDEOGRAPH-59CB
        0x59C9, # G+2206  U+59C9  uni59C9,  CJK UNIFIED IDEOGRAPH-59C9
        0x59FF, # G+2207  U+59FF  uni59FF,  CJK UNIFIED IDEOGRAPH-59FF
        0x2F26, # G+2208  U+2F26  uni2F26,  KANGXI RADICAL CHILD
        0x5C4D, # G+2209  U+5C4D  uni5C4D,  CJK UNIFIED IDEOGRAPH-5C4D
        0x5E02, # G+2210  U+5E02  uni5E02,  CJK UNIFIED IDEOGRAPH-5E02
        0x5E2B, # G+2211  U+5E2B  uni5E2B,  CJK UNIFIED IDEOGRAPH-5E2B
        0x5FD7, # G+2212  U+5FD7  uni5FD7,  CJK UNIFIED IDEOGRAPH-5FD7
        0x601D, # G+2213  U+601D  uni601D,  CJK UNIFIED IDEOGRAPH-601D
        0x6307, # G+2214  U+6307  uni6307,  CJK UNIFIED IDEOGRAPH-6307
        0x2F40, # G+2215  U+2F40  uni2F40,  KANGXI RADICAL BRANCH
        0x5B5C, # G+2216  U+5B5C  uni5B5C,  CJK UNIFIED IDEOGRAPH-5B5C
        0x65AF, # G+2217  U+65AF  uni65AF,  CJK UNIFIED IDEOGRAPH-65AF
        0x65BD, # G+2218  U+65BD  uni65BD,  CJK UNIFIED IDEOGRAPH-65BD
        0x65E8, # G+2219  U+65E8  uni65E8,  CJK UNIFIED IDEOGRAPH-65E8
        0x679D, # G+2220  U+679D  uni679D,  CJK UNIFIED IDEOGRAPH-679D
        0x2F4C, # G+2221  U+2F4C  uni2F4C,  KANGXI RADICAL STOP
        0x6B7B, # G+2222  U+6B7B  uni6B7B,  CJK UNIFIED IDEOGRAPH-6B7B
        0x2F52, # G+2223  U+2F52  uni2F52,  KANGXI RADICAL CLAN
        0x7345, # G+2224  U+7345  uni7345,  CJK UNIFIED IDEOGRAPH-7345
        0x7949, # G+2225  U+7949  uni7949,  CJK UNIFIED IDEOGRAPH-7949
        0x79C1, # G+2226  U+79C1  uni79C1,  CJK UNIFIED IDEOGRAPH-79C1
        0x2F77, # G+2227  U+2F77  uni2F77,  KANGXI RADICAL SILK
        0x7D19, # G+2228  U+7D19  uni7D19,  CJK UNIFIED IDEOGRAPH-7D19
        0x7D2B, # G+2229  U+7D2B  uni7D2B,  CJK UNIFIED IDEOGRAPH-7D2B
        0x80A2, # G+2230  U+80A2  uni80A2,  CJK UNIFIED IDEOGRAPH-80A2
        0x8102, # G+2231  U+8102  uni8102,  CJK UNIFIED IDEOGRAPH-8102
        0x2F84, # G+2232  U+2F84  uni2F84,  KANGXI RADICAL ARRIVE
        0x8996, # G+2233  U+8996  uni8996,  CJK UNIFIED IDEOGRAPH-8996
        0x8A5E, # G+2234  U+8A5E  uni8A5E,  CJK UNIFIED IDEOGRAPH-8A5E
        0x8A69, # G+2235  U+8A69  uni8A69,  CJK UNIFIED IDEOGRAPH-8A69
        0x8A66, # G+2236  U+8A66  uni8A66,  CJK UNIFIED IDEOGRAPH-8A66
        0x8A8C, # G+2237  U+8A8C  uni8A8C,  CJK UNIFIED IDEOGRAPH-8A8C
        0x8AEE, # G+2238  U+8AEE  uni8AEE,  CJK UNIFIED IDEOGRAPH-8AEE
        0x8CC7, # G+2239  U+8CC7  uni8CC7,  CJK UNIFIED IDEOGRAPH-8CC7
        0x8CDC, # G+2240  U+8CDC  uni8CDC,  CJK UNIFIED IDEOGRAPH-8CDC
        0x96CC, # G+2241  U+96CC  uni96CC,  CJK UNIFIED IDEOGRAPH-96CC
        0x98FC, # G+2242  U+98FC  uni98FC,  CJK UNIFIED IDEOGRAPH-98FC
        0x2EED, # G+2243  U+2EED  uni2EED,  CJK RADICAL J-SIMPLIFIED TOOTH
        0x4E8B, # G+2244  U+4E8B  uni4E8B,  CJK UNIFIED IDEOGRAPH-4E8B
        0x4F3C, # G+2245  U+4F3C  uni4F3C,  CJK UNIFIED IDEOGRAPH-4F3C
        0x4F8D, # G+2246  U+4F8D  uni4F8D,  CJK UNIFIED IDEOGRAPH-4F8D
        0x5150, # G+2247  U+5150  uni5150,  CJK UNIFIED IDEOGRAPH-5150
        0x5B57, # G+2248  U+5B57  uni5B57,  CJK UNIFIED IDEOGRAPH-5B57
        0x5BFA, # G+2249  U+5BFA  uni5BFA,  CJK UNIFIED IDEOGRAPH-5BFA
        0x6148, # G+2250  U+6148  uni6148,  CJK UNIFIED IDEOGRAPH-6148
        0x6301, # G+2251  U+6301  uni6301,  CJK UNIFIED IDEOGRAPH-6301
        0x6642, # G+2252  U+6642  uni6642,  CJK UNIFIED IDEOGRAPH-6642
        0x6B21, # G+2253  U+6B21  uni6B21,  CJK UNIFIED IDEOGRAPH-6B21
        0x6ECB, # G+2254  U+6ECB  uni6ECB,  CJK UNIFIED IDEOGRAPH-6ECB
        0x6CBB, # G+2255  U+6CBB  uni6CBB,  CJK UNIFIED IDEOGRAPH-6CBB
        0x723E, # G+2256  U+723E  uni723E,  CJK UNIFIED IDEOGRAPH-723E
        0x74BD, # G+2257  U+74BD  uni74BD,  CJK UNIFIED IDEOGRAPH-74BD
        0x75D4, # G+2258  U+75D4  uni75D4,  CJK UNIFIED IDEOGRAPH-75D4
        0x78C1, # G+2259  U+78C1  uni78C1,  CJK UNIFIED IDEOGRAPH-78C1
        0x2EAC, # G+2260  U+2EAC  uni2EAC,  CJK RADICAL SPIRIT ONE
        0x2F7D, # G+2261  U+2F7D  uni2F7D,  KANGXI RADICAL AND
        0x2F7F, # G+2262  U+2F7F  uni2F7F,  KANGXI RADICAL EAR
        0x2F83, # G+2263  U+2F83  uni2F83,  KANGXI RADICAL SELF
        0x8494, # G+2264  U+8494  uni8494,  CJK UNIFIED IDEOGRAPH-8494
        0x8F9E, # G+2265  U+8F9E  uni8F9E,  CJK UNIFIED IDEOGRAPH-8F9E
        0x6C50, # G+2266  U+6C50  uni6C50,  CJK UNIFIED IDEOGRAPH-6C50
        0x2FC5, # G+2267  U+2FC5  uni2FC5,  KANGXI RADICAL DEER
        0x5F0F, # G+2268  U+5F0F  uni5F0F,  CJK UNIFIED IDEOGRAPH-5F0F
        0x8B58, # G+2269  U+8B58  uni8B58,  CJK UNIFIED IDEOGRAPH-8B58
        0x9D2B, # G+2270  U+9D2B  uni9D2B,  CJK UNIFIED IDEOGRAPH-9D2B
        0x7AFA, # G+2271  U+7AFA  uni7AFA,  CJK UNIFIED IDEOGRAPH-7AFA
        0x8EF8, # G+2272  U+8EF8  uni8EF8,  CJK UNIFIED IDEOGRAPH-8EF8
        0x5B8D, # G+2273  U+5B8D  uni5B8D,  CJK UNIFIED IDEOGRAPH-5B8D
        0x96EB, # G+2274  U+96EB  uni96EB,  CJK UNIFIED IDEOGRAPH-96EB
        0x4E03, # G+2275  U+4E03  uni4E03,  CJK UNIFIED IDEOGRAPH-4E03
        0x53F1, # G+2276  U+53F1  uni53F1,  CJK UNIFIED IDEOGRAPH-53F1
        0x57F7, # G+2277  U+57F7  uni57F7,  CJK UNIFIED IDEOGRAPH-57F7
        0x5931, # G+2278  U+5931  uni5931,  CJK UNIFIED IDEOGRAPH-5931
        0x5AC9, # G+2279  U+5AC9  uni5AC9,  CJK UNIFIED IDEOGRAPH-5AC9
        0x5BA4, # G+2280  U+5BA4  uni5BA4,  CJK UNIFIED IDEOGRAPH-5BA4
        0x6089, # G+2281  U+6089  uni6089,  CJK UNIFIED IDEOGRAPH-6089
        0x6E7F, # G+2282  U+6E7F  uni6E7F,  CJK UNIFIED IDEOGRAPH-6E7F
        0x6F06, # G+2283  U+6F06  uni6F06,  CJK UNIFIED IDEOGRAPH-6F06
        0x75BE, # G+2284  U+75BE  uni75BE,  CJK UNIFIED IDEOGRAPH-75BE
        0x8CEA, # G+2285  U+8CEA  uni8CEA,  CJK UNIFIED IDEOGRAPH-8CEA
        0x5B9F, # G+2286  U+5B9F  uni5B9F,  CJK UNIFIED IDEOGRAPH-5B9F
        0x8500, # G+2287  U+8500  uni8500,  CJK UNIFIED IDEOGRAPH-8500
        0x7BE0, # G+2288  U+7BE0  uni7BE0,  CJK UNIFIED IDEOGRAPH-7BE0
        0x5072, # G+2289  U+5072  uni5072,  CJK UNIFIED IDEOGRAPH-5072
        0x67F4, # G+2290  U+67F4  uni67F4,  CJK UNIFIED IDEOGRAPH-67F4
        0x829D, # G+2291  U+829D  uni829D,  CJK UNIFIED IDEOGRAPH-829D
        0x5C61, # G+2292  U+5C61  uni5C61,  CJK UNIFIED IDEOGRAPH-5C61
        0x854A, # G+2293  U+854A  uni854A,  CJK UNIFIED IDEOGRAPH-854A
        0x7E1E, # G+2294  U+7E1E  uni7E1E,  CJK UNIFIED IDEOGRAPH-7E1E
        0x820E, # G+2295  U+820E  uni820E,  CJK UNIFIED IDEOGRAPH-820E
        0x5199, # G+2296  U+5199  uni5199,  CJK UNIFIED IDEOGRAPH-5199
        0x5C04, # G+2297  U+5C04  uni5C04,  CJK UNIFIED IDEOGRAPH-5C04
        0x6368, # G+2298  U+6368  uni6368,  CJK UNIFIED IDEOGRAPH-6368
        0x8D66, # G+2299  U+8D66  uni8D66,  CJK UNIFIED IDEOGRAPH-8D66
        0x659C, # G+2300  U+659C  uni659C,  CJK UNIFIED IDEOGRAPH-659C
        0x716E, # G+2301  U+716E  uni716E,  CJK UNIFIED IDEOGRAPH-716E
        0x793E, # G+2302  U+793E  uni793E,  CJK UNIFIED IDEOGRAPH-793E
        0x7D17, # G+2303  U+7D17  uni7D17,  CJK UNIFIED IDEOGRAPH-7D17
        0x8005, # G+2304  U+8005  uni8005,  CJK UNIFIED IDEOGRAPH-8005
        0x8B1D, # G+2305  U+8B1D  uni8B1D,  CJK UNIFIED IDEOGRAPH-8B1D
        0x2F9E, # G+2306  U+2F9E  uni2F9E,  KANGXI RADICAL CART
        0x906E, # G+2307  U+906E  uni906E,  CJK UNIFIED IDEOGRAPH-906E
        0x86C7, # G+2308  U+86C7  uni86C7,  CJK UNIFIED IDEOGRAPH-86C7
        0x90AA, # G+2309  U+90AA  uni90AA,  CJK UNIFIED IDEOGRAPH-90AA
        0x501F, # G+2310  U+501F  uni501F,  CJK UNIFIED IDEOGRAPH-501F
        0x52FA, # G+2311  U+52FA  uni52FA,  CJK UNIFIED IDEOGRAPH-52FA
        0x5C3A, # G+2312  U+5C3A  uni5C3A,  CJK UNIFIED IDEOGRAPH-5C3A
        0x6753, # G+2313  U+6753  uni6753,  CJK UNIFIED IDEOGRAPH-6753
        0x707C, # G+2314  U+707C  uni707C,  CJK UNIFIED IDEOGRAPH-707C
        0x7235, # G+2315  U+7235  uni7235,  CJK UNIFIED IDEOGRAPH-7235
        0x914C, # G+2316  U+914C  uni914C,  CJK UNIFIED IDEOGRAPH-914C
        0x91C8, # G+2317  U+91C8  uni91C8,  CJK UNIFIED IDEOGRAPH-91C8
        0x932B, # G+2318  U+932B  uni932B,  CJK UNIFIED IDEOGRAPH-932B
        0x82E5, # G+2319  U+82E5  uni82E5,  CJK UNIFIED IDEOGRAPH-82E5
        0x5BC2, # G+2320  U+5BC2  uni5BC2,  CJK UNIFIED IDEOGRAPH-5BC2
        0x5F31, # G+2321  U+5F31  uni5F31,  CJK UNIFIED IDEOGRAPH-5F31
        0x60F9, # G+2322  U+60F9  uni60F9,  CJK UNIFIED IDEOGRAPH-60F9
        0x4E3B, # G+2323  U+4E3B  uni4E3B,  CJK UNIFIED IDEOGRAPH-4E3B
        0x53D6, # G+2324  U+53D6  uni53D6,  CJK UNIFIED IDEOGRAPH-53D6
        0x5B88, # G+2325  U+5B88  uni5B88,  CJK UNIFIED IDEOGRAPH-5B88
        0x2F3F, # G+2326  U+2F3F  uni2F3F,  KANGXI RADICAL HAND
        0x6731, # G+2327  U+6731  uni6731,  CJK UNIFIED IDEOGRAPH-6731
        0x6B8A, # G+2328  U+6B8A  uni6B8A,  CJK UNIFIED IDEOGRAPH-6B8A
        0x72E9, # G+2329  U+72E9  uni72E9,  CJK UNIFIED IDEOGRAPH-72E9
        0x73E0, # G+2330  U+73E0  uni73E0,  CJK UNIFIED IDEOGRAPH-73E0
        0x7A2E, # G+2331  U+7A2E  uni7A2E,  CJK UNIFIED IDEOGRAPH-7A2E
        0x816B, # G+2332  U+816B  uni816B,  CJK UNIFIED IDEOGRAPH-816B
        0x8DA3, # G+2333  U+8DA3  uni8DA3,  CJK UNIFIED IDEOGRAPH-8DA3
        0x9152, # G+2334  U+9152  uni9152,  CJK UNIFIED IDEOGRAPH-9152
        0x2FB8, # G+2335  U+2FB8  uni2FB8,  KANGXI RADICAL HEAD
        0x5112, # G+2336  U+5112  uni5112,  CJK UNIFIED IDEOGRAPH-5112
        0x53D7, # G+2337  U+53D7  uni53D7,  CJK UNIFIED IDEOGRAPH-53D7
        0x546A, # G+2338  U+546A  uni546A,  CJK UNIFIED IDEOGRAPH-546A
        0x5BFF, # G+2339  U+5BFF  uni5BFF,  CJK UNIFIED IDEOGRAPH-5BFF
        0x6388, # G+2340  U+6388  uni6388,  CJK UNIFIED IDEOGRAPH-6388
        0x6A39, # G+2341  U+6A39  uni6A39,  CJK UNIFIED IDEOGRAPH-6A39
        0x7DAC, # G+2342  U+7DAC  uni7DAC,  CJK UNIFIED IDEOGRAPH-7DAC
        0x9700, # G+2343  U+9700  uni9700,  CJK UNIFIED IDEOGRAPH-9700
        0x56DA, # G+2344  U+56DA  uni56DA,  CJK UNIFIED IDEOGRAPH-56DA
        0x53CE, # G+2345  U+53CE  uni53CE,  CJK UNIFIED IDEOGRAPH-53CE
        0x5468, # G+2346  U+5468  uni5468,  CJK UNIFIED IDEOGRAPH-5468
        0x5B97, # G+2347  U+5B97  uni5B97,  CJK UNIFIED IDEOGRAPH-5B97
        0x5C31, # G+2348  U+5C31  uni5C31,  CJK UNIFIED IDEOGRAPH-5C31
        0x5DDE, # G+2349  U+5DDE  uni5DDE,  CJK UNIFIED IDEOGRAPH-5DDE
        0x4FEE, # G+2350  U+4FEE  uni4FEE,  CJK UNIFIED IDEOGRAPH-4FEE
        0x6101, # G+2351  U+6101  uni6101,  CJK UNIFIED IDEOGRAPH-6101
        0x62FE, # G+2352  U+62FE  uni62FE,  CJK UNIFIED IDEOGRAPH-62FE
        0x6D32, # G+2353  U+6D32  uni6D32,  CJK UNIFIED IDEOGRAPH-6D32
        0x79C0, # G+2354  U+79C0  uni79C0,  CJK UNIFIED IDEOGRAPH-79C0
        0x79CB, # G+2355  U+79CB  uni79CB,  CJK UNIFIED IDEOGRAPH-79CB
        0x7D42, # G+2356  U+7D42  uni7D42,  CJK UNIFIED IDEOGRAPH-7D42
        0x7E4D, # G+2357  U+7E4D  uni7E4D,  CJK UNIFIED IDEOGRAPH-7E4D
        0x7FD2, # G+2358  U+7FD2  uni7FD2,  CJK UNIFIED IDEOGRAPH-7FD2
        0x81ED, # G+2359  U+81ED  uni81ED,  CJK UNIFIED IDEOGRAPH-81ED
        0x2F88, # G+2360  U+2F88  uni2F88,  KANGXI RADICAL BOAT
        0x8490, # G+2361  U+8490  uni8490,  CJK UNIFIED IDEOGRAPH-8490
        0x8846, # G+2362  U+8846  uni8846,  CJK UNIFIED IDEOGRAPH-8846
        0x8972, # G+2363  U+8972  uni8972,  CJK UNIFIED IDEOGRAPH-8972
        0x8B90, # G+2364  U+8B90  uni8B90,  CJK UNIFIED IDEOGRAPH-8B90
        0x8E74, # G+2365  U+8E74  uni8E74,  CJK UNIFIED IDEOGRAPH-8E74
        0x8F2F, # G+2366  U+8F2F  uni8F2F,  CJK UNIFIED IDEOGRAPH-8F2F
        0x9031, # G+2367  U+9031  uni9031,  CJK UNIFIED IDEOGRAPH-9031
        0x914B, # G+2368  U+914B  uni914B,  CJK UNIFIED IDEOGRAPH-914B
        0x916C, # G+2369  U+916C  uni916C,  CJK UNIFIED IDEOGRAPH-916C
        0x96C6, # G+2370  U+96C6  uni96C6,  CJK UNIFIED IDEOGRAPH-96C6
        0x919C, # G+2371  U+919C  uni919C,  CJK UNIFIED IDEOGRAPH-919C
        0x4EC0, # G+2372  U+4EC0  uni4EC0,  CJK UNIFIED IDEOGRAPH-4EC0
        0x4F4F, # G+2373  U+4F4F  uni4F4F,  CJK UNIFIED IDEOGRAPH-4F4F
        0x5145, # G+2374  U+5145  uni5145,  CJK UNIFIED IDEOGRAPH-5145
        0x2F17, # G+2375  U+2F17  uni2F17,  KANGXI RADICAL TEN
        0x5F93, # G+2376  U+5F93  uni5F93,  CJK UNIFIED IDEOGRAPH-5F93
        0x620E, # G+2377  U+620E  uni620E,  CJK UNIFIED IDEOGRAPH-620E
        0x67D4, # G+2378  U+67D4  uni67D4,  CJK UNIFIED IDEOGRAPH-67D4
        0x6C41, # G+2379  U+6C41  uni6C41,  CJK UNIFIED IDEOGRAPH-6C41
        0x6E0B, # G+2380  U+6E0B  uni6E0B,  CJK UNIFIED IDEOGRAPH-6E0B
        0x7363, # G+2381  U+7363  uni7363,  CJK UNIFIED IDEOGRAPH-7363
        0x7E26, # G+2382  U+7E26  uni7E26,  CJK UNIFIED IDEOGRAPH-7E26
        0x91CD, # G+2383  U+91CD  uni91CD,  CJK UNIFIED IDEOGRAPH-91CD
        0x9283, # G+2384  U+9283  uni9283,  CJK UNIFIED IDEOGRAPH-9283
        0x53D4, # G+2385  U+53D4  uni53D4,  CJK UNIFIED IDEOGRAPH-53D4
        0x5919, # G+2386  U+5919  uni5919,  CJK UNIFIED IDEOGRAPH-5919
        0x5BBF, # G+2387  U+5BBF  uni5BBF,  CJK UNIFIED IDEOGRAPH-5BBF
        0x6DD1, # G+2388  U+6DD1  uni6DD1,  CJK UNIFIED IDEOGRAPH-6DD1
        0x795D, # G+2389  U+795D  uni795D,  CJK UNIFIED IDEOGRAPH-795D
        0x7E2E, # G+2390  U+7E2E  uni7E2E,  CJK UNIFIED IDEOGRAPH-7E2E
        0x7C9B, # G+2391  U+7C9B  uni7C9B,  CJK UNIFIED IDEOGRAPH-7C9B
        0x587E, # G+2392  U+587E  uni587E,  CJK UNIFIED IDEOGRAPH-587E
        0x719F, # G+2393  U+719F  uni719F,  CJK UNIFIED IDEOGRAPH-719F
        0x51FA, # G+2394  U+51FA  uni51FA,  CJK UNIFIED IDEOGRAPH-51FA
        0x8853, # G+2395  U+8853  uni8853,  CJK UNIFIED IDEOGRAPH-8853
        0x8FF0, # G+2396  U+8FF0  uni8FF0,  CJK UNIFIED IDEOGRAPH-8FF0
        0x4FCA, # G+2397  U+4FCA  uni4FCA,  CJK UNIFIED IDEOGRAPH-4FCA
        0x5CFB, # G+2398  U+5CFB  uni5CFB,  CJK UNIFIED IDEOGRAPH-5CFB
        0x6625, # G+2399  U+6625  uni6625,  CJK UNIFIED IDEOGRAPH-6625
        0x77AC, # G+2400  U+77AC  uni77AC,  CJK UNIFIED IDEOGRAPH-77AC
        0x7AE3, # G+2401  U+7AE3  uni7AE3,  CJK UNIFIED IDEOGRAPH-7AE3
        0x821C, # G+2402  U+821C  uni821C,  CJK UNIFIED IDEOGRAPH-821C
        0x99FF, # G+2403  U+99FF  uni99FF,  CJK UNIFIED IDEOGRAPH-99FF
        0x51C6, # G+2404  U+51C6  uni51C6,  CJK UNIFIED IDEOGRAPH-51C6
        0x5FAA, # G+2405  U+5FAA  uni5FAA,  CJK UNIFIED IDEOGRAPH-5FAA
        0x65EC, # G+2406  U+65EC  uni65EC,  CJK UNIFIED IDEOGRAPH-65EC
        0x696F, # G+2407  U+696F  uni696F,  CJK UNIFIED IDEOGRAPH-696F
        0x6B89, # G+2408  U+6B89  uni6B89,  CJK UNIFIED IDEOGRAPH-6B89
        0x6DF3, # G+2409  U+6DF3  uni6DF3,  CJK UNIFIED IDEOGRAPH-6DF3
        0x6E96, # G+2410  U+6E96  uni6E96,  CJK UNIFIED IDEOGRAPH-6E96
        0x6F64, # G+2411  U+6F64  uni6F64,  CJK UNIFIED IDEOGRAPH-6F64
        0x76FE, # G+2412  U+76FE  uni76FE,  CJK UNIFIED IDEOGRAPH-76FE
        0x7D14, # G+2413  U+7D14  uni7D14,  CJK UNIFIED IDEOGRAPH-7D14
        0x5DE1, # G+2414  U+5DE1  uni5DE1,  CJK UNIFIED IDEOGRAPH-5DE1
        0x9075, # G+2415  U+9075  uni9075,  CJK UNIFIED IDEOGRAPH-9075
        0x9187, # G+2416  U+9187  uni9187,  CJK UNIFIED IDEOGRAPH-9187
        0x9806, # G+2417  U+9806  uni9806,  CJK UNIFIED IDEOGRAPH-9806
        0x51E6, # G+2418  U+51E6  uni51E6,  CJK UNIFIED IDEOGRAPH-51E6
        0x521D, # G+2419  U+521D  uni521D,  CJK UNIFIED IDEOGRAPH-521D
        0x6240, # G+2420  U+6240  uni6240,  CJK UNIFIED IDEOGRAPH-6240
        0x6691, # G+2421  U+6691  uni6691,  CJK UNIFIED IDEOGRAPH-6691
        0x66D9, # G+2422  U+66D9  uni66D9,  CJK UNIFIED IDEOGRAPH-66D9
        0x6E1A, # G+2423  U+6E1A  uni6E1A,  CJK UNIFIED IDEOGRAPH-6E1A
        0x5EB6, # G+2424  U+5EB6  uni5EB6,  CJK UNIFIED IDEOGRAPH-5EB6
        0x7DD2, # G+2425  U+7DD2  uni7DD2,  CJK UNIFIED IDEOGRAPH-7DD2
        0x7F72, # G+2426  U+7F72  uni7F72,  CJK UNIFIED IDEOGRAPH-7F72
        0x66F8, # G+2427  U+66F8  uni66F8,  CJK UNIFIED IDEOGRAPH-66F8
        0x85AF, # G+2428  U+85AF  uni85AF,  CJK UNIFIED IDEOGRAPH-85AF
        0x85F7, # G+2429  U+85F7  uni85F7,  CJK UNIFIED IDEOGRAPH-85F7
        0x8AF8, # G+2430  U+8AF8  uni8AF8,  CJK UNIFIED IDEOGRAPH-8AF8
        0x52A9, # G+2431  U+52A9  uni52A9,  CJK UNIFIED IDEOGRAPH-52A9
        0x53D9, # G+2432  U+53D9  uni53D9,  CJK UNIFIED IDEOGRAPH-53D9
        0x2F25, # G+2433  U+2F25  uni2F25,  KANGXI RADICAL WOMAN
        0x5E8F, # G+2434  U+5E8F  uni5E8F,  CJK UNIFIED IDEOGRAPH-5E8F
        0x5F90, # G+2435  U+5F90  uni5F90,  CJK UNIFIED IDEOGRAPH-5F90
        0x6055, # G+2436  U+6055  uni6055,  CJK UNIFIED IDEOGRAPH-6055
        0x92E4, # G+2437  U+92E4  uni92E4,  CJK UNIFIED IDEOGRAPH-92E4
        0x9664, # G+2438  U+9664  uni9664,  CJK UNIFIED IDEOGRAPH-9664
        0x50B7, # G+2439  U+50B7  uni50B7,  CJK UNIFIED IDEOGRAPH-50B7
        0x511F, # G+2440  U+511F  uni511F,  CJK UNIFIED IDEOGRAPH-511F
        0x52DD, # G+2441  U+52DD  uni52DD,  CJK UNIFIED IDEOGRAPH-52DD
        0x5320, # G+2442  U+5320  uni5320,  CJK UNIFIED IDEOGRAPH-5320
        0x5347, # G+2443  U+5347  uni5347,  CJK UNIFIED IDEOGRAPH-5347
        0x53EC, # G+2444  U+53EC  uni53EC,  CJK UNIFIED IDEOGRAPH-53EC
        0x54E8, # G+2445  U+54E8  uni54E8,  CJK UNIFIED IDEOGRAPH-54E8
        0x5546, # G+2446  U+5546  uni5546,  CJK UNIFIED IDEOGRAPH-5546
        0x5531, # G+2447  U+5531  uni5531,  CJK UNIFIED IDEOGRAPH-5531
        0x5617, # G+2448  U+5617  uni5617,  CJK UNIFIED IDEOGRAPH-5617
        0x5968, # G+2449  U+5968  uni5968,  CJK UNIFIED IDEOGRAPH-5968
        0x59BE, # G+2450  U+59BE  uni59BE,  CJK UNIFIED IDEOGRAPH-59BE
        0x5A3C, # G+2451  U+5A3C  uni5A3C,  CJK UNIFIED IDEOGRAPH-5A3C
        0x5BB5, # G+2452  U+5BB5  uni5BB5,  CJK UNIFIED IDEOGRAPH-5BB5
        0x5C06, # G+2453  U+5C06  uni5C06,  CJK UNIFIED IDEOGRAPH-5C06
        0x2F29, # G+2454  U+2F29  uni2F29,  KANGXI RADICAL SMALL
        0x5C11, # G+2455  U+5C11  uni5C11,  CJK UNIFIED IDEOGRAPH-5C11
        0x5C1A, # G+2456  U+5C1A  uni5C1A,  CJK UNIFIED IDEOGRAPH-5C1A
        0x5E84, # G+2457  U+5E84  uni5E84,  CJK UNIFIED IDEOGRAPH-5E84
        0x5E8A, # G+2458  U+5E8A  uni5E8A,  CJK UNIFIED IDEOGRAPH-5E8A
        0x5EE0, # G+2459  U+5EE0  uni5EE0,  CJK UNIFIED IDEOGRAPH-5EE0
        0x5F70, # G+2460  U+5F70  uni5F70,  CJK UNIFIED IDEOGRAPH-5F70
        0x627F, # G+2461  U+627F  uni627F,  CJK UNIFIED IDEOGRAPH-627F
        0x6284, # G+2462  U+6284  uni6284,  CJK UNIFIED IDEOGRAPH-6284
        0x62DB, # G+2463  U+62DB  uni62DB,  CJK UNIFIED IDEOGRAPH-62DB
        0x638C, # G+2464  U+638C  uni638C,  CJK UNIFIED IDEOGRAPH-638C
        0x6377, # G+2465  U+6377  uni6377,  CJK UNIFIED IDEOGRAPH-6377
        0x6607, # G+2466  U+6607  uni6607,  CJK UNIFIED IDEOGRAPH-6607
        0x660C, # G+2467  U+660C  uni660C,  CJK UNIFIED IDEOGRAPH-660C
        0x662D, # G+2468  U+662D  uni662D,  CJK UNIFIED IDEOGRAPH-662D
        0x6676, # G+2469  U+6676  uni6676,  CJK UNIFIED IDEOGRAPH-6676
        0x677E, # G+2470  U+677E  uni677E,  CJK UNIFIED IDEOGRAPH-677E
        0x68A2, # G+2471  U+68A2  uni68A2,  CJK UNIFIED IDEOGRAPH-68A2
        0x6A1F, # G+2472  U+6A1F  uni6A1F,  CJK UNIFIED IDEOGRAPH-6A1F
        0x6A35, # G+2473  U+6A35  uni6A35,  CJK UNIFIED IDEOGRAPH-6A35
        0x6CBC, # G+2474  U+6CBC  uni6CBC,  CJK UNIFIED IDEOGRAPH-6CBC
        0x6D88, # G+2475  U+6D88  uni6D88,  CJK UNIFIED IDEOGRAPH-6D88
        0x6E09, # G+2476  U+6E09  uni6E09,  CJK UNIFIED IDEOGRAPH-6E09
        0x6E58, # G+2477  U+6E58  uni6E58,  CJK UNIFIED IDEOGRAPH-6E58
        0x713C, # G+2478  U+713C  uni713C,  CJK UNIFIED IDEOGRAPH-713C
        0x7126, # G+2479  U+7126  uni7126,  CJK UNIFIED IDEOGRAPH-7126
        0x7167, # G+2480  U+7167  uni7167,  CJK UNIFIED IDEOGRAPH-7167
        0x75C7, # G+2481  U+75C7  uni75C7,  CJK UNIFIED IDEOGRAPH-75C7
        0x7701, # G+2482  U+7701  uni7701,  CJK UNIFIED IDEOGRAPH-7701
        0x785D, # G+2483  U+785D  uni785D,  CJK UNIFIED IDEOGRAPH-785D
        0x7901, # G+2484  U+7901  uni7901,  CJK UNIFIED IDEOGRAPH-7901
        0x7965, # G+2485  U+7965  uni7965,  CJK UNIFIED IDEOGRAPH-7965
        0x79F0, # G+2486  U+79F0  uni79F0,  CJK UNIFIED IDEOGRAPH-79F0
        0x7AE0, # G+2487  U+7AE0  uni7AE0,  CJK UNIFIED IDEOGRAPH-7AE0
        0x7B11, # G+2488  U+7B11  uni7B11,  CJK UNIFIED IDEOGRAPH-7B11
        0x7CA7, # G+2489  U+7CA7  uni7CA7,  CJK UNIFIED IDEOGRAPH-7CA7
        0x7D39, # G+2490  U+7D39  uni7D39,  CJK UNIFIED IDEOGRAPH-7D39
        0x8096, # G+2491  U+8096  uni8096,  CJK UNIFIED IDEOGRAPH-8096
        0x83D6, # G+2492  U+83D6  uni83D6,  CJK UNIFIED IDEOGRAPH-83D6
        0x848B, # G+2493  U+848B  uni848B,  CJK UNIFIED IDEOGRAPH-848B
        0x8549, # G+2494  U+8549  uni8549,  CJK UNIFIED IDEOGRAPH-8549
        0x885D, # G+2495  U+885D  uni885D,  CJK UNIFIED IDEOGRAPH-885D
        0x88F3, # G+2496  U+88F3  uni88F3,  CJK UNIFIED IDEOGRAPH-88F3
        0x8A1F, # G+2497  U+8A1F  uni8A1F,  CJK UNIFIED IDEOGRAPH-8A1F
        0x8A3C, # G+2498  U+8A3C  uni8A3C,  CJK UNIFIED IDEOGRAPH-8A3C
        0x8A54, # G+2499  U+8A54  uni8A54,  CJK UNIFIED IDEOGRAPH-8A54
        0x8A73, # G+2500  U+8A73  uni8A73,  CJK UNIFIED IDEOGRAPH-8A73
        0x8C61, # G+2501  U+8C61  uni8C61,  CJK UNIFIED IDEOGRAPH-8C61
        0x8CDE, # G+2502  U+8CDE  uni8CDE,  CJK UNIFIED IDEOGRAPH-8CDE
        0x91A4, # G+2503  U+91A4  uni91A4,  CJK UNIFIED IDEOGRAPH-91A4
        0x9266, # G+2504  U+9266  uni9266,  CJK UNIFIED IDEOGRAPH-9266
        0x937E, # G+2505  U+937E  uni937E,  CJK UNIFIED IDEOGRAPH-937E
        0x9418, # G+2506  U+9418  uni9418,  CJK UNIFIED IDEOGRAPH-9418
        0x969C, # G+2507  U+969C  uni969C,  CJK UNIFIED IDEOGRAPH-969C
        0x9798, # G+2508  U+9798  uni9798,  CJK UNIFIED IDEOGRAPH-9798
        0x4E0A, # G+2509  U+4E0A  uni4E0A,  CJK UNIFIED IDEOGRAPH-4E0A
        0x4E08, # G+2510  U+4E08  uni4E08,  CJK UNIFIED IDEOGRAPH-4E08
        0x4E1E, # G+2511  U+4E1E  uni4E1E,  CJK UNIFIED IDEOGRAPH-4E1E
        0x4E57, # G+2512  U+4E57  uni4E57,  CJK UNIFIED IDEOGRAPH-4E57
        0x5197, # G+2513  U+5197  uni5197,  CJK UNIFIED IDEOGRAPH-5197
        0x5270, # G+2514  U+5270  uni5270,  CJK UNIFIED IDEOGRAPH-5270
        0x57CE, # G+2515  U+57CE  uni57CE,  CJK UNIFIED IDEOGRAPH-57CE
        0x5834, # G+2516  U+5834  uni5834,  CJK UNIFIED IDEOGRAPH-5834
        0x58CC, # G+2517  U+58CC  uni58CC,  CJK UNIFIED IDEOGRAPH-58CC
        0x5B22, # G+2518  U+5B22  uni5B22,  CJK UNIFIED IDEOGRAPH-5B22
        0x5E38, # G+2519  U+5E38  uni5E38,  CJK UNIFIED IDEOGRAPH-5E38
        0x60C5, # G+2520  U+60C5  uni60C5,  CJK UNIFIED IDEOGRAPH-60C5
        0x64FE, # G+2521  U+64FE  uni64FE,  CJK UNIFIED IDEOGRAPH-64FE
        0x6761, # G+2522  U+6761  uni6761,  CJK UNIFIED IDEOGRAPH-6761
        0x6756, # G+2523  U+6756  uni6756,  CJK UNIFIED IDEOGRAPH-6756
        0x6D44, # G+2524  U+6D44  uni6D44,  CJK UNIFIED IDEOGRAPH-6D44
        0x72B6, # G+2525  U+72B6  uni72B6,  CJK UNIFIED IDEOGRAPH-72B6
        0x7573, # G+2526  U+7573  uni7573,  CJK UNIFIED IDEOGRAPH-7573
        0x7A63, # G+2527  U+7A63  uni7A63,  CJK UNIFIED IDEOGRAPH-7A63
        0x84B8, # G+2528  U+84B8  uni84B8,  CJK UNIFIED IDEOGRAPH-84B8
        0x8B72, # G+2529  U+8B72  uni8B72,  CJK UNIFIED IDEOGRAPH-8B72
        0x91B8, # G+2530  U+91B8  uni91B8,  CJK UNIFIED IDEOGRAPH-91B8
        0x9320, # G+2531  U+9320  uni9320,  CJK UNIFIED IDEOGRAPH-9320
        0x5631, # G+2532  U+5631  uni5631,  CJK UNIFIED IDEOGRAPH-5631
        0x57F4, # G+2533  U+57F4  uni57F4,  CJK UNIFIED IDEOGRAPH-57F4
        0x98FE, # G+2534  U+98FE  uni98FE,  CJK UNIFIED IDEOGRAPH-98FE
        0x62ED, # G+2535  U+62ED  uni62ED,  CJK UNIFIED IDEOGRAPH-62ED
        0x690D, # G+2536  U+690D  uni690D,  CJK UNIFIED IDEOGRAPH-690D
        0x6B96, # G+2537  U+6B96  uni6B96,  CJK UNIFIED IDEOGRAPH-6B96
        0x71ED, # G+2538  U+71ED  uni71ED,  CJK UNIFIED IDEOGRAPH-71ED
        0x7E54, # G+2539  U+7E54  uni7E54,  CJK UNIFIED IDEOGRAPH-7E54
        0x8077, # G+2540  U+8077  uni8077,  CJK UNIFIED IDEOGRAPH-8077
        0x2F8A, # G+2541  U+2F8A  uni2F8A,  KANGXI RADICAL COLOR
        0x89E6, # G+2542  U+89E6  uni89E6,  CJK UNIFIED IDEOGRAPH-89E6
        0x2FB7, # G+2543  U+2FB7  uni2FB7,  KANGXI RADICAL EAT
        0x8755, # G+2544  U+8755  uni8755,  CJK UNIFIED IDEOGRAPH-8755
        0x8FB1, # G+2545  U+8FB1  uni8FB1,  CJK UNIFIED IDEOGRAPH-8FB1
        0x5C3B, # G+2546  U+5C3B  uni5C3B,  CJK UNIFIED IDEOGRAPH-5C3B
        0x4F38, # G+2547  U+4F38  uni4F38,  CJK UNIFIED IDEOGRAPH-4F38
        0x4FE1, # G+2548  U+4FE1  uni4FE1,  CJK UNIFIED IDEOGRAPH-4FE1
        0x4FB5, # G+2549  U+4FB5  uni4FB5,  CJK UNIFIED IDEOGRAPH-4FB5
        0x5507, # G+2550  U+5507  uni5507,  CJK UNIFIED IDEOGRAPH-5507
        0x5A20, # G+2551  U+5A20  uni5A20,  CJK UNIFIED IDEOGRAPH-5A20
        0x5BDD, # G+2552  U+5BDD  uni5BDD,  CJK UNIFIED IDEOGRAPH-5BDD
        0x5BE9, # G+2553  U+5BE9  uni5BE9,  CJK UNIFIED IDEOGRAPH-5BE9
        0x2F3C, # G+2554  U+2F3C  uni2F3C,  KANGXI RADICAL HEART
        0x614E, # G+2555  U+614E  uni614E,  CJK UNIFIED IDEOGRAPH-614E
        0x632F, # G+2556  U+632F  uni632F,  CJK UNIFIED IDEOGRAPH-632F
        0x65B0, # G+2557  U+65B0  uni65B0,  CJK UNIFIED IDEOGRAPH-65B0
        0x664B, # G+2558  U+664B  uni664B,  CJK UNIFIED IDEOGRAPH-664B
        0x68EE, # G+2559  U+68EE  uni68EE,  CJK UNIFIED IDEOGRAPH-68EE
        0x699B, # G+2560  U+699B  uni699B,  CJK UNIFIED IDEOGRAPH-699B
        0x6D78, # G+2561  U+6D78  uni6D78,  CJK UNIFIED IDEOGRAPH-6D78
        0x6DF1, # G+2562  U+6DF1  uni6DF1,  CJK UNIFIED IDEOGRAPH-6DF1
        0x7533, # G+2563  U+7533  uni7533,  CJK UNIFIED IDEOGRAPH-7533
        0x75B9, # G+2564  U+75B9  uni75B9,  CJK UNIFIED IDEOGRAPH-75B9
        0x771F, # G+2565  U+771F  uni771F,  CJK UNIFIED IDEOGRAPH-771F
        0x795E, # G+2566  U+795E  uni795E,  CJK UNIFIED IDEOGRAPH-795E
        0x79E6, # G+2567  U+79E6  uni79E6,  CJK UNIFIED IDEOGRAPH-79E6
        0x7D33, # G+2568  U+7D33  uni7D33,  CJK UNIFIED IDEOGRAPH-7D33
        0x2F82, # G+2569  U+2F82  uni2F82,  KANGXI RADICAL MINISTER
        0x82AF, # G+2570  U+82AF  uni82AF,  CJK UNIFIED IDEOGRAPH-82AF
        0x85AA, # G+2571  U+85AA  uni85AA,  CJK UNIFIED IDEOGRAPH-85AA
        0x89AA, # G+2572  U+89AA  uni89AA,  CJK UNIFIED IDEOGRAPH-89AA
        0x8A3A, # G+2573  U+8A3A  uni8A3A,  CJK UNIFIED IDEOGRAPH-8A3A
        0x2F9D, # G+2574  U+2F9D  uni2F9D,  KANGXI RADICAL BODY
        0x2F9F, # G+2575  U+2F9F  uni2F9F,  KANGXI RADICAL BITTER
        0x9032, # G+2576  U+9032  uni9032,  CJK UNIFIED IDEOGRAPH-9032
        0x91DD, # G+2577  U+91DD  uni91DD,  CJK UNIFIED IDEOGRAPH-91DD
        0x9707, # G+2578  U+9707  uni9707,  CJK UNIFIED IDEOGRAPH-9707
        0x2F08, # G+2579  U+2F08  uni2F08,  KANGXI RADICAL MAN
        0x4EC1, # G+2580  U+4EC1  uni4EC1,  CJK UNIFIED IDEOGRAPH-4EC1
        0x5203, # G+2581  U+5203  uni5203,  CJK UNIFIED IDEOGRAPH-5203
        0x5875, # G+2582  U+5875  uni5875,  CJK UNIFIED IDEOGRAPH-5875
        0x58EC, # G+2583  U+58EC  uni58EC,  CJK UNIFIED IDEOGRAPH-58EC
        0x5C0B, # G+2584  U+5C0B  uni5C0B,  CJK UNIFIED IDEOGRAPH-5C0B
        0x751A, # G+2585  U+751A  uni751A,  CJK UNIFIED IDEOGRAPH-751A
        0x5C3D, # G+2586  U+5C3D  uni5C3D,  CJK UNIFIED IDEOGRAPH-5C3D
        0x814E, # G+2587  U+814E  uni814E,  CJK UNIFIED IDEOGRAPH-814E
        0x8A0A, # G+2588  U+8A0A  uni8A0A,  CJK UNIFIED IDEOGRAPH-8A0A
        0x8FC5, # G+2589  U+8FC5  uni8FC5,  CJK UNIFIED IDEOGRAPH-8FC5
        0x9663, # G+2590  U+9663  uni9663,  CJK UNIFIED IDEOGRAPH-9663
        0x976D, # G+2591  U+976D  uni976D,  CJK UNIFIED IDEOGRAPH-976D
        0x7B25, # G+2592  U+7B25  uni7B25,  CJK UNIFIED IDEOGRAPH-7B25
        0x8ACF, # G+2593  U+8ACF  uni8ACF,  CJK UNIFIED IDEOGRAPH-8ACF
        0x9808, # G+2594  U+9808  uni9808,  CJK UNIFIED IDEOGRAPH-9808
        0x9162, # G+2595  U+9162  uni9162,  CJK UNIFIED IDEOGRAPH-9162
        0x56F3, # G+2596  U+56F3  uni56F3,  CJK UNIFIED IDEOGRAPH-56F3
        0x53A8, # G+2597  U+53A8  uni53A8,  CJK UNIFIED IDEOGRAPH-53A8
        0x9017, # G+2598  U+9017  uni9017,  CJK UNIFIED IDEOGRAPH-9017
        0x5439, # G+2599  U+5439  uni5439,  CJK UNIFIED IDEOGRAPH-5439
        0x5782, # G+2600  U+5782  uni5782,  CJK UNIFIED IDEOGRAPH-5782
        0x5E25, # G+2601  U+5E25  uni5E25,  CJK UNIFIED IDEOGRAPH-5E25
        0x63A8, # G+2602  U+63A8  uni63A8,  CJK UNIFIED IDEOGRAPH-63A8
        0x2F54, # G+2603  U+2F54  uni2F54,  KANGXI RADICAL WATER
        0x708A, # G+2604  U+708A  uni708A,  CJK UNIFIED IDEOGRAPH-708A
        0x7761, # G+2605  U+7761  uni7761,  CJK UNIFIED IDEOGRAPH-7761
        0x7C8B, # G+2606  U+7C8B  uni7C8B,  CJK UNIFIED IDEOGRAPH-7C8B
        0x7FE0, # G+2607  U+7FE0  uni7FE0,  CJK UNIFIED IDEOGRAPH-7FE0
        0x8870, # G+2608  U+8870  uni8870,  CJK UNIFIED IDEOGRAPH-8870
        0x9042, # G+2609  U+9042  uni9042,  CJK UNIFIED IDEOGRAPH-9042
        0x9154, # G+2610  U+9154  uni9154,  CJK UNIFIED IDEOGRAPH-9154
        0x9310, # G+2611  U+9310  uni9310,  CJK UNIFIED IDEOGRAPH-9310
        0x9318, # G+2612  U+9318  uni9318,  CJK UNIFIED IDEOGRAPH-9318
        0x968F, # G+2613  U+968F  uni968F,  CJK UNIFIED IDEOGRAPH-968F
        0x745E, # G+2614  U+745E  uni745E,  CJK UNIFIED IDEOGRAPH-745E
        0x9AC4, # G+2615  U+9AC4  uni9AC4,  CJK UNIFIED IDEOGRAPH-9AC4
        0x5D07, # G+2616  U+5D07  uni5D07,  CJK UNIFIED IDEOGRAPH-5D07
        0x5D69, # G+2617  U+5D69  uni5D69,  CJK UNIFIED IDEOGRAPH-5D69
        0x6570, # G+2618  U+6570  uni6570,  CJK UNIFIED IDEOGRAPH-6570
        0x67A2, # G+2619  U+67A2  uni67A2,  CJK UNIFIED IDEOGRAPH-67A2
        0x8DA8, # G+2620  U+8DA8  uni8DA8,  CJK UNIFIED IDEOGRAPH-8DA8
        0x96DB, # G+2621  U+96DB  uni96DB,  CJK UNIFIED IDEOGRAPH-96DB
        0x636E, # G+2622  U+636E  uni636E,  CJK UNIFIED IDEOGRAPH-636E
        0x6749, # G+2623  U+6749  uni6749,  CJK UNIFIED IDEOGRAPH-6749
        0x6919, # G+2624  U+6919  uni6919,  CJK UNIFIED IDEOGRAPH-6919
        0x83C5, # G+2625  U+83C5  uni83C5,  CJK UNIFIED IDEOGRAPH-83C5
        0x9817, # G+2626  U+9817  uni9817,  CJK UNIFIED IDEOGRAPH-9817
        0x96C0, # G+2627  U+96C0  uni96C0,  CJK UNIFIED IDEOGRAPH-96C0
        0x88FE, # G+2628  U+88FE  uni88FE,  CJK UNIFIED IDEOGRAPH-88FE
        0x6F84, # G+2629  U+6F84  uni6F84,  CJK UNIFIED IDEOGRAPH-6F84
        0x647A, # G+2630  U+647A  uni647A,  CJK UNIFIED IDEOGRAPH-647A
        0x2F28, # G+2631  U+2F28  uni2F28,  KANGXI RADICAL INCH
        0x4E16, # G+2632  U+4E16  uni4E16,  CJK UNIFIED IDEOGRAPH-4E16
        0x702C, # G+2633  U+702C  uni702C,  CJK UNIFIED IDEOGRAPH-702C
        0x755D, # G+2634  U+755D  uni755D,  CJK UNIFIED IDEOGRAPH-755D
        0x662F, # G+2635  U+662F  uni662F,  CJK UNIFIED IDEOGRAPH-662F
        0x51C4, # G+2636  U+51C4  uni51C4,  CJK UNIFIED IDEOGRAPH-51C4
        0x5236, # G+2637  U+5236  uni5236,  CJK UNIFIED IDEOGRAPH-5236
        0x52E2, # G+2638  U+52E2  uni52E2,  CJK UNIFIED IDEOGRAPH-52E2
        0x59D3, # G+2639  U+59D3  uni59D3,  CJK UNIFIED IDEOGRAPH-59D3
        0x5F81, # G+2640  U+5F81  uni5F81,  CJK UNIFIED IDEOGRAPH-5F81
        0x6027, # G+2641  U+6027  uni6027,  CJK UNIFIED IDEOGRAPH-6027
        0x6210, # G+2642  U+6210  uni6210,  CJK UNIFIED IDEOGRAPH-6210
        0x653F, # G+2643  U+653F  uni653F,  CJK UNIFIED IDEOGRAPH-653F
        0x6574, # G+2644  U+6574  uni6574,  CJK UNIFIED IDEOGRAPH-6574
        0x661F, # G+2645  U+661F  uni661F,  CJK UNIFIED IDEOGRAPH-661F
        0x6674, # G+2646  U+6674  uni6674,  CJK UNIFIED IDEOGRAPH-6674
        0x68F2, # G+2647  U+68F2  uni68F2,  CJK UNIFIED IDEOGRAPH-68F2
        0x6816, # G+2648  U+6816  uni6816,  CJK UNIFIED IDEOGRAPH-6816
        0x6B63, # G+2649  U+6B63  uni6B63,  CJK UNIFIED IDEOGRAPH-6B63
        0x6E05, # G+2650  U+6E05  uni6E05,  CJK UNIFIED IDEOGRAPH-6E05
        0x7272, # G+2651  U+7272  uni7272,  CJK UNIFIED IDEOGRAPH-7272
        0x2F63, # G+2652  U+2F63  uni2F63,  KANGXI RADICAL LIFE
        0x76DB, # G+2653  U+76DB  uni76DB,  CJK UNIFIED IDEOGRAPH-76DB
        0x7CBE, # G+2654  U+7CBE  uni7CBE,  CJK UNIFIED IDEOGRAPH-7CBE
        0x8056, # G+2655  U+8056  uni8056,  CJK UNIFIED IDEOGRAPH-8056
        0x58F0, # G+2656  U+58F0  uni58F0,  CJK UNIFIED IDEOGRAPH-58F0
        0x88FD, # G+2657  U+88FD  uni88FD,  CJK UNIFIED IDEOGRAPH-88FD
        0x2EC4, # G+2658  U+2EC4  uni2EC4,  CJK RADICAL WEST TWO
        0x8AA0, # G+2659  U+8AA0  uni8AA0,  CJK UNIFIED IDEOGRAPH-8AA0
        0x8A93, # G+2660  U+8A93  uni8A93,  CJK UNIFIED IDEOGRAPH-8A93
        0x8ACB, # G+2661  U+8ACB  uni8ACB,  CJK UNIFIED IDEOGRAPH-8ACB
        0x901D, # G+2662  U+901D  uni901D,  CJK UNIFIED IDEOGRAPH-901D
        0x9192, # G+2663  U+9192  uni9192,  CJK UNIFIED IDEOGRAPH-9192
        0x2ED8, # G+2664  U+2ED8  uni2ED8,  CJK RADICAL BLUE
        0x9759, # G+2665  U+9759  uni9759,  CJK UNIFIED IDEOGRAPH-9759
        0x2EEB, # G+2666  U+2EEB  uni2EEB,  CJK RADICAL J-SIMPLIFIED EVEN
        0x7A0E, # G+2667  U+7A0E  uni7A0E,  CJK UNIFIED IDEOGRAPH-7A0E
        0x8106, # G+2668  U+8106  uni8106,  CJK UNIFIED IDEOGRAPH-8106
        0x96BB, # G+2669  U+96BB  uni96BB,  CJK UNIFIED IDEOGRAPH-96BB
        0x5E2D, # G+2670  U+5E2D  uni5E2D,  CJK UNIFIED IDEOGRAPH-5E2D
        0x60DC, # G+2671  U+60DC  uni60DC,  CJK UNIFIED IDEOGRAPH-60DC
        0x621A, # G+2672  U+621A  uni621A,  CJK UNIFIED IDEOGRAPH-621A
        0x65A5, # G+2673  U+65A5  uni65A5,  CJK UNIFIED IDEOGRAPH-65A5
        0x6614, # G+2674  U+6614  uni6614,  CJK UNIFIED IDEOGRAPH-6614
        0x6790, # G+2675  U+6790  uni6790,  CJK UNIFIED IDEOGRAPH-6790
        0x2F6F, # G+2676  U+2F6F  uni2F6F,  KANGXI RADICAL STONE
        0x7A4D, # G+2677  U+7A4D  uni7A4D,  CJK UNIFIED IDEOGRAPH-7A4D
        0x7C4D, # G+2678  U+7C4D  uni7C4D,  CJK UNIFIED IDEOGRAPH-7C4D
        0x7E3E, # G+2679  U+7E3E  uni7E3E,  CJK UNIFIED IDEOGRAPH-7E3E
        0x810A, # G+2680  U+810A  uni810A,  CJK UNIFIED IDEOGRAPH-810A
        0x8CAC, # G+2681  U+8CAC  uni8CAC,  CJK UNIFIED IDEOGRAPH-8CAC
        0x2F9A, # G+2682  U+2F9A  uni2F9A,  KANGXI RADICAL RED
        0x8DE1, # G+2683  U+8DE1  uni8DE1,  CJK UNIFIED IDEOGRAPH-8DE1
        0x8E5F, # G+2684  U+8E5F  uni8E5F,  CJK UNIFIED IDEOGRAPH-8E5F
        0x78A9, # G+2685  U+78A9  uni78A9,  CJK UNIFIED IDEOGRAPH-78A9
        0x5207, # G+2686  U+5207  uni5207,  CJK UNIFIED IDEOGRAPH-5207
        0x62D9, # G+2687  U+62D9  uni62D9,  CJK UNIFIED IDEOGRAPH-62D9
        0x63A5, # G+2688  U+63A5  uni63A5,  CJK UNIFIED IDEOGRAPH-63A5
        0x6442, # G+2689  U+6442  uni6442,  CJK UNIFIED IDEOGRAPH-6442
        0x6298, # G+2690  U+6298  uni6298,  CJK UNIFIED IDEOGRAPH-6298
        0x8A2D, # G+2691  U+8A2D  uni8A2D,  CJK UNIFIED IDEOGRAPH-8A2D
        0x7A83, # G+2692  U+7A83  uni7A83,  CJK UNIFIED IDEOGRAPH-7A83
        0x7BC0, # G+2693  U+7BC0  uni7BC0,  CJK UNIFIED IDEOGRAPH-7BC0
        0x8AAC, # G+2694  U+8AAC  uni8AAC,  CJK UNIFIED IDEOGRAPH-8AAC
        0x96EA, # G+2695  U+96EA  uni96EA,  CJK UNIFIED IDEOGRAPH-96EA
        0x7D76, # G+2696  U+7D76  uni7D76,  CJK UNIFIED IDEOGRAPH-7D76
        0x2F86, # G+2697  U+2F86  uni2F86,  KANGXI RADICAL TONGUE
        0x8749, # G+2698  U+8749  uni8749,  CJK UNIFIED IDEOGRAPH-8749
        0x4ED9, # G+2699  U+4ED9  uni4ED9,  CJK UNIFIED IDEOGRAPH-4ED9
        0x5148, # G+2700  U+5148  uni5148,  CJK UNIFIED IDEOGRAPH-5148
        0x5343, # G+2701  U+5343  uni5343,  CJK UNIFIED IDEOGRAPH-5343
        0x5360, # G+2702  U+5360  uni5360,  CJK UNIFIED IDEOGRAPH-5360
        0x5BA3, # G+2703  U+5BA3  uni5BA3,  CJK UNIFIED IDEOGRAPH-5BA3
        0x5C02, # G+2704  U+5C02  uni5C02,  CJK UNIFIED IDEOGRAPH-5C02
        0x5C16, # G+2705  U+5C16  uni5C16,  CJK UNIFIED IDEOGRAPH-5C16
        0x5DDD, # G+2706  U+5DDD  uni5DDD,  CJK UNIFIED IDEOGRAPH-5DDD
        0x6226, # G+2707  U+6226  uni6226,  CJK UNIFIED IDEOGRAPH-6226
        0x6247, # G+2708  U+6247  uni6247,  CJK UNIFIED IDEOGRAPH-6247
        0x64B0, # G+2709  U+64B0  uni64B0,  CJK UNIFIED IDEOGRAPH-64B0
        0x6813, # G+2710  U+6813  uni6813,  CJK UNIFIED IDEOGRAPH-6813
        0x6834, # G+2711  U+6834  uni6834,  CJK UNIFIED IDEOGRAPH-6834
        0x6CC9, # G+2712  U+6CC9  uni6CC9,  CJK UNIFIED IDEOGRAPH-6CC9
        0x6D45, # G+2713  U+6D45  uni6D45,  CJK UNIFIED IDEOGRAPH-6D45
        0x6D17, # G+2714  U+6D17  uni6D17,  CJK UNIFIED IDEOGRAPH-6D17
        0x67D3, # G+2715  U+67D3  uni67D3,  CJK UNIFIED IDEOGRAPH-67D3
        0x6F5C, # G+2716  U+6F5C  uni6F5C,  CJK UNIFIED IDEOGRAPH-6F5C
        0x714E, # G+2717  U+714E  uni714E,  CJK UNIFIED IDEOGRAPH-714E
        0x717D, # G+2718  U+717D  uni717D,  CJK UNIFIED IDEOGRAPH-717D
        0x65CB, # G+2719  U+65CB  uni65CB,  CJK UNIFIED IDEOGRAPH-65CB
        0x7A7F, # G+2720  U+7A7F  uni7A7F,  CJK UNIFIED IDEOGRAPH-7A7F
        0x7BAD, # G+2721  U+7BAD  uni7BAD,  CJK UNIFIED IDEOGRAPH-7BAD
        0x7DDA, # G+2722  U+7DDA  uni7DDA,  CJK UNIFIED IDEOGRAPH-7DDA
        0x7E4A, # G+2723  U+7E4A  uni7E4A,  CJK UNIFIED IDEOGRAPH-7E4A
        0x7FA8, # G+2724  U+7FA8  uni7FA8,  CJK UNIFIED IDEOGRAPH-7FA8
        0x817A, # G+2725  U+817A  uni817A,  CJK UNIFIED IDEOGRAPH-817A
        0x2F87, # G+2726  U+2F87  uni2F87,  KANGXI RADICAL OPPOSE
        0x8239, # G+2727  U+8239  uni8239,  CJK UNIFIED IDEOGRAPH-8239
        0x85A6, # G+2728  U+85A6  uni85A6,  CJK UNIFIED IDEOGRAPH-85A6
        0x8A6E, # G+2729  U+8A6E  uni8A6E,  CJK UNIFIED IDEOGRAPH-8A6E
        0x8CCE, # G+2730  U+8CCE  uni8CCE,  CJK UNIFIED IDEOGRAPH-8CCE
        0x8DF5, # G+2731  U+8DF5  uni8DF5,  CJK UNIFIED IDEOGRAPH-8DF5
        0x9078, # G+2732  U+9078  uni9078,  CJK UNIFIED IDEOGRAPH-9078
        0x9077, # G+2733  U+9077  uni9077,  CJK UNIFIED IDEOGRAPH-9077
        0x92AD, # G+2734  U+92AD  uni92AD,  CJK UNIFIED IDEOGRAPH-92AD
        0x9291, # G+2735  U+9291  uni9291,  CJK UNIFIED IDEOGRAPH-9291
        0x9583, # G+2736  U+9583  uni9583,  CJK UNIFIED IDEOGRAPH-9583
        0x9BAE, # G+2737  U+9BAE  uni9BAE,  CJK UNIFIED IDEOGRAPH-9BAE
        0x524D, # G+2738  U+524D  uni524D,  CJK UNIFIED IDEOGRAPH-524D
        0x5584, # G+2739  U+5584  uni5584,  CJK UNIFIED IDEOGRAPH-5584
        0x6F38, # G+2740  U+6F38  uni6F38,  CJK UNIFIED IDEOGRAPH-6F38
        0x7136, # G+2741  U+7136  uni7136,  CJK UNIFIED IDEOGRAPH-7136
        0x5168, # G+2742  U+5168  uni5168,  CJK UNIFIED IDEOGRAPH-5168
        0x7985, # G+2743  U+7985  uni7985,  CJK UNIFIED IDEOGRAPH-7985
        0x7E55, # G+2744  U+7E55  uni7E55,  CJK UNIFIED IDEOGRAPH-7E55
        0x81B3, # G+2745  U+81B3  uni81B3,  CJK UNIFIED IDEOGRAPH-81B3
        0x7CCE, # G+2746  U+7CCE  uni7CCE,  CJK UNIFIED IDEOGRAPH-7CCE
        0x564C, # G+2747  U+564C  uni564C,  CJK UNIFIED IDEOGRAPH-564C
        0x5851, # G+2748  U+5851  uni5851,  CJK UNIFIED IDEOGRAPH-5851
        0x5CA8, # G+2749  U+5CA8  uni5CA8,  CJK UNIFIED IDEOGRAPH-5CA8
        0x63AA, # G+2750  U+63AA  uni63AA,  CJK UNIFIED IDEOGRAPH-63AA
        0x66FE, # G+2751  U+66FE  uni66FE,  CJK UNIFIED IDEOGRAPH-66FE
        0x66FD, # G+2752  U+66FD  uni66FD,  CJK UNIFIED IDEOGRAPH-66FD
        0x695A, # G+2753  U+695A  uni695A,  CJK UNIFIED IDEOGRAPH-695A
        0x72D9, # G+2754  U+72D9  uni72D9,  CJK UNIFIED IDEOGRAPH-72D9
        0x758F, # G+2755  U+758F  uni758F,  CJK UNIFIED IDEOGRAPH-758F
        0x758E, # G+2756  U+758E  uni758E,  CJK UNIFIED IDEOGRAPH-758E
        0x790E, # G+2757  U+790E  uni790E,  CJK UNIFIED IDEOGRAPH-790E
        0x7956, # G+2758  U+7956  uni7956,  CJK UNIFIED IDEOGRAPH-7956
        0x79DF, # G+2759  U+79DF  uni79DF,  CJK UNIFIED IDEOGRAPH-79DF
        0x7C97, # G+2760  U+7C97  uni7C97,  CJK UNIFIED IDEOGRAPH-7C97
        0x7D20, # G+2761  U+7D20  uni7D20,  CJK UNIFIED IDEOGRAPH-7D20
        0x7D44, # G+2762  U+7D44  uni7D44,  CJK UNIFIED IDEOGRAPH-7D44
        0x8607, # G+2763  U+8607  uni8607,  CJK UNIFIED IDEOGRAPH-8607
        0x8A34, # G+2764  U+8A34  uni8A34,  CJK UNIFIED IDEOGRAPH-8A34
        0x963B, # G+2765  U+963B  uni963B,  CJK UNIFIED IDEOGRAPH-963B
        0x9061, # G+2766  U+9061  uni9061,  CJK UNIFIED IDEOGRAPH-9061
        0x2FCF, # G+2767  U+2FCF  uni2FCF,  KANGXI RADICAL RAT
        0x50E7, # G+2768  U+50E7  uni50E7,  CJK UNIFIED IDEOGRAPH-50E7
        0x5275, # G+2769  U+5275  uni5275,  CJK UNIFIED IDEOGRAPH-5275
        0x53CC, # G+2770  U+53CC  uni53CC,  CJK UNIFIED IDEOGRAPH-53CC
        0x53E2, # G+2771  U+53E2  uni53E2,  CJK UNIFIED IDEOGRAPH-53E2
        0x5009, # G+2772  U+5009  uni5009,  CJK UNIFIED IDEOGRAPH-5009
        0x55AA, # G+2773  U+55AA  uni55AA,  CJK UNIFIED IDEOGRAPH-55AA
        0x58EE, # G+2774  U+58EE  uni58EE,  CJK UNIFIED IDEOGRAPH-58EE
        0x594F, # G+2775  U+594F  uni594F,  CJK UNIFIED IDEOGRAPH-594F
        0x723D, # G+2776  U+723D  uni723D,  CJK UNIFIED IDEOGRAPH-723D
        0x5B8B, # G+2777  U+5B8B  uni5B8B,  CJK UNIFIED IDEOGRAPH-5B8B
        0x5C64, # G+2778  U+5C64  uni5C64,  CJK UNIFIED IDEOGRAPH-5C64
        0x531D, # G+2779  U+531D  uni531D,  CJK UNIFIED IDEOGRAPH-531D
        0x60E3, # G+2780  U+60E3  uni60E3,  CJK UNIFIED IDEOGRAPH-60E3
        0x60F3, # G+2781  U+60F3  uni60F3,  CJK UNIFIED IDEOGRAPH-60F3
        0x635C, # G+2782  U+635C  uni635C,  CJK UNIFIED IDEOGRAPH-635C
        0x6383, # G+2783  U+6383  uni6383,  CJK UNIFIED IDEOGRAPH-6383
        0x633F, # G+2784  U+633F  uni633F,  CJK UNIFIED IDEOGRAPH-633F
        0x63BB, # G+2785  U+63BB  uni63BB,  CJK UNIFIED IDEOGRAPH-63BB
        0x64CD, # G+2786  U+64CD  uni64CD,  CJK UNIFIED IDEOGRAPH-64CD
        0x65E9, # G+2787  U+65E9  uni65E9,  CJK UNIFIED IDEOGRAPH-65E9
        0x66F9, # G+2788  U+66F9  uni66F9,  CJK UNIFIED IDEOGRAPH-66F9
        0x5DE3, # G+2789  U+5DE3  uni5DE3,  CJK UNIFIED IDEOGRAPH-5DE3
        0x69CD, # G+2790  U+69CD  uni69CD,  CJK UNIFIED IDEOGRAPH-69CD
        0x69FD, # G+2791  U+69FD  uni69FD,  CJK UNIFIED IDEOGRAPH-69FD
        0x6F15, # G+2792  U+6F15  uni6F15,  CJK UNIFIED IDEOGRAPH-6F15
        0x71E5, # G+2793  U+71E5  uni71E5,  CJK UNIFIED IDEOGRAPH-71E5
        0x4E89, # G+2794  U+4E89  uni4E89,  CJK UNIFIED IDEOGRAPH-4E89
        0x75E9, # G+2795  U+75E9  uni75E9,  CJK UNIFIED IDEOGRAPH-75E9
        0x76F8, # G+2796  U+76F8  uni76F8,  CJK UNIFIED IDEOGRAPH-76F8
        0x7A93, # G+2797  U+7A93  uni7A93,  CJK UNIFIED IDEOGRAPH-7A93
        0x7CDF, # G+2798  U+7CDF  uni7CDF,  CJK UNIFIED IDEOGRAPH-7CDF
        0x7DCF, # G+2799  U+7DCF  uni7DCF,  CJK UNIFIED IDEOGRAPH-7DCF
        0x7D9C, # G+2800  U+7D9C  uni7D9C,  CJK UNIFIED IDEOGRAPH-7D9C
        0x8061, # G+2801  U+8061  uni8061,  CJK UNIFIED IDEOGRAPH-8061
        0x8349, # G+2802  U+8349  uni8349,  CJK UNIFIED IDEOGRAPH-8349
        0x8358, # G+2803  U+8358  uni8358,  CJK UNIFIED IDEOGRAPH-8358
        0x846C, # G+2804  U+846C  uni846C,  CJK UNIFIED IDEOGRAPH-846C
        0x84BC, # G+2805  U+84BC  uni84BC,  CJK UNIFIED IDEOGRAPH-84BC
        0x85FB, # G+2806  U+85FB  uni85FB,  CJK UNIFIED IDEOGRAPH-85FB
        0x88C5, # G+2807  U+88C5  uni88C5,  CJK UNIFIED IDEOGRAPH-88C5
        0x2F9B, # G+2808  U+2F9B  uni2F9B,  KANGXI RADICAL RUN
        0x9001, # G+2809  U+9001  uni9001,  CJK UNIFIED IDEOGRAPH-9001
        0x906D, # G+2810  U+906D  uni906D,  CJK UNIFIED IDEOGRAPH-906D
        0x9397, # G+2811  U+9397  uni9397,  CJK UNIFIED IDEOGRAPH-9397
        0x971C, # G+2812  U+971C  uni971C,  CJK UNIFIED IDEOGRAPH-971C
        0x9A12, # G+2813  U+9A12  uni9A12,  CJK UNIFIED IDEOGRAPH-9A12
        0x50CF, # G+2814  U+50CF  uni50CF,  CJK UNIFIED IDEOGRAPH-50CF
        0x5897, # G+2815  U+5897  uni5897,  CJK UNIFIED IDEOGRAPH-5897
        0x618E, # G+2816  U+618E  uni618E,  CJK UNIFIED IDEOGRAPH-618E
        0x81D3, # G+2817  U+81D3  uni81D3,  CJK UNIFIED IDEOGRAPH-81D3
        0x8535, # G+2818  U+8535  uni8535,  CJK UNIFIED IDEOGRAPH-8535
        0x8D08, # G+2819  U+8D08  uni8D08,  CJK UNIFIED IDEOGRAPH-8D08
        0x9020, # G+2820  U+9020  uni9020,  CJK UNIFIED IDEOGRAPH-9020
        0x4FC3, # G+2821  U+4FC3  uni4FC3,  CJK UNIFIED IDEOGRAPH-4FC3
        0x5074, # G+2822  U+5074  uni5074,  CJK UNIFIED IDEOGRAPH-5074
        0x5247, # G+2823  U+5247  uni5247,  CJK UNIFIED IDEOGRAPH-5247
        0x5373, # G+2824  U+5373  uni5373,  CJK UNIFIED IDEOGRAPH-5373
        0x606F, # G+2825  U+606F  uni606F,  CJK UNIFIED IDEOGRAPH-606F
        0x6349, # G+2826  U+6349  uni6349,  CJK UNIFIED IDEOGRAPH-6349
        0x675F, # G+2827  U+675F  uni675F,  CJK UNIFIED IDEOGRAPH-675F
        0x6E2C, # G+2828  U+6E2C  uni6E2C,  CJK UNIFIED IDEOGRAPH-6E2C
        0x2F9C, # G+2829  U+2F9C  uni2F9C,  KANGXI RADICAL FOOT
        0x901F, # G+2830  U+901F  uni901F,  CJK UNIFIED IDEOGRAPH-901F
        0x4FD7, # G+2831  U+4FD7  uni4FD7,  CJK UNIFIED IDEOGRAPH-4FD7
        0x5C5E, # G+2832  U+5C5E  uni5C5E,  CJK UNIFIED IDEOGRAPH-5C5E
        0x8CCA, # G+2833  U+8CCA  uni8CCA,  CJK UNIFIED IDEOGRAPH-8CCA
        0x65CF, # G+2834  U+65CF  uni65CF,  CJK UNIFIED IDEOGRAPH-65CF
        0x7D9A, # G+2835  U+7D9A  uni7D9A,  CJK UNIFIED IDEOGRAPH-7D9A
        0x5352, # G+2836  U+5352  uni5352,  CJK UNIFIED IDEOGRAPH-5352
        0x8896, # G+2837  U+8896  uni8896,  CJK UNIFIED IDEOGRAPH-8896
        0x5176, # G+2838  U+5176  uni5176,  CJK UNIFIED IDEOGRAPH-5176
        0x63C3, # G+2839  U+63C3  uni63C3,  CJK UNIFIED IDEOGRAPH-63C3
        0x5B58, # G+2840  U+5B58  uni5B58,  CJK UNIFIED IDEOGRAPH-5B58
        0x5B6B, # G+2841  U+5B6B  uni5B6B,  CJK UNIFIED IDEOGRAPH-5B6B
        0x5C0A, # G+2842  U+5C0A  uni5C0A,  CJK UNIFIED IDEOGRAPH-5C0A
        0x640D, # G+2843  U+640D  uni640D,  CJK UNIFIED IDEOGRAPH-640D
        0x6751, # G+2844  U+6751  uni6751,  CJK UNIFIED IDEOGRAPH-6751
        0x905C, # G+2845  U+905C  uni905C,  CJK UNIFIED IDEOGRAPH-905C
        0x4ED6, # G+2846  U+4ED6  uni4ED6,  CJK UNIFIED IDEOGRAPH-4ED6
        0x591A, # G+2847  U+591A  uni591A,  CJK UNIFIED IDEOGRAPH-591A
        0x592A, # G+2848  U+592A  uni592A,  CJK UNIFIED IDEOGRAPH-592A
        0x6C70, # G+2849  U+6C70  uni6C70,  CJK UNIFIED IDEOGRAPH-6C70
        0x8A51, # G+2850  U+8A51  uni8A51,  CJK UNIFIED IDEOGRAPH-8A51
        0x553E, # G+2851  U+553E  uni553E,  CJK UNIFIED IDEOGRAPH-553E
        0x5815, # G+2852  U+5815  uni5815,  CJK UNIFIED IDEOGRAPH-5815
        0x59A5, # G+2853  U+59A5  uni59A5,  CJK UNIFIED IDEOGRAPH-59A5
        0x60F0, # G+2854  U+60F0  uni60F0,  CJK UNIFIED IDEOGRAPH-60F0
        0x6253, # G+2855  U+6253  uni6253,  CJK UNIFIED IDEOGRAPH-6253
        0x67C1, # G+2856  U+67C1  uni67C1,  CJK UNIFIED IDEOGRAPH-67C1
        0x8235, # G+2857  U+8235  uni8235,  CJK UNIFIED IDEOGRAPH-8235
        0x6955, # G+2858  U+6955  uni6955,  CJK UNIFIED IDEOGRAPH-6955
        0x9640, # G+2859  U+9640  uni9640,  CJK UNIFIED IDEOGRAPH-9640
        0x99C4, # G+2860  U+99C4  uni99C4,  CJK UNIFIED IDEOGRAPH-99C4
        0x9A28, # G+2861  U+9A28  uni9A28,  CJK UNIFIED IDEOGRAPH-9A28
        0x4F53, # G+2862  U+4F53  uni4F53,  CJK UNIFIED IDEOGRAPH-4F53
        0x5806, # G+2863  U+5806  uni5806,  CJK UNIFIED IDEOGRAPH-5806
        0x5BFE, # G+2864  U+5BFE  uni5BFE,  CJK UNIFIED IDEOGRAPH-5BFE
        0x8010, # G+2865  U+8010  uni8010,  CJK UNIFIED IDEOGRAPH-8010
        0x5CB1, # G+2866  U+5CB1  uni5CB1,  CJK UNIFIED IDEOGRAPH-5CB1
        0x5E2F, # G+2867  U+5E2F  uni5E2F,  CJK UNIFIED IDEOGRAPH-5E2F
        0x5F85, # G+2868  U+5F85  uni5F85,  CJK UNIFIED IDEOGRAPH-5F85
        0x6020, # G+2869  U+6020  uni6020,  CJK UNIFIED IDEOGRAPH-6020
        0x614B, # G+2870  U+614B  uni614B,  CJK UNIFIED IDEOGRAPH-614B
        0x6234, # G+2871  U+6234  uni6234,  CJK UNIFIED IDEOGRAPH-6234
        0x66FF, # G+2872  U+66FF  uni66FF,  CJK UNIFIED IDEOGRAPH-66FF
        0x6CF0, # G+2873  U+6CF0  uni6CF0,  CJK UNIFIED IDEOGRAPH-6CF0
        0x6EDE, # G+2874  U+6EDE  uni6EDE,  CJK UNIFIED IDEOGRAPH-6EDE
        0x80CE, # G+2875  U+80CE  uni80CE,  CJK UNIFIED IDEOGRAPH-80CE
        0x817F, # G+2876  U+817F  uni817F,  CJK UNIFIED IDEOGRAPH-817F
        0x82D4, # G+2877  U+82D4  uni82D4,  CJK UNIFIED IDEOGRAPH-82D4
        0x888B, # G+2878  U+888B  uni888B,  CJK UNIFIED IDEOGRAPH-888B
        0x8CB8, # G+2879  U+8CB8  uni8CB8,  CJK UNIFIED IDEOGRAPH-8CB8
        0x9000, # G+2880  U+9000  uni9000,  CJK UNIFIED IDEOGRAPH-9000
        0x902E, # G+2881  U+902E  uni902E,  CJK UNIFIED IDEOGRAPH-902E
        0x968A, # G+2882  U+968A  uni968A,  CJK UNIFIED IDEOGRAPH-968A
        0x9EDB, # G+2883  U+9EDB  uni9EDB,  CJK UNIFIED IDEOGRAPH-9EDB
        0x9BDB, # G+2884  U+9BDB  uni9BDB,  CJK UNIFIED IDEOGRAPH-9BDB
        0x4EE3, # G+2885  U+4EE3  uni4EE3,  CJK UNIFIED IDEOGRAPH-4EE3
        0x53F0, # G+2886  U+53F0  uni53F0,  CJK UNIFIED IDEOGRAPH-53F0
        0x2F24, # G+2887  U+2F24  uni2F24,  KANGXI RADICAL BIG
        0x7B2C, # G+2888  U+7B2C  uni7B2C,  CJK UNIFIED IDEOGRAPH-7B2C
        0x918D, # G+2889  U+918D  uni918D,  CJK UNIFIED IDEOGRAPH-918D
        0x984C, # G+2890  U+984C  uni984C,  CJK UNIFIED IDEOGRAPH-984C
        0x9DF9, # G+2891  U+9DF9  uni9DF9,  CJK UNIFIED IDEOGRAPH-9DF9
        0x6EDD, # G+2892  U+6EDD  uni6EDD,  CJK UNIFIED IDEOGRAPH-6EDD
        0x7027, # G+2893  U+7027  uni7027,  CJK UNIFIED IDEOGRAPH-7027
        0x5353, # G+2894  U+5353  uni5353,  CJK UNIFIED IDEOGRAPH-5353
        0x5544, # G+2895  U+5544  uni5544,  CJK UNIFIED IDEOGRAPH-5544
        0x5B85, # G+2896  U+5B85  uni5B85,  CJK UNIFIED IDEOGRAPH-5B85
        0x6258, # G+2897  U+6258  uni6258,  CJK UNIFIED IDEOGRAPH-6258
        0x629E, # G+2898  U+629E  uni629E,  CJK UNIFIED IDEOGRAPH-629E
        0x62D3, # G+2899  U+62D3  uni62D3,  CJK UNIFIED IDEOGRAPH-62D3
        0x6CA2, # G+2900  U+6CA2  uni6CA2,  CJK UNIFIED IDEOGRAPH-6CA2
        0x6FEF, # G+2901  U+6FEF  uni6FEF,  CJK UNIFIED IDEOGRAPH-6FEF
        0x7422, # G+2902  U+7422  uni7422,  CJK UNIFIED IDEOGRAPH-7422
        0x8A17, # G+2903  U+8A17  uni8A17,  CJK UNIFIED IDEOGRAPH-8A17
        0x9438, # G+2904  U+9438  uni9438,  CJK UNIFIED IDEOGRAPH-9438
        0x6FC1, # G+2905  U+6FC1  uni6FC1,  CJK UNIFIED IDEOGRAPH-6FC1
        0x8AFE, # G+2906  U+8AFE  uni8AFE,  CJK UNIFIED IDEOGRAPH-8AFE
        0x8338, # G+2907  U+8338  uni8338,  CJK UNIFIED IDEOGRAPH-8338
        0x51E7, # G+2908  U+51E7  uni51E7,  CJK UNIFIED IDEOGRAPH-51E7
        0x86F8, # G+2909  U+86F8  uni86F8,  CJK UNIFIED IDEOGRAPH-86F8
        0x53EA, # G+2910  U+53EA  uni53EA,  CJK UNIFIED IDEOGRAPH-53EA
        0x53E9, # G+2911  U+53E9  uni53E9,  CJK UNIFIED IDEOGRAPH-53E9
        0x4F46, # G+2912  U+4F46  uni4F46,  CJK UNIFIED IDEOGRAPH-4F46
        0x9054, # G+2913  U+9054  uni9054,  CJK UNIFIED IDEOGRAPH-9054
        0x2FA0, # G+2914  U+2FA0  uni2FA0,  KANGXI RADICAL MORNING
        0x596A, # G+2915  U+596A  uni596A,  CJK UNIFIED IDEOGRAPH-596A
        0x8131, # G+2916  U+8131  uni8131,  CJK UNIFIED IDEOGRAPH-8131
        0x5DFD, # G+2917  U+5DFD  uni5DFD,  CJK UNIFIED IDEOGRAPH-5DFD
        0x7AEA, # G+2918  U+7AEA  uni7AEA,  CJK UNIFIED IDEOGRAPH-7AEA
        0x8FBF, # G+2919  U+8FBF  uni8FBF,  CJK UNIFIED IDEOGRAPH-8FBF
        0x68DA, # G+2920  U+68DA  uni68DA,  CJK UNIFIED IDEOGRAPH-68DA
        0x2F95, # G+2921  U+2F95  uni2F95,  KANGXI RADICAL VALLEY
        0x72F8, # G+2922  U+72F8  uni72F8,  CJK UNIFIED IDEOGRAPH-72F8
        0x9C48, # G+2923  U+9C48  uni9C48,  CJK UNIFIED IDEOGRAPH-9C48
        0x6A3D, # G+2924  U+6A3D  uni6A3D,  CJK UNIFIED IDEOGRAPH-6A3D
        0x8AB0, # G+2925  U+8AB0  uni8AB0,  CJK UNIFIED IDEOGRAPH-8AB0
        0x4E39, # G+2926  U+4E39  uni4E39,  CJK UNIFIED IDEOGRAPH-4E39
        0x5358, # G+2927  U+5358  uni5358,  CJK UNIFIED IDEOGRAPH-5358
        0x5606, # G+2928  U+5606  uni5606,  CJK UNIFIED IDEOGRAPH-5606
        0x5766, # G+2929  U+5766  uni5766,  CJK UNIFIED IDEOGRAPH-5766
        0x62C5, # G+2930  U+62C5  uni62C5,  CJK UNIFIED IDEOGRAPH-62C5
        0x63A2, # G+2931  U+63A2  uni63A2,  CJK UNIFIED IDEOGRAPH-63A2
        0x65E6, # G+2932  U+65E6  uni65E6,  CJK UNIFIED IDEOGRAPH-65E6
        0x6B4E, # G+2933  U+6B4E  uni6B4E,  CJK UNIFIED IDEOGRAPH-6B4E
        0x6DE1, # G+2934  U+6DE1  uni6DE1,  CJK UNIFIED IDEOGRAPH-6DE1
        0x6E5B, # G+2935  U+6E5B  uni6E5B,  CJK UNIFIED IDEOGRAPH-6E5B
        0x70AD, # G+2936  U+70AD  uni70AD,  CJK UNIFIED IDEOGRAPH-70AD
        0x77ED, # G+2937  U+77ED  uni77ED,  CJK UNIFIED IDEOGRAPH-77ED
        0x7AEF, # G+2938  U+7AEF  uni7AEF,  CJK UNIFIED IDEOGRAPH-7AEF
        0x7BAA, # G+2939  U+7BAA  uni7BAA,  CJK UNIFIED IDEOGRAPH-7BAA
        0x7DBB, # G+2940  U+7DBB  uni7DBB,  CJK UNIFIED IDEOGRAPH-7DBB
        0x803D, # G+2941  U+803D  uni803D,  CJK UNIFIED IDEOGRAPH-803D
        0x80C6, # G+2942  U+80C6  uni80C6,  CJK UNIFIED IDEOGRAPH-80C6
        0x86CB, # G+2943  U+86CB  uni86CB,  CJK UNIFIED IDEOGRAPH-86CB
        0x8A95, # G+2944  U+8A95  uni8A95,  CJK UNIFIED IDEOGRAPH-8A95
        0x935B, # G+2945  U+935B  uni935B,  CJK UNIFIED IDEOGRAPH-935B
        0x56E3, # G+2946  U+56E3  uni56E3,  CJK UNIFIED IDEOGRAPH-56E3
        0x58C7, # G+2947  U+58C7  uni58C7,  CJK UNIFIED IDEOGRAPH-58C7
        0x5F3E, # G+2948  U+5F3E  uni5F3E,  CJK UNIFIED IDEOGRAPH-5F3E
        0x65AD, # G+2949  U+65AD  uni65AD,  CJK UNIFIED IDEOGRAPH-65AD
        0x6696, # G+2950  U+6696  uni6696,  CJK UNIFIED IDEOGRAPH-6696
        0x6A80, # G+2951  U+6A80  uni6A80,  CJK UNIFIED IDEOGRAPH-6A80
        0x6BB5, # G+2952  U+6BB5  uni6BB5,  CJK UNIFIED IDEOGRAPH-6BB5
        0x7537, # G+2953  U+7537  uni7537,  CJK UNIFIED IDEOGRAPH-7537
        0x8AC7, # G+2954  U+8AC7  uni8AC7,  CJK UNIFIED IDEOGRAPH-8AC7
        0x5024, # G+2955  U+5024  uni5024,  CJK UNIFIED IDEOGRAPH-5024
        0x77E5, # G+2956  U+77E5  uni77E5,  CJK UNIFIED IDEOGRAPH-77E5
        0x5730, # G+2957  U+5730  uni5730,  CJK UNIFIED IDEOGRAPH-5730
        0x5F1B, # G+2958  U+5F1B  uni5F1B,  CJK UNIFIED IDEOGRAPH-5F1B
        0x6065, # G+2959  U+6065  uni6065,  CJK UNIFIED IDEOGRAPH-6065
        0x667A, # G+2960  U+667A  uni667A,  CJK UNIFIED IDEOGRAPH-667A
        0x6C60, # G+2961  U+6C60  uni6C60,  CJK UNIFIED IDEOGRAPH-6C60
        0x75F4, # G+2962  U+75F4  uni75F4,  CJK UNIFIED IDEOGRAPH-75F4
        0x7A1A, # G+2963  U+7A1A  uni7A1A,  CJK UNIFIED IDEOGRAPH-7A1A
        0x7F6E, # G+2964  U+7F6E  uni7F6E,  CJK UNIFIED IDEOGRAPH-7F6E
        0x81F4, # G+2965  U+81F4  uni81F4,  CJK UNIFIED IDEOGRAPH-81F4
        0x8718, # G+2966  U+8718  uni8718,  CJK UNIFIED IDEOGRAPH-8718
        0x9045, # G+2967  U+9045  uni9045,  CJK UNIFIED IDEOGRAPH-9045
        0x99B3, # G+2968  U+99B3  uni99B3,  CJK UNIFIED IDEOGRAPH-99B3
        0x7BC9, # G+2969  U+7BC9  uni7BC9,  CJK UNIFIED IDEOGRAPH-7BC9
        0x755C, # G+2970  U+755C  uni755C,  CJK UNIFIED IDEOGRAPH-755C
        0x2F75, # G+2971  U+2F75  uni2F75,  KANGXI RADICAL BAMBOO
        0x7B51, # G+2972  U+7B51  uni7B51,  CJK UNIFIED IDEOGRAPH-7B51
        0x84C4, # G+2973  U+84C4  uni84C4,  CJK UNIFIED IDEOGRAPH-84C4
        0x9010, # G+2974  U+9010  uni9010,  CJK UNIFIED IDEOGRAPH-9010
        0x79E9, # G+2975  U+79E9  uni79E9,  CJK UNIFIED IDEOGRAPH-79E9
        0x7A92, # G+2976  U+7A92  uni7A92,  CJK UNIFIED IDEOGRAPH-7A92
        0x8336, # G+2977  U+8336  uni8336,  CJK UNIFIED IDEOGRAPH-8336
        0x5AE1, # G+2978  U+5AE1  uni5AE1,  CJK UNIFIED IDEOGRAPH-5AE1
        0x7740, # G+2979  U+7740  uni7740,  CJK UNIFIED IDEOGRAPH-7740
        0x4E2D, # G+2980  U+4E2D  uni4E2D,  CJK UNIFIED IDEOGRAPH-4E2D
        0x4EF2, # G+2981  U+4EF2  uni4EF2,  CJK UNIFIED IDEOGRAPH-4EF2
        0x5B99, # G+2982  U+5B99  uni5B99,  CJK UNIFIED IDEOGRAPH-5B99
        0x5FE0, # G+2983  U+5FE0  uni5FE0,  CJK UNIFIED IDEOGRAPH-5FE0
        0x62BD, # G+2984  U+62BD  uni62BD,  CJK UNIFIED IDEOGRAPH-62BD
        0x663C, # G+2985  U+663C  uni663C,  CJK UNIFIED IDEOGRAPH-663C
        0x67F1, # G+2986  U+67F1  uni67F1,  CJK UNIFIED IDEOGRAPH-67F1
        0x6CE8, # G+2987  U+6CE8  uni6CE8,  CJK UNIFIED IDEOGRAPH-6CE8
        0x2F8D, # G+2988  U+2F8D  uni2F8D,  KANGXI RADICAL INSECT
        0x8877, # G+2989  U+8877  uni8877,  CJK UNIFIED IDEOGRAPH-8877
        0x8A3B, # G+2990  U+8A3B  uni8A3B,  CJK UNIFIED IDEOGRAPH-8A3B
        0x914E, # G+2991  U+914E  uni914E,  CJK UNIFIED IDEOGRAPH-914E
        0x92F3, # G+2992  U+92F3  uni92F3,  CJK UNIFIED IDEOGRAPH-92F3
        0x99D0, # G+2993  U+99D0  uni99D0,  CJK UNIFIED IDEOGRAPH-99D0
        0x6A17, # G+2994  U+6A17  uni6A17,  CJK UNIFIED IDEOGRAPH-6A17
        0x7026, # G+2995  U+7026  uni7026,  CJK UNIFIED IDEOGRAPH-7026
        0x732A, # G+2996  U+732A  uni732A,  CJK UNIFIED IDEOGRAPH-732A
        0x82E7, # G+2997  U+82E7  uni82E7,  CJK UNIFIED IDEOGRAPH-82E7
        0x8457, # G+2998  U+8457  uni8457,  CJK UNIFIED IDEOGRAPH-8457
        0x8CAF, # G+2999  U+8CAF  uni8CAF,  CJK UNIFIED IDEOGRAPH-8CAF
        0x4E01, # G+3000  U+4E01  uni4E01,  CJK UNIFIED IDEOGRAPH-4E01
        0x5146, # G+3001  U+5146  uni5146,  CJK UNIFIED IDEOGRAPH-5146
        0x51CB, # G+3002  U+51CB  uni51CB,  CJK UNIFIED IDEOGRAPH-51CB
        0x558B, # G+3003  U+558B  uni558B,  CJK UNIFIED IDEOGRAPH-558B
        0x5BF5, # G+3004  U+5BF5  uni5BF5,  CJK UNIFIED IDEOGRAPH-5BF5
        0x5E16, # G+3005  U+5E16  uni5E16,  CJK UNIFIED IDEOGRAPH-5E16
        0x5E33, # G+3006  U+5E33  uni5E33,  CJK UNIFIED IDEOGRAPH-5E33
        0x5E81, # G+3007  U+5E81  uni5E81,  CJK UNIFIED IDEOGRAPH-5E81
        0x5F14, # G+3008  U+5F14  uni5F14,  CJK UNIFIED IDEOGRAPH-5F14
        0x5F35, # G+3009  U+5F35  uni5F35,  CJK UNIFIED IDEOGRAPH-5F35
        0x5F6B, # G+3010  U+5F6B  uni5F6B,  CJK UNIFIED IDEOGRAPH-5F6B
        0x5FB4, # G+3011  U+5FB4  uni5FB4,  CJK UNIFIED IDEOGRAPH-5FB4
        0x61F2, # G+3012  U+61F2  uni61F2,  CJK UNIFIED IDEOGRAPH-61F2
        0x6311, # G+3013  U+6311  uni6311,  CJK UNIFIED IDEOGRAPH-6311
        0x66A2, # G+3014  U+66A2  uni66A2,  CJK UNIFIED IDEOGRAPH-66A2
        0x671D, # G+3015  U+671D  uni671D,  CJK UNIFIED IDEOGRAPH-671D
        0x6F6E, # G+3016  U+6F6E  uni6F6E,  CJK UNIFIED IDEOGRAPH-6F6E
        0x7252, # G+3017  U+7252  uni7252,  CJK UNIFIED IDEOGRAPH-7252
        0x753A, # G+3018  U+753A  uni753A,  CJK UNIFIED IDEOGRAPH-753A
        0x773A, # G+3019  U+773A  uni773A,  CJK UNIFIED IDEOGRAPH-773A
        0x8074, # G+3020  U+8074  uni8074,  CJK UNIFIED IDEOGRAPH-8074
        0x8139, # G+3021  U+8139  uni8139,  CJK UNIFIED IDEOGRAPH-8139
        0x8178, # G+3022  U+8178  uni8178,  CJK UNIFIED IDEOGRAPH-8178
        0x8776, # G+3023  U+8776  uni8776,  CJK UNIFIED IDEOGRAPH-8776
        0x8ABF, # G+3024  U+8ABF  uni8ABF,  CJK UNIFIED IDEOGRAPH-8ABF
        0x8ADC, # G+3025  U+8ADC  uni8ADC,  CJK UNIFIED IDEOGRAPH-8ADC
        0x8D85, # G+3026  U+8D85  uni8D85,  CJK UNIFIED IDEOGRAPH-8D85
        0x8DF3, # G+3027  U+8DF3  uni8DF3,  CJK UNIFIED IDEOGRAPH-8DF3
        0x929A, # G+3028  U+929A  uni929A,  CJK UNIFIED IDEOGRAPH-929A
        0x2ED1, # G+3029  U+2ED1  uni2ED1,  CJK RADICAL LONG ONE
        0x9802, # G+3030  U+9802  uni9802,  CJK UNIFIED IDEOGRAPH-9802
        0x2FC3, # G+3031  U+2FC3  uni2FC3,  KANGXI RADICAL BIRD
        0x52C5, # G+3032  U+52C5  uni52C5,  CJK UNIFIED IDEOGRAPH-52C5
        0x6357, # G+3033  U+6357  uni6357,  CJK UNIFIED IDEOGRAPH-6357
        0x76F4, # G+3034  U+76F4  uni76F4,  CJK UNIFIED IDEOGRAPH-76F4
        0x6715, # G+3035  U+6715  uni6715,  CJK UNIFIED IDEOGRAPH-6715
        0x6C88, # G+3036  U+6C88  uni6C88,  CJK UNIFIED IDEOGRAPH-6C88
        0x73CD, # G+3037  U+73CD  uni73CD,  CJK UNIFIED IDEOGRAPH-73CD
        0x8CC3, # G+3038  U+8CC3  uni8CC3,  CJK UNIFIED IDEOGRAPH-8CC3
        0x93AE, # G+3039  U+93AE  uni93AE,  CJK UNIFIED IDEOGRAPH-93AE
        0x9673, # G+3040  U+9673  uni9673,  CJK UNIFIED IDEOGRAPH-9673
        0x6D25, # G+3041  U+6D25  uni6D25,  CJK UNIFIED IDEOGRAPH-6D25
        0x589C, # G+3042  U+589C  uni589C,  CJK UNIFIED IDEOGRAPH-589C
        0x690E, # G+3043  U+690E  uni690E,  CJK UNIFIED IDEOGRAPH-690E
        0x69CC, # G+3044  U+69CC  uni69CC,  CJK UNIFIED IDEOGRAPH-69CC
        0x8FFD, # G+3045  U+8FFD  uni8FFD,  CJK UNIFIED IDEOGRAPH-8FFD
        0x939A, # G+3046  U+939A  uni939A,  CJK UNIFIED IDEOGRAPH-939A
        0x75DB, # G+3047  U+75DB  uni75DB,  CJK UNIFIED IDEOGRAPH-75DB
        0x901A, # G+3048  U+901A  uni901A,  CJK UNIFIED IDEOGRAPH-901A
        0x585A, # G+3049  U+585A  uni585A,  CJK UNIFIED IDEOGRAPH-585A
        0x6802, # G+3050  U+6802  uni6802,  CJK UNIFIED IDEOGRAPH-6802
        0x63B4, # G+3051  U+63B4  uni63B4,  CJK UNIFIED IDEOGRAPH-63B4
        0x69FB, # G+3052  U+69FB  uni69FB,  CJK UNIFIED IDEOGRAPH-69FB
        0x4F43, # G+3053  U+4F43  uni4F43,  CJK UNIFIED IDEOGRAPH-4F43
        0x6F2C, # G+3054  U+6F2C  uni6F2C,  CJK UNIFIED IDEOGRAPH-6F2C
        0x67D8, # G+3055  U+67D8  uni67D8,  CJK UNIFIED IDEOGRAPH-67D8
        0x8FBB, # G+3056  U+8FBB  uni8FBB,  CJK UNIFIED IDEOGRAPH-8FBB
        0x8526, # G+3057  U+8526  uni8526,  CJK UNIFIED IDEOGRAPH-8526
        0x7DB4, # G+3058  U+7DB4  uni7DB4,  CJK UNIFIED IDEOGRAPH-7DB4
        0x9354, # G+3059  U+9354  uni9354,  CJK UNIFIED IDEOGRAPH-9354
        0x693F, # G+3060  U+693F  uni693F,  CJK UNIFIED IDEOGRAPH-693F
        0x6F70, # G+3061  U+6F70  uni6F70,  CJK UNIFIED IDEOGRAPH-6F70
        0x576A, # G+3062  U+576A  uni576A,  CJK UNIFIED IDEOGRAPH-576A
        0x58F7, # G+3063  U+58F7  uni58F7,  CJK UNIFIED IDEOGRAPH-58F7
        0x5B2C, # G+3064  U+5B2C  uni5B2C,  CJK UNIFIED IDEOGRAPH-5B2C
        0x7D2C, # G+3065  U+7D2C  uni7D2C,  CJK UNIFIED IDEOGRAPH-7D2C
        0x2F56, # G+3066  U+2F56  uni2F56,  KANGXI RADICAL CLAW
        0x540A, # G+3067  U+540A  uni540A,  CJK UNIFIED IDEOGRAPH-540A
        0x91E3, # G+3068  U+91E3  uni91E3,  CJK UNIFIED IDEOGRAPH-91E3
        0x9DB4, # G+3069  U+9DB4  uni9DB4,  CJK UNIFIED IDEOGRAPH-9DB4
        0x4EAD, # G+3070  U+4EAD  uni4EAD,  CJK UNIFIED IDEOGRAPH-4EAD
        0x4F4E, # G+3071  U+4F4E  uni4F4E,  CJK UNIFIED IDEOGRAPH-4F4E
        0x505C, # G+3072  U+505C  uni505C,  CJK UNIFIED IDEOGRAPH-505C
        0x5075, # G+3073  U+5075  uni5075,  CJK UNIFIED IDEOGRAPH-5075
        0x5243, # G+3074  U+5243  uni5243,  CJK UNIFIED IDEOGRAPH-5243
        0x8C9E, # G+3075  U+8C9E  uni8C9E,  CJK UNIFIED IDEOGRAPH-8C9E
        0x5448, # G+3076  U+5448  uni5448,  CJK UNIFIED IDEOGRAPH-5448
        0x5824, # G+3077  U+5824  uni5824,  CJK UNIFIED IDEOGRAPH-5824
        0x5B9A, # G+3078  U+5B9A  uni5B9A,  CJK UNIFIED IDEOGRAPH-5B9A
        0x5E1D, # G+3079  U+5E1D  uni5E1D,  CJK UNIFIED IDEOGRAPH-5E1D
        0x5E95, # G+3080  U+5E95  uni5E95,  CJK UNIFIED IDEOGRAPH-5E95
        0x5EAD, # G+3081  U+5EAD  uni5EAD,  CJK UNIFIED IDEOGRAPH-5EAD
        0x5EF7, # G+3082  U+5EF7  uni5EF7,  CJK UNIFIED IDEOGRAPH-5EF7
        0x5F1F, # G+3083  U+5F1F  uni5F1F,  CJK UNIFIED IDEOGRAPH-5F1F
        0x608C, # G+3084  U+608C  uni608C,  CJK UNIFIED IDEOGRAPH-608C
        0x62B5, # G+3085  U+62B5  uni62B5,  CJK UNIFIED IDEOGRAPH-62B5
        0x633A, # G+3086  U+633A  uni633A,  CJK UNIFIED IDEOGRAPH-633A
        0x63D0, # G+3087  U+63D0  uni63D0,  CJK UNIFIED IDEOGRAPH-63D0
        0x68AF, # G+3088  U+68AF  uni68AF,  CJK UNIFIED IDEOGRAPH-68AF
        0x6C40, # G+3089  U+6C40  uni6C40,  CJK UNIFIED IDEOGRAPH-6C40
        0x7887, # G+3090  U+7887  uni7887,  CJK UNIFIED IDEOGRAPH-7887
        0x798E, # G+3091  U+798E  uni798E,  CJK UNIFIED IDEOGRAPH-798E
        0x7A0B, # G+3092  U+7A0B  uni7A0B,  CJK UNIFIED IDEOGRAPH-7A0B
        0x7DE0, # G+3093  U+7DE0  uni7DE0,  CJK UNIFIED IDEOGRAPH-7DE0
        0x8247, # G+3094  U+8247  uni8247,  CJK UNIFIED IDEOGRAPH-8247
        0x8A02, # G+3095  U+8A02  uni8A02,  CJK UNIFIED IDEOGRAPH-8A02
        0x8AE6, # G+3096  U+8AE6  uni8AE6,  CJK UNIFIED IDEOGRAPH-8AE6
        0x8E44, # G+3097  U+8E44  uni8E44,  CJK UNIFIED IDEOGRAPH-8E44
        0x9013, # G+3098  U+9013  uni9013,  CJK UNIFIED IDEOGRAPH-9013
        0x90B8, # G+3099  U+90B8  uni90B8,  CJK UNIFIED IDEOGRAPH-90B8
        0x912D, # G+3100  U+912D  uni912D,  CJK UNIFIED IDEOGRAPH-912D
        0x91D8, # G+3101  U+91D8  uni91D8,  CJK UNIFIED IDEOGRAPH-91D8
        0x2FCD, # G+3102  U+2FCD  uni2FCD,  KANGXI RADICAL TRIPOD
        0x6CE5, # G+3103  U+6CE5  uni6CE5,  CJK UNIFIED IDEOGRAPH-6CE5
        0x6458, # G+3104  U+6458  uni6458,  CJK UNIFIED IDEOGRAPH-6458
        0x64E2, # G+3105  U+64E2  uni64E2,  CJK UNIFIED IDEOGRAPH-64E2
        0x6575, # G+3106  U+6575  uni6575,  CJK UNIFIED IDEOGRAPH-6575
        0x6EF4, # G+3107  U+6EF4  uni6EF4,  CJK UNIFIED IDEOGRAPH-6EF4
        0x7684, # G+3108  U+7684  uni7684,  CJK UNIFIED IDEOGRAPH-7684
        0x7B1B, # G+3109  U+7B1B  uni7B1B,  CJK UNIFIED IDEOGRAPH-7B1B
        0x9069, # G+3110  U+9069  uni9069,  CJK UNIFIED IDEOGRAPH-9069
        0x93D1, # G+3111  U+93D1  uni93D1,  CJK UNIFIED IDEOGRAPH-93D1
        0x6EBA, # G+3112  U+6EBA  uni6EBA,  CJK UNIFIED IDEOGRAPH-6EBA
        0x54F2, # G+3113  U+54F2  uni54F2,  CJK UNIFIED IDEOGRAPH-54F2
        0x5FB9, # G+3114  U+5FB9  uni5FB9,  CJK UNIFIED IDEOGRAPH-5FB9
        0x64A4, # G+3115  U+64A4  uni64A4,  CJK UNIFIED IDEOGRAPH-64A4
        0x8F4D, # G+3116  U+8F4D  uni8F4D,  CJK UNIFIED IDEOGRAPH-8F4D
        0x8FED, # G+3117  U+8FED  uni8FED,  CJK UNIFIED IDEOGRAPH-8FED
        0x9244, # G+3118  U+9244  uni9244,  CJK UNIFIED IDEOGRAPH-9244
        0x5178, # G+3119  U+5178  uni5178,  CJK UNIFIED IDEOGRAPH-5178
        0x586B, # G+3120  U+586B  uni586B,  CJK UNIFIED IDEOGRAPH-586B
        0x5929, # G+3121  U+5929  uni5929,  CJK UNIFIED IDEOGRAPH-5929
        0x5C55, # G+3122  U+5C55  uni5C55,  CJK UNIFIED IDEOGRAPH-5C55
        0x5E97, # G+3123  U+5E97  uni5E97,  CJK UNIFIED IDEOGRAPH-5E97
        0x6DFB, # G+3124  U+6DFB  uni6DFB,  CJK UNIFIED IDEOGRAPH-6DFB
        0x7E8F, # G+3125  U+7E8F  uni7E8F,  CJK UNIFIED IDEOGRAPH-7E8F
        0x751C, # G+3126  U+751C  uni751C,  CJK UNIFIED IDEOGRAPH-751C
        0x8CBC, # G+3127  U+8CBC  uni8CBC,  CJK UNIFIED IDEOGRAPH-8CBC
        0x8EE2, # G+3128  U+8EE2  uni8EE2,  CJK UNIFIED IDEOGRAPH-8EE2
        0x985B, # G+3129  U+985B  uni985B,  CJK UNIFIED IDEOGRAPH-985B
        0x70B9, # G+3130  U+70B9  uni70B9,  CJK UNIFIED IDEOGRAPH-70B9
        0x4F1D, # G+3131  U+4F1D  uni4F1D,  CJK UNIFIED IDEOGRAPH-4F1D
        0x6BBF, # G+3132  U+6BBF  uni6BBF,  CJK UNIFIED IDEOGRAPH-6BBF
        0x6FB1, # G+3133  U+6FB1  uni6FB1,  CJK UNIFIED IDEOGRAPH-6FB1
        0x2F65, # G+3134  U+2F65  uni2F65,  KANGXI RADICAL FIELD
        0x96FB, # G+3135  U+96FB  uni96FB,  CJK UNIFIED IDEOGRAPH-96FB
        0x514E, # G+3136  U+514E  uni514E,  CJK UNIFIED IDEOGRAPH-514E
        0x5410, # G+3137  U+5410  uni5410,  CJK UNIFIED IDEOGRAPH-5410
        0x5835, # G+3138  U+5835  uni5835,  CJK UNIFIED IDEOGRAPH-5835
        0x5857, # G+3139  U+5857  uni5857,  CJK UNIFIED IDEOGRAPH-5857
        0x59AC, # G+3140  U+59AC  uni59AC,  CJK UNIFIED IDEOGRAPH-59AC
        0x5C60, # G+3141  U+5C60  uni5C60,  CJK UNIFIED IDEOGRAPH-5C60
        0x5F92, # G+3142  U+5F92  uni5F92,  CJK UNIFIED IDEOGRAPH-5F92
        0x2F43, # G+3143  U+2F43  uni2F43,  KANGXI RADICAL DIPPER
        0x675C, # G+3144  U+675C  uni675C,  CJK UNIFIED IDEOGRAPH-675C
        0x6E21, # G+3145  U+6E21  uni6E21,  CJK UNIFIED IDEOGRAPH-6E21
        0x767B, # G+3146  U+767B  uni767B,  CJK UNIFIED IDEOGRAPH-767B
        0x83DF, # G+3147  U+83DF  uni83DF,  CJK UNIFIED IDEOGRAPH-83DF
        0x8CED, # G+3148  U+8CED  uni8CED,  CJK UNIFIED IDEOGRAPH-8CED
        0x9014, # G+3149  U+9014  uni9014,  CJK UNIFIED IDEOGRAPH-9014
        0x90FD, # G+3150  U+90FD  uni90FD,  CJK UNIFIED IDEOGRAPH-90FD
        0x934D, # G+3151  U+934D  uni934D,  CJK UNIFIED IDEOGRAPH-934D
        0x7825, # G+3152  U+7825  uni7825,  CJK UNIFIED IDEOGRAPH-7825
        0x783A, # G+3153  U+783A  uni783A,  CJK UNIFIED IDEOGRAPH-783A
        0x52AA, # G+3154  U+52AA  uni52AA,  CJK UNIFIED IDEOGRAPH-52AA
        0x5EA6, # G+3155  U+5EA6  uni5EA6,  CJK UNIFIED IDEOGRAPH-5EA6
        0x2F1F, # G+3156  U+2F1F  uni2F1F,  KANGXI RADICAL EARTH
        0x5974, # G+3157  U+5974  uni5974,  CJK UNIFIED IDEOGRAPH-5974
        0x6012, # G+3158  U+6012  uni6012,  CJK UNIFIED IDEOGRAPH-6012
        0x5012, # G+3159  U+5012  uni5012,  CJK UNIFIED IDEOGRAPH-5012
        0x515A, # G+3160  U+515A  uni515A,  CJK UNIFIED IDEOGRAPH-515A
        0x51AC, # G+3161  U+51AC  uni51AC,  CJK UNIFIED IDEOGRAPH-51AC
        0x51CD, # G+3162  U+51CD  uni51CD,  CJK UNIFIED IDEOGRAPH-51CD
        0x2F11, # G+3163  U+2F11  uni2F11,  KANGXI RADICAL KNIFE
        0x5510, # G+3164  U+5510  uni5510,  CJK UNIFIED IDEOGRAPH-5510
        0x5854, # G+3165  U+5854  uni5854,  CJK UNIFIED IDEOGRAPH-5854
        0x5858, # G+3166  U+5858  uni5858,  CJK UNIFIED IDEOGRAPH-5858
        0x5957, # G+3167  U+5957  uni5957,  CJK UNIFIED IDEOGRAPH-5957
        0x5B95, # G+3168  U+5B95  uni5B95,  CJK UNIFIED IDEOGRAPH-5B95
        0x5CF6, # G+3169  U+5CF6  uni5CF6,  CJK UNIFIED IDEOGRAPH-5CF6
        0x5D8B, # G+3170  U+5D8B  uni5D8B,  CJK UNIFIED IDEOGRAPH-5D8B
        0x60BC, # G+3171  U+60BC  uni60BC,  CJK UNIFIED IDEOGRAPH-60BC
        0x6295, # G+3172  U+6295  uni6295,  CJK UNIFIED IDEOGRAPH-6295
        0x642D, # G+3173  U+642D  uni642D,  CJK UNIFIED IDEOGRAPH-642D
        0x6771, # G+3174  U+6771  uni6771,  CJK UNIFIED IDEOGRAPH-6771
        0x6843, # G+3175  U+6843  uni6843,  CJK UNIFIED IDEOGRAPH-6843
        0x68BC, # G+3176  U+68BC  uni68BC,  CJK UNIFIED IDEOGRAPH-68BC
        0x68DF, # G+3177  U+68DF  uni68DF,  CJK UNIFIED IDEOGRAPH-68DF
        0x76D7, # G+3178  U+76D7  uni76D7,  CJK UNIFIED IDEOGRAPH-76D7
        0x6DD8, # G+3179  U+6DD8  uni6DD8,  CJK UNIFIED IDEOGRAPH-6DD8
        0x6E6F, # G+3180  U+6E6F  uni6E6F,  CJK UNIFIED IDEOGRAPH-6E6F
        0x6D9B, # G+3181  U+6D9B  uni6D9B,  CJK UNIFIED IDEOGRAPH-6D9B
        0x706F, # G+3182  U+706F  uni706F,  CJK UNIFIED IDEOGRAPH-706F
        0x71C8, # G+3183  U+71C8  uni71C8,  CJK UNIFIED IDEOGRAPH-71C8
        0x5F53, # G+3184  U+5F53  uni5F53,  CJK UNIFIED IDEOGRAPH-5F53
        0x75D8, # G+3185  U+75D8  uni75D8,  CJK UNIFIED IDEOGRAPH-75D8
        0x7977, # G+3186  U+7977  uni7977,  CJK UNIFIED IDEOGRAPH-7977
        0x7B49, # G+3187  U+7B49  uni7B49,  CJK UNIFIED IDEOGRAPH-7B49
        0x7B54, # G+3188  U+7B54  uni7B54,  CJK UNIFIED IDEOGRAPH-7B54
        0x7B52, # G+3189  U+7B52  uni7B52,  CJK UNIFIED IDEOGRAPH-7B52
        0x7CD6, # G+3190  U+7CD6  uni7CD6,  CJK UNIFIED IDEOGRAPH-7CD6
        0x7D71, # G+3191  U+7D71  uni7D71,  CJK UNIFIED IDEOGRAPH-7D71
        0x5230, # G+3192  U+5230  uni5230,  CJK UNIFIED IDEOGRAPH-5230
        0x8463, # G+3193  U+8463  uni8463,  CJK UNIFIED IDEOGRAPH-8463
        0x8569, # G+3194  U+8569  uni8569,  CJK UNIFIED IDEOGRAPH-8569
        0x85E4, # G+3195  U+85E4  uni85E4,  CJK UNIFIED IDEOGRAPH-85E4
        0x8A0E, # G+3196  U+8A0E  uni8A0E,  CJK UNIFIED IDEOGRAPH-8A0E
        0x8B04, # G+3197  U+8B04  uni8B04,  CJK UNIFIED IDEOGRAPH-8B04
        0x2F96, # G+3198  U+2F96  uni2F96,  KANGXI RADICAL BEAN
        0x8E0F, # G+3199  U+8E0F  uni8E0F,  CJK UNIFIED IDEOGRAPH-8E0F
        0x9003, # G+3200  U+9003  uni9003,  CJK UNIFIED IDEOGRAPH-9003
        0x900F, # G+3201  U+900F  uni900F,  CJK UNIFIED IDEOGRAPH-900F
        0x9419, # G+3202  U+9419  uni9419,  CJK UNIFIED IDEOGRAPH-9419
        0x9676, # G+3203  U+9676  uni9676,  CJK UNIFIED IDEOGRAPH-9676
        0x982D, # G+3204  U+982D  uni982D,  CJK UNIFIED IDEOGRAPH-982D
        0x9A30, # G+3205  U+9A30  uni9A30,  CJK UNIFIED IDEOGRAPH-9A30
        0x95D8, # G+3206  U+95D8  uni95D8,  CJK UNIFIED IDEOGRAPH-95D8
        0x50CD, # G+3207  U+50CD  uni50CD,  CJK UNIFIED IDEOGRAPH-50CD
        0x52D5, # G+3208  U+52D5  uni52D5,  CJK UNIFIED IDEOGRAPH-52D5
        0x540C, # G+3209  U+540C  uni540C,  CJK UNIFIED IDEOGRAPH-540C
        0x5802, # G+3210  U+5802  uni5802,  CJK UNIFIED IDEOGRAPH-5802
        0x5C0E, # G+3211  U+5C0E  uni5C0E,  CJK UNIFIED IDEOGRAPH-5C0E
        0x61A7, # G+3212  U+61A7  uni61A7,  CJK UNIFIED IDEOGRAPH-61A7
        0x649E, # G+3213  U+649E  uni649E,  CJK UNIFIED IDEOGRAPH-649E
        0x6D1E, # G+3214  U+6D1E  uni6D1E,  CJK UNIFIED IDEOGRAPH-6D1E
        0x77B3, # G+3215  U+77B3  uni77B3,  CJK UNIFIED IDEOGRAPH-77B3
        0x7AE5, # G+3216  U+7AE5  uni7AE5,  CJK UNIFIED IDEOGRAPH-7AE5
        0x80F4, # G+3217  U+80F4  uni80F4,  CJK UNIFIED IDEOGRAPH-80F4
        0x8404, # G+3218  U+8404  uni8404,  CJK UNIFIED IDEOGRAPH-8404
        0x9053, # G+3219  U+9053  uni9053,  CJK UNIFIED IDEOGRAPH-9053
        0x9285, # G+3220  U+9285  uni9285,  CJK UNIFIED IDEOGRAPH-9285
        0x5CE0, # G+3221  U+5CE0  uni5CE0,  CJK UNIFIED IDEOGRAPH-5CE0
        0x9D07, # G+3222  U+9D07  uni9D07,  CJK UNIFIED IDEOGRAPH-9D07
        0x533F, # G+3223  U+533F  uni533F,  CJK UNIFIED IDEOGRAPH-533F
        0x5F97, # G+3224  U+5F97  uni5F97,  CJK UNIFIED IDEOGRAPH-5F97
        0x5FB3, # G+3225  U+5FB3  uni5FB3,  CJK UNIFIED IDEOGRAPH-5FB3
        0x6D9C, # G+3226  U+6D9C  uni6D9C,  CJK UNIFIED IDEOGRAPH-6D9C
        0x7279, # G+3227  U+7279  uni7279,  CJK UNIFIED IDEOGRAPH-7279
        0x7763, # G+3228  U+7763  uni7763,  CJK UNIFIED IDEOGRAPH-7763
        0x79BF, # G+3229  U+79BF  uni79BF,  CJK UNIFIED IDEOGRAPH-79BF
        0x7BE4, # G+3230  U+7BE4  uni7BE4,  CJK UNIFIED IDEOGRAPH-7BE4
        0x6BD2, # G+3231  U+6BD2  uni6BD2,  CJK UNIFIED IDEOGRAPH-6BD2
        0x72EC, # G+3232  U+72EC  uni72EC,  CJK UNIFIED IDEOGRAPH-72EC
        0x8AAD, # G+3233  U+8AAD  uni8AAD,  CJK UNIFIED IDEOGRAPH-8AAD
        0x6803, # G+3234  U+6803  uni6803,  CJK UNIFIED IDEOGRAPH-6803
        0x6A61, # G+3235  U+6A61  uni6A61,  CJK UNIFIED IDEOGRAPH-6A61
        0x51F8, # G+3236  U+51F8  uni51F8,  CJK UNIFIED IDEOGRAPH-51F8
        0x7A81, # G+3237  U+7A81  uni7A81,  CJK UNIFIED IDEOGRAPH-7A81
        0x6934, # G+3238  U+6934  uni6934,  CJK UNIFIED IDEOGRAPH-6934
        0x5C4A, # G+3239  U+5C4A  uni5C4A,  CJK UNIFIED IDEOGRAPH-5C4A
        0x9CF6, # G+3240  U+9CF6  uni9CF6,  CJK UNIFIED IDEOGRAPH-9CF6
        0x82EB, # G+3241  U+82EB  uni82EB,  CJK UNIFIED IDEOGRAPH-82EB
        0x5BC5, # G+3242  U+5BC5  uni5BC5,  CJK UNIFIED IDEOGRAPH-5BC5
        0x2FA3, # G+3243  U+2FA3  uni2FA3,  KANGXI RADICAL WINE
        0x701E, # G+3244  U+701E  uni701E,  CJK UNIFIED IDEOGRAPH-701E
        0x5678, # G+3245  U+5678  uni5678,  CJK UNIFIED IDEOGRAPH-5678
        0x5C6F, # G+3246  U+5C6F  uni5C6F,  CJK UNIFIED IDEOGRAPH-5C6F
        0x60C7, # G+3247  U+60C7  uni60C7,  CJK UNIFIED IDEOGRAPH-60C7
        0x6566, # G+3248  U+6566  uni6566,  CJK UNIFIED IDEOGRAPH-6566
        0x6C8C, # G+3249  U+6C8C  uni6C8C,  CJK UNIFIED IDEOGRAPH-6C8C
        0x8C5A, # G+3250  U+8C5A  uni8C5A,  CJK UNIFIED IDEOGRAPH-8C5A
        0x9041, # G+3251  U+9041  uni9041,  CJK UNIFIED IDEOGRAPH-9041
        0x9813, # G+3252  U+9813  uni9813,  CJK UNIFIED IDEOGRAPH-9813
        0x5451, # G+3253  U+5451  uni5451,  CJK UNIFIED IDEOGRAPH-5451
        0x66C7, # G+3254  U+66C7  uni66C7,  CJK UNIFIED IDEOGRAPH-66C7
        0x920D, # G+3255  U+920D  uni920D,  CJK UNIFIED IDEOGRAPH-920D
        0x5948, # G+3256  U+5948  uni5948,  CJK UNIFIED IDEOGRAPH-5948
        0x90A3, # G+3257  U+90A3  uni90A3,  CJK UNIFIED IDEOGRAPH-90A3
        0x5185, # G+3258  U+5185  uni5185,  CJK UNIFIED IDEOGRAPH-5185
        0x4E4D, # G+3259  U+4E4D  uni4E4D,  CJK UNIFIED IDEOGRAPH-4E4D
        0x51EA, # G+3260  U+51EA  uni51EA,  CJK UNIFIED IDEOGRAPH-51EA
        0x8599, # G+3261  U+8599  uni8599,  CJK UNIFIED IDEOGRAPH-8599
        0x8B0E, # G+3262  U+8B0E  uni8B0E,  CJK UNIFIED IDEOGRAPH-8B0E
        0x7058, # G+3263  U+7058  uni7058,  CJK UNIFIED IDEOGRAPH-7058
        0x637A, # G+3264  U+637A  uni637A,  CJK UNIFIED IDEOGRAPH-637A
        0x934B, # G+3265  U+934B  uni934B,  CJK UNIFIED IDEOGRAPH-934B
        0x6962, # G+3266  U+6962  uni6962,  CJK UNIFIED IDEOGRAPH-6962
        0x99B4, # G+3267  U+99B4  uni99B4,  CJK UNIFIED IDEOGRAPH-99B4
        0x7E04, # G+3268  U+7E04  uni7E04,  CJK UNIFIED IDEOGRAPH-7E04
        0x7577, # G+3269  U+7577  uni7577,  CJK UNIFIED IDEOGRAPH-7577
        0x5357, # G+3270  U+5357  uni5357,  CJK UNIFIED IDEOGRAPH-5357
        0x6960, # G+3271  U+6960  uni6960,  CJK UNIFIED IDEOGRAPH-6960
        0x8EDF, # G+3272  U+8EDF  uni8EDF,  CJK UNIFIED IDEOGRAPH-8EDF
        0x96E3, # G+3273  U+96E3  uni96E3,  CJK UNIFIED IDEOGRAPH-96E3
        0x6C5D, # G+3274  U+6C5D  uni6C5D,  CJK UNIFIED IDEOGRAPH-6C5D
        0x2F06, # G+3275  U+2F06  uni2F06,  KANGXI RADICAL TWO
        0x5C3C, # G+3276  U+5C3C  uni5C3C,  CJK UNIFIED IDEOGRAPH-5C3C
        0x5F10, # G+3277  U+5F10  uni5F10,  CJK UNIFIED IDEOGRAPH-5F10
        0x8FE9, # G+3278  U+8FE9  uni8FE9,  CJK UNIFIED IDEOGRAPH-8FE9
        0x5302, # G+3279  U+5302  uni5302,  CJK UNIFIED IDEOGRAPH-5302
        0x8CD1, # G+3280  U+8CD1  uni8CD1,  CJK UNIFIED IDEOGRAPH-8CD1
        0x2F81, # G+3281  U+2F81  uni2F81,  KANGXI RADICAL MEAT
        0x8679, # G+3282  U+8679  uni8679,  CJK UNIFIED IDEOGRAPH-8679
        0x5EFF, # G+3283  U+5EFF  uni5EFF,  CJK UNIFIED IDEOGRAPH-5EFF
        0x2F47, # G+3284  U+2F47  uni2F47,  KANGXI RADICAL SUN
        0x4E73, # G+3285  U+4E73  uni4E73,  CJK UNIFIED IDEOGRAPH-4E73
        0x2F0A, # G+3286  U+2F0A  uni2F0A,  KANGXI RADICAL ENTER
        0x5982, # G+3287  U+5982  uni5982,  CJK UNIFIED IDEOGRAPH-5982
        0x5C3F, # G+3288  U+5C3F  uni5C3F,  CJK UNIFIED IDEOGRAPH-5C3F
        0x97EE, # G+3289  U+97EE  uni97EE,  CJK UNIFIED IDEOGRAPH-97EE
        0x4EFB, # G+3290  U+4EFB  uni4EFB,  CJK UNIFIED IDEOGRAPH-4EFB
        0x598A, # G+3291  U+598A  uni598A,  CJK UNIFIED IDEOGRAPH-598A
        0x5FCD, # G+3292  U+5FCD  uni5FCD,  CJK UNIFIED IDEOGRAPH-5FCD
        0x8A8D, # G+3293  U+8A8D  uni8A8D,  CJK UNIFIED IDEOGRAPH-8A8D
        0x6FE1, # G+3294  U+6FE1  uni6FE1,  CJK UNIFIED IDEOGRAPH-6FE1
        0x79B0, # G+3295  U+79B0  uni79B0,  CJK UNIFIED IDEOGRAPH-79B0
        0x7962, # G+3296  U+7962  uni7962,  CJK UNIFIED IDEOGRAPH-7962
        0x5BE7, # G+3297  U+5BE7  uni5BE7,  CJK UNIFIED IDEOGRAPH-5BE7
        0x8471, # G+3298  U+8471  uni8471,  CJK UNIFIED IDEOGRAPH-8471
        0x732B, # G+3299  U+732B  uni732B,  CJK UNIFIED IDEOGRAPH-732B
        0x71B1, # G+3300  U+71B1  uni71B1,  CJK UNIFIED IDEOGRAPH-71B1
        0x5E74, # G+3301  U+5E74  uni5E74,  CJK UNIFIED IDEOGRAPH-5E74
        0x5FF5, # G+3302  U+5FF5  uni5FF5,  CJK UNIFIED IDEOGRAPH-5FF5
        0x637B, # G+3303  U+637B  uni637B,  CJK UNIFIED IDEOGRAPH-637B
        0x649A, # G+3304  U+649A  uni649A,  CJK UNIFIED IDEOGRAPH-649A
        0x71C3, # G+3305  U+71C3  uni71C3,  CJK UNIFIED IDEOGRAPH-71C3
        0x7C98, # G+3306  U+7C98  uni7C98,  CJK UNIFIED IDEOGRAPH-7C98
        0x4E43, # G+3307  U+4E43  uni4E43,  CJK UNIFIED IDEOGRAPH-4E43
        0x5EFC, # G+3308  U+5EFC  uni5EFC,  CJK UNIFIED IDEOGRAPH-5EFC
        0x4E4B, # G+3309  U+4E4B  uni4E4B,  CJK UNIFIED IDEOGRAPH-4E4B
        0x57DC, # G+3310  U+57DC  uni57DC,  CJK UNIFIED IDEOGRAPH-57DC
        0x56A2, # G+3311  U+56A2  uni56A2,  CJK UNIFIED IDEOGRAPH-56A2
        0x60A9, # G+3312  U+60A9  uni60A9,  CJK UNIFIED IDEOGRAPH-60A9
        0x6FC3, # G+3313  U+6FC3  uni6FC3,  CJK UNIFIED IDEOGRAPH-6FC3
        0x7D0D, # G+3314  U+7D0D  uni7D0D,  CJK UNIFIED IDEOGRAPH-7D0D
        0x80FD, # G+3315  U+80FD  uni80FD,  CJK UNIFIED IDEOGRAPH-80FD
        0x8133, # G+3316  U+8133  uni8133,  CJK UNIFIED IDEOGRAPH-8133
        0x81BF, # G+3317  U+81BF  uni81BF,  CJK UNIFIED IDEOGRAPH-81BF
        0x8FB2, # G+3318  U+8FB2  uni8FB2,  CJK UNIFIED IDEOGRAPH-8FB2
        0x8997, # G+3319  U+8997  uni8997,  CJK UNIFIED IDEOGRAPH-8997
        0x86A4, # G+3320  U+86A4  uni86A4,  CJK UNIFIED IDEOGRAPH-86A4
        0x5DF4, # G+3321  U+5DF4  uni5DF4,  CJK UNIFIED IDEOGRAPH-5DF4
        0x628A, # G+3322  U+628A  uni628A,  CJK UNIFIED IDEOGRAPH-628A
        0x64AD, # G+3323  U+64AD  uni64AD,  CJK UNIFIED IDEOGRAPH-64AD
        0x8987, # G+3324  U+8987  uni8987,  CJK UNIFIED IDEOGRAPH-8987
        0x6777, # G+3325  U+6777  uni6777,  CJK UNIFIED IDEOGRAPH-6777
        0x6CE2, # G+3326  U+6CE2  uni6CE2,  CJK UNIFIED IDEOGRAPH-6CE2
        0x6D3E, # G+3327  U+6D3E  uni6D3E,  CJK UNIFIED IDEOGRAPH-6D3E
        0x7436, # G+3328  U+7436  uni7436,  CJK UNIFIED IDEOGRAPH-7436
        0x7834, # G+3329  U+7834  uni7834,  CJK UNIFIED IDEOGRAPH-7834
        0x5A46, # G+3330  U+5A46  uni5A46,  CJK UNIFIED IDEOGRAPH-5A46
        0x7F75, # G+3331  U+7F75  uni7F75,  CJK UNIFIED IDEOGRAPH-7F75
        0x82AD, # G+3332  U+82AD  uni82AD,  CJK UNIFIED IDEOGRAPH-82AD
        0x2FBA, # G+3333  U+2FBA  uni2FBA,  KANGXI RADICAL HORSE
        0x4FF3, # G+3334  U+4FF3  uni4FF3,  CJK UNIFIED IDEOGRAPH-4FF3
        0x5EC3, # G+3335  U+5EC3  uni5EC3,  CJK UNIFIED IDEOGRAPH-5EC3
        0x62DD, # G+3336  U+62DD  uni62DD,  CJK UNIFIED IDEOGRAPH-62DD
        0x6392, # G+3337  U+6392  uni6392,  CJK UNIFIED IDEOGRAPH-6392
        0x6557, # G+3338  U+6557  uni6557,  CJK UNIFIED IDEOGRAPH-6557
        0x676F, # G+3339  U+676F  uni676F,  CJK UNIFIED IDEOGRAPH-676F
        0x76C3, # G+3340  U+76C3  uni76C3,  CJK UNIFIED IDEOGRAPH-76C3
        0x724C, # G+3341  U+724C  uni724C,  CJK UNIFIED IDEOGRAPH-724C
        0x80CC, # G+3342  U+80CC  uni80CC,  CJK UNIFIED IDEOGRAPH-80CC
        0x80BA, # G+3343  U+80BA  uni80BA,  CJK UNIFIED IDEOGRAPH-80BA
        0x8F29, # G+3344  U+8F29  uni8F29,  CJK UNIFIED IDEOGRAPH-8F29
        0x914D, # G+3345  U+914D  uni914D,  CJK UNIFIED IDEOGRAPH-914D
        0x500D, # G+3346  U+500D  uni500D,  CJK UNIFIED IDEOGRAPH-500D
        0x57F9, # G+3347  U+57F9  uni57F9,  CJK UNIFIED IDEOGRAPH-57F9
        0x5A92, # G+3348  U+5A92  uni5A92,  CJK UNIFIED IDEOGRAPH-5A92
        0x6885, # G+3349  U+6885  uni6885,  CJK UNIFIED IDEOGRAPH-6885
        0x6973, # G+3350  U+6973  uni6973,  CJK UNIFIED IDEOGRAPH-6973
        0x7164, # G+3351  U+7164  uni7164,  CJK UNIFIED IDEOGRAPH-7164
        0x72FD, # G+3352  U+72FD  uni72FD,  CJK UNIFIED IDEOGRAPH-72FD
        0x8CB7, # G+3353  U+8CB7  uni8CB7,  CJK UNIFIED IDEOGRAPH-8CB7
        0x58F2, # G+3354  U+58F2  uni58F2,  CJK UNIFIED IDEOGRAPH-58F2
        0x8CE0, # G+3355  U+8CE0  uni8CE0,  CJK UNIFIED IDEOGRAPH-8CE0
        0x966A, # G+3356  U+966A  uni966A,  CJK UNIFIED IDEOGRAPH-966A
        0x9019, # G+3357  U+9019  uni9019,  CJK UNIFIED IDEOGRAPH-9019
        0x877F, # G+3358  U+877F  uni877F,  CJK UNIFIED IDEOGRAPH-877F
        0x79E4, # G+3359  U+79E4  uni79E4,  CJK UNIFIED IDEOGRAPH-79E4
        0x77E7, # G+3360  U+77E7  uni77E7,  CJK UNIFIED IDEOGRAPH-77E7
        0x8429, # G+3361  U+8429  uni8429,  CJK UNIFIED IDEOGRAPH-8429
        0x4F2F, # G+3362  U+4F2F  uni4F2F,  CJK UNIFIED IDEOGRAPH-4F2F
        0x5265, # G+3363  U+5265  uni5265,  CJK UNIFIED IDEOGRAPH-5265
        0x535A, # G+3364  U+535A  uni535A,  CJK UNIFIED IDEOGRAPH-535A
        0x62CD, # G+3365  U+62CD  uni62CD,  CJK UNIFIED IDEOGRAPH-62CD
        0x67CF, # G+3366  U+67CF  uni67CF,  CJK UNIFIED IDEOGRAPH-67CF
        0x6CCA, # G+3367  U+6CCA  uni6CCA,  CJK UNIFIED IDEOGRAPH-6CCA
        0x2F69, # G+3368  U+2F69  uni2F69,  KANGXI RADICAL WHITE
        0x7B94, # G+3369  U+7B94  uni7B94,  CJK UNIFIED IDEOGRAPH-7B94
        0x7C95, # G+3370  U+7C95  uni7C95,  CJK UNIFIED IDEOGRAPH-7C95
        0x8236, # G+3371  U+8236  uni8236,  CJK UNIFIED IDEOGRAPH-8236
        0x8584, # G+3372  U+8584  uni8584,  CJK UNIFIED IDEOGRAPH-8584
        0x8FEB, # G+3373  U+8FEB  uni8FEB,  CJK UNIFIED IDEOGRAPH-8FEB
        0x66DD, # G+3374  U+66DD  uni66DD,  CJK UNIFIED IDEOGRAPH-66DD
        0x6F20, # G+3375  U+6F20  uni6F20,  CJK UNIFIED IDEOGRAPH-6F20
        0x7206, # G+3376  U+7206  uni7206,  CJK UNIFIED IDEOGRAPH-7206
        0x7E1B, # G+3377  U+7E1B  uni7E1B,  CJK UNIFIED IDEOGRAPH-7E1B
        0x83AB, # G+3378  U+83AB  uni83AB,  CJK UNIFIED IDEOGRAPH-83AB
        0x99C1, # G+3379  U+99C1  uni99C1,  CJK UNIFIED IDEOGRAPH-99C1
        0x2EE8, # G+3380  U+2EE8  uni2EE8,  CJK RADICAL SIMPLIFIED WHEAT
        0x51FD, # G+3381  U+51FD  uni51FD,  CJK UNIFIED IDEOGRAPH-51FD
        0x7BB1, # G+3382  U+7BB1  uni7BB1,  CJK UNIFIED IDEOGRAPH-7BB1
        0x7872, # G+3383  U+7872  uni7872,  CJK UNIFIED IDEOGRAPH-7872
        0x7BB8, # G+3384  U+7BB8  uni7BB8,  CJK UNIFIED IDEOGRAPH-7BB8
        0x8087, # G+3385  U+8087  uni8087,  CJK UNIFIED IDEOGRAPH-8087
        0x7B48, # G+3386  U+7B48  uni7B48,  CJK UNIFIED IDEOGRAPH-7B48
        0x6AE8, # G+3387  U+6AE8  uni6AE8,  CJK UNIFIED IDEOGRAPH-6AE8
        0x5E61, # G+3388  U+5E61  uni5E61,  CJK UNIFIED IDEOGRAPH-5E61
        0x808C, # G+3389  U+808C  uni808C,  CJK UNIFIED IDEOGRAPH-808C
        0x7551, # G+3390  U+7551  uni7551,  CJK UNIFIED IDEOGRAPH-7551
        0x7560, # G+3391  U+7560  uni7560,  CJK UNIFIED IDEOGRAPH-7560
        0x2F0B, # G+3392  U+2F0B  uni2F0B,  KANGXI RADICAL EIGHT
        0x9262, # G+3393  U+9262  uni9262,  CJK UNIFIED IDEOGRAPH-9262
        0x6E8C, # G+3394  U+6E8C  uni6E8C,  CJK UNIFIED IDEOGRAPH-6E8C
        0x767A, # G+3395  U+767A  uni767A,  CJK UNIFIED IDEOGRAPH-767A
        0x9197, # G+3396  U+9197  uni9197,  CJK UNIFIED IDEOGRAPH-9197
        0x9AEA, # G+3397  U+9AEA  uni9AEA,  CJK UNIFIED IDEOGRAPH-9AEA
        0x4F10, # G+3398  U+4F10  uni4F10,  CJK UNIFIED IDEOGRAPH-4F10
        0x7F70, # G+3399  U+7F70  uni7F70,  CJK UNIFIED IDEOGRAPH-7F70
        0x629C, # G+3400  U+629C  uni629C,  CJK UNIFIED IDEOGRAPH-629C
        0x7B4F, # G+3401  U+7B4F  uni7B4F,  CJK UNIFIED IDEOGRAPH-7B4F
        0x95A5, # G+3402  U+95A5  uni95A5,  CJK UNIFIED IDEOGRAPH-95A5
        0x9CE9, # G+3403  U+9CE9  uni9CE9,  CJK UNIFIED IDEOGRAPH-9CE9
        0x567A, # G+3404  U+567A  uni567A,  CJK UNIFIED IDEOGRAPH-567A
        0x5859, # G+3405  U+5859  uni5859,  CJK UNIFIED IDEOGRAPH-5859
        0x86E4, # G+3406  U+86E4  uni86E4,  CJK UNIFIED IDEOGRAPH-86E4
        0x96BC, # G+3407  U+96BC  uni96BC,  CJK UNIFIED IDEOGRAPH-96BC
        0x4F34, # G+3408  U+4F34  uni4F34,  CJK UNIFIED IDEOGRAPH-4F34
        0x5224, # G+3409  U+5224  uni5224,  CJK UNIFIED IDEOGRAPH-5224
        0x534A, # G+3410  U+534A  uni534A,  CJK UNIFIED IDEOGRAPH-534A
        0x53CD, # G+3411  U+53CD  uni53CD,  CJK UNIFIED IDEOGRAPH-53CD
        0x53DB, # G+3412  U+53DB  uni53DB,  CJK UNIFIED IDEOGRAPH-53DB
        0x5E06, # G+3413  U+5E06  uni5E06,  CJK UNIFIED IDEOGRAPH-5E06
        0x642C, # G+3414  U+642C  uni642C,  CJK UNIFIED IDEOGRAPH-642C
        0x6591, # G+3415  U+6591  uni6591,  CJK UNIFIED IDEOGRAPH-6591
        0x677F, # G+3416  U+677F  uni677F,  CJK UNIFIED IDEOGRAPH-677F
        0x6C3E, # G+3417  U+6C3E  uni6C3E,  CJK UNIFIED IDEOGRAPH-6C3E
        0x6C4E, # G+3418  U+6C4E  uni6C4E,  CJK UNIFIED IDEOGRAPH-6C4E
        0x7248, # G+3419  U+7248  uni7248,  CJK UNIFIED IDEOGRAPH-7248
        0x72AF, # G+3420  U+72AF  uni72AF,  CJK UNIFIED IDEOGRAPH-72AF
        0x73ED, # G+3421  U+73ED  uni73ED,  CJK UNIFIED IDEOGRAPH-73ED
        0x7554, # G+3422  U+7554  uni7554,  CJK UNIFIED IDEOGRAPH-7554
        0x7E41, # G+3423  U+7E41  uni7E41,  CJK UNIFIED IDEOGRAPH-7E41
        0x822C, # G+3424  U+822C  uni822C,  CJK UNIFIED IDEOGRAPH-822C
        0x85E9, # G+3425  U+85E9  uni85E9,  CJK UNIFIED IDEOGRAPH-85E9
        0x8CA9, # G+3426  U+8CA9  uni8CA9,  CJK UNIFIED IDEOGRAPH-8CA9
        0x7BC4, # G+3427  U+7BC4  uni7BC4,  CJK UNIFIED IDEOGRAPH-7BC4
        0x2FA4, # G+3428  U+2FA4  uni2FA4,  KANGXI RADICAL DISTINGUISH
        0x7169, # G+3429  U+7169  uni7169,  CJK UNIFIED IDEOGRAPH-7169
        0x9812, # G+3430  U+9812  uni9812,  CJK UNIFIED IDEOGRAPH-9812
        0x98EF, # G+3431  U+98EF  uni98EF,  CJK UNIFIED IDEOGRAPH-98EF
        0x633D, # G+3432  U+633D  uni633D,  CJK UNIFIED IDEOGRAPH-633D
        0x6669, # G+3433  U+6669  uni6669,  CJK UNIFIED IDEOGRAPH-6669
        0x756A, # G+3434  U+756A  uni756A,  CJK UNIFIED IDEOGRAPH-756A
        0x76E4, # G+3435  U+76E4  uni76E4,  CJK UNIFIED IDEOGRAPH-76E4
        0x78D0, # G+3436  U+78D0  uni78D0,  CJK UNIFIED IDEOGRAPH-78D0
        0x8543, # G+3437  U+8543  uni8543,  CJK UNIFIED IDEOGRAPH-8543
        0x86EE, # G+3438  U+86EE  uni86EE,  CJK UNIFIED IDEOGRAPH-86EE
        0x532A, # G+3439  U+532A  uni532A,  CJK UNIFIED IDEOGRAPH-532A
        0x5351, # G+3440  U+5351  uni5351,  CJK UNIFIED IDEOGRAPH-5351
        0x5426, # G+3441  U+5426  uni5426,  CJK UNIFIED IDEOGRAPH-5426
        0x5983, # G+3442  U+5983  uni5983,  CJK UNIFIED IDEOGRAPH-5983
        0x5E87, # G+3443  U+5E87  uni5E87,  CJK UNIFIED IDEOGRAPH-5E87
        0x5F7C, # G+3444  U+5F7C  uni5F7C,  CJK UNIFIED IDEOGRAPH-5F7C
        0x60B2, # G+3445  U+60B2  uni60B2,  CJK UNIFIED IDEOGRAPH-60B2
        0x6249, # G+3446  U+6249  uni6249,  CJK UNIFIED IDEOGRAPH-6249
        0x6279, # G+3447  U+6279  uni6279,  CJK UNIFIED IDEOGRAPH-6279
        0x62AB, # G+3448  U+62AB  uni62AB,  CJK UNIFIED IDEOGRAPH-62AB
        0x6590, # G+3449  U+6590  uni6590,  CJK UNIFIED IDEOGRAPH-6590
        0x2F50, # G+3450  U+2F50  uni2F50,  KANGXI RADICAL COMPARE
        0x6CCC, # G+3451  U+6CCC  uni6CCC,  CJK UNIFIED IDEOGRAPH-6CCC
        0x75B2, # G+3452  U+75B2  uni75B2,  CJK UNIFIED IDEOGRAPH-75B2
        0x2F6A, # G+3453  U+2F6A  uni2F6A,  KANGXI RADICAL SKIN
        0x7891, # G+3454  U+7891  uni7891,  CJK UNIFIED IDEOGRAPH-7891
        0x79D8, # G+3455  U+79D8  uni79D8,  CJK UNIFIED IDEOGRAPH-79D8
        0x7DCB, # G+3456  U+7DCB  uni7DCB,  CJK UNIFIED IDEOGRAPH-7DCB
        0x7F77, # G+3457  U+7F77  uni7F77,  CJK UNIFIED IDEOGRAPH-7F77
        0x80A5, # G+3458  U+80A5  uni80A5,  CJK UNIFIED IDEOGRAPH-80A5
        0x88AB, # G+3459  U+88AB  uni88AB,  CJK UNIFIED IDEOGRAPH-88AB
        0x8AB9, # G+3460  U+8AB9  uni8AB9,  CJK UNIFIED IDEOGRAPH-8AB9
        0x8CBB, # G+3461  U+8CBB  uni8CBB,  CJK UNIFIED IDEOGRAPH-8CBB
        0x907F, # G+3462  U+907F  uni907F,  CJK UNIFIED IDEOGRAPH-907F
        0x2FAE, # G+3463  U+2FAE  uni2FAE,  KANGXI RADICAL WRONG
        0x2FB6, # G+3464  U+2FB6  uni2FB6,  KANGXI RADICAL FLY
        0x6A0B, # G+3465  U+6A0B  uni6A0B,  CJK UNIFIED IDEOGRAPH-6A0B
        0x7C38, # G+3466  U+7C38  uni7C38,  CJK UNIFIED IDEOGRAPH-7C38
        0x5099, # G+3467  U+5099  uni5099,  CJK UNIFIED IDEOGRAPH-5099
        0x5C3E, # G+3468  U+5C3E  uni5C3E,  CJK UNIFIED IDEOGRAPH-5C3E
        0x5FAE, # G+3469  U+5FAE  uni5FAE,  CJK UNIFIED IDEOGRAPH-5FAE
        0x6787, # G+3470  U+6787  uni6787,  CJK UNIFIED IDEOGRAPH-6787
        0x6BD8, # G+3471  U+6BD8  uni6BD8,  CJK UNIFIED IDEOGRAPH-6BD8
        0x7435, # G+3472  U+7435  uni7435,  CJK UNIFIED IDEOGRAPH-7435
        0x7709, # G+3473  U+7709  uni7709,  CJK UNIFIED IDEOGRAPH-7709
        0x7F8E, # G+3474  U+7F8E  uni7F8E,  CJK UNIFIED IDEOGRAPH-7F8E
        0x2FD0, # G+3475  U+2FD0  uni2FD0,  KANGXI RADICAL NOSE
        0x67CA, # G+3476  U+67CA  uni67CA,  CJK UNIFIED IDEOGRAPH-67CA
        0x7A17, # G+3477  U+7A17  uni7A17,  CJK UNIFIED IDEOGRAPH-7A17
        0x5339, # G+3478  U+5339  uni5339,  CJK UNIFIED IDEOGRAPH-5339
        0x2F66, # G+3479  U+2F66  uni2F66,  KANGXI RADICAL BOLT OF CLOTH
        0x9AED, # G+3480  U+9AED  uni9AED,  CJK UNIFIED IDEOGRAPH-9AED
        0x5F66, # G+3481  U+5F66  uni5F66,  CJK UNIFIED IDEOGRAPH-5F66
        0x819D, # G+3482  U+819D  uni819D,  CJK UNIFIED IDEOGRAPH-819D
        0x83F1, # G+3483  U+83F1  uni83F1,  CJK UNIFIED IDEOGRAPH-83F1
        0x8098, # G+3484  U+8098  uni8098,  CJK UNIFIED IDEOGRAPH-8098
        0x5F3C, # G+3485  U+5F3C  uni5F3C,  CJK UNIFIED IDEOGRAPH-5F3C
        0x5FC5, # G+3486  U+5FC5  uni5FC5,  CJK UNIFIED IDEOGRAPH-5FC5
        0x7562, # G+3487  U+7562  uni7562,  CJK UNIFIED IDEOGRAPH-7562
        0x7B46, # G+3488  U+7B46  uni7B46,  CJK UNIFIED IDEOGRAPH-7B46
        0x903C, # G+3489  U+903C  uni903C,  CJK UNIFIED IDEOGRAPH-903C
        0x6867, # G+3490  U+6867  uni6867,  CJK UNIFIED IDEOGRAPH-6867
        0x59EB, # G+3491  U+59EB  uni59EB,  CJK UNIFIED IDEOGRAPH-59EB
        0x5A9B, # G+3492  U+5A9B  uni5A9B,  CJK UNIFIED IDEOGRAPH-5A9B
        0x7D10, # G+3493  U+7D10  uni7D10,  CJK UNIFIED IDEOGRAPH-7D10
        0x767E, # G+3494  U+767E  uni767E,  CJK UNIFIED IDEOGRAPH-767E
        0x8B2C, # G+3495  U+8B2C  uni8B2C,  CJK UNIFIED IDEOGRAPH-8B2C
        0x4FF5, # G+3496  U+4FF5  uni4FF5,  CJK UNIFIED IDEOGRAPH-4FF5
        0x5F6A, # G+3497  U+5F6A  uni5F6A,  CJK UNIFIED IDEOGRAPH-5F6A
        0x6A19, # G+3498  U+6A19  uni6A19,  CJK UNIFIED IDEOGRAPH-6A19
        0x6C37, # G+3499  U+6C37  uni6C37,  CJK UNIFIED IDEOGRAPH-6C37
        0x6F02, # G+3500  U+6F02  uni6F02,  CJK UNIFIED IDEOGRAPH-6F02
        0x74E2, # G+3501  U+74E2  uni74E2,  CJK UNIFIED IDEOGRAPH-74E2
        0x7968, # G+3502  U+7968  uni7968,  CJK UNIFIED IDEOGRAPH-7968
        0x8868, # G+3503  U+8868  uni8868,  CJK UNIFIED IDEOGRAPH-8868
        0x8A55, # G+3504  U+8A55  uni8A55,  CJK UNIFIED IDEOGRAPH-8A55
        0x8C79, # G+3505  U+8C79  uni8C79,  CJK UNIFIED IDEOGRAPH-8C79
        0x5EDF, # G+3506  U+5EDF  uni5EDF,  CJK UNIFIED IDEOGRAPH-5EDF
        0x63CF, # G+3507  U+63CF  uni63CF,  CJK UNIFIED IDEOGRAPH-63CF
        0x75C5, # G+3508  U+75C5  uni75C5,  CJK UNIFIED IDEOGRAPH-75C5
        0x79D2, # G+3509  U+79D2  uni79D2,  CJK UNIFIED IDEOGRAPH-79D2
        0x82D7, # G+3510  U+82D7  uni82D7,  CJK UNIFIED IDEOGRAPH-82D7
        0x9328, # G+3511  U+9328  uni9328,  CJK UNIFIED IDEOGRAPH-9328
        0x92F2, # G+3512  U+92F2  uni92F2,  CJK UNIFIED IDEOGRAPH-92F2
        0x849C, # G+3513  U+849C  uni849C,  CJK UNIFIED IDEOGRAPH-849C
        0x86ED, # G+3514  U+86ED  uni86ED,  CJK UNIFIED IDEOGRAPH-86ED
        0x9C2D, # G+3515  U+9C2D  uni9C2D,  CJK UNIFIED IDEOGRAPH-9C2D
        0x54C1, # G+3516  U+54C1  uni54C1,  CJK UNIFIED IDEOGRAPH-54C1
        0x5F6C, # G+3517  U+5F6C  uni5F6C,  CJK UNIFIED IDEOGRAPH-5F6C
        0x658C, # G+3518  U+658C  uni658C,  CJK UNIFIED IDEOGRAPH-658C
        0x6D5C, # G+3519  U+6D5C  uni6D5C,  CJK UNIFIED IDEOGRAPH-6D5C
        0x7015, # G+3520  U+7015  uni7015,  CJK UNIFIED IDEOGRAPH-7015
        0x8CA7, # G+3521  U+8CA7  uni8CA7,  CJK UNIFIED IDEOGRAPH-8CA7
        0x8CD3, # G+3522  U+8CD3  uni8CD3,  CJK UNIFIED IDEOGRAPH-8CD3
        0x983B, # G+3523  U+983B  uni983B,  CJK UNIFIED IDEOGRAPH-983B
        0x654F, # G+3524  U+654F  uni654F,  CJK UNIFIED IDEOGRAPH-654F
        0x74F6, # G+3525  U+74F6  uni74F6,  CJK UNIFIED IDEOGRAPH-74F6
        0x4E0D, # G+3526  U+4E0D  uni4E0D,  CJK UNIFIED IDEOGRAPH-4E0D
        0x4ED8, # G+3527  U+4ED8  uni4ED8,  CJK UNIFIED IDEOGRAPH-4ED8
        0x57E0, # G+3528  U+57E0  uni57E0,  CJK UNIFIED IDEOGRAPH-57E0
        0x592B, # G+3529  U+592B  uni592B,  CJK UNIFIED IDEOGRAPH-592B
        0x5A66, # G+3530  U+5A66  uni5A66,  CJK UNIFIED IDEOGRAPH-5A66
        0x5BCC, # G+3531  U+5BCC  uni5BCC,  CJK UNIFIED IDEOGRAPH-5BCC
        0x51A8, # G+3532  U+51A8  uni51A8,  CJK UNIFIED IDEOGRAPH-51A8
        0x5E03, # G+3533  U+5E03  uni5E03,  CJK UNIFIED IDEOGRAPH-5E03
        0x5E9C, # G+3534  U+5E9C  uni5E9C,  CJK UNIFIED IDEOGRAPH-5E9C
        0x6016, # G+3535  U+6016  uni6016,  CJK UNIFIED IDEOGRAPH-6016
        0x6276, # G+3536  U+6276  uni6276,  CJK UNIFIED IDEOGRAPH-6276
        0x6577, # G+3537  U+6577  uni6577,  CJK UNIFIED IDEOGRAPH-6577
        0x65A7, # G+3538  U+65A7  uni65A7,  CJK UNIFIED IDEOGRAPH-65A7
        0x666E, # G+3539  U+666E  uni666E,  CJK UNIFIED IDEOGRAPH-666E
        0x6D6E, # G+3540  U+6D6E  uni6D6E,  CJK UNIFIED IDEOGRAPH-6D6E
        0x2F57, # G+3541  U+2F57  uni2F57,  KANGXI RADICAL FATHER
        0x7B26, # G+3542  U+7B26  uni7B26,  CJK UNIFIED IDEOGRAPH-7B26
        0x8150, # G+3543  U+8150  uni8150,  CJK UNIFIED IDEOGRAPH-8150
        0x819A, # G+3544  U+819A  uni819A,  CJK UNIFIED IDEOGRAPH-819A
        0x8299, # G+3545  U+8299  uni8299,  CJK UNIFIED IDEOGRAPH-8299
        0x8B5C, # G+3546  U+8B5C  uni8B5C,  CJK UNIFIED IDEOGRAPH-8B5C
        0x8CA0, # G+3547  U+8CA0  uni8CA0,  CJK UNIFIED IDEOGRAPH-8CA0
        0x8CE6, # G+3548  U+8CE6  uni8CE6,  CJK UNIFIED IDEOGRAPH-8CE6
        0x8D74, # G+3549  U+8D74  uni8D74,  CJK UNIFIED IDEOGRAPH-8D74
        0x2FA9, # G+3550  U+2FA9  uni2FA9,  KANGXI RADICAL MOUND
        0x9644, # G+3551  U+9644  uni9644,  CJK UNIFIED IDEOGRAPH-9644
        0x4FAE, # G+3552  U+4FAE  uni4FAE,  CJK UNIFIED IDEOGRAPH-4FAE
        0x64AB, # G+3553  U+64AB  uni64AB,  CJK UNIFIED IDEOGRAPH-64AB
        0x6B66, # G+3554  U+6B66  uni6B66,  CJK UNIFIED IDEOGRAPH-6B66
        0x821E, # G+3555  U+821E  uni821E,  CJK UNIFIED IDEOGRAPH-821E
        0x8461, # G+3556  U+8461  uni8461,  CJK UNIFIED IDEOGRAPH-8461
        0x856A, # G+3557  U+856A  uni856A,  CJK UNIFIED IDEOGRAPH-856A
        0x90E8, # G+3558  U+90E8  uni90E8,  CJK UNIFIED IDEOGRAPH-90E8
        0x5C01, # G+3559  U+5C01  uni5C01,  CJK UNIFIED IDEOGRAPH-5C01
        0x6953, # G+3560  U+6953  uni6953,  CJK UNIFIED IDEOGRAPH-6953
        0x2FB5, # G+3561  U+2FB5  uni2FB5,  KANGXI RADICAL WIND
        0x847A, # G+3562  U+847A  uni847A,  CJK UNIFIED IDEOGRAPH-847A
        0x8557, # G+3563  U+8557  uni8557,  CJK UNIFIED IDEOGRAPH-8557
        0x4F0F, # G+3564  U+4F0F  uni4F0F,  CJK UNIFIED IDEOGRAPH-4F0F
        0x526F, # G+3565  U+526F  uni526F,  CJK UNIFIED IDEOGRAPH-526F
        0x5FA9, # G+3566  U+5FA9  uni5FA9,  CJK UNIFIED IDEOGRAPH-5FA9
        0x5E45, # G+3567  U+5E45  uni5E45,  CJK UNIFIED IDEOGRAPH-5E45
        0x670D, # G+3568  U+670D  uni670D,  CJK UNIFIED IDEOGRAPH-670D
        0x798F, # G+3569  U+798F  uni798F,  CJK UNIFIED IDEOGRAPH-798F
        0x8179, # G+3570  U+8179  uni8179,  CJK UNIFIED IDEOGRAPH-8179
        0x8907, # G+3571  U+8907  uni8907,  CJK UNIFIED IDEOGRAPH-8907
        0x8986, # G+3572  U+8986  uni8986,  CJK UNIFIED IDEOGRAPH-8986
        0x6DF5, # G+3573  U+6DF5  uni6DF5,  CJK UNIFIED IDEOGRAPH-6DF5
        0x5F17, # G+3574  U+5F17  uni5F17,  CJK UNIFIED IDEOGRAPH-5F17
        0x6255, # G+3575  U+6255  uni6255,  CJK UNIFIED IDEOGRAPH-6255
        0x6CB8, # G+3576  U+6CB8  uni6CB8,  CJK UNIFIED IDEOGRAPH-6CB8
        0x4ECF, # G+3577  U+4ECF  uni4ECF,  CJK UNIFIED IDEOGRAPH-4ECF
        0x7269, # G+3578  U+7269  uni7269,  CJK UNIFIED IDEOGRAPH-7269
        0x9B92, # G+3579  U+9B92  uni9B92,  CJK UNIFIED IDEOGRAPH-9B92
        0x5206, # G+3580  U+5206  uni5206,  CJK UNIFIED IDEOGRAPH-5206
        0x543B, # G+3581  U+543B  uni543B,  CJK UNIFIED IDEOGRAPH-543B
        0x5674, # G+3582  U+5674  uni5674,  CJK UNIFIED IDEOGRAPH-5674
        0x58B3, # G+3583  U+58B3  uni58B3,  CJK UNIFIED IDEOGRAPH-58B3
        0x61A4, # G+3584  U+61A4  uni61A4,  CJK UNIFIED IDEOGRAPH-61A4
        0x626E, # G+3585  U+626E  uni626E,  CJK UNIFIED IDEOGRAPH-626E
        0x711A, # G+3586  U+711A  uni711A,  CJK UNIFIED IDEOGRAPH-711A
        0x596E, # G+3587  U+596E  uni596E,  CJK UNIFIED IDEOGRAPH-596E
        0x7C89, # G+3588  U+7C89  uni7C89,  CJK UNIFIED IDEOGRAPH-7C89
        0x7CDE, # G+3589  U+7CDE  uni7CDE,  CJK UNIFIED IDEOGRAPH-7CDE
        0x7D1B, # G+3590  U+7D1B  uni7D1B,  CJK UNIFIED IDEOGRAPH-7D1B
        0x96F0, # G+3591  U+96F0  uni96F0,  CJK UNIFIED IDEOGRAPH-96F0
        0x2F42, # G+3592  U+2F42  uni2F42,  KANGXI RADICAL SCRIPT
        0x805E, # G+3593  U+805E  uni805E,  CJK UNIFIED IDEOGRAPH-805E
        0x4E19, # G+3594  U+4E19  uni4E19,  CJK UNIFIED IDEOGRAPH-4E19
        0x4F75, # G+3595  U+4F75  uni4F75,  CJK UNIFIED IDEOGRAPH-4F75
        0x5175, # G+3596  U+5175  uni5175,  CJK UNIFIED IDEOGRAPH-5175
        0x5840, # G+3597  U+5840  uni5840,  CJK UNIFIED IDEOGRAPH-5840
        0x5E63, # G+3598  U+5E63  uni5E63,  CJK UNIFIED IDEOGRAPH-5E63
        0x5E73, # G+3599  U+5E73  uni5E73,  CJK UNIFIED IDEOGRAPH-5E73
        0x5F0A, # G+3600  U+5F0A  uni5F0A,  CJK UNIFIED IDEOGRAPH-5F0A
        0x67C4, # G+3601  U+67C4  uni67C4,  CJK UNIFIED IDEOGRAPH-67C4
        0x4E26, # G+3602  U+4E26  uni4E26,  CJK UNIFIED IDEOGRAPH-4E26
        0x853D, # G+3603  U+853D  uni853D,  CJK UNIFIED IDEOGRAPH-853D
        0x9589, # G+3604  U+9589  uni9589,  CJK UNIFIED IDEOGRAPH-9589
        0x965B, # G+3605  U+965B  uni965B,  CJK UNIFIED IDEOGRAPH-965B
        0x2F76, # G+3606  U+2F76  uni2F76,  KANGXI RADICAL RICE
        0x2FB4, # G+3607  U+2FB4  uni2FB4,  KANGXI RADICAL LEAF
        0x50FB, # G+3608  U+50FB  uni50FB,  CJK UNIFIED IDEOGRAPH-50FB
        0x58C1, # G+3609  U+58C1  uni58C1,  CJK UNIFIED IDEOGRAPH-58C1
        0x7656, # G+3610  U+7656  uni7656,  CJK UNIFIED IDEOGRAPH-7656
        0x78A7, # G+3611  U+78A7  uni78A7,  CJK UNIFIED IDEOGRAPH-78A7
        0x5225, # G+3612  U+5225  uni5225,  CJK UNIFIED IDEOGRAPH-5225
        0x77A5, # G+3613  U+77A5  uni77A5,  CJK UNIFIED IDEOGRAPH-77A5
        0x8511, # G+3614  U+8511  uni8511,  CJK UNIFIED IDEOGRAPH-8511
        0x7B86, # G+3615  U+7B86  uni7B86,  CJK UNIFIED IDEOGRAPH-7B86
        0x504F, # G+3616  U+504F  uni504F,  CJK UNIFIED IDEOGRAPH-504F
        0x5909, # G+3617  U+5909  uni5909,  CJK UNIFIED IDEOGRAPH-5909
        0x2F5A, # G+3618  U+2F5A  uni2F5A,  KANGXI RADICAL SLICE
        0x7BC7, # G+3619  U+7BC7  uni7BC7,  CJK UNIFIED IDEOGRAPH-7BC7
        0x7DE8, # G+3620  U+7DE8  uni7DE8,  CJK UNIFIED IDEOGRAPH-7DE8
        0x8FBA, # G+3621  U+8FBA  uni8FBA,  CJK UNIFIED IDEOGRAPH-8FBA
        0x8FD4, # G+3622  U+8FD4  uni8FD4,  CJK UNIFIED IDEOGRAPH-8FD4
        0x904D, # G+3623  U+904D  uni904D,  CJK UNIFIED IDEOGRAPH-904D
        0x4FBF, # G+3624  U+4FBF  uni4FBF,  CJK UNIFIED IDEOGRAPH-4FBF
        0x52C9, # G+3625  U+52C9  uni52C9,  CJK UNIFIED IDEOGRAPH-52C9
        0x5A29, # G+3626  U+5A29  uni5A29,  CJK UNIFIED IDEOGRAPH-5A29
        0x5F01, # G+3627  U+5F01  uni5F01,  CJK UNIFIED IDEOGRAPH-5F01
        0x97AD, # G+3628  U+97AD  uni97AD,  CJK UNIFIED IDEOGRAPH-97AD
        0x4FDD, # G+3629  U+4FDD  uni4FDD,  CJK UNIFIED IDEOGRAPH-4FDD
        0x8217, # G+3630  U+8217  uni8217,  CJK UNIFIED IDEOGRAPH-8217
        0x92EA, # G+3631  U+92EA  uni92EA,  CJK UNIFIED IDEOGRAPH-92EA
        0x5703, # G+3632  U+5703  uni5703,  CJK UNIFIED IDEOGRAPH-5703
        0x6355, # G+3633  U+6355  uni6355,  CJK UNIFIED IDEOGRAPH-6355
        0x6B69, # G+3634  U+6B69  uni6B69,  CJK UNIFIED IDEOGRAPH-6B69
        0x752B, # G+3635  U+752B  uni752B,  CJK UNIFIED IDEOGRAPH-752B
        0x88DC, # G+3636  U+88DC  uni88DC,  CJK UNIFIED IDEOGRAPH-88DC
        0x8F14, # G+3637  U+8F14  uni8F14,  CJK UNIFIED IDEOGRAPH-8F14
        0x7A42, # G+3638  U+7A42  uni7A42,  CJK UNIFIED IDEOGRAPH-7A42
        0x52DF, # G+3639  U+52DF  uni52DF,  CJK UNIFIED IDEOGRAPH-52DF
        0x5893, # G+3640  U+5893  uni5893,  CJK UNIFIED IDEOGRAPH-5893
        0x6155, # G+3641  U+6155  uni6155,  CJK UNIFIED IDEOGRAPH-6155
        0x620A, # G+3642  U+620A  uni620A,  CJK UNIFIED IDEOGRAPH-620A
        0x66AE, # G+3643  U+66AE  uni66AE,  CJK UNIFIED IDEOGRAPH-66AE
        0x2E9F, # G+3644  U+2E9F  uni2E9F,  CJK RADICAL MOTHER
        0x7C3F, # G+3645  U+7C3F  uni7C3F,  CJK UNIFIED IDEOGRAPH-7C3F
        0x83E9, # G+3646  U+83E9  uni83E9,  CJK UNIFIED IDEOGRAPH-83E9
        0x5023, # G+3647  U+5023  uni5023,  CJK UNIFIED IDEOGRAPH-5023
        0x4FF8, # G+3648  U+4FF8  uni4FF8,  CJK UNIFIED IDEOGRAPH-4FF8
        0x5305, # G+3649  U+5305  uni5305,  CJK UNIFIED IDEOGRAPH-5305
        0x5446, # G+3650  U+5446  uni5446,  CJK UNIFIED IDEOGRAPH-5446
        0x5831, # G+3651  U+5831  uni5831,  CJK UNIFIED IDEOGRAPH-5831
        0x5949, # G+3652  U+5949  uni5949,  CJK UNIFIED IDEOGRAPH-5949
        0x5B9D, # G+3653  U+5B9D  uni5B9D,  CJK UNIFIED IDEOGRAPH-5B9D
        0x5CF0, # G+3654  U+5CF0  uni5CF0,  CJK UNIFIED IDEOGRAPH-5CF0
        0x5CEF, # G+3655  U+5CEF  uni5CEF,  CJK UNIFIED IDEOGRAPH-5CEF
        0x5D29, # G+3656  U+5D29  uni5D29,  CJK UNIFIED IDEOGRAPH-5D29
        0x5E96, # G+3657  U+5E96  uni5E96,  CJK UNIFIED IDEOGRAPH-5E96
        0x62B1, # G+3658  U+62B1  uni62B1,  CJK UNIFIED IDEOGRAPH-62B1
        0x6367, # G+3659  U+6367  uni6367,  CJK UNIFIED IDEOGRAPH-6367
        0x653E, # G+3660  U+653E  uni653E,  CJK UNIFIED IDEOGRAPH-653E
        0x2F45, # G+3661  U+2F45  uni2F45,  KANGXI RADICAL SQUARE
        0x670B, # G+3662  U+670B  uni670B,  CJK UNIFIED IDEOGRAPH-670B
        0x6CD5, # G+3663  U+6CD5  uni6CD5,  CJK UNIFIED IDEOGRAPH-6CD5
        0x6CE1, # G+3664  U+6CE1  uni6CE1,  CJK UNIFIED IDEOGRAPH-6CE1
        0x70F9, # G+3665  U+70F9  uni70F9,  CJK UNIFIED IDEOGRAPH-70F9
        0x7832, # G+3666  U+7832  uni7832,  CJK UNIFIED IDEOGRAPH-7832
        0x7E2B, # G+3667  U+7E2B  uni7E2B,  CJK UNIFIED IDEOGRAPH-7E2B
        0x80DE, # G+3668  U+80DE  uni80DE,  CJK UNIFIED IDEOGRAPH-80DE
        0x82B3, # G+3669  U+82B3  uni82B3,  CJK UNIFIED IDEOGRAPH-82B3
        0x840C, # G+3670  U+840C  uni840C,  CJK UNIFIED IDEOGRAPH-840C
        0x84EC, # G+3671  U+84EC  uni84EC,  CJK UNIFIED IDEOGRAPH-84EC
        0x8702, # G+3672  U+8702  uni8702,  CJK UNIFIED IDEOGRAPH-8702
        0x8912, # G+3673  U+8912  uni8912,  CJK UNIFIED IDEOGRAPH-8912
        0x8A2A, # G+3674  U+8A2A  uni8A2A,  CJK UNIFIED IDEOGRAPH-8A2A
        0x8C4A, # G+3675  U+8C4A  uni8C4A,  CJK UNIFIED IDEOGRAPH-8C4A
        0x90A6, # G+3676  U+90A6  uni90A6,  CJK UNIFIED IDEOGRAPH-90A6
        0x92D2, # G+3677  U+92D2  uni92D2,  CJK UNIFIED IDEOGRAPH-92D2
        0x98FD, # G+3678  U+98FD  uni98FD,  CJK UNIFIED IDEOGRAPH-98FD
        0x9CF3, # G+3679  U+9CF3  uni9CF3,  CJK UNIFIED IDEOGRAPH-9CF3
        0x9D6C, # G+3680  U+9D6C  uni9D6C,  CJK UNIFIED IDEOGRAPH-9D6C
        0x4E4F, # G+3681  U+4E4F  uni4E4F,  CJK UNIFIED IDEOGRAPH-4E4F
        0x4EA1, # G+3682  U+4EA1  uni4EA1,  CJK UNIFIED IDEOGRAPH-4EA1
        0x508D, # G+3683  U+508D  uni508D,  CJK UNIFIED IDEOGRAPH-508D
        0x5256, # G+3684  U+5256  uni5256,  CJK UNIFIED IDEOGRAPH-5256
        0x574A, # G+3685  U+574A  uni574A,  CJK UNIFIED IDEOGRAPH-574A
        0x59A8, # G+3686  U+59A8  uni59A8,  CJK UNIFIED IDEOGRAPH-59A8
        0x5E3D, # G+3687  U+5E3D  uni5E3D,  CJK UNIFIED IDEOGRAPH-5E3D
        0x5FD8, # G+3688  U+5FD8  uni5FD8,  CJK UNIFIED IDEOGRAPH-5FD8
        0x5FD9, # G+3689  U+5FD9  uni5FD9,  CJK UNIFIED IDEOGRAPH-5FD9
        0x623F, # G+3690  U+623F  uni623F,  CJK UNIFIED IDEOGRAPH-623F
        0x66B4, # G+3691  U+66B4  uni66B4,  CJK UNIFIED IDEOGRAPH-66B4
        0x671B, # G+3692  U+671B  uni671B,  CJK UNIFIED IDEOGRAPH-671B
        0x67D0, # G+3693  U+67D0  uni67D0,  CJK UNIFIED IDEOGRAPH-67D0
        0x68D2, # G+3694  U+68D2  uni68D2,  CJK UNIFIED IDEOGRAPH-68D2
        0x5192, # G+3695  U+5192  uni5192,  CJK UNIFIED IDEOGRAPH-5192
        0x7D21, # G+3696  U+7D21  uni7D21,  CJK UNIFIED IDEOGRAPH-7D21
        0x80AA, # G+3697  U+80AA  uni80AA,  CJK UNIFIED IDEOGRAPH-80AA
        0x81A8, # G+3698  U+81A8  uni81A8,  CJK UNIFIED IDEOGRAPH-81A8
        0x8B00, # G+3699  U+8B00  uni8B00,  CJK UNIFIED IDEOGRAPH-8B00
        0x8C8C, # G+3700  U+8C8C  uni8C8C,  CJK UNIFIED IDEOGRAPH-8C8C
        0x8CBF, # G+3701  U+8CBF  uni8CBF,  CJK UNIFIED IDEOGRAPH-8CBF
        0x927E, # G+3702  U+927E  uni927E,  CJK UNIFIED IDEOGRAPH-927E
        0x9632, # G+3703  U+9632  uni9632,  CJK UNIFIED IDEOGRAPH-9632
        0x5420, # G+3704  U+5420  uni5420,  CJK UNIFIED IDEOGRAPH-5420
        0x982C, # G+3705  U+982C  uni982C,  CJK UNIFIED IDEOGRAPH-982C
        0x5317, # G+3706  U+5317  uni5317,  CJK UNIFIED IDEOGRAPH-5317
        0x50D5, # G+3707  U+50D5  uni50D5,  CJK UNIFIED IDEOGRAPH-50D5
        0x2F18, # G+3708  U+2F18  uni2F18,  KANGXI RADICAL DIVINATION
        0x58A8, # G+3709  U+58A8  uni58A8,  CJK UNIFIED IDEOGRAPH-58A8
        0x64B2, # G+3710  U+64B2  uni64B2,  CJK UNIFIED IDEOGRAPH-64B2
        0x6734, # G+3711  U+6734  uni6734,  CJK UNIFIED IDEOGRAPH-6734
        0x7267, # G+3712  U+7267  uni7267,  CJK UNIFIED IDEOGRAPH-7267
        0x7766, # G+3713  U+7766  uni7766,  CJK UNIFIED IDEOGRAPH-7766
        0x7A46, # G+3714  U+7A46  uni7A46,  CJK UNIFIED IDEOGRAPH-7A46
        0x91E6, # G+3715  U+91E6  uni91E6,  CJK UNIFIED IDEOGRAPH-91E6
        0x52C3, # G+3716  U+52C3  uni52C3,  CJK UNIFIED IDEOGRAPH-52C3
        0x6CA1, # G+3717  U+6CA1  uni6CA1,  CJK UNIFIED IDEOGRAPH-6CA1
        0x6B86, # G+3718  U+6B86  uni6B86,  CJK UNIFIED IDEOGRAPH-6B86
        0x5800, # G+3719  U+5800  uni5800,  CJK UNIFIED IDEOGRAPH-5800
        0x5E4C, # G+3720  U+5E4C  uni5E4C,  CJK UNIFIED IDEOGRAPH-5E4C
        0x5954, # G+3721  U+5954  uni5954,  CJK UNIFIED IDEOGRAPH-5954
        0x672C, # G+3722  U+672C  uni672C,  CJK UNIFIED IDEOGRAPH-672C
        0x7FFB, # G+3723  U+7FFB  uni7FFB,  CJK UNIFIED IDEOGRAPH-7FFB
        0x51E1, # G+3724  U+51E1  uni51E1,  CJK UNIFIED IDEOGRAPH-51E1
        0x76C6, # G+3725  U+76C6  uni76C6,  CJK UNIFIED IDEOGRAPH-76C6
        0x6469, # G+3726  U+6469  uni6469,  CJK UNIFIED IDEOGRAPH-6469
        0x78E8, # G+3727  U+78E8  uni78E8,  CJK UNIFIED IDEOGRAPH-78E8
        0x9B54, # G+3728  U+9B54  uni9B54,  CJK UNIFIED IDEOGRAPH-9B54
        0x2FC7, # G+3729  U+2FC7  uni2FC7,  KANGXI RADICAL HEMP
        0x57CB, # G+3730  U+57CB  uni57CB,  CJK UNIFIED IDEOGRAPH-57CB
        0x59B9, # G+3731  U+59B9  uni59B9,  CJK UNIFIED IDEOGRAPH-59B9
        0x6627, # G+3732  U+6627  uni6627,  CJK UNIFIED IDEOGRAPH-6627
        0x679A, # G+3733  U+679A  uni679A,  CJK UNIFIED IDEOGRAPH-679A
        0x6BCE, # G+3734  U+6BCE  uni6BCE,  CJK UNIFIED IDEOGRAPH-6BCE
        0x54E9, # G+3735  U+54E9  uni54E9,  CJK UNIFIED IDEOGRAPH-54E9
        0x69D9, # G+3736  U+69D9  uni69D9,  CJK UNIFIED IDEOGRAPH-69D9
        0x5E55, # G+3737  U+5E55  uni5E55,  CJK UNIFIED IDEOGRAPH-5E55
        0x819C, # G+3738  U+819C  uni819C,  CJK UNIFIED IDEOGRAPH-819C
        0x6795, # G+3739  U+6795  uni6795,  CJK UNIFIED IDEOGRAPH-6795
        0x9BAA, # G+3740  U+9BAA  uni9BAA,  CJK UNIFIED IDEOGRAPH-9BAA
        0x67FE, # G+3741  U+67FE  uni67FE,  CJK UNIFIED IDEOGRAPH-67FE
        0x9C52, # G+3742  U+9C52  uni9C52,  CJK UNIFIED IDEOGRAPH-9C52
        0x685D, # G+3743  U+685D  uni685D,  CJK UNIFIED IDEOGRAPH-685D
        0x4EA6, # G+3744  U+4EA6  uni4EA6,  CJK UNIFIED IDEOGRAPH-4EA6
        0x4FE3, # G+3745  U+4FE3  uni4FE3,  CJK UNIFIED IDEOGRAPH-4FE3
        0x2F1C, # G+3746  U+2F1C  uni2F1C,  KANGXI RADICAL AGAIN
        0x62B9, # G+3747  U+62B9  uni62B9,  CJK UNIFIED IDEOGRAPH-62B9
        0x672B, # G+3748  U+672B  uni672B,  CJK UNIFIED IDEOGRAPH-672B
        0x6CAB, # G+3749  U+6CAB  uni6CAB,  CJK UNIFIED IDEOGRAPH-6CAB
        0x8FC4, # G+3750  U+8FC4  uni8FC4,  CJK UNIFIED IDEOGRAPH-8FC4
        0x4FAD, # G+3751  U+4FAD  uni4FAD,  CJK UNIFIED IDEOGRAPH-4FAD
        0x7E6D, # G+3752  U+7E6D  uni7E6D,  CJK UNIFIED IDEOGRAPH-7E6D
        0x9EBF, # G+3753  U+9EBF  uni9EBF,  CJK UNIFIED IDEOGRAPH-9EBF
        0x4E07, # G+3754  U+4E07  uni4E07,  CJK UNIFIED IDEOGRAPH-4E07
        0x6162, # G+3755  U+6162  uni6162,  CJK UNIFIED IDEOGRAPH-6162
        0x6E80, # G+3756  U+6E80  uni6E80,  CJK UNIFIED IDEOGRAPH-6E80
        0x6F2B, # G+3757  U+6F2B  uni6F2B,  CJK UNIFIED IDEOGRAPH-6F2B
        0x8513, # G+3758  U+8513  uni8513,  CJK UNIFIED IDEOGRAPH-8513
        0x5473, # G+3759  U+5473  uni5473,  CJK UNIFIED IDEOGRAPH-5473
        0x672A, # G+3760  U+672A  uni672A,  CJK UNIFIED IDEOGRAPH-672A
        0x9B45, # G+3761  U+9B45  uni9B45,  CJK UNIFIED IDEOGRAPH-9B45
        0x2E92, # G+3762  U+2E92  uni2E92,  CJK RADICAL SNAKE
        0x7B95, # G+3763  U+7B95  uni7B95,  CJK UNIFIED IDEOGRAPH-7B95
        0x5CAC, # G+3764  U+5CAC  uni5CAC,  CJK UNIFIED IDEOGRAPH-5CAC
        0x5BC6, # G+3765  U+5BC6  uni5BC6,  CJK UNIFIED IDEOGRAPH-5BC6
        0x871C, # G+3766  U+871C  uni871C,  CJK UNIFIED IDEOGRAPH-871C
        0x6E4A, # G+3767  U+6E4A  uni6E4A,  CJK UNIFIED IDEOGRAPH-6E4A
        0x84D1, # G+3768  U+84D1  uni84D1,  CJK UNIFIED IDEOGRAPH-84D1
        0x7A14, # G+3769  U+7A14  uni7A14,  CJK UNIFIED IDEOGRAPH-7A14
        0x8108, # G+3770  U+8108  uni8108,  CJK UNIFIED IDEOGRAPH-8108
        0x5999, # G+3771  U+5999  uni5999,  CJK UNIFIED IDEOGRAPH-5999
        0x7C8D, # G+3772  U+7C8D  uni7C8D,  CJK UNIFIED IDEOGRAPH-7C8D
        0x2EA0, # G+3773  U+2EA0  uni2EA0,  CJK RADICAL CIVILIAN
        0x7720, # G+3774  U+7720  uni7720,  CJK UNIFIED IDEOGRAPH-7720
        0x52D9, # G+3775  U+52D9  uni52D9,  CJK UNIFIED IDEOGRAPH-52D9
        0x5922, # G+3776  U+5922  uni5922,  CJK UNIFIED IDEOGRAPH-5922
        0x7121, # G+3777  U+7121  uni7121,  CJK UNIFIED IDEOGRAPH-7121
        0x725F, # G+3778  U+725F  uni725F,  CJK UNIFIED IDEOGRAPH-725F
        0x2F6D, # G+3779  U+2F6D  uni2F6D,  KANGXI RADICAL SPEAR
        0x9727, # G+3780  U+9727  uni9727,  CJK UNIFIED IDEOGRAPH-9727
        0x9D61, # G+3781  U+9D61  uni9D61,  CJK UNIFIED IDEOGRAPH-9D61
        0x690B, # G+3782  U+690B  uni690B,  CJK UNIFIED IDEOGRAPH-690B
        0x5A7F, # G+3783  U+5A7F  uni5A7F,  CJK UNIFIED IDEOGRAPH-5A7F
        0x5A18, # G+3784  U+5A18  uni5A18,  CJK UNIFIED IDEOGRAPH-5A18
        0x51A5, # G+3785  U+51A5  uni51A5,  CJK UNIFIED IDEOGRAPH-51A5
        0x540D, # G+3786  U+540D  uni540D,  CJK UNIFIED IDEOGRAPH-540D
        0x547D, # G+3787  U+547D  uni547D,  CJK UNIFIED IDEOGRAPH-547D
        0x660E, # G+3788  U+660E  uni660E,  CJK UNIFIED IDEOGRAPH-660E
        0x76DF, # G+3789  U+76DF  uni76DF,  CJK UNIFIED IDEOGRAPH-76DF
        0x8FF7, # G+3790  U+8FF7  uni8FF7,  CJK UNIFIED IDEOGRAPH-8FF7
        0x9298, # G+3791  U+9298  uni9298,  CJK UNIFIED IDEOGRAPH-9298
        0x9CF4, # G+3792  U+9CF4  uni9CF4,  CJK UNIFIED IDEOGRAPH-9CF4
        0x59EA, # G+3793  U+59EA  uni59EA,  CJK UNIFIED IDEOGRAPH-59EA
        0x725D, # G+3794  U+725D  uni725D,  CJK UNIFIED IDEOGRAPH-725D
        0x6EC5, # G+3795  U+6EC5  uni6EC5,  CJK UNIFIED IDEOGRAPH-6EC5
        0x514D, # G+3796  U+514D  uni514D,  CJK UNIFIED IDEOGRAPH-514D
        0x68C9, # G+3797  U+68C9  uni68C9,  CJK UNIFIED IDEOGRAPH-68C9
        0x7DBF, # G+3798  U+7DBF  uni7DBF,  CJK UNIFIED IDEOGRAPH-7DBF
        0x7DEC, # G+3799  U+7DEC  uni7DEC,  CJK UNIFIED IDEOGRAPH-7DEC
        0x2FAF, # G+3800  U+2FAF  uni2FAF,  KANGXI RADICAL FACE
        0x9EBA, # G+3801  U+9EBA  uni9EBA,  CJK UNIFIED IDEOGRAPH-9EBA
        0x6478, # G+3802  U+6478  uni6478,  CJK UNIFIED IDEOGRAPH-6478
        0x6A21, # G+3803  U+6A21  uni6A21,  CJK UNIFIED IDEOGRAPH-6A21
        0x8302, # G+3804  U+8302  uni8302,  CJK UNIFIED IDEOGRAPH-8302
        0x5984, # G+3805  U+5984  uni5984,  CJK UNIFIED IDEOGRAPH-5984
        0x5B5F, # G+3806  U+5B5F  uni5B5F,  CJK UNIFIED IDEOGRAPH-5B5F
        0x2F51, # G+3807  U+2F51  uni2F51,  KANGXI RADICAL FUR
        0x731B, # G+3808  U+731B  uni731B,  CJK UNIFIED IDEOGRAPH-731B
        0x76F2, # G+3809  U+76F2  uni76F2,  CJK UNIFIED IDEOGRAPH-76F2
        0x7DB2, # G+3810  U+7DB2  uni7DB2,  CJK UNIFIED IDEOGRAPH-7DB2
        0x8017, # G+3811  U+8017  uni8017,  CJK UNIFIED IDEOGRAPH-8017
        0x8499, # G+3812  U+8499  uni8499,  CJK UNIFIED IDEOGRAPH-8499
        0x5132, # G+3813  U+5132  uni5132,  CJK UNIFIED IDEOGRAPH-5132
        0x2F4A, # G+3814  U+2F4A  uni2F4A,  KANGXI RADICAL TREE
        0x9ED9, # G+3815  U+9ED9  uni9ED9,  CJK UNIFIED IDEOGRAPH-9ED9
        0x2F6C, # G+3816  U+2F6C  uni2F6C,  KANGXI RADICAL EYE
        0x6762, # G+3817  U+6762  uni6762,  CJK UNIFIED IDEOGRAPH-6762
        0x52FF, # G+3818  U+52FF  uni52FF,  CJK UNIFIED IDEOGRAPH-52FF
        0x9905, # G+3819  U+9905  uni9905,  CJK UNIFIED IDEOGRAPH-9905
        0x5C24, # G+3820  U+5C24  uni5C24,  CJK UNIFIED IDEOGRAPH-5C24
        0x623B, # G+3821  U+623B  uni623B,  CJK UNIFIED IDEOGRAPH-623B
        0x7C7E, # G+3822  U+7C7E  uni7C7E,  CJK UNIFIED IDEOGRAPH-7C7E
        0x8CB0, # G+3823  U+8CB0  uni8CB0,  CJK UNIFIED IDEOGRAPH-8CB0
        0x554F, # G+3824  U+554F  uni554F,  CJK UNIFIED IDEOGRAPH-554F
        0x60B6, # G+3825  U+60B6  uni60B6,  CJK UNIFIED IDEOGRAPH-60B6
        0x7D0B, # G+3826  U+7D0B  uni7D0B,  CJK UNIFIED IDEOGRAPH-7D0B
        0x2FA8, # G+3827  U+2FA8  uni2FA8,  KANGXI RADICAL GATE
        0x5301, # G+3828  U+5301  uni5301,  CJK UNIFIED IDEOGRAPH-5301
        0x4E5F, # G+3829  U+4E5F  uni4E5F,  CJK UNIFIED IDEOGRAPH-4E5F
        0x51B6, # G+3830  U+51B6  uni51B6,  CJK UNIFIED IDEOGRAPH-51B6
        0x591C, # G+3831  U+591C  uni591C,  CJK UNIFIED IDEOGRAPH-591C
        0x723A, # G+3832  U+723A  uni723A,  CJK UNIFIED IDEOGRAPH-723A
        0x8036, # G+3833  U+8036  uni8036,  CJK UNIFIED IDEOGRAPH-8036
        0x91CE, # G+3834  U+91CE  uni91CE,  CJK UNIFIED IDEOGRAPH-91CE
        0x5F25, # G+3835  U+5F25  uni5F25,  CJK UNIFIED IDEOGRAPH-5F25
        0x2F6E, # G+3836  U+2F6E  uni2F6E,  KANGXI RADICAL ARROW
        0x5384, # G+3837  U+5384  uni5384,  CJK UNIFIED IDEOGRAPH-5384
        0x5F79, # G+3838  U+5F79  uni5F79,  CJK UNIFIED IDEOGRAPH-5F79
        0x7D04, # G+3839  U+7D04  uni7D04,  CJK UNIFIED IDEOGRAPH-7D04
        0x85AC, # G+3840  U+85AC  uni85AC,  CJK UNIFIED IDEOGRAPH-85AC
        0x8A33, # G+3841  U+8A33  uni8A33,  CJK UNIFIED IDEOGRAPH-8A33
        0x8E8D, # G+3842  U+8E8D  uni8E8D,  CJK UNIFIED IDEOGRAPH-8E8D
        0x9756, # G+3843  U+9756  uni9756,  CJK UNIFIED IDEOGRAPH-9756
        0x67F3, # G+3844  U+67F3  uni67F3,  CJK UNIFIED IDEOGRAPH-67F3
        0x85AE, # G+3845  U+85AE  uni85AE,  CJK UNIFIED IDEOGRAPH-85AE
        0x9453, # G+3846  U+9453  uni9453,  CJK UNIFIED IDEOGRAPH-9453
        0x6109, # G+3847  U+6109  uni6109,  CJK UNIFIED IDEOGRAPH-6109
        0x6108, # G+3848  U+6108  uni6108,  CJK UNIFIED IDEOGRAPH-6108
        0x6CB9, # G+3849  U+6CB9  uni6CB9,  CJK UNIFIED IDEOGRAPH-6CB9
        0x7652, # G+3850  U+7652  uni7652,  CJK UNIFIED IDEOGRAPH-7652
        0x8AED, # G+3851  U+8AED  uni8AED,  CJK UNIFIED IDEOGRAPH-8AED
        0x8F38, # G+3852  U+8F38  uni8F38,  CJK UNIFIED IDEOGRAPH-8F38
        0x552F, # G+3853  U+552F  uni552F,  CJK UNIFIED IDEOGRAPH-552F
        0x4F51, # G+3854  U+4F51  uni4F51,  CJK UNIFIED IDEOGRAPH-4F51
        0x512A, # G+3855  U+512A  uni512A,  CJK UNIFIED IDEOGRAPH-512A
        0x52C7, # G+3856  U+52C7  uni52C7,  CJK UNIFIED IDEOGRAPH-52C7
        0x53CB, # G+3857  U+53CB  uni53CB,  CJK UNIFIED IDEOGRAPH-53CB
        0x5BA5, # G+3858  U+5BA5  uni5BA5,  CJK UNIFIED IDEOGRAPH-5BA5
        0x5E7D, # G+3859  U+5E7D  uni5E7D,  CJK UNIFIED IDEOGRAPH-5E7D
        0x60A0, # G+3860  U+60A0  uni60A0,  CJK UNIFIED IDEOGRAPH-60A0
        0x6182, # G+3861  U+6182  uni6182,  CJK UNIFIED IDEOGRAPH-6182
        0x63D6, # G+3862  U+63D6  uni63D6,  CJK UNIFIED IDEOGRAPH-63D6
        0x6709, # G+3863  U+6709  uni6709,  CJK UNIFIED IDEOGRAPH-6709
        0x67DA, # G+3864  U+67DA  uni67DA,  CJK UNIFIED IDEOGRAPH-67DA
        0x6E67, # G+3865  U+6E67  uni6E67,  CJK UNIFIED IDEOGRAPH-6E67
        0x6D8C, # G+3866  U+6D8C  uni6D8C,  CJK UNIFIED IDEOGRAPH-6D8C
        0x7336, # G+3867  U+7336  uni7336,  CJK UNIFIED IDEOGRAPH-7336
        0x7337, # G+3868  U+7337  uni7337,  CJK UNIFIED IDEOGRAPH-7337
        0x7531, # G+3869  U+7531  uni7531,  CJK UNIFIED IDEOGRAPH-7531
        0x7950, # G+3870  U+7950  uni7950,  CJK UNIFIED IDEOGRAPH-7950
        0x88D5, # G+3871  U+88D5  uni88D5,  CJK UNIFIED IDEOGRAPH-88D5
        0x8A98, # G+3872  U+8A98  uni8A98,  CJK UNIFIED IDEOGRAPH-8A98
        0x904A, # G+3873  U+904A  uni904A,  CJK UNIFIED IDEOGRAPH-904A
        0x2FA2, # G+3874  U+2FA2  uni2FA2,  KANGXI RADICAL CITY
        0x90F5, # G+3875  U+90F5  uni90F5,  CJK UNIFIED IDEOGRAPH-90F5
        0x96C4, # G+3876  U+96C4  uni96C4,  CJK UNIFIED IDEOGRAPH-96C4
        0x878D, # G+3877  U+878D  uni878D,  CJK UNIFIED IDEOGRAPH-878D
        0x2F23, # G+3878  U+2F23  uni2F23,  KANGXI RADICAL EVENING
        0x4E88, # G+3879  U+4E88  uni4E88,  CJK UNIFIED IDEOGRAPH-4E88
        0x4F59, # G+3880  U+4F59  uni4F59,  CJK UNIFIED IDEOGRAPH-4F59
        0x4E0E, # G+3881  U+4E0E  uni4E0E,  CJK UNIFIED IDEOGRAPH-4E0E
        0x8A89, # G+3882  U+8A89  uni8A89,  CJK UNIFIED IDEOGRAPH-8A89
        0x8F3F, # G+3883  U+8F3F  uni8F3F,  CJK UNIFIED IDEOGRAPH-8F3F
        0x9810, # G+3884  U+9810  uni9810,  CJK UNIFIED IDEOGRAPH-9810
        0x50AD, # G+3885  U+50AD  uni50AD,  CJK UNIFIED IDEOGRAPH-50AD
        0x5E7C, # G+3886  U+5E7C  uni5E7C,  CJK UNIFIED IDEOGRAPH-5E7C
        0x5996, # G+3887  U+5996  uni5996,  CJK UNIFIED IDEOGRAPH-5996
        0x5BB9, # G+3888  U+5BB9  uni5BB9,  CJK UNIFIED IDEOGRAPH-5BB9
        0x5EB8, # G+3889  U+5EB8  uni5EB8,  CJK UNIFIED IDEOGRAPH-5EB8
        0x63DA, # G+3890  U+63DA  uni63DA,  CJK UNIFIED IDEOGRAPH-63DA
        0x63FA, # G+3891  U+63FA  uni63FA,  CJK UNIFIED IDEOGRAPH-63FA
        0x64C1, # G+3892  U+64C1  uni64C1,  CJK UNIFIED IDEOGRAPH-64C1
        0x66DC, # G+3893  U+66DC  uni66DC,  CJK UNIFIED IDEOGRAPH-66DC
        0x694A, # G+3894  U+694A  uni694A,  CJK UNIFIED IDEOGRAPH-694A
        0x69D8, # G+3895  U+69D8  uni69D8,  CJK UNIFIED IDEOGRAPH-69D8
        0x6D0B, # G+3896  U+6D0B  uni6D0B,  CJK UNIFIED IDEOGRAPH-6D0B
        0x6EB6, # G+3897  U+6EB6  uni6EB6,  CJK UNIFIED IDEOGRAPH-6EB6
        0x7194, # G+3898  U+7194  uni7194,  CJK UNIFIED IDEOGRAPH-7194
        0x2F64, # G+3899  U+2F64  uni2F64,  KANGXI RADICAL USE
        0x7AAF, # G+3900  U+7AAF  uni7AAF,  CJK UNIFIED IDEOGRAPH-7AAF
        0x2F7A, # G+3901  U+2F7A  uni2F7A,  KANGXI RADICAL SHEEP
        0x8000, # G+3902  U+8000  uni8000,  CJK UNIFIED IDEOGRAPH-8000
        0x8449, # G+3903  U+8449  uni8449,  CJK UNIFIED IDEOGRAPH-8449
        0x84C9, # G+3904  U+84C9  uni84C9,  CJK UNIFIED IDEOGRAPH-84C9
        0x8981, # G+3905  U+8981  uni8981,  CJK UNIFIED IDEOGRAPH-8981
        0x8B21, # G+3906  U+8B21  uni8B21,  CJK UNIFIED IDEOGRAPH-8B21
        0x8E0A, # G+3907  U+8E0A  uni8E0A,  CJK UNIFIED IDEOGRAPH-8E0A
        0x9065, # G+3908  U+9065  uni9065,  CJK UNIFIED IDEOGRAPH-9065
        0x967D, # G+3909  U+967D  uni967D,  CJK UNIFIED IDEOGRAPH-967D
        0x990A, # G+3910  U+990A  uni990A,  CJK UNIFIED IDEOGRAPH-990A
        0x617E, # G+3911  U+617E  uni617E,  CJK UNIFIED IDEOGRAPH-617E
        0x6291, # G+3912  U+6291  uni6291,  CJK UNIFIED IDEOGRAPH-6291
        0x6B32, # G+3913  U+6B32  uni6B32,  CJK UNIFIED IDEOGRAPH-6B32
        0x6C83, # G+3914  U+6C83  uni6C83,  CJK UNIFIED IDEOGRAPH-6C83
        0x6D74, # G+3915  U+6D74  uni6D74,  CJK UNIFIED IDEOGRAPH-6D74
        0x7FCC, # G+3916  U+7FCC  uni7FCC,  CJK UNIFIED IDEOGRAPH-7FCC
        0x7FFC, # G+3917  U+7FFC  uni7FFC,  CJK UNIFIED IDEOGRAPH-7FFC
        0x6DC0, # G+3918  U+6DC0  uni6DC0,  CJK UNIFIED IDEOGRAPH-6DC0
        0x7F85, # G+3919  U+7F85  uni7F85,  CJK UNIFIED IDEOGRAPH-7F85
        0x87BA, # G+3920  U+87BA  uni87BA,  CJK UNIFIED IDEOGRAPH-87BA
        0x88F8, # G+3921  U+88F8  uni88F8,  CJK UNIFIED IDEOGRAPH-88F8
        0x6765, # G+3922  U+6765  uni6765,  CJK UNIFIED IDEOGRAPH-6765
        0x83B1, # G+3923  U+83B1  uni83B1,  CJK UNIFIED IDEOGRAPH-83B1
        0x983C, # G+3924  U+983C  uni983C,  CJK UNIFIED IDEOGRAPH-983C
        0x96F7, # G+3925  U+96F7  uni96F7,  CJK UNIFIED IDEOGRAPH-96F7
        0x6D1B, # G+3926  U+6D1B  uni6D1B,  CJK UNIFIED IDEOGRAPH-6D1B
        0x7D61, # G+3927  U+7D61  uni7D61,  CJK UNIFIED IDEOGRAPH-7D61
        0x843D, # G+3928  U+843D  uni843D,  CJK UNIFIED IDEOGRAPH-843D
        0x916A, # G+3929  U+916A  uni916A,  CJK UNIFIED IDEOGRAPH-916A
        0x4E71, # G+3930  U+4E71  uni4E71,  CJK UNIFIED IDEOGRAPH-4E71
        0x5375, # G+3931  U+5375  uni5375,  CJK UNIFIED IDEOGRAPH-5375
        0x5D50, # G+3932  U+5D50  uni5D50,  CJK UNIFIED IDEOGRAPH-5D50
        0x6B04, # G+3933  U+6B04  uni6B04,  CJK UNIFIED IDEOGRAPH-6B04
        0x6FEB, # G+3934  U+6FEB  uni6FEB,  CJK UNIFIED IDEOGRAPH-6FEB
        0x85CD, # G+3935  U+85CD  uni85CD,  CJK UNIFIED IDEOGRAPH-85CD
        0x862D, # G+3936  U+862D  uni862D,  CJK UNIFIED IDEOGRAPH-862D
        0x89A7, # G+3937  U+89A7  uni89A7,  CJK UNIFIED IDEOGRAPH-89A7
        0x5229, # G+3938  U+5229  uni5229,  CJK UNIFIED IDEOGRAPH-5229
        0x540F, # G+3939  U+540F  uni540F,  CJK UNIFIED IDEOGRAPH-540F
        0x5C65, # G+3940  U+5C65  uni5C65,  CJK UNIFIED IDEOGRAPH-5C65
        0x674E, # G+3941  U+674E  uni674E,  CJK UNIFIED IDEOGRAPH-674E
        0x68A8, # G+3942  U+68A8  uni68A8,  CJK UNIFIED IDEOGRAPH-68A8
        0x7406, # G+3943  U+7406  uni7406,  CJK UNIFIED IDEOGRAPH-7406
        0x7483, # G+3944  U+7483  uni7483,  CJK UNIFIED IDEOGRAPH-7483
        0x75E2, # G+3945  U+75E2  uni75E2,  CJK UNIFIED IDEOGRAPH-75E2
        0x88CF, # G+3946  U+88CF  uni88CF,  CJK UNIFIED IDEOGRAPH-88CF
        0x88E1, # G+3947  U+88E1  uni88E1,  CJK UNIFIED IDEOGRAPH-88E1
        0x2FA5, # G+3948  U+2FA5  uni2FA5,  KANGXI RADICAL VILLAGE
        0x96E2, # G+3949  U+96E2  uni96E2,  CJK UNIFIED IDEOGRAPH-96E2
        0x9678, # G+3950  U+9678  uni9678,  CJK UNIFIED IDEOGRAPH-9678
        0x5F8B, # G+3951  U+5F8B  uni5F8B,  CJK UNIFIED IDEOGRAPH-5F8B
        0x7387, # G+3952  U+7387  uni7387,  CJK UNIFIED IDEOGRAPH-7387
        0x2F74, # G+3953  U+2F74  uni2F74,  KANGXI RADICAL STAND
        0x844E, # G+3954  U+844E  uni844E,  CJK UNIFIED IDEOGRAPH-844E
        0x63A0, # G+3955  U+63A0  uni63A0,  CJK UNIFIED IDEOGRAPH-63A0
        0x7565, # G+3956  U+7565  uni7565,  CJK UNIFIED IDEOGRAPH-7565
        0x5289, # G+3957  U+5289  uni5289,  CJK UNIFIED IDEOGRAPH-5289
        0x6D41, # G+3958  U+6D41  uni6D41,  CJK UNIFIED IDEOGRAPH-6D41
        0x6E9C, # G+3959  U+6E9C  uni6E9C,  CJK UNIFIED IDEOGRAPH-6E9C
        0x7409, # G+3960  U+7409  uni7409,  CJK UNIFIED IDEOGRAPH-7409
        0x7559, # G+3961  U+7559  uni7559,  CJK UNIFIED IDEOGRAPH-7559
        0x786B, # G+3962  U+786B  uni786B,  CJK UNIFIED IDEOGRAPH-786B
        0x7C92, # G+3963  U+7C92  uni7C92,  CJK UNIFIED IDEOGRAPH-7C92
        0x9686, # G+3964  U+9686  uni9686,  CJK UNIFIED IDEOGRAPH-9686
        0x2EEF, # G+3965  U+2EEF  uni2EEF,  CJK RADICAL J-SIMPLIFIED DRAGON
        0x2FD3, # G+3966  U+2FD3  uni2FD3,  KANGXI RADICAL DRAGON
        0x4FB6, # G+3967  U+4FB6  uni4FB6,  CJK UNIFIED IDEOGRAPH-4FB6
        0x616E, # G+3968  U+616E  uni616E,  CJK UNIFIED IDEOGRAPH-616E
        0x65C5, # G+3969  U+65C5  uni65C5,  CJK UNIFIED IDEOGRAPH-65C5
        0x865C, # G+3970  U+865C  uni865C,  CJK UNIFIED IDEOGRAPH-865C
        0x4E86, # G+3971  U+4E86  uni4E86,  CJK UNIFIED IDEOGRAPH-4E86
        0x4EAE, # G+3972  U+4EAE  uni4EAE,  CJK UNIFIED IDEOGRAPH-4EAE
        0x50DA, # G+3973  U+50DA  uni50DA,  CJK UNIFIED IDEOGRAPH-50DA
        0x4E21, # G+3974  U+4E21  uni4E21,  CJK UNIFIED IDEOGRAPH-4E21
        0x51CC, # G+3975  U+51CC  uni51CC,  CJK UNIFIED IDEOGRAPH-51CC
        0x5BEE, # G+3976  U+5BEE  uni5BEE,  CJK UNIFIED IDEOGRAPH-5BEE
        0x6599, # G+3977  U+6599  uni6599,  CJK UNIFIED IDEOGRAPH-6599
        0x6881, # G+3978  U+6881  uni6881,  CJK UNIFIED IDEOGRAPH-6881
        0x6DBC, # G+3979  U+6DBC  uni6DBC,  CJK UNIFIED IDEOGRAPH-6DBC
        0x731F, # G+3980  U+731F  uni731F,  CJK UNIFIED IDEOGRAPH-731F
        0x7642, # G+3981  U+7642  uni7642,  CJK UNIFIED IDEOGRAPH-7642
        0x77AD, # G+3982  U+77AD  uni77AD,  CJK UNIFIED IDEOGRAPH-77AD
        0x7A1C, # G+3983  U+7A1C  uni7A1C,  CJK UNIFIED IDEOGRAPH-7A1C
        0x7CE7, # G+3984  U+7CE7  uni7CE7,  CJK UNIFIED IDEOGRAPH-7CE7
        0x826F, # G+3985  U+826F  uni826F,  CJK UNIFIED IDEOGRAPH-826F
        0x8AD2, # G+3986  U+8AD2  uni8AD2,  CJK UNIFIED IDEOGRAPH-8AD2
        0x907C, # G+3987  U+907C  uni907C,  CJK UNIFIED IDEOGRAPH-907C
        0x91CF, # G+3988  U+91CF  uni91CF,  CJK UNIFIED IDEOGRAPH-91CF
        0x9675, # G+3989  U+9675  uni9675,  CJK UNIFIED IDEOGRAPH-9675
        0x9818, # G+3990  U+9818  uni9818,  CJK UNIFIED IDEOGRAPH-9818
        0x2F12, # G+3991  U+2F12  uni2F12,  KANGXI RADICAL POWER
        0x7DD1, # G+3992  U+7DD1  uni7DD1,  CJK UNIFIED IDEOGRAPH-7DD1
        0x502B, # G+3993  U+502B  uni502B,  CJK UNIFIED IDEOGRAPH-502B
        0x5398, # G+3994  U+5398  uni5398,  CJK UNIFIED IDEOGRAPH-5398
        0x6797, # G+3995  U+6797  uni6797,  CJK UNIFIED IDEOGRAPH-6797
        0x6DCB, # G+3996  U+6DCB  uni6DCB,  CJK UNIFIED IDEOGRAPH-6DCB
        0x71D0, # G+3997  U+71D0  uni71D0,  CJK UNIFIED IDEOGRAPH-71D0
        0x7433, # G+3998  U+7433  uni7433,  CJK UNIFIED IDEOGRAPH-7433
        0x81E8, # G+3999  U+81E8  uni81E8,  CJK UNIFIED IDEOGRAPH-81E8
        0x8F2A, # G+4000  U+8F2A  uni8F2A,  CJK UNIFIED IDEOGRAPH-8F2A
        0x96A3, # G+4001  U+96A3  uni96A3,  CJK UNIFIED IDEOGRAPH-96A3
        0x9C57, # G+4002  U+9C57  uni9C57,  CJK UNIFIED IDEOGRAPH-9C57
        0x9E9F, # G+4003  U+9E9F  uni9E9F,  CJK UNIFIED IDEOGRAPH-9E9F
        0x7460, # G+4004  U+7460  uni7460,  CJK UNIFIED IDEOGRAPH-7460
        0x5841, # G+4005  U+5841  uni5841,  CJK UNIFIED IDEOGRAPH-5841
        0x6D99, # G+4006  U+6D99  uni6D99,  CJK UNIFIED IDEOGRAPH-6D99
        0x7D2F, # G+4007  U+7D2F  uni7D2F,  CJK UNIFIED IDEOGRAPH-7D2F
        0x985E, # G+4008  U+985E  uni985E,  CJK UNIFIED IDEOGRAPH-985E
        0x4EE4, # G+4009  U+4EE4  uni4EE4,  CJK UNIFIED IDEOGRAPH-4EE4
        0x4F36, # G+4010  U+4F36  uni4F36,  CJK UNIFIED IDEOGRAPH-4F36
        0x4F8B, # G+4011  U+4F8B  uni4F8B,  CJK UNIFIED IDEOGRAPH-4F8B
        0x51B7, # G+4012  U+51B7  uni51B7,  CJK UNIFIED IDEOGRAPH-51B7
        0x52B1, # G+4013  U+52B1  uni52B1,  CJK UNIFIED IDEOGRAPH-52B1
        0x5DBA, # G+4014  U+5DBA  uni5DBA,  CJK UNIFIED IDEOGRAPH-5DBA
        0x601C, # G+4015  U+601C  uni601C,  CJK UNIFIED IDEOGRAPH-601C
        0x73B2, # G+4016  U+73B2  uni73B2,  CJK UNIFIED IDEOGRAPH-73B2
        0x793C, # G+4017  U+793C  uni793C,  CJK UNIFIED IDEOGRAPH-793C
        0x82D3, # G+4018  U+82D3  uni82D3,  CJK UNIFIED IDEOGRAPH-82D3
        0x9234, # G+4019  U+9234  uni9234,  CJK UNIFIED IDEOGRAPH-9234
        0x96B7, # G+4020  U+96B7  uni96B7,  CJK UNIFIED IDEOGRAPH-96B7
        0x96F6, # G+4021  U+96F6  uni96F6,  CJK UNIFIED IDEOGRAPH-96F6
        0x970A, # G+4022  U+970A  uni970A,  CJK UNIFIED IDEOGRAPH-970A
        0x9E97, # G+4023  U+9E97  uni9E97,  CJK UNIFIED IDEOGRAPH-9E97
        0x9F62, # G+4024  U+9F62  uni9F62,  CJK UNIFIED IDEOGRAPH-9F62
        0x66A6, # G+4025  U+66A6  uni66A6,  CJK UNIFIED IDEOGRAPH-66A6
        0x6B74, # G+4026  U+6B74  uni6B74,  CJK UNIFIED IDEOGRAPH-6B74
        0x5217, # G+4027  U+5217  uni5217,  CJK UNIFIED IDEOGRAPH-5217
        0x52A3, # G+4028  U+52A3  uni52A3,  CJK UNIFIED IDEOGRAPH-52A3
        0x70C8, # G+4029  U+70C8  uni70C8,  CJK UNIFIED IDEOGRAPH-70C8
        0x88C2, # G+4030  U+88C2  uni88C2,  CJK UNIFIED IDEOGRAPH-88C2
        0x5EC9, # G+4031  U+5EC9  uni5EC9,  CJK UNIFIED IDEOGRAPH-5EC9
        0x604B, # G+4032  U+604B  uni604B,  CJK UNIFIED IDEOGRAPH-604B
        0x6190, # G+4033  U+6190  uni6190,  CJK UNIFIED IDEOGRAPH-6190
        0x6F23, # G+4034  U+6F23  uni6F23,  CJK UNIFIED IDEOGRAPH-6F23
        0x7149, # G+4035  U+7149  uni7149,  CJK UNIFIED IDEOGRAPH-7149
        0x7C3E, # G+4036  U+7C3E  uni7C3E,  CJK UNIFIED IDEOGRAPH-7C3E
        0x7DF4, # G+4037  U+7DF4  uni7DF4,  CJK UNIFIED IDEOGRAPH-7DF4
        0x806F, # G+4038  U+806F  uni806F,  CJK UNIFIED IDEOGRAPH-806F
        0x84EE, # G+4039  U+84EE  uni84EE,  CJK UNIFIED IDEOGRAPH-84EE
        0x9023, # G+4040  U+9023  uni9023,  CJK UNIFIED IDEOGRAPH-9023
        0x932C, # G+4041  U+932C  uni932C,  CJK UNIFIED IDEOGRAPH-932C
        0x5442, # G+4042  U+5442  uni5442,  CJK UNIFIED IDEOGRAPH-5442
        0x9B6F, # G+4043  U+9B6F  uni9B6F,  CJK UNIFIED IDEOGRAPH-9B6F
        0x6AD3, # G+4044  U+6AD3  uni6AD3,  CJK UNIFIED IDEOGRAPH-6AD3
        0x7089, # G+4045  U+7089  uni7089,  CJK UNIFIED IDEOGRAPH-7089
        0x8CC2, # G+4046  U+8CC2  uni8CC2,  CJK UNIFIED IDEOGRAPH-8CC2
        0x8DEF, # G+4047  U+8DEF  uni8DEF,  CJK UNIFIED IDEOGRAPH-8DEF
        0x9732, # G+4048  U+9732  uni9732,  CJK UNIFIED IDEOGRAPH-9732
        0x52B4, # G+4049  U+52B4  uni52B4,  CJK UNIFIED IDEOGRAPH-52B4
        0x5A41, # G+4050  U+5A41  uni5A41,  CJK UNIFIED IDEOGRAPH-5A41
        0x5ECA, # G+4051  U+5ECA  uni5ECA,  CJK UNIFIED IDEOGRAPH-5ECA
        0x5F04, # G+4052  U+5F04  uni5F04,  CJK UNIFIED IDEOGRAPH-5F04
        0x6717, # G+4053  U+6717  uni6717,  CJK UNIFIED IDEOGRAPH-6717
        0x697C, # G+4054  U+697C  uni697C,  CJK UNIFIED IDEOGRAPH-697C
        0x6994, # G+4055  U+6994  uni6994,  CJK UNIFIED IDEOGRAPH-6994
        0x6D6A, # G+4056  U+6D6A  uni6D6A,  CJK UNIFIED IDEOGRAPH-6D6A
        0x6F0F, # G+4057  U+6F0F  uni6F0F,  CJK UNIFIED IDEOGRAPH-6F0F
        0x7262, # G+4058  U+7262  uni7262,  CJK UNIFIED IDEOGRAPH-7262
        0x72FC, # G+4059  U+72FC  uni72FC,  CJK UNIFIED IDEOGRAPH-72FC
        0x7BED, # G+4060  U+7BED  uni7BED,  CJK UNIFIED IDEOGRAPH-7BED
        0x2F7C, # G+4061  U+2F7C  uni2F7C,  KANGXI RADICAL OLD
        0x807E, # G+4062  U+807E  uni807E,  CJK UNIFIED IDEOGRAPH-807E
        0x874B, # G+4063  U+874B  uni874B,  CJK UNIFIED IDEOGRAPH-874B
        0x90CE, # G+4064  U+90CE  uni90CE,  CJK UNIFIED IDEOGRAPH-90CE
        0x516D, # G+4065  U+516D  uni516D,  CJK UNIFIED IDEOGRAPH-516D
        0x9E93, # G+4066  U+9E93  uni9E93,  CJK UNIFIED IDEOGRAPH-9E93
        0x7984, # G+4067  U+7984  uni7984,  CJK UNIFIED IDEOGRAPH-7984
        0x808B, # G+4068  U+808B  uni808B,  CJK UNIFIED IDEOGRAPH-808B
        0x9332, # G+4069  U+9332  uni9332,  CJK UNIFIED IDEOGRAPH-9332
        0x8AD6, # G+4070  U+8AD6  uni8AD6,  CJK UNIFIED IDEOGRAPH-8AD6
        0x502D, # G+4071  U+502D  uni502D,  CJK UNIFIED IDEOGRAPH-502D
        0x548C, # G+4072  U+548C  uni548C,  CJK UNIFIED IDEOGRAPH-548C
        0x8A71, # G+4073  U+8A71  uni8A71,  CJK UNIFIED IDEOGRAPH-8A71
        0x6B6A, # G+4074  U+6B6A  uni6B6A,  CJK UNIFIED IDEOGRAPH-6B6A
        0x8CC4, # G+4075  U+8CC4  uni8CC4,  CJK UNIFIED IDEOGRAPH-8CC4
        0x8107, # G+4076  U+8107  uni8107,  CJK UNIFIED IDEOGRAPH-8107
        0x60D1, # G+4077  U+60D1  uni60D1,  CJK UNIFIED IDEOGRAPH-60D1
        0x67A0, # G+4078  U+67A0  uni67A0,  CJK UNIFIED IDEOGRAPH-67A0
        0x9DF2, # G+4079  U+9DF2  uni9DF2,  CJK UNIFIED IDEOGRAPH-9DF2
        0x4E99, # G+4080  U+4E99  uni4E99,  CJK UNIFIED IDEOGRAPH-4E99
        0x4E98, # G+4081  U+4E98  uni4E98,  CJK UNIFIED IDEOGRAPH-4E98
        0x9C10, # G+4082  U+9C10  uni9C10,  CJK UNIFIED IDEOGRAPH-9C10
        0x8A6B, # G+4083  U+8A6B  uni8A6B,  CJK UNIFIED IDEOGRAPH-8A6B
        0x85C1, # G+4084  U+85C1  uni85C1,  CJK UNIFIED IDEOGRAPH-85C1
        0x8568, # G+4085  U+8568  uni8568,  CJK UNIFIED IDEOGRAPH-8568
        0x6900, # G+4086  U+6900  uni6900,  CJK UNIFIED IDEOGRAPH-6900
        0x6E7E, # G+4087  U+6E7E  uni6E7E,  CJK UNIFIED IDEOGRAPH-6E7E
        0x7897, # G+4088  U+7897  uni7897,  CJK UNIFIED IDEOGRAPH-7897
        0x8155, # G+4089  U+8155  uni8155,  CJK UNIFIED IDEOGRAPH-8155
        0x5F0C, # G+4090  U+5F0C  uni5F0C,  CJK UNIFIED IDEOGRAPH-5F0C
        0x4E10, # G+4091  U+4E10  uni4E10,  CJK UNIFIED IDEOGRAPH-4E10
        0x4E15, # G+4092  U+4E15  uni4E15,  CJK UNIFIED IDEOGRAPH-4E15
        0x4E2A, # G+4093  U+4E2A  uni4E2A,  CJK UNIFIED IDEOGRAPH-4E2A
        0x4E31, # G+4094  U+4E31  uni4E31,  CJK UNIFIED IDEOGRAPH-4E31
        0x2F02, # G+4095  U+2F02  uni2F02,  KANGXI RADICAL DOT
        0x4E3C, # G+4096  U+4E3C  uni4E3C,  CJK UNIFIED IDEOGRAPH-4E3C
        0x2F03, # G+4097  U+2F03  uni2F03,  KANGXI RADICAL SLASH
        0x4E42, # G+4098  U+4E42  uni4E42,  CJK UNIFIED IDEOGRAPH-4E42
        0x4E56, # G+4099  U+4E56  uni4E56,  CJK UNIFIED IDEOGRAPH-4E56
        0x4E58, # G+4100  U+4E58  uni4E58,  CJK UNIFIED IDEOGRAPH-4E58
        0x4E82, # G+4101  U+4E82  uni4E82,  CJK UNIFIED IDEOGRAPH-4E82
        0x2F05, # G+4102  U+2F05  uni2F05,  KANGXI RADICAL HOOK
        0x8C6B, # G+4103  U+8C6B  uni8C6B,  CJK UNIFIED IDEOGRAPH-8C6B
        0x4E8A, # G+4104  U+4E8A  uni4E8A,  CJK UNIFIED IDEOGRAPH-4E8A
        0x8212, # G+4105  U+8212  uni8212,  CJK UNIFIED IDEOGRAPH-8212
        0x5F0D, # G+4106  U+5F0D  uni5F0D,  CJK UNIFIED IDEOGRAPH-5F0D
        0x4E8E, # G+4107  U+4E8E  uni4E8E,  CJK UNIFIED IDEOGRAPH-4E8E
        0x4E9E, # G+4108  U+4E9E  uni4E9E,  CJK UNIFIED IDEOGRAPH-4E9E
        0x4E9F, # G+4109  U+4E9F  uni4E9F,  CJK UNIFIED IDEOGRAPH-4E9F
        0x2F07, # G+4110  U+2F07  uni2F07,  KANGXI RADICAL LID
        0x4EA2, # G+4111  U+4EA2  uni4EA2,  CJK UNIFIED IDEOGRAPH-4EA2
        0x4EB0, # G+4112  U+4EB0  uni4EB0,  CJK UNIFIED IDEOGRAPH-4EB0
        0x4EB3, # G+4113  U+4EB3  uni4EB3,  CJK UNIFIED IDEOGRAPH-4EB3
        0x4EB6, # G+4114  U+4EB6  uni4EB6,  CJK UNIFIED IDEOGRAPH-4EB6
        0x4ECE, # G+4115  U+4ECE  uni4ECE,  CJK UNIFIED IDEOGRAPH-4ECE
        0x4ECD, # G+4116  U+4ECD  uni4ECD,  CJK UNIFIED IDEOGRAPH-4ECD
        0x4EC4, # G+4117  U+4EC4  uni4EC4,  CJK UNIFIED IDEOGRAPH-4EC4
        0x4EC6, # G+4118  U+4EC6  uni4EC6,  CJK UNIFIED IDEOGRAPH-4EC6
        0x4EC2, # G+4119  U+4EC2  uni4EC2,  CJK UNIFIED IDEOGRAPH-4EC2
        0x4ED7, # G+4120  U+4ED7  uni4ED7,  CJK UNIFIED IDEOGRAPH-4ED7
        0x4EDE, # G+4121  U+4EDE  uni4EDE,  CJK UNIFIED IDEOGRAPH-4EDE
        0x4EED, # G+4122  U+4EED  uni4EED,  CJK UNIFIED IDEOGRAPH-4EED
        0x4EDF, # G+4123  U+4EDF  uni4EDF,  CJK UNIFIED IDEOGRAPH-4EDF
        0x4EF7, # G+4124  U+4EF7  uni4EF7,  CJK UNIFIED IDEOGRAPH-4EF7
        0x4F09, # G+4125  U+4F09  uni4F09,  CJK UNIFIED IDEOGRAPH-4F09
        0x4F5A, # G+4126  U+4F5A  uni4F5A,  CJK UNIFIED IDEOGRAPH-4F5A
        0x4F30, # G+4127  U+4F30  uni4F30,  CJK UNIFIED IDEOGRAPH-4F30
        0x4F5B, # G+4128  U+4F5B  uni4F5B,  CJK UNIFIED IDEOGRAPH-4F5B
        0x4F5D, # G+4129  U+4F5D  uni4F5D,  CJK UNIFIED IDEOGRAPH-4F5D
        0x4F57, # G+4130  U+4F57  uni4F57,  CJK UNIFIED IDEOGRAPH-4F57
        0x4F47, # G+4131  U+4F47  uni4F47,  CJK UNIFIED IDEOGRAPH-4F47
        0x4F76, # G+4132  U+4F76  uni4F76,  CJK UNIFIED IDEOGRAPH-4F76
        0x4F88, # G+4133  U+4F88  uni4F88,  CJK UNIFIED IDEOGRAPH-4F88
        0x4F8F, # G+4134  U+4F8F  uni4F8F,  CJK UNIFIED IDEOGRAPH-4F8F
        0x4F98, # G+4135  U+4F98  uni4F98,  CJK UNIFIED IDEOGRAPH-4F98
        0x4F7B, # G+4136  U+4F7B  uni4F7B,  CJK UNIFIED IDEOGRAPH-4F7B
        0x4F69, # G+4137  U+4F69  uni4F69,  CJK UNIFIED IDEOGRAPH-4F69
        0x4F70, # G+4138  U+4F70  uni4F70,  CJK UNIFIED IDEOGRAPH-4F70
        0x4F91, # G+4139  U+4F91  uni4F91,  CJK UNIFIED IDEOGRAPH-4F91
        0x4F6F, # G+4140  U+4F6F  uni4F6F,  CJK UNIFIED IDEOGRAPH-4F6F
        0x4F86, # G+4141  U+4F86  uni4F86,  CJK UNIFIED IDEOGRAPH-4F86
        0x4F96, # G+4142  U+4F96  uni4F96,  CJK UNIFIED IDEOGRAPH-4F96
        0x5118, # G+4143  U+5118  uni5118,  CJK UNIFIED IDEOGRAPH-5118
        0x4FD4, # G+4144  U+4FD4  uni4FD4,  CJK UNIFIED IDEOGRAPH-4FD4
        0x4FDF, # G+4145  U+4FDF  uni4FDF,  CJK UNIFIED IDEOGRAPH-4FDF
        0x4FCE, # G+4146  U+4FCE  uni4FCE,  CJK UNIFIED IDEOGRAPH-4FCE
        0x4FD8, # G+4147  U+4FD8  uni4FD8,  CJK UNIFIED IDEOGRAPH-4FD8
        0x4FDB, # G+4148  U+4FDB  uni4FDB,  CJK UNIFIED IDEOGRAPH-4FDB
        0x4FD1, # G+4149  U+4FD1  uni4FD1,  CJK UNIFIED IDEOGRAPH-4FD1
        0x4FDA, # G+4150  U+4FDA  uni4FDA,  CJK UNIFIED IDEOGRAPH-4FDA
        0x4FD0, # G+4151  U+4FD0  uni4FD0,  CJK UNIFIED IDEOGRAPH-4FD0
        0x4FE4, # G+4152  U+4FE4  uni4FE4,  CJK UNIFIED IDEOGRAPH-4FE4
        0x4FE5, # G+4153  U+4FE5  uni4FE5,  CJK UNIFIED IDEOGRAPH-4FE5
        0x501A, # G+4154  U+501A  uni501A,  CJK UNIFIED IDEOGRAPH-501A
        0x5028, # G+4155  U+5028  uni5028,  CJK UNIFIED IDEOGRAPH-5028
        0x5014, # G+4156  U+5014  uni5014,  CJK UNIFIED IDEOGRAPH-5014
        0x502A, # G+4157  U+502A  uni502A,  CJK UNIFIED IDEOGRAPH-502A
        0x5025, # G+4158  U+5025  uni5025,  CJK UNIFIED IDEOGRAPH-5025
        0x5005, # G+4159  U+5005  uni5005,  CJK UNIFIED IDEOGRAPH-5005
        0x4F1C, # G+4160  U+4F1C  uni4F1C,  CJK UNIFIED IDEOGRAPH-4F1C
        0x4FF6, # G+4161  U+4FF6  uni4FF6,  CJK UNIFIED IDEOGRAPH-4FF6
        0x5021, # G+4162  U+5021  uni5021,  CJK UNIFIED IDEOGRAPH-5021
        0x5029, # G+4163  U+5029  uni5029,  CJK UNIFIED IDEOGRAPH-5029
        0x502C, # G+4164  U+502C  uni502C,  CJK UNIFIED IDEOGRAPH-502C
        0x4FFE, # G+4165  U+4FFE  uni4FFE,  CJK UNIFIED IDEOGRAPH-4FFE
        0x4FEF, # G+4166  U+4FEF  uni4FEF,  CJK UNIFIED IDEOGRAPH-4FEF
        0x5011, # G+4167  U+5011  uni5011,  CJK UNIFIED IDEOGRAPH-5011
        0x5006, # G+4168  U+5006  uni5006,  CJK UNIFIED IDEOGRAPH-5006
        0x5043, # G+4169  U+5043  uni5043,  CJK UNIFIED IDEOGRAPH-5043
        0x5047, # G+4170  U+5047  uni5047,  CJK UNIFIED IDEOGRAPH-5047
        0x6703, # G+4171  U+6703  uni6703,  CJK UNIFIED IDEOGRAPH-6703
        0x5055, # G+4172  U+5055  uni5055,  CJK UNIFIED IDEOGRAPH-5055
        0x5050, # G+4173  U+5050  uni5050,  CJK UNIFIED IDEOGRAPH-5050
        0x5048, # G+4174  U+5048  uni5048,  CJK UNIFIED IDEOGRAPH-5048
        0x505A, # G+4175  U+505A  uni505A,  CJK UNIFIED IDEOGRAPH-505A
        0x5056, # G+4176  U+5056  uni5056,  CJK UNIFIED IDEOGRAPH-5056
        0x506C, # G+4177  U+506C  uni506C,  CJK UNIFIED IDEOGRAPH-506C
        0x5078, # G+4178  U+5078  uni5078,  CJK UNIFIED IDEOGRAPH-5078
        0x5080, # G+4179  U+5080  uni5080,  CJK UNIFIED IDEOGRAPH-5080
        0x509A, # G+4180  U+509A  uni509A,  CJK UNIFIED IDEOGRAPH-509A
        0x5085, # G+4181  U+5085  uni5085,  CJK UNIFIED IDEOGRAPH-5085
        0x50B4, # G+4182  U+50B4  uni50B4,  CJK UNIFIED IDEOGRAPH-50B4
        0x50B2, # G+4183  U+50B2  uni50B2,  CJK UNIFIED IDEOGRAPH-50B2
        0x50C9, # G+4184  U+50C9  uni50C9,  CJK UNIFIED IDEOGRAPH-50C9
        0x50CA, # G+4185  U+50CA  uni50CA,  CJK UNIFIED IDEOGRAPH-50CA
        0x50B3, # G+4186  U+50B3  uni50B3,  CJK UNIFIED IDEOGRAPH-50B3
        0x50C2, # G+4187  U+50C2  uni50C2,  CJK UNIFIED IDEOGRAPH-50C2
        0x50D6, # G+4188  U+50D6  uni50D6,  CJK UNIFIED IDEOGRAPH-50D6
        0x50DE, # G+4189  U+50DE  uni50DE,  CJK UNIFIED IDEOGRAPH-50DE
        0x50E5, # G+4190  U+50E5  uni50E5,  CJK UNIFIED IDEOGRAPH-50E5
        0x50ED, # G+4191  U+50ED  uni50ED,  CJK UNIFIED IDEOGRAPH-50ED
        0x50E3, # G+4192  U+50E3  uni50E3,  CJK UNIFIED IDEOGRAPH-50E3
        0x50EE, # G+4193  U+50EE  uni50EE,  CJK UNIFIED IDEOGRAPH-50EE
        0x50F9, # G+4194  U+50F9  uni50F9,  CJK UNIFIED IDEOGRAPH-50F9
        0x50F5, # G+4195  U+50F5  uni50F5,  CJK UNIFIED IDEOGRAPH-50F5
        0x5109, # G+4196  U+5109  uni5109,  CJK UNIFIED IDEOGRAPH-5109
        0x5101, # G+4197  U+5101  uni5101,  CJK UNIFIED IDEOGRAPH-5101
        0x5102, # G+4198  U+5102  uni5102,  CJK UNIFIED IDEOGRAPH-5102
        0x5116, # G+4199  U+5116  uni5116,  CJK UNIFIED IDEOGRAPH-5116
        0x5115, # G+4200  U+5115  uni5115,  CJK UNIFIED IDEOGRAPH-5115
        0x5114, # G+4201  U+5114  uni5114,  CJK UNIFIED IDEOGRAPH-5114
        0x511A, # G+4202  U+511A  uni511A,  CJK UNIFIED IDEOGRAPH-511A
        0x5121, # G+4203  U+5121  uni5121,  CJK UNIFIED IDEOGRAPH-5121
        0x513A, # G+4204  U+513A  uni513A,  CJK UNIFIED IDEOGRAPH-513A
        0x5137, # G+4205  U+5137  uni5137,  CJK UNIFIED IDEOGRAPH-5137
        0x513C, # G+4206  U+513C  uni513C,  CJK UNIFIED IDEOGRAPH-513C
        0x513B, # G+4207  U+513B  uni513B,  CJK UNIFIED IDEOGRAPH-513B
        0x2F09, # G+4208  U+2F09  uni2F09,  KANGXI RADICAL LEGS
        0x2E8E, # G+4209  U+2E8E  uni2E8E,  CJK RADICAL LAME ONE
        0x5152, # G+4210  U+5152  uni5152,  CJK UNIFIED IDEOGRAPH-5152
        0x514C, # G+4211  U+514C  uni514C,  CJK UNIFIED IDEOGRAPH-514C
        0x5154, # G+4212  U+5154  uni5154,  CJK UNIFIED IDEOGRAPH-5154
        0x5162, # G+4213  U+5162  uni5162,  CJK UNIFIED IDEOGRAPH-5162
        0x7AF8, # G+4214  U+7AF8  uni7AF8,  CJK UNIFIED IDEOGRAPH-7AF8
        0x5169, # G+4215  U+5169  uni5169,  CJK UNIFIED IDEOGRAPH-5169
        0x516A, # G+4216  U+516A  uni516A,  CJK UNIFIED IDEOGRAPH-516A
        0x516E, # G+4217  U+516E  uni516E,  CJK UNIFIED IDEOGRAPH-516E
        0x5180, # G+4218  U+5180  uni5180,  CJK UNIFIED IDEOGRAPH-5180
        0x2F0C, # G+4219  U+2F0C  uni2F0C,  KANGXI RADICAL DOWN BOX
        0x56D8, # G+4220  U+56D8  uni56D8,  CJK UNIFIED IDEOGRAPH-56D8
        0x518C, # G+4221  U+518C  uni518C,  CJK UNIFIED IDEOGRAPH-518C
        0x5189, # G+4222  U+5189  uni5189,  CJK UNIFIED IDEOGRAPH-5189
        0x518F, # G+4223  U+518F  uni518F,  CJK UNIFIED IDEOGRAPH-518F
        0x5191, # G+4224  U+5191  uni5191,  CJK UNIFIED IDEOGRAPH-5191
        0x5193, # G+4225  U+5193  uni5193,  CJK UNIFIED IDEOGRAPH-5193
        0x5195, # G+4226  U+5195  uni5195,  CJK UNIFIED IDEOGRAPH-5195
        0x2F0D, # G+4227  U+2F0D  uni2F0D,  KANGXI RADICAL COVER
        0x51A4, # G+4228  U+51A4  uni51A4,  CJK UNIFIED IDEOGRAPH-51A4
        0x51A6, # G+4229  U+51A6  uni51A6,  CJK UNIFIED IDEOGRAPH-51A6
        0x51A2, # G+4230  U+51A2  uni51A2,  CJK UNIFIED IDEOGRAPH-51A2
        0x51A9, # G+4231  U+51A9  uni51A9,  CJK UNIFIED IDEOGRAPH-51A9
        0x51AA, # G+4232  U+51AA  uni51AA,  CJK UNIFIED IDEOGRAPH-51AA
        0x2F0E, # G+4233  U+2F0E  uni2F0E,  KANGXI RADICAL ICE
        0x51B3, # G+4234  U+51B3  uni51B3,  CJK UNIFIED IDEOGRAPH-51B3
        0x51B1, # G+4235  U+51B1  uni51B1,  CJK UNIFIED IDEOGRAPH-51B1
        0x51B2, # G+4236  U+51B2  uni51B2,  CJK UNIFIED IDEOGRAPH-51B2
        0x51B0, # G+4237  U+51B0  uni51B0,  CJK UNIFIED IDEOGRAPH-51B0
        0x51B5, # G+4238  U+51B5  uni51B5,  CJK UNIFIED IDEOGRAPH-51B5
        0x51BD, # G+4239  U+51BD  uni51BD,  CJK UNIFIED IDEOGRAPH-51BD
        0x51C5, # G+4240  U+51C5  uni51C5,  CJK UNIFIED IDEOGRAPH-51C5
        0x51C9, # G+4241  U+51C9  uni51C9,  CJK UNIFIED IDEOGRAPH-51C9
        0x51DB, # G+4242  U+51DB  uni51DB,  CJK UNIFIED IDEOGRAPH-51DB
        0x2F0F, # G+4243  U+2F0F  uni2F0F,  KANGXI RADICAL TABLE
        0x8655, # G+4244  U+8655  uni8655,  CJK UNIFIED IDEOGRAPH-8655
        0x51E9, # G+4245  U+51E9  uni51E9,  CJK UNIFIED IDEOGRAPH-51E9
        0x51ED, # G+4246  U+51ED  uni51ED,  CJK UNIFIED IDEOGRAPH-51ED
        0x51F0, # G+4247  U+51F0  uni51F0,  CJK UNIFIED IDEOGRAPH-51F0
        0x2F10, # G+4248  U+2F10  uni2F10,  KANGXI RADICAL OPEN BOX
        0x51FE, # G+4249  U+51FE  uni51FE,  CJK UNIFIED IDEOGRAPH-51FE
        0x5204, # G+4250  U+5204  uni5204,  CJK UNIFIED IDEOGRAPH-5204
        0x520B, # G+4251  U+520B  uni520B,  CJK UNIFIED IDEOGRAPH-520B
        0x5214, # G+4252  U+5214  uni5214,  CJK UNIFIED IDEOGRAPH-5214
        0x520E, # G+4253  U+520E  uni520E,  CJK UNIFIED IDEOGRAPH-520E
        0x5227, # G+4254  U+5227  uni5227,  CJK UNIFIED IDEOGRAPH-5227
        0x522A, # G+4255  U+522A  uni522A,  CJK UNIFIED IDEOGRAPH-522A
        0x522E, # G+4256  U+522E  uni522E,  CJK UNIFIED IDEOGRAPH-522E
        0x5233, # G+4257  U+5233  uni5233,  CJK UNIFIED IDEOGRAPH-5233
        0x5239, # G+4258  U+5239  uni5239,  CJK UNIFIED IDEOGRAPH-5239
        0x524F, # G+4259  U+524F  uni524F,  CJK UNIFIED IDEOGRAPH-524F
        0x5244, # G+4260  U+5244  uni5244,  CJK UNIFIED IDEOGRAPH-5244
        0x524B, # G+4261  U+524B  uni524B,  CJK UNIFIED IDEOGRAPH-524B
        0x524C, # G+4262  U+524C  uni524C,  CJK UNIFIED IDEOGRAPH-524C
        0x525E, # G+4263  U+525E  uni525E,  CJK UNIFIED IDEOGRAPH-525E
        0x5254, # G+4264  U+5254  uni5254,  CJK UNIFIED IDEOGRAPH-5254
        0x526A, # G+4265  U+526A  uni526A,  CJK UNIFIED IDEOGRAPH-526A
        0x5274, # G+4266  U+5274  uni5274,  CJK UNIFIED IDEOGRAPH-5274
        0x5269, # G+4267  U+5269  uni5269,  CJK UNIFIED IDEOGRAPH-5269
        0x5273, # G+4268  U+5273  uni5273,  CJK UNIFIED IDEOGRAPH-5273
        0x527F, # G+4269  U+527F  uni527F,  CJK UNIFIED IDEOGRAPH-527F
        0x527D, # G+4270  U+527D  uni527D,  CJK UNIFIED IDEOGRAPH-527D
        0x528D, # G+4271  U+528D  uni528D,  CJK UNIFIED IDEOGRAPH-528D
        0x5294, # G+4272  U+5294  uni5294,  CJK UNIFIED IDEOGRAPH-5294
        0x5292, # G+4273  U+5292  uni5292,  CJK UNIFIED IDEOGRAPH-5292
        0x5271, # G+4274  U+5271  uni5271,  CJK UNIFIED IDEOGRAPH-5271
        0x5288, # G+4275  U+5288  uni5288,  CJK UNIFIED IDEOGRAPH-5288
        0x5291, # G+4276  U+5291  uni5291,  CJK UNIFIED IDEOGRAPH-5291
        0x8FA8, # G+4277  U+8FA8  uni8FA8,  CJK UNIFIED IDEOGRAPH-8FA8
        0x8FA7, # G+4278  U+8FA7  uni8FA7,  CJK UNIFIED IDEOGRAPH-8FA7
        0x52AC, # G+4279  U+52AC  uni52AC,  CJK UNIFIED IDEOGRAPH-52AC
        0x52AD, # G+4280  U+52AD  uni52AD,  CJK UNIFIED IDEOGRAPH-52AD
        0x52BC, # G+4281  U+52BC  uni52BC,  CJK UNIFIED IDEOGRAPH-52BC
        0x52B5, # G+4282  U+52B5  uni52B5,  CJK UNIFIED IDEOGRAPH-52B5
        0x52C1, # G+4283  U+52C1  uni52C1,  CJK UNIFIED IDEOGRAPH-52C1
        0x52CD, # G+4284  U+52CD  uni52CD,  CJK UNIFIED IDEOGRAPH-52CD
        0x52D7, # G+4285  U+52D7  uni52D7,  CJK UNIFIED IDEOGRAPH-52D7
        0x52DE, # G+4286  U+52DE  uni52DE,  CJK UNIFIED IDEOGRAPH-52DE
        0x52E3, # G+4287  U+52E3  uni52E3,  CJK UNIFIED IDEOGRAPH-52E3
        0x52E6, # G+4288  U+52E6  uni52E6,  CJK UNIFIED IDEOGRAPH-52E6
        0x98ED, # G+4289  U+98ED  uni98ED,  CJK UNIFIED IDEOGRAPH-98ED
        0x52E0, # G+4290  U+52E0  uni52E0,  CJK UNIFIED IDEOGRAPH-52E0
        0x52F3, # G+4291  U+52F3  uni52F3,  CJK UNIFIED IDEOGRAPH-52F3
        0x52F5, # G+4292  U+52F5  uni52F5,  CJK UNIFIED IDEOGRAPH-52F5
        0x52F8, # G+4293  U+52F8  uni52F8,  CJK UNIFIED IDEOGRAPH-52F8
        0x2F13, # G+4294  U+2F13  uni2F13,  KANGXI RADICAL WRAP
        0x5306, # G+4295  U+5306  uni5306,  CJK UNIFIED IDEOGRAPH-5306
        0x5308, # G+4296  U+5308  uni5308,  CJK UNIFIED IDEOGRAPH-5308
        0x7538, # G+4297  U+7538  uni7538,  CJK UNIFIED IDEOGRAPH-7538
        0x530D, # G+4298  U+530D  uni530D,  CJK UNIFIED IDEOGRAPH-530D
        0x5310, # G+4299  U+5310  uni5310,  CJK UNIFIED IDEOGRAPH-5310
        0x530F, # G+4300  U+530F  uni530F,  CJK UNIFIED IDEOGRAPH-530F
        0x2F14, # G+4301  U+2F14  uni2F14,  KANGXI RADICAL SPOON
        0x2F15, # G+4302  U+2F15  uni2F15,  KANGXI RADICAL RIGHT OPEN BOX
        0x5323, # G+4303  U+5323  uni5323,  CJK UNIFIED IDEOGRAPH-5323
        0x532F, # G+4304  U+532F  uni532F,  CJK UNIFIED IDEOGRAPH-532F
        0x5331, # G+4305  U+5331  uni5331,  CJK UNIFIED IDEOGRAPH-5331
        0x5333, # G+4306  U+5333  uni5333,  CJK UNIFIED IDEOGRAPH-5333
        0x2F16, # G+4307  U+2F16  uni2F16,  KANGXI RADICAL HIDING ENCLOSURE
        0x5340, # G+4308  U+5340  uni5340,  CJK UNIFIED IDEOGRAPH-5340
        0x5346, # G+4309  U+5346  uni5346,  CJK UNIFIED IDEOGRAPH-5346
        0x5345, # G+4310  U+5345  uni5345,  CJK UNIFIED IDEOGRAPH-5345
        0x4E17, # G+4311  U+4E17  uni4E17,  CJK UNIFIED IDEOGRAPH-4E17
        0x5349, # G+4312  U+5349  uni5349,  CJK UNIFIED IDEOGRAPH-5349
        0x534D, # G+4313  U+534D  uni534D,  CJK UNIFIED IDEOGRAPH-534D
        0x51D6, # G+4314  U+51D6  uni51D6,  CJK UNIFIED IDEOGRAPH-51D6
        0x535E, # G+4315  U+535E  uni535E,  CJK UNIFIED IDEOGRAPH-535E
        0x2F19, # G+4316  U+2F19  uni2F19,  KANGXI RADICAL SEAL
        0x536E, # G+4317  U+536E  uni536E,  CJK UNIFIED IDEOGRAPH-536E
        0x5918, # G+4318  U+5918  uni5918,  CJK UNIFIED IDEOGRAPH-5918
        0x537B, # G+4319  U+537B  uni537B,  CJK UNIFIED IDEOGRAPH-537B
        0x5377, # G+4320  U+5377  uni5377,  CJK UNIFIED IDEOGRAPH-5377
        0x2F1A, # G+4321  U+2F1A  uni2F1A,  KANGXI RADICAL CLIFF
        0x5396, # G+4322  U+5396  uni5396,  CJK UNIFIED IDEOGRAPH-5396
        0x53A0, # G+4323  U+53A0  uni53A0,  CJK UNIFIED IDEOGRAPH-53A0
        0x53A6, # G+4324  U+53A6  uni53A6,  CJK UNIFIED IDEOGRAPH-53A6
        0x53A5, # G+4325  U+53A5  uni53A5,  CJK UNIFIED IDEOGRAPH-53A5
        0x53AE, # G+4326  U+53AE  uni53AE,  CJK UNIFIED IDEOGRAPH-53AE
        0x53B0, # G+4327  U+53B0  uni53B0,  CJK UNIFIED IDEOGRAPH-53B0
        0x2F1B, # G+4328  U+2F1B  uni2F1B,  KANGXI RADICAL PRIVATE
        0x53C3, # G+4329  U+53C3  uni53C3,  CJK UNIFIED IDEOGRAPH-53C3
        0x7C12, # G+4330  U+7C12  uni7C12,  CJK UNIFIED IDEOGRAPH-7C12
        0x96D9, # G+4331  U+96D9  uni96D9,  CJK UNIFIED IDEOGRAPH-96D9
        0x53DF, # G+4332  U+53DF  uni53DF,  CJK UNIFIED IDEOGRAPH-53DF
        0x66FC, # G+4333  U+66FC  uni66FC,  CJK UNIFIED IDEOGRAPH-66FC
        0x71EE, # G+4334  U+71EE  uni71EE,  CJK UNIFIED IDEOGRAPH-71EE
        0x53EE, # G+4335  U+53EE  uni53EE,  CJK UNIFIED IDEOGRAPH-53EE
        0x53E8, # G+4336  U+53E8  uni53E8,  CJK UNIFIED IDEOGRAPH-53E8
        0x53ED, # G+4337  U+53ED  uni53ED,  CJK UNIFIED IDEOGRAPH-53ED
        0x53FA, # G+4338  U+53FA  uni53FA,  CJK UNIFIED IDEOGRAPH-53FA
        0x5401, # G+4339  U+5401  uni5401,  CJK UNIFIED IDEOGRAPH-5401
        0x543D, # G+4340  U+543D  uni543D,  CJK UNIFIED IDEOGRAPH-543D
        0x5440, # G+4341  U+5440  uni5440,  CJK UNIFIED IDEOGRAPH-5440
        0x542C, # G+4342  U+542C  uni542C,  CJK UNIFIED IDEOGRAPH-542C
        0x542D, # G+4343  U+542D  uni542D,  CJK UNIFIED IDEOGRAPH-542D
        0x543C, # G+4344  U+543C  uni543C,  CJK UNIFIED IDEOGRAPH-543C
        0x542E, # G+4345  U+542E  uni542E,  CJK UNIFIED IDEOGRAPH-542E
        0x5436, # G+4346  U+5436  uni5436,  CJK UNIFIED IDEOGRAPH-5436
        0x5429, # G+4347  U+5429  uni5429,  CJK UNIFIED IDEOGRAPH-5429
        0x541D, # G+4348  U+541D  uni541D,  CJK UNIFIED IDEOGRAPH-541D
        0x544E, # G+4349  U+544E  uni544E,  CJK UNIFIED IDEOGRAPH-544E
        0x548F, # G+4350  U+548F  uni548F,  CJK UNIFIED IDEOGRAPH-548F
        0x5475, # G+4351  U+5475  uni5475,  CJK UNIFIED IDEOGRAPH-5475
        0x548E, # G+4352  U+548E  uni548E,  CJK UNIFIED IDEOGRAPH-548E
        0x545F, # G+4353  U+545F  uni545F,  CJK UNIFIED IDEOGRAPH-545F
        0x5471, # G+4354  U+5471  uni5471,  CJK UNIFIED IDEOGRAPH-5471
        0x5477, # G+4355  U+5477  uni5477,  CJK UNIFIED IDEOGRAPH-5477
        0x5470, # G+4356  U+5470  uni5470,  CJK UNIFIED IDEOGRAPH-5470
        0x5492, # G+4357  U+5492  uni5492,  CJK UNIFIED IDEOGRAPH-5492
        0x547B, # G+4358  U+547B  uni547B,  CJK UNIFIED IDEOGRAPH-547B
        0x5480, # G+4359  U+5480  uni5480,  CJK UNIFIED IDEOGRAPH-5480
        0x5476, # G+4360  U+5476  uni5476,  CJK UNIFIED IDEOGRAPH-5476
        0x5484, # G+4361  U+5484  uni5484,  CJK UNIFIED IDEOGRAPH-5484
        0x5490, # G+4362  U+5490  uni5490,  CJK UNIFIED IDEOGRAPH-5490
        0x5486, # G+4363  U+5486  uni5486,  CJK UNIFIED IDEOGRAPH-5486
        0x54C7, # G+4364  U+54C7  uni54C7,  CJK UNIFIED IDEOGRAPH-54C7
        0x54A2, # G+4365  U+54A2  uni54A2,  CJK UNIFIED IDEOGRAPH-54A2
        0x54B8, # G+4366  U+54B8  uni54B8,  CJK UNIFIED IDEOGRAPH-54B8
        0x54A5, # G+4367  U+54A5  uni54A5,  CJK UNIFIED IDEOGRAPH-54A5
        0x54AC, # G+4368  U+54AC  uni54AC,  CJK UNIFIED IDEOGRAPH-54AC
        0x54C4, # G+4369  U+54C4  uni54C4,  CJK UNIFIED IDEOGRAPH-54C4
        0x54C8, # G+4370  U+54C8  uni54C8,  CJK UNIFIED IDEOGRAPH-54C8
        0x54A8, # G+4371  U+54A8  uni54A8,  CJK UNIFIED IDEOGRAPH-54A8
        0x54AB, # G+4372  U+54AB  uni54AB,  CJK UNIFIED IDEOGRAPH-54AB
        0x54C2, # G+4373  U+54C2  uni54C2,  CJK UNIFIED IDEOGRAPH-54C2
        0x54A4, # G+4374  U+54A4  uni54A4,  CJK UNIFIED IDEOGRAPH-54A4
        0x54BE, # G+4375  U+54BE  uni54BE,  CJK UNIFIED IDEOGRAPH-54BE
        0x54BC, # G+4376  U+54BC  uni54BC,  CJK UNIFIED IDEOGRAPH-54BC
        0x54D8, # G+4377  U+54D8  uni54D8,  CJK UNIFIED IDEOGRAPH-54D8
        0x54E5, # G+4378  U+54E5  uni54E5,  CJK UNIFIED IDEOGRAPH-54E5
        0x54E6, # G+4379  U+54E6  uni54E6,  CJK UNIFIED IDEOGRAPH-54E6
        0x550F, # G+4380  U+550F  uni550F,  CJK UNIFIED IDEOGRAPH-550F
        0x5514, # G+4381  U+5514  uni5514,  CJK UNIFIED IDEOGRAPH-5514
        0x54FD, # G+4382  U+54FD  uni54FD,  CJK UNIFIED IDEOGRAPH-54FD
        0x54EE, # G+4383  U+54EE  uni54EE,  CJK UNIFIED IDEOGRAPH-54EE
        0x54ED, # G+4384  U+54ED  uni54ED,  CJK UNIFIED IDEOGRAPH-54ED
        0x54FA, # G+4385  U+54FA  uni54FA,  CJK UNIFIED IDEOGRAPH-54FA
        0x54E2, # G+4386  U+54E2  uni54E2,  CJK UNIFIED IDEOGRAPH-54E2
        0x5539, # G+4387  U+5539  uni5539,  CJK UNIFIED IDEOGRAPH-5539
        0x5540, # G+4388  U+5540  uni5540,  CJK UNIFIED IDEOGRAPH-5540
        0x5563, # G+4389  U+5563  uni5563,  CJK UNIFIED IDEOGRAPH-5563
        0x554C, # G+4390  U+554C  uni554C,  CJK UNIFIED IDEOGRAPH-554C
        0x552E, # G+4391  U+552E  uni552E,  CJK UNIFIED IDEOGRAPH-552E
        0x555C, # G+4392  U+555C  uni555C,  CJK UNIFIED IDEOGRAPH-555C
        0x5545, # G+4393  U+5545  uni5545,  CJK UNIFIED IDEOGRAPH-5545
        0x5556, # G+4394  U+5556  uni5556,  CJK UNIFIED IDEOGRAPH-5556
        0x5557, # G+4395  U+5557  uni5557,  CJK UNIFIED IDEOGRAPH-5557
        0x5538, # G+4396  U+5538  uni5538,  CJK UNIFIED IDEOGRAPH-5538
        0x5533, # G+4397  U+5533  uni5533,  CJK UNIFIED IDEOGRAPH-5533
        0x555D, # G+4398  U+555D  uni555D,  CJK UNIFIED IDEOGRAPH-555D
        0x5599, # G+4399  U+5599  uni5599,  CJK UNIFIED IDEOGRAPH-5599
        0x5580, # G+4400  U+5580  uni5580,  CJK UNIFIED IDEOGRAPH-5580
        0x54AF, # G+4401  U+54AF  uni54AF,  CJK UNIFIED IDEOGRAPH-54AF
        0x558A, # G+4402  U+558A  uni558A,  CJK UNIFIED IDEOGRAPH-558A
        0x559F, # G+4403  U+559F  uni559F,  CJK UNIFIED IDEOGRAPH-559F
        0x557B, # G+4404  U+557B  uni557B,  CJK UNIFIED IDEOGRAPH-557B
        0x557E, # G+4405  U+557E  uni557E,  CJK UNIFIED IDEOGRAPH-557E
        0x5598, # G+4406  U+5598  uni5598,  CJK UNIFIED IDEOGRAPH-5598
        0x559E, # G+4407  U+559E  uni559E,  CJK UNIFIED IDEOGRAPH-559E
        0x55AE, # G+4408  U+55AE  uni55AE,  CJK UNIFIED IDEOGRAPH-55AE
        0x557C, # G+4409  U+557C  uni557C,  CJK UNIFIED IDEOGRAPH-557C
        0x5583, # G+4410  U+5583  uni5583,  CJK UNIFIED IDEOGRAPH-5583
        0x55A9, # G+4411  U+55A9  uni55A9,  CJK UNIFIED IDEOGRAPH-55A9
        0x5587, # G+4412  U+5587  uni5587,  CJK UNIFIED IDEOGRAPH-5587
        0x55A8, # G+4413  U+55A8  uni55A8,  CJK UNIFIED IDEOGRAPH-55A8
        0x55DA, # G+4414  U+55DA  uni55DA,  CJK UNIFIED IDEOGRAPH-55DA
        0x55C5, # G+4415  U+55C5  uni55C5,  CJK UNIFIED IDEOGRAPH-55C5
        0x55DF, # G+4416  U+55DF  uni55DF,  CJK UNIFIED IDEOGRAPH-55DF
        0x55C4, # G+4417  U+55C4  uni55C4,  CJK UNIFIED IDEOGRAPH-55C4
        0x55DC, # G+4418  U+55DC  uni55DC,  CJK UNIFIED IDEOGRAPH-55DC
        0x55E4, # G+4419  U+55E4  uni55E4,  CJK UNIFIED IDEOGRAPH-55E4
        0x55D4, # G+4420  U+55D4  uni55D4,  CJK UNIFIED IDEOGRAPH-55D4
        0x5614, # G+4421  U+5614  uni5614,  CJK UNIFIED IDEOGRAPH-5614
        0x55F7, # G+4422  U+55F7  uni55F7,  CJK UNIFIED IDEOGRAPH-55F7
        0x5616, # G+4423  U+5616  uni5616,  CJK UNIFIED IDEOGRAPH-5616
        0x55FE, # G+4424  U+55FE  uni55FE,  CJK UNIFIED IDEOGRAPH-55FE
        0x55FD, # G+4425  U+55FD  uni55FD,  CJK UNIFIED IDEOGRAPH-55FD
        0x561B, # G+4426  U+561B  uni561B,  CJK UNIFIED IDEOGRAPH-561B
        0x55F9, # G+4427  U+55F9  uni55F9,  CJK UNIFIED IDEOGRAPH-55F9
        0x564E, # G+4428  U+564E  uni564E,  CJK UNIFIED IDEOGRAPH-564E
        0x5650, # G+4429  U+5650  uni5650,  CJK UNIFIED IDEOGRAPH-5650
        0x71DF, # G+4430  U+71DF  uni71DF,  CJK UNIFIED IDEOGRAPH-71DF
        0x5634, # G+4431  U+5634  uni5634,  CJK UNIFIED IDEOGRAPH-5634
        0x5636, # G+4432  U+5636  uni5636,  CJK UNIFIED IDEOGRAPH-5636
        0x5632, # G+4433  U+5632  uni5632,  CJK UNIFIED IDEOGRAPH-5632
        0x5638, # G+4434  U+5638  uni5638,  CJK UNIFIED IDEOGRAPH-5638
        0x566B, # G+4435  U+566B  uni566B,  CJK UNIFIED IDEOGRAPH-566B
        0x5664, # G+4436  U+5664  uni5664,  CJK UNIFIED IDEOGRAPH-5664
        0x562F, # G+4437  U+562F  uni562F,  CJK UNIFIED IDEOGRAPH-562F
        0x566C, # G+4438  U+566C  uni566C,  CJK UNIFIED IDEOGRAPH-566C
        0x566A, # G+4439  U+566A  uni566A,  CJK UNIFIED IDEOGRAPH-566A
        0x5686, # G+4440  U+5686  uni5686,  CJK UNIFIED IDEOGRAPH-5686
        0x5680, # G+4441  U+5680  uni5680,  CJK UNIFIED IDEOGRAPH-5680
        0x568A, # G+4442  U+568A  uni568A,  CJK UNIFIED IDEOGRAPH-568A
        0x56A0, # G+4443  U+56A0  uni56A0,  CJK UNIFIED IDEOGRAPH-56A0
        0x5694, # G+4444  U+5694  uni5694,  CJK UNIFIED IDEOGRAPH-5694
        0x568F, # G+4445  U+568F  uni568F,  CJK UNIFIED IDEOGRAPH-568F
        0x56A5, # G+4446  U+56A5  uni56A5,  CJK UNIFIED IDEOGRAPH-56A5
        0x56AE, # G+4447  U+56AE  uni56AE,  CJK UNIFIED IDEOGRAPH-56AE
        0x56B6, # G+4448  U+56B6  uni56B6,  CJK UNIFIED IDEOGRAPH-56B6
        0x56B4, # G+4449  U+56B4  uni56B4,  CJK UNIFIED IDEOGRAPH-56B4
        0x56C2, # G+4450  U+56C2  uni56C2,  CJK UNIFIED IDEOGRAPH-56C2
        0x56BC, # G+4451  U+56BC  uni56BC,  CJK UNIFIED IDEOGRAPH-56BC
        0x56C1, # G+4452  U+56C1  uni56C1,  CJK UNIFIED IDEOGRAPH-56C1
        0x56C3, # G+4453  U+56C3  uni56C3,  CJK UNIFIED IDEOGRAPH-56C3
        0x56C0, # G+4454  U+56C0  uni56C0,  CJK UNIFIED IDEOGRAPH-56C0
        0x56C8, # G+4455  U+56C8  uni56C8,  CJK UNIFIED IDEOGRAPH-56C8
        0x56CE, # G+4456  U+56CE  uni56CE,  CJK UNIFIED IDEOGRAPH-56CE
        0x56D1, # G+4457  U+56D1  uni56D1,  CJK UNIFIED IDEOGRAPH-56D1
        0x56D3, # G+4458  U+56D3  uni56D3,  CJK UNIFIED IDEOGRAPH-56D3
        0x2F1E, # G+4459  U+2F1E  uni2F1E,  KANGXI RADICAL ENCLOSURE
        0x56EE, # G+4460  U+56EE  uni56EE,  CJK UNIFIED IDEOGRAPH-56EE
        0x56F9, # G+4461  U+56F9  uni56F9,  CJK UNIFIED IDEOGRAPH-56F9
        0x5700, # G+4462  U+5700  uni5700,  CJK UNIFIED IDEOGRAPH-5700
        0x56FF, # G+4463  U+56FF  uni56FF,  CJK UNIFIED IDEOGRAPH-56FF
        0x5704, # G+4464  U+5704  uni5704,  CJK UNIFIED IDEOGRAPH-5704
        0x5709, # G+4465  U+5709  uni5709,  CJK UNIFIED IDEOGRAPH-5709
        0x5708, # G+4466  U+5708  uni5708,  CJK UNIFIED IDEOGRAPH-5708
        0x570B, # G+4467  U+570B  uni570B,  CJK UNIFIED IDEOGRAPH-570B
        0x570D, # G+4468  U+570D  uni570D,  CJK UNIFIED IDEOGRAPH-570D
        0x5713, # G+4469  U+5713  uni5713,  CJK UNIFIED IDEOGRAPH-5713
        0x5718, # G+4470  U+5718  uni5718,  CJK UNIFIED IDEOGRAPH-5718
        0x5716, # G+4471  U+5716  uni5716,  CJK UNIFIED IDEOGRAPH-5716
        0x55C7, # G+4472  U+55C7  uni55C7,  CJK UNIFIED IDEOGRAPH-55C7
        0x571C, # G+4473  U+571C  uni571C,  CJK UNIFIED IDEOGRAPH-571C
        0x5726, # G+4474  U+5726  uni5726,  CJK UNIFIED IDEOGRAPH-5726
        0x5737, # G+4475  U+5737  uni5737,  CJK UNIFIED IDEOGRAPH-5737
        0x5738, # G+4476  U+5738  uni5738,  CJK UNIFIED IDEOGRAPH-5738
        0x574E, # G+4477  U+574E  uni574E,  CJK UNIFIED IDEOGRAPH-574E
        0x573B, # G+4478  U+573B  uni573B,  CJK UNIFIED IDEOGRAPH-573B
        0x5740, # G+4479  U+5740  uni5740,  CJK UNIFIED IDEOGRAPH-5740
        0x574F, # G+4480  U+574F  uni574F,  CJK UNIFIED IDEOGRAPH-574F
        0x5769, # G+4481  U+5769  uni5769,  CJK UNIFIED IDEOGRAPH-5769
        0x57C0, # G+4482  U+57C0  uni57C0,  CJK UNIFIED IDEOGRAPH-57C0
        0x5788, # G+4483  U+5788  uni5788,  CJK UNIFIED IDEOGRAPH-5788
        0x5761, # G+4484  U+5761  uni5761,  CJK UNIFIED IDEOGRAPH-5761
        0x577F, # G+4485  U+577F  uni577F,  CJK UNIFIED IDEOGRAPH-577F
        0x5789, # G+4486  U+5789  uni5789,  CJK UNIFIED IDEOGRAPH-5789
        0x5793, # G+4487  U+5793  uni5793,  CJK UNIFIED IDEOGRAPH-5793
        0x57A0, # G+4488  U+57A0  uni57A0,  CJK UNIFIED IDEOGRAPH-57A0
        0x57B3, # G+4489  U+57B3  uni57B3,  CJK UNIFIED IDEOGRAPH-57B3
        0x57A4, # G+4490  U+57A4  uni57A4,  CJK UNIFIED IDEOGRAPH-57A4
        0x57AA, # G+4491  U+57AA  uni57AA,  CJK UNIFIED IDEOGRAPH-57AA
        0x57B0, # G+4492  U+57B0  uni57B0,  CJK UNIFIED IDEOGRAPH-57B0
        0x57C3, # G+4493  U+57C3  uni57C3,  CJK UNIFIED IDEOGRAPH-57C3
        0x57C6, # G+4494  U+57C6  uni57C6,  CJK UNIFIED IDEOGRAPH-57C6
        0x57D4, # G+4495  U+57D4  uni57D4,  CJK UNIFIED IDEOGRAPH-57D4
        0x57D2, # G+4496  U+57D2  uni57D2,  CJK UNIFIED IDEOGRAPH-57D2
        0x57D3, # G+4497  U+57D3  uni57D3,  CJK UNIFIED IDEOGRAPH-57D3
        0x580A, # G+4498  U+580A  uni580A,  CJK UNIFIED IDEOGRAPH-580A
        0x57D6, # G+4499  U+57D6  uni57D6,  CJK UNIFIED IDEOGRAPH-57D6
        0x57E3, # G+4500  U+57E3  uni57E3,  CJK UNIFIED IDEOGRAPH-57E3
        0x580B, # G+4501  U+580B  uni580B,  CJK UNIFIED IDEOGRAPH-580B
        0x5819, # G+4502  U+5819  uni5819,  CJK UNIFIED IDEOGRAPH-5819
        0x581D, # G+4503  U+581D  uni581D,  CJK UNIFIED IDEOGRAPH-581D
        0x5872, # G+4504  U+5872  uni5872,  CJK UNIFIED IDEOGRAPH-5872
        0x5821, # G+4505  U+5821  uni5821,  CJK UNIFIED IDEOGRAPH-5821
        0x5862, # G+4506  U+5862  uni5862,  CJK UNIFIED IDEOGRAPH-5862
        0x584B, # G+4507  U+584B  uni584B,  CJK UNIFIED IDEOGRAPH-584B
        0x5870, # G+4508  U+5870  uni5870,  CJK UNIFIED IDEOGRAPH-5870
        0x6BC0, # G+4509  U+6BC0  uni6BC0,  CJK UNIFIED IDEOGRAPH-6BC0
        0x5852, # G+4510  U+5852  uni5852,  CJK UNIFIED IDEOGRAPH-5852
        0x583D, # G+4511  U+583D  uni583D,  CJK UNIFIED IDEOGRAPH-583D
        0x5879, # G+4512  U+5879  uni5879,  CJK UNIFIED IDEOGRAPH-5879
        0x5885, # G+4513  U+5885  uni5885,  CJK UNIFIED IDEOGRAPH-5885
        0x58B9, # G+4514  U+58B9  uni58B9,  CJK UNIFIED IDEOGRAPH-58B9
        0x589F, # G+4515  U+589F  uni589F,  CJK UNIFIED IDEOGRAPH-589F
        0x58AB, # G+4516  U+58AB  uni58AB,  CJK UNIFIED IDEOGRAPH-58AB
        0x58BA, # G+4517  U+58BA  uni58BA,  CJK UNIFIED IDEOGRAPH-58BA
        0x58DE, # G+4518  U+58DE  uni58DE,  CJK UNIFIED IDEOGRAPH-58DE
        0x58BB, # G+4519  U+58BB  uni58BB,  CJK UNIFIED IDEOGRAPH-58BB
        0x58B8, # G+4520  U+58B8  uni58B8,  CJK UNIFIED IDEOGRAPH-58B8
        0x58AE, # G+4521  U+58AE  uni58AE,  CJK UNIFIED IDEOGRAPH-58AE
        0x58C5, # G+4522  U+58C5  uni58C5,  CJK UNIFIED IDEOGRAPH-58C5
        0x58D3, # G+4523  U+58D3  uni58D3,  CJK UNIFIED IDEOGRAPH-58D3
        0x58D1, # G+4524  U+58D1  uni58D1,  CJK UNIFIED IDEOGRAPH-58D1
        0x58D7, # G+4525  U+58D7  uni58D7,  CJK UNIFIED IDEOGRAPH-58D7
        0x58D9, # G+4526  U+58D9  uni58D9,  CJK UNIFIED IDEOGRAPH-58D9
        0x58D8, # G+4527  U+58D8  uni58D8,  CJK UNIFIED IDEOGRAPH-58D8
        0x58E5, # G+4528  U+58E5  uni58E5,  CJK UNIFIED IDEOGRAPH-58E5
        0x58DC, # G+4529  U+58DC  uni58DC,  CJK UNIFIED IDEOGRAPH-58DC
        0x58E4, # G+4530  U+58E4  uni58E4,  CJK UNIFIED IDEOGRAPH-58E4
        0x58DF, # G+4531  U+58DF  uni58DF,  CJK UNIFIED IDEOGRAPH-58DF
        0x58EF, # G+4532  U+58EF  uni58EF,  CJK UNIFIED IDEOGRAPH-58EF
        0x58FA, # G+4533  U+58FA  uni58FA,  CJK UNIFIED IDEOGRAPH-58FA
        0x58F9, # G+4534  U+58F9  uni58F9,  CJK UNIFIED IDEOGRAPH-58F9
        0x58FB, # G+4535  U+58FB  uni58FB,  CJK UNIFIED IDEOGRAPH-58FB
        0x58FC, # G+4536  U+58FC  uni58FC,  CJK UNIFIED IDEOGRAPH-58FC
        0x58FD, # G+4537  U+58FD  uni58FD,  CJK UNIFIED IDEOGRAPH-58FD
        0x2F21, # G+4538  U+2F21  uni2F21,  KANGXI RADICAL GO
        0x2F22, # G+4539  U+2F22  uni2F22,  KANGXI RADICAL GO SLOWLY
        0x5910, # G+4540  U+5910  uni5910,  CJK UNIFIED IDEOGRAPH-5910
        0x591B, # G+4541  U+591B  uni591B,  CJK UNIFIED IDEOGRAPH-591B
        0x68A6, # G+4542  U+68A6  uni68A6,  CJK UNIFIED IDEOGRAPH-68A6
        0x5925, # G+4543  U+5925  uni5925,  CJK UNIFIED IDEOGRAPH-5925
        0x592C, # G+4544  U+592C  uni592C,  CJK UNIFIED IDEOGRAPH-592C
        0x592D, # G+4545  U+592D  uni592D,  CJK UNIFIED IDEOGRAPH-592D
        0x5932, # G+4546  U+5932  uni5932,  CJK UNIFIED IDEOGRAPH-5932
        0x5938, # G+4547  U+5938  uni5938,  CJK UNIFIED IDEOGRAPH-5938
        0x593E, # G+4548  U+593E  uni593E,  CJK UNIFIED IDEOGRAPH-593E
        0x7AD2, # G+4549  U+7AD2  uni7AD2,  CJK UNIFIED IDEOGRAPH-7AD2
        0x5955, # G+4550  U+5955  uni5955,  CJK UNIFIED IDEOGRAPH-5955
        0x5950, # G+4551  U+5950  uni5950,  CJK UNIFIED IDEOGRAPH-5950
        0x594E, # G+4552  U+594E  uni594E,  CJK UNIFIED IDEOGRAPH-594E
        0x595A, # G+4553  U+595A  uni595A,  CJK UNIFIED IDEOGRAPH-595A
        0x5958, # G+4554  U+5958  uni5958,  CJK UNIFIED IDEOGRAPH-5958
        0x5962, # G+4555  U+5962  uni5962,  CJK UNIFIED IDEOGRAPH-5962
        0x5960, # G+4556  U+5960  uni5960,  CJK UNIFIED IDEOGRAPH-5960
        0x5967, # G+4557  U+5967  uni5967,  CJK UNIFIED IDEOGRAPH-5967
        0x596C, # G+4558  U+596C  uni596C,  CJK UNIFIED IDEOGRAPH-596C
        0x5969, # G+4559  U+5969  uni5969,  CJK UNIFIED IDEOGRAPH-5969
        0x5978, # G+4560  U+5978  uni5978,  CJK UNIFIED IDEOGRAPH-5978
        0x5981, # G+4561  U+5981  uni5981,  CJK UNIFIED IDEOGRAPH-5981
        0x599D, # G+4562  U+599D  uni599D,  CJK UNIFIED IDEOGRAPH-599D
        0x4F5E, # G+4563  U+4F5E  uni4F5E,  CJK UNIFIED IDEOGRAPH-4F5E
        0x4FAB, # G+4564  U+4FAB  uni4FAB,  CJK UNIFIED IDEOGRAPH-4FAB
        0x59A3, # G+4565  U+59A3  uni59A3,  CJK UNIFIED IDEOGRAPH-59A3
        0x59B2, # G+4566  U+59B2  uni59B2,  CJK UNIFIED IDEOGRAPH-59B2
        0x59C6, # G+4567  U+59C6  uni59C6,  CJK UNIFIED IDEOGRAPH-59C6
        0x59E8, # G+4568  U+59E8  uni59E8,  CJK UNIFIED IDEOGRAPH-59E8
        0x59DC, # G+4569  U+59DC  uni59DC,  CJK UNIFIED IDEOGRAPH-59DC
        0x598D, # G+4570  U+598D  uni598D,  CJK UNIFIED IDEOGRAPH-598D
        0x59D9, # G+4571  U+59D9  uni59D9,  CJK UNIFIED IDEOGRAPH-59D9
        0x59DA, # G+4572  U+59DA  uni59DA,  CJK UNIFIED IDEOGRAPH-59DA
        0x5A25, # G+4573  U+5A25  uni5A25,  CJK UNIFIED IDEOGRAPH-5A25
        0x5A1F, # G+4574  U+5A1F  uni5A1F,  CJK UNIFIED IDEOGRAPH-5A1F
        0x5A11, # G+4575  U+5A11  uni5A11,  CJK UNIFIED IDEOGRAPH-5A11
        0x5A1C, # G+4576  U+5A1C  uni5A1C,  CJK UNIFIED IDEOGRAPH-5A1C
        0x5A09, # G+4577  U+5A09  uni5A09,  CJK UNIFIED IDEOGRAPH-5A09
        0x5A1A, # G+4578  U+5A1A  uni5A1A,  CJK UNIFIED IDEOGRAPH-5A1A
        0x5A40, # G+4579  U+5A40  uni5A40,  CJK UNIFIED IDEOGRAPH-5A40
        0x5A6C, # G+4580  U+5A6C  uni5A6C,  CJK UNIFIED IDEOGRAPH-5A6C
        0x5A49, # G+4581  U+5A49  uni5A49,  CJK UNIFIED IDEOGRAPH-5A49
        0x5A35, # G+4582  U+5A35  uni5A35,  CJK UNIFIED IDEOGRAPH-5A35
        0x5A36, # G+4583  U+5A36  uni5A36,  CJK UNIFIED IDEOGRAPH-5A36
        0x5A62, # G+4584  U+5A62  uni5A62,  CJK UNIFIED IDEOGRAPH-5A62
        0x5A6A, # G+4585  U+5A6A  uni5A6A,  CJK UNIFIED IDEOGRAPH-5A6A
        0x5A9A, # G+4586  U+5A9A  uni5A9A,  CJK UNIFIED IDEOGRAPH-5A9A
        0x5ABC, # G+4587  U+5ABC  uni5ABC,  CJK UNIFIED IDEOGRAPH-5ABC
        0x5ABE, # G+4588  U+5ABE  uni5ABE,  CJK UNIFIED IDEOGRAPH-5ABE
        0x5ACB, # G+4589  U+5ACB  uni5ACB,  CJK UNIFIED IDEOGRAPH-5ACB
        0x5AC2, # G+4590  U+5AC2  uni5AC2,  CJK UNIFIED IDEOGRAPH-5AC2
        0x5ABD, # G+4591  U+5ABD  uni5ABD,  CJK UNIFIED IDEOGRAPH-5ABD
        0x5AE3, # G+4592  U+5AE3  uni5AE3,  CJK UNIFIED IDEOGRAPH-5AE3
        0x5AD7, # G+4593  U+5AD7  uni5AD7,  CJK UNIFIED IDEOGRAPH-5AD7
        0x5AE6, # G+4594  U+5AE6  uni5AE6,  CJK UNIFIED IDEOGRAPH-5AE6
        0x5AE9, # G+4595  U+5AE9  uni5AE9,  CJK UNIFIED IDEOGRAPH-5AE9
        0x5AD6, # G+4596  U+5AD6  uni5AD6,  CJK UNIFIED IDEOGRAPH-5AD6
        0x5AFA, # G+4597  U+5AFA  uni5AFA,  CJK UNIFIED IDEOGRAPH-5AFA
        0x5AFB, # G+4598  U+5AFB  uni5AFB,  CJK UNIFIED IDEOGRAPH-5AFB
        0x5B0C, # G+4599  U+5B0C  uni5B0C,  CJK UNIFIED IDEOGRAPH-5B0C
        0x5B0B, # G+4600  U+5B0B  uni5B0B,  CJK UNIFIED IDEOGRAPH-5B0B
        0x5B16, # G+4601  U+5B16  uni5B16,  CJK UNIFIED IDEOGRAPH-5B16
        0x5B32, # G+4602  U+5B32  uni5B32,  CJK UNIFIED IDEOGRAPH-5B32
        0x5AD0, # G+4603  U+5AD0  uni5AD0,  CJK UNIFIED IDEOGRAPH-5AD0
        0x5B2A, # G+4604  U+5B2A  uni5B2A,  CJK UNIFIED IDEOGRAPH-5B2A
        0x5B36, # G+4605  U+5B36  uni5B36,  CJK UNIFIED IDEOGRAPH-5B36
        0x5B3E, # G+4606  U+5B3E  uni5B3E,  CJK UNIFIED IDEOGRAPH-5B3E
        0x5B43, # G+4607  U+5B43  uni5B43,  CJK UNIFIED IDEOGRAPH-5B43
        0x5B45, # G+4608  U+5B45  uni5B45,  CJK UNIFIED IDEOGRAPH-5B45
        0x5B40, # G+4609  U+5B40  uni5B40,  CJK UNIFIED IDEOGRAPH-5B40
        0x5B51, # G+4610  U+5B51  uni5B51,  CJK UNIFIED IDEOGRAPH-5B51
        0x5B55, # G+4611  U+5B55  uni5B55,  CJK UNIFIED IDEOGRAPH-5B55
        0x5B5A, # G+4612  U+5B5A  uni5B5A,  CJK UNIFIED IDEOGRAPH-5B5A
        0x5B5B, # G+4613  U+5B5B  uni5B5B,  CJK UNIFIED IDEOGRAPH-5B5B
        0x5B65, # G+4614  U+5B65  uni5B65,  CJK UNIFIED IDEOGRAPH-5B65
        0x5B69, # G+4615  U+5B69  uni5B69,  CJK UNIFIED IDEOGRAPH-5B69
        0x5B70, # G+4616  U+5B70  uni5B70,  CJK UNIFIED IDEOGRAPH-5B70
        0x5B73, # G+4617  U+5B73  uni5B73,  CJK UNIFIED IDEOGRAPH-5B73
        0x5B75, # G+4618  U+5B75  uni5B75,  CJK UNIFIED IDEOGRAPH-5B75
        0x5B78, # G+4619  U+5B78  uni5B78,  CJK UNIFIED IDEOGRAPH-5B78
        0x6588, # G+4620  U+6588  uni6588,  CJK UNIFIED IDEOGRAPH-6588
        0x5B7A, # G+4621  U+5B7A  uni5B7A,  CJK UNIFIED IDEOGRAPH-5B7A
        0x2F27, # G+4622  U+2F27  uni2F27,  KANGXI RADICAL ROOF
        0x5B83, # G+4623  U+5B83  uni5B83,  CJK UNIFIED IDEOGRAPH-5B83
        0x5BA6, # G+4624  U+5BA6  uni5BA6,  CJK UNIFIED IDEOGRAPH-5BA6
        0x5BB8, # G+4625  U+5BB8  uni5BB8,  CJK UNIFIED IDEOGRAPH-5BB8
        0x5BC3, # G+4626  U+5BC3  uni5BC3,  CJK UNIFIED IDEOGRAPH-5BC3
        0x5BC7, # G+4627  U+5BC7  uni5BC7,  CJK UNIFIED IDEOGRAPH-5BC7
        0x5BC9, # G+4628  U+5BC9  uni5BC9,  CJK UNIFIED IDEOGRAPH-5BC9
        0x5BD4, # G+4629  U+5BD4  uni5BD4,  CJK UNIFIED IDEOGRAPH-5BD4
        0x5BD0, # G+4630  U+5BD0  uni5BD0,  CJK UNIFIED IDEOGRAPH-5BD0
        0x5BE4, # G+4631  U+5BE4  uni5BE4,  CJK UNIFIED IDEOGRAPH-5BE4
        0x5BE6, # G+4632  U+5BE6  uni5BE6,  CJK UNIFIED IDEOGRAPH-5BE6
        0x5BE2, # G+4633  U+5BE2  uni5BE2,  CJK UNIFIED IDEOGRAPH-5BE2
        0x5BDE, # G+4634  U+5BDE  uni5BDE,  CJK UNIFIED IDEOGRAPH-5BDE
        0x5BE5, # G+4635  U+5BE5  uni5BE5,  CJK UNIFIED IDEOGRAPH-5BE5
        0x5BEB, # G+4636  U+5BEB  uni5BEB,  CJK UNIFIED IDEOGRAPH-5BEB
        0x5BF0, # G+4637  U+5BF0  uni5BF0,  CJK UNIFIED IDEOGRAPH-5BF0
        0x5BF6, # G+4638  U+5BF6  uni5BF6,  CJK UNIFIED IDEOGRAPH-5BF6
        0x5BF3, # G+4639  U+5BF3  uni5BF3,  CJK UNIFIED IDEOGRAPH-5BF3
        0x5C05, # G+4640  U+5C05  uni5C05,  CJK UNIFIED IDEOGRAPH-5C05
        0x5C07, # G+4641  U+5C07  uni5C07,  CJK UNIFIED IDEOGRAPH-5C07
        0x5C08, # G+4642  U+5C08  uni5C08,  CJK UNIFIED IDEOGRAPH-5C08
        0x5C0D, # G+4643  U+5C0D  uni5C0D,  CJK UNIFIED IDEOGRAPH-5C0D
        0x5C13, # G+4644  U+5C13  uni5C13,  CJK UNIFIED IDEOGRAPH-5C13
        0x5C20, # G+4645  U+5C20  uni5C20,  CJK UNIFIED IDEOGRAPH-5C20
        0x2E90, # G+4646  U+2E90  uni2E90,  CJK RADICAL LAME THREE
        0x5C28, # G+4647  U+5C28  uni5C28,  CJK UNIFIED IDEOGRAPH-5C28
        0x2F2B, # G+4648  U+2F2B  uni2F2B,  KANGXI RADICAL CORPSE
        0x5C39, # G+4649  U+5C39  uni5C39,  CJK UNIFIED IDEOGRAPH-5C39
        0x5C41, # G+4650  U+5C41  uni5C41,  CJK UNIFIED IDEOGRAPH-5C41
        0x5C46, # G+4651  U+5C46  uni5C46,  CJK UNIFIED IDEOGRAPH-5C46
        0x5C4E, # G+4652  U+5C4E  uni5C4E,  CJK UNIFIED IDEOGRAPH-5C4E
        0x5C53, # G+4653  U+5C53  uni5C53,  CJK UNIFIED IDEOGRAPH-5C53
        0x5C50, # G+4654  U+5C50  uni5C50,  CJK UNIFIED IDEOGRAPH-5C50
        0x5C4F, # G+4655  U+5C4F  uni5C4F,  CJK UNIFIED IDEOGRAPH-5C4F
        0x5B71, # G+4656  U+5B71  uni5B71,  CJK UNIFIED IDEOGRAPH-5B71
        0x5C6C, # G+4657  U+5C6C  uni5C6C,  CJK UNIFIED IDEOGRAPH-5C6C
        0x2F2C, # G+4658  U+2F2C  uni2F2C,  KANGXI RADICAL SPROUT
        0x4E62, # G+4659  U+4E62  uni4E62,  CJK UNIFIED IDEOGRAPH-4E62
        0x5C76, # G+4660  U+5C76  uni5C76,  CJK UNIFIED IDEOGRAPH-5C76
        0x5C79, # G+4661  U+5C79  uni5C79,  CJK UNIFIED IDEOGRAPH-5C79
        0x5C8C, # G+4662  U+5C8C  uni5C8C,  CJK UNIFIED IDEOGRAPH-5C8C
        0x5C91, # G+4663  U+5C91  uni5C91,  CJK UNIFIED IDEOGRAPH-5C91
        0x5C94, # G+4664  U+5C94  uni5C94,  CJK UNIFIED IDEOGRAPH-5C94
        0x599B, # G+4665  U+599B  uni599B,  CJK UNIFIED IDEOGRAPH-599B
        0x5CAB, # G+4666  U+5CAB  uni5CAB,  CJK UNIFIED IDEOGRAPH-5CAB
        0x5CBB, # G+4667  U+5CBB  uni5CBB,  CJK UNIFIED IDEOGRAPH-5CBB
        0x5CB6, # G+4668  U+5CB6  uni5CB6,  CJK UNIFIED IDEOGRAPH-5CB6
        0x5CBC, # G+4669  U+5CBC  uni5CBC,  CJK UNIFIED IDEOGRAPH-5CBC
        0x5CB7, # G+4670  U+5CB7  uni5CB7,  CJK UNIFIED IDEOGRAPH-5CB7
        0x5CC5, # G+4671  U+5CC5  uni5CC5,  CJK UNIFIED IDEOGRAPH-5CC5
        0x5CBE, # G+4672  U+5CBE  uni5CBE,  CJK UNIFIED IDEOGRAPH-5CBE
        0x5CC7, # G+4673  U+5CC7  uni5CC7,  CJK UNIFIED IDEOGRAPH-5CC7
        0x5CD9, # G+4674  U+5CD9  uni5CD9,  CJK UNIFIED IDEOGRAPH-5CD9
        0x5CE9, # G+4675  U+5CE9  uni5CE9,  CJK UNIFIED IDEOGRAPH-5CE9
        0x5CFD, # G+4676  U+5CFD  uni5CFD,  CJK UNIFIED IDEOGRAPH-5CFD
        0x5CFA, # G+4677  U+5CFA  uni5CFA,  CJK UNIFIED IDEOGRAPH-5CFA
        0x5CED, # G+4678  U+5CED  uni5CED,  CJK UNIFIED IDEOGRAPH-5CED
        0x5D8C, # G+4679  U+5D8C  uni5D8C,  CJK UNIFIED IDEOGRAPH-5D8C
        0x5CEA, # G+4680  U+5CEA  uni5CEA,  CJK UNIFIED IDEOGRAPH-5CEA
        0x5D0B, # G+4681  U+5D0B  uni5D0B,  CJK UNIFIED IDEOGRAPH-5D0B
        0x5D15, # G+4682  U+5D15  uni5D15,  CJK UNIFIED IDEOGRAPH-5D15
        0x5D17, # G+4683  U+5D17  uni5D17,  CJK UNIFIED IDEOGRAPH-5D17
        0x5D5C, # G+4684  U+5D5C  uni5D5C,  CJK UNIFIED IDEOGRAPH-5D5C
        0x5D1F, # G+4685  U+5D1F  uni5D1F,  CJK UNIFIED IDEOGRAPH-5D1F
        0x5D1B, # G+4686  U+5D1B  uni5D1B,  CJK UNIFIED IDEOGRAPH-5D1B
        0x5D11, # G+4687  U+5D11  uni5D11,  CJK UNIFIED IDEOGRAPH-5D11
        0x5D14, # G+4688  U+5D14  uni5D14,  CJK UNIFIED IDEOGRAPH-5D14
        0x5D22, # G+4689  U+5D22  uni5D22,  CJK UNIFIED IDEOGRAPH-5D22
        0x5D1A, # G+4690  U+5D1A  uni5D1A,  CJK UNIFIED IDEOGRAPH-5D1A
        0x5D19, # G+4691  U+5D19  uni5D19,  CJK UNIFIED IDEOGRAPH-5D19
        0x5D18, # G+4692  U+5D18  uni5D18,  CJK UNIFIED IDEOGRAPH-5D18
        0x5D4C, # G+4693  U+5D4C  uni5D4C,  CJK UNIFIED IDEOGRAPH-5D4C
        0x5D52, # G+4694  U+5D52  uni5D52,  CJK UNIFIED IDEOGRAPH-5D52
        0x5D4E, # G+4695  U+5D4E  uni5D4E,  CJK UNIFIED IDEOGRAPH-5D4E
        0x5D4B, # G+4696  U+5D4B  uni5D4B,  CJK UNIFIED IDEOGRAPH-5D4B
        0x5D6C, # G+4697  U+5D6C  uni5D6C,  CJK UNIFIED IDEOGRAPH-5D6C
        0x5D73, # G+4698  U+5D73  uni5D73,  CJK UNIFIED IDEOGRAPH-5D73
        0x5D76, # G+4699  U+5D76  uni5D76,  CJK UNIFIED IDEOGRAPH-5D76
        0x5D87, # G+4700  U+5D87  uni5D87,  CJK UNIFIED IDEOGRAPH-5D87
        0x5D84, # G+4701  U+5D84  uni5D84,  CJK UNIFIED IDEOGRAPH-5D84
        0x5D82, # G+4702  U+5D82  uni5D82,  CJK UNIFIED IDEOGRAPH-5D82
        0x5DA2, # G+4703  U+5DA2  uni5DA2,  CJK UNIFIED IDEOGRAPH-5DA2
        0x5D9D, # G+4704  U+5D9D  uni5D9D,  CJK UNIFIED IDEOGRAPH-5D9D
        0x5DAC, # G+4705  U+5DAC  uni5DAC,  CJK UNIFIED IDEOGRAPH-5DAC
        0x5DAE, # G+4706  U+5DAE  uni5DAE,  CJK UNIFIED IDEOGRAPH-5DAE
        0x5DBD, # G+4707  U+5DBD  uni5DBD,  CJK UNIFIED IDEOGRAPH-5DBD
        0x5D90, # G+4708  U+5D90  uni5D90,  CJK UNIFIED IDEOGRAPH-5D90
        0x5DB7, # G+4709  U+5DB7  uni5DB7,  CJK UNIFIED IDEOGRAPH-5DB7
        0x5DBC, # G+4710  U+5DBC  uni5DBC,  CJK UNIFIED IDEOGRAPH-5DBC
        0x5DC9, # G+4711  U+5DC9  uni5DC9,  CJK UNIFIED IDEOGRAPH-5DC9
        0x5DCD, # G+4712  U+5DCD  uni5DCD,  CJK UNIFIED IDEOGRAPH-5DCD
        0x5DD3, # G+4713  U+5DD3  uni5DD3,  CJK UNIFIED IDEOGRAPH-5DD3
        0x5DD2, # G+4714  U+5DD2  uni5DD2,  CJK UNIFIED IDEOGRAPH-5DD2
        0x5DD6, # G+4715  U+5DD6  uni5DD6,  CJK UNIFIED IDEOGRAPH-5DD6
        0x2F2E, # G+4716  U+2F2E  uni2F2E,  KANGXI RADICAL RIVER
        0x5DEB, # G+4717  U+5DEB  uni5DEB,  CJK UNIFIED IDEOGRAPH-5DEB
        0x5DF2, # G+4718  U+5DF2  uni5DF2,  CJK UNIFIED IDEOGRAPH-5DF2
        0x5DF5, # G+4719  U+5DF5  uni5DF5,  CJK UNIFIED IDEOGRAPH-5DF5
        0x5E0B, # G+4720  U+5E0B  uni5E0B,  CJK UNIFIED IDEOGRAPH-5E0B
        0x5E1A, # G+4721  U+5E1A  uni5E1A,  CJK UNIFIED IDEOGRAPH-5E1A
        0x5E19, # G+4722  U+5E19  uni5E19,  CJK UNIFIED IDEOGRAPH-5E19
        0x5E11, # G+4723  U+5E11  uni5E11,  CJK UNIFIED IDEOGRAPH-5E11
        0x5E1B, # G+4724  U+5E1B  uni5E1B,  CJK UNIFIED IDEOGRAPH-5E1B
        0x5E36, # G+4725  U+5E36  uni5E36,  CJK UNIFIED IDEOGRAPH-5E36
        0x5E37, # G+4726  U+5E37  uni5E37,  CJK UNIFIED IDEOGRAPH-5E37
        0x5E44, # G+4727  U+5E44  uni5E44,  CJK UNIFIED IDEOGRAPH-5E44
        0x5E43, # G+4728  U+5E43  uni5E43,  CJK UNIFIED IDEOGRAPH-5E43
        0x5E40, # G+4729  U+5E40  uni5E40,  CJK UNIFIED IDEOGRAPH-5E40
        0x5E4E, # G+4730  U+5E4E  uni5E4E,  CJK UNIFIED IDEOGRAPH-5E4E
        0x5E57, # G+4731  U+5E57  uni5E57,  CJK UNIFIED IDEOGRAPH-5E57
        0x5E54, # G+4732  U+5E54  uni5E54,  CJK UNIFIED IDEOGRAPH-5E54
        0x5E5F, # G+4733  U+5E5F  uni5E5F,  CJK UNIFIED IDEOGRAPH-5E5F
        0x5E62, # G+4734  U+5E62  uni5E62,  CJK UNIFIED IDEOGRAPH-5E62
        0x5E64, # G+4735  U+5E64  uni5E64,  CJK UNIFIED IDEOGRAPH-5E64
        0x5E47, # G+4736  U+5E47  uni5E47,  CJK UNIFIED IDEOGRAPH-5E47
        0x5E75, # G+4737  U+5E75  uni5E75,  CJK UNIFIED IDEOGRAPH-5E75
        0x5E76, # G+4738  U+5E76  uni5E76,  CJK UNIFIED IDEOGRAPH-5E76
        0x2E93, # G+4739  U+2E93  uni2E93,  CJK RADICAL THREAD
        0x9EBC, # G+4740  U+9EBC  uni9EBC,  CJK UNIFIED IDEOGRAPH-9EBC
        0x2F34, # G+4741  U+2F34  uni2F34,  KANGXI RADICAL DOTTED CLIFF
        0x5EA0, # G+4742  U+5EA0  uni5EA0,  CJK UNIFIED IDEOGRAPH-5EA0
        0x5EC1, # G+4743  U+5EC1  uni5EC1,  CJK UNIFIED IDEOGRAPH-5EC1
        0x5EC2, # G+4744  U+5EC2  uni5EC2,  CJK UNIFIED IDEOGRAPH-5EC2
        0x5EC8, # G+4745  U+5EC8  uni5EC8,  CJK UNIFIED IDEOGRAPH-5EC8
        0x5ED0, # G+4746  U+5ED0  uni5ED0,  CJK UNIFIED IDEOGRAPH-5ED0
        0x5ECF, # G+4747  U+5ECF  uni5ECF,  CJK UNIFIED IDEOGRAPH-5ECF
        0x5ED6, # G+4748  U+5ED6  uni5ED6,  CJK UNIFIED IDEOGRAPH-5ED6
        0x5EE3, # G+4749  U+5EE3  uni5EE3,  CJK UNIFIED IDEOGRAPH-5EE3
        0x5EDD, # G+4750  U+5EDD  uni5EDD,  CJK UNIFIED IDEOGRAPH-5EDD
        0x5EDA, # G+4751  U+5EDA  uni5EDA,  CJK UNIFIED IDEOGRAPH-5EDA
        0x5EDB, # G+4752  U+5EDB  uni5EDB,  CJK UNIFIED IDEOGRAPH-5EDB
        0x5EE2, # G+4753  U+5EE2  uni5EE2,  CJK UNIFIED IDEOGRAPH-5EE2
        0x5EE1, # G+4754  U+5EE1  uni5EE1,  CJK UNIFIED IDEOGRAPH-5EE1
        0x5EE8, # G+4755  U+5EE8  uni5EE8,  CJK UNIFIED IDEOGRAPH-5EE8
        0x5EE9, # G+4756  U+5EE9  uni5EE9,  CJK UNIFIED IDEOGRAPH-5EE9
        0x5EEC, # G+4757  U+5EEC  uni5EEC,  CJK UNIFIED IDEOGRAPH-5EEC
        0x5EF1, # G+4758  U+5EF1  uni5EF1,  CJK UNIFIED IDEOGRAPH-5EF1
        0x5EF3, # G+4759  U+5EF3  uni5EF3,  CJK UNIFIED IDEOGRAPH-5EF3
        0x5EF0, # G+4760  U+5EF0  uni5EF0,  CJK UNIFIED IDEOGRAPH-5EF0
        0x2F35, # G+4761  U+2F35  uni2F35,  KANGXI RADICAL LONG STRIDE
        0x5EF8, # G+4762  U+5EF8  uni5EF8,  CJK UNIFIED IDEOGRAPH-5EF8
        0x2F36, # G+4763  U+2F36  uni2F36,  KANGXI RADICAL TWO HANDS
        0x5F03, # G+4764  U+5F03  uni5F03,  CJK UNIFIED IDEOGRAPH-5F03
        0x5F09, # G+4765  U+5F09  uni5F09,  CJK UNIFIED IDEOGRAPH-5F09
        0x5F5D, # G+4766  U+5F5D  uni5F5D,  CJK UNIFIED IDEOGRAPH-5F5D
        0x5F5C, # G+4767  U+5F5C  uni5F5C,  CJK UNIFIED IDEOGRAPH-5F5C
        0x2F37, # G+4768  U+2F37  uni2F37,  KANGXI RADICAL SHOOT
        0x5F11, # G+4769  U+5F11  uni5F11,  CJK UNIFIED IDEOGRAPH-5F11
        0x5F16, # G+4770  U+5F16  uni5F16,  CJK UNIFIED IDEOGRAPH-5F16
        0x5F29, # G+4771  U+5F29  uni5F29,  CJK UNIFIED IDEOGRAPH-5F29
        0x5F2D, # G+4772  U+5F2D  uni5F2D,  CJK UNIFIED IDEOGRAPH-5F2D
        0x5F38, # G+4773  U+5F38  uni5F38,  CJK UNIFIED IDEOGRAPH-5F38
        0x5F41, # G+4774  U+5F41  uni5F41,  CJK UNIFIED IDEOGRAPH-5F41
        0x5F48, # G+4775  U+5F48  uni5F48,  CJK UNIFIED IDEOGRAPH-5F48
        0x5F4C, # G+4776  U+5F4C  uni5F4C,  CJK UNIFIED IDEOGRAPH-5F4C
        0x5F4E, # G+4777  U+5F4E  uni5F4E,  CJK UNIFIED IDEOGRAPH-5F4E
        0x5F2F, # G+4778  U+5F2F  uni5F2F,  CJK UNIFIED IDEOGRAPH-5F2F
        0x2E94, # G+4779  U+2E94  uni2E94,  CJK RADICAL SNOUT ONE
        0x5F56, # G+4780  U+5F56  uni5F56,  CJK UNIFIED IDEOGRAPH-5F56
        0x5F57, # G+4781  U+5F57  uni5F57,  CJK UNIFIED IDEOGRAPH-5F57
        0x5F59, # G+4782  U+5F59  uni5F59,  CJK UNIFIED IDEOGRAPH-5F59
        0x2F3A, # G+4783  U+2F3A  uni2F3A,  KANGXI RADICAL BRISTLE
        0x5F6D, # G+4784  U+5F6D  uni5F6D,  CJK UNIFIED IDEOGRAPH-5F6D
        0x2F3B, # G+4785  U+2F3B  uni2F3B,  KANGXI RADICAL STEP
        0x5F77, # G+4786  U+5F77  uni5F77,  CJK UNIFIED IDEOGRAPH-5F77
        0x5F83, # G+4787  U+5F83  uni5F83,  CJK UNIFIED IDEOGRAPH-5F83
        0x5F82, # G+4788  U+5F82  uni5F82,  CJK UNIFIED IDEOGRAPH-5F82
        0x5F7F, # G+4789  U+5F7F  uni5F7F,  CJK UNIFIED IDEOGRAPH-5F7F
        0x5F8A, # G+4790  U+5F8A  uni5F8A,  CJK UNIFIED IDEOGRAPH-5F8A
        0x5F88, # G+4791  U+5F88  uni5F88,  CJK UNIFIED IDEOGRAPH-5F88
        0x5F91, # G+4792  U+5F91  uni5F91,  CJK UNIFIED IDEOGRAPH-5F91
        0x5F87, # G+4793  U+5F87  uni5F87,  CJK UNIFIED IDEOGRAPH-5F87
        0x5F9E, # G+4794  U+5F9E  uni5F9E,  CJK UNIFIED IDEOGRAPH-5F9E
        0x5F99, # G+4795  U+5F99  uni5F99,  CJK UNIFIED IDEOGRAPH-5F99
        0x5F98, # G+4796  U+5F98  uni5F98,  CJK UNIFIED IDEOGRAPH-5F98
        0x5FA0, # G+4797  U+5FA0  uni5FA0,  CJK UNIFIED IDEOGRAPH-5FA0
        0x5FA8, # G+4798  U+5FA8  uni5FA8,  CJK UNIFIED IDEOGRAPH-5FA8
        0x5FAD, # G+4799  U+5FAD  uni5FAD,  CJK UNIFIED IDEOGRAPH-5FAD
        0x5FBC, # G+4800  U+5FBC  uni5FBC,  CJK UNIFIED IDEOGRAPH-5FBC
        0x5FD6, # G+4801  U+5FD6  uni5FD6,  CJK UNIFIED IDEOGRAPH-5FD6
        0x5FFB, # G+4802  U+5FFB  uni5FFB,  CJK UNIFIED IDEOGRAPH-5FFB
        0x5FE4, # G+4803  U+5FE4  uni5FE4,  CJK UNIFIED IDEOGRAPH-5FE4
        0x5FF8, # G+4804  U+5FF8  uni5FF8,  CJK UNIFIED IDEOGRAPH-5FF8
        0x5FF1, # G+4805  U+5FF1  uni5FF1,  CJK UNIFIED IDEOGRAPH-5FF1
        0x5FDD, # G+4806  U+5FDD  uni5FDD,  CJK UNIFIED IDEOGRAPH-5FDD
        0x60B3, # G+4807  U+60B3  uni60B3,  CJK UNIFIED IDEOGRAPH-60B3
        0x5FFF, # G+4808  U+5FFF  uni5FFF,  CJK UNIFIED IDEOGRAPH-5FFF
        0x6021, # G+4809  U+6021  uni6021,  CJK UNIFIED IDEOGRAPH-6021
        0x6060, # G+4810  U+6060  uni6060,  CJK UNIFIED IDEOGRAPH-6060
        0x6019, # G+4811  U+6019  uni6019,  CJK UNIFIED IDEOGRAPH-6019
        0x6010, # G+4812  U+6010  uni6010,  CJK UNIFIED IDEOGRAPH-6010
        0x6029, # G+4813  U+6029  uni6029,  CJK UNIFIED IDEOGRAPH-6029
        0x600E, # G+4814  U+600E  uni600E,  CJK UNIFIED IDEOGRAPH-600E
        0x6031, # G+4815  U+6031  uni6031,  CJK UNIFIED IDEOGRAPH-6031
        0x601B, # G+4816  U+601B  uni601B,  CJK UNIFIED IDEOGRAPH-601B
        0x6015, # G+4817  U+6015  uni6015,  CJK UNIFIED IDEOGRAPH-6015
        0x602B, # G+4818  U+602B  uni602B,  CJK UNIFIED IDEOGRAPH-602B
        0x6026, # G+4819  U+6026  uni6026,  CJK UNIFIED IDEOGRAPH-6026
        0x600F, # G+4820  U+600F  uni600F,  CJK UNIFIED IDEOGRAPH-600F
        0x603A, # G+4821  U+603A  uni603A,  CJK UNIFIED IDEOGRAPH-603A
        0x605A, # G+4822  U+605A  uni605A,  CJK UNIFIED IDEOGRAPH-605A
        0x6041, # G+4823  U+6041  uni6041,  CJK UNIFIED IDEOGRAPH-6041
        0x606A, # G+4824  U+606A  uni606A,  CJK UNIFIED IDEOGRAPH-606A
        0x6077, # G+4825  U+6077  uni6077,  CJK UNIFIED IDEOGRAPH-6077
        0x605F, # G+4826  U+605F  uni605F,  CJK UNIFIED IDEOGRAPH-605F
        0x604A, # G+4827  U+604A  uni604A,  CJK UNIFIED IDEOGRAPH-604A
        0x6046, # G+4828  U+6046  uni6046,  CJK UNIFIED IDEOGRAPH-6046
        0x604D, # G+4829  U+604D  uni604D,  CJK UNIFIED IDEOGRAPH-604D
        0x6063, # G+4830  U+6063  uni6063,  CJK UNIFIED IDEOGRAPH-6063
        0x6043, # G+4831  U+6043  uni6043,  CJK UNIFIED IDEOGRAPH-6043
        0x6064, # G+4832  U+6064  uni6064,  CJK UNIFIED IDEOGRAPH-6064
        0x6042, # G+4833  U+6042  uni6042,  CJK UNIFIED IDEOGRAPH-6042
        0x606C, # G+4834  U+606C  uni606C,  CJK UNIFIED IDEOGRAPH-606C
        0x606B, # G+4835  U+606B  uni606B,  CJK UNIFIED IDEOGRAPH-606B
        0x6059, # G+4836  U+6059  uni6059,  CJK UNIFIED IDEOGRAPH-6059
        0x6081, # G+4837  U+6081  uni6081,  CJK UNIFIED IDEOGRAPH-6081
        0x608D, # G+4838  U+608D  uni608D,  CJK UNIFIED IDEOGRAPH-608D
        0x60E7, # G+4839  U+60E7  uni60E7,  CJK UNIFIED IDEOGRAPH-60E7
        0x6083, # G+4840  U+6083  uni6083,  CJK UNIFIED IDEOGRAPH-6083
        0x609A, # G+4841  U+609A  uni609A,  CJK UNIFIED IDEOGRAPH-609A
        0x6084, # G+4842  U+6084  uni6084,  CJK UNIFIED IDEOGRAPH-6084
        0x609B, # G+4843  U+609B  uni609B,  CJK UNIFIED IDEOGRAPH-609B
        0x6096, # G+4844  U+6096  uni6096,  CJK UNIFIED IDEOGRAPH-6096
        0x6097, # G+4845  U+6097  uni6097,  CJK UNIFIED IDEOGRAPH-6097
        0x6092, # G+4846  U+6092  uni6092,  CJK UNIFIED IDEOGRAPH-6092
        0x60A7, # G+4847  U+60A7  uni60A7,  CJK UNIFIED IDEOGRAPH-60A7
        0x608B, # G+4848  U+608B  uni608B,  CJK UNIFIED IDEOGRAPH-608B
        0x60E1, # G+4849  U+60E1  uni60E1,  CJK UNIFIED IDEOGRAPH-60E1
        0x60B8, # G+4850  U+60B8  uni60B8,  CJK UNIFIED IDEOGRAPH-60B8
        0x60E0, # G+4851  U+60E0  uni60E0,  CJK UNIFIED IDEOGRAPH-60E0
        0x60D3, # G+4852  U+60D3  uni60D3,  CJK UNIFIED IDEOGRAPH-60D3
        0x60B4, # G+4853  U+60B4  uni60B4,  CJK UNIFIED IDEOGRAPH-60B4
        0x5FF0, # G+4854  U+5FF0  uni5FF0,  CJK UNIFIED IDEOGRAPH-5FF0
        0x60BD, # G+4855  U+60BD  uni60BD,  CJK UNIFIED IDEOGRAPH-60BD
        0x60C6, # G+4856  U+60C6  uni60C6,  CJK UNIFIED IDEOGRAPH-60C6
        0x60B5, # G+4857  U+60B5  uni60B5,  CJK UNIFIED IDEOGRAPH-60B5
        0x60D8, # G+4858  U+60D8  uni60D8,  CJK UNIFIED IDEOGRAPH-60D8
        0x614D, # G+4859  U+614D  uni614D,  CJK UNIFIED IDEOGRAPH-614D
        0x6115, # G+4860  U+6115  uni6115,  CJK UNIFIED IDEOGRAPH-6115
        0x6106, # G+4861  U+6106  uni6106,  CJK UNIFIED IDEOGRAPH-6106
        0x60F6, # G+4862  U+60F6  uni60F6,  CJK UNIFIED IDEOGRAPH-60F6
        0x60F7, # G+4863  U+60F7  uni60F7,  CJK UNIFIED IDEOGRAPH-60F7
        0x6100, # G+4864  U+6100  uni6100,  CJK UNIFIED IDEOGRAPH-6100
        0x60F4, # G+4865  U+60F4  uni60F4,  CJK UNIFIED IDEOGRAPH-60F4
        0x60FA, # G+4866  U+60FA  uni60FA,  CJK UNIFIED IDEOGRAPH-60FA
        0x6103, # G+4867  U+6103  uni6103,  CJK UNIFIED IDEOGRAPH-6103
        0x6121, # G+4868  U+6121  uni6121,  CJK UNIFIED IDEOGRAPH-6121
        0x60FB, # G+4869  U+60FB  uni60FB,  CJK UNIFIED IDEOGRAPH-60FB
        0x60F1, # G+4870  U+60F1  uni60F1,  CJK UNIFIED IDEOGRAPH-60F1
        0x610D, # G+4871  U+610D  uni610D,  CJK UNIFIED IDEOGRAPH-610D
        0x610E, # G+4872  U+610E  uni610E,  CJK UNIFIED IDEOGRAPH-610E
        0x6147, # G+4873  U+6147  uni6147,  CJK UNIFIED IDEOGRAPH-6147
        0x613E, # G+4874  U+613E  uni613E,  CJK UNIFIED IDEOGRAPH-613E
        0x6128, # G+4875  U+6128  uni6128,  CJK UNIFIED IDEOGRAPH-6128
        0x6127, # G+4876  U+6127  uni6127,  CJK UNIFIED IDEOGRAPH-6127
        0x614A, # G+4877  U+614A  uni614A,  CJK UNIFIED IDEOGRAPH-614A
        0x613F, # G+4878  U+613F  uni613F,  CJK UNIFIED IDEOGRAPH-613F
        0x613C, # G+4879  U+613C  uni613C,  CJK UNIFIED IDEOGRAPH-613C
        0x612C, # G+4880  U+612C  uni612C,  CJK UNIFIED IDEOGRAPH-612C
        0x6134, # G+4881  U+6134  uni6134,  CJK UNIFIED IDEOGRAPH-6134
        0x613D, # G+4882  U+613D  uni613D,  CJK UNIFIED IDEOGRAPH-613D
        0x6142, # G+4883  U+6142  uni6142,  CJK UNIFIED IDEOGRAPH-6142
        0x6144, # G+4884  U+6144  uni6144,  CJK UNIFIED IDEOGRAPH-6144
        0x6173, # G+4885  U+6173  uni6173,  CJK UNIFIED IDEOGRAPH-6173
        0x6177, # G+4886  U+6177  uni6177,  CJK UNIFIED IDEOGRAPH-6177
        0x6158, # G+4887  U+6158  uni6158,  CJK UNIFIED IDEOGRAPH-6158
        0x6159, # G+4888  U+6159  uni6159,  CJK UNIFIED IDEOGRAPH-6159
        0x615A, # G+4889  U+615A  uni615A,  CJK UNIFIED IDEOGRAPH-615A
        0x616B, # G+4890  U+616B  uni616B,  CJK UNIFIED IDEOGRAPH-616B
        0x6174, # G+4891  U+6174  uni6174,  CJK UNIFIED IDEOGRAPH-6174
        0x616F, # G+4892  U+616F  uni616F,  CJK UNIFIED IDEOGRAPH-616F
        0x6165, # G+4893  U+6165  uni6165,  CJK UNIFIED IDEOGRAPH-6165
        0x6171, # G+4894  U+6171  uni6171,  CJK UNIFIED IDEOGRAPH-6171
        0x615F, # G+4895  U+615F  uni615F,  CJK UNIFIED IDEOGRAPH-615F
        0x615D, # G+4896  U+615D  uni615D,  CJK UNIFIED IDEOGRAPH-615D
        0x6153, # G+4897  U+6153  uni6153,  CJK UNIFIED IDEOGRAPH-6153
        0x6175, # G+4898  U+6175  uni6175,  CJK UNIFIED IDEOGRAPH-6175
        0x6199, # G+4899  U+6199  uni6199,  CJK UNIFIED IDEOGRAPH-6199
        0x6196, # G+4900  U+6196  uni6196,  CJK UNIFIED IDEOGRAPH-6196
        0x6187, # G+4901  U+6187  uni6187,  CJK UNIFIED IDEOGRAPH-6187
        0x61AC, # G+4902  U+61AC  uni61AC,  CJK UNIFIED IDEOGRAPH-61AC
        0x6194, # G+4903  U+6194  uni6194,  CJK UNIFIED IDEOGRAPH-6194
        0x619A, # G+4904  U+619A  uni619A,  CJK UNIFIED IDEOGRAPH-619A
        0x618A, # G+4905  U+618A  uni618A,  CJK UNIFIED IDEOGRAPH-618A
        0x6191, # G+4906  U+6191  uni6191,  CJK UNIFIED IDEOGRAPH-6191
        0x61AB, # G+4907  U+61AB  uni61AB,  CJK UNIFIED IDEOGRAPH-61AB
        0x61AE, # G+4908  U+61AE  uni61AE,  CJK UNIFIED IDEOGRAPH-61AE
        0x61CC, # G+4909  U+61CC  uni61CC,  CJK UNIFIED IDEOGRAPH-61CC
        0x61CA, # G+4910  U+61CA  uni61CA,  CJK UNIFIED IDEOGRAPH-61CA
        0x61C9, # G+4911  U+61C9  uni61C9,  CJK UNIFIED IDEOGRAPH-61C9
        0x61F7, # G+4912  U+61F7  uni61F7,  CJK UNIFIED IDEOGRAPH-61F7
        0x61C8, # G+4913  U+61C8  uni61C8,  CJK UNIFIED IDEOGRAPH-61C8
        0x61C3, # G+4914  U+61C3  uni61C3,  CJK UNIFIED IDEOGRAPH-61C3
        0x61C6, # G+4915  U+61C6  uni61C6,  CJK UNIFIED IDEOGRAPH-61C6
        0x61BA, # G+4916  U+61BA  uni61BA,  CJK UNIFIED IDEOGRAPH-61BA
        0x61CB, # G+4917  U+61CB  uni61CB,  CJK UNIFIED IDEOGRAPH-61CB
        0x7F79, # G+4918  U+7F79  uni7F79,  CJK UNIFIED IDEOGRAPH-7F79
        0x61CD, # G+4919  U+61CD  uni61CD,  CJK UNIFIED IDEOGRAPH-61CD
        0x61E6, # G+4920  U+61E6  uni61E6,  CJK UNIFIED IDEOGRAPH-61E6
        0x61E3, # G+4921  U+61E3  uni61E3,  CJK UNIFIED IDEOGRAPH-61E3
        0x61F6, # G+4922  U+61F6  uni61F6,  CJK UNIFIED IDEOGRAPH-61F6
        0x61FA, # G+4923  U+61FA  uni61FA,  CJK UNIFIED IDEOGRAPH-61FA
        0x61F4, # G+4924  U+61F4  uni61F4,  CJK UNIFIED IDEOGRAPH-61F4
        0x61FF, # G+4925  U+61FF  uni61FF,  CJK UNIFIED IDEOGRAPH-61FF
        0x61FD, # G+4926  U+61FD  uni61FD,  CJK UNIFIED IDEOGRAPH-61FD
        0x61FC, # G+4927  U+61FC  uni61FC,  CJK UNIFIED IDEOGRAPH-61FC
        0x61FE, # G+4928  U+61FE  uni61FE,  CJK UNIFIED IDEOGRAPH-61FE
        0x6200, # G+4929  U+6200  uni6200,  CJK UNIFIED IDEOGRAPH-6200
        0x2F3D, # G+4930  U+2F3D  uni2F3D,  KANGXI RADICAL HALBERD
        0x6209, # G+4931  U+6209  uni6209,  CJK UNIFIED IDEOGRAPH-6209
        0x620D, # G+4932  U+620D  uni620D,  CJK UNIFIED IDEOGRAPH-620D
        0x620C, # G+4933  U+620C  uni620C,  CJK UNIFIED IDEOGRAPH-620C
        0x6214, # G+4934  U+6214  uni6214,  CJK UNIFIED IDEOGRAPH-6214
        0x621B, # G+4935  U+621B  uni621B,  CJK UNIFIED IDEOGRAPH-621B
        0x621E, # G+4936  U+621E  uni621E,  CJK UNIFIED IDEOGRAPH-621E
        0x6221, # G+4937  U+6221  uni6221,  CJK UNIFIED IDEOGRAPH-6221
        0x622A, # G+4938  U+622A  uni622A,  CJK UNIFIED IDEOGRAPH-622A
        0x622E, # G+4939  U+622E  uni622E,  CJK UNIFIED IDEOGRAPH-622E
        0x6230, # G+4940  U+6230  uni6230,  CJK UNIFIED IDEOGRAPH-6230
        0x6232, # G+4941  U+6232  uni6232,  CJK UNIFIED IDEOGRAPH-6232
        0x6233, # G+4942  U+6233  uni6233,  CJK UNIFIED IDEOGRAPH-6233
        0x6241, # G+4943  U+6241  uni6241,  CJK UNIFIED IDEOGRAPH-6241
        0x624E, # G+4944  U+624E  uni624E,  CJK UNIFIED IDEOGRAPH-624E
        0x625E, # G+4945  U+625E  uni625E,  CJK UNIFIED IDEOGRAPH-625E
        0x6263, # G+4946  U+6263  uni6263,  CJK UNIFIED IDEOGRAPH-6263
        0x625B, # G+4947  U+625B  uni625B,  CJK UNIFIED IDEOGRAPH-625B
        0x6260, # G+4948  U+6260  uni6260,  CJK UNIFIED IDEOGRAPH-6260
        0x6268, # G+4949  U+6268  uni6268,  CJK UNIFIED IDEOGRAPH-6268
        0x627C, # G+4950  U+627C  uni627C,  CJK UNIFIED IDEOGRAPH-627C
        0x6282, # G+4951  U+6282  uni6282,  CJK UNIFIED IDEOGRAPH-6282
        0x6289, # G+4952  U+6289  uni6289,  CJK UNIFIED IDEOGRAPH-6289
        0x627E, # G+4953  U+627E  uni627E,  CJK UNIFIED IDEOGRAPH-627E
        0x6292, # G+4954  U+6292  uni6292,  CJK UNIFIED IDEOGRAPH-6292
        0x6293, # G+4955  U+6293  uni6293,  CJK UNIFIED IDEOGRAPH-6293
        0x6296, # G+4956  U+6296  uni6296,  CJK UNIFIED IDEOGRAPH-6296
        0x62D4, # G+4957  U+62D4  uni62D4,  CJK UNIFIED IDEOGRAPH-62D4
        0x6283, # G+4958  U+6283  uni6283,  CJK UNIFIED IDEOGRAPH-6283
        0x6294, # G+4959  U+6294  uni6294,  CJK UNIFIED IDEOGRAPH-6294
        0x62D7, # G+4960  U+62D7  uni62D7,  CJK UNIFIED IDEOGRAPH-62D7
        0x62D1, # G+4961  U+62D1  uni62D1,  CJK UNIFIED IDEOGRAPH-62D1
        0x62BB, # G+4962  U+62BB  uni62BB,  CJK UNIFIED IDEOGRAPH-62BB
        0x62CF, # G+4963  U+62CF  uni62CF,  CJK UNIFIED IDEOGRAPH-62CF
        0x62FF, # G+4964  U+62FF  uni62FF,  CJK UNIFIED IDEOGRAPH-62FF
        0x62C6, # G+4965  U+62C6  uni62C6,  CJK UNIFIED IDEOGRAPH-62C6
        0x64D4, # G+4966  U+64D4  uni64D4,  CJK UNIFIED IDEOGRAPH-64D4
        0x62C8, # G+4967  U+62C8  uni62C8,  CJK UNIFIED IDEOGRAPH-62C8
        0x62DC, # G+4968  U+62DC  uni62DC,  CJK UNIFIED IDEOGRAPH-62DC
        0x62CC, # G+4969  U+62CC  uni62CC,  CJK UNIFIED IDEOGRAPH-62CC
        0x62CA, # G+4970  U+62CA  uni62CA,  CJK UNIFIED IDEOGRAPH-62CA
        0x62C2, # G+4971  U+62C2  uni62C2,  CJK UNIFIED IDEOGRAPH-62C2
        0x62C7, # G+4972  U+62C7  uni62C7,  CJK UNIFIED IDEOGRAPH-62C7
        0x629B, # G+4973  U+629B  uni629B,  CJK UNIFIED IDEOGRAPH-629B
        0x62C9, # G+4974  U+62C9  uni62C9,  CJK UNIFIED IDEOGRAPH-62C9
        0x630C, # G+4975  U+630C  uni630C,  CJK UNIFIED IDEOGRAPH-630C
        0x62EE, # G+4976  U+62EE  uni62EE,  CJK UNIFIED IDEOGRAPH-62EE
        0x62F1, # G+4977  U+62F1  uni62F1,  CJK UNIFIED IDEOGRAPH-62F1
        0x6327, # G+4978  U+6327  uni6327,  CJK UNIFIED IDEOGRAPH-6327
        0x6302, # G+4979  U+6302  uni6302,  CJK UNIFIED IDEOGRAPH-6302
        0x6308, # G+4980  U+6308  uni6308,  CJK UNIFIED IDEOGRAPH-6308
        0x62EF, # G+4981  U+62EF  uni62EF,  CJK UNIFIED IDEOGRAPH-62EF
        0x62F5, # G+4982  U+62F5  uni62F5,  CJK UNIFIED IDEOGRAPH-62F5
        0x6350, # G+4983  U+6350  uni6350,  CJK UNIFIED IDEOGRAPH-6350
        0x633E, # G+4984  U+633E  uni633E,  CJK UNIFIED IDEOGRAPH-633E
        0x634D, # G+4985  U+634D  uni634D,  CJK UNIFIED IDEOGRAPH-634D
        0x641C, # G+4986  U+641C  uni641C,  CJK UNIFIED IDEOGRAPH-641C
        0x634F, # G+4987  U+634F  uni634F,  CJK UNIFIED IDEOGRAPH-634F
        0x6396, # G+4988  U+6396  uni6396,  CJK UNIFIED IDEOGRAPH-6396
        0x638E, # G+4989  U+638E  uni638E,  CJK UNIFIED IDEOGRAPH-638E
        0x6380, # G+4990  U+6380  uni6380,  CJK UNIFIED IDEOGRAPH-6380
        0x63AB, # G+4991  U+63AB  uni63AB,  CJK UNIFIED IDEOGRAPH-63AB
        0x6376, # G+4992  U+6376  uni6376,  CJK UNIFIED IDEOGRAPH-6376
        0x63A3, # G+4993  U+63A3  uni63A3,  CJK UNIFIED IDEOGRAPH-63A3
        0x638F, # G+4994  U+638F  uni638F,  CJK UNIFIED IDEOGRAPH-638F
        0x6389, # G+4995  U+6389  uni6389,  CJK UNIFIED IDEOGRAPH-6389
        0x639F, # G+4996  U+639F  uni639F,  CJK UNIFIED IDEOGRAPH-639F
        0x63B5, # G+4997  U+63B5  uni63B5,  CJK UNIFIED IDEOGRAPH-63B5
        0x636B, # G+4998  U+636B  uni636B,  CJK UNIFIED IDEOGRAPH-636B
        0x6369, # G+4999  U+6369  uni6369,  CJK UNIFIED IDEOGRAPH-6369
        0x63BE, # G+5000  U+63BE  uni63BE,  CJK UNIFIED IDEOGRAPH-63BE
        0x63E9, # G+5001  U+63E9  uni63E9,  CJK UNIFIED IDEOGRAPH-63E9
        0x63C0, # G+5002  U+63C0  uni63C0,  CJK UNIFIED IDEOGRAPH-63C0
        0x63C6, # G+5003  U+63C6  uni63C6,  CJK UNIFIED IDEOGRAPH-63C6
        0x63E3, # G+5004  U+63E3  uni63E3,  CJK UNIFIED IDEOGRAPH-63E3
        0x63C9, # G+5005  U+63C9  uni63C9,  CJK UNIFIED IDEOGRAPH-63C9
        0x63D2, # G+5006  U+63D2  uni63D2,  CJK UNIFIED IDEOGRAPH-63D2
        0x63F6, # G+5007  U+63F6  uni63F6,  CJK UNIFIED IDEOGRAPH-63F6
        0x63C4, # G+5008  U+63C4  uni63C4,  CJK UNIFIED IDEOGRAPH-63C4
        0x6416, # G+5009  U+6416  uni6416,  CJK UNIFIED IDEOGRAPH-6416
        0x6434, # G+5010  U+6434  uni6434,  CJK UNIFIED IDEOGRAPH-6434
        0x6406, # G+5011  U+6406  uni6406,  CJK UNIFIED IDEOGRAPH-6406
        0x6413, # G+5012  U+6413  uni6413,  CJK UNIFIED IDEOGRAPH-6413
        0x6426, # G+5013  U+6426  uni6426,  CJK UNIFIED IDEOGRAPH-6426
        0x6436, # G+5014  U+6436  uni6436,  CJK UNIFIED IDEOGRAPH-6436
        0x651D, # G+5015  U+651D  uni651D,  CJK UNIFIED IDEOGRAPH-651D
        0x6417, # G+5016  U+6417  uni6417,  CJK UNIFIED IDEOGRAPH-6417
        0x6428, # G+5017  U+6428  uni6428,  CJK UNIFIED IDEOGRAPH-6428
        0x640F, # G+5018  U+640F  uni640F,  CJK UNIFIED IDEOGRAPH-640F
        0x6467, # G+5019  U+6467  uni6467,  CJK UNIFIED IDEOGRAPH-6467
        0x646F, # G+5020  U+646F  uni646F,  CJK UNIFIED IDEOGRAPH-646F
        0x6476, # G+5021  U+6476  uni6476,  CJK UNIFIED IDEOGRAPH-6476
        0x644E, # G+5022  U+644E  uni644E,  CJK UNIFIED IDEOGRAPH-644E
        0x652A, # G+5023  U+652A  uni652A,  CJK UNIFIED IDEOGRAPH-652A
        0x6495, # G+5024  U+6495  uni6495,  CJK UNIFIED IDEOGRAPH-6495
        0x6493, # G+5025  U+6493  uni6493,  CJK UNIFIED IDEOGRAPH-6493
        0x64A5, # G+5026  U+64A5  uni64A5,  CJK UNIFIED IDEOGRAPH-64A5
        0x64A9, # G+5027  U+64A9  uni64A9,  CJK UNIFIED IDEOGRAPH-64A9
        0x6488, # G+5028  U+6488  uni6488,  CJK UNIFIED IDEOGRAPH-6488
        0x64BC, # G+5029  U+64BC  uni64BC,  CJK UNIFIED IDEOGRAPH-64BC
        0x64DA, # G+5030  U+64DA  uni64DA,  CJK UNIFIED IDEOGRAPH-64DA
        0x64D2, # G+5031  U+64D2  uni64D2,  CJK UNIFIED IDEOGRAPH-64D2
        0x64C5, # G+5032  U+64C5  uni64C5,  CJK UNIFIED IDEOGRAPH-64C5
        0x64C7, # G+5033  U+64C7  uni64C7,  CJK UNIFIED IDEOGRAPH-64C7
        0x64BB, # G+5034  U+64BB  uni64BB,  CJK UNIFIED IDEOGRAPH-64BB
        0x64D8, # G+5035  U+64D8  uni64D8,  CJK UNIFIED IDEOGRAPH-64D8
        0x64C2, # G+5036  U+64C2  uni64C2,  CJK UNIFIED IDEOGRAPH-64C2
        0x64F1, # G+5037  U+64F1  uni64F1,  CJK UNIFIED IDEOGRAPH-64F1
        0x64E7, # G+5038  U+64E7  uni64E7,  CJK UNIFIED IDEOGRAPH-64E7
        0x8209, # G+5039  U+8209  uni8209,  CJK UNIFIED IDEOGRAPH-8209
        0x64E0, # G+5040  U+64E0  uni64E0,  CJK UNIFIED IDEOGRAPH-64E0
        0x64E1, # G+5041  U+64E1  uni64E1,  CJK UNIFIED IDEOGRAPH-64E1
        0x62AC, # G+5042  U+62AC  uni62AC,  CJK UNIFIED IDEOGRAPH-62AC
        0x64E3, # G+5043  U+64E3  uni64E3,  CJK UNIFIED IDEOGRAPH-64E3
        0x64EF, # G+5044  U+64EF  uni64EF,  CJK UNIFIED IDEOGRAPH-64EF
        0x652C, # G+5045  U+652C  uni652C,  CJK UNIFIED IDEOGRAPH-652C
        0x64F6, # G+5046  U+64F6  uni64F6,  CJK UNIFIED IDEOGRAPH-64F6
        0x64F4, # G+5047  U+64F4  uni64F4,  CJK UNIFIED IDEOGRAPH-64F4
        0x64F2, # G+5048  U+64F2  uni64F2,  CJK UNIFIED IDEOGRAPH-64F2
        0x64FA, # G+5049  U+64FA  uni64FA,  CJK UNIFIED IDEOGRAPH-64FA
        0x6500, # G+5050  U+6500  uni6500,  CJK UNIFIED IDEOGRAPH-6500
        0x64FD, # G+5051  U+64FD  uni64FD,  CJK UNIFIED IDEOGRAPH-64FD
        0x6518, # G+5052  U+6518  uni6518,  CJK UNIFIED IDEOGRAPH-6518
        0x651C, # G+5053  U+651C  uni651C,  CJK UNIFIED IDEOGRAPH-651C
        0x6505, # G+5054  U+6505  uni6505,  CJK UNIFIED IDEOGRAPH-6505
        0x6524, # G+5055  U+6524  uni6524,  CJK UNIFIED IDEOGRAPH-6524
        0x6523, # G+5056  U+6523  uni6523,  CJK UNIFIED IDEOGRAPH-6523
        0x652B, # G+5057  U+652B  uni652B,  CJK UNIFIED IDEOGRAPH-652B
        0x2F41, # G+5058  U+2F41  uni2F41,  KANGXI RADICAL RAP
        0x2E99, # G+5059  U+2E99  uni2E99,  CJK RADICAL RAP
        0x6537, # G+5060  U+6537  uni6537,  CJK UNIFIED IDEOGRAPH-6537
        0x6536, # G+5061  U+6536  uni6536,  CJK UNIFIED IDEOGRAPH-6536
        0x6538, # G+5062  U+6538  uni6538,  CJK UNIFIED IDEOGRAPH-6538
        0x754B, # G+5063  U+754B  uni754B,  CJK UNIFIED IDEOGRAPH-754B
        0x6548, # G+5064  U+6548  uni6548,  CJK UNIFIED IDEOGRAPH-6548
        0x6556, # G+5065  U+6556  uni6556,  CJK UNIFIED IDEOGRAPH-6556
        0x6555, # G+5066  U+6555  uni6555,  CJK UNIFIED IDEOGRAPH-6555
        0x654D, # G+5067  U+654D  uni654D,  CJK UNIFIED IDEOGRAPH-654D
        0x6558, # G+5068  U+6558  uni6558,  CJK UNIFIED IDEOGRAPH-6558
        0x655E, # G+5069  U+655E  uni655E,  CJK UNIFIED IDEOGRAPH-655E
        0x655D, # G+5070  U+655D  uni655D,  CJK UNIFIED IDEOGRAPH-655D
        0x6572, # G+5071  U+6572  uni6572,  CJK UNIFIED IDEOGRAPH-6572
        0x6578, # G+5072  U+6578  uni6578,  CJK UNIFIED IDEOGRAPH-6578
        0x6582, # G+5073  U+6582  uni6582,  CJK UNIFIED IDEOGRAPH-6582
        0x6583, # G+5074  U+6583  uni6583,  CJK UNIFIED IDEOGRAPH-6583
        0x8B8A, # G+5075  U+8B8A  uni8B8A,  CJK UNIFIED IDEOGRAPH-8B8A
        0x659B, # G+5076  U+659B  uni659B,  CJK UNIFIED IDEOGRAPH-659B
        0x659F, # G+5077  U+659F  uni659F,  CJK UNIFIED IDEOGRAPH-659F
        0x65AB, # G+5078  U+65AB  uni65AB,  CJK UNIFIED IDEOGRAPH-65AB
        0x65B7, # G+5079  U+65B7  uni65B7,  CJK UNIFIED IDEOGRAPH-65B7
        0x65C3, # G+5080  U+65C3  uni65C3,  CJK UNIFIED IDEOGRAPH-65C3
        0x65C6, # G+5081  U+65C6  uni65C6,  CJK UNIFIED IDEOGRAPH-65C6
        0x65C1, # G+5082  U+65C1  uni65C1,  CJK UNIFIED IDEOGRAPH-65C1
        0x65C4, # G+5083  U+65C4  uni65C4,  CJK UNIFIED IDEOGRAPH-65C4
        0x65CC, # G+5084  U+65CC  uni65CC,  CJK UNIFIED IDEOGRAPH-65CC
        0x65D2, # G+5085  U+65D2  uni65D2,  CJK UNIFIED IDEOGRAPH-65D2
        0x65DB, # G+5086  U+65DB  uni65DB,  CJK UNIFIED IDEOGRAPH-65DB
        0x65D9, # G+5087  U+65D9  uni65D9,  CJK UNIFIED IDEOGRAPH-65D9
        0x2F46, # G+5088  U+2F46  uni2F46,  KANGXI RADICAL NOT
        0x2E9B, # G+5089  U+2E9B  uni2E9B,  CJK RADICAL CHOKE
        0x65F1, # G+5090  U+65F1  uni65F1,  CJK UNIFIED IDEOGRAPH-65F1
        0x6772, # G+5091  U+6772  uni6772,  CJK UNIFIED IDEOGRAPH-6772
        0x660A, # G+5092  U+660A  uni660A,  CJK UNIFIED IDEOGRAPH-660A
        0x6603, # G+5093  U+6603  uni6603,  CJK UNIFIED IDEOGRAPH-6603
        0x65FB, # G+5094  U+65FB  uni65FB,  CJK UNIFIED IDEOGRAPH-65FB
        0x6773, # G+5095  U+6773  uni6773,  CJK UNIFIED IDEOGRAPH-6773
        0x6635, # G+5096  U+6635  uni6635,  CJK UNIFIED IDEOGRAPH-6635
        0x6636, # G+5097  U+6636  uni6636,  CJK UNIFIED IDEOGRAPH-6636
        0x6634, # G+5098  U+6634  uni6634,  CJK UNIFIED IDEOGRAPH-6634
        0x661C, # G+5099  U+661C  uni661C,  CJK UNIFIED IDEOGRAPH-661C
        0x664F, # G+5100  U+664F  uni664F,  CJK UNIFIED IDEOGRAPH-664F
        0x6644, # G+5101  U+6644  uni6644,  CJK UNIFIED IDEOGRAPH-6644
        0x6649, # G+5102  U+6649  uni6649,  CJK UNIFIED IDEOGRAPH-6649
        0x6641, # G+5103  U+6641  uni6641,  CJK UNIFIED IDEOGRAPH-6641
        0x665E, # G+5104  U+665E  uni665E,  CJK UNIFIED IDEOGRAPH-665E
        0x665D, # G+5105  U+665D  uni665D,  CJK UNIFIED IDEOGRAPH-665D
        0x6664, # G+5106  U+6664  uni6664,  CJK UNIFIED IDEOGRAPH-6664
        0x6667, # G+5107  U+6667  uni6667,  CJK UNIFIED IDEOGRAPH-6667
        0x6668, # G+5108  U+6668  uni6668,  CJK UNIFIED IDEOGRAPH-6668
        0x665F, # G+5109  U+665F  uni665F,  CJK UNIFIED IDEOGRAPH-665F
        0x6662, # G+5110  U+6662  uni6662,  CJK UNIFIED IDEOGRAPH-6662
        0x6670, # G+5111  U+6670  uni6670,  CJK UNIFIED IDEOGRAPH-6670
        0x6683, # G+5112  U+6683  uni6683,  CJK UNIFIED IDEOGRAPH-6683
        0x6688, # G+5113  U+6688  uni6688,  CJK UNIFIED IDEOGRAPH-6688
        0x668E, # G+5114  U+668E  uni668E,  CJK UNIFIED IDEOGRAPH-668E
        0x6689, # G+5115  U+6689  uni6689,  CJK UNIFIED IDEOGRAPH-6689
        0x6684, # G+5116  U+6684  uni6684,  CJK UNIFIED IDEOGRAPH-6684
        0x6698, # G+5117  U+6698  uni6698,  CJK UNIFIED IDEOGRAPH-6698
        0x669D, # G+5118  U+669D  uni669D,  CJK UNIFIED IDEOGRAPH-669D
        0x66C1, # G+5119  U+66C1  uni66C1,  CJK UNIFIED IDEOGRAPH-66C1
        0x66B9, # G+5120  U+66B9  uni66B9,  CJK UNIFIED IDEOGRAPH-66B9
        0x66C9, # G+5121  U+66C9  uni66C9,  CJK UNIFIED IDEOGRAPH-66C9
        0x66BE, # G+5122  U+66BE  uni66BE,  CJK UNIFIED IDEOGRAPH-66BE
        0x66BC, # G+5123  U+66BC  uni66BC,  CJK UNIFIED IDEOGRAPH-66BC
        0x66C4, # G+5124  U+66C4  uni66C4,  CJK UNIFIED IDEOGRAPH-66C4
        0x66B8, # G+5125  U+66B8  uni66B8,  CJK UNIFIED IDEOGRAPH-66B8
        0x66D6, # G+5126  U+66D6  uni66D6,  CJK UNIFIED IDEOGRAPH-66D6
        0x66DA, # G+5127  U+66DA  uni66DA,  CJK UNIFIED IDEOGRAPH-66DA
        0x66E0, # G+5128  U+66E0  uni66E0,  CJK UNIFIED IDEOGRAPH-66E0
        0x663F, # G+5129  U+663F  uni663F,  CJK UNIFIED IDEOGRAPH-663F
        0x66E6, # G+5130  U+66E6  uni66E6,  CJK UNIFIED IDEOGRAPH-66E6
        0x66E9, # G+5131  U+66E9  uni66E9,  CJK UNIFIED IDEOGRAPH-66E9
        0x2F48, # G+5132  U+2F48  uni2F48,  KANGXI RADICAL SAY
        0x66F5, # G+5133  U+66F5  uni66F5,  CJK UNIFIED IDEOGRAPH-66F5
        0x66F7, # G+5134  U+66F7  uni66F7,  CJK UNIFIED IDEOGRAPH-66F7
        0x670F, # G+5135  U+670F  uni670F,  CJK UNIFIED IDEOGRAPH-670F
        0x6716, # G+5136  U+6716  uni6716,  CJK UNIFIED IDEOGRAPH-6716
        0x671E, # G+5137  U+671E  uni671E,  CJK UNIFIED IDEOGRAPH-671E
        0x6726, # G+5138  U+6726  uni6726,  CJK UNIFIED IDEOGRAPH-6726
        0x6727, # G+5139  U+6727  uni6727,  CJK UNIFIED IDEOGRAPH-6727
        0x9738, # G+5140  U+9738  uni9738,  CJK UNIFIED IDEOGRAPH-9738
        0x672E, # G+5141  U+672E  uni672E,  CJK UNIFIED IDEOGRAPH-672E
        0x673F, # G+5142  U+673F  uni673F,  CJK UNIFIED IDEOGRAPH-673F
        0x6736, # G+5143  U+6736  uni6736,  CJK UNIFIED IDEOGRAPH-6736
        0x6741, # G+5144  U+6741  uni6741,  CJK UNIFIED IDEOGRAPH-6741
        0x6738, # G+5145  U+6738  uni6738,  CJK UNIFIED IDEOGRAPH-6738
        0x6737, # G+5146  U+6737  uni6737,  CJK UNIFIED IDEOGRAPH-6737
        0x6746, # G+5147  U+6746  uni6746,  CJK UNIFIED IDEOGRAPH-6746
        0x675E, # G+5148  U+675E  uni675E,  CJK UNIFIED IDEOGRAPH-675E
        0x6760, # G+5149  U+6760  uni6760,  CJK UNIFIED IDEOGRAPH-6760
        0x6759, # G+5150  U+6759  uni6759,  CJK UNIFIED IDEOGRAPH-6759
        0x6763, # G+5151  U+6763  uni6763,  CJK UNIFIED IDEOGRAPH-6763
        0x6764, # G+5152  U+6764  uni6764,  CJK UNIFIED IDEOGRAPH-6764
        0x6789, # G+5153  U+6789  uni6789,  CJK UNIFIED IDEOGRAPH-6789
        0x6770, # G+5154  U+6770  uni6770,  CJK UNIFIED IDEOGRAPH-6770
        0x67A9, # G+5155  U+67A9  uni67A9,  CJK UNIFIED IDEOGRAPH-67A9
        0x677C, # G+5156  U+677C  uni677C,  CJK UNIFIED IDEOGRAPH-677C
        0x676A, # G+5157  U+676A  uni676A,  CJK UNIFIED IDEOGRAPH-676A
        0x678C, # G+5158  U+678C  uni678C,  CJK UNIFIED IDEOGRAPH-678C
        0x678B, # G+5159  U+678B  uni678B,  CJK UNIFIED IDEOGRAPH-678B
        0x67A6, # G+5160  U+67A6  uni67A6,  CJK UNIFIED IDEOGRAPH-67A6
        0x67A1, # G+5161  U+67A1  uni67A1,  CJK UNIFIED IDEOGRAPH-67A1
        0x6785, # G+5162  U+6785  uni6785,  CJK UNIFIED IDEOGRAPH-6785
        0x67B7, # G+5163  U+67B7  uni67B7,  CJK UNIFIED IDEOGRAPH-67B7
        0x67EF, # G+5164  U+67EF  uni67EF,  CJK UNIFIED IDEOGRAPH-67EF
        0x67B4, # G+5165  U+67B4  uni67B4,  CJK UNIFIED IDEOGRAPH-67B4
        0x67EC, # G+5166  U+67EC  uni67EC,  CJK UNIFIED IDEOGRAPH-67EC
        0x67B3, # G+5167  U+67B3  uni67B3,  CJK UNIFIED IDEOGRAPH-67B3
        0x67E9, # G+5168  U+67E9  uni67E9,  CJK UNIFIED IDEOGRAPH-67E9
        0x67B8, # G+5169  U+67B8  uni67B8,  CJK UNIFIED IDEOGRAPH-67B8
        0x67E4, # G+5170  U+67E4  uni67E4,  CJK UNIFIED IDEOGRAPH-67E4
        0x67DE, # G+5171  U+67DE  uni67DE,  CJK UNIFIED IDEOGRAPH-67DE
        0x67DD, # G+5172  U+67DD  uni67DD,  CJK UNIFIED IDEOGRAPH-67DD
        0x67E2, # G+5173  U+67E2  uni67E2,  CJK UNIFIED IDEOGRAPH-67E2
        0x67EE, # G+5174  U+67EE  uni67EE,  CJK UNIFIED IDEOGRAPH-67EE
        0x67B9, # G+5175  U+67B9  uni67B9,  CJK UNIFIED IDEOGRAPH-67B9
        0x67CE, # G+5176  U+67CE  uni67CE,  CJK UNIFIED IDEOGRAPH-67CE
        0x67C6, # G+5177  U+67C6  uni67C6,  CJK UNIFIED IDEOGRAPH-67C6
        0x67E7, # G+5178  U+67E7  uni67E7,  CJK UNIFIED IDEOGRAPH-67E7
        0x6A9C, # G+5179  U+6A9C  uni6A9C,  CJK UNIFIED IDEOGRAPH-6A9C
        0x681E, # G+5180  U+681E  uni681E,  CJK UNIFIED IDEOGRAPH-681E
        0x6846, # G+5181  U+6846  uni6846,  CJK UNIFIED IDEOGRAPH-6846
        0x6829, # G+5182  U+6829  uni6829,  CJK UNIFIED IDEOGRAPH-6829
        0x6840, # G+5183  U+6840  uni6840,  CJK UNIFIED IDEOGRAPH-6840
        0x684D, # G+5184  U+684D  uni684D,  CJK UNIFIED IDEOGRAPH-684D
        0x6832, # G+5185  U+6832  uni6832,  CJK UNIFIED IDEOGRAPH-6832
        0x684E, # G+5186  U+684E  uni684E,  CJK UNIFIED IDEOGRAPH-684E
        0x68B3, # G+5187  U+68B3  uni68B3,  CJK UNIFIED IDEOGRAPH-68B3
        0x682B, # G+5188  U+682B  uni682B,  CJK UNIFIED IDEOGRAPH-682B
        0x6859, # G+5189  U+6859  uni6859,  CJK UNIFIED IDEOGRAPH-6859
        0x6863, # G+5190  U+6863  uni6863,  CJK UNIFIED IDEOGRAPH-6863
        0x6877, # G+5191  U+6877  uni6877,  CJK UNIFIED IDEOGRAPH-6877
        0x687F, # G+5192  U+687F  uni687F,  CJK UNIFIED IDEOGRAPH-687F
        0x689F, # G+5193  U+689F  uni689F,  CJK UNIFIED IDEOGRAPH-689F
        0x688F, # G+5194  U+688F  uni688F,  CJK UNIFIED IDEOGRAPH-688F
        0x68AD, # G+5195  U+68AD  uni68AD,  CJK UNIFIED IDEOGRAPH-68AD
        0x6894, # G+5196  U+6894  uni6894,  CJK UNIFIED IDEOGRAPH-6894
        0x689D, # G+5197  U+689D  uni689D,  CJK UNIFIED IDEOGRAPH-689D
        0x689B, # G+5198  U+689B  uni689B,  CJK UNIFIED IDEOGRAPH-689B
        0x6883, # G+5199  U+6883  uni6883,  CJK UNIFIED IDEOGRAPH-6883
        0x6AAE, # G+5200  U+6AAE  uni6AAE,  CJK UNIFIED IDEOGRAPH-6AAE
        0x68B9, # G+5201  U+68B9  uni68B9,  CJK UNIFIED IDEOGRAPH-68B9
        0x6874, # G+5202  U+6874  uni6874,  CJK UNIFIED IDEOGRAPH-6874
        0x68B5, # G+5203  U+68B5  uni68B5,  CJK UNIFIED IDEOGRAPH-68B5
        0x68A0, # G+5204  U+68A0  uni68A0,  CJK UNIFIED IDEOGRAPH-68A0
        0x68BA, # G+5205  U+68BA  uni68BA,  CJK UNIFIED IDEOGRAPH-68BA
        0x690F, # G+5206  U+690F  uni690F,  CJK UNIFIED IDEOGRAPH-690F
        0x688D, # G+5207  U+688D  uni688D,  CJK UNIFIED IDEOGRAPH-688D
        0x687E, # G+5208  U+687E  uni687E,  CJK UNIFIED IDEOGRAPH-687E
        0x6901, # G+5209  U+6901  uni6901,  CJK UNIFIED IDEOGRAPH-6901
        0x68CA, # G+5210  U+68CA  uni68CA,  CJK UNIFIED IDEOGRAPH-68CA
        0x6908, # G+5211  U+6908  uni6908,  CJK UNIFIED IDEOGRAPH-6908
        0x68D8, # G+5212  U+68D8  uni68D8,  CJK UNIFIED IDEOGRAPH-68D8
        0x6922, # G+5213  U+6922  uni6922,  CJK UNIFIED IDEOGRAPH-6922
        0x6926, # G+5214  U+6926  uni6926,  CJK UNIFIED IDEOGRAPH-6926
        0x68E1, # G+5215  U+68E1  uni68E1,  CJK UNIFIED IDEOGRAPH-68E1
        0x690C, # G+5216  U+690C  uni690C,  CJK UNIFIED IDEOGRAPH-690C
        0x68CD, # G+5217  U+68CD  uni68CD,  CJK UNIFIED IDEOGRAPH-68CD
        0x68D4, # G+5218  U+68D4  uni68D4,  CJK UNIFIED IDEOGRAPH-68D4
        0x68E7, # G+5219  U+68E7  uni68E7,  CJK UNIFIED IDEOGRAPH-68E7
        0x68D5, # G+5220  U+68D5  uni68D5,  CJK UNIFIED IDEOGRAPH-68D5
        0x6936, # G+5221  U+6936  uni6936,  CJK UNIFIED IDEOGRAPH-6936
        0x6912, # G+5222  U+6912  uni6912,  CJK UNIFIED IDEOGRAPH-6912
        0x6904, # G+5223  U+6904  uni6904,  CJK UNIFIED IDEOGRAPH-6904
        0x68D7, # G+5224  U+68D7  uni68D7,  CJK UNIFIED IDEOGRAPH-68D7
        0x68E3, # G+5225  U+68E3  uni68E3,  CJK UNIFIED IDEOGRAPH-68E3
        0x6925, # G+5226  U+6925  uni6925,  CJK UNIFIED IDEOGRAPH-6925
        0x68F9, # G+5227  U+68F9  uni68F9,  CJK UNIFIED IDEOGRAPH-68F9
        0x68E0, # G+5228  U+68E0  uni68E0,  CJK UNIFIED IDEOGRAPH-68E0
        0x68EF, # G+5229  U+68EF  uni68EF,  CJK UNIFIED IDEOGRAPH-68EF
        0x6928, # G+5230  U+6928  uni6928,  CJK UNIFIED IDEOGRAPH-6928
        0x692A, # G+5231  U+692A  uni692A,  CJK UNIFIED IDEOGRAPH-692A
        0x691A, # G+5232  U+691A  uni691A,  CJK UNIFIED IDEOGRAPH-691A
        0x6923, # G+5233  U+6923  uni6923,  CJK UNIFIED IDEOGRAPH-6923
        0x6921, # G+5234  U+6921  uni6921,  CJK UNIFIED IDEOGRAPH-6921
        0x68C6, # G+5235  U+68C6  uni68C6,  CJK UNIFIED IDEOGRAPH-68C6
        0x6979, # G+5236  U+6979  uni6979,  CJK UNIFIED IDEOGRAPH-6979
        0x6977, # G+5237  U+6977  uni6977,  CJK UNIFIED IDEOGRAPH-6977
        0x695C, # G+5238  U+695C  uni695C,  CJK UNIFIED IDEOGRAPH-695C
        0x6978, # G+5239  U+6978  uni6978,  CJK UNIFIED IDEOGRAPH-6978
        0x696B, # G+5240  U+696B  uni696B,  CJK UNIFIED IDEOGRAPH-696B
        0x6954, # G+5241  U+6954  uni6954,  CJK UNIFIED IDEOGRAPH-6954
        0x697E, # G+5242  U+697E  uni697E,  CJK UNIFIED IDEOGRAPH-697E
        0x696E, # G+5243  U+696E  uni696E,  CJK UNIFIED IDEOGRAPH-696E
        0x6939, # G+5244  U+6939  uni6939,  CJK UNIFIED IDEOGRAPH-6939
        0x6974, # G+5245  U+6974  uni6974,  CJK UNIFIED IDEOGRAPH-6974
        0x693D, # G+5246  U+693D  uni693D,  CJK UNIFIED IDEOGRAPH-693D
        0x6959, # G+5247  U+6959  uni6959,  CJK UNIFIED IDEOGRAPH-6959
        0x6930, # G+5248  U+6930  uni6930,  CJK UNIFIED IDEOGRAPH-6930
        0x6961, # G+5249  U+6961  uni6961,  CJK UNIFIED IDEOGRAPH-6961
        0x695E, # G+5250  U+695E  uni695E,  CJK UNIFIED IDEOGRAPH-695E
        0x695D, # G+5251  U+695D  uni695D,  CJK UNIFIED IDEOGRAPH-695D
        0x6981, # G+5252  U+6981  uni6981,  CJK UNIFIED IDEOGRAPH-6981
        0x696A, # G+5253  U+696A  uni696A,  CJK UNIFIED IDEOGRAPH-696A
        0x69B2, # G+5254  U+69B2  uni69B2,  CJK UNIFIED IDEOGRAPH-69B2
        0x69AE, # G+5255  U+69AE  uni69AE,  CJK UNIFIED IDEOGRAPH-69AE
        0x69D0, # G+5256  U+69D0  uni69D0,  CJK UNIFIED IDEOGRAPH-69D0
        0x69BF, # G+5257  U+69BF  uni69BF,  CJK UNIFIED IDEOGRAPH-69BF
        0x69C1, # G+5258  U+69C1  uni69C1,  CJK UNIFIED IDEOGRAPH-69C1
        0x69D3, # G+5259  U+69D3  uni69D3,  CJK UNIFIED IDEOGRAPH-69D3
        0x69BE, # G+5260  U+69BE  uni69BE,  CJK UNIFIED IDEOGRAPH-69BE
        0x69CE, # G+5261  U+69CE  uni69CE,  CJK UNIFIED IDEOGRAPH-69CE
        0x5BE8, # G+5262  U+5BE8  uni5BE8,  CJK UNIFIED IDEOGRAPH-5BE8
        0x69CA, # G+5263  U+69CA  uni69CA,  CJK UNIFIED IDEOGRAPH-69CA
        0x69DD, # G+5264  U+69DD  uni69DD,  CJK UNIFIED IDEOGRAPH-69DD
        0x69BB, # G+5265  U+69BB  uni69BB,  CJK UNIFIED IDEOGRAPH-69BB
        0x69C3, # G+5266  U+69C3  uni69C3,  CJK UNIFIED IDEOGRAPH-69C3
        0x69A7, # G+5267  U+69A7  uni69A7,  CJK UNIFIED IDEOGRAPH-69A7
        0x6A2E, # G+5268  U+6A2E  uni6A2E,  CJK UNIFIED IDEOGRAPH-6A2E
        0x6991, # G+5269  U+6991  uni6991,  CJK UNIFIED IDEOGRAPH-6991
        0x69A0, # G+5270  U+69A0  uni69A0,  CJK UNIFIED IDEOGRAPH-69A0
        0x699C, # G+5271  U+699C  uni699C,  CJK UNIFIED IDEOGRAPH-699C
        0x6995, # G+5272  U+6995  uni6995,  CJK UNIFIED IDEOGRAPH-6995
        0x69B4, # G+5273  U+69B4  uni69B4,  CJK UNIFIED IDEOGRAPH-69B4
        0x69DE, # G+5274  U+69DE  uni69DE,  CJK UNIFIED IDEOGRAPH-69DE
        0x69E8, # G+5275  U+69E8  uni69E8,  CJK UNIFIED IDEOGRAPH-69E8
        0x6A02, # G+5276  U+6A02  uni6A02,  CJK UNIFIED IDEOGRAPH-6A02
        0x6A1B, # G+5277  U+6A1B  uni6A1B,  CJK UNIFIED IDEOGRAPH-6A1B
        0x69FF, # G+5278  U+69FF  uni69FF,  CJK UNIFIED IDEOGRAPH-69FF
        0x6B0A, # G+5279  U+6B0A  uni6B0A,  CJK UNIFIED IDEOGRAPH-6B0A
        0x69F9, # G+5280  U+69F9  uni69F9,  CJK UNIFIED IDEOGRAPH-69F9
        0x69F2, # G+5281  U+69F2  uni69F2,  CJK UNIFIED IDEOGRAPH-69F2
        0x69E7, # G+5282  U+69E7  uni69E7,  CJK UNIFIED IDEOGRAPH-69E7
        0x6A05, # G+5283  U+6A05  uni6A05,  CJK UNIFIED IDEOGRAPH-6A05
        0x69B1, # G+5284  U+69B1  uni69B1,  CJK UNIFIED IDEOGRAPH-69B1
        0x6A1E, # G+5285  U+6A1E  uni6A1E,  CJK UNIFIED IDEOGRAPH-6A1E
        0x69ED, # G+5286  U+69ED  uni69ED,  CJK UNIFIED IDEOGRAPH-69ED
        0x6A14, # G+5287  U+6A14  uni6A14,  CJK UNIFIED IDEOGRAPH-6A14
        0x69EB, # G+5288  U+69EB  uni69EB,  CJK UNIFIED IDEOGRAPH-69EB
        0x6A0A, # G+5289  U+6A0A  uni6A0A,  CJK UNIFIED IDEOGRAPH-6A0A
        0x6A12, # G+5290  U+6A12  uni6A12,  CJK UNIFIED IDEOGRAPH-6A12
        0x6AC1, # G+5291  U+6AC1  uni6AC1,  CJK UNIFIED IDEOGRAPH-6AC1
        0x6A23, # G+5292  U+6A23  uni6A23,  CJK UNIFIED IDEOGRAPH-6A23
        0x6A13, # G+5293  U+6A13  uni6A13,  CJK UNIFIED IDEOGRAPH-6A13
        0x6A44, # G+5294  U+6A44  uni6A44,  CJK UNIFIED IDEOGRAPH-6A44
        0x6A0C, # G+5295  U+6A0C  uni6A0C,  CJK UNIFIED IDEOGRAPH-6A0C
        0x6A72, # G+5296  U+6A72  uni6A72,  CJK UNIFIED IDEOGRAPH-6A72
        0x6A36, # G+5297  U+6A36  uni6A36,  CJK UNIFIED IDEOGRAPH-6A36
        0x6A78, # G+5298  U+6A78  uni6A78,  CJK UNIFIED IDEOGRAPH-6A78
        0x6A47, # G+5299  U+6A47  uni6A47,  CJK UNIFIED IDEOGRAPH-6A47
        0x6A62, # G+5300  U+6A62  uni6A62,  CJK UNIFIED IDEOGRAPH-6A62
        0x6A59, # G+5301  U+6A59  uni6A59,  CJK UNIFIED IDEOGRAPH-6A59
        0x6A66, # G+5302  U+6A66  uni6A66,  CJK UNIFIED IDEOGRAPH-6A66
        0x6A48, # G+5303  U+6A48  uni6A48,  CJK UNIFIED IDEOGRAPH-6A48
        0x6A38, # G+5304  U+6A38  uni6A38,  CJK UNIFIED IDEOGRAPH-6A38
        0x6A22, # G+5305  U+6A22  uni6A22,  CJK UNIFIED IDEOGRAPH-6A22
        0x6A90, # G+5306  U+6A90  uni6A90,  CJK UNIFIED IDEOGRAPH-6A90
        0x6A8D, # G+5307  U+6A8D  uni6A8D,  CJK UNIFIED IDEOGRAPH-6A8D
        0x6AA0, # G+5308  U+6AA0  uni6AA0,  CJK UNIFIED IDEOGRAPH-6AA0
        0x6A84, # G+5309  U+6A84  uni6A84,  CJK UNIFIED IDEOGRAPH-6A84
        0x6AA2, # G+5310  U+6AA2  uni6AA2,  CJK UNIFIED IDEOGRAPH-6AA2
        0x6AA3, # G+5311  U+6AA3  uni6AA3,  CJK UNIFIED IDEOGRAPH-6AA3
        0x6A97, # G+5312  U+6A97  uni6A97,  CJK UNIFIED IDEOGRAPH-6A97
        0x8617, # G+5313  U+8617  uni8617,  CJK UNIFIED IDEOGRAPH-8617
        0x6ABB, # G+5314  U+6ABB  uni6ABB,  CJK UNIFIED IDEOGRAPH-6ABB
        0x6AC3, # G+5315  U+6AC3  uni6AC3,  CJK UNIFIED IDEOGRAPH-6AC3
        0x6AC2, # G+5316  U+6AC2  uni6AC2,  CJK UNIFIED IDEOGRAPH-6AC2
        0x6AB8, # G+5317  U+6AB8  uni6AB8,  CJK UNIFIED IDEOGRAPH-6AB8
        0x6AB3, # G+5318  U+6AB3  uni6AB3,  CJK UNIFIED IDEOGRAPH-6AB3
        0x6AAC, # G+5319  U+6AAC  uni6AAC,  CJK UNIFIED IDEOGRAPH-6AAC
        0x6ADE, # G+5320  U+6ADE  uni6ADE,  CJK UNIFIED IDEOGRAPH-6ADE
        0x6AD1, # G+5321  U+6AD1  uni6AD1,  CJK UNIFIED IDEOGRAPH-6AD1
        0x6ADF, # G+5322  U+6ADF  uni6ADF,  CJK UNIFIED IDEOGRAPH-6ADF
        0x6AAA, # G+5323  U+6AAA  uni6AAA,  CJK UNIFIED IDEOGRAPH-6AAA
        0x6ADA, # G+5324  U+6ADA  uni6ADA,  CJK UNIFIED IDEOGRAPH-6ADA
        0x6AEA, # G+5325  U+6AEA  uni6AEA,  CJK UNIFIED IDEOGRAPH-6AEA
        0x6AFB, # G+5326  U+6AFB  uni6AFB,  CJK UNIFIED IDEOGRAPH-6AFB
        0x6B05, # G+5327  U+6B05  uni6B05,  CJK UNIFIED IDEOGRAPH-6B05
        0x8616, # G+5328  U+8616  uni8616,  CJK UNIFIED IDEOGRAPH-8616
        0x6AFA, # G+5329  U+6AFA  uni6AFA,  CJK UNIFIED IDEOGRAPH-6AFA
        0x6B12, # G+5330  U+6B12  uni6B12,  CJK UNIFIED IDEOGRAPH-6B12
        0x6B16, # G+5331  U+6B16  uni6B16,  CJK UNIFIED IDEOGRAPH-6B16
        0x9B31, # G+5332  U+9B31  uni9B31,  CJK UNIFIED IDEOGRAPH-9B31
        0x6B1F, # G+5333  U+6B1F  uni6B1F,  CJK UNIFIED IDEOGRAPH-6B1F
        0x6B38, # G+5334  U+6B38  uni6B38,  CJK UNIFIED IDEOGRAPH-6B38
        0x6B37, # G+5335  U+6B37  uni6B37,  CJK UNIFIED IDEOGRAPH-6B37
        0x76DC, # G+5336  U+76DC  uni76DC,  CJK UNIFIED IDEOGRAPH-76DC
        0x6B39, # G+5337  U+6B39  uni6B39,  CJK UNIFIED IDEOGRAPH-6B39
        0x98EE, # G+5338  U+98EE  uni98EE,  CJK UNIFIED IDEOGRAPH-98EE
        0x6B47, # G+5339  U+6B47  uni6B47,  CJK UNIFIED IDEOGRAPH-6B47
        0x6B43, # G+5340  U+6B43  uni6B43,  CJK UNIFIED IDEOGRAPH-6B43
        0x6B49, # G+5341  U+6B49  uni6B49,  CJK UNIFIED IDEOGRAPH-6B49
        0x6B50, # G+5342  U+6B50  uni6B50,  CJK UNIFIED IDEOGRAPH-6B50
        0x6B59, # G+5343  U+6B59  uni6B59,  CJK UNIFIED IDEOGRAPH-6B59
        0x6B54, # G+5344  U+6B54  uni6B54,  CJK UNIFIED IDEOGRAPH-6B54
        0x6B5B, # G+5345  U+6B5B  uni6B5B,  CJK UNIFIED IDEOGRAPH-6B5B
        0x6B5F, # G+5346  U+6B5F  uni6B5F,  CJK UNIFIED IDEOGRAPH-6B5F
        0x6B61, # G+5347  U+6B61  uni6B61,  CJK UNIFIED IDEOGRAPH-6B61
        0x6B78, # G+5348  U+6B78  uni6B78,  CJK UNIFIED IDEOGRAPH-6B78
        0x2F4D, # G+5349  U+2F4D  uni2F4D,  KANGXI RADICAL DEATH
        0x6B7F, # G+5350  U+6B7F  uni6B7F,  CJK UNIFIED IDEOGRAPH-6B7F
        0x6B80, # G+5351  U+6B80  uni6B80,  CJK UNIFIED IDEOGRAPH-6B80
        0x6B84, # G+5352  U+6B84  uni6B84,  CJK UNIFIED IDEOGRAPH-6B84
        0x6B83, # G+5353  U+6B83  uni6B83,  CJK UNIFIED IDEOGRAPH-6B83
        0x6B8D, # G+5354  U+6B8D  uni6B8D,  CJK UNIFIED IDEOGRAPH-6B8D
        0x6B98, # G+5355  U+6B98  uni6B98,  CJK UNIFIED IDEOGRAPH-6B98
        0x6B95, # G+5356  U+6B95  uni6B95,  CJK UNIFIED IDEOGRAPH-6B95
        0x6B9E, # G+5357  U+6B9E  uni6B9E,  CJK UNIFIED IDEOGRAPH-6B9E
        0x6BA4, # G+5358  U+6BA4  uni6BA4,  CJK UNIFIED IDEOGRAPH-6BA4
        0x6BAA, # G+5359  U+6BAA  uni6BAA,  CJK UNIFIED IDEOGRAPH-6BAA
        0x6BAB, # G+5360  U+6BAB  uni6BAB,  CJK UNIFIED IDEOGRAPH-6BAB
        0x6BAF, # G+5361  U+6BAF  uni6BAF,  CJK UNIFIED IDEOGRAPH-6BAF
        0x6BB2, # G+5362  U+6BB2  uni6BB2,  CJK UNIFIED IDEOGRAPH-6BB2
        0x6BB1, # G+5363  U+6BB1  uni6BB1,  CJK UNIFIED IDEOGRAPH-6BB1
        0x2F4E, # G+5364  U+2F4E  uni2F4E,  KANGXI RADICAL WEAPON
        0x6BB7, # G+5365  U+6BB7  uni6BB7,  CJK UNIFIED IDEOGRAPH-6BB7
        0x6BBC, # G+5366  U+6BBC  uni6BBC,  CJK UNIFIED IDEOGRAPH-6BBC
        0x6BC6, # G+5367  U+6BC6  uni6BC6,  CJK UNIFIED IDEOGRAPH-6BC6
        0x2F4F, # G+5368  U+2F4F  uni2F4F,  KANGXI RADICAL DO NOT
        0x6BD3, # G+5369  U+6BD3  uni6BD3,  CJK UNIFIED IDEOGRAPH-6BD3
        0x6BDF, # G+5370  U+6BDF  uni6BDF,  CJK UNIFIED IDEOGRAPH-6BDF
        0x6BEC, # G+5371  U+6BEC  uni6BEC,  CJK UNIFIED IDEOGRAPH-6BEC
        0x6BEB, # G+5372  U+6BEB  uni6BEB,  CJK UNIFIED IDEOGRAPH-6BEB
        0x6BF3, # G+5373  U+6BF3  uni6BF3,  CJK UNIFIED IDEOGRAPH-6BF3
        0x6BEF, # G+5374  U+6BEF  uni6BEF,  CJK UNIFIED IDEOGRAPH-6BEF
        0x9EBE, # G+5375  U+9EBE  uni9EBE,  CJK UNIFIED IDEOGRAPH-9EBE
        0x6C08, # G+5376  U+6C08  uni6C08,  CJK UNIFIED IDEOGRAPH-6C08
        0x6C13, # G+5377  U+6C13  uni6C13,  CJK UNIFIED IDEOGRAPH-6C13
        0x2F53, # G+5378  U+2F53  uni2F53,  KANGXI RADICAL STEAM
        0x6C1B, # G+5379  U+6C1B  uni6C1B,  CJK UNIFIED IDEOGRAPH-6C1B
        0x6C24, # G+5380  U+6C24  uni6C24,  CJK UNIFIED IDEOGRAPH-6C24
        0x6C23, # G+5381  U+6C23  uni6C23,  CJK UNIFIED IDEOGRAPH-6C23
        0x6C5E, # G+5382  U+6C5E  uni6C5E,  CJK UNIFIED IDEOGRAPH-6C5E
        0x6C55, # G+5383  U+6C55  uni6C55,  CJK UNIFIED IDEOGRAPH-6C55
        0x6C62, # G+5384  U+6C62  uni6C62,  CJK UNIFIED IDEOGRAPH-6C62
        0x6C6A, # G+5385  U+6C6A  uni6C6A,  CJK UNIFIED IDEOGRAPH-6C6A
        0x6C82, # G+5386  U+6C82  uni6C82,  CJK UNIFIED IDEOGRAPH-6C82
        0x6C8D, # G+5387  U+6C8D  uni6C8D,  CJK UNIFIED IDEOGRAPH-6C8D
        0x6C9A, # G+5388  U+6C9A  uni6C9A,  CJK UNIFIED IDEOGRAPH-6C9A
        0x6C81, # G+5389  U+6C81  uni6C81,  CJK UNIFIED IDEOGRAPH-6C81
        0x6C9B, # G+5390  U+6C9B  uni6C9B,  CJK UNIFIED IDEOGRAPH-6C9B
        0x6C7E, # G+5391  U+6C7E  uni6C7E,  CJK UNIFIED IDEOGRAPH-6C7E
        0x6C68, # G+5392  U+6C68  uni6C68,  CJK UNIFIED IDEOGRAPH-6C68
        0x6C73, # G+5393  U+6C73  uni6C73,  CJK UNIFIED IDEOGRAPH-6C73
        0x6C92, # G+5394  U+6C92  uni6C92,  CJK UNIFIED IDEOGRAPH-6C92
        0x6C90, # G+5395  U+6C90  uni6C90,  CJK UNIFIED IDEOGRAPH-6C90
        0x6CC4, # G+5396  U+6CC4  uni6CC4,  CJK UNIFIED IDEOGRAPH-6CC4
        0x6CF1, # G+5397  U+6CF1  uni6CF1,  CJK UNIFIED IDEOGRAPH-6CF1
        0x6CD3, # G+5398  U+6CD3  uni6CD3,  CJK UNIFIED IDEOGRAPH-6CD3
        0x6CBD, # G+5399  U+6CBD  uni6CBD,  CJK UNIFIED IDEOGRAPH-6CBD
        0x6CD7, # G+5400  U+6CD7  uni6CD7,  CJK UNIFIED IDEOGRAPH-6CD7
        0x6CC5, # G+5401  U+6CC5  uni6CC5,  CJK UNIFIED IDEOGRAPH-6CC5
        0x6CDD, # G+5402  U+6CDD  uni6CDD,  CJK UNIFIED IDEOGRAPH-6CDD
        0x6CAE, # G+5403  U+6CAE  uni6CAE,  CJK UNIFIED IDEOGRAPH-6CAE
        0x6CB1, # G+5404  U+6CB1  uni6CB1,  CJK UNIFIED IDEOGRAPH-6CB1
        0x6CBE, # G+5405  U+6CBE  uni6CBE,  CJK UNIFIED IDEOGRAPH-6CBE
        0x6CBA, # G+5406  U+6CBA  uni6CBA,  CJK UNIFIED IDEOGRAPH-6CBA
        0x6CDB, # G+5407  U+6CDB  uni6CDB,  CJK UNIFIED IDEOGRAPH-6CDB
        0x6CEF, # G+5408  U+6CEF  uni6CEF,  CJK UNIFIED IDEOGRAPH-6CEF
        0x6CD9, # G+5409  U+6CD9  uni6CD9,  CJK UNIFIED IDEOGRAPH-6CD9
        0x6CEA, # G+5410  U+6CEA  uni6CEA,  CJK UNIFIED IDEOGRAPH-6CEA
        0x6D1F, # G+5411  U+6D1F  uni6D1F,  CJK UNIFIED IDEOGRAPH-6D1F
        0x884D, # G+5412  U+884D  uni884D,  CJK UNIFIED IDEOGRAPH-884D
        0x6D36, # G+5413  U+6D36  uni6D36,  CJK UNIFIED IDEOGRAPH-6D36
        0x6D2B, # G+5414  U+6D2B  uni6D2B,  CJK UNIFIED IDEOGRAPH-6D2B
        0x6D3D, # G+5415  U+6D3D  uni6D3D,  CJK UNIFIED IDEOGRAPH-6D3D
        0x6D38, # G+5416  U+6D38  uni6D38,  CJK UNIFIED IDEOGRAPH-6D38
        0x6D19, # G+5417  U+6D19  uni6D19,  CJK UNIFIED IDEOGRAPH-6D19
        0x6D35, # G+5418  U+6D35  uni6D35,  CJK UNIFIED IDEOGRAPH-6D35
        0x6D33, # G+5419  U+6D33  uni6D33,  CJK UNIFIED IDEOGRAPH-6D33
        0x6D12, # G+5420  U+6D12  uni6D12,  CJK UNIFIED IDEOGRAPH-6D12
        0x6D0C, # G+5421  U+6D0C  uni6D0C,  CJK UNIFIED IDEOGRAPH-6D0C
        0x6D63, # G+5422  U+6D63  uni6D63,  CJK UNIFIED IDEOGRAPH-6D63
        0x6D93, # G+5423  U+6D93  uni6D93,  CJK UNIFIED IDEOGRAPH-6D93
        0x6D64, # G+5424  U+6D64  uni6D64,  CJK UNIFIED IDEOGRAPH-6D64
        0x6D5A, # G+5425  U+6D5A  uni6D5A,  CJK UNIFIED IDEOGRAPH-6D5A
        0x6D79, # G+5426  U+6D79  uni6D79,  CJK UNIFIED IDEOGRAPH-6D79
        0x6D59, # G+5427  U+6D59  uni6D59,  CJK UNIFIED IDEOGRAPH-6D59
        0x6D8E, # G+5428  U+6D8E  uni6D8E,  CJK UNIFIED IDEOGRAPH-6D8E
        0x6D95, # G+5429  U+6D95  uni6D95,  CJK UNIFIED IDEOGRAPH-6D95
        0x6FE4, # G+5430  U+6FE4  uni6FE4,  CJK UNIFIED IDEOGRAPH-6FE4
        0x6D85, # G+5431  U+6D85  uni6D85,  CJK UNIFIED IDEOGRAPH-6D85
        0x6DF9, # G+5432  U+6DF9  uni6DF9,  CJK UNIFIED IDEOGRAPH-6DF9
        0x6E15, # G+5433  U+6E15  uni6E15,  CJK UNIFIED IDEOGRAPH-6E15
        0x6E0A, # G+5434  U+6E0A  uni6E0A,  CJK UNIFIED IDEOGRAPH-6E0A
        0x6DB5, # G+5435  U+6DB5  uni6DB5,  CJK UNIFIED IDEOGRAPH-6DB5
        0x6DC7, # G+5436  U+6DC7  uni6DC7,  CJK UNIFIED IDEOGRAPH-6DC7
        0x6DE6, # G+5437  U+6DE6  uni6DE6,  CJK UNIFIED IDEOGRAPH-6DE6
        0x6DB8, # G+5438  U+6DB8  uni6DB8,  CJK UNIFIED IDEOGRAPH-6DB8
        0x6DC6, # G+5439  U+6DC6  uni6DC6,  CJK UNIFIED IDEOGRAPH-6DC6
        0x6DEC, # G+5440  U+6DEC  uni6DEC,  CJK UNIFIED IDEOGRAPH-6DEC
        0x6DDE, # G+5441  U+6DDE  uni6DDE,  CJK UNIFIED IDEOGRAPH-6DDE
        0x6DCC, # G+5442  U+6DCC  uni6DCC,  CJK UNIFIED IDEOGRAPH-6DCC
        0x6DE8, # G+5443  U+6DE8  uni6DE8,  CJK UNIFIED IDEOGRAPH-6DE8
        0x6DD2, # G+5444  U+6DD2  uni6DD2,  CJK UNIFIED IDEOGRAPH-6DD2
        0x6DC5, # G+5445  U+6DC5  uni6DC5,  CJK UNIFIED IDEOGRAPH-6DC5
        0x6DFA, # G+5446  U+6DFA  uni6DFA,  CJK UNIFIED IDEOGRAPH-6DFA
        0x6DD9, # G+5447  U+6DD9  uni6DD9,  CJK UNIFIED IDEOGRAPH-6DD9
        0x6DE4, # G+5448  U+6DE4  uni6DE4,  CJK UNIFIED IDEOGRAPH-6DE4
        0x6DD5, # G+5449  U+6DD5  uni6DD5,  CJK UNIFIED IDEOGRAPH-6DD5
        0x6DEA, # G+5450  U+6DEA  uni6DEA,  CJK UNIFIED IDEOGRAPH-6DEA
        0x6DEE, # G+5451  U+6DEE  uni6DEE,  CJK UNIFIED IDEOGRAPH-6DEE
        0x6E2D, # G+5452  U+6E2D  uni6E2D,  CJK UNIFIED IDEOGRAPH-6E2D
        0x6E6E, # G+5453  U+6E6E  uni6E6E,  CJK UNIFIED IDEOGRAPH-6E6E
        0x6E2E, # G+5454  U+6E2E  uni6E2E,  CJK UNIFIED IDEOGRAPH-6E2E
        0x6E19, # G+5455  U+6E19  uni6E19,  CJK UNIFIED IDEOGRAPH-6E19
        0x6E72, # G+5456  U+6E72  uni6E72,  CJK UNIFIED IDEOGRAPH-6E72
        0x6E5F, # G+5457  U+6E5F  uni6E5F,  CJK UNIFIED IDEOGRAPH-6E5F
        0x6E3E, # G+5458  U+6E3E  uni6E3E,  CJK UNIFIED IDEOGRAPH-6E3E
        0x6E23, # G+5459  U+6E23  uni6E23,  CJK UNIFIED IDEOGRAPH-6E23
        0x6E6B, # G+5460  U+6E6B  uni6E6B,  CJK UNIFIED IDEOGRAPH-6E6B
        0x6E2B, # G+5461  U+6E2B  uni6E2B,  CJK UNIFIED IDEOGRAPH-6E2B
        0x6E76, # G+5462  U+6E76  uni6E76,  CJK UNIFIED IDEOGRAPH-6E76
        0x6E4D, # G+5463  U+6E4D  uni6E4D,  CJK UNIFIED IDEOGRAPH-6E4D
        0x6E1F, # G+5464  U+6E1F  uni6E1F,  CJK UNIFIED IDEOGRAPH-6E1F
        0x6E43, # G+5465  U+6E43  uni6E43,  CJK UNIFIED IDEOGRAPH-6E43
        0x6E3A, # G+5466  U+6E3A  uni6E3A,  CJK UNIFIED IDEOGRAPH-6E3A
        0x6E4E, # G+5467  U+6E4E  uni6E4E,  CJK UNIFIED IDEOGRAPH-6E4E
        0x6E24, # G+5468  U+6E24  uni6E24,  CJK UNIFIED IDEOGRAPH-6E24
        0x6EFF, # G+5469  U+6EFF  uni6EFF,  CJK UNIFIED IDEOGRAPH-6EFF
        0x6E1D, # G+5470  U+6E1D  uni6E1D,  CJK UNIFIED IDEOGRAPH-6E1D
        0x6E38, # G+5471  U+6E38  uni6E38,  CJK UNIFIED IDEOGRAPH-6E38
        0x6E82, # G+5472  U+6E82  uni6E82,  CJK UNIFIED IDEOGRAPH-6E82
        0x6EAA, # G+5473  U+6EAA  uni6EAA,  CJK UNIFIED IDEOGRAPH-6EAA
        0x6E98, # G+5474  U+6E98  uni6E98,  CJK UNIFIED IDEOGRAPH-6E98
        0x6EC9, # G+5475  U+6EC9  uni6EC9,  CJK UNIFIED IDEOGRAPH-6EC9
        0x6EB7, # G+5476  U+6EB7  uni6EB7,  CJK UNIFIED IDEOGRAPH-6EB7
        0x6ED3, # G+5477  U+6ED3  uni6ED3,  CJK UNIFIED IDEOGRAPH-6ED3
        0x6EBD, # G+5478  U+6EBD  uni6EBD,  CJK UNIFIED IDEOGRAPH-6EBD
        0x6EAF, # G+5479  U+6EAF  uni6EAF,  CJK UNIFIED IDEOGRAPH-6EAF
        0x6EC4, # G+5480  U+6EC4  uni6EC4,  CJK UNIFIED IDEOGRAPH-6EC4
        0x6EB2, # G+5481  U+6EB2  uni6EB2,  CJK UNIFIED IDEOGRAPH-6EB2
        0x6ED4, # G+5482  U+6ED4  uni6ED4,  CJK UNIFIED IDEOGRAPH-6ED4
        0x6ED5, # G+5483  U+6ED5  uni6ED5,  CJK UNIFIED IDEOGRAPH-6ED5
        0x6E8F, # G+5484  U+6E8F  uni6E8F,  CJK UNIFIED IDEOGRAPH-6E8F
        0x6EA5, # G+5485  U+6EA5  uni6EA5,  CJK UNIFIED IDEOGRAPH-6EA5
        0x6EC2, # G+5486  U+6EC2  uni6EC2,  CJK UNIFIED IDEOGRAPH-6EC2
        0x6E9F, # G+5487  U+6E9F  uni6E9F,  CJK UNIFIED IDEOGRAPH-6E9F
        0x6F41, # G+5488  U+6F41  uni6F41,  CJK UNIFIED IDEOGRAPH-6F41
        0x6F11, # G+5489  U+6F11  uni6F11,  CJK UNIFIED IDEOGRAPH-6F11
        0x704C, # G+5490  U+704C  uni704C,  CJK UNIFIED IDEOGRAPH-704C
        0x6EEC, # G+5491  U+6EEC  uni6EEC,  CJK UNIFIED IDEOGRAPH-6EEC
        0x6EF8, # G+5492  U+6EF8  uni6EF8,  CJK UNIFIED IDEOGRAPH-6EF8
        0x6EFE, # G+5493  U+6EFE  uni6EFE,  CJK UNIFIED IDEOGRAPH-6EFE
        0x6F3F, # G+5494  U+6F3F  uni6F3F,  CJK UNIFIED IDEOGRAPH-6F3F
        0x6EF2, # G+5495  U+6EF2  uni6EF2,  CJK UNIFIED IDEOGRAPH-6EF2
        0x6F31, # G+5496  U+6F31  uni6F31,  CJK UNIFIED IDEOGRAPH-6F31
        0x6EEF, # G+5497  U+6EEF  uni6EEF,  CJK UNIFIED IDEOGRAPH-6EEF
        0x6F32, # G+5498  U+6F32  uni6F32,  CJK UNIFIED IDEOGRAPH-6F32
        0x6ECC, # G+5499  U+6ECC  uni6ECC,  CJK UNIFIED IDEOGRAPH-6ECC
        0x6F3E, # G+5500  U+6F3E  uni6F3E,  CJK UNIFIED IDEOGRAPH-6F3E
        0x6F13, # G+5501  U+6F13  uni6F13,  CJK UNIFIED IDEOGRAPH-6F13
        0x6EF7, # G+5502  U+6EF7  uni6EF7,  CJK UNIFIED IDEOGRAPH-6EF7
        0x6F86, # G+5503  U+6F86  uni6F86,  CJK UNIFIED IDEOGRAPH-6F86
        0x6F7A, # G+5504  U+6F7A  uni6F7A,  CJK UNIFIED IDEOGRAPH-6F7A
        0x6F78, # G+5505  U+6F78  uni6F78,  CJK UNIFIED IDEOGRAPH-6F78
        0x6F81, # G+5506  U+6F81  uni6F81,  CJK UNIFIED IDEOGRAPH-6F81
        0x6F80, # G+5507  U+6F80  uni6F80,  CJK UNIFIED IDEOGRAPH-6F80
        0x6F6F, # G+5508  U+6F6F  uni6F6F,  CJK UNIFIED IDEOGRAPH-6F6F
        0x6F5B, # G+5509  U+6F5B  uni6F5B,  CJK UNIFIED IDEOGRAPH-6F5B
        0x6FF3, # G+5510  U+6FF3  uni6FF3,  CJK UNIFIED IDEOGRAPH-6FF3
        0x6F6D, # G+5511  U+6F6D  uni6F6D,  CJK UNIFIED IDEOGRAPH-6F6D
        0x6F82, # G+5512  U+6F82  uni6F82,  CJK UNIFIED IDEOGRAPH-6F82
        0x6F7C, # G+5513  U+6F7C  uni6F7C,  CJK UNIFIED IDEOGRAPH-6F7C
        0x6F58, # G+5514  U+6F58  uni6F58,  CJK UNIFIED IDEOGRAPH-6F58
        0x6F8E, # G+5515  U+6F8E  uni6F8E,  CJK UNIFIED IDEOGRAPH-6F8E
        0x6F91, # G+5516  U+6F91  uni6F91,  CJK UNIFIED IDEOGRAPH-6F91
        0x6FC2, # G+5517  U+6FC2  uni6FC2,  CJK UNIFIED IDEOGRAPH-6FC2
        0x6F66, # G+5518  U+6F66  uni6F66,  CJK UNIFIED IDEOGRAPH-6F66
        0x6FB3, # G+5519  U+6FB3  uni6FB3,  CJK UNIFIED IDEOGRAPH-6FB3
        0x6FA3, # G+5520  U+6FA3  uni6FA3,  CJK UNIFIED IDEOGRAPH-6FA3
        0x6FA1, # G+5521  U+6FA1  uni6FA1,  CJK UNIFIED IDEOGRAPH-6FA1
        0x6FA4, # G+5522  U+6FA4  uni6FA4,  CJK UNIFIED IDEOGRAPH-6FA4
        0x6FB9, # G+5523  U+6FB9  uni6FB9,  CJK UNIFIED IDEOGRAPH-6FB9
        0x6FC6, # G+5524  U+6FC6  uni6FC6,  CJK UNIFIED IDEOGRAPH-6FC6
        0x6FAA, # G+5525  U+6FAA  uni6FAA,  CJK UNIFIED IDEOGRAPH-6FAA
        0x6FDF, # G+5526  U+6FDF  uni6FDF,  CJK UNIFIED IDEOGRAPH-6FDF
        0x6FD5, # G+5527  U+6FD5  uni6FD5,  CJK UNIFIED IDEOGRAPH-6FD5
        0x6FEC, # G+5528  U+6FEC  uni6FEC,  CJK UNIFIED IDEOGRAPH-6FEC
        0x6FD4, # G+5529  U+6FD4  uni6FD4,  CJK UNIFIED IDEOGRAPH-6FD4
        0x6FD8, # G+5530  U+6FD8  uni6FD8,  CJK UNIFIED IDEOGRAPH-6FD8
        0x6FF1, # G+5531  U+6FF1  uni6FF1,  CJK UNIFIED IDEOGRAPH-6FF1
        0x6FEE, # G+5532  U+6FEE  uni6FEE,  CJK UNIFIED IDEOGRAPH-6FEE
        0x6FDB, # G+5533  U+6FDB  uni6FDB,  CJK UNIFIED IDEOGRAPH-6FDB
        0x7009, # G+5534  U+7009  uni7009,  CJK UNIFIED IDEOGRAPH-7009
        0x700B, # G+5535  U+700B  uni700B,  CJK UNIFIED IDEOGRAPH-700B
        0x6FFA, # G+5536  U+6FFA  uni6FFA,  CJK UNIFIED IDEOGRAPH-6FFA
        0x7011, # G+5537  U+7011  uni7011,  CJK UNIFIED IDEOGRAPH-7011
        0x7001, # G+5538  U+7001  uni7001,  CJK UNIFIED IDEOGRAPH-7001
        0x700F, # G+5539  U+700F  uni700F,  CJK UNIFIED IDEOGRAPH-700F
        0x6FFE, # G+5540  U+6FFE  uni6FFE,  CJK UNIFIED IDEOGRAPH-6FFE
        0x701B, # G+5541  U+701B  uni701B,  CJK UNIFIED IDEOGRAPH-701B
        0x701A, # G+5542  U+701A  uni701A,  CJK UNIFIED IDEOGRAPH-701A
        0x6F74, # G+5543  U+6F74  uni6F74,  CJK UNIFIED IDEOGRAPH-6F74
        0x701D, # G+5544  U+701D  uni701D,  CJK UNIFIED IDEOGRAPH-701D
        0x7018, # G+5545  U+7018  uni7018,  CJK UNIFIED IDEOGRAPH-7018
        0x701F, # G+5546  U+701F  uni701F,  CJK UNIFIED IDEOGRAPH-701F
        0x7030, # G+5547  U+7030  uni7030,  CJK UNIFIED IDEOGRAPH-7030
        0x703E, # G+5548  U+703E  uni703E,  CJK UNIFIED IDEOGRAPH-703E
        0x7032, # G+5549  U+7032  uni7032,  CJK UNIFIED IDEOGRAPH-7032
        0x7051, # G+5550  U+7051  uni7051,  CJK UNIFIED IDEOGRAPH-7051
        0x7063, # G+5551  U+7063  uni7063,  CJK UNIFIED IDEOGRAPH-7063
        0x7099, # G+5552  U+7099  uni7099,  CJK UNIFIED IDEOGRAPH-7099
        0x7092, # G+5553  U+7092  uni7092,  CJK UNIFIED IDEOGRAPH-7092
        0x70AF, # G+5554  U+70AF  uni70AF,  CJK UNIFIED IDEOGRAPH-70AF
        0x70F1, # G+5555  U+70F1  uni70F1,  CJK UNIFIED IDEOGRAPH-70F1
        0x70AC, # G+5556  U+70AC  uni70AC,  CJK UNIFIED IDEOGRAPH-70AC
        0x70B8, # G+5557  U+70B8  uni70B8,  CJK UNIFIED IDEOGRAPH-70B8
        0x70B3, # G+5558  U+70B3  uni70B3,  CJK UNIFIED IDEOGRAPH-70B3
        0x70AE, # G+5559  U+70AE  uni70AE,  CJK UNIFIED IDEOGRAPH-70AE
        0x70DF, # G+5560  U+70DF  uni70DF,  CJK UNIFIED IDEOGRAPH-70DF
        0x70CB, # G+5561  U+70CB  uni70CB,  CJK UNIFIED IDEOGRAPH-70CB
        0x70DD, # G+5562  U+70DD  uni70DD,  CJK UNIFIED IDEOGRAPH-70DD
        0x70D9, # G+5563  U+70D9  uni70D9,  CJK UNIFIED IDEOGRAPH-70D9
        0x7109, # G+5564  U+7109  uni7109,  CJK UNIFIED IDEOGRAPH-7109
        0x70FD, # G+5565  U+70FD  uni70FD,  CJK UNIFIED IDEOGRAPH-70FD
        0x711C, # G+5566  U+711C  uni711C,  CJK UNIFIED IDEOGRAPH-711C
        0x7119, # G+5567  U+7119  uni7119,  CJK UNIFIED IDEOGRAPH-7119
        0x7165, # G+5568  U+7165  uni7165,  CJK UNIFIED IDEOGRAPH-7165
        0x7155, # G+5569  U+7155  uni7155,  CJK UNIFIED IDEOGRAPH-7155
        0x7188, # G+5570  U+7188  uni7188,  CJK UNIFIED IDEOGRAPH-7188
        0x7166, # G+5571  U+7166  uni7166,  CJK UNIFIED IDEOGRAPH-7166
        0x7162, # G+5572  U+7162  uni7162,  CJK UNIFIED IDEOGRAPH-7162
        0x714C, # G+5573  U+714C  uni714C,  CJK UNIFIED IDEOGRAPH-714C
        0x7156, # G+5574  U+7156  uni7156,  CJK UNIFIED IDEOGRAPH-7156
        0x716C, # G+5575  U+716C  uni716C,  CJK UNIFIED IDEOGRAPH-716C
        0x718F, # G+5576  U+718F  uni718F,  CJK UNIFIED IDEOGRAPH-718F
        0x71FB, # G+5577  U+71FB  uni71FB,  CJK UNIFIED IDEOGRAPH-71FB
        0x7184, # G+5578  U+7184  uni7184,  CJK UNIFIED IDEOGRAPH-7184
        0x7195, # G+5579  U+7195  uni7195,  CJK UNIFIED IDEOGRAPH-7195
        0x71A8, # G+5580  U+71A8  uni71A8,  CJK UNIFIED IDEOGRAPH-71A8
        0x71AC, # G+5581  U+71AC  uni71AC,  CJK UNIFIED IDEOGRAPH-71AC
        0x71D7, # G+5582  U+71D7  uni71D7,  CJK UNIFIED IDEOGRAPH-71D7
        0x71B9, # G+5583  U+71B9  uni71B9,  CJK UNIFIED IDEOGRAPH-71B9
        0x71BE, # G+5584  U+71BE  uni71BE,  CJK UNIFIED IDEOGRAPH-71BE
        0x71D2, # G+5585  U+71D2  uni71D2,  CJK UNIFIED IDEOGRAPH-71D2
        0x71C9, # G+5586  U+71C9  uni71C9,  CJK UNIFIED IDEOGRAPH-71C9
        0x71D4, # G+5587  U+71D4  uni71D4,  CJK UNIFIED IDEOGRAPH-71D4
        0x71CE, # G+5588  U+71CE  uni71CE,  CJK UNIFIED IDEOGRAPH-71CE
        0x71E0, # G+5589  U+71E0  uni71E0,  CJK UNIFIED IDEOGRAPH-71E0
        0x71EC, # G+5590  U+71EC  uni71EC,  CJK UNIFIED IDEOGRAPH-71EC
        0x71E7, # G+5591  U+71E7  uni71E7,  CJK UNIFIED IDEOGRAPH-71E7
        0x71F5, # G+5592  U+71F5  uni71F5,  CJK UNIFIED IDEOGRAPH-71F5
        0x71FC, # G+5593  U+71FC  uni71FC,  CJK UNIFIED IDEOGRAPH-71FC
        0x71F9, # G+5594  U+71F9  uni71F9,  CJK UNIFIED IDEOGRAPH-71F9
        0x71FF, # G+5595  U+71FF  uni71FF,  CJK UNIFIED IDEOGRAPH-71FF
        0x720D, # G+5596  U+720D  uni720D,  CJK UNIFIED IDEOGRAPH-720D
        0x7210, # G+5597  U+7210  uni7210,  CJK UNIFIED IDEOGRAPH-7210
        0x721B, # G+5598  U+721B  uni721B,  CJK UNIFIED IDEOGRAPH-721B
        0x7228, # G+5599  U+7228  uni7228,  CJK UNIFIED IDEOGRAPH-7228
        0x722D, # G+5600  U+722D  uni722D,  CJK UNIFIED IDEOGRAPH-722D
        0x722C, # G+5601  U+722C  uni722C,  CJK UNIFIED IDEOGRAPH-722C
        0x7230, # G+5602  U+7230  uni7230,  CJK UNIFIED IDEOGRAPH-7230
        0x7232, # G+5603  U+7232  uni7232,  CJK UNIFIED IDEOGRAPH-7232
        0x2F58, # G+5604  U+2F58  uni2F58,  KANGXI RADICAL DOUBLE X
        0x723C, # G+5605  U+723C  uni723C,  CJK UNIFIED IDEOGRAPH-723C
        0x2F59, # G+5606  U+2F59  uni2F59,  KANGXI RADICAL HALF TREE TRUNK
        0x7240, # G+5607  U+7240  uni7240,  CJK UNIFIED IDEOGRAPH-7240
        0x7246, # G+5608  U+7246  uni7246,  CJK UNIFIED IDEOGRAPH-7246
        0x724B, # G+5609  U+724B  uni724B,  CJK UNIFIED IDEOGRAPH-724B
        0x7258, # G+5610  U+7258  uni7258,  CJK UNIFIED IDEOGRAPH-7258
        0x7274, # G+5611  U+7274  uni7274,  CJK UNIFIED IDEOGRAPH-7274
        0x727E, # G+5612  U+727E  uni727E,  CJK UNIFIED IDEOGRAPH-727E
        0x7282, # G+5613  U+7282  uni7282,  CJK UNIFIED IDEOGRAPH-7282
        0x7281, # G+5614  U+7281  uni7281,  CJK UNIFIED IDEOGRAPH-7281
        0x7287, # G+5615  U+7287  uni7287,  CJK UNIFIED IDEOGRAPH-7287
        0x7292, # G+5616  U+7292  uni7292,  CJK UNIFIED IDEOGRAPH-7292
        0x7296, # G+5617  U+7296  uni7296,  CJK UNIFIED IDEOGRAPH-7296
        0x72A2, # G+5618  U+72A2  uni72A2,  CJK UNIFIED IDEOGRAPH-72A2
        0x72A7, # G+5619  U+72A7  uni72A7,  CJK UNIFIED IDEOGRAPH-72A7
        0x72B9, # G+5620  U+72B9  uni72B9,  CJK UNIFIED IDEOGRAPH-72B9
        0x72B2, # G+5621  U+72B2  uni72B2,  CJK UNIFIED IDEOGRAPH-72B2
        0x72C3, # G+5622  U+72C3  uni72C3,  CJK UNIFIED IDEOGRAPH-72C3
        0x72C6, # G+5623  U+72C6  uni72C6,  CJK UNIFIED IDEOGRAPH-72C6
        0x72C4, # G+5624  U+72C4  uni72C4,  CJK UNIFIED IDEOGRAPH-72C4
        0x72CE, # G+5625  U+72CE  uni72CE,  CJK UNIFIED IDEOGRAPH-72CE
        0x72D2, # G+5626  U+72D2  uni72D2,  CJK UNIFIED IDEOGRAPH-72D2
        0x72E2, # G+5627  U+72E2  uni72E2,  CJK UNIFIED IDEOGRAPH-72E2
        0x72E0, # G+5628  U+72E0  uni72E0,  CJK UNIFIED IDEOGRAPH-72E0
        0x72E1, # G+5629  U+72E1  uni72E1,  CJK UNIFIED IDEOGRAPH-72E1
        0x72F9, # G+5630  U+72F9  uni72F9,  CJK UNIFIED IDEOGRAPH-72F9
        0x72F7, # G+5631  U+72F7  uni72F7,  CJK UNIFIED IDEOGRAPH-72F7
        0x500F, # G+5632  U+500F  uni500F,  CJK UNIFIED IDEOGRAPH-500F
        0x7317, # G+5633  U+7317  uni7317,  CJK UNIFIED IDEOGRAPH-7317
        0x730A, # G+5634  U+730A  uni730A,  CJK UNIFIED IDEOGRAPH-730A
        0x731C, # G+5635  U+731C  uni731C,  CJK UNIFIED IDEOGRAPH-731C
        0x7316, # G+5636  U+7316  uni7316,  CJK UNIFIED IDEOGRAPH-7316
        0x731D, # G+5637  U+731D  uni731D,  CJK UNIFIED IDEOGRAPH-731D
        0x7334, # G+5638  U+7334  uni7334,  CJK UNIFIED IDEOGRAPH-7334
        0x732F, # G+5639  U+732F  uni732F,  CJK UNIFIED IDEOGRAPH-732F
        0x7329, # G+5640  U+7329  uni7329,  CJK UNIFIED IDEOGRAPH-7329
        0x7325, # G+5641  U+7325  uni7325,  CJK UNIFIED IDEOGRAPH-7325
        0x733E, # G+5642  U+733E  uni733E,  CJK UNIFIED IDEOGRAPH-733E
        0x734E, # G+5643  U+734E  uni734E,  CJK UNIFIED IDEOGRAPH-734E
        0x734F, # G+5644  U+734F  uni734F,  CJK UNIFIED IDEOGRAPH-734F
        0x9ED8, # G+5645  U+9ED8  uni9ED8,  CJK UNIFIED IDEOGRAPH-9ED8
        0x7357, # G+5646  U+7357  uni7357,  CJK UNIFIED IDEOGRAPH-7357
        0x736A, # G+5647  U+736A  uni736A,  CJK UNIFIED IDEOGRAPH-736A
        0x7368, # G+5648  U+7368  uni7368,  CJK UNIFIED IDEOGRAPH-7368
        0x7370, # G+5649  U+7370  uni7370,  CJK UNIFIED IDEOGRAPH-7370
        0x7378, # G+5650  U+7378  uni7378,  CJK UNIFIED IDEOGRAPH-7378
        0x7375, # G+5651  U+7375  uni7375,  CJK UNIFIED IDEOGRAPH-7375
        0x737B, # G+5652  U+737B  uni737B,  CJK UNIFIED IDEOGRAPH-737B
        0x737A, # G+5653  U+737A  uni737A,  CJK UNIFIED IDEOGRAPH-737A
        0x73C8, # G+5654  U+73C8  uni73C8,  CJK UNIFIED IDEOGRAPH-73C8
        0x73B3, # G+5655  U+73B3  uni73B3,  CJK UNIFIED IDEOGRAPH-73B3
        0x73CE, # G+5656  U+73CE  uni73CE,  CJK UNIFIED IDEOGRAPH-73CE
        0x73BB, # G+5657  U+73BB  uni73BB,  CJK UNIFIED IDEOGRAPH-73BB
        0x73C0, # G+5658  U+73C0  uni73C0,  CJK UNIFIED IDEOGRAPH-73C0
        0x73E5, # G+5659  U+73E5  uni73E5,  CJK UNIFIED IDEOGRAPH-73E5
        0x73EE, # G+5660  U+73EE  uni73EE,  CJK UNIFIED IDEOGRAPH-73EE
        0x73DE, # G+5661  U+73DE  uni73DE,  CJK UNIFIED IDEOGRAPH-73DE
        0x74A2, # G+5662  U+74A2  uni74A2,  CJK UNIFIED IDEOGRAPH-74A2
        0x7405, # G+5663  U+7405  uni7405,  CJK UNIFIED IDEOGRAPH-7405
        0x746F, # G+5664  U+746F  uni746F,  CJK UNIFIED IDEOGRAPH-746F
        0x7425, # G+5665  U+7425  uni7425,  CJK UNIFIED IDEOGRAPH-7425
        0x73F8, # G+5666  U+73F8  uni73F8,  CJK UNIFIED IDEOGRAPH-73F8
        0x7432, # G+5667  U+7432  uni7432,  CJK UNIFIED IDEOGRAPH-7432
        0x743A, # G+5668  U+743A  uni743A,  CJK UNIFIED IDEOGRAPH-743A
        0x7455, # G+5669  U+7455  uni7455,  CJK UNIFIED IDEOGRAPH-7455
        0x743F, # G+5670  U+743F  uni743F,  CJK UNIFIED IDEOGRAPH-743F
        0x745F, # G+5671  U+745F  uni745F,  CJK UNIFIED IDEOGRAPH-745F
        0x7459, # G+5672  U+7459  uni7459,  CJK UNIFIED IDEOGRAPH-7459
        0x7441, # G+5673  U+7441  uni7441,  CJK UNIFIED IDEOGRAPH-7441
        0x745C, # G+5674  U+745C  uni745C,  CJK UNIFIED IDEOGRAPH-745C
        0x7469, # G+5675  U+7469  uni7469,  CJK UNIFIED IDEOGRAPH-7469
        0x7470, # G+5676  U+7470  uni7470,  CJK UNIFIED IDEOGRAPH-7470
        0x7463, # G+5677  U+7463  uni7463,  CJK UNIFIED IDEOGRAPH-7463
        0x746A, # G+5678  U+746A  uni746A,  CJK UNIFIED IDEOGRAPH-746A
        0x7476, # G+5679  U+7476  uni7476,  CJK UNIFIED IDEOGRAPH-7476
        0x747E, # G+5680  U+747E  uni747E,  CJK UNIFIED IDEOGRAPH-747E
        0x748B, # G+5681  U+748B  uni748B,  CJK UNIFIED IDEOGRAPH-748B
        0x749E, # G+5682  U+749E  uni749E,  CJK UNIFIED IDEOGRAPH-749E
        0x74A7, # G+5683  U+74A7  uni74A7,  CJK UNIFIED IDEOGRAPH-74A7
        0x74CA, # G+5684  U+74CA  uni74CA,  CJK UNIFIED IDEOGRAPH-74CA
        0x74CF, # G+5685  U+74CF  uni74CF,  CJK UNIFIED IDEOGRAPH-74CF
        0x74D4, # G+5686  U+74D4  uni74D4,  CJK UNIFIED IDEOGRAPH-74D4
        0x73F1, # G+5687  U+73F1  uni73F1,  CJK UNIFIED IDEOGRAPH-73F1
        0x74E0, # G+5688  U+74E0  uni74E0,  CJK UNIFIED IDEOGRAPH-74E0
        0x74E3, # G+5689  U+74E3  uni74E3,  CJK UNIFIED IDEOGRAPH-74E3
        0x74E7, # G+5690  U+74E7  uni74E7,  CJK UNIFIED IDEOGRAPH-74E7
        0x74E9, # G+5691  U+74E9  uni74E9,  CJK UNIFIED IDEOGRAPH-74E9
        0x74EE, # G+5692  U+74EE  uni74EE,  CJK UNIFIED IDEOGRAPH-74EE
        0x74F2, # G+5693  U+74F2  uni74F2,  CJK UNIFIED IDEOGRAPH-74F2
        0x74F0, # G+5694  U+74F0  uni74F0,  CJK UNIFIED IDEOGRAPH-74F0
        0x74F1, # G+5695  U+74F1  uni74F1,  CJK UNIFIED IDEOGRAPH-74F1
        0x74F8, # G+5696  U+74F8  uni74F8,  CJK UNIFIED IDEOGRAPH-74F8
        0x74F7, # G+5697  U+74F7  uni74F7,  CJK UNIFIED IDEOGRAPH-74F7
        0x7504, # G+5698  U+7504  uni7504,  CJK UNIFIED IDEOGRAPH-7504
        0x7503, # G+5699  U+7503  uni7503,  CJK UNIFIED IDEOGRAPH-7503
        0x7505, # G+5700  U+7505  uni7505,  CJK UNIFIED IDEOGRAPH-7505
        0x750C, # G+5701  U+750C  uni750C,  CJK UNIFIED IDEOGRAPH-750C
        0x750E, # G+5702  U+750E  uni750E,  CJK UNIFIED IDEOGRAPH-750E
        0x750D, # G+5703  U+750D  uni750D,  CJK UNIFIED IDEOGRAPH-750D
        0x7515, # G+5704  U+7515  uni7515,  CJK UNIFIED IDEOGRAPH-7515
        0x7513, # G+5705  U+7513  uni7513,  CJK UNIFIED IDEOGRAPH-7513
        0x751E, # G+5706  U+751E  uni751E,  CJK UNIFIED IDEOGRAPH-751E
        0x7526, # G+5707  U+7526  uni7526,  CJK UNIFIED IDEOGRAPH-7526
        0x752C, # G+5708  U+752C  uni752C,  CJK UNIFIED IDEOGRAPH-752C
        0x753C, # G+5709  U+753C  uni753C,  CJK UNIFIED IDEOGRAPH-753C
        0x7544, # G+5710  U+7544  uni7544,  CJK UNIFIED IDEOGRAPH-7544
        0x754D, # G+5711  U+754D  uni754D,  CJK UNIFIED IDEOGRAPH-754D
        0x754A, # G+5712  U+754A  uni754A,  CJK UNIFIED IDEOGRAPH-754A
        0x7549, # G+5713  U+7549  uni7549,  CJK UNIFIED IDEOGRAPH-7549
        0x755B, # G+5714  U+755B  uni755B,  CJK UNIFIED IDEOGRAPH-755B
        0x7546, # G+5715  U+7546  uni7546,  CJK UNIFIED IDEOGRAPH-7546
        0x755A, # G+5716  U+755A  uni755A,  CJK UNIFIED IDEOGRAPH-755A
        0x7569, # G+5717  U+7569  uni7569,  CJK UNIFIED IDEOGRAPH-7569
        0x7564, # G+5718  U+7564  uni7564,  CJK UNIFIED IDEOGRAPH-7564
        0x7567, # G+5719  U+7567  uni7567,  CJK UNIFIED IDEOGRAPH-7567
        0x756B, # G+5720  U+756B  uni756B,  CJK UNIFIED IDEOGRAPH-756B
        0x756D, # G+5721  U+756D  uni756D,  CJK UNIFIED IDEOGRAPH-756D
        0x7578, # G+5722  U+7578  uni7578,  CJK UNIFIED IDEOGRAPH-7578
        0x7576, # G+5723  U+7576  uni7576,  CJK UNIFIED IDEOGRAPH-7576
        0x7586, # G+5724  U+7586  uni7586,  CJK UNIFIED IDEOGRAPH-7586
        0x7587, # G+5725  U+7587  uni7587,  CJK UNIFIED IDEOGRAPH-7587
        0x7574, # G+5726  U+7574  uni7574,  CJK UNIFIED IDEOGRAPH-7574
        0x758A, # G+5727  U+758A  uni758A,  CJK UNIFIED IDEOGRAPH-758A
        0x7589, # G+5728  U+7589  uni7589,  CJK UNIFIED IDEOGRAPH-7589
        0x7582, # G+5729  U+7582  uni7582,  CJK UNIFIED IDEOGRAPH-7582
        0x7594, # G+5730  U+7594  uni7594,  CJK UNIFIED IDEOGRAPH-7594
        0x759A, # G+5731  U+759A  uni759A,  CJK UNIFIED IDEOGRAPH-759A
        0x759D, # G+5732  U+759D  uni759D,  CJK UNIFIED IDEOGRAPH-759D
        0x75A5, # G+5733  U+75A5  uni75A5,  CJK UNIFIED IDEOGRAPH-75A5
        0x75A3, # G+5734  U+75A3  uni75A3,  CJK UNIFIED IDEOGRAPH-75A3
        0x75C2, # G+5735  U+75C2  uni75C2,  CJK UNIFIED IDEOGRAPH-75C2
        0x75B3, # G+5736  U+75B3  uni75B3,  CJK UNIFIED IDEOGRAPH-75B3
        0x75C3, # G+5737  U+75C3  uni75C3,  CJK UNIFIED IDEOGRAPH-75C3
        0x75B5, # G+5738  U+75B5  uni75B5,  CJK UNIFIED IDEOGRAPH-75B5
        0x75BD, # G+5739  U+75BD  uni75BD,  CJK UNIFIED IDEOGRAPH-75BD
        0x75B8, # G+5740  U+75B8  uni75B8,  CJK UNIFIED IDEOGRAPH-75B8
        0x75BC, # G+5741  U+75BC  uni75BC,  CJK UNIFIED IDEOGRAPH-75BC
        0x75B1, # G+5742  U+75B1  uni75B1,  CJK UNIFIED IDEOGRAPH-75B1
        0x75CD, # G+5743  U+75CD  uni75CD,  CJK UNIFIED IDEOGRAPH-75CD
        0x75CA, # G+5744  U+75CA  uni75CA,  CJK UNIFIED IDEOGRAPH-75CA
        0x75D2, # G+5745  U+75D2  uni75D2,  CJK UNIFIED IDEOGRAPH-75D2
        0x75D9, # G+5746  U+75D9  uni75D9,  CJK UNIFIED IDEOGRAPH-75D9
        0x75E3, # G+5747  U+75E3  uni75E3,  CJK UNIFIED IDEOGRAPH-75E3
        0x75DE, # G+5748  U+75DE  uni75DE,  CJK UNIFIED IDEOGRAPH-75DE
        0x75FE, # G+5749  U+75FE  uni75FE,  CJK UNIFIED IDEOGRAPH-75FE
        0x75FF, # G+5750  U+75FF  uni75FF,  CJK UNIFIED IDEOGRAPH-75FF
        0x75FC, # G+5751  U+75FC  uni75FC,  CJK UNIFIED IDEOGRAPH-75FC
        0x7601, # G+5752  U+7601  uni7601,  CJK UNIFIED IDEOGRAPH-7601
        0x75F0, # G+5753  U+75F0  uni75F0,  CJK UNIFIED IDEOGRAPH-75F0
        0x75FA, # G+5754  U+75FA  uni75FA,  CJK UNIFIED IDEOGRAPH-75FA
        0x75F2, # G+5755  U+75F2  uni75F2,  CJK UNIFIED IDEOGRAPH-75F2
        0x75F3, # G+5756  U+75F3  uni75F3,  CJK UNIFIED IDEOGRAPH-75F3
        0x760B, # G+5757  U+760B  uni760B,  CJK UNIFIED IDEOGRAPH-760B
        0x760D, # G+5758  U+760D  uni760D,  CJK UNIFIED IDEOGRAPH-760D
        0x7609, # G+5759  U+7609  uni7609,  CJK UNIFIED IDEOGRAPH-7609
        0x761F, # G+5760  U+761F  uni761F,  CJK UNIFIED IDEOGRAPH-761F
        0x7627, # G+5761  U+7627  uni7627,  CJK UNIFIED IDEOGRAPH-7627
        0x7620, # G+5762  U+7620  uni7620,  CJK UNIFIED IDEOGRAPH-7620
        0x7621, # G+5763  U+7621  uni7621,  CJK UNIFIED IDEOGRAPH-7621
        0x7622, # G+5764  U+7622  uni7622,  CJK UNIFIED IDEOGRAPH-7622
        0x7624, # G+5765  U+7624  uni7624,  CJK UNIFIED IDEOGRAPH-7624
        0x7634, # G+5766  U+7634  uni7634,  CJK UNIFIED IDEOGRAPH-7634
        0x7630, # G+5767  U+7630  uni7630,  CJK UNIFIED IDEOGRAPH-7630
        0x763B, # G+5768  U+763B  uni763B,  CJK UNIFIED IDEOGRAPH-763B
        0x7647, # G+5769  U+7647  uni7647,  CJK UNIFIED IDEOGRAPH-7647
        0x7648, # G+5770  U+7648  uni7648,  CJK UNIFIED IDEOGRAPH-7648
        0x7646, # G+5771  U+7646  uni7646,  CJK UNIFIED IDEOGRAPH-7646
        0x765C, # G+5772  U+765C  uni765C,  CJK UNIFIED IDEOGRAPH-765C
        0x7658, # G+5773  U+7658  uni7658,  CJK UNIFIED IDEOGRAPH-7658
        0x7661, # G+5774  U+7661  uni7661,  CJK UNIFIED IDEOGRAPH-7661
        0x7662, # G+5775  U+7662  uni7662,  CJK UNIFIED IDEOGRAPH-7662
        0x7668, # G+5776  U+7668  uni7668,  CJK UNIFIED IDEOGRAPH-7668
        0x7669, # G+5777  U+7669  uni7669,  CJK UNIFIED IDEOGRAPH-7669
        0x766A, # G+5778  U+766A  uni766A,  CJK UNIFIED IDEOGRAPH-766A
        0x7667, # G+5779  U+7667  uni7667,  CJK UNIFIED IDEOGRAPH-7667
        0x766C, # G+5780  U+766C  uni766C,  CJK UNIFIED IDEOGRAPH-766C
        0x7670, # G+5781  U+7670  uni7670,  CJK UNIFIED IDEOGRAPH-7670
        0x7672, # G+5782  U+7672  uni7672,  CJK UNIFIED IDEOGRAPH-7672
        0x2F68, # G+5783  U+2F68  uni2F68,  KANGXI RADICAL DOTTED TENT
        0x7678, # G+5784  U+7678  uni7678,  CJK UNIFIED IDEOGRAPH-7678
        0x767C, # G+5785  U+767C  uni767C,  CJK UNIFIED IDEOGRAPH-767C
        0x7680, # G+5786  U+7680  uni7680,  CJK UNIFIED IDEOGRAPH-7680
        0x7683, # G+5787  U+7683  uni7683,  CJK UNIFIED IDEOGRAPH-7683
        0x7688, # G+5788  U+7688  uni7688,  CJK UNIFIED IDEOGRAPH-7688
        0x768B, # G+5789  U+768B  uni768B,  CJK UNIFIED IDEOGRAPH-768B
        0x768E, # G+5790  U+768E  uni768E,  CJK UNIFIED IDEOGRAPH-768E
        0x7696, # G+5791  U+7696  uni7696,  CJK UNIFIED IDEOGRAPH-7696
        0x7693, # G+5792  U+7693  uni7693,  CJK UNIFIED IDEOGRAPH-7693
        0x7699, # G+5793  U+7699  uni7699,  CJK UNIFIED IDEOGRAPH-7699
        0x769A, # G+5794  U+769A  uni769A,  CJK UNIFIED IDEOGRAPH-769A
        0x76B0, # G+5795  U+76B0  uni76B0,  CJK UNIFIED IDEOGRAPH-76B0
        0x76B4, # G+5796  U+76B4  uni76B4,  CJK UNIFIED IDEOGRAPH-76B4
        0x76B8, # G+5797  U+76B8  uni76B8,  CJK UNIFIED IDEOGRAPH-76B8
        0x76B9, # G+5798  U+76B9  uni76B9,  CJK UNIFIED IDEOGRAPH-76B9
        0x76BA, # G+5799  U+76BA  uni76BA,  CJK UNIFIED IDEOGRAPH-76BA
        0x76C2, # G+5800  U+76C2  uni76C2,  CJK UNIFIED IDEOGRAPH-76C2
        0x76CD, # G+5801  U+76CD  uni76CD,  CJK UNIFIED IDEOGRAPH-76CD
        0x76D6, # G+5802  U+76D6  uni76D6,  CJK UNIFIED IDEOGRAPH-76D6
        0x76D2, # G+5803  U+76D2  uni76D2,  CJK UNIFIED IDEOGRAPH-76D2
        0x76DE, # G+5804  U+76DE  uni76DE,  CJK UNIFIED IDEOGRAPH-76DE
        0x76E1, # G+5805  U+76E1  uni76E1,  CJK UNIFIED IDEOGRAPH-76E1
        0x76E5, # G+5806  U+76E5  uni76E5,  CJK UNIFIED IDEOGRAPH-76E5
        0x76E7, # G+5807  U+76E7  uni76E7,  CJK UNIFIED IDEOGRAPH-76E7
        0x76EA, # G+5808  U+76EA  uni76EA,  CJK UNIFIED IDEOGRAPH-76EA
        0x862F, # G+5809  U+862F  uni862F,  CJK UNIFIED IDEOGRAPH-862F
        0x76FB, # G+5810  U+76FB  uni76FB,  CJK UNIFIED IDEOGRAPH-76FB
        0x7708, # G+5811  U+7708  uni7708,  CJK UNIFIED IDEOGRAPH-7708
        0x7707, # G+5812  U+7707  uni7707,  CJK UNIFIED IDEOGRAPH-7707
        0x7704, # G+5813  U+7704  uni7704,  CJK UNIFIED IDEOGRAPH-7704
        0x7729, # G+5814  U+7729  uni7729,  CJK UNIFIED IDEOGRAPH-7729
        0x7724, # G+5815  U+7724  uni7724,  CJK UNIFIED IDEOGRAPH-7724
        0x771E, # G+5816  U+771E  uni771E,  CJK UNIFIED IDEOGRAPH-771E
        0x7725, # G+5817  U+7725  uni7725,  CJK UNIFIED IDEOGRAPH-7725
        0x7726, # G+5818  U+7726  uni7726,  CJK UNIFIED IDEOGRAPH-7726
        0x771B, # G+5819  U+771B  uni771B,  CJK UNIFIED IDEOGRAPH-771B
        0x7737, # G+5820  U+7737  uni7737,  CJK UNIFIED IDEOGRAPH-7737
        0x7738, # G+5821  U+7738  uni7738,  CJK UNIFIED IDEOGRAPH-7738
        0x7747, # G+5822  U+7747  uni7747,  CJK UNIFIED IDEOGRAPH-7747
        0x775A, # G+5823  U+775A  uni775A,  CJK UNIFIED IDEOGRAPH-775A
        0x7768, # G+5824  U+7768  uni7768,  CJK UNIFIED IDEOGRAPH-7768
        0x776B, # G+5825  U+776B  uni776B,  CJK UNIFIED IDEOGRAPH-776B
        0x775B, # G+5826  U+775B  uni775B,  CJK UNIFIED IDEOGRAPH-775B
        0x7765, # G+5827  U+7765  uni7765,  CJK UNIFIED IDEOGRAPH-7765
        0x777F, # G+5828  U+777F  uni777F,  CJK UNIFIED IDEOGRAPH-777F
        0x777E, # G+5829  U+777E  uni777E,  CJK UNIFIED IDEOGRAPH-777E
        0x7779, # G+5830  U+7779  uni7779,  CJK UNIFIED IDEOGRAPH-7779
        0x778E, # G+5831  U+778E  uni778E,  CJK UNIFIED IDEOGRAPH-778E
        0x778B, # G+5832  U+778B  uni778B,  CJK UNIFIED IDEOGRAPH-778B
        0x7791, # G+5833  U+7791  uni7791,  CJK UNIFIED IDEOGRAPH-7791
        0x77A0, # G+5834  U+77A0  uni77A0,  CJK UNIFIED IDEOGRAPH-77A0
        0x779E, # G+5835  U+779E  uni779E,  CJK UNIFIED IDEOGRAPH-779E
        0x77B0, # G+5836  U+77B0  uni77B0,  CJK UNIFIED IDEOGRAPH-77B0
        0x77B6, # G+5837  U+77B6  uni77B6,  CJK UNIFIED IDEOGRAPH-77B6
        0x77B9, # G+5838  U+77B9  uni77B9,  CJK UNIFIED IDEOGRAPH-77B9
        0x77BF, # G+5839  U+77BF  uni77BF,  CJK UNIFIED IDEOGRAPH-77BF
        0x77BC, # G+5840  U+77BC  uni77BC,  CJK UNIFIED IDEOGRAPH-77BC
        0x77BD, # G+5841  U+77BD  uni77BD,  CJK UNIFIED IDEOGRAPH-77BD
        0x77BB, # G+5842  U+77BB  uni77BB,  CJK UNIFIED IDEOGRAPH-77BB
        0x77C7, # G+5843  U+77C7  uni77C7,  CJK UNIFIED IDEOGRAPH-77C7
        0x77CD, # G+5844  U+77CD  uni77CD,  CJK UNIFIED IDEOGRAPH-77CD
        0x77D7, # G+5845  U+77D7  uni77D7,  CJK UNIFIED IDEOGRAPH-77D7
        0x77DA, # G+5846  U+77DA  uni77DA,  CJK UNIFIED IDEOGRAPH-77DA
        0x77DC, # G+5847  U+77DC  uni77DC,  CJK UNIFIED IDEOGRAPH-77DC
        0x77E3, # G+5848  U+77E3  uni77E3,  CJK UNIFIED IDEOGRAPH-77E3
        0x77EE, # G+5849  U+77EE  uni77EE,  CJK UNIFIED IDEOGRAPH-77EE
        0x77FC, # G+5850  U+77FC  uni77FC,  CJK UNIFIED IDEOGRAPH-77FC
        0x780C, # G+5851  U+780C  uni780C,  CJK UNIFIED IDEOGRAPH-780C
        0x7812, # G+5852  U+7812  uni7812,  CJK UNIFIED IDEOGRAPH-7812
        0x7926, # G+5853  U+7926  uni7926,  CJK UNIFIED IDEOGRAPH-7926
        0x7820, # G+5854  U+7820  uni7820,  CJK UNIFIED IDEOGRAPH-7820
        0x792A, # G+5855  U+792A  uni792A,  CJK UNIFIED IDEOGRAPH-792A
        0x7845, # G+5856  U+7845  uni7845,  CJK UNIFIED IDEOGRAPH-7845
        0x788E, # G+5857  U+788E  uni788E,  CJK UNIFIED IDEOGRAPH-788E
        0x7874, # G+5858  U+7874  uni7874,  CJK UNIFIED IDEOGRAPH-7874
        0x7886, # G+5859  U+7886  uni7886,  CJK UNIFIED IDEOGRAPH-7886
        0x787C, # G+5860  U+787C  uni787C,  CJK UNIFIED IDEOGRAPH-787C
        0x789A, # G+5861  U+789A  uni789A,  CJK UNIFIED IDEOGRAPH-789A
        0x788C, # G+5862  U+788C  uni788C,  CJK UNIFIED IDEOGRAPH-788C
        0x78A3, # G+5863  U+78A3  uni78A3,  CJK UNIFIED IDEOGRAPH-78A3
        0x78B5, # G+5864  U+78B5  uni78B5,  CJK UNIFIED IDEOGRAPH-78B5
        0x78AA, # G+5865  U+78AA  uni78AA,  CJK UNIFIED IDEOGRAPH-78AA
        0x78AF, # G+5866  U+78AF  uni78AF,  CJK UNIFIED IDEOGRAPH-78AF
        0x78D1, # G+5867  U+78D1  uni78D1,  CJK UNIFIED IDEOGRAPH-78D1
        0x78C6, # G+5868  U+78C6  uni78C6,  CJK UNIFIED IDEOGRAPH-78C6
        0x78CB, # G+5869  U+78CB  uni78CB,  CJK UNIFIED IDEOGRAPH-78CB
        0x78D4, # G+5870  U+78D4  uni78D4,  CJK UNIFIED IDEOGRAPH-78D4
        0x78BE, # G+5871  U+78BE  uni78BE,  CJK UNIFIED IDEOGRAPH-78BE
        0x78BC, # G+5872  U+78BC  uni78BC,  CJK UNIFIED IDEOGRAPH-78BC
        0x78C5, # G+5873  U+78C5  uni78C5,  CJK UNIFIED IDEOGRAPH-78C5
        0x78CA, # G+5874  U+78CA  uni78CA,  CJK UNIFIED IDEOGRAPH-78CA
        0x78EC, # G+5875  U+78EC  uni78EC,  CJK UNIFIED IDEOGRAPH-78EC
        0x78E7, # G+5876  U+78E7  uni78E7,  CJK UNIFIED IDEOGRAPH-78E7
        0x78DA, # G+5877  U+78DA  uni78DA,  CJK UNIFIED IDEOGRAPH-78DA
        0x78FD, # G+5878  U+78FD  uni78FD,  CJK UNIFIED IDEOGRAPH-78FD
        0x78F4, # G+5879  U+78F4  uni78F4,  CJK UNIFIED IDEOGRAPH-78F4
        0x7907, # G+5880  U+7907  uni7907,  CJK UNIFIED IDEOGRAPH-7907
        0x7912, # G+5881  U+7912  uni7912,  CJK UNIFIED IDEOGRAPH-7912
        0x7911, # G+5882  U+7911  uni7911,  CJK UNIFIED IDEOGRAPH-7911
        0x7919, # G+5883  U+7919  uni7919,  CJK UNIFIED IDEOGRAPH-7919
        0x792C, # G+5884  U+792C  uni792C,  CJK UNIFIED IDEOGRAPH-792C
        0x792B, # G+5885  U+792B  uni792B,  CJK UNIFIED IDEOGRAPH-792B
        0x7940, # G+5886  U+7940  uni7940,  CJK UNIFIED IDEOGRAPH-7940
        0x7960, # G+5887  U+7960  uni7960,  CJK UNIFIED IDEOGRAPH-7960
        0x7957, # G+5888  U+7957  uni7957,  CJK UNIFIED IDEOGRAPH-7957
        0x795F, # G+5889  U+795F  uni795F,  CJK UNIFIED IDEOGRAPH-795F
        0x795A, # G+5890  U+795A  uni795A,  CJK UNIFIED IDEOGRAPH-795A
        0x7955, # G+5891  U+7955  uni7955,  CJK UNIFIED IDEOGRAPH-7955
        0x7953, # G+5892  U+7953  uni7953,  CJK UNIFIED IDEOGRAPH-7953
        0x797A, # G+5893  U+797A  uni797A,  CJK UNIFIED IDEOGRAPH-797A
        0x797F, # G+5894  U+797F  uni797F,  CJK UNIFIED IDEOGRAPH-797F
        0x798A, # G+5895  U+798A  uni798A,  CJK UNIFIED IDEOGRAPH-798A
        0x799D, # G+5896  U+799D  uni799D,  CJK UNIFIED IDEOGRAPH-799D
        0x79A7, # G+5897  U+79A7  uni79A7,  CJK UNIFIED IDEOGRAPH-79A7
        0x9F4B, # G+5898  U+9F4B  uni9F4B,  CJK UNIFIED IDEOGRAPH-9F4B
        0x79AA, # G+5899  U+79AA  uni79AA,  CJK UNIFIED IDEOGRAPH-79AA
        0x79AE, # G+5900  U+79AE  uni79AE,  CJK UNIFIED IDEOGRAPH-79AE
        0x79B3, # G+5901  U+79B3  uni79B3,  CJK UNIFIED IDEOGRAPH-79B3
        0x79B9, # G+5902  U+79B9  uni79B9,  CJK UNIFIED IDEOGRAPH-79B9
        0x79BA, # G+5903  U+79BA  uni79BA,  CJK UNIFIED IDEOGRAPH-79BA
        0x79C9, # G+5904  U+79C9  uni79C9,  CJK UNIFIED IDEOGRAPH-79C9
        0x79D5, # G+5905  U+79D5  uni79D5,  CJK UNIFIED IDEOGRAPH-79D5
        0x79E7, # G+5906  U+79E7  uni79E7,  CJK UNIFIED IDEOGRAPH-79E7
        0x79EC, # G+5907  U+79EC  uni79EC,  CJK UNIFIED IDEOGRAPH-79EC
        0x79E1, # G+5908  U+79E1  uni79E1,  CJK UNIFIED IDEOGRAPH-79E1
        0x79E3, # G+5909  U+79E3  uni79E3,  CJK UNIFIED IDEOGRAPH-79E3
        0x7A08, # G+5910  U+7A08  uni7A08,  CJK UNIFIED IDEOGRAPH-7A08
        0x7A0D, # G+5911  U+7A0D  uni7A0D,  CJK UNIFIED IDEOGRAPH-7A0D
        0x7A18, # G+5912  U+7A18  uni7A18,  CJK UNIFIED IDEOGRAPH-7A18
        0x7A19, # G+5913  U+7A19  uni7A19,  CJK UNIFIED IDEOGRAPH-7A19
        0x7A20, # G+5914  U+7A20  uni7A20,  CJK UNIFIED IDEOGRAPH-7A20
        0x7A1F, # G+5915  U+7A1F  uni7A1F,  CJK UNIFIED IDEOGRAPH-7A1F
        0x7980, # G+5916  U+7980  uni7980,  CJK UNIFIED IDEOGRAPH-7980
        0x7A31, # G+5917  U+7A31  uni7A31,  CJK UNIFIED IDEOGRAPH-7A31
        0x7A3B, # G+5918  U+7A3B  uni7A3B,  CJK UNIFIED IDEOGRAPH-7A3B
        0x7A3E, # G+5919  U+7A3E  uni7A3E,  CJK UNIFIED IDEOGRAPH-7A3E
        0x7A37, # G+5920  U+7A37  uni7A37,  CJK UNIFIED IDEOGRAPH-7A37
        0x7A43, # G+5921  U+7A43  uni7A43,  CJK UNIFIED IDEOGRAPH-7A43
        0x7A57, # G+5922  U+7A57  uni7A57,  CJK UNIFIED IDEOGRAPH-7A57
        0x7A49, # G+5923  U+7A49  uni7A49,  CJK UNIFIED IDEOGRAPH-7A49
        0x7A61, # G+5924  U+7A61  uni7A61,  CJK UNIFIED IDEOGRAPH-7A61
        0x7A62, # G+5925  U+7A62  uni7A62,  CJK UNIFIED IDEOGRAPH-7A62
        0x7A69, # G+5926  U+7A69  uni7A69,  CJK UNIFIED IDEOGRAPH-7A69
        0x9F9D, # G+5927  U+9F9D  uni9F9D,  CJK UNIFIED IDEOGRAPH-9F9D
        0x7A70, # G+5928  U+7A70  uni7A70,  CJK UNIFIED IDEOGRAPH-7A70
        0x7A79, # G+5929  U+7A79  uni7A79,  CJK UNIFIED IDEOGRAPH-7A79
        0x7A7D, # G+5930  U+7A7D  uni7A7D,  CJK UNIFIED IDEOGRAPH-7A7D
        0x7A88, # G+5931  U+7A88  uni7A88,  CJK UNIFIED IDEOGRAPH-7A88
        0x7A97, # G+5932  U+7A97  uni7A97,  CJK UNIFIED IDEOGRAPH-7A97
        0x7A95, # G+5933  U+7A95  uni7A95,  CJK UNIFIED IDEOGRAPH-7A95
        0x7A98, # G+5934  U+7A98  uni7A98,  CJK UNIFIED IDEOGRAPH-7A98
        0x7A96, # G+5935  U+7A96  uni7A96,  CJK UNIFIED IDEOGRAPH-7A96
        0x7AA9, # G+5936  U+7AA9  uni7AA9,  CJK UNIFIED IDEOGRAPH-7AA9
        0x7AC8, # G+5937  U+7AC8  uni7AC8,  CJK UNIFIED IDEOGRAPH-7AC8
        0x7AB0, # G+5938  U+7AB0  uni7AB0,  CJK UNIFIED IDEOGRAPH-7AB0
        0x7AB6, # G+5939  U+7AB6  uni7AB6,  CJK UNIFIED IDEOGRAPH-7AB6
        0x7AC5, # G+5940  U+7AC5  uni7AC5,  CJK UNIFIED IDEOGRAPH-7AC5
        0x7AC4, # G+5941  U+7AC4  uni7AC4,  CJK UNIFIED IDEOGRAPH-7AC4
        0x7ABF, # G+5942  U+7ABF  uni7ABF,  CJK UNIFIED IDEOGRAPH-7ABF
        0x9083, # G+5943  U+9083  uni9083,  CJK UNIFIED IDEOGRAPH-9083
        0x7AC7, # G+5944  U+7AC7  uni7AC7,  CJK UNIFIED IDEOGRAPH-7AC7
        0x7ACA, # G+5945  U+7ACA  uni7ACA,  CJK UNIFIED IDEOGRAPH-7ACA
        0x7ACD, # G+5946  U+7ACD  uni7ACD,  CJK UNIFIED IDEOGRAPH-7ACD
        0x7ACF, # G+5947  U+7ACF  uni7ACF,  CJK UNIFIED IDEOGRAPH-7ACF
        0x7AD5, # G+5948  U+7AD5  uni7AD5,  CJK UNIFIED IDEOGRAPH-7AD5
        0x7AD3, # G+5949  U+7AD3  uni7AD3,  CJK UNIFIED IDEOGRAPH-7AD3
        0x7AD9, # G+5950  U+7AD9  uni7AD9,  CJK UNIFIED IDEOGRAPH-7AD9
        0x7ADA, # G+5951  U+7ADA  uni7ADA,  CJK UNIFIED IDEOGRAPH-7ADA
        0x7ADD, # G+5952  U+7ADD  uni7ADD,  CJK UNIFIED IDEOGRAPH-7ADD
        0x7AE1, # G+5953  U+7AE1  uni7AE1,  CJK UNIFIED IDEOGRAPH-7AE1
        0x7AE2, # G+5954  U+7AE2  uni7AE2,  CJK UNIFIED IDEOGRAPH-7AE2
        0x7AE6, # G+5955  U+7AE6  uni7AE6,  CJK UNIFIED IDEOGRAPH-7AE6
        0x7AED, # G+5956  U+7AED  uni7AED,  CJK UNIFIED IDEOGRAPH-7AED
        0x7AF0, # G+5957  U+7AF0  uni7AF0,  CJK UNIFIED IDEOGRAPH-7AF0
        0x7B02, # G+5958  U+7B02  uni7B02,  CJK UNIFIED IDEOGRAPH-7B02
        0x7B0F, # G+5959  U+7B0F  uni7B0F,  CJK UNIFIED IDEOGRAPH-7B0F
        0x7B0A, # G+5960  U+7B0A  uni7B0A,  CJK UNIFIED IDEOGRAPH-7B0A
        0x7B06, # G+5961  U+7B06  uni7B06,  CJK UNIFIED IDEOGRAPH-7B06
        0x7B33, # G+5962  U+7B33  uni7B33,  CJK UNIFIED IDEOGRAPH-7B33
        0x7B18, # G+5963  U+7B18  uni7B18,  CJK UNIFIED IDEOGRAPH-7B18
        0x7B19, # G+5964  U+7B19  uni7B19,  CJK UNIFIED IDEOGRAPH-7B19
        0x7B1E, # G+5965  U+7B1E  uni7B1E,  CJK UNIFIED IDEOGRAPH-7B1E
        0x7B35, # G+5966  U+7B35  uni7B35,  CJK UNIFIED IDEOGRAPH-7B35
        0x7B28, # G+5967  U+7B28  uni7B28,  CJK UNIFIED IDEOGRAPH-7B28
        0x7B36, # G+5968  U+7B36  uni7B36,  CJK UNIFIED IDEOGRAPH-7B36
        0x7B50, # G+5969  U+7B50  uni7B50,  CJK UNIFIED IDEOGRAPH-7B50
        0x7B7A, # G+5970  U+7B7A  uni7B7A,  CJK UNIFIED IDEOGRAPH-7B7A
        0x7B04, # G+5971  U+7B04  uni7B04,  CJK UNIFIED IDEOGRAPH-7B04
        0x7B4D, # G+5972  U+7B4D  uni7B4D,  CJK UNIFIED IDEOGRAPH-7B4D
        0x7B0B, # G+5973  U+7B0B  uni7B0B,  CJK UNIFIED IDEOGRAPH-7B0B
        0x7B4C, # G+5974  U+7B4C  uni7B4C,  CJK UNIFIED IDEOGRAPH-7B4C
        0x7B45, # G+5975  U+7B45  uni7B45,  CJK UNIFIED IDEOGRAPH-7B45
        0x7B75, # G+5976  U+7B75  uni7B75,  CJK UNIFIED IDEOGRAPH-7B75
        0x7B65, # G+5977  U+7B65  uni7B65,  CJK UNIFIED IDEOGRAPH-7B65
        0x7B74, # G+5978  U+7B74  uni7B74,  CJK UNIFIED IDEOGRAPH-7B74
        0x7B67, # G+5979  U+7B67  uni7B67,  CJK UNIFIED IDEOGRAPH-7B67
        0x7B70, # G+5980  U+7B70  uni7B70,  CJK UNIFIED IDEOGRAPH-7B70
        0x7B71, # G+5981  U+7B71  uni7B71,  CJK UNIFIED IDEOGRAPH-7B71
        0x7B6C, # G+5982  U+7B6C  uni7B6C,  CJK UNIFIED IDEOGRAPH-7B6C
        0x7B6E, # G+5983  U+7B6E  uni7B6E,  CJK UNIFIED IDEOGRAPH-7B6E
        0x7B9D, # G+5984  U+7B9D  uni7B9D,  CJK UNIFIED IDEOGRAPH-7B9D
        0x7B98, # G+5985  U+7B98  uni7B98,  CJK UNIFIED IDEOGRAPH-7B98
        0x7B9F, # G+5986  U+7B9F  uni7B9F,  CJK UNIFIED IDEOGRAPH-7B9F
        0x7B8D, # G+5987  U+7B8D  uni7B8D,  CJK UNIFIED IDEOGRAPH-7B8D
        0x7B9C, # G+5988  U+7B9C  uni7B9C,  CJK UNIFIED IDEOGRAPH-7B9C
        0x7B9A, # G+5989  U+7B9A  uni7B9A,  CJK UNIFIED IDEOGRAPH-7B9A
        0x7B8B, # G+5990  U+7B8B  uni7B8B,  CJK UNIFIED IDEOGRAPH-7B8B
        0x7B92, # G+5991  U+7B92  uni7B92,  CJK UNIFIED IDEOGRAPH-7B92
        0x7B8F, # G+5992  U+7B8F  uni7B8F,  CJK UNIFIED IDEOGRAPH-7B8F
        0x7B5D, # G+5993  U+7B5D  uni7B5D,  CJK UNIFIED IDEOGRAPH-7B5D
        0x7B99, # G+5994  U+7B99  uni7B99,  CJK UNIFIED IDEOGRAPH-7B99
        0x7BCB, # G+5995  U+7BCB  uni7BCB,  CJK UNIFIED IDEOGRAPH-7BCB
        0x7BC1, # G+5996  U+7BC1  uni7BC1,  CJK UNIFIED IDEOGRAPH-7BC1
        0x7BCC, # G+5997  U+7BCC  uni7BCC,  CJK UNIFIED IDEOGRAPH-7BCC
        0x7BCF, # G+5998  U+7BCF  uni7BCF,  CJK UNIFIED IDEOGRAPH-7BCF
        0x7BB4, # G+5999  U+7BB4  uni7BB4,  CJK UNIFIED IDEOGRAPH-7BB4
        0x7BC6, # G+6000  U+7BC6  uni7BC6,  CJK UNIFIED IDEOGRAPH-7BC6
        0x7BDD, # G+6001  U+7BDD  uni7BDD,  CJK UNIFIED IDEOGRAPH-7BDD
        0x7BE9, # G+6002  U+7BE9  uni7BE9,  CJK UNIFIED IDEOGRAPH-7BE9
        0x7C11, # G+6003  U+7C11  uni7C11,  CJK UNIFIED IDEOGRAPH-7C11
        0x7C14, # G+6004  U+7C14  uni7C14,  CJK UNIFIED IDEOGRAPH-7C14
        0x7BE6, # G+6005  U+7BE6  uni7BE6,  CJK UNIFIED IDEOGRAPH-7BE6
        0x7BE5, # G+6006  U+7BE5  uni7BE5,  CJK UNIFIED IDEOGRAPH-7BE5
        0x7C60, # G+6007  U+7C60  uni7C60,  CJK UNIFIED IDEOGRAPH-7C60
        0x7C00, # G+6008  U+7C00  uni7C00,  CJK UNIFIED IDEOGRAPH-7C00
        0x7C07, # G+6009  U+7C07  uni7C07,  CJK UNIFIED IDEOGRAPH-7C07
        0x7C13, # G+6010  U+7C13  uni7C13,  CJK UNIFIED IDEOGRAPH-7C13
        0x7BF3, # G+6011  U+7BF3  uni7BF3,  CJK UNIFIED IDEOGRAPH-7BF3
        0x7BF7, # G+6012  U+7BF7  uni7BF7,  CJK UNIFIED IDEOGRAPH-7BF7
        0x7C17, # G+6013  U+7C17  uni7C17,  CJK UNIFIED IDEOGRAPH-7C17
        0x7C0D, # G+6014  U+7C0D  uni7C0D,  CJK UNIFIED IDEOGRAPH-7C0D
        0x7BF6, # G+6015  U+7BF6  uni7BF6,  CJK UNIFIED IDEOGRAPH-7BF6
        0x7C23, # G+6016  U+7C23  uni7C23,  CJK UNIFIED IDEOGRAPH-7C23
        0x7C27, # G+6017  U+7C27  uni7C27,  CJK UNIFIED IDEOGRAPH-7C27
        0x7C2A, # G+6018  U+7C2A  uni7C2A,  CJK UNIFIED IDEOGRAPH-7C2A
        0x7C1F, # G+6019  U+7C1F  uni7C1F,  CJK UNIFIED IDEOGRAPH-7C1F
        0x7C37, # G+6020  U+7C37  uni7C37,  CJK UNIFIED IDEOGRAPH-7C37
        0x7C2B, # G+6021  U+7C2B  uni7C2B,  CJK UNIFIED IDEOGRAPH-7C2B
        0x7C3D, # G+6022  U+7C3D  uni7C3D,  CJK UNIFIED IDEOGRAPH-7C3D
        0x7C4C, # G+6023  U+7C4C  uni7C4C,  CJK UNIFIED IDEOGRAPH-7C4C
        0x7C43, # G+6024  U+7C43  uni7C43,  CJK UNIFIED IDEOGRAPH-7C43
        0x7C54, # G+6025  U+7C54  uni7C54,  CJK UNIFIED IDEOGRAPH-7C54
        0x7C4F, # G+6026  U+7C4F  uni7C4F,  CJK UNIFIED IDEOGRAPH-7C4F
        0x7C40, # G+6027  U+7C40  uni7C40,  CJK UNIFIED IDEOGRAPH-7C40
        0x7C50, # G+6028  U+7C50  uni7C50,  CJK UNIFIED IDEOGRAPH-7C50
        0x7C58, # G+6029  U+7C58  uni7C58,  CJK UNIFIED IDEOGRAPH-7C58
        0x7C5F, # G+6030  U+7C5F  uni7C5F,  CJK UNIFIED IDEOGRAPH-7C5F
        0x7C64, # G+6031  U+7C64  uni7C64,  CJK UNIFIED IDEOGRAPH-7C64
        0x7C56, # G+6032  U+7C56  uni7C56,  CJK UNIFIED IDEOGRAPH-7C56
        0x7C65, # G+6033  U+7C65  uni7C65,  CJK UNIFIED IDEOGRAPH-7C65
        0x7C6C, # G+6034  U+7C6C  uni7C6C,  CJK UNIFIED IDEOGRAPH-7C6C
        0x7C75, # G+6035  U+7C75  uni7C75,  CJK UNIFIED IDEOGRAPH-7C75
        0x7C83, # G+6036  U+7C83  uni7C83,  CJK UNIFIED IDEOGRAPH-7C83
        0x7C90, # G+6037  U+7C90  uni7C90,  CJK UNIFIED IDEOGRAPH-7C90
        0x7CA4, # G+6038  U+7CA4  uni7CA4,  CJK UNIFIED IDEOGRAPH-7CA4
        0x7CAD, # G+6039  U+7CAD  uni7CAD,  CJK UNIFIED IDEOGRAPH-7CAD
        0x7CA2, # G+6040  U+7CA2  uni7CA2,  CJK UNIFIED IDEOGRAPH-7CA2
        0x7CAB, # G+6041  U+7CAB  uni7CAB,  CJK UNIFIED IDEOGRAPH-7CAB
        0x7CA1, # G+6042  U+7CA1  uni7CA1,  CJK UNIFIED IDEOGRAPH-7CA1
        0x7CA8, # G+6043  U+7CA8  uni7CA8,  CJK UNIFIED IDEOGRAPH-7CA8
        0x7CB3, # G+6044  U+7CB3  uni7CB3,  CJK UNIFIED IDEOGRAPH-7CB3
        0x7CB2, # G+6045  U+7CB2  uni7CB2,  CJK UNIFIED IDEOGRAPH-7CB2
        0x7CB1, # G+6046  U+7CB1  uni7CB1,  CJK UNIFIED IDEOGRAPH-7CB1
        0x7CAE, # G+6047  U+7CAE  uni7CAE,  CJK UNIFIED IDEOGRAPH-7CAE
        0x7CB9, # G+6048  U+7CB9  uni7CB9,  CJK UNIFIED IDEOGRAPH-7CB9
        0x7CBD, # G+6049  U+7CBD  uni7CBD,  CJK UNIFIED IDEOGRAPH-7CBD
        0x7CC0, # G+6050  U+7CC0  uni7CC0,  CJK UNIFIED IDEOGRAPH-7CC0
        0x7CC5, # G+6051  U+7CC5  uni7CC5,  CJK UNIFIED IDEOGRAPH-7CC5
        0x7CC2, # G+6052  U+7CC2  uni7CC2,  CJK UNIFIED IDEOGRAPH-7CC2
        0x7CD8, # G+6053  U+7CD8  uni7CD8,  CJK UNIFIED IDEOGRAPH-7CD8
        0x7CD2, # G+6054  U+7CD2  uni7CD2,  CJK UNIFIED IDEOGRAPH-7CD2
        0x7CDC, # G+6055  U+7CDC  uni7CDC,  CJK UNIFIED IDEOGRAPH-7CDC
        0x7CE2, # G+6056  U+7CE2  uni7CE2,  CJK UNIFIED IDEOGRAPH-7CE2
        0x9B3B, # G+6057  U+9B3B  uni9B3B,  CJK UNIFIED IDEOGRAPH-9B3B
        0x7CEF, # G+6058  U+7CEF  uni7CEF,  CJK UNIFIED IDEOGRAPH-7CEF
        0x7CF2, # G+6059  U+7CF2  uni7CF2,  CJK UNIFIED IDEOGRAPH-7CF2
        0x7CF4, # G+6060  U+7CF4  uni7CF4,  CJK UNIFIED IDEOGRAPH-7CF4
        0x7CF6, # G+6061  U+7CF6  uni7CF6,  CJK UNIFIED IDEOGRAPH-7CF6
        0x7CFA, # G+6062  U+7CFA  uni7CFA,  CJK UNIFIED IDEOGRAPH-7CFA
        0x7D06, # G+6063  U+7D06  uni7D06,  CJK UNIFIED IDEOGRAPH-7D06
        0x7D02, # G+6064  U+7D02  uni7D02,  CJK UNIFIED IDEOGRAPH-7D02
        0x7D1C, # G+6065  U+7D1C  uni7D1C,  CJK UNIFIED IDEOGRAPH-7D1C
        0x7D15, # G+6066  U+7D15  uni7D15,  CJK UNIFIED IDEOGRAPH-7D15
        0x7D0A, # G+6067  U+7D0A  uni7D0A,  CJK UNIFIED IDEOGRAPH-7D0A
        0x7D45, # G+6068  U+7D45  uni7D45,  CJK UNIFIED IDEOGRAPH-7D45
        0x7D4B, # G+6069  U+7D4B  uni7D4B,  CJK UNIFIED IDEOGRAPH-7D4B
        0x7D2E, # G+6070  U+7D2E  uni7D2E,  CJK UNIFIED IDEOGRAPH-7D2E
        0x7D32, # G+6071  U+7D32  uni7D32,  CJK UNIFIED IDEOGRAPH-7D32
        0x7D3F, # G+6072  U+7D3F  uni7D3F,  CJK UNIFIED IDEOGRAPH-7D3F
        0x7D35, # G+6073  U+7D35  uni7D35,  CJK UNIFIED IDEOGRAPH-7D35
        0x7D46, # G+6074  U+7D46  uni7D46,  CJK UNIFIED IDEOGRAPH-7D46
        0x7D73, # G+6075  U+7D73  uni7D73,  CJK UNIFIED IDEOGRAPH-7D73
        0x7D56, # G+6076  U+7D56  uni7D56,  CJK UNIFIED IDEOGRAPH-7D56
        0x7D4E, # G+6077  U+7D4E  uni7D4E,  CJK UNIFIED IDEOGRAPH-7D4E
        0x7D72, # G+6078  U+7D72  uni7D72,  CJK UNIFIED IDEOGRAPH-7D72
        0x7D68, # G+6079  U+7D68  uni7D68,  CJK UNIFIED IDEOGRAPH-7D68
        0x7D6E, # G+6080  U+7D6E  uni7D6E,  CJK UNIFIED IDEOGRAPH-7D6E
        0x7D4F, # G+6081  U+7D4F  uni7D4F,  CJK UNIFIED IDEOGRAPH-7D4F
        0x7D63, # G+6082  U+7D63  uni7D63,  CJK UNIFIED IDEOGRAPH-7D63
        0x7D93, # G+6083  U+7D93  uni7D93,  CJK UNIFIED IDEOGRAPH-7D93
        0x7D89, # G+6084  U+7D89  uni7D89,  CJK UNIFIED IDEOGRAPH-7D89
        0x7D5B, # G+6085  U+7D5B  uni7D5B,  CJK UNIFIED IDEOGRAPH-7D5B
        0x7D8F, # G+6086  U+7D8F  uni7D8F,  CJK UNIFIED IDEOGRAPH-7D8F
        0x7D7D, # G+6087  U+7D7D  uni7D7D,  CJK UNIFIED IDEOGRAPH-7D7D
        0x7D9B, # G+6088  U+7D9B  uni7D9B,  CJK UNIFIED IDEOGRAPH-7D9B
        0x7DBA, # G+6089  U+7DBA  uni7DBA,  CJK UNIFIED IDEOGRAPH-7DBA
        0x7DAE, # G+6090  U+7DAE  uni7DAE,  CJK UNIFIED IDEOGRAPH-7DAE
        0x7DA3, # G+6091  U+7DA3  uni7DA3,  CJK UNIFIED IDEOGRAPH-7DA3
        0x7DB5, # G+6092  U+7DB5  uni7DB5,  CJK UNIFIED IDEOGRAPH-7DB5
        0x7DC7, # G+6093  U+7DC7  uni7DC7,  CJK UNIFIED IDEOGRAPH-7DC7
        0x7DBD, # G+6094  U+7DBD  uni7DBD,  CJK UNIFIED IDEOGRAPH-7DBD
        0x7DAB, # G+6095  U+7DAB  uni7DAB,  CJK UNIFIED IDEOGRAPH-7DAB
        0x7E3D, # G+6096  U+7E3D  uni7E3D,  CJK UNIFIED IDEOGRAPH-7E3D
        0x7DA2, # G+6097  U+7DA2  uni7DA2,  CJK UNIFIED IDEOGRAPH-7DA2
        0x7DAF, # G+6098  U+7DAF  uni7DAF,  CJK UNIFIED IDEOGRAPH-7DAF
        0x7DDC, # G+6099  U+7DDC  uni7DDC,  CJK UNIFIED IDEOGRAPH-7DDC
        0x7DB8, # G+6100  U+7DB8  uni7DB8,  CJK UNIFIED IDEOGRAPH-7DB8
        0x7D9F, # G+6101  U+7D9F  uni7D9F,  CJK UNIFIED IDEOGRAPH-7D9F
        0x7DB0, # G+6102  U+7DB0  uni7DB0,  CJK UNIFIED IDEOGRAPH-7DB0
        0x7DD8, # G+6103  U+7DD8  uni7DD8,  CJK UNIFIED IDEOGRAPH-7DD8
        0x7DDD, # G+6104  U+7DDD  uni7DDD,  CJK UNIFIED IDEOGRAPH-7DDD
        0x7DE4, # G+6105  U+7DE4  uni7DE4,  CJK UNIFIED IDEOGRAPH-7DE4
        0x7DDE, # G+6106  U+7DDE  uni7DDE,  CJK UNIFIED IDEOGRAPH-7DDE
        0x7DFB, # G+6107  U+7DFB  uni7DFB,  CJK UNIFIED IDEOGRAPH-7DFB
        0x7DF2, # G+6108  U+7DF2  uni7DF2,  CJK UNIFIED IDEOGRAPH-7DF2
        0x7DE1, # G+6109  U+7DE1  uni7DE1,  CJK UNIFIED IDEOGRAPH-7DE1
        0x7E05, # G+6110  U+7E05  uni7E05,  CJK UNIFIED IDEOGRAPH-7E05
        0x7E0A, # G+6111  U+7E0A  uni7E0A,  CJK UNIFIED IDEOGRAPH-7E0A
        0x7E23, # G+6112  U+7E23  uni7E23,  CJK UNIFIED IDEOGRAPH-7E23
        0x7E21, # G+6113  U+7E21  uni7E21,  CJK UNIFIED IDEOGRAPH-7E21
        0x7E12, # G+6114  U+7E12  uni7E12,  CJK UNIFIED IDEOGRAPH-7E12
        0x7E31, # G+6115  U+7E31  uni7E31,  CJK UNIFIED IDEOGRAPH-7E31
        0x7E1F, # G+6116  U+7E1F  uni7E1F,  CJK UNIFIED IDEOGRAPH-7E1F
        0x7E09, # G+6117  U+7E09  uni7E09,  CJK UNIFIED IDEOGRAPH-7E09
        0x7E0B, # G+6118  U+7E0B  uni7E0B,  CJK UNIFIED IDEOGRAPH-7E0B
        0x7E22, # G+6119  U+7E22  uni7E22,  CJK UNIFIED IDEOGRAPH-7E22
        0x7E46, # G+6120  U+7E46  uni7E46,  CJK UNIFIED IDEOGRAPH-7E46
        0x7E66, # G+6121  U+7E66  uni7E66,  CJK UNIFIED IDEOGRAPH-7E66
        0x7E3B, # G+6122  U+7E3B  uni7E3B,  CJK UNIFIED IDEOGRAPH-7E3B
        0x7E35, # G+6123  U+7E35  uni7E35,  CJK UNIFIED IDEOGRAPH-7E35
        0x7E39, # G+6124  U+7E39  uni7E39,  CJK UNIFIED IDEOGRAPH-7E39
        0x7E43, # G+6125  U+7E43  uni7E43,  CJK UNIFIED IDEOGRAPH-7E43
        0x7E37, # G+6126  U+7E37  uni7E37,  CJK UNIFIED IDEOGRAPH-7E37
        0x7E32, # G+6127  U+7E32  uni7E32,  CJK UNIFIED IDEOGRAPH-7E32
        0x7E3A, # G+6128  U+7E3A  uni7E3A,  CJK UNIFIED IDEOGRAPH-7E3A
        0x7E67, # G+6129  U+7E67  uni7E67,  CJK UNIFIED IDEOGRAPH-7E67
        0x7E5D, # G+6130  U+7E5D  uni7E5D,  CJK UNIFIED IDEOGRAPH-7E5D
        0x7E56, # G+6131  U+7E56  uni7E56,  CJK UNIFIED IDEOGRAPH-7E56
        0x7E5E, # G+6132  U+7E5E  uni7E5E,  CJK UNIFIED IDEOGRAPH-7E5E
        0x7E59, # G+6133  U+7E59  uni7E59,  CJK UNIFIED IDEOGRAPH-7E59
        0x7E5A, # G+6134  U+7E5A  uni7E5A,  CJK UNIFIED IDEOGRAPH-7E5A
        0x7E79, # G+6135  U+7E79  uni7E79,  CJK UNIFIED IDEOGRAPH-7E79
        0x7E6A, # G+6136  U+7E6A  uni7E6A,  CJK UNIFIED IDEOGRAPH-7E6A
        0x7E69, # G+6137  U+7E69  uni7E69,  CJK UNIFIED IDEOGRAPH-7E69
        0x7E7C, # G+6138  U+7E7C  uni7E7C,  CJK UNIFIED IDEOGRAPH-7E7C
        0x7E7B, # G+6139  U+7E7B  uni7E7B,  CJK UNIFIED IDEOGRAPH-7E7B
        0x7E83, # G+6140  U+7E83  uni7E83,  CJK UNIFIED IDEOGRAPH-7E83
        0x7DD5, # G+6141  U+7DD5  uni7DD5,  CJK UNIFIED IDEOGRAPH-7DD5
        0x7E7D, # G+6142  U+7E7D  uni7E7D,  CJK UNIFIED IDEOGRAPH-7E7D
        0x8FAE, # G+6143  U+8FAE  uni8FAE,  CJK UNIFIED IDEOGRAPH-8FAE
        0x7E7F, # G+6144  U+7E7F  uni7E7F,  CJK UNIFIED IDEOGRAPH-7E7F
        0x7E88, # G+6145  U+7E88  uni7E88,  CJK UNIFIED IDEOGRAPH-7E88
        0x7E89, # G+6146  U+7E89  uni7E89,  CJK UNIFIED IDEOGRAPH-7E89
        0x7E8C, # G+6147  U+7E8C  uni7E8C,  CJK UNIFIED IDEOGRAPH-7E8C
        0x7E92, # G+6148  U+7E92  uni7E92,  CJK UNIFIED IDEOGRAPH-7E92
        0x7E90, # G+6149  U+7E90  uni7E90,  CJK UNIFIED IDEOGRAPH-7E90
        0x7E93, # G+6150  U+7E93  uni7E93,  CJK UNIFIED IDEOGRAPH-7E93
        0x7E94, # G+6151  U+7E94  uni7E94,  CJK UNIFIED IDEOGRAPH-7E94
        0x7E96, # G+6152  U+7E96  uni7E96,  CJK UNIFIED IDEOGRAPH-7E96
        0x7E8E, # G+6153  U+7E8E  uni7E8E,  CJK UNIFIED IDEOGRAPH-7E8E
        0x7E9B, # G+6154  U+7E9B  uni7E9B,  CJK UNIFIED IDEOGRAPH-7E9B
        0x7E9C, # G+6155  U+7E9C  uni7E9C,  CJK UNIFIED IDEOGRAPH-7E9C
        0x7F38, # G+6156  U+7F38  uni7F38,  CJK UNIFIED IDEOGRAPH-7F38
        0x7F3A, # G+6157  U+7F3A  uni7F3A,  CJK UNIFIED IDEOGRAPH-7F3A
        0x7F45, # G+6158  U+7F45  uni7F45,  CJK UNIFIED IDEOGRAPH-7F45
        0x7F4C, # G+6159  U+7F4C  uni7F4C,  CJK UNIFIED IDEOGRAPH-7F4C
        0x7F4D, # G+6160  U+7F4D  uni7F4D,  CJK UNIFIED IDEOGRAPH-7F4D
        0x7F4E, # G+6161  U+7F4E  uni7F4E,  CJK UNIFIED IDEOGRAPH-7F4E
        0x7F50, # G+6162  U+7F50  uni7F50,  CJK UNIFIED IDEOGRAPH-7F50
        0x2F79, # G+6163  U+2F79  uni2F79,  KANGXI RADICAL NET
        0x7F55, # G+6164  U+7F55  uni7F55,  CJK UNIFIED IDEOGRAPH-7F55
        0x7F54, # G+6165  U+7F54  uni7F54,  CJK UNIFIED IDEOGRAPH-7F54
        0x7F58, # G+6166  U+7F58  uni7F58,  CJK UNIFIED IDEOGRAPH-7F58
        0x7F5F, # G+6167  U+7F5F  uni7F5F,  CJK UNIFIED IDEOGRAPH-7F5F
        0x7F60, # G+6168  U+7F60  uni7F60,  CJK UNIFIED IDEOGRAPH-7F60
        0x7F68, # G+6169  U+7F68  uni7F68,  CJK UNIFIED IDEOGRAPH-7F68
        0x7F69, # G+6170  U+7F69  uni7F69,  CJK UNIFIED IDEOGRAPH-7F69
        0x7F67, # G+6171  U+7F67  uni7F67,  CJK UNIFIED IDEOGRAPH-7F67
        0x7F78, # G+6172  U+7F78  uni7F78,  CJK UNIFIED IDEOGRAPH-7F78
        0x7F82, # G+6173  U+7F82  uni7F82,  CJK UNIFIED IDEOGRAPH-7F82
        0x7F86, # G+6174  U+7F86  uni7F86,  CJK UNIFIED IDEOGRAPH-7F86
        0x7F83, # G+6175  U+7F83  uni7F83,  CJK UNIFIED IDEOGRAPH-7F83
        0x7F88, # G+6176  U+7F88  uni7F88,  CJK UNIFIED IDEOGRAPH-7F88
        0x7F87, # G+6177  U+7F87  uni7F87,  CJK UNIFIED IDEOGRAPH-7F87
        0x7F8C, # G+6178  U+7F8C  uni7F8C,  CJK UNIFIED IDEOGRAPH-7F8C
        0x7F94, # G+6179  U+7F94  uni7F94,  CJK UNIFIED IDEOGRAPH-7F94
        0x7F9E, # G+6180  U+7F9E  uni7F9E,  CJK UNIFIED IDEOGRAPH-7F9E
        0x7F9D, # G+6181  U+7F9D  uni7F9D,  CJK UNIFIED IDEOGRAPH-7F9D
        0x7F9A, # G+6182  U+7F9A  uni7F9A,  CJK UNIFIED IDEOGRAPH-7F9A
        0x7FA3, # G+6183  U+7FA3  uni7FA3,  CJK UNIFIED IDEOGRAPH-7FA3
        0x7FAF, # G+6184  U+7FAF  uni7FAF,  CJK UNIFIED IDEOGRAPH-7FAF
        0x7FB2, # G+6185  U+7FB2  uni7FB2,  CJK UNIFIED IDEOGRAPH-7FB2
        0x7FB9, # G+6186  U+7FB9  uni7FB9,  CJK UNIFIED IDEOGRAPH-7FB9
        0x7FAE, # G+6187  U+7FAE  uni7FAE,  CJK UNIFIED IDEOGRAPH-7FAE
        0x7FB6, # G+6188  U+7FB6  uni7FB6,  CJK UNIFIED IDEOGRAPH-7FB6
        0x7FB8, # G+6189  U+7FB8  uni7FB8,  CJK UNIFIED IDEOGRAPH-7FB8
        0x8B71, # G+6190  U+8B71  uni8B71,  CJK UNIFIED IDEOGRAPH-8B71
        0x7FC5, # G+6191  U+7FC5  uni7FC5,  CJK UNIFIED IDEOGRAPH-7FC5
        0x7FC6, # G+6192  U+7FC6  uni7FC6,  CJK UNIFIED IDEOGRAPH-7FC6
        0x7FCA, # G+6193  U+7FCA  uni7FCA,  CJK UNIFIED IDEOGRAPH-7FCA
        0x7FD5, # G+6194  U+7FD5  uni7FD5,  CJK UNIFIED IDEOGRAPH-7FD5
        0x7FD4, # G+6195  U+7FD4  uni7FD4,  CJK UNIFIED IDEOGRAPH-7FD4
        0x7FE1, # G+6196  U+7FE1  uni7FE1,  CJK UNIFIED IDEOGRAPH-7FE1
        0x7FE6, # G+6197  U+7FE6  uni7FE6,  CJK UNIFIED IDEOGRAPH-7FE6
        0x7FE9, # G+6198  U+7FE9  uni7FE9,  CJK UNIFIED IDEOGRAPH-7FE9
        0x7FF3, # G+6199  U+7FF3  uni7FF3,  CJK UNIFIED IDEOGRAPH-7FF3
        0x7FF9, # G+6200  U+7FF9  uni7FF9,  CJK UNIFIED IDEOGRAPH-7FF9
        0x98DC, # G+6201  U+98DC  uni98DC,  CJK UNIFIED IDEOGRAPH-98DC
        0x8006, # G+6202  U+8006  uni8006,  CJK UNIFIED IDEOGRAPH-8006
        0x8004, # G+6203  U+8004  uni8004,  CJK UNIFIED IDEOGRAPH-8004
        0x800B, # G+6204  U+800B  uni800B,  CJK UNIFIED IDEOGRAPH-800B
        0x2F7E, # G+6205  U+2F7E  uni2F7E,  KANGXI RADICAL PLOW
        0x8018, # G+6206  U+8018  uni8018,  CJK UNIFIED IDEOGRAPH-8018
        0x8019, # G+6207  U+8019  uni8019,  CJK UNIFIED IDEOGRAPH-8019
        0x801C, # G+6208  U+801C  uni801C,  CJK UNIFIED IDEOGRAPH-801C
        0x8021, # G+6209  U+8021  uni8021,  CJK UNIFIED IDEOGRAPH-8021
        0x8028, # G+6210  U+8028  uni8028,  CJK UNIFIED IDEOGRAPH-8028
        0x803F, # G+6211  U+803F  uni803F,  CJK UNIFIED IDEOGRAPH-803F
        0x803B, # G+6212  U+803B  uni803B,  CJK UNIFIED IDEOGRAPH-803B
        0x804A, # G+6213  U+804A  uni804A,  CJK UNIFIED IDEOGRAPH-804A
        0x8046, # G+6214  U+8046  uni8046,  CJK UNIFIED IDEOGRAPH-8046
        0x8052, # G+6215  U+8052  uni8052,  CJK UNIFIED IDEOGRAPH-8052
        0x8058, # G+6216  U+8058  uni8058,  CJK UNIFIED IDEOGRAPH-8058
        0x805A, # G+6217  U+805A  uni805A,  CJK UNIFIED IDEOGRAPH-805A
        0x805F, # G+6218  U+805F  uni805F,  CJK UNIFIED IDEOGRAPH-805F
        0x8062, # G+6219  U+8062  uni8062,  CJK UNIFIED IDEOGRAPH-8062
        0x8068, # G+6220  U+8068  uni8068,  CJK UNIFIED IDEOGRAPH-8068
        0x8073, # G+6221  U+8073  uni8073,  CJK UNIFIED IDEOGRAPH-8073
        0x8072, # G+6222  U+8072  uni8072,  CJK UNIFIED IDEOGRAPH-8072
        0x8070, # G+6223  U+8070  uni8070,  CJK UNIFIED IDEOGRAPH-8070
        0x8076, # G+6224  U+8076  uni8076,  CJK UNIFIED IDEOGRAPH-8076
        0x8079, # G+6225  U+8079  uni8079,  CJK UNIFIED IDEOGRAPH-8079
        0x807D, # G+6226  U+807D  uni807D,  CJK UNIFIED IDEOGRAPH-807D
        0x2F80, # G+6227  U+2F80  uni2F80,  KANGXI RADICAL BRUSH
        0x8084, # G+6228  U+8084  uni8084,  CJK UNIFIED IDEOGRAPH-8084
        0x8086, # G+6229  U+8086  uni8086,  CJK UNIFIED IDEOGRAPH-8086
        0x8085, # G+6230  U+8085  uni8085,  CJK UNIFIED IDEOGRAPH-8085
        0x809B, # G+6231  U+809B  uni809B,  CJK UNIFIED IDEOGRAPH-809B
        0x8093, # G+6232  U+8093  uni8093,  CJK UNIFIED IDEOGRAPH-8093
        0x809A, # G+6233  U+809A  uni809A,  CJK UNIFIED IDEOGRAPH-809A
        0x80AD, # G+6234  U+80AD  uni80AD,  CJK UNIFIED IDEOGRAPH-80AD
        0x5190, # G+6235  U+5190  uni5190,  CJK UNIFIED IDEOGRAPH-5190
        0x80AC, # G+6236  U+80AC  uni80AC,  CJK UNIFIED IDEOGRAPH-80AC
        0x80DB, # G+6237  U+80DB  uni80DB,  CJK UNIFIED IDEOGRAPH-80DB
        0x80E5, # G+6238  U+80E5  uni80E5,  CJK UNIFIED IDEOGRAPH-80E5
        0x80D9, # G+6239  U+80D9  uni80D9,  CJK UNIFIED IDEOGRAPH-80D9
        0x80DD, # G+6240  U+80DD  uni80DD,  CJK UNIFIED IDEOGRAPH-80DD
        0x80C4, # G+6241  U+80C4  uni80C4,  CJK UNIFIED IDEOGRAPH-80C4
        0x80DA, # G+6242  U+80DA  uni80DA,  CJK UNIFIED IDEOGRAPH-80DA
        0x80D6, # G+6243  U+80D6  uni80D6,  CJK UNIFIED IDEOGRAPH-80D6
        0x8109, # G+6244  U+8109  uni8109,  CJK UNIFIED IDEOGRAPH-8109
        0x80EF, # G+6245  U+80EF  uni80EF,  CJK UNIFIED IDEOGRAPH-80EF
        0x80F1, # G+6246  U+80F1  uni80F1,  CJK UNIFIED IDEOGRAPH-80F1
        0x811B, # G+6247  U+811B  uni811B,  CJK UNIFIED IDEOGRAPH-811B
        0x8129, # G+6248  U+8129  uni8129,  CJK UNIFIED IDEOGRAPH-8129
        0x8123, # G+6249  U+8123  uni8123,  CJK UNIFIED IDEOGRAPH-8123
        0x812F, # G+6250  U+812F  uni812F,  CJK UNIFIED IDEOGRAPH-812F
        0x814B, # G+6251  U+814B  uni814B,  CJK UNIFIED IDEOGRAPH-814B
        0x968B, # G+6252  U+968B  uni968B,  CJK UNIFIED IDEOGRAPH-968B
        0x8146, # G+6253  U+8146  uni8146,  CJK UNIFIED IDEOGRAPH-8146
        0x813E, # G+6254  U+813E  uni813E,  CJK UNIFIED IDEOGRAPH-813E
        0x8153, # G+6255  U+8153  uni8153,  CJK UNIFIED IDEOGRAPH-8153
        0x8151, # G+6256  U+8151  uni8151,  CJK UNIFIED IDEOGRAPH-8151
        0x80FC, # G+6257  U+80FC  uni80FC,  CJK UNIFIED IDEOGRAPH-80FC
        0x8171, # G+6258  U+8171  uni8171,  CJK UNIFIED IDEOGRAPH-8171
        0x816E, # G+6259  U+816E  uni816E,  CJK UNIFIED IDEOGRAPH-816E
        0x8165, # G+6260  U+8165  uni8165,  CJK UNIFIED IDEOGRAPH-8165
        0x8166, # G+6261  U+8166  uni8166,  CJK UNIFIED IDEOGRAPH-8166
        0x8174, # G+6262  U+8174  uni8174,  CJK UNIFIED IDEOGRAPH-8174
        0x8183, # G+6263  U+8183  uni8183,  CJK UNIFIED IDEOGRAPH-8183
        0x8188, # G+6264  U+8188  uni8188,  CJK UNIFIED IDEOGRAPH-8188
        0x818A, # G+6265  U+818A  uni818A,  CJK UNIFIED IDEOGRAPH-818A
        0x8180, # G+6266  U+8180  uni8180,  CJK UNIFIED IDEOGRAPH-8180
        0x8182, # G+6267  U+8182  uni8182,  CJK UNIFIED IDEOGRAPH-8182
        0x81A0, # G+6268  U+81A0  uni81A0,  CJK UNIFIED IDEOGRAPH-81A0
        0x8195, # G+6269  U+8195  uni8195,  CJK UNIFIED IDEOGRAPH-8195
        0x81A4, # G+6270  U+81A4  uni81A4,  CJK UNIFIED IDEOGRAPH-81A4
        0x81A3, # G+6271  U+81A3  uni81A3,  CJK UNIFIED IDEOGRAPH-81A3
        0x815F, # G+6272  U+815F  uni815F,  CJK UNIFIED IDEOGRAPH-815F
        0x8193, # G+6273  U+8193  uni8193,  CJK UNIFIED IDEOGRAPH-8193
        0x81A9, # G+6274  U+81A9  uni81A9,  CJK UNIFIED IDEOGRAPH-81A9
        0x81B0, # G+6275  U+81B0  uni81B0,  CJK UNIFIED IDEOGRAPH-81B0
        0x81B5, # G+6276  U+81B5  uni81B5,  CJK UNIFIED IDEOGRAPH-81B5
        0x81BE, # G+6277  U+81BE  uni81BE,  CJK UNIFIED IDEOGRAPH-81BE
        0x81B8, # G+6278  U+81B8  uni81B8,  CJK UNIFIED IDEOGRAPH-81B8
        0x81BD, # G+6279  U+81BD  uni81BD,  CJK UNIFIED IDEOGRAPH-81BD
        0x81C0, # G+6280  U+81C0  uni81C0,  CJK UNIFIED IDEOGRAPH-81C0
        0x81C2, # G+6281  U+81C2  uni81C2,  CJK UNIFIED IDEOGRAPH-81C2
        0x81BA, # G+6282  U+81BA  uni81BA,  CJK UNIFIED IDEOGRAPH-81BA
        0x81C9, # G+6283  U+81C9  uni81C9,  CJK UNIFIED IDEOGRAPH-81C9
        0x81CD, # G+6284  U+81CD  uni81CD,  CJK UNIFIED IDEOGRAPH-81CD
        0x81D1, # G+6285  U+81D1  uni81D1,  CJK UNIFIED IDEOGRAPH-81D1
        0x81D9, # G+6286  U+81D9  uni81D9,  CJK UNIFIED IDEOGRAPH-81D9
        0x81D8, # G+6287  U+81D8  uni81D8,  CJK UNIFIED IDEOGRAPH-81D8
        0x81C8, # G+6288  U+81C8  uni81C8,  CJK UNIFIED IDEOGRAPH-81C8
        0x81DA, # G+6289  U+81DA  uni81DA,  CJK UNIFIED IDEOGRAPH-81DA
        0x81DF, # G+6290  U+81DF  uni81DF,  CJK UNIFIED IDEOGRAPH-81DF
        0x81E0, # G+6291  U+81E0  uni81E0,  CJK UNIFIED IDEOGRAPH-81E0
        0x81E7, # G+6292  U+81E7  uni81E7,  CJK UNIFIED IDEOGRAPH-81E7
        0x81FA, # G+6293  U+81FA  uni81FA,  CJK UNIFIED IDEOGRAPH-81FA
        0x81FB, # G+6294  U+81FB  uni81FB,  CJK UNIFIED IDEOGRAPH-81FB
        0x81FE, # G+6295  U+81FE  uni81FE,  CJK UNIFIED IDEOGRAPH-81FE
        0x8201, # G+6296  U+8201  uni8201,  CJK UNIFIED IDEOGRAPH-8201
        0x8202, # G+6297  U+8202  uni8202,  CJK UNIFIED IDEOGRAPH-8202
        0x8205, # G+6298  U+8205  uni8205,  CJK UNIFIED IDEOGRAPH-8205
        0x8207, # G+6299  U+8207  uni8207,  CJK UNIFIED IDEOGRAPH-8207
        0x820A, # G+6300  U+820A  uni820A,  CJK UNIFIED IDEOGRAPH-820A
        0x820D, # G+6301  U+820D  uni820D,  CJK UNIFIED IDEOGRAPH-820D
        0x8210, # G+6302  U+8210  uni8210,  CJK UNIFIED IDEOGRAPH-8210
        0x8216, # G+6303  U+8216  uni8216,  CJK UNIFIED IDEOGRAPH-8216
        0x8229, # G+6304  U+8229  uni8229,  CJK UNIFIED IDEOGRAPH-8229
        0x822B, # G+6305  U+822B  uni822B,  CJK UNIFIED IDEOGRAPH-822B
        0x8238, # G+6306  U+8238  uni8238,  CJK UNIFIED IDEOGRAPH-8238
        0x8233, # G+6307  U+8233  uni8233,  CJK UNIFIED IDEOGRAPH-8233
        0x8240, # G+6308  U+8240  uni8240,  CJK UNIFIED IDEOGRAPH-8240
        0x8259, # G+6309  U+8259  uni8259,  CJK UNIFIED IDEOGRAPH-8259
        0x8258, # G+6310  U+8258  uni8258,  CJK UNIFIED IDEOGRAPH-8258
        0x825D, # G+6311  U+825D  uni825D,  CJK UNIFIED IDEOGRAPH-825D
        0x825A, # G+6312  U+825A  uni825A,  CJK UNIFIED IDEOGRAPH-825A
        0x825F, # G+6313  U+825F  uni825F,  CJK UNIFIED IDEOGRAPH-825F
        0x8264, # G+6314  U+8264  uni8264,  CJK UNIFIED IDEOGRAPH-8264
        0x8262, # G+6315  U+8262  uni8262,  CJK UNIFIED IDEOGRAPH-8262
        0x8268, # G+6316  U+8268  uni8268,  CJK UNIFIED IDEOGRAPH-8268
        0x826A, # G+6317  U+826A  uni826A,  CJK UNIFIED IDEOGRAPH-826A
        0x826B, # G+6318  U+826B  uni826B,  CJK UNIFIED IDEOGRAPH-826B
        0x822E, # G+6319  U+822E  uni822E,  CJK UNIFIED IDEOGRAPH-822E
        0x8271, # G+6320  U+8271  uni8271,  CJK UNIFIED IDEOGRAPH-8271
        0x8277, # G+6321  U+8277  uni8277,  CJK UNIFIED IDEOGRAPH-8277
        0x2F8B, # G+6322  U+2F8B  uni2F8B,  KANGXI RADICAL GRASS
        0x827E, # G+6323  U+827E  uni827E,  CJK UNIFIED IDEOGRAPH-827E
        0x828D, # G+6324  U+828D  uni828D,  CJK UNIFIED IDEOGRAPH-828D
        0x8292, # G+6325  U+8292  uni8292,  CJK UNIFIED IDEOGRAPH-8292
        0x82AB, # G+6326  U+82AB  uni82AB,  CJK UNIFIED IDEOGRAPH-82AB
        0x829F, # G+6327  U+829F  uni829F,  CJK UNIFIED IDEOGRAPH-829F
        0x82BB, # G+6328  U+82BB  uni82BB,  CJK UNIFIED IDEOGRAPH-82BB
        0x82AC, # G+6329  U+82AC  uni82AC,  CJK UNIFIED IDEOGRAPH-82AC
        0x82E1, # G+6330  U+82E1  uni82E1,  CJK UNIFIED IDEOGRAPH-82E1
        0x82E3, # G+6331  U+82E3  uni82E3,  CJK UNIFIED IDEOGRAPH-82E3
        0x82DF, # G+6332  U+82DF  uni82DF,  CJK UNIFIED IDEOGRAPH-82DF
        0x82D2, # G+6333  U+82D2  uni82D2,  CJK UNIFIED IDEOGRAPH-82D2
        0x82F4, # G+6334  U+82F4  uni82F4,  CJK UNIFIED IDEOGRAPH-82F4
        0x82F3, # G+6335  U+82F3  uni82F3,  CJK UNIFIED IDEOGRAPH-82F3
        0x82FA, # G+6336  U+82FA  uni82FA,  CJK UNIFIED IDEOGRAPH-82FA
        0x8393, # G+6337  U+8393  uni8393,  CJK UNIFIED IDEOGRAPH-8393
        0x8303, # G+6338  U+8303  uni8303,  CJK UNIFIED IDEOGRAPH-8303
        0x82FB, # G+6339  U+82FB  uni82FB,  CJK UNIFIED IDEOGRAPH-82FB
        0x82F9, # G+6340  U+82F9  uni82F9,  CJK UNIFIED IDEOGRAPH-82F9
        0x82DE, # G+6341  U+82DE  uni82DE,  CJK UNIFIED IDEOGRAPH-82DE
        0x8306, # G+6342  U+8306  uni8306,  CJK UNIFIED IDEOGRAPH-8306
        0x82DC, # G+6343  U+82DC  uni82DC,  CJK UNIFIED IDEOGRAPH-82DC
        0x8309, # G+6344  U+8309  uni8309,  CJK UNIFIED IDEOGRAPH-8309
        0x82D9, # G+6345  U+82D9  uni82D9,  CJK UNIFIED IDEOGRAPH-82D9
        0x8335, # G+6346  U+8335  uni8335,  CJK UNIFIED IDEOGRAPH-8335
        0x8334, # G+6347  U+8334  uni8334,  CJK UNIFIED IDEOGRAPH-8334
        0x8316, # G+6348  U+8316  uni8316,  CJK UNIFIED IDEOGRAPH-8316
        0x8332, # G+6349  U+8332  uni8332,  CJK UNIFIED IDEOGRAPH-8332
        0x8331, # G+6350  U+8331  uni8331,  CJK UNIFIED IDEOGRAPH-8331
        0x8340, # G+6351  U+8340  uni8340,  CJK UNIFIED IDEOGRAPH-8340
        0x8339, # G+6352  U+8339  uni8339,  CJK UNIFIED IDEOGRAPH-8339
        0x8350, # G+6353  U+8350  uni8350,  CJK UNIFIED IDEOGRAPH-8350
        0x8345, # G+6354  U+8345  uni8345,  CJK UNIFIED IDEOGRAPH-8345
        0x832F, # G+6355  U+832F  uni832F,  CJK UNIFIED IDEOGRAPH-832F
        0x832B, # G+6356  U+832B  uni832B,  CJK UNIFIED IDEOGRAPH-832B
        0x8317, # G+6357  U+8317  uni8317,  CJK UNIFIED IDEOGRAPH-8317
        0x8318, # G+6358  U+8318  uni8318,  CJK UNIFIED IDEOGRAPH-8318
        0x8385, # G+6359  U+8385  uni8385,  CJK UNIFIED IDEOGRAPH-8385
        0x839A, # G+6360  U+839A  uni839A,  CJK UNIFIED IDEOGRAPH-839A
        0x83AA, # G+6361  U+83AA  uni83AA,  CJK UNIFIED IDEOGRAPH-83AA
        0x839F, # G+6362  U+839F  uni839F,  CJK UNIFIED IDEOGRAPH-839F
        0x83A2, # G+6363  U+83A2  uni83A2,  CJK UNIFIED IDEOGRAPH-83A2
        0x8396, # G+6364  U+8396  uni8396,  CJK UNIFIED IDEOGRAPH-8396
        0x8323, # G+6365  U+8323  uni8323,  CJK UNIFIED IDEOGRAPH-8323
        0x838E, # G+6366  U+838E  uni838E,  CJK UNIFIED IDEOGRAPH-838E
        0x8387, # G+6367  U+8387  uni8387,  CJK UNIFIED IDEOGRAPH-8387
        0x838A, # G+6368  U+838A  uni838A,  CJK UNIFIED IDEOGRAPH-838A
        0x837C, # G+6369  U+837C  uni837C,  CJK UNIFIED IDEOGRAPH-837C
        0x83B5, # G+6370  U+83B5  uni83B5,  CJK UNIFIED IDEOGRAPH-83B5
        0x8373, # G+6371  U+8373  uni8373,  CJK UNIFIED IDEOGRAPH-8373
        0x8375, # G+6372  U+8375  uni8375,  CJK UNIFIED IDEOGRAPH-8375
        0x83A0, # G+6373  U+83A0  uni83A0,  CJK UNIFIED IDEOGRAPH-83A0
        0x8389, # G+6374  U+8389  uni8389,  CJK UNIFIED IDEOGRAPH-8389
        0x83A8, # G+6375  U+83A8  uni83A8,  CJK UNIFIED IDEOGRAPH-83A8
        0x83F4, # G+6376  U+83F4  uni83F4,  CJK UNIFIED IDEOGRAPH-83F4
        0x8413, # G+6377  U+8413  uni8413,  CJK UNIFIED IDEOGRAPH-8413
        0x83EB, # G+6378  U+83EB  uni83EB,  CJK UNIFIED IDEOGRAPH-83EB
        0x83CE, # G+6379  U+83CE  uni83CE,  CJK UNIFIED IDEOGRAPH-83CE
        0x83FD, # G+6380  U+83FD  uni83FD,  CJK UNIFIED IDEOGRAPH-83FD
        0x8403, # G+6381  U+8403  uni8403,  CJK UNIFIED IDEOGRAPH-8403
        0x83D8, # G+6382  U+83D8  uni83D8,  CJK UNIFIED IDEOGRAPH-83D8
        0x840B, # G+6383  U+840B  uni840B,  CJK UNIFIED IDEOGRAPH-840B
        0x83C1, # G+6384  U+83C1  uni83C1,  CJK UNIFIED IDEOGRAPH-83C1
        0x83F7, # G+6385  U+83F7  uni83F7,  CJK UNIFIED IDEOGRAPH-83F7
        0x8407, # G+6386  U+8407  uni8407,  CJK UNIFIED IDEOGRAPH-8407
        0x83E0, # G+6387  U+83E0  uni83E0,  CJK UNIFIED IDEOGRAPH-83E0
        0x83F2, # G+6388  U+83F2  uni83F2,  CJK UNIFIED IDEOGRAPH-83F2
        0x840D, # G+6389  U+840D  uni840D,  CJK UNIFIED IDEOGRAPH-840D
        0x8422, # G+6390  U+8422  uni8422,  CJK UNIFIED IDEOGRAPH-8422
        0x8420, # G+6391  U+8420  uni8420,  CJK UNIFIED IDEOGRAPH-8420
        0x83BD, # G+6392  U+83BD  uni83BD,  CJK UNIFIED IDEOGRAPH-83BD
        0x8438, # G+6393  U+8438  uni8438,  CJK UNIFIED IDEOGRAPH-8438
        0x8506, # G+6394  U+8506  uni8506,  CJK UNIFIED IDEOGRAPH-8506
        0x83FB, # G+6395  U+83FB  uni83FB,  CJK UNIFIED IDEOGRAPH-83FB
        0x846D, # G+6396  U+846D  uni846D,  CJK UNIFIED IDEOGRAPH-846D
        0x842A, # G+6397  U+842A  uni842A,  CJK UNIFIED IDEOGRAPH-842A
        0x843C, # G+6398  U+843C  uni843C,  CJK UNIFIED IDEOGRAPH-843C
        0x855A, # G+6399  U+855A  uni855A,  CJK UNIFIED IDEOGRAPH-855A
        0x8484, # G+6400  U+8484  uni8484,  CJK UNIFIED IDEOGRAPH-8484
        0x8477, # G+6401  U+8477  uni8477,  CJK UNIFIED IDEOGRAPH-8477
        0x846B, # G+6402  U+846B  uni846B,  CJK UNIFIED IDEOGRAPH-846B
        0x84AD, # G+6403  U+84AD  uni84AD,  CJK UNIFIED IDEOGRAPH-84AD
        0x846E, # G+6404  U+846E  uni846E,  CJK UNIFIED IDEOGRAPH-846E
        0x8482, # G+6405  U+8482  uni8482,  CJK UNIFIED IDEOGRAPH-8482
        0x8469, # G+6406  U+8469  uni8469,  CJK UNIFIED IDEOGRAPH-8469
        0x8446, # G+6407  U+8446  uni8446,  CJK UNIFIED IDEOGRAPH-8446
        0x842C, # G+6408  U+842C  uni842C,  CJK UNIFIED IDEOGRAPH-842C
        0x846F, # G+6409  U+846F  uni846F,  CJK UNIFIED IDEOGRAPH-846F
        0x8479, # G+6410  U+8479  uni8479,  CJK UNIFIED IDEOGRAPH-8479
        0x8435, # G+6411  U+8435  uni8435,  CJK UNIFIED IDEOGRAPH-8435
        0x84CA, # G+6412  U+84CA  uni84CA,  CJK UNIFIED IDEOGRAPH-84CA
        0x8462, # G+6413  U+8462  uni8462,  CJK UNIFIED IDEOGRAPH-8462
        0x84B9, # G+6414  U+84B9  uni84B9,  CJK UNIFIED IDEOGRAPH-84B9
        0x84BF, # G+6415  U+84BF  uni84BF,  CJK UNIFIED IDEOGRAPH-84BF
        0x849F, # G+6416  U+849F  uni849F,  CJK UNIFIED IDEOGRAPH-849F
        0x84D9, # G+6417  U+84D9  uni84D9,  CJK UNIFIED IDEOGRAPH-84D9
        0x84CD, # G+6418  U+84CD  uni84CD,  CJK UNIFIED IDEOGRAPH-84CD
        0x84BB, # G+6419  U+84BB  uni84BB,  CJK UNIFIED IDEOGRAPH-84BB
        0x84DA, # G+6420  U+84DA  uni84DA,  CJK UNIFIED IDEOGRAPH-84DA
        0x84D0, # G+6421  U+84D0  uni84D0,  CJK UNIFIED IDEOGRAPH-84D0
        0x84C1, # G+6422  U+84C1  uni84C1,  CJK UNIFIED IDEOGRAPH-84C1
        0x84C6, # G+6423  U+84C6  uni84C6,  CJK UNIFIED IDEOGRAPH-84C6
        0x84D6, # G+6424  U+84D6  uni84D6,  CJK UNIFIED IDEOGRAPH-84D6
        0x84A1, # G+6425  U+84A1  uni84A1,  CJK UNIFIED IDEOGRAPH-84A1
        0x8521, # G+6426  U+8521  uni8521,  CJK UNIFIED IDEOGRAPH-8521
        0x84FF, # G+6427  U+84FF  uni84FF,  CJK UNIFIED IDEOGRAPH-84FF
        0x84F4, # G+6428  U+84F4  uni84F4,  CJK UNIFIED IDEOGRAPH-84F4
        0x8517, # G+6429  U+8517  uni8517,  CJK UNIFIED IDEOGRAPH-8517
        0x8518, # G+6430  U+8518  uni8518,  CJK UNIFIED IDEOGRAPH-8518
        0x852C, # G+6431  U+852C  uni852C,  CJK UNIFIED IDEOGRAPH-852C
        0x851F, # G+6432  U+851F  uni851F,  CJK UNIFIED IDEOGRAPH-851F
        0x8515, # G+6433  U+8515  uni8515,  CJK UNIFIED IDEOGRAPH-8515
        0x8514, # G+6434  U+8514  uni8514,  CJK UNIFIED IDEOGRAPH-8514
        0x84FC, # G+6435  U+84FC  uni84FC,  CJK UNIFIED IDEOGRAPH-84FC
        0x8540, # G+6436  U+8540  uni8540,  CJK UNIFIED IDEOGRAPH-8540
        0x8563, # G+6437  U+8563  uni8563,  CJK UNIFIED IDEOGRAPH-8563
        0x8558, # G+6438  U+8558  uni8558,  CJK UNIFIED IDEOGRAPH-8558
        0x8548, # G+6439  U+8548  uni8548,  CJK UNIFIED IDEOGRAPH-8548
        0x8541, # G+6440  U+8541  uni8541,  CJK UNIFIED IDEOGRAPH-8541
        0x8602, # G+6441  U+8602  uni8602,  CJK UNIFIED IDEOGRAPH-8602
        0x854B, # G+6442  U+854B  uni854B,  CJK UNIFIED IDEOGRAPH-854B
        0x8555, # G+6443  U+8555  uni8555,  CJK UNIFIED IDEOGRAPH-8555
        0x8580, # G+6444  U+8580  uni8580,  CJK UNIFIED IDEOGRAPH-8580
        0x85A4, # G+6445  U+85A4  uni85A4,  CJK UNIFIED IDEOGRAPH-85A4
        0x8588, # G+6446  U+8588  uni8588,  CJK UNIFIED IDEOGRAPH-8588
        0x8591, # G+6447  U+8591  uni8591,  CJK UNIFIED IDEOGRAPH-8591
        0x858A, # G+6448  U+858A  uni858A,  CJK UNIFIED IDEOGRAPH-858A
        0x85A8, # G+6449  U+85A8  uni85A8,  CJK UNIFIED IDEOGRAPH-85A8
        0x856D, # G+6450  U+856D  uni856D,  CJK UNIFIED IDEOGRAPH-856D
        0x8594, # G+6451  U+8594  uni8594,  CJK UNIFIED IDEOGRAPH-8594
        0x859B, # G+6452  U+859B  uni859B,  CJK UNIFIED IDEOGRAPH-859B
        0x85EA, # G+6453  U+85EA  uni85EA,  CJK UNIFIED IDEOGRAPH-85EA
        0x8587, # G+6454  U+8587  uni8587,  CJK UNIFIED IDEOGRAPH-8587
        0x859C, # G+6455  U+859C  uni859C,  CJK UNIFIED IDEOGRAPH-859C
        0x8577, # G+6456  U+8577  uni8577,  CJK UNIFIED IDEOGRAPH-8577
        0x857E, # G+6457  U+857E  uni857E,  CJK UNIFIED IDEOGRAPH-857E
        0x8590, # G+6458  U+8590  uni8590,  CJK UNIFIED IDEOGRAPH-8590
        0x85C9, # G+6459  U+85C9  uni85C9,  CJK UNIFIED IDEOGRAPH-85C9
        0x85BA, # G+6460  U+85BA  uni85BA,  CJK UNIFIED IDEOGRAPH-85BA
        0x85CF, # G+6461  U+85CF  uni85CF,  CJK UNIFIED IDEOGRAPH-85CF
        0x85B9, # G+6462  U+85B9  uni85B9,  CJK UNIFIED IDEOGRAPH-85B9
        0x85D0, # G+6463  U+85D0  uni85D0,  CJK UNIFIED IDEOGRAPH-85D0
        0x85D5, # G+6464  U+85D5  uni85D5,  CJK UNIFIED IDEOGRAPH-85D5
        0x85DD, # G+6465  U+85DD  uni85DD,  CJK UNIFIED IDEOGRAPH-85DD
        0x85E5, # G+6466  U+85E5  uni85E5,  CJK UNIFIED IDEOGRAPH-85E5
        0x85DC, # G+6467  U+85DC  uni85DC,  CJK UNIFIED IDEOGRAPH-85DC
        0x85F9, # G+6468  U+85F9  uni85F9,  CJK UNIFIED IDEOGRAPH-85F9
        0x860A, # G+6469  U+860A  uni860A,  CJK UNIFIED IDEOGRAPH-860A
        0x8613, # G+6470  U+8613  uni8613,  CJK UNIFIED IDEOGRAPH-8613
        0x860B, # G+6471  U+860B  uni860B,  CJK UNIFIED IDEOGRAPH-860B
        0x85FE, # G+6472  U+85FE  uni85FE,  CJK UNIFIED IDEOGRAPH-85FE
        0x85FA, # G+6473  U+85FA  uni85FA,  CJK UNIFIED IDEOGRAPH-85FA
        0x8606, # G+6474  U+8606  uni8606,  CJK UNIFIED IDEOGRAPH-8606
        0x8622, # G+6475  U+8622  uni8622,  CJK UNIFIED IDEOGRAPH-8622
        0x861A, # G+6476  U+861A  uni861A,  CJK UNIFIED IDEOGRAPH-861A
        0x8630, # G+6477  U+8630  uni8630,  CJK UNIFIED IDEOGRAPH-8630
        0x863F, # G+6478  U+863F  uni863F,  CJK UNIFIED IDEOGRAPH-863F
        0x2F8C, # G+6479  U+2F8C  uni2F8C,  KANGXI RADICAL TIGER
        0x4E55, # G+6480  U+4E55  uni4E55,  CJK UNIFIED IDEOGRAPH-4E55
        0x8654, # G+6481  U+8654  uni8654,  CJK UNIFIED IDEOGRAPH-8654
        0x865F, # G+6482  U+865F  uni865F,  CJK UNIFIED IDEOGRAPH-865F
        0x8667, # G+6483  U+8667  uni8667,  CJK UNIFIED IDEOGRAPH-8667
        0x8671, # G+6484  U+8671  uni8671,  CJK UNIFIED IDEOGRAPH-8671
        0x8693, # G+6485  U+8693  uni8693,  CJK UNIFIED IDEOGRAPH-8693
        0x86A3, # G+6486  U+86A3  uni86A3,  CJK UNIFIED IDEOGRAPH-86A3
        0x86A9, # G+6487  U+86A9  uni86A9,  CJK UNIFIED IDEOGRAPH-86A9
        0x86AA, # G+6488  U+86AA  uni86AA,  CJK UNIFIED IDEOGRAPH-86AA
        0x868B, # G+6489  U+868B  uni868B,  CJK UNIFIED IDEOGRAPH-868B
        0x868C, # G+6490  U+868C  uni868C,  CJK UNIFIED IDEOGRAPH-868C
        0x86B6, # G+6491  U+86B6  uni86B6,  CJK UNIFIED IDEOGRAPH-86B6
        0x86AF, # G+6492  U+86AF  uni86AF,  CJK UNIFIED IDEOGRAPH-86AF
        0x86C4, # G+6493  U+86C4  uni86C4,  CJK UNIFIED IDEOGRAPH-86C4
        0x86C6, # G+6494  U+86C6  uni86C6,  CJK UNIFIED IDEOGRAPH-86C6
        0x86B0, # G+6495  U+86B0  uni86B0,  CJK UNIFIED IDEOGRAPH-86B0
        0x86C9, # G+6496  U+86C9  uni86C9,  CJK UNIFIED IDEOGRAPH-86C9
        0x8823, # G+6497  U+8823  uni8823,  CJK UNIFIED IDEOGRAPH-8823
        0x86AB, # G+6498  U+86AB  uni86AB,  CJK UNIFIED IDEOGRAPH-86AB
        0x86D4, # G+6499  U+86D4  uni86D4,  CJK UNIFIED IDEOGRAPH-86D4
        0x86DE, # G+6500  U+86DE  uni86DE,  CJK UNIFIED IDEOGRAPH-86DE
        0x86E9, # G+6501  U+86E9  uni86E9,  CJK UNIFIED IDEOGRAPH-86E9
        0x86EC, # G+6502  U+86EC  uni86EC,  CJK UNIFIED IDEOGRAPH-86EC
        0x86DF, # G+6503  U+86DF  uni86DF,  CJK UNIFIED IDEOGRAPH-86DF
        0x86DB, # G+6504  U+86DB  uni86DB,  CJK UNIFIED IDEOGRAPH-86DB
        0x86EF, # G+6505  U+86EF  uni86EF,  CJK UNIFIED IDEOGRAPH-86EF
        0x8712, # G+6506  U+8712  uni8712,  CJK UNIFIED IDEOGRAPH-8712
        0x8706, # G+6507  U+8706  uni8706,  CJK UNIFIED IDEOGRAPH-8706
        0x8708, # G+6508  U+8708  uni8708,  CJK UNIFIED IDEOGRAPH-8708
        0x8700, # G+6509  U+8700  uni8700,  CJK UNIFIED IDEOGRAPH-8700
        0x8703, # G+6510  U+8703  uni8703,  CJK UNIFIED IDEOGRAPH-8703
        0x86FB, # G+6511  U+86FB  uni86FB,  CJK UNIFIED IDEOGRAPH-86FB
        0x8711, # G+6512  U+8711  uni8711,  CJK UNIFIED IDEOGRAPH-8711
        0x8709, # G+6513  U+8709  uni8709,  CJK UNIFIED IDEOGRAPH-8709
        0x870D, # G+6514  U+870D  uni870D,  CJK UNIFIED IDEOGRAPH-870D
        0x86F9, # G+6515  U+86F9  uni86F9,  CJK UNIFIED IDEOGRAPH-86F9
        0x870A, # G+6516  U+870A  uni870A,  CJK UNIFIED IDEOGRAPH-870A
        0x8734, # G+6517  U+8734  uni8734,  CJK UNIFIED IDEOGRAPH-8734
        0x873F, # G+6518  U+873F  uni873F,  CJK UNIFIED IDEOGRAPH-873F
        0x8737, # G+6519  U+8737  uni8737,  CJK UNIFIED IDEOGRAPH-8737
        0x873B, # G+6520  U+873B  uni873B,  CJK UNIFIED IDEOGRAPH-873B
        0x8725, # G+6521  U+8725  uni8725,  CJK UNIFIED IDEOGRAPH-8725
        0x8729, # G+6522  U+8729  uni8729,  CJK UNIFIED IDEOGRAPH-8729
        0x871A, # G+6523  U+871A  uni871A,  CJK UNIFIED IDEOGRAPH-871A
        0x8760, # G+6524  U+8760  uni8760,  CJK UNIFIED IDEOGRAPH-8760
        0x875F, # G+6525  U+875F  uni875F,  CJK UNIFIED IDEOGRAPH-875F
        0x8778, # G+6526  U+8778  uni8778,  CJK UNIFIED IDEOGRAPH-8778
        0x874C, # G+6527  U+874C  uni874C,  CJK UNIFIED IDEOGRAPH-874C
        0x874E, # G+6528  U+874E  uni874E,  CJK UNIFIED IDEOGRAPH-874E
        0x8774, # G+6529  U+8774  uni8774,  CJK UNIFIED IDEOGRAPH-8774
        0x8757, # G+6530  U+8757  uni8757,  CJK UNIFIED IDEOGRAPH-8757
        0x8768, # G+6531  U+8768  uni8768,  CJK UNIFIED IDEOGRAPH-8768
        0x876E, # G+6532  U+876E  uni876E,  CJK UNIFIED IDEOGRAPH-876E
        0x8759, # G+6533  U+8759  uni8759,  CJK UNIFIED IDEOGRAPH-8759
        0x8753, # G+6534  U+8753  uni8753,  CJK UNIFIED IDEOGRAPH-8753
        0x8763, # G+6535  U+8763  uni8763,  CJK UNIFIED IDEOGRAPH-8763
        0x876A, # G+6536  U+876A  uni876A,  CJK UNIFIED IDEOGRAPH-876A
        0x8805, # G+6537  U+8805  uni8805,  CJK UNIFIED IDEOGRAPH-8805
        0x87A2, # G+6538  U+87A2  uni87A2,  CJK UNIFIED IDEOGRAPH-87A2
        0x879F, # G+6539  U+879F  uni879F,  CJK UNIFIED IDEOGRAPH-879F
        0x8782, # G+6540  U+8782  uni8782,  CJK UNIFIED IDEOGRAPH-8782
        0x87AF, # G+6541  U+87AF  uni87AF,  CJK UNIFIED IDEOGRAPH-87AF
        0x87CB, # G+6542  U+87CB  uni87CB,  CJK UNIFIED IDEOGRAPH-87CB
        0x87BD, # G+6543  U+87BD  uni87BD,  CJK UNIFIED IDEOGRAPH-87BD
        0x87C0, # G+6544  U+87C0  uni87C0,  CJK UNIFIED IDEOGRAPH-87C0
        0x87D0, # G+6545  U+87D0  uni87D0,  CJK UNIFIED IDEOGRAPH-87D0
        0x96D6, # G+6546  U+96D6  uni96D6,  CJK UNIFIED IDEOGRAPH-96D6
        0x87AB, # G+6547  U+87AB  uni87AB,  CJK UNIFIED IDEOGRAPH-87AB
        0x87C4, # G+6548  U+87C4  uni87C4,  CJK UNIFIED IDEOGRAPH-87C4
        0x87B3, # G+6549  U+87B3  uni87B3,  CJK UNIFIED IDEOGRAPH-87B3
        0x87C7, # G+6550  U+87C7  uni87C7,  CJK UNIFIED IDEOGRAPH-87C7
        0x87C6, # G+6551  U+87C6  uni87C6,  CJK UNIFIED IDEOGRAPH-87C6
        0x87BB, # G+6552  U+87BB  uni87BB,  CJK UNIFIED IDEOGRAPH-87BB
        0x87EF, # G+6553  U+87EF  uni87EF,  CJK UNIFIED IDEOGRAPH-87EF
        0x87F2, # G+6554  U+87F2  uni87F2,  CJK UNIFIED IDEOGRAPH-87F2
        0x87E0, # G+6555  U+87E0  uni87E0,  CJK UNIFIED IDEOGRAPH-87E0
        0x880F, # G+6556  U+880F  uni880F,  CJK UNIFIED IDEOGRAPH-880F
        0x880D, # G+6557  U+880D  uni880D,  CJK UNIFIED IDEOGRAPH-880D
        0x87FE, # G+6558  U+87FE  uni87FE,  CJK UNIFIED IDEOGRAPH-87FE
        0x87F6, # G+6559  U+87F6  uni87F6,  CJK UNIFIED IDEOGRAPH-87F6
        0x87F7, # G+6560  U+87F7  uni87F7,  CJK UNIFIED IDEOGRAPH-87F7
        0x880E, # G+6561  U+880E  uni880E,  CJK UNIFIED IDEOGRAPH-880E
        0x87D2, # G+6562  U+87D2  uni87D2,  CJK UNIFIED IDEOGRAPH-87D2
        0x8811, # G+6563  U+8811  uni8811,  CJK UNIFIED IDEOGRAPH-8811
        0x8816, # G+6564  U+8816  uni8816,  CJK UNIFIED IDEOGRAPH-8816
        0x8815, # G+6565  U+8815  uni8815,  CJK UNIFIED IDEOGRAPH-8815
        0x8822, # G+6566  U+8822  uni8822,  CJK UNIFIED IDEOGRAPH-8822
        0x8821, # G+6567  U+8821  uni8821,  CJK UNIFIED IDEOGRAPH-8821
        0x8831, # G+6568  U+8831  uni8831,  CJK UNIFIED IDEOGRAPH-8831
        0x8836, # G+6569  U+8836  uni8836,  CJK UNIFIED IDEOGRAPH-8836
        0x8839, # G+6570  U+8839  uni8839,  CJK UNIFIED IDEOGRAPH-8839
        0x8827, # G+6571  U+8827  uni8827,  CJK UNIFIED IDEOGRAPH-8827
        0x883B, # G+6572  U+883B  uni883B,  CJK UNIFIED IDEOGRAPH-883B
        0x8844, # G+6573  U+8844  uni8844,  CJK UNIFIED IDEOGRAPH-8844
        0x8842, # G+6574  U+8842  uni8842,  CJK UNIFIED IDEOGRAPH-8842
        0x8852, # G+6575  U+8852  uni8852,  CJK UNIFIED IDEOGRAPH-8852
        0x8859, # G+6576  U+8859  uni8859,  CJK UNIFIED IDEOGRAPH-8859
        0x885E, # G+6577  U+885E  uni885E,  CJK UNIFIED IDEOGRAPH-885E
        0x8862, # G+6578  U+8862  uni8862,  CJK UNIFIED IDEOGRAPH-8862
        0x886B, # G+6579  U+886B  uni886B,  CJK UNIFIED IDEOGRAPH-886B
        0x8881, # G+6580  U+8881  uni8881,  CJK UNIFIED IDEOGRAPH-8881
        0x887E, # G+6581  U+887E  uni887E,  CJK UNIFIED IDEOGRAPH-887E
        0x889E, # G+6582  U+889E  uni889E,  CJK UNIFIED IDEOGRAPH-889E
        0x8875, # G+6583  U+8875  uni8875,  CJK UNIFIED IDEOGRAPH-8875
        0x887D, # G+6584  U+887D  uni887D,  CJK UNIFIED IDEOGRAPH-887D
        0x88B5, # G+6585  U+88B5  uni88B5,  CJK UNIFIED IDEOGRAPH-88B5
        0x8872, # G+6586  U+8872  uni8872,  CJK UNIFIED IDEOGRAPH-8872
        0x8882, # G+6587  U+8882  uni8882,  CJK UNIFIED IDEOGRAPH-8882
        0x8897, # G+6588  U+8897  uni8897,  CJK UNIFIED IDEOGRAPH-8897
        0x8892, # G+6589  U+8892  uni8892,  CJK UNIFIED IDEOGRAPH-8892
        0x88AE, # G+6590  U+88AE  uni88AE,  CJK UNIFIED IDEOGRAPH-88AE
        0x8899, # G+6591  U+8899  uni8899,  CJK UNIFIED IDEOGRAPH-8899
        0x88A2, # G+6592  U+88A2  uni88A2,  CJK UNIFIED IDEOGRAPH-88A2
        0x888D, # G+6593  U+888D  uni888D,  CJK UNIFIED IDEOGRAPH-888D
        0x88A4, # G+6594  U+88A4  uni88A4,  CJK UNIFIED IDEOGRAPH-88A4
        0x88B0, # G+6595  U+88B0  uni88B0,  CJK UNIFIED IDEOGRAPH-88B0
        0x88BF, # G+6596  U+88BF  uni88BF,  CJK UNIFIED IDEOGRAPH-88BF
        0x88B1, # G+6597  U+88B1  uni88B1,  CJK UNIFIED IDEOGRAPH-88B1
        0x88C3, # G+6598  U+88C3  uni88C3,  CJK UNIFIED IDEOGRAPH-88C3
        0x88C4, # G+6599  U+88C4  uni88C4,  CJK UNIFIED IDEOGRAPH-88C4
        0x88D4, # G+6600  U+88D4  uni88D4,  CJK UNIFIED IDEOGRAPH-88D4
        0x88D8, # G+6601  U+88D8  uni88D8,  CJK UNIFIED IDEOGRAPH-88D8
        0x88D9, # G+6602  U+88D9  uni88D9,  CJK UNIFIED IDEOGRAPH-88D9
        0x88DD, # G+6603  U+88DD  uni88DD,  CJK UNIFIED IDEOGRAPH-88DD
        0x88F9, # G+6604  U+88F9  uni88F9,  CJK UNIFIED IDEOGRAPH-88F9
        0x8902, # G+6605  U+8902  uni8902,  CJK UNIFIED IDEOGRAPH-8902
        0x88FC, # G+6606  U+88FC  uni88FC,  CJK UNIFIED IDEOGRAPH-88FC
        0x88F4, # G+6607  U+88F4  uni88F4,  CJK UNIFIED IDEOGRAPH-88F4
        0x88E8, # G+6608  U+88E8  uni88E8,  CJK UNIFIED IDEOGRAPH-88E8
        0x88F2, # G+6609  U+88F2  uni88F2,  CJK UNIFIED IDEOGRAPH-88F2
        0x8904, # G+6610  U+8904  uni8904,  CJK UNIFIED IDEOGRAPH-8904
        0x890C, # G+6611  U+890C  uni890C,  CJK UNIFIED IDEOGRAPH-890C
        0x890A, # G+6612  U+890A  uni890A,  CJK UNIFIED IDEOGRAPH-890A
        0x8913, # G+6613  U+8913  uni8913,  CJK UNIFIED IDEOGRAPH-8913
        0x8943, # G+6614  U+8943  uni8943,  CJK UNIFIED IDEOGRAPH-8943
        0x891E, # G+6615  U+891E  uni891E,  CJK UNIFIED IDEOGRAPH-891E
        0x8925, # G+6616  U+8925  uni8925,  CJK UNIFIED IDEOGRAPH-8925
        0x892A, # G+6617  U+892A  uni892A,  CJK UNIFIED IDEOGRAPH-892A
        0x892B, # G+6618  U+892B  uni892B,  CJK UNIFIED IDEOGRAPH-892B
        0x8941, # G+6619  U+8941  uni8941,  CJK UNIFIED IDEOGRAPH-8941
        0x8944, # G+6620  U+8944  uni8944,  CJK UNIFIED IDEOGRAPH-8944
        0x893B, # G+6621  U+893B  uni893B,  CJK UNIFIED IDEOGRAPH-893B
        0x8936, # G+6622  U+8936  uni8936,  CJK UNIFIED IDEOGRAPH-8936
        0x8938, # G+6623  U+8938  uni8938,  CJK UNIFIED IDEOGRAPH-8938
        0x894C, # G+6624  U+894C  uni894C,  CJK UNIFIED IDEOGRAPH-894C
        0x891D, # G+6625  U+891D  uni891D,  CJK UNIFIED IDEOGRAPH-891D
        0x8960, # G+6626  U+8960  uni8960,  CJK UNIFIED IDEOGRAPH-8960
        0x895E, # G+6627  U+895E  uni895E,  CJK UNIFIED IDEOGRAPH-895E
        0x8966, # G+6628  U+8966  uni8966,  CJK UNIFIED IDEOGRAPH-8966
        0x8964, # G+6629  U+8964  uni8964,  CJK UNIFIED IDEOGRAPH-8964
        0x896D, # G+6630  U+896D  uni896D,  CJK UNIFIED IDEOGRAPH-896D
        0x896A, # G+6631  U+896A  uni896A,  CJK UNIFIED IDEOGRAPH-896A
        0x896F, # G+6632  U+896F  uni896F,  CJK UNIFIED IDEOGRAPH-896F
        0x8974, # G+6633  U+8974  uni8974,  CJK UNIFIED IDEOGRAPH-8974
        0x8977, # G+6634  U+8977  uni8977,  CJK UNIFIED IDEOGRAPH-8977
        0x2F91, # G+6635  U+2F91  uni2F91,  KANGXI RADICAL WEST
        0x8983, # G+6636  U+8983  uni8983,  CJK UNIFIED IDEOGRAPH-8983
        0x8988, # G+6637  U+8988  uni8988,  CJK UNIFIED IDEOGRAPH-8988
        0x898A, # G+6638  U+898A  uni898A,  CJK UNIFIED IDEOGRAPH-898A
        0x8993, # G+6639  U+8993  uni8993,  CJK UNIFIED IDEOGRAPH-8993
        0x8998, # G+6640  U+8998  uni8998,  CJK UNIFIED IDEOGRAPH-8998
        0x89A1, # G+6641  U+89A1  uni89A1,  CJK UNIFIED IDEOGRAPH-89A1
        0x89A9, # G+6642  U+89A9  uni89A9,  CJK UNIFIED IDEOGRAPH-89A9
        0x89A6, # G+6643  U+89A6  uni89A6,  CJK UNIFIED IDEOGRAPH-89A6
        0x89AC, # G+6644  U+89AC  uni89AC,  CJK UNIFIED IDEOGRAPH-89AC
        0x89AF, # G+6645  U+89AF  uni89AF,  CJK UNIFIED IDEOGRAPH-89AF
        0x89B2, # G+6646  U+89B2  uni89B2,  CJK UNIFIED IDEOGRAPH-89B2
        0x89BA, # G+6647  U+89BA  uni89BA,  CJK UNIFIED IDEOGRAPH-89BA
        0x89BD, # G+6648  U+89BD  uni89BD,  CJK UNIFIED IDEOGRAPH-89BD
        0x89BF, # G+6649  U+89BF  uni89BF,  CJK UNIFIED IDEOGRAPH-89BF
        0x89C0, # G+6650  U+89C0  uni89C0,  CJK UNIFIED IDEOGRAPH-89C0
        0x89DA, # G+6651  U+89DA  uni89DA,  CJK UNIFIED IDEOGRAPH-89DA
        0x89DC, # G+6652  U+89DC  uni89DC,  CJK UNIFIED IDEOGRAPH-89DC
        0x89DD, # G+6653  U+89DD  uni89DD,  CJK UNIFIED IDEOGRAPH-89DD
        0x89E7, # G+6654  U+89E7  uni89E7,  CJK UNIFIED IDEOGRAPH-89E7
        0x89F4, # G+6655  U+89F4  uni89F4,  CJK UNIFIED IDEOGRAPH-89F4
        0x89F8, # G+6656  U+89F8  uni89F8,  CJK UNIFIED IDEOGRAPH-89F8
        0x8A03, # G+6657  U+8A03  uni8A03,  CJK UNIFIED IDEOGRAPH-8A03
        0x8A16, # G+6658  U+8A16  uni8A16,  CJK UNIFIED IDEOGRAPH-8A16
        0x8A10, # G+6659  U+8A10  uni8A10,  CJK UNIFIED IDEOGRAPH-8A10
        0x8A0C, # G+6660  U+8A0C  uni8A0C,  CJK UNIFIED IDEOGRAPH-8A0C
        0x8A1B, # G+6661  U+8A1B  uni8A1B,  CJK UNIFIED IDEOGRAPH-8A1B
        0x8A1D, # G+6662  U+8A1D  uni8A1D,  CJK UNIFIED IDEOGRAPH-8A1D
        0x8A25, # G+6663  U+8A25  uni8A25,  CJK UNIFIED IDEOGRAPH-8A25
        0x8A36, # G+6664  U+8A36  uni8A36,  CJK UNIFIED IDEOGRAPH-8A36
        0x8A41, # G+6665  U+8A41  uni8A41,  CJK UNIFIED IDEOGRAPH-8A41
        0x8A5B, # G+6666  U+8A5B  uni8A5B,  CJK UNIFIED IDEOGRAPH-8A5B
        0x8A52, # G+6667  U+8A52  uni8A52,  CJK UNIFIED IDEOGRAPH-8A52
        0x8A46, # G+6668  U+8A46  uni8A46,  CJK UNIFIED IDEOGRAPH-8A46
        0x8A48, # G+6669  U+8A48  uni8A48,  CJK UNIFIED IDEOGRAPH-8A48
        0x8A7C, # G+6670  U+8A7C  uni8A7C,  CJK UNIFIED IDEOGRAPH-8A7C
        0x8A6D, # G+6671  U+8A6D  uni8A6D,  CJK UNIFIED IDEOGRAPH-8A6D
        0x8A6C, # G+6672  U+8A6C  uni8A6C,  CJK UNIFIED IDEOGRAPH-8A6C
        0x8A62, # G+6673  U+8A62  uni8A62,  CJK UNIFIED IDEOGRAPH-8A62
        0x8A85, # G+6674  U+8A85  uni8A85,  CJK UNIFIED IDEOGRAPH-8A85
        0x8A82, # G+6675  U+8A82  uni8A82,  CJK UNIFIED IDEOGRAPH-8A82
        0x8A84, # G+6676  U+8A84  uni8A84,  CJK UNIFIED IDEOGRAPH-8A84
        0x8AA8, # G+6677  U+8AA8  uni8AA8,  CJK UNIFIED IDEOGRAPH-8AA8
        0x8AA1, # G+6678  U+8AA1  uni8AA1,  CJK UNIFIED IDEOGRAPH-8AA1
        0x8A91, # G+6679  U+8A91  uni8A91,  CJK UNIFIED IDEOGRAPH-8A91
        0x8AA5, # G+6680  U+8AA5  uni8AA5,  CJK UNIFIED IDEOGRAPH-8AA5
        0x8AA6, # G+6681  U+8AA6  uni8AA6,  CJK UNIFIED IDEOGRAPH-8AA6
        0x8A9A, # G+6682  U+8A9A  uni8A9A,  CJK UNIFIED IDEOGRAPH-8A9A
        0x8AA3, # G+6683  U+8AA3  uni8AA3,  CJK UNIFIED IDEOGRAPH-8AA3
        0x8AC4, # G+6684  U+8AC4  uni8AC4,  CJK UNIFIED IDEOGRAPH-8AC4
        0x8ACD, # G+6685  U+8ACD  uni8ACD,  CJK UNIFIED IDEOGRAPH-8ACD
        0x8AC2, # G+6686  U+8AC2  uni8AC2,  CJK UNIFIED IDEOGRAPH-8AC2
        0x8ADA, # G+6687  U+8ADA  uni8ADA,  CJK UNIFIED IDEOGRAPH-8ADA
        0x8AEB, # G+6688  U+8AEB  uni8AEB,  CJK UNIFIED IDEOGRAPH-8AEB
        0x8AF3, # G+6689  U+8AF3  uni8AF3,  CJK UNIFIED IDEOGRAPH-8AF3
        0x8AE7, # G+6690  U+8AE7  uni8AE7,  CJK UNIFIED IDEOGRAPH-8AE7
        0x8AE4, # G+6691  U+8AE4  uni8AE4,  CJK UNIFIED IDEOGRAPH-8AE4
        0x8AF1, # G+6692  U+8AF1  uni8AF1,  CJK UNIFIED IDEOGRAPH-8AF1
        0x8B14, # G+6693  U+8B14  uni8B14,  CJK UNIFIED IDEOGRAPH-8B14
        0x8AE0, # G+6694  U+8AE0  uni8AE0,  CJK UNIFIED IDEOGRAPH-8AE0
        0x8AE2, # G+6695  U+8AE2  uni8AE2,  CJK UNIFIED IDEOGRAPH-8AE2
        0x8AF7, # G+6696  U+8AF7  uni8AF7,  CJK UNIFIED IDEOGRAPH-8AF7
        0x8ADE, # G+6697  U+8ADE  uni8ADE,  CJK UNIFIED IDEOGRAPH-8ADE
        0x8ADB, # G+6698  U+8ADB  uni8ADB,  CJK UNIFIED IDEOGRAPH-8ADB
        0x8B0C, # G+6699  U+8B0C  uni8B0C,  CJK UNIFIED IDEOGRAPH-8B0C
        0x8B07, # G+6700  U+8B07  uni8B07,  CJK UNIFIED IDEOGRAPH-8B07
        0x8B1A, # G+6701  U+8B1A  uni8B1A,  CJK UNIFIED IDEOGRAPH-8B1A
        0x8AE1, # G+6702  U+8AE1  uni8AE1,  CJK UNIFIED IDEOGRAPH-8AE1
        0x8B16, # G+6703  U+8B16  uni8B16,  CJK UNIFIED IDEOGRAPH-8B16
        0x8B10, # G+6704  U+8B10  uni8B10,  CJK UNIFIED IDEOGRAPH-8B10
        0x8B17, # G+6705  U+8B17  uni8B17,  CJK UNIFIED IDEOGRAPH-8B17
        0x8B20, # G+6706  U+8B20  uni8B20,  CJK UNIFIED IDEOGRAPH-8B20
        0x8B33, # G+6707  U+8B33  uni8B33,  CJK UNIFIED IDEOGRAPH-8B33
        0x97AB, # G+6708  U+97AB  uni97AB,  CJK UNIFIED IDEOGRAPH-97AB
        0x8B26, # G+6709  U+8B26  uni8B26,  CJK UNIFIED IDEOGRAPH-8B26
        0x8B2B, # G+6710  U+8B2B  uni8B2B,  CJK UNIFIED IDEOGRAPH-8B2B
        0x8B3E, # G+6711  U+8B3E  uni8B3E,  CJK UNIFIED IDEOGRAPH-8B3E
        0x8B28, # G+6712  U+8B28  uni8B28,  CJK UNIFIED IDEOGRAPH-8B28
        0x8B41, # G+6713  U+8B41  uni8B41,  CJK UNIFIED IDEOGRAPH-8B41
        0x8B4C, # G+6714  U+8B4C  uni8B4C,  CJK UNIFIED IDEOGRAPH-8B4C
        0x8B4F, # G+6715  U+8B4F  uni8B4F,  CJK UNIFIED IDEOGRAPH-8B4F
        0x8B4E, # G+6716  U+8B4E  uni8B4E,  CJK UNIFIED IDEOGRAPH-8B4E
        0x8B49, # G+6717  U+8B49  uni8B49,  CJK UNIFIED IDEOGRAPH-8B49
        0x8B56, # G+6718  U+8B56  uni8B56,  CJK UNIFIED IDEOGRAPH-8B56
        0x8B5B, # G+6719  U+8B5B  uni8B5B,  CJK UNIFIED IDEOGRAPH-8B5B
        0x8B5A, # G+6720  U+8B5A  uni8B5A,  CJK UNIFIED IDEOGRAPH-8B5A
        0x8B6B, # G+6721  U+8B6B  uni8B6B,  CJK UNIFIED IDEOGRAPH-8B6B
        0x8B5F, # G+6722  U+8B5F  uni8B5F,  CJK UNIFIED IDEOGRAPH-8B5F
        0x8B6C, # G+6723  U+8B6C  uni8B6C,  CJK UNIFIED IDEOGRAPH-8B6C
        0x8B6F, # G+6724  U+8B6F  uni8B6F,  CJK UNIFIED IDEOGRAPH-8B6F
        0x8B74, # G+6725  U+8B74  uni8B74,  CJK UNIFIED IDEOGRAPH-8B74
        0x8B7D, # G+6726  U+8B7D  uni8B7D,  CJK UNIFIED IDEOGRAPH-8B7D
        0x8B80, # G+6727  U+8B80  uni8B80,  CJK UNIFIED IDEOGRAPH-8B80
        0x8B8C, # G+6728  U+8B8C  uni8B8C,  CJK UNIFIED IDEOGRAPH-8B8C
        0x8B8E, # G+6729  U+8B8E  uni8B8E,  CJK UNIFIED IDEOGRAPH-8B8E
        0x8B92, # G+6730  U+8B92  uni8B92,  CJK UNIFIED IDEOGRAPH-8B92
        0x8B93, # G+6731  U+8B93  uni8B93,  CJK UNIFIED IDEOGRAPH-8B93
        0x8B96, # G+6732  U+8B96  uni8B96,  CJK UNIFIED IDEOGRAPH-8B96
        0x8B99, # G+6733  U+8B99  uni8B99,  CJK UNIFIED IDEOGRAPH-8B99
        0x8B9A, # G+6734  U+8B9A  uni8B9A,  CJK UNIFIED IDEOGRAPH-8B9A
        0x8C3A, # G+6735  U+8C3A  uni8C3A,  CJK UNIFIED IDEOGRAPH-8C3A
        0x8C41, # G+6736  U+8C41  uni8C41,  CJK UNIFIED IDEOGRAPH-8C41
        0x8C3F, # G+6737  U+8C3F  uni8C3F,  CJK UNIFIED IDEOGRAPH-8C3F
        0x8C48, # G+6738  U+8C48  uni8C48,  CJK UNIFIED IDEOGRAPH-8C48
        0x8C4C, # G+6739  U+8C4C  uni8C4C,  CJK UNIFIED IDEOGRAPH-8C4C
        0x8C4E, # G+6740  U+8C4E  uni8C4E,  CJK UNIFIED IDEOGRAPH-8C4E
        0x8C50, # G+6741  U+8C50  uni8C50,  CJK UNIFIED IDEOGRAPH-8C50
        0x2F97, # G+6742  U+2F97  uni2F97,  KANGXI RADICAL PIG
        0x8C62, # G+6743  U+8C62  uni8C62,  CJK UNIFIED IDEOGRAPH-8C62
        0x8C6C, # G+6744  U+8C6C  uni8C6C,  CJK UNIFIED IDEOGRAPH-8C6C
        0x2F98, # G+6745  U+2F98  uni2F98,  KANGXI RADICAL BADGER
        0x8C7A, # G+6746  U+8C7A  uni8C7A,  CJK UNIFIED IDEOGRAPH-8C7A
        0x8C82, # G+6747  U+8C82  uni8C82,  CJK UNIFIED IDEOGRAPH-8C82
        0x8C89, # G+6748  U+8C89  uni8C89,  CJK UNIFIED IDEOGRAPH-8C89
        0x8C85, # G+6749  U+8C85  uni8C85,  CJK UNIFIED IDEOGRAPH-8C85
        0x8C8A, # G+6750  U+8C8A  uni8C8A,  CJK UNIFIED IDEOGRAPH-8C8A
        0x8C8D, # G+6751  U+8C8D  uni8C8D,  CJK UNIFIED IDEOGRAPH-8C8D
        0x8C8E, # G+6752  U+8C8E  uni8C8E,  CJK UNIFIED IDEOGRAPH-8C8E
        0x8C94, # G+6753  U+8C94  uni8C94,  CJK UNIFIED IDEOGRAPH-8C94
        0x8C7C, # G+6754  U+8C7C  uni8C7C,  CJK UNIFIED IDEOGRAPH-8C7C
        0x8C98, # G+6755  U+8C98  uni8C98,  CJK UNIFIED IDEOGRAPH-8C98
        0x621D, # G+6756  U+621D  uni621D,  CJK UNIFIED IDEOGRAPH-621D
        0x8CAD, # G+6757  U+8CAD  uni8CAD,  CJK UNIFIED IDEOGRAPH-8CAD
        0x8CAA, # G+6758  U+8CAA  uni8CAA,  CJK UNIFIED IDEOGRAPH-8CAA
        0x8CBD, # G+6759  U+8CBD  uni8CBD,  CJK UNIFIED IDEOGRAPH-8CBD
        0x8CB2, # G+6760  U+8CB2  uni8CB2,  CJK UNIFIED IDEOGRAPH-8CB2
        0x8CB3, # G+6761  U+8CB3  uni8CB3,  CJK UNIFIED IDEOGRAPH-8CB3
        0x8CAE, # G+6762  U+8CAE  uni8CAE,  CJK UNIFIED IDEOGRAPH-8CAE
        0x8CB6, # G+6763  U+8CB6  uni8CB6,  CJK UNIFIED IDEOGRAPH-8CB6
        0x8CC8, # G+6764  U+8CC8  uni8CC8,  CJK UNIFIED IDEOGRAPH-8CC8
        0x8CC1, # G+6765  U+8CC1  uni8CC1,  CJK UNIFIED IDEOGRAPH-8CC1
        0x8CE4, # G+6766  U+8CE4  uni8CE4,  CJK UNIFIED IDEOGRAPH-8CE4
        0x8CE3, # G+6767  U+8CE3  uni8CE3,  CJK UNIFIED IDEOGRAPH-8CE3
        0x8CDA, # G+6768  U+8CDA  uni8CDA,  CJK UNIFIED IDEOGRAPH-8CDA
        0x8CFD, # G+6769  U+8CFD  uni8CFD,  CJK UNIFIED IDEOGRAPH-8CFD
        0x8CFA, # G+6770  U+8CFA  uni8CFA,  CJK UNIFIED IDEOGRAPH-8CFA
        0x8CFB, # G+6771  U+8CFB  uni8CFB,  CJK UNIFIED IDEOGRAPH-8CFB
        0x8D04, # G+6772  U+8D04  uni8D04,  CJK UNIFIED IDEOGRAPH-8D04
        0x8D05, # G+6773  U+8D05  uni8D05,  CJK UNIFIED IDEOGRAPH-8D05
        0x8D0A, # G+6774  U+8D0A  uni8D0A,  CJK UNIFIED IDEOGRAPH-8D0A
        0x8D07, # G+6775  U+8D07  uni8D07,  CJK UNIFIED IDEOGRAPH-8D07
        0x8D0F, # G+6776  U+8D0F  uni8D0F,  CJK UNIFIED IDEOGRAPH-8D0F
        0x8D0D, # G+6777  U+8D0D  uni8D0D,  CJK UNIFIED IDEOGRAPH-8D0D
        0x8D10, # G+6778  U+8D10  uni8D10,  CJK UNIFIED IDEOGRAPH-8D10
        0x9F4E, # G+6779  U+9F4E  uni9F4E,  CJK UNIFIED IDEOGRAPH-9F4E
        0x8D13, # G+6780  U+8D13  uni8D13,  CJK UNIFIED IDEOGRAPH-8D13
        0x8CCD, # G+6781  U+8CCD  uni8CCD,  CJK UNIFIED IDEOGRAPH-8CCD
        0x8D14, # G+6782  U+8D14  uni8D14,  CJK UNIFIED IDEOGRAPH-8D14
        0x8D16, # G+6783  U+8D16  uni8D16,  CJK UNIFIED IDEOGRAPH-8D16
        0x8D67, # G+6784  U+8D67  uni8D67,  CJK UNIFIED IDEOGRAPH-8D67
        0x8D6D, # G+6785  U+8D6D  uni8D6D,  CJK UNIFIED IDEOGRAPH-8D6D
        0x8D71, # G+6786  U+8D71  uni8D71,  CJK UNIFIED IDEOGRAPH-8D71
        0x8D73, # G+6787  U+8D73  uni8D73,  CJK UNIFIED IDEOGRAPH-8D73
        0x8D81, # G+6788  U+8D81  uni8D81,  CJK UNIFIED IDEOGRAPH-8D81
        0x8D99, # G+6789  U+8D99  uni8D99,  CJK UNIFIED IDEOGRAPH-8D99
        0x8DC2, # G+6790  U+8DC2  uni8DC2,  CJK UNIFIED IDEOGRAPH-8DC2
        0x8DBE, # G+6791  U+8DBE  uni8DBE,  CJK UNIFIED IDEOGRAPH-8DBE
        0x8DBA, # G+6792  U+8DBA  uni8DBA,  CJK UNIFIED IDEOGRAPH-8DBA
        0x8DCF, # G+6793  U+8DCF  uni8DCF,  CJK UNIFIED IDEOGRAPH-8DCF
        0x8DDA, # G+6794  U+8DDA  uni8DDA,  CJK UNIFIED IDEOGRAPH-8DDA
        0x8DD6, # G+6795  U+8DD6  uni8DD6,  CJK UNIFIED IDEOGRAPH-8DD6
        0x8DCC, # G+6796  U+8DCC  uni8DCC,  CJK UNIFIED IDEOGRAPH-8DCC
        0x8DDB, # G+6797  U+8DDB  uni8DDB,  CJK UNIFIED IDEOGRAPH-8DDB
        0x8DCB, # G+6798  U+8DCB  uni8DCB,  CJK UNIFIED IDEOGRAPH-8DCB
        0x8DEA, # G+6799  U+8DEA  uni8DEA,  CJK UNIFIED IDEOGRAPH-8DEA
        0x8DEB, # G+6800  U+8DEB  uni8DEB,  CJK UNIFIED IDEOGRAPH-8DEB
        0x8DDF, # G+6801  U+8DDF  uni8DDF,  CJK UNIFIED IDEOGRAPH-8DDF
        0x8DE3, # G+6802  U+8DE3  uni8DE3,  CJK UNIFIED IDEOGRAPH-8DE3
        0x8DFC, # G+6803  U+8DFC  uni8DFC,  CJK UNIFIED IDEOGRAPH-8DFC
        0x8E08, # G+6804  U+8E08  uni8E08,  CJK UNIFIED IDEOGRAPH-8E08
        0x8E09, # G+6805  U+8E09  uni8E09,  CJK UNIFIED IDEOGRAPH-8E09
        0x8DFF, # G+6806  U+8DFF  uni8DFF,  CJK UNIFIED IDEOGRAPH-8DFF
        0x8E1D, # G+6807  U+8E1D  uni8E1D,  CJK UNIFIED IDEOGRAPH-8E1D
        0x8E1E, # G+6808  U+8E1E  uni8E1E,  CJK UNIFIED IDEOGRAPH-8E1E
        0x8E10, # G+6809  U+8E10  uni8E10,  CJK UNIFIED IDEOGRAPH-8E10
        0x8E1F, # G+6810  U+8E1F  uni8E1F,  CJK UNIFIED IDEOGRAPH-8E1F
        0x8E42, # G+6811  U+8E42  uni8E42,  CJK UNIFIED IDEOGRAPH-8E42
        0x8E35, # G+6812  U+8E35  uni8E35,  CJK UNIFIED IDEOGRAPH-8E35
        0x8E30, # G+6813  U+8E30  uni8E30,  CJK UNIFIED IDEOGRAPH-8E30
        0x8E34, # G+6814  U+8E34  uni8E34,  CJK UNIFIED IDEOGRAPH-8E34
        0x8E4A, # G+6815  U+8E4A  uni8E4A,  CJK UNIFIED IDEOGRAPH-8E4A
        0x8E47, # G+6816  U+8E47  uni8E47,  CJK UNIFIED IDEOGRAPH-8E47
        0x8E49, # G+6817  U+8E49  uni8E49,  CJK UNIFIED IDEOGRAPH-8E49
        0x8E4C, # G+6818  U+8E4C  uni8E4C,  CJK UNIFIED IDEOGRAPH-8E4C
        0x8E50, # G+6819  U+8E50  uni8E50,  CJK UNIFIED IDEOGRAPH-8E50
        0x8E48, # G+6820  U+8E48  uni8E48,  CJK UNIFIED IDEOGRAPH-8E48
        0x8E59, # G+6821  U+8E59  uni8E59,  CJK UNIFIED IDEOGRAPH-8E59
        0x8E64, # G+6822  U+8E64  uni8E64,  CJK UNIFIED IDEOGRAPH-8E64
        0x8E60, # G+6823  U+8E60  uni8E60,  CJK UNIFIED IDEOGRAPH-8E60
        0x8E2A, # G+6824  U+8E2A  uni8E2A,  CJK UNIFIED IDEOGRAPH-8E2A
        0x8E63, # G+6825  U+8E63  uni8E63,  CJK UNIFIED IDEOGRAPH-8E63
        0x8E55, # G+6826  U+8E55  uni8E55,  CJK UNIFIED IDEOGRAPH-8E55
        0x8E76, # G+6827  U+8E76  uni8E76,  CJK UNIFIED IDEOGRAPH-8E76
        0x8E72, # G+6828  U+8E72  uni8E72,  CJK UNIFIED IDEOGRAPH-8E72
        0x8E7C, # G+6829  U+8E7C  uni8E7C,  CJK UNIFIED IDEOGRAPH-8E7C
        0x8E81, # G+6830  U+8E81  uni8E81,  CJK UNIFIED IDEOGRAPH-8E81
        0x8E87, # G+6831  U+8E87  uni8E87,  CJK UNIFIED IDEOGRAPH-8E87
        0x8E85, # G+6832  U+8E85  uni8E85,  CJK UNIFIED IDEOGRAPH-8E85
        0x8E84, # G+6833  U+8E84  uni8E84,  CJK UNIFIED IDEOGRAPH-8E84
        0x8E8B, # G+6834  U+8E8B  uni8E8B,  CJK UNIFIED IDEOGRAPH-8E8B
        0x8E8A, # G+6835  U+8E8A  uni8E8A,  CJK UNIFIED IDEOGRAPH-8E8A
        0x8E93, # G+6836  U+8E93  uni8E93,  CJK UNIFIED IDEOGRAPH-8E93
        0x8E91, # G+6837  U+8E91  uni8E91,  CJK UNIFIED IDEOGRAPH-8E91
        0x8E94, # G+6838  U+8E94  uni8E94,  CJK UNIFIED IDEOGRAPH-8E94
        0x8E99, # G+6839  U+8E99  uni8E99,  CJK UNIFIED IDEOGRAPH-8E99
        0x8EAA, # G+6840  U+8EAA  uni8EAA,  CJK UNIFIED IDEOGRAPH-8EAA
        0x8EA1, # G+6841  U+8EA1  uni8EA1,  CJK UNIFIED IDEOGRAPH-8EA1
        0x8EAC, # G+6842  U+8EAC  uni8EAC,  CJK UNIFIED IDEOGRAPH-8EAC
        0x8EB0, # G+6843  U+8EB0  uni8EB0,  CJK UNIFIED IDEOGRAPH-8EB0
        0x8EC6, # G+6844  U+8EC6  uni8EC6,  CJK UNIFIED IDEOGRAPH-8EC6
        0x8EB1, # G+6845  U+8EB1  uni8EB1,  CJK UNIFIED IDEOGRAPH-8EB1
        0x8EBE, # G+6846  U+8EBE  uni8EBE,  CJK UNIFIED IDEOGRAPH-8EBE
        0x8EC5, # G+6847  U+8EC5  uni8EC5,  CJK UNIFIED IDEOGRAPH-8EC5
        0x8EC8, # G+6848  U+8EC8  uni8EC8,  CJK UNIFIED IDEOGRAPH-8EC8
        0x8ECB, # G+6849  U+8ECB  uni8ECB,  CJK UNIFIED IDEOGRAPH-8ECB
        0x8EDB, # G+6850  U+8EDB  uni8EDB,  CJK UNIFIED IDEOGRAPH-8EDB
        0x8EE3, # G+6851  U+8EE3  uni8EE3,  CJK UNIFIED IDEOGRAPH-8EE3
        0x8EFC, # G+6852  U+8EFC  uni8EFC,  CJK UNIFIED IDEOGRAPH-8EFC
        0x8EFB, # G+6853  U+8EFB  uni8EFB,  CJK UNIFIED IDEOGRAPH-8EFB
        0x8EEB, # G+6854  U+8EEB  uni8EEB,  CJK UNIFIED IDEOGRAPH-8EEB
        0x8EFE, # G+6855  U+8EFE  uni8EFE,  CJK UNIFIED IDEOGRAPH-8EFE
        0x8F0A, # G+6856  U+8F0A  uni8F0A,  CJK UNIFIED IDEOGRAPH-8F0A
        0x8F05, # G+6857  U+8F05  uni8F05,  CJK UNIFIED IDEOGRAPH-8F05
        0x8F15, # G+6858  U+8F15  uni8F15,  CJK UNIFIED IDEOGRAPH-8F15
        0x8F12, # G+6859  U+8F12  uni8F12,  CJK UNIFIED IDEOGRAPH-8F12
        0x8F19, # G+6860  U+8F19  uni8F19,  CJK UNIFIED IDEOGRAPH-8F19
        0x8F13, # G+6861  U+8F13  uni8F13,  CJK UNIFIED IDEOGRAPH-8F13
        0x8F1C, # G+6862  U+8F1C  uni8F1C,  CJK UNIFIED IDEOGRAPH-8F1C
        0x8F1F, # G+6863  U+8F1F  uni8F1F,  CJK UNIFIED IDEOGRAPH-8F1F
        0x8F1B, # G+6864  U+8F1B  uni8F1B,  CJK UNIFIED IDEOGRAPH-8F1B
        0x8F0C, # G+6865  U+8F0C  uni8F0C,  CJK UNIFIED IDEOGRAPH-8F0C
        0x8F26, # G+6866  U+8F26  uni8F26,  CJK UNIFIED IDEOGRAPH-8F26
        0x8F33, # G+6867  U+8F33  uni8F33,  CJK UNIFIED IDEOGRAPH-8F33
        0x8F3B, # G+6868  U+8F3B  uni8F3B,  CJK UNIFIED IDEOGRAPH-8F3B
        0x8F39, # G+6869  U+8F39  uni8F39,  CJK UNIFIED IDEOGRAPH-8F39
        0x8F45, # G+6870  U+8F45  uni8F45,  CJK UNIFIED IDEOGRAPH-8F45
        0x8F42, # G+6871  U+8F42  uni8F42,  CJK UNIFIED IDEOGRAPH-8F42
        0x8F3E, # G+6872  U+8F3E  uni8F3E,  CJK UNIFIED IDEOGRAPH-8F3E
        0x8F4C, # G+6873  U+8F4C  uni8F4C,  CJK UNIFIED IDEOGRAPH-8F4C
        0x8F49, # G+6874  U+8F49  uni8F49,  CJK UNIFIED IDEOGRAPH-8F49
        0x8F46, # G+6875  U+8F46  uni8F46,  CJK UNIFIED IDEOGRAPH-8F46
        0x8F4E, # G+6876  U+8F4E  uni8F4E,  CJK UNIFIED IDEOGRAPH-8F4E
        0x8F57, # G+6877  U+8F57  uni8F57,  CJK UNIFIED IDEOGRAPH-8F57
        0x8F5C, # G+6878  U+8F5C  uni8F5C,  CJK UNIFIED IDEOGRAPH-8F5C
        0x8F62, # G+6879  U+8F62  uni8F62,  CJK UNIFIED IDEOGRAPH-8F62
        0x8F63, # G+6880  U+8F63  uni8F63,  CJK UNIFIED IDEOGRAPH-8F63
        0x8F64, # G+6881  U+8F64  uni8F64,  CJK UNIFIED IDEOGRAPH-8F64
        0x8F9C, # G+6882  U+8F9C  uni8F9C,  CJK UNIFIED IDEOGRAPH-8F9C
        0x8F9F, # G+6883  U+8F9F  uni8F9F,  CJK UNIFIED IDEOGRAPH-8F9F
        0x8FA3, # G+6884  U+8FA3  uni8FA3,  CJK UNIFIED IDEOGRAPH-8FA3
        0x8FAD, # G+6885  U+8FAD  uni8FAD,  CJK UNIFIED IDEOGRAPH-8FAD
        0x8FAF, # G+6886  U+8FAF  uni8FAF,  CJK UNIFIED IDEOGRAPH-8FAF
        0x8FB7, # G+6887  U+8FB7  uni8FB7,  CJK UNIFIED IDEOGRAPH-8FB7
        0x8FDA, # G+6888  U+8FDA  uni8FDA,  CJK UNIFIED IDEOGRAPH-8FDA
        0x8FE5, # G+6889  U+8FE5  uni8FE5,  CJK UNIFIED IDEOGRAPH-8FE5
        0x8FE2, # G+6890  U+8FE2  uni8FE2,  CJK UNIFIED IDEOGRAPH-8FE2
        0x8FEA, # G+6891  U+8FEA  uni8FEA,  CJK UNIFIED IDEOGRAPH-8FEA
        0x8FEF, # G+6892  U+8FEF  uni8FEF,  CJK UNIFIED IDEOGRAPH-8FEF
        0x9087, # G+6893  U+9087  uni9087,  CJK UNIFIED IDEOGRAPH-9087
        0x8FF4, # G+6894  U+8FF4  uni8FF4,  CJK UNIFIED IDEOGRAPH-8FF4
        0x9005, # G+6895  U+9005  uni9005,  CJK UNIFIED IDEOGRAPH-9005
        0x8FF9, # G+6896  U+8FF9  uni8FF9,  CJK UNIFIED IDEOGRAPH-8FF9
        0x8FFA, # G+6897  U+8FFA  uni8FFA,  CJK UNIFIED IDEOGRAPH-8FFA
        0x9011, # G+6898  U+9011  uni9011,  CJK UNIFIED IDEOGRAPH-9011
        0x9015, # G+6899  U+9015  uni9015,  CJK UNIFIED IDEOGRAPH-9015
        0x9021, # G+6900  U+9021  uni9021,  CJK UNIFIED IDEOGRAPH-9021
        0x900D, # G+6901  U+900D  uni900D,  CJK UNIFIED IDEOGRAPH-900D
        0x901E, # G+6902  U+901E  uni901E,  CJK UNIFIED IDEOGRAPH-901E
        0x9016, # G+6903  U+9016  uni9016,  CJK UNIFIED IDEOGRAPH-9016
        0x900B, # G+6904  U+900B  uni900B,  CJK UNIFIED IDEOGRAPH-900B
        0x9027, # G+6905  U+9027  uni9027,  CJK UNIFIED IDEOGRAPH-9027
        0x9036, # G+6906  U+9036  uni9036,  CJK UNIFIED IDEOGRAPH-9036
        0x9035, # G+6907  U+9035  uni9035,  CJK UNIFIED IDEOGRAPH-9035
        0x9039, # G+6908  U+9039  uni9039,  CJK UNIFIED IDEOGRAPH-9039
        0x8FF8, # G+6909  U+8FF8  uni8FF8,  CJK UNIFIED IDEOGRAPH-8FF8
        0x904F, # G+6910  U+904F  uni904F,  CJK UNIFIED IDEOGRAPH-904F
        0x9050, # G+6911  U+9050  uni9050,  CJK UNIFIED IDEOGRAPH-9050
        0x9051, # G+6912  U+9051  uni9051,  CJK UNIFIED IDEOGRAPH-9051
        0x9052, # G+6913  U+9052  uni9052,  CJK UNIFIED IDEOGRAPH-9052
        0x900E, # G+6914  U+900E  uni900E,  CJK UNIFIED IDEOGRAPH-900E
        0x9049, # G+6915  U+9049  uni9049,  CJK UNIFIED IDEOGRAPH-9049
        0x903E, # G+6916  U+903E  uni903E,  CJK UNIFIED IDEOGRAPH-903E
        0x9056, # G+6917  U+9056  uni9056,  CJK UNIFIED IDEOGRAPH-9056
        0x9058, # G+6918  U+9058  uni9058,  CJK UNIFIED IDEOGRAPH-9058
        0x905E, # G+6919  U+905E  uni905E,  CJK UNIFIED IDEOGRAPH-905E
        0x9068, # G+6920  U+9068  uni9068,  CJK UNIFIED IDEOGRAPH-9068
        0x906F, # G+6921  U+906F  uni906F,  CJK UNIFIED IDEOGRAPH-906F
        0x9076, # G+6922  U+9076  uni9076,  CJK UNIFIED IDEOGRAPH-9076
        0x96A8, # G+6923  U+96A8  uni96A8,  CJK UNIFIED IDEOGRAPH-96A8
        0x9072, # G+6924  U+9072  uni9072,  CJK UNIFIED IDEOGRAPH-9072
        0x9082, # G+6925  U+9082  uni9082,  CJK UNIFIED IDEOGRAPH-9082
        0x907D, # G+6926  U+907D  uni907D,  CJK UNIFIED IDEOGRAPH-907D
        0x9081, # G+6927  U+9081  uni9081,  CJK UNIFIED IDEOGRAPH-9081
        0x9080, # G+6928  U+9080  uni9080,  CJK UNIFIED IDEOGRAPH-9080
        0x908A, # G+6929  U+908A  uni908A,  CJK UNIFIED IDEOGRAPH-908A
        0x9089, # G+6930  U+9089  uni9089,  CJK UNIFIED IDEOGRAPH-9089
        0x908F, # G+6931  U+908F  uni908F,  CJK UNIFIED IDEOGRAPH-908F
        0x90A8, # G+6932  U+90A8  uni90A8,  CJK UNIFIED IDEOGRAPH-90A8
        0x90AF, # G+6933  U+90AF  uni90AF,  CJK UNIFIED IDEOGRAPH-90AF
        0x90B1, # G+6934  U+90B1  uni90B1,  CJK UNIFIED IDEOGRAPH-90B1
        0x90B5, # G+6935  U+90B5  uni90B5,  CJK UNIFIED IDEOGRAPH-90B5
        0x90E2, # G+6936  U+90E2  uni90E2,  CJK UNIFIED IDEOGRAPH-90E2
        0x90E4, # G+6937  U+90E4  uni90E4,  CJK UNIFIED IDEOGRAPH-90E4
        0x6248, # G+6938  U+6248  uni6248,  CJK UNIFIED IDEOGRAPH-6248
        0x90DB, # G+6939  U+90DB  uni90DB,  CJK UNIFIED IDEOGRAPH-90DB
        0x9102, # G+6940  U+9102  uni9102,  CJK UNIFIED IDEOGRAPH-9102
        0x9112, # G+6941  U+9112  uni9112,  CJK UNIFIED IDEOGRAPH-9112
        0x9119, # G+6942  U+9119  uni9119,  CJK UNIFIED IDEOGRAPH-9119
        0x9132, # G+6943  U+9132  uni9132,  CJK UNIFIED IDEOGRAPH-9132
        0x9130, # G+6944  U+9130  uni9130,  CJK UNIFIED IDEOGRAPH-9130
        0x914A, # G+6945  U+914A  uni914A,  CJK UNIFIED IDEOGRAPH-914A
        0x9156, # G+6946  U+9156  uni9156,  CJK UNIFIED IDEOGRAPH-9156
        0x9158, # G+6947  U+9158  uni9158,  CJK UNIFIED IDEOGRAPH-9158
        0x9163, # G+6948  U+9163  uni9163,  CJK UNIFIED IDEOGRAPH-9163
        0x9165, # G+6949  U+9165  uni9165,  CJK UNIFIED IDEOGRAPH-9165
        0x9169, # G+6950  U+9169  uni9169,  CJK UNIFIED IDEOGRAPH-9169
        0x9173, # G+6951  U+9173  uni9173,  CJK UNIFIED IDEOGRAPH-9173
        0x9172, # G+6952  U+9172  uni9172,  CJK UNIFIED IDEOGRAPH-9172
        0x918B, # G+6953  U+918B  uni918B,  CJK UNIFIED IDEOGRAPH-918B
        0x9189, # G+6954  U+9189  uni9189,  CJK UNIFIED IDEOGRAPH-9189
        0x9182, # G+6955  U+9182  uni9182,  CJK UNIFIED IDEOGRAPH-9182
        0x91A2, # G+6956  U+91A2  uni91A2,  CJK UNIFIED IDEOGRAPH-91A2
        0x91AB, # G+6957  U+91AB  uni91AB,  CJK UNIFIED IDEOGRAPH-91AB
        0x91AF, # G+6958  U+91AF  uni91AF,  CJK UNIFIED IDEOGRAPH-91AF
        0x91AA, # G+6959  U+91AA  uni91AA,  CJK UNIFIED IDEOGRAPH-91AA
        0x91B5, # G+6960  U+91B5  uni91B5,  CJK UNIFIED IDEOGRAPH-91B5
        0x91B4, # G+6961  U+91B4  uni91B4,  CJK UNIFIED IDEOGRAPH-91B4
        0x91BA, # G+6962  U+91BA  uni91BA,  CJK UNIFIED IDEOGRAPH-91BA
        0x91C0, # G+6963  U+91C0  uni91C0,  CJK UNIFIED IDEOGRAPH-91C0
        0x91C1, # G+6964  U+91C1  uni91C1,  CJK UNIFIED IDEOGRAPH-91C1
        0x91C9, # G+6965  U+91C9  uni91C9,  CJK UNIFIED IDEOGRAPH-91C9
        0x91CB, # G+6966  U+91CB  uni91CB,  CJK UNIFIED IDEOGRAPH-91CB
        0x91D0, # G+6967  U+91D0  uni91D0,  CJK UNIFIED IDEOGRAPH-91D0
        0x91D6, # G+6968  U+91D6  uni91D6,  CJK UNIFIED IDEOGRAPH-91D6
        0x91DF, # G+6969  U+91DF  uni91DF,  CJK UNIFIED IDEOGRAPH-91DF
        0x91E1, # G+6970  U+91E1  uni91E1,  CJK UNIFIED IDEOGRAPH-91E1
        0x91DB, # G+6971  U+91DB  uni91DB,  CJK UNIFIED IDEOGRAPH-91DB
        0x91FC, # G+6972  U+91FC  uni91FC,  CJK UNIFIED IDEOGRAPH-91FC
        0x91F5, # G+6973  U+91F5  uni91F5,  CJK UNIFIED IDEOGRAPH-91F5
        0x91F6, # G+6974  U+91F6  uni91F6,  CJK UNIFIED IDEOGRAPH-91F6
        0x921E, # G+6975  U+921E  uni921E,  CJK UNIFIED IDEOGRAPH-921E
        0x91FF, # G+6976  U+91FF  uni91FF,  CJK UNIFIED IDEOGRAPH-91FF
        0x9214, # G+6977  U+9214  uni9214,  CJK UNIFIED IDEOGRAPH-9214
        0x922C, # G+6978  U+922C  uni922C,  CJK UNIFIED IDEOGRAPH-922C
        0x9215, # G+6979  U+9215  uni9215,  CJK UNIFIED IDEOGRAPH-9215
        0x9211, # G+6980  U+9211  uni9211,  CJK UNIFIED IDEOGRAPH-9211
        0x925E, # G+6981  U+925E  uni925E,  CJK UNIFIED IDEOGRAPH-925E
        0x9257, # G+6982  U+9257  uni9257,  CJK UNIFIED IDEOGRAPH-9257
        0x9245, # G+6983  U+9245  uni9245,  CJK UNIFIED IDEOGRAPH-9245
        0x9249, # G+6984  U+9249  uni9249,  CJK UNIFIED IDEOGRAPH-9249
        0x9264, # G+6985  U+9264  uni9264,  CJK UNIFIED IDEOGRAPH-9264
        0x9248, # G+6986  U+9248  uni9248,  CJK UNIFIED IDEOGRAPH-9248
        0x9295, # G+6987  U+9295  uni9295,  CJK UNIFIED IDEOGRAPH-9295
        0x923F, # G+6988  U+923F  uni923F,  CJK UNIFIED IDEOGRAPH-923F
        0x924B, # G+6989  U+924B  uni924B,  CJK UNIFIED IDEOGRAPH-924B
        0x9250, # G+6990  U+9250  uni9250,  CJK UNIFIED IDEOGRAPH-9250
        0x929C, # G+6991  U+929C  uni929C,  CJK UNIFIED IDEOGRAPH-929C
        0x9296, # G+6992  U+9296  uni9296,  CJK UNIFIED IDEOGRAPH-9296
        0x9293, # G+6993  U+9293  uni9293,  CJK UNIFIED IDEOGRAPH-9293
        0x929B, # G+6994  U+929B  uni929B,  CJK UNIFIED IDEOGRAPH-929B
        0x925A, # G+6995  U+925A  uni925A,  CJK UNIFIED IDEOGRAPH-925A
        0x92CF, # G+6996  U+92CF  uni92CF,  CJK UNIFIED IDEOGRAPH-92CF
        0x92B9, # G+6997  U+92B9  uni92B9,  CJK UNIFIED IDEOGRAPH-92B9
        0x92B7, # G+6998  U+92B7  uni92B7,  CJK UNIFIED IDEOGRAPH-92B7
        0x92E9, # G+6999  U+92E9  uni92E9,  CJK UNIFIED IDEOGRAPH-92E9
        0x930F, # G+7000  U+930F  uni930F,  CJK UNIFIED IDEOGRAPH-930F
        0x92FA, # G+7001  U+92FA  uni92FA,  CJK UNIFIED IDEOGRAPH-92FA
        0x9344, # G+7002  U+9344  uni9344,  CJK UNIFIED IDEOGRAPH-9344
        0x932E, # G+7003  U+932E  uni932E,  CJK UNIFIED IDEOGRAPH-932E
        0x9319, # G+7004  U+9319  uni9319,  CJK UNIFIED IDEOGRAPH-9319
        0x9322, # G+7005  U+9322  uni9322,  CJK UNIFIED IDEOGRAPH-9322
        0x931A, # G+7006  U+931A  uni931A,  CJK UNIFIED IDEOGRAPH-931A
        0x9323, # G+7007  U+9323  uni9323,  CJK UNIFIED IDEOGRAPH-9323
        0x933A, # G+7008  U+933A  uni933A,  CJK UNIFIED IDEOGRAPH-933A
        0x9335, # G+7009  U+9335  uni9335,  CJK UNIFIED IDEOGRAPH-9335
        0x933B, # G+7010  U+933B  uni933B,  CJK UNIFIED IDEOGRAPH-933B
        0x935C, # G+7011  U+935C  uni935C,  CJK UNIFIED IDEOGRAPH-935C
        0x9360, # G+7012  U+9360  uni9360,  CJK UNIFIED IDEOGRAPH-9360
        0x937C, # G+7013  U+937C  uni937C,  CJK UNIFIED IDEOGRAPH-937C
        0x936E, # G+7014  U+936E  uni936E,  CJK UNIFIED IDEOGRAPH-936E
        0x9356, # G+7015  U+9356  uni9356,  CJK UNIFIED IDEOGRAPH-9356
        0x93B0, # G+7016  U+93B0  uni93B0,  CJK UNIFIED IDEOGRAPH-93B0
        0x93AC, # G+7017  U+93AC  uni93AC,  CJK UNIFIED IDEOGRAPH-93AC
        0x93AD, # G+7018  U+93AD  uni93AD,  CJK UNIFIED IDEOGRAPH-93AD
        0x9394, # G+7019  U+9394  uni9394,  CJK UNIFIED IDEOGRAPH-9394
        0x93B9, # G+7020  U+93B9  uni93B9,  CJK UNIFIED IDEOGRAPH-93B9
        0x93D6, # G+7021  U+93D6  uni93D6,  CJK UNIFIED IDEOGRAPH-93D6
        0x93D7, # G+7022  U+93D7  uni93D7,  CJK UNIFIED IDEOGRAPH-93D7
        0x93E8, # G+7023  U+93E8  uni93E8,  CJK UNIFIED IDEOGRAPH-93E8
        0x93E5, # G+7024  U+93E5  uni93E5,  CJK UNIFIED IDEOGRAPH-93E5
        0x93D8, # G+7025  U+93D8  uni93D8,  CJK UNIFIED IDEOGRAPH-93D8
        0x93C3, # G+7026  U+93C3  uni93C3,  CJK UNIFIED IDEOGRAPH-93C3
        0x93DD, # G+7027  U+93DD  uni93DD,  CJK UNIFIED IDEOGRAPH-93DD
        0x93D0, # G+7028  U+93D0  uni93D0,  CJK UNIFIED IDEOGRAPH-93D0
        0x93C8, # G+7029  U+93C8  uni93C8,  CJK UNIFIED IDEOGRAPH-93C8
        0x93E4, # G+7030  U+93E4  uni93E4,  CJK UNIFIED IDEOGRAPH-93E4
        0x941A, # G+7031  U+941A  uni941A,  CJK UNIFIED IDEOGRAPH-941A
        0x9414, # G+7032  U+9414  uni9414,  CJK UNIFIED IDEOGRAPH-9414
        0x9413, # G+7033  U+9413  uni9413,  CJK UNIFIED IDEOGRAPH-9413
        0x9403, # G+7034  U+9403  uni9403,  CJK UNIFIED IDEOGRAPH-9403
        0x9407, # G+7035  U+9407  uni9407,  CJK UNIFIED IDEOGRAPH-9407
        0x9410, # G+7036  U+9410  uni9410,  CJK UNIFIED IDEOGRAPH-9410
        0x9436, # G+7037  U+9436  uni9436,  CJK UNIFIED IDEOGRAPH-9436
        0x942B, # G+7038  U+942B  uni942B,  CJK UNIFIED IDEOGRAPH-942B
        0x9435, # G+7039  U+9435  uni9435,  CJK UNIFIED IDEOGRAPH-9435
        0x9421, # G+7040  U+9421  uni9421,  CJK UNIFIED IDEOGRAPH-9421
        0x943A, # G+7041  U+943A  uni943A,  CJK UNIFIED IDEOGRAPH-943A
        0x9441, # G+7042  U+9441  uni9441,  CJK UNIFIED IDEOGRAPH-9441
        0x9452, # G+7043  U+9452  uni9452,  CJK UNIFIED IDEOGRAPH-9452
        0x9444, # G+7044  U+9444  uni9444,  CJK UNIFIED IDEOGRAPH-9444
        0x945B, # G+7045  U+945B  uni945B,  CJK UNIFIED IDEOGRAPH-945B
        0x9460, # G+7046  U+9460  uni9460,  CJK UNIFIED IDEOGRAPH-9460
        0x9462, # G+7047  U+9462  uni9462,  CJK UNIFIED IDEOGRAPH-9462
        0x945E, # G+7048  U+945E  uni945E,  CJK UNIFIED IDEOGRAPH-945E
        0x946A, # G+7049  U+946A  uni946A,  CJK UNIFIED IDEOGRAPH-946A
        0x9229, # G+7050  U+9229  uni9229,  CJK UNIFIED IDEOGRAPH-9229
        0x9470, # G+7051  U+9470  uni9470,  CJK UNIFIED IDEOGRAPH-9470
        0x9475, # G+7052  U+9475  uni9475,  CJK UNIFIED IDEOGRAPH-9475
        0x9477, # G+7053  U+9477  uni9477,  CJK UNIFIED IDEOGRAPH-9477
        0x947D, # G+7054  U+947D  uni947D,  CJK UNIFIED IDEOGRAPH-947D
        0x945A, # G+7055  U+945A  uni945A,  CJK UNIFIED IDEOGRAPH-945A
        0x947C, # G+7056  U+947C  uni947C,  CJK UNIFIED IDEOGRAPH-947C
        0x947E, # G+7057  U+947E  uni947E,  CJK UNIFIED IDEOGRAPH-947E
        0x9481, # G+7058  U+9481  uni9481,  CJK UNIFIED IDEOGRAPH-9481
        0x947F, # G+7059  U+947F  uni947F,  CJK UNIFIED IDEOGRAPH-947F
        0x9582, # G+7060  U+9582  uni9582,  CJK UNIFIED IDEOGRAPH-9582
        0x9587, # G+7061  U+9587  uni9587,  CJK UNIFIED IDEOGRAPH-9587
        0x958A, # G+7062  U+958A  uni958A,  CJK UNIFIED IDEOGRAPH-958A
        0x9594, # G+7063  U+9594  uni9594,  CJK UNIFIED IDEOGRAPH-9594
        0x9596, # G+7064  U+9596  uni9596,  CJK UNIFIED IDEOGRAPH-9596
        0x9598, # G+7065  U+9598  uni9598,  CJK UNIFIED IDEOGRAPH-9598
        0x9599, # G+7066  U+9599  uni9599,  CJK UNIFIED IDEOGRAPH-9599
        0x95A0, # G+7067  U+95A0  uni95A0,  CJK UNIFIED IDEOGRAPH-95A0
        0x95A8, # G+7068  U+95A8  uni95A8,  CJK UNIFIED IDEOGRAPH-95A8
        0x95A7, # G+7069  U+95A7  uni95A7,  CJK UNIFIED IDEOGRAPH-95A7
        0x95AD, # G+7070  U+95AD  uni95AD,  CJK UNIFIED IDEOGRAPH-95AD
        0x95BC, # G+7071  U+95BC  uni95BC,  CJK UNIFIED IDEOGRAPH-95BC
        0x95BB, # G+7072  U+95BB  uni95BB,  CJK UNIFIED IDEOGRAPH-95BB
        0x95B9, # G+7073  U+95B9  uni95B9,  CJK UNIFIED IDEOGRAPH-95B9
        0x95BE, # G+7074  U+95BE  uni95BE,  CJK UNIFIED IDEOGRAPH-95BE
        0x95CA, # G+7075  U+95CA  uni95CA,  CJK UNIFIED IDEOGRAPH-95CA
        0x6FF6, # G+7076  U+6FF6  uni6FF6,  CJK UNIFIED IDEOGRAPH-6FF6
        0x95C3, # G+7077  U+95C3  uni95C3,  CJK UNIFIED IDEOGRAPH-95C3
        0x95CD, # G+7078  U+95CD  uni95CD,  CJK UNIFIED IDEOGRAPH-95CD
        0x95CC, # G+7079  U+95CC  uni95CC,  CJK UNIFIED IDEOGRAPH-95CC
        0x95D5, # G+7080  U+95D5  uni95D5,  CJK UNIFIED IDEOGRAPH-95D5
        0x95D4, # G+7081  U+95D4  uni95D4,  CJK UNIFIED IDEOGRAPH-95D4
        0x95D6, # G+7082  U+95D6  uni95D6,  CJK UNIFIED IDEOGRAPH-95D6
        0x95DC, # G+7083  U+95DC  uni95DC,  CJK UNIFIED IDEOGRAPH-95DC
        0x95E1, # G+7084  U+95E1  uni95E1,  CJK UNIFIED IDEOGRAPH-95E1
        0x95E5, # G+7085  U+95E5  uni95E5,  CJK UNIFIED IDEOGRAPH-95E5
        0x95E2, # G+7086  U+95E2  uni95E2,  CJK UNIFIED IDEOGRAPH-95E2
        0x9621, # G+7087  U+9621  uni9621,  CJK UNIFIED IDEOGRAPH-9621
        0x9628, # G+7088  U+9628  uni9628,  CJK UNIFIED IDEOGRAPH-9628
        0x962E, # G+7089  U+962E  uni962E,  CJK UNIFIED IDEOGRAPH-962E
        0x962F, # G+7090  U+962F  uni962F,  CJK UNIFIED IDEOGRAPH-962F
        0x9642, # G+7091  U+9642  uni9642,  CJK UNIFIED IDEOGRAPH-9642
        0x964C, # G+7092  U+964C  uni964C,  CJK UNIFIED IDEOGRAPH-964C
        0x964F, # G+7093  U+964F  uni964F,  CJK UNIFIED IDEOGRAPH-964F
        0x964B, # G+7094  U+964B  uni964B,  CJK UNIFIED IDEOGRAPH-964B
        0x9677, # G+7095  U+9677  uni9677,  CJK UNIFIED IDEOGRAPH-9677
        0x965C, # G+7096  U+965C  uni965C,  CJK UNIFIED IDEOGRAPH-965C
        0x965E, # G+7097  U+965E  uni965E,  CJK UNIFIED IDEOGRAPH-965E
        0x965D, # G+7098  U+965D  uni965D,  CJK UNIFIED IDEOGRAPH-965D
        0x965F, # G+7099  U+965F  uni965F,  CJK UNIFIED IDEOGRAPH-965F
        0x9666, # G+7100  U+9666  uni9666,  CJK UNIFIED IDEOGRAPH-9666
        0x9672, # G+7101  U+9672  uni9672,  CJK UNIFIED IDEOGRAPH-9672
        0x966C, # G+7102  U+966C  uni966C,  CJK UNIFIED IDEOGRAPH-966C
        0x968D, # G+7103  U+968D  uni968D,  CJK UNIFIED IDEOGRAPH-968D
        0x9698, # G+7104  U+9698  uni9698,  CJK UNIFIED IDEOGRAPH-9698
        0x9695, # G+7105  U+9695  uni9695,  CJK UNIFIED IDEOGRAPH-9695
        0x9697, # G+7106  U+9697  uni9697,  CJK UNIFIED IDEOGRAPH-9697
        0x96AA, # G+7107  U+96AA  uni96AA,  CJK UNIFIED IDEOGRAPH-96AA
        0x96A7, # G+7108  U+96A7  uni96A7,  CJK UNIFIED IDEOGRAPH-96A7
        0x96B1, # G+7109  U+96B1  uni96B1,  CJK UNIFIED IDEOGRAPH-96B1
        0x96B2, # G+7110  U+96B2  uni96B2,  CJK UNIFIED IDEOGRAPH-96B2
        0x96B0, # G+7111  U+96B0  uni96B0,  CJK UNIFIED IDEOGRAPH-96B0
        0x96B4, # G+7112  U+96B4  uni96B4,  CJK UNIFIED IDEOGRAPH-96B4
        0x2FAA, # G+7113  U+2FAA  uni2FAA,  KANGXI RADICAL SLAVE
        0x96B8, # G+7114  U+96B8  uni96B8,  CJK UNIFIED IDEOGRAPH-96B8
        0x2FAB, # G+7115  U+2FAB  uni2FAB,  KANGXI RADICAL SHORT TAILED BIRD
        0x96CE, # G+7116  U+96CE  uni96CE,  CJK UNIFIED IDEOGRAPH-96CE
        0x96CB, # G+7117  U+96CB  uni96CB,  CJK UNIFIED IDEOGRAPH-96CB
        0x96C9, # G+7118  U+96C9  uni96C9,  CJK UNIFIED IDEOGRAPH-96C9
        0x96CD, # G+7119  U+96CD  uni96CD,  CJK UNIFIED IDEOGRAPH-96CD
        0x894D, # G+7120  U+894D  uni894D,  CJK UNIFIED IDEOGRAPH-894D
        0x96DC, # G+7121  U+96DC  uni96DC,  CJK UNIFIED IDEOGRAPH-96DC
        0x970D, # G+7122  U+970D  uni970D,  CJK UNIFIED IDEOGRAPH-970D
        0x96D5, # G+7123  U+96D5  uni96D5,  CJK UNIFIED IDEOGRAPH-96D5
        0x96F9, # G+7124  U+96F9  uni96F9,  CJK UNIFIED IDEOGRAPH-96F9
        0x9704, # G+7125  U+9704  uni9704,  CJK UNIFIED IDEOGRAPH-9704
        0x9706, # G+7126  U+9706  uni9706,  CJK UNIFIED IDEOGRAPH-9706
        0x9708, # G+7127  U+9708  uni9708,  CJK UNIFIED IDEOGRAPH-9708
        0x9713, # G+7128  U+9713  uni9713,  CJK UNIFIED IDEOGRAPH-9713
        0x970E, # G+7129  U+970E  uni970E,  CJK UNIFIED IDEOGRAPH-970E
        0x9711, # G+7130  U+9711  uni9711,  CJK UNIFIED IDEOGRAPH-9711
        0x970F, # G+7131  U+970F  uni970F,  CJK UNIFIED IDEOGRAPH-970F
        0x9716, # G+7132  U+9716  uni9716,  CJK UNIFIED IDEOGRAPH-9716
        0x9719, # G+7133  U+9719  uni9719,  CJK UNIFIED IDEOGRAPH-9719
        0x9724, # G+7134  U+9724  uni9724,  CJK UNIFIED IDEOGRAPH-9724
        0x972A, # G+7135  U+972A  uni972A,  CJK UNIFIED IDEOGRAPH-972A
        0x9730, # G+7136  U+9730  uni9730,  CJK UNIFIED IDEOGRAPH-9730
        0x9739, # G+7137  U+9739  uni9739,  CJK UNIFIED IDEOGRAPH-9739
        0x973D, # G+7138  U+973D  uni973D,  CJK UNIFIED IDEOGRAPH-973D
        0x973E, # G+7139  U+973E  uni973E,  CJK UNIFIED IDEOGRAPH-973E
        0x9744, # G+7140  U+9744  uni9744,  CJK UNIFIED IDEOGRAPH-9744
        0x9746, # G+7141  U+9746  uni9746,  CJK UNIFIED IDEOGRAPH-9746
        0x9748, # G+7142  U+9748  uni9748,  CJK UNIFIED IDEOGRAPH-9748
        0x9742, # G+7143  U+9742  uni9742,  CJK UNIFIED IDEOGRAPH-9742
        0x9749, # G+7144  U+9749  uni9749,  CJK UNIFIED IDEOGRAPH-9749
        0x975C, # G+7145  U+975C  uni975C,  CJK UNIFIED IDEOGRAPH-975C
        0x9760, # G+7146  U+9760  uni9760,  CJK UNIFIED IDEOGRAPH-9760
        0x9764, # G+7147  U+9764  uni9764,  CJK UNIFIED IDEOGRAPH-9764
        0x9766, # G+7148  U+9766  uni9766,  CJK UNIFIED IDEOGRAPH-9766
        0x9768, # G+7149  U+9768  uni9768,  CJK UNIFIED IDEOGRAPH-9768
        0x52D2, # G+7150  U+52D2  uni52D2,  CJK UNIFIED IDEOGRAPH-52D2
        0x976B, # G+7151  U+976B  uni976B,  CJK UNIFIED IDEOGRAPH-976B
        0x9771, # G+7152  U+9771  uni9771,  CJK UNIFIED IDEOGRAPH-9771
        0x9779, # G+7153  U+9779  uni9779,  CJK UNIFIED IDEOGRAPH-9779
        0x9785, # G+7154  U+9785  uni9785,  CJK UNIFIED IDEOGRAPH-9785
        0x977C, # G+7155  U+977C  uni977C,  CJK UNIFIED IDEOGRAPH-977C
        0x9781, # G+7156  U+9781  uni9781,  CJK UNIFIED IDEOGRAPH-9781
        0x977A, # G+7157  U+977A  uni977A,  CJK UNIFIED IDEOGRAPH-977A
        0x9786, # G+7158  U+9786  uni9786,  CJK UNIFIED IDEOGRAPH-9786
        0x978B, # G+7159  U+978B  uni978B,  CJK UNIFIED IDEOGRAPH-978B
        0x978F, # G+7160  U+978F  uni978F,  CJK UNIFIED IDEOGRAPH-978F
        0x9790, # G+7161  U+9790  uni9790,  CJK UNIFIED IDEOGRAPH-9790
        0x979C, # G+7162  U+979C  uni979C,  CJK UNIFIED IDEOGRAPH-979C
        0x97A8, # G+7163  U+97A8  uni97A8,  CJK UNIFIED IDEOGRAPH-97A8
        0x97A6, # G+7164  U+97A6  uni97A6,  CJK UNIFIED IDEOGRAPH-97A6
        0x97A3, # G+7165  U+97A3  uni97A3,  CJK UNIFIED IDEOGRAPH-97A3
        0x97B3, # G+7166  U+97B3  uni97B3,  CJK UNIFIED IDEOGRAPH-97B3
        0x97B4, # G+7167  U+97B4  uni97B4,  CJK UNIFIED IDEOGRAPH-97B4
        0x97C3, # G+7168  U+97C3  uni97C3,  CJK UNIFIED IDEOGRAPH-97C3
        0x97C6, # G+7169  U+97C6  uni97C6,  CJK UNIFIED IDEOGRAPH-97C6
        0x97C8, # G+7170  U+97C8  uni97C8,  CJK UNIFIED IDEOGRAPH-97C8
        0x2FB1, # G+7171  U+2FB1  uni2FB1,  KANGXI RADICAL TANNED LEATHER
        0x97DC, # G+7172  U+97DC  uni97DC,  CJK UNIFIED IDEOGRAPH-97DC
        0x2FB2, # G+7173  U+2FB2  uni2FB2,  KANGXI RADICAL LEEK
        0x9F4F, # G+7174  U+9F4F  uni9F4F,  CJK UNIFIED IDEOGRAPH-9F4F
        0x97F2, # G+7175  U+97F2  uni97F2,  CJK UNIFIED IDEOGRAPH-97F2
        0x7ADF, # G+7176  U+7ADF  uni7ADF,  CJK UNIFIED IDEOGRAPH-7ADF
        0x97F6, # G+7177  U+97F6  uni97F6,  CJK UNIFIED IDEOGRAPH-97F6
        0x97F5, # G+7178  U+97F5  uni97F5,  CJK UNIFIED IDEOGRAPH-97F5
        0x980F, # G+7179  U+980F  uni980F,  CJK UNIFIED IDEOGRAPH-980F
        0x980C, # G+7180  U+980C  uni980C,  CJK UNIFIED IDEOGRAPH-980C
        0x9838, # G+7181  U+9838  uni9838,  CJK UNIFIED IDEOGRAPH-9838
        0x9824, # G+7182  U+9824  uni9824,  CJK UNIFIED IDEOGRAPH-9824
        0x9821, # G+7183  U+9821  uni9821,  CJK UNIFIED IDEOGRAPH-9821
        0x9837, # G+7184  U+9837  uni9837,  CJK UNIFIED IDEOGRAPH-9837
        0x983D, # G+7185  U+983D  uni983D,  CJK UNIFIED IDEOGRAPH-983D
        0x9846, # G+7186  U+9846  uni9846,  CJK UNIFIED IDEOGRAPH-9846
        0x984F, # G+7187  U+984F  uni984F,  CJK UNIFIED IDEOGRAPH-984F
        0x984B, # G+7188  U+984B  uni984B,  CJK UNIFIED IDEOGRAPH-984B
        0x986B, # G+7189  U+986B  uni986B,  CJK UNIFIED IDEOGRAPH-986B
        0x986F, # G+7190  U+986F  uni986F,  CJK UNIFIED IDEOGRAPH-986F
        0x9870, # G+7191  U+9870  uni9870,  CJK UNIFIED IDEOGRAPH-9870
        0x9871, # G+7192  U+9871  uni9871,  CJK UNIFIED IDEOGRAPH-9871
        0x9874, # G+7193  U+9874  uni9874,  CJK UNIFIED IDEOGRAPH-9874
        0x9873, # G+7194  U+9873  uni9873,  CJK UNIFIED IDEOGRAPH-9873
        0x98AA, # G+7195  U+98AA  uni98AA,  CJK UNIFIED IDEOGRAPH-98AA
        0x98AF, # G+7196  U+98AF  uni98AF,  CJK UNIFIED IDEOGRAPH-98AF
        0x98B1, # G+7197  U+98B1  uni98B1,  CJK UNIFIED IDEOGRAPH-98B1
        0x98B6, # G+7198  U+98B6  uni98B6,  CJK UNIFIED IDEOGRAPH-98B6
        0x98C4, # G+7199  U+98C4  uni98C4,  CJK UNIFIED IDEOGRAPH-98C4
        0x98C3, # G+7200  U+98C3  uni98C3,  CJK UNIFIED IDEOGRAPH-98C3
        0x98C6, # G+7201  U+98C6  uni98C6,  CJK UNIFIED IDEOGRAPH-98C6
        0x98E9, # G+7202  U+98E9  uni98E9,  CJK UNIFIED IDEOGRAPH-98E9
        0x98EB, # G+7203  U+98EB  uni98EB,  CJK UNIFIED IDEOGRAPH-98EB
        0x9903, # G+7204  U+9903  uni9903,  CJK UNIFIED IDEOGRAPH-9903
        0x9909, # G+7205  U+9909  uni9909,  CJK UNIFIED IDEOGRAPH-9909
        0x9912, # G+7206  U+9912  uni9912,  CJK UNIFIED IDEOGRAPH-9912
        0x9914, # G+7207  U+9914  uni9914,  CJK UNIFIED IDEOGRAPH-9914
        0x9918, # G+7208  U+9918  uni9918,  CJK UNIFIED IDEOGRAPH-9918
        0x9921, # G+7209  U+9921  uni9921,  CJK UNIFIED IDEOGRAPH-9921
        0x991D, # G+7210  U+991D  uni991D,  CJK UNIFIED IDEOGRAPH-991D
        0x991E, # G+7211  U+991E  uni991E,  CJK UNIFIED IDEOGRAPH-991E
        0x9924, # G+7212  U+9924  uni9924,  CJK UNIFIED IDEOGRAPH-9924
        0x9920, # G+7213  U+9920  uni9920,  CJK UNIFIED IDEOGRAPH-9920
        0x992C, # G+7214  U+992C  uni992C,  CJK UNIFIED IDEOGRAPH-992C
        0x992E, # G+7215  U+992E  uni992E,  CJK UNIFIED IDEOGRAPH-992E
        0x993D, # G+7216  U+993D  uni993D,  CJK UNIFIED IDEOGRAPH-993D
        0x993E, # G+7217  U+993E  uni993E,  CJK UNIFIED IDEOGRAPH-993E
        0x9942, # G+7218  U+9942  uni9942,  CJK UNIFIED IDEOGRAPH-9942
        0x9949, # G+7219  U+9949  uni9949,  CJK UNIFIED IDEOGRAPH-9949
        0x9945, # G+7220  U+9945  uni9945,  CJK UNIFIED IDEOGRAPH-9945
        0x9950, # G+7221  U+9950  uni9950,  CJK UNIFIED IDEOGRAPH-9950
        0x994B, # G+7222  U+994B  uni994B,  CJK UNIFIED IDEOGRAPH-994B
        0x9951, # G+7223  U+9951  uni9951,  CJK UNIFIED IDEOGRAPH-9951
        0x9952, # G+7224  U+9952  uni9952,  CJK UNIFIED IDEOGRAPH-9952
        0x994C, # G+7225  U+994C  uni994C,  CJK UNIFIED IDEOGRAPH-994C
        0x9955, # G+7226  U+9955  uni9955,  CJK UNIFIED IDEOGRAPH-9955
        0x9997, # G+7227  U+9997  uni9997,  CJK UNIFIED IDEOGRAPH-9997
        0x9998, # G+7228  U+9998  uni9998,  CJK UNIFIED IDEOGRAPH-9998
        0x99A5, # G+7229  U+99A5  uni99A5,  CJK UNIFIED IDEOGRAPH-99A5
        0x99AD, # G+7230  U+99AD  uni99AD,  CJK UNIFIED IDEOGRAPH-99AD
        0x99AE, # G+7231  U+99AE  uni99AE,  CJK UNIFIED IDEOGRAPH-99AE
        0x99BC, # G+7232  U+99BC  uni99BC,  CJK UNIFIED IDEOGRAPH-99BC
        0x99DF, # G+7233  U+99DF  uni99DF,  CJK UNIFIED IDEOGRAPH-99DF
        0x99DB, # G+7234  U+99DB  uni99DB,  CJK UNIFIED IDEOGRAPH-99DB
        0x99DD, # G+7235  U+99DD  uni99DD,  CJK UNIFIED IDEOGRAPH-99DD
        0x99D8, # G+7236  U+99D8  uni99D8,  CJK UNIFIED IDEOGRAPH-99D8
        0x99D1, # G+7237  U+99D1  uni99D1,  CJK UNIFIED IDEOGRAPH-99D1
        0x99ED, # G+7238  U+99ED  uni99ED,  CJK UNIFIED IDEOGRAPH-99ED
        0x99EE, # G+7239  U+99EE  uni99EE,  CJK UNIFIED IDEOGRAPH-99EE
        0x99F1, # G+7240  U+99F1  uni99F1,  CJK UNIFIED IDEOGRAPH-99F1
        0x99F2, # G+7241  U+99F2  uni99F2,  CJK UNIFIED IDEOGRAPH-99F2
        0x99FB, # G+7242  U+99FB  uni99FB,  CJK UNIFIED IDEOGRAPH-99FB
        0x99F8, # G+7243  U+99F8  uni99F8,  CJK UNIFIED IDEOGRAPH-99F8
        0x9A01, # G+7244  U+9A01  uni9A01,  CJK UNIFIED IDEOGRAPH-9A01
        0x9A0F, # G+7245  U+9A0F  uni9A0F,  CJK UNIFIED IDEOGRAPH-9A0F
        0x9A05, # G+7246  U+9A05  uni9A05,  CJK UNIFIED IDEOGRAPH-9A05
        0x99E2, # G+7247  U+99E2  uni99E2,  CJK UNIFIED IDEOGRAPH-99E2
        0x9A19, # G+7248  U+9A19  uni9A19,  CJK UNIFIED IDEOGRAPH-9A19
        0x9A2B, # G+7249  U+9A2B  uni9A2B,  CJK UNIFIED IDEOGRAPH-9A2B
        0x9A37, # G+7250  U+9A37  uni9A37,  CJK UNIFIED IDEOGRAPH-9A37
        0x9A45, # G+7251  U+9A45  uni9A45,  CJK UNIFIED IDEOGRAPH-9A45
        0x9A42, # G+7252  U+9A42  uni9A42,  CJK UNIFIED IDEOGRAPH-9A42
        0x9A40, # G+7253  U+9A40  uni9A40,  CJK UNIFIED IDEOGRAPH-9A40
        0x9A43, # G+7254  U+9A43  uni9A43,  CJK UNIFIED IDEOGRAPH-9A43
        0x9A3E, # G+7255  U+9A3E  uni9A3E,  CJK UNIFIED IDEOGRAPH-9A3E
        0x9A55, # G+7256  U+9A55  uni9A55,  CJK UNIFIED IDEOGRAPH-9A55
        0x9A4D, # G+7257  U+9A4D  uni9A4D,  CJK UNIFIED IDEOGRAPH-9A4D
        0x9A5B, # G+7258  U+9A5B  uni9A5B,  CJK UNIFIED IDEOGRAPH-9A5B
        0x9A57, # G+7259  U+9A57  uni9A57,  CJK UNIFIED IDEOGRAPH-9A57
        0x9A5F, # G+7260  U+9A5F  uni9A5F,  CJK UNIFIED IDEOGRAPH-9A5F
        0x9A62, # G+7261  U+9A62  uni9A62,  CJK UNIFIED IDEOGRAPH-9A62
        0x9A65, # G+7262  U+9A65  uni9A65,  CJK UNIFIED IDEOGRAPH-9A65
        0x9A64, # G+7263  U+9A64  uni9A64,  CJK UNIFIED IDEOGRAPH-9A64
        0x9A69, # G+7264  U+9A69  uni9A69,  CJK UNIFIED IDEOGRAPH-9A69
        0x9A6B, # G+7265  U+9A6B  uni9A6B,  CJK UNIFIED IDEOGRAPH-9A6B
        0x9A6A, # G+7266  U+9A6A  uni9A6A,  CJK UNIFIED IDEOGRAPH-9A6A
        0x9AAD, # G+7267  U+9AAD  uni9AAD,  CJK UNIFIED IDEOGRAPH-9AAD
        0x9AB0, # G+7268  U+9AB0  uni9AB0,  CJK UNIFIED IDEOGRAPH-9AB0
        0x9ABC, # G+7269  U+9ABC  uni9ABC,  CJK UNIFIED IDEOGRAPH-9ABC
        0x9AC0, # G+7270  U+9AC0  uni9AC0,  CJK UNIFIED IDEOGRAPH-9AC0
        0x9ACF, # G+7271  U+9ACF  uni9ACF,  CJK UNIFIED IDEOGRAPH-9ACF
        0x9AD1, # G+7272  U+9AD1  uni9AD1,  CJK UNIFIED IDEOGRAPH-9AD1
        0x9AD3, # G+7273  U+9AD3  uni9AD3,  CJK UNIFIED IDEOGRAPH-9AD3
        0x9AD4, # G+7274  U+9AD4  uni9AD4,  CJK UNIFIED IDEOGRAPH-9AD4
        0x9ADE, # G+7275  U+9ADE  uni9ADE,  CJK UNIFIED IDEOGRAPH-9ADE
        0x2FBD, # G+7276  U+2FBD  uni2FBD,  KANGXI RADICAL HAIR
        0x9AE2, # G+7277  U+9AE2  uni9AE2,  CJK UNIFIED IDEOGRAPH-9AE2
        0x9AE3, # G+7278  U+9AE3  uni9AE3,  CJK UNIFIED IDEOGRAPH-9AE3
        0x9AE6, # G+7279  U+9AE6  uni9AE6,  CJK UNIFIED IDEOGRAPH-9AE6
        0x9AEF, # G+7280  U+9AEF  uni9AEF,  CJK UNIFIED IDEOGRAPH-9AEF
        0x9AEB, # G+7281  U+9AEB  uni9AEB,  CJK UNIFIED IDEOGRAPH-9AEB
        0x9AEE, # G+7282  U+9AEE  uni9AEE,  CJK UNIFIED IDEOGRAPH-9AEE
        0x9AF4, # G+7283  U+9AF4  uni9AF4,  CJK UNIFIED IDEOGRAPH-9AF4
        0x9AF1, # G+7284  U+9AF1  uni9AF1,  CJK UNIFIED IDEOGRAPH-9AF1
        0x9AF7, # G+7285  U+9AF7  uni9AF7,  CJK UNIFIED IDEOGRAPH-9AF7
        0x9AFB, # G+7286  U+9AFB  uni9AFB,  CJK UNIFIED IDEOGRAPH-9AFB
        0x9B06, # G+7287  U+9B06  uni9B06,  CJK UNIFIED IDEOGRAPH-9B06
        0x9B18, # G+7288  U+9B18  uni9B18,  CJK UNIFIED IDEOGRAPH-9B18
        0x9B1A, # G+7289  U+9B1A  uni9B1A,  CJK UNIFIED IDEOGRAPH-9B1A
        0x9B1F, # G+7290  U+9B1F  uni9B1F,  CJK UNIFIED IDEOGRAPH-9B1F
        0x9B22, # G+7291  U+9B22  uni9B22,  CJK UNIFIED IDEOGRAPH-9B22
        0x9B23, # G+7292  U+9B23  uni9B23,  CJK UNIFIED IDEOGRAPH-9B23
        0x2FBE, # G+7293  U+2FBE  uni2FBE,  KANGXI RADICAL FIGHT
        0x9B27, # G+7294  U+9B27  uni9B27,  CJK UNIFIED IDEOGRAPH-9B27
        0x9B28, # G+7295  U+9B28  uni9B28,  CJK UNIFIED IDEOGRAPH-9B28
        0x9B29, # G+7296  U+9B29  uni9B29,  CJK UNIFIED IDEOGRAPH-9B29
        0x9B2A, # G+7297  U+9B2A  uni9B2A,  CJK UNIFIED IDEOGRAPH-9B2A
        0x9B2E, # G+7298  U+9B2E  uni9B2E,  CJK UNIFIED IDEOGRAPH-9B2E
        0x2FBF, # G+7299  U+2FBF  uni2FBF,  KANGXI RADICAL SACRIFICIAL WINE
        0x2FC0, # G+7300  U+2FC0  uni2FC0,  KANGXI RADICAL CAULDRON
        0x9B44, # G+7301  U+9B44  uni9B44,  CJK UNIFIED IDEOGRAPH-9B44
        0x9B43, # G+7302  U+9B43  uni9B43,  CJK UNIFIED IDEOGRAPH-9B43
        0x9B4F, # G+7303  U+9B4F  uni9B4F,  CJK UNIFIED IDEOGRAPH-9B4F
        0x9B4D, # G+7304  U+9B4D  uni9B4D,  CJK UNIFIED IDEOGRAPH-9B4D
        0x9B4E, # G+7305  U+9B4E  uni9B4E,  CJK UNIFIED IDEOGRAPH-9B4E
        0x9B51, # G+7306  U+9B51  uni9B51,  CJK UNIFIED IDEOGRAPH-9B51
        0x9B58, # G+7307  U+9B58  uni9B58,  CJK UNIFIED IDEOGRAPH-9B58
        0x9B74, # G+7308  U+9B74  uni9B74,  CJK UNIFIED IDEOGRAPH-9B74
        0x9B93, # G+7309  U+9B93  uni9B93,  CJK UNIFIED IDEOGRAPH-9B93
        0x9B83, # G+7310  U+9B83  uni9B83,  CJK UNIFIED IDEOGRAPH-9B83
        0x9B91, # G+7311  U+9B91  uni9B91,  CJK UNIFIED IDEOGRAPH-9B91
        0x9B96, # G+7312  U+9B96  uni9B96,  CJK UNIFIED IDEOGRAPH-9B96
        0x9B97, # G+7313  U+9B97  uni9B97,  CJK UNIFIED IDEOGRAPH-9B97
        0x9B9F, # G+7314  U+9B9F  uni9B9F,  CJK UNIFIED IDEOGRAPH-9B9F
        0x9BA0, # G+7315  U+9BA0  uni9BA0,  CJK UNIFIED IDEOGRAPH-9BA0
        0x9BA8, # G+7316  U+9BA8  uni9BA8,  CJK UNIFIED IDEOGRAPH-9BA8
        0x9BB4, # G+7317  U+9BB4  uni9BB4,  CJK UNIFIED IDEOGRAPH-9BB4
        0x9BC0, # G+7318  U+9BC0  uni9BC0,  CJK UNIFIED IDEOGRAPH-9BC0
        0x9BCA, # G+7319  U+9BCA  uni9BCA,  CJK UNIFIED IDEOGRAPH-9BCA
        0x9BB9, # G+7320  U+9BB9  uni9BB9,  CJK UNIFIED IDEOGRAPH-9BB9
        0x9BC6, # G+7321  U+9BC6  uni9BC6,  CJK UNIFIED IDEOGRAPH-9BC6
        0x9BCF, # G+7322  U+9BCF  uni9BCF,  CJK UNIFIED IDEOGRAPH-9BCF
        0x9BD1, # G+7323  U+9BD1  uni9BD1,  CJK UNIFIED IDEOGRAPH-9BD1
        0x9BD2, # G+7324  U+9BD2  uni9BD2,  CJK UNIFIED IDEOGRAPH-9BD2
        0x9BE3, # G+7325  U+9BE3  uni9BE3,  CJK UNIFIED IDEOGRAPH-9BE3
        0x9BE2, # G+7326  U+9BE2  uni9BE2,  CJK UNIFIED IDEOGRAPH-9BE2
        0x9BE4, # G+7327  U+9BE4  uni9BE4,  CJK UNIFIED IDEOGRAPH-9BE4
        0x9BD4, # G+7328  U+9BD4  uni9BD4,  CJK UNIFIED IDEOGRAPH-9BD4
        0x9BE1, # G+7329  U+9BE1  uni9BE1,  CJK UNIFIED IDEOGRAPH-9BE1
        0x9C3A, # G+7330  U+9C3A  uni9C3A,  CJK UNIFIED IDEOGRAPH-9C3A
        0x9BF2, # G+7331  U+9BF2  uni9BF2,  CJK UNIFIED IDEOGRAPH-9BF2
        0x9BF1, # G+7332  U+9BF1  uni9BF1,  CJK UNIFIED IDEOGRAPH-9BF1
        0x9BF0, # G+7333  U+9BF0  uni9BF0,  CJK UNIFIED IDEOGRAPH-9BF0
        0x9C15, # G+7334  U+9C15  uni9C15,  CJK UNIFIED IDEOGRAPH-9C15
        0x9C14, # G+7335  U+9C14  uni9C14,  CJK UNIFIED IDEOGRAPH-9C14
        0x9C09, # G+7336  U+9C09  uni9C09,  CJK UNIFIED IDEOGRAPH-9C09
        0x9C13, # G+7337  U+9C13  uni9C13,  CJK UNIFIED IDEOGRAPH-9C13
        0x9C0C, # G+7338  U+9C0C  uni9C0C,  CJK UNIFIED IDEOGRAPH-9C0C
        0x9C06, # G+7339  U+9C06  uni9C06,  CJK UNIFIED IDEOGRAPH-9C06
        0x9C08, # G+7340  U+9C08  uni9C08,  CJK UNIFIED IDEOGRAPH-9C08
        0x9C12, # G+7341  U+9C12  uni9C12,  CJK UNIFIED IDEOGRAPH-9C12
        0x9C0A, # G+7342  U+9C0A  uni9C0A,  CJK UNIFIED IDEOGRAPH-9C0A
        0x9C04, # G+7343  U+9C04  uni9C04,  CJK UNIFIED IDEOGRAPH-9C04
        0x9C2E, # G+7344  U+9C2E  uni9C2E,  CJK UNIFIED IDEOGRAPH-9C2E
        0x9C1B, # G+7345  U+9C1B  uni9C1B,  CJK UNIFIED IDEOGRAPH-9C1B
        0x9C25, # G+7346  U+9C25  uni9C25,  CJK UNIFIED IDEOGRAPH-9C25
        0x9C24, # G+7347  U+9C24  uni9C24,  CJK UNIFIED IDEOGRAPH-9C24
        0x9C21, # G+7348  U+9C21  uni9C21,  CJK UNIFIED IDEOGRAPH-9C21
        0x9C30, # G+7349  U+9C30  uni9C30,  CJK UNIFIED IDEOGRAPH-9C30
        0x9C47, # G+7350  U+9C47  uni9C47,  CJK UNIFIED IDEOGRAPH-9C47
        0x9C32, # G+7351  U+9C32  uni9C32,  CJK UNIFIED IDEOGRAPH-9C32
        0x9C46, # G+7352  U+9C46  uni9C46,  CJK UNIFIED IDEOGRAPH-9C46
        0x9C3E, # G+7353  U+9C3E  uni9C3E,  CJK UNIFIED IDEOGRAPH-9C3E
        0x9C5A, # G+7354  U+9C5A  uni9C5A,  CJK UNIFIED IDEOGRAPH-9C5A
        0x9C60, # G+7355  U+9C60  uni9C60,  CJK UNIFIED IDEOGRAPH-9C60
        0x9C67, # G+7356  U+9C67  uni9C67,  CJK UNIFIED IDEOGRAPH-9C67
        0x9C76, # G+7357  U+9C76  uni9C76,  CJK UNIFIED IDEOGRAPH-9C76
        0x9C78, # G+7358  U+9C78  uni9C78,  CJK UNIFIED IDEOGRAPH-9C78
        0x9CE7, # G+7359  U+9CE7  uni9CE7,  CJK UNIFIED IDEOGRAPH-9CE7
        0x9CEC, # G+7360  U+9CEC  uni9CEC,  CJK UNIFIED IDEOGRAPH-9CEC
        0x9CF0, # G+7361  U+9CF0  uni9CF0,  CJK UNIFIED IDEOGRAPH-9CF0
        0x9D09, # G+7362  U+9D09  uni9D09,  CJK UNIFIED IDEOGRAPH-9D09
        0x9D08, # G+7363  U+9D08  uni9D08,  CJK UNIFIED IDEOGRAPH-9D08
        0x9CEB, # G+7364  U+9CEB  uni9CEB,  CJK UNIFIED IDEOGRAPH-9CEB
        0x9D03, # G+7365  U+9D03  uni9D03,  CJK UNIFIED IDEOGRAPH-9D03
        0x9D06, # G+7366  U+9D06  uni9D06,  CJK UNIFIED IDEOGRAPH-9D06
        0x9D2A, # G+7367  U+9D2A  uni9D2A,  CJK UNIFIED IDEOGRAPH-9D2A
        0x9D26, # G+7368  U+9D26  uni9D26,  CJK UNIFIED IDEOGRAPH-9D26
        0x9DAF, # G+7369  U+9DAF  uni9DAF,  CJK UNIFIED IDEOGRAPH-9DAF
        0x9D23, # G+7370  U+9D23  uni9D23,  CJK UNIFIED IDEOGRAPH-9D23
        0x9D1F, # G+7371  U+9D1F  uni9D1F,  CJK UNIFIED IDEOGRAPH-9D1F
        0x9D44, # G+7372  U+9D44  uni9D44,  CJK UNIFIED IDEOGRAPH-9D44
        0x9D15, # G+7373  U+9D15  uni9D15,  CJK UNIFIED IDEOGRAPH-9D15
        0x9D12, # G+7374  U+9D12  uni9D12,  CJK UNIFIED IDEOGRAPH-9D12
        0x9D41, # G+7375  U+9D41  uni9D41,  CJK UNIFIED IDEOGRAPH-9D41
        0x9D3F, # G+7376  U+9D3F  uni9D3F,  CJK UNIFIED IDEOGRAPH-9D3F
        0x9D3E, # G+7377  U+9D3E  uni9D3E,  CJK UNIFIED IDEOGRAPH-9D3E
        0x9D46, # G+7378  U+9D46  uni9D46,  CJK UNIFIED IDEOGRAPH-9D46
        0x9D48, # G+7379  U+9D48  uni9D48,  CJK UNIFIED IDEOGRAPH-9D48
        0x9D5D, # G+7380  U+9D5D  uni9D5D,  CJK UNIFIED IDEOGRAPH-9D5D
        0x9D5E, # G+7381  U+9D5E  uni9D5E,  CJK UNIFIED IDEOGRAPH-9D5E
        0x9D64, # G+7382  U+9D64  uni9D64,  CJK UNIFIED IDEOGRAPH-9D64
        0x9D51, # G+7383  U+9D51  uni9D51,  CJK UNIFIED IDEOGRAPH-9D51
        0x9D50, # G+7384  U+9D50  uni9D50,  CJK UNIFIED IDEOGRAPH-9D50
        0x9D59, # G+7385  U+9D59  uni9D59,  CJK UNIFIED IDEOGRAPH-9D59
        0x9D72, # G+7386  U+9D72  uni9D72,  CJK UNIFIED IDEOGRAPH-9D72
        0x9D89, # G+7387  U+9D89  uni9D89,  CJK UNIFIED IDEOGRAPH-9D89
        0x9D87, # G+7388  U+9D87  uni9D87,  CJK UNIFIED IDEOGRAPH-9D87
        0x9DAB, # G+7389  U+9DAB  uni9DAB,  CJK UNIFIED IDEOGRAPH-9DAB
        0x9D6F, # G+7390  U+9D6F  uni9D6F,  CJK UNIFIED IDEOGRAPH-9D6F
        0x9D7A, # G+7391  U+9D7A  uni9D7A,  CJK UNIFIED IDEOGRAPH-9D7A
        0x9D9A, # G+7392  U+9D9A  uni9D9A,  CJK UNIFIED IDEOGRAPH-9D9A
        0x9DA4, # G+7393  U+9DA4  uni9DA4,  CJK UNIFIED IDEOGRAPH-9DA4
        0x9DA9, # G+7394  U+9DA9  uni9DA9,  CJK UNIFIED IDEOGRAPH-9DA9
        0x9DB2, # G+7395  U+9DB2  uni9DB2,  CJK UNIFIED IDEOGRAPH-9DB2
        0x9DC4, # G+7396  U+9DC4  uni9DC4,  CJK UNIFIED IDEOGRAPH-9DC4
        0x9DC1, # G+7397  U+9DC1  uni9DC1,  CJK UNIFIED IDEOGRAPH-9DC1
        0x9DBB, # G+7398  U+9DBB  uni9DBB,  CJK UNIFIED IDEOGRAPH-9DBB
        0x9DB8, # G+7399  U+9DB8  uni9DB8,  CJK UNIFIED IDEOGRAPH-9DB8
        0x9DBA, # G+7400  U+9DBA  uni9DBA,  CJK UNIFIED IDEOGRAPH-9DBA
        0x9DC6, # G+7401  U+9DC6  uni9DC6,  CJK UNIFIED IDEOGRAPH-9DC6
        0x9DCF, # G+7402  U+9DCF  uni9DCF,  CJK UNIFIED IDEOGRAPH-9DCF
        0x9DC2, # G+7403  U+9DC2  uni9DC2,  CJK UNIFIED IDEOGRAPH-9DC2
        0x9DD9, # G+7404  U+9DD9  uni9DD9,  CJK UNIFIED IDEOGRAPH-9DD9
        0x9DD3, # G+7405  U+9DD3  uni9DD3,  CJK UNIFIED IDEOGRAPH-9DD3
        0x9DF8, # G+7406  U+9DF8  uni9DF8,  CJK UNIFIED IDEOGRAPH-9DF8
        0x9DE6, # G+7407  U+9DE6  uni9DE6,  CJK UNIFIED IDEOGRAPH-9DE6
        0x9DED, # G+7408  U+9DED  uni9DED,  CJK UNIFIED IDEOGRAPH-9DED
        0x9DEF, # G+7409  U+9DEF  uni9DEF,  CJK UNIFIED IDEOGRAPH-9DEF
        0x9DFD, # G+7410  U+9DFD  uni9DFD,  CJK UNIFIED IDEOGRAPH-9DFD
        0x9E1A, # G+7411  U+9E1A  uni9E1A,  CJK UNIFIED IDEOGRAPH-9E1A
        0x9E1B, # G+7412  U+9E1B  uni9E1B,  CJK UNIFIED IDEOGRAPH-9E1B
        0x9E1E, # G+7413  U+9E1E  uni9E1E,  CJK UNIFIED IDEOGRAPH-9E1E
        0x2FC4, # G+7414  U+2FC4  uni2FC4,  KANGXI RADICAL SALT
        0x9E79, # G+7415  U+9E79  uni9E79,  CJK UNIFIED IDEOGRAPH-9E79
        0x9E7D, # G+7416  U+9E7D  uni9E7D,  CJK UNIFIED IDEOGRAPH-9E7D
        0x9E81, # G+7417  U+9E81  uni9E81,  CJK UNIFIED IDEOGRAPH-9E81
        0x9E88, # G+7418  U+9E88  uni9E88,  CJK UNIFIED IDEOGRAPH-9E88
        0x9E8B, # G+7419  U+9E8B  uni9E8B,  CJK UNIFIED IDEOGRAPH-9E8B
        0x9E8C, # G+7420  U+9E8C  uni9E8C,  CJK UNIFIED IDEOGRAPH-9E8C
        0x9E92, # G+7421  U+9E92  uni9E92,  CJK UNIFIED IDEOGRAPH-9E92
        0x9E95, # G+7422  U+9E95  uni9E95,  CJK UNIFIED IDEOGRAPH-9E95
        0x9E91, # G+7423  U+9E91  uni9E91,  CJK UNIFIED IDEOGRAPH-9E91
        0x9E9D, # G+7424  U+9E9D  uni9E9D,  CJK UNIFIED IDEOGRAPH-9E9D
        0x2FC6, # G+7425  U+2FC6  uni2FC6,  KANGXI RADICAL WHEAT
        0x9EA9, # G+7426  U+9EA9  uni9EA9,  CJK UNIFIED IDEOGRAPH-9EA9
        0x9EB8, # G+7427  U+9EB8  uni9EB8,  CJK UNIFIED IDEOGRAPH-9EB8
        0x9EAA, # G+7428  U+9EAA  uni9EAA,  CJK UNIFIED IDEOGRAPH-9EAA
        0x9EAD, # G+7429  U+9EAD  uni9EAD,  CJK UNIFIED IDEOGRAPH-9EAD
        0x9761, # G+7430  U+9761  uni9761,  CJK UNIFIED IDEOGRAPH-9761
        0x9ECC, # G+7431  U+9ECC  uni9ECC,  CJK UNIFIED IDEOGRAPH-9ECC
        0x9ECE, # G+7432  U+9ECE  uni9ECE,  CJK UNIFIED IDEOGRAPH-9ECE
        0x9ECF, # G+7433  U+9ECF  uni9ECF,  CJK UNIFIED IDEOGRAPH-9ECF
        0x9ED0, # G+7434  U+9ED0  uni9ED0,  CJK UNIFIED IDEOGRAPH-9ED0
        0x9ED4, # G+7435  U+9ED4  uni9ED4,  CJK UNIFIED IDEOGRAPH-9ED4
        0x9EDC, # G+7436  U+9EDC  uni9EDC,  CJK UNIFIED IDEOGRAPH-9EDC
        0x9EDE, # G+7437  U+9EDE  uni9EDE,  CJK UNIFIED IDEOGRAPH-9EDE
        0x9EDD, # G+7438  U+9EDD  uni9EDD,  CJK UNIFIED IDEOGRAPH-9EDD
        0x9EE0, # G+7439  U+9EE0  uni9EE0,  CJK UNIFIED IDEOGRAPH-9EE0
        0x9EE5, # G+7440  U+9EE5  uni9EE5,  CJK UNIFIED IDEOGRAPH-9EE5
        0x9EE8, # G+7441  U+9EE8  uni9EE8,  CJK UNIFIED IDEOGRAPH-9EE8
        0x9EEF, # G+7442  U+9EEF  uni9EEF,  CJK UNIFIED IDEOGRAPH-9EEF
        0x9EF4, # G+7443  U+9EF4  uni9EF4,  CJK UNIFIED IDEOGRAPH-9EF4
        0x9EF6, # G+7444  U+9EF6  uni9EF6,  CJK UNIFIED IDEOGRAPH-9EF6
        0x9EF7, # G+7445  U+9EF7  uni9EF7,  CJK UNIFIED IDEOGRAPH-9EF7
        0x2FCB, # G+7446  U+2FCB  uni2FCB,  KANGXI RADICAL EMBROIDERY
        0x9EFB, # G+7447  U+9EFB  uni9EFB,  CJK UNIFIED IDEOGRAPH-9EFB
        0x9EFC, # G+7448  U+9EFC  uni9EFC,  CJK UNIFIED IDEOGRAPH-9EFC
        0x2FCC, # G+7449  U+2FCC  uni2FCC,  KANGXI RADICAL FROG
        0x9F07, # G+7450  U+9F07  uni9F07,  CJK UNIFIED IDEOGRAPH-9F07
        0x9F08, # G+7451  U+9F08  uni9F08,  CJK UNIFIED IDEOGRAPH-9F08
        0x76B7, # G+7452  U+76B7  uni76B7,  CJK UNIFIED IDEOGRAPH-76B7
        0x9F15, # G+7453  U+9F15  uni9F15,  CJK UNIFIED IDEOGRAPH-9F15
        0x9F21, # G+7454  U+9F21  uni9F21,  CJK UNIFIED IDEOGRAPH-9F21
        0x9F2C, # G+7455  U+9F2C  uni9F2C,  CJK UNIFIED IDEOGRAPH-9F2C
        0x9F3E, # G+7456  U+9F3E  uni9F3E,  CJK UNIFIED IDEOGRAPH-9F3E
        0x2FD1, # G+7457  U+2FD1  uni2FD1,  KANGXI RADICAL EVEN
        0x2FD2, # G+7458  U+2FD2  uni2FD2,  KANGXI RADICAL TOOTH
        0x9F54, # G+7459  U+9F54  uni9F54,  CJK UNIFIED IDEOGRAPH-9F54
        0x9F63, # G+7460  U+9F63  uni9F63,  CJK UNIFIED IDEOGRAPH-9F63
        0x9F5F, # G+7461  U+9F5F  uni9F5F,  CJK UNIFIED IDEOGRAPH-9F5F
        0x9F60, # G+7462  U+9F60  uni9F60,  CJK UNIFIED IDEOGRAPH-9F60
        0x9F61, # G+7463  U+9F61  uni9F61,  CJK UNIFIED IDEOGRAPH-9F61
        0x9F66, # G+7464  U+9F66  uni9F66,  CJK UNIFIED IDEOGRAPH-9F66
        0x9F67, # G+7465  U+9F67  uni9F67,  CJK UNIFIED IDEOGRAPH-9F67
        0x9F6C, # G+7466  U+9F6C  uni9F6C,  CJK UNIFIED IDEOGRAPH-9F6C
        0x9F6A, # G+7467  U+9F6A  uni9F6A,  CJK UNIFIED IDEOGRAPH-9F6A
        0x9F77, # G+7468  U+9F77  uni9F77,  CJK UNIFIED IDEOGRAPH-9F77
        0x9F72, # G+7469  U+9F72  uni9F72,  CJK UNIFIED IDEOGRAPH-9F72
        0x9F76, # G+7470  U+9F76  uni9F76,  CJK UNIFIED IDEOGRAPH-9F76
        0x9F95, # G+7471  U+9F95  uni9F95,  CJK UNIFIED IDEOGRAPH-9F95
        0x2FD4, # G+7472  U+2FD4  uni2FD4,  KANGXI RADICAL TURTLE
        0x2FD5, # G+7473  U+2FD5  uni2FD5,  KANGXI RADICAL FLUTE
        0x582F, # G+7474  U+582F  uni582F,  CJK UNIFIED IDEOGRAPH-582F
        0x69C7, # G+7475  U+69C7  uni69C7,  CJK UNIFIED IDEOGRAPH-69C7
        0x9059, # G+7476  U+9059  uni9059,  CJK UNIFIED IDEOGRAPH-9059
        0x7464, # G+7477  U+7464  uni7464,  CJK UNIFIED IDEOGRAPH-7464
        0x0000, # G+7478  U+0000  .notdef,  UNDEFINED
        0x2500, # G+7479  U+2500  SF100000,  BOX DRAWINGS LIGHT HORIZONTAL
        0x2501, # G+7480  U+2501  uni2501,  BOX DRAWINGS HEAVY HORIZONTAL
        0x2502, # G+7481  U+2502  SF110000,  BOX DRAWINGS LIGHT VERTICAL
        0x2503, # G+7482  U+2503  uni2503,  BOX DRAWINGS HEAVY VERTICAL
        0x2504, # G+7483  U+2504  uni2504,  BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL
        0x2505, # G+7484  U+2505  uni2505,  BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL
        0x2506, # G+7485  U+2506  uni2506,  BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL
        0x2507, # G+7486  U+2507  uni2507,  BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL
        0x2508, # G+7487  U+2508  uni2508,  BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL
        0x2509, # G+7488  U+2509  uni2509,  BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL
        0x250A, # G+7489  U+250A  uni250A,  BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL
        0x250B, # G+7490  U+250B  uni250B,  BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL
        0x250C, # G+7491  U+250C  SF010000,  BOX DRAWINGS LIGHT DOWN AND RIGHT
        0x250D, # G+7492  U+250D  uni250D,  BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
        0x250E, # G+7493  U+250E  uni250E,  BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
        0x250F, # G+7494  U+250F  uni250F,  BOX DRAWINGS HEAVY DOWN AND RIGHT
        0x2510, # G+7495  U+2510  SF030000,  BOX DRAWINGS LIGHT DOWN AND LEFT
        0x2511, # G+7496  U+2511  uni2511,  BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
        0x2512, # G+7497  U+2512  uni2512,  BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
        0x2513, # G+7498  U+2513  uni2513,  BOX DRAWINGS HEAVY DOWN AND LEFT
        0x2514, # G+7499  U+2514  SF020000,  BOX DRAWINGS LIGHT UP AND RIGHT
        0x2515, # G+7500  U+2515  uni2515,  BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
        0x2516, # G+7501  U+2516  uni2516,  BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
        0x2517, # G+7502  U+2517  uni2517,  BOX DRAWINGS HEAVY UP AND RIGHT
        0x2518, # G+7503  U+2518  SF040000,  BOX DRAWINGS LIGHT UP AND LEFT
        0x2519, # G+7504  U+2519  uni2519,  BOX DRAWINGS UP LIGHT AND LEFT HEAVY
        0x251A, # G+7505  U+251A  uni251A,  BOX DRAWINGS UP HEAVY AND LEFT LIGHT
        0x251B, # G+7506  U+251B  uni251B,  BOX DRAWINGS HEAVY UP AND LEFT
        0x251C, # G+7507  U+251C  SF080000,  BOX DRAWINGS LIGHT VERTICAL AND RIGHT
        0x251D, # G+7508  U+251D  uni251D,  BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
        0x251E, # G+7509  U+251E  uni251E,  BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
        0x251F, # G+7510  U+251F  uni251F,  BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
        0x2520, # G+7511  U+2520  uni2520,  BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
        0x2521, # G+7512  U+2521  uni2521,  BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
        0x2522, # G+7513  U+2522  uni2522,  BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
        0x2523, # G+7514  U+2523  uni2523,  BOX DRAWINGS HEAVY VERTICAL AND RIGHT
        0x2524, # G+7515  U+2524  SF090000,  BOX DRAWINGS LIGHT VERTICAL AND LEFT
        0x2525, # G+7516  U+2525  uni2525,  BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
        0x2526, # G+7517  U+2526  uni2526,  BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
        0x2527, # G+7518  U+2527  uni2527,  BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
        0x2528, # G+7519  U+2528  uni2528,  BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
        0x2529, # G+7520  U+2529  uni2529,  BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
        0x252A, # G+7521  U+252A  uni252A,  BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
        0x252B, # G+7522  U+252B  uni252B,  BOX DRAWINGS HEAVY VERTICAL AND LEFT
        0x252C, # G+7523  U+252C  SF060000,  BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
        0x252D, # G+7524  U+252D  uni252D,  BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
        0x252E, # G+7525  U+252E  uni252E,  BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
        0x252F, # G+7526  U+252F  uni252F,  BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
        0x2530, # G+7527  U+2530  uni2530,  BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
        0x2531, # G+7528  U+2531  uni2531,  BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
        0x2532, # G+7529  U+2532  uni2532,  BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
        0x2533, # G+7530  U+2533  uni2533,  BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
        0x2534, # G+7531  U+2534  SF070000,  BOX DRAWINGS LIGHT UP AND HORIZONTAL
        0x2535, # G+7532  U+2535  uni2535,  BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
        0x2536, # G+7533  U+2536  uni2536,  BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
        0x2537, # G+7534  U+2537  uni2537,  BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
        0x2538, # G+7535  U+2538  uni2538,  BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
        0x2539, # G+7536  U+2539  uni2539,  BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
        0x253A, # G+7537  U+253A  uni253A,  BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
        0x253B, # G+7538  U+253B  uni253B,  BOX DRAWINGS HEAVY UP AND HORIZONTAL
        0x253C, # G+7539  U+253C  SF050000,  BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
        0x253D, # G+7540  U+253D  uni253D,  BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
        0x253E, # G+7541  U+253E  uni253E,  BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
        0x253F, # G+7542  U+253F  uni253F,  BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
        0x2540, # G+7543  U+2540  uni2540,  BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
        0x2541, # G+7544  U+2541  uni2541,  BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
        0x2542, # G+7545  U+2542  uni2542,  BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
        0x2543, # G+7546  U+2543  uni2543,  BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
        0x2544, # G+7547  U+2544  uni2544,  BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
        0x2545, # G+7548  U+2545  uni2545,  BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
        0x2546, # G+7549  U+2546  uni2546,  BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
        0x2547, # G+7550  U+2547  uni2547,  BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
        0x2548, # G+7551  U+2548  uni2548,  BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
        0x2549, # G+7552  U+2549  uni2549,  BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
        0x254A, # G+7553  U+254A  uni254A,  BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
        0x254B, # G+7554  U+254B  uni254B,  BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
        0x2460, # G+7555  U+2460  a120,  CIRCLED DIGIT ONE
        0x2461, # G+7556  U+2461  a121,  CIRCLED DIGIT TWO
        0x2462, # G+7557  U+2462  a122,  CIRCLED DIGIT THREE
        0x2463, # G+7558  U+2463  a123,  CIRCLED DIGIT FOUR
        0x2464, # G+7559  U+2464  a124,  CIRCLED DIGIT FIVE
        0x2465, # G+7560  U+2465  a125,  CIRCLED DIGIT SIX
        0x2466, # G+7561  U+2466  a126,  CIRCLED DIGIT SEVEN
        0x2467, # G+7562  U+2467  a127,  CIRCLED DIGIT EIGHT
        0x2468, # G+7563  U+2468  a128,  CIRCLED DIGIT NINE
        0x2469, # G+7564  U+2469  a129,  CIRCLED NUMBER TEN
        0x246A, # G+7565  U+246A  uni246A,  CIRCLED NUMBER ELEVEN
        0x246B, # G+7566  U+246B  uni246B,  CIRCLED NUMBER TWELVE
        0x246C, # G+7567  U+246C  uni246C,  CIRCLED NUMBER THIRTEEN
        0x246D, # G+7568  U+246D  uni246D,  CIRCLED NUMBER FOURTEEN
        0x246E, # G+7569  U+246E  uni246E,  CIRCLED NUMBER FIFTEEN
        0x246F, # G+7570  U+246F  uni246F,  CIRCLED NUMBER SIXTEEN
        0x2470, # G+7571  U+2470  uni2470,  CIRCLED NUMBER SEVENTEEN
        0x2471, # G+7572  U+2471  uni2471,  CIRCLED NUMBER EIGHTEEN
        0x2472, # G+7573  U+2472  uni2472,  CIRCLED NUMBER NINETEEN
        0x2473, # G+7574  U+2473  uni2473,  CIRCLED NUMBER TWENTY
        0x2160, # G+7575  U+2160  uni2160,  ROMAN NUMERAL ONE
        0x2161, # G+7576  U+2161  uni2161,  ROMAN NUMERAL TWO
        0x2162, # G+7577  U+2162  uni2162,  ROMAN NUMERAL THREE
        0x2163, # G+7578  U+2163  uni2163,  ROMAN NUMERAL FOUR
        0x2164, # G+7579  U+2164  uni2164,  ROMAN NUMERAL FIVE
        0x2165, # G+7580  U+2165  uni2165,  ROMAN NUMERAL SIX
        0x2166, # G+7581  U+2166  uni2166,  ROMAN NUMERAL SEVEN
        0x2167, # G+7582  U+2167  uni2167,  ROMAN NUMERAL EIGHT
        0x2168, # G+7583  U+2168  uni2168,  ROMAN NUMERAL NINE
        0x2169, # G+7584  U+2169  uni2169,  ROMAN NUMERAL TEN
        0x3349, # G+7585  U+3349  uni3349,  SQUARE MIRI
        0x3314, # G+7586  U+3314  uni3314,  SQUARE KIRO
        0x0000, # G+7587  U+0000  .notdef,  UNDEFINED
        0x334D, # G+7588  U+334D  uni334D,  SQUARE MEETORU
        0x0000, # G+7589  U+0000  .notdef,  UNDEFINED
        0x3327, # G+7590  U+3327  uni3327,  SQUARE TON
        0x0000, # G+7591  U+0000  .notdef,  UNDEFINED
        0x3336, # G+7592  U+3336  uni3336,  SQUARE HEKUTAARU
        0x3351, # G+7593  U+3351  uni3351,  SQUARE RITTORU
        0x0000, # G+7594  U+0000  .notdef,  UNDEFINED
        0x330D, # G+7595  U+330D  uni330D,  SQUARE KARORII
        0x3326, # G+7596  U+3326  uni3326,  SQUARE DORU
        0x0000, # G+7597  U+0000  .notdef,  UNDEFINED
        0x332B, # G+7598  U+332B  uni332B,  SQUARE PAASENTO
        0x334A, # G+7599  U+334A  uni334A,  SQUARE MIRIBAARU
        0x0000, # G+7600  U+0000  .notdef,  UNDEFINED
        0x339C, # G+7601  U+339C  uni339C,  SQUARE MM
        0x339D, # G+7602  U+339D  uni339D,  SQUARE CM
        0x339E, # G+7603  U+339E  uni339E,  SQUARE KM
        0x338E, # G+7604  U+338E  uni338E,  SQUARE MG
        0x338F, # G+7605  U+338F  uni338F,  SQUARE KG
        0x33C4, # G+7606  U+33C4  uni33C4,  SQUARE CC
        0x33A1, # G+7607  U+33A1  uni33A1,  SQUARE M SQUARED
        0x301D, # G+7608  U+301D  uni301D,  REVERSED DOUBLE PRIME QUOTATION MARK
        0x301F, # G+7609  U+301F  uni301F,  LOW DOUBLE PRIME QUOTATION MARK
        0x2116, # G+7610  U+2116  afii61352,  NUMERO SIGN
        0x33CD, # G+7611  U+33CD  uni33CD,  SQUARE KK
        0x0000, # G+7612  U+0000  .notdef,  UNDEFINED
        0x32A4, # G+7613  U+32A4  uni32A4,  CIRCLED IDEOGRAPH HIGH
        0x32A5, # G+7614  U+32A5  uni32A5,  CIRCLED IDEOGRAPH CENTRE
        0x32A6, # G+7615  U+32A6  uni32A6,  CIRCLED IDEOGRAPH LOW
        0x32A7, # G+7616  U+32A7  uni32A7,  CIRCLED IDEOGRAPH LEFT
        0x32A8, # G+7617  U+32A8  uni32A8,  CIRCLED IDEOGRAPH RIGHT
        0x3231, # G+7618  U+3231  uni3231,  PARENTHESIZED IDEOGRAPH STOCK
        0x3232, # G+7619  U+3232  uni3232,  PARENTHESIZED IDEOGRAPH HAVE
        0x3239, # G+7620  U+3239  uni3239,  PARENTHESIZED IDEOGRAPH REPRESENT
        0x337E, # G+7621  U+337E  uni337E,  SQUARE ERA NAME MEIZI
        0x337D, # G+7622  U+337D  uni337D,  SQUARE ERA NAME TAISYOU
        0x337C, # G+7623  U+337C  uni337C,  SQUARE ERA NAME SYOUWA
        0x222E, # G+7624  U+222E  uni222E,  CONTOUR INTEGRAL
        0x2211, # G+7625  U+2211  summation,  N-ARY SUMMATION
        0x0000, # G+7626  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7627  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7628  U+0000  .notdef,  UNDEFINED
        0x221F, # G+7629  U+221F  orthogonal,  RIGHT ANGLE
        0x22BF, # G+7630  U+22BF  uni22BF,  RIGHT TRIANGLE
        0x0000, # G+7631  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7632  U+0000  .notdef,  UNDEFINED
        0x555E, # G+7633  U+555E  uni555E,  CJK UNIFIED IDEOGRAPH-555E
        0x0000, # G+7634  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7635  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7636  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7637  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7638  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7639  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7640  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7641  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7642  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7643  U+0000  .notdef,  UNDEFINED
        0x7130, # G+7644  U+7130  uni7130,  CJK UNIFIED IDEOGRAPH-7130
        0x0000, # G+7645  U+0000  .notdef,  UNDEFINED
        0x9DD7, # G+7646  U+9DD7  uni9DD7,  CJK UNIFIED IDEOGRAPH-9DD7
        0x0000, # G+7647  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7648  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7649  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7650  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7651  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7652  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7653  U+0000  .notdef,  UNDEFINED
        0x5699, # G+7654  U+5699  uni5699,  CJK UNIFIED IDEOGRAPH-5699
        0x0000, # G+7655  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7656  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7657  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7658  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7659  U+0000  .notdef,  UNDEFINED
        0x4FE0, # G+7660  U+4FE0  uni4FE0,  CJK UNIFIED IDEOGRAPH-4FE0
        0x0000, # G+7661  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7662  U+0000  .notdef,  UNDEFINED
        0x8EC0, # G+7663  U+8EC0  uni8EC0,  CJK UNIFIED IDEOGRAPH-8EC0
        0x0000, # G+7664  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7665  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7666  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7667  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7668  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7669  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7670  U+0000  .notdef,  UNDEFINED
        0x7E6B, # G+7671  U+7E6B  uni7E6B,  CJK UNIFIED IDEOGRAPH-7E6B
        0x0000, # G+7672  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7673  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7674  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7675  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7676  U+0000  .notdef,  UNDEFINED
        0x9E7C, # G+7677  U+9E7C  uni9E7C,  CJK UNIFIED IDEOGRAPH-9E7C
        0x0000, # G+7678  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7679  U+0000  .notdef,  UNDEFINED
        0x663B, # G+7680  U+663B  uni663B,  CJK UNIFIED IDEOGRAPH-663B
        0x0000, # G+7681  U+0000  .notdef,  UNDEFINED
        0x9EB4, # G+7682  U+9EB4  uni9EB4,  CJK UNIFIED IDEOGRAPH-9EB4
        0x0000, # G+7683  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7684  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7685  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7686  U+0000  .notdef,  UNDEFINED
        0x6805, # G+7687  U+6805  uni6805,  CJK UNIFIED IDEOGRAPH-6805
        0x0000, # G+7688  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7689  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7690  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7691  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7692  U+0000  .notdef,  UNDEFINED
        0x5C62, # G+7693  U+5C62  uni5C62,  CJK UNIFIED IDEOGRAPH-5C62
        0x0000, # G+7694  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7695  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7696  U+0000  .notdef,  UNDEFINED
        0x7E61, # G+7697  U+7E61  uni7E61,  CJK UNIFIED IDEOGRAPH-7E61
        0x0000, # G+7698  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7699  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7700  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7701  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7702  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7703  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7704  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7705  U+0000  .notdef,  UNDEFINED
        0x8523, # G+7706  U+8523  uni8523,  CJK UNIFIED IDEOGRAPH-8523
        0x91AC, # G+7707  U+91AC  uni91AC,  CJK UNIFIED IDEOGRAPH-91AC
        0x0000, # G+7708  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7709  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7710  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7711  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7712  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7713  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7714  U+0000  .notdef,  UNDEFINED
        0x87EC, # G+7715  U+87EC  uni87EC,  CJK UNIFIED IDEOGRAPH-87EC
        0x0000, # G+7716  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7717  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7718  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7719  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7720  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7721  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7722  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7723  U+0000  .notdef,  UNDEFINED
        0x6414, # G+7724  U+6414  uni6414,  CJK UNIFIED IDEOGRAPH-6414
        0x7626, # G+7725  U+7626  uni7626,  CJK UNIFIED IDEOGRAPH-7626
        0x0000, # G+7726  U+0000  .notdef,  UNDEFINED
        0x9A52, # G+7727  U+9A52  uni9A52,  CJK UNIFIED IDEOGRAPH-9A52
        0x0000, # G+7728  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7729  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7730  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7731  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7732  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7733  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7734  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7735  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7736  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7737  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7738  U+0000  .notdef,  UNDEFINED
        0x7C1E, # G+7739  U+7C1E  uni7C1E,  CJK UNIFIED IDEOGRAPH-7C1E
        0x0000, # G+7740  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7741  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7742  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7743  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7744  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7745  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7746  U+0000  .notdef,  UNDEFINED
        0x6451, # G+7747  U+6451  uni6451,  CJK UNIFIED IDEOGRAPH-6451
        0x0000, # G+7748  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7749  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7750  U+0000  .notdef,  UNDEFINED
        0x5861, # G+7751  U+5861  uni5861,  CJK UNIFIED IDEOGRAPH-5861
        0x985A, # G+7752  U+985A  uni985A,  CJK UNIFIED IDEOGRAPH-985A
        0x0000, # G+7753  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7754  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7755  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7756  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7757  U+0000  .notdef,  UNDEFINED
        0x79B1, # G+7758  U+79B1  uni79B1,  CJK UNIFIED IDEOGRAPH-79B1
        0x0000, # G+7759  U+0000  .notdef,  UNDEFINED
        0x7006, # G+7760  U+7006  uni7006,  CJK UNIFIED IDEOGRAPH-7006
        0x0000, # G+7761  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7762  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7763  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7764  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7765  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7766  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7767  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7768  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7769  U+0000  .notdef,  UNDEFINED
        0x56CA, # G+7770  U+56CA  uni56CA,  CJK UNIFIED IDEOGRAPH-56CA
        0x0000, # G+7771  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7772  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7773  U+0000  .notdef,  UNDEFINED
        0x525D, # G+7774  U+525D  uni525D,  CJK UNIFIED IDEOGRAPH-525D
        0x0000, # G+7775  U+0000  .notdef,  UNDEFINED
        0x6F51, # G+7776  U+6F51  uni6F51,  CJK UNIFIED IDEOGRAPH-6F51
        0x91B1, # G+7777  U+91B1  uni91B1,  CJK UNIFIED IDEOGRAPH-91B1
        0x0000, # G+7778  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7779  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7780  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7781  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7782  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7783  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7784  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7785  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7786  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7787  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7788  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7789  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7790  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7791  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7792  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7793  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7794  U+0000  .notdef,  UNDEFINED
        0x9830, # G+7795  U+9830  uni9830,  CJK UNIFIED IDEOGRAPH-9830
        0x0000, # G+7796  U+0000  .notdef,  UNDEFINED
        0x9EB5, # G+7797  U+9EB5  uni9EB5,  CJK UNIFIED IDEOGRAPH-9EB5
        0x0000, # G+7798  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7799  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7800  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7801  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7802  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7803  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7804  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7805  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7806  U+0000  .notdef,  UNDEFINED
        0x840A, # G+7807  U+840A  uni840A,  CJK UNIFIED IDEOGRAPH-840A
        0x0000, # G+7808  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7809  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7810  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7811  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7812  U+0000  .notdef,  UNDEFINED
        0x881F, # G+7813  U+881F  uni881F,  CJK UNIFIED IDEOGRAPH-881F
        0x0000, # G+7814  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7815  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7816  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7817  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7818  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7819  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7820  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7821  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7822  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7823  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7824  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7825  U+0000  .notdef,  UNDEFINED
        0x5C5B, # G+7826  U+5C5B  uni5C5B,  CJK UNIFIED IDEOGRAPH-5C5B
        0x0000, # G+7827  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7828  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7829  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7830  U+0000  .notdef,  UNDEFINED
        0x6522, # G+7831  U+6522  uni6522,  CJK UNIFIED IDEOGRAPH-6522
        0x0000, # G+7832  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7833  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7834  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7835  U+0000  .notdef,  UNDEFINED
        0x688E, # G+7836  U+688E  uni688E,  CJK UNIFIED IDEOGRAPH-688E
        0x0000, # G+7837  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7838  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7839  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7840  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7841  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7842  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7843  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7844  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7845  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7846  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7847  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7848  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7849  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7850  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7851  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7852  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7853  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7854  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7855  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7856  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7857  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7858  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7859  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7860  U+0000  .notdef,  UNDEFINED
        0x853E, # G+7861  U+853E  uni853E,  CJK UNIFIED IDEOGRAPH-853E
        0x0000, # G+7862  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7863  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7864  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7865  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7866  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7867  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7868  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7869  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7870  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7871  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7872  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7873  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7874  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7875  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7876  U+0000  .notdef,  UNDEFINED
        0x7762, # G+7877  U+7762  uni7762,  CJK UNIFIED IDEOGRAPH-7762
        0x0000, # G+7878  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7879  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7880  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7881  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7882  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7883  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7884  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7885  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7886  U+0000  .notdef,  UNDEFINED
        0x3001, # G+7887  U+3001  uni3001,  IDEOGRAPHIC COMMA
        0x3002, # G+7888  U+3002  uni3002,  IDEOGRAPHIC FULL STOP
        0xFFE3, # G+7889  U+FFE3  uniFFE3,  FULLWIDTH MACRON
        0xFE33, # G+7890  U+FE33  uniFE33,  PRESENTATION FORM FOR VERTICAL LOW LINE
        0x30FC, # G+7891  U+30FC  uni30FC,  KATAKANA-HIRAGANA PROLONGED SOUND MARK
        0xFE31, # G+7892  U+FE31  uniFE31,  PRESENTATION FORM FOR VERTICAL EM DASH
        0xFE32, # G+7893  U+FE32  uniFE32,  PRESENTATION FORM FOR VERTICAL EN DASH
        0x223C, # G+7894  U+223C  similar,  TILDE OPERATOR
        0x2016, # G+7895  U+2016  uni2016,  DOUBLE VERTICAL LINE
        0xFF5C, # G+7896  U+FF5C  uniFF5C,  FULLWIDTH VERTICAL LINE
        0x22EE, # G+7897  U+22EE  uni22EE,  VERTICAL ELLIPSIS
        0xFE30, # G+7898  U+FE30  uniFE30,  PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
        0xFE35, # G+7899  U+FE35  uniFE35,  PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
        0xFE36, # G+7900  U+FE36  uniFE36,  PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
        0xFE39, # G+7901  U+FE39  uniFE39,  PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
        0xFE3A, # G+7902  U+FE3A  uniFE3A,  PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
        0xFF3B, # G+7903  U+FF3B  uniFF3B,  FULLWIDTH LEFT SQUARE BRACKET
        0xFF3D, # G+7904  U+FF3D  uniFF3D,  FULLWIDTH RIGHT SQUARE BRACKET
        0xFE37, # G+7905  U+FE37  uniFE37,  PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
        0xFE38, # G+7906  U+FE38  uniFE38,  PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
        0xFE3F, # G+7907  U+FE3F  uniFE3F,  PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
        0xFE40, # G+7908  U+FE40  uniFE40,  PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
        0xFE3D, # G+7909  U+FE3D  uniFE3D,  PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
        0xFE3E, # G+7910  U+FE3E  uniFE3E,  PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
        0xFE41, # G+7911  U+FE41  uniFE41,  PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
        0xFE42, # G+7912  U+FE42  uniFE42,  PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
        0xFE43, # G+7913  U+FE43  uniFE43,  PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
        0xFE44, # G+7914  U+FE44  uniFE44,  PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
        0xFE3B, # G+7915  U+FE3B  uniFE3B,  PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
        0xFE3C, # G+7916  U+FE3C  uniFE3C,  PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
        0xFF1D, # G+7917  U+FF1D  uniFF1D,  FULLWIDTH EQUALS SIGN
        0x3041, # G+7918  U+3041  uni3041,  HIRAGANA LETTER SMALL A
        0x3043, # G+7919  U+3043  uni3043,  HIRAGANA LETTER SMALL I
        0x3045, # G+7920  U+3045  uni3045,  HIRAGANA LETTER SMALL U
        0x3047, # G+7921  U+3047  uni3047,  HIRAGANA LETTER SMALL E
        0x3049, # G+7922  U+3049  uni3049,  HIRAGANA LETTER SMALL O
        0x3063, # G+7923  U+3063  uni3063,  HIRAGANA LETTER SMALL TU
        0x3083, # G+7924  U+3083  uni3083,  HIRAGANA LETTER SMALL YA
        0x3085, # G+7925  U+3085  uni3085,  HIRAGANA LETTER SMALL YU
        0x3087, # G+7926  U+3087  uni3087,  HIRAGANA LETTER SMALL YO
        0x308E, # G+7927  U+308E  uni308E,  HIRAGANA LETTER SMALL WA
        0x30A1, # G+7928  U+30A1  uni30A1,  KATAKANA LETTER SMALL A
        0x30A3, # G+7929  U+30A3  uni30A3,  KATAKANA LETTER SMALL I
        0x30A5, # G+7930  U+30A5  uni30A5,  KATAKANA LETTER SMALL U
        0x30A7, # G+7931  U+30A7  uni30A7,  KATAKANA LETTER SMALL E
        0x30A9, # G+7932  U+30A9  uni30A9,  KATAKANA LETTER SMALL O
        0x30C3, # G+7933  U+30C3  uni30C3,  KATAKANA LETTER SMALL TU
        0x30E3, # G+7934  U+30E3  uni30E3,  KATAKANA LETTER SMALL YA
        0x30E5, # G+7935  U+30E5  uni30E5,  KATAKANA LETTER SMALL YU
        0x30E7, # G+7936  U+30E7  uni30E7,  KATAKANA LETTER SMALL YO
        0x30EE, # G+7937  U+30EE  uni30EE,  KATAKANA LETTER SMALL WA
        0x30F5, # G+7938  U+30F5  uni30F5,  KATAKANA LETTER SMALL KA
        0x30F6, # G+7939  U+30F6  uni30F6,  KATAKANA LETTER SMALL KE
        0x3349, # G+7940  U+3349  uni3349,  SQUARE MIRI
        0x3314, # G+7941  U+3314  uni3314,  SQUARE KIRO
        0x0000, # G+7942  U+0000  .notdef,  UNDEFINED
        0x334D, # G+7943  U+334D  uni334D,  SQUARE MEETORU
        0x0000, # G+7944  U+0000  .notdef,  UNDEFINED
        0x3327, # G+7945  U+3327  uni3327,  SQUARE TON
        0x0000, # G+7946  U+0000  .notdef,  UNDEFINED
        0x3336, # G+7947  U+3336  uni3336,  SQUARE HEKUTAARU
        0x3351, # G+7948  U+3351  uni3351,  SQUARE RITTORU
        0x0000, # G+7949  U+0000  .notdef,  UNDEFINED
        0x330D, # G+7950  U+330D  uni330D,  SQUARE KARORII
        0x3326, # G+7951  U+3326  uni3326,  SQUARE DORU
        0x0000, # G+7952  U+0000  .notdef,  UNDEFINED
        0x332B, # G+7953  U+332B  uni332B,  SQUARE PAASENTO
        0x334A, # G+7954  U+334A  uni334A,  SQUARE MIRIBAARU
        0x0000, # G+7955  U+0000  .notdef,  UNDEFINED
        0x301D, # G+7956  U+301D  uni301D,  REVERSED DOUBLE PRIME QUOTATION MARK
        0x301F, # G+7957  U+301F  uni301F,  LOW DOUBLE PRIME QUOTATION MARK
        0x3094, # G+7958  U+3094  uni3094,  HIRAGANA LETTER VU
        0x0000, # G+7959  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7960  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7961  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7962  U+0000  .notdef,  UNDEFINED
        0x5653, # G+7963  U+5653  uni5653,  CJK UNIFIED IDEOGRAPH-5653
        0x0000, # G+7964  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7965  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7966  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7967  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7968  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7969  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7970  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7971  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7972  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7973  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7974  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7975  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7976  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7977  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7978  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7979  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7980  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7981  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7982  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7983  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7984  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7985  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7986  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7987  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7988  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7989  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7990  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7991  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7992  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7993  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7994  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7995  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7996  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7997  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7998  U+0000  .notdef,  UNDEFINED
        0x0000, # G+7999  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8000  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8001  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8002  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8003  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8004  U+0000  .notdef,  UNDEFINED
        0xFFE4, # G+8005  U+FFE4  uniFFE4,  FULLWIDTH BROKEN BAR
        0xFF07, # G+8006  U+FF07  uniFF07,  FULLWIDTH APOSTROPHE
        0xFF02, # G+8007  U+FF02  uniFF02,  FULLWIDTH QUOTATION MARK
        0x0000, # G+8008  U+0000  .notdef,  UNDEFINED
        0x25C1, # G+8009  U+25C1  uni25C1,  WHITE LEFT-POINTING TRIANGLE
        0x25B7, # G+8010  U+25B7  uni25B7,  WHITE RIGHT-POINTING TRIANGLE
        0x21E9, # G+8011  U+21E9  uni21E9,  DOWNWARDS WHITE ARROW
        0x21E7, # G+8012  U+21E7  uni21E7,  UPWARDS WHITE ARROW
        0x21E6, # G+8013  U+21E6  uni21E6,  LEFTWARDS WHITE ARROW
        0x21E8, # G+8014  U+21E8  uni21E8,  RIGHTWARDS WHITE ARROW
        0x25A2, # G+8015  U+25A2  uni25A2,  WHITE SQUARE WITH ROUNDED CORNERS
        0x2667, # G+8016  U+2667  uni2667,  WHITE CLUB SUIT
        0x2661, # G+8017  U+2661  uni2661,  WHITE HEART SUIT
        0x2664, # G+8018  U+2664  uni2664,  WHITE SPADE SUIT
        0x2662, # G+8019  U+2662  uni2662,  WHITE DIAMOND SUIT
        0x33A0, # G+8020  U+33A0  uni33A0,  SQUARE CM SQUARED
        0x33A2, # G+8021  U+33A2  uni33A2,  SQUARE KM SQUARED
        0x33A4, # G+8022  U+33A4  uni33A4,  SQUARE CM CUBED
        0x33A5, # G+8023  U+33A5  uni33A5,  SQUARE M CUBED
        0x3397, # G+8024  U+3397  uni3397,  SQUARE DL
        0x2113, # G+8025  U+2113  afii61289,  SCRIPT SMALL L
        0x3398, # G+8026  U+3398  uni3398,  SQUARE KL
        0x33B3, # G+8027  U+33B3  uni33B3,  SQUARE MS
        0x33B2, # G+8028  U+33B2  uni33B2,  SQUARE MU S
        0x33B1, # G+8029  U+33B1  uni33B1,  SQUARE NS
        0x33B0, # G+8030  U+33B0  uni33B0,  SQUARE PS
        0x3385, # G+8031  U+3385  uni3385,  SQUARE KB
        0x3386, # G+8032  U+3386  uni3386,  SQUARE MB
        0x3387, # G+8033  U+3387  uni3387,  SQUARE GB
        0x33CB, # G+8034  U+33CB  uni33CB,  SQUARE HP
        0x3390, # G+8035  U+3390  uni3390,  SQUARE HZ
        0x33D4, # G+8036  U+33D4  uni33D4,  SQUARE MB SMALL
        0x3396, # G+8037  U+3396  uni3396,  SQUARE ML
        0x3322, # G+8038  U+3322  uni3322,  SQUARE SENTI
        0x3316, # G+8039  U+3316  uni3316,  SQUARE KIROMEETORU
        0x3318, # G+8040  U+3318  uni3318,  SQUARE GURAMU
        0x3315, # G+8041  U+3315  uni3315,  SQUARE KIROGURAMU
        0x3303, # G+8042  U+3303  uni3303,  SQUARE AARU
        0x3323, # G+8043  U+3323  uni3323,  SQUARE SENTO
        0x3357, # G+8044  U+3357  uni3357,  SQUARE WATTO
        0x3342, # G+8045  U+3342  uni3342,  SQUARE HOON
        0x3339, # G+8046  U+3339  uni3339,  SQUARE HERUTU
        0x333B, # G+8047  U+333B  uni333B,  SQUARE PEEZI
        0x3300, # G+8048  U+3300  uni3300,  SQUARE APAATO
        0x3331, # G+8049  U+3331  uni3331,  SQUARE BIRU
        0x3347, # G+8050  U+3347  uni3347,  SQUARE MANSYON
        0x331E, # G+8051  U+331E  uni331E,  SQUARE KOOPO
        0x332A, # G+8052  U+332A  uni332A,  SQUARE HAITU
        0x0000, # G+8053  U+0000  .notdef,  UNDEFINED
        0x337F, # G+8054  U+337F  uni337F,  SQUARE CORPORATION
        0x2121, # G+8055  U+2121  uni2121,  TELEPHONE SIGN
        0x260E, # G+8056  U+260E  a4,  BLACK TELEPHONE
        0x3036, # G+8057  U+3036  uni3036,  CIRCLED POSTAL MARK
        0x3020, # G+8058  U+3020  uni3020,  POSTAL MARK FACE
        0x0000, # G+8059  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8060  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8061  U+0000  .notdef,  UNDEFINED
        0x2488, # G+8062  U+2488  uni2488,  DIGIT ONE FULL STOP
        0x2489, # G+8063  U+2489  uni2489,  DIGIT TWO FULL STOP
        0x248A, # G+8064  U+248A  uni248A,  DIGIT THREE FULL STOP
        0x248B, # G+8065  U+248B  uni248B,  DIGIT FOUR FULL STOP
        0x248C, # G+8066  U+248C  uni248C,  DIGIT FIVE FULL STOP
        0x248D, # G+8067  U+248D  uni248D,  DIGIT SIX FULL STOP
        0x248E, # G+8068  U+248E  uni248E,  DIGIT SEVEN FULL STOP
        0x248F, # G+8069  U+248F  uni248F,  DIGIT EIGHT FULL STOP
        0x2490, # G+8070  U+2490  uni2490,  DIGIT NINE FULL STOP
        0x2474, # G+8071  U+2474  uni2474,  PARENTHESIZED DIGIT ONE
        0x2475, # G+8072  U+2475  uni2475,  PARENTHESIZED DIGIT TWO
        0x2476, # G+8073  U+2476  uni2476,  PARENTHESIZED DIGIT THREE
        0x2477, # G+8074  U+2477  uni2477,  PARENTHESIZED DIGIT FOUR
        0x2478, # G+8075  U+2478  uni2478,  PARENTHESIZED DIGIT FIVE
        0x2479, # G+8076  U+2479  uni2479,  PARENTHESIZED DIGIT SIX
        0x247A, # G+8077  U+247A  uni247A,  PARENTHESIZED DIGIT SEVEN
        0x247B, # G+8078  U+247B  uni247B,  PARENTHESIZED DIGIT EIGHT
        0x247C, # G+8079  U+247C  uni247C,  PARENTHESIZED DIGIT NINE
        0x247D, # G+8080  U+247D  uni247D,  PARENTHESIZED NUMBER TEN
        0x247E, # G+8081  U+247E  uni247E,  PARENTHESIZED NUMBER ELEVEN
        0x247F, # G+8082  U+247F  uni247F,  PARENTHESIZED NUMBER TWELVE
        0x2480, # G+8083  U+2480  uni2480,  PARENTHESIZED NUMBER THIRTEEN
        0x2481, # G+8084  U+2481  uni2481,  PARENTHESIZED NUMBER FOURTEEN
        0x2482, # G+8085  U+2482  uni2482,  PARENTHESIZED NUMBER FIFTEEN
        0x2483, # G+8086  U+2483  uni2483,  PARENTHESIZED NUMBER SIXTEEN
        0x2484, # G+8087  U+2484  uni2484,  PARENTHESIZED NUMBER SEVENTEEN
        0x2485, # G+8088  U+2485  uni2485,  PARENTHESIZED NUMBER EIGHTEEN
        0x2486, # G+8089  U+2486  uni2486,  PARENTHESIZED NUMBER NINETEEN
        0x2487, # G+8090  U+2487  uni2487,  PARENTHESIZED NUMBER TWENTY
        0x0000, # G+8091  U+0000  .notdef,  UNDEFINED
        0x2170, # G+8092  U+2170  uni2170,  SMALL ROMAN NUMERAL ONE
        0x2171, # G+8093  U+2171  uni2171,  SMALL ROMAN NUMERAL TWO
        0x2172, # G+8094  U+2172  uni2172,  SMALL ROMAN NUMERAL THREE
        0x2173, # G+8095  U+2173  uni2173,  SMALL ROMAN NUMERAL FOUR
        0x2174, # G+8096  U+2174  uni2174,  SMALL ROMAN NUMERAL FIVE
        0x2175, # G+8097  U+2175  uni2175,  SMALL ROMAN NUMERAL SIX
        0x2176, # G+8098  U+2176  uni2176,  SMALL ROMAN NUMERAL SEVEN
        0x2177, # G+8099  U+2177  uni2177,  SMALL ROMAN NUMERAL EIGHT
        0x2178, # G+8100  U+2178  uni2178,  SMALL ROMAN NUMERAL NINE
        0x2179, # G+8101  U+2179  uni2179,  SMALL ROMAN NUMERAL TEN
        0x0000, # G+8102  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8103  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8104  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8105  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8106  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8107  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8108  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8109  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8110  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8111  U+0000  .notdef,  UNDEFINED
        0x249C, # G+8112  U+249C  uni249C,  PARENTHESIZED LATIN SMALL LETTER A
        0x249D, # G+8113  U+249D  uni249D,  PARENTHESIZED LATIN SMALL LETTER B
        0x249E, # G+8114  U+249E  uni249E,  PARENTHESIZED LATIN SMALL LETTER C
        0x249F, # G+8115  U+249F  uni249F,  PARENTHESIZED LATIN SMALL LETTER D
        0x24A0, # G+8116  U+24A0  uni24A0,  PARENTHESIZED LATIN SMALL LETTER E
        0x24A1, # G+8117  U+24A1  uni24A1,  PARENTHESIZED LATIN SMALL LETTER F
        0x24A2, # G+8118  U+24A2  uni24A2,  PARENTHESIZED LATIN SMALL LETTER G
        0x24A3, # G+8119  U+24A3  uni24A3,  PARENTHESIZED LATIN SMALL LETTER H
        0x24A4, # G+8120  U+24A4  uni24A4,  PARENTHESIZED LATIN SMALL LETTER I
        0x24A5, # G+8121  U+24A5  uni24A5,  PARENTHESIZED LATIN SMALL LETTER J
        0x24A6, # G+8122  U+24A6  uni24A6,  PARENTHESIZED LATIN SMALL LETTER K
        0x24A7, # G+8123  U+24A7  uni24A7,  PARENTHESIZED LATIN SMALL LETTER L
        0x24A8, # G+8124  U+24A8  uni24A8,  PARENTHESIZED LATIN SMALL LETTER M
        0x24A9, # G+8125  U+24A9  uni24A9,  PARENTHESIZED LATIN SMALL LETTER N
        0x24AA, # G+8126  U+24AA  uni24AA,  PARENTHESIZED LATIN SMALL LETTER O
        0x24AB, # G+8127  U+24AB  uni24AB,  PARENTHESIZED LATIN SMALL LETTER P
        0x24AC, # G+8128  U+24AC  uni24AC,  PARENTHESIZED LATIN SMALL LETTER Q
        0x24AD, # G+8129  U+24AD  uni24AD,  PARENTHESIZED LATIN SMALL LETTER R
        0x24AE, # G+8130  U+24AE  uni24AE,  PARENTHESIZED LATIN SMALL LETTER S
        0x24AF, # G+8131  U+24AF  uni24AF,  PARENTHESIZED LATIN SMALL LETTER T
        0x24B0, # G+8132  U+24B0  uni24B0,  PARENTHESIZED LATIN SMALL LETTER U
        0x24B1, # G+8133  U+24B1  uni24B1,  PARENTHESIZED LATIN SMALL LETTER V
        0x24B2, # G+8134  U+24B2  uni24B2,  PARENTHESIZED LATIN SMALL LETTER W
        0x24B3, # G+8135  U+24B3  uni24B3,  PARENTHESIZED LATIN SMALL LETTER X
        0x24B4, # G+8136  U+24B4  uni24B4,  PARENTHESIZED LATIN SMALL LETTER Y
        0x24B5, # G+8137  U+24B5  uni24B5,  PARENTHESIZED LATIN SMALL LETTER Z
        0x3243, # G+8138  U+3243  uni3243,  PARENTHESIZED IDEOGRAPH REACH
        0x323D, # G+8139  U+323D  uni323D,  PARENTHESIZED IDEOGRAPH ENTERPRISE
        0x323F, # G+8140  U+323F  uni323F,  PARENTHESIZED IDEOGRAPH ALLIANCE
        0x3234, # G+8141  U+3234  uni3234,  PARENTHESIZED IDEOGRAPH NAME
        0x3238, # G+8142  U+3238  uni3238,  PARENTHESIZED IDEOGRAPH LABOR
        0x3233, # G+8143  U+3233  uni3233,  PARENTHESIZED IDEOGRAPH SOCIETY
        0x323C, # G+8144  U+323C  uni323C,  PARENTHESIZED IDEOGRAPH SUPERVISE
        0x3242, # G+8145  U+3242  uni3242,  PARENTHESIZED IDEOGRAPH SELF
        0x323E, # G+8146  U+323E  uni323E,  PARENTHESIZED IDEOGRAPH RESOURCE
        0x3236, # G+8147  U+3236  uni3236,  PARENTHESIZED IDEOGRAPH FINANCIAL
        0x3235, # G+8148  U+3235  uni3235,  PARENTHESIZED IDEOGRAPH SPECIAL
        0x323B, # G+8149  U+323B  uni323B,  PARENTHESIZED IDEOGRAPH STUDY
        0x3240, # G+8150  U+3240  uni3240,  PARENTHESIZED IDEOGRAPH FESTIVAL
        0x323A, # G+8151  U+323A  uni323A,  PARENTHESIZED IDEOGRAPH CALL
        0x32B0, # G+8152  U+32B0  uni32B0,  CIRCLED IDEOGRAPH NIGHT
        0x32AD, # G+8153  U+32AD  uni32AD,  CIRCLED IDEOGRAPH ENTERPRISE
        0x32A9, # G+8154  U+32A9  uni32A9,  CIRCLED IDEOGRAPH MEDICINE
        0x32AF, # G+8155  U+32AF  uni32AF,  CIRCLED IDEOGRAPH ALLIANCE
        0x3294, # G+8156  U+3294  uni3294,  CIRCLED IDEOGRAPH NAME
        0x32AA, # G+8157  U+32AA  uni32AA,  CIRCLED IDEOGRAPH RELIGION
        0x3298, # G+8158  U+3298  uni3298,  CIRCLED IDEOGRAPH LABOR
        0x32AB, # G+8159  U+32AB  uni32AB,  CIRCLED IDEOGRAPH STUDY
        0x3292, # G+8160  U+3292  uni3292,  CIRCLED IDEOGRAPH HAVE
        0x3291, # G+8161  U+3291  uni3291,  CIRCLED IDEOGRAPH STOCK
        0x3293, # G+8162  U+3293  uni3293,  CIRCLED IDEOGRAPH SOCIETY
        0x32AC, # G+8163  U+32AC  uni32AC,  CIRCLED IDEOGRAPH SUPERVISE
        0x32AE, # G+8164  U+32AE  uni32AE,  CIRCLED IDEOGRAPH RESOURCE
        0x3296, # G+8165  U+3296  uni3296,  CIRCLED IDEOGRAPH FINANCIAL
        0x0000, # G+8166  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8167  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8168  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8169  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8170  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8171  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8172  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8173  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8174  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8175  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8176  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8177  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8178  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8179  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8180  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8181  U+0000  .notdef,  UNDEFINED
        0x33CC, # G+8182  U+33CC  uni33CC,  SQUARE IN
        0x3305, # G+8183  U+3305  uni3305,  SQUARE INTI
        0x0000, # G+8184  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8185  U+0000  .notdef,  UNDEFINED
        0x339F, # G+8186  U+339F  uni339F,  SQUARE MM SQUARED
        0x33A3, # G+8187  U+33A3  uni33A3,  SQUARE MM CUBED
        0x33A6, # G+8188  U+33A6  uni33A6,  SQUARE KM CUBED
        0x0000, # G+8189  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8190  U+0000  .notdef,  UNDEFINED
        0x329E, # G+8191  U+329E  uni329E,  CIRCLED IDEOGRAPH PRINT
        0x3388, # G+8192  U+3388  uni3388,  SQUARE CAL
        0x3389, # G+8193  U+3389  uni3389,  SQUARE KCAL
        0x33C8, # G+8194  U+33C8  uni33C8,  SQUARE DB
        0x222D, # G+8195  U+222D  uni222D,  TRIPLE INTEGRAL
        0x0000, # G+8196  U+0000  .notdef,  UNDEFINED
        0x3230, # G+8197  U+3230  uni3230,  PARENTHESIZED IDEOGRAPH SUN
        0x322A, # G+8198  U+322A  uni322A,  PARENTHESIZED IDEOGRAPH MOON
        0x322B, # G+8199  U+322B  uni322B,  PARENTHESIZED IDEOGRAPH FIRE
        0x322C, # G+8200  U+322C  uni322C,  PARENTHESIZED IDEOGRAPH WATER
        0x322D, # G+8201  U+322D  uni322D,  PARENTHESIZED IDEOGRAPH WOOD
        0x322E, # G+8202  U+322E  uni322E,  PARENTHESIZED IDEOGRAPH METAL
        0x322F, # G+8203  U+322F  uni322F,  PARENTHESIZED IDEOGRAPH EARTH
        0x3237, # G+8204  U+3237  uni3237,  PARENTHESIZED IDEOGRAPH CONGRATULATION
        0x3241, # G+8205  U+3241  uni3241,  PARENTHESIZED IDEOGRAPH REST
        0x27A1, # G+8206  U+27A1  a172,  BLACK RIGHTWARDS ARROW
        0x0000, # G+8207  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8208  U+0000  .notdef,  UNDEFINED
        0x27A1, # G+8209  U+27A1  a172,  BLACK RIGHTWARDS ARROW
        0x25C9, # G+8210  U+25C9  uni25C9,  FISHEYE
        0x2660, # G+8211  U+2660  spade,  BLACK SPADE SUIT
        0x2665, # G+8212  U+2665  heart,  BLACK HEART SUIT
        0x2663, # G+8213  U+2663  club,  BLACK CLUB SUIT
        0x2666, # G+8214  U+2666  diamond,  BLACK DIAMOND SUIT
        0x2600, # G+8215  U+2600  uni2600,  BLACK SUN WITH RAYS
        0x2601, # G+8216  U+2601  uni2601,  CLOUD
        0x2602, # G+8217  U+2602  uni2602,  UMBRELLA
        0x2603, # G+8218  U+2603  uni2603,  SNOWMAN
        0x261E, # G+8219  U+261E  a12,  WHITE RIGHT POINTING INDEX
        0x261C, # G+8220  U+261C  uni261C,  WHITE LEFT POINTING INDEX
        0x261D, # G+8221  U+261D  uni261D,  WHITE UP POINTING INDEX
        0x261F, # G+8222  U+261F  uni261F,  WHITE DOWN POINTING INDEX
        0x3299, # G+8223  U+3299  uni3299,  CIRCLED IDEOGRAPH SECRET
        0x24EA, # G+8224  U+24EA  uni24EA,  CIRCLED DIGIT ZERO
        0x216A, # G+8225  U+216A  uni216A,  ROMAN NUMERAL ELEVEN
        0x216B, # G+8226  U+216B  uni216B,  ROMAN NUMERAL TWELVE
        0x0000, # G+8227  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8228  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8229  U+0000  .notdef,  UNDEFINED
        0x2581, # G+8230  U+2581  uni2581,  LOWER ONE EIGHTH BLOCK
        0x2582, # G+8231  U+2582  uni2582,  LOWER ONE QUARTER BLOCK
        0x2583, # G+8232  U+2583  uni2583,  LOWER THREE EIGHTHS BLOCK
        0x2584, # G+8233  U+2584  dnblock,  LOWER HALF BLOCK
        0x2585, # G+8234  U+2585  uni2585,  LOWER FIVE EIGHTHS BLOCK
        0x2586, # G+8235  U+2586  uni2586,  LOWER THREE QUARTERS BLOCK
        0x2587, # G+8236  U+2587  uni2587,  LOWER SEVEN EIGHTHS BLOCK
        0x2588, # G+8237  U+2588  block,  FULL BLOCK
        0x258F, # G+8238  U+258F  uni258F,  LEFT ONE EIGHTH BLOCK
        0x258E, # G+8239  U+258E  uni258E,  LEFT ONE QUARTER BLOCK
        0x258D, # G+8240  U+258D  uni258D,  LEFT THREE EIGHTHS BLOCK
        0x258C, # G+8241  U+258C  lfblock,  LEFT HALF BLOCK
        0x258B, # G+8242  U+258B  uni258B,  LEFT FIVE EIGHTHS BLOCK
        0x258A, # G+8243  U+258A  uni258A,  LEFT THREE QUARTERS BLOCK
        0x2589, # G+8244  U+2589  uni2589,  LEFT SEVEN EIGHTHS BLOCK
        0x2594, # G+8245  U+2594  uni2594,  UPPER ONE EIGHTH BLOCK
        0x2595, # G+8246  U+2595  uni2595,  RIGHT ONE EIGHTH BLOCK
        0x256D, # G+8247  U+256D  uni256D,  BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
        0x256E, # G+8248  U+256E  uni256E,  BOX DRAWINGS LIGHT ARC DOWN AND LEFT
        0x2570, # G+8249  U+2570  uni2570,  BOX DRAWINGS LIGHT ARC UP AND RIGHT
        0x256F, # G+8250  U+256F  uni256F,  BOX DRAWINGS LIGHT ARC UP AND LEFT
        0x2550, # G+8251  U+2550  SF430000,  BOX DRAWINGS DOUBLE HORIZONTAL
        0x255E, # G+8252  U+255E  SF360000,  BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
        0x256A, # G+8253  U+256A  SF540000,  BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
        0x2561, # G+8254  U+2561  SF190000,  BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
        0x25E2, # G+8255  U+25E2  uni25E2,  BLACK LOWER RIGHT TRIANGLE
        0x25E3, # G+8256  U+25E3  uni25E3,  BLACK LOWER LEFT TRIANGLE
        0x25E5, # G+8257  U+25E5  uni25E5,  BLACK UPPER RIGHT TRIANGLE
        0x25E4, # G+8258  U+25E4  uni25E4,  BLACK UPPER LEFT TRIANGLE
        0x0000, # G+8259  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8260  U+0000  .notdef,  UNDEFINED
        0x2571, # G+8261  U+2571  uni2571,  BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
        0x2572, # G+8262  U+2572  uni2572,  BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
        0x2573, # G+8263  U+2573  uni2573,  BOX DRAWINGS LIGHT DIAGONAL CROSS
        0x0000, # G+8264  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8265  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8266  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8267  U+0000  .notdef,  UNDEFINED
        0xFF0C, # G+8268  U+FF0C  uniFF0C,  FULLWIDTH COMMA
        0x00B0, # G+8269  U+00B0  degree,  DEGREE SIGN
        0x3013, # G+8270  U+3013  uni3013,  GETA MARK
        0x309C, # G+8271  U+309C  uni309C,  KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
        0x309B, # G+8272  U+309B  uni309B,  KATAKANA-HIRAGANA VOICED SOUND MARK
        0x2032, # G+8273  U+2032  minute,  PRIME
        0xFF0E, # G+8274  U+FF0E  uniFF0E,  FULLWIDTH FULL STOP
        0x0000, # G+8275  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8276  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8277  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8278  U+0000  .notdef,  UNDEFINED
        0x201C, # G+8279  U+201C  quotedblleft,  LEFT DOUBLE QUOTATION MARK
        0x201D, # G+8280  U+201D  quotedblright,  RIGHT DOUBLE QUOTATION MARK
        0x2018, # G+8281  U+2018  quoteleft,  LEFT SINGLE QUOTATION MARK
        0x2019, # G+8282  U+2019  quoteright,  RIGHT SINGLE QUOTATION MARK
        0x2033, # G+8283  U+2033  second,  DOUBLE PRIME
        0x51DC, # G+8284  U+51DC  uni51DC,  CJK UNIFIED IDEOGRAPH-51DC
        0x7199, # G+8285  U+7199  uni7199,  CJK UNIFIED IDEOGRAPH-7199
        0x2776, # G+8286  U+2776  a130,  DINGBAT NEGATIVE CIRCLED DIGIT ONE
        0x2777, # G+8287  U+2777  a131,  DINGBAT NEGATIVE CIRCLED DIGIT TWO
        0x2778, # G+8288  U+2778  a132,  DINGBAT NEGATIVE CIRCLED DIGIT THREE
        0x2779, # G+8289  U+2779  a133,  DINGBAT NEGATIVE CIRCLED DIGIT FOUR
        0x277A, # G+8290  U+277A  a134,  DINGBAT NEGATIVE CIRCLED DIGIT FIVE
        0x277B, # G+8291  U+277B  a135,  DINGBAT NEGATIVE CIRCLED DIGIT SIX
        0x277C, # G+8292  U+277C  a136,  DINGBAT NEGATIVE CIRCLED DIGIT SEVEN
        0x277D, # G+8293  U+277D  a137,  DINGBAT NEGATIVE CIRCLED DIGIT EIGHT
        0x277E, # G+8294  U+277E  a138,  DINGBAT NEGATIVE CIRCLED DIGIT NINE
        0x0000, # G+8295  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8296  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8297  U+0000  .notdef,  UNDEFINED
        0x217A, # G+8298  U+217A  uni217A,  SMALL ROMAN NUMERAL ELEVEN
        0x217B, # G+8299  U+217B  uni217B,  SMALL ROMAN NUMERAL TWELVE
        0x0000, # G+8300  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8301  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8302  U+0000  .notdef,  UNDEFINED
        0x217F, # G+8303  U+217F  uni217F,  SMALL ROMAN NUMERAL ONE THOUSAND
        0x210A, # G+8304  U+210A  uni210A,  SCRIPT SMALL G
        0x2109, # G+8305  U+2109  uni2109,  DEGREE FAHRENHEIT
        0x0000, # G+8306  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8307  U+0000  .notdef,  UNDEFINED
        0x3004, # G+8308  U+3004  uni3004,  JAPANESE INDUSTRIAL STANDARD SYMBOL
        0x21C6, # G+8309  U+21C6  uni21C6,  LEFTWARDS ARROW OVER RIGHTWARDS ARROW
        0x21C4, # G+8310  U+21C4  uni21C4,  RIGHTWARDS ARROW OVER LEFTWARDS ARROW
        0x21C5, # G+8311  U+21C5  uni21C5,  UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW
        0x21C6, # G+8312  U+21C6  uni21C6,  LEFTWARDS ARROW OVER RIGHTWARDS ARROW
        0x30F7, # G+8313  U+30F7  uni30F7,  KATAKANA LETTER VA
        0x30F8, # G+8314  U+30F8  uni30F8,  KATAKANA LETTER VI
        0x30F9, # G+8315  U+30F9  uni30F9,  KATAKANA LETTER VE
        0x30FA, # G+8316  U+30FA  uni30FA,  KATAKANA LETTER VO
        0x0000, # G+8317  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8318  U+0000  .notdef,  UNDEFINED
        0x329D, # G+8319  U+329D  uni329D,  CIRCLED IDEOGRAPH EXCELLENT
        0x0000, # G+8320  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8321  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8322  U+0000  .notdef,  UNDEFINED
        0x337B, # G+8323  U+337B  uni337B,  SQUARE ERA NAME HEISEI
        0x337F, # G+8324  U+337F  uni337F,  SQUARE CORPORATION
        0x0000, # G+8325  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8326  U+0000  .notdef,  UNDEFINED
        0x3333, # G+8327  U+3333  uni3333,  SQUARE HUIITO
        0x334E, # G+8328  U+334E  uni334E,  SQUARE YAADO
        0x3322, # G+8329  U+3322  uni3322,  SQUARE SENTI
        0x3316, # G+8330  U+3316  uni3316,  SQUARE KIROMEETORU
        0x0000, # G+8331  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8332  U+0000  .notdef,  UNDEFINED
        0x3305, # G+8333  U+3305  uni3305,  SQUARE INTI
        0x3333, # G+8334  U+3333  uni3333,  SQUARE HUIITO
        0x0000, # G+8335  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8336  U+0000  .notdef,  UNDEFINED
        0x334E, # G+8337  U+334E  uni334E,  SQUARE YAADO
        0x3303, # G+8338  U+3303  uni3303,  SQUARE AARU
        0x3318, # G+8339  U+3318  uni3318,  SQUARE GURAMU
        0x3315, # G+8340  U+3315  uni3315,  SQUARE KIROGURAMU
        0x0000, # G+8341  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8342  U+0000  .notdef,  UNDEFINED
        0x3339, # G+8343  U+3339  uni3339,  SQUARE HERUTU
        0x3357, # G+8344  U+3357  uni3357,  SQUARE WATTO
        0x0000, # G+8345  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8346  U+0000  .notdef,  UNDEFINED
        0x3342, # G+8347  U+3342  uni3342,  SQUARE HOON
        0x3323, # G+8348  U+3323  uni3323,  SQUARE SENTO
        0x333B, # G+8349  U+333B  uni333B,  SQUARE PEEZI
        0x3300, # G+8350  U+3300  uni3300,  SQUARE APAATO
        0x0000, # G+8351  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8352  U+0000  .notdef,  UNDEFINED
        0x331E, # G+8353  U+331E  uni331E,  SQUARE KOOPO
        0x0000, # G+8354  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8355  U+0000  .notdef,  UNDEFINED
        0x332A, # G+8356  U+332A  uni332A,  SQUARE HAITU
        0x3347, # G+8357  U+3347  uni3347,  SQUARE MANSYON
        0x3331, # G+8358  U+3331  uni3331,  SQUARE BIRU
        0x7E8A, # G+8359  U+7E8A  uni7E8A,  CJK UNIFIED IDEOGRAPH-7E8A
        0x891C, # G+8360  U+891C  uni891C,  CJK UNIFIED IDEOGRAPH-891C
        0x9348, # G+8361  U+9348  uni9348,  CJK UNIFIED IDEOGRAPH-9348
        0x9288, # G+8362  U+9288  uni9288,  CJK UNIFIED IDEOGRAPH-9288
        0x84DC, # G+8363  U+84DC  uni84DC,  CJK UNIFIED IDEOGRAPH-84DC
        0x4FC9, # G+8364  U+4FC9  uni4FC9,  CJK UNIFIED IDEOGRAPH-4FC9
        0x70BB, # G+8365  U+70BB  uni70BB,  CJK UNIFIED IDEOGRAPH-70BB
        0x6631, # G+8366  U+6631  uni6631,  CJK UNIFIED IDEOGRAPH-6631
        0x68C8, # G+8367  U+68C8  uni68C8,  CJK UNIFIED IDEOGRAPH-68C8
        0x92F9, # G+8368  U+92F9  uni92F9,  CJK UNIFIED IDEOGRAPH-92F9
        0x66FB, # G+8369  U+66FB  uni66FB,  CJK UNIFIED IDEOGRAPH-66FB
        0x5F45, # G+8370  U+5F45  uni5F45,  CJK UNIFIED IDEOGRAPH-5F45
        0x2F01, # G+8371  U+2F01  uni2F01,  KANGXI RADICAL LINE
        0x4EE1, # G+8372  U+4EE1  uni4EE1,  CJK UNIFIED IDEOGRAPH-4EE1
        0x4EFC, # G+8373  U+4EFC  uni4EFC,  CJK UNIFIED IDEOGRAPH-4EFC
        0x4F00, # G+8374  U+4F00  uni4F00,  CJK UNIFIED IDEOGRAPH-4F00
        0x4F03, # G+8375  U+4F03  uni4F03,  CJK UNIFIED IDEOGRAPH-4F03
        0x4F39, # G+8376  U+4F39  uni4F39,  CJK UNIFIED IDEOGRAPH-4F39
        0x4F56, # G+8377  U+4F56  uni4F56,  CJK UNIFIED IDEOGRAPH-4F56
        0x4F92, # G+8378  U+4F92  uni4F92,  CJK UNIFIED IDEOGRAPH-4F92
        0x4F8A, # G+8379  U+4F8A  uni4F8A,  CJK UNIFIED IDEOGRAPH-4F8A
        0x4F9A, # G+8380  U+4F9A  uni4F9A,  CJK UNIFIED IDEOGRAPH-4F9A
        0x4F94, # G+8381  U+4F94  uni4F94,  CJK UNIFIED IDEOGRAPH-4F94
        0x4FCD, # G+8382  U+4FCD  uni4FCD,  CJK UNIFIED IDEOGRAPH-4FCD
        0x5040, # G+8383  U+5040  uni5040,  CJK UNIFIED IDEOGRAPH-5040
        0x5022, # G+8384  U+5022  uni5022,  CJK UNIFIED IDEOGRAPH-5022
        0x4FFF, # G+8385  U+4FFF  uni4FFF,  CJK UNIFIED IDEOGRAPH-4FFF
        0x501E, # G+8386  U+501E  uni501E,  CJK UNIFIED IDEOGRAPH-501E
        0x5046, # G+8387  U+5046  uni5046,  CJK UNIFIED IDEOGRAPH-5046
        0x5070, # G+8388  U+5070  uni5070,  CJK UNIFIED IDEOGRAPH-5070
        0x5042, # G+8389  U+5042  uni5042,  CJK UNIFIED IDEOGRAPH-5042
        0x5094, # G+8390  U+5094  uni5094,  CJK UNIFIED IDEOGRAPH-5094
        0x50F4, # G+8391  U+50F4  uni50F4,  CJK UNIFIED IDEOGRAPH-50F4
        0x50D8, # G+8392  U+50D8  uni50D8,  CJK UNIFIED IDEOGRAPH-50D8
        0x514A, # G+8393  U+514A  uni514A,  CJK UNIFIED IDEOGRAPH-514A
        0x5164, # G+8394  U+5164  uni5164,  CJK UNIFIED IDEOGRAPH-5164
        0x519D, # G+8395  U+519D  uni519D,  CJK UNIFIED IDEOGRAPH-519D
        0x51BE, # G+8396  U+51BE  uni51BE,  CJK UNIFIED IDEOGRAPH-51BE
        0x51EC, # G+8397  U+51EC  uni51EC,  CJK UNIFIED IDEOGRAPH-51EC
        0x5215, # G+8398  U+5215  uni5215,  CJK UNIFIED IDEOGRAPH-5215
        0x529C, # G+8399  U+529C  uni529C,  CJK UNIFIED IDEOGRAPH-529C
        0x52A6, # G+8400  U+52A6  uni52A6,  CJK UNIFIED IDEOGRAPH-52A6
        0x52C0, # G+8401  U+52C0  uni52C0,  CJK UNIFIED IDEOGRAPH-52C0
        0x52DB, # G+8402  U+52DB  uni52DB,  CJK UNIFIED IDEOGRAPH-52DB
        0x5300, # G+8403  U+5300  uni5300,  CJK UNIFIED IDEOGRAPH-5300
        0x5307, # G+8404  U+5307  uni5307,  CJK UNIFIED IDEOGRAPH-5307
        0x5324, # G+8405  U+5324  uni5324,  CJK UNIFIED IDEOGRAPH-5324
        0x5372, # G+8406  U+5372  uni5372,  CJK UNIFIED IDEOGRAPH-5372
        0x5393, # G+8407  U+5393  uni5393,  CJK UNIFIED IDEOGRAPH-5393
        0x53B2, # G+8408  U+53B2  uni53B2,  CJK UNIFIED IDEOGRAPH-53B2
        0x53DD, # G+8409  U+53DD  uni53DD,  CJK UNIFIED IDEOGRAPH-53DD
        0xFA0E, # G+8410  U+FA0E  uniFA0E,  CJK COMPATIBILITY IDEOGRAPH-FA0E
        0x549C, # G+8411  U+549C  uni549C,  CJK UNIFIED IDEOGRAPH-549C
        0x548A, # G+8412  U+548A  uni548A,  CJK UNIFIED IDEOGRAPH-548A
        0x54A9, # G+8413  U+54A9  uni54A9,  CJK UNIFIED IDEOGRAPH-54A9
        0x54FF, # G+8414  U+54FF  uni54FF,  CJK UNIFIED IDEOGRAPH-54FF
        0x5586, # G+8415  U+5586  uni5586,  CJK UNIFIED IDEOGRAPH-5586
        0x5759, # G+8416  U+5759  uni5759,  CJK UNIFIED IDEOGRAPH-5759
        0x5765, # G+8417  U+5765  uni5765,  CJK UNIFIED IDEOGRAPH-5765
        0x57AC, # G+8418  U+57AC  uni57AC,  CJK UNIFIED IDEOGRAPH-57AC
        0x57C8, # G+8419  U+57C8  uni57C8,  CJK UNIFIED IDEOGRAPH-57C8
        0x57C7, # G+8420  U+57C7  uni57C7,  CJK UNIFIED IDEOGRAPH-57C7
        0xFA0F, # G+8421  U+FA0F  uniFA0F,  CJK COMPATIBILITY IDEOGRAPH-FA0F
        0xFA10, # G+8422  U+FA10  uniFA10,  CJK COMPATIBILITY IDEOGRAPH-FA10
        0x589E, # G+8423  U+589E  uni589E,  CJK UNIFIED IDEOGRAPH-589E
        0x58B2, # G+8424  U+58B2  uni58B2,  CJK UNIFIED IDEOGRAPH-58B2
        0x590B, # G+8425  U+590B  uni590B,  CJK UNIFIED IDEOGRAPH-590B
        0x5953, # G+8426  U+5953  uni5953,  CJK UNIFIED IDEOGRAPH-5953
        0x595B, # G+8427  U+595B  uni595B,  CJK UNIFIED IDEOGRAPH-595B
        0x595D, # G+8428  U+595D  uni595D,  CJK UNIFIED IDEOGRAPH-595D
        0x5963, # G+8429  U+5963  uni5963,  CJK UNIFIED IDEOGRAPH-5963
        0x59A4, # G+8430  U+59A4  uni59A4,  CJK UNIFIED IDEOGRAPH-59A4
        0x59BA, # G+8431  U+59BA  uni59BA,  CJK UNIFIED IDEOGRAPH-59BA
        0x5B56, # G+8432  U+5B56  uni5B56,  CJK UNIFIED IDEOGRAPH-5B56
        0x5BC0, # G+8433  U+5BC0  uni5BC0,  CJK UNIFIED IDEOGRAPH-5BC0
        0x752F, # G+8434  U+752F  uni752F,  CJK UNIFIED IDEOGRAPH-752F
        0x5BD8, # G+8435  U+5BD8  uni5BD8,  CJK UNIFIED IDEOGRAPH-5BD8
        0x5BEC, # G+8436  U+5BEC  uni5BEC,  CJK UNIFIED IDEOGRAPH-5BEC
        0x5C1E, # G+8437  U+5C1E  uni5C1E,  CJK UNIFIED IDEOGRAPH-5C1E
        0x5CA6, # G+8438  U+5CA6  uni5CA6,  CJK UNIFIED IDEOGRAPH-5CA6
        0x5CBA, # G+8439  U+5CBA  uni5CBA,  CJK UNIFIED IDEOGRAPH-5CBA
        0x5CF5, # G+8440  U+5CF5  uni5CF5,  CJK UNIFIED IDEOGRAPH-5CF5
        0x5D27, # G+8441  U+5D27  uni5D27,  CJK UNIFIED IDEOGRAPH-5D27
        0x5D53, # G+8442  U+5D53  uni5D53,  CJK UNIFIED IDEOGRAPH-5D53
        0xFA11, # G+8443  U+FA11  uniFA11,  CJK COMPATIBILITY IDEOGRAPH-FA11
        0x5D42, # G+8444  U+5D42  uni5D42,  CJK UNIFIED IDEOGRAPH-5D42
        0x5D6D, # G+8445  U+5D6D  uni5D6D,  CJK UNIFIED IDEOGRAPH-5D6D
        0x5DB8, # G+8446  U+5DB8  uni5DB8,  CJK UNIFIED IDEOGRAPH-5DB8
        0x5DB9, # G+8447  U+5DB9  uni5DB9,  CJK UNIFIED IDEOGRAPH-5DB9
        0x5DD0, # G+8448  U+5DD0  uni5DD0,  CJK UNIFIED IDEOGRAPH-5DD0
        0x5F21, # G+8449  U+5F21  uni5F21,  CJK UNIFIED IDEOGRAPH-5F21
        0x5F34, # G+8450  U+5F34  uni5F34,  CJK UNIFIED IDEOGRAPH-5F34
        0x5F67, # G+8451  U+5F67  uni5F67,  CJK UNIFIED IDEOGRAPH-5F67
        0x5FB7, # G+8452  U+5FB7  uni5FB7,  CJK UNIFIED IDEOGRAPH-5FB7
        0x5FDE, # G+8453  U+5FDE  uni5FDE,  CJK UNIFIED IDEOGRAPH-5FDE
        0x605D, # G+8454  U+605D  uni605D,  CJK UNIFIED IDEOGRAPH-605D
        0x6085, # G+8455  U+6085  uni6085,  CJK UNIFIED IDEOGRAPH-6085
        0x608A, # G+8456  U+608A  uni608A,  CJK UNIFIED IDEOGRAPH-608A
        0x60DE, # G+8457  U+60DE  uni60DE,  CJK UNIFIED IDEOGRAPH-60DE
        0x60D5, # G+8458  U+60D5  uni60D5,  CJK UNIFIED IDEOGRAPH-60D5
        0x6120, # G+8459  U+6120  uni6120,  CJK UNIFIED IDEOGRAPH-6120
        0x60F2, # G+8460  U+60F2  uni60F2,  CJK UNIFIED IDEOGRAPH-60F2
        0x6111, # G+8461  U+6111  uni6111,  CJK UNIFIED IDEOGRAPH-6111
        0x6137, # G+8462  U+6137  uni6137,  CJK UNIFIED IDEOGRAPH-6137
        0x6130, # G+8463  U+6130  uni6130,  CJK UNIFIED IDEOGRAPH-6130
        0x6198, # G+8464  U+6198  uni6198,  CJK UNIFIED IDEOGRAPH-6198
        0x6213, # G+8465  U+6213  uni6213,  CJK UNIFIED IDEOGRAPH-6213
        0x62A6, # G+8466  U+62A6  uni62A6,  CJK UNIFIED IDEOGRAPH-62A6
        0x63F5, # G+8467  U+63F5  uni63F5,  CJK UNIFIED IDEOGRAPH-63F5
        0x6460, # G+8468  U+6460  uni6460,  CJK UNIFIED IDEOGRAPH-6460
        0x649D, # G+8469  U+649D  uni649D,  CJK UNIFIED IDEOGRAPH-649D
        0x64CE, # G+8470  U+64CE  uni64CE,  CJK UNIFIED IDEOGRAPH-64CE
        0x654E, # G+8471  U+654E  uni654E,  CJK UNIFIED IDEOGRAPH-654E
        0x6600, # G+8472  U+6600  uni6600,  CJK UNIFIED IDEOGRAPH-6600
        0x6615, # G+8473  U+6615  uni6615,  CJK UNIFIED IDEOGRAPH-6615
        0x6609, # G+8474  U+6609  uni6609,  CJK UNIFIED IDEOGRAPH-6609
        0x662E, # G+8475  U+662E  uni662E,  CJK UNIFIED IDEOGRAPH-662E
        0x661E, # G+8476  U+661E  uni661E,  CJK UNIFIED IDEOGRAPH-661E
        0x6624, # G+8477  U+6624  uni6624,  CJK UNIFIED IDEOGRAPH-6624
        0x6665, # G+8478  U+6665  uni6665,  CJK UNIFIED IDEOGRAPH-6665
        0x6657, # G+8479  U+6657  uni6657,  CJK UNIFIED IDEOGRAPH-6657
        0x6659, # G+8480  U+6659  uni6659,  CJK UNIFIED IDEOGRAPH-6659
        0xFA12, # G+8481  U+FA12  uniFA12,  CJK COMPATIBILITY IDEOGRAPH-FA12
        0x6673, # G+8482  U+6673  uni6673,  CJK UNIFIED IDEOGRAPH-6673
        0x6699, # G+8483  U+6699  uni6699,  CJK UNIFIED IDEOGRAPH-6699
        0x66A0, # G+8484  U+66A0  uni66A0,  CJK UNIFIED IDEOGRAPH-66A0
        0x66B2, # G+8485  U+66B2  uni66B2,  CJK UNIFIED IDEOGRAPH-66B2
        0x66BF, # G+8486  U+66BF  uni66BF,  CJK UNIFIED IDEOGRAPH-66BF
        0x66FA, # G+8487  U+66FA  uni66FA,  CJK UNIFIED IDEOGRAPH-66FA
        0x670E, # G+8488  U+670E  uni670E,  CJK UNIFIED IDEOGRAPH-670E
        0xF929, # G+8489  U+F929  uniF929,  CJK COMPATIBILITY IDEOGRAPH-F929
        0x6766, # G+8490  U+6766  uni6766,  CJK UNIFIED IDEOGRAPH-6766
        0x67BB, # G+8491  U+67BB  uni67BB,  CJK UNIFIED IDEOGRAPH-67BB
        0x6852, # G+8492  U+6852  uni6852,  CJK UNIFIED IDEOGRAPH-6852
        0x67C0, # G+8493  U+67C0  uni67C0,  CJK UNIFIED IDEOGRAPH-67C0
        0x6801, # G+8494  U+6801  uni6801,  CJK UNIFIED IDEOGRAPH-6801
        0x6844, # G+8495  U+6844  uni6844,  CJK UNIFIED IDEOGRAPH-6844
        0x68CF, # G+8496  U+68CF  uni68CF,  CJK UNIFIED IDEOGRAPH-68CF
        0xFA13, # G+8497  U+FA13  uniFA13,  CJK COMPATIBILITY IDEOGRAPH-FA13
        0x6968, # G+8498  U+6968  uni6968,  CJK UNIFIED IDEOGRAPH-6968
        0xFA14, # G+8499  U+FA14  uniFA14,  CJK COMPATIBILITY IDEOGRAPH-FA14
        0x6998, # G+8500  U+6998  uni6998,  CJK UNIFIED IDEOGRAPH-6998
        0x69E2, # G+8501  U+69E2  uni69E2,  CJK UNIFIED IDEOGRAPH-69E2
        0x6A30, # G+8502  U+6A30  uni6A30,  CJK UNIFIED IDEOGRAPH-6A30
        0x6A6B, # G+8503  U+6A6B  uni6A6B,  CJK UNIFIED IDEOGRAPH-6A6B
        0x6A46, # G+8504  U+6A46  uni6A46,  CJK UNIFIED IDEOGRAPH-6A46
        0x6A73, # G+8505  U+6A73  uni6A73,  CJK UNIFIED IDEOGRAPH-6A73
        0x6A7E, # G+8506  U+6A7E  uni6A7E,  CJK UNIFIED IDEOGRAPH-6A7E
        0x6AE2, # G+8507  U+6AE2  uni6AE2,  CJK UNIFIED IDEOGRAPH-6AE2
        0x6AE4, # G+8508  U+6AE4  uni6AE4,  CJK UNIFIED IDEOGRAPH-6AE4
        0x6BD6, # G+8509  U+6BD6  uni6BD6,  CJK UNIFIED IDEOGRAPH-6BD6
        0x6C3F, # G+8510  U+6C3F  uni6C3F,  CJK UNIFIED IDEOGRAPH-6C3F
        0x6C5C, # G+8511  U+6C5C  uni6C5C,  CJK UNIFIED IDEOGRAPH-6C5C
        0x6C86, # G+8512  U+6C86  uni6C86,  CJK UNIFIED IDEOGRAPH-6C86
        0x6C6F, # G+8513  U+6C6F  uni6C6F,  CJK UNIFIED IDEOGRAPH-6C6F
        0x6CDA, # G+8514  U+6CDA  uni6CDA,  CJK UNIFIED IDEOGRAPH-6CDA
        0x6D04, # G+8515  U+6D04  uni6D04,  CJK UNIFIED IDEOGRAPH-6D04
        0x6D87, # G+8516  U+6D87  uni6D87,  CJK UNIFIED IDEOGRAPH-6D87
        0x6D6F, # G+8517  U+6D6F  uni6D6F,  CJK UNIFIED IDEOGRAPH-6D6F
        0x6D96, # G+8518  U+6D96  uni6D96,  CJK UNIFIED IDEOGRAPH-6D96
        0x6DAC, # G+8519  U+6DAC  uni6DAC,  CJK UNIFIED IDEOGRAPH-6DAC
        0x6DCF, # G+8520  U+6DCF  uni6DCF,  CJK UNIFIED IDEOGRAPH-6DCF
        0x6DF8, # G+8521  U+6DF8  uni6DF8,  CJK UNIFIED IDEOGRAPH-6DF8
        0x6DF2, # G+8522  U+6DF2  uni6DF2,  CJK UNIFIED IDEOGRAPH-6DF2
        0x6DFC, # G+8523  U+6DFC  uni6DFC,  CJK UNIFIED IDEOGRAPH-6DFC
        0x6E39, # G+8524  U+6E39  uni6E39,  CJK UNIFIED IDEOGRAPH-6E39
        0x6E5C, # G+8525  U+6E5C  uni6E5C,  CJK UNIFIED IDEOGRAPH-6E5C
        0x6E27, # G+8526  U+6E27  uni6E27,  CJK UNIFIED IDEOGRAPH-6E27
        0x6E3C, # G+8527  U+6E3C  uni6E3C,  CJK UNIFIED IDEOGRAPH-6E3C
        0x6EBF, # G+8528  U+6EBF  uni6EBF,  CJK UNIFIED IDEOGRAPH-6EBF
        0x6F88, # G+8529  U+6F88  uni6F88,  CJK UNIFIED IDEOGRAPH-6F88
        0x6FB5, # G+8530  U+6FB5  uni6FB5,  CJK UNIFIED IDEOGRAPH-6FB5
        0x6FF5, # G+8531  U+6FF5  uni6FF5,  CJK UNIFIED IDEOGRAPH-6FF5
        0x7005, # G+8532  U+7005  uni7005,  CJK UNIFIED IDEOGRAPH-7005
        0x7007, # G+8533  U+7007  uni7007,  CJK UNIFIED IDEOGRAPH-7007
        0x7028, # G+8534  U+7028  uni7028,  CJK UNIFIED IDEOGRAPH-7028
        0x7085, # G+8535  U+7085  uni7085,  CJK UNIFIED IDEOGRAPH-7085
        0x70AB, # G+8536  U+70AB  uni70AB,  CJK UNIFIED IDEOGRAPH-70AB
        0x710F, # G+8537  U+710F  uni710F,  CJK UNIFIED IDEOGRAPH-710F
        0x7104, # G+8538  U+7104  uni7104,  CJK UNIFIED IDEOGRAPH-7104
        0x715C, # G+8539  U+715C  uni715C,  CJK UNIFIED IDEOGRAPH-715C
        0x7146, # G+8540  U+7146  uni7146,  CJK UNIFIED IDEOGRAPH-7146
        0x7147, # G+8541  U+7147  uni7147,  CJK UNIFIED IDEOGRAPH-7147
        0xFA15, # G+8542  U+FA15  uniFA15,  CJK COMPATIBILITY IDEOGRAPH-FA15
        0x71C1, # G+8543  U+71C1  uni71C1,  CJK UNIFIED IDEOGRAPH-71C1
        0x71FE, # G+8544  U+71FE  uni71FE,  CJK UNIFIED IDEOGRAPH-71FE
        0x72B1, # G+8545  U+72B1  uni72B1,  CJK UNIFIED IDEOGRAPH-72B1
        0x72BE, # G+8546  U+72BE  uni72BE,  CJK UNIFIED IDEOGRAPH-72BE
        0x7324, # G+8547  U+7324  uni7324,  CJK UNIFIED IDEOGRAPH-7324
        0xFA16, # G+8548  U+FA16  uniFA16,  CJK COMPATIBILITY IDEOGRAPH-FA16
        0x7377, # G+8549  U+7377  uni7377,  CJK UNIFIED IDEOGRAPH-7377
        0x73BD, # G+8550  U+73BD  uni73BD,  CJK UNIFIED IDEOGRAPH-73BD
        0x73C9, # G+8551  U+73C9  uni73C9,  CJK UNIFIED IDEOGRAPH-73C9
        0x73D6, # G+8552  U+73D6  uni73D6,  CJK UNIFIED IDEOGRAPH-73D6
        0x73E3, # G+8553  U+73E3  uni73E3,  CJK UNIFIED IDEOGRAPH-73E3
        0x73D2, # G+8554  U+73D2  uni73D2,  CJK UNIFIED IDEOGRAPH-73D2
        0x7407, # G+8555  U+7407  uni7407,  CJK UNIFIED IDEOGRAPH-7407
        0x73F5, # G+8556  U+73F5  uni73F5,  CJK UNIFIED IDEOGRAPH-73F5
        0x7426, # G+8557  U+7426  uni7426,  CJK UNIFIED IDEOGRAPH-7426
        0x742A, # G+8558  U+742A  uni742A,  CJK UNIFIED IDEOGRAPH-742A
        0x7429, # G+8559  U+7429  uni7429,  CJK UNIFIED IDEOGRAPH-7429
        0x742E, # G+8560  U+742E  uni742E,  CJK UNIFIED IDEOGRAPH-742E
        0x7462, # G+8561  U+7462  uni7462,  CJK UNIFIED IDEOGRAPH-7462
        0x7489, # G+8562  U+7489  uni7489,  CJK UNIFIED IDEOGRAPH-7489
        0x749F, # G+8563  U+749F  uni749F,  CJK UNIFIED IDEOGRAPH-749F
        0x7501, # G+8564  U+7501  uni7501,  CJK UNIFIED IDEOGRAPH-7501
        0x756F, # G+8565  U+756F  uni756F,  CJK UNIFIED IDEOGRAPH-756F
        0x7682, # G+8566  U+7682  uni7682,  CJK UNIFIED IDEOGRAPH-7682
        0x769C, # G+8567  U+769C  uni769C,  CJK UNIFIED IDEOGRAPH-769C
        0x769E, # G+8568  U+769E  uni769E,  CJK UNIFIED IDEOGRAPH-769E
        0x769B, # G+8569  U+769B  uni769B,  CJK UNIFIED IDEOGRAPH-769B
        0x76A6, # G+8570  U+76A6  uni76A6,  CJK UNIFIED IDEOGRAPH-76A6
        0xFA17, # G+8571  U+FA17  uniFA17,  CJK COMPATIBILITY IDEOGRAPH-FA17
        0x7746, # G+8572  U+7746  uni7746,  CJK UNIFIED IDEOGRAPH-7746
        0x52AF, # G+8573  U+52AF  uni52AF,  CJK UNIFIED IDEOGRAPH-52AF
        0x7821, # G+8574  U+7821  uni7821,  CJK UNIFIED IDEOGRAPH-7821
        0x784E, # G+8575  U+784E  uni784E,  CJK UNIFIED IDEOGRAPH-784E
        0x7864, # G+8576  U+7864  uni7864,  CJK UNIFIED IDEOGRAPH-7864
        0x787A, # G+8577  U+787A  uni787A,  CJK UNIFIED IDEOGRAPH-787A
        0x7930, # G+8578  U+7930  uni7930,  CJK UNIFIED IDEOGRAPH-7930
        0xFA18, # G+8579  U+FA18  uniFA18,  CJK COMPATIBILITY IDEOGRAPH-FA18
        0xFA19, # G+8580  U+FA19  uniFA19,  CJK COMPATIBILITY IDEOGRAPH-FA19
        0xFA1A, # G+8581  U+FA1A  uniFA1A,  CJK COMPATIBILITY IDEOGRAPH-FA1A
        0x7994, # G+8582  U+7994  uni7994,  CJK UNIFIED IDEOGRAPH-7994
        0xFA1B, # G+8583  U+FA1B  uniFA1B,  CJK COMPATIBILITY IDEOGRAPH-FA1B
        0x799B, # G+8584  U+799B  uni799B,  CJK UNIFIED IDEOGRAPH-799B
        0x7AD1, # G+8585  U+7AD1  uni7AD1,  CJK UNIFIED IDEOGRAPH-7AD1
        0x7AE7, # G+8586  U+7AE7  uni7AE7,  CJK UNIFIED IDEOGRAPH-7AE7
        0xFA1C, # G+8587  U+FA1C  uniFA1C,  CJK COMPATIBILITY IDEOGRAPH-FA1C
        0x7AEB, # G+8588  U+7AEB  uni7AEB,  CJK UNIFIED IDEOGRAPH-7AEB
        0x7B9E, # G+8589  U+7B9E  uni7B9E,  CJK UNIFIED IDEOGRAPH-7B9E
        0xFA1D, # G+8590  U+FA1D  uniFA1D,  CJK COMPATIBILITY IDEOGRAPH-FA1D
        0x7D48, # G+8591  U+7D48  uni7D48,  CJK UNIFIED IDEOGRAPH-7D48
        0x7D5C, # G+8592  U+7D5C  uni7D5C,  CJK UNIFIED IDEOGRAPH-7D5C
        0x7DB7, # G+8593  U+7DB7  uni7DB7,  CJK UNIFIED IDEOGRAPH-7DB7
        0x7DA0, # G+8594  U+7DA0  uni7DA0,  CJK UNIFIED IDEOGRAPH-7DA0
        0x7DD6, # G+8595  U+7DD6  uni7DD6,  CJK UNIFIED IDEOGRAPH-7DD6
        0x7E52, # G+8596  U+7E52  uni7E52,  CJK UNIFIED IDEOGRAPH-7E52
        0x7F47, # G+8597  U+7F47  uni7F47,  CJK UNIFIED IDEOGRAPH-7F47
        0x7FA1, # G+8598  U+7FA1  uni7FA1,  CJK UNIFIED IDEOGRAPH-7FA1
        0xFA1E, # G+8599  U+FA1E  uniFA1E,  CJK COMPATIBILITY IDEOGRAPH-FA1E
        0x8301, # G+8600  U+8301  uni8301,  CJK UNIFIED IDEOGRAPH-8301
        0x8362, # G+8601  U+8362  uni8362,  CJK UNIFIED IDEOGRAPH-8362
        0x837F, # G+8602  U+837F  uni837F,  CJK UNIFIED IDEOGRAPH-837F
        0x83C7, # G+8603  U+83C7  uni83C7,  CJK UNIFIED IDEOGRAPH-83C7
        0x83F6, # G+8604  U+83F6  uni83F6,  CJK UNIFIED IDEOGRAPH-83F6
        0x8448, # G+8605  U+8448  uni8448,  CJK UNIFIED IDEOGRAPH-8448
        0x84B4, # G+8606  U+84B4  uni84B4,  CJK UNIFIED IDEOGRAPH-84B4
        0x8553, # G+8607  U+8553  uni8553,  CJK UNIFIED IDEOGRAPH-8553
        0x8559, # G+8608  U+8559  uni8559,  CJK UNIFIED IDEOGRAPH-8559
        0x856B, # G+8609  U+856B  uni856B,  CJK UNIFIED IDEOGRAPH-856B
        0xFA1F, # G+8610  U+FA1F  uniFA1F,  CJK COMPATIBILITY IDEOGRAPH-FA1F
        0x85B0, # G+8611  U+85B0  uni85B0,  CJK UNIFIED IDEOGRAPH-85B0
        0xFA20, # G+8612  U+FA20  uniFA20,  CJK COMPATIBILITY IDEOGRAPH-FA20
        0xFA21, # G+8613  U+FA21  uniFA21,  CJK COMPATIBILITY IDEOGRAPH-FA21
        0x8807, # G+8614  U+8807  uni8807,  CJK UNIFIED IDEOGRAPH-8807
        0x88F5, # G+8615  U+88F5  uni88F5,  CJK UNIFIED IDEOGRAPH-88F5
        0x8A12, # G+8616  U+8A12  uni8A12,  CJK UNIFIED IDEOGRAPH-8A12
        0x8A37, # G+8617  U+8A37  uni8A37,  CJK UNIFIED IDEOGRAPH-8A37
        0x8A79, # G+8618  U+8A79  uni8A79,  CJK UNIFIED IDEOGRAPH-8A79
        0x8AA7, # G+8619  U+8AA7  uni8AA7,  CJK UNIFIED IDEOGRAPH-8AA7
        0x8ABE, # G+8620  U+8ABE  uni8ABE,  CJK UNIFIED IDEOGRAPH-8ABE
        0x8ADF, # G+8621  U+8ADF  uni8ADF,  CJK UNIFIED IDEOGRAPH-8ADF
        0xFA22, # G+8622  U+FA22  uniFA22,  CJK COMPATIBILITY IDEOGRAPH-FA22
        0x8AF6, # G+8623  U+8AF6  uni8AF6,  CJK UNIFIED IDEOGRAPH-8AF6
        0x8B53, # G+8624  U+8B53  uni8B53,  CJK UNIFIED IDEOGRAPH-8B53
        0x8B7F, # G+8625  U+8B7F  uni8B7F,  CJK UNIFIED IDEOGRAPH-8B7F
        0x8CF0, # G+8626  U+8CF0  uni8CF0,  CJK UNIFIED IDEOGRAPH-8CF0
        0x8CF4, # G+8627  U+8CF4  uni8CF4,  CJK UNIFIED IDEOGRAPH-8CF4
        0x8D12, # G+8628  U+8D12  uni8D12,  CJK UNIFIED IDEOGRAPH-8D12
        0x8D76, # G+8629  U+8D76  uni8D76,  CJK UNIFIED IDEOGRAPH-8D76
        0xFA23, # G+8630  U+FA23  uniFA23,  CJK COMPATIBILITY IDEOGRAPH-FA23
        0x8ECF, # G+8631  U+8ECF  uni8ECF,  CJK UNIFIED IDEOGRAPH-8ECF
        0xFA24, # G+8632  U+FA24  uniFA24,  CJK COMPATIBILITY IDEOGRAPH-FA24
        0xFA25, # G+8633  U+FA25  uniFA25,  CJK COMPATIBILITY IDEOGRAPH-FA25
        0x9067, # G+8634  U+9067  uni9067,  CJK UNIFIED IDEOGRAPH-9067
        0x90DE, # G+8635  U+90DE  uni90DE,  CJK UNIFIED IDEOGRAPH-90DE
        0xFA26, # G+8636  U+FA26  uniFA26,  CJK COMPATIBILITY IDEOGRAPH-FA26
        0x9115, # G+8637  U+9115  uni9115,  CJK UNIFIED IDEOGRAPH-9115
        0x9127, # G+8638  U+9127  uni9127,  CJK UNIFIED IDEOGRAPH-9127
        0x91DA, # G+8639  U+91DA  uni91DA,  CJK UNIFIED IDEOGRAPH-91DA
        0x91D7, # G+8640  U+91D7  uni91D7,  CJK UNIFIED IDEOGRAPH-91D7
        0x91DE, # G+8641  U+91DE  uni91DE,  CJK UNIFIED IDEOGRAPH-91DE
        0x91ED, # G+8642  U+91ED  uni91ED,  CJK UNIFIED IDEOGRAPH-91ED
        0x91EE, # G+8643  U+91EE  uni91EE,  CJK UNIFIED IDEOGRAPH-91EE
        0x91E4, # G+8644  U+91E4  uni91E4,  CJK UNIFIED IDEOGRAPH-91E4
        0x91E5, # G+8645  U+91E5  uni91E5,  CJK UNIFIED IDEOGRAPH-91E5
        0x9206, # G+8646  U+9206  uni9206,  CJK UNIFIED IDEOGRAPH-9206
        0x9210, # G+8647  U+9210  uni9210,  CJK UNIFIED IDEOGRAPH-9210
        0x920A, # G+8648  U+920A  uni920A,  CJK UNIFIED IDEOGRAPH-920A
        0x923A, # G+8649  U+923A  uni923A,  CJK UNIFIED IDEOGRAPH-923A
        0x9240, # G+8650  U+9240  uni9240,  CJK UNIFIED IDEOGRAPH-9240
        0x923C, # G+8651  U+923C  uni923C,  CJK UNIFIED IDEOGRAPH-923C
        0x924E, # G+8652  U+924E  uni924E,  CJK UNIFIED IDEOGRAPH-924E
        0x9259, # G+8653  U+9259  uni9259,  CJK UNIFIED IDEOGRAPH-9259
        0x9251, # G+8654  U+9251  uni9251,  CJK UNIFIED IDEOGRAPH-9251
        0x9239, # G+8655  U+9239  uni9239,  CJK UNIFIED IDEOGRAPH-9239
        0x9267, # G+8656  U+9267  uni9267,  CJK UNIFIED IDEOGRAPH-9267
        0x92A7, # G+8657  U+92A7  uni92A7,  CJK UNIFIED IDEOGRAPH-92A7
        0x9277, # G+8658  U+9277  uni9277,  CJK UNIFIED IDEOGRAPH-9277
        0x9278, # G+8659  U+9278  uni9278,  CJK UNIFIED IDEOGRAPH-9278
        0x92E7, # G+8660  U+92E7  uni92E7,  CJK UNIFIED IDEOGRAPH-92E7
        0x92D7, # G+8661  U+92D7  uni92D7,  CJK UNIFIED IDEOGRAPH-92D7
        0x92D9, # G+8662  U+92D9  uni92D9,  CJK UNIFIED IDEOGRAPH-92D9
        0x92D0, # G+8663  U+92D0  uni92D0,  CJK UNIFIED IDEOGRAPH-92D0
        0xFA27, # G+8664  U+FA27  uniFA27,  CJK COMPATIBILITY IDEOGRAPH-FA27
        0x92D5, # G+8665  U+92D5  uni92D5,  CJK UNIFIED IDEOGRAPH-92D5
        0x92E0, # G+8666  U+92E0  uni92E0,  CJK UNIFIED IDEOGRAPH-92E0
        0x92D3, # G+8667  U+92D3  uni92D3,  CJK UNIFIED IDEOGRAPH-92D3
        0x9325, # G+8668  U+9325  uni9325,  CJK UNIFIED IDEOGRAPH-9325
        0x9321, # G+8669  U+9321  uni9321,  CJK UNIFIED IDEOGRAPH-9321
        0x92FB, # G+8670  U+92FB  uni92FB,  CJK UNIFIED IDEOGRAPH-92FB
        0xFA28, # G+8671  U+FA28  uniFA28,  CJK COMPATIBILITY IDEOGRAPH-FA28
        0x931E, # G+8672  U+931E  uni931E,  CJK UNIFIED IDEOGRAPH-931E
        0x92FF, # G+8673  U+92FF  uni92FF,  CJK UNIFIED IDEOGRAPH-92FF
        0x931D, # G+8674  U+931D  uni931D,  CJK UNIFIED IDEOGRAPH-931D
        0x9302, # G+8675  U+9302  uni9302,  CJK UNIFIED IDEOGRAPH-9302
        0x9370, # G+8676  U+9370  uni9370,  CJK UNIFIED IDEOGRAPH-9370
        0x9357, # G+8677  U+9357  uni9357,  CJK UNIFIED IDEOGRAPH-9357
        0x93A4, # G+8678  U+93A4  uni93A4,  CJK UNIFIED IDEOGRAPH-93A4
        0x93C6, # G+8679  U+93C6  uni93C6,  CJK UNIFIED IDEOGRAPH-93C6
        0x93DE, # G+8680  U+93DE  uni93DE,  CJK UNIFIED IDEOGRAPH-93DE
        0x93F8, # G+8681  U+93F8  uni93F8,  CJK UNIFIED IDEOGRAPH-93F8
        0x9431, # G+8682  U+9431  uni9431,  CJK UNIFIED IDEOGRAPH-9431
        0x9445, # G+8683  U+9445  uni9445,  CJK UNIFIED IDEOGRAPH-9445
        0x9448, # G+8684  U+9448  uni9448,  CJK UNIFIED IDEOGRAPH-9448
        0x9592, # G+8685  U+9592  uni9592,  CJK UNIFIED IDEOGRAPH-9592
        0xF9DC, # G+8686  U+F9DC  uniF9DC,  CJK COMPATIBILITY IDEOGRAPH-F9DC
        0xFA29, # G+8687  U+FA29  uniFA29,  CJK COMPATIBILITY IDEOGRAPH-FA29
        0x969D, # G+8688  U+969D  uni969D,  CJK UNIFIED IDEOGRAPH-969D
        0x96AF, # G+8689  U+96AF  uni96AF,  CJK UNIFIED IDEOGRAPH-96AF
        0x9733, # G+8690  U+9733  uni9733,  CJK UNIFIED IDEOGRAPH-9733
        0x973B, # G+8691  U+973B  uni973B,  CJK UNIFIED IDEOGRAPH-973B
        0x9743, # G+8692  U+9743  uni9743,  CJK UNIFIED IDEOGRAPH-9743
        0x974D, # G+8693  U+974D  uni974D,  CJK UNIFIED IDEOGRAPH-974D
        0x974F, # G+8694  U+974F  uni974F,  CJK UNIFIED IDEOGRAPH-974F
        0x2FAD, # G+8695  U+2FAD  uni2FAD,  KANGXI RADICAL BLUE
        0x9755, # G+8696  U+9755  uni9755,  CJK UNIFIED IDEOGRAPH-9755
        0x9857, # G+8697  U+9857  uni9857,  CJK UNIFIED IDEOGRAPH-9857
        0x9865, # G+8698  U+9865  uni9865,  CJK UNIFIED IDEOGRAPH-9865
        0xFA2A, # G+8699  U+FA2A  uniFA2A,  CJK COMPATIBILITY IDEOGRAPH-FA2A
        0xFA2B, # G+8700  U+FA2B  uniFA2B,  CJK COMPATIBILITY IDEOGRAPH-FA2B
        0x9927, # G+8701  U+9927  uni9927,  CJK UNIFIED IDEOGRAPH-9927
        0xFA2C, # G+8702  U+FA2C  uniFA2C,  CJK COMPATIBILITY IDEOGRAPH-FA2C
        0x999E, # G+8703  U+999E  uni999E,  CJK UNIFIED IDEOGRAPH-999E
        0x9A4E, # G+8704  U+9A4E  uni9A4E,  CJK UNIFIED IDEOGRAPH-9A4E
        0x9AD9, # G+8705  U+9AD9  uni9AD9,  CJK UNIFIED IDEOGRAPH-9AD9
        0x9ADC, # G+8706  U+9ADC  uni9ADC,  CJK UNIFIED IDEOGRAPH-9ADC
        0x9B75, # G+8707  U+9B75  uni9B75,  CJK UNIFIED IDEOGRAPH-9B75
        0x9B72, # G+8708  U+9B72  uni9B72,  CJK UNIFIED IDEOGRAPH-9B72
        0x9B8F, # G+8709  U+9B8F  uni9B8F,  CJK UNIFIED IDEOGRAPH-9B8F
        0x9BB1, # G+8710  U+9BB1  uni9BB1,  CJK UNIFIED IDEOGRAPH-9BB1
        0x9BBB, # G+8711  U+9BBB  uni9BBB,  CJK UNIFIED IDEOGRAPH-9BBB
        0x9C00, # G+8712  U+9C00  uni9C00,  CJK UNIFIED IDEOGRAPH-9C00
        0x9D70, # G+8713  U+9D70  uni9D70,  CJK UNIFIED IDEOGRAPH-9D70
        0x9D6B, # G+8714  U+9D6B  uni9D6B,  CJK UNIFIED IDEOGRAPH-9D6B
        0xFA2D, # G+8715  U+FA2D  uniFA2D,  CJK COMPATIBILITY IDEOGRAPH-FA2D
        0x9E19, # G+8716  U+9E19  uni9E19,  CJK UNIFIED IDEOGRAPH-9E19
        0x9ED1, # G+8717  U+9ED1  uni9ED1,  CJK UNIFIED IDEOGRAPH-9ED1
        0x0000, # G+8718  U+0000  .notdef,  UNDEFINED
        0x005C, # G+8719  U+005C  backslash,  REVERSE SOLIDUS
        0x0000, # G+8720  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8721  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8722  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8723  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8724  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8725  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8726  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8727  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8728  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8729  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8730  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8731  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8732  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8733  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8734  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8735  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8736  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8737  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8738  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8739  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8740  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8741  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8742  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8743  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8744  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8745  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8746  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8747  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8748  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8749  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8750  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8751  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8752  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8753  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8754  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8755  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8756  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8757  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8758  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8759  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8760  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8761  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8762  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8763  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8764  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8765  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8766  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8767  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8768  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8769  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8770  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8771  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8772  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8773  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8774  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8775  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8776  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8777  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8778  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8779  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8780  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8781  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8782  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8783  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8784  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8785  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8786  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8787  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8788  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8789  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8790  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8791  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8792  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8793  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8794  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8795  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8796  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8797  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8798  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8799  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8800  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8801  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8802  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8803  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8804  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8805  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8806  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8807  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8808  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8809  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8810  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8811  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8812  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8813  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8814  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8815  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8816  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8817  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8818  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8819  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8820  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8821  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8822  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8823  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8824  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8825  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8826  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8827  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8828  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8829  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8830  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8831  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8832  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8833  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8834  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8835  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8836  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8837  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8838  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8839  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8840  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8841  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8842  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8843  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8844  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8845  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8846  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8847  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8848  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8849  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8850  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8851  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8852  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8853  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8854  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8855  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8856  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8857  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8858  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8859  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8860  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8861  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8862  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8863  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8864  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8865  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8866  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8867  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8868  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8869  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8870  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8871  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8872  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8873  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8874  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8875  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8876  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8877  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8878  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8879  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8880  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8881  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8882  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8883  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8884  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8885  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8886  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8887  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8888  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8889  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8890  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8891  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8892  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8893  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8894  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8895  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8896  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8897  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8898  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8899  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8900  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8901  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8902  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8903  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8904  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8905  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8906  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8907  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8908  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8909  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8910  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8911  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8912  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8913  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8914  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8915  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8916  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8917  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8918  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8919  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8920  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8921  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8922  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8923  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8924  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8925  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8926  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8927  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8928  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8929  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8930  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8931  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8932  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8933  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8934  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8935  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8936  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8937  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8938  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8939  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8940  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8941  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8942  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8943  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8944  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8945  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8946  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8947  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8948  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8949  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8950  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8951  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8952  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8953  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8954  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8955  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8956  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8957  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8958  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8959  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8960  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8961  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8962  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8963  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8964  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8965  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8966  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8967  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8968  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8969  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8970  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8971  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8972  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8973  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8974  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8975  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8976  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8977  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8978  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8979  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8980  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8981  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8982  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8983  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8984  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8985  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8986  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8987  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8988  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8989  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8990  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8991  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8992  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8993  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8994  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8995  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8996  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8997  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8998  U+0000  .notdef,  UNDEFINED
        0x0000, # G+8999  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9000  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9001  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9002  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9003  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9004  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9005  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9006  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9007  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9008  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9009  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9010  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9011  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9012  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9013  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9014  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9015  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9016  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9017  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9018  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9019  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9020  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9021  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9022  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9023  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9024  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9025  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9026  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9027  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9028  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9029  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9030  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9031  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9032  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9033  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9034  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9035  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9036  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9037  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9038  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9039  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9040  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9041  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9042  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9043  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9044  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9045  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9046  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9047  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9048  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9049  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9050  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9051  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9052  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9053  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9054  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9055  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9056  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9057  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9058  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9059  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9060  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9061  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9062  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9063  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9064  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9065  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9066  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9067  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9068  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9069  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9070  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9071  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9072  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9073  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9074  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9075  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9076  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9077  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9078  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9079  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9080  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9081  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9082  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9083  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9084  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9085  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9086  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9087  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9088  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9089  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9090  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9091  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9092  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9093  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9094  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9095  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9096  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9097  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9098  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9099  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9100  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9101  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9102  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9103  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9104  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9105  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9106  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9107  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9108  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9109  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9110  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9111  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9112  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9113  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9114  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9115  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9116  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9117  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9118  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9119  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9120  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9121  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9122  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9123  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9124  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9125  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9126  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9127  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9128  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9129  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9130  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9131  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9132  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9133  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9134  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9135  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9136  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9137  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9138  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9139  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9140  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9141  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9142  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9143  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9144  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9145  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9146  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9147  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9148  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9149  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9150  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9151  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9152  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9153  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9154  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9155  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9156  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9157  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9158  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9159  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9160  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9161  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9162  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9163  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9164  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9165  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9166  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9167  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9168  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9169  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9170  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9171  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9172  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9173  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9174  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9175  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9176  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9177  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9178  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9179  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9180  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9181  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9182  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9183  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9184  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9185  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9186  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9187  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9188  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9189  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9190  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9191  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9192  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9193  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9194  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9195  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9196  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9197  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9198  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9199  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9200  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9201  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9202  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9203  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9204  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9205  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9206  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9207  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9208  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9209  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9210  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9211  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9212  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9213  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9214  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9215  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9216  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9217  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9218  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9219  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9220  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9221  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9222  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9223  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9224  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9225  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9226  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9227  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9228  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9229  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9230  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9231  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9232  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9233  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9234  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9235  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9236  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9237  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9238  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9239  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9240  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9241  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9242  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9243  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9244  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9245  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9246  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9247  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9248  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9249  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9250  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9251  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9252  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9253  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9254  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9255  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9256  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9257  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9258  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9259  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9260  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9261  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9262  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9263  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9264  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9265  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9266  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9267  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9268  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9269  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9270  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9271  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9272  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9273  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9274  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9275  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9276  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9277  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9278  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9279  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9280  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9281  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9282  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9283  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9284  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9285  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9286  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9287  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9288  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9289  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9290  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9291  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9292  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9293  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9294  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9295  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9296  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9297  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9298  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9299  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9300  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9301  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9302  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9303  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9304  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9305  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9306  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9307  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9308  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9309  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9310  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9311  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9312  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9313  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9314  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9315  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9316  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9317  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9318  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9319  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9320  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9321  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9322  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9323  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9324  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9325  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9326  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9327  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9328  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9329  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9330  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9331  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9332  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9333  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9334  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9335  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9336  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9337  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9338  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9339  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9340  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9341  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9342  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9343  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9344  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9345  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9346  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9347  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9348  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9349  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9350  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9351  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9352  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9353  U+0000  .notdef,  UNDEFINED
        0x20AC, # G+9354  U+20AC  Euro,  EURO SIGN
        0x2126, # G+9355  U+2126  Omega,  OHM SIGN
        0x0000, # G+9356  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9357  U+0000  .notdef,  UNDEFINED
        0xFB00, # G+9358  U+FB00  ff,  LATIN SMALL LIGATURE FF
        0xFB03, # G+9359  U+FB03  ffi,  LATIN SMALL LIGATURE FFI
        0xFB04, # G+9360  U+FB04  ffl,  LATIN SMALL LIGATURE FFL
        0x0101, # G+9361  U+0101  amacron,  LATIN SMALL LETTER A WITH MACRON
        0x012B, # G+9362  U+012B  imacron,  LATIN SMALL LETTER I WITH MACRON
        0x016B, # G+9363  U+016B  umacron,  LATIN SMALL LETTER U WITH MACRON
        0x0113, # G+9364  U+0113  emacron,  LATIN SMALL LETTER E WITH MACRON
        0x014D, # G+9365  U+014D  omacron,  LATIN SMALL LETTER O WITH MACRON
        0x0100, # G+9366  U+0100  Amacron,  LATIN CAPITAL LETTER A WITH MACRON
        0x012A, # G+9367  U+012A  Imacron,  LATIN CAPITAL LETTER I WITH MACRON
        0x016A, # G+9368  U+016A  Umacron,  LATIN CAPITAL LETTER U WITH MACRON
        0x0112, # G+9369  U+0112  Emacron,  LATIN CAPITAL LETTER E WITH MACRON
        0x014C, # G+9370  U+014C  Omacron,  LATIN CAPITAL LETTER O WITH MACRON
        0x215B, # G+9371  U+215B  oneeighth,  VULGAR FRACTION ONE EIGHTH
        0x215C, # G+9372  U+215C  threeeighths,  VULGAR FRACTION THREE EIGHTHS
        0x215D, # G+9373  U+215D  fiveeighths,  VULGAR FRACTION FIVE EIGHTHS
        0x215E, # G+9374  U+215E  seveneighths,  VULGAR FRACTION SEVEN EIGHTHS
        0x2153, # G+9375  U+2153  onethird,  VULGAR FRACTION ONE THIRD
        0x2154, # G+9376  U+2154  twothirds,  VULGAR FRACTION TWO THIRDS
        0x2070, # G+9377  U+2070  zerosuperior,  SUPERSCRIPT ZERO
        0x2074, # G+9378  U+2074  foursuperior,  SUPERSCRIPT FOUR
        0x2075, # G+9379  U+2075  fivesuperior,  SUPERSCRIPT FIVE
        0x2076, # G+9380  U+2076  sixsuperior,  SUPERSCRIPT SIX
        0x2077, # G+9381  U+2077  sevensuperior,  SUPERSCRIPT SEVEN
        0x2078, # G+9382  U+2078  eightsuperior,  SUPERSCRIPT EIGHT
        0x2079, # G+9383  U+2079  ninesuperior,  SUPERSCRIPT NINE
        0x2080, # G+9384  U+2080  zeroinferior,  SUBSCRIPT ZERO
        0x2081, # G+9385  U+2081  oneinferior,  SUBSCRIPT ONE
        0x2082, # G+9386  U+2082  twoinferior,  SUBSCRIPT TWO
        0x2083, # G+9387  U+2083  threeinferior,  SUBSCRIPT THREE
        0x2084, # G+9388  U+2084  fourinferior,  SUBSCRIPT FOUR
        0x2085, # G+9389  U+2085  fiveinferior,  SUBSCRIPT FIVE
        0x2086, # G+9390  U+2086  sixinferior,  SUBSCRIPT SIX
        0x2087, # G+9391  U+2087  seveninferior,  SUBSCRIPT SEVEN
        0x2088, # G+9392  U+2088  eightinferior,  SUBSCRIPT EIGHT
        0x2089, # G+9393  U+2089  nineinferior,  SUBSCRIPT NINE
        0x01CD, # G+9394  U+01CD  uni01CD,  LATIN CAPITAL LETTER A WITH CARON
        0x011A, # G+9395  U+011A  Ecaron,  LATIN CAPITAL LETTER E WITH CARON
        0x0000, # G+9396  U+0000  .notdef,  UNDEFINED
        0x1EBC, # G+9397  U+1EBC  uni1EBC,  LATIN CAPITAL LETTER E WITH TILDE
        0x01CF, # G+9398  U+01CF  uni01CF,  LATIN CAPITAL LETTER I WITH CARON
        0x0000, # G+9399  U+0000  .notdef,  UNDEFINED
        0x0128, # G+9400  U+0128  Itilde,  LATIN CAPITAL LETTER I WITH TILDE
        0x01D1, # G+9401  U+01D1  uni01D1,  LATIN CAPITAL LETTER O WITH CARON
        0x0000, # G+9402  U+0000  .notdef,  UNDEFINED
        0x01D3, # G+9403  U+01D3  uni01D3,  LATIN CAPITAL LETTER U WITH CARON
        0x016E, # G+9404  U+016E  Uring,  LATIN CAPITAL LETTER U WITH RING ABOVE
        0x0168, # G+9405  U+0168  Utilde,  LATIN CAPITAL LETTER U WITH TILDE
        0x01CE, # G+9406  U+01CE  uni01CE,  LATIN SMALL LETTER A WITH CARON
        0x011B, # G+9407  U+011B  ecaron,  LATIN SMALL LETTER E WITH CARON
        0x0000, # G+9408  U+0000  .notdef,  UNDEFINED
        0x1EBD, # G+9409  U+1EBD  uni1EBD,  LATIN SMALL LETTER E WITH TILDE
        0x01D0, # G+9410  U+01D0  uni01D0,  LATIN SMALL LETTER I WITH CARON
        0x0000, # G+9411  U+0000  .notdef,  UNDEFINED
        0x0129, # G+9412  U+0129  itilde,  LATIN SMALL LETTER I WITH TILDE
        0x01D2, # G+9413  U+01D2  uni01D2,  LATIN SMALL LETTER O WITH CARON
        0x0000, # G+9414  U+0000  .notdef,  UNDEFINED
        0x01D4, # G+9415  U+01D4  uni01D4,  LATIN SMALL LETTER U WITH CARON
        0x016F, # G+9416  U+016F  uring,  LATIN SMALL LETTER U WITH RING ABOVE
        0x0169, # G+9417  U+0169  utilde,  LATIN SMALL LETTER U WITH TILDE
        0x0251, # G+9418  U+0251  uni0251,  LATIN SMALL LETTER ALPHA
        0x0000, # G+9419  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9420  U+0000  .notdef,  UNDEFINED
        0x01FD, # G+9421  U+01FD  aeacute,  LATIN SMALL LETTER AE WITH ACUTE
        0x0000, # G+9422  U+0000  .notdef,  UNDEFINED
        0x0254, # G+9423  U+0254  uni0254,  LATIN SMALL LETTER OPEN O
        0x0000, # G+9424  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9425  U+0000  .notdef,  UNDEFINED
        0x0259, # G+9426  U+0259  uni0259,  LATIN SMALL LETTER SCHWA
        0x0000, # G+9427  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9428  U+0000  .notdef,  UNDEFINED
        0x025A, # G+9429  U+025A  uni025A,  LATIN SMALL LETTER SCHWA WITH HOOK
        0x0000, # G+9430  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9431  U+0000  .notdef,  UNDEFINED
        0x025B, # G+9432  U+025B  uni025B,  LATIN SMALL LETTER OPEN E
        0x0000, # G+9433  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9434  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9435  U+0000  .notdef,  UNDEFINED
        0x014B, # G+9436  U+014B  eng,  LATIN SMALL LETTER ENG
        0x0275, # G+9437  U+0275  uni0275,  LATIN SMALL LETTER BARRED O
        0x028C, # G+9438  U+028C  uni028C,  LATIN SMALL LETTER TURNED V
        0x0000, # G+9439  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9440  U+0000  .notdef,  UNDEFINED
        0x0292, # G+9441  U+0292  uni0292,  LATIN SMALL LETTER EZH
        0x0283, # G+9442  U+0283  uni0283,  LATIN SMALL LETTER ESH
        0x02D0, # G+9443  U+02D0  uni02D0,  MODIFIER LETTER TRIANGULAR COLON
        0x0000, # G+9444  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9445  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9446  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9447  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9448  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9449  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9450  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9451  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9452  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9453  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9454  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9455  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9456  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9457  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9458  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9459  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9460  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9461  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9462  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9463  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9464  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9465  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9466  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9467  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9468  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9469  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9470  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9471  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9472  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9473  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9474  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9475  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9476  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9477  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9478  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9479  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9480  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9481  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9482  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9483  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9484  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9485  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9486  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9487  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9488  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9489  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9490  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9491  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9492  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9493  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9494  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9495  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9496  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9497  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9498  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9499  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9500  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9501  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9502  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9503  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9504  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9505  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9506  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9507  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9508  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9509  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9510  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9511  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9512  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9513  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9514  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9515  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9516  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9517  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9518  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9519  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9520  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9521  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9522  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9523  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9524  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9525  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9526  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9527  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9528  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9529  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9530  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9531  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9532  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9533  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9534  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9535  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9536  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9537  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9538  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9539  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9540  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9541  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9542  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9543  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9544  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9545  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9546  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9547  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9548  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9549  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9550  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9551  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9552  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9553  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9554  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9555  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9556  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9557  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9558  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9559  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9560  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9561  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9562  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9563  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9564  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9565  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9566  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9567  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9568  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9569  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9570  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9571  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9572  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9573  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9574  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9575  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9576  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9577  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9578  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9579  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9580  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9581  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9582  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9583  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9584  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9585  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9586  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9587  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9588  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9589  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9590  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9591  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9592  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9593  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9594  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9595  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9596  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9597  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9598  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9599  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9600  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9601  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9602  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9603  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9604  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9605  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9606  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9607  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9608  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9609  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9610  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9611  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9612  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9613  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9614  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9615  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9616  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9617  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9618  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9619  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9620  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9621  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9622  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9623  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9624  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9625  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9626  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9627  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9628  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9629  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9630  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9631  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9632  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9633  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9634  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9635  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9636  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9637  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9638  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9639  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9640  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9641  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9642  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9643  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9644  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9645  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9646  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9647  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9648  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9649  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9650  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9651  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9652  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9653  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9654  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9655  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9656  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9657  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9658  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9659  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9660  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9661  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9662  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9663  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9664  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9665  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9666  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9667  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9668  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9669  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9670  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9671  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9672  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9673  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9674  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9675  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9676  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9677  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9678  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9679  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9680  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9681  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9682  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9683  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9684  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9685  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9686  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9687  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9688  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9689  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9690  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9691  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9692  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9693  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9694  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9695  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9696  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9697  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9698  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9699  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9700  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9701  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9702  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9703  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9704  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9705  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9706  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9707  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9708  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9709  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9710  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9711  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9712  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9713  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9714  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9715  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9716  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9717  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9718  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9719  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9720  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9721  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9722  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9723  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9724  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9725  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9726  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9727  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9728  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9729  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9730  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9731  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9732  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9733  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9734  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9735  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9736  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9737  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9738  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9739  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9740  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9741  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9742  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9743  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9744  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9745  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9746  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9747  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9748  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9749  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9750  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9751  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9752  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9753  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9754  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9755  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9756  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9757  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9758  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9759  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9760  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9761  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9762  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9763  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9764  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9765  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9766  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9767  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9768  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9769  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9770  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9771  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9772  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9773  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9774  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9775  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9776  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9777  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9778  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9779  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9780  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9781  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9782  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9783  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9784  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9785  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9786  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9787  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9788  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9789  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9790  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9791  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9792  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9793  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9794  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9795  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9796  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9797  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9798  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9799  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9800  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9801  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9802  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9803  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9804  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9805  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9806  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9807  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9808  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9809  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9810  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9811  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9812  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9813  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9814  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9815  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9816  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9817  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9818  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9819  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9820  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9821  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9822  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9823  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9824  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9825  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9826  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9827  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9828  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9829  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9830  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9831  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9832  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9833  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9834  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9835  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9836  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9837  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9838  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9839  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9840  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9841  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9842  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9843  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9844  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9845  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9846  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9847  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9848  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9849  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9850  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9851  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9852  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9853  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9854  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9855  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9856  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9857  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9858  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9859  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9860  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9861  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9862  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9863  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9864  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9865  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9866  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9867  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9868  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9869  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9870  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9871  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9872  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9873  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9874  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9875  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9876  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9877  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9878  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9879  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9880  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9881  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9882  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9883  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9884  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9885  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9886  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9887  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9888  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9889  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9890  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9891  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9892  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9893  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9894  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9895  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9896  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9897  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9898  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9899  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9900  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9901  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9902  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9903  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9904  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9905  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9906  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9907  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9908  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9909  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9910  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9911  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9912  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9913  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9914  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9915  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9916  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9917  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9918  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9919  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9920  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9921  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9922  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9923  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9924  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9925  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9926  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9927  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9928  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9929  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9930  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9931  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9932  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9933  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9934  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9935  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9936  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9937  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9938  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9939  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9940  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9941  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9942  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9943  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9944  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9945  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9946  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9947  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9948  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9949  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9950  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9951  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9952  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9953  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9954  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9955  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9956  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9957  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9958  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9959  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9960  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9961  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9962  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9963  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9964  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9965  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9966  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9967  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9968  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9969  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9970  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9971  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9972  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9973  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9974  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9975  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9976  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9977  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9978  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9979  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9980  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9981  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9982  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9983  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9984  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9985  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9986  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9987  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9988  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9989  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9990  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9991  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9992  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9993  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9994  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9995  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9996  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9997  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9998  U+0000  .notdef,  UNDEFINED
        0x0000, # G+9999  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10000  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10001  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10002  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10003  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10004  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10005  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10006  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10007  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10008  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10009  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10010  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10011  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10012  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10013  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10014  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10015  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10016  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10017  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10018  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10019  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10020  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10021  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10022  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10023  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10024  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10025  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10026  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10027  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10028  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10029  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10030  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10031  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10032  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10033  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10034  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10035  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10036  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10037  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10038  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10039  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10040  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10041  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10042  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10043  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10044  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10045  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10046  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10047  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10048  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10049  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10050  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10051  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10052  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10053  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10054  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10055  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10056  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10057  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10058  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10059  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10060  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10061  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10062  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10063  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10064  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10065  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10066  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10067  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10068  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10069  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10070  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10071  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10072  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10073  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10074  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10075  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10076  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10077  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10078  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10079  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10080  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10081  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10082  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10083  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10084  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10085  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10086  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10087  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10088  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10089  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10090  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10091  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10092  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10093  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10094  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10095  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10096  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10097  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10098  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10099  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10100  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10101  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10102  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10103  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10104  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10105  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10106  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10107  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10108  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10109  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10110  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10111  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10112  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10113  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10114  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10115  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10116  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10117  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10118  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10119  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10120  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10121  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10122  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10123  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10124  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10125  U+0000  .notdef,  UNDEFINED
        0x3220, # G+10126  U+3220  uni3220,  PARENTHESIZED IDEOGRAPH ONE
        0x3221, # G+10127  U+3221  uni3221,  PARENTHESIZED IDEOGRAPH TWO
        0x3222, # G+10128  U+3222  uni3222,  PARENTHESIZED IDEOGRAPH THREE
        0x3223, # G+10129  U+3223  uni3223,  PARENTHESIZED IDEOGRAPH FOUR
        0x3224, # G+10130  U+3224  uni3224,  PARENTHESIZED IDEOGRAPH FIVE
        0x3225, # G+10131  U+3225  uni3225,  PARENTHESIZED IDEOGRAPH SIX
        0x3226, # G+10132  U+3226  uni3226,  PARENTHESIZED IDEOGRAPH SEVEN
        0x3227, # G+10133  U+3227  uni3227,  PARENTHESIZED IDEOGRAPH EIGHT
        0x3228, # G+10134  U+3228  uni3228,  PARENTHESIZED IDEOGRAPH NINE
        0x3229, # G+10135  U+3229  uni3229,  PARENTHESIZED IDEOGRAPH TEN
        0x0000, # G+10136  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10137  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10138  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10139  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10140  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10141  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10142  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10143  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10144  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10145  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10146  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10147  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10148  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10149  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10150  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10151  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10152  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10153  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10154  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10155  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10156  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10157  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10158  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10159  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10160  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10161  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10162  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10163  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10164  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10165  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10166  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10167  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10168  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10169  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10170  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10171  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10172  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10173  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10174  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10175  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10176  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10177  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10178  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10179  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10180  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10181  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10182  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10183  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10184  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10185  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10186  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10187  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10188  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10189  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10190  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10191  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10192  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10193  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10194  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10195  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10196  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10197  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10198  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10199  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10200  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10201  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10202  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10203  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10204  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10205  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10206  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10207  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10208  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10209  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10210  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10211  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10212  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10213  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10214  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10215  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10216  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10217  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10218  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10219  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10220  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10221  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10222  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10223  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10224  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10225  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10226  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10227  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10228  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10229  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10230  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10231  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10232  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10233  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10234  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10235  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10236  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10237  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10238  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10239  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10240  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10241  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10242  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10243  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10244  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10245  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10246  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10247  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10248  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10249  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10250  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10251  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10252  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10253  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10254  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10255  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10256  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10257  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10258  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10259  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10260  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10261  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10262  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10263  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10264  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10265  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10266  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10267  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10268  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10269  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10270  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10271  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10272  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10273  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10274  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10275  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10276  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10277  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10278  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10279  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10280  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10281  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10282  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10283  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10284  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10285  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10286  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10287  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10288  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10289  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10290  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10291  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10292  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10293  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10294  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10295  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10296  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10297  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10298  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10299  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10300  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10301  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10302  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10303  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10304  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10305  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10306  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10307  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10308  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10309  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10310  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10311  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10312  U+0000  .notdef,  UNDEFINED
        0x24D0, # G+10313  U+24D0  uni24D0,  CIRCLED LATIN SMALL LETTER A
        0x24D1, # G+10314  U+24D1  uni24D1,  CIRCLED LATIN SMALL LETTER B
        0x24D2, # G+10315  U+24D2  uni24D2,  CIRCLED LATIN SMALL LETTER C
        0x24D3, # G+10316  U+24D3  uni24D3,  CIRCLED LATIN SMALL LETTER D
        0x24D4, # G+10317  U+24D4  uni24D4,  CIRCLED LATIN SMALL LETTER E
        0x24D5, # G+10318  U+24D5  uni24D5,  CIRCLED LATIN SMALL LETTER F
        0x24D6, # G+10319  U+24D6  uni24D6,  CIRCLED LATIN SMALL LETTER G
        0x24D7, # G+10320  U+24D7  uni24D7,  CIRCLED LATIN SMALL LETTER H
        0x24D8, # G+10321  U+24D8  uni24D8,  CIRCLED LATIN SMALL LETTER I
        0x24D9, # G+10322  U+24D9  uni24D9,  CIRCLED LATIN SMALL LETTER J
        0x24DA, # G+10323  U+24DA  uni24DA,  CIRCLED LATIN SMALL LETTER K
        0x24DB, # G+10324  U+24DB  uni24DB,  CIRCLED LATIN SMALL LETTER L
        0x24DC, # G+10325  U+24DC  uni24DC,  CIRCLED LATIN SMALL LETTER M
        0x24DD, # G+10326  U+24DD  uni24DD,  CIRCLED LATIN SMALL LETTER N
        0x24DE, # G+10327  U+24DE  uni24DE,  CIRCLED LATIN SMALL LETTER O
        0x24DF, # G+10328  U+24DF  uni24DF,  CIRCLED LATIN SMALL LETTER P
        0x24E0, # G+10329  U+24E0  uni24E0,  CIRCLED LATIN SMALL LETTER Q
        0x24E1, # G+10330  U+24E1  uni24E1,  CIRCLED LATIN SMALL LETTER R
        0x24E2, # G+10331  U+24E2  uni24E2,  CIRCLED LATIN SMALL LETTER S
        0x24E3, # G+10332  U+24E3  uni24E3,  CIRCLED LATIN SMALL LETTER T
        0x24E4, # G+10333  U+24E4  uni24E4,  CIRCLED LATIN SMALL LETTER U
        0x24E5, # G+10334  U+24E5  uni24E5,  CIRCLED LATIN SMALL LETTER V
        0x24E6, # G+10335  U+24E6  uni24E6,  CIRCLED LATIN SMALL LETTER W
        0x24E7, # G+10336  U+24E7  uni24E7,  CIRCLED LATIN SMALL LETTER X
        0x24E8, # G+10337  U+24E8  uni24E8,  CIRCLED LATIN SMALL LETTER Y
        0x24E9, # G+10338  U+24E9  uni24E9,  CIRCLED LATIN SMALL LETTER Z
        0x24B6, # G+10339  U+24B6  uni24B6,  CIRCLED LATIN CAPITAL LETTER A
        0x24B7, # G+10340  U+24B7  uni24B7,  CIRCLED LATIN CAPITAL LETTER B
        0x24B8, # G+10341  U+24B8  uni24B8,  CIRCLED LATIN CAPITAL LETTER C
        0x24B9, # G+10342  U+24B9  uni24B9,  CIRCLED LATIN CAPITAL LETTER D
        0x24BA, # G+10343  U+24BA  uni24BA,  CIRCLED LATIN CAPITAL LETTER E
        0x24BB, # G+10344  U+24BB  uni24BB,  CIRCLED LATIN CAPITAL LETTER F
        0x24BC, # G+10345  U+24BC  uni24BC,  CIRCLED LATIN CAPITAL LETTER G
        0x24BD, # G+10346  U+24BD  uni24BD,  CIRCLED LATIN CAPITAL LETTER H
        0x24BE, # G+10347  U+24BE  uni24BE,  CIRCLED LATIN CAPITAL LETTER I
        0x24BF, # G+10348  U+24BF  uni24BF,  CIRCLED LATIN CAPITAL LETTER J
        0x24C0, # G+10349  U+24C0  uni24C0,  CIRCLED LATIN CAPITAL LETTER K
        0x24C1, # G+10350  U+24C1  uni24C1,  CIRCLED LATIN CAPITAL LETTER L
        0x24C2, # G+10351  U+24C2  uni24C2,  CIRCLED LATIN CAPITAL LETTER M
        0x24C3, # G+10352  U+24C3  uni24C3,  CIRCLED LATIN CAPITAL LETTER N
        0x24C4, # G+10353  U+24C4  uni24C4,  CIRCLED LATIN CAPITAL LETTER O
        0x24C5, # G+10354  U+24C5  uni24C5,  CIRCLED LATIN CAPITAL LETTER P
        0x24C6, # G+10355  U+24C6  uni24C6,  CIRCLED LATIN CAPITAL LETTER Q
        0x24C7, # G+10356  U+24C7  uni24C7,  CIRCLED LATIN CAPITAL LETTER R
        0x24C8, # G+10357  U+24C8  uni24C8,  CIRCLED LATIN CAPITAL LETTER S
        0x24C9, # G+10358  U+24C9  uni24C9,  CIRCLED LATIN CAPITAL LETTER T
        0x24CA, # G+10359  U+24CA  uni24CA,  CIRCLED LATIN CAPITAL LETTER U
        0x24CB, # G+10360  U+24CB  uni24CB,  CIRCLED LATIN CAPITAL LETTER V
        0x24CC, # G+10361  U+24CC  uni24CC,  CIRCLED LATIN CAPITAL LETTER W
        0x24CD, # G+10362  U+24CD  uni24CD,  CIRCLED LATIN CAPITAL LETTER X
        0x24CE, # G+10363  U+24CE  uni24CE,  CIRCLED LATIN CAPITAL LETTER Y
        0x24CF, # G+10364  U+24CF  uni24CF,  CIRCLED LATIN CAPITAL LETTER Z
        0x0000, # G+10365  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10366  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10367  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10368  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10369  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10370  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10371  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10372  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10373  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10374  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10375  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10376  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10377  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10378  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10379  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10380  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10381  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10382  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10383  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10384  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10385  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10386  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10387  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10388  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10389  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10390  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10391  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10392  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10393  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10394  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10395  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10396  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10397  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10398  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10399  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10400  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10401  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10402  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10403  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10404  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10405  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10406  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10407  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10408  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10409  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10410  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10411  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10412  U+0000  .notdef,  UNDEFINED
        0x32D0, # G+10413  U+32D0  uni32D0,  CIRCLED KATAKANA A
        0x32D1, # G+10414  U+32D1  uni32D1,  CIRCLED KATAKANA I
        0x32D2, # G+10415  U+32D2  uni32D2,  CIRCLED KATAKANA U
        0x32D3, # G+10416  U+32D3  uni32D3,  CIRCLED KATAKANA E
        0x32D4, # G+10417  U+32D4  uni32D4,  CIRCLED KATAKANA O
        0x32D5, # G+10418  U+32D5  uni32D5,  CIRCLED KATAKANA KA
        0x32D6, # G+10419  U+32D6  uni32D6,  CIRCLED KATAKANA KI
        0x32D7, # G+10420  U+32D7  uni32D7,  CIRCLED KATAKANA KU
        0x32D8, # G+10421  U+32D8  uni32D8,  CIRCLED KATAKANA KE
        0x32D9, # G+10422  U+32D9  uni32D9,  CIRCLED KATAKANA KO
        0x32DA, # G+10423  U+32DA  uni32DA,  CIRCLED KATAKANA SA
        0x32DB, # G+10424  U+32DB  uni32DB,  CIRCLED KATAKANA SI
        0x32DC, # G+10425  U+32DC  uni32DC,  CIRCLED KATAKANA SU
        0x32DD, # G+10426  U+32DD  uni32DD,  CIRCLED KATAKANA SE
        0x32DE, # G+10427  U+32DE  uni32DE,  CIRCLED KATAKANA SO
        0x32DF, # G+10428  U+32DF  uni32DF,  CIRCLED KATAKANA TA
        0x32E0, # G+10429  U+32E0  uni32E0,  CIRCLED KATAKANA TI
        0x32E1, # G+10430  U+32E1  uni32E1,  CIRCLED KATAKANA TU
        0x32E2, # G+10431  U+32E2  uni32E2,  CIRCLED KATAKANA TE
        0x32E3, # G+10432  U+32E3  uni32E3,  CIRCLED KATAKANA TO
        0x32E4, # G+10433  U+32E4  uni32E4,  CIRCLED KATAKANA NA
        0x32E5, # G+10434  U+32E5  uni32E5,  CIRCLED KATAKANA NI
        0x32E6, # G+10435  U+32E6  uni32E6,  CIRCLED KATAKANA NU
        0x32E7, # G+10436  U+32E7  uni32E7,  CIRCLED KATAKANA NE
        0x32E8, # G+10437  U+32E8  uni32E8,  CIRCLED KATAKANA NO
        0x32E9, # G+10438  U+32E9  uni32E9,  CIRCLED KATAKANA HA
        0x32EA, # G+10439  U+32EA  uni32EA,  CIRCLED KATAKANA HI
        0x32EB, # G+10440  U+32EB  uni32EB,  CIRCLED KATAKANA HU
        0x32EC, # G+10441  U+32EC  uni32EC,  CIRCLED KATAKANA HE
        0x32ED, # G+10442  U+32ED  uni32ED,  CIRCLED KATAKANA HO
        0x32EE, # G+10443  U+32EE  uni32EE,  CIRCLED KATAKANA MA
        0x32EF, # G+10444  U+32EF  uni32EF,  CIRCLED KATAKANA MI
        0x32F0, # G+10445  U+32F0  uni32F0,  CIRCLED KATAKANA MU
        0x32F1, # G+10446  U+32F1  uni32F1,  CIRCLED KATAKANA ME
        0x32F2, # G+10447  U+32F2  uni32F2,  CIRCLED KATAKANA MO
        0x32F3, # G+10448  U+32F3  uni32F3,  CIRCLED KATAKANA YA
        0x32F4, # G+10449  U+32F4  uni32F4,  CIRCLED KATAKANA YU
        0x32F5, # G+10450  U+32F5  uni32F5,  CIRCLED KATAKANA YO
        0x32F6, # G+10451  U+32F6  uni32F6,  CIRCLED KATAKANA RA
        0x32F7, # G+10452  U+32F7  uni32F7,  CIRCLED KATAKANA RI
        0x32F8, # G+10453  U+32F8  uni32F8,  CIRCLED KATAKANA RU
        0x32F9, # G+10454  U+32F9  uni32F9,  CIRCLED KATAKANA RE
        0x32FA, # G+10455  U+32FA  uni32FA,  CIRCLED KATAKANA RO
        0x32FB, # G+10456  U+32FB  uni32FB,  CIRCLED KATAKANA WA
        0x32FC, # G+10457  U+32FC  uni32FC,  CIRCLED KATAKANA WI
        0x32FD, # G+10458  U+32FD  uni32FD,  CIRCLED KATAKANA WE
        0x32FE, # G+10459  U+32FE  uni32FE,  CIRCLED KATAKANA WO
        0x0000, # G+10460  U+0000  .notdef,  UNDEFINED
        0x3280, # G+10461  U+3280  uni3280,  CIRCLED IDEOGRAPH ONE
        0x3281, # G+10462  U+3281  uni3281,  CIRCLED IDEOGRAPH TWO
        0x3282, # G+10463  U+3282  uni3282,  CIRCLED IDEOGRAPH THREE
        0x3283, # G+10464  U+3283  uni3283,  CIRCLED IDEOGRAPH FOUR
        0x3284, # G+10465  U+3284  uni3284,  CIRCLED IDEOGRAPH FIVE
        0x3285, # G+10466  U+3285  uni3285,  CIRCLED IDEOGRAPH SIX
        0x3286, # G+10467  U+3286  uni3286,  CIRCLED IDEOGRAPH SEVEN
        0x3287, # G+10468  U+3287  uni3287,  CIRCLED IDEOGRAPH EIGHT
        0x3288, # G+10469  U+3288  uni3288,  CIRCLED IDEOGRAPH NINE
        0x3289, # G+10470  U+3289  uni3289,  CIRCLED IDEOGRAPH TEN
        0x3290, # G+10471  U+3290  uni3290,  CIRCLED IDEOGRAPH SUN
        0x328A, # G+10472  U+328A  uni328A,  CIRCLED IDEOGRAPH MOON
        0x328B, # G+10473  U+328B  uni328B,  CIRCLED IDEOGRAPH FIRE
        0x328C, # G+10474  U+328C  uni328C,  CIRCLED IDEOGRAPH WATER
        0x328D, # G+10475  U+328D  uni328D,  CIRCLED IDEOGRAPH WOOD
        0x328E, # G+10476  U+328E  uni328E,  CIRCLED IDEOGRAPH METAL
        0x328F, # G+10477  U+328F  uni328F,  CIRCLED IDEOGRAPH EARTH
        0x0000, # G+10478  U+0000  .notdef,  UNDEFINED
        0x329F, # G+10479  U+329F  uni329F,  CIRCLED IDEOGRAPH ATTENTION
        0x0000, # G+10480  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10481  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10482  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10483  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10484  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10485  U+0000  .notdef,  UNDEFINED
        0x32A0, # G+10486  U+32A0  uni32A0,  CIRCLED IDEOGRAPH ITEM
        0x32A1, # G+10487  U+32A1  uni32A1,  CIRCLED IDEOGRAPH REST
        0x329B, # G+10488  U+329B  uni329B,  CIRCLED IDEOGRAPH FEMALE
        0x329A, # G+10489  U+329A  uni329A,  CIRCLED IDEOGRAPH MALE
        0x32A3, # G+10490  U+32A3  uni32A3,  CIRCLED IDEOGRAPH CORRECT
        0x32A2, # G+10491  U+32A2  uni32A2,  CIRCLED IDEOGRAPH COPY
        0x3297, # G+10492  U+3297  uni3297,  CIRCLED IDEOGRAPH CONGRATULATION
        0x0000, # G+10493  U+0000  .notdef,  UNDEFINED
        0x329C, # G+10494  U+329C  uni329C,  CIRCLED IDEOGRAPH SUITABLE
        0x3295, # G+10495  U+3295  uni3295,  CIRCLED IDEOGRAPH SPECIAL
        0x0000, # G+10496  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10497  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10498  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10499  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10500  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10501  U+0000  .notdef,  UNDEFINED
        0x25CC, # G+10502  U+25CC  uni25CC,  DOTTED CIRCLE
        0x0000, # G+10503  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10504  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10505  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10506  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10507  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10508  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10509  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10510  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10511  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10512  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10513  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10514  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10515  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10516  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10517  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10518  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10519  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10520  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10521  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10522  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10523  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10524  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10525  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10526  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10527  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10528  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10529  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10530  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10531  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10532  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10533  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10534  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10535  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10536  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10537  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10538  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10539  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10540  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10541  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10542  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10543  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10544  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10545  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10546  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10547  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10548  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10549  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10550  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10551  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10552  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10553  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10554  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10555  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10556  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10557  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10558  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10559  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10560  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10561  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10562  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10563  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10564  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10565  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10566  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10567  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10568  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10569  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10570  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10571  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10572  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10573  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10574  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10575  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10576  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10577  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10578  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10579  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10580  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10581  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10582  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10583  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10584  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10585  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10586  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10587  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10588  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10589  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10590  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10591  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10592  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10593  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10594  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10595  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10596  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10597  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10598  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10599  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10600  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10601  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10602  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10603  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10604  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10605  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10606  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10607  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10608  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10609  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10610  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10611  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10612  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10613  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10614  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10615  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10616  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10617  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10618  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10619  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10620  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10621  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10622  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10623  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10624  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10625  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10626  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10627  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10628  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10629  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10630  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10631  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10632  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10633  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10634  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10635  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10636  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10637  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10638  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10639  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10640  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10641  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10642  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10643  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10644  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10645  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10646  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10647  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10648  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10649  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10650  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10651  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10652  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10653  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10654  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10655  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10656  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10657  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10658  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10659  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10660  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10661  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10662  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10663  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10664  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10665  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10666  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10667  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10668  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10669  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10670  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10671  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10672  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10673  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10674  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10675  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10676  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10677  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10678  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10679  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10680  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10681  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10682  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10683  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10684  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10685  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10686  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10687  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10688  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10689  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10690  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10691  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10692  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10693  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10694  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10695  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10696  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10697  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10698  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10699  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10700  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10701  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10702  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10703  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10704  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10705  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10706  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10707  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10708  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10709  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10710  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10711  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10712  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10713  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10714  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10715  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10716  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10717  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10718  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10719  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10720  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10721  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10722  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10723  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10724  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10725  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10726  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10727  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10728  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10729  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10730  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10731  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10732  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10733  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10734  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10735  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10736  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10737  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10738  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10739  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10740  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10741  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10742  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10743  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10744  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10745  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10746  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10747  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10748  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10749  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10750  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10751  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10752  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10753  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10754  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10755  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10756  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10757  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10758  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10759  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10760  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10761  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10762  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10763  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10764  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10765  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10766  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10767  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10768  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10769  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10770  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10771  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10772  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10773  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10774  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10775  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10776  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10777  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10778  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10779  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10780  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10781  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10782  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10783  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10784  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10785  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10786  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10787  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10788  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10789  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10790  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10791  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10792  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10793  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10794  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10795  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10796  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10797  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10798  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10799  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10800  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10801  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10802  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10803  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10804  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10805  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10806  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10807  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10808  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10809  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10810  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10811  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10812  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10813  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10814  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10815  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10816  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10817  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10818  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10819  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10820  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10821  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10822  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10823  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10824  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10825  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10826  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10827  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10828  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10829  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10830  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10831  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10832  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10833  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10834  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10835  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10836  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10837  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10838  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10839  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10840  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10841  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10842  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10843  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10844  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10845  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10846  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10847  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10848  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10849  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10850  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10851  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10852  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10853  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10854  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10855  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10856  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10857  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10858  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10859  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10860  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10861  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10862  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10863  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10864  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10865  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10866  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10867  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10868  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10869  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10870  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10871  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10872  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10873  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10874  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10875  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10876  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10877  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10878  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10879  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10880  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10881  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10882  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10883  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10884  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10885  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10886  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10887  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10888  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10889  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10890  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10891  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10892  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10893  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10894  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10895  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10896  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10897  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10898  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10899  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10900  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10901  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10902  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10903  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10904  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10905  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10906  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10907  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10908  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10909  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10910  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10911  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10912  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10913  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10914  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10915  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10916  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10917  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10918  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10919  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10920  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10921  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10922  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10923  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10924  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10925  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10926  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10927  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10928  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10929  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10930  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10931  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10932  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10933  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10934  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10935  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10936  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10937  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10938  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10939  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10940  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10941  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10942  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10943  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10944  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10945  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10946  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10947  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10948  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10949  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10950  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10951  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10952  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10953  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10954  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10955  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10956  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10957  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10958  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10959  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10960  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10961  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10962  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10963  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10964  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10965  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10966  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10967  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10968  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10969  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10970  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10971  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10972  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10973  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10974  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10975  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10976  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10977  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10978  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10979  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10980  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10981  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10982  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10983  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10984  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10985  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10986  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10987  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10988  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10989  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10990  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10991  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10992  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10993  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10994  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10995  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10996  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10997  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10998  U+0000  .notdef,  UNDEFINED
        0x0000, # G+10999  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11000  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11001  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11002  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11003  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11004  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11005  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11006  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11007  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11008  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11009  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11010  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11011  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11012  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11013  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11014  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11015  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11016  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11017  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11018  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11019  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11020  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11021  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11022  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11023  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11024  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11025  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11026  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11027  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11028  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11029  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11030  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11031  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11032  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11033  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11034  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11035  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11036  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11037  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11038  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11039  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11040  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11041  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11042  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11043  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11044  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11045  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11046  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11047  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11048  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11049  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11050  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11051  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11052  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11053  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11054  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11055  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11056  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11057  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11058  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11059  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11060  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11061  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11062  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11063  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11064  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11065  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11066  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11067  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11068  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11069  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11070  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11071  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11072  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11073  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11074  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11075  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11076  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11077  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11078  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11079  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11080  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11081  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11082  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11083  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11084  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11085  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11086  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11087  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11088  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11089  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11090  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11091  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11092  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11093  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11094  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11095  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11096  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11097  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11098  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11099  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11100  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11101  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11102  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11103  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11104  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11105  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11106  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11107  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11108  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11109  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11110  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11111  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11112  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11113  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11114  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11115  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11116  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11117  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11118  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11119  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11120  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11121  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11122  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11123  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11124  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11125  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11126  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11127  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11128  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11129  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11130  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11131  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11132  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11133  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11134  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11135  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11136  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11137  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11138  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11139  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11140  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11141  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11142  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11143  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11144  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11145  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11146  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11147  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11148  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11149  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11150  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11151  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11152  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11153  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11154  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11155  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11156  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11157  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11158  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11159  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11160  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11161  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11162  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11163  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11164  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11165  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11166  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11167  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11168  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11169  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11170  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11171  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11172  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11173  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11174  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11175  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11176  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11177  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11178  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11179  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11180  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11181  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11182  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11183  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11184  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11185  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11186  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11187  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11188  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11189  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11190  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11191  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11192  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11193  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11194  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11195  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11196  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11197  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11198  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11199  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11200  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11201  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11202  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11203  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11204  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11205  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11206  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11207  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11208  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11209  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11210  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11211  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11212  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11213  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11214  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11215  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11216  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11217  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11218  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11219  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11220  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11221  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11222  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11223  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11224  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11225  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11226  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11227  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11228  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11229  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11230  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11231  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11232  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11233  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11234  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11235  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11236  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11237  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11238  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11239  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11240  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11241  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11242  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11243  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11244  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11245  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11246  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11247  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11248  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11249  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11250  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11251  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11252  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11253  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11254  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11255  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11256  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11257  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11258  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11259  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11260  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11261  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11262  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11263  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11264  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11265  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11266  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11267  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11268  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11269  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11270  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11271  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11272  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11273  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11274  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11275  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11276  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11277  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11278  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11279  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11280  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11281  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11282  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11283  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11284  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11285  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11286  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11287  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11288  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11289  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11290  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11291  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11292  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11293  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11294  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11295  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11296  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11297  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11298  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11299  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11300  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11301  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11302  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11303  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11304  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11305  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11306  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11307  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11308  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11309  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11310  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11311  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11312  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11313  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11314  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11315  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11316  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11317  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11318  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11319  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11320  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11321  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11322  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11323  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11324  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11325  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11326  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11327  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11328  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11329  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11330  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11331  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11332  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11333  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11334  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11335  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11336  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11337  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11338  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11339  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11340  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11341  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11342  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11343  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11344  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11345  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11346  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11347  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11348  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11349  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11350  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11351  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11352  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11353  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11354  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11355  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11356  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11357  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11358  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11359  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11360  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11361  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11362  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11363  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11364  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11365  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11366  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11367  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11368  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11369  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11370  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11371  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11372  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11373  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11374  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11375  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11376  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11377  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11378  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11379  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11380  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11381  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11382  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11383  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11384  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11385  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11386  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11387  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11388  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11389  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11390  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11391  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11392  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11393  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11394  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11395  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11396  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11397  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11398  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11399  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11400  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11401  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11402  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11403  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11404  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11405  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11406  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11407  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11408  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11409  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11410  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11411  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11412  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11413  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11414  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11415  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11416  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11417  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11418  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11419  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11420  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11421  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11422  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11423  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11424  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11425  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11426  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11427  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11428  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11429  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11430  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11431  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11432  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11433  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11434  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11435  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11436  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11437  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11438  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11439  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11440  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11441  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11442  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11443  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11444  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11445  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11446  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11447  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11448  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11449  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11450  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11451  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11452  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11453  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11454  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11455  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11456  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11457  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11458  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11459  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11460  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11461  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11462  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11463  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11464  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11465  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11466  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11467  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11468  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11469  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11470  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11471  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11472  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11473  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11474  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11475  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11476  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11477  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11478  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11479  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11480  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11481  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11482  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11483  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11484  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11485  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11486  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11487  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11488  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11489  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11490  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11491  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11492  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11493  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11494  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11495  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11496  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11497  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11498  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11499  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11500  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11501  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11502  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11503  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11504  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11505  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11506  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11507  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11508  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11509  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11510  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11511  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11512  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11513  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11514  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11515  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11516  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11517  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11518  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11519  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11520  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11521  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11522  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11523  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11524  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11525  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11526  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11527  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11528  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11529  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11530  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11531  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11532  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11533  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11534  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11535  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11536  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11537  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11538  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11539  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11540  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11541  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11542  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11543  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11544  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11545  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11546  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11547  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11548  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11549  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11550  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11551  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11552  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11553  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11554  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11555  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11556  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11557  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11558  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11559  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11560  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11561  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11562  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11563  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11564  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11565  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11566  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11567  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11568  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11569  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11570  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11571  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11572  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11573  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11574  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11575  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11576  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11577  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11578  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11579  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11580  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11581  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11582  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11583  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11584  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11585  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11586  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11587  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11588  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11589  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11590  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11591  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11592  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11593  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11594  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11595  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11596  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11597  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11598  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11599  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11600  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11601  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11602  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11603  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11604  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11605  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11606  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11607  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11608  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11609  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11610  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11611  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11612  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11613  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11614  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11615  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11616  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11617  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11618  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11619  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11620  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11621  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11622  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11623  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11624  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11625  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11626  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11627  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11628  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11629  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11630  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11631  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11632  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11633  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11634  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11635  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11636  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11637  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11638  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11639  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11640  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11641  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11642  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11643  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11644  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11645  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11646  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11647  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11648  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11649  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11650  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11651  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11652  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11653  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11654  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11655  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11656  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11657  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11658  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11659  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11660  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11661  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11662  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11663  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11664  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11665  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11666  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11667  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11668  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11669  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11670  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11671  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11672  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11673  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11674  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11675  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11676  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11677  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11678  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11679  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11680  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11681  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11682  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11683  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11684  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11685  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11686  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11687  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11688  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11689  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11690  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11691  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11692  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11693  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11694  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11695  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11696  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11697  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11698  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11699  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11700  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11701  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11702  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11703  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11704  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11705  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11706  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11707  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11708  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11709  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11710  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11711  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11712  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11713  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11714  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11715  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11716  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11717  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11718  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11719  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11720  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11721  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11722  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11723  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11724  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11725  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11726  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11727  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11728  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11729  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11730  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11731  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11732  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11733  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11734  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11735  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11736  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11737  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11738  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11739  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11740  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11741  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11742  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11743  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11744  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11745  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11746  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11747  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11748  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11749  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11750  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11751  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11752  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11753  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11754  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11755  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11756  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11757  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11758  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11759  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11760  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11761  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11762  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11763  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11764  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11765  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11766  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11767  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11768  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11769  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11770  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11771  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11772  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11773  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11774  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11775  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11776  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11777  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11778  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11779  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11780  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11781  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11782  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11783  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11784  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11785  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11786  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11787  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11788  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11789  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11790  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11791  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11792  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11793  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11794  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11795  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11796  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11797  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11798  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11799  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11800  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11801  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11802  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11803  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11804  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11805  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11806  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11807  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11808  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11809  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11810  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11811  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11812  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11813  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11814  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11815  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11816  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11817  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11818  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11819  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11820  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11821  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11822  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11823  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11824  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11825  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11826  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11827  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11828  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11829  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11830  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11831  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11832  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11833  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11834  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11835  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11836  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11837  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11838  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11839  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11840  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11841  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11842  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11843  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11844  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11845  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11846  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11847  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11848  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11849  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11850  U+0000  .notdef,  UNDEFINED
        0x33DA, # G+11851  U+33DA  uni33DA,  SQUARE PR
        0x0000, # G+11852  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11853  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11854  U+0000  .notdef,  UNDEFINED
        0x2100, # G+11855  U+2100  uni2100,  ACCOUNT OF
        0x33C2, # G+11856  U+33C2  uni33C2,  SQUARE AM
        0x0000, # G+11857  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11858  U+0000  .notdef,  UNDEFINED
        0x2105, # G+11859  U+2105  afii61248,  CARE OF
        0x0000, # G+11860  U+0000  .notdef,  UNDEFINED
        0x3371, # G+11861  U+3371  uni3371,  SQUARE HPA
        0x0000, # G+11862  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11863  U+0000  .notdef,  UNDEFINED
        0x338D, # G+11864  U+338D  uni338D,  SQUARE MU G
        0x339B, # G+11865  U+339B  uni339B,  SQUARE MU M
        0x0000, # G+11866  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11867  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11868  U+0000  .notdef,  UNDEFINED
        0x33D7, # G+11869  U+33D7  uni33D7,  SQUARE PH
        0x33D8, # G+11870  U+33D8  uni33D8,  SQUARE PM
        0x0000, # G+11871  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11872  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11873  U+0000  .notdef,  UNDEFINED
        0x3301, # G+11874  U+3301  uni3301,  SQUARE ARUHUA
        0x3302, # G+11875  U+3302  uni3302,  SQUARE ANPEA
        0x3304, # G+11876  U+3304  uni3304,  SQUARE ININGU
        0x3306, # G+11877  U+3306  uni3306,  SQUARE UON
        0x0000, # G+11878  U+0000  .notdef,  UNDEFINED
        0x3308, # G+11879  U+3308  uni3308,  SQUARE EEKAA
        0x0000, # G+11880  U+0000  .notdef,  UNDEFINED
        0x3307, # G+11881  U+3307  uni3307,  SQUARE ESUKUUDO
        0x330A, # G+11882  U+330A  uni330A,  SQUARE OOMU
        0x0000, # G+11883  U+0000  .notdef,  UNDEFINED
        0x3309, # G+11884  U+3309  uni3309,  SQUARE ONSU
        0x0000, # G+11885  U+0000  .notdef,  UNDEFINED
        0x330B, # G+11886  U+330B  uni330B,  SQUARE KAIRI
        0x0000, # G+11887  U+0000  .notdef,  UNDEFINED
        0x330C, # G+11888  U+330C  uni330C,  SQUARE KARATTO
        0x330E, # G+11889  U+330E  uni330E,  SQUARE GARON
        0x330F, # G+11890  U+330F  uni330F,  SQUARE GANMA
        0x3310, # G+11891  U+3310  uni3310,  SQUARE GIGA
        0x3311, # G+11892  U+3311  uni3311,  SQUARE GINII
        0x3312, # G+11893  U+3312  uni3312,  SQUARE KYURII
        0x3313, # G+11894  U+3313  uni3313,  SQUARE GIRUDAA
        0x0000, # G+11895  U+0000  .notdef,  UNDEFINED
        0x3317, # G+11896  U+3317  uni3317,  SQUARE KIROWATTO
        0x0000, # G+11897  U+0000  .notdef,  UNDEFINED
        0x3319, # G+11898  U+3319  uni3319,  SQUARE GURAMUTON
        0x0000, # G+11899  U+0000  .notdef,  UNDEFINED
        0x331A, # G+11900  U+331A  uni331A,  SQUARE KURUZEIRO
        0x331B, # G+11901  U+331B  uni331B,  SQUARE KUROONE
        0x331C, # G+11902  U+331C  uni331C,  SQUARE KEESU
        0x331D, # G+11903  U+331D  uni331D,  SQUARE KORUNA
        0x331F, # G+11904  U+331F  uni331F,  SQUARE SAIKURU
        0x3320, # G+11905  U+3320  uni3320,  SQUARE SANTIIMU
        0x3321, # G+11906  U+3321  uni3321,  SQUARE SIRINGU
        0x3324, # G+11907  U+3324  uni3324,  SQUARE DAASU
        0x0000, # G+11908  U+0000  .notdef,  UNDEFINED
        0x3325, # G+11909  U+3325  uni3325,  SQUARE DESI
        0x0000, # G+11910  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11911  U+0000  .notdef,  UNDEFINED
        0x3328, # G+11912  U+3328  uni3328,  SQUARE NANO
        0x3329, # G+11913  U+3329  uni3329,  SQUARE NOTTO
        0x0000, # G+11914  U+0000  .notdef,  UNDEFINED
        0x332D, # G+11915  U+332D  uni332D,  SQUARE BAARERU
        0x0000, # G+11916  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11917  U+0000  .notdef,  UNDEFINED
        0x332E, # G+11918  U+332E  uni332E,  SQUARE PIASUTORU
        0x332F, # G+11919  U+332F  uni332F,  SQUARE PIKURU
        0x3330, # G+11920  U+3330  uni3330,  SQUARE PIKO
        0x3332, # G+11921  U+3332  uni3332,  SQUARE HUARADDO
        0x0000, # G+11922  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11923  U+0000  .notdef,  UNDEFINED
        0x3334, # G+11924  U+3334  uni3334,  SQUARE BUSSYERU
        0x3335, # G+11925  U+3335  uni3335,  SQUARE HURAN
        0x333C, # G+11926  U+333C  uni333C,  SQUARE BEETA
        0x0000, # G+11927  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11928  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11929  U+0000  .notdef,  UNDEFINED
        0x3337, # G+11930  U+3337  uni3337,  SQUARE PESO
        0x0000, # G+11931  U+0000  .notdef,  UNDEFINED
        0x3338, # G+11932  U+3338  uni3338,  SQUARE PENIHI
        0x333A, # G+11933  U+333A  uni333A,  SQUARE PENSU
        0x333D, # G+11934  U+333D  uni333D,  SQUARE POINTO
        0x3341, # G+11935  U+3341  uni3341,  SQUARE HOORU
        0x333E, # G+11936  U+333E  uni333E,  SQUARE BORUTO
        0x333F, # G+11937  U+333F  uni333F,  SQUARE HON
        0x3340, # G+11938  U+3340  uni3340,  SQUARE PONDO
        0x3343, # G+11939  U+3343  uni3343,  SQUARE MAIKURO
        0x3344, # G+11940  U+3344  uni3344,  SQUARE MAIRU
        0x3345, # G+11941  U+3345  uni3345,  SQUARE MAHHA
        0x3346, # G+11942  U+3346  uni3346,  SQUARE MARUKU
        0x3348, # G+11943  U+3348  uni3348,  SQUARE MIKURON
        0x334B, # G+11944  U+334B  uni334B,  SQUARE MEGA
        0x334C, # G+11945  U+334C  uni334C,  SQUARE MEGATON
        0x334F, # G+11946  U+334F  uni334F,  SQUARE YAARU
        0x3350, # G+11947  U+3350  uni3350,  SQUARE YUAN
        0x0000, # G+11948  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11949  U+0000  .notdef,  UNDEFINED
        0x3352, # G+11950  U+3352  uni3352,  SQUARE RIRA
        0x3354, # G+11951  U+3354  uni3354,  SQUARE RUUBURU
        0x0000, # G+11952  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11953  U+0000  .notdef,  UNDEFINED
        0x3353, # G+11954  U+3353  uni3353,  SQUARE RUPII
        0x3355, # G+11955  U+3355  uni3355,  SQUARE REMU
        0x3356, # G+11956  U+3356  uni3356,  SQUARE RENTOGEN
        0x0000, # G+11957  U+0000  .notdef,  UNDEFINED
        0x3301, # G+11958  U+3301  uni3301,  SQUARE ARUHUA
        0x3302, # G+11959  U+3302  uni3302,  SQUARE ANPEA
        0x3304, # G+11960  U+3304  uni3304,  SQUARE ININGU
        0x3306, # G+11961  U+3306  uni3306,  SQUARE UON
        0x0000, # G+11962  U+0000  .notdef,  UNDEFINED
        0x3308, # G+11963  U+3308  uni3308,  SQUARE EEKAA
        0x0000, # G+11964  U+0000  .notdef,  UNDEFINED
        0x3307, # G+11965  U+3307  uni3307,  SQUARE ESUKUUDO
        0x330A, # G+11966  U+330A  uni330A,  SQUARE OOMU
        0x0000, # G+11967  U+0000  .notdef,  UNDEFINED
        0x3309, # G+11968  U+3309  uni3309,  SQUARE ONSU
        0x0000, # G+11969  U+0000  .notdef,  UNDEFINED
        0x330B, # G+11970  U+330B  uni330B,  SQUARE KAIRI
        0x0000, # G+11971  U+0000  .notdef,  UNDEFINED
        0x330C, # G+11972  U+330C  uni330C,  SQUARE KARATTO
        0x330E, # G+11973  U+330E  uni330E,  SQUARE GARON
        0x330F, # G+11974  U+330F  uni330F,  SQUARE GANMA
        0x3310, # G+11975  U+3310  uni3310,  SQUARE GIGA
        0x3311, # G+11976  U+3311  uni3311,  SQUARE GINII
        0x3312, # G+11977  U+3312  uni3312,  SQUARE KYURII
        0x3313, # G+11978  U+3313  uni3313,  SQUARE GIRUDAA
        0x0000, # G+11979  U+0000  .notdef,  UNDEFINED
        0x3317, # G+11980  U+3317  uni3317,  SQUARE KIROWATTO
        0x0000, # G+11981  U+0000  .notdef,  UNDEFINED
        0x3319, # G+11982  U+3319  uni3319,  SQUARE GURAMUTON
        0x0000, # G+11983  U+0000  .notdef,  UNDEFINED
        0x331A, # G+11984  U+331A  uni331A,  SQUARE KURUZEIRO
        0x331B, # G+11985  U+331B  uni331B,  SQUARE KUROONE
        0x331C, # G+11986  U+331C  uni331C,  SQUARE KEESU
        0x331D, # G+11987  U+331D  uni331D,  SQUARE KORUNA
        0x331F, # G+11988  U+331F  uni331F,  SQUARE SAIKURU
        0x3320, # G+11989  U+3320  uni3320,  SQUARE SANTIIMU
        0x3321, # G+11990  U+3321  uni3321,  SQUARE SIRINGU
        0x3324, # G+11991  U+3324  uni3324,  SQUARE DAASU
        0x0000, # G+11992  U+0000  .notdef,  UNDEFINED
        0x3325, # G+11993  U+3325  uni3325,  SQUARE DESI
        0x0000, # G+11994  U+0000  .notdef,  UNDEFINED
        0x0000, # G+11995  U+0000  .notdef,  UNDEFINED
        0x3328, # G+11996  U+3328  uni3328,  SQUARE NANO
        0x3329, # G+11997  U+3329  uni3329,  SQUARE NOTTO
        0x0000, # G+11998  U+0000  .notdef,  UNDEFINED
        0x332D, # G+11999  U+332D  uni332D,  SQUARE BAARERU
        0x0000, # G+12000  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12001  U+0000  .notdef,  UNDEFINED
        0x332E, # G+12002  U+332E  uni332E,  SQUARE PIASUTORU
        0x332F, # G+12003  U+332F  uni332F,  SQUARE PIKURU
        0x3330, # G+12004  U+3330  uni3330,  SQUARE PIKO
        0x3332, # G+12005  U+3332  uni3332,  SQUARE HUARADDO
        0x0000, # G+12006  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12007  U+0000  .notdef,  UNDEFINED
        0x3334, # G+12008  U+3334  uni3334,  SQUARE BUSSYERU
        0x3335, # G+12009  U+3335  uni3335,  SQUARE HURAN
        0x333C, # G+12010  U+333C  uni333C,  SQUARE BEETA
        0x0000, # G+12011  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12012  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12013  U+0000  .notdef,  UNDEFINED
        0x3337, # G+12014  U+3337  uni3337,  SQUARE PESO
        0x0000, # G+12015  U+0000  .notdef,  UNDEFINED
        0x3338, # G+12016  U+3338  uni3338,  SQUARE PENIHI
        0x333A, # G+12017  U+333A  uni333A,  SQUARE PENSU
        0x333D, # G+12018  U+333D  uni333D,  SQUARE POINTO
        0x3341, # G+12019  U+3341  uni3341,  SQUARE HOORU
        0x333E, # G+12020  U+333E  uni333E,  SQUARE BORUTO
        0x333F, # G+12021  U+333F  uni333F,  SQUARE HON
        0x3340, # G+12022  U+3340  uni3340,  SQUARE PONDO
        0x3343, # G+12023  U+3343  uni3343,  SQUARE MAIKURO
        0x3344, # G+12024  U+3344  uni3344,  SQUARE MAIRU
        0x3345, # G+12025  U+3345  uni3345,  SQUARE MAHHA
        0x3346, # G+12026  U+3346  uni3346,  SQUARE MARUKU
        0x3348, # G+12027  U+3348  uni3348,  SQUARE MIKURON
        0x334B, # G+12028  U+334B  uni334B,  SQUARE MEGA
        0x334C, # G+12029  U+334C  uni334C,  SQUARE MEGATON
        0x334F, # G+12030  U+334F  uni334F,  SQUARE YAARU
        0x3350, # G+12031  U+3350  uni3350,  SQUARE YUAN
        0x0000, # G+12032  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12033  U+0000  .notdef,  UNDEFINED
        0x3352, # G+12034  U+3352  uni3352,  SQUARE RIRA
        0x3354, # G+12035  U+3354  uni3354,  SQUARE RUUBURU
        0x0000, # G+12036  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12037  U+0000  .notdef,  UNDEFINED
        0x3353, # G+12038  U+3353  uni3353,  SQUARE RUPII
        0x3355, # G+12039  U+3355  uni3355,  SQUARE REMU
        0x3356, # G+12040  U+3356  uni3356,  SQUARE RENTOGEN
        0x0000, # G+12041  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12042  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12043  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12044  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12045  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12046  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12047  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12048  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12049  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12050  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12051  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12052  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12053  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12054  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12055  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12056  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12057  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12058  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12059  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12060  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12061  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12062  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12063  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12064  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12065  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12066  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12067  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12068  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12069  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12070  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12071  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12072  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12073  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12074  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12075  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12076  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12077  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12078  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12079  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12080  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12081  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12082  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12083  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12084  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12085  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12086  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12087  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12088  U+0000  .notdef,  UNDEFINED
        0x2135, # G+12089  U+2135  aleph,  ALEF SYMBOL
        0x03D0, # G+12090  U+03D0  uni03D0,  GREEK BETA SYMBOL
        0x220A, # G+12091  U+220A  uni220A,  SMALL ELEMENT OF
        0x0127, # G+12092  U+0127  hbar,  LATIN SMALL LETTER H WITH STROKE
        0x0000, # G+12093  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12094  U+0000  .notdef,  UNDEFINED
        0x03DB, # G+12095  U+03DB  uni03DB,  GREEK SMALL LETTER STIGMA
        0x03D1, # G+12096  U+03D1  theta1,  GREEK THETA SYMBOL
        0x0000, # G+12097  U+0000  .notdef,  UNDEFINED
        0x2668, # G+12098  U+2668  uni2668,  HOT SPRINGS
        0x2669, # G+12099  U+2669  uni2669,  QUARTER NOTE
        0x266C, # G+12100  U+266C  uni266C,  BEAMED SIXTEENTH NOTES
        0x0000, # G+12101  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12102  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12103  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12104  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12105  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12106  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12107  U+0000  .notdef,  UNDEFINED
        0x3033, # G+12108  U+3033  uni3033,  VERTICAL KANA REPEAT MARK UPPER HALF
        0x3034, # G+12109  U+3034  uni3034,  VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF
        0x3035, # G+12110  U+3035  uni3035,  VERTICAL KANA REPEAT MARK LOWER HALF
        0x203C, # G+12111  U+203C  exclamdbl,  DOUBLE EXCLAMATION MARK
        0x2049, # G+12112  U+2049  uni2049,  EXCLAMATION QUESTION MARK
        0x0000, # G+12113  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12114  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12115  U+0000  .notdef,  UNDEFINED
        0x244A, # G+12116  U+244A  uni244A,  OCR DOUBLE BACKSLASH
        0x0000, # G+12117  U+0000  .notdef,  UNDEFINED
        0x2213, # G+12118  U+2213  uni2213,  MINUS-OR-PLUS SIGN
        0x0000, # G+12119  U+0000  .notdef,  UNDEFINED
        0x2243, # G+12120  U+2243  uni2243,  ASYMPTOTICALLY EQUAL TO
        0x2272, # G+12121  U+2272  uni2272,  LESS-THAN OR EQUIVALENT TO
        0x2273, # G+12122  U+2273  uni2273,  GREATER-THAN OR EQUIVALENT TO
        0x0000, # G+12123  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12124  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12125  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12126  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12127  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12128  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12129  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12130  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12131  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12132  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12133  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12134  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12135  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12136  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12137  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12138  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12139  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12140  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12141  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12142  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12143  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12144  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12145  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12146  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12147  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12148  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12149  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12150  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12151  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12152  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12153  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12154  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12155  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12156  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12157  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12158  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12159  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12160  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12161  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12162  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12163  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12164  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12165  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12166  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12167  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12168  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12169  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12170  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12171  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12172  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12173  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12174  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12175  U+0000  .notdef,  UNDEFINED
        0x2702, # G+12176  U+2702  a2,  BLACK SCISSORS
        0x0000, # G+12177  U+0000  .notdef,  UNDEFINED
        0x2702, # G+12178  U+2702  a2,  BLACK SCISSORS
        0x0000, # G+12179  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12180  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12181  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12182  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12183  U+0000  .notdef,  UNDEFINED
        0x2205, # G+12184  U+2205  emptyset,  EMPTY SET
        0x22A0, # G+12185  U+22A0  uni22A0,  SQUARED TIMES
        0x2296, # G+12186  U+2296  uni2296,  CIRCLED MINUS
        0x2298, # G+12187  U+2298  uni2298,  CIRCLED DIVISION SLASH
        0x2295, # G+12188  U+2295  circleplus,  CIRCLED PLUS
        0x2297, # G+12189  U+2297  circlemultiply,  CIRCLED TIMES
        0x229E, # G+12190  U+229E  uni229E,  SQUARED PLUS
        0x0000, # G+12191  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12192  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12193  U+0000  .notdef,  UNDEFINED
        0x25C0, # G+12194  U+25C0  uni25C0,  BLACK LEFT-POINTING TRIANGLE
        0x25B6, # G+12195  U+25B6  uni25B6,  BLACK RIGHT-POINTING TRIANGLE
        0x0000, # G+12196  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12197  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12198  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12199  U+0000  .notdef,  UNDEFINED
        0x21D0, # G+12200  U+21D0  arrowdblleft,  LEFTWARDS DOUBLE ARROW
        0x2194, # G+12201  U+2194  arrowboth,  LEFT RIGHT ARROW
        0x2198, # G+12202  U+2198  uni2198,  SOUTH EAST ARROW
        0x2199, # G+12203  U+2199  uni2199,  SOUTH WEST ARROW
        0x2196, # G+12204  U+2196  uni2196,  NORTH WEST ARROW
        0x2197, # G+12205  U+2197  uni2197,  NORTH EAST ARROW
        0x21CC, # G+12206  U+21CC  uni21CC,  RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON
        0x0000, # G+12207  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12208  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12209  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12210  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12211  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12212  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12213  U+0000  .notdef,  UNDEFINED
        0x2195, # G+12214  U+2195  arrowupdn,  UP DOWN ARROW
        0x2195, # G+12215  U+2195  arrowupdn,  UP DOWN ARROW
        0x0000, # G+12216  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12217  U+0000  .notdef,  UNDEFINED
        0x3030, # G+12218  U+3030  uni3030,  WAVY DASH
        0x2307, # G+12219  U+2307  uni2307,  WAVY LINE
        0x0000, # G+12220  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12221  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12222  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12223  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12224  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12225  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12226  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12227  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12228  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12229  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12230  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12231  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12232  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12233  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12234  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12235  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12236  U+0000  .notdef,  UNDEFINED
        0x25AB, # G+12237  U+25AB  H18551,  WHITE SMALL SQUARE
        0x0000, # G+12238  U+0000  .notdef,  UNDEFINED
        0x25AA, # G+12239  U+25AA  H18543,  BLACK SMALL SQUARE
        0x0000, # G+12240  U+0000  .notdef,  UNDEFINED
        0x271A, # G+12241  U+271A  a26,  HEAVY GREEK CROSS
        0x0000, # G+12242  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12243  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12244  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12245  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12246  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12247  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12248  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12249  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12250  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12251  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12252  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12253  U+0000  .notdef,  UNDEFINED
        0x25E6, # G+12254  U+25E6  openbullet,  WHITE BULLET
        0x0000, # G+12255  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12256  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12257  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12258  U+0000  .notdef,  UNDEFINED
        0x2756, # G+12259  U+2756  a79,  BLACK DIAMOND MINUS WHITE X
        0x0000, # G+12260  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12261  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12262  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12263  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12264  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12265  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12266  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12267  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12268  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12269  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12270  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12271  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12272  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12273  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12274  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12275  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12276  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12277  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12278  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12279  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12280  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12281  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12282  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12283  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12284  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12285  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12286  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12287  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12288  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12289  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12290  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12291  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12292  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12293  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12294  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12295  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12296  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12297  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12298  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12299  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12300  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12301  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12302  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12303  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12304  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12305  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12306  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12307  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12308  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12309  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12310  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12311  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12312  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12313  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12314  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12315  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12316  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12317  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12318  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12319  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12320  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12321  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12322  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12323  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12324  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12325  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12326  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12327  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12328  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12329  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12330  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12331  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12332  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12333  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12334  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12335  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12336  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12337  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12338  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12339  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12340  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12341  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12342  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12343  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12344  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12345  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12346  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12347  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12348  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12349  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12350  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12351  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12352  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12353  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12354  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12355  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12356  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12357  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12358  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12359  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12360  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12361  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12362  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12363  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12364  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12365  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12366  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12367  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12368  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12369  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12370  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12371  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12372  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12373  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12374  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12375  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12376  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12377  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12378  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12379  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12380  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12381  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12382  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12383  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12384  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12385  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12386  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12387  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12388  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12389  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12390  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12391  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12392  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12393  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12394  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12395  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12396  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12397  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12398  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12399  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12400  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12401  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12402  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12403  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12404  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12405  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12406  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12407  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12408  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12409  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12410  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12411  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12412  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12413  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12414  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12415  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12416  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12417  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12418  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12419  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12420  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12421  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12422  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12423  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12424  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12425  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12426  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12427  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12428  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12429  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12430  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12431  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12432  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12433  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12434  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12435  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12436  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12437  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12438  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12439  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12440  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12441  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12442  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12443  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12444  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12445  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12446  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12447  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12448  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12449  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12450  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12451  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12452  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12453  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12454  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12455  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12456  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12457  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12458  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12459  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12460  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12461  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12462  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12463  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12464  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12465  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12466  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12467  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12468  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12469  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12470  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12471  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12472  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12473  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12474  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12475  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12476  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12477  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12478  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12479  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12480  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12481  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12482  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12483  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12484  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12485  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12486  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12487  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12488  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12489  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12490  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12491  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12492  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12493  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12494  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12495  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12496  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12497  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12498  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12499  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12500  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12501  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12502  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12503  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12504  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12505  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12506  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12507  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12508  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12509  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12510  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12511  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12512  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12513  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12514  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12515  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12516  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12517  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12518  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12519  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12520  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12521  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12522  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12523  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12524  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12525  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12526  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12527  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12528  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12529  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12530  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12531  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12532  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12533  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12534  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12535  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12536  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12537  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12538  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12539  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12540  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12541  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12542  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12543  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12544  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12545  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12546  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12547  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12548  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12549  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12550  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12551  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12552  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12553  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12554  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12555  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12556  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12557  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12558  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12559  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12560  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12561  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12562  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12563  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12564  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12565  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12566  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12567  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12568  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12569  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12570  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12571  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12572  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12573  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12574  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12575  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12576  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12577  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12578  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12579  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12580  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12581  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12582  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12583  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12584  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12585  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12586  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12587  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12588  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12589  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12590  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12591  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12592  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12593  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12594  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12595  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12596  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12597  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12598  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12599  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12600  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12601  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12602  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12603  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12604  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12605  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12606  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12607  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12608  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12609  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12610  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12611  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12612  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12613  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12614  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12615  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12616  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12617  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12618  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12619  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12620  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12621  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12622  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12623  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12624  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12625  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12626  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12627  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12628  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12629  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12630  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12631  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12632  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12633  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12634  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12635  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12636  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12637  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12638  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12639  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12640  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12641  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12642  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12643  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12644  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12645  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12646  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12647  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12648  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12649  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12650  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12651  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12652  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12653  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12654  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12655  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12656  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12657  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12658  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12659  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12660  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12661  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12662  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12663  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12664  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12665  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12666  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12667  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12668  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12669  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12670  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12671  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12672  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12673  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12674  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12675  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12676  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12677  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12678  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12679  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12680  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12681  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12682  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12683  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12684  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12685  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12686  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12687  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12688  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12689  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12690  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12691  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12692  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12693  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12694  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12695  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12696  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12697  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12698  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12699  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12700  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12701  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12702  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12703  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12704  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12705  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12706  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12707  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12708  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12709  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12710  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12711  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12712  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12713  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12714  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12715  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12716  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12717  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12718  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12719  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12720  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12721  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12722  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12723  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12724  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12725  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12726  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12727  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12728  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12729  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12730  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12731  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12732  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12733  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12734  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12735  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12736  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12737  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12738  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12739  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12740  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12741  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12742  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12743  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12744  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12745  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12746  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12747  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12748  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12749  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12750  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12751  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12752  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12753  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12754  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12755  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12756  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12757  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12758  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12759  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12760  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12761  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12762  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12763  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12764  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12765  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12766  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12767  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12768  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12769  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12770  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12771  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12772  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12773  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12774  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12775  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12776  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12777  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12778  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12779  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12780  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12781  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12782  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12783  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12784  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12785  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12786  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12787  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12788  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12789  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12790  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12791  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12792  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12793  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12794  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12795  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12796  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12797  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12798  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12799  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12800  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12801  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12802  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12803  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12804  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12805  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12806  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12807  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12808  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12809  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12810  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12811  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12812  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12813  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12814  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12815  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12816  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12817  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12818  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12819  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12820  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12821  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12822  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12823  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12824  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12825  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12826  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12827  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12828  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12829  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12830  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12831  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12832  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12833  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12834  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12835  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12836  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12837  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12838  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12839  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12840  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12841  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12842  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12843  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12844  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12845  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12846  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12847  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12848  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12849  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12850  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12851  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12852  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12853  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12854  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12855  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12856  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12857  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12858  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12859  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12860  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12861  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12862  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12863  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12864  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12865  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12866  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12867  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12868  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12869  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12870  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12871  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12872  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12873  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12874  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12875  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12876  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12877  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12878  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12879  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12880  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12881  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12882  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12883  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12884  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12885  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12886  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12887  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12888  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12889  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12890  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12891  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12892  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12893  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12894  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12895  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12896  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12897  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12898  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12899  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12900  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12901  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12902  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12903  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12904  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12905  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12906  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12907  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12908  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12909  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12910  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12911  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12912  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12913  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12914  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12915  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12916  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12917  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12918  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12919  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12920  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12921  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12922  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12923  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12924  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12925  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12926  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12927  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12928  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12929  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12930  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12931  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12932  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12933  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12934  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12935  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12936  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12937  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12938  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12939  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12940  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12941  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12942  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12943  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12944  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12945  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12946  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12947  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12948  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12949  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12950  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12951  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12952  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12953  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12954  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12955  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12956  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12957  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12958  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12959  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12960  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12961  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12962  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12963  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12964  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12965  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12966  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12967  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12968  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12969  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12970  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12971  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12972  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12973  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12974  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12975  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12976  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12977  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12978  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12979  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12980  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12981  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12982  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12983  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12984  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12985  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12986  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12987  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12988  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12989  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12990  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12991  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12992  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12993  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12994  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12995  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12996  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12997  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12998  U+0000  .notdef,  UNDEFINED
        0x0000, # G+12999  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13000  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13001  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13002  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13003  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13004  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13005  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13006  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13007  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13008  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13009  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13010  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13011  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13012  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13013  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13014  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13015  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13016  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13017  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13018  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13019  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13020  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13021  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13022  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13023  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13024  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13025  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13026  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13027  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13028  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13029  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13030  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13031  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13032  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13033  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13034  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13035  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13036  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13037  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13038  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13039  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13040  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13041  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13042  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13043  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13044  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13045  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13046  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13047  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13048  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13049  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13050  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13051  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13052  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13053  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13054  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13055  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13056  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13057  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13058  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13059  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13060  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13061  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13062  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13063  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13064  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13065  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13066  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13067  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13068  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13069  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13070  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13071  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13072  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13073  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13074  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13075  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13076  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13077  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13078  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13079  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13080  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13081  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13082  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13083  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13084  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13085  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13086  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13087  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13088  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13089  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13090  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13091  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13092  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13093  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13094  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13095  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13096  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13097  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13098  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13099  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13100  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13101  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13102  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13103  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13104  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13105  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13106  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13107  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13108  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13109  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13110  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13111  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13112  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13113  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13114  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13115  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13116  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13117  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13118  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13119  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13120  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13121  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13122  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13123  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13124  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13125  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13126  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13127  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13128  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13129  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13130  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13131  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13132  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13133  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13134  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13135  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13136  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13137  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13138  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13139  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13140  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13141  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13142  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13143  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13144  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13145  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13146  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13147  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13148  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13149  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13150  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13151  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13152  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13153  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13154  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13155  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13156  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13157  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13158  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13159  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13160  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13161  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13162  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13163  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13164  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13165  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13166  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13167  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13168  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13169  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13170  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13171  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13172  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13173  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13174  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13175  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13176  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13177  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13178  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13179  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13180  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13181  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13182  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13183  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13184  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13185  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13186  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13187  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13188  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13189  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13190  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13191  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13192  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13193  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13194  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13195  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13196  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13197  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13198  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13199  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13200  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13201  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13202  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13203  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13204  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13205  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13206  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13207  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13208  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13209  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13210  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13211  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13212  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13213  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13214  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13215  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13216  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13217  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13218  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13219  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13220  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13221  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13222  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13223  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13224  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13225  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13226  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13227  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13228  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13229  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13230  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13231  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13232  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13233  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13234  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13235  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13236  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13237  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13238  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13239  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13240  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13241  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13242  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13243  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13244  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13245  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13246  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13247  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13248  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13249  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13250  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13251  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13252  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13253  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13254  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13255  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13256  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13257  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13258  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13259  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13260  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13261  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13262  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13263  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13264  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13265  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13266  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13267  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13268  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13269  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13270  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13271  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13272  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13273  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13274  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13275  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13276  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13277  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13278  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13279  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13280  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13281  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13282  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13283  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13284  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13285  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13286  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13287  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13288  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13289  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13290  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13291  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13292  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13293  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13294  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13295  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13296  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13297  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13298  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13299  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13300  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13301  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13302  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13303  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13304  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13305  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13306  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13307  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13308  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13309  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13310  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13311  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13312  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13313  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13314  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13315  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13316  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13317  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13318  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13319  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13320  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13321  U+0000  .notdef,  UNDEFINED
        0x7DE3, # G+13322  U+7DE3  uni7DE3,  CJK UNIFIED IDEOGRAPH-7DE3
        0x2FC8, # G+13323  U+2FC8  uni2FC8,  KANGXI RADICAL YELLOW
        0x6EAB, # G+13324  U+6EAB  uni6EAB,  CJK UNIFIED IDEOGRAPH-6EAB
        0x0000, # G+13325  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13326  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13327  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13328  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13329  U+0000  .notdef,  UNDEFINED
        0x6E34, # G+13330  U+6E34  uni6E34,  CJK UNIFIED IDEOGRAPH-6E34
        0x0000, # G+13331  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13332  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13333  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13334  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13335  U+0000  .notdef,  UNDEFINED
        0x865B, # G+13336  U+865B  uni865B,  CJK UNIFIED IDEOGRAPH-865B
        0x0000, # G+13337  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13338  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13339  U+0000  .notdef,  UNDEFINED
        0x63ED, # G+13340  U+63ED  uni63ED,  CJK UNIFIED IDEOGRAPH-63ED
        0x64CA, # G+13341  U+64CA  uni64CA,  CJK UNIFIED IDEOGRAPH-64CA
        0x784F, # G+13342  U+784F  uni784F,  CJK UNIFIED IDEOGRAPH-784F
        0x0000, # G+13343  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13344  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13345  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13346  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13347  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13348  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13349  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13350  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13351  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13352  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13353  U+0000  .notdef,  UNDEFINED
        0x6D89, # G+13354  U+6D89  uni6D89,  CJK UNIFIED IDEOGRAPH-6D89
        0x72C0, # G+13355  U+72C0  uni72C0,  CJK UNIFIED IDEOGRAPH-72C0
        0x0000, # G+13356  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13357  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13358  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13359  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13360  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13361  U+0000  .notdef,  UNDEFINED
        0x5DE2, # G+13362  U+5DE2  uni5DE2,  CJK UNIFIED IDEOGRAPH-5DE2
        0x0000, # G+13363  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13364  U+0000  .notdef,  UNDEFINED
        0x537D, # G+13365  U+537D  uni537D,  CJK UNIFIED IDEOGRAPH-537D
        0x0000, # G+13366  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13367  U+0000  .notdef,  UNDEFINED
        0x5FB5, # G+13368  U+5FB5  uni5FB5,  CJK UNIFIED IDEOGRAPH-5FB5
        0x0000, # G+13369  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13370  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13371  U+0000  .notdef,  UNDEFINED
        0x9B2D, # G+13372  U+9B2D  uni9B2D,  CJK UNIFIED IDEOGRAPH-9B2D
        0x0000, # G+13373  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13374  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13375  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13376  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13377  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13378  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13379  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13380  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13381  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13382  U+0000  .notdef,  UNDEFINED
        0x5002, # G+13383  U+5002  uni5002,  CJK UNIFIED IDEOGRAPH-5002
        0x0000, # G+13384  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13385  U+0000  .notdef,  UNDEFINED
        0x6B65, # G+13386  U+6B65  uni6B65,  CJK UNIFIED IDEOGRAPH-6B65
        0x0000, # G+13387  U+0000  .notdef,  UNDEFINED
        0x6BCF, # G+13388  U+6BCF  uni6BCF,  CJK UNIFIED IDEOGRAPH-6BCF
        0x0000, # G+13389  U+0000  .notdef,  UNDEFINED
        0x623E, # G+13390  U+623E  uni623E,  CJK UNIFIED IDEOGRAPH-623E
        0x0000, # G+13391  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13392  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13393  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13394  U+0000  .notdef,  UNDEFINED
        0x6DDA, # G+13395  U+6DDA  uni6DDA,  CJK UNIFIED IDEOGRAPH-6DDA
        0x0000, # G+13396  U+0000  .notdef,  UNDEFINED
        0x66C6, # G+13397  U+66C6  uni66C6,  CJK UNIFIED IDEOGRAPH-66C6
        0x6B77, # G+13398  U+6B77  uni6B77,  CJK UNIFIED IDEOGRAPH-6B77
        0x0000, # G+13399  U+0000  .notdef,  UNDEFINED
        0x934A, # G+13400  U+934A  uni934A,  CJK UNIFIED IDEOGRAPH-934A
        0x0000, # G+13401  U+0000  .notdef,  UNDEFINED
        0x9304, # G+13402  U+9304  uni9304,  CJK UNIFIED IDEOGRAPH-9304
        0x0000, # G+13403  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13404  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13405  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13406  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13407  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13408  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13409  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13410  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13411  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13412  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13413  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13414  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13415  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13416  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13417  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13418  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13419  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13420  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13421  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13422  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13423  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13424  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13425  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13426  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13427  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13428  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13429  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13430  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13431  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13432  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13433  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13434  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13435  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13436  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13437  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13438  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13439  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13440  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13441  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13442  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13443  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13444  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13445  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13446  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13447  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13448  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13449  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13450  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13451  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13452  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13453  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13454  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13455  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13456  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13457  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13458  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13459  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13460  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13461  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13462  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13463  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13464  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13465  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13466  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13467  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13468  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13469  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13470  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13471  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13472  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13473  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13474  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13475  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13476  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13477  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13478  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13479  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13480  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13481  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13482  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13483  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13484  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13485  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13486  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13487  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13488  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13489  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13490  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13491  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13492  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13493  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13494  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13495  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13496  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13497  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13498  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13499  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13500  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13501  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13502  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13503  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13504  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13505  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13506  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13507  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13508  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13509  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13510  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13511  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13512  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13513  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13514  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13515  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13516  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13517  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13518  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13519  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13520  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13521  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13522  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13523  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13524  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13525  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13526  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13527  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13528  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13529  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13530  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13531  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13532  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13533  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13534  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13535  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13536  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13537  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13538  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13539  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13540  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13541  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13542  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13543  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13544  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13545  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13546  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13547  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13548  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13549  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13550  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13551  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13552  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13553  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13554  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13555  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13556  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13557  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13558  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13559  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13560  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13561  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13562  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13563  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13564  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13565  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13566  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13567  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13568  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13569  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13570  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13571  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13572  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13573  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13574  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13575  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13576  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13577  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13578  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13579  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13580  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13581  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13582  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13583  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13584  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13585  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13586  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13587  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13588  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13589  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13590  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13591  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13592  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13593  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13594  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13595  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13596  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13597  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13598  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13599  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13600  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13601  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13602  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13603  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13604  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13605  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13606  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13607  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13608  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13609  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13610  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13611  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13612  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13613  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13614  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13615  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13616  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13617  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13618  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13619  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13620  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13621  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13622  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13623  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13624  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13625  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13626  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13627  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13628  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13629  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13630  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13631  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13632  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13633  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13634  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13635  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13636  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13637  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13638  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13639  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13640  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13641  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13642  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13643  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13644  U+0000  .notdef,  UNDEFINED
        0x2ED7, # G+13645  U+2ED7  uni2ED7,  CJK RADICAL RAIN
        0x2EBD, # G+13646  U+2EBD  uni2EBD,  CJK RADICAL MORTAR
        0x0000, # G+13647  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13648  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13649  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13650  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13651  U+0000  .notdef,  UNDEFINED
        0x92B3, # G+13652  U+92B3  uni92B3,  CJK UNIFIED IDEOGRAPH-92B3
        0x95B1, # G+13653  U+95B1  uni95B1,  CJK UNIFIED IDEOGRAPH-95B1
        0x0000, # G+13654  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13655  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13656  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13657  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13658  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13659  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13660  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13661  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13662  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13663  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13664  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13665  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13666  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13667  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13668  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13669  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13670  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13671  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13672  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13673  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13674  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13675  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13676  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13677  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13678  U+0000  .notdef,  UNDEFINED
        0x69EA, # G+13679  U+69EA  uni69EA,  CJK UNIFIED IDEOGRAPH-69EA
        0x0000, # G+13680  U+0000  .notdef,  UNDEFINED
        0x676E, # G+13681  U+676E  uni676E,  CJK UNIFIED IDEOGRAPH-676E
        0x2EC6, # G+13682  U+2EC6  uni2EC6,  CJK RADICAL SIMPLIFIED HORN
        0x0000, # G+13683  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13684  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13685  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13686  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13687  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13688  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13689  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13690  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13691  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13692  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13693  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13694  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13695  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13696  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13697  U+0000  .notdef,  UNDEFINED
        0x3402, # G+13698  U+3402  uni3402,  CJK UNIFIED IDEOGRAPH-3402
        0x0000, # G+13699  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13700  U+0000  .notdef,  UNDEFINED
        0x65E3, # G+13701  U+65E3  uni65E3,  CJK UNIFIED IDEOGRAPH-65E3
        0x0000, # G+13702  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13703  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13704  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13705  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13706  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13707  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13708  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13709  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13710  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13711  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13712  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13713  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13714  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13715  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13716  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13717  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13718  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13719  U+0000  .notdef,  UNDEFINED
        0x5F3A, # G+13720  U+5F3A  uni5F3A,  CJK UNIFIED IDEOGRAPH-5F3A
        0x0000, # G+13721  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13722  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13723  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13724  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13725  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13726  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13727  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13728  U+0000  .notdef,  UNDEFINED
        0x2EA9, # G+13729  U+2EA9  uni2EA9,  CJK RADICAL JADE
        0x0000, # G+13730  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13731  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13732  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13733  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13734  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13735  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13736  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13737  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13738  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13739  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13740  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13741  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13742  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13743  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13744  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13745  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13746  U+0000  .notdef,  UNDEFINED
        0x2EBC, # G+13747  U+2EBC  uni2EBC,  CJK RADICAL MEAT
        0x0000, # G+13748  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13749  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13750  U+0000  .notdef,  UNDEFINED
        0x6743, # G+13751  U+6743  uni6743,  CJK UNIFIED IDEOGRAPH-6743
        0x0000, # G+13752  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13753  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13754  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13755  U+0000  .notdef,  UNDEFINED
        0x8A01, # G+13756  U+8A01  uni8A01,  CJK UNIFIED IDEOGRAPH-8A01
        0x6236, # G+13757  U+6236  uni6236,  CJK UNIFIED IDEOGRAPH-6236
        0x0000, # G+13758  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13759  U+0000  .notdef,  UNDEFINED
        0x5433, # G+13760  U+5433  uni5433,  CJK UNIFIED IDEOGRAPH-5433
        0x5A1B, # G+13761  U+5A1B  uni5A1B,  CJK UNIFIED IDEOGRAPH-5A1B
        0x0000, # G+13762  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13763  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13764  U+0000  .notdef,  UNDEFINED
        0x6285, # G+13765  U+6285  uni6285,  CJK UNIFIED IDEOGRAPH-6285
        0x0000, # G+13766  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13767  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13768  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13769  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13770  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13771  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13772  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13773  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13774  U+0000  .notdef,  UNDEFINED
        0x543F, # G+13775  U+543F  uni543F,  CJK UNIFIED IDEOGRAPH-543F
        0x0000, # G+13776  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13777  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13778  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13779  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13780  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13781  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13782  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13783  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13784  U+0000  .notdef,  UNDEFINED
        0x6B72, # G+13785  U+6B72  uni6B72,  CJK UNIFIED IDEOGRAPH-6B72
        0x0000, # G+13786  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13787  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13788  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13789  U+0000  .notdef,  UNDEFINED
        0x7522, # G+13790  U+7522  uni7522,  CJK UNIFIED IDEOGRAPH-7522
        0x0000, # G+13791  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13792  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13793  U+0000  .notdef,  UNDEFINED
        0x5DFF, # G+13794  U+5DFF  uni5DFF,  CJK UNIFIED IDEOGRAPH-5DFF
        0x0000, # G+13795  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13796  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13797  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13798  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13799  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13800  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13801  U+0000  .notdef,  UNDEFINED
        0x73BA, # G+13802  U+73BA  uni73BA,  CJK UNIFIED IDEOGRAPH-73BA
        0x0000, # G+13803  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13804  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13805  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13806  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13807  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13808  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13809  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13810  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13811  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13812  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13813  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13814  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13815  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13816  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13817  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13818  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13819  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13820  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13821  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13822  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13823  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13824  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13825  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13826  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13827  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13828  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13829  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13830  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13831  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13832  U+0000  .notdef,  UNDEFINED
        0x2E8C, # G+13833  U+2E8C  uni2E8C,  CJK RADICAL SMALL ONE
        0x2E8D, # G+13834  U+2E8D  uni2E8D,  CJK RADICAL SMALL TWO
        0x5C19, # G+13835  U+5C19  uni5C19,  CJK UNIFIED IDEOGRAPH-5C19
        0x0000, # G+13836  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13837  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13838  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13839  U+0000  .notdef,  UNDEFINED
        0x5B82, # G+13840  U+5B82  uni5B82,  CJK UNIFIED IDEOGRAPH-5B82
        0x0000, # G+13841  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13842  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13843  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13844  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13845  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13846  U+0000  .notdef,  UNDEFINED
        0x2EDD, # G+13847  U+2EDD  uni2EDD,  CJK RADICAL EAT ONE
        0x2EDF, # G+13848  U+2EDF  uni2EDF,  CJK RADICAL EAT THREE
        0x2EDE, # G+13849  U+2EDE  uni2EDE,  CJK RADICAL EAT TWO
        0x378D, # G+13850  U+378D  uni378D,  CJK UNIFIED IDEOGRAPH-378D
        0x0000, # G+13851  U+0000  .notdef,  UNDEFINED
        0x2E97, # G+13852  U+2E97  uni2E97,  CJK RADICAL HEART TWO
        0x0000, # G+13853  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13854  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13855  U+0000  .notdef,  UNDEFINED
        0x2E85, # G+13856  U+2E85  uni2E85,  CJK RADICAL PERSON
        0x0000, # G+13857  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13858  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13859  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13860  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13861  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13862  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13863  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13864  U+0000  .notdef,  UNDEFINED
        0x351F, # G+13865  U+351F  uni351F,  CJK UNIFIED IDEOGRAPH-351F
        0x0000, # G+13866  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13867  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13868  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13869  U+0000  .notdef,  UNDEFINED
        0x2EC3, # G+13870  U+2EC3  uni2EC3,  CJK RADICAL WEST ONE
        0x0000, # G+13871  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13872  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13873  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13874  U+0000  .notdef,  UNDEFINED
        0x7A05, # G+13875  U+7A05  uni7A05,  CJK UNIFIED IDEOGRAPH-7A05
        0x0000, # G+13876  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13877  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13878  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13879  U+0000  .notdef,  UNDEFINED
        0x8AAA, # G+13880  U+8AAA  uni8AAA,  CJK UNIFIED IDEOGRAPH-8AAA
        0x0000, # G+13881  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13882  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13883  U+0000  .notdef,  UNDEFINED
        0x6F98, # G+13884  U+6F98  uni6F98,  CJK UNIFIED IDEOGRAPH-6F98
        0x0000, # G+13885  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13886  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13887  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13888  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13889  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13890  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13891  U+0000  .notdef,  UNDEFINED
        0x63F7, # G+13892  U+63F7  uni63F7,  CJK UNIFIED IDEOGRAPH-63F7
        0x0000, # G+13893  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13894  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13895  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13896  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13897  U+0000  .notdef,  UNDEFINED
        0x2ECA, # G+13898  U+2ECA  uni2ECA,  CJK RADICAL FOOT
        0x0000, # G+13899  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13900  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13901  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13902  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13903  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13904  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13905  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13906  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13907  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13908  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13909  U+0000  .notdef,  UNDEFINED
        0x3427, # G+13910  U+3427  uni3427,  CJK UNIFIED IDEOGRAPH-3427
        0x0000, # G+13911  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13912  U+0000  .notdef,  UNDEFINED
        0x812B, # G+13913  U+812B  uni812B,  CJK UNIFIED IDEOGRAPH-812B
        0x0000, # G+13914  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13915  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13916  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13917  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13918  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13919  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13920  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13921  U+0000  .notdef,  UNDEFINED
        0x2EAE, # G+13922  U+2EAE  uni2EAE,  CJK RADICAL BAMBOO
        0x0000, # G+13923  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13924  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13925  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13926  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13927  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13928  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13929  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13930  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13931  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13932  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13933  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13934  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13935  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13936  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13937  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13938  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13939  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13940  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13941  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13942  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13943  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13944  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13945  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13946  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13947  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13948  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13949  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13950  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13951  U+0000  .notdef,  UNDEFINED
        0x5721, # G+13952  U+5721  uni5721,  CJK UNIFIED IDEOGRAPH-5721
        0x0000, # G+13953  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13954  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13955  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13956  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13957  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13958  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13959  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13960  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13961  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13962  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13963  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13964  U+0000  .notdef,  UNDEFINED
        0x3B88, # G+13965  U+3B88  uni3B88,  CJK UNIFIED IDEOGRAPH-3B88
        0x5167, # G+13966  U+5167  uni5167,  CJK UNIFIED IDEOGRAPH-5167
        0x0000, # G+13967  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13968  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13969  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13970  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13971  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13972  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13973  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13974  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13975  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13976  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13977  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13978  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13979  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13980  U+0000  .notdef,  UNDEFINED
        0x4E37, # G+13981  U+4E37  uni4E37,  CJK UNIFIED IDEOGRAPH-4E37
        0x0000, # G+13982  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13983  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13984  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13985  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13986  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13987  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13988  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13989  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13990  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13991  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13992  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13993  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13994  U+0000  .notdef,  UNDEFINED
        0x2EAA, # G+13995  U+2EAA  uni2EAA,  CJK RADICAL BOLT OF CLOTH
        0x5F65, # G+13996  U+5F65  uni5F65,  CJK UNIFIED IDEOGRAPH-5F65
        0x59EC, # G+13997  U+59EC  uni59EC,  CJK UNIFIED IDEOGRAPH-59EC
        0x0000, # G+13998  U+0000  .notdef,  UNDEFINED
        0x0000, # G+13999  U+0000  .notdef,  UNDEFINED
        0x5E99, # G+14000  U+5E99  uni5E99,  CJK UNIFIED IDEOGRAPH-5E99
        0x0000, # G+14001  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14002  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14003  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14004  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14005  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14006  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14007  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14008  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14009  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14010  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14011  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14012  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14013  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14014  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14015  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14016  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14017  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14018  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14019  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14020  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14021  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14022  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14023  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14024  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14025  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14026  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14027  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14028  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14029  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14030  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14031  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14032  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14033  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14034  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14035  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14036  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14037  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14038  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14039  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14040  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14041  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14042  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14043  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14044  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14045  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14046  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14047  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14048  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14049  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14050  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14051  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14052  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14053  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14054  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14055  U+0000  .notdef,  UNDEFINED
        0x52D0, # G+14056  U+52D0  uni52D0,  CJK UNIFIED IDEOGRAPH-52D0
        0x0000, # G+14057  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14058  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14059  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14060  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14061  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14062  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14063  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14064  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14065  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14066  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14067  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14068  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14069  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14070  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14071  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14072  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14073  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14074  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14075  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14076  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14077  U+0000  .notdef,  UNDEFINED
        0x2EB7, # G+14078  U+2EB7  uni2EB7,  CJK RADICAL RAM
        0x0000, # G+14079  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14080  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14081  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14082  U+0000  .notdef,  UNDEFINED
        0x8EB6, # G+14083  U+8EB6  uni8EB6,  CJK UNIFIED IDEOGRAPH-8EB6
        0x0000, # G+14084  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14085  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14086  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14087  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14088  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14089  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14090  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14091  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14092  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14093  U+0000  .notdef,  UNDEFINED
        0x7C7B, # G+14094  U+7C7B  uni7C7B,  CJK UNIFIED IDEOGRAPH-7C7B
        0x0000, # G+14095  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14096  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14097  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14098  U+0000  .notdef,  UNDEFINED
        0x2EB9, # G+14099  U+2EB9  uni2EB9,  CJK RADICAL OLD
        0x0000, # G+14100  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14101  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14102  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14103  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14104  U+0000  .notdef,  UNDEFINED
        0x2E87, # G+14105  U+2E87  uni2E87,  CJK RADICAL TABLE
        0x0000, # G+14106  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14107  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14108  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14109  U+0000  .notdef,  UNDEFINED
        0x2E8B, # G+14110  U+2E8B  uni2E8B,  CJK RADICAL SEAL
        0x0000, # G+14111  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14112  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14113  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14114  U+0000  .notdef,  UNDEFINED
        0x5455, # G+14115  U+5455  uni5455,  CJK UNIFIED IDEOGRAPH-5455
        0x0000, # G+14116  U+0000  .notdef,  UNDEFINED
        0x5939, # G+14117  U+5939  uni5939,  CJK UNIFIED IDEOGRAPH-5939
        0x0000, # G+14118  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14119  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14120  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14121  U+0000  .notdef,  UNDEFINED
        0x5C14, # G+14122  U+5C14  uni5C14,  CJK UNIFIED IDEOGRAPH-5C14
        0x37E2, # G+14123  U+37E2  uni37E2,  CJK UNIFIED IDEOGRAPH-37E2
        0x5CE6, # G+14124  U+5CE6  uni5CE6,  CJK UNIFIED IDEOGRAPH-5CE6
        0x0000, # G+14125  U+0000  .notdef,  UNDEFINED
        0x4E48, # G+14126  U+4E48  uni4E48,  CJK UNIFIED IDEOGRAPH-4E48
        0x0000, # G+14127  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14128  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14129  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14130  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14131  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14132  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14133  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14134  U+0000  .notdef,  UNDEFINED
        0x631B, # G+14135  U+631B  uni631B,  CJK UNIFIED IDEOGRAPH-631B
        0x0000, # G+14136  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14137  U+0000  .notdef,  UNDEFINED
        0x6663, # G+14138  U+6663  uni6663,  CJK UNIFIED IDEOGRAPH-6663
        0x0000, # G+14139  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14140  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14141  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14142  U+0000  .notdef,  UNDEFINED
        0x69F6, # G+14143  U+69F6  uni69F6,  CJK UNIFIED IDEOGRAPH-69F6
        0x0000, # G+14144  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14145  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14146  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14147  U+0000  .notdef,  UNDEFINED
        0x6BCC, # G+14148  U+6BCC  uni6BCC,  CJK UNIFIED IDEOGRAPH-6BCC
        0x0000, # G+14149  U+0000  .notdef,  UNDEFINED
        0x6E17, # G+14150  U+6E17  uni6E17,  CJK UNIFIED IDEOGRAPH-6E17
        0x0000, # G+14151  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14152  U+0000  .notdef,  UNDEFINED
        0x6CAA, # G+14153  U+6CAA  uni6CAA,  CJK UNIFIED IDEOGRAPH-6CAA
        0x0000, # G+14154  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14155  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14156  U+0000  .notdef,  UNDEFINED
        0x2EA6, # G+14157  U+2EA6  uni2EA6,  CJK RADICAL SIMPLIFIED HALF TREE TRUNK
        0x0000, # G+14158  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14159  U+0000  .notdef,  UNDEFINED
        0x74EF, # G+14160  U+74EF  uni74EF,  CJK UNIFIED IDEOGRAPH-74EF
        0x7575, # G+14161  U+7575  uni7575,  CJK UNIFIED IDEOGRAPH-7575
        0x75EC, # G+14162  U+75EC  uni75EC,  CJK UNIFIED IDEOGRAPH-75EC
        0x764E, # G+14163  U+764E  uni764E,  CJK UNIFIED IDEOGRAPH-764E
        0x3FB1, # G+14164  U+3FB1  uni3FB1,  CJK UNIFIED IDEOGRAPH-3FB1
        0x776A, # G+14165  U+776A  uni776A,  CJK UNIFIED IDEOGRAPH-776A
        0x77A9, # G+14166  U+77A9  uni77A9,  CJK UNIFIED IDEOGRAPH-77A9
        0x0000, # G+14167  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14168  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14169  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14170  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14171  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14172  U+0000  .notdef,  UNDEFINED
        0x7B53, # G+14173  U+7B53  uni7B53,  CJK UNIFIED IDEOGRAPH-7B53
        0x0000, # G+14174  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14175  U+0000  .notdef,  UNDEFINED
        0x4264, # G+14176  U+4264  uni4264,  CJK UNIFIED IDEOGRAPH-4264
        0x0000, # G+14177  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14178  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14179  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14180  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14181  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14182  U+0000  .notdef,  UNDEFINED
        0x7E48, # G+14183  U+7E48  uni7E48,  CJK UNIFIED IDEOGRAPH-7E48
        0x0000, # G+14184  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14185  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14186  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14187  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14188  U+0000  .notdef,  UNDEFINED
        0x2EB3, # G+14189  U+2EB3  uni2EB3,  CJK RADICAL NET THREE
        0x0000, # G+14190  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14191  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14192  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14193  U+0000  .notdef,  UNDEFINED
        0x8141, # G+14194  U+8141  uni8141,  CJK UNIFIED IDEOGRAPH-8141
        0x4453, # G+14195  U+4453  uni4453,  CJK UNIFIED IDEOGRAPH-4453
        0x0000, # G+14196  U+0000  .notdef,  UNDEFINED
        0x2EBE, # G+14197  U+2EBE  uni2EBE,  CJK RADICAL GRASS ONE
        0x2EBF, # G+14198  U+2EBF  uni2EBF,  CJK RADICAL GRASS TWO
        0x2EC0, # G+14199  U+2EC0  uni2EC0,  CJK RADICAL GRASS THREE
        0x0000, # G+14200  U+0000  .notdef,  UNDEFINED
        0x5179, # G+14201  U+5179  uni5179,  CJK UNIFIED IDEOGRAPH-5179
        0x0000, # G+14202  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14203  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14204  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14205  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14206  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14207  U+0000  .notdef,  UNDEFINED
        0x85F4, # G+14208  U+85F4  uni85F4,  CJK UNIFIED IDEOGRAPH-85F4
        0x0000, # G+14209  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14210  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14211  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14212  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14213  U+0000  .notdef,  UNDEFINED
        0x867D, # G+14214  U+867D  uni867D,  CJK UNIFIED IDEOGRAPH-867D
        0x0000, # G+14215  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14216  U+0000  .notdef,  UNDEFINED
        0x88C6, # G+14217  U+88C6  uni88C6,  CJK UNIFIED IDEOGRAPH-88C6
        0x0000, # G+14218  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14219  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14220  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14221  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14222  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14223  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14224  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14225  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14226  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14227  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14228  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14229  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14230  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14231  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14232  U+0000  .notdef,  UNDEFINED
        0x8FC8, # G+14233  U+8FC8  uni8FC8,  CJK UNIFIED IDEOGRAPH-8FC8
        0x0000, # G+14234  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14235  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14236  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14237  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14238  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14239  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14240  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14241  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14242  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14243  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14244  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14245  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14246  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14247  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14248  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14249  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14250  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14251  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14252  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14253  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14254  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14255  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14256  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14257  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14258  U+0000  .notdef,  UNDEFINED
        0x9839, # G+14259  U+9839  uni9839,  CJK UNIFIED IDEOGRAPH-9839
        0x0000, # G+14260  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14261  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14262  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14263  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14264  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14265  U+0000  .notdef,  UNDEFINED
        0x9A08, # G+14266  U+9A08  uni9A08,  CJK UNIFIED IDEOGRAPH-9A08
        0x0000, # G+14267  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14268  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14269  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14270  U+0000  .notdef,  UNDEFINED
        0x9BDF, # G+14271  U+9BDF  uni9BDF,  CJK UNIFIED IDEOGRAPH-9BDF
        0x0000, # G+14272  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14273  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14274  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14275  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14276  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14277  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14278  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14279  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14280  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14281  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14282  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14283  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14284  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14285  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14286  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14287  U+0000  .notdef,  UNDEFINED
        0x5389, # G+14288  U+5389  uni5389,  CJK UNIFIED IDEOGRAPH-5389
        0x0000, # G+14289  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14290  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14291  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14292  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14293  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14294  U+0000  .notdef,  UNDEFINED
        0x0000, # G+14295  U+0000  .notdef,  UNDEFINED
        0x4E04, # G+14296  U+4E04  uni4E04,  CJK UNIFIED IDEOGRAPH-4E04
        0x4E05, # G+14297  U+4E05  uni4E05,  CJK UNIFIED IDEOGRAPH-4E05
        0x4E1F, # G+14298  U+4E1F  uni4E1F,  CJK UNIFIED IDEOGRAPH-4E1F
        0x4E2B, # G+14299  U+4E2B  uni4E2B,  CJK UNIFIED IDEOGRAPH-4E2B
        0x4E2F, # G+14300  U+4E2F  uni4E2F,  CJK UNIFIED IDEOGRAPH-4E2F
        0x4E30, # G+14301  U+4E30  uni4E30,  CJK UNIFIED IDEOGRAPH-4E30
        0x4E40, # G+14302  U+4E40  uni4E40,  CJK UNIFIED IDEOGRAPH-4E40
        0x4E41, # G+14303  U+4E41  uni4E41,  CJK UNIFIED IDEOGRAPH-4E41
        0x4E44, # G+14304  U+4E44  uni4E44,  CJK UNIFIED IDEOGRAPH-4E44
        0x2E83, # G+14305  U+2E83  uni2E83,  CJK RADICAL SECOND TWO
        0x4E7F, # G+14306  U+4E7F  uni4E7F,  CJK UNIFIED IDEOGRAPH-4E7F
        0x4E8D, # G+14307  U+4E8D  uni4E8D,  CJK UNIFIED IDEOGRAPH-4E8D
        0x4E96, # G+14308  U+4E96  uni4E96,  CJK UNIFIED IDEOGRAPH-4E96
        0x4EB9, # G+14309  U+4EB9  uni4EB9,  CJK UNIFIED IDEOGRAPH-4EB9
        0x4ED0, # G+14310  U+4ED0  uni4ED0,  CJK UNIFIED IDEOGRAPH-4ED0
        0x4EE0, # G+14311  U+4EE0  uni4EE0,  CJK UNIFIED IDEOGRAPH-4EE0
        0x4EFD, # G+14312  U+4EFD  uni4EFD,  CJK UNIFIED IDEOGRAPH-4EFD
        0x4EFF, # G+14313  U+4EFF  uni4EFF,  CJK UNIFIED IDEOGRAPH-4EFF
        0x4F0B, # G+14314  U+4F0B  uni4F0B,  CJK UNIFIED IDEOGRAPH-4F0B
        0x4F15, # G+14315  U+4F15  uni4F15,  CJK UNIFIED IDEOGRAPH-4F15
        0x4F60, # G+14316  U+4F60  uni4F60,  CJK UNIFIED IDEOGRAPH-4F60
        0x4F3B, # G+14317  U+4F3B  uni4F3B,  CJK UNIFIED IDEOGRAPH-4F3B
        0x4F49, # G+14318  U+4F49  uni4F49,  CJK UNIFIED IDEOGRAPH-4F49
        0x4F54, # G+14319  U+4F54  uni4F54,  CJK UNIFIED IDEOGRAPH-4F54
        0x4F7A, # G+14320  U+4F7A  uni4F7A,  CJK UNIFIED IDEOGRAPH-4F7A
        0x4F7D, # G+14321  U+4F7D  uni4F7D,  CJK UNIFIED IDEOGRAPH-4F7D
        0x4F7E, # G+14322  U+4F7E  uni4F7E,  CJK UNIFIED IDEOGRAPH-4F7E
        0x4F97, # G+14323  U+4F97  uni4F97,  CJK UNIFIED IDEOGRAPH-4F97
        0x4FBE, # G+14324  U+4FBE  uni4FBE,  CJK UNIFIED IDEOGRAPH-4FBE
        0x4FCF, # G+14325  U+4FCF  uni4FCF,  CJK UNIFIED IDEOGRAPH-4FCF
        0x4FFD, # G+14326  U+4FFD  uni4FFD,  CJK UNIFIED IDEOGRAPH-4FFD
        0x5000, # G+14327  U+5000  uni5000,  CJK UNIFIED IDEOGRAPH-5000
        0x5001, # G+14328  U+5001  uni5001,  CJK UNIFIED IDEOGRAPH-5001
        0x5010, # G+14329  U+5010  uni5010,  CJK UNIFIED IDEOGRAPH-5010
        0x501B, # G+14330  U+501B  uni501B,  CJK UNIFIED IDEOGRAPH-501B
        0x5027, # G+14331  U+5027  uni5027,  CJK UNIFIED IDEOGRAPH-5027
        0x502E, # G+14332  U+502E  uni502E,  CJK UNIFIED IDEOGRAPH-502E
        0x5057, # G+14333  U+5057  uni5057,  CJK UNIFIED IDEOGRAPH-5057
        0x5066, # G+14334  U+5066  uni5066,  CJK UNIFIED IDEOGRAPH-5066
        0x506A, # G+14335  U+506A  uni506A,  CJK UNIFIED IDEOGRAPH-506A
        0x503B, # G+14336  U+503B  uni503B,  CJK UNIFIED IDEOGRAPH-503B
        0x508F, # G+14337  U+508F  uni508F,  CJK UNIFIED IDEOGRAPH-508F
        0x5096, # G+14338  U+5096  uni5096,  CJK UNIFIED IDEOGRAPH-5096
        0x509C, # G+14339  U+509C  uni509C,  CJK UNIFIED IDEOGRAPH-509C
        0x50CC, # G+14340  U+50CC  uni50CC,  CJK UNIFIED IDEOGRAPH-50CC
        0x50E6, # G+14341  U+50E6  uni50E6,  CJK UNIFIED IDEOGRAPH-50E6
        0x50E9, # G+14342  U+50E9  uni50E9,  CJK UNIFIED IDEOGRAPH-50E9
        0x50EF, # G+14343  U+50EF  uni50EF,  CJK UNIFIED IDEOGRAPH-50EF
        0x5108, # G+14344  U+5108  uni5108,  CJK UNIFIED IDEOGRAPH-5108
        0x510B, # G+14345  U+510B  uni510B,  CJK UNIFIED IDEOGRAPH-510B
        0x5110, # G+14346  U+5110  uni5110,  CJK UNIFIED IDEOGRAPH-5110
        0x511B, # G+14347  U+511B  uni511B,  CJK UNIFIED IDEOGRAPH-511B
        0x511E, # G+14348  U+511E  uni511E,  CJK UNIFIED IDEOGRAPH-511E
        0x515F, # G+14349  U+515F  uni515F,  CJK UNIFIED IDEOGRAPH-515F
        0x51A1, # G+14350  U+51A1  uni51A1,  CJK UNIFIED IDEOGRAPH-51A1
        0x51BC, # G+14351  U+51BC  uni51BC,  CJK UNIFIED IDEOGRAPH-51BC
        0x51DE, # G+14352  U+51DE  uni51DE,  CJK UNIFIED IDEOGRAPH-51DE
        0x51EE, # G+14353  U+51EE  uni51EE,  CJK UNIFIED IDEOGRAPH-51EE
        0x51F4, # G+14354  U+51F4  uni51F4,  CJK UNIFIED IDEOGRAPH-51F4
        0x5201, # G+14355  U+5201  uni5201,  CJK UNIFIED IDEOGRAPH-5201
        0x2E89, # G+14356  U+2E89  uni2E89,  CJK RADICAL KNIFE TWO
        0x5213, # G+14357  U+5213  uni5213,  CJK UNIFIED IDEOGRAPH-5213
        0x5249, # G+14358  U+5249  uni5249,  CJK UNIFIED IDEOGRAPH-5249
        0x5261, # G+14359  U+5261  uni5261,  CJK UNIFIED IDEOGRAPH-5261
        0x5266, # G+14360  U+5266  uni5266,  CJK UNIFIED IDEOGRAPH-5266
        0x5293, # G+14361  U+5293  uni5293,  CJK UNIFIED IDEOGRAPH-5293
        0x52C8, # G+14362  U+52C8  uni52C8,  CJK UNIFIED IDEOGRAPH-52C8
        0x52F0, # G+14363  U+52F0  uni52F0,  CJK UNIFIED IDEOGRAPH-52F0
        0x530A, # G+14364  U+530A  uni530A,  CJK UNIFIED IDEOGRAPH-530A
        0x530B, # G+14365  U+530B  uni530B,  CJK UNIFIED IDEOGRAPH-530B
        0x533E, # G+14366  U+533E  uni533E,  CJK UNIFIED IDEOGRAPH-533E
        0x534C, # G+14367  U+534C  uni534C,  CJK UNIFIED IDEOGRAPH-534C
        0x534B, # G+14368  U+534B  uni534B,  CJK UNIFIED IDEOGRAPH-534B
        0x5361, # G+14369  U+5361  uni5361,  CJK UNIFIED IDEOGRAPH-5361
        0x536C, # G+14370  U+536C  uni536C,  CJK UNIFIED IDEOGRAPH-536C
        0x53AB, # G+14371  U+53AB  uni53AB,  CJK UNIFIED IDEOGRAPH-53AB
        0x53DA, # G+14372  U+53DA  uni53DA,  CJK UNIFIED IDEOGRAPH-53DA
        0x53E6, # G+14373  U+53E6  uni53E6,  CJK UNIFIED IDEOGRAPH-53E6
        0x53F5, # G+14374  U+53F5  uni53F5,  CJK UNIFIED IDEOGRAPH-53F5
        0x5427, # G+14375  U+5427  uni5427,  CJK UNIFIED IDEOGRAPH-5427
        0x544D, # G+14376  U+544D  uni544D,  CJK UNIFIED IDEOGRAPH-544D
        0x5466, # G+14377  U+5466  uni5466,  CJK UNIFIED IDEOGRAPH-5466
        0x546B, # G+14378  U+546B  uni546B,  CJK UNIFIED IDEOGRAPH-546B
        0x5474, # G+14379  U+5474  uni5474,  CJK UNIFIED IDEOGRAPH-5474
        0x548D, # G+14380  U+548D  uni548D,  CJK UNIFIED IDEOGRAPH-548D
        0x5496, # G+14381  U+5496  uni5496,  CJK UNIFIED IDEOGRAPH-5496
        0x54A1, # G+14382  U+54A1  uni54A1,  CJK UNIFIED IDEOGRAPH-54A1
        0x54AD, # G+14383  U+54AD  uni54AD,  CJK UNIFIED IDEOGRAPH-54AD
        0x54B9, # G+14384  U+54B9  uni54B9,  CJK UNIFIED IDEOGRAPH-54B9
        0x54BF, # G+14385  U+54BF  uni54BF,  CJK UNIFIED IDEOGRAPH-54BF
        0x54C6, # G+14386  U+54C6  uni54C6,  CJK UNIFIED IDEOGRAPH-54C6
        0x54CD, # G+14387  U+54CD  uni54CD,  CJK UNIFIED IDEOGRAPH-54CD
        0x550E, # G+14388  U+550E  uni550E,  CJK UNIFIED IDEOGRAPH-550E
        0x552B, # G+14389  U+552B  uni552B,  CJK UNIFIED IDEOGRAPH-552B
        0x5535, # G+14390  U+5535  uni5535,  CJK UNIFIED IDEOGRAPH-5535
        0x554A, # G+14391  U+554A  uni554A,  CJK UNIFIED IDEOGRAPH-554A
        0x5560, # G+14392  U+5560  uni5560,  CJK UNIFIED IDEOGRAPH-5560
        0x5561, # G+14393  U+5561  uni5561,  CJK UNIFIED IDEOGRAPH-5561
        0x5588, # G+14394  U+5588  uni5588,  CJK UNIFIED IDEOGRAPH-5588
        0x558E, # G+14395  U+558E  uni558E,  CJK UNIFIED IDEOGRAPH-558E
        0x5608, # G+14396  U+5608  uni5608,  CJK UNIFIED IDEOGRAPH-5608
        0x560E, # G+14397  U+560E  uni560E,  CJK UNIFIED IDEOGRAPH-560E
        0x560F, # G+14398  U+560F  uni560F,  CJK UNIFIED IDEOGRAPH-560F
        0x5637, # G+14399  U+5637  uni5637,  CJK UNIFIED IDEOGRAPH-5637
        0x563F, # G+14400  U+563F  uni563F,  CJK UNIFIED IDEOGRAPH-563F
        0x5649, # G+14401  U+5649  uni5649,  CJK UNIFIED IDEOGRAPH-5649
        0x564B, # G+14402  U+564B  uni564B,  CJK UNIFIED IDEOGRAPH-564B
        0x564F, # G+14403  U+564F  uni564F,  CJK UNIFIED IDEOGRAPH-564F
        0x5666, # G+14404  U+5666  uni5666,  CJK UNIFIED IDEOGRAPH-5666
        0x5669, # G+14405  U+5669  uni5669,  CJK UNIFIED IDEOGRAPH-5669
        0x566F, # G+14406  U+566F  uni566F,  CJK UNIFIED IDEOGRAPH-566F
        0x5671, # G+14407  U+5671  uni5671,  CJK UNIFIED IDEOGRAPH-5671
        0x5672, # G+14408  U+5672  uni5672,  CJK UNIFIED IDEOGRAPH-5672
        0x5695, # G+14409  U+5695  uni5695,  CJK UNIFIED IDEOGRAPH-5695
        0x569A, # G+14410  U+569A  uni569A,  CJK UNIFIED IDEOGRAPH-569A
        0x56AC, # G+14411  U+56AC  uni56AC,  CJK UNIFIED IDEOGRAPH-56AC
        0x56AD, # G+14412  U+56AD  uni56AD,  CJK UNIFIED IDEOGRAPH-56AD
        0x56B1, # G+14413  U+56B1  uni56B1,  CJK UNIFIED IDEOGRAPH-56B1
        0x56C9, # G+14414  U+56C9  uni56C9,  CJK UNIFIED IDEOGRAPH-56C9
        0x56DD, # G+14415  U+56DD  uni56DD,  CJK UNIFIED IDEOGRAPH-56DD
        0x56E4, # G+14416  U+56E4  uni56E4,  CJK UNIFIED IDEOGRAPH-56E4
        0x570A, # G+14417  U+570A  uni570A,  CJK UNIFIED IDEOGRAPH-570A
        0x5715, # G+14418  U+5715  uni5715,  CJK UNIFIED IDEOGRAPH-5715
        0x5723, # G+14419  U+5723  uni5723,  CJK UNIFIED IDEOGRAPH-5723
        0x572F, # G+14420  U+572F  uni572F,  CJK UNIFIED IDEOGRAPH-572F
        0x5733, # G+14421  U+5733  uni5733,  CJK UNIFIED IDEOGRAPH-5733
        0x5734, # G+14422  U+5734  uni5734,  CJK UNIFIED IDEOGRAPH-5734
        0x574C, # G+14423  U+574C  uni574C,  CJK UNIFIED IDEOGRAPH-574C
        0x5770, # G+14424  U+5770  uni5770,  CJK UNIFIED IDEOGRAPH-5770
        0x578C, # G+14425  U+578C  uni578C,  CJK UNIFIED IDEOGRAPH-578C
        0x579C, # G+14426  U+579C  uni579C,  CJK UNIFIED IDEOGRAPH-579C
        0x57B8, # G+14427  U+57B8  uni57B8,  CJK UNIFIED IDEOGRAPH-57B8
        0x57E6, # G+14428  U+57E6  uni57E6,  CJK UNIFIED IDEOGRAPH-57E6
        0x57ED, # G+14429  U+57ED  uni57ED,  CJK UNIFIED IDEOGRAPH-57ED
        0x57F5, # G+14430  U+57F5  uni57F5,  CJK UNIFIED IDEOGRAPH-57F5
        0x57F6, # G+14431  U+57F6  uni57F6,  CJK UNIFIED IDEOGRAPH-57F6
        0x57FF, # G+14432  U+57FF  uni57FF,  CJK UNIFIED IDEOGRAPH-57FF
        0x5809, # G+14433  U+5809  uni5809,  CJK UNIFIED IDEOGRAPH-5809
        0x5820, # G+14434  U+5820  uni5820,  CJK UNIFIED IDEOGRAPH-5820
        0x5832, # G+14435  U+5832  uni5832,  CJK UNIFIED IDEOGRAPH-5832
        0x587C, # G+14436  U+587C  uni587C,  CJK UNIFIED IDEOGRAPH-587C
        0x5880, # G+14437  U+5880  uni5880,  CJK UNIFIED IDEOGRAPH-5880
        0x58A9, # G+14438  U+58A9  uni58A9,  CJK UNIFIED IDEOGRAPH-58A9
        0x58CE, # G+14439  U+58CE  uni58CE,  CJK UNIFIED IDEOGRAPH-58CE
        0x58D0, # G+14440  U+58D0  uni58D0,  CJK UNIFIED IDEOGRAPH-58D0
        0x58D4, # G+14441  U+58D4  uni58D4,  CJK UNIFIED IDEOGRAPH-58D4
        0x58DA, # G+14442  U+58DA  uni58DA,  CJK UNIFIED IDEOGRAPH-58DA
        0x58E9, # G+14443  U+58E9  uni58E9,  CJK UNIFIED IDEOGRAPH-58E9
        0x590C, # G+14444  U+590C  uni590C,  CJK UNIFIED IDEOGRAPH-590C
        0x5924, # G+14445  U+5924  uni5924,  CJK UNIFIED IDEOGRAPH-5924
        0x592F, # G+14446  U+592F  uni592F,  CJK UNIFIED IDEOGRAPH-592F
        0x5961, # G+14447  U+5961  uni5961,  CJK UNIFIED IDEOGRAPH-5961
        0x596D, # G+14448  U+596D  uni596D,  CJK UNIFIED IDEOGRAPH-596D
        0x59CA, # G+14449  U+59CA  uni59CA,  CJK UNIFIED IDEOGRAPH-59CA
        0x59D2, # G+14450  U+59D2  uni59D2,  CJK UNIFIED IDEOGRAPH-59D2
        0x59DD, # G+14451  U+59DD  uni59DD,  CJK UNIFIED IDEOGRAPH-59DD
        0x59E3, # G+14452  U+59E3  uni59E3,  CJK UNIFIED IDEOGRAPH-59E3
        0x59E4, # G+14453  U+59E4  uni59E4,  CJK UNIFIED IDEOGRAPH-59E4
        0x5A04, # G+14454  U+5A04  uni5A04,  CJK UNIFIED IDEOGRAPH-5A04
        0x5A0C, # G+14455  U+5A0C  uni5A0C,  CJK UNIFIED IDEOGRAPH-5A0C
        0x5A23, # G+14456  U+5A23  uni5A23,  CJK UNIFIED IDEOGRAPH-5A23
        0x5A47, # G+14457  U+5A47  uni5A47,  CJK UNIFIED IDEOGRAPH-5A47
        0x5A55, # G+14458  U+5A55  uni5A55,  CJK UNIFIED IDEOGRAPH-5A55
        0x5A63, # G+14459  U+5A63  uni5A63,  CJK UNIFIED IDEOGRAPH-5A63
        0x5A6D, # G+14460  U+5A6D  uni5A6D,  CJK UNIFIED IDEOGRAPH-5A6D
        0x5A7E, # G+14461  U+5A7E  uni5A7E,  CJK UNIFIED IDEOGRAPH-5A7E
        0x5A9E, # G+14462  U+5A9E  uni5A9E,  CJK UNIFIED IDEOGRAPH-5A9E
        0x5AA7, # G+14463  U+5AA7  uni5AA7,  CJK UNIFIED IDEOGRAPH-5AA7
        0x5AAC, # G+14464  U+5AAC  uni5AAC,  CJK UNIFIED IDEOGRAPH-5AAC
        0x5AB3, # G+14465  U+5AB3  uni5AB3,  CJK UNIFIED IDEOGRAPH-5AB3
        0x5AE0, # G+14466  U+5AE0  uni5AE0,  CJK UNIFIED IDEOGRAPH-5AE0
        0x5B00, # G+14467  U+5B00  uni5B00,  CJK UNIFIED IDEOGRAPH-5B00
        0x5B19, # G+14468  U+5B19  uni5B19,  CJK UNIFIED IDEOGRAPH-5B19
        0x5B25, # G+14469  U+5B25  uni5B25,  CJK UNIFIED IDEOGRAPH-5B25
        0x5B2D, # G+14470  U+5B2D  uni5B2D,  CJK UNIFIED IDEOGRAPH-5B2D
        0x5B41, # G+14471  U+5B41  uni5B41,  CJK UNIFIED IDEOGRAPH-5B41
        0x5B7C, # G+14472  U+5B7C  uni5B7C,  CJK UNIFIED IDEOGRAPH-5B7C
        0x5B7E, # G+14473  U+5B7E  uni5B7E,  CJK UNIFIED IDEOGRAPH-5B7E
        0x5B7F, # G+14474  U+5B7F  uni5B7F,  CJK UNIFIED IDEOGRAPH-5B7F
        0x5B8A, # G+14475  U+5B8A  uni5B8A,  CJK UNIFIED IDEOGRAPH-5B8A
        0x2E8F, # G+14476  U+2E8F  uni2E8F,  CJK RADICAL LAME TWO
        0x5C2B, # G+14477  U+5C2B  uni5C2B,  CJK UNIFIED IDEOGRAPH-5C2B
        0x5C30, # G+14478  U+5C30  uni5C30,  CJK UNIFIED IDEOGRAPH-5C30
        0x5C63, # G+14479  U+5C63  uni5C63,  CJK UNIFIED IDEOGRAPH-5C63
        0x5C69, # G+14480  U+5C69  uni5C69,  CJK UNIFIED IDEOGRAPH-5C69
        0x5C7C, # G+14481  U+5C7C  uni5C7C,  CJK UNIFIED IDEOGRAPH-5C7C
        0x5CCB, # G+14482  U+5CCB  uni5CCB,  CJK UNIFIED IDEOGRAPH-5CCB
        0x5CD2, # G+14483  U+5CD2  uni5CD2,  CJK UNIFIED IDEOGRAPH-5CD2
        0x5CF4, # G+14484  U+5CF4  uni5CF4,  CJK UNIFIED IDEOGRAPH-5CF4
        0x5D24, # G+14485  U+5D24  uni5D24,  CJK UNIFIED IDEOGRAPH-5D24
        0x5D26, # G+14486  U+5D26  uni5D26,  CJK UNIFIED IDEOGRAPH-5D26
        0x5D43, # G+14487  U+5D43  uni5D43,  CJK UNIFIED IDEOGRAPH-5D43
        0x5D46, # G+14488  U+5D46  uni5D46,  CJK UNIFIED IDEOGRAPH-5D46
        0x5D4A, # G+14489  U+5D4A  uni5D4A,  CJK UNIFIED IDEOGRAPH-5D4A
        0x5D92, # G+14490  U+5D92  uni5D92,  CJK UNIFIED IDEOGRAPH-5D92
        0x5D94, # G+14491  U+5D94  uni5D94,  CJK UNIFIED IDEOGRAPH-5D94
        0x5D99, # G+14492  U+5D99  uni5D99,  CJK UNIFIED IDEOGRAPH-5D99
        0x5DA0, # G+14493  U+5DA0  uni5DA0,  CJK UNIFIED IDEOGRAPH-5DA0
        0x5DD8, # G+14494  U+5DD8  uni5DD8,  CJK UNIFIED IDEOGRAPH-5DD8
        0x5DE0, # G+14495  U+5DE0  uni5DE0,  CJK UNIFIED IDEOGRAPH-5DE0
        0x5DF8, # G+14496  U+5DF8  uni5DF8,  CJK UNIFIED IDEOGRAPH-5DF8
        0x5E00, # G+14497  U+5E00  uni5E00,  CJK UNIFIED IDEOGRAPH-5E00
        0x5E12, # G+14498  U+5E12  uni5E12,  CJK UNIFIED IDEOGRAPH-5E12
        0x5E14, # G+14499  U+5E14  uni5E14,  CJK UNIFIED IDEOGRAPH-5E14
        0x5E15, # G+14500  U+5E15  uni5E15,  CJK UNIFIED IDEOGRAPH-5E15
        0x5E18, # G+14501  U+5E18  uni5E18,  CJK UNIFIED IDEOGRAPH-5E18
        0x5E2E, # G+14502  U+5E2E  uni5E2E,  CJK UNIFIED IDEOGRAPH-5E2E
        0x5E58, # G+14503  U+5E58  uni5E58,  CJK UNIFIED IDEOGRAPH-5E58
        0x5E6B, # G+14504  U+5E6B  uni5E6B,  CJK UNIFIED IDEOGRAPH-5E6B
        0x5E6C, # G+14505  U+5E6C  uni5E6C,  CJK UNIFIED IDEOGRAPH-5E6C
        0x5EA8, # G+14506  U+5EA8  uni5EA8,  CJK UNIFIED IDEOGRAPH-5EA8
        0x5EAA, # G+14507  U+5EAA  uni5EAA,  CJK UNIFIED IDEOGRAPH-5EAA
        0x5EBE, # G+14508  U+5EBE  uni5EBE,  CJK UNIFIED IDEOGRAPH-5EBE
        0x5EBF, # G+14509  U+5EBF  uni5EBF,  CJK UNIFIED IDEOGRAPH-5EBF
        0x5ECB, # G+14510  U+5ECB  uni5ECB,  CJK UNIFIED IDEOGRAPH-5ECB
        0x5ED2, # G+14511  U+5ED2  uni5ED2,  CJK UNIFIED IDEOGRAPH-5ED2
        0x5F07, # G+14512  U+5F07  uni5F07,  CJK UNIFIED IDEOGRAPH-5F07
        0x5F0E, # G+14513  U+5F0E  uni5F0E,  CJK UNIFIED IDEOGRAPH-5F0E
        0x5F1C, # G+14514  U+5F1C  uni5F1C,  CJK UNIFIED IDEOGRAPH-5F1C
        0x5F1D, # G+14515  U+5F1D  uni5F1D,  CJK UNIFIED IDEOGRAPH-5F1D
        0x5F22, # G+14516  U+5F22  uni5F22,  CJK UNIFIED IDEOGRAPH-5F22
        0x5F28, # G+14517  U+5F28  uni5F28,  CJK UNIFIED IDEOGRAPH-5F28
        0x5F36, # G+14518  U+5F36  uni5F36,  CJK UNIFIED IDEOGRAPH-5F36
        0x5F3B, # G+14519  U+5F3B  uni5F3B,  CJK UNIFIED IDEOGRAPH-5F3B
        0x5F40, # G+14520  U+5F40  uni5F40,  CJK UNIFIED IDEOGRAPH-5F40
        0x2F39, # G+14521  U+2F39  uni2F39,  KANGXI RADICAL SNOUT
        0x5F58, # G+14522  U+5F58  uni5F58,  CJK UNIFIED IDEOGRAPH-5F58
        0x5F64, # G+14523  U+5F64  uni5F64,  CJK UNIFIED IDEOGRAPH-5F64
        0x5F89, # G+14524  U+5F89  uni5F89,  CJK UNIFIED IDEOGRAPH-5F89
        0x5F9C, # G+14525  U+5F9C  uni5F9C,  CJK UNIFIED IDEOGRAPH-5F9C
        0x5FA7, # G+14526  U+5FA7  uni5FA7,  CJK UNIFIED IDEOGRAPH-5FA7
        0x5FA4, # G+14527  U+5FA4  uni5FA4,  CJK UNIFIED IDEOGRAPH-5FA4
        0x5FAF, # G+14528  U+5FAF  uni5FAF,  CJK UNIFIED IDEOGRAPH-5FAF
        0x5FB8, # G+14529  U+5FB8  uni5FB8,  CJK UNIFIED IDEOGRAPH-5FB8
        0x2E96, # G+14530  U+2E96  uni2E96,  CJK RADICAL HEART ONE
        0x5FC9, # G+14531  U+5FC9  uni5FC9,  CJK UNIFIED IDEOGRAPH-5FC9
        0x5FE1, # G+14532  U+5FE1  uni5FE1,  CJK UNIFIED IDEOGRAPH-5FE1
        0x5FE9, # G+14533  U+5FE9  uni5FE9,  CJK UNIFIED IDEOGRAPH-5FE9
        0x5FED, # G+14534  U+5FED  uni5FED,  CJK UNIFIED IDEOGRAPH-5FED
        0x5FFC, # G+14535  U+5FFC  uni5FFC,  CJK UNIFIED IDEOGRAPH-5FFC
        0x6017, # G+14536  U+6017  uni6017,  CJK UNIFIED IDEOGRAPH-6017
        0x601A, # G+14537  U+601A  uni601A,  CJK UNIFIED IDEOGRAPH-601A
        0x6033, # G+14538  U+6033  uni6033,  CJK UNIFIED IDEOGRAPH-6033
        0x6061, # G+14539  U+6061  uni6061,  CJK UNIFIED IDEOGRAPH-6061
        0x607F, # G+14540  U+607F  uni607F,  CJK UNIFIED IDEOGRAPH-607F
        0x609E, # G+14541  U+609E  uni609E,  CJK UNIFIED IDEOGRAPH-609E
        0x60A4, # G+14542  U+60A4  uni60A4,  CJK UNIFIED IDEOGRAPH-60A4
        0x60B0, # G+14543  U+60B0  uni60B0,  CJK UNIFIED IDEOGRAPH-60B0
        0x60CB, # G+14544  U+60CB  uni60CB,  CJK UNIFIED IDEOGRAPH-60CB
        0x60DB, # G+14545  U+60DB  uni60DB,  CJK UNIFIED IDEOGRAPH-60DB
        0x60F8, # G+14546  U+60F8  uni60F8,  CJK UNIFIED IDEOGRAPH-60F8
        0x6112, # G+14547  U+6112  uni6112,  CJK UNIFIED IDEOGRAPH-6112
        0x6113, # G+14548  U+6113  uni6113,  CJK UNIFIED IDEOGRAPH-6113
        0x6114, # G+14549  U+6114  uni6114,  CJK UNIFIED IDEOGRAPH-6114
        0x611C, # G+14550  U+611C  uni611C,  CJK UNIFIED IDEOGRAPH-611C
        0x617C, # G+14551  U+617C  uni617C,  CJK UNIFIED IDEOGRAPH-617C
        0x618D, # G+14552  U+618D  uni618D,  CJK UNIFIED IDEOGRAPH-618D
        0x619F, # G+14553  U+619F  uni619F,  CJK UNIFIED IDEOGRAPH-619F
        0x61A8, # G+14554  U+61A8  uni61A8,  CJK UNIFIED IDEOGRAPH-61A8
        0x61C2, # G+14555  U+61C2  uni61C2,  CJK UNIFIED IDEOGRAPH-61C2
        0x61DF, # G+14556  U+61DF  uni61DF,  CJK UNIFIED IDEOGRAPH-61DF
        0x6215, # G+14557  U+6215  uni6215,  CJK UNIFIED IDEOGRAPH-6215
        0x6229, # G+14558  U+6229  uni6229,  CJK UNIFIED IDEOGRAPH-6229
        0x6243, # G+14559  U+6243  uni6243,  CJK UNIFIED IDEOGRAPH-6243
        0x6246, # G+14560  U+6246  uni6246,  CJK UNIFIED IDEOGRAPH-6246
        0x2E98, # G+14561  U+2E98  uni2E98,  CJK RADICAL HAND
        0x6251, # G+14562  U+6251  uni6251,  CJK UNIFIED IDEOGRAPH-6251
        0x6256, # G+14563  U+6256  uni6256,  CJK UNIFIED IDEOGRAPH-6256
        0x62C4, # G+14564  U+62C4  uni62C4,  CJK UNIFIED IDEOGRAPH-62C4
        0x62FC, # G+14565  U+62FC  uni62FC,  CJK UNIFIED IDEOGRAPH-62FC
        0x630A, # G+14566  U+630A  uni630A,  CJK UNIFIED IDEOGRAPH-630A
        0x630D, # G+14567  U+630D  uni630D,  CJK UNIFIED IDEOGRAPH-630D
        0x6318, # G+14568  U+6318  uni6318,  CJK UNIFIED IDEOGRAPH-6318
        0x6339, # G+14569  U+6339  uni6339,  CJK UNIFIED IDEOGRAPH-6339
        0x6342, # G+14570  U+6342  uni6342,  CJK UNIFIED IDEOGRAPH-6342
        0x6343, # G+14571  U+6343  uni6343,  CJK UNIFIED IDEOGRAPH-6343
        0x6365, # G+14572  U+6365  uni6365,  CJK UNIFIED IDEOGRAPH-6365
        0x6374, # G+14573  U+6374  uni6374,  CJK UNIFIED IDEOGRAPH-6374
        0x637D, # G+14574  U+637D  uni637D,  CJK UNIFIED IDEOGRAPH-637D
        0x6384, # G+14575  U+6384  uni6384,  CJK UNIFIED IDEOGRAPH-6384
        0x6387, # G+14576  U+6387  uni6387,  CJK UNIFIED IDEOGRAPH-6387
        0x6390, # G+14577  U+6390  uni6390,  CJK UNIFIED IDEOGRAPH-6390
        0x639E, # G+14578  U+639E  uni639E,  CJK UNIFIED IDEOGRAPH-639E
        0x63D1, # G+14579  U+63D1  uni63D1,  CJK UNIFIED IDEOGRAPH-63D1
        0x63DC, # G+14580  U+63DC  uni63DC,  CJK UNIFIED IDEOGRAPH-63DC
        0x6409, # G+14581  U+6409  uni6409,  CJK UNIFIED IDEOGRAPH-6409
        0x6410, # G+14582  U+6410  uni6410,  CJK UNIFIED IDEOGRAPH-6410
        0x6422, # G+14583  U+6422  uni6422,  CJK UNIFIED IDEOGRAPH-6422
        0x6454, # G+14584  U+6454  uni6454,  CJK UNIFIED IDEOGRAPH-6454
        0x645B, # G+14585  U+645B  uni645B,  CJK UNIFIED IDEOGRAPH-645B
        0x646D, # G+14586  U+646D  uni646D,  CJK UNIFIED IDEOGRAPH-646D
        0x647B, # G+14587  U+647B  uni647B,  CJK UNIFIED IDEOGRAPH-647B
        0x64BE, # G+14588  U+64BE  uni64BE,  CJK UNIFIED IDEOGRAPH-64BE
        0x64BF, # G+14589  U+64BF  uni64BF,  CJK UNIFIED IDEOGRAPH-64BF
        0x64E5, # G+14590  U+64E5  uni64E5,  CJK UNIFIED IDEOGRAPH-64E5
        0x64F7, # G+14591  U+64F7  uni64F7,  CJK UNIFIED IDEOGRAPH-64F7
        0x64FB, # G+14592  U+64FB  uni64FB,  CJK UNIFIED IDEOGRAPH-64FB
        0x6504, # G+14593  U+6504  uni6504,  CJK UNIFIED IDEOGRAPH-6504
        0x6516, # G+14594  U+6516  uni6516,  CJK UNIFIED IDEOGRAPH-6516
        0x6519, # G+14595  U+6519  uni6519,  CJK UNIFIED IDEOGRAPH-6519
        0x6547, # G+14596  U+6547  uni6547,  CJK UNIFIED IDEOGRAPH-6547
        0x6567, # G+14597  U+6567  uni6567,  CJK UNIFIED IDEOGRAPH-6567
        0x6581, # G+14598  U+6581  uni6581,  CJK UNIFIED IDEOGRAPH-6581
        0x6585, # G+14599  U+6585  uni6585,  CJK UNIFIED IDEOGRAPH-6585
        0x65C2, # G+14600  U+65C2  uni65C2,  CJK UNIFIED IDEOGRAPH-65C2
        0x65F0, # G+14601  U+65F0  uni65F0,  CJK UNIFIED IDEOGRAPH-65F0
        0x65F2, # G+14602  U+65F2  uni65F2,  CJK UNIFIED IDEOGRAPH-65F2
        0x662C, # G+14603  U+662C  uni662C,  CJK UNIFIED IDEOGRAPH-662C
        0x664C, # G+14604  U+664C  uni664C,  CJK UNIFIED IDEOGRAPH-664C
        0x665B, # G+14605  U+665B  uni665B,  CJK UNIFIED IDEOGRAPH-665B
        0x665C, # G+14606  U+665C  uni665C,  CJK UNIFIED IDEOGRAPH-665C
        0x6661, # G+14607  U+6661  uni6661,  CJK UNIFIED IDEOGRAPH-6661
        0x666B, # G+14608  U+666B  uni666B,  CJK UNIFIED IDEOGRAPH-666B
        0x6677, # G+14609  U+6677  uni6677,  CJK UNIFIED IDEOGRAPH-6677
        0x66A4, # G+14610  U+66A4  uni66A4,  CJK UNIFIED IDEOGRAPH-66A4
        0x66C8, # G+14611  U+66C8  uni66C8,  CJK UNIFIED IDEOGRAPH-66C8
        0x66EC, # G+14612  U+66EC  uni66EC,  CJK UNIFIED IDEOGRAPH-66EC
        0x6705, # G+14613  U+6705  uni6705,  CJK UNIFIED IDEOGRAPH-6705
        0x6713, # G+14614  U+6713  uni6713,  CJK UNIFIED IDEOGRAPH-6713
        0x6733, # G+14615  U+6733  uni6733,  CJK UNIFIED IDEOGRAPH-6733
        0x6748, # G+14616  U+6748  uni6748,  CJK UNIFIED IDEOGRAPH-6748
        0x674C, # G+14617  U+674C  uni674C,  CJK UNIFIED IDEOGRAPH-674C
        0x6776, # G+14618  U+6776  uni6776,  CJK UNIFIED IDEOGRAPH-6776
        0x677B, # G+14619  U+677B  uni677B,  CJK UNIFIED IDEOGRAPH-677B
        0x67B0, # G+14620  U+67B0  uni67B0,  CJK UNIFIED IDEOGRAPH-67B0
        0x67B2, # G+14621  U+67B2  uni67B2,  CJK UNIFIED IDEOGRAPH-67B2
        0x67F9, # G+14622  U+67F9  uni67F9,  CJK UNIFIED IDEOGRAPH-67F9
        0x67D7, # G+14623  U+67D7  uni67D7,  CJK UNIFIED IDEOGRAPH-67D7
        0x67D9, # G+14624  U+67D9  uni67D9,  CJK UNIFIED IDEOGRAPH-67D9
        0x67F0, # G+14625  U+67F0  uni67F0,  CJK UNIFIED IDEOGRAPH-67F0
        0x682C, # G+14626  U+682C  uni682C,  CJK UNIFIED IDEOGRAPH-682C
        0x6830, # G+14627  U+6830  uni6830,  CJK UNIFIED IDEOGRAPH-6830
        0x6831, # G+14628  U+6831  uni6831,  CJK UNIFIED IDEOGRAPH-6831
        0x685B, # G+14629  U+685B  uni685B,  CJK UNIFIED IDEOGRAPH-685B
        0x6872, # G+14630  U+6872  uni6872,  CJK UNIFIED IDEOGRAPH-6872
        0x6875, # G+14631  U+6875  uni6875,  CJK UNIFIED IDEOGRAPH-6875
        0x687A, # G+14632  U+687A  uni687A,  CJK UNIFIED IDEOGRAPH-687A
        0x6884, # G+14633  U+6884  uni6884,  CJK UNIFIED IDEOGRAPH-6884
        0x68A5, # G+14634  U+68A5  uni68A5,  CJK UNIFIED IDEOGRAPH-68A5
        0x68B2, # G+14635  U+68B2  uni68B2,  CJK UNIFIED IDEOGRAPH-68B2
        0x68D0, # G+14636  U+68D0  uni68D0,  CJK UNIFIED IDEOGRAPH-68D0
        0x68D6, # G+14637  U+68D6  uni68D6,  CJK UNIFIED IDEOGRAPH-68D6
        0x68E8, # G+14638  U+68E8  uni68E8,  CJK UNIFIED IDEOGRAPH-68E8
        0x68ED, # G+14639  U+68ED  uni68ED,  CJK UNIFIED IDEOGRAPH-68ED
        0x68F0, # G+14640  U+68F0  uni68F0,  CJK UNIFIED IDEOGRAPH-68F0
        0x68F1, # G+14641  U+68F1  uni68F1,  CJK UNIFIED IDEOGRAPH-68F1
        0x68FC, # G+14642  U+68FC  uni68FC,  CJK UNIFIED IDEOGRAPH-68FC
        0x6911, # G+14643  U+6911  uni6911,  CJK UNIFIED IDEOGRAPH-6911
        0x6913, # G+14644  U+6913  uni6913,  CJK UNIFIED IDEOGRAPH-6913
        0x6935, # G+14645  U+6935  uni6935,  CJK UNIFIED IDEOGRAPH-6935
        0x693B, # G+14646  U+693B  uni693B,  CJK UNIFIED IDEOGRAPH-693B
        0x6957, # G+14647  U+6957  uni6957,  CJK UNIFIED IDEOGRAPH-6957
        0x6963, # G+14648  U+6963  uni6963,  CJK UNIFIED IDEOGRAPH-6963
        0x6972, # G+14649  U+6972  uni6972,  CJK UNIFIED IDEOGRAPH-6972
        0x697F, # G+14650  U+697F  uni697F,  CJK UNIFIED IDEOGRAPH-697F
        0x6980, # G+14651  U+6980  uni6980,  CJK UNIFIED IDEOGRAPH-6980
        0x69A6, # G+14652  U+69A6  uni69A6,  CJK UNIFIED IDEOGRAPH-69A6
        0x69AD, # G+14653  U+69AD  uni69AD,  CJK UNIFIED IDEOGRAPH-69AD
        0x69B7, # G+14654  U+69B7  uni69B7,  CJK UNIFIED IDEOGRAPH-69B7
        0x69D6, # G+14655  U+69D6  uni69D6,  CJK UNIFIED IDEOGRAPH-69D6
        0x69D7, # G+14656  U+69D7  uni69D7,  CJK UNIFIED IDEOGRAPH-69D7
        0x6A01, # G+14657  U+6A01  uni6A01,  CJK UNIFIED IDEOGRAPH-6A01
        0x6A0F, # G+14658  U+6A0F  uni6A0F,  CJK UNIFIED IDEOGRAPH-6A0F
        0x6A15, # G+14659  U+6A15  uni6A15,  CJK UNIFIED IDEOGRAPH-6A15
        0x6A28, # G+14660  U+6A28  uni6A28,  CJK UNIFIED IDEOGRAPH-6A28
        0x6A34, # G+14661  U+6A34  uni6A34,  CJK UNIFIED IDEOGRAPH-6A34
        0x6A3E, # G+14662  U+6A3E  uni6A3E,  CJK UNIFIED IDEOGRAPH-6A3E
        0x6A45, # G+14663  U+6A45  uni6A45,  CJK UNIFIED IDEOGRAPH-6A45
        0x6A50, # G+14664  U+6A50  uni6A50,  CJK UNIFIED IDEOGRAPH-6A50
        0x6A51, # G+14665  U+6A51  uni6A51,  CJK UNIFIED IDEOGRAPH-6A51
        0x6A56, # G+14666  U+6A56  uni6A56,  CJK UNIFIED IDEOGRAPH-6A56
        0x6A5B, # G+14667  U+6A5B  uni6A5B,  CJK UNIFIED IDEOGRAPH-6A5B
        0x6A83, # G+14668  U+6A83  uni6A83,  CJK UNIFIED IDEOGRAPH-6A83
        0x6A89, # G+14669  U+6A89  uni6A89,  CJK UNIFIED IDEOGRAPH-6A89
        0x6A91, # G+14670  U+6A91  uni6A91,  CJK UNIFIED IDEOGRAPH-6A91
        0x6A9D, # G+14671  U+6A9D  uni6A9D,  CJK UNIFIED IDEOGRAPH-6A9D
        0x6A9E, # G+14672  U+6A9E  uni6A9E,  CJK UNIFIED IDEOGRAPH-6A9E
        0x6A9F, # G+14673  U+6A9F  uni6A9F,  CJK UNIFIED IDEOGRAPH-6A9F
        0x6ADC, # G+14674  U+6ADC  uni6ADC,  CJK UNIFIED IDEOGRAPH-6ADC
        0x6AE7, # G+14675  U+6AE7  uni6AE7,  CJK UNIFIED IDEOGRAPH-6AE7
        0x6AEC, # G+14676  U+6AEC  uni6AEC,  CJK UNIFIED IDEOGRAPH-6AEC
        0x6B1E, # G+14677  U+6B1E  uni6B1E,  CJK UNIFIED IDEOGRAPH-6B1E
        0x6B24, # G+14678  U+6B24  uni6B24,  CJK UNIFIED IDEOGRAPH-6B24
        0x6B35, # G+14679  U+6B35  uni6B35,  CJK UNIFIED IDEOGRAPH-6B35
        0x6B46, # G+14680  U+6B46  uni6B46,  CJK UNIFIED IDEOGRAPH-6B46
        0x6B56, # G+14681  U+6B56  uni6B56,  CJK UNIFIED IDEOGRAPH-6B56
        0x6B60, # G+14682  U+6B60  uni6B60,  CJK UNIFIED IDEOGRAPH-6B60
        0x6B82, # G+14683  U+6B82  uni6B82,  CJK UNIFIED IDEOGRAPH-6B82
        0x6BBE, # G+14684  U+6BBE  uni6BBE,  CJK UNIFIED IDEOGRAPH-6BBE
        0x6BE1, # G+14685  U+6BE1  uni6BE1,  CJK UNIFIED IDEOGRAPH-6BE1
        0x6BF1, # G+14686  U+6BF1  uni6BF1,  CJK UNIFIED IDEOGRAPH-6BF1
        0x6C10, # G+14687  U+6C10  uni6C10,  CJK UNIFIED IDEOGRAPH-6C10
        0x6C33, # G+14688  U+6C33  uni6C33,  CJK UNIFIED IDEOGRAPH-6C33
        0x2EA1, # G+14689  U+2EA1  uni2EA1,  CJK RADICAL WATER ONE
        0x2EA2, # G+14690  U+2EA2  uni2EA2,  CJK RADICAL WATER TWO
        0x6C59, # G+14691  U+6C59  uni6C59,  CJK UNIFIED IDEOGRAPH-6C59
        0x6C76, # G+14692  U+6C76  uni6C76,  CJK UNIFIED IDEOGRAPH-6C76
        0x6C7B, # G+14693  U+6C7B  uni6C7B,  CJK UNIFIED IDEOGRAPH-6C7B
        0x6C85, # G+14694  U+6C85  uni6C85,  CJK UNIFIED IDEOGRAPH-6C85
        0x6C95, # G+14695  U+6C95  uni6C95,  CJK UNIFIED IDEOGRAPH-6C95
        0x6C9C, # G+14696  U+6C9C  uni6C9C,  CJK UNIFIED IDEOGRAPH-6C9C
        0x6CD0, # G+14697  U+6CD0  uni6CD0,  CJK UNIFIED IDEOGRAPH-6CD0
        0x6CD4, # G+14698  U+6CD4  uni6CD4,  CJK UNIFIED IDEOGRAPH-6CD4
        0x6CD6, # G+14699  U+6CD6  uni6CD6,  CJK UNIFIED IDEOGRAPH-6CD6
        0x6CE0, # G+14700  U+6CE0  uni6CE0,  CJK UNIFIED IDEOGRAPH-6CE0
        0x6CEB, # G+14701  U+6CEB  uni6CEB,  CJK UNIFIED IDEOGRAPH-6CEB
        0x6CEC, # G+14702  U+6CEC  uni6CEC,  CJK UNIFIED IDEOGRAPH-6CEC
        0x6CEE, # G+14703  U+6CEE  uni6CEE,  CJK UNIFIED IDEOGRAPH-6CEE
        0x6D0A, # G+14704  U+6D0A  uni6D0A,  CJK UNIFIED IDEOGRAPH-6D0A
        0x6D0E, # G+14705  U+6D0E  uni6D0E,  CJK UNIFIED IDEOGRAPH-6D0E
        0x6D11, # G+14706  U+6D11  uni6D11,  CJK UNIFIED IDEOGRAPH-6D11
        0x6D2E, # G+14707  U+6D2E  uni6D2E,  CJK UNIFIED IDEOGRAPH-6D2E
        0x6D57, # G+14708  U+6D57  uni6D57,  CJK UNIFIED IDEOGRAPH-6D57
        0x6D5E, # G+14709  U+6D5E  uni6D5E,  CJK UNIFIED IDEOGRAPH-6D5E
        0x6D65, # G+14710  U+6D65  uni6D65,  CJK UNIFIED IDEOGRAPH-6D65
        0x6D82, # G+14711  U+6D82  uni6D82,  CJK UNIFIED IDEOGRAPH-6D82
        0x6DBF, # G+14712  U+6DBF  uni6DBF,  CJK UNIFIED IDEOGRAPH-6DBF
        0x6DC4, # G+14713  U+6DC4  uni6DC4,  CJK UNIFIED IDEOGRAPH-6DC4
        0x6DCA, # G+14714  U+6DCA  uni6DCA,  CJK UNIFIED IDEOGRAPH-6DCA
        0x6DD6, # G+14715  U+6DD6  uni6DD6,  CJK UNIFIED IDEOGRAPH-6DD6
        0x6DE9, # G+14716  U+6DE9  uni6DE9,  CJK UNIFIED IDEOGRAPH-6DE9
        0x6E22, # G+14717  U+6E22  uni6E22,  CJK UNIFIED IDEOGRAPH-6E22
        0x6E51, # G+14718  U+6E51  uni6E51,  CJK UNIFIED IDEOGRAPH-6E51
        0x6EC7, # G+14719  U+6EC7  uni6EC7,  CJK UNIFIED IDEOGRAPH-6EC7
        0x6ECA, # G+14720  U+6ECA  uni6ECA,  CJK UNIFIED IDEOGRAPH-6ECA
        0x6ECE, # G+14721  U+6ECE  uni6ECE,  CJK UNIFIED IDEOGRAPH-6ECE
        0x6EFD, # G+14722  U+6EFD  uni6EFD,  CJK UNIFIED IDEOGRAPH-6EFD
        0x6F1A, # G+14723  U+6F1A  uni6F1A,  CJK UNIFIED IDEOGRAPH-6F1A
        0x6F2A, # G+14724  U+6F2A  uni6F2A,  CJK UNIFIED IDEOGRAPH-6F2A
        0x6F2F, # G+14725  U+6F2F  uni6F2F,  CJK UNIFIED IDEOGRAPH-6F2F
        0x6F33, # G+14726  U+6F33  uni6F33,  CJK UNIFIED IDEOGRAPH-6F33
        0x6F5A, # G+14727  U+6F5A  uni6F5A,  CJK UNIFIED IDEOGRAPH-6F5A
        0x6F5E, # G+14728  U+6F5E  uni6F5E,  CJK UNIFIED IDEOGRAPH-6F5E
        0x6F62, # G+14729  U+6F62  uni6F62,  CJK UNIFIED IDEOGRAPH-6F62
        0x6F7D, # G+14730  U+6F7D  uni6F7D,  CJK UNIFIED IDEOGRAPH-6F7D
        0x6F8B, # G+14731  U+6F8B  uni6F8B,  CJK UNIFIED IDEOGRAPH-6F8B
        0x6F8D, # G+14732  U+6F8D  uni6F8D,  CJK UNIFIED IDEOGRAPH-6F8D
        0x6F92, # G+14733  U+6F92  uni6F92,  CJK UNIFIED IDEOGRAPH-6F92
        0x6F94, # G+14734  U+6F94  uni6F94,  CJK UNIFIED IDEOGRAPH-6F94
        0x6F9A, # G+14735  U+6F9A  uni6F9A,  CJK UNIFIED IDEOGRAPH-6F9A
        0x6FA7, # G+14736  U+6FA7  uni6FA7,  CJK UNIFIED IDEOGRAPH-6FA7
        0x6FA8, # G+14737  U+6FA8  uni6FA8,  CJK UNIFIED IDEOGRAPH-6FA8
        0x6FB6, # G+14738  U+6FB6  uni6FB6,  CJK UNIFIED IDEOGRAPH-6FB6
        0x6FDA, # G+14739  U+6FDA  uni6FDA,  CJK UNIFIED IDEOGRAPH-6FDA
        0x6FDE, # G+14740  U+6FDE  uni6FDE,  CJK UNIFIED IDEOGRAPH-6FDE
        0x6FF9, # G+14741  U+6FF9  uni6FF9,  CJK UNIFIED IDEOGRAPH-6FF9
        0x7039, # G+14742  U+7039  uni7039,  CJK UNIFIED IDEOGRAPH-7039
        0x703C, # G+14743  U+703C  uni703C,  CJK UNIFIED IDEOGRAPH-703C
        0x704A, # G+14744  U+704A  uni704A,  CJK UNIFIED IDEOGRAPH-704A
        0x7054, # G+14745  U+7054  uni7054,  CJK UNIFIED IDEOGRAPH-7054
        0x705D, # G+14746  U+705D  uni705D,  CJK UNIFIED IDEOGRAPH-705D
        0x705E, # G+14747  U+705E  uni705E,  CJK UNIFIED IDEOGRAPH-705E
        0x7064, # G+14748  U+7064  uni7064,  CJK UNIFIED IDEOGRAPH-7064
        0x2EA3, # G+14749  U+2EA3  uni2EA3,  CJK RADICAL FIRE
        0x707E, # G+14750  U+707E  uni707E,  CJK UNIFIED IDEOGRAPH-707E
        0x7081, # G+14751  U+7081  uni7081,  CJK UNIFIED IDEOGRAPH-7081
        0x7095, # G+14752  U+7095  uni7095,  CJK UNIFIED IDEOGRAPH-7095
        0x70B7, # G+14753  U+70B7  uni70B7,  CJK UNIFIED IDEOGRAPH-70B7
        0x70D3, # G+14754  U+70D3  uni70D3,  CJK UNIFIED IDEOGRAPH-70D3
        0x70D4, # G+14755  U+70D4  uni70D4,  CJK UNIFIED IDEOGRAPH-70D4
        0x70D8, # G+14756  U+70D8  uni70D8,  CJK UNIFIED IDEOGRAPH-70D8
        0x70DC, # G+14757  U+70DC  uni70DC,  CJK UNIFIED IDEOGRAPH-70DC
        0x7107, # G+14758  U+7107  uni7107,  CJK UNIFIED IDEOGRAPH-7107
        0x7120, # G+14759  U+7120  uni7120,  CJK UNIFIED IDEOGRAPH-7120
        0x7131, # G+14760  U+7131  uni7131,  CJK UNIFIED IDEOGRAPH-7131
        0x714A, # G+14761  U+714A  uni714A,  CJK UNIFIED IDEOGRAPH-714A
        0x7152, # G+14762  U+7152  uni7152,  CJK UNIFIED IDEOGRAPH-7152
        0x7160, # G+14763  U+7160  uni7160,  CJK UNIFIED IDEOGRAPH-7160
        0x7179, # G+14764  U+7179  uni7179,  CJK UNIFIED IDEOGRAPH-7179
        0x7192, # G+14765  U+7192  uni7192,  CJK UNIFIED IDEOGRAPH-7192
        0x71B3, # G+14766  U+71B3  uni71B3,  CJK UNIFIED IDEOGRAPH-71B3
        0x71CB, # G+14767  U+71CB  uni71CB,  CJK UNIFIED IDEOGRAPH-71CB
        0x71D3, # G+14768  U+71D3  uni71D3,  CJK UNIFIED IDEOGRAPH-71D3
        0x71D6, # G+14769  U+71D6  uni71D6,  CJK UNIFIED IDEOGRAPH-71D6
        0x7200, # G+14770  U+7200  uni7200,  CJK UNIFIED IDEOGRAPH-7200
        0x721D, # G+14771  U+721D  uni721D,  CJK UNIFIED IDEOGRAPH-721D
        0x722B, # G+14772  U+722B  uni722B,  CJK UNIFIED IDEOGRAPH-722B
        0x7238, # G+14773  U+7238  uni7238,  CJK UNIFIED IDEOGRAPH-7238
        0x7241, # G+14774  U+7241  uni7241,  CJK UNIFIED IDEOGRAPH-7241
        0x7253, # G+14775  U+7253  uni7253,  CJK UNIFIED IDEOGRAPH-7253
        0x7255, # G+14776  U+7255  uni7255,  CJK UNIFIED IDEOGRAPH-7255
        0x7256, # G+14777  U+7256  uni7256,  CJK UNIFIED IDEOGRAPH-7256
        0x725C, # G+14778  U+725C  uni725C,  CJK UNIFIED IDEOGRAPH-725C
        0x728D, # G+14779  U+728D  uni728D,  CJK UNIFIED IDEOGRAPH-728D
        0x2EA8, # G+14780  U+2EA8  uni2EA8,  CJK RADICAL DOG
        0x72B4, # G+14781  U+72B4  uni72B4,  CJK UNIFIED IDEOGRAPH-72B4
        0x72C7, # G+14782  U+72C7  uni72C7,  CJK UNIFIED IDEOGRAPH-72C7
        0x72FB, # G+14783  U+72FB  uni72FB,  CJK UNIFIED IDEOGRAPH-72FB
        0x7304, # G+14784  U+7304  uni7304,  CJK UNIFIED IDEOGRAPH-7304
        0x7305, # G+14785  U+7305  uni7305,  CJK UNIFIED IDEOGRAPH-7305
        0x7328, # G+14786  U+7328  uni7328,  CJK UNIFIED IDEOGRAPH-7328
        0x7331, # G+14787  U+7331  uni7331,  CJK UNIFIED IDEOGRAPH-7331
        0x7343, # G+14788  U+7343  uni7343,  CJK UNIFIED IDEOGRAPH-7343
        0x736C, # G+14789  U+736C  uni736C,  CJK UNIFIED IDEOGRAPH-736C
        0x737C, # G+14790  U+737C  uni737C,  CJK UNIFIED IDEOGRAPH-737C
        0x7383, # G+14791  U+7383  uni7383,  CJK UNIFIED IDEOGRAPH-7383
        0x7385, # G+14792  U+7385  uni7385,  CJK UNIFIED IDEOGRAPH-7385
        0x7386, # G+14793  U+7386  uni7386,  CJK UNIFIED IDEOGRAPH-7386
        0x7395, # G+14794  U+7395  uni7395,  CJK UNIFIED IDEOGRAPH-7395
        0x739E, # G+14795  U+739E  uni739E,  CJK UNIFIED IDEOGRAPH-739E
        0x739F, # G+14796  U+739F  uni739F,  CJK UNIFIED IDEOGRAPH-739F
        0x73A0, # G+14797  U+73A0  uni73A0,  CJK UNIFIED IDEOGRAPH-73A0
        0x73A6, # G+14798  U+73A6  uni73A6,  CJK UNIFIED IDEOGRAPH-73A6
        0x73AB, # G+14799  U+73AB  uni73AB,  CJK UNIFIED IDEOGRAPH-73AB
        0x73B5, # G+14800  U+73B5  uni73B5,  CJK UNIFIED IDEOGRAPH-73B5
        0x73B7, # G+14801  U+73B7  uni73B7,  CJK UNIFIED IDEOGRAPH-73B7
        0x73BC, # G+14802  U+73BC  uni73BC,  CJK UNIFIED IDEOGRAPH-73BC
        0x73CF, # G+14803  U+73CF  uni73CF,  CJK UNIFIED IDEOGRAPH-73CF
        0x73D9, # G+14804  U+73D9  uni73D9,  CJK UNIFIED IDEOGRAPH-73D9
        0x73E9, # G+14805  U+73E9  uni73E9,  CJK UNIFIED IDEOGRAPH-73E9
        0x73F4, # G+14806  U+73F4  uni73F4,  CJK UNIFIED IDEOGRAPH-73F4
        0x73FD, # G+14807  U+73FD  uni73FD,  CJK UNIFIED IDEOGRAPH-73FD
        0x7404, # G+14808  U+7404  uni7404,  CJK UNIFIED IDEOGRAPH-7404
        0x740A, # G+14809  U+740A  uni740A,  CJK UNIFIED IDEOGRAPH-740A
        0x741A, # G+14810  U+741A  uni741A,  CJK UNIFIED IDEOGRAPH-741A
        0x741B, # G+14811  U+741B  uni741B,  CJK UNIFIED IDEOGRAPH-741B
        0x7424, # G+14812  U+7424  uni7424,  CJK UNIFIED IDEOGRAPH-7424
        0x7428, # G+14813  U+7428  uni7428,  CJK UNIFIED IDEOGRAPH-7428
        0x742C, # G+14814  U+742C  uni742C,  CJK UNIFIED IDEOGRAPH-742C
        0x742F, # G+14815  U+742F  uni742F,  CJK UNIFIED IDEOGRAPH-742F
        0x7430, # G+14816  U+7430  uni7430,  CJK UNIFIED IDEOGRAPH-7430
        0x7431, # G+14817  U+7431  uni7431,  CJK UNIFIED IDEOGRAPH-7431
        0x7439, # G+14818  U+7439  uni7439,  CJK UNIFIED IDEOGRAPH-7439
        0x7444, # G+14819  U+7444  uni7444,  CJK UNIFIED IDEOGRAPH-7444
        0x7447, # G+14820  U+7447  uni7447,  CJK UNIFIED IDEOGRAPH-7447
        0x744B, # G+14821  U+744B  uni744B,  CJK UNIFIED IDEOGRAPH-744B
        0x744D, # G+14822  U+744D  uni744D,  CJK UNIFIED IDEOGRAPH-744D
        0x7451, # G+14823  U+7451  uni7451,  CJK UNIFIED IDEOGRAPH-7451
        0x7457, # G+14824  U+7457  uni7457,  CJK UNIFIED IDEOGRAPH-7457
        0x7466, # G+14825  U+7466  uni7466,  CJK UNIFIED IDEOGRAPH-7466
        0x746B, # G+14826  U+746B  uni746B,  CJK UNIFIED IDEOGRAPH-746B
        0x7471, # G+14827  U+7471  uni7471,  CJK UNIFIED IDEOGRAPH-7471
        0x7480, # G+14828  U+7480  uni7480,  CJK UNIFIED IDEOGRAPH-7480
        0x7485, # G+14829  U+7485  uni7485,  CJK UNIFIED IDEOGRAPH-7485
        0x7486, # G+14830  U+7486  uni7486,  CJK UNIFIED IDEOGRAPH-7486
        0x7487, # G+14831  U+7487  uni7487,  CJK UNIFIED IDEOGRAPH-7487
        0x7490, # G+14832  U+7490  uni7490,  CJK UNIFIED IDEOGRAPH-7490
        0x7498, # G+14833  U+7498  uni7498,  CJK UNIFIED IDEOGRAPH-7498
        0x749C, # G+14834  U+749C  uni749C,  CJK UNIFIED IDEOGRAPH-749C
        0x74A0, # G+14835  U+74A0  uni74A0,  CJK UNIFIED IDEOGRAPH-74A0
        0x74A3, # G+14836  U+74A3  uni74A3,  CJK UNIFIED IDEOGRAPH-74A3
        0x74A8, # G+14837  U+74A8  uni74A8,  CJK UNIFIED IDEOGRAPH-74A8
        0x74AB, # G+14838  U+74AB  uni74AB,  CJK UNIFIED IDEOGRAPH-74AB
        0x74B5, # G+14839  U+74B5  uni74B5,  CJK UNIFIED IDEOGRAPH-74B5
        0x74BF, # G+14840  U+74BF  uni74BF,  CJK UNIFIED IDEOGRAPH-74BF
        0x74C8, # G+14841  U+74C8  uni74C8,  CJK UNIFIED IDEOGRAPH-74C8
        0x74DA, # G+14842  U+74DA  uni74DA,  CJK UNIFIED IDEOGRAPH-74DA
        0x74DE, # G+14843  U+74DE  uni74DE,  CJK UNIFIED IDEOGRAPH-74DE
        0x754E, # G+14844  U+754E  uni754E,  CJK UNIFIED IDEOGRAPH-754E
        0x7579, # G+14845  U+7579  uni7579,  CJK UNIFIED IDEOGRAPH-7579
        0x7581, # G+14846  U+7581  uni7581,  CJK UNIFIED IDEOGRAPH-7581
        0x7590, # G+14847  U+7590  uni7590,  CJK UNIFIED IDEOGRAPH-7590
        0x2F67, # G+14848  U+2F67  uni2F67,  KANGXI RADICAL SICKNESS
        0x7593, # G+14849  U+7593  uni7593,  CJK UNIFIED IDEOGRAPH-7593
        0x75B4, # G+14850  U+75B4  uni75B4,  CJK UNIFIED IDEOGRAPH-75B4
        0x75E4, # G+14851  U+75E4  uni75E4,  CJK UNIFIED IDEOGRAPH-75E4
        0x75F9, # G+14852  U+75F9  uni75F9,  CJK UNIFIED IDEOGRAPH-75F9
        0x7600, # G+14853  U+7600  uni7600,  CJK UNIFIED IDEOGRAPH-7600
        0x760A, # G+14854  U+760A  uni760A,  CJK UNIFIED IDEOGRAPH-760A
        0x7615, # G+14855  U+7615  uni7615,  CJK UNIFIED IDEOGRAPH-7615
        0x7616, # G+14856  U+7616  uni7616,  CJK UNIFIED IDEOGRAPH-7616
        0x7619, # G+14857  U+7619  uni7619,  CJK UNIFIED IDEOGRAPH-7619
        0x761E, # G+14858  U+761E  uni761E,  CJK UNIFIED IDEOGRAPH-761E
        0x762D, # G+14859  U+762D  uni762D,  CJK UNIFIED IDEOGRAPH-762D
        0x7635, # G+14860  U+7635  uni7635,  CJK UNIFIED IDEOGRAPH-7635
        0x7643, # G+14861  U+7643  uni7643,  CJK UNIFIED IDEOGRAPH-7643
        0x764B, # G+14862  U+764B  uni764B,  CJK UNIFIED IDEOGRAPH-764B
        0x7665, # G+14863  U+7665  uni7665,  CJK UNIFIED IDEOGRAPH-7665
        0x766D, # G+14864  U+766D  uni766D,  CJK UNIFIED IDEOGRAPH-766D
        0x766F, # G+14865  U+766F  uni766F,  CJK UNIFIED IDEOGRAPH-766F
        0x7671, # G+14866  U+7671  uni7671,  CJK UNIFIED IDEOGRAPH-7671
        0x7674, # G+14867  U+7674  uni7674,  CJK UNIFIED IDEOGRAPH-7674
        0x76A4, # G+14868  U+76A4  uni76A4,  CJK UNIFIED IDEOGRAPH-76A4
        0x76A5, # G+14869  U+76A5  uni76A5,  CJK UNIFIED IDEOGRAPH-76A5
        0x76C5, # G+14870  U+76C5  uni76C5,  CJK UNIFIED IDEOGRAPH-76C5
        0x76CC, # G+14871  U+76CC  uni76CC,  CJK UNIFIED IDEOGRAPH-76CC
        0x76EC, # G+14872  U+76EC  uni76EC,  CJK UNIFIED IDEOGRAPH-76EC
        0x76FC, # G+14873  U+76FC  uni76FC,  CJK UNIFIED IDEOGRAPH-76FC
        0x7734, # G+14874  U+7734  uni7734,  CJK UNIFIED IDEOGRAPH-7734
        0x7736, # G+14875  U+7736  uni7736,  CJK UNIFIED IDEOGRAPH-7736
        0x775C, # G+14876  U+775C  uni775C,  CJK UNIFIED IDEOGRAPH-775C
        0x775F, # G+14877  U+775F  uni775F,  CJK UNIFIED IDEOGRAPH-775F
        0x7760, # G+14878  U+7760  uni7760,  CJK UNIFIED IDEOGRAPH-7760
        0x7772, # G+14879  U+7772  uni7772,  CJK UNIFIED IDEOGRAPH-7772
        0x777D, # G+14880  U+777D  uni777D,  CJK UNIFIED IDEOGRAPH-777D
        0x7795, # G+14881  U+7795  uni7795,  CJK UNIFIED IDEOGRAPH-7795
        0x77AA, # G+14882  U+77AA  uni77AA,  CJK UNIFIED IDEOGRAPH-77AA
        0x77E6, # G+14883  U+77E6  uni77E6,  CJK UNIFIED IDEOGRAPH-77E6
        0x77F0, # G+14884  U+77F0  uni77F0,  CJK UNIFIED IDEOGRAPH-77F0
        0x77F4, # G+14885  U+77F4  uni77F4,  CJK UNIFIED IDEOGRAPH-77F4
        0x7806, # G+14886  U+7806  uni7806,  CJK UNIFIED IDEOGRAPH-7806
        0x7822, # G+14887  U+7822  uni7822,  CJK UNIFIED IDEOGRAPH-7822
        0x782D, # G+14888  U+782D  uni782D,  CJK UNIFIED IDEOGRAPH-782D
        0x782E, # G+14889  U+782E  uni782E,  CJK UNIFIED IDEOGRAPH-782E
        0x7830, # G+14890  U+7830  uni7830,  CJK UNIFIED IDEOGRAPH-7830
        0x7835, # G+14891  U+7835  uni7835,  CJK UNIFIED IDEOGRAPH-7835
        0x7868, # G+14892  U+7868  uni7868,  CJK UNIFIED IDEOGRAPH-7868
        0x789E, # G+14893  U+789E  uni789E,  CJK UNIFIED IDEOGRAPH-789E
        0x78C8, # G+14894  U+78C8  uni78C8,  CJK UNIFIED IDEOGRAPH-78C8
        0x78CC, # G+14895  U+78CC  uni78CC,  CJK UNIFIED IDEOGRAPH-78CC
        0x78CE, # G+14896  U+78CE  uni78CE,  CJK UNIFIED IDEOGRAPH-78CE
        0x78E4, # G+14897  U+78E4  uni78E4,  CJK UNIFIED IDEOGRAPH-78E4
        0x78E0, # G+14898  U+78E0  uni78E0,  CJK UNIFIED IDEOGRAPH-78E0
        0x78E1, # G+14899  U+78E1  uni78E1,  CJK UNIFIED IDEOGRAPH-78E1
        0x78F2, # G+14900  U+78F2  uni78F2,  CJK UNIFIED IDEOGRAPH-78F2
        0x78F7, # G+14901  U+78F7  uni78F7,  CJK UNIFIED IDEOGRAPH-78F7
        0x78FB, # G+14902  U+78FB  uni78FB,  CJK UNIFIED IDEOGRAPH-78FB
        0x7931, # G+14903  U+7931  uni7931,  CJK UNIFIED IDEOGRAPH-7931
        0x7934, # G+14904  U+7934  uni7934,  CJK UNIFIED IDEOGRAPH-7934
        0x2EAD, # G+14905  U+2EAD  uni2EAD,  CJK RADICAL SPIRIT TWO
        0x793D, # G+14906  U+793D  uni793D,  CJK UNIFIED IDEOGRAPH-793D
        0x7945, # G+14907  U+7945  uni7945,  CJK UNIFIED IDEOGRAPH-7945
        0x795B, # G+14908  U+795B  uni795B,  CJK UNIFIED IDEOGRAPH-795B
        0x795C, # G+14909  U+795C  uni795C,  CJK UNIFIED IDEOGRAPH-795C
        0x798B, # G+14910  U+798B  uni798B,  CJK UNIFIED IDEOGRAPH-798B
        0x7996, # G+14911  U+7996  uni7996,  CJK UNIFIED IDEOGRAPH-7996
        0x7998, # G+14912  U+7998  uni7998,  CJK UNIFIED IDEOGRAPH-7998
        0x2F71, # G+14913  U+2F71  uni2F71,  KANGXI RADICAL TRACK
        0x79BB, # G+14914  U+79BB  uni79BB,  CJK UNIFIED IDEOGRAPH-79BB
        0x79CA, # G+14915  U+79CA  uni79CA,  CJK UNIFIED IDEOGRAPH-79CA
        0x79DA, # G+14916  U+79DA  uni79DA,  CJK UNIFIED IDEOGRAPH-79DA
        0x7A03, # G+14917  U+7A03  uni7A03,  CJK UNIFIED IDEOGRAPH-7A03
        0x7A09, # G+14918  U+7A09  uni7A09,  CJK UNIFIED IDEOGRAPH-7A09
        0x7A11, # G+14919  U+7A11  uni7A11,  CJK UNIFIED IDEOGRAPH-7A11
        0x7A1E, # G+14920  U+7A1E  uni7A1E,  CJK UNIFIED IDEOGRAPH-7A1E
        0x7A2D, # G+14921  U+7A2D  uni7A2D,  CJK UNIFIED IDEOGRAPH-7A2D
        0x7A39, # G+14922  U+7A39  uni7A39,  CJK UNIFIED IDEOGRAPH-7A39
        0x7A45, # G+14923  U+7A45  uni7A45,  CJK UNIFIED IDEOGRAPH-7A45
        0x7A4C, # G+14924  U+7A4C  uni7A4C,  CJK UNIFIED IDEOGRAPH-7A4C
        0x7A5D, # G+14925  U+7A5D  uni7A5D,  CJK UNIFIED IDEOGRAPH-7A5D
        0x7A60, # G+14926  U+7A60  uni7A60,  CJK UNIFIED IDEOGRAPH-7A60
        0x7A6D, # G+14927  U+7A6D  uni7A6D,  CJK UNIFIED IDEOGRAPH-7A6D
        0x7A78, # G+14928  U+7A78  uni7A78,  CJK UNIFIED IDEOGRAPH-7A78
        0x7AA0, # G+14929  U+7AA0  uni7AA0,  CJK UNIFIED IDEOGRAPH-7AA0
        0x7AA3, # G+14930  U+7AA3  uni7AA3,  CJK UNIFIED IDEOGRAPH-7AA3
        0x7AB3, # G+14931  U+7AB3  uni7AB3,  CJK UNIFIED IDEOGRAPH-7AB3
        0x7ABB, # G+14932  U+7ABB  uni7ABB,  CJK UNIFIED IDEOGRAPH-7ABB
        0x7ABC, # G+14933  U+7ABC  uni7ABC,  CJK UNIFIED IDEOGRAPH-7ABC
        0x7AC6, # G+14934  U+7AC6  uni7AC6,  CJK UNIFIED IDEOGRAPH-7AC6
        0x7B07, # G+14935  U+7B07  uni7B07,  CJK UNIFIED IDEOGRAPH-7B07
        0x7B14, # G+14936  U+7B14  uni7B14,  CJK UNIFIED IDEOGRAPH-7B14
        0x7B27, # G+14937  U+7B27  uni7B27,  CJK UNIFIED IDEOGRAPH-7B27
        0x7B31, # G+14938  U+7B31  uni7B31,  CJK UNIFIED IDEOGRAPH-7B31
        0x7B47, # G+14939  U+7B47  uni7B47,  CJK UNIFIED IDEOGRAPH-7B47
        0x7B4E, # G+14940  U+7B4E  uni7B4E,  CJK UNIFIED IDEOGRAPH-7B4E
        0x7B60, # G+14941  U+7B60  uni7B60,  CJK UNIFIED IDEOGRAPH-7B60
        0x7B69, # G+14942  U+7B69  uni7B69,  CJK UNIFIED IDEOGRAPH-7B69
        0x7B6D, # G+14943  U+7B6D  uni7B6D,  CJK UNIFIED IDEOGRAPH-7B6D
        0x7B72, # G+14944  U+7B72  uni7B72,  CJK UNIFIED IDEOGRAPH-7B72
        0x7B91, # G+14945  U+7B91  uni7B91,  CJK UNIFIED IDEOGRAPH-7B91
        0x7BAF, # G+14946  U+7BAF  uni7BAF,  CJK UNIFIED IDEOGRAPH-7BAF
        0x7BD7, # G+14947  U+7BD7  uni7BD7,  CJK UNIFIED IDEOGRAPH-7BD7
        0x7BD9, # G+14948  U+7BD9  uni7BD9,  CJK UNIFIED IDEOGRAPH-7BD9
        0x7C0B, # G+14949  U+7C0B  uni7C0B,  CJK UNIFIED IDEOGRAPH-7C0B
        0x7C0F, # G+14950  U+7C0F  uni7C0F,  CJK UNIFIED IDEOGRAPH-7C0F
        0x7C20, # G+14951  U+7C20  uni7C20,  CJK UNIFIED IDEOGRAPH-7C20
        0x7C26, # G+14952  U+7C26  uni7C26,  CJK UNIFIED IDEOGRAPH-7C26
        0x7C31, # G+14953  U+7C31  uni7C31,  CJK UNIFIED IDEOGRAPH-7C31
        0x7C36, # G+14954  U+7C36  uni7C36,  CJK UNIFIED IDEOGRAPH-7C36
        0x7C51, # G+14955  U+7C51  uni7C51,  CJK UNIFIED IDEOGRAPH-7C51
        0x7C59, # G+14956  U+7C59  uni7C59,  CJK UNIFIED IDEOGRAPH-7C59
        0x7C67, # G+14957  U+7C67  uni7C67,  CJK UNIFIED IDEOGRAPH-7C67
        0x7C6E, # G+14958  U+7C6E  uni7C6E,  CJK UNIFIED IDEOGRAPH-7C6E
        0x7C70, # G+14959  U+7C70  uni7C70,  CJK UNIFIED IDEOGRAPH-7C70
        0x7CBC, # G+14960  U+7CBC  uni7CBC,  CJK UNIFIED IDEOGRAPH-7CBC
        0x7CBF, # G+14961  U+7CBF  uni7CBF,  CJK UNIFIED IDEOGRAPH-7CBF
        0x7CC8, # G+14962  U+7CC8  uni7CC8,  CJK UNIFIED IDEOGRAPH-7CC8
        0x7CC9, # G+14963  U+7CC9  uni7CC9,  CJK UNIFIED IDEOGRAPH-7CC9
        0x7CD7, # G+14964  U+7CD7  uni7CD7,  CJK UNIFIED IDEOGRAPH-7CD7
        0x7CD9, # G+14965  U+7CD9  uni7CD9,  CJK UNIFIED IDEOGRAPH-7CD9
        0x7CDD, # G+14966  U+7CDD  uni7CDD,  CJK UNIFIED IDEOGRAPH-7CDD
        0x7CEB, # G+14967  U+7CEB  uni7CEB,  CJK UNIFIED IDEOGRAPH-7CEB
        0x7D07, # G+14968  U+7D07  uni7D07,  CJK UNIFIED IDEOGRAPH-7D07
        0x7D08, # G+14969  U+7D08  uni7D08,  CJK UNIFIED IDEOGRAPH-7D08
        0x7D09, # G+14970  U+7D09  uni7D09,  CJK UNIFIED IDEOGRAPH-7D09
        0x7D13, # G+14971  U+7D13  uni7D13,  CJK UNIFIED IDEOGRAPH-7D13
        0x7D1D, # G+14972  U+7D1D  uni7D1D,  CJK UNIFIED IDEOGRAPH-7D1D
        0x7D23, # G+14973  U+7D23  uni7D23,  CJK UNIFIED IDEOGRAPH-7D23
        0x7D41, # G+14974  U+7D41  uni7D41,  CJK UNIFIED IDEOGRAPH-7D41
        0x7D53, # G+14975  U+7D53  uni7D53,  CJK UNIFIED IDEOGRAPH-7D53
        0x7D59, # G+14976  U+7D59  uni7D59,  CJK UNIFIED IDEOGRAPH-7D59
        0x7D5D, # G+14977  U+7D5D  uni7D5D,  CJK UNIFIED IDEOGRAPH-7D5D
        0x7D7A, # G+14978  U+7D7A  uni7D7A,  CJK UNIFIED IDEOGRAPH-7D7A
        0x7D86, # G+14979  U+7D86  uni7D86,  CJK UNIFIED IDEOGRAPH-7D86
        0x7D8B, # G+14980  U+7D8B  uni7D8B,  CJK UNIFIED IDEOGRAPH-7D8B
        0x7D8C, # G+14981  U+7D8C  uni7D8C,  CJK UNIFIED IDEOGRAPH-7D8C
        0x7DCC, # G+14982  U+7DCC  uni7DCC,  CJK UNIFIED IDEOGRAPH-7DCC
        0x7DEB, # G+14983  U+7DEB  uni7DEB,  CJK UNIFIED IDEOGRAPH-7DEB
        0x7DF1, # G+14984  U+7DF1  uni7DF1,  CJK UNIFIED IDEOGRAPH-7DF1
        0x7DF9, # G+14985  U+7DF9  uni7DF9,  CJK UNIFIED IDEOGRAPH-7DF9
        0x7E08, # G+14986  U+7E08  uni7E08,  CJK UNIFIED IDEOGRAPH-7E08
        0x7E11, # G+14987  U+7E11  uni7E11,  CJK UNIFIED IDEOGRAPH-7E11
        0x7E15, # G+14988  U+7E15  uni7E15,  CJK UNIFIED IDEOGRAPH-7E15
        0x7E20, # G+14989  U+7E20  uni7E20,  CJK UNIFIED IDEOGRAPH-7E20
        0x7E47, # G+14990  U+7E47  uni7E47,  CJK UNIFIED IDEOGRAPH-7E47
        0x7E62, # G+14991  U+7E62  uni7E62,  CJK UNIFIED IDEOGRAPH-7E62
        0x7E6E, # G+14992  U+7E6E  uni7E6E,  CJK UNIFIED IDEOGRAPH-7E6E
        0x7E73, # G+14993  U+7E73  uni7E73,  CJK UNIFIED IDEOGRAPH-7E73
        0x7E8D, # G+14994  U+7E8D  uni7E8D,  CJK UNIFIED IDEOGRAPH-7E8D
        0x7E91, # G+14995  U+7E91  uni7E91,  CJK UNIFIED IDEOGRAPH-7E91
        0x7E98, # G+14996  U+7E98  uni7E98,  CJK UNIFIED IDEOGRAPH-7E98
        0x7F44, # G+14997  U+7F44  uni7F44,  CJK UNIFIED IDEOGRAPH-7F44
        0x7F4F, # G+14998  U+7F4F  uni7F4F,  CJK UNIFIED IDEOGRAPH-7F4F
        0x2EAB, # G+14999  U+2EAB  uni2EAB,  CJK RADICAL EYE
        0x2EB1, # G+15000  U+2EB1  uni2EB1,  CJK RADICAL NET ONE
        0x7F61, # G+15001  U+7F61  uni7F61,  CJK UNIFIED IDEOGRAPH-7F61
        0x7F91, # G+15002  U+7F91  uni7F91,  CJK UNIFIED IDEOGRAPH-7F91
        0x7FBF, # G+15003  U+7FBF  uni7FBF,  CJK UNIFIED IDEOGRAPH-7FBF
        0x7FCE, # G+15004  U+7FCE  uni7FCE,  CJK UNIFIED IDEOGRAPH-7FCE
        0x7FDF, # G+15005  U+7FDF  uni7FDF,  CJK UNIFIED IDEOGRAPH-7FDF
        0x7FE5, # G+15006  U+7FE5  uni7FE5,  CJK UNIFIED IDEOGRAPH-7FE5
        0x7FEC, # G+15007  U+7FEC  uni7FEC,  CJK UNIFIED IDEOGRAPH-7FEC
        0x7FEE, # G+15008  U+7FEE  uni7FEE,  CJK UNIFIED IDEOGRAPH-7FEE
        0x7FEF, # G+15009  U+7FEF  uni7FEF,  CJK UNIFIED IDEOGRAPH-7FEF
        0x7FFA, # G+15010  U+7FFA  uni7FFA,  CJK UNIFIED IDEOGRAPH-7FFA
        0x800E, # G+15011  U+800E  uni800E,  CJK UNIFIED IDEOGRAPH-800E
        0x8011, # G+15012  U+8011  uni8011,  CJK UNIFIED IDEOGRAPH-8011
        0x8014, # G+15013  U+8014  uni8014,  CJK UNIFIED IDEOGRAPH-8014
        0x8024, # G+15014  U+8024  uni8024,  CJK UNIFIED IDEOGRAPH-8024
        0x8026, # G+15015  U+8026  uni8026,  CJK UNIFIED IDEOGRAPH-8026
        0x803A, # G+15016  U+803A  uni803A,  CJK UNIFIED IDEOGRAPH-803A
        0x803C, # G+15017  U+803C  uni803C,  CJK UNIFIED IDEOGRAPH-803C
        0x8060, # G+15018  U+8060  uni8060,  CJK UNIFIED IDEOGRAPH-8060
        0x8071, # G+15019  U+8071  uni8071,  CJK UNIFIED IDEOGRAPH-8071
        0x8075, # G+15020  U+8075  uni8075,  CJK UNIFIED IDEOGRAPH-8075
        0x809E, # G+15021  U+809E  uni809E,  CJK UNIFIED IDEOGRAPH-809E
        0x80A6, # G+15022  U+80A6  uni80A6,  CJK UNIFIED IDEOGRAPH-80A6
        0x80AB, # G+15023  U+80AB  uni80AB,  CJK UNIFIED IDEOGRAPH-80AB
        0x80D7, # G+15024  U+80D7  uni80D7,  CJK UNIFIED IDEOGRAPH-80D7
        0x80D8, # G+15025  U+80D8  uni80D8,  CJK UNIFIED IDEOGRAPH-80D8
        0x8116, # G+15026  U+8116  uni8116,  CJK UNIFIED IDEOGRAPH-8116
        0x8118, # G+15027  U+8118  uni8118,  CJK UNIFIED IDEOGRAPH-8118
        0x813A, # G+15028  U+813A  uni813A,  CJK UNIFIED IDEOGRAPH-813A
        0x814A, # G+15029  U+814A  uni814A,  CJK UNIFIED IDEOGRAPH-814A
        0x814C, # G+15030  U+814C  uni814C,  CJK UNIFIED IDEOGRAPH-814C
        0x8181, # G+15031  U+8181  uni8181,  CJK UNIFIED IDEOGRAPH-8181
        0x8184, # G+15032  U+8184  uni8184,  CJK UNIFIED IDEOGRAPH-8184
        0x81B4, # G+15033  U+81B4  uni81B4,  CJK UNIFIED IDEOGRAPH-81B4
        0x81CF, # G+15034  U+81CF  uni81CF,  CJK UNIFIED IDEOGRAPH-81CF
        0x81F9, # G+15035  U+81F9  uni81F9,  CJK UNIFIED IDEOGRAPH-81F9
        0x8203, # G+15036  U+8203  uni8203,  CJK UNIFIED IDEOGRAPH-8203
        0x8221, # G+15037  U+8221  uni8221,  CJK UNIFIED IDEOGRAPH-8221
        0x8232, # G+15038  U+8232  uni8232,  CJK UNIFIED IDEOGRAPH-8232
        0x8234, # G+15039  U+8234  uni8234,  CJK UNIFIED IDEOGRAPH-8234
        0x8246, # G+15040  U+8246  uni8246,  CJK UNIFIED IDEOGRAPH-8246
        0x824B, # G+15041  U+824B  uni824B,  CJK UNIFIED IDEOGRAPH-824B
        0x824F, # G+15042  U+824F  uni824F,  CJK UNIFIED IDEOGRAPH-824F
        0x828E, # G+15043  U+828E  uni828E,  CJK UNIFIED IDEOGRAPH-828E
        0x82AE, # G+15044  U+82AE  uni82AE,  CJK UNIFIED IDEOGRAPH-82AE
        0x82B7, # G+15045  U+82B7  uni82B7,  CJK UNIFIED IDEOGRAPH-82B7
        0x82BE, # G+15046  U+82BE  uni82BE,  CJK UNIFIED IDEOGRAPH-82BE
        0x82C6, # G+15047  U+82C6  uni82C6,  CJK UNIFIED IDEOGRAPH-82C6
        0x82FE, # G+15048  U+82FE  uni82FE,  CJK UNIFIED IDEOGRAPH-82FE
        0x8343, # G+15049  U+8343  uni8343,  CJK UNIFIED IDEOGRAPH-8343
        0x8351, # G+15050  U+8351  uni8351,  CJK UNIFIED IDEOGRAPH-8351
        0x8355, # G+15051  U+8355  uni8355,  CJK UNIFIED IDEOGRAPH-8355
        0x8386, # G+15052  U+8386  uni8386,  CJK UNIFIED IDEOGRAPH-8386
        0x838D, # G+15053  U+838D  uni838D,  CJK UNIFIED IDEOGRAPH-838D
        0x8392, # G+15054  U+8392  uni8392,  CJK UNIFIED IDEOGRAPH-8392
        0x8398, # G+15055  U+8398  uni8398,  CJK UNIFIED IDEOGRAPH-8398
        0x83A9, # G+15056  U+83A9  uni83A9,  CJK UNIFIED IDEOGRAPH-83A9
        0x83BF, # G+15057  U+83BF  uni83BF,  CJK UNIFIED IDEOGRAPH-83BF
        0x83C0, # G+15058  U+83C0  uni83C0,  CJK UNIFIED IDEOGRAPH-83C0
        0x83EA, # G+15059  U+83EA  uni83EA,  CJK UNIFIED IDEOGRAPH-83EA
        0x840F, # G+15060  U+840F  uni840F,  CJK UNIFIED IDEOGRAPH-840F
        0x8411, # G+15061  U+8411  uni8411,  CJK UNIFIED IDEOGRAPH-8411
        0x844A, # G+15062  U+844A  uni844A,  CJK UNIFIED IDEOGRAPH-844A
        0x8476, # G+15063  U+8476  uni8476,  CJK UNIFIED IDEOGRAPH-8476
        0x84A8, # G+15064  U+84A8  uni84A8,  CJK UNIFIED IDEOGRAPH-84A8
        0x84AF, # G+15065  U+84AF  uni84AF,  CJK UNIFIED IDEOGRAPH-84AF
        0x84C0, # G+15066  U+84C0  uni84C0,  CJK UNIFIED IDEOGRAPH-84C0
        0x84C2, # G+15067  U+84C2  uni84C2,  CJK UNIFIED IDEOGRAPH-84C2
        0x84F0, # G+15068  U+84F0  uni84F0,  CJK UNIFIED IDEOGRAPH-84F0
        0x84FD, # G+15069  U+84FD  uni84FD,  CJK UNIFIED IDEOGRAPH-84FD
        0x850C, # G+15070  U+850C  uni850C,  CJK UNIFIED IDEOGRAPH-850C
        0x8534, # G+15071  U+8534  uni8534,  CJK UNIFIED IDEOGRAPH-8534
        0x855E, # G+15072  U+855E  uni855E,  CJK UNIFIED IDEOGRAPH-855E
        0x858F, # G+15073  U+858F  uni858F,  CJK UNIFIED IDEOGRAPH-858F
        0x85B7, # G+15074  U+85B7  uni85B7,  CJK UNIFIED IDEOGRAPH-85B7
        0x85CE, # G+15075  U+85CE  uni85CE,  CJK UNIFIED IDEOGRAPH-85CE
        0x85AD, # G+15076  U+85AD  uni85AD,  CJK UNIFIED IDEOGRAPH-85AD
        0x8612, # G+15077  U+8612  uni8612,  CJK UNIFIED IDEOGRAPH-8612
        0x8629, # G+15078  U+8629  uni8629,  CJK UNIFIED IDEOGRAPH-8629
        0x8652, # G+15079  U+8652  uni8652,  CJK UNIFIED IDEOGRAPH-8652
        0x8663, # G+15080  U+8663  uni8663,  CJK UNIFIED IDEOGRAPH-8663
        0x866C, # G+15081  U+866C  uni866C,  CJK UNIFIED IDEOGRAPH-866C
        0x866F, # G+15082  U+866F  uni866F,  CJK UNIFIED IDEOGRAPH-866F
        0x867A, # G+15083  U+867A  uni867A,  CJK UNIFIED IDEOGRAPH-867A
        0x868D, # G+15084  U+868D  uni868D,  CJK UNIFIED IDEOGRAPH-868D
        0x8691, # G+15085  U+8691  uni8691,  CJK UNIFIED IDEOGRAPH-8691
        0x8698, # G+15086  U+8698  uni8698,  CJK UNIFIED IDEOGRAPH-8698
        0x86A7, # G+15087  U+86A7  uni86A7,  CJK UNIFIED IDEOGRAPH-86A7
        0x86A8, # G+15088  U+86A8  uni86A8,  CJK UNIFIED IDEOGRAPH-86A8
        0x86FA, # G+15089  U+86FA  uni86FA,  CJK UNIFIED IDEOGRAPH-86FA
        0x86FD, # G+15090  U+86FD  uni86FD,  CJK UNIFIED IDEOGRAPH-86FD
        0x870B, # G+15091  U+870B  uni870B,  CJK UNIFIED IDEOGRAPH-870B
        0x8713, # G+15092  U+8713  uni8713,  CJK UNIFIED IDEOGRAPH-8713
        0x8719, # G+15093  U+8719  uni8719,  CJK UNIFIED IDEOGRAPH-8719
        0x871E, # G+15094  U+871E  uni871E,  CJK UNIFIED IDEOGRAPH-871E
        0x8728, # G+15095  U+8728  uni8728,  CJK UNIFIED IDEOGRAPH-8728
        0x873E, # G+15096  U+873E  uni873E,  CJK UNIFIED IDEOGRAPH-873E
        0x8771, # G+15097  U+8771  uni8771,  CJK UNIFIED IDEOGRAPH-8771
        0x8788, # G+15098  U+8788  uni8788,  CJK UNIFIED IDEOGRAPH-8788
        0x8799, # G+15099  U+8799  uni8799,  CJK UNIFIED IDEOGRAPH-8799
        0x87AC, # G+15100  U+87AC  uni87AC,  CJK UNIFIED IDEOGRAPH-87AC
        0x87AD, # G+15101  U+87AD  uni87AD,  CJK UNIFIED IDEOGRAPH-87AD
        0x87B5, # G+15102  U+87B5  uni87B5,  CJK UNIFIED IDEOGRAPH-87B5
        0x87D6, # G+15103  U+87D6  uni87D6,  CJK UNIFIED IDEOGRAPH-87D6
        0x87EB, # G+15104  U+87EB  uni87EB,  CJK UNIFIED IDEOGRAPH-87EB
        0x87ED, # G+15105  U+87ED  uni87ED,  CJK UNIFIED IDEOGRAPH-87ED
        0x8801, # G+15106  U+8801  uni8801,  CJK UNIFIED IDEOGRAPH-8801
        0x8803, # G+15107  U+8803  uni8803,  CJK UNIFIED IDEOGRAPH-8803
        0x8806, # G+15108  U+8806  uni8806,  CJK UNIFIED IDEOGRAPH-8806
        0x880B, # G+15109  U+880B  uni880B,  CJK UNIFIED IDEOGRAPH-880B
        0x8814, # G+15110  U+8814  uni8814,  CJK UNIFIED IDEOGRAPH-8814
        0x881C, # G+15111  U+881C  uni881C,  CJK UNIFIED IDEOGRAPH-881C
        0x8856, # G+15112  U+8856  uni8856,  CJK UNIFIED IDEOGRAPH-8856
        0x885F, # G+15113  U+885F  uni885F,  CJK UNIFIED IDEOGRAPH-885F
        0x2EC2, # G+15114  U+2EC2  uni2EC2,  CJK RADICAL CLOTHES
        0x8898, # G+15115  U+8898  uni8898,  CJK UNIFIED IDEOGRAPH-8898
        0x88AA, # G+15116  U+88AA  uni88AA,  CJK UNIFIED IDEOGRAPH-88AA
        0x88BD, # G+15117  U+88BD  uni88BD,  CJK UNIFIED IDEOGRAPH-88BD
        0x88BE, # G+15118  U+88BE  uni88BE,  CJK UNIFIED IDEOGRAPH-88BE
        0x88CA, # G+15119  U+88CA  uni88CA,  CJK UNIFIED IDEOGRAPH-88CA
        0x88D2, # G+15120  U+88D2  uni88D2,  CJK UNIFIED IDEOGRAPH-88D2
        0x88DB, # G+15121  U+88DB  uni88DB,  CJK UNIFIED IDEOGRAPH-88DB
        0x88F0, # G+15122  U+88F0  uni88F0,  CJK UNIFIED IDEOGRAPH-88F0
        0x88F1, # G+15123  U+88F1  uni88F1,  CJK UNIFIED IDEOGRAPH-88F1
        0x8906, # G+15124  U+8906  uni8906,  CJK UNIFIED IDEOGRAPH-8906
        0x8918, # G+15125  U+8918  uni8918,  CJK UNIFIED IDEOGRAPH-8918
        0x8919, # G+15126  U+8919  uni8919,  CJK UNIFIED IDEOGRAPH-8919
        0x891A, # G+15127  U+891A  uni891A,  CJK UNIFIED IDEOGRAPH-891A
        0x8927, # G+15128  U+8927  uni8927,  CJK UNIFIED IDEOGRAPH-8927
        0x8930, # G+15129  U+8930  uni8930,  CJK UNIFIED IDEOGRAPH-8930
        0x893E, # G+15130  U+893E  uni893E,  CJK UNIFIED IDEOGRAPH-893E
        0x897B, # G+15131  U+897B  uni897B,  CJK UNIFIED IDEOGRAPH-897B
        0x89D4, # G+15132  U+89D4  uni89D4,  CJK UNIFIED IDEOGRAPH-89D4
        0x89D6, # G+15133  U+89D6  uni89D6,  CJK UNIFIED IDEOGRAPH-89D6
        0x89E5, # G+15134  U+89E5  uni89E5,  CJK UNIFIED IDEOGRAPH-89E5
        0x89F1, # G+15135  U+89F1  uni89F1,  CJK UNIFIED IDEOGRAPH-89F1
        0x8A07, # G+15136  U+8A07  uni8A07,  CJK UNIFIED IDEOGRAPH-8A07
        0x8A0F, # G+15137  U+8A0F  uni8A0F,  CJK UNIFIED IDEOGRAPH-8A0F
        0x8A15, # G+15138  U+8A15  uni8A15,  CJK UNIFIED IDEOGRAPH-8A15
        0x8A22, # G+15139  U+8A22  uni8A22,  CJK UNIFIED IDEOGRAPH-8A22
        0x8A4E, # G+15140  U+8A4E  uni8A4E,  CJK UNIFIED IDEOGRAPH-8A4E
        0x8A7F, # G+15141  U+8A7F  uni8A7F,  CJK UNIFIED IDEOGRAPH-8A7F
        0x8AF4, # G+15142  U+8AF4  uni8AF4,  CJK UNIFIED IDEOGRAPH-8AF4
        0x8B1F, # G+15143  U+8B1F  uni8B1F,  CJK UNIFIED IDEOGRAPH-8B1F
        0x8B37, # G+15144  U+8B37  uni8B37,  CJK UNIFIED IDEOGRAPH-8B37
        0x8B43, # G+15145  U+8B43  uni8B43,  CJK UNIFIED IDEOGRAPH-8B43
        0x8B44, # G+15146  U+8B44  uni8B44,  CJK UNIFIED IDEOGRAPH-8B44
        0x8B54, # G+15147  U+8B54  uni8B54,  CJK UNIFIED IDEOGRAPH-8B54
        0x8B9C, # G+15148  U+8B9C  uni8B9C,  CJK UNIFIED IDEOGRAPH-8B9C
        0x8B9E, # G+15149  U+8B9E  uni8B9E,  CJK UNIFIED IDEOGRAPH-8B9E
        0x8C47, # G+15150  U+8C47  uni8C47,  CJK UNIFIED IDEOGRAPH-8C47
        0x8C54, # G+15151  U+8C54  uni8C54,  CJK UNIFIED IDEOGRAPH-8C54
        0x8C73, # G+15152  U+8C73  uni8C73,  CJK UNIFIED IDEOGRAPH-8C73
        0x8CA4, # G+15153  U+8CA4  uni8CA4,  CJK UNIFIED IDEOGRAPH-8CA4
        0x8CD9, # G+15154  U+8CD9  uni8CD9,  CJK UNIFIED IDEOGRAPH-8CD9
        0x8CE1, # G+15155  U+8CE1  uni8CE1,  CJK UNIFIED IDEOGRAPH-8CE1
        0x8CF8, # G+15156  U+8CF8  uni8CF8,  CJK UNIFIED IDEOGRAPH-8CF8
        0x8CFE, # G+15157  U+8CFE  uni8CFE,  CJK UNIFIED IDEOGRAPH-8CFE
        0x8D1B, # G+15158  U+8D1B  uni8D1B,  CJK UNIFIED IDEOGRAPH-8D1B
        0x8D69, # G+15159  U+8D69  uni8D69,  CJK UNIFIED IDEOGRAPH-8D69
        0x8D6C, # G+15160  U+8D6C  uni8D6C,  CJK UNIFIED IDEOGRAPH-8D6C
        0x8D84, # G+15161  U+8D84  uni8D84,  CJK UNIFIED IDEOGRAPH-8D84
        0x8D8D, # G+15162  U+8D8D  uni8D8D,  CJK UNIFIED IDEOGRAPH-8D8D
        0x8D95, # G+15163  U+8D95  uni8D95,  CJK UNIFIED IDEOGRAPH-8D95
        0x8DA6, # G+15164  U+8DA6  uni8DA6,  CJK UNIFIED IDEOGRAPH-8DA6
        0x8DC6, # G+15165  U+8DC6  uni8DC6,  CJK UNIFIED IDEOGRAPH-8DC6
        0x8DCE, # G+15166  U+8DCE  uni8DCE,  CJK UNIFIED IDEOGRAPH-8DCE
        0x8DE4, # G+15167  U+8DE4  uni8DE4,  CJK UNIFIED IDEOGRAPH-8DE4
        0x8DEC, # G+15168  U+8DEC  uni8DEC,  CJK UNIFIED IDEOGRAPH-8DEC
        0x8E20, # G+15169  U+8E20  uni8E20,  CJK UNIFIED IDEOGRAPH-8E20
        0x8E4B, # G+15170  U+8E4B  uni8E4B,  CJK UNIFIED IDEOGRAPH-8E4B
        0x8E6C, # G+15171  U+8E6C  uni8E6C,  CJK UNIFIED IDEOGRAPH-8E6C
        0x8E70, # G+15172  U+8E70  uni8E70,  CJK UNIFIED IDEOGRAPH-8E70
        0x8E7A, # G+15173  U+8E7A  uni8E7A,  CJK UNIFIED IDEOGRAPH-8E7A
        0x8E92, # G+15174  U+8E92  uni8E92,  CJK UNIFIED IDEOGRAPH-8E92
        0x8EAE, # G+15175  U+8EAE  uni8EAE,  CJK UNIFIED IDEOGRAPH-8EAE
        0x8EB3, # G+15176  U+8EB3  uni8EB3,  CJK UNIFIED IDEOGRAPH-8EB3
        0x8ED1, # G+15177  U+8ED1  uni8ED1,  CJK UNIFIED IDEOGRAPH-8ED1
        0x8ED4, # G+15178  U+8ED4  uni8ED4,  CJK UNIFIED IDEOGRAPH-8ED4
        0x8EF9, # G+15179  U+8EF9  uni8EF9,  CJK UNIFIED IDEOGRAPH-8EF9
        0x8F17, # G+15180  U+8F17  uni8F17,  CJK UNIFIED IDEOGRAPH-8F17
        0x8F36, # G+15181  U+8F36  uni8F36,  CJK UNIFIED IDEOGRAPH-8F36
        0x8FA6, # G+15182  U+8FA6  uni8FA6,  CJK UNIFIED IDEOGRAPH-8FA6
        0x2FA1, # G+15183  U+2FA1  uni2FA1,  KANGXI RADICAL WALK
        0x2ECD, # G+15184  U+2ECD  uni2ECD,  CJK RADICAL WALK ONE
        0x8FC6, # G+15185  U+8FC6  uni8FC6,  CJK UNIFIED IDEOGRAPH-8FC6
        0x8FE0, # G+15186  U+8FE0  uni8FE0,  CJK UNIFIED IDEOGRAPH-8FE0
        0x8FE4, # G+15187  U+8FE4  uni8FE4,  CJK UNIFIED IDEOGRAPH-8FE4
        0x8FF6, # G+15188  U+8FF6  uni8FF6,  CJK UNIFIED IDEOGRAPH-8FF6
        0x9002, # G+15189  U+9002  uni9002,  CJK UNIFIED IDEOGRAPH-9002
        0x902C, # G+15190  U+902C  uni902C,  CJK UNIFIED IDEOGRAPH-902C
        0x9044, # G+15191  U+9044  uni9044,  CJK UNIFIED IDEOGRAPH-9044
        0x9088, # G+15192  U+9088  uni9088,  CJK UNIFIED IDEOGRAPH-9088
        0x9095, # G+15193  U+9095  uni9095,  CJK UNIFIED IDEOGRAPH-9095
        0x9099, # G+15194  U+9099  uni9099,  CJK UNIFIED IDEOGRAPH-9099
        0x909B, # G+15195  U+909B  uni909B,  CJK UNIFIED IDEOGRAPH-909B
        0x90A2, # G+15196  U+90A2  uni90A2,  CJK UNIFIED IDEOGRAPH-90A2
        0x90B4, # G+15197  U+90B4  uni90B4,  CJK UNIFIED IDEOGRAPH-90B4
        0x90D7, # G+15198  U+90D7  uni90D7,  CJK UNIFIED IDEOGRAPH-90D7
        0x90DD, # G+15199  U+90DD  uni90DD,  CJK UNIFIED IDEOGRAPH-90DD
        0x90F4, # G+15200  U+90F4  uni90F4,  CJK UNIFIED IDEOGRAPH-90F4
        0x9117, # G+15201  U+9117  uni9117,  CJK UNIFIED IDEOGRAPH-9117
        0x911C, # G+15202  U+911C  uni911C,  CJK UNIFIED IDEOGRAPH-911C
        0x9131, # G+15203  U+9131  uni9131,  CJK UNIFIED IDEOGRAPH-9131
        0x913A, # G+15204  U+913A  uni913A,  CJK UNIFIED IDEOGRAPH-913A
        0x913D, # G+15205  U+913D  uni913D,  CJK UNIFIED IDEOGRAPH-913D
        0x9148, # G+15206  U+9148  uni9148,  CJK UNIFIED IDEOGRAPH-9148
        0x915B, # G+15207  U+915B  uni915B,  CJK UNIFIED IDEOGRAPH-915B
        0x9161, # G+15208  U+9161  uni9161,  CJK UNIFIED IDEOGRAPH-9161
        0x9164, # G+15209  U+9164  uni9164,  CJK UNIFIED IDEOGRAPH-9164
        0x918E, # G+15210  U+918E  uni918E,  CJK UNIFIED IDEOGRAPH-918E
        0x919E, # G+15211  U+919E  uni919E,  CJK UNIFIED IDEOGRAPH-919E
        0x91A8, # G+15212  U+91A8  uni91A8,  CJK UNIFIED IDEOGRAPH-91A8
        0x91AD, # G+15213  U+91AD  uni91AD,  CJK UNIFIED IDEOGRAPH-91AD
        0x91AE, # G+15214  U+91AE  uni91AE,  CJK UNIFIED IDEOGRAPH-91AE
        0x91B2, # G+15215  U+91B2  uni91B2,  CJK UNIFIED IDEOGRAPH-91B2
        0x91BC, # G+15216  U+91BC  uni91BC,  CJK UNIFIED IDEOGRAPH-91BC
        0x91F0, # G+15217  U+91F0  uni91F0,  CJK UNIFIED IDEOGRAPH-91F0
        0x91F7, # G+15218  U+91F7  uni91F7,  CJK UNIFIED IDEOGRAPH-91F7
        0x91FB, # G+15219  U+91FB  uni91FB,  CJK UNIFIED IDEOGRAPH-91FB
        0x9207, # G+15220  U+9207  uni9207,  CJK UNIFIED IDEOGRAPH-9207
        0x9228, # G+15221  U+9228  uni9228,  CJK UNIFIED IDEOGRAPH-9228
        0x9233, # G+15222  U+9233  uni9233,  CJK UNIFIED IDEOGRAPH-9233
        0x9238, # G+15223  U+9238  uni9238,  CJK UNIFIED IDEOGRAPH-9238
        0x9243, # G+15224  U+9243  uni9243,  CJK UNIFIED IDEOGRAPH-9243
        0x9247, # G+15225  U+9247  uni9247,  CJK UNIFIED IDEOGRAPH-9247
        0x924F, # G+15226  U+924F  uni924F,  CJK UNIFIED IDEOGRAPH-924F
        0x9260, # G+15227  U+9260  uni9260,  CJK UNIFIED IDEOGRAPH-9260
        0x92C2, # G+15228  U+92C2  uni92C2,  CJK UNIFIED IDEOGRAPH-92C2
        0x92CB, # G+15229  U+92CB  uni92CB,  CJK UNIFIED IDEOGRAPH-92CB
        0x92CC, # G+15230  U+92CC  uni92CC,  CJK UNIFIED IDEOGRAPH-92CC
        0x92DF, # G+15231  U+92DF  uni92DF,  CJK UNIFIED IDEOGRAPH-92DF
        0x930D, # G+15232  U+930D  uni930D,  CJK UNIFIED IDEOGRAPH-930D
        0x9315, # G+15233  U+9315  uni9315,  CJK UNIFIED IDEOGRAPH-9315
        0x931F, # G+15234  U+931F  uni931F,  CJK UNIFIED IDEOGRAPH-931F
        0x9327, # G+15235  U+9327  uni9327,  CJK UNIFIED IDEOGRAPH-9327
        0x9347, # G+15236  U+9347  uni9347,  CJK UNIFIED IDEOGRAPH-9347
        0x9352, # G+15237  U+9352  uni9352,  CJK UNIFIED IDEOGRAPH-9352
        0x9365, # G+15238  U+9365  uni9365,  CJK UNIFIED IDEOGRAPH-9365
        0x936A, # G+15239  U+936A  uni936A,  CJK UNIFIED IDEOGRAPH-936A
        0x936D, # G+15240  U+936D  uni936D,  CJK UNIFIED IDEOGRAPH-936D
        0x939B, # G+15241  U+939B  uni939B,  CJK UNIFIED IDEOGRAPH-939B
        0x93BA, # G+15242  U+93BA  uni93BA,  CJK UNIFIED IDEOGRAPH-93BA
        0x93A9, # G+15243  U+93A9  uni93A9,  CJK UNIFIED IDEOGRAPH-93A9
        0x93C1, # G+15244  U+93C1  uni93C1,  CJK UNIFIED IDEOGRAPH-93C1
        0x93CA, # G+15245  U+93CA  uni93CA,  CJK UNIFIED IDEOGRAPH-93CA
        0x93E2, # G+15246  U+93E2  uni93E2,  CJK UNIFIED IDEOGRAPH-93E2
        0x93FA, # G+15247  U+93FA  uni93FA,  CJK UNIFIED IDEOGRAPH-93FA
        0x93FD, # G+15248  U+93FD  uni93FD,  CJK UNIFIED IDEOGRAPH-93FD
        0x940F, # G+15249  U+940F  uni940F,  CJK UNIFIED IDEOGRAPH-940F
        0x9434, # G+15250  U+9434  uni9434,  CJK UNIFIED IDEOGRAPH-9434
        0x943F, # G+15251  U+943F  uni943F,  CJK UNIFIED IDEOGRAPH-943F
        0x9455, # G+15252  U+9455  uni9455,  CJK UNIFIED IDEOGRAPH-9455
        0x946B, # G+15253  U+946B  uni946B,  CJK UNIFIED IDEOGRAPH-946B
        0x9472, # G+15254  U+9472  uni9472,  CJK UNIFIED IDEOGRAPH-9472
        0x2ED2, # G+15255  U+2ED2  uni2ED2,  CJK RADICAL LONG TWO
        0x95A6, # G+15256  U+95A6  uni95A6,  CJK UNIFIED IDEOGRAPH-95A6
        0x95A9, # G+15257  U+95A9  uni95A9,  CJK UNIFIED IDEOGRAPH-95A9
        0x95AB, # G+15258  U+95AB  uni95AB,  CJK UNIFIED IDEOGRAPH-95AB
        0x95B4, # G+15259  U+95B4  uni95B4,  CJK UNIFIED IDEOGRAPH-95B4
        0x95BD, # G+15260  U+95BD  uni95BD,  CJK UNIFIED IDEOGRAPH-95BD
        0x95DA, # G+15261  U+95DA  uni95DA,  CJK UNIFIED IDEOGRAPH-95DA
        0x2ECF, # G+15262  U+2ECF  uni2ECF,  CJK RADICAL CITY
        0x9641, # G+15263  U+9641  uni9641,  CJK UNIFIED IDEOGRAPH-9641
        0x9658, # G+15264  U+9658  uni9658,  CJK UNIFIED IDEOGRAPH-9658
        0x9684, # G+15265  U+9684  uni9684,  CJK UNIFIED IDEOGRAPH-9684
        0x96A4, # G+15266  U+96A4  uni96A4,  CJK UNIFIED IDEOGRAPH-96A4
        0x96A9, # G+15267  U+96A9  uni96A9,  CJK UNIFIED IDEOGRAPH-96A9
        0x96D2, # G+15268  U+96D2  uni96D2,  CJK UNIFIED IDEOGRAPH-96D2
        0x5DB2, # G+15269  U+5DB2  uni5DB2,  CJK UNIFIED IDEOGRAPH-5DB2
        0x96DE, # G+15270  U+96DE  uni96DE,  CJK UNIFIED IDEOGRAPH-96DE
        0x96E9, # G+15271  U+96E9  uni96E9,  CJK UNIFIED IDEOGRAPH-96E9
        0x96F1, # G+15272  U+96F1  uni96F1,  CJK UNIFIED IDEOGRAPH-96F1
        0x9702, # G+15273  U+9702  uni9702,  CJK UNIFIED IDEOGRAPH-9702
        0x9709, # G+15274  U+9709  uni9709,  CJK UNIFIED IDEOGRAPH-9709
        0x975A, # G+15275  U+975A  uni975A,  CJK UNIFIED IDEOGRAPH-975A
        0x9763, # G+15276  U+9763  uni9763,  CJK UNIFIED IDEOGRAPH-9763
        0x976E, # G+15277  U+976E  uni976E,  CJK UNIFIED IDEOGRAPH-976E
        0x9773, # G+15278  U+9773  uni9773,  CJK UNIFIED IDEOGRAPH-9773
        0x979A, # G+15279  U+979A  uni979A,  CJK UNIFIED IDEOGRAPH-979A
        0x97A2, # G+15280  U+97A2  uni97A2,  CJK UNIFIED IDEOGRAPH-97A2
        0x97B5, # G+15281  U+97B5  uni97B5,  CJK UNIFIED IDEOGRAPH-97B5
        0x97B6, # G+15282  U+97B6  uni97B6,  CJK UNIFIED IDEOGRAPH-97B6
        0x97D9, # G+15283  U+97D9  uni97D9,  CJK UNIFIED IDEOGRAPH-97D9
        0x97DE, # G+15284  U+97DE  uni97DE,  CJK UNIFIED IDEOGRAPH-97DE
        0x97F4, # G+15285  U+97F4  uni97F4,  CJK UNIFIED IDEOGRAPH-97F4
        0x980A, # G+15286  U+980A  uni980A,  CJK UNIFIED IDEOGRAPH-980A
        0x980E, # G+15287  U+980E  uni980E,  CJK UNIFIED IDEOGRAPH-980E
        0x981E, # G+15288  U+981E  uni981E,  CJK UNIFIED IDEOGRAPH-981E
        0x9823, # G+15289  U+9823  uni9823,  CJK UNIFIED IDEOGRAPH-9823
        0x982B, # G+15290  U+982B  uni982B,  CJK UNIFIED IDEOGRAPH-982B
        0x983E, # G+15291  U+983E  uni983E,  CJK UNIFIED IDEOGRAPH-983E
        0x9852, # G+15292  U+9852  uni9852,  CJK UNIFIED IDEOGRAPH-9852
        0x9853, # G+15293  U+9853  uni9853,  CJK UNIFIED IDEOGRAPH-9853
        0x9859, # G+15294  U+9859  uni9859,  CJK UNIFIED IDEOGRAPH-9859
        0x986C, # G+15295  U+986C  uni986C,  CJK UNIFIED IDEOGRAPH-986C
        0x98B8, # G+15296  U+98B8  uni98B8,  CJK UNIFIED IDEOGRAPH-98B8
        0x98BA, # G+15297  U+98BA  uni98BA,  CJK UNIFIED IDEOGRAPH-98BA
        0x98BF, # G+15298  U+98BF  uni98BF,  CJK UNIFIED IDEOGRAPH-98BF
        0x98C8, # G+15299  U+98C8  uni98C8,  CJK UNIFIED IDEOGRAPH-98C8
        0x98E5, # G+15300  U+98E5  uni98E5,  CJK UNIFIED IDEOGRAPH-98E5
        0x9932, # G+15301  U+9932  uni9932,  CJK UNIFIED IDEOGRAPH-9932
        0x9933, # G+15302  U+9933  uni9933,  CJK UNIFIED IDEOGRAPH-9933
        0x9940, # G+15303  U+9940  uni9940,  CJK UNIFIED IDEOGRAPH-9940
        0x994D, # G+15304  U+994D  uni994D,  CJK UNIFIED IDEOGRAPH-994D
        0x995C, # G+15305  U+995C  uni995C,  CJK UNIFIED IDEOGRAPH-995C
        0x995F, # G+15306  U+995F  uni995F,  CJK UNIFIED IDEOGRAPH-995F
        0x99B1, # G+15307  U+99B1  uni99B1,  CJK UNIFIED IDEOGRAPH-99B1
        0x99B9, # G+15308  U+99B9  uni99B9,  CJK UNIFIED IDEOGRAPH-99B9
        0x99BA, # G+15309  U+99BA  uni99BA,  CJK UNIFIED IDEOGRAPH-99BA
        0x99C9, # G+15310  U+99C9  uni99C9,  CJK UNIFIED IDEOGRAPH-99C9
        0x9A02, # G+15311  U+9A02  uni9A02,  CJK UNIFIED IDEOGRAPH-9A02
        0x9A16, # G+15312  U+9A16  uni9A16,  CJK UNIFIED IDEOGRAPH-9A16
        0x9A24, # G+15313  U+9A24  uni9A24,  CJK UNIFIED IDEOGRAPH-9A24
        0x9A27, # G+15314  U+9A27  uni9A27,  CJK UNIFIED IDEOGRAPH-9A27
        0x9A2D, # G+15315  U+9A2D  uni9A2D,  CJK UNIFIED IDEOGRAPH-9A2D
        0x9A2E, # G+15316  U+9A2E  uni9A2E,  CJK UNIFIED IDEOGRAPH-9A2E
        0x9A36, # G+15317  U+9A36  uni9A36,  CJK UNIFIED IDEOGRAPH-9A36
        0x9A38, # G+15318  U+9A38  uni9A38,  CJK UNIFIED IDEOGRAPH-9A38
        0x9A4A, # G+15319  U+9A4A  uni9A4A,  CJK UNIFIED IDEOGRAPH-9A4A
        0x9A56, # G+15320  U+9A56  uni9A56,  CJK UNIFIED IDEOGRAPH-9A56
        0x9AB5, # G+15321  U+9AB5  uni9AB5,  CJK UNIFIED IDEOGRAPH-9AB5
        0x9AB6, # G+15322  U+9AB6  uni9AB6,  CJK UNIFIED IDEOGRAPH-9AB6
        0x9AF9, # G+15323  U+9AF9  uni9AF9,  CJK UNIFIED IDEOGRAPH-9AF9
        0x9B03, # G+15324  U+9B03  uni9B03,  CJK UNIFIED IDEOGRAPH-9B03
        0x9B20, # G+15325  U+9B20  uni9B20,  CJK UNIFIED IDEOGRAPH-9B20
        0x9B33, # G+15326  U+9B33  uni9B33,  CJK UNIFIED IDEOGRAPH-9B33
        0x9B34, # G+15327  U+9B34  uni9B34,  CJK UNIFIED IDEOGRAPH-9B34
        0x9B73, # G+15328  U+9B73  uni9B73,  CJK UNIFIED IDEOGRAPH-9B73
        0x9B79, # G+15329  U+9B79  uni9B79,  CJK UNIFIED IDEOGRAPH-9B79
        0x9BA7, # G+15330  U+9BA7  uni9BA7,  CJK UNIFIED IDEOGRAPH-9BA7
        0x9BC1, # G+15331  U+9BC1  uni9BC1,  CJK UNIFIED IDEOGRAPH-9BC1
        0x9BC7, # G+15332  U+9BC7  uni9BC7,  CJK UNIFIED IDEOGRAPH-9BC7
        0x9BD7, # G+15333  U+9BD7  uni9BD7,  CJK UNIFIED IDEOGRAPH-9BD7
        0x9BE7, # G+15334  U+9BE7  uni9BE7,  CJK UNIFIED IDEOGRAPH-9BE7
        0x9BEB, # G+15335  U+9BEB  uni9BEB,  CJK UNIFIED IDEOGRAPH-9BEB
        0x9BF7, # G+15336  U+9BF7  uni9BF7,  CJK UNIFIED IDEOGRAPH-9BF7
        0x9BFA, # G+15337  U+9BFA  uni9BFA,  CJK UNIFIED IDEOGRAPH-9BFA
        0x9BFD, # G+15338  U+9BFD  uni9BFD,  CJK UNIFIED IDEOGRAPH-9BFD
        0x9C0B, # G+15339  U+9C0B  uni9C0B,  CJK UNIFIED IDEOGRAPH-9C0B
        0x9C27, # G+15340  U+9C27  uni9C27,  CJK UNIFIED IDEOGRAPH-9C27
        0x9C2A, # G+15341  U+9C2A  uni9C2A,  CJK UNIFIED IDEOGRAPH-9C2A
        0x9C36, # G+15342  U+9C36  uni9C36,  CJK UNIFIED IDEOGRAPH-9C36
        0x9C41, # G+15343  U+9C41  uni9C41,  CJK UNIFIED IDEOGRAPH-9C41
        0x9C53, # G+15344  U+9C53  uni9C53,  CJK UNIFIED IDEOGRAPH-9C53
        0x9C63, # G+15345  U+9C63  uni9C63,  CJK UNIFIED IDEOGRAPH-9C63
        0x9C6A, # G+15346  U+9C6A  uni9C6A,  CJK UNIFIED IDEOGRAPH-9C6A
        0x9C77, # G+15347  U+9C77  uni9C77,  CJK UNIFIED IDEOGRAPH-9C77
        0x9D02, # G+15348  U+9D02  uni9D02,  CJK UNIFIED IDEOGRAPH-9D02
        0x9D42, # G+15349  U+9D42  uni9D42,  CJK UNIFIED IDEOGRAPH-9D42
        0x9D47, # G+15350  U+9D47  uni9D47,  CJK UNIFIED IDEOGRAPH-9D47
        0x9D63, # G+15351  U+9D63  uni9D63,  CJK UNIFIED IDEOGRAPH-9D63
        0x9D69, # G+15352  U+9D69  uni9D69,  CJK UNIFIED IDEOGRAPH-9D69
        0x9D7C, # G+15353  U+9D7C  uni9D7C,  CJK UNIFIED IDEOGRAPH-9D7C
        0x9D7E, # G+15354  U+9D7E  uni9D7E,  CJK UNIFIED IDEOGRAPH-9D7E
        0x9D8D, # G+15355  U+9D8D  uni9D8D,  CJK UNIFIED IDEOGRAPH-9D8D
        0x9DB1, # G+15356  U+9DB1  uni9DB1,  CJK UNIFIED IDEOGRAPH-9DB1
        0x9DC3, # G+15357  U+9DC3  uni9DC3,  CJK UNIFIED IDEOGRAPH-9DC3
        0x9DC7, # G+15358  U+9DC7  uni9DC7,  CJK UNIFIED IDEOGRAPH-9DC7
        0x9DD6, # G+15359  U+9DD6  uni9DD6,  CJK UNIFIED IDEOGRAPH-9DD6
        0x9DDF, # G+15360  U+9DDF  uni9DDF,  CJK UNIFIED IDEOGRAPH-9DDF
        0x9DEB, # G+15361  U+9DEB  uni9DEB,  CJK UNIFIED IDEOGRAPH-9DEB
        0x9DF4, # G+15362  U+9DF4  uni9DF4,  CJK UNIFIED IDEOGRAPH-9DF4
        0x9E15, # G+15363  U+9E15  uni9E15,  CJK UNIFIED IDEOGRAPH-9E15
        0x9E1D, # G+15364  U+9E1D  uni9E1D,  CJK UNIFIED IDEOGRAPH-9E1D
        0x9EA4, # G+15365  U+9EA4  uni9EA4,  CJK UNIFIED IDEOGRAPH-9EA4
        0x9EA8, # G+15366  U+9EA8  uni9EA8,  CJK UNIFIED IDEOGRAPH-9EA8
        0x9EAC, # G+15367  U+9EAC  uni9EAC,  CJK UNIFIED IDEOGRAPH-9EAC
        0x9EE7, # G+15368  U+9EE7  uni9EE7,  CJK UNIFIED IDEOGRAPH-9EE7
        0x9EEE, # G+15369  U+9EEE  uni9EEE,  CJK UNIFIED IDEOGRAPH-9EEE
        0x9F10, # G+15370  U+9F10  uni9F10,  CJK UNIFIED IDEOGRAPH-9F10
        0x9F12, # G+15371  U+9F12  uni9F12,  CJK UNIFIED IDEOGRAPH-9F12
        0x9F17, # G+15372  U+9F17  uni9F17,  CJK UNIFIED IDEOGRAPH-9F17
        0x9F19, # G+15373  U+9F19  uni9F19,  CJK UNIFIED IDEOGRAPH-9F19
        0x9F2F, # G+15374  U+9F2F  uni9F2F,  CJK UNIFIED IDEOGRAPH-9F2F
        0x9F37, # G+15375  U+9F37  uni9F37,  CJK UNIFIED IDEOGRAPH-9F37
        0x9F39, # G+15376  U+9F39  uni9F39,  CJK UNIFIED IDEOGRAPH-9F39
        0x9F41, # G+15377  U+9F41  uni9F41,  CJK UNIFIED IDEOGRAPH-9F41
        0x9F45, # G+15378  U+9F45  uni9F45,  CJK UNIFIED IDEOGRAPH-9F45
        0x9F57, # G+15379  U+9F57  uni9F57,  CJK UNIFIED IDEOGRAPH-9F57
        0x9F68, # G+15380  U+9F68  uni9F68,  CJK UNIFIED IDEOGRAPH-9F68
        0x9F71, # G+15381  U+9F71  uni9F71,  CJK UNIFIED IDEOGRAPH-9F71
        0x9F75, # G+15382  U+9F75  uni9F75,  CJK UNIFIED IDEOGRAPH-9F75
        0x9F90, # G+15383  U+9F90  uni9F90,  CJK UNIFIED IDEOGRAPH-9F90
        0x9F94, # G+15384  U+9F94  uni9F94,  CJK UNIFIED IDEOGRAPH-9F94
        0x9FA2, # G+15385  U+9FA2  uni9FA2,  CJK UNIFIED IDEOGRAPH-9FA2
        0x0000, # G+15386  U+0000  .notdef,  UNDEFINED
        0x3405, # G+15387  U+3405  uni3405,  CJK UNIFIED IDEOGRAPH-3405
        0x0000, # G+15388  U+0000  .notdef,  UNDEFINED
        0x5620, # G+15389  U+5620  uni5620,  CJK UNIFIED IDEOGRAPH-5620
        0x0000, # G+15390  U+0000  .notdef,  UNDEFINED
        0x2E95, # G+15391  U+2E95  uni2E95,  CJK RADICAL SNOUT TWO
        0x0000, # G+15392  U+0000  .notdef,  UNDEFINED
        0x0000, # G+15393  U+0000  .notdef,  UNDEFINED
        0x0000, # G+15394  U+0000  .notdef,  UNDEFINED
        0x0000, # G+15395  U+0000  .notdef,  UNDEFINED
        0x6EE6, # G+15396  U+6EE6  uni6EE6,  CJK UNIFIED IDEOGRAPH-6EE6
        0x0000, # G+15397  U+0000  .notdef,  UNDEFINED
        0x2EA4, # G+15398  U+2EA4  uni2EA4,  CJK RADICAL PAW ONE
        0x0000, # G+15399  U+0000  .notdef,  UNDEFINED
        0x0000, # G+15400  U+0000  .notdef,  UNDEFINED
        0x0000, # G+15401  U+0000  .notdef,  UNDEFINED
        0x0000, # G+15402  U+0000  .notdef,  UNDEFINED
        0x2ECC, # G+15403  U+2ECC  uni2ECC,  CJK RADICAL SIMPLIFIED WALK
        0x0000, # G+15404  U+0000  .notdef,  UNDEFINED
        0x0000, # G+15405  U+0000  .notdef,  UNDEFINED
        0x0000, # G+15406  U+0000  .notdef,  UNDEFINED
        0x4FD3, # G+15407  U+4FD3  uni4FD3,  CJK UNIFIED IDEOGRAPH-4FD3
        0x50D9, # G+15408  U+50D9  uni50D9,  CJK UNIFIED IDEOGRAPH-50D9
        0x50F0, # G+15409  U+50F0  uni50F0,  CJK UNIFIED IDEOGRAPH-50F0
        0x51C3, # G+15410  U+51C3  uni51C3,  CJK UNIFIED IDEOGRAPH-51C3
        0x5676, # G+15411  U+5676  uni5676,  CJK UNIFIED IDEOGRAPH-5676
        0x6A54, # G+15412  U+6A54  uni6A54,  CJK UNIFIED IDEOGRAPH-6A54
        0x6D01, # G+15413  U+6D01  uni6D01,  CJK UNIFIED IDEOGRAPH-6D01
        0x6DD0, # G+15414  U+6DD0  uni6DD0,  CJK UNIFIED IDEOGRAPH-6DD0
        0x6E42, # G+15415  U+6E42  uni6E42,  CJK UNIFIED IDEOGRAPH-6E42
        0x6ED9, # G+15416  U+6ED9  uni6ED9,  CJK UNIFIED IDEOGRAPH-6ED9
        0x73E4, # G+15417  U+73E4  uni73E4,  CJK UNIFIED IDEOGRAPH-73E4
        0x7421, # G+15418  U+7421  uni7421,  CJK UNIFIED IDEOGRAPH-7421
        0x756C, # G+15419  U+756C  uni756C,  CJK UNIFIED IDEOGRAPH-756C
        0x7851, # G+15420  U+7851  uni7851,  CJK UNIFIED IDEOGRAPH-7851
        0x87F5, # G+15421  U+87F5  uni87F5,  CJK UNIFIED IDEOGRAPH-87F5
        0x0000, # G+15422  U+0000  .notdef,  UNDEFINED
        0x73A8, # G+15423  U+73A8  uni73A8,  CJK UNIFIED IDEOGRAPH-73A8
        0x3AF3, # G+15424  U+3AF3  uni3AF3,  CJK UNIFIED IDEOGRAPH-3AF3
        0x34DB, # G+15425  U+34DB  uni34DB,  CJK UNIFIED IDEOGRAPH-34DB
        0x440C, # G+15426  U+440C  uni440C,  CJK UNIFIED IDEOGRAPH-440C
        0x3E8A, # G+15427  U+3E8A  uni3E8A,  CJK UNIFIED IDEOGRAPH-3E8A
        0x0000, # G+15428  U+0000  .notdef,  UNDEFINED
        0x0000, # G+15429  U+0000  .notdef,  UNDEFINED
        0x4BE8, # G+15430  U+4BE8  uni4BE8,  CJK UNIFIED IDEOGRAPH-4BE8
        0x0000, # G+15431  U+0000  .notdef,  UNDEFINED
        0x3EDA, # G+15432  U+3EDA  uni3EDA,  CJK UNIFIED IDEOGRAPH-3EDA
        0x3B22, # G+15433  U+3B22  uni3B22,  CJK UNIFIED IDEOGRAPH-3B22
        0x0000, # G+15434  U+0000  .notdef,  UNDEFINED
        0x457A, # G+15435  U+457A  uni457A,  CJK UNIFIED IDEOGRAPH-457A
        0x4093, # G+15436  U+4093  uni4093,  CJK UNIFIED IDEOGRAPH-4093
        0x0000, # G+15437  U+0000  .notdef,  UNDEFINED
        0x4665, # G+15438  U+4665  uni4665,  CJK UNIFIED IDEOGRAPH-4665
        0x4103, # G+15439  U+4103  uni4103,  CJK UNIFIED IDEOGRAPH-4103
        0x4293, # G+15440  U+4293  uni4293,  CJK UNIFIED IDEOGRAPH-4293
        0x46AE, # G+15441  U+46AE  uni46AE,  CJK UNIFIED IDEOGRAPH-46AE
        0x3488, # G+15442  U+3488  uni3488,  CJK UNIFIED IDEOGRAPH-3488
        0x0000, # G+15443  U+0000  .notdef,  UNDEFINED
    ],
    'u2g' => {
        '0' => '0', # G+0  U+0000  .notdef,  UNDEFINED
        '32' => '1',    # G+1  U+0020  space,  SPACE
        '33' => '2',    # G+2  U+0021  exclam,  EXCLAMATION MARK
        '33' => '232',  # G+232  U+0021  exclam,  EXCLAMATION MARK
        '34' => '3',    # G+3  U+0022  quotedbl,  QUOTATION MARK
        '34' => '233',  # G+233  U+0022  quotedbl,  QUOTATION MARK
        '35' => '4',    # G+4  U+0023  numbersign,  NUMBER SIGN
        '35' => '234',  # G+234  U+0023  numbersign,  NUMBER SIGN
        '36' => '5',    # G+5  U+0024  dollar,  DOLLAR SIGN
        '36' => '235',  # G+235  U+0024  dollar,  DOLLAR SIGN
        '37' => '6',    # G+6  U+0025  percent,  PERCENT SIGN
        '37' => '236',  # G+236  U+0025  percent,  PERCENT SIGN
        '38' => '7',    # G+7  U+0026  ampersand,  AMPERSAND
        '38' => '237',  # G+237  U+0026  ampersand,  AMPERSAND
        '39' => '8',    # G+8  U+0027  quotesingle,  APOSTROPHE
        '39' => '238',  # G+238  U+0027  quotesingle,  APOSTROPHE
        '40' => '9',    # G+9  U+0028  parenleft,  LEFT PARENTHESIS
        '40' => '239',  # G+239  U+0028  parenleft,  LEFT PARENTHESIS
        '41' => '10',   # G+10  U+0029  parenright,  RIGHT PARENTHESIS
        '41' => '240',  # G+240  U+0029  parenright,  RIGHT PARENTHESIS
        '42' => '11',   # G+11  U+002A  asterisk,  ASTERISK
        '42' => '241',  # G+241  U+002A  asterisk,  ASTERISK
        '43' => '12',   # G+12  U+002B  plus,  PLUS SIGN
        '43' => '242',  # G+242  U+002B  plus,  PLUS SIGN
        '44' => '13',   # G+13  U+002C  comma,  COMMA
        '44' => '243',  # G+243  U+002C  comma,  COMMA
        '45' => '14',   # G+14  U+002D  hyphen,  HYPHEN-MINUS
        '45' => '244',  # G+244  U+002D  hyphen,  HYPHEN-MINUS
        '46' => '15',   # G+15  U+002E  period,  FULL STOP
        '46' => '245',  # G+245  U+002E  period,  FULL STOP
        '47' => '16',   # G+16  U+002F  slash,  SOLIDUS
        '47' => '246',  # G+246  U+002F  slash,  SOLIDUS
        '48' => '17',   # G+17  U+0030  zero,  DIGIT ZERO
        '48' => '247',  # G+247  U+0030  zero,  DIGIT ZERO
        '49' => '18',   # G+18  U+0031  one,  DIGIT ONE
        '49' => '248',  # G+248  U+0031  one,  DIGIT ONE
        '50' => '19',   # G+19  U+0032  two,  DIGIT TWO
        '50' => '249',  # G+249  U+0032  two,  DIGIT TWO
        '51' => '20',   # G+20  U+0033  three,  DIGIT THREE
        '51' => '250',  # G+250  U+0033  three,  DIGIT THREE
        '52' => '21',   # G+21  U+0034  four,  DIGIT FOUR
        '52' => '251',  #