#=======================================================================
#    ____  ____  _____              _    ____ ___   ____
#   |  _ \|  _ \|  ___|  _   _     / \  |  _ \_ _| |___ \
#   | |_) | | | | |_    (_) (_)   / _ \ | |_) | |    __) |
#   |  __/| |_| |  _|    _   _   / ___ \|  __/| |   / __/
#   |_|   |____/|_|     (_) (_) /_/   \_\_|  |___| |_____|
#
#   A Perl Module Chain to faciliate the Creation and Modification
#   of High-Quality "Portable Document Format (PDF)" Files.
#
#   Copyright 1999-2004 Alfred Reibenschuh <areibens@cpan.org>.
#
#=======================================================================
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the
#   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#   Boston, MA 02111-1307, USA.
#
#   $Id: japanese.pm,v 1.3 2003/12/08 13:05:43 Administrator Exp $
#
#=======================================================================

$cmap->{japanese}={
    'g2u' => [
        0x0000, # G+0
        0x02D8, # G+1
        0x02C7, # G+2
        0x00B8, # G+3
        0x02D9, # G+4
        0x02DD, # G+5
        0x00AF, # G+6
        0x02DB, # G+7
        0x02DA, # G+8
        0x007E, # G+9
        0x0384, # G+10
        0x0385, # G+11
        0x00A1, # G+12
        0x00A6, # G+13
        0x00BF, # G+14
        0x00BA, # G+15
        0x00AA, # G+16
        0x00A9, # G+17
        0x00AE, # G+18
        0x2122, # G+19
        0x00A4, # G+20
        0x2116, # G+21
        0x0386, # G+22
        0x0388, # G+23
        0x0389, # G+24
        0x038A, # G+25
        0x03AA, # G+26
        0x038C, # G+27
        0x038E, # G+28
        0x03AB, # G+29
        0x038F, # G+30
        0x03AC, # G+31
        0x03AD, # G+32
        0x03AE, # G+33
        0x03AF, # G+34
        0x03CA, # G+35
        0x0390, # G+36
        0x03CC, # G+37
        0x03C2, # G+38
        0x03CD, # G+39
        0x03CB, # G+40
        0x03B0, # G+41
        0x03CE, # G+42
        0x0402, # G+43
        0x0403, # G+44
        0x0404, # G+45
        0x0405, # G+46
        0x0406, # G+47
        0x0407, # G+48
        0x0408, # G+49
        0x0409, # G+50
        0x040A, # G+51
        0x040B, # G+52
        0x040C, # G+53
        0x040E, # G+54
        0x040F, # G+55
        0x0452, # G+56
        0x0453, # G+57
        0x0454, # G+58
        0x0455, # G+59
        0x0456, # G+60
        0x0457, # G+61
        0x0458, # G+62
        0x0459, # G+63
        0x045A, # G+64
        0x045B, # G+65
        0x045C, # G+66
        0x045E, # G+67
        0x045F, # G+68
        0x00C6, # G+69
        0x0110, # G+70
        0x0126, # G+71
        0x0132, # G+72
        0x0141, # G+73
        0x013F, # G+74
        0x014A, # G+75
        0x00D8, # G+76
        0x0152, # G+77
        0x0166, # G+78
        0x00DE, # G+79
        0x00E6, # G+80
        0x0111, # G+81
        0x00F0, # G+82
        0x0127, # G+83
        0x0131, # G+84
        0x0133, # G+85
        0x0138, # G+86
        0x0142, # G+87
        0x0140, # G+88
        0x0149, # G+89
        0x014B, # G+90
        0x00F8, # G+91
        0x0153, # G+92
        0x00DF, # G+93
        0x0167, # G+94
        0x00FE, # G+95
        0x00C1, # G+96
        0x00C0, # G+97
        0x00C4, # G+98
        0x00C2, # G+99
        0x0102, # G+100
        0x01CD, # G+101
        0x0100, # G+102
        0x0104, # G+103
        0x00C5, # G+104
        0x00C3, # G+105
        0x0106, # G+106
        0x0108, # G+107
        0x010C, # G+108
        0x00C7, # G+109
        0x010A, # G+110
        0x010E, # G+111
        0x00C9, # G+112
        0x00C8, # G+113
        0x00CB, # G+114
        0x00CA, # G+115
        0x011A, # G+116
        0x0116, # G+117
        0x0112, # G+118
        0x0118, # G+119
        0x011C, # G+120
        0x011E, # G+121
        0x0122, # G+122
        0x0120, # G+123
        0x0124, # G+124
        0x00CD, # G+125
        0x00CC, # G+126
        0x00CF, # G+127
        0x00CE, # G+128
        0x01CF, # G+129
        0x0130, # G+130
        0x012A, # G+131
        0x012E, # G+132
        0x0128, # G+133
        0x0134, # G+134
        0x0136, # G+135
        0x0139, # G+136
        0x013D, # G+137
        0x013B, # G+138
        0x0143, # G+139
        0x0147, # G+140
        0x0145, # G+141
        0x00D1, # G+142
        0x00D3, # G+143
        0x00D2, # G+144
        0x00D6, # G+145
        0x00D4, # G+146
        0x01D1, # G+147
        0x0150, # G+148
        0x014C, # G+149
        0x00D5, # G+150
        0x0154, # G+151
        0x0158, # G+152
        0x0156, # G+153
        0x015A, # G+154
        0x015C, # G+155
        0x0160, # G+156
        0x015E, # G+157
        0x0164, # G+158
        0x0162, # G+159
        0x00DA, # G+160
        0x00D9, # G+161
        0x00DC, # G+162
        0x00DB, # G+163
        0x016C, # G+164
        0x01D3, # G+165
        0x0170, # G+166
        0x016A, # G+167
        0x0172, # G+168
        0x016E, # G+169
        0x0168, # G+170
        0x01D7, # G+171
        0x01DB, # G+172
        0x01D9, # G+173
        0x01D5, # G+174
        0x0174, # G+175
        0x00DD, # G+176
        0x0178, # G+177
        0x0176, # G+178
        0x0179, # G+179
        0x017D, # G+180
        0x017B, # G+181
        0x00E1, # G+182
        0x00E0, # G+183
        0x00E4, # G+184
        0x00E2, # G+185
        0x0103, # G+186
        0x01CE, # G+187
        0x0101, # G+188
        0x0105, # G+189
        0x00E5, # G+190
        0x00E3, # G+191
        0x0107, # G+192
        0x0109, # G+193
        0x010D, # G+194
        0x00E7, # G+195
        0x010B, # G+196
        0x010F, # G+197
        0x00E9, # G+198
        0x00E8, # G+199
        0x00EB, # G+200
        0x00EA, # G+201
        0x011B, # G+202
        0x0117, # G+203
        0x0113, # G+204
        0x0119, # G+205
        0x01F5, # G+206
        0x011D, # G+207
        0x011F, # G+208
        0x0121, # G+209
        0x0125, # G+210
        0x00ED, # G+211
        0x00EC, # G+212
        0x00EF, # G+213
        0x00EE, # G+214
        0x01D0, # G+215
        0x012B, # G+216
        0x012F, # G+217
        0x0129, # G+218
        0x0135, # G+219
        0x0137, # G+220
        0x013A, # G+221
        0x013E, # G+222
        0x013C, # G+223
        0x0144, # G+224
        0x0148, # G+225
        0x0146, # G+226
        0x00F1, # G+227
        0x00F3, # G+228
        0x00F2, # G+229
        0x00F6, # G+230
        0x00F4, # G+231
        0x01D2, # G+232
        0x0151, # G+233
        0x014D, # G+234
        0x00F5, # G+235
        0x0155, # G+236
        0x0159, # G+237
        0x0157, # G+238
        0x015B, # G+239
        0x015D, # G+240
        0x0161, # G+241
        0x015F, # G+242
        0x0165, # G+243
        0x0163, # G+244
        0x00FA, # G+245
        0x00F9, # G+246
        0x00FC, # G+247
        0x00FB, # G+248
        0x016D, # G+249
        0x01D4, # G+250
        0x0171, # G+251
        0x016B, # G+252
        0x0173, # G+253
        0x016F, # G+254
        0x0169, # G+255
        0x01D8, # G+256
        0x01DC, # G+257
        0x01DA, # G+258
        0x01D6, # G+259
        0x0175, # G+260
        0x00FD, # G+261
        0x00FF, # G+262
        0x0177, # G+263
        0x017A, # G+264
        0x017E, # G+265
        0x017C, # G+266
        0x4E02, # G+267
        0x4E04, # G+268
        0x4E05, # G+269
        0x4E0C, # G+270
        0x4E12, # G+271
        0x4E1F, # G+272
        0x4E23, # G+273
        0x4E24, # G+274
        0x2F01, # G+275
        0x4E2B, # G+276
        0x4E2E, # G+277
        0x4E2F, # G+278
        0x4E30, # G+279
        0x4E35, # G+280
        0x4E40, # G+281
        0x4E41, # G+282
        0x4E44, # G+283
        0x4E47, # G+284
        0x4E51, # G+285
        0x2E83, # G+286
        0x4E5C, # G+287
        0x4E63, # G+288
        0x4E68, # G+289
        0x4E69, # G+290
        0x4E74, # G+291
        0x4E75, # G+292
        0x4E79, # G+293
        0x4E7F, # G+294
        0x4E8D, # G+295
        0x4E96, # G+296
        0x4E97, # G+297
        0x4E9D, # G+298
        0x4EAF, # G+299
        0x4EB9, # G+300
        0x4EC3, # G+301
        0x4ED0, # G+302
        0x4EDA, # G+303
        0x4EDB, # G+304
        0x4EE0, # G+305
        0x4EE1, # G+306
        0x4EE2, # G+307
        0x4EE8, # G+308
        0x4EEF, # G+309
        0x4EF1, # G+310
        0x4EF3, # G+311
        0x4EF5, # G+312
        0x4EFD, # G+313
        0x4EFE, # G+314
        0x4EFF, # G+315
        0x4F00, # G+316
        0x4F02, # G+317
        0x4F03, # G+318
        0x4F08, # G+319
        0x4F0B, # G+320
        0x4F0C, # G+321
        0x4F12, # G+322
        0x4F15, # G+323
        0x4F16, # G+324
        0x4F17, # G+325
        0x4F19, # G+326
        0x4F2E, # G+327
        0x4F31, # G+328
        0x4F60, # G+329
        0x4F33, # G+330
        0x4F35, # G+331
        0x4F37, # G+332
        0x4F39, # G+333
        0x4F3B, # G+334
        0x4F3E, # G+335
        0x4F40, # G+336
        0x4F42, # G+337
        0x4F48, # G+338
        0x4F49, # G+339
        0x4F4B, # G+340
        0x4F4C, # G+341
        0x4F52, # G+342
        0x4F54, # G+343
        0x4F56, # G+344
        0x4F58, # G+345
        0x4F5F, # G+346
        0x4F63, # G+347
        0x4F6A, # G+348
        0x4F6C, # G+349
        0x4F6E, # G+350
        0x4F71, # G+351
        0x4F77, # G+352
        0x4F78, # G+353
        0x4F79, # G+354
        0x4F7A, # G+355
        0x4F7D, # G+356
        0x4F7E, # G+357
        0x4F81, # G+358
        0x4F82, # G+359
        0x4F84, # G+360
        0x4F85, # G+361
        0x4F89, # G+362
        0x4F8A, # G+363
        0x4F8C, # G+364
        0x4F8E, # G+365
        0x4F90, # G+366
        0x4F92, # G+367
        0x4F93, # G+368
        0x4F94, # G+369
        0x4F97, # G+370
        0x4F99, # G+371
        0x4F9A, # G+372
        0x4F9E, # G+373
        0x4F9F, # G+374
        0x4FB2, # G+375
        0x4FB7, # G+376
        0x4FB9, # G+377
        0x4FBB, # G+378
        0x4FBC, # G+379
        0x4FBD, # G+380
        0x4FBE, # G+381
        0x4FC0, # G+382
        0x4FC1, # G+383
        0x4FC5, # G+384
        0x4FC6, # G+385
        0x4FC8, # G+386
        0x4FC9, # G+387
        0x4FCB, # G+388
        0x4FCC, # G+389
        0x4FCD, # G+390
        0x4FCF, # G+391
        0x4FD2, # G+392
        0x4FDC, # G+393
        0x4FE0, # G+394
        0x4FE2, # G+395
        0x4FF0, # G+396
        0x4FF2, # G+397
        0x4FFC, # G+398
        0x4FFD, # G+399
        0x4FFF, # G+400
        0x5000, # G+401
        0x5001, # G+402
        0x5004, # G+403
        0x5007, # G+404
        0x500A, # G+405
        0x500C, # G+406
        0x500E, # G+407
        0x5010, # G+408
        0x5013, # G+409
        0x5017, # G+410
        0x5018, # G+411
        0x501B, # G+412
        0x501C, # G+413
        0x501D, # G+414
        0x501E, # G+415
        0x5022, # G+416
        0x5027, # G+417
        0x502E, # G+418
        0x5030, # G+419
        0x5032, # G+420
        0x5033, # G+421
        0x5035, # G+422
        0x5040, # G+423
        0x5041, # G+424
        0x5042, # G+425
        0x5045, # G+426
        0x5046, # G+427
        0x504A, # G+428
        0x504C, # G+429
        0x504E, # G+430
        0x5051, # G+431
        0x5052, # G+432
        0x5053, # G+433
        0x5057, # G+434
        0x5059, # G+435
        0x505F, # G+436
        0x5060, # G+437
        0x5062, # G+438
        0x5063, # G+439
        0x5066, # G+440
        0x5067, # G+441
        0x506A, # G+442
        0x506D, # G+443
        0x5070, # G+444
        0x5071, # G+445
        0x503B, # G+446
        0x5081, # G+447
        0x5083, # G+448
        0x5084, # G+449
        0x5086, # G+450
        0x508A, # G+451
        0x508E, # G+452
        0x508F, # G+453
        0x5090, # G+454
        0x5092, # G+455
        0x5093, # G+456
        0x5094, # G+457
        0x5096, # G+458
        0x509B, # G+459
        0x509C, # G+460
        0x509E, # G+461
        0x509F, # G+462
        0x50A0, # G+463
        0x50A1, # G+464
        0x50A2, # G+465
        0x50AA, # G+466
        0x50AF, # G+467
        0x50B0, # G+468
        0x50B9, # G+469
        0x50BA, # G+470
        0x50BD, # G+471
        0x50C0, # G+472
        0x50C3, # G+473
        0x50C4, # G+474
        0x50C7, # G+475
        0x50CC, # G+476
        0x50CE, # G+477
        0x50D0, # G+478
        0x50D3, # G+479
        0x50D4, # G+480
        0x50D8, # G+481
        0x50DC, # G+482
        0x50DD, # G+483
        0x50DF, # G+484
        0x50E2, # G+485
        0x50E4, # G+486
        0x50E6, # G+487
        0x50E8, # G+488
        0x50E9, # G+489
        0x50EF, # G+490
        0x50F1, # G+491
        0x50F6, # G+492
        0x50FA, # G+493
        0x50FE, # G+494
        0x5103, # G+495
        0x5106, # G+496
        0x5107, # G+497
        0x5108, # G+498
        0x510B, # G+499
        0x510C, # G+500
        0x510D, # G+501
        0x510E, # G+502
        0x50F2, # G+503
        0x5110, # G+504
        0x5117, # G+505
        0x5119, # G+506
        0x511B, # G+507
        0x511C, # G+508
        0x511D, # G+509
        0x511E, # G+510
        0x5123, # G+511
        0x5127, # G+512
        0x5128, # G+513
        0x512C, # G+514
        0x512D, # G+515
        0x512F, # G+516
        0x5131, # G+517
        0x5133, # G+518
        0x5134, # G+519
        0x5135, # G+520
        0x5138, # G+521
        0x5139, # G+522
        0x5142, # G+523
        0x514A, # G+524
        0x514F, # G+525
        0x5153, # G+526
        0x5155, # G+527
        0x5157, # G+528
        0x5158, # G+529
        0x515F, # G+530
        0x5164, # G+531
        0x5166, # G+532
        0x517E, # G+533
        0x5183, # G+534
        0x5184, # G+535
        0x518B, # G+536
        0x518E, # G+537
        0x5198, # G+538
        0x519D, # G+539
        0x51A1, # G+540
        0x51A3, # G+541
        0x51AD, # G+542
        0x51B8, # G+543
        0x51BA, # G+544
        0x51BC, # G+545
        0x51BE, # G+546
        0x51BF, # G+547
        0x51C2, # G+548
        0x51C8, # G+549
        0x51CF, # G+550
        0x51D1, # G+551
        0x51D2, # G+552
        0x51D3, # G+553
        0x51D5, # G+554
        0x51D8, # G+555
        0x51DE, # G+556
        0x51E2, # G+557
        0x51E5, # G+558
        0x51EE, # G+559
        0x51F2, # G+560
        0x51F3, # G+561
        0x51F4, # G+562
        0x51F7, # G+563
        0x5201, # G+564
        0x2E89, # G+565
        0x5205, # G+566
        0x5212, # G+567
        0x5213, # G+568
        0x5215, # G+569
        0x5216, # G+570
        0x5218, # G+571
        0x5222, # G+572
        0x5228, # G+573
        0x5231, # G+574
        0x5232, # G+575
        0x5235, # G+576
        0x523C, # G+577
        0x5245, # G+578
        0x5249, # G+579
        0x5255, # G+580
        0x5257, # G+581
        0x5258, # G+582
        0x525A, # G+583
        0x525C, # G+584
        0x525F, # G+585
        0x5260, # G+586
        0x5261, # G+587
        0x5266, # G+588
        0x526E, # G+589
        0x5277, # G+590
        0x5278, # G+591
        0x5279, # G+592
        0x5280, # G+593
        0x5282, # G+594
        0x5285, # G+595
        0x528A, # G+596
        0x528C, # G+597
        0x5293, # G+598
        0x5295, # G+599
        0x5296, # G+600
        0x5297, # G+601
        0x5298, # G+602
        0x529A, # G+603
        0x529C, # G+604
        0x52A4, # G+605
        0x52A5, # G+606
        0x52A6, # G+607
        0x52A7, # G+608
        0x52AF, # G+609
        0x52B0, # G+610
        0x52B6, # G+611
        0x52B7, # G+612
        0x52B8, # G+613
        0x52BA, # G+614
        0x52BB, # G+615
        0x52BD, # G+616
        0x52C0, # G+617
        0x52C4, # G+618
        0x52C6, # G+619
        0x52C8, # G+620
        0x52CC, # G+621
        0x52CF, # G+622
        0x52D1, # G+623
        0x52D4, # G+624
        0x52D6, # G+625
        0x52DB, # G+626
        0x52DC, # G+627
        0x52E1, # G+628
        0x52E5, # G+629
        0x52E8, # G+630
        0x52E9, # G+631
        0x52EA, # G+632
        0x52EC, # G+633
        0x52F0, # G+634
        0x52F1, # G+635
        0x52F4, # G+636
        0x52F6, # G+637
        0x52F7, # G+638
        0x5300, # G+639
        0x5303, # G+640
        0x530A, # G+641
        0x530B, # G+642
        0x530C, # G+643
        0x5311, # G+644
        0x5313, # G+645
        0x5318, # G+646
        0x531B, # G+647
        0x531C, # G+648
        0x531E, # G+649
        0x531F, # G+650
        0x5325, # G+651
        0x5327, # G+652
        0x5328, # G+653
        0x5329, # G+654
        0x532B, # G+655
        0x532C, # G+656
        0x532D, # G+657
        0x5330, # G+658
        0x5332, # G+659
        0x5335, # G+660
        0x533C, # G+661
        0x533D, # G+662
        0x533E, # G+663
        0x5342, # G+664
        0x534C, # G+665
        0x534B, # G+666
        0x5359, # G+667
        0x535B, # G+668
        0x5361, # G+669
        0x5363, # G+670
        0x5365, # G+671
        0x536C, # G+672
        0x536D, # G+673
        0x5372, # G+674
        0x5379, # G+675
        0x537E, # G+676
        0x5383, # G+677
        0x5387, # G+678
        0x5388, # G+679
        0x538E, # G+680
        0x5393, # G+681
        0x5394, # G+682
        0x5399, # G+683
        0x539D, # G+684
        0x53A1, # G+685
        0x53A4, # G+686
        0x53AA, # G+687
        0x53AB, # G+688
        0x53AF, # G+689
        0x53B2, # G+690
        0x53B4, # G+691
        0x53B5, # G+692
        0x53B7, # G+693
        0x53B8, # G+694
        0x53BA, # G+695
        0x53BD, # G+696
        0x53C0, # G+697
        0x53C5, # G+698
        0x53CF, # G+699
        0x53D2, # G+700
        0x53D3, # G+701
        0x53D5, # G+702
        0x53DA, # G+703
        0x53DD, # G+704
        0x53DE, # G+705
        0x53E0, # G+706
        0x53E6, # G+707
        0x53E7, # G+708
        0x53F5, # G+709
        0x5402, # G+710
        0x5413, # G+711
        0x541A, # G+712
        0x5421, # G+713
        0x5427, # G+714
        0x5428, # G+715
        0x542A, # G+716
        0x542F, # G+717
        0x5431, # G+718
        0x5434, # G+719
        0x5435, # G+720
        0x5443, # G+721
        0x5444, # G+722
        0x5447, # G+723
        0x544D, # G+724
        0x544F, # G+725
        0x545E, # G+726
        0x5462, # G+727
        0x5464, # G+728
        0x5466, # G+729
        0x5467, # G+730
        0x5469, # G+731
        0x546B, # G+732
        0x546D, # G+733
        0x546E, # G+734
        0x5474, # G+735
        0x547F, # G+736
        0x5481, # G+737
        0x5483, # G+738
        0x5485, # G+739
        0x5488, # G+740
        0x5489, # G+741
        0x548D, # G+742
        0x5491, # G+743
        0x5495, # G+744
        0x5496, # G+745
        0x549C, # G+746
        0x549F, # G+747
        0x54A1, # G+748
        0x54A6, # G+749
        0x54A7, # G+750
        0x54A9, # G+751
        0x54AA, # G+752
        0x54AD, # G+753
        0x54AE, # G+754
        0x54B1, # G+755
        0x54B7, # G+756
        0x54B9, # G+757
        0x54BA, # G+758
        0x54BB, # G+759
        0x54BF, # G+760
        0x54C6, # G+761
        0x54CA, # G+762
        0x54CD, # G+763
        0x54CE, # G+764
        0x54E0, # G+765
        0x54EA, # G+766
        0x54EC, # G+767
        0x54EF, # G+768
        0x54F6, # G+769
        0x54FC, # G+770
        0x54FE, # G+771
        0x54FF, # G+772
        0x5500, # G+773
        0x5501, # G+774
        0x5505, # G+775
        0x5508, # G+776
        0x5509, # G+777
        0x550C, # G+778
        0x550D, # G+779
        0x550E, # G+780
        0x5515, # G+781
        0x552A, # G+782
        0x552B, # G+783
        0x5532, # G+784
        0x5535, # G+785
        0x5536, # G+786
        0x553B, # G+787
        0x553C, # G+788
        0x553D, # G+789
        0x5541, # G+790
        0x5547, # G+791
        0x5549, # G+792
        0x554A, # G+793
        0x554D, # G+794
        0x5550, # G+795
        0x5551, # G+796
        0x5558, # G+797
        0x555A, # G+798
        0x555B, # G+799
        0x555E, # G+800
        0x5560, # G+801
        0x5561, # G+802
        0x5564, # G+803
        0x5566, # G+804
        0x557F, # G+805
        0x5581, # G+806
        0x5582, # G+807
        0x5586, # G+808
        0x5588, # G+809
        0x558E, # G+810
        0x558F, # G+811
        0x5591, # G+812
        0x5592, # G+813
        0x5593, # G+814
        0x5594, # G+815
        0x5597, # G+816
        0x55A3, # G+817
        0x55A4, # G+818
        0x55AD, # G+819
        0x55B2, # G+820
        0x55BF, # G+821
        0x55C1, # G+822
        0x55C3, # G+823
        0x55C6, # G+824
        0x55C9, # G+825
        0x55CB, # G+826
        0x55CC, # G+827
        0x55CE, # G+828
        0x55D1, # G+829
        0x55D2, # G+830
        0x55D3, # G+831
        0x55D7, # G+832
        0x55D8, # G+833
        0x55DB, # G+834
        0x55DE, # G+835
        0x55E2, # G+836
        0x55E9, # G+837
        0x55F6, # G+838
        0x55FF, # G+839
        0x5605, # G+840
        0x5608, # G+841
        0x560A, # G+842
        0x560D, # G+843
        0x560E, # G+844
        0x560F, # G+845
        0x5610, # G+846
        0x5611, # G+847
        0x5612, # G+848
        0x5619, # G+849
        0x562C, # G+850
        0x5630, # G+851
        0x5633, # G+852
        0x5635, # G+853
        0x5637, # G+854
        0x5639, # G+855
        0x563B, # G+856
        0x563C, # G+857
        0x563D, # G+858
        0x563F, # G+859
        0x5640, # G+860
        0x5641, # G+861
        0x5643, # G+862
        0x5644, # G+863
        0x5646, # G+864
        0x5649, # G+865
        0x564B, # G+866
        0x564D, # G+867
        0x564F, # G+868
        0x5654, # G+869
        0x565E, # G+870
        0x5660, # G+871
        0x5661, # G+872
        0x5662, # G+873
        0x5663, # G+874
        0x5666, # G+875
        0x5669, # G+876
        0x566D, # G+877
        0x566F, # G+878
        0x5671, # G+879
        0x5672, # G+880
        0x5675, # G+881
        0x5684, # G+882
        0x5685, # G+883
        0x5688, # G+884
        0x568B, # G+885
        0x568C, # G+886
        0x5695, # G+887
        0x5699, # G+888
        0x569A, # G+889
        0x569D, # G+890
        0x569E, # G+891
        0x569F, # G+892
        0x56A6, # G+893
        0x56A7, # G+894
        0x56A8, # G+895
        0x56A9, # G+896
        0x56AB, # G+897
        0x56AC, # G+898
        0x56AD, # G+899
        0x56B1, # G+900
        0x56B3, # G+901
        0x56B7, # G+902
        0x56BE, # G+903
        0x56C5, # G+904
        0x56C9, # G+905
        0x56CA, # G+906
        0x56CB, # G+907
        0x56CF, # G+908
        0x56D0, # G+909
        0x56CC, # G+910
        0x56CD, # G+911
        0x56D9, # G+912
        0x56DC, # G+913
        0x56DD, # G+914
        0x56DF, # G+915
        0x56E1, # G+916
        0x56E4, # G+917
        0x56E5, # G+918
        0x56E6, # G+919
        0x56E7, # G+920
        0x56E8, # G+921
        0x56F1, # G+922
        0x56EB, # G+923
        0x56ED, # G+924
        0x56F6, # G+925
        0x56F7, # G+926
        0x5701, # G+927
        0x5702, # G+928
        0x5707, # G+929
        0x570A, # G+930
        0x570C, # G+931
        0x5711, # G+932
        0x5715, # G+933
        0x571A, # G+934
        0x571B, # G+935
        0x571D, # G+936
        0x5720, # G+937
        0x5722, # G+938
        0x5723, # G+939
        0x5724, # G+940
        0x5725, # G+941
        0x5729, # G+942
        0x572A, # G+943
        0x572C, # G+944
        0x572E, # G+945
        0x572F, # G+946
        0x5733, # G+947
        0x5734, # G+948
        0x573D, # G+949
        0x573E, # G+950
        0x573F, # G+951
        0x5745, # G+952
        0x5746, # G+953
        0x574C, # G+954
        0x574D, # G+955
        0x5752, # G+956
        0x5762, # G+957
        0x5765, # G+958
        0x5767, # G+959
        0x5768, # G+960
        0x576B, # G+961
        0x576D, # G+962
        0x576E, # G+963
        0x576F, # G+964
        0x5770, # G+965
        0x5771, # G+966
        0x5773, # G+967
        0x5774, # G+968
        0x5775, # G+969
        0x5777, # G+970
        0x5779, # G+971
        0x577A, # G+972
        0x577B, # G+973
        0x577C, # G+974
        0x577E, # G+975
        0x5781, # G+976
        0x5783, # G+977
        0x578C, # G+978
        0x5794, # G+979
        0x5797, # G+980
        0x5799, # G+981
        0x579A, # G+982
        0x579C, # G+983
        0x579D, # G+984
        0x579E, # G+985
        0x579F, # G+986
        0x57A1, # G+987
        0x5795, # G+988
        0x57A7, # G+989
        0x57A8, # G+990
        0x57A9, # G+991
        0x57AC, # G+992
        0x57B8, # G+993
        0x57BD, # G+994
        0x57C7, # G+995
        0x57C8, # G+996
        0x57CC, # G+997
        0x57CF, # G+998
        0x57D5, # G+999
        0x57DD, # G+1000
        0x57DE, # G+1001
        0x57E4, # G+1002
        0x57E6, # G+1003
        0x57E7, # G+1004
        0x57E9, # G+1005
        0x57ED, # G+1006
        0x57F0, # G+1007
        0x57F5, # G+1008
        0x57F6, # G+1009
        0x57F8, # G+1010
        0x57FD, # G+1011
        0x57FE, # G+1012
        0x57FF, # G+1013
        0x5803, # G+1014
        0x5804, # G+1015
        0x5808, # G+1016
        0x5809, # G+1017
        0x57E1, # G+1018
        0x580C, # G+1019
        0x580D, # G+1020
        0x581B, # G+1021
        0x581E, # G+1022
        0x581F, # G+1023
        0x5820, # G+1024
        0x5826, # G+1025
        0x5827, # G+1026
        0x582D, # G+1027
        0x5832, # G+1028
        0x5839, # G+1029
        0x583F, # G+1030
        0x5849, # G+1031
        0x584C, # G+1032
        0x584D, # G+1033
        0x584F, # G+1034
        0x5850, # G+1035
        0x5855, # G+1036
        0x585F, # G+1037
        0x5861, # G+1038
        0x5864, # G+1039
        0x5867, # G+1040
        0x5868, # G+1041
        0x5878, # G+1042
        0x587C, # G+1043
        0x587F, # G+1044
        0x5880, # G+1045
        0x5881, # G+1046
        0x5887, # G+1047
        0x5888, # G+1048
        0x5889, # G+1049
        0x588A, # G+1050
        0x588C, # G+1051
        0x588D, # G+1052
        0x588F, # G+1053
        0x5890, # G+1054
        0x5894, # G+1055
        0x5896, # G+1056
        0x589D, # G+1057
        0x58A0, # G+1058
        0x58A1, # G+1059
        0x58A2, # G+1060
        0x58A6, # G+1061
        0x58A9, # G+1062
        0x58B1, # G+1063
        0x58B2, # G+1064
        0x58C4, # G+1065
        0x58BC, # G+1066
        0x58C2, # G+1067
        0x58C8, # G+1068
        0x58CD, # G+1069
        0x58CE, # G+1070
        0x58D0, # G+1071
        0x58D2, # G+1072
        0x58D4, # G+1073
        0x58D6, # G+1074
        0x58DA, # G+1075
        0x58DD, # G+1076
        0x58E1, # G+1077
        0x58E2, # G+1078
        0x58E9, # G+1079
        0x58F3, # G+1080
        0x5905, # G+1081
        0x5906, # G+1082
        0x590B, # G+1083
        0x590C, # G+1084
        0x5912, # G+1085
        0x5913, # G+1086
        0x5914, # G+1087
        0x8641, # G+1088
        0x591D, # G+1089
        0x5921, # G+1090
        0x5923, # G+1091
        0x5924, # G+1092
        0x5928, # G+1093
        0x592F, # G+1094
        0x5930, # G+1095
        0x5933, # G+1096
        0x5935, # G+1097
        0x5936, # G+1098
        0x593F, # G+1099
        0x5943, # G+1100
        0x5946, # G+1101
        0x5952, # G+1102
        0x5953, # G+1103
        0x5959, # G+1104
        0x595B, # G+1105
        0x595D, # G+1106
        0x595E, # G+1107
        0x595F, # G+1108
        0x5961, # G+1109
        0x5963, # G+1110
        0x596B, # G+1111
        0x596D, # G+1112
        0x596F, # G+1113
        0x5972, # G+1114
        0x5975, # G+1115
        0x5976, # G+1116
        0x5979, # G+1117
        0x597B, # G+1118
        0x597C, # G+1119
        0x598B, # G+1120
        0x598C, # G+1121
        0x598E, # G+1122
        0x5992, # G+1123
        0x5995, # G+1124
        0x5997, # G+1125
        0x599F, # G+1126
        0x59A4, # G+1127
        0x59A7, # G+1128
        0x59AD, # G+1129
        0x59AE, # G+1130
        0x59AF, # G+1131
        0x59B0, # G+1132
        0x59B3, # G+1133
        0x59B7, # G+1134
        0x59BA, # G+1135
        0x59BC, # G+1136
        0x59C1, # G+1137
        0x59C3, # G+1138
        0x59C4, # G+1139
        0x59C8, # G+1140
        0x59CA, # G+1141
        0x59CD, # G+1142
        0x59D2, # G+1143
        0x59DD, # G+1144
        0x59DE, # G+1145
        0x59DF, # G+1146
        0x59E3, # G+1147
        0x59E4, # G+1148
        0x59E7, # G+1149
        0x59EE, # G+1150
        0x59EF, # G+1151
        0x59F1, # G+1152
        0x59F2, # G+1153
        0x59F4, # G+1154
        0x59F7, # G+1155
        0x5A00, # G+1156
        0x5A04, # G+1157
        0x5A0C, # G+1158
        0x5A0D, # G+1159
        0x5A0E, # G+1160
        0x5A12, # G+1161
        0x5A13, # G+1162
        0x5A1E, # G+1163
        0x5A23, # G+1164
        0x5A24, # G+1165
        0x5A27, # G+1166
        0x5A28, # G+1167
        0x5A2A, # G+1168
        0x5A2D, # G+1169
        0x5A30, # G+1170
        0x5A44, # G+1171
        0x5A45, # G+1172
        0x5A47, # G+1173
        0x5A48, # G+1174
        0x5A4C, # G+1175
        0x5A50, # G+1176
        0x5A55, # G+1177
        0x5A5E, # G+1178
        0x5A63, # G+1179
        0x5A65, # G+1180
        0x5A67, # G+1181
        0x5A6D, # G+1182
        0x5A77, # G+1183
        0x5A7A, # G+1184
        0x5A7B, # G+1185
        0x5A7E, # G+1186
        0x5A8B, # G+1187
        0x5A90, # G+1188
        0x5A93, # G+1189
        0x5A96, # G+1190
        0x5A99, # G+1191
        0x5A9C, # G+1192
        0x5A9E, # G+1193
        0x5A9F, # G+1194
        0x5AA0, # G+1195
        0x5AA2, # G+1196
        0x5AA7, # G+1197
        0x5AAC, # G+1198
        0x5AB1, # G+1199
        0x5AB2, # G+1200
        0x5AB3, # G+1201
        0x5AB5, # G+1202
        0x5AB8, # G+1203
        0x5ABA, # G+1204
        0x5ABB, # G+1205
        0x5ABF, # G+1206
        0x5AC4, # G+1207
        0x5AC6, # G+1208
        0x5AC8, # G+1209
        0x5ACF, # G+1210
        0x5ADA, # G+1211
        0x5ADC, # G+1212
        0x5AE0, # G+1213
        0x5AE5, # G+1214
        0x5AEA, # G+1215
        0x5AEE, # G+1216
        0x5AF5, # G+1217
        0x5AF6, # G+1218
        0x5AFD, # G+1219
        0x5B00, # G+1220
        0x5B01, # G+1221
        0x5B08, # G+1222
        0x5B17, # G+1223
        0x5B34, # G+1224
        0x5B19, # G+1225
        0x5B1B, # G+1226
        0x5B1D, # G+1227
        0x5B21, # G+1228
        0x5B25, # G+1229
        0x5B2D, # G+1230
        0x5B38, # G+1231
        0x5B41, # G+1232
        0x5B4B, # G+1233
        0x5B4C, # G+1234
        0x5B52, # G+1235
        0x5B56, # G+1236
        0x5B5E, # G+1237
        0x5B68, # G+1238
        0x5B6E, # G+1239
        0x5B6F, # G+1240
        0x5B7C, # G+1241
        0x5B7D, # G+1242
        0x5B7E, # G+1243
        0x5B7F, # G+1244
        0x5B81, # G+1245
        0x5B84, # G+1246
        0x5B86, # G+1247
        0x5B8A, # G+1248
        0x5B8E, # G+1249
        0x5B90, # G+1250
        0x5B91, # G+1251
        0x5B93, # G+1252
        0x5B94, # G+1253
        0x5B96, # G+1254
        0x5BA8, # G+1255
        0x5BA9, # G+1256
        0x5BAC, # G+1257
        0x5BAD, # G+1258
        0x5BAF, # G+1259
        0x5BB1, # G+1260
        0x5BB2, # G+1261
        0x5BB7, # G+1262
        0x5BBA, # G+1263
        0x5BBC, # G+1264
        0x5BC0, # G+1265
        0x5BC1, # G+1266
        0x5BCD, # G+1267
        0x5BCF, # G+1268
        0x5BD6, # G+1269
        0x5BD7, # G+1270
        0x5BD8, # G+1271
        0x5BD9, # G+1272
        0x5BDA, # G+1273
        0x5BE0, # G+1274
        0x5BEF, # G+1275
        0x5BF1, # G+1276
        0x5BF4, # G+1277
        0x5BFD, # G+1278
        0x5C0C, # G+1279
        0x5C17, # G+1280
        0x5C1E, # G+1281
        0x5C1F, # G+1282
        0x2E8F, # G+1283
        0x5C26, # G+1284
        0x5C29, # G+1285
        0x5C2B, # G+1286
        0x5C2C, # G+1287
        0x5C2E, # G+1288
        0x5C30, # G+1289
        0x5C32, # G+1290
        0x5C35, # G+1291
        0x5C36, # G+1292
        0x5C59, # G+1293
        0x5C5A, # G+1294
        0x5C5C, # G+1295
        0x5C62, # G+1296
        0x5C63, # G+1297
        0x5C67, # G+1298
        0x5C68, # G+1299
        0x5C69, # G+1300
        0x5C6D, # G+1301
        0x5C70, # G+1302
        0x5C74, # G+1303
        0x5C75, # G+1304
        0x5C7A, # G+1305
        0x5C7B, # G+1306
        0x5C7C, # G+1307
        0x5C7D, # G+1308
        0x5C87, # G+1309
        0x5C88, # G+1310
        0x5C8A, # G+1311
        0x5C8F, # G+1312
        0x5C92, # G+1313
        0x5C9D, # G+1314
        0x5C9F, # G+1315
        0x5CA0, # G+1316
        0x5CA2, # G+1317
        0x5CA3, # G+1318
        0x5CA6, # G+1319
        0x5CAA, # G+1320
        0x5CB2, # G+1321
        0x5CB4, # G+1322
        0x5CB5, # G+1323
        0x5CBA, # G+1324
        0x5CC9, # G+1325
        0x5CCB, # G+1326
        0x5CD2, # G+1327
        0x5CDD, # G+1328
        0x5CD7, # G+1329
        0x5CEE, # G+1330
        0x5CF1, # G+1331
        0x5CF2, # G+1332
        0x5CF4, # G+1333
        0x5D01, # G+1334
        0x5D06, # G+1335
        0x5D0D, # G+1336
        0x5D12, # G+1337
        0x5D2B, # G+1338
        0x5D23, # G+1339
        0x5D24, # G+1340
        0x5D26, # G+1341
        0x5D27, # G+1342
        0x5D31, # G+1343
        0x5D34, # G+1344
        0x5D39, # G+1345
        0x5D3D, # G+1346
        0x5D3F, # G+1347
        0x5D42, # G+1348
        0x5D43, # G+1349
        0x5D46, # G+1350
        0x5D48, # G+1351
        0x5D55, # G+1352
        0x5D51, # G+1353
        0x5D59, # G+1354
        0x5D4A, # G+1355
        0x5D5F, # G+1356
        0x5D60, # G+1357
        0x5D61, # G+1358
        0x5D62, # G+1359
        0x5D64, # G+1360
        0x5D6A, # G+1361
        0x5D6D, # G+1362
        0x5D70, # G+1363
        0x5D79, # G+1364
        0x5D7A, # G+1365
        0x5D7E, # G+1366
        0x5D7F, # G+1367
        0x5D81, # G+1368
        0x5D83, # G+1369
        0x5D88, # G+1370
        0x5D8A, # G+1371
        0x5D92, # G+1372
        0x5D93, # G+1373
        0x5D94, # G+1374
        0x5D95, # G+1375
        0x5D99, # G+1376
        0x5D9B, # G+1377
        0x5D9F, # G+1378
        0x5DA0, # G+1379
        0x5DA7, # G+1380
        0x5DAB, # G+1381
        0x5DB0, # G+1382
        0x5DB4, # G+1383
        0x5DB8, # G+1384
        0x5DB9, # G+1385
        0x5DC3, # G+1386
        0x5DC7, # G+1387
        0x5DCB, # G+1388
        0x5DD0, # G+1389
        0x5DCE, # G+1390
        0x5DD8, # G+1391
        0x5DD9, # G+1392
        0x5DE0, # G+1393
        0x5DE4, # G+1394
        0x5DE9, # G+1395
        0x5DF8, # G+1396
        0x5DF9, # G+1397
        0x5E00, # G+1398
        0x5E07, # G+1399
        0x5E0D, # G+1400
        0x5E12, # G+1401
        0x5E14, # G+1402
        0x5E15, # G+1403
        0x5E18, # G+1404
        0x5E1F, # G+1405
        0x5E20, # G+1406
        0x5E2E, # G+1407
        0x5E28, # G+1408
        0x5E32, # G+1409
        0x5E35, # G+1410
        0x5E3E, # G+1411
        0x5E4B, # G+1412
        0x5E50, # G+1413
        0x5E49, # G+1414
        0x5E51, # G+1415
        0x5E56, # G+1416
        0x5E58, # G+1417
        0x5E5B, # G+1418
        0x5E5C, # G+1419
        0x5E5E, # G+1420
        0x5E68, # G+1421
        0x5E6A, # G+1422
        0x5E6B, # G+1423
        0x5E6C, # G+1424
        0x5E6D, # G+1425
        0x5E6E, # G+1426
        0x5E70, # G+1427
        0x5E80, # G+1428
        0x5E8B, # G+1429
        0x5E8E, # G+1430
        0x5EA2, # G+1431
        0x5EA4, # G+1432
        0x5EA5, # G+1433
        0x5EA8, # G+1434
        0x5EAA, # G+1435
        0x5EAC, # G+1436
        0x5EB1, # G+1437
        0x5EB3, # G+1438
        0x5EBD, # G+1439
        0x5EBE, # G+1440
        0x5EBF, # G+1441
        0x5EC6, # G+1442
        0x5ECC, # G+1443
        0x5ECB, # G+1444
        0x5ECE, # G+1445
        0x5ED1, # G+1446
        0x5ED2, # G+1447
        0x5ED4, # G+1448
        0x5ED5, # G+1449
        0x5EDC, # G+1450
        0x5EDE, # G+1451
        0x5EE5, # G+1452
        0x5EEB, # G+1453
        0x5F02, # G+1454
        0x5F06, # G+1455
        0x5F07, # G+1456
        0x5F08, # G+1457
        0x5F0E, # G+1458
        0x5F19, # G+1459
        0x5F1C, # G+1460
        0x5F1D, # G+1461
        0x5F21, # G+1462
        0x5F22, # G+1463
        0x5F23, # G+1464
        0x5F24, # G+1465
        0x5F28, # G+1466
        0x5F2B, # G+1467
        0x5F2C, # G+1468
        0x5F2E, # G+1469
        0x5F30, # G+1470
        0x5F34, # G+1471
        0x5F36, # G+1472
        0x5F3B, # G+1473
        0x5F3D, # G+1474
        0x5F3F, # G+1475
        0x5F40, # G+1476
        0x5F44, # G+1477
        0x5F45, # G+1478
        0x5F47, # G+1479
        0x5F4D, # G+1480
        0x2E95, # G+1481
        0x5F54, # G+1482
        0x5F58, # G+1483
        0x5F5B, # G+1484
        0x5F60, # G+1485
        0x5F63, # G+1486
        0x5F64, # G+1487
        0x5F67, # G+1488
        0x5F6F, # G+1489
        0x5F72, # G+1490
        0x5F74, # G+1491
        0x5F75, # G+1492
        0x5F78, # G+1493
        0x5F7A, # G+1494
        0x5F7D, # G+1495
        0x5F7E, # G+1496
        0x5F89, # G+1497
        0x5F8D, # G+1498
        0x5F8F, # G+1499
        0x5F96, # G+1500
        0x5F9C, # G+1501
        0x5F9D, # G+1502
        0x5FA2, # G+1503
        0x5FA7, # G+1504
        0x5FAB, # G+1505
        0x5FA4, # G+1506
        0x5FAC, # G+1507
        0x5FAF, # G+1508
        0x5FB0, # G+1509
        0x5FB1, # G+1510
        0x5FB8, # G+1511
        0x2E96, # G+1512
        0x5FC7, # G+1513
        0x5FC8, # G+1514
        0x5FC9, # G+1515
        0x5FCB, # G+1516
        0x5FD0, # G+1517
        0x5FD1, # G+1518
        0x5FD2, # G+1519
        0x5FD3, # G+1520
        0x5FD4, # G+1521
        0x5FDE, # G+1522
        0x5FE1, # G+1523
        0x5FE2, # G+1524
        0x5FE8, # G+1525
        0x5FE9, # G+1526
        0x5FEA, # G+1527
        0x5FEC, # G+1528
        0x5FED, # G+1529
        0x5FEE, # G+1530
        0x5FEF, # G+1531
        0x5FF2, # G+1532
        0x5FF3, # G+1533
        0x5FF6, # G+1534
        0x5FFA, # G+1535
        0x5FFC, # G+1536
        0x6007, # G+1537
        0x600A, # G+1538
        0x600D, # G+1539
        0x6013, # G+1540
        0x6014, # G+1541
        0x6017, # G+1542
        0x6018, # G+1543
        0x601A, # G+1544
        0x601F, # G+1545
        0x6024, # G+1546
        0x602D, # G+1547
        0x6033, # G+1548
        0x6035, # G+1549
        0x6040, # G+1550
        0x6047, # G+1551
        0x6048, # G+1552
        0x6049, # G+1553
        0x604C, # G+1554
        0x6051, # G+1555
        0x6054, # G+1556
        0x6056, # G+1557
        0x6057, # G+1558
        0x605D, # G+1559
        0x6061, # G+1560
        0x6067, # G+1561
        0x6071, # G+1562
        0x607E, # G+1563
        0x607F, # G+1564
        0x6082, # G+1565
        0x6086, # G+1566
        0x6088, # G+1567
        0x608A, # G+1568
        0x608E, # G+1569
        0x6091, # G+1570
        0x6093, # G+1571
        0x6095, # G+1572
        0x6098, # G+1573
        0x609D, # G+1574
        0x609E, # G+1575
        0x60A2, # G+1576
        0x60A4, # G+1577
        0x60A5, # G+1578
        0x60A8, # G+1579
        0x60B0, # G+1580
        0x60B1, # G+1581
        0x60B7, # G+1582
        0x60BB, # G+1583
        0x60BE, # G+1584
        0x60C2, # G+1585
        0x60C4, # G+1586
        0x60C8, # G+1587
        0x60C9, # G+1588
        0x60CA, # G+1589
        0x60CB, # G+1590
        0x60CE, # G+1591
        0x60CF, # G+1592
        0x60D4, # G+1593
        0x60D5, # G+1594
        0x60D9, # G+1595
        0x60DB, # G+1596
        0x60DD, # G+1597
        0x60DE, # G+1598
        0x60E2, # G+1599
        0x60E5, # G+1600
        0x60F2, # G+1601
        0x60F5, # G+1602
        0x60F8, # G+1603
        0x60FC, # G+1604
        0x60FD, # G+1605
        0x6102, # G+1606
        0x6107, # G+1607
        0x610A, # G+1608
        0x610C, # G+1609
        0x6110, # G+1610
        0x6111, # G+1611
        0x6112, # G+1612
        0x6113, # G+1613
        0x6114, # G+1614
        0x6116, # G+1615
        0x6117, # G+1616
        0x6119, # G+1617
        0x611C, # G+1618
        0x611E, # G+1619
        0x6122, # G+1620
        0x612A, # G+1621
        0x612B, # G+1622
        0x6130, # G+1623
        0x6131, # G+1624
        0x6135, # G+1625
        0x6136, # G+1626
        0x6137, # G+1627
        0x6139, # G+1628
        0x6141, # G+1629
        0x6145, # G+1630
        0x6146, # G+1631
        0x6149, # G+1632
        0x615E, # G+1633
        0x6160, # G+1634
        0x616C, # G+1635
        0x6172, # G+1636
        0x6178, # G+1637
        0x617B, # G+1638
        0x617C, # G+1639
        0x617F, # G+1640
        0x6180, # G+1641
        0x6181, # G+1642
        0x6183, # G+1643
        0x6184, # G+1644
        0x618B, # G+1645
        0x618D, # G+1646
        0x6192, # G+1647
        0x6193, # G+1648
        0x6197, # G+1649
        0x6198, # G+1650
        0x619C, # G+1651
        0x619D, # G+1652
        0x619F, # G+1653
        0x61A0, # G+1654
        0x61A5, # G+1655
        0x61A8, # G+1656
        0x61AA, # G+1657
        0x61AD, # G+1658
        0x61B8, # G+1659
        0x61B9, # G+1660
        0x61BC, # G+1661
        0x61C0, # G+1662
        0x61C1, # G+1663
        0x61C2, # G+1664
        0x61CE, # G+1665
        0x61CF, # G+1666
        0x61D5, # G+1667
        0x61DC, # G+1668
        0x61DD, # G+1669
        0x61DE, # G+1670
        0x61DF, # G+1671
        0x61E1, # G+1672
        0x61E2, # G+1673
        0x61E7, # G+1674
        0x61E9, # G+1675
        0x61E5, # G+1676
        0x61EC, # G+1677
        0x61ED, # G+1678
        0x61EF, # G+1679
        0x6201, # G+1680
        0x6203, # G+1681
        0x6204, # G+1682
        0x6207, # G+1683
        0x6213, # G+1684
        0x6215, # G+1685
        0x621C, # G+1686
        0x6220, # G+1687
        0x6222, # G+1688
        0x6223, # G+1689
        0x6227, # G+1690
        0x6229, # G+1691
        0x622B, # G+1692
        0x6239, # G+1693
        0x623D, # G+1694
        0x6242, # G+1695
        0x6243, # G+1696
        0x6244, # G+1697
        0x6246, # G+1698
        0x2E98, # G+1699
        0x6250, # G+1700
        0x6251, # G+1701
        0x6252, # G+1702
        0x6254, # G+1703
        0x6256, # G+1704
        0x625A, # G+1705
        0x625C, # G+1706
        0x6264, # G+1707
        0x626D, # G+1708
        0x626F, # G+1709
        0x6273, # G+1710
        0x627A, # G+1711
        0x627D, # G+1712
        0x628D, # G+1713
        0x628E, # G+1714
        0x628F, # G+1715
        0x6290, # G+1716
        0x62A6, # G+1717
        0x62A8, # G+1718
        0x62B3, # G+1719
        0x62B6, # G+1720
        0x62B7, # G+1721
        0x62BA, # G+1722
        0x62BE, # G+1723
        0x62BF, # G+1724
        0x62C4, # G+1725
        0x62CE, # G+1726
        0x62D5, # G+1727
        0x62D6, # G+1728
        0x62DA, # G+1729
        0x62EA, # G+1730
        0x62F2, # G+1731
        0x62F4, # G+1732
        0x62FC, # G+1733
        0x62FD, # G+1734
        0x6303, # G+1735
        0x6304, # G+1736
        0x630A, # G+1737
        0x630B, # G+1738
        0x630D, # G+1739
        0x6310, # G+1740
        0x6313, # G+1741
        0x6316, # G+1742
        0x6318, # G+1743
        0x6329, # G+1744
        0x632A, # G+1745
        0x632D, # G+1746
        0x6335, # G+1747
        0x6336, # G+1748
        0x6339, # G+1749
        0x633C, # G+1750
        0x6341, # G+1751
        0x6342, # G+1752
        0x6343, # G+1753
        0x6344, # G+1754
        0x6346, # G+1755
        0x634A, # G+1756
        0x634B, # G+1757
        0x634E, # G+1758
        0x6352, # G+1759
        0x6353, # G+1760
        0x6354, # G+1761
        0x6358, # G+1762
        0x635B, # G+1763
        0x6365, # G+1764
        0x6366, # G+1765
        0x636C, # G+1766
        0x636D, # G+1767
        0x6371, # G+1768
        0x6374, # G+1769
        0x6375, # G+1770
        0x6378, # G+1771
        0x637C, # G+1772
        0x637D, # G+1773
        0x637F, # G+1774
        0x6382, # G+1775
        0x6384, # G+1776
        0x6387, # G+1777
        0x638A, # G+1778
        0x6390, # G+1779
        0x6394, # G+1780
        0x6395, # G+1781
        0x6399, # G+1782
        0x639A, # G+1783
        0x639E, # G+1784
        0x63A4, # G+1785
        0x63A6, # G+1786
        0x63AD, # G+1787
        0x63AE, # G+1788
        0x63AF, # G+1789
        0x63BD, # G+1790
        0x63C1, # G+1791
        0x63C5, # G+1792
        0x63C8, # G+1793
        0x63CE, # G+1794
        0x63D1, # G+1795
        0x63D3, # G+1796
        0x63D4, # G+1797
        0x63D5, # G+1798
        0x63DC, # G+1799
        0x63E0, # G+1800
        0x63E5, # G+1801
        0x63EA, # G+1802
        0x63EC, # G+1803
        0x63F2, # G+1804
        0x63F3, # G+1805
        0x63F5, # G+1806
        0x63F8, # G+1807
        0x63F9, # G+1808
        0x6409, # G+1809
        0x640A, # G+1810
        0x6410, # G+1811
        0x6412, # G+1812
        0x6414, # G+1813
        0x6418, # G+1814
        0x641E, # G+1815
        0x6420, # G+1816
        0x6422, # G+1817
        0x6424, # G+1818
        0x6425, # G+1819
        0x6429, # G+1820
        0x642A, # G+1821
        0x642F, # G+1822
        0x6430, # G+1823
        0x6435, # G+1824
        0x643D, # G+1825
        0x643F, # G+1826
        0x644B, # G+1827
        0x644F, # G+1828
        0x6451, # G+1829
        0x6452, # G+1830
        0x6453, # G+1831
        0x6454, # G+1832
        0x645A, # G+1833
        0x645B, # G+1834
        0x645C, # G+1835
        0x645D, # G+1836
        0x645F, # G+1837
        0x6460, # G+1838
        0x6461, # G+1839
        0x6463, # G+1840
        0x646D, # G+1841
        0x6473, # G+1842
        0x6474, # G+1843
        0x647B, # G+1844
        0x647D, # G+1845
        0x6485, # G+1846
        0x6487, # G+1847
        0x648F, # G+1848
        0x6490, # G+1849
        0x6491, # G+1850
        0x6498, # G+1851
        0x6499, # G+1852
        0x649B, # G+1853
        0x649D, # G+1854
        0x649F, # G+1855
        0x64A1, # G+1856
        0x64A3, # G+1857
        0x64A6, # G+1858
        0x64A8, # G+1859
        0x64AC, # G+1860
        0x64B3, # G+1861
        0x64BD, # G+1862
        0x64BE, # G+1863
        0x64BF, # G+1864
        0x64C4, # G+1865
        0x64C9, # G+1866
        0x64CA, # G+1867
        0x64CB, # G+1868
        0x64CC, # G+1869
        0x64CE, # G+1870
        0x64D0, # G+1871
        0x64D1, # G+1872
        0x64D5, # G+1873
        0x64D7, # G+1874
        0x64E4, # G+1875
        0x64E5, # G+1876
        0x64E9, # G+1877
        0x64EA, # G+1878
        0x64ED, # G+1879
        0x64F0, # G+1880
        0x64F5, # G+1881
        0x64F7, # G+1882
        0x64FB, # G+1883
        0x64FF, # G+1884
        0x6501, # G+1885
        0x6504, # G+1886
        0x6508, # G+1887
        0x6509, # G+1888
        0x650A, # G+1889
        0x650F, # G+1890
        0x6513, # G+1891
        0x6514, # G+1892
        0x6516, # G+1893
        0x6519, # G+1894
        0x651B, # G+1895
        0x651E, # G+1896
        0x651F, # G+1897
        0x6522, # G+1898
        0x6526, # G+1899
        0x6529, # G+1900
        0x652E, # G+1901
        0x6531, # G+1902
        0x653A, # G+1903
        0x653C, # G+1904
        0x653D, # G+1905
        0x6543, # G+1906
        0x6547, # G+1907
        0x6549, # G+1908
        0x6550, # G+1909
        0x6552, # G+1910
        0x6554, # G+1911
        0x655F, # G+1912
        0x6560, # G+1913
        0x6567, # G+1914
        0x656B, # G+1915
        0x657A, # G+1916
        0x657D, # G+1917
        0x6581, # G+1918
        0x6585, # G+1919
        0x658A, # G+1920
        0x6592, # G+1921
        0x6595, # G+1922
        0x6598, # G+1923
        0x659D, # G+1924
        0x65A0, # G+1925
        0x65A3, # G+1926
        0x65A6, # G+1927
        0x65AE, # G+1928
        0x65B2, # G+1929
        0x65B3, # G+1930
        0x65B4, # G+1931
        0x65BF, # G+1932
        0x65C2, # G+1933
        0x65C8, # G+1934
        0x65C9, # G+1935
        0x65CE, # G+1936
        0x65D0, # G+1937
        0x65D4, # G+1938
        0x65D6, # G+1939
        0x65D8, # G+1940
        0x65DF, # G+1941
        0x65F0, # G+1942
        0x65F2, # G+1943
        0x65F4, # G+1944
        0x65F5, # G+1945
        0x65F9, # G+1946
        0x65FE, # G+1947
        0x65FF, # G+1948
        0x6600, # G+1949
        0x6604, # G+1950
        0x6608, # G+1951
        0x6609, # G+1952
        0x660D, # G+1953
        0x6611, # G+1954
        0x6612, # G+1955
        0x6615, # G+1956
        0x6616, # G+1957
        0x661D, # G+1958
        0x661E, # G+1959
        0x6621, # G+1960
        0x6622, # G+1961
        0x6623, # G+1962
        0x6624, # G+1963
        0x6626, # G+1964
        0x6629, # G+1965
        0x662A, # G+1966
        0x662B, # G+1967
        0x662C, # G+1968
        0x662E, # G+1969
        0x6630, # G+1970
        0x6631, # G+1971
        0x6633, # G+1972
        0x6639, # G+1973
        0x6637, # G+1974
        0x6640, # G+1975
        0x6645, # G+1976
        0x6646, # G+1977
        0x664A, # G+1978
        0x664C, # G+1979
        0x6651, # G+1980
        0x664E, # G+1981
        0x6657, # G+1982
        0x6658, # G+1983
        0x6659, # G+1984
        0x665B, # G+1985
        0x665C, # G+1986
        0x6660, # G+1987
        0x6661, # G+1988
        0x66FB, # G+1989
        0x666A, # G+1990
        0x666B, # G+1991
        0x666C, # G+1992
        0x667E, # G+1993
        0x6673, # G+1994
        0x6675, # G+1995
        0x667F, # G+1996
        0x6677, # G+1997
        0x6678, # G+1998
        0x6679, # G+1999
        0x667B, # G+2000
        0x6680, # G+2001
        0x667C, # G+2002
        0x668B, # G+2003
        0x668C, # G+2004
        0x668D, # G+2005
        0x6690, # G+2006
        0x6692, # G+2007
        0x6699, # G+2008
        0x669A, # G+2009
        0x669B, # G+2010
        0x669C, # G+2011
        0x669F, # G+2012
        0x66A0, # G+2013
        0x66A4, # G+2014
        0x66AD, # G+2015
        0x66B1, # G+2016
        0x66B2, # G+2017
        0x66B5, # G+2018
        0x66BB, # G+2019
        0x66BF, # G+2020
        0x66C0, # G+2021
        0x66C2, # G+2022
        0x66C3, # G+2023
        0x66C8, # G+2024
        0x66CC, # G+2025
        0x66CE, # G+2026
        0x66CF, # G+2027
        0x66D4, # G+2028
        0x66DB, # G+2029
        0x66DF, # G+2030
        0x66E8, # G+2031
        0x66EB, # G+2032
        0x66EC, # G+2033
        0x66EE, # G+2034
        0x66FA, # G+2035
        0x6705, # G+2036
        0x6707, # G+2037
        0x670E, # G+2038
        0x6713, # G+2039
        0x6719, # G+2040
        0x671C, # G+2041
        0x6720, # G+2042
        0x6722, # G+2043
        0x6733, # G+2044
        0x673E, # G+2045
        0x6745, # G+2046
        0x6747, # G+2047
        0x6748, # G+2048
        0x674C, # G+2049
        0x6754, # G+2050
        0x6755, # G+2051
        0x675D, # G+2052
        0x6766, # G+2053
        0x676C, # G+2054
        0x676E, # G+2055
        0x6774, # G+2056
        0x6776, # G+2057
        0x677B, # G+2058
        0x6781, # G+2059
        0x6784, # G+2060
        0x678E, # G+2061
        0x678F, # G+2062
        0x6791, # G+2063
        0x6793, # G+2064
        0x6796, # G+2065
        0x6798, # G+2066
        0x6799, # G+2067
        0x679B, # G+2068
        0x67B0, # G+2069
        0x67B1, # G+2070
        0x67B2, # G+2071
        0x67B5, # G+2072
        0x67BB, # G+2073
        0x67BC, # G+2074
        0x67BD, # G+2075
        0x67F9, # G+2076
        0x67C0, # G+2077
        0x67C2, # G+2078
        0x67C3, # G+2079
        0x67C5, # G+2080
        0x67C8, # G+2081
        0x67C9, # G+2082
        0x67D2, # G+2083
        0x67D7, # G+2084
        0x67D9, # G+2085
        0x67DC, # G+2086
        0x67E1, # G+2087
        0x67E6, # G+2088
        0x67F0, # G+2089
        0x67F2, # G+2090
        0x67F6, # G+2091
        0x67F7, # G+2092
        0x6852, # G+2093
        0x6814, # G+2094
        0x6819, # G+2095
        0x681D, # G+2096
        0x681F, # G+2097
        0x6828, # G+2098
        0x6827, # G+2099
        0x682C, # G+2100
        0x682D, # G+2101
        0x682F, # G+2102
        0x6830, # G+2103
        0x6831, # G+2104
        0x6833, # G+2105
        0x683B, # G+2106
        0x683F, # G+2107
        0x6844, # G+2108
        0x6845, # G+2109
        0x684A, # G+2110
        0x684C, # G+2111
        0x6855, # G+2112
        0x6857, # G+2113
        0x6858, # G+2114
        0x685B, # G+2115
        0x686B, # G+2116
        0x686E, # G+2117
        0x686F, # G+2118
        0x6870, # G+2119
        0x6871, # G+2120
        0x6872, # G+2121
        0x6875, # G+2122
        0x6879, # G+2123
        0x687A, # G+2124
        0x687B, # G+2125
        0x687C, # G+2126
        0x6882, # G+2127
        0x6884, # G+2128
        0x6886, # G+2129
        0x6888, # G+2130
        0x6896, # G+2131
        0x6898, # G+2132
        0x689A, # G+2133
        0x689C, # G+2134
        0x68A1, # G+2135
        0x68A3, # G+2136
        0x68A5, # G+2137
        0x68A9, # G+2138
        0x68AA, # G+2139
        0x68AE, # G+2140
        0x68B2, # G+2141
        0x68BB, # G+2142
        0x68C5, # G+2143
        0x68C8, # G+2144
        0x68CC, # G+2145
        0x68CF, # G+2146
        0x68D0, # G+2147
        0x68D1, # G+2148
        0x68D3, # G+2149
        0x68D6, # G+2150
        0x68D9, # G+2151
        0x68DC, # G+2152
        0x68DD, # G+2153
        0x68E5, # G+2154
        0x68E8, # G+2155
        0x68EA, # G+2156
        0x68EB, # G+2157
        0x68EC, # G+2158
        0x68ED, # G+2159
        0x68F0, # G+2160
        0x68F1, # G+2161
        0x68F5, # G+2162
        0x68F6, # G+2163
        0x68FB, # G+2164
        0x68FC, # G+2165
        0x68FD, # G+2166
        0x6906, # G+2167
        0x6909, # G+2168
        0x690A, # G+2169
        0x6910, # G+2170
        0x6911, # G+2171
        0x6913, # G+2172
        0x6916, # G+2173
        0x6917, # G+2174
        0x6931, # G+2175
        0x6933, # G+2176
        0x6935, # G+2177
        0x6938, # G+2178
        0x693B, # G+2179
        0x6942, # G+2180
        0x6945, # G+2181
        0x6949, # G+2182
        0x694E, # G+2183
        0x6957, # G+2184
        0x695B, # G+2185
        0x6963, # G+2186
        0x6964, # G+2187
        0x6965, # G+2188
        0x6966, # G+2189
        0x6968, # G+2190
        0x6969, # G+2191
        0x696C, # G+2192
        0x6970, # G+2193
        0x6971, # G+2194
        0x6972, # G+2195
        0x697A, # G+2196
        0x697B, # G+2197
        0x697F, # G+2198
        0x6980, # G+2199
        0x698D, # G+2200
        0x6992, # G+2201
        0x6996, # G+2202
        0x6998, # G+2203
        0x69A1, # G+2204
        0x69A5, # G+2205
        0x69A6, # G+2206
        0x69A8, # G+2207
        0x69AB, # G+2208
        0x69AD, # G+2209
        0x69AF, # G+2210
        0x69B7, # G+2211
        0x69B8, # G+2212
        0x69BA, # G+2213
        0x69BC, # G+2214
        0x69C5, # G+2215
        0x69C8, # G+2216
        0x69D1, # G+2217
        0x69D6, # G+2218
        0x69D7, # G+2219
        0x69E2, # G+2220
        0x69E5, # G+2221
        0x69EE, # G+2222
        0x69EF, # G+2223
        0x69F1, # G+2224
        0x69F3, # G+2225
        0x69F5, # G+2226
        0x69FE, # G+2227
        0x6A00, # G+2228
        0x6A01, # G+2229
        0x6A03, # G+2230
        0x6A0F, # G+2231
        0x6A11, # G+2232
        0x6A15, # G+2233
        0x6A1A, # G+2234
        0x6A1D, # G+2235
        0x6A20, # G+2236
        0x6A24, # G+2237
        0x6A28, # G+2238
        0x6A30, # G+2239
        0x6A32, # G+2240
        0x6A34, # G+2241
        0x6A37, # G+2242
        0x6A3B, # G+2243
        0x6A3E, # G+2244
        0x6A3F, # G+2245
        0x6A45, # G+2246
        0x6A46, # G+2247
        0x6A49, # G+2248
        0x6A4A, # G+2249
        0x6A4E, # G+2250
        0x6A50, # G+2251
        0x6A51, # G+2252
        0x6A52, # G+2253
        0x6A55, # G+2254
        0x6A56, # G+2255
        0x6A5B, # G+2256
        0x6A64, # G+2257
        0x6A67, # G+2258
        0x6A6A, # G+2259
        0x6A71, # G+2260
        0x6A73, # G+2261
        0x6A7E, # G+2262
        0x6A81, # G+2263
        0x6A83, # G+2264
        0x6A86, # G+2265
        0x6A87, # G+2266
        0x6A89, # G+2267
        0x6A8B, # G+2268
        0x6A91, # G+2269
        0x6A9B, # G+2270
        0x6A9D, # G+2271
        0x6A9E, # G+2272
        0x6A9F, # G+2273
        0x6AA5, # G+2274
        0x6AAB, # G+2275
        0x6AAF, # G+2276
        0x6AB0, # G+2277
        0x6AB1, # G+2278
        0x6AB4, # G+2279
        0x6ABD, # G+2280
        0x6ABE, # G+2281
        0x6ABF, # G+2282
        0x6AC6, # G+2283
        0x6AC9, # G+2284
        0x6AC8, # G+2285
        0x6ACC, # G+2286
        0x6AD0, # G+2287
        0x6AD4, # G+2288
        0x6AD5, # G+2289
        0x6AD6, # G+2290
        0x6ADC, # G+2291
        0x6ADD, # G+2292
        0x6AE4, # G+2293
        0x6AE7, # G+2294
        0x6AEC, # G+2295
        0x6AF0, # G+2296
        0x6AF1, # G+2297
        0x6AF2, # G+2298
        0x6AFC, # G+2299
        0x6AFD, # G+2300
        0x6B02, # G+2301
        0x6B03, # G+2302
        0x6B06, # G+2303
        0x6B07, # G+2304
        0x6B09, # G+2305
        0x6B0F, # G+2306
        0x6B10, # G+2307
        0x6B11, # G+2308
        0x6B17, # G+2309
        0x6B1B, # G+2310
        0x6B1E, # G+2311
        0x6B24, # G+2312
        0x6B28, # G+2313
        0x6B2B, # G+2314
        0x6B2C, # G+2315
        0x6B2F, # G+2316
        0x6B35, # G+2317
        0x6B36, # G+2318
        0x6B3B, # G+2319
        0x6B3F, # G+2320
        0x6B46, # G+2321
        0x6B4A, # G+2322
        0x6B4D, # G+2323
        0x6B52, # G+2324
        0x6B56, # G+2325
        0x6B58, # G+2326
        0x6B5D, # G+2327
        0x6B60, # G+2328
        0x6B67, # G+2329
        0x6B6B, # G+2330
        0x6B6E, # G+2331
        0x6B70, # G+2332
        0x6B75, # G+2333
        0x6B7D, # G+2334
        0x6B7E, # G+2335
        0x6B82, # G+2336
        0x6B85, # G+2337
        0x6B97, # G+2338
        0x6B9B, # G+2339
        0x6B9F, # G+2340
        0x6BA0, # G+2341
        0x6BA2, # G+2342
        0x6BA3, # G+2343
        0x6BA8, # G+2344
        0x6BA9, # G+2345
        0x6BAC, # G+2346
        0x6BAD, # G+2347
        0x6BAE, # G+2348
        0x6BB0, # G+2349
        0x6BB8, # G+2350
        0x6BB9, # G+2351
        0x6BBD, # G+2352
        0x6BBE, # G+2353
        0x6BC3, # G+2354
        0x6BC4, # G+2355
        0x6BC9, # G+2356
        0x6BCC, # G+2357
        0x6BD6, # G+2358
        0x6BDA, # G+2359
        0x6BE1, # G+2360
        0x6BE3, # G+2361
        0x6BE6, # G+2362
        0x6BE7, # G+2363
        0x6BEE, # G+2364
        0x6BF1, # G+2365
        0x6BF7, # G+2366
        0x6BF9, # G+2367
        0x6BFF, # G+2368
        0x6C02, # G+2369
        0x6C04, # G+2370
        0x6C05, # G+2371
        0x6C09, # G+2372
        0x6C0D, # G+2373
        0x6C0E, # G+2374
        0x6C10, # G+2375
        0x6C12, # G+2376
        0x6C19, # G+2377
        0x6C1F, # G+2378
        0x6C26, # G+2379
        0x6C27, # G+2380
        0x6C28, # G+2381
        0x6C2C, # G+2382
        0x6C2E, # G+2383
        0x6C33, # G+2384
        0x2EA1, # G+2385
        0x6C36, # G+2386
        0x2EA2, # G+2387
        0x6C3B, # G+2388
        0x6C3F, # G+2389
        0x6C4A, # G+2390
        0x6C4B, # G+2391
        0x6C4D, # G+2392
        0x6C4F, # G+2393
        0x6C52, # G+2394
        0x6C54, # G+2395
        0x6C59, # G+2396
        0x6C5B, # G+2397
        0x6C5C, # G+2398
        0x6C6B, # G+2399
        0x6C6D, # G+2400
        0x6C6F, # G+2401
        0x6C74, # G+2402
        0x6C76, # G+2403
        0x6C78, # G+2404
        0x6C79, # G+2405
        0x6C7B, # G+2406
        0x6C85, # G+2407
        0x6C86, # G+2408
        0x6C87, # G+2409
        0x6C89, # G+2410
        0x6C94, # G+2411
        0x6C95, # G+2412
        0x6C97, # G+2413
        0x6C98, # G+2414
        0x6C9C, # G+2415
        0x6C9F, # G+2416
        0x6CB0, # G+2417
        0x6CB2, # G+2418
        0x6CB4, # G+2419
        0x6CC2, # G+2420
        0x6CC6, # G+2421
        0x6CCD, # G+2422
        0x6CCF, # G+2423
        0x6CD0, # G+2424
        0x6CD1, # G+2425
        0x6CD2, # G+2426
        0x6CD4, # G+2427
        0x6CD6, # G+2428
        0x6CDA, # G+2429
        0x6CDC, # G+2430
        0x6CE0, # G+2431
        0x6CE7, # G+2432
        0x6CE9, # G+2433
        0x6CEB, # G+2434
        0x6CEC, # G+2435
        0x6CEE, # G+2436
        0x6CF2, # G+2437
        0x6CF4, # G+2438
        0x6D04, # G+2439
        0x6D07, # G+2440
        0x6D0A, # G+2441
        0x6D0E, # G+2442
        0x6D0F, # G+2443
        0x6D11, # G+2444
        0x6D13, # G+2445
        0x6D1A, # G+2446
        0x6D26, # G+2447
        0x6D27, # G+2448
        0x6D28, # G+2449
        0x6C67, # G+2450
        0x6D2E, # G+2451
        0x6D2F, # G+2452
        0x6D31, # G+2453
        0x6D39, # G+2454
        0x6D3C, # G+2455
        0x6D3F, # G+2456
        0x6D57, # G+2457
        0x6D5E, # G+2458
        0x6D5F, # G+2459
        0x6D61, # G+2460
        0x6D65, # G+2461
        0x6D67, # G+2462
        0x6D6F, # G+2463
        0x6D70, # G+2464
        0x6D7C, # G+2465
        0x6D82, # G+2466
        0x6D87, # G+2467
        0x6D91, # G+2468
        0x6D92, # G+2469
        0x6D94, # G+2470
        0x6D96, # G+2471
        0x6D97, # G+2472
        0x6D98, # G+2473
        0x6DAA, # G+2474
        0x6DAC, # G+2475
        0x6DB4, # G+2476
        0x6DB7, # G+2477
        0x6DB9, # G+2478
        0x6DBD, # G+2479
        0x6DBF, # G+2480
        0x6DC4, # G+2481
        0x6DC8, # G+2482
        0x6DCA, # G+2483
        0x6DCE, # G+2484
        0x6DCF, # G+2485
        0x6DD6, # G+2486
        0x6DDB, # G+2487
        0x6DDD, # G+2488
        0x6DDF, # G+2489
        0x6DE0, # G+2490
        0x6DE2, # G+2491
        0x6DE5, # G+2492
        0x6DE9, # G+2493
        0x6DEF, # G+2494
        0x6DF0, # G+2495
        0x6DF4, # G+2496
        0x6DF6, # G+2497
        0x6DFC, # G+2498
        0x6E00, # G+2499
        0x6E04, # G+2500
        0x6E1E, # G+2501
        0x6E22, # G+2502
        0x6E27, # G+2503
        0x6E32, # G+2504
        0x6E36, # G+2505
        0x6E39, # G+2506
        0x6E3B, # G+2507
        0x6E3C, # G+2508
        0x6E44, # G+2509
        0x6E45, # G+2510
        0x6E48, # G+2511
        0x6E49, # G+2512
        0x6E4B, # G+2513
        0x6E4F, # G+2514
        0x6E51, # G+2515
        0x6E52, # G+2516
        0x6E53, # G+2517
        0x6E54, # G+2518
        0x6E57, # G+2519
        0x6E5C, # G+2520
        0x6E5D, # G+2521
        0x6E5E, # G+2522
        0x6E62, # G+2523
        0x6E63, # G+2524
        0x6E68, # G+2525
        0x6E73, # G+2526
        0x6E7B, # G+2527
        0x6E7D, # G+2528
        0x6E8D, # G+2529
        0x6E93, # G+2530
        0x6E99, # G+2531
        0x6EA0, # G+2532
        0x6EA7, # G+2533
        0x6EAD, # G+2534
        0x6EAE, # G+2535
        0x6EB1, # G+2536
        0x6EB3, # G+2537
        0x6EBB, # G+2538
        0x6EBF, # G+2539
        0x6EC0, # G+2540
        0x6EC1, # G+2541
        0x6EC3, # G+2542
        0x6EC7, # G+2543
        0x6EC8, # G+2544
        0x6ECA, # G+2545
        0x6ECD, # G+2546
        0x6ECE, # G+2547
        0x6ECF, # G+2548
        0x6EEB, # G+2549
        0x6EED, # G+2550
        0x6EEE, # G+2551
        0x6EF9, # G+2552
        0x6EFB, # G+2553
        0x6EFD, # G+2554
        0x6F04, # G+2555
        0x6F08, # G+2556
        0x6F0A, # G+2557
        0x6F0C, # G+2558
        0x6F0D, # G+2559
        0x6F16, # G+2560
        0x6F18, # G+2561
        0x6F1A, # G+2562
        0x6F1B, # G+2563
        0x6F26, # G+2564
        0x6F29, # G+2565
        0x6F2A, # G+2566
        0x6F2F, # G+2567
        0x6F30, # G+2568
        0x6F33, # G+2569
        0x6F36, # G+2570
        0x6F3B, # G+2571
        0x6F3C, # G+2572
        0x6F2D, # G+2573
        0x6F4F, # G+2574
        0x6F51, # G+2575
        0x6F52, # G+2576
        0x6F53, # G+2577
        0x6F57, # G+2578
        0x6F59, # G+2579
        0x6F5A, # G+2580
        0x6F5D, # G+2581
        0x6F5E, # G+2582
        0x6F61, # G+2583
        0x6F62, # G+2584
        0x6F68, # G+2585
        0x6F6C, # G+2586
        0x6F7D, # G+2587
        0x6F7E, # G+2588
        0x6F83, # G+2589
        0x6F87, # G+2590
        0x6F88, # G+2591
        0x6F8B, # G+2592
        0x6F8C, # G+2593
        0x6F8D, # G+2594
        0x6F90, # G+2595
        0x6F92, # G+2596
        0x6F93, # G+2597
        0x6F94, # G+2598
        0x6F96, # G+2599
        0x6F9A, # G+2600
        0x6F9F, # G+2601
        0x6FA0, # G+2602
        0x6FA5, # G+2603
        0x6FA6, # G+2604
        0x6FA7, # G+2605
        0x6FA8, # G+2606
        0x6FAE, # G+2607
        0x6FAF, # G+2608
        0x6FB0, # G+2609
        0x6FB5, # G+2610
        0x6FB6, # G+2611
        0x6FBC, # G+2612
        0x6FC5, # G+2613
        0x6FC7, # G+2614
        0x6FC8, # G+2615
        0x6FCA, # G+2616
        0x6FDA, # G+2617
        0x6FDE, # G+2618
        0x6FE8, # G+2619
        0x6FE9, # G+2620
        0x6FF0, # G+2621
        0x6FF5, # G+2622
        0x6FF9, # G+2623
        0x6FFC, # G+2624
        0x6FFD, # G+2625
        0x7000, # G+2626
        0x7005, # G+2627
        0x7006, # G+2628
        0x7007, # G+2629
        0x700D, # G+2630
        0x7017, # G+2631
        0x7020, # G+2632
        0x7023, # G+2633
        0x702F, # G+2634
        0x7034, # G+2635
        0x7037, # G+2636
        0x7039, # G+2637
        0x703C, # G+2638
        0x7043, # G+2639
        0x7044, # G+2640
        0x7048, # G+2641
        0x7049, # G+2642
        0x704A, # G+2643
        0x704B, # G+2644
        0x7054, # G+2645
        0x7055, # G+2646
        0x705D, # G+2647
        0x705E, # G+2648
        0x704E, # G+2649
        0x7064, # G+2650
        0x7065, # G+2651
        0x2EA3, # G+2652
        0x706E, # G+2653
        0x7075, # G+2654
        0x7076, # G+2655
        0x707E, # G+2656
        0x7081, # G+2657
        0x7085, # G+2658
        0x7086, # G+2659
        0x7094, # G+2660
        0x7095, # G+2661
        0x7096, # G+2662
        0x7097, # G+2663
        0x7098, # G+2664
        0x709B, # G+2665
        0x70A4, # G+2666
        0x70AB, # G+2667
        0x70B0, # G+2668
        0x70B1, # G+2669
        0x70B4, # G+2670
        0x70B7, # G+2671
        0x70CA, # G+2672
        0x70D1, # G+2673
        0x70D3, # G+2674
        0x70D4, # G+2675
        0x70D5, # G+2676
        0x70D6, # G+2677
        0x70D8, # G+2678
        0x70DC, # G+2679
        0x70E4, # G+2680
        0x70FA, # G+2681
        0x7103, # G+2682
        0x7104, # G+2683
        0x7105, # G+2684
        0x7106, # G+2685
        0x7107, # G+2686
        0x710B, # G+2687
        0x710C, # G+2688
        0x710F, # G+2689
        0x711E, # G+2690
        0x7120, # G+2691
        0x712B, # G+2692
        0x712D, # G+2693
        0x712F, # G+2694
        0x7130, # G+2695
        0x7131, # G+2696
        0x7138, # G+2697
        0x7141, # G+2698
        0x7145, # G+2699
        0x7146, # G+2700
        0x7147, # G+2701
        0x714A, # G+2702
        0x714B, # G+2703
        0x7150, # G+2704
        0x7152, # G+2705
        0x7157, # G+2706
        0x715A, # G+2707
        0x715C, # G+2708
        0x715E, # G+2709
        0x7160, # G+2710
        0x7168, # G+2711
        0x7179, # G+2712
        0x7180, # G+2713
        0x7185, # G+2714
        0x7187, # G+2715
        0x718C, # G+2716
        0x7192, # G+2717
        0x719A, # G+2718
        0x719B, # G+2719
        0x71A0, # G+2720
        0x71A2, # G+2721
        0x71AF, # G+2722
        0x71B0, # G+2723
        0x71B2, # G+2724
        0x71B3, # G+2725
        0x71BA, # G+2726
        0x71BF, # G+2727
        0x71C0, # G+2728
        0x71C1, # G+2729
        0x71C4, # G+2730
        0x71CB, # G+2731
        0x71CC, # G+2732
        0x71D3, # G+2733
        0x71D6, # G+2734
        0x71D9, # G+2735
        0x71DA, # G+2736
        0x71DC, # G+2737
        0x71F8, # G+2738
        0x71FE, # G+2739
        0x7200, # G+2740
        0x7207, # G+2741
        0x7208, # G+2742
        0x7209, # G+2743
        0x7213, # G+2744
        0x7217, # G+2745
        0x721A, # G+2746
        0x721D, # G+2747
        0x721F, # G+2748
        0x7224, # G+2749
        0x2EA5, # G+2750
        0x722F, # G+2751
        0x7234, # G+2752
        0x7238, # G+2753
        0x7239, # G+2754
        0x7241, # G+2755
        0x7242, # G+2756
        0x7243, # G+2757
        0x7245, # G+2758
        0x724E, # G+2759
        0x724F, # G+2760
        0x7250, # G+2761
        0x7253, # G+2762
        0x7255, # G+2763
        0x7256, # G+2764
        0x725A, # G+2765
        0x725C, # G+2766
        0x725E, # G+2767
        0x7260, # G+2768
        0x7263, # G+2769
        0x7268, # G+2770
        0x726B, # G+2771
        0x726E, # G+2772
        0x726F, # G+2773
        0x7271, # G+2774
        0x7277, # G+2775
        0x7278, # G+2776
        0x727B, # G+2777
        0x727C, # G+2778
        0x727F, # G+2779
        0x7284, # G+2780
        0x7289, # G+2781
        0x728D, # G+2782
        0x728E, # G+2783
        0x7293, # G+2784
        0x729B, # G+2785
        0x72A8, # G+2786
        0x2EA8, # G+2787
        0x72AE, # G+2788
        0x72B1, # G+2789
        0x72B4, # G+2790
        0x72BE, # G+2791
        0x72C1, # G+2792
        0x72C7, # G+2793
        0x72C9, # G+2794
        0x72CC, # G+2795
        0x72D5, # G+2796
        0x72D6, # G+2797
        0x72D8, # G+2798
        0x72DF, # G+2799
        0x72E5, # G+2800
        0x72F3, # G+2801
        0x72F4, # G+2802
        0x72FA, # G+2803
        0x72FB, # G+2804
        0x72FE, # G+2805
        0x7302, # G+2806
        0x7304, # G+2807
        0x7305, # G+2808
        0x7307, # G+2809
        0x730B, # G+2810
        0x730D, # G+2811
        0x7312, # G+2812
        0x7313, # G+2813
        0x7318, # G+2814
        0x7319, # G+2815
        0x731E, # G+2816
        0x7322, # G+2817
        0x7324, # G+2818
        0x7327, # G+2819
        0x7328, # G+2820
        0x732C, # G+2821
        0x7331, # G+2822
        0x7332, # G+2823
        0x7335, # G+2824
        0x733A, # G+2825
        0x733B, # G+2826
        0x733D, # G+2827
        0x7343, # G+2828
        0x734D, # G+2829
        0x7350, # G+2830
        0x7352, # G+2831
        0x7356, # G+2832
        0x7358, # G+2833
        0x735D, # G+2834
        0x735E, # G+2835
        0x735F, # G+2836
        0x7360, # G+2837
        0x7366, # G+2838
        0x7367, # G+2839
        0x7369, # G+2840
        0x736B, # G+2841
        0x736C, # G+2842
        0x736E, # G+2843
        0x736F, # G+2844
        0x7371, # G+2845
        0x7377, # G+2846
        0x7379, # G+2847
        0x737C, # G+2848
        0x7380, # G+2849
        0x7381, # G+2850
        0x7383, # G+2851
        0x7385, # G+2852
        0x7386, # G+2853
        0x738E, # G+2854
        0x7390, # G+2855
        0x7393, # G+2856
        0x7395, # G+2857
        0x7397, # G+2858
        0x7398, # G+2859
        0x739C, # G+2860
        0x739E, # G+2861
        0x739F, # G+2862
        0x73A0, # G+2863
        0x73A2, # G+2864
        0x73A5, # G+2865
        0x73A6, # G+2866
        0x73AA, # G+2867
        0x73AB, # G+2868
        0x73AD, # G+2869
        0x73B5, # G+2870
        0x73B7, # G+2871
        0x73B9, # G+2872
        0x73BC, # G+2873
        0x73BD, # G+2874
        0x73BF, # G+2875
        0x73C5, # G+2876
        0x73C6, # G+2877
        0x73C9, # G+2878
        0x73CB, # G+2879
        0x73CC, # G+2880
        0x73CF, # G+2881
        0x73D2, # G+2882
        0x73D3, # G+2883
        0x73D6, # G+2884
        0x73D9, # G+2885
        0x73DD, # G+2886
        0x73E1, # G+2887
        0x73E3, # G+2888
        0x73E6, # G+2889
        0x73E7, # G+2890
        0x73E9, # G+2891
        0x73F4, # G+2892
        0x73F5, # G+2893
        0x73F7, # G+2894
        0x73F9, # G+2895
        0x73FA, # G+2896
        0x73FB, # G+2897
        0x73FD, # G+2898
        0x73FF, # G+2899
        0x7400, # G+2900
        0x7401, # G+2901
        0x7404, # G+2902
        0x7407, # G+2903
        0x740A, # G+2904
        0x7411, # G+2905
        0x741A, # G+2906
        0x741B, # G+2907
        0x7424, # G+2908
        0x7426, # G+2909
        0x7428, # G+2910
        0x7429, # G+2911
        0x742A, # G+2912
        0x742B, # G+2913
        0x742C, # G+2914
        0x742D, # G+2915
        0x742E, # G+2916
        0x742F, # G+2917
        0x7430, # G+2918
        0x7431, # G+2919
        0x7439, # G+2920
        0x7440, # G+2921
        0x7443, # G+2922
        0x7444, # G+2923
        0x7446, # G+2924
        0x7447, # G+2925
        0x744B, # G+2926
        0x744D, # G+2927
        0x7451, # G+2928
        0x7452, # G+2929
        0x7457, # G+2930
        0x745D, # G+2931
        0x7462, # G+2932
        0x7466, # G+2933
        0x7467, # G+2934
        0x7468, # G+2935
        0x746B, # G+2936
        0x746D, # G+2937
        0x746E, # G+2938
        0x7471, # G+2939
        0x7472, # G+2940
        0x7480, # G+2941
        0x7481, # G+2942
        0x7485, # G+2943
        0x7486, # G+2944
        0x7487, # G+2945
        0x7489, # G+2946
        0x748F, # G+2947
        0x7490, # G+2948
        0x7491, # G+2949
        0x7492, # G+2950
        0x7498, # G+2951
        0x7499, # G+2952
        0x749A, # G+2953
        0x749C, # G+2954
        0x749F, # G+2955
        0x74A0, # G+2956
        0x74A1, # G+2957
        0x74A3, # G+2958
        0x74A6, # G+2959
        0x74A8, # G+2960
        0x74A9, # G+2961
        0x74AA, # G+2962
        0x74AB, # G+2963
        0x74AE, # G+2964
        0x74AF, # G+2965
        0x74B1, # G+2966
        0x74B2, # G+2967
        0x74B5, # G+2968
        0x74B9, # G+2969
        0x74BB, # G+2970
        0x74BF, # G+2971
        0x74C8, # G+2972
        0x74C9, # G+2973
        0x74CC, # G+2974
        0x74D0, # G+2975
        0x74D3, # G+2976
        0x74D8, # G+2977
        0x74DA, # G+2978
        0x74DB, # G+2979
        0x74DE, # G+2980
        0x74DF, # G+2981
        0x74E4, # G+2982
        0x74E8, # G+2983
        0x74EA, # G+2984
        0x74EB, # G+2985
        0x74EF, # G+2986
        0x74F4, # G+2987
        0x74FA, # G+2988
        0x74FB, # G+2989
        0x74FC, # G+2990
        0x74FF, # G+2991
        0x7506, # G+2992
        0x7512, # G+2993
        0x7516, # G+2994
        0x7517, # G+2995
        0x7520, # G+2996
        0x7521, # G+2997
        0x7524, # G+2998
        0x7527, # G+2999
        0x7529, # G+3000
        0x752A, # G+3001
        0x752F, # G+3002
        0x7536, # G+3003
        0x7539, # G+3004
        0x753D, # G+3005
        0x753E, # G+3006
        0x753F, # G+3007
        0x7540, # G+3008
        0x7543, # G+3009
        0x7547, # G+3010
        0x7548, # G+3011
        0x754E, # G+3012
        0x7550, # G+3013
        0x7552, # G+3014
        0x7557, # G+3015
        0x755E, # G+3016
        0x755F, # G+3017
        0x7561, # G+3018
        0x756F, # G+3019
        0x7571, # G+3020
        0x7579, # G+3021
        0x757A, # G+3022
        0x757B, # G+3023
        0x757C, # G+3024
        0x757D, # G+3025
        0x757E, # G+3026
        0x7581, # G+3027
        0x7585, # G+3028
        0x7590, # G+3029
        0x2F67, # G+3030
        0x7593, # G+3031
        0x7595, # G+3032
        0x7599, # G+3033
        0x759C, # G+3034
        0x75A2, # G+3035
        0x75A4, # G+3036
        0x75B4, # G+3037
        0x75BA, # G+3038
        0x75BF, # G+3039
        0x75C0, # G+3040
        0x75C1, # G+3041
        0x75C4, # G+3042
        0x75C6, # G+3043
        0x75CC, # G+3044
        0x75CE, # G+3045
        0x75CF, # G+3046
        0x75D7, # G+3047
        0x75DC, # G+3048
        0x75DF, # G+3049
        0x75E0, # G+3050
        0x75E1, # G+3051
        0x75E4, # G+3052
        0x75E7, # G+3053
        0x75EC, # G+3054
        0x75EE, # G+3055
        0x75EF, # G+3056
        0x75F1, # G+3057
        0x75F9, # G+3058
        0x7600, # G+3059
        0x7602, # G+3060
        0x7603, # G+3061
        0x7604, # G+3062
        0x7607, # G+3063
        0x7608, # G+3064
        0x760A, # G+3065
        0x760C, # G+3066
        0x760F, # G+3067
        0x7612, # G+3068
        0x7613, # G+3069
        0x7615, # G+3070
        0x7616, # G+3071
        0x7619, # G+3072
        0x761B, # G+3073
        0x761C, # G+3074
        0x761D, # G+3075
        0x761E, # G+3076
        0x7623, # G+3077
        0x7625, # G+3078
        0x7626, # G+3079
        0x7629, # G+3080
        0x762D, # G+3081
        0x7632, # G+3082
        0x7633, # G+3083
        0x7635, # G+3084
        0x7638, # G+3085
        0x7639, # G+3086
        0x763A, # G+3087
        0x763C, # G+3088
        0x764A, # G+3089
        0x7640, # G+3090
        0x7641, # G+3091
        0x7643, # G+3092
        0x7644, # G+3093
        0x7645, # G+3094
        0x7649, # G+3095
        0x764B, # G+3096
        0x7655, # G+3097
        0x7659, # G+3098
        0x765F, # G+3099
        0x7664, # G+3100
        0x7665, # G+3101
        0x766D, # G+3102
        0x766E, # G+3103
        0x766F, # G+3104
        0x7671, # G+3105
        0x7674, # G+3106
        0x7681, # G+3107
        0x7685, # G+3108
        0x768C, # G+3109
        0x768D, # G+3110
        0x7695, # G+3111
        0x769B, # G+3112
        0x769C, # G+3113
        0x769D, # G+3114
        0x769F, # G+3115
        0x76A0, # G+3116
        0x76A2, # G+3117
        0x76A3, # G+3118
        0x76A4, # G+3119
        0x76A5, # G+3120
        0x76A6, # G+3121
        0x76A7, # G+3122
        0x76A8, # G+3123
        0x76AA, # G+3124
        0x76AD, # G+3125
        0x76BD, # G+3126
        0x76C1, # G+3127
        0x76C5, # G+3128
        0x76C9, # G+3129
        0x76CB, # G+3130
        0x76CC, # G+3131
        0x76CE, # G+3132
        0x76D4, # G+3133
        0x76D9, # G+3134
        0x76E0, # G+3135
        0x76E6, # G+3136
        0x76E8, # G+3137
        0x76EC, # G+3138
        0x76F0, # G+3139
        0x76F1, # G+3140
        0x76F6, # G+3141
        0x76F9, # G+3142
        0x76FC, # G+3143
        0x7700, # G+3144
        0x7706, # G+3145
        0x770A, # G+3146
        0x770E, # G+3147
        0x7712, # G+3148
        0x7714, # G+3149
        0x7715, # G+3150
        0x7717, # G+3151
        0x7719, # G+3152
        0x771A, # G+3153
        0x771C, # G+3154
        0x7722, # G+3155
        0x7728, # G+3156
        0x772D, # G+3157
        0x772E, # G+3158
        0x772F, # G+3159
        0x7734, # G+3160
        0x7735, # G+3161
        0x7736, # G+3162
        0x7739, # G+3163
        0x773D, # G+3164
        0x773E, # G+3165
        0x7742, # G+3166
        0x7745, # G+3167
        0x7746, # G+3168
        0x774A, # G+3169
        0x774D, # G+3170
        0x774E, # G+3171
        0x774F, # G+3172
        0x7752, # G+3173
        0x7756, # G+3174
        0x7757, # G+3175
        0x775C, # G+3176
        0x775E, # G+3177
        0x775F, # G+3178
        0x7760, # G+3179
        0x7762, # G+3180
        0x7764, # G+3181
        0x7767, # G+3182
        0x776A, # G+3183
        0x776C, # G+3184
        0x7770, # G+3185
        0x7772, # G+3186
        0x7773, # G+3187
        0x7774, # G+3188
        0x777A, # G+3189
        0x777D, # G+3190
        0x7780, # G+3191
        0x7784, # G+3192
        0x778C, # G+3193
        0x778D, # G+3194
        0x7794, # G+3195
        0x7795, # G+3196
        0x7796, # G+3197
        0x779A, # G+3198
        0x779F, # G+3199
        0x77A2, # G+3200
        0x77A7, # G+3201
        0x77AA, # G+3202
        0x77AE, # G+3203
        0x77AF, # G+3204
        0x77B1, # G+3205
        0x77B5, # G+3206
        0x77BE, # G+3207
        0x77C3, # G+3208
        0x77C9, # G+3209
        0x77D1, # G+3210
        0x77D2, # G+3211
        0x77D5, # G+3212
        0x77D9, # G+3213
        0x77DE, # G+3214
        0x77DF, # G+3215
        0x77E0, # G+3216
        0x77E4, # G+3217
        0x77E6, # G+3218
        0x77EA, # G+3219
        0x77EC, # G+3220
        0x77F0, # G+3221
        0x77F1, # G+3222
        0x77F4, # G+3223
        0x77F8, # G+3224
        0x77FB, # G+3225
        0x7805, # G+3226
        0x7806, # G+3227
        0x7809, # G+3228
        0x780D, # G+3229
        0x780E, # G+3230
        0x7811, # G+3231
        0x781D, # G+3232
        0x7821, # G+3233
        0x7822, # G+3234
        0x7823, # G+3235
        0x782D, # G+3236
        0x782E, # G+3237
        0x7830, # G+3238
        0x7835, # G+3239
        0x7837, # G+3240
        0x7843, # G+3241
        0x7844, # G+3242
        0x7847, # G+3243
        0x7848, # G+3244
        0x784C, # G+3245
        0x784E, # G+3246
        0x7852, # G+3247
        0x785C, # G+3248
        0x785E, # G+3249
        0x7860, # G+3250
        0x7861, # G+3251
        0x7863, # G+3252
        0x7864, # G+3253
        0x7868, # G+3254
        0x786A, # G+3255
        0x786E, # G+3256
        0x787A, # G+3257
        0x787E, # G+3258
        0x788A, # G+3259
        0x788F, # G+3260
        0x7894, # G+3261
        0x7898, # G+3262
        0x78A1, # G+3263
        0x789D, # G+3264
        0x789E, # G+3265
        0x789F, # G+3266
        0x78A4, # G+3267
        0x78A8, # G+3268
        0x78AC, # G+3269
        0x78AD, # G+3270
        0x78B0, # G+3271
        0x78B1, # G+3272
        0x78B2, # G+3273
        0x78B3, # G+3274
        0x78BB, # G+3275
        0x78BD, # G+3276
        0x78BF, # G+3277
        0x78C7, # G+3278
        0x78C8, # G+3279
        0x78C9, # G+3280
        0x78CC, # G+3281
        0x78CE, # G+3282
        0x78D2, # G+3283
        0x78D3, # G+3284
        0x78D5, # G+3285
        0x78D6, # G+3286
        0x78E4, # G+3287
        0x78DB, # G+3288
        0x78DF, # G+3289
        0x78E0, # G+3290
        0x78E1, # G+3291
        0x78E6, # G+3292
        0x78EA, # G+3293
        0x78F2, # G+3294
        0x78F3, # G+3295
        0x7900, # G+3296
        0x78F6, # G+3297
        0x78F7, # G+3298
        0x78FA, # G+3299
        0x78FB, # G+3300
        0x78FF, # G+3301
        0x7906, # G+3302
        0x790C, # G+3303
        0x7910, # G+3304
        0x791A, # G+3305
        0x791C, # G+3306
        0x791E, # G+3307
        0x791F, # G+3308
        0x7920, # G+3309
        0x7925, # G+3310
        0x7927, # G+3311
        0x7929, # G+3312
        0x792D, # G+3313
        0x7931, # G+3314
        0x7934, # G+3315
        0x7935, # G+3316
        0x2EAD, # G+3317
        0x793D, # G+3318
        0x793F, # G+3319
        0x7944, # G+3320
        0x7945, # G+3321
        0x7946, # G+3322
        0x794A, # G+3323
        0x794B, # G+3324
        0x794F, # G+3325
        0x7951, # G+3326
        0x7954, # G+3327
        0x7958, # G+3328
        0x795B, # G+3329
        0x795C, # G+3330
        0x7967, # G+3331
        0x7969, # G+3332
        0x796B, # G+3333
        0x7972, # G+3334
        0x7979, # G+3335
        0x797B, # G+3336
        0x797C, # G+3337
        0x797E, # G+3338
        0x798B, # G+3339
        0x798C, # G+3340
        0x7991, # G+3341
        0x7993, # G+3342
        0x7994, # G+3343
        0x7995, # G+3344
        0x7996, # G+3345
        0x7998, # G+3346
        0x799B, # G+3347
        0x799C, # G+3348
        0x79A1, # G+3349
        0x79A8, # G+3350
        0x79A9, # G+3351
        0x79AB, # G+3352
        0x79AF, # G+3353
        0x79B1, # G+3354
        0x79B4, # G+3355
        0x2F71, # G+3356
        0x79BB, # G+3357
        0x79C2, # G+3358
        0x79C4, # G+3359
        0x79C7, # G+3360
        0x79C8, # G+3361
        0x79CA, # G+3362
        0x79CF, # G+3363
        0x79D4, # G+3364
        0x79D6, # G+3365
        0x79DA, # G+3366
        0x79DD, # G+3367
        0x79DE, # G+3368
        0x79E0, # G+3369
        0x79E2, # G+3370
        0x79E5, # G+3371
        0x79EA, # G+3372
        0x79EB, # G+3373
        0x79ED, # G+3374
        0x79F1, # G+3375
        0x79F8, # G+3376
        0x79FC, # G+3377
        0x7A02, # G+3378
        0x7A03, # G+3379
        0x7A07, # G+3380
        0x7A09, # G+3381
        0x7A0A, # G+3382
        0x7A0C, # G+3383
        0x7A11, # G+3384
        0x7A15, # G+3385
        0x7A1B, # G+3386
        0x7A1E, # G+3387
        0x7A21, # G+3388
        0x7A27, # G+3389
        0x7A2B, # G+3390
        0x7A2D, # G+3391
        0x7A2F, # G+3392
        0x7A30, # G+3393
        0x7A34, # G+3394
        0x7A35, # G+3395
        0x7A38, # G+3396
        0x7A39, # G+3397
        0x7A3A, # G+3398
        0x7A44, # G+3399
        0x7A45, # G+3400
        0x7A47, # G+3401
        0x7A48, # G+3402
        0x7A4C, # G+3403
        0x7A55, # G+3404
        0x7A56, # G+3405
        0x7A59, # G+3406
        0x7A5C, # G+3407
        0x7A5D, # G+3408
        0x7A5F, # G+3409
        0x7A60, # G+3410
        0x7A65, # G+3411
        0x7A67, # G+3412
        0x7A6A, # G+3413
        0x7A6D, # G+3414
        0x7A75, # G+3415
        0x7A78, # G+3416
        0x7A7E, # G+3417
        0x7A80, # G+3418
        0x7A82, # G+3419
        0x7A85, # G+3420
        0x7A86, # G+3421
        0x7A8A, # G+3422
        0x7A8B, # G+3423
        0x7A90, # G+3424
        0x7A91, # G+3425
        0x7A94, # G+3426
        0x7A9E, # G+3427
        0x7AA0, # G+3428
        0x7AA3, # G+3429
        0x7AAC, # G+3430
        0x7AB3, # G+3431
        0x7AB5, # G+3432
        0x7AB9, # G+3433
        0x7ABB, # G+3434
        0x7ABC, # G+3435
        0x7AC6, # G+3436
        0x7AC9, # G+3437
        0x7ACC, # G+3438
        0x7ACE, # G+3439
        0x7AD1, # G+3440
        0x7ADB, # G+3441
        0x7AE8, # G+3442
        0x7AE9, # G+3443
        0x7AEB, # G+3444
        0x7AEC, # G+3445
        0x7AF1, # G+3446
        0x7AF4, # G+3447
        0x7AFB, # G+3448
        0x7AFD, # G+3449
        0x7AFE, # G+3450
        0x7B07, # G+3451
        0x7B14, # G+3452
        0x7B1F, # G+3453
        0x7B23, # G+3454
        0x7B27, # G+3455
        0x7B29, # G+3456
        0x7B2A, # G+3457
        0x7B2B, # G+3458
        0x7B2D, # G+3459
        0x7B2E, # G+3460
        0x7B2F, # G+3461
        0x7B30, # G+3462
        0x7B31, # G+3463
        0x7B34, # G+3464
        0x7B3D, # G+3465
        0x7B3F, # G+3466
        0x7B40, # G+3467
        0x7B41, # G+3468
        0x7B47, # G+3469
        0x7B4E, # G+3470
        0x7B55, # G+3471
        0x7B60, # G+3472
        0x7B64, # G+3473
        0x7B66, # G+3474
        0x7B69, # G+3475
        0x7B6A, # G+3476
        0x7B6D, # G+3477
        0x7B6F, # G+3478
        0x7B72, # G+3479
        0x7B73, # G+3480
        0x7B77, # G+3481
        0x7B84, # G+3482
        0x7B89, # G+3483
        0x7B8E, # G+3484
        0x7B90, # G+3485
        0x7B91, # G+3486
        0x7B96, # G+3487
        0x7B9B, # G+3488
        0x7B9E, # G+3489
        0x7BA0, # G+3490
        0x7BA5, # G+3491
        0x7BAC, # G+3492
        0x7BAF, # G+3493
        0x7BB0, # G+3494
        0x7BB2, # G+3495
        0x7BB5, # G+3496
        0x7BB6, # G+3497
        0x7BBA, # G+3498
        0x7BBB, # G+3499
        0x7BBC, # G+3500
        0x7BBD, # G+3501
        0x7BC2, # G+3502
        0x7BC5, # G+3503
        0x7BC8, # G+3504
        0x7BCA, # G+3505
        0x7BD4, # G+3506
        0x7BD6, # G+3507
        0x7BD7, # G+3508
        0x7BD9, # G+3509
        0x7BDA, # G+3510
        0x7BDB, # G+3511
        0x7BE8, # G+3512
        0x7BEA, # G+3513
        0x7BF2, # G+3514
        0x7BF4, # G+3515
        0x7BF5, # G+3516
        0x7BF8, # G+3517
        0x7BF9, # G+3518
        0x7BFA, # G+3519
        0x7BFC, # G+3520
        0x7BFE, # G+3521
        0x7C01, # G+3522
        0x7C02, # G+3523
        0x7C03, # G+3524
        0x7C04, # G+3525
        0x7C06, # G+3526
        0x7C09, # G+3527
        0x7C0B, # G+3528
        0x7C0C, # G+3529
        0x7C0E, # G+3530
        0x7C0F, # G+3531
        0x7C19, # G+3532
        0x7C1B, # G+3533
        0x7C20, # G+3534
        0x7C25, # G+3535
        0x7C26, # G+3536
        0x7C28, # G+3537
        0x7C2C, # G+3538
        0x7C31, # G+3539
        0x7C33, # G+3540
        0x7C34, # G+3541
        0x7C36, # G+3542
        0x7C39, # G+3543
        0x7C3A, # G+3544
        0x7C46, # G+3545
        0x7C4A, # G+3546
        0x7C55, # G+3547
        0x7C51, # G+3548
        0x7C52, # G+3549
        0x7C53, # G+3550
        0x7C59, # G+3551
        0x7C5A, # G+3552
        0x7C5B, # G+3553
        0x7C5C, # G+3554
        0x7C5D, # G+3555
        0x7C5E, # G+3556
        0x7C61, # G+3557
        0x7C63, # G+3558
        0x7C67, # G+3559
        0x7C69, # G+3560
        0x7C6D, # G+3561
        0x7C6E, # G+3562
        0x7C70, # G+3563
        0x7C72, # G+3564
        0x7C79, # G+3565
        0x7C7C, # G+3566
        0x7C7D, # G+3567
        0x7C86, # G+3568
        0x7C87, # G+3569
        0x7C8F, # G+3570
        0x7C94, # G+3571
        0x7C9E, # G+3572
        0x7CA0, # G+3573
        0x7CA6, # G+3574
        0x7CB0, # G+3575
        0x7CB6, # G+3576
        0x7CB7, # G+3577
        0x7CBA, # G+3578
        0x7CBB, # G+3579
        0x7CBC, # G+3580
        0x7CBF, # G+3581
        0x7CC4, # G+3582
        0x7CC7, # G+3583
        0x7CC8, # G+3584
        0x7CC9, # G+3585
        0x7CCD, # G+3586
        0x7CCF, # G+3587
        0x7CD3, # G+3588
        0x7CD4, # G+3589
        0x7CD5, # G+3590
        0x7CD7, # G+3591
        0x7CD9, # G+3592
        0x7CDA, # G+3593
        0x7CDD, # G+3594
        0x7CE6, # G+3595
        0x7CE9, # G+3596
        0x7CEB, # G+3597
        0x7CF5, # G+3598
        0x7D03, # G+3599
        0x7D07, # G+3600
        0x7D08, # G+3601
        0x7D09, # G+3602
        0x7D0F, # G+3603
        0x7D11, # G+3604
        0x7D12, # G+3605
        0x7D13, # G+3606
        0x7D16, # G+3607
        0x7D1D, # G+3608
        0x7D1E, # G+3609
        0x7D23, # G+3610
        0x7D26, # G+3611
        0x7D2A, # G+3612
        0x7D2D, # G+3613
        0x7D31, # G+3614
        0x7D3C, # G+3615
        0x7D3D, # G+3616
        0x7D3E, # G+3617
        0x7D40, # G+3618
        0x7D41, # G+3619
        0x7D47, # G+3620
        0x7D48, # G+3621
        0x7D4D, # G+3622
        0x7D51, # G+3623
        0x7D53, # G+3624
        0x7D57, # G+3625
        0x7D59, # G+3626
        0x7D5A, # G+3627
        0x7D5C, # G+3628
        0x7D5D, # G+3629
        0x7D65, # G+3630
        0x7D67, # G+3631
        0x7D6A, # G+3632
        0x7D70, # G+3633
        0x7D78, # G+3634
        0x7D7A, # G+3635
        0x7D7B, # G+3636
        0x7D7F, # G+3637
        0x7D81, # G+3638
        0x7D82, # G+3639
        0x7D83, # G+3640
        0x7D85, # G+3641
        0x7D86, # G+3642
        0x7D88, # G+3643
        0x7D8B, # G+3644
        0x7D8C, # G+3645
        0x7D8D, # G+3646
        0x7D91, # G+3647
        0x7D96, # G+3648
        0x7D97, # G+3649
        0x7D9D, # G+3650
        0x7D9E, # G+3651
        0x7DA6, # G+3652
        0x7DA7, # G+3653
        0x7DAA, # G+3654
        0x7DB3, # G+3655
        0x7DB6, # G+3656
        0x7DB7, # G+3657
        0x7DB9, # G+3658
        0x7DC2, # G+3659
        0x7DC3, # G+3660
        0x7DC4, # G+3661
        0x7DC5, # G+3662
        0x7DC6, # G+3663
        0x7DCC, # G+3664
        0x7DCD, # G+3665
        0x7DCE, # G+3666
        0x7DD7, # G+3667
        0x7DD9, # G+3668
        0x7E00, # G+3669
        0x7DE2, # G+3670
        0x7DE5, # G+3671
        0x7DE6, # G+3672
        0x7DEA, # G+3673
        0x7DEB, # G+3674
        0x7DED, # G+3675
        0x7DF1, # G+3676
        0x7DF5, # G+3677
        0x7DF6, # G+3678
        0x7DF9, # G+3679
        0x7DFA, # G+3680
        0x7E08, # G+3681
        0x7E10, # G+3682
        0x7E11, # G+3683
        0x7E15, # G+3684
        0x7E17, # G+3685
        0x7E1C, # G+3686
        0x7E1D, # G+3687
        0x7E20, # G+3688
        0x7E27, # G+3689
        0x7E28, # G+3690
        0x7E2C, # G+3691
        0x7E2D, # G+3692
        0x7E2F, # G+3693
        0x7E33, # G+3694
        0x7E36, # G+3695
        0x7E3F, # G+3696
        0x7E44, # G+3697
        0x7E45, # G+3698
        0x7E47, # G+3699
        0x7E4E, # G+3700
        0x7E50, # G+3701
        0x7E52, # G+3702
        0x7E58, # G+3703
        0x7E5F, # G+3704
        0x7E61, # G+3705
        0x7E62, # G+3706
        0x7E65, # G+3707
        0x7E6B, # G+3708
        0x7E6E, # G+3709
        0x7E6F, # G+3710
        0x7E73, # G+3711
        0x7E78, # G+3712
        0x7E7E, # G+3713
        0x7E81, # G+3714
        0x7E86, # G+3715
        0x7E87, # G+3716
        0x7E8A, # G+3717
        0x7E8D, # G+3718
        0x7E91, # G+3719
        0x7E95, # G+3720
        0x7E98, # G+3721
        0x7E9A, # G+3722
        0x7E9D, # G+3723
        0x7E9E, # G+3724
        0x7F3C, # G+3725
        0x7F3B, # G+3726
        0x7F3D, # G+3727
        0x7F3E, # G+3728
        0x7F3F, # G+3729
        0x7F43, # G+3730
        0x7F44, # G+3731
        0x7F47, # G+3732
        0x7F4F, # G+3733
        0x2EB2, # G+3734
        0x2EB1, # G+3735
        0x7F5B, # G+3736
        0x7F5C, # G+3737
        0x7F5D, # G+3738
        0x7F61, # G+3739
        0x7F63, # G+3740
        0x7F64, # G+3741
        0x7F65, # G+3742
        0x7F66, # G+3743
        0x7F6D, # G+3744
        0x7F71, # G+3745
        0x7F7D, # G+3746
        0x7F7E, # G+3747
        0x7F7F, # G+3748
        0x7F80, # G+3749
        0x7F8B, # G+3750
        0x7F8D, # G+3751
        0x7F8F, # G+3752
        0x7F90, # G+3753
        0x7F91, # G+3754
        0x7F96, # G+3755
        0x7F97, # G+3756
        0x7F9C, # G+3757
        0x7FA1, # G+3758
        0x7FA2, # G+3759
        0x7FA6, # G+3760
        0x7FAA, # G+3761
        0x7FAD, # G+3762
        0x7FB4, # G+3763
        0x7FBC, # G+3764
        0x7FBF, # G+3765
        0x7FC0, # G+3766
        0x7FC3, # G+3767
        0x7FC8, # G+3768
        0x7FCE, # G+3769
        0x7FCF, # G+3770
        0x7FDB, # G+3771
        0x7FDF, # G+3772
        0x7FE3, # G+3773
        0x7FE5, # G+3774
        0x7FE8, # G+3775
        0x7FEC, # G+3776
        0x7FEE, # G+3777
        0x7FEF, # G+3778
        0x7FF2, # G+3779
        0x7FFA, # G+3780
        0x7FFD, # G+3781
        0x7FFE, # G+3782
        0x7FFF, # G+3783
        0x8007, # G+3784
        0x8008, # G+3785
        0x800A, # G+3786
        0x800D, # G+3787
        0x800E, # G+3788
        0x800F, # G+3789
        0x8011, # G+3790
        0x8013, # G+3791
        0x8014, # G+3792
        0x8016, # G+3793
        0x801D, # G+3794
        0x801E, # G+3795
        0x801F, # G+3796
        0x8020, # G+3797
        0x8024, # G+3798
        0x8026, # G+3799
        0x802C, # G+3800
        0x802E, # G+3801
        0x8030, # G+3802
        0x8034, # G+3803
        0x8035, # G+3804
        0x8037, # G+3805
        0x8039, # G+3806
        0x803A, # G+3807
        0x803C, # G+3808
        0x803E, # G+3809
        0x8040, # G+3810
        0x8044, # G+3811
        0x8060, # G+3812
        0x8064, # G+3813
        0x8066, # G+3814
        0x806D, # G+3815
        0x8071, # G+3816
        0x8075, # G+3817
        0x8081, # G+3818
        0x8088, # G+3819
        0x808E, # G+3820
        0x809C, # G+3821
        0x809E, # G+3822
        0x80A6, # G+3823
        0x80A7, # G+3824
        0x80AB, # G+3825
        0x80B8, # G+3826
        0x80B9, # G+3827
        0x80C8, # G+3828
        0x80CD, # G+3829
        0x80CF, # G+3830
        0x80D2, # G+3831
        0x80D4, # G+3832
        0x80D5, # G+3833
        0x80D7, # G+3834
        0x80D8, # G+3835
        0x80E0, # G+3836
        0x80ED, # G+3837
        0x80EE, # G+3838
        0x80F0, # G+3839
        0x80F2, # G+3840
        0x80F3, # G+3841
        0x80F6, # G+3842
        0x80F9, # G+3843
        0x80FA, # G+3844
        0x80FE, # G+3845
        0x8103, # G+3846
        0x810B, # G+3847
        0x8116, # G+3848
        0x8117, # G+3849
        0x8118, # G+3850
        0x811C, # G+3851
        0x811E, # G+3852
        0x8120, # G+3853
        0x8124, # G+3854
        0x8127, # G+3855
        0x812C, # G+3856
        0x8130, # G+3857
        0x8135, # G+3858
        0x813A, # G+3859
        0x813C, # G+3860
        0x8145, # G+3861
        0x8147, # G+3862
        0x814A, # G+3863
        0x814C, # G+3864
        0x8152, # G+3865
        0x8157, # G+3866
        0x8160, # G+3867
        0x8161, # G+3868
        0x8167, # G+3869
        0x8168, # G+3870
        0x8169, # G+3871
        0x816D, # G+3872
        0x816F, # G+3873
        0x8177, # G+3874
        0x8181, # G+3875
        0x8190, # G+3876
        0x8184, # G+3877
        0x8185, # G+3878
        0x8186, # G+3879
        0x818B, # G+3880
        0x818E, # G+3881
        0x8196, # G+3882
        0x8198, # G+3883
        0x819B, # G+3884
        0x819E, # G+3885
        0x81A2, # G+3886
        0x81AE, # G+3887
        0x81B2, # G+3888
        0x81B4, # G+3889
        0x81BB, # G+3890
        0x81CB, # G+3891
        0x81C3, # G+3892
        0x81C5, # G+3893
        0x81CA, # G+3894
        0x81CE, # G+3895
        0x81CF, # G+3896
        0x81D5, # G+3897
        0x81D7, # G+3898
        0x81DB, # G+3899
        0x81DD, # G+3900
        0x81DE, # G+3901
        0x81E1, # G+3902
        0x81E4, # G+3903
        0x81EB, # G+3904
        0x81EC, # G+3905
        0x81F0, # G+3906
        0x81F1, # G+3907
        0x81F2, # G+3908
        0x81F5, # G+3909
        0x81F6, # G+3910
        0x81F8, # G+3911
        0x81F9, # G+3912
        0x81FD, # G+3913
        0x81FF, # G+3914
        0x8200, # G+3915
        0x8203, # G+3916
        0x820F, # G+3917
        0x8213, # G+3918
        0x8214, # G+3919
        0x8219, # G+3920
        0x821A, # G+3921
        0x821D, # G+3922
        0x8221, # G+3923
        0x8222, # G+3924
        0x8228, # G+3925
        0x8232, # G+3926
        0x8234, # G+3927
        0x823A, # G+3928
        0x8243, # G+3929
        0x8244, # G+3930
        0x8245, # G+3931
        0x8246, # G+3932
        0x824B, # G+3933
        0x824E, # G+3934
        0x824F, # G+3935
        0x8251, # G+3936
        0x8256, # G+3937
        0x825C, # G+3938
        0x8260, # G+3939
        0x8263, # G+3940
        0x8267, # G+3941
        0x826D, # G+3942
        0x8274, # G+3943
        0x827B, # G+3944
        0x827D, # G+3945
        0x827F, # G+3946
        0x8280, # G+3947
        0x8281, # G+3948
        0x8283, # G+3949
        0x8284, # G+3950
        0x8287, # G+3951
        0x8289, # G+3952
        0x828A, # G+3953
        0x828E, # G+3954
        0x8291, # G+3955
        0x8294, # G+3956
        0x8296, # G+3957
        0x8298, # G+3958
        0x829A, # G+3959
        0x829B, # G+3960
        0x82A0, # G+3961
        0x82A1, # G+3962
        0x82A3, # G+3963
        0x82A4, # G+3964
        0x82A7, # G+3965
        0x82A8, # G+3966
        0x82A9, # G+3967
        0x82AA, # G+3968
        0x82AE, # G+3969
        0x82B0, # G+3970
        0x82B2, # G+3971
        0x82B4, # G+3972
        0x82B7, # G+3973
        0x82BA, # G+3974
        0x82BC, # G+3975
        0x82BE, # G+3976
        0x82BF, # G+3977
        0x82C6, # G+3978
        0x82D0, # G+3979
        0x82D5, # G+3980
        0x82DA, # G+3981
        0x82E0, # G+3982
        0x82E2, # G+3983
        0x82E4, # G+3984
        0x82E8, # G+3985
        0x82EA, # G+3986
        0x82ED, # G+3987
        0x82EF, # G+3988
        0x82F6, # G+3989
        0x82F7, # G+3990
        0x82FD, # G+3991
        0x82FE, # G+3992
        0x8300, # G+3993
        0x8301, # G+3994
        0x8307, # G+3995
        0x8308, # G+3996
        0x830A, # G+3997
        0x830B, # G+3998
        0x8354, # G+3999
        0x831B, # G+4000
        0x831D, # G+4001
        0x831E, # G+4002
        0x831F, # G+4003
        0x8321, # G+4004
        0x8322, # G+4005
        0x832C, # G+4006
        0x832D, # G+4007
        0x832E, # G+4008
        0x8330, # G+4009
        0x8333, # G+4010
        0x8337, # G+4011
        0x833A, # G+4012
        0x833C, # G+4013
        0x833D, # G+4014
        0x8342, # G+4015
        0x8343, # G+4016
        0x8344, # G+4017
        0x8347, # G+4018
        0x834D, # G+4019
        0x834E, # G+4020
        0x8351, # G+4021
        0x8355, # G+4022
        0x8356, # G+4023
        0x8357, # G+4024
        0x8370, # G+4025
        0x8378, # G+4026
        0x837D, # G+4027
        0x837F, # G+4028
        0x8380, # G+4029
        0x8382, # G+4030
        0x8384, # G+4031
        0x8386, # G+4032
        0x838D, # G+4033
        0x8392, # G+4034
        0x8394, # G+4035
        0x8395, # G+4036
        0x8398, # G+4037
        0x8399, # G+4038
        0x839B, # G+4039
        0x839C, # G+4040
        0x839D, # G+4041
        0x83A6, # G+4042
        0x83A7, # G+4043
        0x83A9, # G+4044
        0x83AC, # G+4045
        0x83BE, # G+4046
        0x83BF, # G+4047
        0x83C0, # G+4048
        0x83C7, # G+4049
        0x83C9, # G+4050
        0x83CF, # G+4051
        0x83D0, # G+4052
        0x83D1, # G+4053
        0x83D4, # G+4054
        0x83DD, # G+4055
        0x8353, # G+4056
        0x83E8, # G+4057
        0x83EA, # G+4058
        0x83F6, # G+4059
        0x83F8, # G+4060
        0x83F9, # G+4061
        0x83FC, # G+4062
        0x8401, # G+4063
        0x8406, # G+4064
        0x840A, # G+4065
        0x840F, # G+4066
        0x8411, # G+4067
        0x8415, # G+4068
        0x8419, # G+4069
        0x83AD, # G+4070
        0x842F, # G+4071
        0x8439, # G+4072
        0x8445, # G+4073
        0x8447, # G+4074
        0x8448, # G+4075
        0x844A, # G+4076
        0x844D, # G+4077
        0x844F, # G+4078
        0x8451, # G+4079
        0x8452, # G+4080
        0x8456, # G+4081
        0x8458, # G+4082
        0x8459, # G+4083
        0x845A, # G+4084
        0x845C, # G+4085
        0x8460, # G+4086
        0x8464, # G+4087
        0x8465, # G+4088
        0x8467, # G+4089
        0x846A, # G+4090
        0x8470, # G+4091
        0x8473, # G+4092
        0x8474, # G+4093
        0x8476, # G+4094
        0x8478, # G+4095
        0x847C, # G+4096
        0x847D, # G+4097
        0x8481, # G+4098
        0x8485, # G+4099
        0x8492, # G+4100
        0x8493, # G+4101
        0x8495, # G+4102
        0x849E, # G+4103
        0x84A6, # G+4104
        0x84A8, # G+4105
        0x84A9, # G+4106
        0x84AA, # G+4107
        0x84AF, # G+4108
        0x84B1, # G+4109
        0x84B4, # G+4110
        0x84BA, # G+4111
        0x84BD, # G+4112
        0x84BE, # G+4113
        0x84C0, # G+4114
        0x84C2, # G+4115
        0x84C7, # G+4116
        0x84C8, # G+4117
        0x84CC, # G+4118
        0x84CF, # G+4119
        0x84D3, # G+4120
        0x84DC, # G+4121
        0x84E7, # G+4122
        0x84EA, # G+4123
        0x84EF, # G+4124
        0x84F0, # G+4125
        0x84F1, # G+4126
        0x84F2, # G+4127
        0x84F7, # G+4128
        0x8532, # G+4129
        0x84FA, # G+4130
        0x84FB, # G+4131
        0x84FD, # G+4132
        0x8502, # G+4133
        0x8503, # G+4134
        0x8507, # G+4135
        0x850C, # G+4136
        0x850E, # G+4137
        0x8510, # G+4138
        0x851C, # G+4139
        0x851E, # G+4140
        0x8522, # G+4141
        0x8523, # G+4142
        0x8524, # G+4143
        0x8525, # G+4144
        0x8527, # G+4145
        0x852A, # G+4146
        0x852B, # G+4147
        0x852F, # G+4148
        0x8533, # G+4149
        0x8534, # G+4150
        0x8536, # G+4151
        0x853F, # G+4152
        0x8546, # G+4153
        0x854F, # G+4154
        0x8550, # G+4155
        0x8551, # G+4156
        0x8552, # G+4157
        0x8553, # G+4158
        0x8556, # G+4159
        0x8559, # G+4160
        0x855C, # G+4161
        0x855D, # G+4162
        0x855E, # G+4163
        0x855F, # G+4164
        0x8560, # G+4165
        0x8561, # G+4166
        0x8562, # G+4167
        0x8564, # G+4168
        0x856B, # G+4169
        0x856F, # G+4170
        0x8579, # G+4171
        0x857A, # G+4172
        0x857B, # G+4173
        0x857D, # G+4174
        0x857F, # G+4175
        0x8581, # G+4176
        0x8585, # G+4177
        0x8586, # G+4178
        0x8589, # G+4179
        0x858B, # G+4180
        0x858C, # G+4181
        0x858F, # G+4182
        0x8593, # G+4183
        0x8598, # G+4184
        0x859D, # G+4185
        0x859F, # G+4186
        0x85A0, # G+4187
        0x85A2, # G+4188
        0x85A5, # G+4189
        0x85A7, # G+4190
        0x85B4, # G+4191
        0x85B6, # G+4192
        0x85B7, # G+4193
        0x85B8, # G+4194
        0x85BC, # G+4195
        0x85BD, # G+4196
        0x85BE, # G+4197
        0x85BF, # G+4198
        0x85C2, # G+4199
        0x85C7, # G+4200
        0x85CA, # G+4201
        0x85CB, # G+4202
        0x85CE, # G+4203
        0x85AD, # G+4204
        0x85D8, # G+4205
        0x85DA, # G+4206
        0x85DF, # G+4207
        0x85E0, # G+4208
        0x85E6, # G+4209
        0x85E8, # G+4210
        0x85ED, # G+4211
        0x85F3, # G+4212
        0x85F6, # G+4213
        0x85FC, # G+4214
        0x85FF, # G+4215
        0x8600, # G+4216
        0x8604, # G+4217
        0x8605, # G+4218
        0x860D, # G+4219
        0x860E, # G+4220
        0x8610, # G+4221
        0x8611, # G+4222
        0x8612, # G+4223
        0x8618, # G+4224
        0x8619, # G+4225
        0x861B, # G+4226
        0x861E, # G+4227
        0x8621, # G+4228
        0x8627, # G+4229
        0x8629, # G+4230
        0x8636, # G+4231
        0x8638, # G+4232
        0x863A, # G+4233
        0x863C, # G+4234
        0x863D, # G+4235
        0x8640, # G+4236
        0x8642, # G+4237
        0x8646, # G+4238
        0x8652, # G+4239
        0x8653, # G+4240
        0x8656, # G+4241
        0x8657, # G+4242
        0x8658, # G+4243
        0x8659, # G+4244
        0x865D, # G+4245
        0x8660, # G+4246
        0x8661, # G+4247
        0x8662, # G+4248
        0x8663, # G+4249
        0x8664, # G+4250
        0x8669, # G+4251
        0x866C, # G+4252
        0x866F, # G+4253
        0x8675, # G+4254
        0x8676, # G+4255
        0x8677, # G+4256
        0x867A, # G+4257
        0x868D, # G+4258
        0x8691, # G+4259
        0x8696, # G+4260
        0x8698, # G+4261
        0x869A, # G+4262
        0x869C, # G+4263
        0x86A1, # G+4264
        0x86A6, # G+4265
        0x86A7, # G+4266
        0x86A8, # G+4267
        0x86AD, # G+4268
        0x86B1, # G+4269
        0x86B3, # G+4270
        0x86B4, # G+4271
        0x86B5, # G+4272
        0x86B7, # G+4273
        0x86B8, # G+4274
        0x86B9, # G+4275
        0x86BF, # G+4276
        0x86C0, # G+4277
        0x86C1, # G+4278
        0x86C3, # G+4279
        0x86C5, # G+4280
        0x86D1, # G+4281
        0x86D2, # G+4282
        0x86D5, # G+4283
        0x86D7, # G+4284
        0x86DA, # G+4285
        0x86DC, # G+4286
        0x86E0, # G+4287
        0x86E3, # G+4288
        0x86E5, # G+4289
        0x86E7, # G+4290
        0x8688, # G+4291
        0x86FA, # G+4292
        0x86FC, # G+4293
        0x86FD, # G+4294
        0x8704, # G+4295
        0x8705, # G+4296
        0x8707, # G+4297
        0x870B, # G+4298
        0x870E, # G+4299
        0x870F, # G+4300
        0x8710, # G+4301
        0x8713, # G+4302
        0x8714, # G+4303
        0x8719, # G+4304
        0x871E, # G+4305
        0x871F, # G+4306
        0x8721, # G+4307
        0x8723, # G+4308
        0x8728, # G+4309
        0x872E, # G+4310
        0x872F, # G+4311
        0x8731, # G+4312
        0x8732, # G+4313
        0x8739, # G+4314
        0x873A, # G+4315
        0x873C, # G+4316
        0x873D, # G+4317
        0x873E, # G+4318
        0x8740, # G+4319
        0x8743, # G+4320
        0x8745, # G+4321
        0x874D, # G+4322
        0x8758, # G+4323
        0x875D, # G+4324
        0x8761, # G+4325
        0x8764, # G+4326
        0x8765, # G+4327
        0x876F, # G+4328
        0x8771, # G+4329
        0x8772, # G+4330
        0x877B, # G+4331
        0x8783, # G+4332
        0x8784, # G+4333
        0x8785, # G+4334
        0x8786, # G+4335
        0x8787, # G+4336
        0x8788, # G+4337
        0x8789, # G+4338
        0x878B, # G+4339
        0x878C, # G+4340
        0x8790, # G+4341
        0x8793, # G+4342
        0x8795, # G+4343
        0x8797, # G+4344
        0x8798, # G+4345
        0x8799, # G+4346
        0x879E, # G+4347
        0x87A0, # G+4348
        0x87A3, # G+4349
        0x87A7, # G+4350
        0x87AC, # G+4351
        0x87AD, # G+4352
        0x87AE, # G+4353
        0x87B1, # G+4354
        0x87B5, # G+4355
        0x87BE, # G+4356
        0x87BF, # G+4357
        0x87C1, # G+4358
        0x87C8, # G+4359
        0x87C9, # G+4360
        0x87CA, # G+4361
        0x87CE, # G+4362
        0x87D5, # G+4363
        0x87D6, # G+4364
        0x87D9, # G+4365
        0x87DA, # G+4366
        0x87DC, # G+4367
        0x87DF, # G+4368
        0x87E2, # G+4369
        0x87E3, # G+4370
        0x87E4, # G+4371
        0x87EA, # G+4372
        0x87EB, # G+4373
        0x87ED, # G+4374
        0x87F1, # G+4375
        0x87F3, # G+4376
        0x87F8, # G+4377
        0x87FA, # G+4378
        0x87FF, # G+4379
        0x8801, # G+4380
        0x8803, # G+4381
        0x8806, # G+4382
        0x8809, # G+4383
        0x880A, # G+4384
        0x880B, # G+4385
        0x8810, # G+4386
        0x8819, # G+4387
        0x8812, # G+4388
        0x8813, # G+4389
        0x8814, # G+4390
        0x8818, # G+4391
        0x881A, # G+4392
        0x881B, # G+4393
        0x881C, # G+4394
        0x881E, # G+4395
        0x881F, # G+4396
        0x8828, # G+4397
        0x882D, # G+4398
        0x882E, # G+4399
        0x8830, # G+4400
        0x8832, # G+4401
        0x8835, # G+4402
        0x883A, # G+4403
        0x883C, # G+4404
        0x8841, # G+4405
        0x8843, # G+4406
        0x8845, # G+4407
        0x8848, # G+4408
        0x8849, # G+4409
        0x884A, # G+4410
        0x884B, # G+4411
        0x884E, # G+4412
        0x8851, # G+4413
        0x8855, # G+4414
        0x8856, # G+4415
        0x8858, # G+4416
        0x885A, # G+4417
        0x885C, # G+4418
        0x885F, # G+4419
        0x8860, # G+4420
        0x2EC2, # G+4421
        0x8869, # G+4422
        0x8871, # G+4423
        0x8879, # G+4424
        0x887B, # G+4425
        0x8880, # G+4426
        0x8898, # G+4427
        0x889A, # G+4428
        0x889B, # G+4429
        0x889C, # G+4430
        0x889F, # G+4431
        0x88A0, # G+4432
        0x88A8, # G+4433
        0x88AA, # G+4434
        0x88BA, # G+4435
        0x88BD, # G+4436
        0x88BE, # G+4437
        0x88C0, # G+4438
        0x88CA, # G+4439
        0x88CB, # G+4440
        0x88CC, # G+4441
        0x88CD, # G+4442
        0x88CE, # G+4443
        0x88D1, # G+4444
        0x88D2, # G+4445
        0x88D3, # G+4446
        0x88DB, # G+4447
        0x88DE, # G+4448
        0x88E7, # G+4449
        0x88EF, # G+4450
        0x88F0, # G+4451
        0x88F1, # G+4452
        0x88F5, # G+4453
        0x88F7, # G+4454
        0x8901, # G+4455
        0x8906, # G+4456
        0x890D, # G+4457
        0x890E, # G+4458
        0x890F, # G+4459
        0x8915, # G+4460
        0x8916, # G+4461
        0x8918, # G+4462
        0x8919, # G+4463
        0x891A, # G+4464
        0x891C, # G+4465
        0x8920, # G+4466
        0x8926, # G+4467
        0x8927, # G+4468
        0x8928, # G+4469
        0x8930, # G+4470
        0x8931, # G+4471
        0x8932, # G+4472
        0x8935, # G+4473
        0x8939, # G+4474
        0x893A, # G+4475
        0x893E, # G+4476
        0x8940, # G+4477
        0x8942, # G+4478
        0x8945, # G+4479
        0x8946, # G+4480
        0x8949, # G+4481
        0x894F, # G+4482
        0x8952, # G+4483
        0x8957, # G+4484
        0x895A, # G+4485
        0x895B, # G+4486
        0x895C, # G+4487
        0x8961, # G+4488
        0x8962, # G+4489
        0x8963, # G+4490
        0x896B, # G+4491
        0x896E, # G+4492
        0x8970, # G+4493
        0x8973, # G+4494
        0x8975, # G+4495
        0x897A, # G+4496
        0x897B, # G+4497
        0x897C, # G+4498
        0x897D, # G+4499
        0x8989, # G+4500
        0x898D, # G+4501
        0x8990, # G+4502
        0x8994, # G+4503
        0x8995, # G+4504
        0x899B, # G+4505
        0x899C, # G+4506
        0x899F, # G+4507
        0x89A0, # G+4508
        0x89A5, # G+4509
        0x89B0, # G+4510
        0x89B4, # G+4511
        0x89B5, # G+4512
        0x89B6, # G+4513
        0x89B7, # G+4514
        0x89BC, # G+4515
        0x89D4, # G+4516
        0x89D5, # G+4517
        0x89D6, # G+4518
        0x89D7, # G+4519
        0x89D8, # G+4520
        0x89E5, # G+4521
        0x89E9, # G+4522
        0x89EB, # G+4523
        0x89ED, # G+4524
        0x89F1, # G+4525
        0x89F3, # G+4526
        0x89F6, # G+4527
        0x89F9, # G+4528
        0x89FD, # G+4529
        0x89FF, # G+4530
        0x8A04, # G+4531
        0x8A05, # G+4532
        0x8A07, # G+4533
        0x8A0F, # G+4534
        0x8A11, # G+4535
        0x8A12, # G+4536
        0x8A14, # G+4537
        0x8A15, # G+4538
        0x8A1E, # G+4539
        0x8A20, # G+4540
        0x8A22, # G+4541
        0x8A24, # G+4542
        0x8A26, # G+4543
        0x8A2B, # G+4544
        0x8A2C, # G+4545
        0x8A2F, # G+4546
        0x8A35, # G+4547
        0x8A37, # G+4548
        0x8A3D, # G+4549
        0x8A3E, # G+4550
        0x8A40, # G+4551
        0x8A43, # G+4552
        0x8A45, # G+4553
        0x8A47, # G+4554
        0x8A49, # G+4555
        0x8A4D, # G+4556
        0x8A4E, # G+4557
        0x8A53, # G+4558
        0x8A56, # G+4559
        0x8A57, # G+4560
        0x8A58, # G+4561
        0x8A5C, # G+4562
        0x8A5D, # G+4563
        0x8A61, # G+4564
        0x8A65, # G+4565
        0x8A67, # G+4566
        0x8A75, # G+4567
        0x8A76, # G+4568
        0x8A77, # G+4569
        0x8A79, # G+4570
        0x8A7A, # G+4571
        0x8A7B, # G+4572
        0x8A7E, # G+4573
        0x8A7F, # G+4574
        0x8A80, # G+4575
        0x8A83, # G+4576
        0x8A86, # G+4577
        0x8A8B, # G+4578
        0x8A8F, # G+4579
        0x8A90, # G+4580
        0x8A92, # G+4581
        0x8A96, # G+4582
        0x8A97, # G+4583
        0x8A99, # G+4584
        0x8A9F, # G+4585
        0x8AA7, # G+4586
        0x8AA9, # G+4587
        0x8AAE, # G+4588
        0x8AAF, # G+4589
        0x8AB3, # G+4590
        0x8AB6, # G+4591
        0x8AB7, # G+4592
        0x8ABB, # G+4593
        0x8ABE, # G+4594
        0x8AC3, # G+4595
        0x8AC6, # G+4596
        0x8AC8, # G+4597
        0x8AC9, # G+4598
        0x8ACA, # G+4599
        0x8AD1, # G+4600
        0x8AD3, # G+4601
        0x8AD4, # G+4602
        0x8AD5, # G+4603
        0x8AD7, # G+4604
        0x8ADD, # G+4605
        0x8ADF, # G+4606
        0x8AEC, # G+4607
        0x8AF0, # G+4608
        0x8AF4, # G+4609
        0x8AF5, # G+4610
        0x8AF6, # G+4611
        0x8AFC, # G+4612
        0x8AFF, # G+4613
        0x8B05, # G+4614
        0x8B06, # G+4615
        0x8B0B, # G+4616
        0x8B11, # G+4617
        0x8B1C, # G+4618
        0x8B1E, # G+4619
        0x8B1F, # G+4620
        0x8B0A, # G+4621
        0x8B2D, # G+4622
        0x8B30, # G+4623
        0x8B37, # G+4624
        0x8B3C, # G+4625
        0x8B42, # G+4626
        0x8B43, # G+4627
        0x8B44, # G+4628
        0x8B45, # G+4629
        0x8B46, # G+4630
        0x8B48, # G+4631
        0x8B52, # G+4632
        0x8B53, # G+4633
        0x8B54, # G+4634
        0x8B59, # G+4635
        0x8B4D, # G+4636
        0x8B5E, # G+4637
        0x8B63, # G+4638
        0x8B6D, # G+4639
        0x8B76, # G+4640
        0x8B78, # G+4641
        0x8B79, # G+4642
        0x8B7C, # G+4643
        0x8B7E, # G+4644
        0x8B81, # G+4645
        0x8B84, # G+4646
        0x8B85, # G+4647
        0x8B8B, # G+4648
        0x8B8D, # G+4649
        0x8B8F, # G+4650
        0x8B94, # G+4651
        0x8B95, # G+4652
        0x8B9C, # G+4653
        0x8B9E, # G+4654
        0x8B9F, # G+4655
        0x8C38, # G+4656
        0x8C39, # G+4657
        0x8C3D, # G+4658
        0x8C3E, # G+4659
        0x8C45, # G+4660
        0x8C47, # G+4661
        0x8C49, # G+4662
        0x8C4B, # G+4663
        0x8C4F, # G+4664
        0x8C51, # G+4665
        0x8C53, # G+4666
        0x8C54, # G+4667
        0x8C57, # G+4668
        0x8C58, # G+4669
        0x8C5B, # G+4670
        0x8C5D, # G+4671
        0x8C59, # G+4672
        0x8C63, # G+4673
        0x8C64, # G+4674
        0x8C66, # G+4675
        0x8C68, # G+4676
        0x8C69, # G+4677
        0x8C6D, # G+4678
        0x8C73, # G+4679
        0x8C75, # G+4680
        0x8C76, # G+4681
        0x8C7B, # G+4682
        0x8C7E, # G+4683
        0x8C86, # G+4684
        0x8C87, # G+4685
        0x8C8B, # G+4686
        0x8C90, # G+4687
        0x8C92, # G+4688
        0x8C93, # G+4689
        0x8C99, # G+4690
        0x8C9B, # G+4691
        0x8C9C, # G+4692
        0x8CA4, # G+4693
        0x8CB9, # G+4694
        0x8CBA, # G+4695
        0x8CC5, # G+4696
        0x8CC6, # G+4697
        0x8CC9, # G+4698
        0x8CCB, # G+4699
        0x8CCF, # G+4700
        0x8CD6, # G+4701
        0x8CD5, # G+4702
        0x8CD9, # G+4703
        0x8CDD, # G+4704
        0x8CE1, # G+4705
        0x8CE8, # G+4706
        0x8CEC, # G+4707
        0x8CEF, # G+4708
        0x8CF0, # G+4709
        0x8CF2, # G+4710
        0x8CF5, # G+4711
        0x8CF7, # G+4712
        0x8CF8, # G+4713
        0x8CFE, # G+4714
        0x8CFF, # G+4715
        0x8D01, # G+4716
        0x8D03, # G+4717
        0x8D09, # G+4718
        0x8D12, # G+4719
        0x8D17, # G+4720
        0x8D1B, # G+4721
        0x8D65, # G+4722
        0x8D69, # G+4723
        0x8D6C, # G+4724
        0x8D6E, # G+4725
        0x8D7F, # G+4726
        0x8D82, # G+4727
        0x8D84, # G+4728
        0x8D88, # G+4729
        0x8D8D, # G+4730
        0x8D90, # G+4731
        0x8D91, # G+4732
        0x8D95, # G+4733
        0x8D9E, # G+4734
        0x8D9F, # G+4735
        0x8DA0, # G+4736
        0x8DA6, # G+4737
        0x8DAB, # G+4738
        0x8DAC, # G+4739
        0x8DAF, # G+4740
        0x8DB2, # G+4741
        0x8DB5, # G+4742
        0x8DB7, # G+4743
        0x8DB9, # G+4744
        0x8DBB, # G+4745
        0x8DC0, # G+4746
        0x8DC5, # G+4747
        0x8DC6, # G+4748
        0x8DC7, # G+4749
        0x8DC8, # G+4750
        0x8DCA, # G+4751
        0x8DCE, # G+4752
        0x8DD1, # G+4753
        0x8DD4, # G+4754
        0x8DD5, # G+4755
        0x8DD7, # G+4756
        0x8DD9, # G+4757
        0x8DE4, # G+4758
        0x8DE5, # G+4759
        0x8DE7, # G+4760
        0x8DEC, # G+4761
        0x8DF0, # G+4762
        0x8DBC, # G+4763
        0x8DF1, # G+4764
        0x8DF2, # G+4765
        0x8DF4, # G+4766
        0x8DFD, # G+4767
        0x8E01, # G+4768
        0x8E04, # G+4769
        0x8E05, # G+4770
        0x8E06, # G+4771
        0x8E0B, # G+4772
        0x8E11, # G+4773
        0x8E14, # G+4774
        0x8E16, # G+4775
        0x8E20, # G+4776
        0x8E21, # G+4777
        0x8E22, # G+4778
        0x8E23, # G+4779
        0x8E26, # G+4780
        0x8E27, # G+4781
        0x8E31, # G+4782
        0x8E33, # G+4783
        0x8E36, # G+4784
        0x8E37, # G+4785
        0x8E38, # G+4786
        0x8E39, # G+4787
        0x8E3D, # G+4788
        0x8E40, # G+4789
        0x8E41, # G+4790
        0x8E4B, # G+4791
        0x8E4D, # G+4792
        0x8E4E, # G+4793
        0x8E4F, # G+4794
        0x8E54, # G+4795
        0x8E5B, # G+4796
        0x8E5C, # G+4797
        0x8E5D, # G+4798
        0x8E5E, # G+4799
        0x8E61, # G+4800
        0x8E62, # G+4801
        0x8E69, # G+4802
        0x8E6C, # G+4803
        0x8E6D, # G+4804
        0x8E6F, # G+4805
        0x8E70, # G+4806
        0x8E71, # G+4807
        0x8E79, # G+4808
        0x8E7A, # G+4809
        0x8E7B, # G+4810
        0x8E82, # G+4811
        0x8E83, # G+4812
        0x8E89, # G+4813
        0x8E90, # G+4814
        0x8E92, # G+4815
        0x8E95, # G+4816
        0x8E9A, # G+4817
        0x8E9B, # G+4818
        0x8E9D, # G+4819
        0x8E9E, # G+4820
        0x8EA2, # G+4821
        0x8EA7, # G+4822
        0x8EA9, # G+4823
        0x8EAD, # G+4824
        0x8EAE, # G+4825
        0x8EB3, # G+4826
        0x8EB5, # G+4827
        0x8EBA, # G+4828
        0x8EBB, # G+4829
        0x8EC0, # G+4830
        0x8EC1, # G+4831
        0x8EC3, # G+4832
        0x8EC4, # G+4833
        0x8EC7, # G+4834
        0x8ECF, # G+4835
        0x8ED1, # G+4836
        0x8ED4, # G+4837
        0x8EDC, # G+4838
        0x8EE8, # G+4839
        0x8EEE, # G+4840
        0x8EF0, # G+4841
        0x8EF1, # G+4842
        0x8EF7, # G+4843
        0x8EF9, # G+4844
        0x8EFA, # G+4845
        0x8EED, # G+4846
        0x8F00, # G+4847
        0x8F02, # G+4848
        0x8F07, # G+4849
        0x8F08, # G+4850
        0x8F0F, # G+4851
        0x8F10, # G+4852
        0x8F16, # G+4853
        0x8F17, # G+4854
        0x8F18, # G+4855
        0x8F1E, # G+4856
        0x8F20, # G+4857
        0x8F21, # G+4858
        0x8F23, # G+4859
        0x8F25, # G+4860
        0x8F27, # G+4861
        0x8F28, # G+4862
        0x8F2C, # G+4863
        0x8F2D, # G+4864
        0x8F2E, # G+4865
        0x8F34, # G+4866
        0x8F35, # G+4867
        0x8F36, # G+4868
        0x8F37, # G+4869
        0x8F3A, # G+4870
        0x8F40, # G+4871
        0x8F41, # G+4872
        0x8F43, # G+4873
        0x8F47, # G+4874
        0x8F4F, # G+4875
        0x8F51, # G+4876
        0x8F52, # G+4877
        0x8F53, # G+4878
        0x8F54, # G+4879
        0x8F55, # G+4880
        0x8F58, # G+4881
        0x8F5D, # G+4882
        0x8F5E, # G+4883
        0x8F65, # G+4884
        0x8F9D, # G+4885
        0x8FA0, # G+4886
        0x8FA1, # G+4887
        0x8FA4, # G+4888
        0x8FA5, # G+4889
        0x8FA6, # G+4890
        0x2FA1, # G+4891
        0x2ECD, # G+4892
        0x8FB8, # G+4893
        0x8FBE, # G+4894
        0x8FC0, # G+4895
        0x8FC1, # G+4896
        0x8FC6, # G+4897
        0x8FCA, # G+4898
        0x8FCB, # G+4899
        0x8FCD, # G+4900
        0x8FD0, # G+4901
        0x8FD2, # G+4902
        0x8FD3, # G+4903
        0x8FD5, # G+4904
        0x8FE0, # G+4905
        0x8FE3, # G+4906
        0x8FE4, # G+4907
        0x8FE8, # G+4908
        0x8FEE, # G+4909
        0x8FF1, # G+4910
        0x8FF5, # G+4911
        0x8FF6, # G+4912
        0x8FFB, # G+4913
        0x8FFE, # G+4914
        0x9002, # G+4915
        0x9004, # G+4916
        0x9008, # G+4917
        0x900C, # G+4918
        0x9018, # G+4919
        0x901B, # G+4920
        0x9028, # G+4921
        0x9029, # G+4922
        0x902F, # G+4923
        0x902A, # G+4924
        0x902C, # G+4925
        0x902D, # G+4926
        0x9033, # G+4927
        0x9034, # G+4928
        0x9037, # G+4929
        0x903F, # G+4930
        0x9043, # G+4931
        0x9044, # G+4932
        0x904C, # G+4933
        0x905B, # G+4934
        0x905D, # G+4935
        0x9062, # G+4936
        0x9066, # G+4937
        0x9067, # G+4938
        0x906C, # G+4939
        0x9070, # G+4940
        0x9074, # G+4941
        0x9079, # G+4942
        0x9085, # G+4943
        0x9088, # G+4944
        0x908B, # G+4945
        0x908C, # G+4946
        0x908E, # G+4947
        0x9090, # G+4948
        0x9095, # G+4949
        0x9097, # G+4950
        0x9098, # G+4951
        0x9099, # G+4952
        0x909B, # G+4953
        0x90A0, # G+4954
        0x90A1, # G+4955
        0x90A2, # G+4956
        0x90A5, # G+4957
        0x90B0, # G+4958
        0x90B2, # G+4959
        0x90B3, # G+4960
        0x90B4, # G+4961
        0x90B6, # G+4962
        0x90BD, # G+4963
        0x90CC, # G+4964
        0x90BE, # G+4965
        0x90C3, # G+4966
        0x90C4, # G+4967
        0x90C5, # G+4968
        0x90C7, # G+4969
        0x90C8, # G+4970
        0x90D5, # G+4971
        0x90D7, # G+4972
        0x90D8, # G+4973
        0x90D9, # G+4974
        0x90DC, # G+4975
        0x90DD, # G+4976
        0x90DF, # G+4977
        0x90E5, # G+4978
        0x90D2, # G+4979
        0x90F6, # G+4980
        0x90EB, # G+4981
        0x90EF, # G+4982
        0x90F0, # G+4983
        0x90F4, # G+4984
        0x90FE, # G+4985
        0x90FF, # G+4986
        0x9100, # G+4987
        0x9104, # G+4988
        0x9105, # G+4989
        0x9106, # G+4990
        0x9108, # G+4991
        0x910D, # G+4992
        0x9110, # G+4993
        0x9114, # G+4994
        0x9116, # G+4995
        0x9117, # G+4996
        0x9118, # G+4997
        0x911A, # G+4998
        0x911C, # G+4999
        0x911E, # G+5000
        0x9120, # G+5001
        0x9125, # G+5002
        0x9122, # G+5003
        0x9123, # G+5004
        0x9127, # G+5005
        0x9129, # G+5006
        0x912E, # G+5007
        0x912F, # G+5008
        0x9131, # G+5009
        0x9134, # G+5010
        0x9136, # G+5011
        0x9137, # G+5012
        0x9139, # G+5013
        0x913A, # G+5014
        0x913C, # G+5015
        0x913D, # G+5016
        0x9143, # G+5017
        0x9147, # G+5018
        0x9148, # G+5019
        0x914F, # G+5020
        0x9153, # G+5021
        0x9157, # G+5022
        0x9159, # G+5023
        0x915A, # G+5024
        0x915B, # G+5025
        0x9161, # G+5026
        0x9164, # G+5027
        0x9167, # G+5028
        0x916D, # G+5029
        0x9174, # G+5030
        0x9179, # G+5031
        0x917A, # G+5032
        0x917B, # G+5033
        0x9181, # G+5034
        0x9183, # G+5035
        0x9185, # G+5036
        0x9186, # G+5037
        0x918A, # G+5038
        0x918E, # G+5039
        0x9191, # G+5040
        0x9193, # G+5041
        0x9194, # G+5042
        0x9195, # G+5043
        0x9198, # G+5044
        0x919E, # G+5045
        0x91A1, # G+5046
        0x91A6, # G+5047
        0x91A8, # G+5048
        0x91AC, # G+5049
        0x91AD, # G+5050
        0x91AE, # G+5051
        0x91B0, # G+5052
        0x91B1, # G+5053
        0x91B2, # G+5054
        0x91B3, # G+5055
        0x91B6, # G+5056
        0x91BB, # G+5057
        0x91BC, # G+5058
        0x91BD, # G+5059
        0x91BF, # G+5060
        0x91C2, # G+5061
        0x91C3, # G+5062
        0x91C5, # G+5063
        0x91D3, # G+5064
        0x91D4, # G+5065
        0x91D7, # G+5066
        0x91D9, # G+5067
        0x91DA, # G+5068
        0x91DE, # G+5069
        0x91E4, # G+5070
        0x91E5, # G+5071
        0x91E9, # G+5072
        0x91EA, # G+5073
        0x91EC, # G+5074
        0x91ED, # G+5075
        0x91EE, # G+5076
        0x91EF, # G+5077
        0x91F0, # G+5078
        0x91F1, # G+5079
        0x91F7, # G+5080
        0x91F9, # G+5081
        0x91FB, # G+5082
        0x91FD, # G+5083
        0x9200, # G+5084
        0x9201, # G+5085
        0x9204, # G+5086
        0x9205, # G+5087
        0x9206, # G+5088
        0x9207, # G+5089
        0x9209, # G+5090
        0x920A, # G+5091
        0x920C, # G+5092
        0x9210, # G+5093
        0x9212, # G+5094
        0x9213, # G+5095
        0x9216, # G+5096
        0x9218, # G+5097
        0x921C, # G+5098
        0x921D, # G+5099
        0x9223, # G+5100
        0x9224, # G+5101
        0x9225, # G+5102
        0x9226, # G+5103
        0x9228, # G+5104
        0x922E, # G+5105
        0x922F, # G+5106
        0x9230, # G+5107
        0x9233, # G+5108
        0x9235, # G+5109
        0x9236, # G+5110
        0x9238, # G+5111
        0x9239, # G+5112
        0x923A, # G+5113
        0x923C, # G+5114
        0x923E, # G+5115
        0x9240, # G+5116
        0x9242, # G+5117
        0x9243, # G+5118
        0x9246, # G+5119
        0x9247, # G+5120
        0x924A, # G+5121
        0x924D, # G+5122
        0x924E, # G+5123
        0x924F, # G+5124
        0x9251, # G+5125
        0x9258, # G+5126
        0x9259, # G+5127
        0x925C, # G+5128
        0x925D, # G+5129
        0x9260, # G+5130
        0x9261, # G+5131
        0x9265, # G+5132
        0x9267, # G+5133
        0x9268, # G+5134
        0x9269, # G+5135
        0x926E, # G+5136
        0x926F, # G+5137
        0x9270, # G+5138
        0x9275, # G+5139
        0x9276, # G+5140
        0x9277, # G+5141
        0x9278, # G+5142
        0x9279, # G+5143
        0x927B, # G+5144
        0x927C, # G+5145
        0x927D, # G+5146
        0x927F, # G+5147
        0x9288, # G+5148
        0x9289, # G+5149
        0x928A, # G+5150
        0x928D, # G+5151
        0x928E, # G+5152
        0x9292, # G+5153
        0x9297, # G+5154
        0x9299, # G+5155
        0x929F, # G+5156
        0x92A0, # G+5157
        0x92A4, # G+5158
        0x92A5, # G+5159
        0x92A7, # G+5160
        0x92A8, # G+5161
        0x92AB, # G+5162
        0x92AF, # G+5163
        0x92B2, # G+5164
        0x92B6, # G+5165
        0x92B8, # G+5166
        0x92BA, # G+5167
        0x92BB, # G+5168
        0x92BC, # G+5169
        0x92BD, # G+5170
        0x92BF, # G+5171
        0x92C0, # G+5172
        0x92C1, # G+5173
        0x92C2, # G+5174
        0x92C3, # G+5175
        0x92C5, # G+5176
        0x92C6, # G+5177
        0x92C7, # G+5178
        0x92C8, # G+5179
        0x92CB, # G+5180
        0x92CC, # G+5181
        0x92CD, # G+5182
        0x92CE, # G+5183
        0x92D0, # G+5184
        0x92D3, # G+5185
        0x92D5, # G+5186
        0x92D7, # G+5187
        0x92D8, # G+5188
        0x92D9, # G+5189
        0x92DC, # G+5190
        0x92DD, # G+5191
        0x92DF, # G+5192
        0x92E0, # G+5193
        0x92E1, # G+5194
        0x92E3, # G+5195
        0x92E5, # G+5196
        0x92E7, # G+5197
        0x92E8, # G+5198
        0x92EC, # G+5199
        0x92EE, # G+5200
        0x92F0, # G+5201
        0x92F9, # G+5202
        0x92FB, # G+5203
        0x92FF, # G+5204
        0x9300, # G+5205
        0x9302, # G+5206
        0x9308, # G+5207
        0x930D, # G+5208
        0x9311, # G+5209
        0x9314, # G+5210
        0x9315, # G+5211
        0x931C, # G+5212
        0x931D, # G+5213
        0x931E, # G+5214
        0x931F, # G+5215
        0x9321, # G+5216
        0x9324, # G+5217
        0x9325, # G+5218
        0x9327, # G+5219
        0x9329, # G+5220
        0x932A, # G+5221
        0x9333, # G+5222
        0x9334, # G+5223
        0x9336, # G+5224
        0x9337, # G+5225
        0x9347, # G+5226
        0x9348, # G+5227
        0x9349, # G+5228
        0x9350, # G+5229
        0x9351, # G+5230
        0x9352, # G+5231
        0x9355, # G+5232
        0x9357, # G+5233
        0x9358, # G+5234
        0x935A, # G+5235
        0x935E, # G+5236
        0x9364, # G+5237
        0x9365, # G+5238
        0x9367, # G+5239
        0x9369, # G+5240
        0x936A, # G+5241
        0x936D, # G+5242
        0x936F, # G+5243
        0x9370, # G+5244
        0x9371, # G+5245
        0x9373, # G+5246
        0x9374, # G+5247
        0x9376, # G+5248
        0x937A, # G+5249
        0x937D, # G+5250
        0x937F, # G+5251
        0x9380, # G+5252
        0x9381, # G+5253
        0x9382, # G+5254
        0x9388, # G+5255
        0x938A, # G+5256
        0x938B, # G+5257
        0x938D, # G+5258
        0x938F, # G+5259
        0x9392, # G+5260
        0x9395, # G+5261
        0x9398, # G+5262
        0x939B, # G+5263
        0x939E, # G+5264
        0x93A1, # G+5265
        0x93A3, # G+5266
        0x93A4, # G+5267
        0x93A6, # G+5268
        0x93A8, # G+5269
        0x93AB, # G+5270
        0x93B4, # G+5271
        0x93B5, # G+5272
        0x93B6, # G+5273
        0x93BA, # G+5274
        0x93A9, # G+5275
        0x93C1, # G+5276
        0x93C4, # G+5277
        0x93C5, # G+5278
        0x93C6, # G+5279
        0x93C7, # G+5280
        0x93C9, # G+5281
        0x93CA, # G+5282
        0x93CB, # G+5283
        0x93CC, # G+5284
        0x93CD, # G+5285
        0x93D3, # G+5286
        0x93D9, # G+5287
        0x93DC, # G+5288
        0x93DE, # G+5289
        0x93DF, # G+5290
        0x93E2, # G+5291
        0x93E6, # G+5292
        0x93E7, # G+5293
        0x93F9, # G+5294
        0x93F7, # G+5295
        0x93F8, # G+5296
        0x93FA, # G+5297
        0x93FB, # G+5298
        0x93FD, # G+5299
        0x9401, # G+5300
        0x9402, # G+5301
        0x9404, # G+5302
        0x9408, # G+5303
        0x9409, # G+5304
        0x940D, # G+5305
        0x940E, # G+5306
        0x940F, # G+5307
        0x9415, # G+5308
        0x9416, # G+5309
        0x9417, # G+5310
        0x941F, # G+5311
        0x942E, # G+5312
        0x942F, # G+5313
        0x9431, # G+5314
        0x9432, # G+5315
        0x9433, # G+5316
        0x9434, # G+5317
        0x943B, # G+5318
        0x943F, # G+5319
        0x943D, # G+5320
        0x9443, # G+5321
        0x9445, # G+5322
        0x9448, # G+5323
        0x944A, # G+5324
        0x944C, # G+5325
        0x9455, # G+5326
        0x9459, # G+5327
        0x945C, # G+5328
        0x945F, # G+5329
        0x9461, # G+5330
        0x9463, # G+5331
        0x9468, # G+5332
        0x946B, # G+5333
        0x946D, # G+5334
        0x946E, # G+5335
        0x946F, # G+5336
        0x9471, # G+5337
        0x9472, # G+5338
        0x9484, # G+5339
        0x9483, # G+5340
        0x2ED2, # G+5341
        0x9579, # G+5342
        0x957E, # G+5343
        0x9584, # G+5344
        0x9588, # G+5345
        0x958C, # G+5346
        0x958D, # G+5347
        0x958E, # G+5348
        0x959D, # G+5349
        0x959E, # G+5350
        0x959F, # G+5351
        0x95A1, # G+5352
        0x95A6, # G+5353
        0x95A9, # G+5354
        0x95AB, # G+5355
        0x95AC, # G+5356
        0x95B4, # G+5357
        0x95B6, # G+5358
        0x95BA, # G+5359
        0x95BD, # G+5360
        0x95BF, # G+5361
        0x95C6, # G+5362
        0x95C8, # G+5363
        0x95C9, # G+5364
        0x95CB, # G+5365
        0x95D0, # G+5366
        0x95D1, # G+5367
        0x95D2, # G+5368
        0x95D3, # G+5369
        0x95D9, # G+5370
        0x95DA, # G+5371
        0x95DD, # G+5372
        0x95DE, # G+5373
        0x95DF, # G+5374
        0x95E0, # G+5375
        0x95E4, # G+5376
        0x95E6, # G+5377
        0x2ED6, # G+5378
        0x961E, # G+5379
        0x9622, # G+5380
        0x9624, # G+5381
        0x9625, # G+5382
        0x9626, # G+5383
        0x962C, # G+5384
        0x9631, # G+5385
        0x9633, # G+5386
        0x9637, # G+5387
        0x9638, # G+5388
        0x9639, # G+5389
        0x963A, # G+5390
        0x963C, # G+5391
        0x963D, # G+5392
        0x9641, # G+5393
        0x9652, # G+5394
        0x9654, # G+5395
        0x9656, # G+5396
        0x9657, # G+5397
        0x9658, # G+5398
        0x9661, # G+5399
        0x966E, # G+5400
        0x9674, # G+5401
        0x967B, # G+5402
        0x967C, # G+5403
        0x967E, # G+5404
        0x967F, # G+5405
        0x9681, # G+5406
        0x9682, # G+5407
        0x9683, # G+5408
        0x9684, # G+5409
        0x9689, # G+5410
        0x9691, # G+5411
        0x9696, # G+5412
        0x969A, # G+5413
        0x969D, # G+5414
        0x969F, # G+5415
        0x96A4, # G+5416
        0x96A5, # G+5417
        0x96A6, # G+5418
        0x96A9, # G+5419
        0x96AE, # G+5420
        0x96AF, # G+5421
        0x96B3, # G+5422
        0x96BA, # G+5423
        0x96CA, # G+5424
        0x96D2, # G+5425
        0x5DB2, # G+5426
        0x96D8, # G+5427
        0x96DA, # G+5428
        0x96DD, # G+5429
        0x96DE, # G+5430
        0x96DF, # G+5431
        0x96E9, # G+5432
        0x96EF, # G+5433
        0x96F1, # G+5434
        0x96FA, # G+5435
        0x9702, # G+5436
        0x9703, # G+5437
        0x9705, # G+5438
        0x9709, # G+5439
        0x971A, # G+5440
        0x971B, # G+5441
        0x971D, # G+5442
        0x9721, # G+5443
        0x9722, # G+5444
        0x9723, # G+5445
        0x9728, # G+5446
        0x9731, # G+5447
        0x9733, # G+5448
        0x9741, # G+5449
        0x9743, # G+5450
        0x974A, # G+5451
        0x974E, # G+5452
        0x974F, # G+5453
        0x9755, # G+5454
        0x9757, # G+5455
        0x9758, # G+5456
        0x975A, # G+5457
        0x975B, # G+5458
        0x9763, # G+5459
        0x9767, # G+5460
        0x976A, # G+5461
        0x976E, # G+5462
        0x9773, # G+5463
        0x9776, # G+5464
        0x9777, # G+5465
        0x9778, # G+5466
        0x977B, # G+5467
        0x977D, # G+5468
        0x977F, # G+5469
        0x9780, # G+5470
        0x9789, # G+5471
        0x9795, # G+5472
        0x9796, # G+5473
        0x9797, # G+5474
        0x9799, # G+5475
        0x979A, # G+5476
        0x979E, # G+5477
        0x979F, # G+5478
        0x97A2, # G+5479
        0x97AC, # G+5480
        0x97AE, # G+5481
        0x97B1, # G+5482
        0x97B2, # G+5483
        0x97B5, # G+5484
        0x97B6, # G+5485
        0x97B8, # G+5486
        0x97B9, # G+5487
        0x97BA, # G+5488
        0x97BC, # G+5489
        0x97BE, # G+5490
        0x97BF, # G+5491
        0x97C1, # G+5492
        0x97C4, # G+5493
        0x97C5, # G+5494
        0x97C7, # G+5495
        0x97C9, # G+5496
        0x97CA, # G+5497
        0x97CC, # G+5498
        0x97CD, # G+5499
        0x97CE, # G+5500
        0x97D0, # G+5501
        0x97D1, # G+5502
        0x97D4, # G+5503
        0x97D7, # G+5504
        0x97D8, # G+5505
        0x97D9, # G+5506
        0x97DD, # G+5507
        0x97DE, # G+5508
        0x97E0, # G+5509
        0x97DB, # G+5510
        0x97E1, # G+5511
        0x97E4, # G+5512
        0x97EF, # G+5513
        0x97F1, # G+5514
        0x97F4, # G+5515
        0x97F7, # G+5516
        0x97F8, # G+5517
        0x97FA, # G+5518
        0x9807, # G+5519
        0x980A, # G+5520
        0x9819, # G+5521
        0x980D, # G+5522
        0x980E, # G+5523
        0x9814, # G+5524
        0x9816, # G+5525
        0x981C, # G+5526
        0x981E, # G+5527
        0x9820, # G+5528
        0x9823, # G+5529
        0x9826, # G+5530
        0x982B, # G+5531
        0x982E, # G+5532
        0x982F, # G+5533
        0x9830, # G+5534
        0x9832, # G+5535
        0x9833, # G+5536
        0x9835, # G+5537
        0x9825, # G+5538
        0x983E, # G+5539
        0x9844, # G+5540
        0x9847, # G+5541
        0x984A, # G+5542
        0x9851, # G+5543
        0x9852, # G+5544
        0x9853, # G+5545
        0x9856, # G+5546
        0x9857, # G+5547
        0x9859, # G+5548
        0x985A, # G+5549
        0x9862, # G+5550
        0x9863, # G+5551
        0x9865, # G+5552
        0x9866, # G+5553
        0x986A, # G+5554
        0x986C, # G+5555
        0x98AB, # G+5556
        0x98AD, # G+5557
        0x98AE, # G+5558
        0x98B0, # G+5559
        0x98B4, # G+5560
        0x98B7, # G+5561
        0x98B8, # G+5562
        0x98BA, # G+5563
        0x98BB, # G+5564
        0x98BF, # G+5565
        0x98C2, # G+5566
        0x98C5, # G+5567
        0x98C8, # G+5568
        0x98CC, # G+5569
        0x98E1, # G+5570
        0x98E3, # G+5571
        0x98E5, # G+5572
        0x98E6, # G+5573
        0x98E7, # G+5574
        0x98EA, # G+5575
        0x98F3, # G+5576
        0x98F6, # G+5577
        0x9902, # G+5578
        0x9907, # G+5579
        0x9908, # G+5580
        0x9911, # G+5581
        0x9915, # G+5582
        0x9916, # G+5583
        0x9917, # G+5584
        0x991A, # G+5585
        0x991B, # G+5586
        0x991C, # G+5587
        0x991F, # G+5588
        0x9922, # G+5589
        0x9926, # G+5590
        0x9927, # G+5591
        0x992B, # G+5592
        0x9931, # G+5593
        0x9932, # G+5594
        0x9933, # G+5595
        0x9934, # G+5596
        0x9935, # G+5597
        0x9939, # G+5598
        0x993A, # G+5599
        0x993B, # G+5600
        0x993C, # G+5601
        0x9940, # G+5602
        0x9941, # G+5603
        0x9946, # G+5604
        0x9947, # G+5605
        0x9948, # G+5606
        0x994D, # G+5607
        0x994E, # G+5608
        0x9954, # G+5609
        0x9958, # G+5610
        0x9959, # G+5611
        0x995B, # G+5612
        0x995C, # G+5613
        0x995E, # G+5614
        0x995F, # G+5615
        0x9960, # G+5616
        0x999B, # G+5617
        0x999D, # G+5618
        0x999F, # G+5619
        0x99A6, # G+5620
        0x99B0, # G+5621
        0x99B1, # G+5622
        0x99B2, # G+5623
        0x99B5, # G+5624
        0x99B9, # G+5625
        0x99BA, # G+5626
        0x99BD, # G+5627
        0x99BF, # G+5628
        0x99C3, # G+5629
        0x99C9, # G+5630
        0x99D3, # G+5631
        0x99D4, # G+5632
        0x99D9, # G+5633
        0x99DA, # G+5634
        0x99DC, # G+5635
        0x99DE, # G+5636
        0x99E7, # G+5637
        0x99EA, # G+5638
        0x99EB, # G+5639
        0x99EC, # G+5640
        0x99F0, # G+5641
        0x99F4, # G+5642
        0x99F5, # G+5643
        0x99F9, # G+5644
        0x99FD, # G+5645
        0x99FE, # G+5646
        0x9A02, # G+5647
        0x9A03, # G+5648
        0x9A04, # G+5649
        0x9A0B, # G+5650
        0x9A0C, # G+5651
        0x9A10, # G+5652
        0x9A11, # G+5653
        0x9A16, # G+5654
        0x9A1E, # G+5655
        0x9A20, # G+5656
        0x9A22, # G+5657
        0x9A23, # G+5658
        0x9A24, # G+5659
        0x9A27, # G+5660
        0x9A2D, # G+5661
        0x9A2E, # G+5662
        0x9A33, # G+5663
        0x9A35, # G+5664
        0x9A36, # G+5665
        0x9A38, # G+5666
        0x9A47, # G+5667
        0x9A41, # G+5668
        0x9A44, # G+5669
        0x9A4A, # G+5670
        0x9A4B, # G+5671
        0x9A4C, # G+5672
        0x9A4E, # G+5673
        0x9A51, # G+5674
        0x9A54, # G+5675
        0x9A56, # G+5676
        0x9A5D, # G+5677
        0x9AAA, # G+5678
        0x9AAC, # G+5679
        0x9AAE, # G+5680
        0x9AAF, # G+5681
        0x9AB2, # G+5682
        0x9AB4, # G+5683
        0x9AB5, # G+5684
        0x9AB6, # G+5685
        0x9AB9, # G+5686
        0x9ABB, # G+5687
        0x9ABE, # G+5688
        0x9ABF, # G+5689
        0x9AC1, # G+5690
        0x9AC3, # G+5691
        0x9AC6, # G+5692
        0x9AC8, # G+5693
        0x9ACE, # G+5694
        0x9AD0, # G+5695
        0x9AD2, # G+5696
        0x9AD5, # G+5697
        0x9AD6, # G+5698
        0x9AD7, # G+5699
        0x9ADB, # G+5700
        0x9ADC, # G+5701
        0x9AE0, # G+5702
        0x9AE4, # G+5703
        0x9AE5, # G+5704
        0x9AE7, # G+5705
        0x9AE9, # G+5706
        0x9AEC, # G+5707
        0x9AF2, # G+5708
        0x9AF3, # G+5709
        0x9AF5, # G+5710
        0x9AF9, # G+5711
        0x9AFA, # G+5712
        0x9AFD, # G+5713
        0x9AFF, # G+5714
        0x9B00, # G+5715
        0x9B01, # G+5716
        0x9B02, # G+5717
        0x9B03, # G+5718
        0x9B04, # G+5719
        0x9B05, # G+5720
        0x9B08, # G+5721
        0x9B09, # G+5722
        0x9B0B, # G+5723
        0x9B0C, # G+5724
        0x9B0D, # G+5725
        0x9B0E, # G+5726
        0x9B10, # G+5727
        0x9B12, # G+5728
        0x9B16, # G+5729
        0x9B19, # G+5730
        0x9B1B, # G+5731
        0x9B1C, # G+5732
        0x9B20, # G+5733
        0x9B26, # G+5734
        0x9B2B, # G+5735
        0x9B2D, # G+5736
        0x9B33, # G+5737
        0x9B34, # G+5738
        0x9B35, # G+5739
        0x9B37, # G+5740
        0x9B39, # G+5741
        0x9B3A, # G+5742
        0x9B3D, # G+5743
        0x9B48, # G+5744
        0x9B4B, # G+5745
        0x9B4C, # G+5746
        0x9B55, # G+5747
        0x9B56, # G+5748
        0x9B57, # G+5749
        0x9B5B, # G+5750
        0x9B5E, # G+5751
        0x9B61, # G+5752
        0x9B63, # G+5753
        0x9B65, # G+5754
        0x9B66, # G+5755
        0x9B68, # G+5756
        0x9B6A, # G+5757
        0x9B6B, # G+5758
        0x9B6C, # G+5759
        0x9B6D, # G+5760
        0x9B6E, # G+5761
        0x9B73, # G+5762
        0x9B75, # G+5763
        0x9B77, # G+5764
        0x9B78, # G+5765
        0x9B79, # G+5766
        0x9B7F, # G+5767
        0x9B80, # G+5768
        0x9B84, # G+5769
        0x9B85, # G+5770
        0x9B86, # G+5771
        0x9B87, # G+5772
        0x9B89, # G+5773
        0x9B8A, # G+5774
        0x9B8B, # G+5775
        0x9B8D, # G+5776
        0x9B8F, # G+5777
        0x9B90, # G+5778
        0x9B94, # G+5779
        0x9B9A, # G+5780
        0x9B9D, # G+5781
        0x9B9E, # G+5782
        0x9BA6, # G+5783
        0x9BA7, # G+5784
        0x9BA9, # G+5785
        0x9BAC, # G+5786
        0x9BB0, # G+5787
        0x9BB1, # G+5788
        0x9BB2, # G+5789
        0x9BB7, # G+5790
        0x9BB8, # G+5791
        0x9BBB, # G+5792
        0x9BBC, # G+5793
        0x9BBE, # G+5794
        0x9BBF, # G+5795
        0x9BC1, # G+5796
        0x9BC7, # G+5797
        0x9BC8, # G+5798
        0x9BCE, # G+5799
        0x9BD0, # G+5800
        0x9BD7, # G+5801
        0x9BD8, # G+5802
        0x9BDD, # G+5803
        0x9BDF, # G+5804
        0x9BE5, # G+5805
        0x9BE7, # G+5806
        0x9BEA, # G+5807
        0x9BEB, # G+5808
        0x9BEF, # G+5809
        0x9BF3, # G+5810
        0x9BF7, # G+5811
        0x9BF8, # G+5812
        0x9BF9, # G+5813
        0x9BFA, # G+5814
        0x9BFD, # G+5815
        0x9BFF, # G+5816
        0x9C00, # G+5817
        0x9C02, # G+5818
        0x9C0B, # G+5819
        0x9C0F, # G+5820
        0x9C11, # G+5821
        0x9C16, # G+5822
        0x9C18, # G+5823
        0x9C19, # G+5824
        0x9C1A, # G+5825
        0x9C1C, # G+5826
        0x9C1E, # G+5827
        0x9C22, # G+5828
        0x9C23, # G+5829
        0x9C26, # G+5830
        0x9C27, # G+5831
        0x9C28, # G+5832
        0x9C29, # G+5833
        0x9C2A, # G+5834
        0x9C31, # G+5835
        0x9C35, # G+5836
        0x9C36, # G+5837
        0x9C37, # G+5838
        0x9C3D, # G+5839
        0x9C41, # G+5840
        0x9C43, # G+5841
        0x9C44, # G+5842
        0x9C45, # G+5843
        0x9C49, # G+5844
        0x9C4A, # G+5845
        0x9C4E, # G+5846
        0x9C4F, # G+5847
        0x9C50, # G+5848
        0x9C53, # G+5849
        0x9C54, # G+5850
        0x9C56, # G+5851
        0x9C58, # G+5852
        0x9C5B, # G+5853
        0x9C5D, # G+5854
        0x9C5E, # G+5855
        0x9C5F, # G+5856
        0x9C63, # G+5857
        0x9C69, # G+5858
        0x9C6A, # G+5859
        0x9C5C, # G+5860
        0x9C6B, # G+5861
        0x9C68, # G+5862
        0x9C6E, # G+5863
        0x9C70, # G+5864
        0x9C72, # G+5865
        0x9C75, # G+5866
        0x9C77, # G+5867
        0x9C7B, # G+5868
        0x9CE6, # G+5869
        0x9CF2, # G+5870
        0x9CF7, # G+5871
        0x9CF9, # G+5872
        0x9D0B, # G+5873
        0x9D02, # G+5874
        0x9D11, # G+5875
        0x9D17, # G+5876
        0x9D18, # G+5877
        0x9D1C, # G+5878
        0x9D1D, # G+5879
        0x9D1E, # G+5880
        0x9D2F, # G+5881
        0x9D30, # G+5882
        0x9D32, # G+5883
        0x9D33, # G+5884
        0x9D34, # G+5885
        0x9D3A, # G+5886
        0x9D3C, # G+5887
        0x9D45, # G+5888
        0x9D3D, # G+5889
        0x9D42, # G+5890
        0x9D43, # G+5891
        0x9D47, # G+5892
        0x9D4A, # G+5893
        0x9D53, # G+5894
        0x9D54, # G+5895
        0x9D5F, # G+5896
        0x9D63, # G+5897
        0x9D62, # G+5898
        0x9D65, # G+5899
        0x9D69, # G+5900
        0x9D6A, # G+5901
        0x9D6B, # G+5902
        0x9D70, # G+5903
        0x9D76, # G+5904
        0x9D77, # G+5905
        0x9D7B, # G+5906
        0x9D7C, # G+5907
        0x9D7E, # G+5908
        0x9D83, # G+5909
        0x9D84, # G+5910
        0x9D86, # G+5911
        0x9D8A, # G+5912
        0x9D8D, # G+5913
        0x9D8E, # G+5914
        0x9D92, # G+5915
        0x9D93, # G+5916
        0x9D95, # G+5917
        0x9D96, # G+5918
        0x9D97, # G+5919
        0x9D98, # G+5920
        0x9DA1, # G+5921
        0x9DAA, # G+5922
        0x9DAC, # G+5923
        0x9DAE, # G+5924
        0x9DB1, # G+5925
        0x9DB5, # G+5926
        0x9DB9, # G+5927
        0x9DBC, # G+5928
        0x9DBF, # G+5929
        0x9DC3, # G+5930
        0x9DC7, # G+5931
        0x9DC9, # G+5932
        0x9DCA, # G+5933
        0x9DD4, # G+5934
        0x9DD5, # G+5935
        0x9DD6, # G+5936
        0x9DD7, # G+5937
        0x9DDA, # G+5938
        0x9DDE, # G+5939
        0x9DDF, # G+5940
        0x9DE0, # G+5941
        0x9DE5, # G+5942
        0x9DE7, # G+5943
        0x9DE9, # G+5944
        0x9DEB, # G+5945
        0x9DEE, # G+5946
        0x9DF0, # G+5947
        0x9DF3, # G+5948
        0x9DF4, # G+5949
        0x9DFE, # G+5950
        0x9E0A, # G+5951
        0x9E02, # G+5952
        0x9E07, # G+5953
        0x9E0E, # G+5954
        0x9E10, # G+5955
        0x9E11, # G+5956
        0x9E12, # G+5957
        0x9E15, # G+5958
        0x9E16, # G+5959
        0x9E19, # G+5960
        0x9E1C, # G+5961
        0x9E1D, # G+5962
        0x9E7A, # G+5963
        0x9E7B, # G+5964
        0x9E7C, # G+5965
        0x9E80, # G+5966
        0x9E82, # G+5967
        0x9E83, # G+5968
        0x9E84, # G+5969
        0x9E85, # G+5970
        0x9E87, # G+5971
        0x9E8E, # G+5972
        0x9E8F, # G+5973
        0x9E96, # G+5974
        0x9E98, # G+5975
        0x9E9B, # G+5976
        0x9E9E, # G+5977
        0x9EA4, # G+5978
        0x9EA8, # G+5979
        0x9EAC, # G+5980
        0x9EAE, # G+5981
        0x9EAF, # G+5982
        0x9EB0, # G+5983
        0x9EB3, # G+5984
        0x9EB4, # G+5985
        0x9EB5, # G+5986
        0x9EC6, # G+5987
        0x9EC8, # G+5988
        0x9ECB, # G+5989
        0x9ED5, # G+5990
        0x9EDF, # G+5991
        0x9EE4, # G+5992
        0x9EE7, # G+5993
        0x9EEC, # G+5994
        0x9EED, # G+5995
        0x9EEE, # G+5996
        0x9EF0, # G+5997
        0x9EF1, # G+5998
        0x9EF2, # G+5999
        0x9EF5, # G+6000
        0x9EF8, # G+6001
        0x9EFF, # G+6002
        0x9F02, # G+6003
        0x9F03, # G+6004
        0x9F09, # G+6005
        0x9F0F, # G+6006
        0x9F10, # G+6007
        0x9F11, # G+6008
        0x9F12, # G+6009
        0x9F14, # G+6010
        0x9F16, # G+6011
        0x9F17, # G+6012
        0x9F19, # G+6013
        0x9F1A, # G+6014
        0x9F1B, # G+6015
        0x9F1F, # G+6016
        0x9F22, # G+6017
        0x9F26, # G+6018
        0x9F2A, # G+6019
        0x9F2B, # G+6020
        0x9F2F, # G+6021
        0x9F31, # G+6022
        0x9F32, # G+6023
        0x9F34, # G+6024
        0x9F37, # G+6025
        0x9F39, # G+6026
        0x9F3A, # G+6027
        0x9F3C, # G+6028
        0x9F3D, # G+6029
        0x9F3F, # G+6030
        0x9F41, # G+6031
        0x9F43, # G+6032
        0x9F44, # G+6033
        0x9F45, # G+6034
        0x9F46, # G+6035
        0x9F47, # G+6036
        0x9F53, # G+6037
        0x9F55, # G+6038
        0x9F56, # G+6039
        0x9F57, # G+6040
        0x9F58, # G+6041
        0x9F5A, # G+6042
        0x9F5D, # G+6043
        0x9F5E, # G+6044
        0x9F68, # G+6045
        0x9F69, # G+6046
        0x9F6D, # G+6047
        0x9F6E, # G+6048
        0x9F6F, # G+6049
        0x9F70, # G+6050
        0x9F71, # G+6051
        0x9F73, # G+6052
        0x9F75, # G+6053
        0x9F7A, # G+6054
        0x9F7D, # G+6055
        0x9F8F, # G+6056
        0x9F90, # G+6057
        0x9F91, # G+6058
        0x9F92, # G+6059
        0x9F94, # G+6060
        0x9F96, # G+6061
        0x9F97, # G+6062
        0x9F9E, # G+6063
        0x9FA1, # G+6064
        0x9FA2, # G+6065
        0x9FA3, # G+6066
        0x9FA5, # G+6067
    ],
    'u2g' => {
        '0' => '0', # U+0000
        '126' => '9', # U+007E
        '161' => '12', # U+00A1
        '164' => '20', # U+00A4
        '166' => '13', # U+00A6
        '169' => '17', # U+00A9
        '170' => '16', # U+00AA
        '174' => '18', # U+00AE
        '175' => '6', # U+00AF
        '184' => '3', # U+00B8
        '186' => '15', # U+00BA
        '191' => '14', # U+00BF
        '192' => '97', # U+00C0
        '193' => '96', # U+00C1
        '194' => '99', # U+00C2
        '195' => '105', # U+00C3
        '196' => '98', # U+00C4
        '197' => '104', # U+00C5
        '198' => '69', # U+00C6
        '199' => '109', # U+00C7
        '200' => '113', # U+00C8
        '201' => '112', # U+00C9
        '202' => '115', # U+00CA
        '203' => '114', # U+00CB
        '204' => '126', # U+00CC
        '205' => '125', # U+00CD
        '206' => '128', # U+00CE
        '207' => '127', # U+00CF
        '209' => '142', # U+00D1
        '210' => '144', # U+00D2
        '211' => '143', # U+00D3
        '212' => '146', # U+00D4
        '213' => '150', # U+00D5
        '214' => '145', # U+00D6
        '216' => '76', # U+00D8
        '217' => '161', # U+00D9
        '218' => '160', # U+00DA
        '219' => '163', # U+00DB
        '220' => '162', # U+00DC
        '221' => '176', # U+00DD
        '222' => '79', # U+00DE
        '223' => '93', # U+00DF
        '224' => '183', # U+00E0
        '225' => '182', # U+00E1
        '226' => '185', # U+00E2
        '227' => '191', # U+00E3
        '228' => '184', # U+00E4
        '229' => '190', # U+00E5
        '230' => '80', # U+00E6
        '231' => '195', # U+00E7
        '232' => '199', # U+00E8
        '233' => '198', # U+00E9
        '234' => '201', # U+00EA
        '235' => '200', # U+00EB
        '236' => '212', # U+00EC
        '237' => '211', # U+00ED
        '238' => '214', # U+00EE
        '239' => '213', # U+00EF
        '240' => '82', # U+00F0
        '241' => '227', # U+00F1
        '242' => '229', # U+00F2
        '243' => '228', # U+00F3
        '244' => '231', # U+00F4
        '245' => '235', # U+00F5
        '246' => '230', # U+00F6
        '248' => '91', # U+00F8
        '249' => '246', # U+00F9
        '250' => '245', # U+00FA
        '251' => '248', # U+00FB
        '252' => '247', # U+00FC
        '253' => '261', # U+00FD
        '254' => '95', # U+00FE
        '255' => '262', # U+00FF
        '256' => '102', # U+0100
        '257' => '188', # U+0101
        '258' => '100', # U+0102
        '259' => '186', # U+0103
        '260' => '103', # U+0104
        '261' => '189', # U+0105
        '262' => '106', # U+0106
        '263' => '192', # U+0107
        '264' => '107', # U+0108
        '265' => '193', # U+0109
        '266' => '110', # U+010A
        '267' => '196', # U+010B
        '268' => '108', # U+010C
        '269' => '194', # U+010D
        '270' => '111', # U+010E
        '271' => '197', # U+010F
        '272' => '70', # U+0110
        '273' => '81', # U+0111
        '274' => '118', # U+0112
        '275' => '204', # U+0113
        '278' => '117', # U+0116
        '279' => '203', # U+0117
        '280' => '119', # U+0118
        '281' => '205', # U+0119
        '282' => '116', # U+011A
        '283' => '202', # U+011B
        '284' => '120', # U+011C
        '285' => '207', # U+011D
        '286' => '121', # U+011E
        '287' => '208', # U+011F
        '288' => '123', # U+0120
        '289' => '209', # U+0121
        '290' => '122', # U+0122
        '292' => '124', # U+0124
        '293' => '210', # U+0125
        '294' => '71', # U+0126
        '295' => '83', # U+0127
        '296' => '133', # U+0128
        '297' => '218', # U+0129
        '298' => '131', # U+012A
        '299' => '216', # U+012B
        '302' => '132', # U+012E
        '303' => '217', # U+012F
        '304' => '130', # U+0130
        '305' => '84', # U+0131
        '306' => '72', # U+0132
        '307' => '85', # U+0133
        '308' => '134', # U+0134
        '309' => '219', # U+0135
        '310' => '135', # U+0136
        '311' => '220', # U+0137
        '312' => '86', # U+0138
        '313' => '136', # U+0139
        '314' => '221', # U+013A
        '315' => '138', # U+013B
        '316' => '223', # U+013C
        '317' => '137', # U+013D
        '318' => '222', # U+013E
        '319' => '74', # U+013F
        '320' => '88', # U+0140
        '321' => '73', # U+0141
        '322' => '87', # U+0142
        '323' => '139', # U+0143
        '324' => '224', # U+0144
        '325' => '141', # U+0145
        '326' => '226', # U+0146
        '327' => '140', # U+0147
        '328' => '225', # U+0148
        '329' => '89', # U+0149
        '330' => '75', # U+014A
        '331' => '90', # U+014B
        '332' => '149', # U+014C
        '333' => '234', # U+014D
        '336' => '148', # U+0150
        '337' => '233', # U+0151
        '338' => '77', # U+0152
        '339' => '92', # U+0153
        '340' => '151', # U+0154
        '341' => '236', # U+0155
        '342' => '153', # U+0156
        '343' => '238', # U+0157
        '344' => '152', # U+0158
        '345' => '237', # U+0159
        '346' => '154', # U+015A
        '347' => '239', # U+015B
        '348' => '155', # U+015C
        '349' => '240', # U+015D
        '350' => '157', # U+015E
        '351' => '242', # U+015F
        '352' => '156', # U+0160
        '353' => '241', # U+0161
        '354' => '159', # U+0162
        '355' => '244', # U+0163
        '356' => '158', # U+0164
        '357' => '243', # U+0165
        '358' => '78', # U+0166
        '359' => '94', # U+0167
        '360' => '170', # U+0168
        '361' => '255', # U+0169
        '362' => '167', # U+016A
        '363' => '252', # U+016B
        '364' => '164', # U+016C
        '365' => '249', # U+016D
        '366' => '169', # U+016E
        '367' => '254', # U+016F
        '368' => '166', # U+0170
        '369' => '251', # U+0171
        '370' => '168', # U+0172
        '371' => '253', # U+0173
        '372' => '175', # U+0174
        '373' => '260', # U+0175
        '374' => '178', # U+0176
        '375' => '263', # U+0177
        '376' => '177', # U+0178
        '377' => '179', # U+0179
        '378' => '264', # U+017A
        '379' => '181', # U+017B
        '380' => '266', # U+017C
        '381' => '180', # U+017D
        '382' => '265', # U+017E
        '461' => '101', # U+01CD
        '462' => '187', # U+01CE
        '463' => '129', # U+01CF
        '464' => '215', # U+01D0
        '465' => '147', # U+01D1
        '466' => '232', # U+01D2
        '467' => '165', # U+01D3
        '468' => '250', # U+01D4
        '469' => '174', # U+01D5
        '470' => '259', # U+01D6
        '471' => '171', # U+01D7
        '472' => '256', # U+01D8
        '473' => '173', # U+01D9
        '474' => '258', # U+01DA
        '475' => '172', # U+01DB
        '476' => '257', # U+01DC
        '501' => '206', # U+01F5
        '711' => '2', # U+02C7
        '728' => '1', # U+02D8
        '729' => '4', # U+02D9
        '730' => '8', # U+02DA
        '731' => '7', # U+02DB
        '733' => '5', # U+02DD
        '900' => '10', # U+0384
        '901' => '11', # U+0385
        '902' => '22', # U+0386
        '904' => '23', # U+0388
        '905' => '24', # U+0389
        '906' => '25', # U+038A
        '908' => '27', # U+038C
        '910' => '28', # U+038E
        '911' => '30', # U+038F
        '912' => '36', # U+0390
        '938' => '26', # U+03AA
        '939' => '29', # U+03AB
        '940' => '31', # U+03AC
        '941' => '32', # U+03AD
        '942' => '33', # U+03AE
        '943' => '34', # U+03AF
        '944' => '41', # U+03B0
        '962' => '38', # U+03C2
        '970' => '35', # U+03CA
        '971' => '40', # U+03CB
        '972' => '37', # U+03CC
        '973' => '39', # U+03CD
        '974' => '42', # U+03CE
        '1026' => '43', # U+0402
        '1027' => '44', # U+0403
        '1028' => '45', # U+0404
        '1029' => '46', # U+0405
        '1030' => '47', # U+0406
        '1031' => '48', # U+0407
        '1032' => '49', # U+0408
        '1033' => '50', # U+0409
        '1034' => '51', # U+040A
        '1035' => '52', # U+040B
        '1036' => '53', # U+040C
        '1038' => '54', # U+040E
        '1039' => '55', # U+040F
        '1106' => '56', # U+0452
        '1107' => '57', # U+0453
        '1108' => '58', # U+0454
        '1109' => '59', # U+0455
        '1110' => '60', # U+0456
        '1111' => '61', # U+0457
        '1112' => '62', # U+0458
        '1113' => '63', # U+0459
        '1114' => '64', # U+045A
        '1115' => '65', # U+045B
        '1116' => '66', # U+045C
        '1118' => '67', # U+045E
        '1119' => '68', # U+045F
        '8470' => '21', # U+2116
        '8482' => '19', # U+2122
        '11907' => '286', # U+2E83
        '11913' => '565', # U+2E89
        '11919' => '1283', # U+2E8F
        '11925' => '1481', # U+2E95
        '11926' => '1512', # U+2E96
        '11928' => '1699', # U+2E98
        '11937' => '2385', # U+2EA1
        '11938' => '2387', # U+2EA2
        '11939' => '2652', # U+2EA3
        '11941' => '2750', # U+2EA5
        '11944' => '2787', # U+2EA8
        '11949' => '3317', # U+2EAD
        '11953' => '3735', # U+2EB1
        '11954' => '3734', # U+2EB2
        '11970' => '4421', # U+2EC2
        '11981' => '4892', # U+2ECD
        '11986' => '5341', # U+2ED2
        '11990' => '5378', # U+2ED6
        '12033' => '275', # U+2F01
        '12089' => '1481', # U+2F39
        '12135' => '3030', # U+2F67
        '12145' => '3356', # U+2F71
        '12193' => '4891', # U+2FA1
        '19970' => '267', # U+4E02
        '19972' => '268', # U+4E04
        '19973' => '269', # U+4E05
        '19980' => '270', # U+4E0C
        '19986' => '271', # U+4E12
        '19999' => '272', # U+4E1F
        '20003' => '273', # U+4E23
        '20004' => '274', # U+4E24
        '20008' => '275', # U+4E28
        '20011' => '276', # U+4E2B
        '20014' => '277', # U+4E2E
        '20015' => '278', # U+4E2F
        '20016' => '279', # U+4E30
        '20021' => '280', # U+4E35
        '20032' => '281', # U+4E40
        '20033' => '282', # U+4E41
        '20036' => '283', # U+4E44
        '20039' => '284', # U+4E47
        '20049' => '285', # U+4E51
        '20058' => '286', # U+4E5A
        '20060' => '287', # U+4E5C
        '20067' => '288', # U+4E63
        '20072' => '289', # U+4E68
        '20073' => '290', # U+4E69
        '20084' => '291', # U+4E74
        '20085' => '292', # U+4E75
        '20089' => '293', # U+4E79
        '20095' => '294', # U+4E7F
        '20109' => '295', # U+4E8D
        '20118' => '296', # U+4E96
        '20119' => '297', # U+4E97
        '20125' => '298', # U+4E9D
        '20143' => '299', # U+4EAF
        '20153' => '300', # U+4EB9
        '20163' => '301', # U+4EC3
        '20176' => '302', # U+4ED0
        '20186' => '303', # U+4EDA
        '20187' => '304', # U+4EDB
        '20192' => '305', # U+4EE0
        '20193' => '306', # U+4EE1
        '20194' => '307', # U+4EE2
        '20200' => '308', # U+4EE8
        '20207' => '309', # U+4EEF
        '20209' => '310', # U+4EF1
        '20211' => '311', # U+4EF3
        '20213' => '312', # U+4EF5
        '20221' => '313', # U+4EFD
        '20222' => '314', # U+4EFE
        '20223' => '315', # U+4EFF
        '20224' => '316', # U+4F00
        '20226' => '317', # U+4F02
        '20227' => '318', # U+4F03
        '20232' => '319', # U+4F08
        '20235' => '320', # U+4F0B
        '20236' => '321', # U+4F0C
        '20242' => '322', # U+4F12
        '20245' => '323', # U+4F15
        '20246' => '324', # U+4F16
        '20247' => '325', # U+4F17
        '20249' => '326', # U+4F19
        '20270' => '327', # U+4F2E
        '20273' => '328', # U+4F31
        '20275' => '330', # U+4F33
        '20277' => '331', # U+4F35
        '20279' => '332', # U+4F37
        '20281' => '333', # U+4F39
        '20283' => '334', # U+4F3B
        '20286' => '335', # U+4F3E
        '20288' => '336', # U+4F40
        '20290' => '337', # U+4F42
        '20296' => '338', # U+4F48
        '20297' => '339', # U+4F49
        '20299' => '340', # U+4F4B
        '20300' => '341', # U+4F4C
        '20306' => '342', # U+4F52
        '20308' => '343', # U+4F54
        '20310' => '344', # U+4F56
        '20312' => '345', # U+4F58
        '20319' => '346', # U+4F5F
        '20320' => '329', # U+4F60
        '20323' => '347', # U+4F63
        '20330' => '348', # U+4F6A
        '20332' => '349', # U+4F6C
        '20334' => '350', # U+4F6E
        '20337' => '351', # U+4F71
        '20343' => '352', # U+4F77
        '20344' => '353', # U+4F78
        '20345' => '354', # U+4F79
        '20346' => '355', # U+4F7A
        '20349' => '356', # U+4F7D
        '20350' => '357', # U+4F7E
        '20353' => '358', # U+4F81
        '20354' => '359', # U+4F82
        '20356' => '360', # U+4F84
        '20357' => '361', # U+4F85
        '20361' => '362', # U+4F89
        '20362' => '363', # U+4F8A
        '20364' => '364', # U+4F8C
        '20366' => '365', # U+4F8E
        '20368' => '366', # U+4F90
        '20370' => '367', # U+4F92
        '20371' => '368', # U+4F93
        '20372' => '369', # U+4F94
        '20375' => '370', # U+4F97
        '20377' => '371', # U+4F99
        '20378' => '372', # U+4F9A
        '20382' => '373', # U+4F9E
        '20383' => '374', # U+4F9F
        '20402' => '375', # U+4FB2
        '20407' => '376', # U+4FB7
        '20409' => '377', # U+4FB9
        '20411' => '378', # U+4FBB
        '20412' => '379', # U+4FBC
        '20413' => '380', # U+4FBD
        '20414' => '381', # U+4FBE
        '20416' => '382', # U+4FC0
        '20417' => '383', # U+4FC1
        '20421' => '384', # U+4FC5
        '20422' => '385', # U+4FC6
        '20424' => '386', # U+4FC8
        '20425' => '387', # U+4FC9
        '20427' => '388', # U+4FCB
        '20428' => '389', # U+4FCC
        '20429' => '390', # U+4FCD
        '20431' => '391', # U+4FCF
        '20434' => '392', # U+4FD2
        '20444' => '393', # U+4FDC
        '20448' => '394', # U+4FE0
        '20450' => '395', # U+4FE2
        '20464' => '396', # U+4FF0
        '20466' => '397', # U+4FF2
        '20476' => '398', # U+4FFC
        '20477' => '399', # U+4FFD
        '20479' => '400', # U+4FFF
        '20480' => '401', # U+5000
        '20481' => '402', # U+5001
        '20484' => '403', # U+5004
        '20487' => '404', # U+5007
        '20490' => '405', # U+500A
        '20492' => '406', # U+500C
        '20494' => '407', # U+500E
        '20496' => '408', # U+5010
        '20499' => '409', # U+5013
        '20503' => '410', # U+5017
        '20504' => '411', # U+5018
        '20507' => '412', # U+501B
        '20508' => '413', # U+501C
        '20509' => '414', # U+501D
        '20510' => '415', # U+501E
        '20514' => '416', # U+5022
        '20519' => '417', # U+5027
        '20526' => '418', # U+502E
        '20528' => '419', # U+5030
        '20530' => '420', # U+5032
        '20531' => '421', # U+5033
        '20533' => '422', # U+5035
        '20539' => '446', # U+503B
        '20544' => '423', # U+5040
        '20545' => '424', # U+5041
        '20546' => '425', # U+5042
        '20549' => '426', # U+5045
        '20550' => '427', # U+5046
        '20554' => '428', # U+504A
        '20556' => '429', # U+504C
        '20558' => '430', # U+504E
        '20561' => '431', # U+5051
        '20562' => '432', # U+5052
        '20563' => '433', # U+5053
        '20567' => '434', # U+5057
        '20569' => '435', # U+5059
        '20575' => '436', # U+505F
        '20576' => '437', # U+5060
        '20578' => '438', # U+5062
        '20579' => '439', # U+5063
        '20582' => '440', # U+5066
        '20583' => '441', # U+5067
        '20586' => '442', # U+506A
        '20589' => '443', # U+506D
        '20592' => '444', # U+5070
        '20593' => '445', # U+5071
        '20609' => '447', # U+5081
        '20611' => '448', # U+5083
        '20612' => '449', # U+5084
        '20614' => '450', # U+5086
        '20618' => '451', # U+508A
        '20622' => '452', # U+508E
        '20623' => '453', # U+508F
        '20624' => '454', # U+5090
        '20626' => '455', # U+5092
        '20627' => '456', # U+5093
        '20628' => '457', # U+5094
        '20630' => '458', # U+5096
        '20635' => '459', # U+509B
        '20636' => '460', # U+509C
        '20638' => '461', # U+509E
        '20639' => '462', # U+509F
        '20640' => '463', # U+50A0
        '20641' => '464', # U+50A1
        '20642' => '465', # U+50A2
        '20650' => '466', # U+50AA
        '20655' => '467', # U+50AF
        '20656' => '468', # U+50B0
        '20665' => '469', # U+50B9
        '20666' => '470', # U+50BA
        '20669' => '471', # U+50BD
        '20672' => '472', # U+50C0
        '20675' => '473', # U+50C3
        '20676' => '474', # U+50C4
        '20679' => '475', # U+50C7
        '20684' => '476', # U+50CC
        '20686' => '477', # U+50CE
        '20688' => '478', # U+50D0
        '20691' => '479', # U+50D3
        '20692' => '480', # U+50D4
        '20696' => '481', # U+50D8
        '20700' => '482', # U+50DC
        '20701' => '483', # U+50DD
        '20703' => '484', # U+50DF
        '20706' => '485', # U+50E2
        '20708' => '486', # U+50E4
        '20710' => '487', # U+50E6
        '20712' => '488', # U+50E8
        '20713' => '489', # U+50E9
        '20719' => '490', # U+50EF
        '20721' => '491', # U+50F1
        '20722' => '503', # U+50F2
        '20726' => '492', # U+50F6
        '20730' => '493', # U+50FA
        '20734' => '494', # U+50FE
        '20739' => '495', # U+5103
        '20742' => '496', # U+5106
        '20743' => '497', # U+5107
        '20744' => '498', # U+5108
        '20747' => '499', # U+510B
        '20748' => '500', # U+510C
        '20749' => '501', # U+510D
        '20750' => '502', # U+510E
        '20752' => '504', # U+5110
        '20759' => '505', # U+5117
        '20761' => '506', # U+5119
        '20763' => '507', # U+511B
        '20764' => '508', # U+511C
        '20765' => '509', # U+511D
        '20766' => '510', # U+511E
        '20771' => '511', # U+5123
        '20775' => '512', # U+5127
        '20776' => '513', # U+5128
        '20780' => '514', # U+512C
        '20781' => '515', # U+512D
        '20783' => '516', # U+512F
        '20785' => '517', # U+5131
        '20787' => '518', # U+5133
        '20788' => '519', # U+5134
        '20789' => '520', # U+5135
        '20792' => '521', # U+5138
        '20793' => '522', # U+5139
        '20802' => '523', # U+5142
        '20810' => '524', # U+514A
        '20815' => '525', # U+514F
        '20819' => '526', # U+5153
        '20821' => '527', # U+5155
        '20823' => '528', # U+5157
        '20824' => '529', # U+5158
        '20831' => '530', # U+515F
        '20836' => '531', # U+5164
        '20838' => '532', # U+5166
        '20862' => '533', # U+517E
        '20867' => '534', # U+5183
        '20868' => '535', # U+5184
        '20875' => '536', # U+518B
        '20878' => '537', # U+518E
        '20888' => '538', # U+5198
        '20893' => '539', # U+519D
        '20897' => '540', # U+51A1
        '20899' => '541', # U+51A3
        '20909' => '542', # U+51AD
        '20920' => '543', # U+51B8
        '20922' => '544', # U+51BA
        '20924' => '545', # U+51BC
        '20926' => '546', # U+51BE
        '20927' => '547', # U+51BF
        '20930' => '548', # U+51C2
        '20936' => '549', # U+51C8
        '20943' => '550', # U+51CF
        '20945' => '551', # U+51D1
        '20946' => '552', # U+51D2
        '20947' => '553', # U+51D3
        '20949' => '554', # U+51D5
        '20952' => '555', # U+51D8
        '20958' => '556', # U+51DE
        '20962' => '557', # U+51E2
        '20965' => '558', # U+51E5
        '20974' => '559', # U+51EE
        '20978' => '560', # U+51F2
        '20979' => '561', # U+51F3
        '20980' => '562', # U+51F4
        '20983' => '563', # U+51F7
        '20993' => '564', # U+5201
        '20994' => '565', # U+5202
        '20997' => '566', # U+5205
        '21010' => '567', # U+5212
        '21011' => '568', # U+5213
        '21013' => '569', # U+5215
        '21014' => '570', # U+5216
        '21016' => '571', # U+5218
        '21026' => '572', # U+5222
        '21032' => '573', # U+5228
        '21041' => '574', # U+5231
        '21042' => '575', # U+5232
        '21045' => '576', # U+5235
        '21052' => '577', # U+523C
        '21061' => '578', # U+5245
        '21065' => '579', # U+5249
        '21077' => '580', # U+5255
        '21079' => '581', # U+5257
        '21080' => '582', # U+5258
        '21082' => '583', # U+525A
        '21084' => '584', # U+525C
        '21087' => '585', # U+525F
        '21088' => '586', # U+5260
        '21089' => '587', # U+5261
        '21094' => '588', # U+5266
        '21102' => '589', # U+526E
        '21111' => '590', # U+5277
        '21112' => '591', # U+5278
        '21113' => '592', # U+5279
        '21120' => '593', # U+5280
        '21122' => '594', # U+5282
        '21125' => '595', # U+5285
        '21130' => '596', # U+528A
        '21132' => '597', # U+528C
        '21139' => '598', # U+5293
        '21141' => '599', # U+5295
        '21142' => '600', # U+5296
        '21143' => '601', # U+5297
        '21144' => '602', # U+5298
        '21146' => '603', # U+529A
        '21148' => '604', # U+529C
        '21156' => '605', # U+52A4
        '21157' => '606', # U+52A5
        '21158' => '607', # U+52A6
        '21159' => '608', # U+52A7
        '21167' => '609', # U+52AF
        '21168' => '610', # U+52B0
        '21174' => '611', # U+52B6
        '21175' => '612', # U+52B7
        '21176' => '613', # U+52B8
        '21178' => '614', # U+52BA
        '21179' => '615', # U+52BB
        '21181' => '616', # U+52BD
        '21184' => '617', # U+52C0
        '21188' => '618', # U+52C4
        '21190' => '619', # U+52C6
        '21192' => '620', # U+52C8
        '21196' => '621', # U+52CC
        '21199' => '622', # U+52CF
        '21201' => '623', # U+52D1
        '21204' => '624', # U+52D4
        '21206' => '625', # U+52D6
        '21211' => '626', # U+52DB
        '21212' => '627', # U+52DC
        '21217' => '628', # U+52E1
        '21221' => '629', # U+52E5
        '21224' => '630', # U+52E8
        '21225' => '631', # U+52E9
        '21226' => '632', # U+52EA
        '21228' => '633', # U+52EC
        '21232' => '634', # U+52F0
        '21233' => '635', # U+52F1
        '21236' => '636', # U+52F4
        '21238' => '637', # U+52F6
        '21239' => '638', # U+52F7
        '21248' => '639', # U+5300
        '21251' => '640', # U+5303
        '21258' => '641', # U+530A
        '21259' => '642', # U+530B
        '21260' => '643', # U+530C
        '21265' => '644', # U+5311
        '21267' => '645', # U+5313
        '21272' => '646', # U+5318
        '21275' => '647', # U+531B
        '21276' => '648', # U+531C
        '21278' => '649', # U+531E
        '21279' => '650', # U+531F
        '21285' => '651', # U+5325
        '21287' => '652', # U+5327
        '21288' => '653', # U+5328
        '21289' => '654', # U+5329
        '21291' => '655', # U+532B
        '21292' => '656', # U+532C
        '21293' => '657', # U+532D
        '21296' => '658', # U+5330
        '21298' => '659', # U+5332
        '21301' => '660', # U+5335
        '21308' => '661', # U+533C
        '21309' => '662', # U+533D
        '21310' => '663', # U+533E
        '21314' => '664', # U+5342
        '21323' => '666', # U+534B
        '21324' => '665', # U+534C
        '21337' => '667', # U+5359
        '21339' => '668', # U+535B
        '21345' => '669', # U+5361
        '21347' => '670', # U+5363
        '21349' => '671', # U+5365
        '21356' => '672', # U+536C
        '21357' => '673', # U+536D
        '21362' => '674', # U+5372
        '21369' => '675', # U+5379
        '21374' => '676', # U+537E
        '21379' => '677', # U+5383
        '21383' => '678', # U+5387
        '21384' => '679', # U+5388
        '21390' => '680', # U+538E
        '21395' => '681', # U+5393
        '21396' => '682', # U+5394
        '21401' => '683', # U+5399
        '21405' => '684', # U+539D
        '21409' => '685', # U+53A1
        '21412' => '686', # U+53A4
        '21418' => '687', # U+53AA
        '21419' => '688', # U+53AB
        '21423' => '689', # U+53AF
        '21426' => '690', # U+53B2
        '21428' => '691', # U+53B4
        '21429' => '692', # U+53B5
        '21431' => '693', # U+53B7
        '21432' => '694', # U+53B8
        '21434' => '695', # U+53BA
        '21437' => '696', # U+53BD
        '21440' => '697', # U+53C0
        '21445' => '698', # U+53C5
        '21455' => '699', # U+53CF
        '21458' => '700', # U+53D2
        '21459' => '701', # U+53D3
        '21461' => '702', # U+53D5
        '21466' => '703', # U+53DA
        '21469' => '704', # U+53DD
        '21470' => '705', # U+53DE
        '21472' => '706', # U+53E0
        '21478' => '707', # U+53E6
        '21479' => '708', # U+53E7
        '21493' => '709', # U+53F5
        '21506' => '710', # U+5402
        '21523' => '711', # U+5413
        '21530' => '712', # U+541A
        '21537' => '713', # U+5421
        '21543' => '714', # U+5427
        '21544' => '715', # U+5428
        '21546' => '716', # U+542A
        '21551' => '717', # U+542F
        '21553' => '718', # U+5431
        '21556' => '719', # U+5434
        '21557' => '720', # U+5435
        '21571' => '721', # U+5443
        '21572' => '722', # U+5444
        '21575' => '723', # U+5447
        '21581' => '724', # U+544D
        '21583' => '725', # U+544F
        '21598' => '726', # U+545E
        '21602' => '727', # U+5462
        '21604' => '728', # U+5464
        '21606' => '729', # U+5466
        '21607' => '730', # U+5467
        '21609' => '731', # U+5469
        '21611' => '732', # U+546B
        '21613' => '733', # U+546D
        '21614' => '734', # U+546E
        '21620' => '735', # U+5474
        '21631' => '736', # U+547F
        '21633' => '737', # U+5481
        '21635' => '738', # U+5483
        '21637' => '739', # U+5485
        '21640' => '740', # U+5488
        '21641' => '741', # U+5489
        '21645' => '742', # U+548D
        '21649' => '743', # U+5491
        '21653' => '744', # U+5495
        '21654' => '745', # U+5496
        '21660' => '746', # U+549C
        '21663' => '747', # U+549F
        '21665' => '748', # U+54A1
        '21670' => '749', # U+54A6
        '21671' => '750', # U+54A7
        '21673' => '751', # U+54A9
        '21674' => '752', # U+54AA
        '21677' => '753', # U+54AD
        '21678' => '754', # U+54AE
        '21681' => '755', # U+54B1
        '21687' => '756', # U+54B7
        '21689' => '757', # U+54B9
        '21690' => '758', # U+54BA
        '21691' => '759', # U+54BB
        '21695' => '760', # U+54BF
        '21702' => '761', # U+54C6
        '21706' => '762', # U+54CA
        '21709' => '763', # U+54CD
        '21710' => '764', # U+54CE
        '21728' => '765', # U+54E0
        '21738' => '766', # U+54EA
        '21740' => '767', # U+54EC
        '21743' => '768', # U+54EF
        '21750' => '769', # U+54F6
        '21756' => '770', # U+54FC
        '21758' => '771', # U+54FE
        '21759' => '772', # U+54FF
        '21760' => '773', # U+5500
        '21761' => '774', # U+5501
        '21765' => '775', # U+5505
        '21768' => '776', # U+5508
        '21769' => '777', # U+5509
        '21772' => '778', # U+550C
        '21773' => '779', # U+550D
        '21774' => '780', # U+550E
        '21781' => '781', # U+5515
        '21802' => '782', # U+552A
        '21803' => '783', # U+552B
        '21810' => '784', # U+5532
        '21813' => '785', # U+5535
        '21814' => '786', # U+5536
        '21819' => '787', # U+553B
        '21820' => '788', # U+553C
        '21821' => '789', # U+553D
        '21825' => '790', # U+5541
        '21831' => '791', # U+5547
        '21833' => '792', # U+5549
        '21834' => '793', # U+554A
        '21837' => '794', # U+554D
        '21840' => '795', # U+5550
        '21841' => '796', # U+5551
        '21848' => '797', # U+5558
        '21850' => '798', # U+555A
        '21851' => '799', # U+555B
        '21854' => '800', # U+555E
        '21856' => '801', # U+5560
        '21857' => '802', # U+5561
        '21860' => '803', # U+5564
        '21862' => '804', # U+5566
        '21887' => '805', # U+557F
        '21889' => '806', # U+5581
        '21890' => '807', # U+5582
        '21894' => '808', # U+5586
        '21896' => '809', # U+5588
        '21902' => '810', # U+558E
        '21903' => '811', # U+558F
        '21905' => '812', # U+5591
        '21906' => '813', # U+5592
        '21907' => '814', # U+5593
        '21908' => '815', # U+5594
        '21911' => '816', # U+5597
        '21923' => '817', # U+55A3
        '21924' => '818', # U+55A4
        '21933' => '819', # U+55AD
        '21938' => '820', # U+55B2
        '21951' => '821', # U+55BF
        '21953' => '822', # U+55C1
        '21955' => '823', # U+55C3
        '21958' => '824', # U+55C6
        '21961' => '825', # U+55C9
        '21963' => '826', # U+55CB
        '21964' => '827', # U+55CC
        '21966' => '828', # U+55CE
        '21969' => '829', # U+55D1
        '21970' => '830', # U+55D2
        '21971' => '831', # U+55D3
        '21975' => '832', # U+55D7
        '21976' => '833', # U+55D8
        '21979' => '834', # U+55DB
        '21982' => '835', # U+55DE
        '21986' => '836', # U+55E2
        '21993' => '837', # U+55E9
        '22006' => '838', # U+55F6
        '22015' => '839', # U+55FF
        '22021' => '840', # U+5605
        '22024' => '841', # U+5608
        '22026' => '842', # U+560A
        '22029' => '843', # U+560D
        '22030' => '844', # U+560E
        '22031' => '845', # U+560F
        '22032' => '846', # U+5610
        '22033' => '847', # U+5611
        '22034' => '848', # U+5612
        '22041' => '849', # U+5619
        '22060' => '850', # U+562C
        '22064' => '851', # U+5630
        '22067' => '852', # U+5633
        '22069' => '853', # U+5635
        '22071' => '854', # U+5637
        '22073' => '855', # U+5639
        '22075' => '856', # U+563B
        '22076' => '857', # U+563C
        '22077' => '858', # U+563D
        '22079' => '859', # U+563F
        '22080' => '860', # U+5640
        '22081' => '861', # U+5641
        '22083' => '862', # U+5643
        '22084' => '863', # U+5644
        '22086' => '864', # U+5646
        '22089' => '865', # U+5649
        '22091' => '866', # U+564B
        '22093' => '867', # U+564D
        '22095' => '868', # U+564F
        '22100' => '869', # U+5654
        '22110' => '870', # U+565E
        '22112' => '871', # U+5660
        '22113' => '872', # U+5661
        '22114' => '873', # U+5662
        '22115' => '874', # U+5663
        '22118' => '875', # U+5666
        '22121' => '876', # U+5669
        '22125' => '877', # U+566D
        '22127' => '878', # U+566F
        '22129' => '879', # U+5671
        '22130' => '880', # U+5672
        '22133' => '881', # U+5675
        '22148' => '882', # U+5684
        '22149' => '883', # U+5685
        '22152' => '884', # U+5688
        '22155' => '885', # U+568B
        '22156' => '886', # U+568C
        '22165' => '887', # U+5695
        '22169' => '888', # U+5699
        '22170' => '889', # U+569A
        '22173' => '890', # U+569D
        '22174' => '891', # U+569E
        '22175' => '892', # U+569F
        '22182' => '893', # U+56A6
        '22183' => '894', # U+56A7
        '22184' => '895', # U+56A8
        '22185' => '896', # U+56A9
        '22187' => '897', # U+56AB
        '22188' => '898', # U+56AC
        '22189' => '899', # U+56AD
        '22193' => '900', # U+56B1
        '22195' => '901', # U+56B3
        '22199' => '902', # U+56B7
        '22206' => '903', # U+56BE
        '22213' => '904', # U+56C5
        '22217' => '905', # U+56C9
        '22218' => '906', # U+56CA
        '22219' => '907', # U+56CB
        '22220' => '910', # U+56CC
        '22221' => '911', # U+56CD
        '22223' => '908', # U+56CF
        '22224' => '909', # U+56D0
        '22233' => '912', # U+56D9
        '22236' => '913', # U+56DC
        '22237' => '914', # U+56DD
        '22239' => '915', # U+56DF
        '22241' => '916', # U+56E1
        '22244' => '917', # U+56E4
        '22245' => '918', # U+56E5
        '22246' => '919', # U+56E6
        '22247' => '920', # U+56E7
        '22248' => '921', # U+56E8
        '22251' => '923', # U+56EB
        '22253' => '924', # U+56ED
        '22257' => '922', # U+56F1
        '22262' => '925', # U+56F6
        '22263' => '926', # U+56F7
        '22273' => '927', # U+5701
        '22274' => '928', # U+5702
        '22279' => '929', # U+5707
        '22282' => '930', # U+570A
        '22284' => '931', # U+570C
        '22289' => '932', # U+5711
        '22293' => '933', # U+5715
        '22298' => '934', # U+571A
        '22299' => '935', # U+571B
        '22301' => '936', # U+571D
        '22304' => '937', # U+5720
        '22306' => '938', # U+5722
        '22307' => '939', # U+5723
        '22308' => '940', # U+5724
        '22309' => '941', # U+5725
        '22313' => '942', # U+5729
        '22314' => '943', # U+572A
        '22316' => '944', # U+572C
        '22318' => '945', # U+572E
        '22319' => '946', # U+572F
        '22323' => '947', # U+5733
        '22324' => '948', # U+5734
        '22333' => '949', # U+573D
        '22334' => '950', # U+573E
        '22335' => '951', # U+573F
        '22341' => '952', # U+5745
        '22342' => '953', # U+5746
        '22348' => '954', # U+574C
        '22349' => '955', # U+574D
        '22354' => '956', # U+5752
        '22370' => '957', # U+5762
        '22373' => '958', # U+5765
        '22375' => '959', # U+5767
        '22376' => '960', # U+5768
        '22379' => '961', # U+576B
        '22381' => '962', # U+576D
        '22382' => '963', # U+576E
        '22383' => '964', # U+576F
        '22384' => '965', # U+5770
        '22385' => '966', # U+5771
        '22387' => '967', # U+5773
        '22388' => '968', # U+5774
        '22389' => '969', # U+5775
        '22391' => '970', # U+5777
        '22393' => '971', # U+5779
        '22394' => '972', # U+577A
        '22395' => '973', # U+577B
        '22396' => '974', # U+577C
        '22398' => '975', # U+577E
        '22401' => '976', # U+5781
        '22403' => '977', # U+5783
        '22412' => '978', # U+578C
        '22420' => '979', # U+5794
        '22421' => '988', # U+5795
        '22423' => '980', # U+5797
        '22425' => '981', # U+5799
        '22426' => '982', # U+579A
        '22428' => '983', # U+579C
        '22429' => '984', # U+579D
        '22430' => '985', # U+579E
        '22431' => '986', # U+579F
        '22433' => '987', # U+57A1
        '22439' => '989', # U+57A7
        '22440' => '990', # U+57A8
        '22441' => '991', # U+57A9
        '22444' => '992', # U+57AC
        '22456' => '993', # U+57B8
        '22461' => '994', # U+57BD
        '22471' => '995', # U+57C7
        '22472' => '996', # U+57C8
        '22476' => '997', # U+57CC
        '22479' => '998', # U+57CF
        '22485' => '999', # U+57D5
        '22493' => '1000', # U+57DD
        '22494' => '1001', # U+57DE
        '22497' => '1018', # U+57E1
        '22500' => '1002', # U+57E4
        '22502' => '1003', # U+57E6
        '22503' => '1004', # U+57E7
        '22505' => '1005', # U+57E9
        '22509' => '1006', # U+57ED
        '22512' => '1007', # U+57F0
        '22517' => '1008', # U+57F5
        '22518' => '1009', # U+57F6
        '22520' => '1010', # U+57F8
        '22525' => '1011', # U+57FD
        '22526' => '1012', # U+57FE
        '22527' => '1013', # U+57FF
        '22531' => '1014', # U+5803
        '22532' => '1015', # U+5804
        '22536' => '1016', # U+5808
        '22537' => '1017', # U+5809
        '22540' => '1019', # U+580C
        '22541' => '1020', # U+580D
        '22555' => '1021', # U+581B
        '22558' => '1022', # U+581E
        '22559' => '1023', # U+581F
        '22560' => '1024', # U+5820
        '22566' => '1025', # U+5826
        '22567' => '1026', # U+5827
        '22573' => '1027', # U+582D
        '22578' => '1028', # U+5832
        '22585' => '1029', # U+5839
        '22591' => '1030', # U+583F
        '22601' => '1031', # U+5849
        '22604' => '1032', # U+584C
        '22605' => '1033', # U+584D
        '22607' => '1034', # U+584F
        '22608' => '1035', # U+5850
        '22613' => '1036', # U+5855
        '22623' => '1037', # U+585F
        '22625' => '1038', # U+5861
        '22628' => '1039', # U+5864
        '22631' => '1040', # U+5867
        '22632' => '1041', # U+5868
        '22648' => '1042', # U+5878
        '22652' => '1043', # U+587C
        '22655' => '1044', # U+587F
        '22656' => '1045', # U+5880
        '22657' => '1046', # U+5881
        '22663' => '1047', # U+5887
        '22664' => '1048', # U+5888
        '22665' => '1049', # U+5889
        '22666' => '1050', # U+588A
        '22668' => '1051', # U+588C
        '22669' => '1052', # U+588D
        '22671' => '1053', # U+588F
        '22672' => '1054', # U+5890
        '22676' => '1055', # U+5894
        '22678' => '1056', # U+5896
        '22685' => '1057', # U+589D
        '22688' => '1058', # U+58A0
        '22689' => '1059', # U+58A1
        '22690' => '1060', # U+58A2
        '22694' => '1061', # U+58A6
        '22697' => '1062', # U+58A9
        '22705' => '1063', # U+58B1
        '22706' => '1064', # U+58B2
        '22716' => '1066', # U+58BC
        '22722' => '1067', # U+58C2
        '22724' => '1065', # U+58C4
        '22728' => '1068', # U+58C8
        '22733' => '1069', # U+58CD
        '22734' => '1070', # U+58CE
        '22736' => '1071', # U+58D0
        '22738' => '1072', # U+58D2
        '22740' => '1073', # U+58D4
        '22742' => '1074', # U+58D6
        '22746' => '1075', # U+58DA
        '22749' => '1076', # U+58DD
        '22753' => '1077', # U+58E1
        '22754' => '1078', # U+58E2
        '22761' => '1079', # U+58E9
        '22771' => '1080', # U+58F3
        '22789' => '1081', # U+5905
        '22790' => '1082', # U+5906
        '22795' => '1083', # U+590B
        '22796' => '1084', # U+590C
        '22802' => '1085', # U+5912
        '22803' => '1086', # U+5913
        '22804' => '1087', # U+5914
        '22813' => '1089', # U+591D
        '22817' => '1090', # U+5921
        '22819' => '1091', # U+5923
        '22820' => '1092', # U+5924
        '22824' => '1093', # U+5928
        '22831' => '1094', # U+592F
        '22832' => '1095', # U+5930
        '22835' => '1096', # U+5933
        '22837' => '1097', # U+5935
        '22838' => '1098', # U+5936
        '22847' => '1099', # U+593F
        '22851' => '1100', # U+5943
        '22854' => '1101', # U+5946
        '22866' => '1102', # U+5952
        '22867' => '1103', # U+5953
        '22873' => '1104', # U+5959
        '22875' => '1105', # U+595B
        '22877' => '1106', # U+595D
        '22878' => '1107', # U+595E
        '22879' => '1108', # U+595F
        '22881' => '1109', # U+5961
        '22883' => '1110', # U+5963
        '22891' => '1111', # U+596B
        '22893' => '1112', # U+596D
        '22895' => '1113', # U+596F
        '22898' => '1114', # U+5972
        '22901' => '1115', # U+5975
        '22902' => '1116', # U+5976
        '22905' => '1117', # U+5979
        '22907' => '1118', # U+597B
        '22908' => '1119', # U+597C
        '22923' => '1120', # U+598B
        '22924' => '1121', # U+598C
        '22926' => '1122', # U+598E
        '22930' => '1123', # U+5992
        '22933' => '1124', # U+5995
        '22935' => '1125', # U+5997
        '22943' => '1126', # U+599F
        '22948' => '1127', # U+59A4
        '22951' => '1128', # U+59A7
        '22957' => '1129', # U+59AD
        '22958' => '1130', # U+59AE
        '22959' => '1131', # U+59AF
        '22960' => '1132', # U+59B0
        '22963' => '1133', # U+59B3
        '22967' => '1134', # U+59B7
        '22970' => '1135', # U+59BA
        '22972' => '1136', # U+59BC
        '22977' => '1137', # U+59C1
        '22979' => '1138', # U+59C3
        '22980' => '1139', # U+59C4
        '22984' => '1140', # U+59C8
        '22986' => '1141', # U+59CA
        '22989' => '1142', # U+59CD
        '22994' => '1143', # U+59D2
        '23005' => '1144', # U+59DD
        '23006' => '1145', # U+59DE
        '23007' => '1146', # U+59DF
        '23011' => '1147', # U+59E3
        '23012' => '1148', # U+59E4
        '23015' => '1149', # U+59E7
        '23022' => '1150', # U+59EE
        '23023' => '1151', # U+59EF
        '23025' => '1152', # U+59F1
        '23026' => '1153', # U+59F2
        '23028' => '1154', # U+59F4
        '23031' => '1155', # U+59F7
        '23040' => '1156', # U+5A00
        '23044' => '1157', # U+5A04
        '23052' => '1158', # U+5A0C
        '23053' => '1159', # U+5A0D
        '23054' => '1160', # U+5A0E
        '23058' => '1161', # U+5A12
        '23059' => '1162', # U+5A13
        '23070' => '1163', # U+5A1E
        '23075' => '1164', # U+5A23
        '23076' => '1165', # U+5A24
        '23079' => '1166', # U+5A27
        '23080' => '1167', # U+5A28
        '23082' => '1168', # U+5A2A
        '23085' => '1169', # U+5A2D
        '23088' => '1170', # U+5A30
        '23108' => '1171', # U+5A44
        '23109' => '1172', # U+5A45
        '23111' => '1173', # U+5A47
        '23112' => '1174', # U+5A48
        '23116' => '1175', # U+5A4C
        '23120' => '1176', # U+5A50
        '23125' => '1177', # U+5A55
        '23134' => '1178', # U+5A5E
        '23139' => '1179', # U+5A63
        '23141' => '1180', # U+5A65
        '23143' => '1181', # U+5A67
        '23149' => '1182', # U+5A6D
        '23159' => '1183', # U+5A77
        '23162' => '1184', # U+5A7A
        '23163' => '1185', # U+5A7B
        '23166' => '1186', # U+5A7E
        '23179' => '1187', # U+5A8B
        '23184' => '1188', # U+5A90
        '23187' => '1189', # U+5A93
        '23190' => '1190', # U+5A96
        '23193' => '1191', # U+5A99
        '23196' => '1192', # U+5A9C
        '23198' => '1193', # U+5A9E
        '23199' => '1194', # U+5A9F
        '23200' => '1195', # U+5AA0
        '23202' => '1196', # U+5AA2
        '23207' => '1197', # U+5AA7
        '23212' => '1198', # U+5AAC
        '23217' => '1199', # U+5AB1
        '23218' => '1200', # U+5AB2
        '23219' => '1201', # U+5AB3
        '23221' => '1202', # U+5AB5
        '23224' => '1203', # U+5AB8
        '23226' => '1204', # U+5ABA
        '23227' => '1205', # U+5ABB
        '23231' => '1206', # U+5ABF
        '23236' => '1207', # U+5AC4
        '23238' => '1208', # U+5AC6
        '23240' => '1209', # U+5AC8
        '23247' => '1210', # U+5ACF
        '23258' => '1211', # U+5ADA
        '23260' => '1212', # U+5ADC
        '23264' => '1213', # U+5AE0
        '23269' => '1214', # U+5AE5
        '23274' => '1215', # U+5AEA
        '23278' => '1216', # U+5AEE
        '23285' => '1217', # U+5AF5
        '23286' => '1218', # U+5AF6
        '23293' => '1219', # U+5AFD
        '23296' => '1220', # U+5B00
        '23297' => '1221', # U+5B01
        '23304' => '1222', # U+5B08
        '23319' => '1223', # U+5B17
        '23321' => '1225', # U+5B19
        '23323' => '1226', # U+5B1B
        '23325' => '1227', # U+5B1D
        '23329' => '1228', # U+5B21
        '23333' => '1229', # U+5B25
        '23341' => '1230', # U+5B2D
        '23348' => '1224', # U+5B34
        '23352' => '1231', # U+5B38
        '23361' => '1232', # U+5B41
        '23371' => '1233', # U+5B4B
        '23372' => '1234', # U+5B4C
        '23378' => '1235', # U+5B52
        '23382' => '1236', # U+5B56
        '23390' => '1237', # U+5B5E
        '23400' => '1238', # U+5B68
        '23406' => '1239', # U+5B6E
        '23407' => '1240', # U+5B6F
        '23420' => '1241', # U+5B7C
        '23421' => '1242', # U+5B7D
        '23422' => '1243', # U+5B7E
        '23423' => '1244', # U+5B7F
        '23425' => '1245', # U+5B81
        '23428' => '1246', # U+5B84
        '23430' => '1247', # U+5B86
        '23434' => '1248', # U+5B8A
        '23438' => '1249', # U+5B8E
        '23440' => '1250', # U+5B90
        '23441' => '1251', # U+5B91
        '23443' => '1252', # U+5B93
        '23444' => '1253', # U+5B94
        '23446' => '1254', # U+5B96
        '23464' => '1255', # U+5BA8
        '23465' => '1256', # U+5BA9
        '23468' => '1257', # U+5BAC
        '23469' => '1258', # U+5BAD
        '23471' => '1259', # U+5BAF
        '23473' => '1260', # U+5BB1
        '23474' => '1261', # U+5BB2
        '23479' => '1262', # U+5BB7
        '23482' => '1263', # U+5BBA
        '23484' => '1264', # U+5BBC
        '23488' => '1265', # U+5BC0
        '23489' => '1266', # U+5BC1
        '23501' => '1267', # U+5BCD
        '23503' => '1268', # U+5BCF
        '23510' => '1269', # U+5BD6
        '23511' => '1270', # U+5BD7
        '23512' => '1271', # U+5BD8
        '23513' => '1272', # U+5BD9
        '23514' => '1273', # U+5BDA
        '23520' => '1274', # U+5BE0
        '23535' => '1275', # U+5BEF
        '23537' => '1276', # U+5BF1
        '23540' => '1277', # U+5BF4
        '23549' => '1278', # U+5BFD
        '23564' => '1279', # U+5C0C
        '23575' => '1280', # U+5C17
        '23582' => '1281', # U+5C1E
        '23583' => '1282', # U+5C1F
        '23587' => '1283', # U+5C23
        '23590' => '1284', # U+5C26
        '23593' => '1285', # U+5C29
        '23595' => '1286', # U+5C2B
        '23596' => '1287', # U+5C2C
        '23598' => '1288', # U+5C2E
        '23600' => '1289', # U+5C30
        '23602' => '1290', # U+5C32
        '23605' => '1291', # U+5C35
        '23606' => '1292', # U+5C36
        '23641' => '1293', # U+5C59
        '23642' => '1294', # U+5C5A
        '23644' => '1295', # U+5C5C
        '23650' => '1296', # U+5C62
        '23651' => '1297', # U+5C63
        '23655' => '1298', # U+5C67
        '23656' => '1299', # U+5C68
        '23657' => '1300', # U+5C69
        '23661' => '1301', # U+5C6D
        '23664' => '1302', # U+5C70
        '23668' => '1303', # U+5C74
        '23669' => '1304', # U+5C75
        '23674' => '1305', # U+5C7A
        '23675' => '1306', # U+5C7B
        '23676' => '1307', # U+5C7C
        '23677' => '1308', # U+5C7D
        '23687' => '1309', # U+5C87
        '23688' => '1310', # U+5C88
        '23690' => '1311', # U+5C8A
        '23695' => '1312', # U+5C8F
        '23698' => '1313', # U+5C92
        '23709' => '1314', # U+5C9D
        '23711' => '1315', # U+5C9F
        '23712' => '1316', # U+5CA0
        '23714' => '1317', # U+5CA2
        '23715' => '1318', # U+5CA3
        '23718' => '1319', # U+5CA6
        '23722' => '1320', # U+5CAA
        '23730' => '1321', # U+5CB2
        '23732' => '1322', # U+5CB4
        '23733' => '1323', # U+5CB5
        '23738' => '1324', # U+5CBA
        '23753' => '1325', # U+5CC9
        '23755' => '1326', # U+5CCB
        '23762' => '1327', # U+5CD2
        '23767' => '1329', # U+5CD7
        '23773' => '1328', # U+5CDD
        '23790' => '1330', # U+5CEE
        '23793' => '1331', # U+5CF1
        '23794' => '1332', # U+5CF2
        '23796' => '1333', # U+5CF4
        '23809' => '1334', # U+5D01
        '23814' => '1335', # U+5D06
        '23821' => '1336', # U+5D0D
        '23826' => '1337', # U+5D12
        '23843' => '1339', # U+5D23
        '23844' => '1340', # U+5D24
        '23846' => '1341', # U+5D26
        '23847' => '1342', # U+5D27
        '23851' => '1338', # U+5D2B
        '23857' => '1343', # U+5D31
        '23860' => '1344', # U+5D34
        '23865' => '1345', # U+5D39
        '23869' => '1346', # U+5D3D
        '23871' => '1347', # U+5D3F
        '23874' => '1348', # U+5D42
        '23875' => '1349', # U+5D43
        '23878' => '1350', # U+5D46
        '23880' => '1351', # U+5D48
        '23882' => '1355', # U+5D4A
        '23889' => '1353', # U+5D51
        '23893' => '1352', # U+5D55
        '23897' => '1354', # U+5D59
        '23903' => '1356', # U+5D5F
        '23904' => '1357', # U+5D60
        '23905' => '1358', # U+5D61
        '23906' => '1359', # U+5D62
        '23908' => '1360', # U+5D64
        '23914' => '1361', # U+5D6A
        '23917' => '1362', # U+5D6D
        '23920' => '1363', # U+5D70
        '23929' => '1364', # U+5D79
        '23930' => '1365', # U+5D7A
        '23934' => '1366', # U+5D7E
        '23935' => '1367', # U+5D7F
        '23937' => '1368', # U+5D81
        '23939' => '1369', # U+5D83
        '23944' => '1370', # U+5D88
        '23946' => '1371', # U+5D8A
        '23954' => '1372', # U+5D92
        '23955' => '1373', # U+5D93
        '23956' => '1374', # U+5D94
        '23957' => '1375', # U+5D95
        '23961' => '1376', # U+5D99
        '23963' => '1377', # U+5D9B
        '23967' => '1378', # U+5D9F
        '23968' => '1379', # U+5DA0
        '23975' => '1380', # U+5DA7
        '23979' => '1381', # U+5DAB
        '23984' => '1382', # U+5DB0
        '23986' => '5426', # U+5DB2
        '23988' => '1383', # U+5DB4
        '23992' => '1384', # U+5DB8
        '23993' => '1385', # U+5DB9
        '24003' => '1386', # U+5DC3
        '24007' => '1387', # U+5DC7
        '24011' => '1388', # U+5DCB
        '24014' => '1390', # U+5DCE
        '24016' => '1389', # U+5DD0
        '24024' => '1391', # U+5DD8
        '24025' => '1392', # U+5DD9
        '24032' => '1393', # U+5DE0
        '24036' => '1394', # U+5DE4
        '24041' => '1395', # U+5DE9
        '24056' => '1396', # U+5DF8
        '24057' => '1397', # U+5DF9
        '24064' => '1398', # U+5E00
        '24071' => '1399', # U+5E07
        '24077' => '1400', # U+5E0D
        '24082' => '1401', # U+5E12
        '24084' => '1402', # U+5E14
        '24085' => '1403', # U+5E15
        '24088' => '1404', # U+5E18
        '24095' => '1405', # U+5E1F
        '24096' => '1406', # U+5E20
        '24104' => '1408', # U+5E28
        '24110' => '1407', # U+5E2E
        '24114' => '1409', # U+5E32
        '24117' => '1410', # U+5E35
        '24126' => '1411', # U+5E3E
        '24137' => '1414', # U+5E49
        '24139' => '1412', # U+5E4B
        '24144' => '1413', # U+5E50
        '24145' => '1415', # U+5E51
        '24150' => '1416', # U+5E56
        '24152' => '1417', # U+5E58
        '24155' => '1418', # U+5E5B
        '24156' => '1419', # U+5E5C
        '24158' => '1420', # U+5E5E
        '24168' => '1421', # U+5E68
        '24170' => '1422', # U+5E6A
        '24171' => '1423', # U+5E6B
        '24172' => '1424', # U+5E6C
        '24173' => '1425', # U+5E6D
        '24174' => '1426', # U+5E6E
        '24176' => '1427', # U+5E70
        '24192' => '1428', # U+5E80
        '24203' => '1429', # U+5E8B
        '24206' => '1430', # U+5E8E
        '24226' => '1431', # U+5EA2
        '24228' => '1432', # U+5EA4
        '24229' => '1433', # U+5EA5
        '24232' => '1434', # U+5EA8
        '24234' => '1435', # U+5EAA
        '24236' => '1436', # U+5EAC
        '24241' => '1437', # U+5EB1
        '24243' => '1438', # U+5EB3
        '24253' => '1439', # U+5EBD
        '24254' => '1440', # U+5EBE
        '24255' => '1441', # U+5EBF
        '24262' => '1442', # U+5EC6
        '24267' => '1444', # U+5ECB
        '24268' => '1443', # U+5ECC
        '24270' => '1445', # U+5ECE
        '24273' => '1446', # U+5ED1
        '24274' => '1447', # U+5ED2
        '24276' => '1448', # U+5ED4
        '24277' => '1449', # U+5ED5
        '24284' => '1450', # U+5EDC
        '24286' => '1451', # U+5EDE
        '24293' => '1452', # U+5EE5
        '24299' => '1453', # U+5EEB
        '24322' => '1454', # U+5F02
        '24326' => '1455', # U+5F06
        '24327' => '1456', # U+5F07
        '24328' => '1457', # U+5F08
        '24334' => '1458', # U+5F0E
        '24345' => '1459', # U+5F19
        '24348' => '1460', # U+5F1C
        '24349' => '1461', # U+5F1D
        '24353' => '1462', # U+5F21
        '24354' => '1463', # U+5F22
        '24355' => '1464', # U+5F23
        '24356' => '1465', # U+5F24
        '24360' => '1466', # U+5F28
        '24363' => '1467', # U+5F2B
        '24364' => '1468', # U+5F2C
        '24366' => '1469', # U+5F2E
        '24368' => '1470', # U+5F30
        '24372' => '1471', # U+5F34
        '24374' => '1472', # U+5F36
        '24379' => '1473', # U+5F3B
        '24381' => '1474', # U+5F3D
        '24383' => '1475', # U+5F3F
        '24384' => '1476', # U+5F40
        '24388' => '1477', # U+5F44
        '24389' => '1478', # U+5F45
        '24391' => '1479', # U+5F47
        '24397' => '1480', # U+5F4D
        '24400' => '1481', # U+5F50
        '24404' => '1482', # U+5F54
        '24408' => '1483', # U+5F58
        '24411' => '1484', # U+5F5B
        '24416' => '1485', # U+5F60
        '24419' => '1486', # U+5F63
        '24420' => '1487', # U+5F64
        '24423' => '1488', # U+5F67
        '24431' => '1489', # U+5F6F
        '24434' => '1490', # U+5F72
        '24436' => '1491', # U+5F74
        '24437' => '1492', # U+5F75
        '24440' => '1493', # U+5F78
        '24442' => '1494', # U+5F7A
        '24445' => '1495', # U+5F7D
        '24446' => '1496', # U+5F7E
        '24457' => '1497', # U+5F89
        '24461' => '1498', # U+5F8D
        '24463' => '1499', # U+5F8F
        '24470' => '1500', # U+5F96
        '24476' => '1501', # U+5F9C
        '24477' => '1502', # U+5F9D
        '24482' => '1503', # U+5FA2
        '24484' => '1506', # U+5FA4
        '24487' => '1504', # U+5FA7
        '24491' => '1505', # U+5FAB
        '24492' => '1507', # U+5FAC
        '24495' => '1508', # U+5FAF
        '24496' => '1509', # U+5FB0
        '24497' => '1510', # U+5FB1
        '24504' => '1511', # U+5FB8
        '24516' => '1512', # U+5FC4
        '24519' => '1513', # U+5FC7
        '24520' => '1514', # U+5FC8
        '24521' => '1515', # U+5FC9
        '24523' => '1516', # U+5FCB
        '24528' => '1517', # U+5FD0
        '24529' => '1518', # U+5FD1
        '24530' => '1519', # U+5FD2
        '24531' => '1520', # U+5FD3
        '24532' => '1521', # U+5FD4
        '24542' => '1522', # U+5FDE
        '24545' => '1523', # U+5FE1
        '24546' => '1524', # U+5FE2
        '24552' => '1525', # U+5FE8
        '24553' => '1526', # U+5FE9
        '24554' => '1527', # U+5FEA
        '24556' => '1528', # U+5FEC
        '24557' => '1529', # U+5FED
        '24558' => '1530', # U+5FEE
        '24559' => '1531', # U+5FEF
        '24562' => '1532', # U+5FF2
        '24563' => '1533', # U+5FF3
        '24566' => '1534', # U+5FF6
        '24570' => '1535', # U+5FFA
        '24572' => '1536', # U+5FFC
        '24583' => '1537', # U+6007
        '24586' => '1538', # U+600A
        '24589' => '1539', # U+600D
        '24595' => '1540', # U+6013
        '24596' => '1541', # U+6014
        '24599' => '1542', # U+6017
        '24600' => '1543', # U+6018
        '24602' => '1544', # U+601A
        '24607' => '1545', # U+601F
        '24612' => '1546', # U+6024
        '24621' => '1547', # U+602D
        '24627' => '1548', # U+6033
        '24629' => '1549', # U+6035
        '24640' => '1550', # U+6040
        '24647' => '1551', # U+6047
        '24648' => '1552', # U+6048
        '24649' => '1553', # U+6049
        '24652' => '1554', # U+604C
        '24657' => '1555', # U+6051
        '24660' => '1556', # U+6054
        '24662' => '1557', # U+6056
        '24663' => '1558', # U+6057
        '24669' => '1559', # U+605D
        '24673' => '1560', # U+6061
        '24679' => '1561', # U+6067
        '24689' => '1562', # U+6071
        '24702' => '1563', # U+607E
        '24703' => '1564', # U+607F
        '24706' => '1565', # U+6082
        '24710' => '1566', # U+6086
        '24712' => '1567', # U+6088
        '24714' => '1568', # U+608A
        '24718' => '1569', # U+608E
        '24721' => '1570', # U+6091
        '24723' => '1571', # U+6093
        '24725' => '1572', # U+6095
        '24728' => '1573', # U+6098
        '24733' => '1574', # U+609D
        '24734' => '1575', # U+609E
        '24738' => '1576', # U+60A2
        '24740' => '1577', # U+60A4
        '24741' => '1578', # U+60A5
        '24744' => '1579', # U+60A8
        '24752' => '1580', # U+60B0
        '24753' => '1581', # U+60B1
        '24759' => '1582', # U+60B7
        '24763' => '1583', # U+60BB
        '24766' => '1584', # U+60BE
        '24770' => '1585', # U+60C2
        '24772' => '1586', # U+60C4
        '24776' => '1587', # U+60C8
        '24777' => '1588', # U+60C9
        '24778' => '1589', # U+60CA
        '24779' => '1590', # U+60CB
        '24782' => '1591', # U+60CE
        '24783' => '1592', # U+60CF
        '24788' => '1593', # U+60D4
        '24789' => '1594', # U+60D5
        '24793' => '1595', # U+60D9
        '24795' => '1596', # U+60DB
        '24797' => '1597', # U+60DD
        '24798' => '1598', # U+60DE
        '24802' => '1599', # U+60E2
        '24805' => '1600', # U+60E5
        '24818' => '1601', # U+60F2
        '24821' => '1602', # U+60F5
        '24824' => '1603', # U+60F8
        '24828' => '1604', # U+60FC
        '24829' => '1605', # U+60FD
        '24834' => '1606', # U+6102
        '24839' => '1607', # U+6107
        '24842' => '1608', # U+610A
        '24844' => '1609', # U+610C
        '24848' => '1610', # U+6110
        '24849' => '1611', # U+6111
        '24850' => '1612', # U+6112
        '24851' => '1613', # U+6113
        '24852' => '1614', # U+6114
        '24854' => '1615', # U+6116
        '24855' => '1616', # U+6117
        '24857' => '1617', # U+6119
        '24860' => '1618', # U+611C
        '24862' => '1619', # U+611E
        '24866' => '1620', # U+6122
        '24874' => '1621', # U+612A
        '24875' => '1622', # U+612B
        '24880' => '1623', # U+6130
        '24881' => '1624', # U+6131
        '24885' => '1625', # U+6135
        '24886' => '1626', # U+6136
        '24887' => '1627', # U+6137
        '24889' => '1628', # U+6139
        '24897' => '1629', # U+6141
        '24901' => '1630', # U+6145
        '24902' => '1631', # U+6146
        '24905' => '1632', # U+6149
        '24926' => '1633', # U+615E
        '24928' => '1634', # U+6160
        '24940' => '1635', # U+616C
        '24946' => '1636', # U+6172
        '24952' => '1637', # U+6178
        '24955' => '1638', # U+617B
        '24956' => '1639', # U+617C
        '24959' => '1640', # U+617F
        '24960' => '1641', # U+6180
        '24961' => '1642', # U+6181
        '24963' => '1643', # U+6183
        '24964' => '1644', # U+6184
        '24971' => '1645', # U+618B
        '24973' => '1646', # U+618D
        '24978' => '1647', # U+6192
        '24979' => '1648', # U+6193
        '24983' => '1649', # U+6197
        '24984' => '1650', # U+6198
        '24988' => '1651', # U+619C
        '24989' => '1652', # U+619D
        '24991' => '1653', # U+619F
        '24992' => '1654', # U+61A0
        '24997' => '1655', # U+61A5
        '25000' => '1656', # U+61A8
        '25002' => '1657', # U+61AA
        '25005' => '1658', # U+61AD
        '25016' => '1659', # U+61B8
        '25017' => '1660', # U+61B9
        '25020' => '1661', # U+61BC
        '25024' => '1662', # U+61C0
        '25025' => '1663', # U+61C1
        '25026' => '1664', # U+61C2
        '25038' => '1665', # U+61CE
        '25039' => '1666', # U+61CF
        '25045' => '1667', # U+61D5
        '25052' => '1668', # U+61DC
        '25053' => '1669', # U+61DD
        '25054' => '1670', # U+61DE
        '25055' => '1671', # U+61DF
        '25057' => '1672', # U+61E1
        '25058' => '1673', # U+61E2
        '25061' => '1676', # U+61E5
        '25063' => '1674', # U+61E7
        '25065' => '1675', # U+61E9
        '25068' => '1677', # U+61EC
        '25069' => '1678', # U+61ED
        '25071' => '1679', # U+61EF
        '25089' => '1680', # U+6201
        '25091' => '1681', # U+6203
        '25092' => '1682', # U+6204
        '25095' => '1683', # U+6207
        '25107' => '1684', # U+6213
        '25109' => '1685', # U+6215
        '25116' => '1686', # U+621C
        '25120' => '1687', # U+6220
        '25122' => '1688', # U+6222
        '25123' => '1689', # U+6223
        '25127' => '1690', # U+6227
        '25129' => '1691', # U+6229
        '25131' => '1692', # U+622B
        '25145' => '1693', # U+6239
        '25149' => '1694', # U+623D
        '25154' => '1695', # U+6242
        '25155' => '1696', # U+6243
        '25156' => '1697', # U+6244
        '25158' => '1698', # U+6246
        '25164' => '1699', # U+624C
        '25168' => '1700', # U+6250
        '25169' => '1701', # U+6251
        '25170' => '1702', # U+6252
        '25172' => '1703', # U+6254
        '25174' => '1704', # U+6256
        '25178' => '1705', # U+625A
        '25180' => '1706', # U+625C
        '25188' => '1707', # U+6264
        '25197' => '1708', # U+626D
        '25199' => '1709', # U+626F
        '25203' => '1710', # U+6273
        '25210' => '1711', # U+627A
        '25213' => '1712', # U+627D
        '25229' => '1713', # U+628D
        '25230' => '1714', # U+628E
        '25231' => '1715', # U+628F
        '25232' => '1716', # U+6290
        '25254' => '1717', # U+62A6
        '25256' => '1718', # U+62A8
        '25267' => '1719', # U+62B3
        '25270' => '1720', # U+62B6
        '25271' => '1721', # U+62B7
        '25274' => '1722', # U+62BA
        '25278' => '1723', # U+62BE
        '25279' => '1724', # U+62BF
        '25284' => '1725', # U+62C4
        '25294' => '1726', # U+62CE
        '25301' => '1727', # U+62D5
        '25302' => '1728', # U+62D6
        '25306' => '1729', # U+62DA
        '25322' => '1730', # U+62EA
        '25330' => '1731', # U+62F2
        '25332' => '1732', # U+62F4
        '25340' => '1733', # U+62FC
        '25341' => '1734', # U+62FD
        '25347' => '1735', # U+6303
        '25348' => '1736', # U+6304
        '25354' => '1737', # U+630A
        '25355' => '1738', # U+630B
        '25357' => '1739', # U+630D
        '25360' => '1740', # U+6310
        '25363' => '1741', # U+6313
        '25366' => '1742', # U+6316
        '25368' => '1743', # U+6318
        '25385' => '1744', # U+6329
        '25386' => '1745', # U+632A
        '25389' => '1746', # U+632D
        '25397' => '1747', # U+6335
        '25398' => '1748', # U+6336
        '25401' => '1749', # U+6339
        '25404' => '1750', # U+633C
        '25409' => '1751', # U+6341
        '25410' => '1752', # U+6342
        '25411' => '1753', # U+6343
        '25412' => '1754', # U+6344
        '25414' => '1755', # U+6346
        '25418' => '1756', # U+634A
        '25419' => '1757', # U+634B
        '25422' => '1758', # U+634E
        '25426' => '1759', # U+6352
        '25427' => '1760', # U+6353
        '25428' => '1761', # U+6354
        '25432' => '1762', # U+6358
        '25435' => '1763', # U+635B
        '25445' => '1764', # U+6365
        '25446' => '1765', # U+6366
        '25452' => '1766', # U+636C
        '25453' => '1767', # U+636D
        '25457' => '1768', # U+6371
        '25460' => '1769', # U+6374
        '25461' => '1770', # U+6375
        '25464' => '1771', # U+6378
        '25468' => '1772', # U+637C
        '25469' => '1773', # U+637D
        '25471' => '1774', # U+637F
        '25474' => '1775', # U+6382
        '25476' => '1776', # U+6384
        '25479' => '1777', # U+6387
        '25482' => '1778', # U+638A
        '25488' => '1779', # U+6390
        '25492' => '1780', # U+6394
        '25493' => '1781', # U+6395
        '25497' => '1782', # U+6399
        '25498' => '1783', # U+639A
        '25502' => '1784', # U+639E
        '25508' => '1785', # U+63A4
        '25510' => '1786', # U+63A6
        '25517' => '1787', # U+63AD
        '25518' => '1788', # U+63AE
        '25519' => '1789', # U+63AF
        '25533' => '1790', # U+63BD
        '25537' => '1791', # U+63C1
        '25541' => '1792', # U+63C5
        '25544' => '1793', # U+63C8
        '25550' => '1794', # U+63CE
        '25553' => '1795', # U+63D1
        '25555' => '1796', # U+63D3
        '25556' => '1797', # U+63D4
        '25557' => '1798', # U+63D5
        '25564' => '1799', # U+63DC
        '25568' => '1800', # U+63E0
        '25573' => '1801', # U+63E5
        '25578' => '1802', # U+63EA
        '25580' => '1803', # U+63EC
        '25586' => '1804', # U+63F2
        '25587' => '1805', # U+63F3
        '25589' => '1806', # U+63F5
        '25592' => '1807', # U+63F8
        '25593' => '1808', # U+63F9
        '25609' => '1809', # U+6409
        '25610' => '1810', # U+640A
        '25616' => '1811', # U+6410
        '25618' => '1812', # U+6412
        '25620' => '1813', # U+6414
        '25624' => '1814', # U+6418
        '25630' => '1815', # U+641E
        '25632' => '1816', # U+6420
        '25634' => '1817', # U+6422
        '25636' => '1818', # U+6424
        '25637' => '1819', # U+6425
        '25641' => '1820', # U+6429
        '25642' => '1821', # U+642A
        '25647' => '1822', # U+642F
        '25648' => '1823', # U+6430
        '25653' => '1824', # U+6435
        '25661' => '1825', # U+643D
        '25663' => '1826', # U+643F
        '25675' => '1827', # U+644B
        '25679' => '1828', # U+644F
        '25681' => '1829', # U+6451
        '25682' => '1830', # U+6452
        '25683' => '1831', # U+6453
        '25684' => '1832', # U+6454
        '25690' => '1833', # U+645A
        '25691' => '1834', # U+645B
        '25692' => '1835', # U+645C
        '25693' => '1836', # U+645D
        '25695' => '1837', # U+645F
        '25696' => '1838', # U+6460
        '25697' => '1839', # U+6461
        '25699' => '1840', # U+6463
        '25709' => '1841', # U+646D
        '25715' => '1842', # U+6473
        '25716' => '1843', # U+6474
        '25723' => '1844', # U+647B
        '25725' => '1845', # U+647D
        '25733' => '1846', # U+6485
        '25735' => '1847', # U+6487
        '25743' => '1848', # U+648F
        '25744' => '1849', # U+6490
        '25745' => '1850', # U+6491
        '25752' => '1851', # U+6498
        '25753' => '1852', # U+6499
        '25755' => '1853', # U+649B
        '25757' => '1854', # U+649D
        '25759' => '1855', # U+649F
        '25761' => '1856', # U+64A1
        '25763' => '1857', # U+64A3
        '25766' => '1858', # U+64A6
        '25768' => '1859', # U+64A8
        '25772' => '1860', # U+64AC
        '25779' => '1861', # U+64B3
        '25789' => '1862', # U+64BD
        '25790' => '1863', # U+64BE
        '25791' => '1864', # U+64BF
        '25796' => '1865', # U+64C4
        '25801' => '1866', # U+64C9
        '25802' => '1867', # U+64CA
        '25803' => '1868', # U+64CB
        '25804' => '1869', # U+64CC
        '25806' => '1870', # U+64CE
        '25808' => '1871', # U+64D0
        '25809' => '1872', # U+64D1
        '25813' => '1873', # U+64D5
        '25815' => '1874', # U+64D7
        '25828' => '1875', # U+64E4
        '25829' => '1876', # U+64E5
        '25833' => '1877', # U+64E9
        '25834' => '1878', # U+64EA
        '25837' => '1879', # U+64ED
        '25840' => '1880', # U+64F0
        '25845' => '1881', # U+64F5
        '25847' => '1882', # U+64F7
        '25851' => '1883', # U+64FB
        '25855' => '1884', # U+64FF
        '25857' => '1885', # U+6501
        '25860' => '1886', # U+6504
        '25864' => '1887', # U+6508
        '25865' => '1888', # U+6509
        '25866' => '1889', # U+650A
        '25871' => '1890', # U+650F
        '25875' => '1891', # U+6513
        '25876' => '1892', # U+6514
        '25878' => '1893', # U+6516
        '25881' => '1894', # U+6519
        '25883' => '1895', # U+651B
        '25886' => '1896', # U+651E
        '25887' => '1897', # U+651F
        '25890' => '1898', # U+6522
        '25894' => '1899', # U+6526
        '25897' => '1900', # U+6529
        '25902' => '1901', # U+652E
        '25905' => '1902', # U+6531
        '25914' => '1903', # U+653A
        '25916' => '1904', # U+653C
        '25917' => '1905', # U+653D
        '25923' => '1906', # U+6543
        '25927' => '1907', # U+6547
        '25929' => '1908', # U+6549
        '25936' => '1909', # U+6550
        '25938' => '1910', # U+6552
        '25940' => '1911', # U+6554
        '25951' => '1912', # U+655F
        '25952' => '1913', # U+6560
        '25959' => '1914', # U+6567
        '25963' => '1915', # U+656B
        '25978' => '1916', # U+657A
        '25981' => '1917', # U+657D
        '25985' => '1918', # U+6581
        '25989' => '1919', # U+6585
        '25994' => '1920', # U+658A
        '26002' => '1921', # U+6592
        '26005' => '1922', # U+6595
        '26008' => '1923', # U+6598
        '26013' => '1924', # U+659D
        '26016' => '1925', # U+65A0
        '26019' => '1926', # U+65A3
        '26022' => '1927', # U+65A6
        '26030' => '1928', # U+65AE
        '26034' => '1929', # U+65B2
        '26035' => '1930', # U+65B3
        '26036' => '1931', # U+65B4
        '26047' => '1932', # U+65BF
        '26050' => '1933', # U+65C2
        '26056' => '1934', # U+65C8
        '26057' => '1935', # U+65C9
        '26062' => '1936', # U+65CE
        '26064' => '1937', # U+65D0
        '26068' => '1938', # U+65D4
        '26070' => '1939', # U+65D6
        '26072' => '1940', # U+65D8
        '26079' => '1941', # U+65DF
        '26096' => '1942', # U+65F0
        '26098' => '1943', # U+65F2
        '26100' => '1944', # U+65F4
        '26101' => '1945', # U+65F5
        '26105' => '1946', # U+65F9
        '26110' => '1947', # U+65FE
        '26111' => '1948', # U+65FF
        '26112' => '1949', # U+6600
        '26116' => '1950', # U+6604
        '26120' => '1951', # U+6608
        '26121' => '1952', # U+6609
        '26125' => '1953', # U+660D
        '26129' => '1954', # U+6611
        '26130' => '1955', # U+6612
        '26133' => '1956', # U+6615
        '26134' => '1957', # U+6616
        '26141' => '1958', # U+661D
        '26142' => '1959', # U+661E
        '26145' => '1960', # U+6621
        '26146' => '1961', # U+6622
        '26147' => '1962', # U+6623
        '26148' => '1963', # U+6624
        '26150' => '1964', # U+6626
        '26153' => '1965', # U+6629
        '26154' => '1966', # U+662A
        '26155' => '1967', # U+662B
        '26156' => '1968', # U+662C
        '26158' => '1969', # U+662E
        '26160' => '1970', # U+6630
        '26161' => '1971', # U+6631
        '26163' => '1972', # U+6633
        '26167' => '1974', # U+6637
        '26169' => '1973', # U+6639
        '26176' => '1975', # U+6640
        '26181' => '1976', # U+6645
        '26182' => '1977', # U+6646
        '26186' => '1978', # U+664A
        '26188' => '1979', # U+664C
        '26190' => '1981', # U+664E
        '26193' => '1980', # U+6651
        '26199' => '1982', # U+6657
        '26200' => '1983', # U+6658
        '26201' => '1984', # U+6659
        '26203' => '1985', # U+665B
        '26204' => '1986', # U+665C
        '26208' => '1987', # U+6660
        '26209' => '1988', # U+6661
        '26218' => '1990', # U+666A
        '26219' => '1991', # U+666B
        '26220' => '1992', # U+666C
        '26227' => '1994', # U+6673
        '26229' => '1995', # U+6675
        '26231' => '1997', # U+6677
        '26232' => '1998', # U+6678
        '26233' => '1999', # U+6679
        '26235' => '2000', # U+667B
        '26236' => '2002', # U+667C
        '26238' => '1993', # U+667E
        '26239' => '1996', # U+667F
        '26240' => '2001', # U+6680
        '26251' => '2003', # U+668B
        '26252' => '2004', # U+668C
        '26253' => '2005', # U+668D
        '26256' => '2006', # U+6690
        '26258' => '2007', # U+6692
        '26265' => '2008', # U+6699
        '26266' => '2009', # U+669A
        '26267' => '2010', # U+669B
        '26268' => '2011', # U+669C
        '26271' => '2012', # U+669F
        '26272' => '2013', # U+66A0
        '26276' => '2014', # U+66A4
        '26285' => '2015', # U+66AD
        '26289' => '2016', # U+66B1
        '26290' => '2017', # U+66B2
        '26293' => '2018', # U+66B5
        '26299' => '2019', # U+66BB
        '26303' => '2020', # U+66BF
        '26304' => '2021', # U+66C0
        '26306' => '2022', # U+66C2
        '26307' => '2023', # U+66C3
        '26312' => '2024', # U+66C8
        '26316' => '2025', # U+66CC
        '26318' => '2026', # U+66CE
        '26319' => '2027', # U+66CF
        '26324' => '2028', # U+66D4
        '26331' => '2029', # U+66DB
        '26335' => '2030', # U+66DF
        '26344' => '2031', # U+66E8
        '26347' => '2032', # U+66EB
        '26348' => '2033', # U+66EC
        '26350' => '2034', # U+66EE
        '26362' => '2035', # U+66FA
        '26363' => '1989', # U+66FB
        '26373' => '2036', # U+6705
        '26375' => '2037', # U+6707
        '26382' => '2038', # U+670E
        '26387' => '2039', # U+6713
        '26393' => '2040', # U+6719
        '26396' => '2041', # U+671C
        '26400' => '2042', # U+6720
        '26402' => '2043', # U+6722
        '26419' => '2044', # U+6733
        '26430' => '2045', # U+673E
        '26437' => '2046', # U+6745
        '26439' => '2047', # U+6747
        '26440' => '2048', # U+6748
        '26444' => '2049', # U+674C
        '26452' => '2050', # U+6754
        '26453' => '2051', # U+6755
        '26461' => '2052', # U+675D
        '26470' => '2053', # U+6766
        '26476' => '2054', # U+676C
        '26478' => '2055', # U+676E
        '26484' => '2056', # U+6774
        '26486' => '2057', # U+6776
        '26491' => '2058', # U+677B
        '26497' => '2059', # U+6781
        '26500' => '2060', # U+6784
        '26510' => '2061', # U+678E
        '26511' => '2062', # U+678F
        '26513' => '2063', # U+6791
        '26515' => '2064', # U+6793
        '26518' => '2065', # U+6796
        '26520' => '2066', # U+6798
        '26521' => '2067', # U+6799
        '26523' => '2068', # U+679B
        '26544' => '2069', # U+67B0
        '26545' => '2070', # U+67B1
        '26546' => '2071', # U+67B2
        '26549' => '2072', # U+67B5
        '26555' => '2073', # U+67BB
        '26556' => '2074', # U+67BC
        '26557' => '2075', # U+67BD
        '26560' => '2077', # U+67C0
        '26562' => '2078', # U+67C2
        '26563' => '2079', # U+67C3
        '26565' => '2080', # U+67C5
        '26568' => '2081', # U+67C8
        '26569' => '2082', # U+67C9
        '26578' => '2083', # U+67D2
        '26583' => '2084', # U+67D7
        '26585' => '2085', # U+67D9
        '26588' => '2086', # U+67DC
        '26593' => '2087', # U+67E1
        '26598' => '2088', # U+67E6
        '26608' => '2089', # U+67F0
        '26610' => '2090', # U+67F2
        '26614' => '2091', # U+67F6
        '26615' => '2092', # U+67F7
        '26617' => '2076', # U+67F9
        '26644' => '2094', # U+6814
        '26649' => '2095', # U+6819
        '26653' => '2096', # U+681D
        '26655' => '2097', # U+681F
        '26663' => '2099', # U+6827
        '26664' => '2098', # U+6828
        '26668' => '2100', # U+682C
        '26669' => '2101', # U+682D
        '26671' => '2102', # U+682F
        '26672' => '2103', # U+6830
        '26673' => '2104', # U+6831
        '26675' => '2105', # U+6833
        '26683' => '2106', # U+683B
        '26687' => '2107', # U+683F
        '26692' => '2108', # U+6844
        '26693' => '2109', # U+6845
        '26698' => '2110', # U+684A
        '26700' => '2111', # U+684C
        '26706' => '2093', # U+6852
        '26709' => '2112', # U+6855
        '26711' => '2113', # U+6857
        '26712' => '2114', # U+6858
        '26715' => '2115', # U+685B
        '26731' => '2116', # U+686B
        '26734' => '2117', # U+686E
        '26735' => '2118', # U+686F
        '26736' => '2119', # U+6870
        '26737' => '2120', # U+6871
        '26738' => '2121', # U+6872
        '26741' => '2122', # U+6875
        '26745' => '2123', # U+6879
        '26746' => '2124', # U+687A
        '26747' => '2125', # U+687B
        '26748' => '2126', # U+687C
        '26754' => '2127', # U+6882
        '26756' => '2128', # U+6884
        '26758' => '2129', # U+6886
        '26760' => '2130', # U+6888
        '26774' => '2131', # U+6896
        '26776' => '2132', # U+6898
        '26778' => '2133', # U+689A
        '26780' => '2134', # U+689C
        '26785' => '2135', # U+68A1
        '26787' => '2136', # U+68A3
        '26789' => '2137', # U+68A5
        '26793' => '2138', # U+68A9
        '26794' => '2139', # U+68AA
        '26798' => '2140', # U+68AE
        '26802' => '2141', # U+68B2
        '26811' => '2142', # U+68BB
        '26821' => '2143', # U+68C5
        '26824' => '2144', # U+68C8
        '26828' => '2145', # U+68CC
        '26831' => '2146', # U+68CF
        '26832' => '2147', # U+68D0
        '26833' => '2148', # U+68D1
        '26835' => '2149', # U+68D3
        '26838' => '2150', # U+68D6
        '26841' => '2151', # U+68D9
        '26844' => '2152', # U+68DC
        '26845' => '2153', # U+68DD
        '26853' => '2154', # U+68E5
        '26856' => '2155', # U+68E8
        '26858' => '2156', # U+68EA
        '26859' => '2157', # U+68EB
        '26860' => '2158', # U+68EC
        '26861' => '2159', # U+68ED
        '26864' => '2160', # U+68F0
        '26865' => '2161', # U+68F1
        '26869' => '2162', # U+68F5
        '26870' => '2163', # U+68F6
        '26875' => '2164', # U+68FB
        '26876' => '2165', # U+68FC
        '26877' => '2166', # U+68FD
        '26886' => '2167', # U+6906
        '26889' => '2168', # U+6909
        '26890' => '2169', # U+690A
        '26896' => '2170', # U+6910
        '26897' => '2171', # U+6911
        '26899' => '2172', # U+6913
        '26902' => '2173', # U+6916
        '26903' => '2174', # U+6917
        '26929' => '2175', # U+6931
        '26931' => '2176', # U+6933
        '26933' => '2177', # U+6935
        '26936' => '2178', # U+6938
        '26939' => '2179', # U+693B
        '26946' => '2180', # U+6942
        '26949' => '2181', # U+6945
        '26953' => '2182', # U+6949
        '26958' => '2183', # U+694E
        '26967' => '2184', # U+6957
        '26971' => '2185', # U+695B
        '26979' => '2186', # U+6963
        '26980' => '2187', # U+6964
        '26981' => '2188', # U+6965
        '26982' => '2189', # U+6966
        '26984' => '2190', # U+6968
        '26985' => '2191', # U+6969
        '26988' => '2192', # U+696C
        '26992' => '2193', # U+6970
        '26993' => '2194', # U+6971
        '26994' => '2195', # U+6972
        '27002' => '2196', # U+697A
        '27003' => '2197', # U+697B
        '27007' => '2198', # U+697F
        '27008' => '2199', # U+6980
        '27021' => '2200', # U+698D
        '27026' => '2201', # U+6992
        '27030' => '2202', # U+6996
        '27032' => '2203', # U+6998
        '27041' => '2204', # U+69A1
        '27045' => '2205', # U+69A5
        '27046' => '2206', # U+69A6
        '27048' => '2207', # U+69A8
        '27051' => '2208', # U+69AB
        '27053' => '2209', # U+69AD
        '27055' => '2210', # U+69AF
        '27063' => '2211', # U+69B7
        '27064' => '2212', # U+69B8
        '27066' => '2213', # U+69BA
        '27068' => '2214', # U+69BC
        '27077' => '2215', # U+69C5
        '27080' => '2216', # U+69C8
        '27089' => '2217', # U+69D1
        '27094' => '2218', # U+69D6
        '27095' => '2219', # U+69D7
        '27106' => '2220', # U+69E2
        '27109' => '2221', # U+69E5
        '27118' => '2222', # U+69EE
        '27119' => '2223', # U+69EF
        '27121' => '2224', # U+69F1
        '27123' => '2225', # U+69F3
        '27125' => '2226', # U+69F5
        '27134' => '2227', # U+69FE
        '27136' => '2228', # U+6A00
        '27137' => '2229', # U+6A01
        '27139' => '2230', # U+6A03
        '27151' => '2231', # U+6A0F
        '27153' => '2232', # U+6A11
        '27157' => '2233', # U+6A15
        '27162' => '2234', # U+6A1A
        '27165' => '2235', # U+6A1D
        '27168' => '2236', # U+6A20
        '27172' => '2237', # U+6A24
        '27176' => '2238', # U+6A28
        '27184' => '2239', # U+6A30
        '27186' => '2240', # U+6A32
        '27188' => '2241', # U+6A34
        '27191' => '2242', # U+6A37
        '27195' => '2243', # U+6A3B
        '27198' => '2244', # U+6A3E
        '27199' => '2245', # U+6A3F
        '27205' => '2246', # U+6A45
        '27206' => '2247', # U+6A46
        '27209' => '2248', # U+6A49
        '27210' => '2249', # U+6A4A
        '27214' => '2250', # U+6A4E
        '27216' => '2251', # U+6A50
        '27217' => '2252', # U+6A51
        '27218' => '2253', # U+6A52
        '27221' => '2254', # U+6A55
        '27222' => '2255', # U+6A56
        '27227' => '2256', # U+6A5B
        '27236' => '2257', # U+6A64
        '27239' => '2258', # U+6A67
        '27242' => '2259', # U+6A6A
        '27249' => '2260', # U+6A71
        '27251' => '2261', # U+6A73
        '27262' => '2262', # U+6A7E
        '27265' => '2263', # U+6A81
        '27267' => '2264', # U+6A83
        '27270' => '2265', # U+6A86
        '27271' => '2266', # U+6A87
        '27273' => '2267', # U+6A89
        '27275' => '2268', # U+6A8B
        '27281' => '2269', # U+6A91
        '27291' => '2270', # U+6A9B
        '27293' => '2271', # U+6A9D
        '27294' => '2272', # U+6A9E
        '27295' => '2273', # U+6A9F
        '27301' => '2274', # U+6AA5
        '27307' => '2275', # U+6AAB
        '27311' => '2276', # U+6AAF
        '27312' => '2277', # U+6AB0
        '27313' => '2278', # U+6AB1
        '27316' => '2279', # U+6AB4
        '27325' => '2280', # U+6ABD
        '27326' => '2281', # U+6ABE
        '27327' => '2282', # U+6ABF
        '27334' => '2283', # U+6AC6
        '27336' => '2285', # U+6AC8
        '27337' => '2284', # U+6AC9
        '27340' => '2286', # U+6ACC
        '27344' => '2287', # U+6AD0
        '27348' => '2288', # U+6AD4
        '27349' => '2289', # U+6AD5
        '27350' => '2290', # U+6AD6
        '27356' => '2291', # U+6ADC
        '27357' => '2292', # U+6ADD
        '27364' => '2293', # U+6AE4
        '27367' => '2294', # U+6AE7
        '27372' => '2295', # U+6AEC
        '27376' => '2296', # U+6AF0
        '27377' => '2297', # U+6AF1
        '27378' => '2298', # U+6AF2
        '27388' => '2299', # U+6AFC
        '27389' => '2300', # U+6AFD
        '27394' => '2301', # U+6B02
        '27395' => '2302', # U+6B03
        '27398' => '2303', # U+6B06
        '27399' => '2304', # U+6B07
        '27401' => '2305', # U+6B09
        '27407' => '2306', # U+6B0F
        '27408' => '2307', # U+6B10
        '27409' => '2308', # U+6B11
        '27415' => '2309', # U+6B17
        '27419' => '2310', # U+6B1B
        '27422' => '2311', # U+6B1E
        '27428' => '2312', # U+6B24
        '27432' => '2313', # U+6B28
        '27435' => '2314', # U+6B2B
        '27436' => '2315', # U+6B2C
        '27439' => '2316', # U+6B2F
        '27445' => '2317', # U+6B35
        '27446' => '2318', # U+6B36
        '27451' => '2319', # U+6B3B
        '27455' => '2320', # U+6B3F
        '27462' => '2321', # U+6B46
        '27466' => '2322', # U+6B4A
        '27469' => '2323', # U+6B4D
        '27474' => '2324', # U+6B52
        '27478' => '2325', # U+6B56
        '27480' => '2326', # U+6B58
        '27485' => '2327', # U+6B5D
        '27488' => '2328', # U+6B60
        '27495' => '2329', # U+6B67
        '27499' => '2330', # U+6B6B
        '27502' => '2331', # U+6B6E
        '27504' => '2332', # U+6B70
        '27509' => '2333', # U+6B75
        '27517' => '2334', # U+6B7D
        '27518' => '2335', # U+6B7E
        '27522' => '2336', # U+6B82
        '27525' => '2337', # U+6B85
        '27543' => '2338', # U+6B97
        '27547' => '2339', # U+6B9B
        '27551' => '2340', # U+6B9F
        '27552' => '2341', # U+6BA0
        '27554' => '2342', # U+6BA2
        '27555' => '2343', # U+6BA3
        '27560' => '2344', # U+6BA8
        '27561' => '2345', # U+6BA9
        '27564' => '2346', # U+6BAC
        '27565' => '2347', # U+6BAD
        '27566' => '2348', # U+6BAE
        '27568' => '2349', # U+6BB0
        '27576' => '2350', # U+6BB8
        '27577' => '2351', # U+6BB9
        '27581' => '2352', # U+6BBD
        '27582' => '2353', # U+6BBE
        '27587' => '2354', # U+6BC3
        '27588' => '2355', # U+6BC4
        '27593' => '2356', # U+6BC9
        '27596' => '2357', # U+6BCC
        '27606' => '2358', # U+6BD6
        '27610' => '2359', # U+6BDA
        '27617' => '2360', # U+6BE1
        '27619' => '2361', # U+6BE3
        '27622' => '2362', # U+6BE6
        '27623' => '2363', # U+6BE7
        '27630' => '2364', # U+6BEE
        '27633' => '2365', # U+6BF1
        '27639' => '2366', # U+6BF7
        '27641' => '2367', # U+6BF9
        '27647' => '2368', # U+6BFF
        '27650' => '2369', # U+6C02
        '27652' => '2370', # U+6C04
        '27653' => '2371', # U+6C05
        '27657' => '2372', # U+6C09
        '27661' => '2373', # U+6C0D
        '27662' => '2374', # U+6C0E
        '27664' => '2375', # U+6C10
        '27666' => '2376', # U+6C12
        '27673' => '2377', # U+6C19
        '27679' => '2378', # U+6C1F
        '27686' => '2379', # U+6C26
        '27687' => '2380', # U+6C27
        '27688' => '2381', # U+6C28
        '27692' => '2382', # U+6C2C
        '27694' => '2383', # U+6C2E
        '27699' => '2384', # U+6C33
        '27701' => '2385', # U+6C35
        '27702' => '2386', # U+6C36
        '27706' => '2387', # U+6C3A
        '27707' => '2388', # U+6C3B
        '27711' => '2389', # U+6C3F
        '27722' => '2390', # U+6C4A
        '27723' => '2391', # U+6C4B
        '27725' => '2392', # U+6C4D
        '27727' => '2393', # U+6C4F
        '27730' => '2394', # U+6C52
        '27732' => '2395', # U+6C54
        '27737' => '2396', # U+6C59
        '27739' => '2397', # U+6C5B
        '27740' => '2398', # U+6C5C
        '27751' => '2450', # U+6C67
        '27755' => '2399', # U+6C6B
        '27757' => '2400', # U+6C6D
        '27759' => '2401', # U+6C6F
        '27764' => '2402', # U+6C74
        '27766' => '2403', # U+6C76
        '27768' => '2404', # U+6C78
        '27769' => '2405', # U+6C79
        '27771' => '2406', # U+6C7B
        '27781' => '2407', # U+6C85
        '27782' => '2408', # U+6C86
        '27783' => '2409', # U+6C87
        '27785' => '2410', # U+6C89
        '27796' => '2411', # U+6C94
        '27797' => '2412', # U+6C95
        '27799' => '2413', # U+6C97
        '27800' => '2414', # U+6C98
        '27804' => '2415', # U+6C9C
        '27807' => '2416', # U+6C9F
        '27824' => '2417', # U+6CB0
        '27826' => '2418', # U+6CB2
        '27828' => '2419', # U+6CB4
        '27842' => '2420', # U+6CC2
        '27846' => '2421', # U+6CC6
        '27853' => '2422', # U+6CCD
        '27855' => '2423', # U+6CCF
        '27856' => '2424', # U+6CD0
        '27857' => '2425', # U+6CD1
        '27858' => '2426', # U+6CD2
        '27860' => '2427', # U+6CD4
        '27862' => '2428', # U+6CD6
        '27866' => '2429', # U+6CDA
        '27868' => '2430', # U+6CDC
        '27872' => '2431', # U+6CE0
        '27879' => '2432', # U+6CE7
        '27881' => '2433', # U+6CE9
        '27883' => '2434', # U+6CEB
        '27884' => '2435', # U+6CEC
        '27886' => '2436', # U+6CEE
        '27890' => '2437', # U+6CF2
        '27892' => '2438', # U+6CF4
        '27908' => '2439', # U+6D04
        '27911' => '2440', # U+6D07
        '27914' => '2441', # U+6D0A
        '27918' => '2442', # U+6D0E
        '27919' => '2443', # U+6D0F
        '27921' => '2444', # U+6D11
        '27923' => '2445', # U+6D13
        '27930' => '2446', # U+6D1A
        '27942' => '2447', # U+6D26
        '27943' => '2448', # U+6D27
        '27944' => '2449', # U+6D28
        '27950' => '2451', # U+6D2E
        '27951' => '2452', # U+6D2F
        '27953' => '2453', # U+6D31
        '27961' => '2454', # U+6D39
        '27964' => '2455', # U+6D3C
        '27967' => '2456', # U+6D3F
        '27991' => '2457', # U+6D57
        '27998' => '2458', # U+6D5E
        '27999' => '2459', # U+6D5F
        '28001' => '2460', # U+6D61
        '28005' => '2461', # U+6D65
        '28007' => '2462', # U+6D67
        '28015' => '2463', # U+6D6F
        '28016' => '2464', # U+6D70
        '28028' => '2465', # U+6D7C
        '28034' => '2466', # U+6D82
        '28039' => '2467', # U+6D87
        '28049' => '2468', # U+6D91
        '28050' => '2469', # U+6D92
        '28052' => '2470', # U+6D94
        '28054' => '2471', # U+6D96
        '28055' => '2472', # U+6D97
        '28056' => '2473', # U+6D98
        '28074' => '2474', # U+6DAA
        '28076' => '2475', # U+6DAC
        '28084' => '2476', # U+6DB4
        '28087' => '2477', # U+6DB7
        '28089' => '2478', # U+6DB9
        '28093' => '2479', # U+6DBD
        '28095' => '2480', # U+6DBF
        '28100' => '2481', # U+6DC4
        '28104' => '2482', # U+6DC8
        '28106' => '2483', # U+6DCA
        '28110' => '2484', # U+6DCE
        '28111' => '2485', # U+6DCF
        '28118' => '2486', # U+6DD6
        '28123' => '2487', # U+6DDB
        '28125' => '2488', # U+6DDD
        '28127' => '2489', # U+6DDF
        '28128' => '2490', # U+6DE0
        '28130' => '2491', # U+6DE2
        '28133' => '2492', # U+6DE5
        '28137' => '2493', # U+6DE9
        '28143' => '2494', # U+6DEF
        '28144' => '2495', # U+6DF0
        '28148' => '2496', # U+6DF4
        '28150' => '2497', # U+6DF6
        '28156' => '2498', # U+6DFC
        '28160' => '2499', # U+6E00
        '28164' => '2500', # U+6E04
        '28190' => '2501', # U+6E1E
        '28194' => '2502', # U+6E22
        '28199' => '2503', # U+6E27
        '28210' => '2504', # U+6E32
        '28214' => '2505', # U+6E36
        '28217' => '2506', # U+6E39
        '28219' => '2507', # U+6E3B
        '28220' => '2508', # U+6E3C
        '28228' => '2509', # U+6E44
        '28229' => '2510', # U+6E45
        '28232' => '2511', # U+6E48
        '28233' => '2512', # U+6E49
        '28235' => '2513', # U+6E4B
        '28239' => '2514', # U+6E4F
        '28241' => '2515', # U+6E51
        '28242' => '2516', # U+6E52
        '28243' => '2517', # U+6E53
        '28244' => '2518', # U+6E54
        '28247' => '2519', # U+6E57
        '28252' => '2520', # U+6E5C
        '28253' => '2521', # U+6E5D
        '28254' => '2522', # U+6E5E
        '28258' => '2523', # U+6E62
        '28259' => '2524', # U+6E63
        '28264' => '2525', # U+6E68
        '28275' => '2526', # U+6E73
        '28283' => '2527', # U+6E7B
        '28285' => '2528', # U+6E7D
        '28301' => '2529', # U+6E8D
        '28307' => '2530', # U+6E93
        '28313' => '2531', # U+6E99
        '28320' => '2532', # U+6EA0
        '28327' => '2533', # U+6EA7
        '28333' => '2534', # U+6EAD
        '28334' => '2535', # U+6EAE
        '28337' => '2536', # U+6EB1
        '28339' => '2537', # U+6EB3
        '28347' => '2538', # U+6EBB
        '28351' => '2539', # U+6EBF
        '28352' => '2540', # U+6EC0
        '28353' => '2541', # U+6EC1
        '28355' => '2542', # U+6EC3
        '28359' => '2543', # U+6EC7
        '28360' => '2544', # U+6EC8
        '28362' => '2545', # U+6ECA
        '28365' => '2546', # U+6ECD
        '28366' => '2547', # U+6ECE
        '28367' => '2548', # U+6ECF
        '28395' => '2549', # U+6EEB
        '28397' => '2550', # U+6EED
        '28398' => '2551', # U+6EEE
        '28409' => '2552', # U+6EF9
        '28411' => '2553', # U+6EFB
        '28413' => '2554', # U+6EFD
        '28420' => '2555', # U+6F04
        '28424' => '2556', # U+6F08
        '28426' => '2557', # U+6F0A
        '28428' => '2558', # U+6F0C
        '28429' => '2559', # U+6F0D
        '28438' => '2560', # U+6F16
        '28440' => '2561', # U+6F18
        '28442' => '2562', # U+6F1A
        '28443' => '2563', # U+6F1B
        '28454' => '2564', # U+6F26
        '28457' => '2565', # U+6F29
        '28458' => '2566', # U+6F2A
        '28461' => '2573', # U+6F2D
        '28463' => '2567', # U+6F2F
        '28464' => '2568', # U+6F30
        '28467' => '2569', # U+6F33
        '28470' => '2570', # U+6F36
        '28475' => '2571', # U+6F3B
        '28476' => '2572', # U+6F3C
        '28495' => '2574', # U+6F4F
        '28497' => '2575', # U+6F51
        '28498' => '2576', # U+6F52
        '28499' => '2577', # U+6F53
        '28503' => '2578', # U+6F57
        '28505' => '2579', # U+6F59
        '28506' => '2580', # U+6F5A
        '28509' => '2581', # U+6F5D
        '28510' => '2582', # U+6F5E
        '28513' => '2583', # U+6F61
        '28514' => '2584', # U+6F62
        '28520' => '2585', # U+6F68
        '28524' => '2586', # U+6F6C
        '28541' => '2587', # U+6F7D
        '28542' => '2588', # U+6F7E
        '28547' => '2589', # U+6F83
        '28551' => '2590', # U+6F87
        '28552' => '2591', # U+6F88
        '28555' => '2592', # U+6F8B
        '28556' => '2593', # U+6F8C
        '28557' => '2594', # U+6F8D
        '28560' => '2595', # U+6F90
        '28562' => '2596', # U+6F92
        '28563' => '2597', # U+6F93
        '28564' => '2598', # U+6F94
        '28566' => '2599', # U+6F96
        '28570' => '2600', # U+6F9A
        '28575' => '2601', # U+6F9F
        '28576' => '2602', # U+6FA0
        '28581' => '2603', # U+6FA5
        '28582' => '2604', # U+6FA6
        '28583' => '2605', # U+6FA7
        '28584' => '2606', # U+6FA8
        '28590' => '2607', # U+6FAE
        '28591' => '2608', # U+6FAF
        '28592' => '2609', # U+6FB0
        '28597' => '2610', # U+6FB5
        '28598' => '2611', # U+6FB6
        '28604' => '2612', # U+6FBC
        '28613' => '2613', # U+6FC5
        '28615' => '2614', # U+6FC7
        '28616' => '2615', # U+6FC8
        '28618' => '2616', # U+6FCA
        '28634' => '2617', # U+6FDA
        '28638' => '2618', # U+6FDE
        '28648' => '2619', # U+6FE8
        '28649' => '2620', # U+6FE9
        '28656' => '2621', # U+6FF0
        '28661' => '2622', # U+6FF5
        '28665' => '2623', # U+6FF9
        '28668' => '2624', # U+6FFC
        '28669' => '2625', # U+6FFD
        '28672' => '2626', # U+7000
        '28677' => '2627', # U+7005
        '28678' => '2628', # U+7006
        '28679' => '2629', # U+7007
        '28685' => '2630', # U+700D
        '28695' => '2631', # U+7017
        '28704' => '2632', # U+7020
        '28707' => '2633', # U+7023
        '28719' => '2634', # U+702F
        '28724' => '2635', # U+7034
        '28727' => '2636', # U+7037
        '28729' => '2637', # U+7039
        '28732' => '2638', # U+703C
        '28739' => '2639', # U+7043
        '28740' => '2640', # U+7044
        '28744' => '2641', # U+7048
        '28745' => '2642', # U+7049
        '28746' => '2643', # U+704A
        '28747' => '2644', # U+704B
        '28750' => '2649', # U+704E
        '28756' => '2645', # U+7054
        '28757' => '2646', # U+7055
        '28765' => '2647', # U+705D
        '28766' => '2648', # U+705E
        '28772' => '2650', # U+7064
        '28773' => '2651', # U+7065
        '28780' => '2652', # U+706C
        '28782' => '2653', # U+706E
        '28789' => '2654', # U+7075
        '28790' => '2655', # U+7076
        '28798' => '2656', # U+707E
        '28801' => '2657', # U+7081
        '28805' => '2658', # U+7085
        '28806' => '2659', # U+7086
        '28820' => '2660', # U+7094
        '28821' => '2661', # U+7095
        '28822' => '2662', # U+7096
        '28823' => '2663', # U+7097
        '28824' => '2664', # U+7098
        '28827' => '2665', # U+709B
        '28836' => '2666', # U+70A4
        '28843' => '2667', # U+70AB
        '28848' => '2668', # U+70B0
        '28849' => '2669', # U+70B1
        '28852' => '2670', # U+70B4
        '28855' => '2671', # U+70B7
        '28874' => '2672', # U+70CA
        '28881' => '2673', # U+70D1
        '28883' => '2674', # U+70D3
        '28884' => '2675', # U+70D4
        '28885' => '2676', # U+70D5
        '28886' => '2677', # U+70D6
        '28888' => '2678', # U+70D8
        '28892' => '2679', # U+70DC
        '28900' => '2680', # U+70E4
        '28922' => '2681', # U+70FA
        '28931' => '2682', # U+7103
        '28932' => '2683', # U+7104
        '28933' => '2684', # U+7105
        '28934' => '2685', # U+7106
        '28935' => '2686', # U+7107
        '28939' => '2687', # U+710B
        '28940' => '2688', # U+710C
        '28943' => '2689', # U+710F
        '28958' => '2690', # U+711E
        '28960' => '2691', # U+7120
        '28971' => '2692', # U+712B
        '28973' => '2693', # U+712D
        '28975' => '2694', # U+712F
        '28976' => '2695', # U+7130
        '28977' => '2696', # U+7131
        '28984' => '2697', # U+7138
        '28993' => '2698', # U+7141
        '28997' => '2699', # U+7145
        '28998' => '2700', # U+7146
        '28999' => '2701', # U+7147
        '29002' => '2702', # U+714A
        '29003' => '2703', # U+714B
        '29008' => '2704', # U+7150
        '29010' => '2705', # U+7152
        '29015' => '2706', # U+7157
        '29018' => '2707', # U+715A
        '29020' => '2708', # U+715C
        '29022' => '2709', # U+715E
        '29024' => '2710', # U+7160
        '29032' => '2711', # U+7168
        '29049' => '2712', # U+7179
        '29056' => '2713', # U+7180
        '29061' => '2714', # U+7185
        '29063' => '2715', # U+7187
        '29068' => '2716', # U+718C
        '29074' => '2717', # U+7192
        '29082' => '2718', # U+719A
        '29083' => '2719', # U+719B
        '29088' => '2720', # U+71A0
        '29090' => '2721', # U+71A2
        '29103' => '2722', # U+71AF
        '29104' => '2723', # U+71B0
        '29106' => '2724', # U+71B2
        '29107' => '2725', # U+71B3
        '29114' => '2726', # U+71BA
        '29119' => '2727', # U+71BF
        '29120' => '2728', # U+71C0
        '29121' => '2729', # U+71C1
        '29124' => '2730', # U+71C4
        '29131' => '2731', # U+71CB
        '29132' => '2732', # U+71CC
        '29139' => '2733', # U+71D3
        '29142' => '2734', # U+71D6
        '29145' => '2735', # U+71D9
        '29146' => '2736', # U+71DA
        '29148' => '2737', # U+71DC
        '29176' => '2738', # U+71F8
        '29182' => '2739', # U+71FE
        '29184' => '2740', # U+7200
        '29191' => '2741', # U+7207
        '29192' => '2742', # U+7208
        '29193' => '2743', # U+7209
        '29203' => '2744', # U+7213
        '29207' => '2745', # U+7217
        '29210' => '2746', # U+721A
        '29213' => '2747', # U+721D
        '29215' => '2748', # U+721F
        '29220' => '2749', # U+7224
        '29227' => '2750', # U+722B
        '29231' => '2751', # U+722F
        '29236' => '2752', # U+7234
        '29240' => '2753', # U+7238
        '29241' => '2754', # U+7239
        '29249' => '2755', # U+7241
        '29250' => '2756', # U+7242
        '29251' => '2757', # U+7243
        '29253' => '2758', # U+7245
        '29262' => '2759', # U+724E
        '29263' => '2760', # U+724F
        '29264' => '2761', # U+7250
        '29267' => '2762', # U+7253
        '29269' => '2763', # U+7255
        '29270' => '2764', # U+7256
        '29274' => '2765', # U+725A
        '29276' => '2766', # U+725C
        '29278' => '2767', # U+725E
        '29280' => '2768', # U+7260
        '29283' => '2769', # U+7263
        '29288' => '2770', # U+7268
        '29291' => '2771', # U+726B
        '29294' => '2772', # U+726E
        '29295' => '2773', # U+726F
        '29297' => '2774', # U+7271
        '29303' => '2775', # U+7277
        '29304' => '2776', # U+7278
        '29307' => '2777', # U+727B
        '29308' => '2778', # U+727C
        '29311' => '2779', # U+727F
        '29316' => '2780', # U+7284
        '29321' => '2781', # U+7289
        '29325' => '2782', # U+728D
        '29326' => '2783', # U+728E
        '29331' => '2784', # U+7293
        '29339' => '2785', # U+729B
        '29352' => '2786', # U+72A8
        '29357' => '2787', # U+72AD
        '29358' => '2788', # U+72AE
        '29361' => '2789', # U+72B1
        '29364' => '2790', # U+72B4
        '29374' => '2791', # U+72BE
        '29377' => '2792', # U+72C1
        '29383' => '2793', # U+72C7
        '29385' => '2794', # U+72C9
        '29388' => '2795', # U+72CC
        '29397' => '2796', # U+72D5
        '29398' => '2797', # U+72D6
        '29400' => '2798', # U+72D8
        '29407' => '2799', # U+72DF
        '29413' => '2800', # U+72E5
        '29427' => '2801', # U+72F3
        '29428' => '2802', # U+72F4
        '29434' => '2803', # U+72FA
        '29435' => '2804', # U+72FB
        '29438' => '2805', # U+72FE
        '29442' => '2806', # U+7302
        '29444' => '2807', # U+7304
        '29445' => '2808', # U+7305
        '29447' => '2809', # U+7307
        '29451' => '2810', # U+730B
        '29453' => '2811', # U+730D
        '29458' => '2812', # U+7312
        '29459' => '2813', # U+7313
        '29464' => '2814', # U+7318
        '29465' => '2815', # U+7319
        '29470' => '2816', # U+731E
        '29474' => '2817', # U+7322
        '29476' => '2818', # U+7324
        '29479' => '2819', # U+7327
        '29480' => '2820', # U+7328
        '29484' => '2821', # U+732C
        '29489' => '2822', # U+7331
        '29490' => '2823', # U+7332
        '29493' => '2824', # U+7335
        '29498' => '2825', # U+733A
        '29499' => '2826', # U+733B
        '29501' => '2827', # U+733D
        '29507' => '2828', # U+7343
        '29517' => '2829', # U+734D
        '29520' => '2830', # U+7350
        '29522' => '2831', # U+7352
        '29526' => '2832', # U+7356
        '29528' => '2833', # U+7358
        '29533' => '2834', # U+735D
        '29534' => '2835', # U+735E
        '29535' => '2836', # U+735F
        '29536' => '2837', # U+7360
        '29542' => '2838', # U+7366
        '29543' => '2839', # U+7367
        '29545' => '2840', # U+7369
        '29547' => '2841', # U+736B
        '29548' => '2842', # U+736C
        '29550' => '2843', # U+736E
        '29551' => '2844', # U+736F
        '29553' => '2845', # U+7371
        '29559' => '2846', # U+7377
        '29561' => '2847', # U+7379
        '29564' => '2848', # U+737C
        '29568' => '2849', # U+7380
        '29569' => '2850', # U+7381
        '29571' => '2851', # U+7383
        '29573' => '2852', # U+7385
        '29574' => '2853', # U+7386
        '29582' => '2854', # U+738E
        '29584' => '2855', # U+7390
        '29587' => '2856', # U+7393
        '29589' => '2857', # U+7395
        '29591' => '2858', # U+7397
        '29592' => '2859', # U+7398
        '29596' => '2860', # U+739C
        '29598' => '2861', # U+739E
        '29599' => '2862', # U+739F
        '29600' => '2863', # U+73A0
        '29602' => '2864', # U+73A2
        '29605' => '2865', # U+73A5
        '29606' => '2866', # U+73A6
        '29610' => '2867', # U+73AA
        '29611' => '2868', # U+73AB
        '29613' => '2869', # U+73AD
        '29621' => '2870', # U+73B5
        '29623' => '2871', # U+73B7
        '29625' => '2872', # U+73B9
        '29628' => '2873', # U+73BC
        '29629' => '2874', # U+73BD
        '29631' => '2875', # U+73BF
        '29637' => '2876', # U+73C5
        '29638' => '2877', # U+73C6
        '29641' => '2878', # U+73C9
        '29643' => '2879', # U+73CB
        '29644' => '2880', # U+73CC
        '29647' => '2881', # U+73CF
        '29650' => '2882', # U+73D2
        '29651' => '2883', # U+73D3
        '29654' => '2884', # U+73D6
        '29657' => '2885', # U+73D9
        '29661' => '2886', # U+73DD
        '29665' => '2887', # U+73E1
        '29667' => '2888', # U+73E3
        '29670' => '2889', # U+73E6
        '29671' => '2890', # U+73E7
        '29673' => '2891', # U+73E9
        '29684' => '2892', # U+73F4
        '29685' => '2893', # U+73F5
        '29687' => '2894', # U+73F7
        '29689' => '2895', # U+73F9
        '29690' => '2896', # U+73FA
        '29691' => '2897', # U+73FB
        '29693' => '2898', # U+73FD
        '29695' => '2899', # U+73FF
        '29696' => '2900', # U+7400
        '29697' => '2901', # U+7401
        '29700' => '2902', # U+7404
        '29703' => '2903', # U+7407
        '29706' => '2904', # U+740A
        '29713' => '2905', # U+7411
        '29722' => '2906', # U+741A
        '29723' => '2907', # U+741B
        '29732' => '2908', # U+7424
        '29734' => '2909', # U+7426
        '29736' => '2910', # U+7428
        '29737' => '2911', # U+7429
        '29738' => '2912', # U+742A
        '29739' => '2913', # U+742B
        '29740' => '2914', # U+742C
        '29741' => '2915', # U+742D
        '29742' => '2916', # U+742E
        '29743' => '2917', # U+742F
        '29744' => '2918', # U+7430
        '29745' => '2919', # U+7431
        '29753' => '2920', # U+7439
        '29760' => '2921', # U+7440
        '29763' => '2922', # U+7443
        '29764' => '2923', # U+7444
        '29766' => '2924', # U+7446
        '29767' => '2925', # U+7447
        '29771' => '2926', # U+744B
        '29773' => '2927', # U+744D
        '29777' => '2928', # U+7451
        '29778' => '2929', # U+7452
        '29783' => '2930', # U+7457
        '29789' => '2931', # U+745D
        '29794' => '2932', # U+7462
        '29798' => '2933', # U+7466
        '29799' => '2934', # U+7467
        '29800' => '2935', # U+7468
        '29803' => '2936', # U+746B
        '29805' => '2937', # U+746D
        '29806' => '2938', # U+746E
        '29809' => '2939', # U+7471
        '29810' => '2940', # U+7472
        '29824' => '2941', # U+7480
        '29825' => '2942', # U+7481
        '29829' => '2943', # U+7485
        '29830' => '2944', # U+7486
        '29831' => '2945', # U+7487
        '29833' => '2946', # U+7489
        '29839' => '2947', # U+748F
        '29840' => '2948', # U+7490
        '29841' => '2949', # U+7491
        '29842' => '2950', # U+7492
        '29848' => '2951', # U+7498
        '29849' => '2952', # U+7499
        '29850' => '2953', # U+749A
        '29852' => '2954', # U+749C
        '29855' => '2955', # U+749F
        '29856' => '2956', # U+74A0
        '29857' => '2957', # U+74A1
        '29859' => '2958', # U+74A3
        '29862' => '2959', # U+74A6
        '29864' => '2960', # U+74A8
        '29865' => '2961', # U+74A9
        '29866' => '2962', # U+74AA
        '29867' => '2963', # U+74AB
        '29870' => '2964', # U+74AE
        '29871' => '2965', # U+74AF
        '29873' => '2966', # U+74B1
        '29874' => '2967', # U+74B2
        '29877' => '2968', # U+74B5
        '29881' => '2969', # U+74B9
        '29883' => '2970', # U+74BB
        '29887' => '2971', # U+74BF
        '29896' => '2972', # U+74C8
        '29897' => '2973', # U+74C9
        '29900' => '2974', # U+74CC
        '29904' => '2975', # U+74D0
        '29907' => '2976', # U+74D3
        '29912' => '2977', # U+74D8
        '29914' => '2978', # U+74DA
        '29915' => '2979', # U+74DB
        '29918' => '2980', # U+74DE
        '29919' => '2981', # U+74DF
        '29924' => '2982', # U+74E4
        '29928' => '2983', # U+74E8
        '29930' => '2984', # U+74EA
        '29931' => '2985', # U+74EB
        '29935' => '2986', # U+74EF
        '29940' => '2987', # U+74F4
        '29946' => '2988', # U+74FA
        '29947' => '2989', # U+74FB
        '29948' => '2990', # U+74FC
        '29951' => '2991', # U+74FF
        '29958' => '2992', # U+7506
        '29970' => '2993', # U+7512
        '29974' => '2994', # U+7516
        '29975' => '2995', # U+7517
        '29984' => '2996', # U+7520
        '29985' => '2997', # U+7521
        '29988' => '2998', # U+7524
        '29991' => '2999', # U+7527
        '29993' => '3000', # U+7529
        '29994' => '3001', # U+752A
        '29999' => '3002', # U+752F
        '30006' => '3003', # U+7536
        '30009' => '3004', # U+7539
        '30013' => '3005', # U+753D
        '30014' => '3006', # U+753E
        '30015' => '3007', # U+753F
        '30016' => '3008', # U+7540
        '30019' => '3009', # U+7543
        '30023' => '3010', # U+7547
        '30024' => '3011', # U+7548
        '30030' => '3012', # U+754E
        '30032' => '3013', # U+7550
        '30034' => '3014', # U+7552
        '30039' => '3015', # U+7557
        '30046' => '3016', # U+755E
        '30047' => '3017', # U+755F
        '30049' => '3018', # U+7561
        '30063' => '3019', # U+756F
        '30065' => '3020', # U+7571
        '30073' => '3021', # U+7579
        '30074' => '3022', # U+757A
        '30075' => '3023', # U+757B
        '30076' => '3024', # U+757C
        '30077' => '3025', # U+757D
        '30078' => '3026', # U+757E
        '30081' => '3027', # U+7581
        '30085' => '3028', # U+7585
        '30096' => '3029', # U+7590
        '30098' => '3030', # U+7592
        '30099' => '3031', # U+7593
        '30101' => '3032', # U+7595
        '30105' => '3033', # U+7599
        '30108' => '3034', # U+759C
        '30114' => '3035', # U+75A2
        '30116' => '3036', # U+75A4
        '30132' => '3037', # U+75B4
        '30138' => '3038', # U+75BA
        '30143' => '3039', # U+75BF
        '30144' => '3040', # U+75C0
        '30145' => '3041', # U+75C1
        '30148' => '3042', # U+75C4
        '30150' => '3043', # U+75C6
        '30156' => '3044', # U+75CC
        '30158' => '3045', # U+75CE
        '30159' => '3046', # U+75CF
        '30167' => '3047', # U+75D7
        '30172' => '3048', # U+75DC
        '30175' => '3049', # U+75DF
        '30176' => '3050', # U+75E0
        '30177' => '3051', # U+75E1
        '30180' => '3052', # U+75E4
        '30183' => '3053', # U+75E7
        '30188' => '3054', # U+75EC
        '30190' => '3055', # U+75EE
        '30191' => '3056', # U+75EF
        '30193' => '3057', # U+75F1
        '30201' => '3058', # U+75F9
        '30208' => '3059', # U+7600
        '30210' => '3060', # U+7602
        '30211' => '3061', # U+7603
        '30212' => '3062', # U+7604
        '30215' => '3063', # U+7607
        '30216' => '3064', # U+7608
        '30218' => '3065', # U+760A
        '30220' => '3066', # U+760C
        '30223' => '3067', # U+760F
        '30226' => '3068', # U+7612
        '30227' => '3069', # U+7613
        '30229' => '3070', # U+7615
        '30230' => '3071', # U+7616
        '30233' => '3072', # U+7619
        '30235' => '3073', # U+761B
        '30236' => '3074', # U+761C
        '30237' => '3075', # U+761D
        '30238' => '3076', # U+761E
        '30243' => '3077', # U+7623
        '30245' => '3078', # U+7625
        '30246' => '3079', # U+7626
        '30249' => '3080', # U+7629
        '30253' => '3081', # U+762D
        '30258' => '3082', # U+7632
        '30259' => '3083', # U+7633
        '30261' => '3084', # U+7635
        '30264' => '3085', # U+7638
        '30265' => '3086', # U+7639
        '30266' => '3087', # U+763A
        '30268' => '3088', # U+763C
        '30272' => '3090', # U+7640
        '30273' => '3091', # U+7641
        '30275' => '3092', # U+7643
        '30276' => '3093', # U+7644
        '30277' => '3094', # U+7645
        '30281' => '3095', # U+7649
        '30282' => '3089', # U+764A
        '30283' => '3096', # U+764B
        '30293' => '3097', # U+7655
        '30297' => '3098', # U+7659
        '30303' => '3099', # U+765F
        '30308' => '3100', # U+7664
        '30309' => '3101', # U+7665
        '30317' => '3102', # U+766D
        '30318' => '3103', # U+766E
        '30319' => '3104', # U+766F
        '30321' => '3105', # U+7671
        '30324' => '3106', # U+7674
        '30337' => '3107', # U+7681
        '30341' => '3108', # U+7685
        '30348' => '3109', # U+768C
        '30349' => '3110', # U+768D
        '30357' => '3111', # U+7695
        '30363' => '3112', # U+769B
        '30364' => '3113', # U+769C
        '30365' => '3114', # U+769D
        '30367' => '3115', # U+769F
        '30368' => '3116', # U+76A0
        '30370' => '3117', # U+76A2
        '30371' => '3118', # U+76A3
        '30372' => '3119', # U+76A4
        '30373' => '3120', # U+76A5
        '30374' => '3121', # U+76A6
        '30375' => '3122', # U+76A7
        '30376' => '3123', # U+76A8
        '30378' => '3124', # U+76AA
        '30381' => '3125', # U+76AD
        '30397' => '3126', # U+76BD
        '30401' => '3127', # U+76C1
        '30405' => '3128', # U+76C5
        '30409' => '3129', # U+76C9
        '30411' => '3130', # U+76CB
        '30412' => '3131', # U+76CC
        '30414' => '3132', # U+76CE
        '30420' => '3133', # U+76D4
        '30425' => '3134', # U+76D9
        '30432' => '3135', # U+76E0
        '30438' => '3136', # U+76E6
        '30440' => '3137', # U+76E8
        '30444' => '3138', # U+76EC
        '30448' => '3139', # U+76F0
        '30449' => '3140', # U+76F1
        '30454' => '3141', # U+76F6
        '30457' => '3142', # U+76F9
        '30460' => '3143', # U+76FC
        '30464' => '3144', # U+7700
        '30470' => '3145', # U+7706
        '30474' => '3146', # U+770A
        '30478' => '3147', # U+770E
        '30482' => '3148', # U+7712
        '30484' => '3149', # U+7714
        '30485' => '3150', # U+7715
        '30487' => '3151', # U+7717
        '30489' => '3152', # U+7719
        '30490' => '3153', # U+771A
        '30492' => '3154', # U+771C
        '30498' => '3155', # U+7722
        '30504' => '3156', # U+7728
        '30509' => '3157', # U+772D
        '30510' => '3158', # U+772E
        '30511' => '3159', # U+772F
        '30516' => '3160', # U+7734
        '30517' => '3161', # U+7735
        '30518' => '3162', # U+7736
        '30521' => '3163', # U+7739
        '30525' => '3164', # U+773D
        '30526' => '3165', # U+773E
        '30530' => '3166', # U+7742
        '30533' => '3167', # U+7745
        '30534' => '3168', # U+7746
        '30538' => '3169', # U+774A
        '30541' => '3170', # U+774D
        '30542' => '3171', # U+774E
        '30543' => '3172', # U+774F
        '30546' => '3173', # U+7752
        '30550' => '3174', # U+7756
        '30551' => '3175', # U+7757
        '30556' => '3176', # U+775C
        '30558' => '3177', # U+775E
        '30559' => '3178', # U+775F
        '30560' => '3179', # U+7760
        '30562' => '3180', # U+7762
        '30564' => '3181', # U+7764
        '30567' => '3182', # U+7767
        '30570' => '3183', # U+776A
        '30572' => '3184', # U+776C
        '30576' => '3185', # U+7770
        '30578' => '3186', # U+7772
        '30579' => '3187', # U+7773
        '30580' => '3188', # U+7774
        '30586' => '3189', # U+777A
        '30589' => '3190', # U+777D
        '30592' => '3191', # U+7780
        '30596' => '3192', # U+7784
        '30604' => '3193', # U+778C
        '30605' => '3194', # U+778D
        '30612' => '3195', # U+7794
        '30613' => '3196', # U+7795
        '30614' => '3197', # U+7796
        '30618' => '3198', # U+779A
        '30623' => '3199', # U+779F
        '30626' => '3200', # U+77A2
        '30631' => '3201', # U+77A7
        '30634' => '3202', # U+77AA
        '30638' => '3203', # U+77AE
        '30639' => '3204', # U+77AF
        '30641' => '3205', # U+77B1
        '30645' => '3206', # U+77B5
        '30654' => '3207', # U+77BE
        '30659' => '3208', # U+77C3
        '30665' => '3209', # U+77C9
        '30673' => '3210', # U+77D1
        '30674' => '3211', # U+77D2
        '30677' => '3212', # U+77D5
        '30681' => '3213', # U+77D9
        '30686' => '3214', # U+77DE
        '30687' => '3215', # U+77DF
        '30688' => '3216', # U+77E0
        '30692' => '3217', # U+77E4
        '30694' => '3218', # U+77E6
        '30698' => '3219', # U+77EA
        '30700' => '3220', # U+77EC
        '30704' => '3221', # U+77F0
        '30705' => '3222', # U+77F1
        '30708' => '3223', # U+77F4
        '30712' => '3224', # U+77F8
        '30715' => '3225', # U+77FB
        '30725' => '3226', # U+7805
        '30726' => '3227', # U+7806
        '30729' => '3228', # U+7809
        '30733' => '3229', # U+780D
        '30734' => '3230', # U+780E
        '30737' => '3231', # U+7811
        '30749' => '3232', # U+781D
        '30753' => '3233', # U+7821
        '30754' => '3234', # U+7822
        '30755' => '3235', # U+7823
        '30765' => '3236', # U+782D
        '30766' => '3237', # U+782E
        '30768' => '3238', # U+7830
        '30773' => '3239', # U+7835
        '30775' => '3240', # U+7837
        '30787' => '3241', # U+7843
        '30788' => '3242', # U+7844
        '30791' => '3243', # U+7847
        '30792' => '3244', # U+7848
        '30796' => '3245', # U+784C
        '30798' => '3246', # U+784E
        '30802' => '3247', # U+7852
        '30812' => '3248', # U+785C
        '30814' => '3249', # U+785E
        '30816' => '3250', # U+7860
        '30817' => '3251', # U+7861
        '30819' => '3252', # U+7863
        '30820' => '3253', # U+7864
        '30824' => '3254', # U+7868
        '30826' => '3255', # U+786A
        '30830' => '3256', # U+786E
        '30842' => '3257', # U+787A
        '30846' => '3258', # U+787E
        '30858' => '3259', # U+788A
        '30863' => '3260', # U+788F
        '30868' => '3261', # U+7894
        '30872' => '3262', # U+7898
        '30877' => '3264', # U+789D
        '30878' => '3265', # U+789E
        '30879' => '3266', # U+789F
        '30881' => '3263', # U+78A1
        '30884' => '3267', # U+78A4
        '30888' => '3268', # U+78A8
        '30892' => '3269', # U+78AC
        '30893' => '3270', # U+78AD
        '30896' => '3271', # U+78B0
        '30897' => '3272', # U+78B1
        '30898' => '3273', # U+78B2
        '30899' => '3274', # U+78B3
        '30907' => '3275', # U+78BB
        '30909' => '3276', # U+78BD
        '30911' => '3277', # U+78BF
        '30919' => '3278', # U+78C7
        '30920' => '3279', # U+78C8
        '30921' => '3280', # U+78C9
        '30924' => '3281', # U+78CC
        '30926' => '3282', # U+78CE
        '30930' => '3283', # U+78D2
        '30931' => '3284', # U+78D3
        '30933' => '3285', # U+78D5
        '30934' => '3286', # U+78D6
        '30939' => '3288', # U+78DB
        '30943' => '3289', # U+78DF
        '30944' => '3290', # U+78E0
        '30945' => '3291', # U+78E1
        '30948' => '3287', # U+78E4
        '30950' => '3292', # U+78E6
        '30954' => '3293', # U+78EA
        '30962' => '3294', # U+78F2
        '30963' => '3295', # U+78F3
        '30966' => '3297', # U+78F6
        '30967' => '3298', # U+78F7
        '30970' => '3299', # U+78FA
        '30971' => '3300', # U+78FB
        '30975' => '3301', # U+78FF
        '30976' => '3296', # U+7900
        '30982' => '3302', # U+7906
        '30988' => '3303', # U+790C
        '30992' => '3304', # U+7910
        '31002' => '3305', # U+791A
        '31004' => '3306', # U+791C
        '31006' => '3307', # U+791E
        '31007' => '3308', # U+791F
        '31008' => '3309', # U+7920
        '31013' => '3310', # U+7925
        '31015' => '3311', # U+7927
        '31017' => '3312', # U+7929
        '31021' => '3313', # U+792D
        '31025' => '3314', # U+7931
        '31028' => '3315', # U+7934
        '31029' => '3316', # U+7935
        '31035' => '3317', # U+793B
        '31037' => '3318', # U+793D
        '31039' => '3319', # U+793F
        '31044' => '3320', # U+7944
        '31045' => '3321', # U+7945
        '31046' => '3322', # U+7946
        '31050' => '3323', # U+794A
        '31051' => '3324', # U+794B
        '31055' => '3325', # U+794F
        '31057' => '3326', # U+7951
        '31060' => '3327', # U+7954
        '31064' => '3328', # U+7958
        '31067' => '3329', # U+795B
        '31068' => '3330', # U+795C
        '31079' => '3331', # U+7967
        '31081' => '3332', # U+7969
        '31083' => '3333', # U+796B
        '31090' => '3334', # U+7972
        '31097' => '3335', # U+7979
        '31099' => '3336', # U+797B
        '31100' => '3337', # U+797C
        '31102' => '3338', # U+797E
        '31115' => '3339', # U+798B
        '31116' => '3340', # U+798C
        '31121' => '3341', # U+7991
        '31123' => '3342', # U+7993
        '31124' => '3343', # U+7994
        '31125' => '3344', # U+7995
        '31126' => '3345', # U+7996
        '31128' => '3346', # U+7998
        '31131' => '3347', # U+799B
        '31132' => '3348', # U+799C
        '31137' => '3349', # U+79A1
        '31144' => '3350', # U+79A8
        '31145' => '3351', # U+79A9
        '31147' => '3352', # U+79AB
        '31151' => '3353', # U+79AF
        '31153' => '3354', # U+79B1
        '31156' => '3355', # U+79B4
        '31160' => '3356', # U+79B8
        '31163' => '3357', # U+79BB
        '31170' => '3358', # U+79C2
        '31172' => '3359', # U+79C4
        '31175' => '3360', # U+79C7
        '31176' => '3361', # U+79C8
        '31178' => '3362', # U+79CA
        '31183' => '3363', # U+79CF
        '31188' => '3364', # U+79D4
        '31190' => '3365', # U+79D6
        '31194' => '3366', # U+79DA
        '31197' => '3367', # U+79DD
        '31198' => '3368', # U+79DE
        '31200' => '3369', # U+79E0
        '31202' => '3370', # U+79E2
        '31205' => '3371', # U+79E5
        '31210' => '3372', # U+79EA
        '31211' => '3373', # U+79EB
        '31213' => '3374', # U+79ED
        '31217' => '3375', # U+79F1
        '31224' => '3376', # U+79F8
        '31228' => '3377', # U+79FC
        '31234' => '3378', # U+7A02
        '31235' => '3379', # U+7A03
        '31239' => '3380', # U+7A07
        '31241' => '3381', # U+7A09
        '31242' => '3382', # U+7A0A
        '31244' => '3383', # U+7A0C
        '31249' => '3384', # U+7A11
        '31253' => '3385', # U+7A15
        '31259' => '3386', # U+7A1B
        '31262' => '3387', # U+7A1E
        '31265' => '3388', # U+7A21
        '31271' => '3389', # U+7A27
        '31275' => '3390', # U+7A2B
        '31277' => '3391', # U+7A2D
        '31279' => '3392', # U+7A2F
        '31280' => '3393', # U+7A30
        '31284' => '3394', # U+7A34
        '31285' => '3395', # U+7A35
        '31288' => '3396', # U+7A38
        '31289' => '3397', # U+7A39
        '31290' => '3398', # U+7A3A
        '31300' => '3399', # U+7A44
        '31301' => '3400', # U+7A45
        '31303' => '3401', # U+7A47
        '31304' => '3402', # U+7A48
        '31308' => '3403', # U+7A4C
        '31317' => '3404', # U+7A55
        '31318' => '3405', # U+7A56
        '31321' => '3406', # U+7A59
        '31324' => '3407', # U+7A5C
        '31325' => '3408', # U+7A5D
        '31327' => '3409', # U+7A5F
        '31328' => '3410', # U+7A60
        '31333' => '3411', # U+7A65
        '31335' => '3412', # U+7A67
        '31338' => '3413', # U+7A6A
        '31341' => '3414', # U+7A6D
        '31349' => '3415', # U+7A75
        '31352' => '3416', # U+7A78
        '31358' => '3417', # U+7A7E
        '31360' => '3418', # U+7A80
        '31362' => '3419', # U+7A82
        '31365' => '3420', # U+7A85
        '31366' => '3421', # U+7A86
        '31370' => '3422', # U+7A8A
        '31371' => '3423', # U+7A8B
        '31376' => '3424', # U+7A90
        '31377' => '3425', # U+7A91
        '31380' => '3426', # U+7A94
        '31390' => '3427', # U+7A9E
        '31392' => '3428', # U+7AA0
        '31395' => '3429', # U+7AA3
        '31404' => '3430', # U+7AAC
        '31411' => '3431', # U+7AB3
        '31413' => '3432', # U+7AB5
        '31417' => '3433', # U+7AB9
        '31419' => '3434', # U+7ABB
        '31420' => '3435', # U+7ABC
        '31430' => '3436', # U+7AC6
        '31433' => '3437', # U+7AC9
        '31436' => '3438', # U+7ACC
        '31438' => '3439', # U+7ACE
        '31441' => '3440', # U+7AD1
        '31451' => '3441', # U+7ADB
        '31464' => '3442', # U+7AE8
        '31465' => '3443', # U+7AE9
        '31467' => '3444', # U+7AEB
        '31468' => '3445', # U+7AEC
        '31473' => '3446', # U+7AF1
        '31476' => '3447', # U+7AF4
        '31483' => '3448', # U+7AFB
        '31485' => '3449', # U+7AFD
        '31486' => '3450', # U+7AFE
        '31495' => '3451', # U+7B07
        '31508' => '3452', # U+7B14
        '31519' => '3453', # U+7B1F
        '31523' => '3454', # U+7B23
        '31527' => '3455', # U+7B27
        '31529' => '3456', # U+7B29
        '31530' => '3457', # U+7B2A
        '31531' => '3458', # U+7B2B
        '31533' => '3459', # U+7B2D
        '31534' => '3460', # U+7B2E
        '31535' => '3461', # U+7B2F
        '31536' => '3462', # U+7B30
        '31537' => '3463', # U+7B31
        '31540' => '3464', # U+7B34
        '31549' => '3465', # U+7B3D
        '31551' => '3466', # U+7B3F
        '31552' => '3467', # U+7B40
        '31553' => '3468', # U+7B41
        '31559' => '3469', # U+7B47
        '31566' => '3470', # U+7B4E
        '31573' => '3471', # U+7B55
        '31584' => '3472', # U+7B60
        '31588' => '3473', # U+7B64
        '31590' => '3474', # U+7B66
        '31593' => '3475', # U+7B69
        '31594' => '3476', # U+7B6A
        '31597' => '3477', # U+7B6D
        '31599' => '3478', # U+7B6F
        '31602' => '3479', # U+7B72
        '31603' => '3480', # U+7B73
        '31607' => '3481', # U+7B77
        '31620' => '3482', # U+7B84
        '31625' => '3483', # U+7B89
        '31630' => '3484', # U+7B8E
        '31632' => '3485', # U+7B90
        '31633' => '3486', # U+7B91
        '31638' => '3487', # U+7B96
        '31643' => '3488', # U+7B9B
        '31646' => '3489', # U+7B9E
        '31648' => '3490', # U+7BA0
        '31653' => '3491', # U+7BA5
        '31660' => '3492', # U+7BAC
        '31663' => '3493', # U+7BAF
        '31664' => '3494', # U+7BB0
        '31666' => '3495', # U+7BB2
        '31669' => '3496', # U+7BB5
        '31670' => '3497', # U+7BB6
        '31674' => '3498', # U+7BBA
        '31675' => '3499', # U+7BBB
        '31676' => '3500', # U+7BBC
        '31677' => '3501', # U+7BBD
        '31682' => '3502', # U+7BC2
        '31685' => '3503', # U+7BC5
        '31688' => '3504', # U+7BC8
        '31690' => '3505', # U+7BCA
        '31700' => '3506', # U+7BD4
        '31702' => '3507', # U+7BD6
        '31703' => '3508', # U+7BD7
        '31705' => '3509', # U+7BD9
        '31706' => '3510', # U+7BDA
        '31707' => '3511', # U+7BDB
        '31720' => '3512', # U+7BE8
        '31722' => '3513', # U+7BEA
        '31730' => '3514', # U+7BF2
        '31732' => '3515', # U+7BF4
        '31733' => '3516', # U+7BF5
        '31736' => '3517', # U+7BF8
        '31737' => '3518', # U+7BF9
        '31738' => '3519', # U+7BFA
        '31740' => '3520', # U+7BFC
        '31742' => '3521', # U+7BFE
        '31745' => '3522', # U+7C01
        '31746' => '3523', # U+7C02
        '31747' => '3524', # U+7C03
        '31748' => '3525', # U+7C04
        '31750' => '3526', # U+7C06
        '31753' => '3527', # U+7C09
        '31755' => '3528', # U+7C0B
        '31756' => '3529', # U+7C0C
        '31758' => '3530', # U+7C0E
        '31759' => '3531', # U+7C0F
        '31769' => '3532', # U+7C19
        '31771' => '3533', # U+7C1B
        '31776' => '3534', # U+7C20
        '31781' => '3535', # U+7C25
        '31782' => '3536', # U+7C26
        '31784' => '3537', # U+7C28
        '31788' => '3538', # U+7C2C
        '31793' => '3539', # U+7C31
        '31795' => '3540', # U+7C33
        '31796' => '3541', # U+7C34
        '31798' => '3542', # U+7C36
        '31801' => '3543', # U+7C39
        '31802' => '3544', # U+7C3A
        '31814' => '3545', # U+7C46
        '31818' => '3546', # U+7C4A
        '31825' => '3548', # U+7C51
        '31826' => '3549', # U+7C52
        '31827' => '3550', # U+7C53
        '31829' => '3547', # U+7C55
        '31833' => '3551', # U+7C59
        '31834' => '3552', # U+7C5A
        '31835' => '3553', # U+7C5B
        '31836' => '3554', # U+7C5C
        '31837' => '3555', # U+7C5D
        '31838' => '3556', # U+7C5E
        '31841' => '3557', # U+7C61
        '31843' => '3558', # U+7C63
        '31847' => '3559', # U+7C67
        '31849' => '3560', # U+7C69
        '31853' => '3561', # U+7C6D
        '31854' => '3562', # U+7C6E
        '31856' => '3563', # U+7C70
        '31858' => '3564', # U+7C72
        '31865' => '3565', # U+7C79
        '31868' => '3566', # U+7C7C
        '31869' => '3567', # U+7C7D
        '31878' => '3568', # U+7C86
        '31879' => '3569', # U+7C87
        '31887' => '3570', # U+7C8F
        '31892' => '3571', # U+7C94
        '31902' => '3572', # U+7C9E
        '31904' => '3573', # U+7CA0
        '31910' => '3574', # U+7CA6
        '31920' => '3575', # U+7CB0
        '31926' => '3576', # U+7CB6
        '31927' => '3577', # U+7CB7
        '31930' => '3578', # U+7CBA
        '31931' => '3579', # U+7CBB
        '31932' => '3580', # U+7CBC
        '31935' => '3581', # U+7CBF
        '31940' => '3582', # U+7CC4
        '31943' => '3583', # U+7CC7
        '31944' => '3584', # U+7CC8
        '31945' => '3585', # U+7CC9
        '31949' => '3586', # U+7CCD
        '31951' => '3587', # U+7CCF
        '31955' => '3588', # U+7CD3
        '31956' => '3589', # U+7CD4
        '31957' => '3590', # U+7CD5
        '31959' => '3591', # U+7CD7
        '31961' => '3592', # U+7CD9
        '31962' => '3593', # U+7CDA
        '31965' => '3594', # U+7CDD
        '31974' => '3595', # U+7CE6
        '31977' => '3596', # U+7CE9
        '31979' => '3597', # U+7CEB
        '31989' => '3598', # U+7CF5
        '32003' => '3599', # U+7D03
        '32007' => '3600', # U+7D07
        '32008' => '3601', # U+7D08
        '32009' => '3602', # U+7D09
        '32015' => '3603', # U+7D0F
        '32017' => '3604', # U+7D11
        '32018' => '3605', # U+7D12
        '32019' => '3606', # U+7D13
        '32022' => '3607', # U+7D16
        '32029' => '3608', # U+7D1D
        '32030' => '3609', # U+7D1E
        '32035' => '3610', # U+7D23
        '32038' => '3611', # U+7D26
        '32042' => '3612', # U+7D2A
        '32045' => '3613', # U+7D2D
        '32049' => '3614', # U+7D31
        '32060' => '3615', # U+7D3C
        '32061' => '3616', # U+7D3D
        '32062' => '3617', # U+7D3E
        '32064' => '3618', # U+7D40
        '32065' => '3619', # U+7D41
        '32071' => '3620', # U+7D47
        '32072' => '3621', # U+7D48
        '32077' => '3622', # U+7D4D
        '32081' => '3623', # U+7D51
        '32083' => '3624', # U+7D53
        '32087' => '3625', # U+7D57
        '32089' => '3626', # U+7D59
        '32090' => '3627', # U+7D5A
        '32092' => '3628', # U+7D5C
        '32093' => '3629', # U+7D5D
        '32101' => '3630', # U+7D65
        '32103' => '3631', # U+7D67
        '32106' => '3632', # U+7D6A
        '32112' => '3633', # U+7D70
        '32120' => '3634', # U+7D78
        '32122' => '3635', # U+7D7A
        '32123' => '3636', # U+7D7B
        '32127' => '3637', # U+7D7F
        '32129' => '3638', # U+7D81
        '32130' => '3639', # U+7D82
        '32131' => '3640', # U+7D83
        '32133' => '3641', # U+7D85
        '32134' => '3642', # U+7D86
        '32136' => '3643', # U+7D88
        '32139' => '3644', # U+7D8B
        '32140' => '3645', # U+7D8C
        '32141' => '3646', # U+7D8D
        '32145' => '3647', # U+7D91
        '32150' => '3648', # U+7D96
        '32151' => '3649', # U+7D97
        '32157' => '3650', # U+7D9D
        '32158' => '3651', # U+7D9E
        '32166' => '3652', # U+7DA6
        '32167' => '3653', # U+7DA7
        '32170' => '3654', # U+7DAA
        '32179' => '3655', # U+7DB3
        '32182' => '3656', # U+7DB6
        '32183' => '3657', # U+7DB7
        '32185' => '3658', # U+7DB9
        '32194' => '3659', # U+7DC2
        '32195' => '3660', # U+7DC3
        '32196' => '3661', # U+7DC4
        '32197' => '3662', # U+7DC5
        '32198' => '3663', # U+7DC6
        '32204' => '3664', # U+7DCC
        '32205' => '3665', # U+7DCD
        '32206' => '3666', # U+7DCE
        '32215' => '3667', # U+7DD7
        '32217' => '3668', # U+7DD9
        '32226' => '3670', # U+7DE2
        '32229' => '3671', # U+7DE5
        '32230' => '3672', # U+7DE6
        '32234' => '3673', # U+7DEA
        '32235' => '3674', # U+7DEB
        '32237' => '3675', # U+7DED
        '32241' => '3676', # U+7DF1
        '32245' => '3677', # U+7DF5
        '32246' => '3678', # U+7DF6
        '32249' => '3679', # U+7DF9
        '32250' => '3680', # U+7DFA
        '32256' => '3669', # U+7E00
        '32264' => '3681', # U+7E08
        '32272' => '3682', # U+7E10
        '32273' => '3683', # U+7E11
        '32277' => '3684', # U+7E15
        '32279' => '3685', # U+7E17
        '32284' => '3686', # U+7E1C
        '32285' => '3687', # U+7E1D
        '32288' => '3688', # U+7E20
        '32295' => '3689', # U+7E27
        '32296' => '3690', # U+7E28
        '32300' => '3691', # U+7E2C
        '32301' => '3692', # U+7E2D
        '32303' => '3693', # U+7E2F
        '32307' => '3694', # U+7E33
        '32310' => '3695', # U+7E36
        '32319' => '3696', # U+7E3F
        '32324' => '3697', # U+7E44
        '32325' => '3698', # U+7E45
        '32327' => '3699', # U+7E47
        '32334' => '3700', # U+7E4E
        '32336' => '3701', # U+7E50
        '32338' => '3702', # U+7E52
        '32344' => '3703', # U+7E58
        '32351' => '3704', # U+7E5F
        '32353' => '3705', # U+7E61
        '32354' => '3706', # U+7E62
        '32357' => '3707', # U+7E65
        '32363' => '3708', # U+7E6B
        '32366' => '3709', # U+7E6E
        '32367' => '3710', # U+7E6F
        '32371' => '3711', # U+7E73
        '32376' => '3712', # U+7E78
        '32382' => '3713', # U+7E7E
        '32385' => '3714', # U+7E81
        '32390' => '3715', # U+7E86
        '32391' => '3716', # U+7E87
        '32394' => '3717', # U+7E8A
        '32397' => '3718', # U+7E8D
        '32401' => '3719', # U+7E91
        '32405' => '3720', # U+7E95
        '32408' => '3721', # U+7E98
        '32410' => '3722', # U+7E9A
        '32413' => '3723', # U+7E9D
        '32414' => '3724', # U+7E9E
        '32571' => '3726', # U+7F3B
        '32572' => '3725', # U+7F3C
        '32573' => '3727', # U+7F3D
        '32574' => '3728', # U+7F3E
        '32575' => '3729', # U+7F3F
        '32579' => '3730', # U+7F43
        '32580' => '3731', # U+7F44
        '32583' => '3732', # U+7F47
        '32591' => '3733', # U+7F4F
        '32594' => '3734', # U+7F52
        '32595' => '3735', # U+7F53
        '32603' => '3736', # U+7F5B
        '32604' => '3737', # U+7F5C
        '32605' => '3738', # U+7F5D
        '32609' => '3739', # U+7F61
        '32611' => '3740', # U+7F63
        '32612' => '3741', # U+7F64
        '32613' => '3742', # U+7F65
        '32614' => '3743', # U+7F66
        '32621' => '3744', # U+7F6D
        '32625' => '3745', # U+7F71
        '32637' => '3746', # U+7F7D
        '32638' => '3747', # U+7F7E
        '32639' => '3748', # U+7F7F
        '32640' => '3749', # U+7F80
        '32651' => '3750', # U+7F8B
        '32653' => '3751', # U+7F8D
        '32655' => '3752', # U+7F8F
        '32656' => '3753', # U+7F90
        '32657' => '3754', # U+7F91
        '32662' => '3755', # U+7F96
        '32663' => '3756', # U+7F97
        '32668' => '3757', # U+7F9C
        '32673' => '3758', # U+7FA1
        '32674' => '3759', # U+7FA2
        '32678' => '3760', # U+7FA6
        '32682' => '3761', # U+7FAA
        '32685' => '3762', # U+7FAD
        '32692' => '3763', # U+7FB4
        '32700' => '3764', # U+7FBC
        '32703' => '3765', # U+7FBF
        '32704' => '3766', # U+7FC0
        '32707' => '3767', # U+7FC3
        '32712' => '3768', # U+7FC8
        '32718' => '3769', # U+7FCE
        '32719' => '3770', # U+7FCF
        '32731' => '3771', # U+7FDB
        '32735' => '3772', # U+7FDF
        '32739' => '3773', # U+7FE3
        '32741' => '3774', # U+7FE5
        '32744' => '3775', # U+7FE8
        '32748' => '3776', # U+7FEC
        '32750' => '3777', # U+7FEE
        '32751' => '3778', # U+7FEF
        '32754' => '3779', # U+7FF2
        '32762' => '3780', # U+7FFA
        '32765' => '3781', # U+7FFD
        '32766' => '3782', # U+7FFE
        '32767' => '3783', # U+7FFF
        '32775' => '3784', # U+8007
        '32776' => '3785', # U+8008
        '32778' => '3786', # U+800A
        '32781' => '3787', # U+800D
        '32782' => '3788', # U+800E
        '32783' => '3789', # U+800F
        '32785' => '3790', # U+8011
        '32787' => '3791', # U+8013
        '32788' => '3792', # U+8014
        '32790' => '3793', # U+8016
        '32797' => '3794', # U+801D
        '32798' => '3795', # U+801E
        '32799' => '3796', # U+801F
        '32800' => '3797', # U+8020
        '32804' => '3798', # U+8024
        '32806' => '3799', # U+8026
        '32812' => '3800', # U+802C
        '32814' => '3801', # U+802E
        '32816' => '3802', # U+8030
        '32820' => '3803', # U+8034
        '32821' => '3804', # U+8035
        '32823' => '3805', # U+8037
        '32825' => '3806', # U+8039
        '32826' => '3807', # U+803A
        '32828' => '3808', # U+803C
        '32830' => '3809', # U+803E
        '32832' => '3810', # U+8040
        '32836' => '3811', # U+8044
        '32864' => '3812', # U+8060
        '32868' => '3813', # U+8064
        '32870' => '3814', # U+8066
        '32877' => '3815', # U+806D
        '32881' => '3816', # U+8071
        '32885' => '3817', # U+8075
        '32897' => '3818', # U+8081
        '32904' => '3819', # U+8088
        '32910' => '3820', # U+808E
        '32924' => '3821', # U+809C
        '32926' => '3822', # U+809E
        '32934' => '3823', # U+80A6
        '32935' => '3824', # U+80A7
        '32939' => '3825', # U+80AB
        '32952' => '3826', # U+80B8
        '32953' => '3827', # U+80B9
        '32968' => '3828', # U+80C8
        '32973' => '3829', # U+80CD
        '32975' => '3830', # U+80CF
        '32978' => '3831', # U+80D2
        '32980' => '3832', # U+80D4
        '32981' => '3833', # U+80D5
        '32983' => '3834', # U+80D7
        '32984' => '3835', # U+80D8
        '32992' => '3836', # U+80E0
        '33005' => '3837', # U+80ED
        '33006' => '3838', # U+80EE
        '33008' => '3839', # U+80F0
        '33010' => '3840', # U+80F2
        '33011' => '3841', # U+80F3
        '33014' => '3842', # U+80F6
        '33017' => '3843', # U+80F9
        '33018' => '3844', # U+80FA
        '33022' => '3845', # U+80FE
        '33027' => '3846', # U+8103
        '33035' => '3847', # U+810B
        '33046' => '3848', # U+8116
        '33047' => '3849', # U+8117
        '33048' => '3850', # U+8118
        '33052' => '3851', # U+811C
        '33054' => '3852', # U+811E
        '33056' => '3853', # U+8120
        '33060' => '3854', # U+8124
        '33063' => '3855', # U+8127
        '33068' => '3856', # U+812C
        '33072' => '3857', # U+8130
        '33077' => '3858', # U+8135
        '33082' => '3859', # U+813A
        '33084' => '3860', # U+813C
        '33093' => '3861', # U+8145
        '33095' => '3862', # U+8147
        '33098' => '3863', # U+814A
        '33100' => '3864', # U+814C
        '33106' => '3865', # U+8152
        '33111' => '3866', # U+8157
        '33120' => '3867', # U+8160
        '33121' => '3868', # U+8161
        '33127' => '3869', # U+8167
        '33128' => '3870', # U+8168
        '33129' => '3871', # U+8169
        '33133' => '3872', # U+816D
        '33135' => '3873', # U+816F
        '33143' => '3874', # U+8177
        '33153' => '3875', # U+8181
        '33156' => '3877', # U+8184
        '33157' => '3878', # U+8185
        '33158' => '3879', # U+8186
        '33163' => '3880', # U+818B
        '33166' => '3881', # U+818E
        '33168' => '3876', # U+8190
        '33174' => '3882', # U+8196
        '33176' => '3883', # U+8198
        '33179' => '3884', # U+819B
        '33182' => '3885', # U+819E
        '33186' => '3886', # U+81A2
        '33198' => '3887', # U+81AE
        '33202' => '3888', # U+81B2
        '33204' => '3889', # U+81B4
        '33211' => '3890', # U+81BB
        '33219' => '3892', # U+81C3
        '33221' => '3893', # U+81C5
        '33226' => '3894', # U+81CA
        '33227' => '3891', # U+81CB
        '33230' => '3895', # U+81CE
        '33231' => '3896', # U+81CF
        '33237' => '3897', # U+81D5
        '33239' => '3898', # U+81D7
        '33243' => '3899', # U+81DB
        '33245' => '3900', # U+81DD
        '33246' => '3901', # U+81DE
        '33249' => '3902', # U+81E1
        '33252' => '3903', # U+81E4
        '33259' => '3904', # U+81EB
        '33260' => '3905', # U+81EC
        '33264' => '3906', # U+81F0
        '33265' => '3907', # U+81F1
        '33266' => '3908', # U+81F2
        '33269' => '3909', # U+81F5
        '33270' => '3910', # U+81F6
        '33272' => '3911', # U+81F8
        '33273' => '3912', # U+81F9
        '33277' => '3913', # U+81FD
        '33279' => '3914', # U+81FF
        '33280' => '3915', # U+8200
        '33283' => '3916', # U+8203
        '33295' => '3917', # U+820F
        '33299' => '3918', # U+8213
        '33300' => '3919', # U+8214
        '33305' => '3920', # U+8219
        '33306' => '3921', # U+821A
        '33309' => '3922', # U+821D
        '33313' => '3923', # U+8221
        '33314' => '3924', # U+8222
        '33320' => '3925', # U+8228
        '33330' => '3926', # U+8232
        '33332' => '3927', # U+8234
        '33338' => '3928', # U+823A
        '33347' => '3929', # U+8243
        '33348' => '3930', # U+8244
        '33349' => '3931', # U+8245
        '33350' => '3932', # U+8246
        '33355' => '3933', # U+824B
        '33358' => '3934', # U+824E
        '33359' => '3935', # U+824F
        '33361' => '3936', # U+8251
        '33366' => '3937', # U+8256
        '33372' => '3938', # U+825C
        '33376' => '3939', # U+8260
        '33379' => '3940', # U+8263
        '33383' => '3941', # U+8267
        '33389' => '3942', # U+826D
        '33396' => '3943', # U+8274
        '33403' => '3944', # U+827B
        '33405' => '3945', # U+827D
        '33407' => '3946', # U+827F
        '33408' => '3947', # U+8280
        '33409' => '3948', # U+8281
        '33411' => '3949', # U+8283
        '33412' => '3950', # U+8284
        '33415' => '3951', # U+8287
        '33417' => '3952', # U+8289
        '33418' => '3953', # U+828A
        '33422' => '3954', # U+828E
        '33425' => '3955', # U+8291
        '33428' => '3956', # U+8294
        '33430' => '3957', # U+8296
        '33432' => '3958', # U+8298
        '33434' => '3959', # U+829A
        '33435' => '3960', # U+829B
        '33440' => '3961', # U+82A0
        '33441' => '3962', # U+82A1
        '33443' => '3963', # U+82A3
        '33444' => '3964', # U+82A4
        '33447' => '3965', # U+82A7
        '33448' => '3966', # U+82A8
        '33449' => '3967', # U+82A9
        '33450' => '3968', # U+82AA
        '33454' => '3969', # U+82AE
        '33456' => '3970', # U+82B0
        '33458' => '3971', # U+82B2
        '33460' => '3972', # U+82B4
        '33463' => '3973', # U+82B7
        '33466' => '3974', # U+82BA
        '33468' => '3975', # U+82BC
        '33470' => '3976', # U+82BE
        '33471' => '3977', # U+82BF
        '33478' => '3978', # U+82C6
        '33488' => '3979', # U+82D0
        '33493' => '3980', # U+82D5
        '33498' => '3981', # U+82DA
        '33504' => '3982', # U+82E0
        '33506' => '3983', # U+82E2
        '33508' => '3984', # U+82E4
        '33512' => '3985', # U+82E8
        '33514' => '3986', # U+82EA
        '33517' => '3987', # U+82ED
        '33519' => '3988', # U+82EF
        '33526' => '3989', # U+82F6
        '33527' => '3990', # U+82F7
        '33533' => '3991', # U+82FD
        '33534' => '3992', # U+82FE
        '33536' => '3993', # U+8300
        '33537' => '3994', # U+8301
        '33543' => '3995', # U+8307
        '33544' => '3996', # U+8308
        '33546' => '3997', # U+830A
        '33547' => '3998', # U+830B
        '33563' => '4000', # U+831B
        '33565' => '4001', # U+831D
        '33566' => '4002', # U+831E
        '33567' => '4003', # U+831F
        '33569' => '4004', # U+8321
        '33570' => '4005', # U+8322
        '33580' => '4006', # U+832C
        '33581' => '4007', # U+832D
        '33582' => '4008', # U+832E
        '33584' => '4009', # U+8330
        '33587' => '4010', # U+8333
        '33591' => '4011', # U+8337
        '33594' => '4012', # U+833A
        '33596' => '4013', # U+833C
        '33597' => '4014', # U+833D
        '33602' => '4015', # U+8342
        '33603' => '4016', # U+8343
        '33604' => '4017', # U+8344
        '33607' => '4018', # U+8347
        '33613' => '4019', # U+834D
        '33614' => '4020', # U+834E
        '33617' => '4021', # U+8351
        '33619' => '4056', # U+8353
        '33620' => '3999', # U+8354
        '33621' => '4022', # U+8355
        '33622' => '4023', # U+8356
        '33623' => '4024', # U+8357
        '33648' => '4025', # U+8370
        '33656' => '4026', # U+8378
        '33661' => '4027', # U+837D
        '33663' => '4028', # U+837F
        '33664' => '4029', # U+8380
        '33666' => '4030', # U+8382
        '33668' => '4031', # U+8384
        '33670' => '4032', # U+8386
        '33677' => '4033', # U+838D
        '33682' => '4034', # U+8392
        '33684' => '4035', # U+8394
        '33685' => '4036', # U+8395
        '33688' => '4037', # U+8398
        '33689' => '4038', # U+8399
        '33691' => '4039', # U+839B
        '33692' => '4040', # U+839C
        '33693' => '4041', # U+839D
        '33702' => '4042', # U+83A6
        '33703' => '4043', # U+83A7
        '33705' => '4044', # U+83A9
        '33708' => '4045', # U+83AC
        '33709' => '4070', # U+83AD
        '33726' => '4046', # U+83BE
        '33727' => '4047', # U+83BF
        '33728' => '4048', # U+83C0
        '33735' => '4049', # U+83C7
        '33737' => '4050', # U+83C9
        '33743' => '4051', # U+83CF
        '33744' => '4052', # U+83D0
        '33745' => '4053', # U+83D1
        '33748' => '4054', # U+83D4
        '33757' => '4055', # U+83DD
        '33768' => '4057', # U+83E8
        '33770' => '4058', # U+83EA
        '33782' => '4059', # U+83F6
        '33784' => '4060', # U+83F8
        '33785' => '4061', # U+83F9
        '33788' => '4062', # U+83FC
        '33793' => '4063', # U+8401
        '33798' => '4064', # U+8406
        '33802' => '4065', # U+840A
        '33807' => '4066', # U+840F
        '33809' => '4067', # U+8411
        '33813' => '4068', # U+8415
        '33817' => '4069', # U+8419
        '33839' => '4071', # U+842F
        '33849' => '4072', # U+8439
        '33861' => '4073', # U+8445
        '33863' => '4074', # U+8447
        '33864' => '4075', # U+8448
        '33866' => '4076', # U+844A
        '33869' => '4077', # U+844D
        '33871' => '4078', # U+844F
        '33873' => '4079', # U+8451
        '33874' => '4080', # U+8452
        '33878' => '4081', # U+8456
        '33880' => '4082', # U+8458
        '33881' => '4083', # U+8459
        '33882' => '4084', # U+845A
        '33884' => '4085', # U+845C
        '33888' => '4086', # U+8460
        '33892' => '4087', # U+8464
        '33893' => '4088', # U+8465
        '33895' => '4089', # U+8467
        '33898' => '4090', # U+846A
        '33904' => '4091', # U+8470
        '33907' => '4092', # U+8473
        '33908' => '4093', # U+8474
        '33910' => '4094', # U+8476
        '33912' => '4095', # U+8478
        '33916' => '4096', # U+847C
        '33917' => '4097', # U+847D
        '33921' => '4098', # U+8481
        '33925' => '4099', # U+8485
        '33938' => '4100', # U+8492
        '33939' => '4101', # U+8493
        '33941' => '4102', # U+8495
        '33950' => '4103', # U+849E
        '33958' => '4104', # U+84A6
        '33960' => '4105', # U+84A8
        '33961' => '4106', # U+84A9
        '33962' => '4107', # U+84AA
        '33967' => '4108', # U+84AF
        '33969' => '4109', # U+84B1
        '33972' => '4110', # U+84B4
        '33978' => '4111', # U+84BA
        '33981' => '4112', # U+84BD
        '33982' => '4113', # U+84BE
        '33984' => '4114', # U+84C0
        '33986' => '4115', # U+84C2
        '33991' => '4116', # U+84C7
        '33992' => '4117', # U+84C8
        '33996' => '4118', # U+84CC
        '33999' => '4119', # U+84CF
        '34003' => '4120', # U+84D3
        '34012' => '4121', # U+84DC
        '34023' => '4122', # U+84E7
        '34026' => '4123', # U+84EA
        '34031' => '4124', # U+84EF
        '34032' => '4125', # U+84F0
        '34033' => '4126', # U+84F1
        '34034' => '4127', # U+84F2
        '34039' => '4128', # U+84F7
        '34042' => '4130', # U+84FA
        '34043' => '4131', # U+84FB
        '34045' => '4132', # U+84FD
        '34050' => '4133', # U+8502
        '34051' => '4134', # U+8503
        '34055' => '4135', # U+8507
        '34060' => '4136', # U+850C
        '34062' => '4137', # U+850E
        '34064' => '4138', # U+8510
        '34076' => '4139', # U+851C
        '34078' => '4140', # U+851E
        '34082' => '4141', # U+8522
        '34083' => '4142', # U+8523
        '34084' => '4143', # U+8524
        '34085' => '4144', # U+8525
        '34087' => '4145', # U+8527
        '34090' => '4146', # U+852A
        '34091' => '4147', # U+852B
        '34095' => '4148', # U+852F
        '34098' => '4129', # U+8532
        '34099' => '4149', # U+8533
        '34100' => '4150', # U+8534
        '34102' => '4151', # U+8536
        '34111' => '4152', # U+853F
        '34118' => '4153', # U+8546
        '34127' => '4154', # U+854F
        '34128' => '4155', # U+8550
        '34129' => '4156', # U+8551
        '34130' => '4157', # U+8552
        '34131' => '4158', # U+8553
        '34134' => '4159', # U+8556
        '34137' => '4160', # U+8559
        '34140' => '4161', # U+855C
        '34141' => '4162', # U+855D
        '34142' => '4163', # U+855E
        '34143' => '4164', # U+855F
        '34144' => '4165', # U+8560
        '34145' => '4166', # U+8561
        '34146' => '4167', # U+8562
        '34148' => '4168', # U+8564
        '34155' => '4169', # U+856B
        '34159' => '4170', # U+856F
        '34169' => '4171', # U+8579
        '34170' => '4172', # U+857A
        '34171' => '4173', # U+857B
        '34173' => '4174', # U+857D
        '34175' => '4175', # U+857F
        '34177' => '4176', # U+8581
        '34181' => '4177', # U+8585
        '34182' => '4178', # U+8586
        '34185' => '4179', # U+8589
        '34187' => '4180', # U+858B
        '34188' => '4181', # U+858C
        '34191' => '4182', # U+858F
        '34195' => '4183', # U+8593
        '34200' => '4184', # U+8598
        '34205' => '4185', # U+859D
        '34207' => '4186', # U+859F
        '34208' => '4187', # U+85A0
        '34210' => '4188', # U+85A2
        '34213' => '4189', # U+85A5
        '34215' => '4190', # U+85A7
        '34221' => '4204', # U+85AD
        '34228' => '4191', # U+85B4
        '34230' => '4192', # U+85B6
        '34231' => '4193', # U+85B7
        '34232' => '4194', # U+85B8
        '34236' => '4195', # U+85BC
        '34237' => '4196', # U+85BD
        '34238' => '4197', # U+85BE
        '34239' => '4198', # U+85BF
        '34242' => '4199', # U+85C2
        '34247' => '4200', # U+85C7
        '34250' => '4201', # U+85CA
        '34251' => '4202', # U+85CB
        '34254' => '4203', # U+85CE
        '34264' => '4205', # U+85D8
        '34266' => '4206', # U+85DA
        '34271' => '4207', # U+85DF
        '34272' => '4208', # U+85E0
        '34278' => '4209', # U+85E6
        '34280' => '4210', # U+85E8
        '34285' => '4211', # U+85ED
        '34291' => '4212', # U+85F3
        '34294' => '4213', # U+85F6
        '34300' => '4214', # U+85FC
        '34303' => '4215', # U+85FF
        '34304' => '4216', # U+8600
        '34308' => '4217', # U+8604
        '34309' => '4218', # U+8605
        '34317' => '4219', # U+860D
        '34318' => '4220', # U+860E
        '34320' => '4221', # U+8610
        '34321' => '4222', # U+8611
        '34322' => '4223', # U+8612
        '34328' => '4224', # U+8618
        '34329' => '4225', # U+8619
        '34331' => '4226', # U+861B
        '34334' => '4227', # U+861E
        '34337' => '4228', # U+8621
        '34343' => '4229', # U+8627
        '34345' => '4230', # U+8629
        '34358' => '4231', # U+8636
        '34360' => '4232', # U+8638
        '34362' => '4233', # U+863A
        '34364' => '4234', # U+863C
        '34365' => '4235', # U+863D
        '34368' => '4236', # U+8640
        '34369' => '1088', # U+8641
        '34370' => '4237', # U+8642
        '34374' => '4238', # U+8646
        '34386' => '4239', # U+8652
        '34387' => '4240', # U+8653
        '34390' => '4241', # U+8656
        '34391' => '4242', # U+8657
        '34392' => '4243', # U+8658
        '34393' => '4244', # U+8659
        '34397' => '4245', # U+865D
        '34400' => '4246', # U+8660
        '34401' => '4247', # U+8661
        '34402' => '4248', # U+8662
        '34403' => '4249', # U+8663
        '34404' => '4250', # U+8664
        '34409' => '4251', # U+8669
        '34412' => '4252', # U+866C
        '34415' => '4253', # U+866F
        '34421' => '4254', # U+8675
        '34422' => '4255', # U+8676
        '34423' => '4256', # U+8677
        '34426' => '4257', # U+867A
        '34440' => '4291', # U+8688
        '34445' => '4258', # U+868D
        '34449' => '4259', # U+8691
        '34454' => '4260', # U+8696
        '34456' => '4261', # U+8698
        '34458' => '4262', # U+869A
        '34460' => '4263', # U+869C
        '34465' => '4264', # U+86A1
        '34470' => '4265', # U+86A6
        '34471' => '4266', # U+86A7
        '34472' => '4267', # U+86A8
        '34477' => '4268', # U+86AD
        '34481' => '4269', # U+86B1
        '34483' => '4270', # U+86B3
        '34484' => '4271', # U+86B4
        '34485' => '4272', # U+86B5
        '34487' => '4273', # U+86B7
        '34488' => '4274', # U+86B8
        '34489' => '4275', # U+86B9
        '34495' => '4276', # U+86BF
        '34496' => '4277', # U+86C0
        '34497' => '4278', # U+86C1
        '34499' => '4279', # U+86C3
        '34501' => '4280', # U+86C5
        '34513' => '4281', # U+86D1
        '34514' => '4282', # U+86D2
        '34517' => '4283', # U+86D5
        '34519' => '4284', # U+86D7
        '34522' => '4285', # U+86DA
        '34524' => '4286', # U+86DC
        '34528' => '4287', # U+86E0
        '34531' => '4288', # U+86E3
        '34533' => '4289', # U+86E5
        '34535' => '4290', # U+86E7
        '34554' => '4292', # U+86FA
        '34556' => '4293', # U+86FC
        '34557' => '4294', # U+86FD
        '34564' => '4295', # U+8704
        '34565' => '4296', # U+8705
        '34567' => '4297', # U+8707
        '34571' => '4298', # U+870B
        '34574' => '4299', # U+870E
        '34575' => '4300', # U+870F
        '34576' => '4301', # U+8710
        '34579' => '4302', # U+8713
        '34580' => '4303', # U+8714
        '34585' => '4304', # U+8719
        '34590' => '4305', # U+871E
        '34591' => '4306', # U+871F
        '34593' => '4307', # U+8721
        '34595' => '4308', # U+8723
        '34600' => '4309', # U+8728
        '34606' => '4310', # U+872E
        '34607' => '4311', # U+872F
        '34609' => '4312', # U+8731
        '34610' => '4313', # U+8732
        '34617' => '4314', # U+8739
        '34618' => '4315', # U+873A
        '34620' => '4316', # U+873C
        '34621' => '4317', # U+873D
        '34622' => '4318', # U+873E
        '34624' => '4319', # U+8740
        '34627' => '4320', # U+8743
        '34629' => '4321', # U+8745
        '34637' => '4322', # U+874D
        '34648' => '4323', # U+8758
        '34653' => '4324', # U+875D
        '34657' => '4325', # U+8761
        '34660' => '4326', # U+8764
        '34661' => '4327', # U+8765
        '34671' => '4328', # U+876F
        '34673' => '4329', # U+8771
        '34674' => '4330', # U+8772
        '34683' => '4331', # U+877B
        '34691' => '4332', # U+8783
        '34692' => '4333', # U+8784
        '34693' => '4334', # U+8785
        '34694' => '4335', # U+8786
        '34695' => '4336', # U+8787
        '34696' => '4337', # U+8788
        '34697' => '4338', # U+8789
        '34699' => '4339', # U+878B
        '34700' => '4340', # U+878C
        '34704' => '4341', # U+8790
        '34707' => '4342', # U+8793
        '34709' => '4343', # U+8795
        '34711' => '4344', # U+8797
        '34712' => '4345', # U+8798
        '34713' => '4346', # U+8799
        '34718' => '4347', # U+879E
        '34720' => '4348', # U+87A0
        '34723' => '4349', # U+87A3
        '34727' => '4350', # U+87A7
        '34732' => '4351', # U+87AC
        '34733' => '4352', # U+87AD
        '34734' => '4353', # U+87AE
        '34737' => '4354', # U+87B1
        '34741' => '4355', # U+87B5
        '34750' => '4356', # U+87BE
        '34751' => '4357', # U+87BF
        '34753' => '4358', # U+87C1
        '34760' => '4359', # U+87C8
        '34761' => '4360', # U+87C9
        '34762' => '4361', # U+87CA
        '34766' => '4362', # U+87CE
        '34773' => '4363', # U+87D5
        '34774' => '4364', # U+87D6
        '34777' => '4365', # U+87D9
        '34778' => '4366', # U+87DA
        '34780' => '4367', # U+87DC
        '34783' => '4368', # U+87DF
        '34786' => '4369', # U+87E2
        '34787' => '4370', # U+87E3
        '34788' => '4371', # U+87E4
        '34794' => '4372', # U+87EA
        '34795' => '4373', # U+87EB
        '34797' => '4374', # U+87ED
        '34801' => '4375', # U+87F1
        '34803' => '4376', # U+87F3
        '34808' => '4377', # U+87F8
        '34810' => '4378', # U+87FA
        '34815' => '4379', # U+87FF
        '34817' => '4380', # U+8801
        '34819' => '4381', # U+8803
        '34822' => '4382', # U+8806
        '34825' => '4383', # U+8809
        '34826' => '4384', # U+880A
        '34827' => '4385', # U+880B
        '34832' => '4386', # U+8810
        '34834' => '4388', # U+8812
        '34835' => '4389', # U+8813
        '34836' => '4390', # U+8814
        '34840' => '4391', # U+8818
        '34841' => '4387', # U+8819
        '34842' => '4392', # U+881A
        '34843' => '4393', # U+881B
        '34844' => '4394', # U+881C
        '34846' => '4395', # U+881E
        '34847' => '4396', # U+881F
        '34856' => '4397', # U+8828
        '34861' => '4398', # U+882D
        '34862' => '4399', # U+882E
        '34864' => '4400', # U+8830
        '34866' => '4401', # U+8832
        '34869' => '4402', # U+8835
        '34874' => '4403', # U+883A
        '34876' => '4404', # U+883C
        '34881' => '4405', # U+8841
        '34883' => '4406', # U+8843
        '34885' => '4407', # U+8845
        '34888' => '4408', # U+8848
        '34889' => '4409', # U+8849
        '34890' => '4410', # U+884A
        '34891' => '4411', # U+884B
        '34894' => '4412', # U+884E
        '34897' => '4413', # U+8851
        '34901' => '4414', # U+8855
        '34902' => '4415', # U+8856
        '34904' => '4416', # U+8858
        '34906' => '4417', # U+885A
        '34908' => '4418', # U+885C
        '34911' => '4419', # U+885F
        '34912' => '4420', # U+8860
        '34916' => '4421', # U+8864
        '34921' => '4422', # U+8869
        '34929' => '4423', # U+8871
        '34937' => '4424', # U+8879
        '34939' => '4425', # U+887B
        '34944' => '4426', # U+8880
        '34968' => '4427', # U+8898
        '34970' => '4428', # U+889A
        '34971' => '4429', # U+889B
        '34972' => '4430', # U+889C
        '34975' => '4431', # U+889F
        '34976' => '4432', # U+88A0
        '34984' => '4433', # U+88A8
        '34986' => '4434', # U+88AA
        '35002' => '4435', # U+88BA
        '35005' => '4436', # U+88BD
        '35006' => '4437', # U+88BE
        '35008' => '4438', # U+88C0
        '35018' => '4439', # U+88CA
        '35019' => '4440', # U+88CB
        '35020' => '4441', # U+88CC
        '35021' => '4442', # U+88CD
        '35022' => '4443', # U+88CE
        '35025' => '4444', # U+88D1
        '35026' => '4445', # U+88D2
        '35027' => '4446', # U+88D3
        '35035' => '4447', # U+88DB
        '35038' => '4448', # U+88DE
        '35047' => '4449', # U+88E7
        '35055' => '4450', # U+88EF
        '35056' => '4451', # U+88F0
        '35057' => '4452', # U+88F1
        '35061' => '4453', # U+88F5
        '35063' => '4454', # U+88F7
        '35073' => '4455', # U+8901
        '35078' => '4456', # U+8906
        '35085' => '4457', # U+890D
        '35086' => '4458', # U+890E
        '35087' => '4459', # U+890F
        '35093' => '4460', # U+8915
        '35094' => '4461', # U+8916
        '35096' => '4462', # U+8918
        '35097' => '4463', # U+8919
        '35098' => '4464', # U+891A
        '35100' => '4465', # U+891C
        '35104' => '4466', # U+8920
        '35110' => '4467', # U+8926
        '35111' => '4468', # U+8927
        '35112' => '4469', # U+8928
        '35120' => '4470', # U+8930
        '35121' => '4471', # U+8931
        '35122' => '4472', # U+8932
        '35125' => '4473', # U+8935
        '35129' => '4474', # U+8939
        '35130' => '4475', # U+893A
        '35134' => '4476', # U+893E
        '35136' => '4477', # U+8940
        '35138' => '4478', # U+8942
        '35141' => '4479', # U+8945
        '35142' => '4480', # U+8946
        '35145' => '4481', # U+8949
        '35151' => '4482', # U+894F
        '35154' => '4483', # U+8952
        '35159' => '4484', # U+8957
        '35162' => '4485', # U+895A
        '35163' => '4486', # U+895B
        '35164' => '4487', # U+895C
        '35169' => '4488', # U+8961
        '35170' => '4489', # U+8962
        '35171' => '4490', # U+8963
        '35179' => '4491', # U+896B
        '35182' => '4492', # U+896E
        '35184' => '4493', # U+8970
        '35187' => '4494', # U+8973
        '35189' => '4495', # U+8975
        '35194' => '4496', # U+897A
        '35195' => '4497', # U+897B
        '35196' => '4498', # U+897C
        '35197' => '4499', # U+897D
        '35209' => '4500', # U+8989
        '35213' => '4501', # U+898D
        '35216' => '4502', # U+8990
        '35220' => '4503', # U+8994
        '35221' => '4504', # U+8995
        '35227' => '4505', # U+899B
        '35228' => '4506', # U+899C
        '35231' => '4507', # U+899F
        '35232' => '4508', # U+89A0
        '35237' => '4509', # U+89A5
        '35248' => '4510', # U+89B0
        '35252' => '4511', # U+89B4
        '35253' => '4512', # U+89B5
        '35254' => '4513', # U+89B6
        '35255' => '4514', # U+89B7
        '35260' => '4515', # U+89BC
        '35284' => '4516', # U+89D4
        '35285' => '4517', # U+89D5
        '35286' => '4518', # U+89D6
        '35287' => '4519', # U+89D7
        '35288' => '4520', # U+89D8
        '35301' => '4521', # U+89E5
        '35305' => '4522', # U+89E9
        '35307' => '4523', # U+89EB
        '35309' => '4524', # U+89ED
        '35313' => '4525', # U+89F1
        '35315' => '4526', # U+89F3
        '35318' => '4527', # U+89F6
        '35321' => '4528', # U+89F9
        '35325' => '4529', # U+89FD
        '35327' => '4530', # U+89FF
        '35332' => '4531', # U+8A04
        '35333' => '4532', # U+8A05
        '35335' => '4533', # U+8A07
        '35343' => '4534', # U+8A0F
        '35345' => '4535', # U+8A11
        '35346' => '4536', # U+8A12
        '35348' => '4537', # U+8A14
        '35349' => '4538', # U+8A15
        '35358' => '4539', # U+8A1E
        '35360' => '4540', # U+8A20
        '35362' => '4541', # U+8A22
        '35364' => '4542', # U+8A24
        '35366' => '4543', # U+8A26
        '35371' => '4544', # U+8A2B
        '35372' => '4545', # U+8A2C
        '35375' => '4546', # U+8A2F
        '35381' => '4547', # U+8A35
        '35383' => '4548', # U+8A37
        '35389' => '4549', # U+8A3D
        '35390' => '4550', # U+8A3E
        '35392' => '4551', # U+8A40
        '35395' => '4552', # U+8A43
        '35397' => '4553', # U+8A45
        '35399' => '4554', # U+8A47
        '35401' => '4555', # U+8A49
        '35405' => '4556', # U+8A4D
        '35406' => '4557', # U+8A4E
        '35411' => '4558', # U+8A53
        '35414' => '4559', # U+8A56
        '35415' => '4560', # U+8A57
        '35416' => '4561', # U+8A58
        '35420' => '4562', # U+8A5C
        '35421' => '4563', # U+8A5D
        '35425' => '4564', # U+8A61
        '35429' => '4565', # U+8A65
        '35431' => '4566', # U+8A67
        '35445' => '4567', # U+8A75
        '35446' => '4568', # U+8A76
        '35447' => '4569', # U+8A77
        '35449' => '4570', # U+8A79
        '35450' => '4571', # U+8A7A
        '35451' => '4572', # U+8A7B
        '35454' => '4573', # U+8A7E
        '35455' => '4574', # U+8A7F
        '35456' => '4575', # U+8A80
        '35459' => '4576', # U+8A83
        '35462' => '4577', # U+8A86
        '35467' => '4578', # U+8A8B
        '35471' => '4579', # U+8A8F
        '35472' => '4580', # U+8A90
        '35474' => '4581', # U+8A92
        '35478' => '4582', # U+8A96
        '35479' => '4583', # U+8A97
        '35481' => '4584', # U+8A99
        '35487' => '4585', # U+8A9F
        '35495' => '4586', # U+8AA7
        '35497' => '4587', # U+8AA9
        '35502' => '4588', # U+8AAE
        '35503' => '4589', # U+8AAF
        '35507' => '4590', # U+8AB3
        '35510' => '4591', # U+8AB6
        '35511' => '4592', # U+8AB7
        '35515' => '4593', # U+8ABB
        '35518' => '4594', # U+8ABE
        '35523' => '4595', # U+8AC3
        '35526' => '4596', # U+8AC6
        '35528' => '4597', # U+8AC8
        '35529' => '4598', # U+8AC9
        '35530' => '4599', # U+8ACA
        '35537' => '4600', # U+8AD1
        '35539' => '4601', # U+8AD3
        '35540' => '4602', # U+8AD4
        '35541' => '4603', # U+8AD5
        '35543' => '4604', # U+8AD7
        '35549' => '4605', # U+8ADD
        '35551' => '4606', # U+8ADF
        '35564' => '4607', # U+8AEC
        '35568' => '4608', # U+8AF0
        '35572' => '4609', # U+8AF4
        '35573' => '4610', # U+8AF5
        '35574' => '4611', # U+8AF6
        '35580' => '4612', # U+8AFC
        '35583' => '4613', # U+8AFF
        '35589' => '4614', # U+8B05
        '35590' => '4615', # U+8B06
        '35594' => '4621', # U+8B0A
        '35595' => '4616', # U+8B0B
        '35601' => '4617', # U+8B11
        '35612' => '4618', # U+8B1C
        '35614' => '4619', # U+8B1E
        '35615' => '4620', # U+8B1F
        '35629' => '4622', # U+8B2D
        '35632' => '4623', # U+8B30
        '35639' => '4624', # U+8B37
        '35644' => '4625', # U+8B3C
        '35650' => '4626', # U+8B42
        '35651' => '4627', # U+8B43
        '35652' => '4628', # U+8B44
        '35653' => '4629', # U+8B45
        '35654' => '4630', # U+8B46
        '35656' => '4631', # U+8B48
        '35661' => '4636', # U+8B4D
        '35666' => '4632', # U+8B52
        '35667' => '4633', # U+8B53
        '35668' => '4634', # U+8B54
        '35673' => '4635', # U+8B59
        '35678' => '4637', # U+8B5E
        '35683' => '4638', # U+8B63
        '35693' => '4639', # U+8B6D
        '35702' => '4640', # U+8B76
        '35704' => '4641', # U+8B78
        '35705' => '4642', # U+8B79
        '35708' => '4643', # U+8B7C
        '35710' => '4644', # U+8B7E
        '35713' => '4645', # U+8B81
        '35716' => '4646', # U+8B84
        '35717' => '4647', # U+8B85
        '35723' => '4648', # U+8B8B
        '35725' => '4649', # U+8B8D
        '35727' => '4650', # U+8B8F
        '35732' => '4651', # U+8B94
        '35733' => '4652', # U+8B95
        '35740' => '4653', # U+8B9C
        '35742' => '4654', # U+8B9E
        '35743' => '4655', # U+8B9F
        '35896' => '4656', # U+8C38
        '35897' => '4657', # U+8C39
        '35901' => '4658', # U+8C3D
        '35902' => '4659', # U+8C3E
        '35909' => '4660', # U+8C45
        '35911' => '4661', # U+8C47
        '35913' => '4662', # U+8C49
        '35915' => '4663', # U+8C4B
        '35919' => '4664', # U+8C4F
        '35921' => '4665', # U+8C51
        '35923' => '4666', # U+8C53
        '35924' => '4667', # U+8C54
        '35927' => '4668', # U+8C57
        '35928' => '4669', # U+8C58
        '35929' => '4672', # U+8C59
        '35931' => '4670', # U+8C5B
        '35933' => '4671', # U+8C5D
        '35939' => '4673', # U+8C63
        '35940' => '4674', # U+8C64
        '35942' => '4675', # U+8C66
        '35944' => '4676', # U+8C68
        '35945' => '4677', # U+8C69
        '35949' => '4678', # U+8C6D
        '35955' => '4679', # U+8C73
        '35957' => '4680', # U+8C75
        '35958' => '4681', # U+8C76
        '35963' => '4682', # U+8C7B
        '35966' => '4683', # U+8C7E
        '35974' => '4684', # U+8C86
        '35975' => '4685', # U+8C87
        '35979' => '4686', # U+8C8B
        '35984' => '4687', # U+8C90
        '35986' => '4688', # U+8C92
        '35987' => '4689', # U+8C93
        '35993' => '4690', # U+8C99
        '35995' => '4691', # U+8C9B
        '35996' => '4692', # U+8C9C
        '36004' => '4693', # U+8CA4
        '36025' => '4694', # U+8CB9
        '36026' => '4695', # U+8CBA
        '36037' => '4696', # U+8CC5
        '36038' => '4697', # U+8CC6
        '36041' => '4698', # U+8CC9
        '36043' => '4699', # U+8CCB
        '36047' => '4700', # U+8CCF
        '36053' => '4702', # U+8CD5
        '36054' => '4701', # U+8CD6
        '36057' => '4703', # U+8CD9
        '36061' => '4704', # U+8CDD
        '36065' => '4705', # U+8CE1
        '36072' => '4706', # U+8CE8
        '36076' => '4707', # U+8CEC
        '36079' => '4708', # U+8CEF
        '36080' => '4709', # U+8CF0
        '36082' => '4710', # U+8CF2
        '36085' => '4711', # U+8CF5
        '36087' => '4712', # U+8CF7
        '36088' => '4713', # U+8CF8
        '36094' => '4714', # U+8CFE
        '36095' => '4715', # U+8CFF
        '36097' => '4716', # U+8D01
        '36099' => '4717', # U+8D03
        '36105' => '4718', # U+8D09
        '36114' => '4719', # U+8D12
        '36119' => '4720', # U+8D17
        '36123' => '4721', # U+8D1B
        '36197' => '4722', # U+8D65
        '36201' => '4723', # U+8D69
        '36204' => '4724', # U+8D6C
        '36206' => '4725', # U+8D6E
        '36223' => '4726', # U+8D7F
        '36226' => '4727', # U+8D82
        '36228' => '4728', # U+8D84
        '36232' => '4729', # U+8D88
        '36237' => '4730', # U+8D8D
        '36240' => '4731', # U+8D90
        '36241' => '4732', # U+8D91
        '36245' => '4733', # U+8D95
        '36254' => '4734', # U+8D9E
        '36255' => '4735', # U+8D9F
        '36256' => '4736', # U+8DA0
        '36262' => '4737', # U+8DA6
        '36267' => '4738', # U+8DAB
        '36268' => '4739', # U+8DAC
        '36271' => '4740', # U+8DAF
        '36274' => '4741', # U+8DB2
        '36277' => '4742', # U+8DB5
        '36279' => '4743', # U+8DB7
        '36281' => '4744', # U+8DB9
        '36283' => '4745', # U+8DBB
        '36284' => '4763', # U+8DBC
        '36288' => '4746', # U+8DC0
        '36293' => '4747', # U+8DC5
        '36294' => '4748', # U+8DC6
        '36295' => '4749', # U+8DC7
        '36296' => '4750', # U+8DC8
        '36298' => '4751', # U+8DCA
        '36302' => '4752', # U+8DCE
        '36305' => '4753', # U+8DD1
        '36308' => '4754', # U+8DD4
        '36309' => '4755', # U+8DD5
        '36311' => '4756', # U+8DD7
        '36313' => '4757', # U+8DD9
        '36324' => '4758', # U+8DE4
        '36325' => '4759', # U+8DE5
        '36327' => '4760', # U+8DE7
        '36332' => '4761', # U+8DEC
        '36336' => '4762', # U+8DF0
        '36337' => '4764', # U+8DF1
        '36338' => '4765', # U+8DF2
        '36340' => '4766', # U+8DF4
        '36349' => '4767', # U+8DFD
        '36353' => '4768', # U+8E01
        '36356' => '4769', # U+8E04
        '36357' => '4770', # U+8E05
        '36358' => '4771', # U+8E06
        '36363' => '4772', # U+8E0B
        '36369' => '4773', # U+8E11
        '36372' => '4774', # U+8E14
        '36374' => '4775', # U+8E16
        '36384' => '4776', # U+8E20
        '36385' => '4777', # U+8E21
        '36386' => '4778', # U+8E22
        '36387' => '4779', # U+8E23
        '36390' => '4780', # U+8E26
        '36391' => '4781', # U+8E27
        '36401' => '4782', # U+8E31
        '36403' => '4783', # U+8E33
        '36406' => '4784', # U+8E36
        '36407' => '4785', # U+8E37
        '36408' => '4786', # U+8E38
        '36409' => '4787', # U+8E39
        '36413' => '4788', # U+8E3D
        '36416' => '4789', # U+8E40
        '36417' => '4790', # U+8E41
        '36427' => '4791', # U+8E4B
        '36429' => '4792', # U+8E4D
        '36430' => '4793', # U+8E4E
        '36431' => '4794', # U+8E4F
        '36436' => '4795', # U+8E54
        '36443' => '4796', # U+8E5B
        '36444' => '4797', # U+8E5C
        '36445' => '4798', # U+8E5D
        '36446' => '4799', # U+8E5E
        '36449' => '4800', # U+8E61
        '36450' => '4801', # U+8E62
        '36457' => '4802', # U+8E69
        '36460' => '4803', # U+8E6C
        '36461' => '4804', # U+8E6D
        '36463' => '4805', # U+8E6F
        '36464' => '4806', # U+8E70
        '36465' => '4807', # U+8E71
        '36473' => '4808', # U+8E79
        '36474' => '4809', # U+8E7A
        '36475' => '4810', # U+8E7B
        '36482' => '4811', # U+8E82
        '36483' => '4812', # U+8E83
        '36489' => '4813', # U+8E89
        '36496' => '4814', # U+8E90
        '36498' => '4815', # U+8E92
        '36501' => '4816', # U+8E95
        '36506' => '4817', # U+8E9A
        '36507' => '4818', # U+8E9B
        '36509' => '4819', # U+8E9D
        '36510' => '4820', # U+8E9E
        '36514' => '4821', # U+8EA2
        '36519' => '4822', # U+8EA7
        '36521' => '4823', # U+8EA9
        '36525' => '4824', # U+8EAD
        '36526' => '4825', # U+8EAE
        '36531' => '4826', # U+8EB3
        '36533' => '4827', # U+8EB5
        '36538' => '4828', # U+8EBA
        '36539' => '4829', # U+8EBB
        '36544' => '4830', # U+8EC0
        '36545' => '4831', # U+8EC1
        '36547' => '4832', # U+8EC3
        '36548' => '4833', # U+8EC4
        '36551' => '4834', # U+8EC7
        '36559' => '4835', # U+8ECF
        '36561' => '4836', # U+8ED1
        '36564' => '4837', # U+8ED4
        '36572' => '4838', # U+8EDC
        '36584' => '4839', # U+8EE8
        '36589' => '4846', # U+8EED
        '36590' => '4840', # U+8EEE
        '36592' => '4841', # U+8EF0
        '36593' => '4842', # U+8EF1
        '36599' => '4843', # U+8EF7
        '36601' => '4844', # U+8EF9
        '36602' => '4845', # U+8EFA
        '36608' => '4847', # U+8F00
        '36610' => '4848', # U+8F02
        '36615' => '4849', # U+8F07
        '36616' => '4850', # U+8F08
        '36623' => '4851', # U+8F0F
        '36624' => '4852', # U+8F10
        '36630' => '4853', # U+8F16
        '36631' => '4854', # U+8F17
        '36632' => '4855', # U+8F18
        '36638' => '4856', # U+8F1E
        '36640' => '4857', # U+8F20
        '36641' => '4858', # U+8F21
        '36643' => '4859', # U+8F23
        '36645' => '4860', # U+8F25
        '36647' => '4861', # U+8F27
        '36648' => '4862', # U+8F28
        '36652' => '4863', # U+8F2C
        '36653' => '4864', # U+8F2D
        '36654' => '4865', # U+8F2E
        '36660' => '4866', # U+8F34
        '36661' => '4867', # U+8F35
        '36662' => '4868', # U+8F36
        '36663' => '4869', # U+8F37
        '36666' => '4870', # U+8F3A
        '36672' => '4871', # U+8F40
        '36673' => '4872', # U+8F41
        '36675' => '4873', # U+8F43
        '36679' => '4874', # U+8F47
        '36687' => '4875', # U+8F4F
        '36689' => '4876', # U+8F51
        '36690' => '4877', # U+8F52
        '36691' => '4878', # U+8F53
        '36692' => '4879', # U+8F54
        '36693' => '4880', # U+8F55
        '36696' => '4881', # U+8F58
        '36701' => '4882', # U+8F5D
        '36702' => '4883', # U+8F5E
        '36709' => '4884', # U+8F65
        '36765' => '4885', # U+8F9D
        '36768' => '4886', # U+8FA0
        '36769' => '4887', # U+8FA1
        '36772' => '4888', # U+8FA4
        '36773' => '4889', # U+8FA5
        '36774' => '4890', # U+8FA6
        '36789' => '4891', # U+8FB5
        '36790' => '4892', # U+8FB6
        '36792' => '4893', # U+8FB8
        '36798' => '4894', # U+8FBE
        '36800' => '4895', # U+8FC0
        '36801' => '4896', # U+8FC1
        '36806' => '4897', # U+8FC6
        '36810' => '4898', # U+8FCA
        '36811' => '4899', # U+8FCB
        '36813' => '4900', # U+8FCD
        '36816' => '4901', # U+8FD0
        '36818' => '4902', # U+8FD2
        '36819' => '4903', # U+8FD3
        '36821' => '4904', # U+8FD5
        '36832' => '4905', # U+8FE0
        '36835' => '4906', # U+8FE3
        '36836' => '4907', # U+8FE4
        '36840' => '4908', # U+8FE8
        '36846' => '4909', # U+8FEE
        '36849' => '4910', # U+8FF1
        '36853' => '4911', # U+8FF5
        '36854' => '4912', # U+8FF6
        '36859' => '4913', # U+8FFB
        '36862' => '4914', # U+8FFE
        '36866' => '4915', # U+9002
        '36868' => '4916', # U+9004
        '36872' => '4917', # U+9008
        '36876' => '4918', # U+900C
        '36888' => '4919', # U+9018
        '36891' => '4920', # U+901B
        '36904' => '4921', # U+9028
        '36905' => '4922', # U+9029
        '36906' => '4924', # U+902A
        '36908' => '4925', # U+902C
        '36909' => '4926', # U+902D
        '36911' => '4923', # U+902F
        '36915' => '4927', # U+9033
        '36916' => '4928', # U+9034
        '36919' => '4929', # U+9037
        '36927' => '4930', # U+903F
        '36931' => '4931', # U+9043
        '36932' => '4932', # U+9044
        '36940' => '4933', # U+904C
        '36955' => '4934', # U+905B
        '36957' => '4935', # U+905D
        '36962' => '4936', # U+9062
        '36966' => '4937', # U+9066
        '36967' => '4938', # U+9067
        '36972' => '4939', # U+906C
        '36976' => '4940', # U+9070
        '36980' => '4941', # U+9074
        '36985' => '4942', # U+9079
        '36997' => '4943', # U+9085
        '37000' => '4944', # U+9088
        '37003' => '4945', # U+908B
        '37004' => '4946', # U+908C
        '37006' => '4947', # U+908E
        '37008' => '4948', # U+9090
        '37013' => '4949', # U+9095
        '37015' => '4950', # U+9097
        '37016' => '4951', # U+9098
        '37017' => '4952', # U+9099
        '37019' => '4953', # U+909B
        '37024' => '4954', # U+90A0
        '37025' => '4955', # U+90A1
        '37026' => '4956', # U+90A2
        '37029' => '4957', # U+90A5
        '37040' => '4958', # U+90B0
        '37042' => '4959', # U+90B2
        '37043' => '4960', # U+90B3
        '37044' => '4961', # U+90B4
        '37046' => '4962', # U+90B6
        '37053' => '4963', # U+90BD
        '37054' => '4965', # U+90BE
        '37059' => '4966', # U+90C3
        '37060' => '4967', # U+90C4
        '37061' => '4968', # U+90C5
        '37063' => '4969', # U+90C7
        '37064' => '4970', # U+90C8
        '37068' => '4964', # U+90CC
        '37074' => '4979', # U+90D2
        '37077' => '4971', # U+90D5
        '37079' => '4972', # U+90D7
        '37080' => '4973', # U+90D8
        '37081' => '4974', # U+90D9
        '37084' => '4975', # U+90DC
        '37085' => '4976', # U+90DD
        '37087' => '4977', # U+90DF
        '37093' => '4978', # U+90E5
        '37099' => '4981', # U+90EB
        '37103' => '4982', # U+90EF
        '37104' => '4983', # U+90F0
        '37108' => '4984', # U+90F4
        '37110' => '4980', # U+90F6
        '37118' => '4985', # U+90FE
        '37119' => '4986', # U+90FF
        '37120' => '4987', # U+9100
        '37124' => '4988', # U+9104
        '37125' => '4989', # U+9105
        '37126' => '4990', # U+9106
        '37128' => '4991', # U+9108
        '37133' => '4992', # U+910D
        '37136' => '4993', # U+9110
        '37140' => '4994', # U+9114
        '37142' => '4995', # U+9116
        '37143' => '4996', # U+9117
        '37144' => '4997', # U+9118
        '37146' => '4998', # U+911A
        '37148' => '4999', # U+911C
        '37150' => '5000', # U+911E
        '37152' => '5001', # U+9120
        '37154' => '5003', # U+9122
        '37155' => '5004', # U+9123
        '37157' => '5002', # U+9125
        '37159' => '5005', # U+9127
        '37161' => '5006', # U+9129
        '37166' => '5007', # U+912E
        '37167' => '5008', # U+912F
        '37169' => '5009', # U+9131
        '37172' => '5010', # U+9134
        '37174' => '5011', # U+9136
        '37175' => '5012', # U+9137
        '37177' => '5013', # U+9139
        '37178' => '5014', # U+913A
        '37180' => '5015', # U+913C
        '37181' => '5016', # U+913D
        '37187' => '5017', # U+9143
        '37191' => '5018', # U+9147
        '37192' => '5019', # U+9148
        '37199' => '5020', # U+914F
        '37203' => '5021', # U+9153
        '37207' => '5022', # U+9157
        '37209' => '5023', # U+9159
        '37210' => '5024', # U+915A
        '37211' => '5025', # U+915B
        '37217' => '5026', # U+9161
        '37220' => '5027', # U+9164
        '37223' => '5028', # U+9167
        '37229' => '5029', # U+916D
        '37236' => '5030', # U+9174
        '37241' => '5031', # U+9179
        '37242' => '5032', # U+917A
        '37243' => '5033', # U+917B
        '37249' => '5034', # U+9181
        '37251' => '5035', # U+9183
        '37253' => '5036', # U+9185
        '37254' => '5037', # U+9186
        '37258' => '5038', # U+918A
        '37262' => '5039', # U+918E
        '37265' => '5040', # U+9191
        '37267' => '5041', # U+9193
        '37268' => '5042', # U+9194
        '37269' => '5043', # U+9195
        '37272' => '5044', # U+9198
        '37278' => '5045', # U+919E
        '37281' => '5046', # U+91A1
        '37286' => '5047', # U+91A6
        '37288' => '5048', # U+91A8
        '37292' => '5049', # U+91AC
        '37293' => '5050', # U+91AD
        '37294' => '5051', # U+91AE
        '37296' => '5052', # U+91B0
        '37297' => '5053', # U+91B1
        '37298' => '5054', # U+91B2
        '37299' => '5055', # U+91B3
        '37302' => '5056', # U+91B6
        '37307' => '5057', # U+91BB
        '37308' => '5058', # U+91BC
        '37309' => '5059', # U+91BD
        '37311' => '5060', # U+91BF
        '37314' => '5061', # U+91C2
        '37315' => '5062', # U+91C3
        '37317' => '5063', # U+91C5
        '37331' => '5064', # U+91D3
        '37332' => '5065', # U+91D4
        '37335' => '5066', # U+91D7
        '37337' => '5067', # U+91D9
        '37338' => '5068', # U+91DA
        '37342' => '5069', # U+91DE
        '37348' => '5070', # U+91E4
        '37349' => '5071', # U+91E5
        '37353' => '5072', # U+91E9
        '37354' => '5073', # U+91EA
        '37356' => '5074', # U+91EC
        '37357' => '5075', # U+91ED
        '37358' => '5076', # U+91EE
        '37359' => '5077', # U+91EF
        '37360' => '5078', # U+91F0
        '37361' => '5079', # U+91F1
        '37367' => '5080', # U+91F7
        '37369' => '5081', # U+91F9
        '37371' => '5082', # U+91FB
        '37373' => '5083', # U+91FD
        '37376' => '5084', # U+9200
        '37377' => '5085', # U+9201
        '37380' => '5086', # U+9204
        '37381' => '5087', # U+9205
        '37382' => '5088', # U+9206
        '37383' => '5089', # U+9207
        '37385' => '5090', # U+9209
        '37386' => '5091', # U+920A
        '37388' => '5092', # U+920C
        '37392' => '5093', # U+9210
        '37394' => '5094', # U+9212
        '37395' => '5095', # U+9213
        '37398' => '5096', # U+9216
        '37400' => '5097', # U+9218
        '37404' => '5098', # U+921C
        '37405' => '5099', # U+921D
        '37411' => '5100', # U+9223
        '37412' => '5101', # U+9224
        '37413' => '5102', # U+9225
        '37414' => '5103', # U+9226
        '37416' => '5104', # U+9228
        '37422' => '5105', # U+922E
        '37423' => '5106', # U+922F
        '37424' => '5107', # U+9230
        '37427' => '5108', # U+9233
        '37429' => '5109', # U+9235
        '37430' => '5110', # U+9236
        '37432' => '5111', # U+9238
        '37433' => '5112', # U+9239
        '37434' => '5113', # U+923A
        '37436' => '5114', # U+923C
        '37438' => '5115', # U+923E
        '37440' => '5116', # U+9240
        '37442' => '5117', # U+9242
        '37443' => '5118', # U+9243
        '37446' => '5119', # U+9246
        '37447' => '5120', # U+9247
        '37450' => '5121', # U+924A
        '37453' => '5122', # U+924D
        '37454' => '5123', # U+924E
        '37455' => '5124', # U+924F
        '37457' => '5125', # U+9251
        '37464' => '5126', # U+9258
        '37465' => '5127', # U+9259
        '37468' => '5128', # U+925C
        '37469' => '5129', # U+925D
        '37472' => '5130', # U+9260
        '37473' => '5131', # U+9261
        '37477' => '5132', # U+9265
        '37479' => '5133', # U+9267
        '37480' => '5134', # U+9268
        '37481' => '5135', # U+9269
        '37486' => '5136', # U+926E
        '37487' => '5137', # U+926F
        '37488' => '5138', # U+9270
        '37493' => '5139', # U+9275
        '37494' => '5140', # U+9276
        '37495' => '5141', # U+9277
        '37496' => '5142', # U+9278
        '37497' => '5143', # U+9279
        '37499' => '5144', # U+927B
        '37500' => '5145', # U+927C
        '37501' => '5146', # U+927D
        '37503' => '5147', # U+927F
        '37512' => '5148', # U+9288
        '37513' => '5149', # U+9289
        '37514' => '5150', # U+928A
        '37517' => '5151', # U+928D
        '37518' => '5152', # U+928E
        '37522' => '5153', # U+9292
        '37527' => '5154', # U+9297
        '37529' => '5155', # U+9299
        '37535' => '5156', # U+929F
        '37536' => '5157', # U+92A0
        '37540' => '5158', # U+92A4
        '37541' => '5159', # U+92A5
        '37543' => '5160', # U+92A7
        '37544' => '5161', # U+92A8
        '37547' => '5162', # U+92AB
        '37551' => '5163', # U+92AF
        '37554' => '5164', # U+92B2
        '37558' => '5165', # U+92B6
        '37560' => '5166', # U+92B8
        '37562' => '5167', # U+92BA
        '37563' => '5168', # U+92BB
        '37564' => '5169', # U+92BC
        '37565' => '5170', # U+92BD
        '37567' => '5171', # U+92BF
        '37568' => '5172', # U+92C0
        '37569' => '5173', # U+92C1
        '37570' => '5174', # U+92C2
        '37571' => '5175', # U+92C3
        '37573' => '5176', # U+92C5
        '37574' => '5177', # U+92C6
        '37575' => '5178', # U+92C7
        '37576' => '5179', # U+92C8
        '37579' => '5180', # U+92CB
        '37580' => '5181', # U+92CC
        '37581' => '5182', # U+92CD
        '37582' => '5183', # U+92CE
        '37584' => '5184', # U+92D0
        '37587' => '5185', # U+92D3
        '37589' => '5186', # U+92D5
        '37591' => '5187', # U+92D7
        '37592' => '5188', # U+92D8
        '37593' => '5189', # U+92D9
        '37596' => '5190', # U+92DC
        '37597' => '5191', # U+92DD
        '37599' => '5192', # U+92DF
        '37600' => '5193', # U+92E0
        '37601' => '5194', # U+92E1
        '37603' => '5195', # U+92E3
        '37605' => '5196', # U+92E5
        '37607' => '5197', # U+92E7
        '37608' => '5198', # U+92E8
        '37612' => '5199', # U+92EC
        '37614' => '5200', # U+92EE
        '37616' => '5201', # U+92F0
        '37625' => '5202', # U+92F9
        '37627' => '5203', # U+92FB
        '37631' => '5204', # U+92FF
        '37632' => '5205', # U+9300
        '37634' => '5206', # U+9302
        '37640' => '5207', # U+9308
        '37645' => '5208', # U+930D
        '37649' => '5209', # U+9311
        '37652' => '5210', # U+9314
        '37653' => '5211', # U+9315
        '37660' => '5212', # U+931C
        '37661' => '5213', # U+931D
        '37662' => '5214', # U+931E
        '37663' => '5215', # U+931F
        '37665' => '5216', # U+9321
        '37668' => '5217', # U+9324
        '37669' => '5218', # U+9325
        '37671' => '5219', # U+9327
        '37673' => '5220', # U+9329
        '37674' => '5221', # U+932A
        '37683' => '5222', # U+9333
        '37684' => '5223', # U+9334
        '37686' => '5224', # U+9336
        '37687' => '5225', # U+9337
        '37703' => '5226', # U+9347
        '37704' => '5227', # U+9348
        '37705' => '5228', # U+9349
        '37712' => '5229', # U+9350
        '37713' => '5230', # U+9351
        '37714' => '5231', # U+9352
        '37717' => '5232', # U+9355
        '37719' => '5233', # U+9357
        '37720' => '5234', # U+9358
        '37722' => '5235', # U+935A
        '37726' => '5236', # U+935E
        '37732' => '5237', # U+9364
        '37733' => '5238', # U+9365
        '37735' => '5239', # U+9367
        '37737' => '5240', # U+9369
        '37738' => '5241', # U+936A
        '37741' => '5242', # U+936D
        '37743' => '5243', # U+936F
        '37744' => '5244', # U+9370
        '37745' => '5245', # U+9371
        '37747' => '5246', # U+9373
        '37748' => '5247', # U+9374
        '37750' => '5248', # U+9376
        '37754' => '5249', # U+937A
        '37757' => '5250', # U+937D
        '37759' => '5251', # U+937F
        '37760' => '5252', # U+9380
        '37761' => '5253', # U+9381
        '37762' => '5254', # U+9382
        '37768' => '5255', # U+9388
        '37770' => '5256', # U+938A
        '37771' => '5257', # U+938B
        '37773' => '5258', # U+938D
        '37775' => '5259', # U+938F
        '37778' => '5260', # U+9392
        '37781' => '5261', # U+9395
        '37784' => '5262', # U+9398
        '37787' => '5263', # U+939B
        '37790' => '5264', # U+939E
        '37793' => '5265', # U+93A1
        '37795' => '5266', # U+93A3
        '37796' => '5267', # U+93A4
        '37798' => '5268', # U+93A6
        '37800' => '5269', # U+93A8
        '37801' => '5275', # U+93A9
        '37803' => '5270', # U+93AB
        '37812' => '5271', # U+93B4
        '37813' => '5272', # U+93B5
        '37814' => '5273', # U+93B6
        '37818' => '5274', # U+93BA
        '37825' => '5276', # U+93C1
        '37828' => '5277', # U+93C4
        '37829' => '5278', # U+93C5
        '37830' => '5279', # U+93C6
        '37831' => '5280', # U+93C7
        '37833' => '5281', # U+93C9
        '37834' => '5282', # U+93CA
        '37835' => '5283', # U+93CB
        '37836' => '5284', # U+93CC
        '37837' => '5285', # U+93CD
        '37843' => '5286', # U+93D3
        '37849' => '5287', # U+93D9
        '37852' => '5288', # U+93DC
        '37854' => '5289', # U+93DE
        '37855' => '5290', # U+93DF
        '37858' => '5291', # U+93E2
        '37862' => '5292', # U+93E6
        '37863' => '5293', # U+93E7
        '37879' => '5295', # U+93F7
        '37880' => '5296', # U+93F8
        '37881' => '5294', # U+93F9
        '37882' => '5297', # U+93FA
        '37883' => '5298', # U+93FB
        '37885' => '5299', # U+93FD
        '37889' => '5300', # U+9401
        '37890' => '5301', # U+9402
        '37892' => '5302', # U+9404
        '37896' => '5303', # U+9408
        '37897' => '5304', # U+9409
        '37901' => '5305', # U+940D
        '37902' => '5306', # U+940E
        '37903' => '5307', # U+940F
        '37909' => '5308', # U+9415
        '37910' => '5309', # U+9416
        '37911' => '5310', # U+9417
        '37919' => '5311', # U+941F
        '37934' => '5312', # U+942E
        '37935' => '5313', # U+942F
        '37937' => '5314', # U+9431
        '37938' => '5315', # U+9432
        '37939' => '5316', # U+9433
        '37940' => '5317', # U+9434
        '37947' => '5318', # U+943B
        '37949' => '5320', # U+943D
        '37951' => '5319', # U+943F
        '37955' => '5321', # U+9443
        '37957' => '5322', # U+9445
        '37960' => '5323', # U+9448
        '37962' => '5324', # U+944A
        '37964' => '5325', # U+944C
        '37973' => '5326', # U+9455
        '37977' => '5327', # U+9459
        '37980' => '5328', # U+945C
        '37983' => '5329', # U+945F
        '37985' => '5330', # U+9461
        '37987' => '5331', # U+9463
        '37992' => '5332', # U+9468
        '37995' => '5333', # U+946B
        '37997' => '5334', # U+946D
        '37998' => '5335', # U+946E
        '37999' => '5336', # U+946F
        '38001' => '5337', # U+9471
        '38002' => '5338', # U+9472
        '38019' => '5340', # U+9483
        '38020' => '5339', # U+9484
        '38264' => '5341', # U+9578
        '38265' => '5342', # U+9579
        '38270' => '5343', # U+957E
        '38276' => '5344', # U+9584
        '38280' => '5345', # U+9588
        '38284' => '5346', # U+958C
        '38285' => '5347', # U+958D
        '38286' => '5348', # U+958E
        '38301' => '5349', # U+959D
        '38302' => '5350', # U+959E
        '38303' => '5351', # U+959F
        '38305' => '5352', # U+95A1
        '38310' => '5353', # U+95A6
        '38313' => '5354', # U+95A9
        '38315' => '5355', # U+95AB
        '38316' => '5356', # U+95AC
        '38324' => '5357', # U+95B4
        '38326' => '5358', # U+95B6
        '38330' => '5359', # U+95BA
        '38333' => '5360', # U+95BD
        '38335' => '5361', # U+95BF
        '38342' => '5362', # U+95C6
        '38344' => '5363', # U+95C8
        '38345' => '5364', # U+95C9
        '38347' => '5365', # U+95CB
        '38352' => '5366', # U+95D0
        '38353' => '5367', # U+95D1
        '38354' => '5368', # U+95D2
        '38355' => '5369', # U+95D3
        '38361' => '5370', # U+95D9
        '38362' => '5371', # U+95DA
        '38365' => '5372', # U+95DD
        '38366' => '5373', # U+95DE
        '38367' => '5374', # U+95DF
        '38368' => '5375', # U+95E0
        '38372' => '5376', # U+95E4
        '38374' => '5377', # U+95E6
        '38429' => '5378', # U+961D
        '38430' => '5379', # U+961E
        '38434' => '5380', # U+9622
        '38436' => '5381', # U+9624
        '38437' => '5382', # U+9625
        '38438' => '5383', # U+9626
        '38444' => '5384', # U+962C
        '38449' => '5385', # U+9631
        '38451' => '5386', # U+9633
        '38455' => '5387', # U+9637
        '38456' => '5388', # U+9638
        '38457' => '5389', # U+9639
        '38458' => '5390', # U+963A
        '38460' => '5391', # U+963C
        '38461' => '5392', # U+963D
        '38465' => '5393', # U+9641
        '38482' => '5394', # U+9652
        '38484' => '5395', # U+9654
        '38486' => '5396', # U+9656
        '38487' => '5397', # U+9657
        '38488' => '5398', # U+9658
        '38497' => '5399', # U+9661
        '38510' => '5400', # U+966E
        '38516' => '5401', # U+9674
        '38523' => '5402', # U+967B
        '38524' => '5403', # U+967C
        '38526' => '5404', # U+967E
        '38527' => '5405', # U+967F
        '38529' => '5406', # U+9681
        '38530' => '5407', # U+9682
        '38531' => '5408', # U+9683
        '38532' => '5409', # U+9684
        '38537' => '5410', # U+9689
        '38545' => '5411', # U+9691
        '38550' => '5412', # U+9696
        '38554' => '5413', # U+969A
        '38557' => '5414', # U+969D
        '38559' => '5415', # U+969F
        '38564' => '5416', # U+96A4
        '38565' => '5417', # U+96A5
        '38566' => '5418', # U+96A6
        '38569' => '5419', # U+96A9
        '38574' => '5420', # U+96AE
        '38575' => '5421', # U+96AF
        '38579' => '5422', # U+96B3
        '38586' => '5423', # U+96BA
        '38602' => '5424', # U+96CA
        '38610' => '5425', # U+96D2
        '38616' => '5427', # U+96D8
        '38618' => '5428', # U+96DA
        '38621' => '5429', # U+96DD
        '38622' => '5430', # U+96DE
        '38623' => '5431', # U+96DF
        '38633' => '5432', # U+96E9
        '38639' => '5433', # U+96EF
        '38641' => '5434', # U+96F1
        '38650' => '5435', # U+96FA
        '38658' => '5436', # U+9702
        '38659' => '5437', # U+9703
        '38661' => '5438', # U+9705
        '38665' => '5439', # U+9709
        '38682' => '5440', # U+971A
        '38683' => '5441', # U+971B
        '38685' => '5442', # U+971D
        '38689' => '5443', # U+9721
        '38690' => '5444', # U+9722
        '38691' => '5445', # U+9723
        '38696' => '5446', # U+9728
        '38705' => '5447', # U+9731
        '38707' => '5448', # U+9733
        '38721' => '5449', # U+9741
        '38723' => '5450', # U+9743
        '38730' => '5451', # U+974A
        '38734' => '5452', # U+974E
        '38735' => '5453', # U+974F
        '38741' => '5454', # U+9755
        '38743' => '5455', # U+9757
        '38744' => '5456', # U+9758
        '38746' => '5457', # U+975A
        '38747' => '5458', # U+975B
        '38755' => '5459', # U+9763
        '38759' => '5460', # U+9767
        '38762' => '5461', # U+976A
        '38766' => '5462', # U+976E
        '38771' => '5463', # U+9773
        '38774' => '5464', # U+9776
        '38775' => '5465', # U+9777
        '38776' => '5466', # U+9778
        '38779' => '5467', # U+977B
        '38781' => '5468', # U+977D
        '38783' => '5469', # U+977F
        '38784' => '5470', # U+9780
        '38793' => '5471', # U+9789
        '38805' => '5472', # U+9795
        '38806' => '5473', # U+9796
        '38807' => '5474', # U+9797
        '38809' => '5475', # U+9799
        '38810' => '5476', # U+979A
        '38814' => '5477', # U+979E
        '38815' => '5478', # U+979F
        '38818' => '5479', # U+97A2
        '38828' => '5480', # U+97AC
        '38830' => '5481', # U+97AE
        '38833' => '5482', # U+97B1
        '38834' => '5483', # U+97B2
        '38837' => '5484', # U+97B5
        '38838' => '5485', # U+97B6
        '38840' => '5486', # U+97B8
        '38841' => '5487', # U+97B9
        '38842' => '5488', # U+97BA
        '38844' => '5489', # U+97BC
        '38846' => '5490', # U+97BE
        '38847' => '5491', # U+97BF
        '38849' => '5492', # U+97C1
        '38852' => '5493', # U+97C4
        '38853' => '5494', # U+97C5
        '38855' => '5495', # U+97C7
        '38857' => '5496', # U+97C9
        '38858' => '5497', # U+97CA
        '38860' => '5498', # U+97CC
        '38861' => '5499', # U+97CD
        '38862' => '5500', # U+97CE
        '38864' => '5501', # U+97D0
        '38865' => '5502', # U+97D1
        '38868' => '5503', # U+97D4
        '38871' => '5504', # U+97D7
        '38872' => '5505', # U+97D8
        '38873' => '5506', # U+97D9
        '38875' => '5510', # U+97DB
        '38877' => '5507', # U+97DD
        '38878' => '5508', # U+97DE
        '38880' => '5509', # U+97E0
        '38881' => '5511', # U+97E1
        '38884' => '5512', # U+97E4
        '38895' => '5513', # U+97EF
        '38897' => '5514', # U+97F1
        '38900' => '5515', # U+97F4
        '38903' => '5516', # U+97F7
        '38904' => '5517', # U+97F8
        '38906' => '5518', # U+97FA
        '38919' => '5519', # U+9807
        '38922' => '5520', # U+980A
        '38925' => '5522', # U+980D
        '38926' => '5523', # U+980E
        '38932' => '5524', # U+9814
        '38934' => '5525', # U+9816
        '38937' => '5521', # U+9819
        '38940' => '5526', # U+981C
        '38942' => '5527', # U+981E
        '38944' => '5528', # U+9820
        '38947' => '5529', # U+9823
        '38949' => '5538', # U+9825
        '38950' => '5530', # U+9826
        '38955' => '5531', # U+982B
        '38958' => '5532', # U+982E
        '38959' => '5533', # U+982F
        '38960' => '5534', # U+9830
        '38962' => '5535', # U+9832
        '38963' => '5536', # U+9833
        '38965' => '5537', # U+9835
        '38974' => '5539', # U+983E
        '38980' => '5540', # U+9844
        '38983' => '5541', # U+9847
        '38986' => '5542', # U+984A
        '38993' => '5543', # U+9851
        '38994' => '5544', # U+9852
        '38995' => '5545', # U+9853
        '38998' => '5546', # U+9856
        '38999' => '5547', # U+9857
        '39001' => '5548', # U+9859
        '39002' => '5549', # U+985A
        '39010' => '5550', # U+9862
        '39011' => '5551', # U+9863
        '39013' => '5552', # U+9865
        '39014' => '5553', # U+9866
        '39018' => '5554', # U+986A
        '39020' => '5555', # U+986C
        '39083' => '5556', # U+98AB
        '39085' => '5557', # U+98AD
        '39086' => '5558', # U+98AE
        '39088' => '5559', # U+98B0
        '39092' => '5560', # U+98B4
        '39095' => '5561', # U+98B7
        '39096' => '5562', # U+98B8
        '39098' => '5563', # U+98BA
        '39099' => '5564', # U+98BB
        '39103' => '5565', # U+98BF
        '39106' => '5566', # U+98C2
        '39109' => '5567', # U+98C5
        '39112' => '5568', # U+98C8
        '39116' => '5569', # U+98CC
        '39137' => '5570', # U+98E1
        '39139' => '5571', # U+98E3
        '39141' => '5572', # U+98E5
        '39142' => '5573', # U+98E6
        '39143' => '5574', # U+98E7
        '39146' => '5575', # U+98EA
        '39155' => '5576', # U+98F3
        '39158' => '5577', # U+98F6
        '39170' => '5578', # U+9902
        '39175' => '5579', # U+9907
        '39176' => '5580', # U+9908
        '39185' => '5581', # U+9911
        '39189' => '5582', # U+9915
        '39190' => '5583', # U+9916
        '39191' => '5584', # U+9917
        '39194' => '5585', # U+991A
        '39195' => '5586', # U+991B
        '39196' => '5587', # U+991C
        '39199' => '5588', # U+991F
        '39202' => '5589', # U+9922
        '39206' => '5590', # U+9926
        '39207' => '5591', # U+9927
        '39211' => '5592', # U+992B
        '39217' => '5593', # U+9931
        '39218' => '5594', # U+9932
        '39219' => '5595', # U+9933
        '39220' => '5596', # U+9934
        '39221' => '5597', # U+9935
        '39225' => '5598', # U+9939
        '39226' => '5599', # U+993A
        '39227' => '5600', # U+993B
        '39228' => '5601', # U+993C
        '39232' => '5602', # U+9940
        '39233' => '5603', # U+9941
        '39238' => '5604', # U+9946
        '39239' => '5605', # U+9947
        '39240' => '5606', # U+9948
        '39245' => '5607', # U+994D
        '39246' => '5608', # U+994E
        '39252' => '5609', # U+9954
        '39256' => '5610', # U+9958
        '39257' => '5611', # U+9959
        '39259' => '5612', # U+995B
        '39260' => '5613', # U+995C
        '39262' => '5614', # U+995E
        '39263' => '5615', # U+995F
        '39264' => '5616', # U+9960
        '39323' => '5617', # U+999B
        '39325' => '5618', # U+999D
        '39327' => '5619', # U+999F
        '39334' => '5620', # U+99A6
        '39344' => '5621', # U+99B0
        '39345' => '5622', # U+99B1
        '39346' => '5623', # U+99B2
        '39349' => '5624', # U+99B5
        '39353' => '5625', # U+99B9
        '39354' => '5626', # U+99BA
        '39357' => '5627', # U+99BD
        '39359' => '5628', # U+99BF
        '39363' => '5629', # U+99C3
        '39369' => '5630', # U+99C9
        '39379' => '5631', # U+99D3
        '39380' => '5632', # U+99D4
        '39385' => '5633', # U+99D9
        '39386' => '5634', # U+99DA
        '39388' => '5635', # U+99DC
        '39390' => '5636', # U+99DE
        '39399' => '5637', # U+99E7
        '39402' => '5638', # U+99EA
        '39403' => '5639', # U+99EB
        '39404' => '5640', # U+99EC
        '39408' => '5641', # U+99F0
        '39412' => '5642', # U+99F4
        '39413' => '5643', # U+99F5
        '39417' => '5644', # U+99F9
        '39421' => '5645', # U+99FD
        '39422' => '5646', # U+99FE
        '39426' => '5647', # U+9A02
        '39427' => '5648', # U+9A03
        '39428' => '5649', # U+9A04
        '39435' => '5650', # U+9A0B
        '39436' => '5651', # U+9A0C
        '39440' => '5652', # U+9A10
        '39441' => '5653', # U+9A11
        '39446' => '5654', # U+9A16
        '39454' => '5655', # U+9A1E
        '39456' => '5656', # U+9A20
        '39458' => '5657', # U+9A22
        '39459' => '5658', # U+9A23
        '39460' => '5659', # U+9A24
        '39463' => '5660', # U+9A27
        '39469' => '5661', # U+9A2D
        '39470' => '5662', # U+9A2E
        '39475' => '5663', # U+9A33
        '39477' => '5664', # U+9A35
        '39478' => '5665', # U+9A36
        '39480' => '5666', # U+9A38
        '39489' => '5668', # U+9A41
        '39492' => '5669', # U+9A44
        '39495' => '5667', # U+9A47
        '39498' => '5670', # U+9A4A
        '39499' => '5671', # U+9A4B
        '39500' => '5672', # U+9A4C
        '39502' => '5673', # U+9A4E
        '39505' => '5674', # U+9A51
        '39508' => '5675', # U+9A54
        '39510' => '5676', # U+9A56
        '39517' => '5677', # U+9A5D
        '39594' => '5678', # U+9AAA
        '39596' => '5679', # U+9AAC
        '39598' => '5680', # U+9AAE
        '39599' => '5681', # U+9AAF
        '39602' => '5682', # U+9AB2
        '39604' => '5683', # U+9AB4
        '39605' => '5684', # U+9AB5
        '39606' => '5685', # U+9AB6
        '39609' => '5686', # U+9AB9
        '39611' => '5687', # U+9ABB
        '39614' => '5688', # U+9ABE
        '39615' => '5689', # U+9ABF
        '39617' => '5690', # U+9AC1
        '39619' => '5691', # U+9AC3
        '39622' => '5692', # U+9AC6
        '39624' => '5693', # U+9AC8
        '39630' => '5694', # U+9ACE
        '39632' => '5695', # U+9AD0
        '39634' => '5696', # U+9AD2
        '39637' => '5697', # U+9AD5
        '39638' => '5698', # U+9AD6
        '39639' => '5699', # U+9AD7
        '39643' => '5700', # U+9ADB
        '39644' => '5701', # U+9ADC
        '39648' => '5702', # U+9AE0
        '39652' => '5703', # U+9AE4
        '39653' => '5704', # U+9AE5
        '39655' => '5705', # U+9AE7
        '39657' => '5706', # U+9AE9
        '39660' => '5707', # U+9AEC
        '39666' => '5708', # U+9AF2
        '39667' => '5709', # U+9AF3
        '39669' => '5710', # U+9AF5
        '39673' => '5711', # U+9AF9
        '39674' => '5712', # U+9AFA
        '39677' => '5713', # U+9AFD
        '39679' => '5714', # U+9AFF
        '39680' => '5715', # U+9B00
        '39681' => '5716', # U+9B01
        '39682' => '5717', # U+9B02
        '39683' => '5718', # U+9B03
        '39684' => '5719', # U+9B04
        '39685' => '5720', # U+9B05
        '39688' => '5721', # U+9B08
        '39689' => '5722', # U+9B09
        '39691' => '5723', # U+9B0B
        '39692' => '5724', # U+9B0C
        '39693' => '5725', # U+9B0D
        '39694' => '5726', # U+9B0E
        '39696' => '5727', # U+9B10
        '39698' => '5728', # U+9B12
        '39702' => '5729', # U+9B16
        '39705' => '5730', # U+9B19
        '39707' => '5731', # U+9B1B
        '39708' => '5732', # U+9B1C
        '39712' => '5733', # U+9B20
        '39718' => '5734', # U+9B26
        '39723' => '5735', # U+9B2B
        '39725' => '5736', # U+9B2D
        '39731' => '5737', # U+9B33
        '39732' => '5738', # U+9B34
        '39733' => '5739', # U+9B35
        '39735' => '5740', # U+9B37
        '39737' => '5741', # U+9B39
        '39738' => '5742', # U+9B3A
        '39741' => '5743', # U+9B3D
        '39752' => '5744', # U+9B48
        '39755' => '5745', # U+9B4B
        '39756' => '5746', # U+9B4C
        '39765' => '5747', # U+9B55
        '39766' => '5748', # U+9B56
        '39767' => '5749', # U+9B57
        '39771' => '5750', # U+9B5B
        '39774' => '5751', # U+9B5E
        '39777' => '5752', # U+9B61
        '39779' => '5753', # U+9B63
        '39781' => '5754', # U+9B65
        '39782' => '5755', # U+9B66
        '39784' => '5756', # U+9B68
        '39786' => '5757', # U+9B6A
        '39787' => '5758', # U+9B6B
        '39788' => '5759', # U+9B6C
        '39789' => '5760', # U+9B6D
        '39790' => '5761', # U+9B6E
        '39795' => '5762', # U+9B73
        '39797' => '5763', # U+9B75
        '39799' => '5764', # U+9B77
        '39800' => '5765', # U+9B78
        '39801' => '5766', # U+9B79
        '39807' => '5767', # U+9B7F
        '39808' => '5768', # U+9B80
        '39812' => '5769', # U+9B84
        '39813' => '5770', # U+9B85
        '39814' => '5771', # U+9B86
        '39815' => '5772', # U+9B87
        '39817' => '5773', # U+9B89
        '39818' => '5774', # U+9B8A
        '39819' => '5775', # U+9B8B
        '39821' => '5776', # U+9B8D
        '39823' => '5777', # U+9B8F
        '39824' => '5778', # U+9B90
        '39828' => '5779', # U+9B94
        '39834' => '5780', # U+9B9A
        '39837' => '5781', # U+9B9D
        '39838' => '5782', # U+9B9E
        '39846' => '5783', # U+9BA6
        '39847' => '5784', # U+9BA7
        '39849' => '5785', # U+9BA9
        '39852' => '5786', # U+9BAC
        '39856' => '5787', # U+9BB0
        '39857' => '5788', # U+9BB1
        '39858' => '5789', # U+9BB2
        '39863' => '5790', # U+9BB7
        '39864' => '5791', # U+9BB8
        '39867' => '5792', # U+9BBB
        '39868' => '5793', # U+9BBC
        '39870' => '5794', # U+9BBE
        '39871' => '5795', # U+9BBF
        '39873' => '5796', # U+9BC1
        '39879' => '5797', # U+9BC7
        '39880' => '5798', # U+9BC8
        '39886' => '5799', # U+9BCE
        '39888' => '5800', # U+9BD0
        '39895' => '5801', # U+9BD7
        '39896' => '5802', # U+9BD8
        '39901' => '5803', # U+9BDD
        '39903' => '5804', # U+9BDF
        '39909' => '5805', # U+9BE5
        '39911' => '5806', # U+9BE7
        '39914' => '5807', # U+9BEA
        '39915' => '5808', # U+9BEB
        '39919' => '5809', # U+9BEF
        '39923' => '5810', # U+9BF3
        '39927' => '5811', # U+9BF7
        '39928' => '5812', # U+9BF8
        '39929' => '5813', # U+9BF9
        '39930' => '5814', # U+9BFA
        '39933' => '5815', # U+9BFD
        '39935' => '5816', # U+9BFF
        '39936' => '5817', # U+9C00
        '39938' => '5818', # U+9C02
        '39947' => '5819', # U+9C0B
        '39951' => '5820', # U+9C0F
        '39953' => '5821', # U+9C11
        '39958' => '5822', # U+9C16
        '39960' => '5823', # U+9C18
        '39961' => '5824', # U+9C19
        '39962' => '5825', # U+9C1A
        '39964' => '5826', # U+9C1C
        '39966' => '5827', # U+9C1E
        '39970' => '5828', # U+9C22
        '39971' => '5829', # U+9C23
        '39974' => '5830', # U+9C26
        '39975' => '5831', # U+9C27
        '39976' => '5832', # U+9C28
        '39977' => '5833', # U+9C29
        '39978' => '5834', # U+9C2A
        '39985' => '5835', # U+9C31
        '39989' => '5836', # U+9C35
        '39990' => '5837', # U+9C36
        '39991' => '5838', # U+9C37
        '39997' => '5839', # U+9C3D
        '40001' => '5840', # U+9C41
        '40003' => '5841', # U+9C43
        '40004' => '5842', # U+9C44
        '40005' => '5843', # U+9C45
        '40009' => '5844', # U+9C49
        '40010' => '5845', # U+9C4A
        '40014' => '5846', # U+9C4E
        '40015' => '5847', # U+9C4F
        '40016' => '5848', # U+9C50
        '40019' => '5849', # U+9C53
        '40020' => '5850', # U+9C54
        '40022' => '5851', # U+9C56
        '40024' => '5852', # U+9C58
        '40027' => '5853', # U+9C5B
        '40028' => '5860', # U+9C5C
        '40029' => '5854', # U+9C5D
        '40030' => '5855', # U+9C5E
        '40031' => '5856', # U+9C5F
        '40035' => '5857', # U+9C63
        '40040' => '5862', # U+9C68
        '40041' => '5858', # U+9C69
        '40042' => '5859', # U+9C6A
        '40043' => '5861', # U+9C6B
        '40046' => '5863', # U+9C6E
        '40048' => '5864', # U+9C70
        '40050' => '5865', # U+9C72
        '40053' => '5866', # U+9C75
        '40055' => '5867', # U+9C77
        '40059' => '5868', # U+9C7B
        '40166' => '5869', # U+9CE6
        '40178' => '5870', # U+9CF2
        '40183' => '5871', # U+9CF7
        '40185' => '5872', # U+9CF9
        '40194' => '5874', # U+9D02
        '40203' => '5873', # U+9D0B
        '40209' => '5875', # U+9D11
        '40215' => '5876', # U+9D17
        '40216' => '5877', # U+9D18
        '40220' => '5878', # U+9D1C
        '40221' => '5879', # U+9D1D
        '40222' => '5880', # U+9D1E
        '40239' => '5881', # U+9D2F
        '40240' => '5882', # U+9D30
        '40242' => '5883', # U+9D32
        '40243' => '5884', # U+9D33
        '40244' => '5885', # U+9D34
        '40250' => '5886', # U+9D3A
        '40252' => '5887', # U+9D3C
        '40253' => '5889', # U+9D3D
        '40258' => '5890', # U+9D42
        '40259' => '5891', # U+9D43
        '40261' => '5888', # U+9D45
        '40263' => '5892', # U+9D47
        '40266' => '5893', # U+9D4A
        '40275' => '5894', # U+9D53
        '40276' => '5895', # U+9D54
        '40287' => '5896', # U+9D5F
        '40290' => '5898', # U+9D62
        '40291' => '5897', # U+9D63
        '40293' => '5899', # U+9D65
        '40297' => '5900', # U+9D69
        '40298' => '5901', # U+9D6A
        '40299' => '5902', # U+9D6B
        '40304' => '5903', # U+9D70
        '40310' => '5904', # U+9D76
        '40311' => '5905', # U+9D77
        '40315' => '5906', # U+9D7B
        '40316' => '5907', # U+9D7C
        '40318' => '5908', # U+9D7E
        '40323' => '5909', # U+9D83
        '40324' => '5910', # U+9D84
        '40326' => '5911', # U+9D86
        '40330' => '5912', # U+9D8A
        '40333' => '5913', # U+9D8D
        '40334' => '5914', # U+9D8E
        '40338' => '5915', # U+9D92
        '40339' => '5916', # U+9D93
        '40341' => '5917', # U+9D95
        '40342' => '5918', # U+9D96
        '40343' => '5919', # U+9D97
        '40344' => '5920', # U+9D98
        '40353' => '5921', # U+9DA1
        '40362' => '5922', # U+9DAA
        '40364' => '5923', # U+9DAC
        '40366' => '5924', # U+9DAE
        '40369' => '5925', # U+9DB1
        '40373' => '5926', # U+9DB5
        '40377' => '5927', # U+9DB9
        '40380' => '5928', # U+9DBC
        '40383' => '5929', # U+9DBF
        '40387' => '5930', # U+9DC3
        '40391' => '5931', # U+9DC7
        '40393' => '5932', # U+9DC9
        '40394' => '5933', # U+9DCA
        '40404' => '5934', # U+9DD4
        '40405' => '5935', # U+9DD5
        '40406' => '5936', # U+9DD6
        '40407' => '5937', # U+9DD7
        '40410' => '5938', # U+9DDA
        '40414' => '5939', # U+9DDE
        '40415' => '5940', # U+9DDF
        '40416' => '5941', # U+9DE0
        '40421' => '5942', # U+9DE5
        '40423' => '5943', # U+9DE7
        '40425' => '5944', # U+9DE9
        '40427' => '5945', # U+9DEB
        '40430' => '5946', # U+9DEE
        '40432' => '5947', # U+9DF0
        '40435' => '5948', # U+9DF3
        '40436' => '5949', # U+9DF4
        '40446' => '5950', # U+9DFE
        '40450' => '5952', # U+9E02
        '40455' => '5953', # U+9E07
        '40458' => '5951', # U+9E0A
        '40462' => '5954', # U+9E0E
        '40464' => '5955', # U+9E10
        '40465' => '5956', # U+9E11
        '40466' => '5957', # U+9E12
        '40469' => '5958', # U+9E15
        '40470' => '5959', # U+9E16
        '40473' => '5960', # U+9E19
        '40476' => '5961', # U+9E1C
        '40477' => '5962', # U+9E1D
        '40570' => '5963', # U+9E7A
        '40571' => '5964', # U+9E7B
        '40572' => '5965', # U+9E7C
        '40576' => '5966', # U+9E80
        '40578' => '5967', # U+9E82
        '40579' => '5968', # U+9E83
        '40580' => '5969', # U+9E84
        '40581' => '5970', # U+9E85
        '40583' => '5971', # U+9E87
        '40590' => '5972', # U+9E8E
        '40591' => '5973', # U+9E8F
        '40598' => '5974', # U+9E96
        '40600' => '5975', # U+9E98
        '40603' => '5976', # U+9E9B
        '40606' => '5977', # U+9E9E
        '40612' => '5978', # U+9EA4
        '40616' => '5979', # U+9EA8
        '40620' => '5980', # U+9EAC
        '40622' => '5981', # U+9EAE
        '40623' => '5982', # U+9EAF
        '40624' => '5983', # U+9EB0
        '40627' => '5984', # U+9EB3
        '40628' => '5985', # U+9EB4
        '40629' => '5986', # U+9EB5
        '40646' => '5987', # U+9EC6
        '40648' => '5988', # U+9EC8
        '40651' => '5989', # U+9ECB
        '40661' => '5990', # U+9ED5
        '40671' => '5991', # U+9EDF
        '40676' => '5992', # U+9EE4
        '40679' => '5993', # U+9EE7
        '40684' => '5994', # U+9EEC
        '40685' => '5995', # U+9EED
        '40686' => '5996', # U+9EEE
        '40688' => '5997', # U+9EF0
        '40689' => '5998', # U+9EF1
        '40690' => '5999', # U+9EF2
        '40693' => '6000', # U+9EF5
        '40696' => '6001', # U+9EF8
        '40703' => '6002', # U+9EFF
        '40706' => '6003', # U+9F02
        '40707' => '6004', # U+9F03
        '40713' => '6005', # U+9F09
        '40719' => '6006', # U+9F0F
        '40720' => '6007', # U+9F10
        '40721' => '6008', # U+9F11
        '40722' => '6009', # U+9F12
        '40724' => '6010', # U+9F14
        '40726' => '6011', # U+9F16
        '40727' => '6012', # U+9F17
        '40729' => '6013', # U+9F19
        '40730' => '6014', # U+9F1A
        '40731' => '6015', # U+9F1B
        '40735' => '6016', # U+9F1F
        '40738' => '6017', # U+9F22
        '40742' => '6018', # U+9F26
        '40746' => '6019', # U+9F2A
        '40747' => '6020', # U+9F2B
        '40751' => '6021', # U+9F2F
        '40753' => '6022', # U+9F31
        '40754' => '6023', # U+9F32
        '40756' => '6024', # U+9F34
        '40759' => '6025', # U+9F37
        '40761' => '6026', # U+9F39
        '40762' => '6027', # U+9F3A
        '40764' => '6028', # U+9F3C
        '40765' => '6029', # U+9F3D
        '40767' => '6030', # U+9F3F
        '40769' => '6031', # U+9F41
        '40771' => '6032', # U+9F43
        '40772' => '6033', # U+9F44
        '40773' => '6034', # U+9F45
        '40774' => '6035', # U+9F46
        '40775' => '6036', # U+9F47
        '40787' => '6037', # U+9F53
        '40789' => '6038', # U+9F55
        '40790' => '6039', # U+9F56
        '40791' => '6040', # U+9F57
        '40792' => '6041', # U+9F58
        '40794' => '6042', # U+9F5A
        '40797' => '6043', # U+9F5D
        '40798' => '6044', # U+9F5E
        '40808' => '6045', # U+9F68
        '40809' => '6046', # U+9F69
        '40813' => '6047', # U+9F6D
        '40814' => '6048', # U+9F6E
        '40815' => '6049', # U+9F6F
        '40816' => '6050', # U+9F70
        '40817' => '6051', # U+9F71
        '40819' => '6052', # U+9F73
        '40821' => '6053', # U+9F75
        '40826' => '6054', # U+9F7A
        '40829' => '6055', # U+9F7D
        '40847' => '6056', # U+9F8F
        '40848' => '6057', # U+9F90
        '40849' => '6058', # U+9F91
        '40850' => '6059', # U+9F92
        '40852' => '6060', # U+9F94
        '40854' => '6061', # U+9F96
        '40855' => '6062', # U+9F97
        '40862' => '6063', # U+9F9E
        '40865' => '6064', # U+9FA1
        '40866' => '6065', # U+9FA2
        '40867' => '6066', # U+9FA3
        '40869' => '6067', # U+9FA5
    },
};

__END__

=head1 HISTORY

    $Log: japanese.pm,v $
    Revision 1.3  2003/12/08 13:05:43  Administrator
    corrected to proper licencing statement

    Revision 1.2  2003/11/30 17:31:17  Administrator
    merged into default

    Revision 1.1.1.1.2.2  2003/11/30 16:56:45  Administrator
    merged into default

    Revision 1.1.1.1.2.1  2003/11/30 14:21:39  Administrator
    added CVS id/log


=cut