use Test::More tests => 13;
BEGIN { use_ok('Lingua::Identify', qw/:language_manipulation :language_identification/) };

my @de = langof(<<EOT);
soviel nehmen darf, als man ihr giebt, wenn sie nur ihre Tugend
behauptet?  Das gilt auch fuer Minister und erlaubt mir, in dieser
kargen Zeit unter Umstaenden auf mein Gehalt zu verzichten.  Dafuer
kannst du dir zuweilen ein gutes Bild kaufen, Fraenzchen.  Du musst
auch deine ehrbare Ergoetzung haben.
EOT

is($de[0],'de');
cmp_ok($de[1],'>','0.14');
cmp_ok(confidence(@de),'>','0.60');

my @pt = langof(<<EOT);
As armas e os bares assinalados 
Que, da Ocidental praia Lusitana, 
Por mares nunca de antes navegados 
EOT

is($pt[0],'pt');
cmp_ok($pt[1],'>','0.18');
cmp_ok(confidence(@pt),'>','0.55');

my @en = langof(<<EOT);
this is an example of an English text; hopefully, it won't be mistaken
for a Gaelic text, this time! That is not the purpose for this line.
EOT

is($en[0],'en');
cmp_ok($en[1],'>','0.23');
cmp_ok(confidence(@en),'>','0.74');

@pt = langof(<<EOT);
As armas e os bares assinalados 
Que, da Ocidental praia Lusitana, 
Por mares nunca de antes navegados 
Passaram ainda alm da Taprobana 
E em perigos e guerras esforados 
Mais do que prometia a fora humana, 
E entre gente remota edificaram 
Novo Reino, que tanto sublimaram; 
  

E tambm as memrias gloriosas 
Daqueles Reis que foram dilatando 
A F, o Imprio, e as terras viciosas 
De frica e de sia andaram devastando, 
E aqueles que por obras valerosas 
Se vo da lei da Morte libertando: 
Cantando espalharei por toda parte, 
Se a tanto me ajudar o engenho e arte. 
  

Cessem do sbio Grego e do Troiano 
As navegaes grandes que fizeram; 
Cale-se de Alexandro e de Trajano 
A fama das vitrias que tiveram; 
Que eu canto o peito ilustre Lusitano, 
A quem Neptuno e Marte obedeceram. 
Cesse tudo o que a Musa antiga canta, 
Que outro valor mais alto se alevanta. 
  

E vs, Tgides minhas, pois criado 
Tendes em mi um novo engenho ardente 
Se sempre, em verso humilde, celebrado 
Foi de mi vosso rio alegremente, 
Dai-me agora um som alto e sublimado, 
Um estilo grandloco e corrente, 
Por que de vossas guas Febo ordene 
Que no tenham enveja s de Hipocrene. 
  

Dai-me ha fria grande e sonorosa, 
E no de agreste avena ou frauta ruda, 
Mas de tuba canora e belicosa, 
Que o peito acende e a cor ao gesto muda; 
Dai-me igual canto aos feitos da famosa 
Gente vossa, que a Marte tanto ajuda; 
Que se espalhe e se cante no Universo, 
Se to sublime preo cabe em verso. 
  

E vs,  bem nascida segurana 
Da Lusitana antiga liberdade, 
E no menos certssima esperana 
De aumento da pequena Cristandade; 
Vs,  novo temor da Maura lana, 
Maravilha fatal da nossa idade, 
Dada ao mundo por Deus (que todo o mande, 
Pera do mundo a Deus dar parte grande); 
  

Vs, tenro e novo ramo florecente, 
De ha rvore, de Cristo mais amada 
Que nenha nascida no Ocidente, 
Cesrea ou Cristianssima chamada, 
(Vede-o no vosso escudo, que presente  
Vos amostra a vitria j passada, 
Na qual vos deu por armas e deixou  
As que Ele pera Si na Cruz tomou); 
  

Vs, poderoso Rei, cujo alto Imprio 
O Sol, logo em nascendo, v primeiro;  
V-o tambm no meio do Hemisfrio, 
E, quando dece, o deixa derradeiro;  
Vs, que esperamos jugo e vituprio 
Do torpe lsmaelita cavaleiro, 
Do Turco Oriental e do Gentio 
Que inda bebe o licor do santo Rio: 
  

Inclinai por um pouco a majestade, 
Que nesse tenro gesto vos contemplo,  
Que j se mostra qual na inteira idade,  
Quando subindo ireis ao eterno Templo;  
Os olhos da real benignidade 
Ponde no cho: vereis um novo exemplo  
De amor dos ptrios feitos valerosos, 
Em versos devulgado numerosos. 
  

Vereis amor da ptria, no movido 
De prmio vil, mas alto e quase eterno;  
Que no  prmio vil ser conhecido 
Por um prego do ninho meu paterno. 
Ouvi: vereis o nome engrandecido 
Daqueles de quem sois senhor superno, 
E julgareis qual  mais excelente, 
Se ser do mundo Rei, se de tal gente. 
  

Ouvi: que no vereis com vs faanhas,  
Fantsticas, fingidas, mentirosas,  
Louvar os vossos, como nas estranhas Musas,  
de engrandecer-se desejosas: 
As verdadeiras vossas so tamanhas, 
Que excedem as sonhadas, fabulosas, 
Que excedem Rodamonte e o vo Rugeiro,  
E Orlando, inda que fora verdadeiro. 
  

Por estes vos darei um Nuno fero, 
Que fez ao Rei e ao Reino tal servio, 
Um Egas e um Dom Fuas, que de Homero  
A ctara para eles s cobio; 
Pois polos Doze Pares dar-vos quero 
Os Doze de Inglaterra e o seu Magrio;  
Dou-vos tambm aquele ilustre Gama,  
Que para si de Eneias toma a fama. 
  

Pois, se a troco de Carlos, Rei de Frana,  
Ou de Csar, quereis igual memria,  
Vede o primeiro Afonso, cuja lana  
Escura faz qualquer estranha glria; 
E aquele que a seu Reino a segurana  
Deixou, co a grande e prspera vitria;  
Outro Joanne, invicto cavaleiro; 
O quarto e quinto Afonsos e o terceiro. 
  

Nem deixaro meus versos esquecidos  
Aqueles que, nos Reinos l da Aurora, 
Se fizeram por armas to subidos, 
Vossa bandeira sempre vencedora: 
Um Pacheeo fortssimo e os temidos  
Almeidas, por quem sempre o Tejo chora,  
Albuquerque terribil, Castro forte, 
E outros em quem poder no teve a morte. 
  

E, enquanto eu estes canto, e a vs no posso,  
Sublime Rei, que no me atrevo a tanto,  
Tomai as rdeas vs do Reino vosso: 
Dareis matria a nunca ouvido canto.  
Comecem a sentir o peso grosso 
(Que polo mundo todo faa espanto) 
De exrcitos e feitos singulares 
De frica as terras e do Oriente os mares.  
EOT

is($pt[0],'pt');
cmp_ok($pt[1],'>','0.14');
cmp_ok(confidence(@pt),'>','0.50');
