package Mojo::Pua::Error;
use Evo -Class;
use overload bool => sub {1}, '""' => sub { $_[0]->to_string }, fallback => 1;

has 'message', required => 1;
has 'code';
has 'res';


sub to_string($self) {
  $self->code
    ? "[${\$self->code}] ${\$self->message}"
    : "[connection error] ${\$self->message}";
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Mojo::Pua::Error

=head1 VERSION

version 0.004

=head1 AUTHOR

alexbyk <alexbyk.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
