package Evo::Class::Hash;
use Evo '/::Gen::Hash GEN; -Role ROLE_EXPORTER; /::Meta; -Attr *';
use Evo '-Export *, -import, import_all:import';

my $META = Evo::Class::Meta::new(gen => GEN, rex => ROLE_EXPORTER);

export_gen new => sub($class) { $META->compile_builder($class); };

export_gen has => sub($class) {
  sub { $META->install_attr($class, @_); };
};

export_gen with => sub($class) {
  sub { $META->install_roles($class, @_); };
};

export_gen overrides => sub($class) {
  sub { $META->mark_overriden($class, @_); };
};


# dont share this
sub _attr_handler ($class, $code, @attrs) {
  if (grep { $_ eq 'Override' } @attrs) {
    Evo::Lib::Bare::find_subnames($class, $code);
    $META->mark_overriden($class, Evo::Lib::Bare::find_subnames($class, $code));
  }
  return grep { $_ ne 'Override' } @attrs;
}

attr_handler \&_attr_handler;

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Evo::Class::Hash

=head1 VERSION

version 0.0209

=head1 DESCRIPTION

Hash based driver for L<Evo::Class>

=head1 AUTHOR

alexbyk.com

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by alexbyk.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
