package Test::Inline::Content::Default;

=pod

=head1 NAME

Test::Inline::Content::Default - Test::Inline 2 fallback/default Content Handler

=head1 DESCRIPTION

This class implements the default generator for script content. It generates
test script content inteded for use in a standard CPAN dist.

This module contains no user servicable parts.

=cut

use strict;
use UNIVERSAL 'isa';
use base 'Test::Inline::Content';

use vars qw{$VERSION};
BEGIN {
	$VERSION = '2.099_02';
}

sub process {
	my $self   = shift;
	my $Inline = isa(ref $_[0], 'Test::Inline')         ? shift : return undef;
	my $Script = isa(ref $_[0], 'Test::Inline::Script') ? shift : return undef;

	# Get the merged content
	my $content = $Script->merged_content;
	return undef unless defined $content;

	# Determine a plan
	my $tests = $Script->tests;
	my $plan  = defined $tests
		? "tests => $tests"
		: "'no_plan'";

	# Wrap the merged contents with the rest of the test
	# file infrastructure.
	my $file = <<"END_TEST";
#!/usr/bin/perl -w

use strict;
use Test::More $plan;
\$| = 1;



$content



1;
END_TEST

	$file;
}

1;

=pod

=head1 SUPPORT

See the main L<SUPPORT|Test::Inline/SUPPORT> section.

=head1 AUTHOR

Adam Kennedy <cpan@ali.as>, L<http://ali.as/>

=head1 COPYRIGHT

Copyright (c) 2004 - 2005 Phase N Austalia. All rights reserved.

This program is free software; you can redistribute
it and/or modify it under the same terms as Perl itself.

The full text of the license can be found in the
LICENSE file included with this module.

=cut
