#!/usr/bin/perl

package eBay::API::XML::Call::SetReturnURL::SetReturnURLRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetReturnURLRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetReturnURL::SetReturnURLRequestType

=head1 DESCRIPTION

Configures your application's authentication and authorization preferences and
other data, such as the URLs that eBay should redirect users to after they
complete the authentication and authorization process.
<br>
<br>
Unlike most other Trading API calls, this call requires the eBay
Username and Password values that you created for use by your applications.
(Most Trading API calls, in contrast, require an authentication token.)
These values are not described in the
current documentation topic. For more information about these values,
please use the Setup for Authentication link below.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetReturnURL::SetReturnURLRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::AuthenticationEntryType;
use eBay::API::XML::DataType::Enum::ModifyActionCodeType;


my @gaProperties = ( [ 'Action', 'ns:ModifyActionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ModifyActionCodeType', '' ]
	, [ 'ApplicationDisplayName', 'xs:string', '', '', '' ]
	, [ 'AuthenticationEntry', 'ns:AuthenticationEntryType', ''
	     ,'eBay::API::XML::DataType::AuthenticationEntryType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAction()

Specifies whether the authentication entry is being added, deleted, or
modified.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AuthNAuth
Title: Authentication & Authorization

  RequiredInput: Yes
#    Argument: 'ns:ModifyActionCodeType'

=cut

sub setAction {
  my $self = shift;
  $self->{'Action'} = shift
}

=head2 getAction()

#    Returns: 'ns:ModifyActionCodeType'

=cut

sub getAction {
  my $self = shift;
  return $self->{'Action'};
}


=head2 setApplicationDisplayName()

Sets an application display name for the eBay sign-in page.
Need not be set with every call. Optional.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AuthNAuth
Title: Authentication & Authorization

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setApplicationDisplayName {
  my $self = shift;
  $self->{'ApplicationDisplayName'} = shift
}

=head2 getApplicationDisplayName()

#    Returns: 'xs:string'

=cut

sub getApplicationDisplayName {
  my $self = shift;
  return $self->{'ApplicationDisplayName'};
}


=head2 setAuthenticationEntry()

The authentication preferences and other data that you are
adding, deleting, or modifying.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AuthNAuth
Title: Authentication & Authorization

  RequiredInput: Yes
#    Argument: 'ns:AuthenticationEntryType'

=cut

sub setAuthenticationEntry {
  my $self = shift;
  $self->{'AuthenticationEntry'} = shift
}

=head2 getAuthenticationEntry()

#    Returns: 'ns:AuthenticationEntryType'

=cut

sub getAuthenticationEntry {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AuthenticationEntry'
		,'eBay::API::XML::DataType::AuthenticationEntryType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
