package WebService::Mattermost::V4::API::Object::Results;

# ABSTRACT: A result object.

use Moo;
use Types::Standard qw(Maybe Str);

extends 'WebService::Mattermost::V4::API::Object';

################################################################################

has results => (is => 'ro', isa => Maybe[Str], lazy => 1, builder => 1);

################################################################################

sub _build_results { shift->raw_data->{results} }

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Object::Results - A result object.

=head1 VERSION

version 0.28

=head1 DESCRIPTION

Details a Mattermost Results object. Returned only by L<WebService::Mattermost::V4::API::Resource::Team>'s
C<import_from_existing()> method.

=head2 ATTRIBUTES

=over 4

=item * C<results>

Stringified "results".

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
