# Generated by default/object.tt
package Paws::CodeGuruReviewer::BranchDiffSourceCodeType;
  use Moose;
  has DestinationBranchName => (is => 'ro', isa => 'Str', required => 1);
  has SourceBranchName => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruReviewer::BranchDiffSourceCodeType

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruReviewer::BranchDiffSourceCodeType object:

  $service_obj->Method(Att1 => { DestinationBranchName => $value, ..., SourceBranchName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruReviewer::BranchDiffSourceCodeType object:

  $result = $service_obj->Method(...);
  $result->Att1->DestinationBranchName

=head1 DESCRIPTION

A type of C<SourceCodeType>
(https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType)
that specifies a code diff between a source and destination branch in
an associated repository.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DestinationBranchName => Str

The destination branch for a diff in an associated repository.


=head2 B<REQUIRED> SourceBranchName => Str

The source branch for a diff in an associated repository.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruReviewer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

