@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S "%0" %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
exit /b %errorlevel%
goto endofperl
@rem ';
#!perl
#line 15
undef(@rem=@rem);
######################################################################
#
# App::japerl - JPerl-again Perl glocalization scripting environment
#
# https://metacpan.org/release/App-japerl
#
# Copyright (c) 2018, 2019, 2021 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

$VERSION = '0.13';
$VERSION = $VERSION;
BEGIN { pop @INC if $INC[-1] eq '.' } # CVE-2016-1238: Important unsafe module load path flaw
use FindBin;

use 5.00503;
use strict;
BEGIN { $INC{'warnings.pm'} = '' if $] < 5.006 }; use warnings; local $^W=1;

# command-line parameter not found
unless (@ARGV) {
    die <<END;
usage:

    @{[__FILE__]} [switches] [--] script.pl [arguments]
END
}

# mb.pm modulino exists or not
if (not -e "$FindBin::Bin/lib/mb.pm") {
    die "@{[__FILE__]}: $FindBin::Bin/lib/mb.pm not found.\n";
}

# configuration of this software
my %x = (
    'PERL5BIN' => $^X,

    'PERL5LIB' => [

        # local::lib compatible
        defined($ENV{'PERL_LOCAL_LIB_ROOT'}) ? ($ENV{'PERL_LOCAL_LIB_ROOT'}) : (),
    ],

    # The PERL5OPT environment variable (for passing command line arguments
    # to Perl) didn't work for more than a single group of options. [561]

    'PERL5OPT' => join(' ',
        '-w',
        (exists $ENV{'PERL5OPT'}) ? $ENV{'PERL5OPT'} : '',
    ),
);

# get command-line switches
my @switch = ();
while ((defined $ARGV[0]) and ($ARGV[0] =~ /^-/)) {
    if ($ARGV[0] eq '--') {
        shift @ARGV;
        last;
    }
    elsif ($ARGV[0] =~ /I$/) {     # -I Include/Path
        push @switch, shift @ARGV; # -I
        push @switch, shift @ARGV; #    Include/Path
    }
    else {
        push @switch, shift @ARGV;
    }
}

# script file exists or not
if (not -e $ARGV[0]) {
    die "@{[__FILE__]}: script $ARGV[0] not found.\n";
}

# local $ENV{'PATH'} = '.';
local @ENV{qw(IFS CDPATH ENV BASH_ENV)}; # Make %ENV safer

# remove environment variable PERL5OPT
local $ENV{'PERL5OPT'};

# execute escaped script
$| = 1;
system(
    "$x{'PERL5BIN'}",
    (map { "-I$_" } grep { -e $_ } @{$x{'PERL5LIB'}}),
    @switch,
    $x{'PERL5OPT'},
    '--',
    "$FindBin::Bin/lib/mb.pm",
    @ARGV,
);
exit($? >> 8);

__END__

=pod

=head1 NAME

App::japerl - JPerl-again Perl glocalization scripting environment

=head1 SYNOPSIS

  japerl [switches] [--] script.pl [arguments]

=head1 DESCRIPTION

japerl was created with the intention of succeeding JPerl.
japerl provides glocalization script environment on both modern Perl
and traditional Perl by using mb.pm modulino.

This is often misunderstood, but japerl and jacode.pl have different
purposes and functions.

       software
  <<elder   younger>>     software purpose
  ----------------------+---------------------------------------
  jcode.pl  jacode.pl   | to convert encoding of data for I/O
  ----------------------+---------------------------------------
  jperl     japerl.bat  | to execute native encoding scripts
                        | (NEVER convert script encoding)
  ----------------------+---------------------------------------

This software can do the following.

=over 4

=item * choose one perl interpreter in system

=item * select local use libraries

=item * execute script written in system native encoding

=back

May you do good magic with japerl.

=head1 AUTHOR

INABA Hitoshi E<lt>ina@cpan.orgE<gt> in a CPAN

This project was originated by INABA Hitoshi.

=head1 LICENSE AND COPYRIGHT

This software is free software; you can redistribute it and/or
modify it under the same terms as Perl itself. See L<perlartistic>.

This software is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

=cut

:endofperl
