package Run::Parts::Common;

# ABSTRACT: Common helpers for Run::Parts and its backends

use Modern::Perl;
use Exporter::Easy ( EXPORT => [qw[lines chomped_lines]] );
use Scalar::Util qw(blessed);

our $VERSION = '0.07'; # VERSION generated by DZP::OurPkgVersion


sub lines {
    # Sanity check
    die "lines is no method" if blessed $_[0];

    return wantarray ? @_ : join("\n", @_)."\n";
}


sub chomped_lines {
    # Sanity check
    die "chomped_lines is no method" if blessed $_[0];

    chomp(@_);
    return lines(@_);
}




23; # End of Run::Parts::Common

__END__

=pod

=encoding UTF-8

=head1 NAME

Run::Parts::Common - Common helpers for Run::Parts and its backends

=head1 VERSION

version 0.07

=head1 SYNOPSIS

Exports helper functions used by L<Run::Parts> as well as its backends.

=head1 EXPORTED FUNCTIONS

=head2 lines

Gets an array of strings as parameter.

In scalar context returns a string with all lines concatenated. In
array context it passes through the array.

=head2 chomped_lines

Gets an array of strings as parameter and calls chomp() on it.

In scalar context returns a string with all lines concatenated. In
array context it passes through the array.

=head1 SEE ALSO

L<Run::Parts>

=head1 BUGS

Please report any bugs or feature requests to C<bug-run-parts at
rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Run-Parts>.  I will
be notified, and then you'll automatically be notified of progress on
your bug as I make changes.

=head1 AUTHOR

Axel Beckert <abe@deuxchevaux.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Axel Beckert.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
