/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.HtmlProgress;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.LabelsHelper;

@JsxClass(domClass=HtmlProgress.class)
public class HTMLProgressElement
extends HTMLElement {
    private AbstractList labels_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public HTMLProgressElement() {
    }

    @JsxGetter
    public double getValue() {
        return this.getAttributeAsDouble("value", 0.0);
    }

    @JsxGetter
    public double getMax() {
        return this.getAttributeAsDouble("max", 1.0);
    }

    private double getAttributeAsDouble(String attributeName, double defaultValue) {
        try {
            return Double.parseDouble(this.getDomNodeOrDie().getAttribute(attributeName));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public AbstractList getLabels() {
        if (this.labels_ == null) {
            this.labels_ = new LabelsHelper(this.getDomNodeOrDie());
        }
        return this.labels_;
    }
}

