## Magento::Backend
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>modules</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Returns an array of enabled modules|GET|<div style='white-space: nowrap;'>/V1/modules</div>|
## Magento::Bundle
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>bundle-products-children</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$product_sku!</div>|Get all children for Bundle product|GET|<div style='white-space: nowrap;'>/V1/bundle-products/:productSku/children</div>|
|<div style='white-space: nowrap;'>bundle-products-links</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Int  :$option_id!,<br/>    Hash :$data!</div>|Add child product to specified Bundle option by product sku|POST|<div style='white-space: nowrap;'>/V1/bundle-products/:sku/links/:optionId</div>|
|<div style='white-space: nowrap;'>bundle-products-links</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Int  :$id!,<br/>    Hash :$data!</div>||PUT|<div style='white-space: nowrap;'>/V1/bundle-products/:sku/links/:id</div>|
|<div style='white-space: nowrap;'>bundle-products-options</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Int  :$option_id!</div>|Get option for bundle product|GET|<div style='white-space: nowrap;'>/V1/bundle-products/:sku/options/:optionId</div>|
|<div style='white-space: nowrap;'>bundle-products-options</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$option_id!,<br/>    Hash :$data!</div>|Add new option for bundle product|PUT|<div style='white-space: nowrap;'>/V1/bundle-products/options/:optionId</div>|
|<div style='white-space: nowrap;'>bundle-products-options-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Int  :$option_id!</div>|Remove bundle option|DELETE|<div style='white-space: nowrap;'>/V1/bundle-products/:sku/options/:optionId</div>|
|<div style='white-space: nowrap;'>bundle-products-options-add</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Add new option for bundle product|POST|<div style='white-space: nowrap;'>/V1/bundle-products/options/add</div>|
|<div style='white-space: nowrap;'>bundle-products-options-all</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!</div>|Get all options for bundle product|GET|<div style='white-space: nowrap;'>/V1/bundle-products/:sku/options/all</div>|
|<div style='white-space: nowrap;'>bundle-products-options-children-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Int  :$option_id!,<br/>    Str  :$child_sku!</div>|Remove product from Bundle product option|DELETE|<div style='white-space: nowrap;'>/V1/bundle-products/:sku/options/:optionId/children/:childSku</div>|
|<div style='white-space: nowrap;'>bundle-products-options-types</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Get all types for options for bundle products|GET|<div style='white-space: nowrap;'>/V1/bundle-products/options/types</div>|
## Magento::Catalog
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>products</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Get product list|GET|<div style='white-space: nowrap;'>/V1/products</div>|
|<div style='white-space: nowrap;'>products</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Create product|POST|<div style='white-space: nowrap;'>/V1/products</div>|
|<div style='white-space: nowrap;'>products</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Hash :$data!</div>|Create product|PUT|<div style='white-space: nowrap;'>/V1/products/:sku</div>|
|<div style='white-space: nowrap;'>products</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!</div>|Get info about product by product SKU|GET|<div style='white-space: nowrap;'>/V1/products/:sku</div>|
|<div style='white-space: nowrap;'>products-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!</div>||DELETE|<div style='white-space: nowrap;'>/V1/products/:sku</div>|
|<div style='white-space: nowrap;'>products-attributes-types</div>|<div style='white-space: nowrap;'>    Hash $config,</div>|Retrieve list of product attribute types|GET|<div style='white-space: nowrap;'>/V1/products/attributes/types</div>|
|<div style='white-space: nowrap;'>products-attributes</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Retrieve all attributes for entity type|GET|<div style='white-space: nowrap;'>/V1/products/attributes</div>|
|<div style='white-space: nowrap;'>products-attributes</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Save attribute data|POST|<div style='white-space: nowrap;'>/V1/products/attributes</div>|
|<div style='white-space: nowrap;'>categories-attributes</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Retrieve all attributes for entity type|GET|<div style='white-space: nowrap;'>/V1/categories/attributes</div>|
|<div style='white-space: nowrap;'>products-types</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Retrieve available product types|GET|<div style='white-space: nowrap;'>/V1/products/types</div>|
|<div style='white-space: nowrap;'>products-attribute-sets</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Retrieve list of Attribute Sets|GET|<div style='white-space: nowrap;'>/V1/products/attribute-sets/sets/list</div>|
|<div style='white-space: nowrap;'>products-attribute-sets</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Create attribute set from data|POST|<div style='white-space: nowrap;'>/V1/products/attribute-sets</div>|
|<div style='white-space: nowrap;'>products-attribute-sets-attributes</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Assign attribute to attribute set|POST|<div style='white-space: nowrap;'>/V1/products/attribute-sets/attributes</div>|
|<div style='white-space: nowrap;'>products-attribute-groups</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Save attribute group|POST|<div style='white-space: nowrap;'>/V1/products/attribute-sets/groups</div>|
|<div style='white-space: nowrap;'>products-media</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,</div>|Retrieve the list of gallery entries associated with given product|GET|<div style='white-space: nowrap;'>/V1/products/:sku/media</div>|
|<div style='white-space: nowrap;'>products-media</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Hash :$data!</div>|Create new gallery entry|POST|<div style='white-space: nowrap;'>/V1/products/:sku/media</div>|
|<div style='white-space: nowrap;'>categories</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$root_category_id = 1,<br/>    Int  :$depth = 1;</div>|Retrieve list of categories|GET|<div style='white-space: nowrap;'>/V1/categories</div>|
|<div style='white-space: nowrap;'>categories</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Create category service|POST|<div style='white-space: nowrap;'>/V1/categories</div>|
|<div style='white-space: nowrap;'>categories</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$category_id!,<br/>    Hash :$data!</div>|Create category service|PUT|<div style='white-space: nowrap;'>/V1/categories/:id</div>|
|<div style='white-space: nowrap;'>products-options-types</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Get custom option types|GET|<div style='white-space: nowrap;'>/V1/products/options/types</div>|
|<div style='white-space: nowrap;'>products-custom-options</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!</div>|Get the list of custom options for a specific product|GET|<div style='white-space: nowrap;'>/V1/products/:sku/options</div>|
|<div style='white-space: nowrap;'>products-custom-options</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Save Custom Option|POST|<div style='white-space: nowrap;'>/V1/products/options</div>|
|<div style='white-space: nowrap;'>products-links-types</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Retrieve information about available product link types|GET|<div style='white-space: nowrap;'>/V1/products/links/types</div>|
|<div style='white-space: nowrap;'>products-links-attributes</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$type</div>|Provide a list of the product link type attributes|GET|<div style='white-space: nowrap;'>/V1/products/links/:type/attributes</div>|
|<div style='white-space: nowrap;'>products-links</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Str  :$type!</div>|Provide the list of links for a specific product|GET|<div style='white-space: nowrap;'>/V1/products/:sku/links/:type</div>|
|<div style='white-space: nowrap;'>products-links</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Hash :$data!</div>|Assign a product link to another product|POST|<div style='white-space: nowrap;'>/V1/products/:sku/links</div>|
|<div style='white-space: nowrap;'>products-links-update</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Hash :$data!</div>|Save product link|PUT|<div style='white-space: nowrap;'>/V1/products/:sku/links</div>|
|<div style='white-space: nowrap;'>products-links-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Str  :$type!,<br/>    Str  :$linked_product_sku!</div>||DELETE|<div style='white-space: nowrap;'>/V1/products/:sku/links/:type/:linkedProductSku</div>|
## Magento::CatalogInventory
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>products-stock-items</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$product_sku!,<br/>    Int  :$item_id!,<br/>    Hash :$data!</div>||PUT|<div style='white-space: nowrap;'>/V1/products/:productSku/stockItems/:itemId</div>|
|<div style='white-space: nowrap;'>stock-items</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$product_sku!</div>||GET|<div style='white-space: nowrap;'>/V1/stockItems/:productSku</div>|
|<div style='white-space: nowrap;'>stock-items-low-stock</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$scope_id     = 0,<br/>    Int  :$qty          = 1,<br/>    Int  :$page_size    = 1,<br/>    Int  :$current_page = 1</div>|Retrieves a list of SKU's with low inventory qty|GET|<div style='white-space: nowrap;'>/V1/stockItems/lowStock/</div>|
|<div style='white-space: nowrap;'>stock-statuses</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$product_sku!</div>||GET|<div style='white-space: nowrap;'>/V1/stockStatuses/:productSku</div>|
## Magento::Checkout
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>carts-mine-payment-information</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Set payment information and place order for a specified cart.|POST|<div style='white-space: nowrap;'>/V1/carts/mine/payment-information</div>|
|<div style='white-space: nowrap;'>carts-mine-payment-information</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Get payment information|GET|<div style='white-space: nowrap;'>/V1/carts/mine/payment-information</div>|
|<div style='white-space: nowrap;'>carts-mine-set-payment-information</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Set payment information for a specified cart.|POST|<div style='white-space: nowrap;'>/V1/carts/mine/set-payment-information</div>|
|<div style='white-space: nowrap;'>carts-mine-shipping-information</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>||POST|<div style='white-space: nowrap;'>/V1/carts/mine/shipping-information</div>|
|<div style='white-space: nowrap;'>carts-mine-totals-information</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Calculate quote totals based on address and shipping method.|POST|<div style='white-space: nowrap;'>/V1/carts/mine/totals-information</div>|
|<div style='white-space: nowrap;'>carts-shipping-information</div>|<div style='white-space: nowrap;'>    Hash   $config,<br/>    CartId :$cart_id!,<br/>    Hash   :$data!</div>||POST|<div style='white-space: nowrap;'>/V1/carts/:cartId/shipping-information</div>|
|<div style='white-space: nowrap;'>carts-totals-information</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Hash :$data!</div>|Calculate quote totals based on address and shipping method.|POST|<div style='white-space: nowrap;'>/V1/carts/:cartId/totals-information</div>|
|<div style='white-space: nowrap;'>guest-carts-payment-information</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Hash :$data!</div>|Set payment information and place order for a specified cart.|POST|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/payment-information</div>|
|<div style='white-space: nowrap;'>guest-carts-payment-information</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!</div>|Get payment information|GET|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/payment-information</div>|
|<div style='white-space: nowrap;'>guest-carts-set-payment-information</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Hash :$data!</div>|Set payment information for a specified cart.|POST|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/set-payment-information</div>|
|<div style='white-space: nowrap;'>guest-carts-shipping-information</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Hash :$data!</div>||POST|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/shipping-information</div>|
|<div style='white-space: nowrap;'>guest-carts-totals-information</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Hash :$data!</div>|Calculate quote totals based on address and shipping method.|POST|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/totals-information</div>|
## Magento::CheckoutAgreements
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>carts-licence</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Lists active checkout agreements.|GET|<div style='white-space: nowrap;'>/V1/carts/licence</div>|
## Magento::Cms
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>cms-block</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$block_id!</div>|Retrieve block.|GET|<div style='white-space: nowrap;'>/V1/cmsBlock/:blockId</div>|
|<div style='white-space: nowrap;'>cms-block</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Save block.|POST|<div style='white-space: nowrap;'>/V1/cmsBlock</div>|
|<div style='white-space: nowrap;'>cms-block</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$block_id!,<br/>    Hash :$data!</div>|Save block.|PUT|<div style='white-space: nowrap;'>/V1/cmsBlock/:id</div>|
|<div style='white-space: nowrap;'>cms-block-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$block_id!</div>|Delete block by ID.|DELETE|<div style='white-space: nowrap;'>/V1/cmsBlock/:blockId</div>|
|<div style='white-space: nowrap;'>cms-block-search</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Retrieve blocks matching the specified criteria.|GET|<div style='white-space: nowrap;'>/V1/cmsBlock/search</div>|
|<div style='white-space: nowrap;'>cms-page</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$page_id!</div>|Retrieve page.|GET|<div style='white-space: nowrap;'>/V1/cmsPage/:pageId</div>|
|<div style='white-space: nowrap;'>cms-page</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Save page.|POST|<div style='white-space: nowrap;'>/V1/cmsPage</div>|
|<div style='white-space: nowrap;'>cms-page</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$page_id!,<br/>    Hash :$data!</div>|Save page.|PUT|<div style='white-space: nowrap;'>/V1/cmsPage/:id</div>|
|<div style='white-space: nowrap;'>cms-page-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$page_id!</div>|Delete page by ID.|DELETE|<div style='white-space: nowrap;'>/V1/cmsPage/:pageId</div>|
|<div style='white-space: nowrap;'>cms-page-search</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Retrieve pages matching the specified criteria.|GET|<div style='white-space: nowrap;'>/V1/cmsPage/search</div>|
## Magento::Customer
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>customer-groups</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id</div>|Get customer group by group ID.|GET|<div style='white-space: nowrap;'>/V1/customerGroups/:id</div>|
|<div style='white-space: nowrap;'>customer-groups</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data</div>|Save customer group.|POST|<div style='white-space: nowrap;'>/V1/customerGroups</div>|
|<div style='white-space: nowrap;'>customer-groups</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id,<br/>    Hash :$data</div>|Save customer group.|PUT|<div style='white-space: nowrap;'>/V1/customerGroups/:id</div>|
|<div style='white-space: nowrap;'>customer-groups-default</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$store_id</div>|Get default customer group.|GET|<div style='white-space: nowrap;'>/V1/customerGroups/default/:storeId</div>|
|<div style='white-space: nowrap;'>customer-groups-default</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Get default customer group.|GET|<div style='white-space: nowrap;'>/V1/customerGroups/default</div>|
|<div style='white-space: nowrap;'>customer-groups-permissions</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id</div>|Check if customer group can be deleted.|GET|<div style='white-space: nowrap;'>/V1/customerGroups/:id/permissions</div>|
|<div style='white-space: nowrap;'>customer-groups-search</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria</div>|Retrieve customer groups. The list of groups can be filtered to exclude the NOT_LOGGED_IN group using the first parameter and/or it can be filtered by tax class. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#GroupRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/customerGroups/search</div>|
|<div style='white-space: nowrap;'>customer-groups-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id</div>|Delete customer group by ID.|DELETE|<div style='white-space: nowrap;'>/V1/customerGroups/:id</div>|
|<div style='white-space: nowrap;'>customer-metadata-attribute</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str :$attribute_code</div>|Retrieve attribute metadata.|GET|<div style='white-space: nowrap;'>/V1/attributeMetadata/customer/attribute/:attributeCode</div>|
|<div style='white-space: nowrap;'>customer-metadata-form</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str :$form_code</div>|Retrieve all attributes filtered by form code|GET|<div style='white-space: nowrap;'>/V1/attributeMetadata/customer/form/:formCode</div>|
|<div style='white-space: nowrap;'>customer-metadata</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Get all attribute metadata.|GET|<div style='white-space: nowrap;'>/V1/attributeMetadata/customer</div>|
|<div style='white-space: nowrap;'>customer-metadata-custom</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Get custom attributes metadata for the given data interface.|GET|<div style='white-space: nowrap;'>/V1/attributeMetadata/customer/custom</div>|
|<div style='white-space: nowrap;'>customer-address-attribute</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str :$attribute_code</div>|Retrieve attribute metadata.|GET|<div style='white-space: nowrap;'>/V1/attributeMetadata/customerAddress/attribute/:attributeCode</div>|
|<div style='white-space: nowrap;'>customer-address-form</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str :$form_code</div>|Retrieve all attributes filtered by form code|GET|<div style='white-space: nowrap;'>/V1/attributeMetadata/customerAddress/form/:formCode</div>|
|<div style='white-space: nowrap;'>customer-address</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Get all attribute metadata.|GET|<div style='white-space: nowrap;'>/V1/attributeMetadata/customerAddress</div>|
|<div style='white-space: nowrap;'>customer-address-custom</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Get custom attributes metadata for the given data interface.|GET|<div style='white-space: nowrap;'>/V1/attributeMetadata/customerAddress/custom</div>|
|<div style='white-space: nowrap;'>customers-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id</div>|Delete customer by ID.|DELETE|<div style='white-space: nowrap;'>/V1/customers/:customerId</div>|
|<div style='white-space: nowrap;'>customers</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id,<br/>    Hash :$data</div>|Create or update a customer.|PUT|<div style='white-space: nowrap;'>/V1/customers/:id</div>|
|<div style='white-space: nowrap;'>customers</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id</div>|Get customer by customer ID.|GET|<div style='white-space: nowrap;'>/V1/customers/:customerId</div>|
|<div style='white-space: nowrap;'>customers-me-activate</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data</div>|Activate a customer account using a key that was sent in a confirmation email.|PUT|<div style='white-space: nowrap;'>/V1/customers/me/activate</div>|
|<div style='white-space: nowrap;'>customers-me</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Get customer by customer ID.|GET|<div style='white-space: nowrap;'>/V1/customers/me</div>|
|<div style='white-space: nowrap;'>customers-me</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data</div>|Create or update a customer.|PUT|<div style='white-space: nowrap;'>/V1/customers/me</div>|
|<div style='white-space: nowrap;'>customers-me-password</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data</div>|Change customer password.|PUT|<div style='white-space: nowrap;'>/V1/customers/me/password</div>|
|<div style='white-space: nowrap;'>customers-me-billing-address</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Retrieve default billing address for the given customerId.|GET|<div style='white-space: nowrap;'>/V1/customers/me/billingAddress</div>|
|<div style='white-space: nowrap;'>customers-me-shipping-address</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Retrieve default shipping address for the given customerId.|GET|<div style='white-space: nowrap;'>/V1/customers/me/shippingAddress</div>|
|<div style='white-space: nowrap;'>customers-search</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria</div>|Retrieve customers which match a specified criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#CustomerRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/customers/search</div>|
|<div style='white-space: nowrap;'>customers-email-activate</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$email,<br/>    Hash :$data</div>|Activate a customer account using a key that was sent in a confirmation email.|PUT|<div style='white-space: nowrap;'>/V1/customers/:email/activate</div>|
|<div style='white-space: nowrap;'>customers-reset-link-token</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id,<br/>    Str  :$link_token</div>|Check if password reset token is valid.|GET|<div style='white-space: nowrap;'>/V1/customers/:customerId/password/resetLinkToken/:resetPasswordLinkToken</div>|
|<div style='white-space: nowrap;'>customers-password</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data</div>|Send an email to the customer with a password reset link.|PUT|<div style='white-space: nowrap;'>/V1/customers/password</div>|
|<div style='white-space: nowrap;'>customers-confirm</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id</div>|Gets the account confirmation status.|GET|<div style='white-space: nowrap;'>/V1/customers/:customerId/confirm</div>|
|<div style='white-space: nowrap;'>customers-confirm</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data</div>|Resend confirmation email.|POST|<div style='white-space: nowrap;'>/V1/customers/confirm</div>|
|<div style='white-space: nowrap;'>customers-validate</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data</div>|Validate customer data.|PUT|<div style='white-space: nowrap;'>/V1/customers/validate</div>|
|<div style='white-space: nowrap;'>customers-permissions</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id</div>|Check if customer can be deleted.|GET|<div style='white-space: nowrap;'>/V1/customers/:customerId/permissions/readonly</div>|
|<div style='white-space: nowrap;'>customers-email-available</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data</div>|Check if given email is associated with a customer account in given website.|POST|<div style='white-space: nowrap;'>/V1/customers/isEmailAvailable</div>|
|<div style='white-space: nowrap;'>customers-addresses</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$address_id</div>|Retrieve customer address.|GET|<div style='white-space: nowrap;'>/V1/customers/addresses/:addressId</div>|
|<div style='white-space: nowrap;'>customers-addresses-billing</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id</div>|Retrieve default billing address for the given customerId.|GET|<div style='white-space: nowrap;'>/V1/customers/:customerId/billingAddress</div>|
|<div style='white-space: nowrap;'>customers-addresses-shipping</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id</div>|Retrieve default shipping address for the given customerId.|GET|<div style='white-space: nowrap;'>/V1/customers/:customerId/shippingAddress</div>|
|<div style='white-space: nowrap;'>customers-addresses-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$address_id</div>|Delete customer address by ID.|DELETE|<div style='white-space: nowrap;'>/V1/addresses/:addressId</div>|
## Magento::CustomerBalance
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>carts-mine-balance-apply</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Apply store credit|POST|<div style='white-space: nowrap;'>/V1/carts/mine/balance/apply</div>|
## Magento::Directory
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>directory-countries</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Get all countries and regions information for the store.|GET|<div style='white-space: nowrap;'>/V1/directory/countries</div>|
|<div style='white-space: nowrap;'>directory-countries</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$country_id!</div>|Get country and region information for the store.|GET|<div style='white-space: nowrap;'>/V1/directory/countries/:countryId</div>|
|<div style='white-space: nowrap;'>directory-currency</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Get currency information for the store.|GET|<div style='white-space: nowrap;'>/V1/directory/currency</div>|
## Magento::Downloadable
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>products-downloadable-links</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!</div>|List of links with associated samples|GET|<div style='white-space: nowrap;'>/V1/products/:sku/downloadable-links</div>|
|<div style='white-space: nowrap;'>products-downloadable-links</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Hash :$data!</div>|Update downloadable link of the given product (link type and its resources cannot be changed)|POST|<div style='white-space: nowrap;'>/V1/products/:sku/downloadable-links</div>|
|<div style='white-space: nowrap;'>products-downloadable-links</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Int  :$id!,<br/>    Hash :$data!</div>|Update downloadable link of the given product (link type and its resources cannot be changed)|PUT|<div style='white-space: nowrap;'>/V1/products/:sku/downloadable-links/:id</div>|
|<div style='white-space: nowrap;'>products-downloadable-links-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Delete downloadable link|DELETE|<div style='white-space: nowrap;'>/V1/products/downloadable-links/:id</div>|
|<div style='white-space: nowrap;'>products-downloadable-links-samples</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!</div>|List of samples for downloadable product|GET|<div style='white-space: nowrap;'>/V1/products/:sku/downloadable-links/samples</div>|
|<div style='white-space: nowrap;'>products-downloadable-links-samples</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Hash :$data!</div>|Update downloadable sample of the given product|POST|<div style='white-space: nowrap;'>/V1/products/:sku/downloadable-links/samples</div>|
|<div style='white-space: nowrap;'>products-downloadable-links-samples</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$sku!,<br/>    Int  :$id!,<br/>    Hash :$data!</div>|Update downloadable sample of the given product|PUT|<div style='white-space: nowrap;'>/V1/products/:sku/downloadable-links/samples/:id</div>|
|<div style='white-space: nowrap;'>products-downloadable-links-samples-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Delete downloadable sample|DELETE|<div style='white-space: nowrap;'>/V1/products/downloadable-links/samples/:id</div>|
## Magento::Eav
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>eav-attribute-sets</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$attribute_set_id!</div>|Retrieve attribute set information based on given ID|GET|<div style='white-space: nowrap;'>/V1/eav/attribute-sets/:attributeSetId</div>|
|<div style='white-space: nowrap;'>eav-attribute-sets-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$attribute_set_id!</div>|Remove attribute set by given ID|DELETE|<div style='white-space: nowrap;'>/V1/eav/attribute-sets/:attributeSetId</div>|
|<div style='white-space: nowrap;'>eav-attribute-sets</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Create attribute set from data|POST|<div style='white-space: nowrap;'>/V1/eav/attribute-sets</div>|
|<div style='white-space: nowrap;'>eav-attribute-sets</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$attribute_set_id!,<br/>    Hash :$data!</div>|Save attribute set data|PUT|<div style='white-space: nowrap;'>/V1/eav/attribute-sets/:attributeSetId</div>|
|<div style='white-space: nowrap;'>eav-attribute-sets-list</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Retrieve list of Attribute Sets This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#AttributeSetRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/eav/attribute-sets/list</div>|
## Magento::GiftCardAccount
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>carts-giftCards</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$quote_id!</div>|Return GiftCard Account cards|GET|<div style='white-space: nowrap;'>/V1/carts/:quoteId/giftCards</div>|
|<div style='white-space: nowrap;'>carts-giftCards</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Hash :$data!</div>||PUT|<div style='white-space: nowrap;'>/V1/carts/:cartId/giftCards</div>|
|<div style='white-space: nowrap;'>carts-mine-giftCards</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>||POST|<div style='white-space: nowrap;'>/V1/carts/mine/giftCards</div>|
|<div style='white-space: nowrap;'>carts-guest-carts-giftCards</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Hash :$data!</div>||POST|<div style='white-space: nowrap;'>/V1/carts/guest-carts/:cartId/giftCards</div>|
|<div style='white-space: nowrap;'>carts-guest-carts-checkGiftCard</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Str  :$gift_card_code!</div>||GET|<div style='white-space: nowrap;'>/V1/carts/guest-carts/:cartId/checkGiftCard/:giftCardCode</div>|
|<div style='white-space: nowrap;'>carts-mine-checkGiftCard</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$gift_card_code!</div>||GET|<div style='white-space: nowrap;'>/V1/carts/mine/checkGiftCard/:giftCardCode</div>|
## Magento::GiftMessage
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>carts-gift-message</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!</div>|Return the gift message for a specified order.|GET|<div style='white-space: nowrap;'>/V1/carts/:cartId/gift-message</div>|
|<div style='white-space: nowrap;'>carts-gift-message</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Int  :$item_id!</div>|Return the gift message for a specified item in a specified shopping cart.|GET|<div style='white-space: nowrap;'>/V1/carts/:cartId/gift-message/:itemId</div>|
|<div style='white-space: nowrap;'>carts-gift-message</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Hash :$data!</div>|Set the gift message for an entire order.|POST|<div style='white-space: nowrap;'>/V1/carts/:cartId/gift-message</div>|
|<div style='white-space: nowrap;'>carts-gift-message</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Int  :$item_id!,<br/>    Hash :$data!</div>|Set the gift message for a specified item in a specified shopping cart.|POST|<div style='white-space: nowrap;'>/V1/carts/:cartId/gift-message/:itemId</div>|
|<div style='white-space: nowrap;'>carts-mine-gift-message</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Return the gift message for a specified order.|GET|<div style='white-space: nowrap;'>/V1/carts/mine/gift-message</div>|
|<div style='white-space: nowrap;'>carts-mine-gift-message</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$item_id!</div>|Return the gift message for a specified item in a specified shopping cart.|GET|<div style='white-space: nowrap;'>/V1/carts/mine/gift-message/:itemId</div>|
|<div style='white-space: nowrap;'>carts-mine-gift-message</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Set the gift message for an entire order.|POST|<div style='white-space: nowrap;'>/V1/carts/mine/gift-message</div>|
|<div style='white-space: nowrap;'>carts-mine-gift-message</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$item_id!,<br/>    Hash :$data!</div>|Set the gift message for a specified item in a specified shopping cart.|POST|<div style='white-space: nowrap;'>/V1/carts/mine/gift-message/:itemId</div>|
|<div style='white-space: nowrap;'>guest-carts-gift-message</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!</div>|Return the gift message for a specified order.|GET|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/gift-message</div>|
|<div style='white-space: nowrap;'>guest-carts-gift-message</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Int  :$item_id!</div>|Return the gift message for a specified item in a specified shopping cart.|GET|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/gift-message/:itemId</div>|
|<div style='white-space: nowrap;'>guest-carts-gift-message</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Hash :$data!</div>|Set the gift message for an entire order.|POST|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/gift-message</div>|
|<div style='white-space: nowrap;'>guest-carts-gift-message</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Int  :$item_id!,<br/>    Hash :$data!</div>|Set the gift message for a specified item in a specified shopping cart.|POST|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/gift-message/:itemId</div>|
## Magento::GiftRegistry
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>giftregistry-mine-estimate-shipping-methods</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Estimate shipping|POST|<div style='white-space: nowrap;'>/V1/giftregistry/mine/estimate-shipping-methods</div>|
|<div style='white-space: nowrap;'>guest-giftregistry-estimate-shipping-methods</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Hash :$data!</div>|Estimate shipping|POST|<div style='white-space: nowrap;'>/V1/guest-giftregistry/:cartId/estimate-shipping-methods</div>|
## Magento::GiftWrapping
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>gift-wrappings</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$id!</div>|Return data object for specified wrapping ID and store.|GET|<div style='white-space: nowrap;'>/V1/gift-wrappings/:id</div>|
|<div style='white-space: nowrap;'>gift-wrappings</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Create/Update new gift wrapping with data object values|POST|<div style='white-space: nowrap;'>/V1/gift-wrappings</div>|
|<div style='white-space: nowrap;'>gift-wrappings</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$wrapping_id!,<br/>    Hash :$data!</div>|Create/Update new gift wrapping with data object values|PUT|<div style='white-space: nowrap;'>/V1/gift-wrappings/:wrappingId</div>|
|<div style='white-space: nowrap;'>gift-wrappings</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Return list of gift wrapping data objects based on search criteria|GET|<div style='white-space: nowrap;'>/V1/gift-wrappings</div>|
|<div style='white-space: nowrap;'>gift-wrappings-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$id!</div>|Delete gift wrapping|DELETE|<div style='white-space: nowrap;'>/V1/gift-wrappings/:id</div>|
## Magento::Integration
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>integration-token</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$user_type!,<br/>    Hash :$data!</div>|Create access token user given the admin / customer credentials.|POST|<div style='white-space: nowrap;'>/V1/integration/[admin\|customer]/token</div>|
## Magento::Quote
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>carts</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!</div>|Enables an administrative user to return information for a specified cart.|GET|<div style='white-space: nowrap;'>/V1/carts/:cartId</div>|
|<div style='white-space: nowrap;'>carts</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Creates an empty cart and quote for a guest.|POST|<div style='white-space: nowrap;'>/V1/carts/</div>|
|<div style='white-space: nowrap;'>carts</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Hash :$data!</div>|Assigns a specified customer to a specified shopping cart.|PUT|<div style='white-space: nowrap;'>/V1/carts/:cartId</div>|
|<div style='white-space: nowrap;'>carts-billing-address</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!</div>|Returns the billing address for a specified quote.|GET|<div style='white-space: nowrap;'>/V1/carts/:cartId/billing-address</div>|
|<div style='white-space: nowrap;'>carts-billing-address</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Hash :$data!</div>|Assigns a specified billing address to a specified cart.|POST|<div style='white-space: nowrap;'>/V1/carts/:cartId/billing-address</div>|
|<div style='white-space: nowrap;'>carts-coupons</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!</div>|Returns information for a coupon in a specified cart.|GET|<div style='white-space: nowrap;'>/V1/carts/:cartId/coupons</div>|
|<div style='white-space: nowrap;'>carts-coupons</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Str  :$coupon_code!</div>|Adds a coupon by code to a specified cart.|PUT|<div style='white-space: nowrap;'>/V1/carts/:cartId/coupons/:couponCode</div>|
|<div style='white-space: nowrap;'>carts-coupons-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!</div>|Deletes a coupon from a specified cart.|DELETE|<div style='white-space: nowrap;'>/V1/carts/:cartId/coupons</div>|
|<div style='white-space: nowrap;'>carts-estimate-shipping-methods</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Hash :$data!</div>|Estimate shipping by address and return list of available shipping methods|POST|<div style='white-space: nowrap;'>/V1/carts/:cartId/estimate-shipping-methods</div>|
|<div style='white-space: nowrap;'>carts-estimate-shipping-methods-by-address-id</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Hash :$data!</div>|Estimate shipping|POST|<div style='white-space: nowrap;'>/V1/carts/:cartId/estimate-shipping-methods-by-address-id</div>|
|<div style='white-space: nowrap;'>carts-items</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!</div>|Lists items that are assigned to a specified cart.|GET|<div style='white-space: nowrap;'>/V1/carts/:cartId/items</div>|
|<div style='white-space: nowrap;'>carts-items</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Hash :$data!</div>|Add/update the specified cart item.|POST|<div style='white-space: nowrap;'>/V1/carts/:quoteId/items</div>|
|<div style='white-space: nowrap;'>carts-items</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Int  :$item_id!,<br/>    Hash :$data!</div>|Add/update the specified cart item.|PUT|<div style='white-space: nowrap;'>/V1/carts/:cartId/items/:itemId</div>|
|<div style='white-space: nowrap;'>carts-items-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Int  :$item_id!</div>|Removes the specified item from the specified cart.|DELETE|<div style='white-space: nowrap;'>/V1/carts/:cartId/items/:itemId</div>|
|<div style='white-space: nowrap;'>carts-mine-new</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Creates an empty cart and quote for a specified customer if customer does not have a cart yet.|POST|<div style='white-space: nowrap;'>/V1/carts/mine</div>|
|<div style='white-space: nowrap;'>carts-mine</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Returns information for the cart for a specified customer.|GET|<div style='white-space: nowrap;'>/V1/carts/mine</div>|
|<div style='white-space: nowrap;'>carts-mine-update</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Save quote|PUT|<div style='white-space: nowrap;'>/V1/carts/mine</div>|
|<div style='white-space: nowrap;'>carts-mine-billing-address</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Returns the billing address for a specified quote.|GET|<div style='white-space: nowrap;'>/V1/carts/mine/billing-address</div>|
|<div style='white-space: nowrap;'>carts-mine-billing-address</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Assigns a specified billing address to a specified cart.|POST|<div style='white-space: nowrap;'>/V1/carts/mine/billing-address</div>|
|<div style='white-space: nowrap;'>carts-mine-collect-totals</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Set shipping/billing methods and additional data for cart and collect totals.|PUT|<div style='white-space: nowrap;'>/V1/carts/mine/collect-totals</div>|
|<div style='white-space: nowrap;'>carts-mine-coupons</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Returns information for a coupon in a specified cart.|GET|<div style='white-space: nowrap;'>/V1/carts/mine/coupons</div>|
|<div style='white-space: nowrap;'>carts-mine-coupons</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$coupon_code!,<br/>    Hash :$data!</div>|Adds a coupon by code to a specified cart.|PUT|<div style='white-space: nowrap;'>/V1/carts/mine/coupons/:couponCode</div>|
|<div style='white-space: nowrap;'>carts-mine-coupons-delete</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Deletes a coupon from a specified cart.|DELETE|<div style='white-space: nowrap;'>/V1/carts/mine/coupons</div>|
|<div style='white-space: nowrap;'>carts-mine-estimate-shipping-methods</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Estimate shipping by address and return list of available shipping methods|POST|<div style='white-space: nowrap;'>/V1/carts/mine/estimate-shipping-methods</div>|
|<div style='white-space: nowrap;'>carts-mine-estimate-shipping-methods-by-address-id</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Estimate shipping|POST|<div style='white-space: nowrap;'>/V1/carts/mine/estimate-shipping-methods-by-address-id</div>|
|<div style='white-space: nowrap;'>carts-mine-items</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Lists items that are assigned to a specified cart.|GET|<div style='white-space: nowrap;'>/V1/carts/mine/items</div>|
|<div style='white-space: nowrap;'>carts-mine-items</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Add/update the specified cart item.|POST|<div style='white-space: nowrap;'>/V1/carts/mine/items</div>|
|<div style='white-space: nowrap;'>carts-mine-items</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$item_id!,<br/>    Hash :$data!</div>|Add/update the specified cart item.|PUT|<div style='white-space: nowrap;'>/V1/carts/mine/items/:itemId</div>|
|<div style='white-space: nowrap;'>carts-mine-items-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$item_id!</div>|Removes the specified item from the specified cart.|DELETE|<div style='white-space: nowrap;'>/V1/carts/mine/items/:itemId</div>|
|<div style='white-space: nowrap;'>carts-mine-order</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Places an order for a specified cart.|PUT|<div style='white-space: nowrap;'>/V1/carts/mine/order</div>|
|<div style='white-space: nowrap;'>carts-mine-payment-methods</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Lists available payment methods for a specified shopping cart. This call returns an array of objects, but detailed information about each object’s attributes might not be included.  See http://devdocs.magento.com/codelinks/attributes.html#PaymentMethodManagementInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/carts/mine/payment-methods</div>|
|<div style='white-space: nowrap;'>carts-mine-selected-payment-method</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Returns the payment method for a specified shopping cart.|GET|<div style='white-space: nowrap;'>/V1/carts/mine/selected-payment-method</div>|
|<div style='white-space: nowrap;'>carts-mine-selected-payment-method</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Adds a specified payment method to a specified shopping cart.|PUT|<div style='white-space: nowrap;'>/V1/carts/mine/selected-payment-method</div>|
|<div style='white-space: nowrap;'>carts-mine-shipping-methods</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Lists applicable shipping methods for a specified quote.|GET|<div style='white-space: nowrap;'>/V1/carts/mine/shipping-methods</div>|
|<div style='white-space: nowrap;'>carts-mine-totals</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Returns quote totals data for a specified cart.|GET|<div style='white-space: nowrap;'>/V1/carts/mine/totals</div>|
|<div style='white-space: nowrap;'>carts-order</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Hash :$data!</div>|Places an order for a specified cart.|PUT|<div style='white-space: nowrap;'>/V1/carts/:cartId/order</div>|
|<div style='white-space: nowrap;'>carts-payment-methods</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!</div>|Lists available payment methods for a specified shopping cart. This call returns an array of objects, but detailed information about each object’s attributes might not be included.  See http://devdocs.magento.com/codelinks/attributes.html#PaymentMethodManagementInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/carts/:cartId/payment-methods</div>|
|<div style='white-space: nowrap;'>carts-search</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Enables administrative users to list carts that match specified search criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included.  See http://devdocs.magento.com/codelinks/attributes.html#CartRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/carts/search</div>|
|<div style='white-space: nowrap;'>carts-selected-payment-method</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!</div>|Returns the payment method for a specified shopping cart.|GET|<div style='white-space: nowrap;'>/V1/carts/:cartId/selected-payment-method</div>|
|<div style='white-space: nowrap;'>carts-selected-payment-method</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!,<br/>    Hash :$data!</div>|Adds a specified payment method to a specified shopping cart.|PUT|<div style='white-space: nowrap;'>/V1/carts/:cartId/selected-payment-method</div>|
|<div style='white-space: nowrap;'>carts-shipping-methods</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!</div>|Lists applicable shipping methods for a specified quote.|GET|<div style='white-space: nowrap;'>/V1/carts/:cartId/shipping-methods</div>|
|<div style='white-space: nowrap;'>carts-totals</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$cart_id!</div>|Returns quote totals data for a specified cart.|GET|<div style='white-space: nowrap;'>/V1/carts/:cartId/totals</div>|
|<div style='white-space: nowrap;'>customers-carts</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$customer_id!</div>|Creates an empty cart and quote for a specified customer if customer does not have a cart yet.|POST|<div style='white-space: nowrap;'>/V1/customers/:customerId/carts</div>|
|<div style='white-space: nowrap;'>guest-carts</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!</div>|Enable a guest user to return information for a specified cart.|GET|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId</div>|
|<div style='white-space: nowrap;'>guest-carts</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Enable an customer or guest user to create an empty cart and quote for an anonymous customer.|POST|<div style='white-space: nowrap;'>/V1/guest-carts</div>|
|<div style='white-space: nowrap;'>guest-carts</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Hash :$data!</div>|Assign a specified customer to a specified shopping cart.|PUT|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId</div>|
|<div style='white-space: nowrap;'>guest-carts-billing-address</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!</div>|Return the billing address for a specified quote.|GET|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/billing-address</div>|
|<div style='white-space: nowrap;'>guest-carts-billing-address</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Hash :$data!</div>|Assign a specified billing address to a specified cart.|POST|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/billing-address</div>|
|<div style='white-space: nowrap;'>guest-carts-collect-totals</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Hash :$data!</div>|Set shipping/billing methods and additional data for cart and collect totals for guest.|PUT|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/collect-totals</div>|
|<div style='white-space: nowrap;'>guest-carts-coupons</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!</div>|Return information for a coupon in a specified cart.|GET|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/coupons</div>|
|<div style='white-space: nowrap;'>guest-carts-coupons</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Str  :$coupon_code!</div>|Add a coupon by code to a specified cart.|PUT|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/coupons/:couponCode</div>|
|<div style='white-space: nowrap;'>guest-carts-coupons-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!</div>|Delete a coupon from a specified cart.|DELETE|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/coupons</div>|
|<div style='white-space: nowrap;'>guest-carts-estimate-shipping-methods</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Hash :$data!</div>|Estimate shipping by address and return list of available shipping methods|POST|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/estimate-shipping-methods</div>|
|<div style='white-space: nowrap;'>guest-carts-items</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!</div>|List items that are assigned to a specified cart.|GET|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/items</div>|
|<div style='white-space: nowrap;'>guest-carts-items</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Hash :$data!</div>|Add/update the specified cart item.|POST|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/items</div>|
|<div style='white-space: nowrap;'>guest-carts-items</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Int  :$item_id!,<br/>    Hash :$data!</div>|Add/update the specified cart item.|PUT|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/items/:itemId</div>|
|<div style='white-space: nowrap;'>guest-carts-items-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Int  :$item_id!</div>|Remove the specified item from the specified cart.|DELETE|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/items/:itemId</div>|
|<div style='white-space: nowrap;'>guest-carts-order</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Hash :$data!</div>|Place an order for a specified cart.|PUT|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/order</div>|
|<div style='white-space: nowrap;'>guest-carts-payment-methods</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!</div>|List available payment methods for a specified shopping cart. This call returns an array of objects, but detailed information about each object’s attributes might not be included.  See http://devdocs.magento.com/codelinks/attributes.html#GuestPaymentMethodManagementInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/payment-methods</div>|
|<div style='white-space: nowrap;'>guest-carts-selected-payment-method</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!</div>|Return the payment method for a specified shopping cart.|GET|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/selected-payment-method</div>|
|<div style='white-space: nowrap;'>guest-carts-selected-payment-method</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!,<br/>    Hash :$data!</div>|Add a specified payment method to a specified shopping cart.|PUT|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/selected-payment-method</div>|
|<div style='white-space: nowrap;'>guest-carts-shipping-methods</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!</div>|List applicable shipping methods for a specified quote.|GET|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/shipping-methods</div>|
|<div style='white-space: nowrap;'>guest-carts-totals</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$cart_id!</div>|Return quote totals data for a specified cart.|GET|<div style='white-space: nowrap;'>/V1/guest-carts/:cartId/totals</div>|
## Magento::Reward
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>reward-mine-use-reward</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Set reward points to quote|POST|<div style='white-space: nowrap;'>/V1/reward/mine/use-reward</div>|
## Magento::Rma
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>returns</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$id!</div>|Return data object for specified RMA id|GET|<div style='white-space: nowrap;'>/V1/returns/:id</div>|
|<div style='white-space: nowrap;'>returns-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$id!</div>|Delete RMA|DELETE|<div style='white-space: nowrap;'>/V1/returns/:id</div>|
|<div style='white-space: nowrap;'>returns</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Save RMA|POST|<div style='white-space: nowrap;'>/V1/returns</div>|
|<div style='white-space: nowrap;'>returns</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$id!,<br/>    Hash :$data!</div>|Save RMA|PUT|<div style='white-space: nowrap;'>/V1/returns/:id</div>|
|<div style='white-space: nowrap;'>returns</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Return list of rma data objects based on search criteria|GET|<div style='white-space: nowrap;'>/V1/returns</div>|
|<div style='white-space: nowrap;'>returns-attribute-metadata</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$attribute_code!</div>|Retrieve attribute metadata.|GET|<div style='white-space: nowrap;'>/V1/returnsAttributeMetadata/:attributeCode</div>|
|<div style='white-space: nowrap;'>returns-attribute-metadata</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Get all attribute metadata.|GET|<div style='white-space: nowrap;'>/V1/returnsAttributeMetadata</div>|
|<div style='white-space: nowrap;'>returns-attribute-metadata-custom</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Get custom attribute metadata for the given Data object's attribute set|GET|<div style='white-space: nowrap;'>/V1/returnsAttributeMetadata/custom</div>|
|<div style='white-space: nowrap;'>returns-attribute-metadata-form</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$form_code!</div>|Retrieve all attributes filtered by form code|GET|<div style='white-space: nowrap;'>/V1/returnsAttributeMetadata/form/:formCode</div>|
|<div style='white-space: nowrap;'>returns-comments</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$id!,<br/>    Hash :$data!</div>|Add comment|POST|<div style='white-space: nowrap;'>/V1/returns/:id/comments</div>|
|<div style='white-space: nowrap;'>returns-comments</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$id!</div>|Comments list|GET|<div style='white-space: nowrap;'>/V1/returns/:id/comments</div>|
|<div style='white-space: nowrap;'>returns-labels</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$id!</div>|Get shipping label int the PDF format|GET|<div style='white-space: nowrap;'>/V1/returns/:id/labels</div>|
|<div style='white-space: nowrap;'>returns-tracking-numbers</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$id!,<br/>    Hash :$data!</div>|Add track|POST|<div style='white-space: nowrap;'>/V1/returns/:id/tracking-numbers</div>|
|<div style='white-space: nowrap;'>returns-tracking-numbers-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$id!,<br/>    Int  :$track_id!</div>|Remove track by id|DELETE|<div style='white-space: nowrap;'>/V1/returns/:id/tracking-numbers/:trackId</div>|
|<div style='white-space: nowrap;'>returns-tracking-numbers</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Str  :$id!</div>|Get track list|GET|<div style='white-space: nowrap;'>/V1/returns/:id/tracking-numbers</div>|
## Magento::Sales
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>orders</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Loads a specified order.|GET|<div style='white-space: nowrap;'>/V1/orders/:id</div>|
|<div style='white-space: nowrap;'>orders</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Lists orders that match specified search criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#OrderRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/orders</div>|
|<div style='white-space: nowrap;'>orders</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$parent_id!,<br/>    Hash :$data!</div>|Performs persist operations for a specified order address.|PUT|<div style='white-space: nowrap;'>/V1/orders/:parent_id</div>|
|<div style='white-space: nowrap;'>orders-statuses</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Gets the status for a specified order.|GET|<div style='white-space: nowrap;'>/V1/orders/:id/statuses</div>|
|<div style='white-space: nowrap;'>orders-cancel</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!,<br/>    Hash :$data!</div>|Cancels a specified order.|POST|<div style='white-space: nowrap;'>/V1/orders/:id/cancel</div>|
|<div style='white-space: nowrap;'>orders-emails</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Emails a user a specified order.|POST|<div style='white-space: nowrap;'>/V1/orders/:id/emails</div>|
|<div style='white-space: nowrap;'>orders-hold</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Holds a specified order.|POST|<div style='white-space: nowrap;'>/V1/orders/:id/hold</div>|
|<div style='white-space: nowrap;'>orders-unhold</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Releases a specified order from hold status.|POST|<div style='white-space: nowrap;'>/V1/orders/:id/unhold</div>|
|<div style='white-space: nowrap;'>orders-comments</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!,<br/>    Hash :$data!</div>|Adds a comment to a specified order.|POST|<div style='white-space: nowrap;'>/V1/orders/:id/comments</div>|
|<div style='white-space: nowrap;'>orders-comments</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!,<br/>    Hash :$search_criteria = %{}</div>|Lists comments for a specified order.|GET|<div style='white-space: nowrap;'>/V1/orders/:id/comments</div>|
|<div style='white-space: nowrap;'>orders-create</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Performs persist operations for a specified order.|PUT|<div style='white-space: nowrap;'>/V1/orders/create</div>|
|<div style='white-space: nowrap;'>orders-items</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Loads a specified order item.|GET|<div style='white-space: nowrap;'>/V1/orders/items/:id</div>|
|<div style='white-space: nowrap;'>orders-items</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Lists order items that match specified search criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#OrderItemRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/orders/items</div>|
|<div style='white-space: nowrap;'>invoices</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Loads a specified invoice.|GET|<div style='white-space: nowrap;'>/V1/invoices/:id</div>|
|<div style='white-space: nowrap;'>invoices</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Lists invoices that match specified search criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#InvoiceRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/invoices</div>|
|<div style='white-space: nowrap;'>invoices</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Performs persist operations for a specified invoice.|POST|<div style='white-space: nowrap;'>/V1/invoices/</div>|
|<div style='white-space: nowrap;'>invoices-comments</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!,<br/>    Hash :$search_criteria = %{}</div>|Lists comments for a specified invoice.|GET|<div style='white-space: nowrap;'>/V1/invoices/:id/comments</div>|
|<div style='white-space: nowrap;'>invoices-emails</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Emails a user a specified invoice.|POST|<div style='white-space: nowrap;'>/V1/invoices/:id/emails</div>|
|<div style='white-space: nowrap;'>invoices-void</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!,<br/>    Hash :$data!</div>|Voids a specified invoice.|POST|<div style='white-space: nowrap;'>/V1/invoices/:id/void</div>|
|<div style='white-space: nowrap;'>invoices-capture</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Sets invoice capture.|POST|<div style='white-space: nowrap;'>/V1/invoices/:id/capture</div>|
|<div style='white-space: nowrap;'>invoices-comments</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Performs persist operations for a specified invoice comment.|POST|<div style='white-space: nowrap;'>/V1/invoices/comments</div>|
|<div style='white-space: nowrap;'>creditmemo-comments</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Lists comments for a specified credit memo.|GET|<div style='white-space: nowrap;'>/V1/creditmemo/:id/comments</div>|
|<div style='white-space: nowrap;'>creditmemos</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Lists credit memos that match specified search criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#CreditmemoRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/creditmemos</div>|
|<div style='white-space: nowrap;'>creditmemo</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Loads a specified credit memo.|GET|<div style='white-space: nowrap;'>/V1/creditmemo/:id</div>|
|<div style='white-space: nowrap;'>creditmemo</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!,<br/>    Hash :$data!</div>|Cancels a specified credit memo.|PUT|<div style='white-space: nowrap;'>/V1/creditmemo/:id</div>|
|<div style='white-space: nowrap;'>creditmemo-emails</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Emails a user a specified credit memo.|POST|<div style='white-space: nowrap;'>/V1/creditmemo/:id/emails</div>|
|<div style='white-space: nowrap;'>creditmemo-comments</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!,<br/>    Hash :$data!</div>|Performs persist operations for a specified entity.|POST|<div style='white-space: nowrap;'>/V1/creditmemo/:id/comments</div>|
|<div style='white-space: nowrap;'>creditmemo</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Performs persist operations for a specified credit memo.|POST|<div style='white-space: nowrap;'>/V1/creditmemo</div>|
|<div style='white-space: nowrap;'>shipment</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Loads a specified shipment.|GET|<div style='white-space: nowrap;'>/V1/shipment/:id</div>|
|<div style='white-space: nowrap;'>shipments</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Lists shipments that match specified search criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#ShipmentRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/shipments</div>|
|<div style='white-space: nowrap;'>shipment-comments</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Lists comments for a specified shipment.|GET|<div style='white-space: nowrap;'>/V1/shipment/:id/comments</div>|
|<div style='white-space: nowrap;'>shipment-comments</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!,<br/>    Hash :$data!</div>|Performs persist operations for a specified shipment comment.|POST|<div style='white-space: nowrap;'>/V1/shipment/:id/comments</div>|
|<div style='white-space: nowrap;'>shipment-emails</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Emails user a specified shipment.|POST|<div style='white-space: nowrap;'>/V1/shipment/:id/emails</div>|
|<div style='white-space: nowrap;'>shipment-track</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Performs persist operations for a specified shipment track.|POST|<div style='white-space: nowrap;'>/V1/shipment/track</div>|
|<div style='white-space: nowrap;'>shipment-track-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Deletes a specified shipment track by ID.|DELETE|<div style='white-space: nowrap;'>/V1/shipment/track/:id</div>|
|<div style='white-space: nowrap;'>shipment</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Performs persist operations for a specified shipment.|POST|<div style='white-space: nowrap;'>/V1/shipment/</div>|
|<div style='white-space: nowrap;'>shipment-label</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Gets a specified shipment label.|GET|<div style='white-space: nowrap;'>/V1/shipment/:id/label</div>|
|<div style='white-space: nowrap;'>orders</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Performs persist operations for a specified order.|POST|<div style='white-space: nowrap;'>/V1/orders/</div>|
|<div style='white-space: nowrap;'>transactions</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$id!</div>|Loads a specified transaction.|GET|<div style='white-space: nowrap;'>/V1/transactions/:id</div>|
|<div style='white-space: nowrap;'>transactions</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Lists transactions that match specified search criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#TransactionRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/transactions</div>|
|<div style='white-space: nowrap;'>order-invoice</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$order_id!,<br/>    Hash :$data!</div>||POST|<div style='white-space: nowrap;'>/V1/order/:orderId/invoice</div>|
|<div style='white-space: nowrap;'>order-ship</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$order_id!,<br/>    Hash :$data!</div>|Creates new Shipment for given Order.|POST|<div style='white-space: nowrap;'>/V1/order/:orderId/ship</div>|
|<div style='white-space: nowrap;'>invoice-refund</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$invoice_id!,<br/>    Hash :$data!</div>|Create refund for invoice|POST|<div style='white-space: nowrap;'>/V1/invoice/:invoiceId/refund</div>|
|<div style='white-space: nowrap;'>order-refund</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$order_id!,<br/>    Hash :$data!</div>|Create offline refund for order|POST|<div style='white-space: nowrap;'>/V1/order/:orderId/refund</div>|
## Magento::SalesRule
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>coupons</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$coupon_id!</div>|Get coupon by coupon id.|GET|<div style='white-space: nowrap;'>/V1/coupons/:couponId</div>|
|<div style='white-space: nowrap;'>coupons</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Save a coupon.|POST|<div style='white-space: nowrap;'>/V1/coupons</div>|
|<div style='white-space: nowrap;'>coupons</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$coupon_id!,<br/>    Hash :$data!</div>|Save a coupon.|PUT|<div style='white-space: nowrap;'>/V1/coupons/:couponId</div>|
|<div style='white-space: nowrap;'>coupons-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$coupon_id!</div>|Delete coupon by coupon id.|DELETE|<div style='white-space: nowrap;'>/V1/coupons/:couponId</div>|
|<div style='white-space: nowrap;'>coupons-delete-by-codes</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Delete coupon by coupon codes.|POST|<div style='white-space: nowrap;'>/V1/coupons/deleteByCodes</div>|
|<div style='white-space: nowrap;'>coupons-delete-by-ids</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Delete coupon by coupon ids.|POST|<div style='white-space: nowrap;'>/V1/coupons/deleteByIds</div>|
|<div style='white-space: nowrap;'>coupons-generate</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Generate coupon for a rule|POST|<div style='white-space: nowrap;'>/V1/coupons/generate</div>|
|<div style='white-space: nowrap;'>coupons-search</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Retrieve a coupon using the specified search criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#CouponRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/coupons/search</div>|
|<div style='white-space: nowrap;'>sales-rules</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$rule_id!</div>|Get rule by ID.|GET|<div style='white-space: nowrap;'>/V1/salesRules/:ruleId</div>|
|<div style='white-space: nowrap;'>sales-rules</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Save sales rule.|POST|<div style='white-space: nowrap;'>/V1/salesRules</div>|
|<div style='white-space: nowrap;'>sales-rules</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$rule_id!,<br/>    Hash :$data!</div>|Save sales rule.|PUT|<div style='white-space: nowrap;'>/V1/salesRules/:ruleId</div>|
|<div style='white-space: nowrap;'>sales-rules-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$rule_id!</div>|Delete rule by ID.|DELETE|<div style='white-space: nowrap;'>/V1/salesRules/:ruleId</div>|
|<div style='white-space: nowrap;'>sales-rules-search</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Retrieve sales rules that match te specified criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#RuleRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/salesRules/search</div>|
## Magento::Search
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>search</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Make Full Text Search and return found Documents|GET|<div style='white-space: nowrap;'>/V1/search</div>|
## Magento::Store
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>store-store-views</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Retrieve list of all stores|GET|<div style='white-space: nowrap;'>/V1/store/storeViews</div>|
|<div style='white-space: nowrap;'>store-store-groups</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Retrieve list of all groups|GET|<div style='white-space: nowrap;'>/V1/store/storeGroups</div>|
|<div style='white-space: nowrap;'>store-websites</div>|<div style='white-space: nowrap;'>    Hash $config</div>|Retrieve list of all websites|GET|<div style='white-space: nowrap;'>/V1/store/websites</div>|
|<div style='white-space: nowrap;'>store-store-configs</div>|<div style='white-space: nowrap;'>    Hash $config</div>||GET|<div style='white-space: nowrap;'>/V1/store/storeConfigs</div>|
## Magento::Tax
|Subroutine|Parameters|Description|HTTP<br/>Method|Path|
|:---|:---|:---|:---|:---|
|<div style='white-space: nowrap;'>tax-classes</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Create a Tax Class|POST|<div style='white-space: nowrap;'>/V1/taxClasses</div>|
|<div style='white-space: nowrap;'>tax-classes</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$tax_class_id!</div>|Get a tax class with the given tax class id.|GET|<div style='white-space: nowrap;'>/V1/taxClasses/:taxClassId</div>|
|<div style='white-space: nowrap;'>tax-classes</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$class_id!,<br/>    Hash :$data!</div>|Create a Tax Class|PUT|<div style='white-space: nowrap;'>/V1/taxClasses/:classId</div>|
|<div style='white-space: nowrap;'>tax-classes-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$tax_class_id!</div>|Delete a tax class with the given tax class id.|DELETE|<div style='white-space: nowrap;'>/V1/taxClasses/:taxClassId</div>|
|<div style='white-space: nowrap;'>tax-classes-search</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Retrieve tax classes which match a specific criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#TaxClassRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/taxClasses/search</div>|
|<div style='white-space: nowrap;'>tax-rates</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Create or update tax rate|POST|<div style='white-space: nowrap;'>/V1/taxRates</div>|
|<div style='white-space: nowrap;'>tax-rates</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$rate_id!</div>|Get tax rate|GET|<div style='white-space: nowrap;'>/V1/taxRates/:rateId</div>|
|<div style='white-space: nowrap;'>tax-rates</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Create or update tax rate|PUT|<div style='white-space: nowrap;'>/V1/taxRates</div>|
|<div style='white-space: nowrap;'>tax-rates-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$rate_id!</div>|Delete tax rate|DELETE|<div style='white-space: nowrap;'>/V1/taxRates/:rateId</div>|
|<div style='white-space: nowrap;'>tax-rates-search</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Search TaxRates This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#TaxRateRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/taxRates/search</div>|
|<div style='white-space: nowrap;'>tax-rules</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Save TaxRule|POST|<div style='white-space: nowrap;'>/V1/taxRules</div>|
|<div style='white-space: nowrap;'>tax-rules</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$data!</div>|Save TaxRule|PUT|<div style='white-space: nowrap;'>/V1/taxRules</div>|
|<div style='white-space: nowrap;'>tax-rules-delete</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$rule_id!</div>|Delete TaxRule|DELETE|<div style='white-space: nowrap;'>/V1/taxRules/:ruleId</div>|
|<div style='white-space: nowrap;'>tax-rules</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Int  :$rule_id!</div>|Get TaxRule|GET|<div style='white-space: nowrap;'>/V1/taxRules/:ruleId</div>|
|<div style='white-space: nowrap;'>tax-rules-search</div>|<div style='white-space: nowrap;'>    Hash $config,<br/>    Hash :$search_criteria = %{}</div>|Search TaxRules This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#TaxRuleRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.|GET|<div style='white-space: nowrap;'>/V1/taxRules/search</div>|
