/*
 This file is part of GNU Anastasis
 (C) 2021-2022 Anastasis SARL

 GNU Anastasis is free software; you can redistribute it and/or modify it under the
 terms of the GNU Affero General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Anastasis is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License along with
 GNU Anastasis; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { h, VNode } from "preact";
import { useEffect, useRef } from "preact/hooks";
import qrcode from "qrcode-generator";

export function QR({ text }: { text: string }): VNode {
  const divRef = useRef<HTMLDivElement>(null);
  useEffect(() => {
    const qr = qrcode(0, "L");
    qr.addData(text);
    qr.make();
    if (divRef.current)
      divRef.current.innerHTML = qr.createSvgTag({
        scalable: true,
      });
  });

  return (
    <div
      style={{
        width: "100%",
        display: "flex",
        flexDirection: "column",
        alignItems: "center",
      }}
    >
      <div
        style={{ width: "50%", minWidth: 200, maxWidth: 300 }}
        ref={divRef}
      />
    </div>
  );
}
