/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompiledExpression;
import gnu.jel.ExpressionImage;
import gnu.jel.Library;
import gnu.jel.OP;
import gnu.jel.OP_binary;
import gnu.jel.OP_call;
import gnu.jel.OP_convert;
import gnu.jel.OP_function;
import gnu.jel.OP_load;
import gnu.jel.OP_param;
import gnu.jel.OP_start;
import gnu.jel.OP_unary;
import gnu.jel.OPlist;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import java.util.Stack;

public class Optimizer {
    private Library lib;
    private Stack types = new Stack();
    private OPlist code = new OPlist();
    private Stack functions = new Stack();
    private Stack functionsDescriptors = new Stack();
    private Throwable caughtThrowable;
    private boolean finished = false;

    public Optimizer(Library lib) {
        this.lib = lib;
    }

    public void load(boolean c) {
        this.load(Boolean.TYPE, new Boolean(c));
    }

    public void load(byte c) {
        this.load(Byte.TYPE, new Byte(c));
    }

    public void load(char c) {
        this.load(Character.TYPE, new Character(c));
    }

    public void load(short c) {
        this.load(Short.TYPE, new Short(c));
    }

    public void load(int c) {
        this.load(Integer.TYPE, new Integer(c));
    }

    public void load(long c) {
        this.load(Long.TYPE, new Long(c));
    }

    public void load(float c) {
        this.load(Float.TYPE, new Float(c));
    }

    public void load(double c) {
        this.load(Double.TYPE, new Double(c));
    }

    private void load(Class t, Object o) {
        this.seeNonFinished();
        OP_load nop = new OP_load(t, o);
        this.types.push(t);
        this.code.addLast(nop);
    }

    public void convert(Class to) throws IllegalStateException {
        this.seeNonFinished();
        Class ct = (Class)this.types.peek();
        if (!ExpressionImage.canConvert(ct, to)) {
            throw new IllegalStateException("Requested conversion (" + ct.toString() + " --> " + to.toString() + ") is not supported.");
        }
        this.code.addLast(new OP_convert(to));
        this.types.pop();
        this.types.push(to);
    }

    public void unary(int o) {
        this.seeNonFinished();
        Class ct = (Class)this.types.peek();
        if (!ExpressionImage.canGenerateUnary(o, ct)) {
            throw new IllegalStateException("Unary " + ExpressionImage.unaryNames[o] + " is not supported on " + ct.getName() + "'s");
        }
        this.code.addLast(new OP_unary(o));
    }

    public void function_start() {
        this.seeNonFinished();
        OP_call opc = new OP_call();
        this.functions.push(opc);
        int[] descrs = new int[1];
        this.functionsDescriptors.push(descrs);
        this.code.addLast(new OP_start(opc));
    }

    public void binaryOP_param() {
        this.seeNonFinished();
        OP_binary opc = new OP_binary();
        this.functions.push(opc);
        int[] descrs = new int[1];
        this.functionsDescriptors.push(descrs);
        this.code.addLast(new OP_param(opc, (Class)this.types.peek()));
    }

    public boolean function_param() {
        this.seeNonFinished();
        OP_function opf = (OP_function)this.functions.peek();
        int[] descrs = (int[])this.functionsDescriptors.peek();
        descrs[0] = descrs[0] + 1;
        this.code.addLast(new OP_param(opf, (Class)this.types.peek()));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void function_call(String name) throws IllegalStateException {
        block4: {
            this.seeNonFinished();
            opf = (OP_call)this.functions.peek();
            descrs = (int[])this.functionsDescriptors.peek();
            nparams = descrs[0];
            paramTypes = new Class[nparams];
            i = nparams - 1;
            while (i >= 0) {
                paramTypes[i] = (Class)this.types.pop();
                --i;
            }
            try {
                m = this.lib.getMethod(name, paramTypes);
                break block4;
            }
            catch (NoSuchMethodException e) {
                i = 0;
                ** while (i < nparams)
            }
lbl-1000:
            // 1 sources

            {
                this.types.push(paramTypes[i]);
                ++i;
                continue;
            }
lbl21:
            // 1 sources

            throw new IllegalStateException(e.getMessage());
        }
        opc = opf;
        this.code.addLast(opc);
        opc.setMethod(this.code, m, this.lib.getDynamicMethodClassID(m), this.lib.isStateless(m));
        this.types.push(m.getReturnType());
        this.functions.pop();
        this.functionsDescriptors.pop();
    }

    public void binaryOP(int o) throws IllegalStateException {
        this.seeNonFinished();
        OP_binary opf = (OP_binary)this.functions.peek();
        int[] descrs = (int[])this.functionsDescriptors.peek();
        this.code.addLast(new OP_param(opf, (Class)this.types.peek()));
        Class op2 = (Class)this.types.pop();
        Class op1 = (Class)this.types.pop();
        if (!ExpressionImage.canGenerateBinary(o, op1, op2)) {
            this.types.push(op1);
            this.types.push(op2);
            throw new IllegalStateException("Types " + op1.toString() + " and " + op2.toString() + " are not suitable " + "for the operation \"" + ExpressionImage.binaryNames[o] + "\"");
        }
        Class ft = ExpressionImage.getMostGeneralType(op1, op2);
        OP_binary opc = opf;
        this.code.addLast(opc);
        opc.setOperation(this.code, o, ft);
        this.types.push(ft);
        this.functions.pop();
        this.functionsDescriptors.pop();
    }

    public void finish() throws IllegalStateException {
        this.seeNonFinished();
        if (this.code.size != 0 && this.types.size() != 1) {
            throw new IllegalStateException("Stack should contain single item on exit.");
        }
        if (this.functions.size() != 0 || this.functionsDescriptors.size() != 0) {
            throw new IllegalStateException("There are function calls in progress.");
        }
        this.finished = true;
    }

    public void optimize(int of) {
        this.seeFinished();
        if (of == 0) {
            return;
        }
        while (this.optimizeIteration()) {
        }
    }

    protected boolean optimizeIteration() {
        OP cop = this.code.getFirst();
        boolean didsome = false;
        while (cop != null && this.caughtThrowable == null) {
            OP_function copf;
            OP ncop = cop.next();
            if (cop instanceof OP_function && (copf = (OP_function)cop).canInterpret()) {
                try {
                    copf.interpret(this.code);
                    didsome = true;
                }
                catch (Throwable exc) {
                    this.caughtThrowable = exc;
                }
            }
            cop = ncop;
        }
        return didsome;
    }

    public CompiledExpression compile() {
        this.seeFinished();
        ExpressionImage image = new ExpressionImage();
        this.code.compile(image);
        image.asm_return();
        ExpressionImage.dumpImage(image);
        return image.getExpression();
    }

    public String toString() {
        return this.code.toString();
    }

    private void seeFinished() {
        if (!this.finished) {
            throw new IllegalStateException("Attempt to instantiate unfinished function.");
        }
    }

    private void seeNonFinished() {
        if (this.finished) {
            throw new IllegalStateException("Attempt to modify finished function.");
        }
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        Optimizer.test(t);
        t.summarize();
    }

    public static void test(Tester t) {
        Number res;
        CompiledExpression ce;
        Optimizer op;
        Library clib = null;
        try {
            Class[] statlb = new Class[]{Class.forName("java.lang.Math")};
            clib = new Library(statlb, null);
            clib.markStateDependent("random", null);
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
        }
        t.startTest("Enter \"(2.0, 2,*)\" ");
        try {
            op = new Optimizer(clib);
            op.load(2.0);
            op.binaryOP_param();
            op.load(2L);
            op.binaryOP(2);
            op.finish();
            Debug.println("");
            Debug.println(op.toString());
            ce = op.compile();
            res = (Number)ce.evaluate(null);
            Debug.println("And the result is " + res.toString());
            if (res.intValue() == 4) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Enter \"5+(2.0*2)*exp(0)\" ");
        Debug.println("");
        try {
            op = new Optimizer(clib);
            op.load(5L);
            op.binaryOP_param();
            op.load(2.0);
            op.binaryOP_param();
            op.load(2L);
            op.binaryOP(2);
            op.binaryOP_param();
            op.function_start();
            op.load(0);
            op.function_param();
            op.function_call("exp");
            op.binaryOP(2);
            op.binaryOP(0);
            op.finish();
            Debug.println(op.toString());
            ce = op.compile();
            res = (Number)ce.evaluate(null);
            Debug.println("And the result is " + res.toString());
            if (res.intValue() == 9) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
    }
}

