


User Commands                                            CLISP(1)



NNNNAAAAMMMMEEEE
     clisp - Common Lisp language interpreter and compiler

SSSSYYYYNNNNOOOOPPPPSSSSIIIISSSS
     cccclllliiiisssspppp [ -hhhh | --hhhheeeellllpppp ] [ --vvvveeeerrrrssssiiiioooonnnn  ]  [  --lllliiiicccceeeennnnsssseeee  ]  [  -BBBB
     _l_i_s_p_l_i_b_d_i_r  ] [ -KKKK _l_i_n_k_i_n_g-_s_e_t ] [ -MMMM _m_e_m_f_i_l_e ] [ -mmmm _m_e_m_s_i_z_e
     ] [ -LLLL _l_a_n_g_u_a_g_e ] [ -NNNN _l_o_c_a_l_e_d_i_r ] [ -EEEE_d_o_m_a_i_n _e_n_c_o_d_i_n_g  ]  [
     -qqqq  | --qqqquuuuiiiieeeetttt | --ssssiiiilllleeeennnntttt ] [ -wwww ] [ -IIII ] [ -aaaannnnssssiiii ] [ -ttttrrrraaaaddddiiii----
     ttttiiiioooonnnnaaaallll ] [ -pppp _p_a_c_k_a_g_e_n_a_m_e ] [ -CCCC ] [ -nnnnoooorrrrcccc ] [  -iiii  _i_n_i_t_f_i_l_e
     ...   ]  [  -cccc [ -llll ] _l_i_s_p_f_i_l_e [ -oooo _o_u_t_p_u_t_f_i_l_e ] ...  ] [ -xxxx
     _e_x_p_r_e_s_s_i_o_n ] [ _l_i_s_p_f_i_l_e [ _a_r_g_u_m_e_n_t ] ]

DDDDEEEESSSSCCCCRRRRIIIIPPPPTTTTIIIIOOOONNNN
     Invokes the common lisp interpreter and  compiler.   Invoked
     without arguments, executes a read-eval-print loop, in which
     expressions are in turn read from standard input,  evaluated
     by  the  lisp interpreter, and their results output to stan-
     dard output.  Invoked with -cccc, the specified lisp files  are
     compiled  to  a  bytecode  that  can  be executed more effi-
     ciently.

OOOOPPPPTTTTIIIIOOOONNNNSSSS
     -hhhh, --hhhheeeellllpppp
          Displays a help message on how to use cccclllliiiisssspppp.

     --vvvveeeerrrrssssiiiioooonnnn
          Displays the cccclllliiiisssspppp version  number,  as  given  by  the
          function call (_l_i_s_p-_i_m_p_l_e_m_e_n_t_a_t_i_o_n-_v_e_r_s_i_o_n).

     --lllliiiicccceeeennnnsssseeee
          Displays a summary of the  licensing  information,  the
          GNU GPL.

     -BBBB _l_i_s_p_l_i_b_d_i_r
          Specifies  the  installation  directory.  This  is  the
          directory  containing  the  linking sets and other data
          files.  This option is normally not necessary,  because
          the  installation  directory is already built-in in the
          cccclllliiiisssspppp executable.  Directory lisplibdir can be  changed
          at run-time using the symbol-macro ****lllliiiibbbb----ddddiiiirrrreeeeccccttttoooorrrryyyy****....

     -KKKK _l_i_n_k_i_n_g-_s_e_t
          Specifies the linking set to be run. This is  a  direc-
          tory  containing at least a main executable and an ini-
          tial memory image. Possible values are bbbbaaaasssseeee, ffffuuuullllllll.  The
          default is bbbbaaaasssseeee.

     -MMMM _m_e_m_f_i_l_e
          Specifies the initial memory image.   This  must  be  a
          memory  dump  produced by the _s_a_v_e_i_n_i_t_m_e_m function.  It
          may have been compressed using GNU gzip.




SunOS 5.8           Last change: 31 May 2001                    1






User Commands                                            CLISP(1)



     -mmmm _m_e_m_s_i_z_e
          Sets the amount  of  memory  cccclllliiiisssspppp  tries  to  grab  on
          startup.   The amount may be given as _n_n_n_n_n_n_n (measured
          in bytes), _n_n_n_nKKKK or _n_n_n_nKKKKBBBB (measured in  kilobytes)  or
          _nMMMM  or _nMMMMBBBB (measured in megabytes).  Default is 2 mega-
          bytes.  The argument is constrained above 100  KB.   --
          This version of cccclllliiiisssspppp is not likely to actually use the
          entire _m_e_m_s_i_z_e since garbage collection  will  periodi-
          cally  reduce  the amount of used memory.  It is there-
          fore common to specify 10 MB even  if  only  2  MB  are
          going to be used.

     -LLLL _l_a_n_g_u_a_g_e
          Specifies the language cccclllliiiisssspppp uses to  communicate  with
          the user. This may be eeeennnngggglllliiiisssshhhh, ddddeeeeuuuuttttsssscccchhhh, ffffrrrraaaannnnccccaaaaiiiissss, Other
          languages may  be  specified  through  the  environment
          variable LLLLAAAANNNNGGGG, provided the corresponding message cata-
          log is installed.  The language may be changed at  run-
          time using the symbol macro ****ccccuuuurrrrrrrreeeennnntttt----llllaaaannnngggguuuuaaaaggggeeee****....

     -NNNN _l_o_c_a_l_e_d_i_r
          Specifies the base directory of  locale  files.   cccclllliiiisssspppp
          will     search     its     message     catalogs     in
          _l_o_c_a_l_e_d_i_r/_l_a_n_g_u_a_g_e/LC_MESSAGES/clisp.mo.  The localedir
          may  be  changed  at  run-time  using  the symbol macro
          ****ccccuuuurrrrrrrreeeennnntttt----llllaaaannnngggguuuuaaaaggggeeee****....

     -EEEE_d_o_m_a_i_n _e_n_c_o_d_i_n_g
          Specifies the encoding used for a given  domain,  over-
          riding  the  default  which  depends on the environment
          variables LLLLCCCC____AAAALLLLLLLL, LLLLCCCC____CCCCTTTTYYYYPPPPEEEE, LLLLAAAANNNNGGGG.  _d_o_m_a_i_n can be  ffffiiiilllleeee,
          affecting ****ddddeeeeffffaaaauuuulllltttt----ffffiiiilllleeee----eeeennnnccccooooddddiiiinnnngggg****, or ppppaaaatttthhhhnnnnaaaammmmeeee, affect-
          ing   ****ppppaaaatttthhhhnnnnaaaammmmeeee----eeeennnnccccooooddddiiiinnnngggg****,   or   tttteeeerrrrmmmmiiiinnnnaaaallll,   affecting
          ****tttteeeerrrrmmmmiiiinnnnaaaallll----eeeennnnccccooooddddiiiinnnngggg****,  or  ffffoooorrrreeeeiiiiggggnnnn,  affecting ****ffffoooorrrreeeeiiiiggggnnnn----
          eeeennnnccccooooddddiiiinnnngggg****, or mmmmiiiisssscccc, affecting ****mmmmiiiisssscccc----eeeennnnccccooooddddiiiinnnngggg****.

     -qqqq, --qqqquuuuiiiieeeetttt, --ssssiiiilllleeeennnntttt
          Quiet:  cccclllliiiisssspppp displays no  banner  at  startup  and  no
          good-bye message when quitting.

     -wwww   Wait for keypress after program termination.

     -IIII   Be ILISP friendly. ILISP is an alternative Emacs inter-
          face  to  Common  Lisp systems. With this option, cccclllliiiisssspppp
          interacts in a way that ILISP can deal with.  Currently
          the only effect of this is that unnecessary prompts are
          not suppressed.  Furthermore, the GNU readline  library
          treats Tab as a normal self-inserting character.

     -aaaannnnssssiiii
          ANSI CL compliant: comply with the ANSI  CL  specifica-
          tion even where CLISP has been traditionally different.



SunOS 5.8           Last change: 31 May 2001                    2






User Commands                                            CLISP(1)



          It  sets  the  symbol   macro   *_a_n_s_i*   to   tttt.    See
          impnotes.html,  section  "Maximum  ANSI CL compliance",
          for details.

     -ttttrrrraaaaddddiiiittttiiiioooonnnnaaaallll
          Traditional: reverses the residual effects of -aaaannnnssssiiii  in
          the saved image.

     -pppp _p_a_c_k_a_g_e_n_a_m_e
          At startup the value of the variable *_p_a_c_k_a_g_e* will  be
          set  to  the package named _p_a_c_k_a_g_e_n_a_m_e.  The default is
          the package which was active when the image was  saved,
          normally UUUUSSSSEEEERRRR, or CCCCOOOOMMMMMMMMOOOONNNN----LLLLIIIISSSSPPPP----UUUUSSSSEEEERRRR if the option -aaaa was
          specified.

     -CCCC   Compile when load: At startup the value of the variable
          *_l_o_a_d-_c_o_m_p_i_l_i_n_g*  will  be set to tttt.  Code being _l_o_a_ded
          will then be compiled  on  the  fly.  This  results  in
          slower loading, but faster execution.

     -nnnnoooorrrrcccc
          Normally cccclllliiiisssspppp loads a user run control  (RC)  file  on
          startup  (this  happens  after  the  -CCCC  option is pro-
          cessed).  The file loaded is  $$$${{{{HHHHOOOOMMMMEEEE}}}}////....cccclllliiiisssspppprrrrcccc....lllliiiisssspppp  or
          $$$${{{{HHHHOOOOMMMMEEEE}}}}////....cccclllliiiisssspppprrrrcccc....ffffaaaassss, whichever is newest. This option,
          -nnnnoooorrrrcccc,,,, prevents loading of the RC file.

     -iiii _i_n_i_t_f_i_l_e ...
          Specifies initialization files to be _l_o_a_ded at startup.
          These  should  be  lisp  files  (source  or  compiled).
          Several -iiii options can  be  given;  all  the  specified
          files will be loaded in order.

     -cccc _l_i_s_p_f_i_l_e ...
          Compiles the specified _l_i_s_p_f_i_l_es to  bytecode  (*.fas).
          The  compiled  files  can then be _l_o_a_ded instead of the
          sources to gain efficiency.

     -oooo _o_u_t_p_u_t_f_i_l_e
          Specifies the output file or directory for the compila-
          tion of the last specified _l_i_s_p_f_i_l_e.

     -llll   A bytecode listing (*.lis) of the files being  compiled
          will  be produced.  Useful only for debugging purposes.
          See the documentation of _c_o_m_p_i_l_e-_f_i_l_e for details.

     -xxxx _e_x_p_r_e_s_s_i_o_n_s
          Executes a series of arbitrary expressions instead of a
          read-eval-print  loop.   The  values of the expressions
          will be output to standard output.  Due to the argument
          processing  done  by the shell, the _e_x_p_r_e_s_s_i_o_n_s must be
          enclosed  in  double  quotes,  and  double  quotes  and



SunOS 5.8           Last change: 31 May 2001                    3






User Commands                                            CLISP(1)



          backslashes must be preceded by backslashes.

     _l_i_s_p_f_i_l_e [_a_r_g_u_m_e_n_t ...]
          Loads and executes a _l_i_s_p_f_i_l_e.  There will be no  read-
          eval-print  loop.  Before _l_i_s_p_f_i_l_e is loaded, the vari-
          able *_a_r_g_s*  will  be  bound  to  a  list  of  strings,
          representing the _a_r_g_u_m_e_n_ts.  The first line of _l_i_s_p_f_i_l_e
          may start with ####!!!!, thus permitting cccclllliiiisssspppp to be used  as
          a  script  interpreter.  If _l_i_s_p_f_i_l_e is -, the standard
          input is used instead of a file.   If  _l_i_s_p_f_i_l_e  is  an
          empty  string tttthhhheeee rrrreeeesssstttt ooooffff tttthhhheeee aaaarrrrgggguuuummmmeeeennnnttttssss iiiissss ssssttttiiiillllllll aaaavvvvaaaaiiiillll----
          aaaabbbblllleeee iiiinnnn *_a_r_g_s* , for parsing by  the  iiiinnnniiiitttt----ffffuuuunnnnccccttttiiiioooonnnn  of
          the  current  image.  This option must be the last one.
          No RC file will be executed.

RRRREEEEFFFFEEEERRRREEEENNNNCCCCEEEE
     The language implemented mostly conforms to
            ANSI Common Lisp standard X3.226-1994
            http://www.x3.org/tc_home/j13sd4.htm
     available online as the
            Common Lisp HyperSpec
            http://www.lisp.org/HyperSpec/
            ("CLHS" for short)
     which supersedes the earlier specifications
            Guy L. Steele Jr.: Common Lisp - The Language.
            Digital Press. 2nd edition 1990, 1032 pages.
            http://www.cs.cmu.edu/afs/cs.cmu.edu/project/ai-
      repository/ai/html/cltl/cltl2.html
            ("CLtL2" for short)
     and
            Guy L. Steele Jr.: Common Lisp - The Language.
            Digital Press. 1st edition 1984, 465 pages.
            ("CLtL1" for short)

UUUUSSSSEEEE
     hhhheeeellllpppp to get some on-line help.

     ((((aaaapppprrrrooooppppoooossss _n_a_m_e))))
          lists the symbols relating to _n_a_m_e.

     ((((eeeexxxxiiiitttt)))) or ((((qqqquuuuiiiitttt)))) or ((((bbbbyyyyeeee))))
          to quit cccclllliiiisssspppp.

     EOF (Ctrl-D)
          to leave the current read-eval-print loop.

     arrow keys
          for editing and viewing the input history.

     Tab key
          to complete the symbol's name you are just typing.




SunOS 5.8           Last change: 31 May 2001                    4






User Commands                                            CLISP(1)



FFFFIIIILLLLEEEESSSS
     _c_l_i_s_p
          startup script

     _l_i_s_p._r_u_n
          main executable

     _l_i_s_p_i_n_i_t._m_e_m
          initial memory image

     _c_o_n_f_i_g._l_i_s_p
          site-dependent configuration

     *._l_i_s_p
          lisp source

     *._f_a_s
          lisp code, compiled by cccclllliiiisssspppp

     *._l_i_b
          lisp source library information, generated and used  by
          the cccclllliiiisssspppp compiler

     *._c  C code, compiled from lisp source by cccclllliiiisssspppp

EEEENNNNVVVVIIIIRRRROOOONNNNMMMMEEEENNNNTTTT
     CCCCLLLLIIIISSSSPPPP____LLLLAAAANNNNGGGGUUUUAAAAGGGGEEEE
          specifies the language cccclllliiiisssspppp uses to  communicate  with
          the  user.  The value may be eeeennnngggglllliiiisssshhhh, ddddeeeeuuuuttttsssscccchhhh, ffffrrrraaaannnnccccaaaaiiiissss
          and defaults to eeeennnngggglllliiiisssshhhh.  The -LLLL option can be used  to
          override this environment variable.

     LLLLCCCC____CCCCTTTTYYYYPPPPEEEE
          specifies the locale which determines the character set
          in  use.   The  value  can  be  of the form _l_a_n_g_u_a_g_e or
          _l_a_n_g_u_a_g_e__c_o_u_n_t_r_y  or  _l_a_n_g_u_a_g_e__c_o_u_n_t_r_y._c_h_a_r_s_e_t,   where
          _l_a_n_g_u_a_g_e  is  a two-letter ISO 639 language code (lower
          case), and _c_o_u_n_t_r_y is a  two-letter  ISO  3166  country
          code  (upper  case).   _c_h_a_r_s_e_t is an optional character
          set specification, and  needs  normally  not  be  given
          because  the  character  set  can  be inferred from the
          language and country.

     LLLLAAAANNNNGGGG specifies the language cccclllliiiisssspppp uses to  communicate  with
          the  user,  unless  it is already specified through the
          environment variable CCCCLLLLIIIISSSSPPPP____LLLLAAAANNNNGGGGUUUUAAAAGGGGEEEE or the  -LLLL  option.
          It  also specifies the locale determining the character
          set  in  use,  unless  already  specified  through  the
          environment  variable  LLLLCCCC____CCCCTTTTYYYYPPPPEEEE.   The  value may begin
          with a two-letter ISO 639 language  code,  for  example
          eeeennnn, ddddeeee, ffffrrrr.




SunOS 5.8           Last change: 31 May 2001                    5






User Commands                                            CLISP(1)



     HHHHOOOOMMMMEEEE and UUUUSSSSEEEERRRR
          are used for determining  the  value  of  the  function
          _u_s_e_r-_h_o_m_e_d_i_r-_p_a_t_h_n_a_m_e.  (Unix implementation only.)

     SSSSHHHHEEEELLLLLLLL (Unix implementation only)
          is used to find  the  interactive  command  interpreter
          called by (_s_h_e_l_l).

     TTTTEEEERRRRMMMM determines the screen size  recognized  by  the  pretty
          printer.

SSSSEEEEEEEE AAAALLLLSSSSOOOO
     impnotes.html, _c_m_u_c_l(1), _e_m_a_c_s(1), _x_e_m_a_c_s(1).

BBBBUUUUGGGGSSSS
     Not all extensions from CLtL2 are supported.

     No on-line documentation  beyond  _a_p_r_o_p_o_s  and  _d_e_s_c_r_i_b_e  is
     available.

PPPPRRRROOOOJJJJEEEECCCCTTTTSSSS
     Writing on-line documentation.

     Enhance the compiler so that it can inline local functions.

     Specify a portable set of window and graphics operations.

AAAAUUUUTTTTHHHHOOOORRRRSSSS
     Bruno Haible and Michael Stoll.


























SunOS 5.8           Last change: 31 May 2001                    6



