/* translation of file "petrinet-patterns-structured.k" */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.10 (C) 1998-2007 Humboldt-University of Berlin $
 */
#define KC_FUNCTIONS_petrinet_patterns_structured

#include <stdlib.h>
#include "ast-system-k.h"
#include "petrinet-patterns-structured.h"
namespace kc { }
using namespace kc;
/* included stuff */
#line 22 "petrinet-patterns-structured.k"
/*!
 * \file    petrinet-patterns-structured.cc
 *
 * \brief   Petri net patterns for BPEL's structured activities
 *
 * \author  Niels Lohmann <nlohmann@informatik.hu-berlin.de>,
 *          last changes of: \$Author: nielslohmann $
 * 
 * \since   2006-11-26
 *
 * \date    \$Date: 2007/05/10 12:37:57 $
 * 
 * \note    This file is part of the tool BPEL2oWFN and was created during the
 *          project "Tools4BPEL" at the Humboldt-Universitt zu Berlin. See
 *          http://www.informatik.hu-berlin.de/top/tools4bpel for details.
 *
 * \note    This file was created using Kimwitu++ reading file petrinet-patterns-structured.k.
 *          See http://site.informatik.hu-berlin.de/kimwitu++ for details.
 *
 * \version \$Revision: 1.58 $
*/

#line  37 "petrinet-patterns-structured.cc"
#line 56 "petrinet-patterns-structured.k"
#include "ast-config.h"
#include "helpers.h"
#include "ast-tools.h"
#include "ast-details.h"
#include "globals.h"
#include "petrinet-patterns-shortcuts.h"

using std::cerr;
using std::endl;

extern PetriNet PN;

#line  51 "petrinet-patterns-structured.cc"
#line 78 "petrinet-patterns-structured.k"
/*!
 * \fn void kc::PWhile(impl_tWhile* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <while> activity.
 *
 *          \image html "while.png" "pattern"
 *
 * \ingroup patterns
 */

#line  63 "petrinet-patterns-structured.cc"
#line 276 "petrinet-patterns-structured.k"
/*!
 * \fn void kc::PRepeatUntil(impl_tRepeatUntil* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <repeatUntil> activity.
 * 
 *          \image html "repeatuntil.png" "pattern"
 *
 * \ingroup patterns
 */

#line  75 "petrinet-patterns-structured.cc"
#line 530 "petrinet-patterns-structured.k"
/*!
 * \fn      void kc::PSequence(impl_tSequence* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <sequence> activity.
 * 
 *          \image html "sequence.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 */

#line  90 "petrinet-patterns-structured.cc"
#line 603 "petrinet-patterns-structured.k"
/*!
 * \fn void kc::PFlow(impl_tFlow* abstract_phylum, uview current_view)
 * \brief Pattern for the <flow> activity.
 * \image html "flow.png" "pattern"
 *
 * \ingroup patterns
 */

#line  100 "petrinet-patterns-structured.cc"
#line 710 "petrinet-patterns-structured.k"
/*!
 * \fn      void kc::PPick(impl_tPick* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <pick> activity.
 *
 *          \image html "pick.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \ingroup patterns
 * 
 * \todo    Use "receivingTransition" function in <onMessage> branches.
 */

#line  117 "petrinet-patterns-structured.cc"
#line 854 "petrinet-patterns-structured.k"
/*!
 * \fn      void kc::PIf(impl_tIf* abstract_phylum, uview current_view)
 *
 * \brief   Pattern for the <if> and <switch> activity.
 *
 *          \image html "if.png" "pattern"
 *
 * \param   abstract_phylum  pointer to the phylum of the abstract syntax tree
 * \param   current_view     the current unparse view
 *
 * \note    The branches are not checked sequentially, but in parallel. This
 *          would make a difference in colored Petri nets, but as we are
 *          modeling data-driven decisions by nondeterminism, the <if> can be
 *          modeled by a single conflicting place.
 *
 * \note    The <switch> activity of BPEL4WS 1.1 is modeled with the same
 *          pattern as the <if> activity as the two activity have similar
 *          semantics. The only difference is that an absent <otherwise> branch
 *          in the <switch> activity has to be filled with an <empty> activity
 *          rather than with a shortcut transition as an absent <else> branch.
 *          This implicit <empty> activity is added by the parser.
 *
 * \ingroup patterns
 */

#line  144 "petrinet-patterns-structured.cc"
/* end included stuff */


namespace kc {

#ifndef KC_TRACE_PROVIDED
#define KC_TRACE_PROVIDED(COND,FILE,LINE,NODE) COND
#endif

void PWhile(impl_tWhile *abstract_phylum, uview current_view)
#line 89 "petrinet-patterns-structured.k"
{
    impl_tWhile_While* phylum = static_cast<impl_tWhile_While*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";

    assert(globals::ASTEmap[phylum->id] != NULL);
    ASTE *myself = globals::ASTEmap[phylum->id];

    switch(current_view)
    {
	case(petrinetnew_enum):
	{
	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "running");
	    Place *p3 = PN.newPlace(prefix + "p3");
	    Place *p4 = PN.newPlace(prefix + "final");
	    Place *p5 = PN.newPlace(prefix + "stop");
	    Place *p6 = PN.newPlace(prefix + "stopped");
	    Place *p7 = PN.newPlace(prefix + "p7");	

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		Place *p5l = PN.newPlace(prefix + "stop_loop");
		Place *p5a = PN.newPlace(prefix + "stop_activity");
		Place *p6l = PN.newPlace(prefix + "stopped_loop");
		Place *p6a = PN.newPlace(prefix + "stopped_activity");

		Transition *stop_split = PN.newTransition(prefix + "stop_split");
		PN.newArc(p5, stop_split);
		PN.newArc(stop_split, p5l);
		PN.newArc(stop_split, p5a);

		Transition *stopped_merge = PN.newTransition(prefix + "stopped_merge");
		PN.newArc(p6l, stopped_merge);
		PN.newArc(p6a, stopped_merge);
		PN.newArc(stopped_merge, p6);
	    }


	    Place *control_enter = NULL;
	    Place *control_leave = NULL;
	    if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
	    {
		control_enter = PN.newPlace("in.enterloop." + toString(phylum->id), IN);
		control_leave = PN.newPlace("in.leaveloop." + toString(phylum->id), IN);
	    }

	    Transition *t1 = PN.newTransition(prefix + "read_condition");
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p2);

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		looppattern(myself->attributes["condition"], myself->max_loops, prefix, phylum->id,
		    p2, p3, p4);
	    }
	    else
	    {

		if (!globals::parameters[P_LOOPCOUNT])
		{
		    Transition *t2 = PN.newTransition(prefix + "start");
		    PN.newArc(p2, t2);
		    PN.newArc(t2, p3);
		    if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
		    {
			PN.newArc(control_enter, t2);
		    }

		    if (myself->attributes["condition"] != "true")
		    {
			Transition *t3 = PN.newTransition(prefix + "end");
			PN.newArc(p2, t3);
			PN.newArc(t3, p4);
			if (globals::parameters[P_LOOPCONTROL])
			{
			    PN.newArc(control_leave, t3);
			}
		    }
		}
	    }


	    if (globals::parameters[P_STANDARDFAULTS])
	    Transition *t5 = throwFault(p2, p7, "running", prefix, mkinteger(phylum->id), globals::ASTEmap[phylum->id]->controlFlow);

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		Transition *t6 = stop_activity(p2, "running", prefix);
		Transition *t7 = stop_activity(p4, "final", prefix);
		Transition *t8 = stop_activity(p7, "p7", prefix);
	    }
	    else
	    {
		Transition *t6 = stop(p2, "running", prefix);
		Transition *t7 = stop(p4, "final", prefix);
		Transition *t8 = stop(p7, "p7", prefix);  
	    }


	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


	    phylum->activity_1->unparse(pseudoPrinter, current_view);



	    PN.mergePlaces(phylum->id, ".internal.p3",      phylum->activity_1->id, ".initial");
	    PN.mergePlaces(phylum->id, ".internal.initial", phylum->activity_1->id, ".final");
	    PN.mergePlaces(phylum->id, ".internal.stop",    phylum->activity_1->id, ".stop");
	    PN.mergePlaces(phylum->id, ".internal.stopped", phylum->activity_1->id, ".stopped");

	    break;
	}

	case(petrinetsmall_enum):
	{
	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "running");
	    Place *p3 = PN.newPlace(prefix + "final");



	    Place *control_enter = NULL;
	    Place *control_leave = NULL;
	    if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
	    {
		control_enter = PN.newPlace("in.enterloop." + toString(phylum->id), IN);
		control_leave = PN.newPlace("in.leaveloop." + toString(phylum->id), IN);
	    }

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		looppattern(myself->attributes["condition"], myself->max_loops, prefix, phylum->id,
		    p1, p2, p3);
	    }
	    else
	    {
		if(myself->attributes["condition"] != "true")
		{
		    Transition *t1 = PN.newTransition(prefix + "leave");
		    PN.newArc(p1, t1);
		    PN.newArc(t1, p3);
		    if (globals::parameters[P_LOOPCONTROL])
		    PN.newArc(control_leave, t1);
		}

		Transition *t2 = PN.newTransition(prefix + "loop");
		PN.newArc(p1, t2);
		PN.newArc(t2, p2);
		if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
		PN.newArc(control_enter, t2);
	    }



	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


	    phylum->activity_1->unparse(pseudoPrinter, current_view);



	    PN.mergePlaces(phylum->id, ".internal.running", phylum->activity_1->id, ".initial");
	    PN.mergePlaces(phylum->id, ".internal.initial", phylum->activity_1->id, ".final");	

	    break;
	}

	default: {  }
    }


    footer(phylum->id, true);

#line 265 "petrinet-patterns-structured.k"
}
#line  335 "petrinet-patterns-structured.cc"

void PRepeatUntil(impl_tRepeatUntil *abstract_phylum, uview current_view)
#line 287 "petrinet-patterns-structured.k"
{
    impl_tRepeatUntil_RepeatUntil* phylum = static_cast<impl_tRepeatUntil_RepeatUntil*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";

    assert(globals::ASTEmap[phylum->id] != NULL);
    ASTE *myself = globals::ASTEmap[phylum->id];

    switch (current_view)
    {
	case(petrinetnew_enum):
	{

	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "p2"); 
	    Place *p3 = PN.newPlace(prefix + "running");
	    Place *p4 = PN.newPlace(prefix + "final");
	    Place *p5 = PN.newPlace(prefix + "stop");
	    Place *p6 = PN.newPlace(prefix + "stopped");
	    Place *p7 = PN.newPlace(prefix + "faulted");


	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		Place *p5l = PN.newPlace(prefix + "stop_loop");
		Place *p5a = PN.newPlace(prefix + "stop_activity");
		Place *p6l = PN.newPlace(prefix + "stopped_loop");
		Place *p6a = PN.newPlace(prefix + "stopped_activity");

		Transition *stop_split = PN.newTransition(prefix + "stop_split");
		PN.newArc(p5, stop_split);
		PN.newArc(stop_split, p5l);
		PN.newArc(stop_split, p5a);

		Transition *stopped_merge = PN.newTransition(prefix + "stopped_merge");
		PN.newArc(p6l, stopped_merge);
		PN.newArc(p6a, stopped_merge);
		PN.newArc(stopped_merge, p6);
	    }


	    Place *control_enter = NULL;
	    Place *control_leave = NULL;
	    if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
	    {
		control_enter = PN.newPlace("in.enterloop." + toString(phylum->id), IN);
		control_leave = PN.newPlace("in.leaveloop." + toString(phylum->id), IN);
	    }

	    Transition *t1 = PN.newTransition(prefix + "read_condition");
	    PN.newArc(p2, t1);
	    PN.newArc(t1, p3);

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		looppattern(myself->attributes["condition"], (myself->max_loops-1), prefix, phylum->id,
		    p3, p1, p4);
	    }
	    else
	    {
		if(myself->attributes["condition"] != "true")
		{
		    Transition *t2 = PN.newTransition(prefix + "leave");
		    PN.newArc(p3, t2);
		    PN.newArc(t2, p4);
		    if( globals::parameters[P_LOOPCONTROL])
		    PN.newArc(control_leave, t2);
		}

		Transition *t3 = PN.newTransition(prefix + "loop");
		PN.newArc(p3, t3);
		PN.newArc(t3, p1);
		if( globals::parameters[P_LOOPCONTROL])
		PN.newArc(control_enter, t3);	
	    }

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		Transition *t4 = stop_activity(p3, "running", prefix);
		Transition *t5 = stop_activity(p4, "final", prefix);
		Transition *t6 = stop_activity(p7, "faulted", prefix);
	    }
	    else
	    {
		Transition *t4 = stop(p3, "running", prefix);
		Transition *t5 = stop(p4, "final", prefix);
		Transition *t6 = stop(p7, "faulted", prefix);
	    }

	    if (globals::parameters[P_STANDARDFAULTS])
	    Transition *t7 = throwFault(p3, p7, "running", prefix, mkinteger(phylum->id), globals::ASTEmap[phylum->id]->controlFlow);




































































	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


	    phylum->activity_1->unparse(pseudoPrinter, current_view);


	    PN.mergePlaces(phylum->id, ".internal.initial", phylum->activity_1->id, ".initial");
	    PN.mergePlaces(phylum->id, ".internal.p2",      phylum->activity_1->id, ".final");
	    PN.mergePlaces(phylum->id, ".internal.stop",    phylum->activity_1->id, ".stop");
	    PN.mergePlaces(phylum->id, ".internal.stopped", phylum->activity_1->id, ".stopped");

	    break;
	}

	case(petrinetsmall_enum):
	{
	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "p2");
	    Place *p3 = PN.newPlace(prefix + "final");



	    Place *control_enter = NULL;
	    Place *control_leave = NULL;
	    if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
	    {
		control_enter = PN.newPlace("in.enterloop." + toString(phylum->id), IN);
		control_leave = PN.newPlace("in.leaveloop." + toString(phylum->id), IN);
	    }

	    if((myself->max_loops != 0) && (myself->max_loops != UINT_MAX))
	    {
		looppattern(myself->attributes["condition"], (myself->max_loops-1), prefix, phylum->id,
		    p2, p1, p3);
	    }
	    else
	    {
		if(myself->attributes["condition"] != "true")
		{
		    Transition *t1 = PN.newTransition(prefix + "leave");
		    PN.newArc(p2, t1);
		    PN.newArc(t1, p3);
		    if (globals::parameters[P_LOOPCONTROL])
		    PN.newArc(control_leave, t1);
		}

		Transition *t2 = PN.newTransition(prefix + "loop");
		PN.newArc(p2, t2);
		PN.newArc(t2, p1);
		if (globals::parameters[P_LOOPCONTROL] && myself->attributes["condition"] != "true")
		PN.newArc(control_enter, t2);
	    }



	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


	    phylum->activity_1->unparse(pseudoPrinter, current_view);


	    PN.mergePlaces(phylum->id, ".internal.initial", phylum->activity_1->id, ".initial");
	    PN.mergePlaces(phylum->id, ".internal.p2", phylum->activity_1->id, ".final");

	    break;
	}

	default: {  }
    }

    footer(phylum->id, true);

#line 519 "petrinet-patterns-structured.k"
}
#line  574 "petrinet-patterns-structured.cc"

void PSequence(impl_tSequence *abstract_phylum, uview current_view)
#line 544 "petrinet-patterns-structured.k"
{
    impl_tSequence_Sequence* phylum = static_cast<impl_tSequence_Sequence*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";


    Place *p1  = PN.newPlace(prefix + "initial");
    Place *p2  = PN.newPlace(prefix + "final");


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


    phylum->activity_list_1->unparse(pseudoPrinter, current_view);


    int activityCount = 1;
    impl_activity* lastActivity;
    {
#line 571 "petrinet-patterns-structured.k"
	activity_list kc_fe_selvar_1 =  phylum->activity_list_1;

#line  609 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
	    ) {
	    activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
	    {
#line 571 "petrinet-patterns-structured.k"
		{
		    {
#line 572 "petrinet-patterns-structured.k"
#line 571 "petrinet-patterns-structured.k"
			const activity innerActivity = kc_selvar_0_1;
#line 572 "petrinet-patterns-structured.k"

			if (activityCount == 1)
			PN.mergePlaces(phylum->id, ".internal.initial", innerActivity->id, ".initial");
			else
			PN.mergePlaces(lastActivity->id, ".final", innerActivity->id, ".initial");

			if (activityCount == phylum->activity_list_1->length())
			PN.mergePlaces(phylum->id, ".internal.final", innerActivity->id, ".final");

			if (current_view != petrinetsmall_enum)
			{
			    PN.mergePlaces(phylum->id, ".internal.stop", innerActivity->id, ".stop");
			    PN.mergePlaces(phylum->id, ".internal.stopped", innerActivity->id, ".stopped");
			}

			lastActivity = innerActivity;
			activityCount++;

#line  640 "petrinet-patterns-structured.cc"
		    }
		}

#line  644 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 571 "petrinet-patterns-structured.k"

#line  649 "petrinet-patterns-structured.cc"
	}
    }
#line 590 "petrinet-patterns-structured.k"

    footer(phylum->id, true);

#line 592 "petrinet-patterns-structured.k"
}
#line  658 "petrinet-patterns-structured.cc"

void PFlow(impl_tFlow *abstract_phylum, uview current_view)
#line 612 "petrinet-patterns-structured.k"
{
    impl_tFlow_Flow* phylum = static_cast<impl_tFlow_Flow*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";


    switch(current_view)
    {
	case(petrinetnew_enum):
	{
	    Place *p1 = PN.newPlace(prefix + "initial");
	    Place *p2 = PN.newPlace(prefix + "final");
	    Place *p3 = PN.newPlace(prefix + "stop");
	    Place *p4 = PN.newPlace(prefix + "stopped");
	    Place *p5 = PN.newPlace(prefix + "running");

	    Transition *t1 = PN.newTransition(prefix + "split");
	    PN.newArc(p1, t1);
	    PN.newArc(t1, p5);

	    Transition *t2 = PN.newTransition(prefix + "join");
	    PN.newArc(p5, t2);
	    PN.newArc(t2, p2);

	    Transition *t3 = PN.newTransition(prefix + "stop_all");
	    PN.newArc(p3, t3);
	    PN.newArc(p5, t3);

	    Transition *t4 = PN.newTransition(prefix + "all_stopped");
	    PN.newArc(t4, p4);


	    Transition *t5 = stop(p1, "initial", prefix);
	    Transition *t6 = stop(p2, "final", prefix);


	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


	    phylum->activity_list_1->unparse(pseudoPrinter, current_view);


	    {
#line 656 "petrinet-patterns-structured.k"
		activity_list kc_fe_selvar_1 =  phylum->activity_list_1;

#line  710 "petrinet-patterns-structured.cc"
		while(
			kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
		    ) {
		    activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
		    {
#line 656 "petrinet-patterns-structured.k"
			{
			    {
#line 657 "petrinet-patterns-structured.k"
#line 656 "petrinet-patterns-structured.k"
				const activity innerActivity = kc_selvar_0_1;
#line 657 "petrinet-patterns-structured.k"

				PN.newArc(t1, PN.findPlace(innerActivity->id, ".initial"));
				PN.newArc(t3, PN.findPlace(innerActivity->id, ".stop"));
				PN.newArc(PN.findPlace(innerActivity->id, ".stopped"), t4);
				PN.newArc(PN.findPlace(innerActivity->id, ".final"), t2);

#line  729 "petrinet-patterns-structured.cc"
			    }
			}

#line  733 "petrinet-patterns-structured.cc"
		    }
		    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 656 "petrinet-patterns-structured.k"

#line  738 "petrinet-patterns-structured.cc"
		}
	    }
#line 663 "petrinet-patterns-structured.k"

	    break;
	}

	case(petrinetsmall_enum):
	{
	    Place *p1  = PN.newPlace(prefix + "initial");
	    Place *p2  = PN.newPlace(prefix + "final");

	    Transition *t1 = PN.newTransition(prefix + "split");
	    PN.newArc(p1, t1);

	    Transition *t2 = PN.newTransition(prefix + "join");
	    PN.newArc(t2, p2);


	    phylum->standardElements_1->unparse(pseudoPrinter, current_view);


	    phylum->activity_list_1->unparse(pseudoPrinter, current_view);

	    {
#line 684 "petrinet-patterns-structured.k"
		activity_list kc_fe_selvar_1 =  phylum->activity_list_1;

#line  767 "petrinet-patterns-structured.cc"
		while(
			kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
		    ) {
		    activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
		    {
#line 684 "petrinet-patterns-structured.k"
			{
			    {
#line 685 "petrinet-patterns-structured.k"
#line 684 "petrinet-patterns-structured.k"
				const activity innerActivity = kc_selvar_0_1;
#line 685 "petrinet-patterns-structured.k"

				PN.newArc(t1, PN.findPlace(innerActivity->id, ".initial"));
				PN.newArc(PN.findPlace(innerActivity->id, ".final"), t2);

#line  784 "petrinet-patterns-structured.cc"
			    }
			}

#line  788 "petrinet-patterns-structured.cc"
		    }
		    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 684 "petrinet-patterns-structured.k"

#line  793 "petrinet-patterns-structured.cc"
		}
	    }
#line 689 "petrinet-patterns-structured.k"

	    break;
	}

	default: {  }
    }


    footer(phylum->id, true);


#line 699 "petrinet-patterns-structured.k"
}
#line  810 "petrinet-patterns-structured.cc"

void PPick(impl_tPick *abstract_phylum, uview current_view)
#line 726 "petrinet-patterns-structured.k"
{
    impl_tPick_Pick* phylum = static_cast<impl_tPick_Pick*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";



    Place *p1 = PN.newPlace(prefix + "initial");
    Place *p2 = PN.newPlace(prefix + "final");


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 = PN.newPlace(prefix + "stop");
	Place *p4 = PN.newPlace(prefix + "stopped");

	Transition *t4 = stop(p1, "initial", prefix);
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);



    unsigned int branch_count = 1;
    {
#line 753 "petrinet-patterns-structured.k"
	tOnMessage_list kc_fe_selvar_1 =  phylum->tOnMessage_list_1;

#line  845 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
	    ) {
	    tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
	    {
#line 753 "petrinet-patterns-structured.k"
		{
#line 754 "petrinet-patterns-structured.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 754 "petrinet-patterns-structured.k"
#line 753 "petrinet-patterns-structured.k"
			const tOnMessage ThisBranch = kc_selvar_0_1;
#line 753 "petrinet-patterns-structured.k"
			const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 753 "petrinet-patterns-structured.k"
			const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 753 "petrinet-patterns-structured.k"
			const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 753 "petrinet-patterns-structured.k"
			const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 754 "petrinet-patterns-structured.k"

			header(_id2, true);
			string branch = toString(branch_count++);


			innerActivity->unparse(pseudoPrinter, current_view);


			string interface_place_name = (globals::ASTEmap[ThisBranch->id]->channel_instances != 0) ?
			"in." + globals::ASTEmap[ThisBranch->id]->channelName + ".instance_" + toString(globals::ASTEmap[ThisBranch->id]->channel_instances++) :
			"in." + globals::ASTEmap[ThisBranch->id]->channelName;


			Transition *t1 = PN.newTransition(prefix + "onMessage_" + branch);
			PN.newArc(PN.findPlace(prefix + "initial"), t1);
			PN.newArc(PN.findPlace(interface_place_name), t1);
			PN.newArc(t1, PN.findPlace(toString(innerActivity->id) + ".initial"));


			PN.mergePlaces(phylum->id, ".final", innerActivity->id, ".final");

			if (current_view != petrinetsmall_enum)
			{
			    PN.mergePlaces(phylum->id, ".stop",        innerActivity->id, ".stop");
			    PN.mergePlaces(phylum->id, ".stopped",     innerActivity->id, ".stopped");
			}

			footer(_id2, true);

#line  896 "petrinet-patterns-structured.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  901 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 753 "petrinet-patterns-structured.k"

#line  906 "petrinet-patterns-structured.cc"
	}
    }
#line 783 "petrinet-patterns-structured.k"



    {
#line 786 "petrinet-patterns-structured.k"
	tOnAlarm_list kc_fe_selvar_1 =  phylum->tOnAlarm_list_1;

#line  917 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
	    ) {
	    tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
	    {
#line 786 "petrinet-patterns-structured.k"
		{
#line 787 "petrinet-patterns-structured.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 787 "petrinet-patterns-structured.k"
#line 786 "petrinet-patterns-structured.k"
			const tOnAlarm onAlarmBranch = kc_selvar_0_1;
#line 786 "petrinet-patterns-structured.k"
			const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 786 "petrinet-patterns-structured.k"
			const integer _id2 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 787 "petrinet-patterns-structured.k"

			header(_id2, true);
			string branch = toString(branch_count++);


			innerActivity->unparse(pseudoPrinter, current_view);


			Transition *t3 = PN.newTransition(prefix + "onAlarm_" + branch);
			PN.newArc(PN.findPlace(prefix + "initial"), t3);
			PN.newArc(t3, PN.findPlace(toString(innerActivity->id) + ".initial"));


			PN.mergePlaces(phylum->id, ".final", innerActivity->id, ".final");

			if (current_view != petrinetsmall_enum)
			{
			    PN.mergePlaces(phylum->id, ".stop",        innerActivity->id, ".stop");
			    PN.mergePlaces(phylum->id, ".stopped",     innerActivity->id, ".stopped");
			}

			footer(_id2, true);

#line  958 "petrinet-patterns-structured.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  963 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 786 "petrinet-patterns-structured.k"

#line  968 "petrinet-patterns-structured.cc"
	}
    }
#line 810 "petrinet-patterns-structured.k"





    branch_count = 1;
    {
#line 816 "petrinet-patterns-structured.k"
	tOnMessage_list kc_fe_selvar_1 =  phylum->tOnMessage_list_1;

#line  982 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
	    ) {
	    tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
	    {
#line 816 "petrinet-patterns-structured.k"
		{
#line 816 "petrinet-patterns-structured.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 816 "petrinet-patterns-structured.k"
#line 816 "petrinet-patterns-structured.k"
			const tCorrelation_list corr_1 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 816 "petrinet-patterns-structured.k"
			const tFromPart_list from_1 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 816 "petrinet-patterns-structured.k"
			const activity innerActivity1 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 816 "petrinet-patterns-structured.k"
			const integer _id1 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 816 "petrinet-patterns-structured.k"

			{
#line 817 "petrinet-patterns-structured.k"
			    tOnMessage_list kc_fe_selvar_1 =  phylum->tOnMessage_list_1;

#line  1007 "petrinet-patterns-structured.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
				) {
				tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
				{
#line 817 "petrinet-patterns-structured.k"
				    {
#line 817 "petrinet-patterns-structured.k"
					if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 817 "petrinet-patterns-structured.k"
#line 817 "petrinet-patterns-structured.k"
					    const tCorrelation_list corr_2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->tCorrelation_list_1;
#line 817 "petrinet-patterns-structured.k"
					    const tFromPart_list from_2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->tFromPart_list_1;
#line 817 "petrinet-patterns-structured.k"
					    const activity innerActivity2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 817 "petrinet-patterns-structured.k"
					    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->integer_1;
#line 817 "petrinet-patterns-structured.k"

					    if ((innerActivity1 != innerActivity2))
					    dpeLinks(PN.findTransition(prefix + "onMessage_" + toString(branch_count)), innerActivity2->id, phylum->id); 

#line  1031 "petrinet-patterns-structured.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1036 "petrinet-patterns-structured.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 817 "petrinet-patterns-structured.k"

#line  1041 "petrinet-patterns-structured.cc"
			    }
			}
#line 821 "petrinet-patterns-structured.k"

			{
#line 822 "petrinet-patterns-structured.k"
			    tOnAlarm_list kc_fe_selvar_1 =  phylum->tOnAlarm_list_1;

#line  1050 "petrinet-patterns-structured.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
				) {
				tOnAlarm kc_selvar_1_1 = kc_fe_selvar_1->tOnAlarm_1;
				{
#line 822 "petrinet-patterns-structured.k"
				    {
#line 822 "petrinet-patterns-structured.k"
					if ((kc_selvar_1_1->prod_sel() == sel_OnAlarm)) {
#line 822 "petrinet-patterns-structured.k"
#line 822 "petrinet-patterns-structured.k"
					    const activity innerActivity2 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_1_1)->activity_1;
#line 822 "petrinet-patterns-structured.k"

					    dpeLinks(PN.findTransition(prefix + "onMessage_" + toString(branch_count)), innerActivity2->id, phylum->id); 

#line  1067 "petrinet-patterns-structured.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1072 "petrinet-patterns-structured.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 822 "petrinet-patterns-structured.k"

#line  1077 "petrinet-patterns-structured.cc"
			    }
			}
#line 825 "petrinet-patterns-structured.k"

			branch_count++;

#line  1084 "petrinet-patterns-structured.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  1089 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 816 "petrinet-patterns-structured.k"

#line  1094 "petrinet-patterns-structured.cc"
	}
    }
#line 828 "petrinet-patterns-structured.k"

    {
#line 829 "petrinet-patterns-structured.k"
	tOnAlarm_list kc_fe_selvar_1 =  phylum->tOnAlarm_list_1;

#line  1103 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
	    ) {
	    tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
	    {
#line 829 "petrinet-patterns-structured.k"
		{
#line 829 "petrinet-patterns-structured.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 829 "petrinet-patterns-structured.k"
#line 829 "petrinet-patterns-structured.k"
			const activity innerActivity1 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 829 "petrinet-patterns-structured.k"

			{
#line 830 "petrinet-patterns-structured.k"
			    tOnAlarm_list kc_fe_selvar_1 =  phylum->tOnAlarm_list_1;

#line  1122 "petrinet-patterns-structured.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
				) {
				tOnAlarm kc_selvar_1_1 = kc_fe_selvar_1->tOnAlarm_1;
				{
#line 830 "petrinet-patterns-structured.k"
				    {
#line 830 "petrinet-patterns-structured.k"
					if ((kc_selvar_1_1->prod_sel() == sel_OnAlarm)) {
#line 830 "petrinet-patterns-structured.k"
#line 830 "petrinet-patterns-structured.k"
					    const tOnAlarm otheronalarm = kc_selvar_1_1;
#line 830 "petrinet-patterns-structured.k"
					    const activity innerActivity2 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_1_1)->activity_1;
#line 830 "petrinet-patterns-structured.k"

					    if ((innerActivity1 != innerActivity2))
					    dpeLinks(PN.findTransition(prefix + "onAlarm_" + toString(branch_count)), innerActivity2->id, phylum->id); 

#line  1142 "petrinet-patterns-structured.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1147 "petrinet-patterns-structured.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 830 "petrinet-patterns-structured.k"

#line  1152 "petrinet-patterns-structured.cc"
			    }
			}
#line 834 "petrinet-patterns-structured.k"

			{
#line 835 "petrinet-patterns-structured.k"
			    tOnMessage_list kc_fe_selvar_1 =  phylum->tOnMessage_list_1;

#line  1161 "petrinet-patterns-structured.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
				) {
				tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
				{
#line 835 "petrinet-patterns-structured.k"
				    {
#line 835 "petrinet-patterns-structured.k"
					if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 835 "petrinet-patterns-structured.k"
#line 835 "petrinet-patterns-structured.k"
					    const tCorrelation_list _corr2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->tCorrelation_list_1;
#line 835 "petrinet-patterns-structured.k"
					    const tFromPart_list _from2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->tFromPart_list_1;
#line 835 "petrinet-patterns-structured.k"
					    const activity innerActivity2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 835 "petrinet-patterns-structured.k"
					    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->integer_1;
#line 835 "petrinet-patterns-structured.k"

					    dpeLinks(PN.findTransition(prefix + "onAlarm_" + toString(branch_count)), innerActivity2->id, phylum->id); 

#line  1184 "petrinet-patterns-structured.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1189 "petrinet-patterns-structured.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 835 "petrinet-patterns-structured.k"

#line  1194 "petrinet-patterns-structured.cc"
			    }
			}
#line 838 "petrinet-patterns-structured.k"

			branch_count++;

#line  1201 "petrinet-patterns-structured.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  1206 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 829 "petrinet-patterns-structured.k"

#line  1211 "petrinet-patterns-structured.cc"
	}
    }
#line 841 "petrinet-patterns-structured.k"

    footer(phylum->id, true);

#line 843 "petrinet-patterns-structured.k"
}
#line  1220 "petrinet-patterns-structured.cc"

void PIf(impl_tIf *abstract_phylum, uview current_view)
#line 880 "petrinet-patterns-structured.k"
{
    impl_tIf_If* phylum = static_cast<impl_tIf_If*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";



    Place *p1 =  PN.newPlace(prefix + "initial");
    Place *p2 =  PN.newPlace(prefix + "final");


    if (current_view != petrinetsmall_enum)
    {
	Place *p3 =  PN.newPlace(prefix + "stop");
	Place *p4 =  PN.newPlace(prefix + "stopped");

	Transition *t9 = stop(p1, "initial", prefix);
	Transition *t10 = stop(p2, "final", prefix);
    }


    phylum->standardElements_1->unparse(pseudoPrinter, current_view);




    unsigned int currentCase = 1;
    {
#line 909 "petrinet-patterns-structured.k"
	tElseIf_list kc_fe_selvar_1 =  phylum->tElseIf_list_1;

#line  1257 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
	    ) {
	    tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
	    {
#line 909 "petrinet-patterns-structured.k"
		{
#line 910 "petrinet-patterns-structured.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 910 "petrinet-patterns-structured.k"
#line 909 "petrinet-patterns-structured.k"
			const tElseIf caseBranch = kc_selvar_0_1;
#line 909 "petrinet-patterns-structured.k"
			const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 909 "petrinet-patterns-structured.k"
			const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->integer_1;
#line 910 "petrinet-patterns-structured.k"

			header(_id2, true);
			string branch = toString(currentCase++);


			innerActivity->unparse(pseudoPrinter, current_view);


			Transition* t1 = PN.newTransition(prefix + "case" + branch);
			PN.newArc(PN.findPlace(prefix + "initial"), t1);


			PN.newArc(t1, PN.findPlace(innerActivity->id, ".initial"));
			PN.mergePlaces(phylum->id, ".internal.final", innerActivity->id, ".final");

			if (current_view != petrinetsmall_enum)
			{
			    PN.mergePlaces(phylum->id, ".internal.stop", innerActivity->id, ".stop");
			    PN.mergePlaces(phylum->id, ".internal.stopped", innerActivity->id, ".stopped");
			}

			footer(_id2, true);

#line  1298 "petrinet-patterns-structured.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  1303 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 909 "petrinet-patterns-structured.k"

#line  1308 "petrinet-patterns-structured.cc"
	}
    }
#line 933 "petrinet-patterns-structured.k"



    Transition *t3 = PN.newTransition(prefix + "caseo");
    PN.newArc(PN.findPlace(prefix + "initial"), t3);

    impl_tElse *elseBranch = phylum->tElse_1;
    {
#line 940 "petrinet-patterns-structured.k"
	tElse kc_selvar_0_1 = phylum_cast<tElse>(elseBranch);
#line 963 "petrinet-patterns-structured.k"
	if ((kc_selvar_0_1->prod_sel() == sel_NoElse)) {
#line 963 "petrinet-patterns-structured.k"
#line 962 "petrinet-patterns-structured.k"
	    const tElse elseBranch = kc_selvar_0_1;
#line 962 "petrinet-patterns-structured.k"
	    const integer _id2 = phylum_cast<const impl_tElse_NoElse*>(kc_selvar_0_1)->integer_1;
#line 963 "petrinet-patterns-structured.k"

	    PN.newArc(t3, PN.findPlace(phylum->id, ".internal.final"));

#line  1333 "petrinet-patterns-structured.cc"
	} else
#line 943 "petrinet-patterns-structured.k"
	    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 943 "petrinet-patterns-structured.k"
#line 942 "petrinet-patterns-structured.k"
	    const tElse elseBranch = kc_selvar_0_1;
#line 942 "petrinet-patterns-structured.k"
	    const activity innerActivity = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 942 "petrinet-patterns-structured.k"
	    const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 943 "petrinet-patterns-structured.k"

	    header(_id2, true);


	    phylum->tElse_1->unparse(pseudoPrinter, current_view);


	    PN.newArc(t3, PN.findPlace(innerActivity->id, ".initial"));
	    PN.mergePlaces(phylum->id, ".internal.final", innerActivity->id, ".final");

	    if (current_view != petrinetsmall_enum)
	    {
		PN.mergePlaces(phylum->id, ".internal.stop", innerActivity->id, ".stop");
		PN.mergePlaces(phylum->id, ".internal.stopped", innerActivity->id, ".stopped");
	    }

	    footer(_id2, true);

#line  1363 "petrinet-patterns-structured.cc"
	} else
	{
#line 967 "petrinet-patterns-structured.k"
#line 967 "petrinet-patterns-structured.k"

#line  1369 "petrinet-patterns-structured.cc"
	}
    }
#line 969 "petrinet-patterns-structured.k"





    currentCase = 1;
    {
#line 975 "petrinet-patterns-structured.k"
	tElseIf_list kc_fe_selvar_1 =  phylum->tElseIf_list_1;

#line  1383 "petrinet-patterns-structured.cc"
	while(
		kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
	    ) {
	    tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
	    {
#line 975 "petrinet-patterns-structured.k"
		{
#line 976 "petrinet-patterns-structured.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 976 "petrinet-patterns-structured.k"
#line 975 "petrinet-patterns-structured.k"
			const activity innerActivity1 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 976 "petrinet-patterns-structured.k"

			{
#line 977 "petrinet-patterns-structured.k"
			    tElseIf_list kc_fe_selvar_1 =  phylum->tElseIf_list_1;

#line  1402 "petrinet-patterns-structured.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
				) {
				tElseIf kc_selvar_1_1 = kc_fe_selvar_1->tElseIf_1;
				{
#line 977 "petrinet-patterns-structured.k"
				    {
#line 978 "petrinet-patterns-structured.k"
					if ((kc_selvar_1_1->prod_sel() == sel_ElseIf)) {
#line 978 "petrinet-patterns-structured.k"
#line 977 "petrinet-patterns-structured.k"
					    const activity innerActivity2 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_1_1)->activity_1;
#line 978 "petrinet-patterns-structured.k"

					    if (innerActivity1 != innerActivity2)
					    {
						dpeLinks(PN.findTransition(prefix + "case" + toString(currentCase)), innerActivity2->id, phylum->id); 
					    }

#line  1422 "petrinet-patterns-structured.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1427 "petrinet-patterns-structured.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 977 "petrinet-patterns-structured.k"

#line  1432 "petrinet-patterns-structured.cc"
			    }
			}
#line 984 "petrinet-patterns-structured.k"

			{
#line 985 "petrinet-patterns-structured.k"
			    tElse kc_selvar_1_1 = phylum_cast<tElse>(elseBranch);
#line 988 "petrinet-patterns-structured.k"
			    if ((kc_selvar_1_1->prod_sel() == sel_Else)) {
#line 988 "petrinet-patterns-structured.k"
#line 987 "petrinet-patterns-structured.k"
				const tElse elseBranch = kc_selvar_1_1;
#line 987 "petrinet-patterns-structured.k"
				const activity innerActivity3 = phylum_cast<const impl_tElse_Else*>(kc_selvar_1_1)->activity_1;
#line 987 "petrinet-patterns-structured.k"
				const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_1_1)->integer_1;
#line 988 "petrinet-patterns-structured.k"

				dpeLinks(PN.findTransition(prefix + "case" + toString(currentCase)), innerActivity3->id, phylum->id); 
				dpeLinks(PN.findTransition(prefix + "caseo"), innerActivity1->id, phylum->id); 

#line  1454 "petrinet-patterns-structured.cc"
			    } else
			    {
#line 994 "petrinet-patterns-structured.k"
#line 994 "petrinet-patterns-structured.k"

				dpeLinks(PN.findTransition(prefix + "caseo"), innerActivity1->id, phylum->id); 

#line  1462 "petrinet-patterns-structured.cc"
			    }
			}
#line 998 "petrinet-patterns-structured.k"

			currentCase++;

#line  1469 "petrinet-patterns-structured.cc"
		    } else
		    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
		}

#line  1474 "petrinet-patterns-structured.cc"
	    }
	    kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 975 "petrinet-patterns-structured.k"

#line  1479 "petrinet-patterns-structured.cc"
	}
    }
#line 1001 "petrinet-patterns-structured.k"

    footer(phylum->id, true);

#line 1003 "petrinet-patterns-structured.k"
}
#line  1488 "petrinet-patterns-structured.cc"

void PForEach(impl_tForEach *abstract_phylum, uview current_view)
#line 1014 "petrinet-patterns-structured.k"
{
    impl_tForEach_ForEach* phylum = static_cast<impl_tForEach_ForEach*>(abstract_phylum);
    assert(phylum != NULL);

    header(phylum->id, true);
    string prefix = toString(phylum->id) + ".internal.";

    assert(globals::ASTEmap[phylum->id] != NULL);
    ASTE *myself = globals::ASTEmap[phylum->id];



    if (globals::ASTEmap[phylum->id]->attributes["parallel"] == "yes")
    {
	switch(current_view)
	{
	    case(petrinetsmall_enum):
	    {
		Place *p1 = PN.newPlace(prefix + "initial");
		Place *p2 = PN.newPlace(prefix + "final");

		Transition *t1 = PN.newTransition(prefix + "split");
		PN.newArc(p1, t1);

		Transition *t2 = PN.newTransition(prefix + "join");
		PN.newArc(t2, p2);

		for (unsigned int branch = 1; branch <= myself->max_loops; branch++)
		{

		    PN.push_forEach_suffix(toString(branch));

		    Place *p_start = PN.newPlace(prefix + "start_branch");
		    Place *p_end = PN.newPlace(prefix + "end_branch");

		    PN.newArc(t1, p_start);
		    PN.newArc(p_end, t2);


		    phylum->tScope_1->unparse(pseudoPrinter, current_view);


		    PN.mergePlaces(prefix + "start_branch", toString(phylum->tScope_1->id) + ".initial");
		    PN.mergePlaces(prefix + "end_branch", toString(phylum->tScope_1->id) + ".final");


		    PN.pop_forEach_suffix();
		}


		phylum->standardElements_1->unparse(pseudoPrinter, current_view);

		break;	  
	    }


	    case(petrinetnew_enum):
	    {
		cerr << "no pattern" << endl;
		break;
	    }

	    default: {  }
	}
    }
    else
    cerr << "no pattern" << endl;






































































    footer(phylum->id, true);

#line 1152 "petrinet-patterns-structured.k"
}
#line  1633 "petrinet-patterns-structured.cc"


} // namespace kc
