;; Copyright 2009, 2010, 2011, 2014, 2016 Free Software Foundation, Inc.

;; This file is part of Guile-Ncurses.

;; Guile-Ncurses is free software: you can redistribute it and/or
;; modify it under the terms of the GNU Lesser General Public License
;; as published by the Free Software Foundation, either version 3 of
;; the License, or (at your option) any later version.

;; Guile-Ncurses is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; Lesser General Public License for more details.

;; You should have received a copy of the GNU Lesser General Public
;; License along with Guile-Ncurses.  If not, see
;; <http://www.gnu.org/licenses/>.

(use-modules (test automake-test-lib)
             (ncurses curses))

 ;; erasechar and killchar get their data from the terminal line
 ;; settings, so it isn't possible to say what the 'correct' response
 ;; should be, yet.  (In the future, we can compare this to the
;; response from the termios functions.)

(define expected-killchar #\nak)

(automake-test
 (let ((win (initscr)))
   (clear win)
   (refresh win) 
   (let ((c (killchar)))
     (endwin)
     (newline)
     (format #t "Killchar: ~s (expected ~s)~%" c expected-killchar)
     (eqv? c expected-killchar)
     'skipped)))

