/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : MTSERVER_SKEL
    Description : Multi Threaded Server Skeleton
    Author      : David Martnez Oliviera
    Date        : 12/04/2001
-----------------------------------------------------
  REVISIONS :
  August 6th, 2005

  This class requires review since new functions to manage threads in a
  portable way were added to GNU/EDMA. 

  Modification also should support PRODUCER/CONSUMERS architectures

  ----------------------------------------------------------------
  July, 23th, 2001
  After a system crash, we're going to rebuild the latest
  modifications about releassing resources when the connection
  service thread finish.
  ------------------------------------------------------------------
  September, 4th, 2005
  Integration of new GNU/EDMA thread model

***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <pthread.h>
#include <time.h>
/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>
/*
***************************************************
  Private Data Struct for class MTSERVER_SKEL
***************************************************
*/
 
typedef struct
  {
    EUint32		Port;
    EUint32		BackLog;
    OBJID		Channel;
    ESint32		MaxClients;
    EDMAT_BUFFER	Data;
    ESint32             n;
    /* Mutex for witting CLIENT table*/
    /* Due to datatype sizes we use a pointer and dynamic allocation
       for this class Attribute. This attribute is an EUInt32 in EDMA
       Inteface Definition File.
       We only need enought space for a pointer
    */
    pthread_mutex_t     *smutex;
}DtMTSERVER_SKEL;

typedef struct
{
  pthread_t      tid;
  OBJID          server;
  OBJID          id;
  time_t         tstart;
  time_t         tend;
} CLIENT;

void *service(void *);

/*
***************************************************
  Method Declaration for class Data
***************************************************
*/
 
ESint32 EDMAPROC 
MTSERVER_SKELinitZS32rS32 (OBJID IdObj, EPChar res, ESint32 n)
{
  DtMTSERVER_SKEL	*m;
  ESint32               i,r;
  CLIENT                *ci;

  m = (DtMTSERVER_SKEL*) edma_get_data_ref (IdObj);
  /* We create the incomming request channel*/
  if ((m->Channel = edma_new_obj ("CHANNEL")) == -1)
    {
      edma_printf_obj (IdObj, "%s", "[ERROR] Can't create 'CHANNEL' object");
      return -1;
    }
  
  /* Configure Server*/
  r = (ESint32) edma_met3 (m->Channel, "open", res);
  if (r == -1) 
    {
      edma_printf_obj (IdObj, "%s", "[ERROR] Can't open '%s'", res);
      return -1;
    }

  /* Now, we build the service thread extra data*/
  edma_printf_obj (IdObj, "[INFO] Initializing %d client data structs", n);
  m->MaxClients = n;
  if ((edma_buffer_alloc (&m->Data, sizeof(CLIENT) * n))) 
    {
      /* Can't alloc client table*/
      edma_printf_obj (IdObj, "%s", "[ERROR] Can't allocate mt client table");
      return -1;
    }

  ci = (CLIENT *)m->Data.dat;
  for (i = 0; i < n; i++)
    ci[i].id = -1;
  m->n = 0;

  /* Initialize the mutex struct. FIXME: Change to new GNU/EDMA Thread Interface */
  m->smutex = (pthread_mutex_t*) malloc (sizeof (pthread_mutex_t));
  if (m->smutex == NULL) 
    {
      /* Can't allocate memory space for mutex struct, so we abort init*/
      edma_printf_obj (IdObj, "%s", "[ERROR] Can't allocate mutex");
      /* FIXME: We must release client table*/
      return -1;
    }

  /* FIXME: Change to new GNU/EDMA Thread Management Functions */
  pthread_mutex_init (m->smutex, NULL);
  
  return 0;
}


ESint32 EDMAPROC 
MTSERVER_SKELrunrS32 (OBJID IdObj)
{
  DtMTSERVER_SKEL	*m;
  OBJID                 id;
  CLIENT                *ci;
  ESint32               i;

  m = (DtMTSERVER_SKEL*) edma_get_data_ref (IdObj);
  ci = m->Data.dat;
  while (1) 
    {
      if ((edma_met3 (m->Channel, "wait", &id)) == -1)
	{
	  edma_printf_obj (IdObj, "%s", "wait error...");
	  continue;
	}
      if (id == -1)
	{
	  edma_printf_obj (IdObj, "%s", "wait error....");
	  continue;
	}
      
      /* Look for Entry on thread table. Mutex access required*/
      pthread_mutex_lock (m->smutex);
      for (i = 0; i < m->MaxClients; i++) 
	{
	  if (ci[i].id == -1)
	    break;
	}
      
      if (i == m->MaxClients) 
	{
	  edma_printf_obj (IdObj,"%s", "[ERROR] Can't accept more connections");
	  edma_printf_obj (IdObj, "Clossing connection with object %d", id);
	  edma_met3 (id, "Close");
	  edma_free_obj (id);
	  pthread_mutex_unlock (m->smutex);
	  continue;
	}
      ci[i].id = id;
      ci[i].server = IdObj;
      /* Client data is marked so we can release mutex*/
      m->n++;
      pthread_mutex_unlock (m->smutex);
      time (&ci[i].tstart);
      pthread_create (&ci[i].tid, NULL, service, &ci[i]);      
    }
  return 0;
}


ESint32 EDMAPROC 
MTSERVER_SKELonRequestOrS32 (OBJID IdObj,OBJID id)
{
  DtMTSERVER_SKEL	*m;
  EChar                 remote[1024];

  m=(DtMTSERVER_SKEL*)edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "%s", "[Warnning] You haven't override this method for managing requests");
  edma_rprop3 (id, "Resource", remote);
  edma_printf_obj (IdObj, "[Warnning] Request arrived from: %s", remote);
  
  return 0;
}

void * service (void *data) {
  CLIENT *ci;
  ESint32    n;
  pthread_mutex_t  *the_mutex;

  edma_thread_register();
  ci = (CLIENT*)data;
  edma_met3 (ci->server, "onRequest", ci->id);
  time (&ci->tend);
  /* Here we can log the session if we want*/
  /* Finally we release the client struct*/
  /* In theory we must not to mutex this access. Each
     client only has a uniq id used for assign, so there
     is no conflict.
   */

  /* Safe access to shared structs */
  edma_met3 (ci->id, "Close");
  edma_rprop3 (ci->server, "smutex", &the_mutex);

  pthread_mutex_lock (the_mutex);
  /* Frees channel object allocated for communication*/
  edma_free_obj (ci->id);
  /* Update current client Number*/

  edma_rprop3 (ci->server, "n", &n);
  n--;
  edma_wprop3 (ci->server, "n", n);
  ci->id=-1;
  pthread_mutex_unlock (the_mutex);
  edma_thread_unregister ();
  /* The thread finished with the return statement*/
  return NULL;
}


/********** END C IMPLEMENTATION SKELETON ******************/
