#include "pu_defs.h"
#include <stdio.h>

void printonoff(char *str, int flag)
{
	printf("%s",str);
	if (flag)
		printf("On\n");
	else
		printf("Off\n");
}

void main(int argc, char *argv[])
{
	PICDEFN pic;
	char oscstr[10];
	int top;

	if(argc!=2)
	{
		printf("\nUseage:\n%s <inputfile>\n",argv[0]);
		exit(1);
	}

	if (PU_Read(argv[1],&pic,&top) == PU_FAIL)
		exit(1);

	switch(pic.osctype)
	{
		case 0:		sprintf(oscstr,"LP");
				break;
		case 1:		sprintf(oscstr,"XT");
				break;
		case 2:		sprintf(oscstr,"HS");
				break;
		case 3:		sprintf(oscstr,"RC");
				break;
		default:	sprintf(oscstr,"Unknown");
				break;
	}

	printf(";-------------------------------\n\n");
	printf("Filename:       %s\n\n",argv[1]);
	printf("Chip type:      16C%d\n\n",pic.pictype);

	printf("Clock Freq:     %.4f MHz\n",pic.clock/1000000.0);
	printf("Oscillator:     %s\n\n",oscstr);

	printonoff("Code Protect:   ",!pic.cp_fuse);
	printonoff("Watchdog Timer: ",pic.wd_fuse);
	printonoff("Power Up:       ",pic.pu_fuse);

	printf("\nID words are:   %04x %04x %04x %04x\n\n",
		pic.picid[0],pic.picid[1],pic.picid[2],pic.picid[3]);

	printf("Code top:       0x%04x\n\n",top);
	printf(";-------------------------------\n");
}

/* ... The End ... */
