/* init.c */

#include "picasm.h"

static SYMBOL keywords[] =
	{

/* instuctions Pic 12 and 14 bit */

		"addwf",	ADDWF,		KEYWORD,	0,
		"andwf",	ANDWF,		KEYWORD,	0,
		"clrf",		CLRF,		KEYWORD,	0,
		"clrw",		CLRW,		KEYWORD,	0,
		"comf",		COMF,		KEYWORD,	0,
		"decf",		DECF,		KEYWORD,	0,
		"decfsz",	DECFSZ,		KEYWORD,	0,
		"incf",		INCF,		KEYWORD,	0,
		"incfsz",	INCFSZ,		KEYWORD,	0,
		"iorwf",	IORWF,		KEYWORD,	0,
		"movf",		MOVF,		KEYWORD,	0,
		"movwf",	MOVWF,		KEYWORD,	0,
		"nop",		NOP,		KEYWORD,	0,
		"rlf",		RLF,		KEYWORD,	0,
		"rrf",		RRF,		KEYWORD,	0,
		"subwf",	SUBWF,		KEYWORD,	0,
		"swapf",	SWAPF,		KEYWORD,	0,
		"xorwf",	XORWF,		KEYWORD,	0,
		"bcf",		BCF,		KEYWORD,	0,
		"bsf",		BSF,		KEYWORD,	0,
		"btfsc",	BTFSC,		KEYWORD,	0,
		"btfss",	BTFSS,		KEYWORD,	0,
		"andlw",	ANDLW,		KEYWORD,	0,
		"call",		CALL,		KEYWORD,	0,
		"clrwdt",	CLRWDT,		KEYWORD,	0,
		"goto",		GOTO,		KEYWORD,	0,
		"iorlw",	IORLW,		KEYWORD,	0,
		"movlw",	MOVLW,		KEYWORD,	0,
		"option",	OPTION,		KEYWORD,	0,
		"retlw",	RETLW,		KEYWORD,	0,
		"sleep",	SLEEP,		KEYWORD,	0,
		"xorlw",	XORLW,		KEYWORD,	0,
		"tris",		TRIS,		KEYWORD,	0,

/* extras for 14 bit Pics */

		"addlw",	ADDLW,		KEYWORD,	0,
		"retfie",	RETFIE,		KEYWORD,	0,
		"return",	RETURN,		KEYWORD,	0,
		"sublw",	SUBLW,		KEYWORD,	0,

/* compiler directives */

		"org",		ORG,		KEYWORD,	0,
		"equ",		EQU,		KEYWORD,	0,
		"end",		END,		KEYWORD,	0,
		"processor",	PROC,		KEYWORD,	0,
		"watchdog",	WATCH,		KEYWORD,	0,
		"idwords",	IDWRDS,		KEYWORD,	0,
		"pwrup",	PWRUP,		KEYWORD,	0,
		"protect",	PROTECT,	KEYWORD,	0,
		"clock",	CLK,		KEYWORD,	0,
		"rc",		RC,		KEYWORD,	0,
		"lp",		LP,		KEYWORD,	0,
		"xt",		XT,		KEYWORD,	0,
		"hs",		HS,		KEYWORD,	0,
		"on",		ON,		KEYWORD,	0,
		"off",		OFF,		KEYWORD,	0,

		"data",		DATA,		KEYWORD,	0,

		"if",		IF,		KEYWORD,	0,
		"else",		ELSE,		KEYWORD,	0,
		"endif",	ENDIF,		KEYWORD,	0,
		"ifdef",	IFDEF,		KEYWORD,	0,
		"ifndef",	IFNDEF,		KEYWORD,	0,
		"include",	INCLUDE,	KEYWORD,	0,
		"macro",	MACRO,		KEYWORD,	0,
		"endm",		ENDM,		KEYWORD,	0,
		"begin",	BEGIN,		KEYWORD,	0,
		"endb",		ENDB,		KEYWORD,	0,

		0,		0,		0,		0
	};

void init()
{
	SYMBOL *p;

	for(p = keywords; p->token; p++)
		(void)insert(p->lexptr, p->token, p->type);
}

/* ... The End ... */
