/* hashlen.c: The opiehashlen() library function.

%%% copyright-cmetz
This software is Copyright 1996 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

        History:

	Created by cmetz for OPIE 2.3.
*/
#include "opie_cfg.h"
#include "opie.h"

VOIDRET opiehashlen FUNCTION((algorithm, in, out, n), int algorithm AND VOIDPTR in AND VOIDPTR out AND int n)
{
  struct opiemdx_ctx ctx;
  UINT4 results[4];

  switch(algorithm) {
	case 4:
		opiemd4init(&ctx);
		opiemd4update(&ctx, (unsigned char *)in, n);
		opiemd4final((unsigned char *)results, &ctx);
		break;
	case 5:
		opiemd5init(&ctx);
		opiemd5update(&ctx, (unsigned char *)in, n);
		opiemd5final((unsigned char *)results, &ctx);
		break;
  }

  results[0] ^= results[2];
  results[1] ^= results[3];

  memcpy(out, (VOIDPTR)results, 8);
}
