/* passwd.c: The opiepasswd() library function.

This software is Copyright 1996 by Craig Metz, All Rights Reserved. The Inner
Net Copyright Notice and License Agreement applies to these portions of the
software.

	History:

	Created by cmetz for OPIE 2.22.
*/
#include "opie_cfg.h"

#include <stdio.h>
#if TM_IN_SYS_TIME
#include <sys/time.h>
#else /* TM_IN_SYS_TIME */
#include <time.h>
#endif /* TM_IN_SYS_TIME */
#include <sys/types.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */
#if HAVE_STRING_H
#include <string.h>
#endif /* HAVE_STRING_H */
#if HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#include "opie.h"

int opiepasswd FUNCTION((old, principal, n, seed, key), struct opie *old AND char *principal AND int n AND char *seed AND char *key)
{
  char buf[17], buf2[64], *p;
  time_t now;
  FILE *f;
  struct opie opie;

  time(&now);
  if (strftime(buf2, sizeof(buf2), " %b %d,%Y %T", localtime(&now)) < 1)
    return -1;

  if (key) {
    if (opiebtoa8(buf, key))
      return -1;
    p = buf;
  } else
    p = "****************";

  if (opielock(principal))
    return -1;

  if (old && old->keyfile && old->recstart) {
    fclose((FILE *)old->keyfile);
    if (!(f = fopen(KEY_FILE, "r+")))
      return -1;
    if (fseek(f, old->recstart, SEEK_SET) < 0)
      return -1;
  } else {
    int i = opielookup(&opie, principal);

    switch(i) {
    case 0:
      f = (FILE *)opie.keyfile;
      break;
    case 1:
      if (f = fopen(KEY_FILE, "a"))
	break;
    default:
      return -1;
    }
  }

  if (fprintf(f, "%s %04d %-16s %s %-21s\n", principal, n, seed, p, buf2) < 1)
    return -1;

  fclose(f);

  if (opieunlock())
    return -1;

  if (old)
    memset(old, 0, sizeof(*old));

  return 0;
}
