var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn2, res) => function __init() {
  return fn2 && (res = (0, fn2[__getOwnPropNames(fn2)[0]])(fn2 = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// ../../node_modules/.pnpm/big-integer@1.6.52/node_modules/big-integer/BigInteger.js
var require_BigInteger = __commonJS({
  "../../node_modules/.pnpm/big-integer@1.6.52/node_modules/big-integer/BigInteger.js"(exports, module) {
    var bigInt = function(undefined2) {
      "use strict";
      var BASE = 1e7, LOG_BASE = 7, MAX_INT = 9007199254740992, MAX_INT_ARR = smallToArray(MAX_INT), DEFAULT_ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz";
      var supportsNativeBigInt = typeof BigInt === "function";
      function Integer2(v3, radix, alphabet, caseSensitive) {
        if (typeof v3 === "undefined")
          return Integer2[0];
        if (typeof radix !== "undefined")
          return +radix === 10 && !alphabet ? parseValue(v3) : parseBase(v3, radix, alphabet, caseSensitive);
        return parseValue(v3);
      }
      function BigInteger(value, sign2) {
        this.value = value;
        this.sign = sign2;
        this.isSmall = false;
      }
      BigInteger.prototype = Object.create(Integer2.prototype);
      function SmallInteger(value) {
        this.value = value;
        this.sign = value < 0;
        this.isSmall = true;
      }
      SmallInteger.prototype = Object.create(Integer2.prototype);
      function NativeBigInt(value) {
        this.value = value;
      }
      NativeBigInt.prototype = Object.create(Integer2.prototype);
      function isPrecise(n2) {
        return -MAX_INT < n2 && n2 < MAX_INT;
      }
      function smallToArray(n2) {
        if (n2 < 1e7)
          return [n2];
        if (n2 < 1e14)
          return [n2 % 1e7, Math.floor(n2 / 1e7)];
        return [n2 % 1e7, Math.floor(n2 / 1e7) % 1e7, Math.floor(n2 / 1e14)];
      }
      function arrayToSmall(arr) {
        trim(arr);
        var length = arr.length;
        if (length < 4 && compareAbs(arr, MAX_INT_ARR) < 0) {
          switch (length) {
            case 0:
              return 0;
            case 1:
              return arr[0];
            case 2:
              return arr[0] + arr[1] * BASE;
            default:
              return arr[0] + (arr[1] + arr[2] * BASE) * BASE;
          }
        }
        return arr;
      }
      function trim(v3) {
        var i5 = v3.length;
        while (v3[--i5] === 0)
          ;
        v3.length = i5 + 1;
      }
      function createArray(length) {
        var x5 = new Array(length);
        var i5 = -1;
        while (++i5 < length) {
          x5[i5] = 0;
        }
        return x5;
      }
      function truncate(n2) {
        if (n2 > 0)
          return Math.floor(n2);
        return Math.ceil(n2);
      }
      function add4(a4, b4) {
        var l_a = a4.length, l_b = b4.length, r3 = new Array(l_a), carry = 0, base2 = BASE, sum, i5;
        for (i5 = 0; i5 < l_b; i5++) {
          sum = a4[i5] + b4[i5] + carry;
          carry = sum >= base2 ? 1 : 0;
          r3[i5] = sum - carry * base2;
        }
        while (i5 < l_a) {
          sum = a4[i5] + carry;
          carry = sum === base2 ? 1 : 0;
          r3[i5++] = sum - carry * base2;
        }
        if (carry > 0)
          r3.push(carry);
        return r3;
      }
      function addAny(a4, b4) {
        if (a4.length >= b4.length)
          return add4(a4, b4);
        return add4(b4, a4);
      }
      function addSmall(a4, carry) {
        var l3 = a4.length, r3 = new Array(l3), base2 = BASE, sum, i5;
        for (i5 = 0; i5 < l3; i5++) {
          sum = a4[i5] - base2 + carry;
          carry = Math.floor(sum / base2);
          r3[i5] = sum - carry * base2;
          carry += 1;
        }
        while (carry > 0) {
          r3[i5++] = carry % base2;
          carry = Math.floor(carry / base2);
        }
        return r3;
      }
      BigInteger.prototype.add = function(v3) {
        var n2 = parseValue(v3);
        if (this.sign !== n2.sign) {
          return this.subtract(n2.negate());
        }
        var a4 = this.value, b4 = n2.value;
        if (n2.isSmall) {
          return new BigInteger(addSmall(a4, Math.abs(b4)), this.sign);
        }
        return new BigInteger(addAny(a4, b4), this.sign);
      };
      BigInteger.prototype.plus = BigInteger.prototype.add;
      SmallInteger.prototype.add = function(v3) {
        var n2 = parseValue(v3);
        var a4 = this.value;
        if (a4 < 0 !== n2.sign) {
          return this.subtract(n2.negate());
        }
        var b4 = n2.value;
        if (n2.isSmall) {
          if (isPrecise(a4 + b4))
            return new SmallInteger(a4 + b4);
          b4 = smallToArray(Math.abs(b4));
        }
        return new BigInteger(addSmall(b4, Math.abs(a4)), a4 < 0);
      };
      SmallInteger.prototype.plus = SmallInteger.prototype.add;
      NativeBigInt.prototype.add = function(v3) {
        return new NativeBigInt(this.value + parseValue(v3).value);
      };
      NativeBigInt.prototype.plus = NativeBigInt.prototype.add;
      function subtract(a4, b4) {
        var a_l = a4.length, b_l = b4.length, r3 = new Array(a_l), borrow = 0, base2 = BASE, i5, difference;
        for (i5 = 0; i5 < b_l; i5++) {
          difference = a4[i5] - borrow - b4[i5];
          if (difference < 0) {
            difference += base2;
            borrow = 1;
          } else
            borrow = 0;
          r3[i5] = difference;
        }
        for (i5 = b_l; i5 < a_l; i5++) {
          difference = a4[i5] - borrow;
          if (difference < 0)
            difference += base2;
          else {
            r3[i5++] = difference;
            break;
          }
          r3[i5] = difference;
        }
        for (; i5 < a_l; i5++) {
          r3[i5] = a4[i5];
        }
        trim(r3);
        return r3;
      }
      function subtractAny(a4, b4, sign2) {
        var value;
        if (compareAbs(a4, b4) >= 0) {
          value = subtract(a4, b4);
        } else {
          value = subtract(b4, a4);
          sign2 = !sign2;
        }
        value = arrayToSmall(value);
        if (typeof value === "number") {
          if (sign2)
            value = -value;
          return new SmallInteger(value);
        }
        return new BigInteger(value, sign2);
      }
      function subtractSmall(a4, b4, sign2) {
        var l3 = a4.length, r3 = new Array(l3), carry = -b4, base2 = BASE, i5, difference;
        for (i5 = 0; i5 < l3; i5++) {
          difference = a4[i5] + carry;
          carry = Math.floor(difference / base2);
          difference %= base2;
          r3[i5] = difference < 0 ? difference + base2 : difference;
        }
        r3 = arrayToSmall(r3);
        if (typeof r3 === "number") {
          if (sign2)
            r3 = -r3;
          return new SmallInteger(r3);
        }
        return new BigInteger(r3, sign2);
      }
      BigInteger.prototype.subtract = function(v3) {
        var n2 = parseValue(v3);
        if (this.sign !== n2.sign) {
          return this.add(n2.negate());
        }
        var a4 = this.value, b4 = n2.value;
        if (n2.isSmall)
          return subtractSmall(a4, Math.abs(b4), this.sign);
        return subtractAny(a4, b4, this.sign);
      };
      BigInteger.prototype.minus = BigInteger.prototype.subtract;
      SmallInteger.prototype.subtract = function(v3) {
        var n2 = parseValue(v3);
        var a4 = this.value;
        if (a4 < 0 !== n2.sign) {
          return this.add(n2.negate());
        }
        var b4 = n2.value;
        if (n2.isSmall) {
          return new SmallInteger(a4 - b4);
        }
        return subtractSmall(b4, Math.abs(a4), a4 >= 0);
      };
      SmallInteger.prototype.minus = SmallInteger.prototype.subtract;
      NativeBigInt.prototype.subtract = function(v3) {
        return new NativeBigInt(this.value - parseValue(v3).value);
      };
      NativeBigInt.prototype.minus = NativeBigInt.prototype.subtract;
      BigInteger.prototype.negate = function() {
        return new BigInteger(this.value, !this.sign);
      };
      SmallInteger.prototype.negate = function() {
        var sign2 = this.sign;
        var small = new SmallInteger(-this.value);
        small.sign = !sign2;
        return small;
      };
      NativeBigInt.prototype.negate = function() {
        return new NativeBigInt(-this.value);
      };
      BigInteger.prototype.abs = function() {
        return new BigInteger(this.value, false);
      };
      SmallInteger.prototype.abs = function() {
        return new SmallInteger(Math.abs(this.value));
      };
      NativeBigInt.prototype.abs = function() {
        return new NativeBigInt(this.value >= 0 ? this.value : -this.value);
      };
      function multiplyLong(a4, b4) {
        var a_l = a4.length, b_l = b4.length, l3 = a_l + b_l, r3 = createArray(l3), base2 = BASE, product, carry, i5, a_i, b_j;
        for (i5 = 0; i5 < a_l; ++i5) {
          a_i = a4[i5];
          for (var j4 = 0; j4 < b_l; ++j4) {
            b_j = b4[j4];
            product = a_i * b_j + r3[i5 + j4];
            carry = Math.floor(product / base2);
            r3[i5 + j4] = product - carry * base2;
            r3[i5 + j4 + 1] += carry;
          }
        }
        trim(r3);
        return r3;
      }
      function multiplySmall(a4, b4) {
        var l3 = a4.length, r3 = new Array(l3), base2 = BASE, carry = 0, product, i5;
        for (i5 = 0; i5 < l3; i5++) {
          product = a4[i5] * b4 + carry;
          carry = Math.floor(product / base2);
          r3[i5] = product - carry * base2;
        }
        while (carry > 0) {
          r3[i5++] = carry % base2;
          carry = Math.floor(carry / base2);
        }
        return r3;
      }
      function shiftLeft(x5, n2) {
        var r3 = [];
        while (n2-- > 0)
          r3.push(0);
        return r3.concat(x5);
      }
      function multiplyKaratsuba(x5, y4) {
        var n2 = Math.max(x5.length, y4.length);
        if (n2 <= 30)
          return multiplyLong(x5, y4);
        n2 = Math.ceil(n2 / 2);
        var b4 = x5.slice(n2), a4 = x5.slice(0, n2), d4 = y4.slice(n2), c4 = y4.slice(0, n2);
        var ac = multiplyKaratsuba(a4, c4), bd = multiplyKaratsuba(b4, d4), abcd = multiplyKaratsuba(addAny(a4, b4), addAny(c4, d4));
        var product = addAny(addAny(ac, shiftLeft(subtract(subtract(abcd, ac), bd), n2)), shiftLeft(bd, 2 * n2));
        trim(product);
        return product;
      }
      function useKaratsuba(l1, l22) {
        return -0.012 * l1 - 0.012 * l22 + 15e-6 * l1 * l22 > 0;
      }
      BigInteger.prototype.multiply = function(v3) {
        var n2 = parseValue(v3), a4 = this.value, b4 = n2.value, sign2 = this.sign !== n2.sign, abs;
        if (n2.isSmall) {
          if (b4 === 0)
            return Integer2[0];
          if (b4 === 1)
            return this;
          if (b4 === -1)
            return this.negate();
          abs = Math.abs(b4);
          if (abs < BASE) {
            return new BigInteger(multiplySmall(a4, abs), sign2);
          }
          b4 = smallToArray(abs);
        }
        if (useKaratsuba(a4.length, b4.length))
          return new BigInteger(multiplyKaratsuba(a4, b4), sign2);
        return new BigInteger(multiplyLong(a4, b4), sign2);
      };
      BigInteger.prototype.times = BigInteger.prototype.multiply;
      function multiplySmallAndArray(a4, b4, sign2) {
        if (a4 < BASE) {
          return new BigInteger(multiplySmall(b4, a4), sign2);
        }
        return new BigInteger(multiplyLong(b4, smallToArray(a4)), sign2);
      }
      SmallInteger.prototype._multiplyBySmall = function(a4) {
        if (isPrecise(a4.value * this.value)) {
          return new SmallInteger(a4.value * this.value);
        }
        return multiplySmallAndArray(Math.abs(a4.value), smallToArray(Math.abs(this.value)), this.sign !== a4.sign);
      };
      BigInteger.prototype._multiplyBySmall = function(a4) {
        if (a4.value === 0)
          return Integer2[0];
        if (a4.value === 1)
          return this;
        if (a4.value === -1)
          return this.negate();
        return multiplySmallAndArray(Math.abs(a4.value), this.value, this.sign !== a4.sign);
      };
      SmallInteger.prototype.multiply = function(v3) {
        return parseValue(v3)._multiplyBySmall(this);
      };
      SmallInteger.prototype.times = SmallInteger.prototype.multiply;
      NativeBigInt.prototype.multiply = function(v3) {
        return new NativeBigInt(this.value * parseValue(v3).value);
      };
      NativeBigInt.prototype.times = NativeBigInt.prototype.multiply;
      function square(a4) {
        var l3 = a4.length, r3 = createArray(l3 + l3), base2 = BASE, product, carry, i5, a_i, a_j;
        for (i5 = 0; i5 < l3; i5++) {
          a_i = a4[i5];
          carry = 0 - a_i * a_i;
          for (var j4 = i5; j4 < l3; j4++) {
            a_j = a4[j4];
            product = 2 * (a_i * a_j) + r3[i5 + j4] + carry;
            carry = Math.floor(product / base2);
            r3[i5 + j4] = product - carry * base2;
          }
          r3[i5 + l3] = carry;
        }
        trim(r3);
        return r3;
      }
      BigInteger.prototype.square = function() {
        return new BigInteger(square(this.value), false);
      };
      SmallInteger.prototype.square = function() {
        var value = this.value * this.value;
        if (isPrecise(value))
          return new SmallInteger(value);
        return new BigInteger(square(smallToArray(Math.abs(this.value))), false);
      };
      NativeBigInt.prototype.square = function(v3) {
        return new NativeBigInt(this.value * this.value);
      };
      function divMod1(a4, b4) {
        var a_l = a4.length, b_l = b4.length, base2 = BASE, result = createArray(b4.length), divisorMostSignificantDigit = b4[b_l - 1], lambda = Math.ceil(base2 / (2 * divisorMostSignificantDigit)), remainder = multiplySmall(a4, lambda), divisor = multiplySmall(b4, lambda), quotientDigit, shift, carry, borrow, i5, l3, q5;
        if (remainder.length <= a_l)
          remainder.push(0);
        divisor.push(0);
        divisorMostSignificantDigit = divisor[b_l - 1];
        for (shift = a_l - b_l; shift >= 0; shift--) {
          quotientDigit = base2 - 1;
          if (remainder[shift + b_l] !== divisorMostSignificantDigit) {
            quotientDigit = Math.floor((remainder[shift + b_l] * base2 + remainder[shift + b_l - 1]) / divisorMostSignificantDigit);
          }
          carry = 0;
          borrow = 0;
          l3 = divisor.length;
          for (i5 = 0; i5 < l3; i5++) {
            carry += quotientDigit * divisor[i5];
            q5 = Math.floor(carry / base2);
            borrow += remainder[shift + i5] - (carry - q5 * base2);
            carry = q5;
            if (borrow < 0) {
              remainder[shift + i5] = borrow + base2;
              borrow = -1;
            } else {
              remainder[shift + i5] = borrow;
              borrow = 0;
            }
          }
          while (borrow !== 0) {
            quotientDigit -= 1;
            carry = 0;
            for (i5 = 0; i5 < l3; i5++) {
              carry += remainder[shift + i5] - base2 + divisor[i5];
              if (carry < 0) {
                remainder[shift + i5] = carry + base2;
                carry = 0;
              } else {
                remainder[shift + i5] = carry;
                carry = 1;
              }
            }
            borrow += carry;
          }
          result[shift] = quotientDigit;
        }
        remainder = divModSmall(remainder, lambda)[0];
        return [arrayToSmall(result), arrayToSmall(remainder)];
      }
      function divMod2(a4, b4) {
        var a_l = a4.length, b_l = b4.length, result = [], part = [], base2 = BASE, guess, xlen, highx, highy, check;
        while (a_l) {
          part.unshift(a4[--a_l]);
          trim(part);
          if (compareAbs(part, b4) < 0) {
            result.push(0);
            continue;
          }
          xlen = part.length;
          highx = part[xlen - 1] * base2 + part[xlen - 2];
          highy = b4[b_l - 1] * base2 + b4[b_l - 2];
          if (xlen > b_l) {
            highx = (highx + 1) * base2;
          }
          guess = Math.ceil(highx / highy);
          do {
            check = multiplySmall(b4, guess);
            if (compareAbs(check, part) <= 0)
              break;
            guess--;
          } while (guess);
          result.push(guess);
          part = subtract(part, check);
        }
        result.reverse();
        return [arrayToSmall(result), arrayToSmall(part)];
      }
      function divModSmall(value, lambda) {
        var length = value.length, quotient = createArray(length), base2 = BASE, i5, q5, remainder, divisor;
        remainder = 0;
        for (i5 = length - 1; i5 >= 0; --i5) {
          divisor = remainder * base2 + value[i5];
          q5 = truncate(divisor / lambda);
          remainder = divisor - q5 * lambda;
          quotient[i5] = q5 | 0;
        }
        return [quotient, remainder | 0];
      }
      function divModAny(self2, v3) {
        var value, n2 = parseValue(v3);
        if (supportsNativeBigInt) {
          return [new NativeBigInt(self2.value / n2.value), new NativeBigInt(self2.value % n2.value)];
        }
        var a4 = self2.value, b4 = n2.value;
        var quotient;
        if (b4 === 0)
          throw new Error("Cannot divide by zero");
        if (self2.isSmall) {
          if (n2.isSmall) {
            return [new SmallInteger(truncate(a4 / b4)), new SmallInteger(a4 % b4)];
          }
          return [Integer2[0], self2];
        }
        if (n2.isSmall) {
          if (b4 === 1)
            return [self2, Integer2[0]];
          if (b4 == -1)
            return [self2.negate(), Integer2[0]];
          var abs = Math.abs(b4);
          if (abs < BASE) {
            value = divModSmall(a4, abs);
            quotient = arrayToSmall(value[0]);
            var remainder = value[1];
            if (self2.sign)
              remainder = -remainder;
            if (typeof quotient === "number") {
              if (self2.sign !== n2.sign)
                quotient = -quotient;
              return [new SmallInteger(quotient), new SmallInteger(remainder)];
            }
            return [new BigInteger(quotient, self2.sign !== n2.sign), new SmallInteger(remainder)];
          }
          b4 = smallToArray(abs);
        }
        var comparison = compareAbs(a4, b4);
        if (comparison === -1)
          return [Integer2[0], self2];
        if (comparison === 0)
          return [Integer2[self2.sign === n2.sign ? 1 : -1], Integer2[0]];
        if (a4.length + b4.length <= 200)
          value = divMod1(a4, b4);
        else
          value = divMod2(a4, b4);
        quotient = value[0];
        var qSign = self2.sign !== n2.sign, mod = value[1], mSign = self2.sign;
        if (typeof quotient === "number") {
          if (qSign)
            quotient = -quotient;
          quotient = new SmallInteger(quotient);
        } else
          quotient = new BigInteger(quotient, qSign);
        if (typeof mod === "number") {
          if (mSign)
            mod = -mod;
          mod = new SmallInteger(mod);
        } else
          mod = new BigInteger(mod, mSign);
        return [quotient, mod];
      }
      BigInteger.prototype.divmod = function(v3) {
        var result = divModAny(this, v3);
        return {
          quotient: result[0],
          remainder: result[1]
        };
      };
      NativeBigInt.prototype.divmod = SmallInteger.prototype.divmod = BigInteger.prototype.divmod;
      BigInteger.prototype.divide = function(v3) {
        return divModAny(this, v3)[0];
      };
      NativeBigInt.prototype.over = NativeBigInt.prototype.divide = function(v3) {
        return new NativeBigInt(this.value / parseValue(v3).value);
      };
      SmallInteger.prototype.over = SmallInteger.prototype.divide = BigInteger.prototype.over = BigInteger.prototype.divide;
      BigInteger.prototype.mod = function(v3) {
        return divModAny(this, v3)[1];
      };
      NativeBigInt.prototype.mod = NativeBigInt.prototype.remainder = function(v3) {
        return new NativeBigInt(this.value % parseValue(v3).value);
      };
      SmallInteger.prototype.remainder = SmallInteger.prototype.mod = BigInteger.prototype.remainder = BigInteger.prototype.mod;
      BigInteger.prototype.pow = function(v3) {
        var n2 = parseValue(v3), a4 = this.value, b4 = n2.value, value, x5, y4;
        if (b4 === 0)
          return Integer2[1];
        if (a4 === 0)
          return Integer2[0];
        if (a4 === 1)
          return Integer2[1];
        if (a4 === -1)
          return n2.isEven() ? Integer2[1] : Integer2[-1];
        if (n2.sign) {
          return Integer2[0];
        }
        if (!n2.isSmall)
          throw new Error("The exponent " + n2.toString() + " is too large.");
        if (this.isSmall) {
          if (isPrecise(value = Math.pow(a4, b4)))
            return new SmallInteger(truncate(value));
        }
        x5 = this;
        y4 = Integer2[1];
        while (true) {
          if (b4 & true) {
            y4 = y4.times(x5);
            --b4;
          }
          if (b4 === 0)
            break;
          b4 /= 2;
          x5 = x5.square();
        }
        return y4;
      };
      SmallInteger.prototype.pow = BigInteger.prototype.pow;
      NativeBigInt.prototype.pow = function(v3) {
        var n2 = parseValue(v3);
        var a4 = this.value, b4 = n2.value;
        var _0 = BigInt(0), _1 = BigInt(1), _22 = BigInt(2);
        if (b4 === _0)
          return Integer2[1];
        if (a4 === _0)
          return Integer2[0];
        if (a4 === _1)
          return Integer2[1];
        if (a4 === BigInt(-1))
          return n2.isEven() ? Integer2[1] : Integer2[-1];
        if (n2.isNegative())
          return new NativeBigInt(_0);
        var x5 = this;
        var y4 = Integer2[1];
        while (true) {
          if ((b4 & _1) === _1) {
            y4 = y4.times(x5);
            --b4;
          }
          if (b4 === _0)
            break;
          b4 /= _22;
          x5 = x5.square();
        }
        return y4;
      };
      BigInteger.prototype.modPow = function(exp, mod) {
        exp = parseValue(exp);
        mod = parseValue(mod);
        if (mod.isZero())
          throw new Error("Cannot take modPow with modulus 0");
        var r3 = Integer2[1], base2 = this.mod(mod);
        if (exp.isNegative()) {
          exp = exp.multiply(Integer2[-1]);
          base2 = base2.modInv(mod);
        }
        while (exp.isPositive()) {
          if (base2.isZero())
            return Integer2[0];
          if (exp.isOdd())
            r3 = r3.multiply(base2).mod(mod);
          exp = exp.divide(2);
          base2 = base2.square().mod(mod);
        }
        return r3;
      };
      NativeBigInt.prototype.modPow = SmallInteger.prototype.modPow = BigInteger.prototype.modPow;
      function compareAbs(a4, b4) {
        if (a4.length !== b4.length) {
          return a4.length > b4.length ? 1 : -1;
        }
        for (var i5 = a4.length - 1; i5 >= 0; i5--) {
          if (a4[i5] !== b4[i5])
            return a4[i5] > b4[i5] ? 1 : -1;
        }
        return 0;
      }
      BigInteger.prototype.compareAbs = function(v3) {
        var n2 = parseValue(v3), a4 = this.value, b4 = n2.value;
        if (n2.isSmall)
          return 1;
        return compareAbs(a4, b4);
      };
      SmallInteger.prototype.compareAbs = function(v3) {
        var n2 = parseValue(v3), a4 = Math.abs(this.value), b4 = n2.value;
        if (n2.isSmall) {
          b4 = Math.abs(b4);
          return a4 === b4 ? 0 : a4 > b4 ? 1 : -1;
        }
        return -1;
      };
      NativeBigInt.prototype.compareAbs = function(v3) {
        var a4 = this.value;
        var b4 = parseValue(v3).value;
        a4 = a4 >= 0 ? a4 : -a4;
        b4 = b4 >= 0 ? b4 : -b4;
        return a4 === b4 ? 0 : a4 > b4 ? 1 : -1;
      };
      BigInteger.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var n2 = parseValue(v3), a4 = this.value, b4 = n2.value;
        if (this.sign !== n2.sign) {
          return n2.sign ? 1 : -1;
        }
        if (n2.isSmall) {
          return this.sign ? -1 : 1;
        }
        return compareAbs(a4, b4) * (this.sign ? -1 : 1);
      };
      BigInteger.prototype.compareTo = BigInteger.prototype.compare;
      SmallInteger.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var n2 = parseValue(v3), a4 = this.value, b4 = n2.value;
        if (n2.isSmall) {
          return a4 == b4 ? 0 : a4 > b4 ? 1 : -1;
        }
        if (a4 < 0 !== n2.sign) {
          return a4 < 0 ? -1 : 1;
        }
        return a4 < 0 ? 1 : -1;
      };
      SmallInteger.prototype.compareTo = SmallInteger.prototype.compare;
      NativeBigInt.prototype.compare = function(v3) {
        if (v3 === Infinity) {
          return -1;
        }
        if (v3 === -Infinity) {
          return 1;
        }
        var a4 = this.value;
        var b4 = parseValue(v3).value;
        return a4 === b4 ? 0 : a4 > b4 ? 1 : -1;
      };
      NativeBigInt.prototype.compareTo = NativeBigInt.prototype.compare;
      BigInteger.prototype.equals = function(v3) {
        return this.compare(v3) === 0;
      };
      NativeBigInt.prototype.eq = NativeBigInt.prototype.equals = SmallInteger.prototype.eq = SmallInteger.prototype.equals = BigInteger.prototype.eq = BigInteger.prototype.equals;
      BigInteger.prototype.notEquals = function(v3) {
        return this.compare(v3) !== 0;
      };
      NativeBigInt.prototype.neq = NativeBigInt.prototype.notEquals = SmallInteger.prototype.neq = SmallInteger.prototype.notEquals = BigInteger.prototype.neq = BigInteger.prototype.notEquals;
      BigInteger.prototype.greater = function(v3) {
        return this.compare(v3) > 0;
      };
      NativeBigInt.prototype.gt = NativeBigInt.prototype.greater = SmallInteger.prototype.gt = SmallInteger.prototype.greater = BigInteger.prototype.gt = BigInteger.prototype.greater;
      BigInteger.prototype.lesser = function(v3) {
        return this.compare(v3) < 0;
      };
      NativeBigInt.prototype.lt = NativeBigInt.prototype.lesser = SmallInteger.prototype.lt = SmallInteger.prototype.lesser = BigInteger.prototype.lt = BigInteger.prototype.lesser;
      BigInteger.prototype.greaterOrEquals = function(v3) {
        return this.compare(v3) >= 0;
      };
      NativeBigInt.prototype.geq = NativeBigInt.prototype.greaterOrEquals = SmallInteger.prototype.geq = SmallInteger.prototype.greaterOrEquals = BigInteger.prototype.geq = BigInteger.prototype.greaterOrEquals;
      BigInteger.prototype.lesserOrEquals = function(v3) {
        return this.compare(v3) <= 0;
      };
      NativeBigInt.prototype.leq = NativeBigInt.prototype.lesserOrEquals = SmallInteger.prototype.leq = SmallInteger.prototype.lesserOrEquals = BigInteger.prototype.leq = BigInteger.prototype.lesserOrEquals;
      BigInteger.prototype.isEven = function() {
        return (this.value[0] & 1) === 0;
      };
      SmallInteger.prototype.isEven = function() {
        return (this.value & 1) === 0;
      };
      NativeBigInt.prototype.isEven = function() {
        return (this.value & BigInt(1)) === BigInt(0);
      };
      BigInteger.prototype.isOdd = function() {
        return (this.value[0] & 1) === 1;
      };
      SmallInteger.prototype.isOdd = function() {
        return (this.value & 1) === 1;
      };
      NativeBigInt.prototype.isOdd = function() {
        return (this.value & BigInt(1)) === BigInt(1);
      };
      BigInteger.prototype.isPositive = function() {
        return !this.sign;
      };
      SmallInteger.prototype.isPositive = function() {
        return this.value > 0;
      };
      NativeBigInt.prototype.isPositive = SmallInteger.prototype.isPositive;
      BigInteger.prototype.isNegative = function() {
        return this.sign;
      };
      SmallInteger.prototype.isNegative = function() {
        return this.value < 0;
      };
      NativeBigInt.prototype.isNegative = SmallInteger.prototype.isNegative;
      BigInteger.prototype.isUnit = function() {
        return false;
      };
      SmallInteger.prototype.isUnit = function() {
        return Math.abs(this.value) === 1;
      };
      NativeBigInt.prototype.isUnit = function() {
        return this.abs().value === BigInt(1);
      };
      BigInteger.prototype.isZero = function() {
        return false;
      };
      SmallInteger.prototype.isZero = function() {
        return this.value === 0;
      };
      NativeBigInt.prototype.isZero = function() {
        return this.value === BigInt(0);
      };
      BigInteger.prototype.isDivisibleBy = function(v3) {
        var n2 = parseValue(v3);
        if (n2.isZero())
          return false;
        if (n2.isUnit())
          return true;
        if (n2.compareAbs(2) === 0)
          return this.isEven();
        return this.mod(n2).isZero();
      };
      NativeBigInt.prototype.isDivisibleBy = SmallInteger.prototype.isDivisibleBy = BigInteger.prototype.isDivisibleBy;
      function isBasicPrime(v3) {
        var n2 = v3.abs();
        if (n2.isUnit())
          return false;
        if (n2.equals(2) || n2.equals(3) || n2.equals(5))
          return true;
        if (n2.isEven() || n2.isDivisibleBy(3) || n2.isDivisibleBy(5))
          return false;
        if (n2.lesser(49))
          return true;
      }
      function millerRabinTest(n2, a4) {
        var nPrev = n2.prev(), b4 = nPrev, r3 = 0, d4, t4, i5, x5;
        while (b4.isEven())
          b4 = b4.divide(2), r3++;
        next:
          for (i5 = 0; i5 < a4.length; i5++) {
            if (n2.lesser(a4[i5]))
              continue;
            x5 = bigInt(a4[i5]).modPow(b4, n2);
            if (x5.isUnit() || x5.equals(nPrev))
              continue;
            for (d4 = r3 - 1; d4 != 0; d4--) {
              x5 = x5.square().mod(n2);
              if (x5.isUnit())
                return false;
              if (x5.equals(nPrev))
                continue next;
            }
            return false;
          }
        return true;
      }
      BigInteger.prototype.isPrime = function(strict) {
        var isPrime = isBasicPrime(this);
        if (isPrime !== undefined2)
          return isPrime;
        var n2 = this.abs();
        var bits = n2.bitLength();
        if (bits <= 64)
          return millerRabinTest(n2, [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37]);
        var logN = Math.log(2) * bits.toJSNumber();
        var t4 = Math.ceil(strict === true ? 2 * Math.pow(logN, 2) : logN);
        for (var a4 = [], i5 = 0; i5 < t4; i5++) {
          a4.push(bigInt(i5 + 2));
        }
        return millerRabinTest(n2, a4);
      };
      NativeBigInt.prototype.isPrime = SmallInteger.prototype.isPrime = BigInteger.prototype.isPrime;
      BigInteger.prototype.isProbablePrime = function(iterations, rng) {
        var isPrime = isBasicPrime(this);
        if (isPrime !== undefined2)
          return isPrime;
        var n2 = this.abs();
        var t4 = iterations === undefined2 ? 5 : iterations;
        for (var a4 = [], i5 = 0; i5 < t4; i5++) {
          a4.push(bigInt.randBetween(2, n2.minus(2), rng));
        }
        return millerRabinTest(n2, a4);
      };
      NativeBigInt.prototype.isProbablePrime = SmallInteger.prototype.isProbablePrime = BigInteger.prototype.isProbablePrime;
      BigInteger.prototype.modInv = function(n2) {
        var t4 = bigInt.zero, newT = bigInt.one, r3 = parseValue(n2), newR = this.abs(), q5, lastT, lastR;
        while (!newR.isZero()) {
          q5 = r3.divide(newR);
          lastT = t4;
          lastR = r3;
          t4 = newT;
          r3 = newR;
          newT = lastT.subtract(q5.multiply(newT));
          newR = lastR.subtract(q5.multiply(newR));
        }
        if (!r3.isUnit())
          throw new Error(this.toString() + " and " + n2.toString() + " are not co-prime");
        if (t4.compare(0) === -1) {
          t4 = t4.add(n2);
        }
        if (this.isNegative()) {
          return t4.negate();
        }
        return t4;
      };
      NativeBigInt.prototype.modInv = SmallInteger.prototype.modInv = BigInteger.prototype.modInv;
      BigInteger.prototype.next = function() {
        var value = this.value;
        if (this.sign) {
          return subtractSmall(value, 1, this.sign);
        }
        return new BigInteger(addSmall(value, 1), this.sign);
      };
      SmallInteger.prototype.next = function() {
        var value = this.value;
        if (value + 1 < MAX_INT)
          return new SmallInteger(value + 1);
        return new BigInteger(MAX_INT_ARR, false);
      };
      NativeBigInt.prototype.next = function() {
        return new NativeBigInt(this.value + BigInt(1));
      };
      BigInteger.prototype.prev = function() {
        var value = this.value;
        if (this.sign) {
          return new BigInteger(addSmall(value, 1), true);
        }
        return subtractSmall(value, 1, this.sign);
      };
      SmallInteger.prototype.prev = function() {
        var value = this.value;
        if (value - 1 > -MAX_INT)
          return new SmallInteger(value - 1);
        return new BigInteger(MAX_INT_ARR, true);
      };
      NativeBigInt.prototype.prev = function() {
        return new NativeBigInt(this.value - BigInt(1));
      };
      var powersOfTwo = [1];
      while (2 * powersOfTwo[powersOfTwo.length - 1] <= BASE)
        powersOfTwo.push(2 * powersOfTwo[powersOfTwo.length - 1]);
      var powers2Length = powersOfTwo.length, highestPower2 = powersOfTwo[powers2Length - 1];
      function shift_isSmall(n2) {
        return Math.abs(n2) <= BASE;
      }
      BigInteger.prototype.shiftLeft = function(v3) {
        var n2 = parseValue(v3).toJSNumber();
        if (!shift_isSmall(n2)) {
          throw new Error(String(n2) + " is too large for shifting.");
        }
        if (n2 < 0)
          return this.shiftRight(-n2);
        var result = this;
        if (result.isZero())
          return result;
        while (n2 >= powers2Length) {
          result = result.multiply(highestPower2);
          n2 -= powers2Length - 1;
        }
        return result.multiply(powersOfTwo[n2]);
      };
      NativeBigInt.prototype.shiftLeft = SmallInteger.prototype.shiftLeft = BigInteger.prototype.shiftLeft;
      BigInteger.prototype.shiftRight = function(v3) {
        var remQuo;
        var n2 = parseValue(v3).toJSNumber();
        if (!shift_isSmall(n2)) {
          throw new Error(String(n2) + " is too large for shifting.");
        }
        if (n2 < 0)
          return this.shiftLeft(-n2);
        var result = this;
        while (n2 >= powers2Length) {
          if (result.isZero() || result.isNegative() && result.isUnit())
            return result;
          remQuo = divModAny(result, highestPower2);
          result = remQuo[1].isNegative() ? remQuo[0].prev() : remQuo[0];
          n2 -= powers2Length - 1;
        }
        remQuo = divModAny(result, powersOfTwo[n2]);
        return remQuo[1].isNegative() ? remQuo[0].prev() : remQuo[0];
      };
      NativeBigInt.prototype.shiftRight = SmallInteger.prototype.shiftRight = BigInteger.prototype.shiftRight;
      function bitwise(x5, y4, fn2) {
        y4 = parseValue(y4);
        var xSign = x5.isNegative(), ySign = y4.isNegative();
        var xRem = xSign ? x5.not() : x5, yRem = ySign ? y4.not() : y4;
        var xDigit = 0, yDigit = 0;
        var xDivMod = null, yDivMod = null;
        var result = [];
        while (!xRem.isZero() || !yRem.isZero()) {
          xDivMod = divModAny(xRem, highestPower2);
          xDigit = xDivMod[1].toJSNumber();
          if (xSign) {
            xDigit = highestPower2 - 1 - xDigit;
          }
          yDivMod = divModAny(yRem, highestPower2);
          yDigit = yDivMod[1].toJSNumber();
          if (ySign) {
            yDigit = highestPower2 - 1 - yDigit;
          }
          xRem = xDivMod[0];
          yRem = yDivMod[0];
          result.push(fn2(xDigit, yDigit));
        }
        var sum = fn2(xSign ? 1 : 0, ySign ? 1 : 0) !== 0 ? bigInt(-1) : bigInt(0);
        for (var i5 = result.length - 1; i5 >= 0; i5 -= 1) {
          sum = sum.multiply(highestPower2).add(bigInt(result[i5]));
        }
        return sum;
      }
      BigInteger.prototype.not = function() {
        return this.negate().prev();
      };
      NativeBigInt.prototype.not = SmallInteger.prototype.not = BigInteger.prototype.not;
      BigInteger.prototype.and = function(n2) {
        return bitwise(this, n2, function(a4, b4) {
          return a4 & b4;
        });
      };
      NativeBigInt.prototype.and = SmallInteger.prototype.and = BigInteger.prototype.and;
      BigInteger.prototype.or = function(n2) {
        return bitwise(this, n2, function(a4, b4) {
          return a4 | b4;
        });
      };
      NativeBigInt.prototype.or = SmallInteger.prototype.or = BigInteger.prototype.or;
      BigInteger.prototype.xor = function(n2) {
        return bitwise(this, n2, function(a4, b4) {
          return a4 ^ b4;
        });
      };
      NativeBigInt.prototype.xor = SmallInteger.prototype.xor = BigInteger.prototype.xor;
      var LOBMASK_I = 1 << 30, LOBMASK_BI = (BASE & -BASE) * (BASE & -BASE) | LOBMASK_I;
      function roughLOB(n2) {
        var v3 = n2.value, x5 = typeof v3 === "number" ? v3 | LOBMASK_I : typeof v3 === "bigint" ? v3 | BigInt(LOBMASK_I) : v3[0] + v3[1] * BASE | LOBMASK_BI;
        return x5 & -x5;
      }
      function integerLogarithm(value, base2) {
        if (base2.compareTo(value) <= 0) {
          var tmp = integerLogarithm(value, base2.square(base2));
          var p4 = tmp.p;
          var e4 = tmp.e;
          var t4 = p4.multiply(base2);
          return t4.compareTo(value) <= 0 ? { p: t4, e: e4 * 2 + 1 } : { p: p4, e: e4 * 2 };
        }
        return { p: bigInt(1), e: 0 };
      }
      BigInteger.prototype.bitLength = function() {
        var n2 = this;
        if (n2.compareTo(bigInt(0)) < 0) {
          n2 = n2.negate().subtract(bigInt(1));
        }
        if (n2.compareTo(bigInt(0)) === 0) {
          return bigInt(0);
        }
        return bigInt(integerLogarithm(n2, bigInt(2)).e).add(bigInt(1));
      };
      NativeBigInt.prototype.bitLength = SmallInteger.prototype.bitLength = BigInteger.prototype.bitLength;
      function max(a4, b4) {
        a4 = parseValue(a4);
        b4 = parseValue(b4);
        return a4.greater(b4) ? a4 : b4;
      }
      function min(a4, b4) {
        a4 = parseValue(a4);
        b4 = parseValue(b4);
        return a4.lesser(b4) ? a4 : b4;
      }
      function gcd(a4, b4) {
        a4 = parseValue(a4).abs();
        b4 = parseValue(b4).abs();
        if (a4.equals(b4))
          return a4;
        if (a4.isZero())
          return b4;
        if (b4.isZero())
          return a4;
        var c4 = Integer2[1], d4, t4;
        while (a4.isEven() && b4.isEven()) {
          d4 = min(roughLOB(a4), roughLOB(b4));
          a4 = a4.divide(d4);
          b4 = b4.divide(d4);
          c4 = c4.multiply(d4);
        }
        while (a4.isEven()) {
          a4 = a4.divide(roughLOB(a4));
        }
        do {
          while (b4.isEven()) {
            b4 = b4.divide(roughLOB(b4));
          }
          if (a4.greater(b4)) {
            t4 = b4;
            b4 = a4;
            a4 = t4;
          }
          b4 = b4.subtract(a4);
        } while (!b4.isZero());
        return c4.isUnit() ? a4 : a4.multiply(c4);
      }
      function lcm(a4, b4) {
        a4 = parseValue(a4).abs();
        b4 = parseValue(b4).abs();
        return a4.divide(gcd(a4, b4)).multiply(b4);
      }
      function randBetween(a4, b4, rng) {
        a4 = parseValue(a4);
        b4 = parseValue(b4);
        var usedRNG = rng || Math.random;
        var low = min(a4, b4), high = max(a4, b4);
        var range = high.subtract(low).add(1);
        if (range.isSmall)
          return low.add(Math.floor(usedRNG() * range));
        var digits = toBase(range, BASE).value;
        var result = [], restricted = true;
        for (var i5 = 0; i5 < digits.length; i5++) {
          var top = restricted ? digits[i5] + (i5 + 1 < digits.length ? digits[i5 + 1] / BASE : 0) : BASE;
          var digit = truncate(usedRNG() * top);
          result.push(digit);
          if (digit < digits[i5])
            restricted = false;
        }
        return low.add(Integer2.fromArray(result, BASE, false));
      }
      var parseBase = function(text, base2, alphabet, caseSensitive) {
        alphabet = alphabet || DEFAULT_ALPHABET;
        text = String(text);
        if (!caseSensitive) {
          text = text.toLowerCase();
          alphabet = alphabet.toLowerCase();
        }
        var length = text.length;
        var i5;
        var absBase = Math.abs(base2);
        var alphabetValues = {};
        for (i5 = 0; i5 < alphabet.length; i5++) {
          alphabetValues[alphabet[i5]] = i5;
        }
        for (i5 = 0; i5 < length; i5++) {
          var c4 = text[i5];
          if (c4 === "-")
            continue;
          if (c4 in alphabetValues) {
            if (alphabetValues[c4] >= absBase) {
              if (c4 === "1" && absBase === 1)
                continue;
              throw new Error(c4 + " is not a valid digit in base " + base2 + ".");
            }
          }
        }
        base2 = parseValue(base2);
        var digits = [];
        var isNegative = text[0] === "-";
        for (i5 = isNegative ? 1 : 0; i5 < text.length; i5++) {
          var c4 = text[i5];
          if (c4 in alphabetValues)
            digits.push(parseValue(alphabetValues[c4]));
          else if (c4 === "<") {
            var start = i5;
            do {
              i5++;
            } while (text[i5] !== ">" && i5 < text.length);
            digits.push(parseValue(text.slice(start + 1, i5)));
          } else
            throw new Error(c4 + " is not a valid character");
        }
        return parseBaseFromArray(digits, base2, isNegative);
      };
      function parseBaseFromArray(digits, base2, isNegative) {
        var val = Integer2[0], pow = Integer2[1], i5;
        for (i5 = digits.length - 1; i5 >= 0; i5--) {
          val = val.add(digits[i5].times(pow));
          pow = pow.times(base2);
        }
        return isNegative ? val.negate() : val;
      }
      function stringify(digit, alphabet) {
        alphabet = alphabet || DEFAULT_ALPHABET;
        if (digit < alphabet.length) {
          return alphabet[digit];
        }
        return "<" + digit + ">";
      }
      function toBase(n2, base2) {
        base2 = bigInt(base2);
        if (base2.isZero()) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          throw new Error("Cannot convert nonzero numbers to base 0.");
        }
        if (base2.equals(-1)) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          if (n2.isNegative())
            return {
              value: [].concat.apply(
                [],
                Array.apply(null, Array(-n2.toJSNumber())).map(Array.prototype.valueOf, [1, 0])
              ),
              isNegative: false
            };
          var arr = Array.apply(null, Array(n2.toJSNumber() - 1)).map(Array.prototype.valueOf, [0, 1]);
          arr.unshift([1]);
          return {
            value: [].concat.apply([], arr),
            isNegative: false
          };
        }
        var neg = false;
        if (n2.isNegative() && base2.isPositive()) {
          neg = true;
          n2 = n2.abs();
        }
        if (base2.isUnit()) {
          if (n2.isZero())
            return { value: [0], isNegative: false };
          return {
            value: Array.apply(null, Array(n2.toJSNumber())).map(Number.prototype.valueOf, 1),
            isNegative: neg
          };
        }
        var out = [];
        var left = n2, divmod;
        while (left.isNegative() || left.compareAbs(base2) >= 0) {
          divmod = left.divmod(base2);
          left = divmod.quotient;
          var digit = divmod.remainder;
          if (digit.isNegative()) {
            digit = base2.minus(digit).abs();
            left = left.next();
          }
          out.push(digit.toJSNumber());
        }
        out.push(left.toJSNumber());
        return { value: out.reverse(), isNegative: neg };
      }
      function toBaseString(n2, base2, alphabet) {
        var arr = toBase(n2, base2);
        return (arr.isNegative ? "-" : "") + arr.value.map(function(x5) {
          return stringify(x5, alphabet);
        }).join("");
      }
      BigInteger.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      SmallInteger.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      NativeBigInt.prototype.toArray = function(radix) {
        return toBase(this, radix);
      };
      BigInteger.prototype.toString = function(radix, alphabet) {
        if (radix === undefined2)
          radix = 10;
        if (radix !== 10 || alphabet)
          return toBaseString(this, radix, alphabet);
        var v3 = this.value, l3 = v3.length, str = String(v3[--l3]), zeros = "0000000", digit;
        while (--l3 >= 0) {
          digit = String(v3[l3]);
          str += zeros.slice(digit.length) + digit;
        }
        var sign2 = this.sign ? "-" : "";
        return sign2 + str;
      };
      SmallInteger.prototype.toString = function(radix, alphabet) {
        if (radix === undefined2)
          radix = 10;
        if (radix != 10 || alphabet)
          return toBaseString(this, radix, alphabet);
        return String(this.value);
      };
      NativeBigInt.prototype.toString = SmallInteger.prototype.toString;
      NativeBigInt.prototype.toJSON = BigInteger.prototype.toJSON = SmallInteger.prototype.toJSON = function() {
        return this.toString();
      };
      BigInteger.prototype.valueOf = function() {
        return parseInt(this.toString(), 10);
      };
      BigInteger.prototype.toJSNumber = BigInteger.prototype.valueOf;
      SmallInteger.prototype.valueOf = function() {
        return this.value;
      };
      SmallInteger.prototype.toJSNumber = SmallInteger.prototype.valueOf;
      NativeBigInt.prototype.valueOf = NativeBigInt.prototype.toJSNumber = function() {
        return parseInt(this.toString(), 10);
      };
      function parseStringValue(v3) {
        if (isPrecise(+v3)) {
          var x5 = +v3;
          if (x5 === truncate(x5))
            return supportsNativeBigInt ? new NativeBigInt(BigInt(x5)) : new SmallInteger(x5);
          throw new Error("Invalid integer: " + v3);
        }
        var sign2 = v3[0] === "-";
        if (sign2)
          v3 = v3.slice(1);
        var split = v3.split(/e/i);
        if (split.length > 2)
          throw new Error("Invalid integer: " + split.join("e"));
        if (split.length === 2) {
          var exp = split[1];
          if (exp[0] === "+")
            exp = exp.slice(1);
          exp = +exp;
          if (exp !== truncate(exp) || !isPrecise(exp))
            throw new Error("Invalid integer: " + exp + " is not a valid exponent.");
          var text = split[0];
          var decimalPlace = text.indexOf(".");
          if (decimalPlace >= 0) {
            exp -= text.length - decimalPlace - 1;
            text = text.slice(0, decimalPlace) + text.slice(decimalPlace + 1);
          }
          if (exp < 0)
            throw new Error("Cannot include negative exponent part for integers");
          text += new Array(exp + 1).join("0");
          v3 = text;
        }
        var isValid3 = /^([0-9][0-9]*)$/.test(v3);
        if (!isValid3)
          throw new Error("Invalid integer: " + v3);
        if (supportsNativeBigInt) {
          return new NativeBigInt(BigInt(sign2 ? "-" + v3 : v3));
        }
        var r3 = [], max2 = v3.length, l3 = LOG_BASE, min2 = max2 - l3;
        while (max2 > 0) {
          r3.push(+v3.slice(min2, max2));
          min2 -= l3;
          if (min2 < 0)
            min2 = 0;
          max2 -= l3;
        }
        trim(r3);
        return new BigInteger(r3, sign2);
      }
      function parseNumberValue(v3) {
        if (supportsNativeBigInt) {
          return new NativeBigInt(BigInt(v3));
        }
        if (isPrecise(v3)) {
          if (v3 !== truncate(v3))
            throw new Error(v3 + " is not an integer.");
          return new SmallInteger(v3);
        }
        return parseStringValue(v3.toString());
      }
      function parseValue(v3) {
        if (typeof v3 === "number") {
          return parseNumberValue(v3);
        }
        if (typeof v3 === "string") {
          return parseStringValue(v3);
        }
        if (typeof v3 === "bigint") {
          return new NativeBigInt(v3);
        }
        return v3;
      }
      for (var i4 = 0; i4 < 1e3; i4++) {
        Integer2[i4] = parseValue(i4);
        if (i4 > 0)
          Integer2[-i4] = parseValue(-i4);
      }
      Integer2.one = Integer2[1];
      Integer2.zero = Integer2[0];
      Integer2.minusOne = Integer2[-1];
      Integer2.max = max;
      Integer2.min = min;
      Integer2.gcd = gcd;
      Integer2.lcm = lcm;
      Integer2.isInstance = function(x5) {
        return x5 instanceof BigInteger || x5 instanceof SmallInteger || x5 instanceof NativeBigInt;
      };
      Integer2.randBetween = randBetween;
      Integer2.fromArray = function(digits, base2, isNegative) {
        return parseBaseFromArray(digits.map(parseValue), parseValue(base2 || 10), isNegative);
      };
      return Integer2;
    }();
    if (typeof module !== "undefined" && module.hasOwnProperty("exports")) {
      module.exports = bigInt;
    }
    if (typeof define === "function" && define.amd) {
      define(function() {
        return bigInt;
      });
    }
  }
});

// ../../node_modules/.pnpm/jed@1.1.1/node_modules/jed/jed.js
var require_jed = __commonJS({
  "../../node_modules/.pnpm/jed@1.1.1/node_modules/jed/jed.js"(exports, module) {
    (function(root, undef) {
      var ArrayProto = Array.prototype, ObjProto = Object.prototype, slice = ArrayProto.slice, hasOwnProp = ObjProto.hasOwnProperty, nativeForEach = ArrayProto.forEach, breaker = {};
      var _3 = {
        forEach: function(obj, iterator, context) {
          var i4, l3, key;
          if (obj === null) {
            return;
          }
          if (nativeForEach && obj.forEach === nativeForEach) {
            obj.forEach(iterator, context);
          } else if (obj.length === +obj.length) {
            for (i4 = 0, l3 = obj.length; i4 < l3; i4++) {
              if (i4 in obj && iterator.call(context, obj[i4], i4, obj) === breaker) {
                return;
              }
            }
          } else {
            for (key in obj) {
              if (hasOwnProp.call(obj, key)) {
                if (iterator.call(context, obj[key], key, obj) === breaker) {
                  return;
                }
              }
            }
          }
        },
        extend: function(obj) {
          this.forEach(slice.call(arguments, 1), function(source) {
            for (var prop in source) {
              obj[prop] = source[prop];
            }
          });
          return obj;
        }
      };
      var Jed2 = function(options) {
        this.defaults = {
          "locale_data": {
            "messages": {
              "": {
                "domain": "messages",
                "lang": "en",
                "plural_forms": "nplurals=2; plural=(n != 1);"
              }
              // There are no default keys, though
            }
          },
          // The default domain if one is missing
          "domain": "messages",
          // enable debug mode to log untranslated strings to the console
          "debug": false
        };
        this.options = _3.extend({}, this.defaults, options);
        this.textdomain(this.options.domain);
        if (options.domain && !this.options.locale_data[this.options.domain]) {
          throw new Error("Text domain set to non-existent domain: `" + options.domain + "`");
        }
      };
      Jed2.context_delimiter = String.fromCharCode(4);
      function getPluralFormFunc(plural_form_string) {
        return Jed2.PF.compile(plural_form_string || "nplurals=2; plural=(n != 1);");
      }
      function Chain(key, i18n2) {
        this._key = key;
        this._i18n = i18n2;
      }
      _3.extend(Chain.prototype, {
        onDomain: function(domain) {
          this._domain = domain;
          return this;
        },
        withContext: function(context) {
          this._context = context;
          return this;
        },
        ifPlural: function(num, pkey) {
          this._val = num;
          this._pkey = pkey;
          return this;
        },
        fetch: function(sArr) {
          if ({}.toString.call(sArr) != "[object Array]") {
            sArr = [].slice.call(arguments, 0);
          }
          return (sArr && sArr.length ? Jed2.sprintf : function(x5) {
            return x5;
          })(
            this._i18n.dcnpgettext(this._domain, this._context, this._key, this._pkey, this._val),
            sArr
          );
        }
      });
      _3.extend(Jed2.prototype, {
        // The sexier api start point
        translate: function(key) {
          return new Chain(key, this);
        },
        textdomain: function(domain) {
          if (!domain) {
            return this._textdomain;
          }
          this._textdomain = domain;
        },
        gettext: function(key) {
          return this.dcnpgettext.call(this, undef, undef, key);
        },
        dgettext: function(domain, key) {
          return this.dcnpgettext.call(this, domain, undef, key);
        },
        dcgettext: function(domain, key) {
          return this.dcnpgettext.call(this, domain, undef, key);
        },
        ngettext: function(skey, pkey, val) {
          return this.dcnpgettext.call(this, undef, undef, skey, pkey, val);
        },
        dngettext: function(domain, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, undef, skey, pkey, val);
        },
        dcngettext: function(domain, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, undef, skey, pkey, val);
        },
        pgettext: function(context, key) {
          return this.dcnpgettext.call(this, undef, context, key);
        },
        dpgettext: function(domain, context, key) {
          return this.dcnpgettext.call(this, domain, context, key);
        },
        dcpgettext: function(domain, context, key) {
          return this.dcnpgettext.call(this, domain, context, key);
        },
        npgettext: function(context, skey, pkey, val) {
          return this.dcnpgettext.call(this, undef, context, skey, pkey, val);
        },
        dnpgettext: function(domain, context, skey, pkey, val) {
          return this.dcnpgettext.call(this, domain, context, skey, pkey, val);
        },
        // The most fully qualified gettext function. It has every option.
        // Since it has every option, we can use it from every other method.
        // This is the bread and butter.
        // Technically there should be one more argument in this function for 'Category',
        // but since we never use it, we might as well not waste the bytes to define it.
        dcnpgettext: function(domain, context, singular_key, plural_key, val) {
          plural_key = plural_key || singular_key;
          domain = domain || this._textdomain;
          var fallback;
          if (!this.options) {
            fallback = new Jed2();
            return fallback.dcnpgettext.call(fallback, void 0, void 0, singular_key, plural_key, val);
          }
          if (!this.options.locale_data) {
            throw new Error("No locale data provided.");
          }
          if (!this.options.locale_data[domain]) {
            throw new Error("Domain `" + domain + "` was not found.");
          }
          if (!this.options.locale_data[domain][""]) {
            throw new Error("No locale meta information provided.");
          }
          if (!singular_key) {
            throw new Error("No translation key found.");
          }
          var key = context ? context + Jed2.context_delimiter + singular_key : singular_key, locale_data = this.options.locale_data, dict = locale_data[domain], defaultConf = (locale_data.messages || this.defaults.locale_data.messages)[""], pluralForms = dict[""].plural_forms || dict[""]["Plural-Forms"] || dict[""]["plural-forms"] || defaultConf.plural_forms || defaultConf["Plural-Forms"] || defaultConf["plural-forms"], val_list, res;
          var val_idx;
          if (val === void 0) {
            val_idx = 0;
          } else {
            if (typeof val != "number") {
              val = parseInt(val, 10);
              if (isNaN(val)) {
                throw new Error("The number that was passed in is not a number.");
              }
            }
            val_idx = getPluralFormFunc(pluralForms)(val);
          }
          if (!dict) {
            throw new Error("No domain named `" + domain + "` could be found.");
          }
          val_list = dict[key];
          if (!val_list || val_idx > val_list.length) {
            if (this.options.missing_key_callback) {
              this.options.missing_key_callback(key, domain);
            }
            res = [singular_key, plural_key];
            if (this.options.debug === true) {
              console.log(res[getPluralFormFunc(pluralForms)(val)]);
            }
            return res[getPluralFormFunc()(val)];
          }
          res = val_list[val_idx];
          if (!res) {
            res = [singular_key, plural_key];
            return res[getPluralFormFunc()(val)];
          }
          return res;
        }
      });
      var sprintf = function() {
        function get_type(variable) {
          return Object.prototype.toString.call(variable).slice(8, -1).toLowerCase();
        }
        function str_repeat(input, multiplier) {
          for (var output = []; multiplier > 0; output[--multiplier] = input) {
          }
          return output.join("");
        }
        var str_format = function() {
          if (!str_format.cache.hasOwnProperty(arguments[0])) {
            str_format.cache[arguments[0]] = str_format.parse(arguments[0]);
          }
          return str_format.format.call(null, str_format.cache[arguments[0]], arguments);
        };
        str_format.format = function(parse_tree, argv) {
          var cursor = 1, tree_length = parse_tree.length, node_type = "", arg, output = [], i4, k5, match6, pad, pad_character, pad_length;
          for (i4 = 0; i4 < tree_length; i4++) {
            node_type = get_type(parse_tree[i4]);
            if (node_type === "string") {
              output.push(parse_tree[i4]);
            } else if (node_type === "array") {
              match6 = parse_tree[i4];
              if (match6[2]) {
                arg = argv[cursor];
                for (k5 = 0; k5 < match6[2].length; k5++) {
                  if (!arg.hasOwnProperty(match6[2][k5])) {
                    throw sprintf('[sprintf] property "%s" does not exist', match6[2][k5]);
                  }
                  arg = arg[match6[2][k5]];
                }
              } else if (match6[1]) {
                arg = argv[match6[1]];
              } else {
                arg = argv[cursor++];
              }
              if (/[^s]/.test(match6[8]) && get_type(arg) != "number") {
                throw sprintf("[sprintf] expecting number but found %s", get_type(arg));
              }
              if (typeof arg == "undefined" || arg === null) {
                arg = "";
              }
              switch (match6[8]) {
                case "b":
                  arg = arg.toString(2);
                  break;
                case "c":
                  arg = String.fromCharCode(arg);
                  break;
                case "d":
                  arg = parseInt(arg, 10);
                  break;
                case "e":
                  arg = match6[7] ? arg.toExponential(match6[7]) : arg.toExponential();
                  break;
                case "f":
                  arg = match6[7] ? parseFloat(arg).toFixed(match6[7]) : parseFloat(arg);
                  break;
                case "o":
                  arg = arg.toString(8);
                  break;
                case "s":
                  arg = (arg = String(arg)) && match6[7] ? arg.substring(0, match6[7]) : arg;
                  break;
                case "u":
                  arg = Math.abs(arg);
                  break;
                case "x":
                  arg = arg.toString(16);
                  break;
                case "X":
                  arg = arg.toString(16).toUpperCase();
                  break;
              }
              arg = /[def]/.test(match6[8]) && match6[3] && arg >= 0 ? "+" + arg : arg;
              pad_character = match6[4] ? match6[4] == "0" ? "0" : match6[4].charAt(1) : " ";
              pad_length = match6[6] - String(arg).length;
              pad = match6[6] ? str_repeat(pad_character, pad_length) : "";
              output.push(match6[5] ? arg + pad : pad + arg);
            }
          }
          return output.join("");
        };
        str_format.cache = {};
        str_format.parse = function(fmt) {
          var _fmt = fmt, match6 = [], parse_tree = [], arg_names = 0;
          while (_fmt) {
            if ((match6 = /^[^\x25]+/.exec(_fmt)) !== null) {
              parse_tree.push(match6[0]);
            } else if ((match6 = /^\x25{2}/.exec(_fmt)) !== null) {
              parse_tree.push("%");
            } else if ((match6 = /^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-fosuxX])/.exec(_fmt)) !== null) {
              if (match6[2]) {
                arg_names |= 1;
                var field_list = [], replacement_field = match6[2], field_match = [];
                if ((field_match = /^([a-z_][a-z_\d]*)/i.exec(replacement_field)) !== null) {
                  field_list.push(field_match[1]);
                  while ((replacement_field = replacement_field.substring(field_match[0].length)) !== "") {
                    if ((field_match = /^\.([a-z_][a-z_\d]*)/i.exec(replacement_field)) !== null) {
                      field_list.push(field_match[1]);
                    } else if ((field_match = /^\[(\d+)\]/.exec(replacement_field)) !== null) {
                      field_list.push(field_match[1]);
                    } else {
                      throw "[sprintf] huh?";
                    }
                  }
                } else {
                  throw "[sprintf] huh?";
                }
                match6[2] = field_list;
              } else {
                arg_names |= 2;
              }
              if (arg_names === 3) {
                throw "[sprintf] mixing positional and named placeholders is not (yet) supported";
              }
              parse_tree.push(match6);
            } else {
              throw "[sprintf] huh?";
            }
            _fmt = _fmt.substring(match6[0].length);
          }
          return parse_tree;
        };
        return str_format;
      }();
      var vsprintf = function(fmt, argv) {
        argv.unshift(fmt);
        return sprintf.apply(null, argv);
      };
      Jed2.parse_plural = function(plural_forms, n2) {
        plural_forms = plural_forms.replace(/n/g, n2);
        return Jed2.parse_expression(plural_forms);
      };
      Jed2.sprintf = function(fmt, args) {
        if ({}.toString.call(args) == "[object Array]") {
          return vsprintf(fmt, [].slice.call(args));
        }
        return sprintf.apply(this, [].slice.call(arguments));
      };
      Jed2.prototype.sprintf = function() {
        return Jed2.sprintf.apply(this, arguments);
      };
      Jed2.PF = {};
      Jed2.PF.parse = function(p4) {
        var plural_str = Jed2.PF.extractPluralExpr(p4);
        return Jed2.PF.parser.parse.call(Jed2.PF.parser, plural_str);
      };
      Jed2.PF.compile = function(p4) {
        function imply(val) {
          return val === true ? 1 : val ? val : 0;
        }
        var ast = Jed2.PF.parse(p4);
        return function(n2) {
          return imply(Jed2.PF.interpreter(ast)(n2));
        };
      };
      Jed2.PF.interpreter = function(ast) {
        return function(n2) {
          var res;
          switch (ast.type) {
            case "GROUP":
              return Jed2.PF.interpreter(ast.expr)(n2);
            case "TERNARY":
              if (Jed2.PF.interpreter(ast.expr)(n2)) {
                return Jed2.PF.interpreter(ast.truthy)(n2);
              }
              return Jed2.PF.interpreter(ast.falsey)(n2);
            case "OR":
              return Jed2.PF.interpreter(ast.left)(n2) || Jed2.PF.interpreter(ast.right)(n2);
            case "AND":
              return Jed2.PF.interpreter(ast.left)(n2) && Jed2.PF.interpreter(ast.right)(n2);
            case "LT":
              return Jed2.PF.interpreter(ast.left)(n2) < Jed2.PF.interpreter(ast.right)(n2);
            case "GT":
              return Jed2.PF.interpreter(ast.left)(n2) > Jed2.PF.interpreter(ast.right)(n2);
            case "LTE":
              return Jed2.PF.interpreter(ast.left)(n2) <= Jed2.PF.interpreter(ast.right)(n2);
            case "GTE":
              return Jed2.PF.interpreter(ast.left)(n2) >= Jed2.PF.interpreter(ast.right)(n2);
            case "EQ":
              return Jed2.PF.interpreter(ast.left)(n2) == Jed2.PF.interpreter(ast.right)(n2);
            case "NEQ":
              return Jed2.PF.interpreter(ast.left)(n2) != Jed2.PF.interpreter(ast.right)(n2);
            case "MOD":
              return Jed2.PF.interpreter(ast.left)(n2) % Jed2.PF.interpreter(ast.right)(n2);
            case "VAR":
              return n2;
            case "NUM":
              return ast.val;
            default:
              throw new Error("Invalid Token found.");
          }
        };
      };
      Jed2.PF.extractPluralExpr = function(p4) {
        p4 = p4.replace(/^\s\s*/, "").replace(/\s\s*$/, "");
        if (!/;\s*$/.test(p4)) {
          p4 = p4.concat(";");
        }
        var nplurals_re = /nplurals\=(\d+);/, plural_re = /plural\=(.*);/, nplurals_matches = p4.match(nplurals_re), res = {}, plural_matches;
        if (nplurals_matches.length > 1) {
          res.nplurals = nplurals_matches[1];
        } else {
          throw new Error("nplurals not found in plural_forms string: " + p4);
        }
        p4 = p4.replace(nplurals_re, "");
        plural_matches = p4.match(plural_re);
        if (!(plural_matches && plural_matches.length > 1)) {
          throw new Error("`plural` expression not found: " + p4);
        }
        return plural_matches[1];
      };
      Jed2.PF.parser = function() {
        var parser = {
          trace: function trace() {
          },
          yy: {},
          symbols_: { "error": 2, "expressions": 3, "e": 4, "EOF": 5, "?": 6, ":": 7, "||": 8, "&&": 9, "<": 10, "<=": 11, ">": 12, ">=": 13, "!=": 14, "==": 15, "%": 16, "(": 17, ")": 18, "n": 19, "NUMBER": 20, "$accept": 0, "$end": 1 },
          terminals_: { 2: "error", 5: "EOF", 6: "?", 7: ":", 8: "||", 9: "&&", 10: "<", 11: "<=", 12: ">", 13: ">=", 14: "!=", 15: "==", 16: "%", 17: "(", 18: ")", 19: "n", 20: "NUMBER" },
          productions_: [0, [3, 2], [4, 5], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 3], [4, 1], [4, 1]],
          performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
            var $0 = $$.length - 1;
            switch (yystate) {
              case 1:
                return { type: "GROUP", expr: $$[$0 - 1] };
                break;
              case 2:
                this.$ = { type: "TERNARY", expr: $$[$0 - 4], truthy: $$[$0 - 2], falsey: $$[$0] };
                break;
              case 3:
                this.$ = { type: "OR", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 4:
                this.$ = { type: "AND", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 5:
                this.$ = { type: "LT", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 6:
                this.$ = { type: "LTE", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 7:
                this.$ = { type: "GT", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 8:
                this.$ = { type: "GTE", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 9:
                this.$ = { type: "NEQ", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 10:
                this.$ = { type: "EQ", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 11:
                this.$ = { type: "MOD", left: $$[$0 - 2], right: $$[$0] };
                break;
              case 12:
                this.$ = { type: "GROUP", expr: $$[$0 - 1] };
                break;
              case 13:
                this.$ = { type: "VAR" };
                break;
              case 14:
                this.$ = { type: "NUM", val: Number(yytext) };
                break;
            }
          },
          table: [{ 3: 1, 4: 2, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 1: [3] }, { 5: [1, 6], 6: [1, 7], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16] }, { 4: 17, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 5: [2, 13], 6: [2, 13], 7: [2, 13], 8: [2, 13], 9: [2, 13], 10: [2, 13], 11: [2, 13], 12: [2, 13], 13: [2, 13], 14: [2, 13], 15: [2, 13], 16: [2, 13], 18: [2, 13] }, { 5: [2, 14], 6: [2, 14], 7: [2, 14], 8: [2, 14], 9: [2, 14], 10: [2, 14], 11: [2, 14], 12: [2, 14], 13: [2, 14], 14: [2, 14], 15: [2, 14], 16: [2, 14], 18: [2, 14] }, { 1: [2, 1] }, { 4: 18, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 19, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 20, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 21, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 22, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 23, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 24, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 25, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 26, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 4: 27, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 6: [1, 7], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [1, 28] }, { 6: [1, 7], 7: [1, 29], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16] }, { 5: [2, 3], 6: [2, 3], 7: [2, 3], 8: [2, 3], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 3] }, { 5: [2, 4], 6: [2, 4], 7: [2, 4], 8: [2, 4], 9: [2, 4], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 4] }, { 5: [2, 5], 6: [2, 5], 7: [2, 5], 8: [2, 5], 9: [2, 5], 10: [2, 5], 11: [2, 5], 12: [2, 5], 13: [2, 5], 14: [2, 5], 15: [2, 5], 16: [1, 16], 18: [2, 5] }, { 5: [2, 6], 6: [2, 6], 7: [2, 6], 8: [2, 6], 9: [2, 6], 10: [2, 6], 11: [2, 6], 12: [2, 6], 13: [2, 6], 14: [2, 6], 15: [2, 6], 16: [1, 16], 18: [2, 6] }, { 5: [2, 7], 6: [2, 7], 7: [2, 7], 8: [2, 7], 9: [2, 7], 10: [2, 7], 11: [2, 7], 12: [2, 7], 13: [2, 7], 14: [2, 7], 15: [2, 7], 16: [1, 16], 18: [2, 7] }, { 5: [2, 8], 6: [2, 8], 7: [2, 8], 8: [2, 8], 9: [2, 8], 10: [2, 8], 11: [2, 8], 12: [2, 8], 13: [2, 8], 14: [2, 8], 15: [2, 8], 16: [1, 16], 18: [2, 8] }, { 5: [2, 9], 6: [2, 9], 7: [2, 9], 8: [2, 9], 9: [2, 9], 10: [2, 9], 11: [2, 9], 12: [2, 9], 13: [2, 9], 14: [2, 9], 15: [2, 9], 16: [1, 16], 18: [2, 9] }, { 5: [2, 10], 6: [2, 10], 7: [2, 10], 8: [2, 10], 9: [2, 10], 10: [2, 10], 11: [2, 10], 12: [2, 10], 13: [2, 10], 14: [2, 10], 15: [2, 10], 16: [1, 16], 18: [2, 10] }, { 5: [2, 11], 6: [2, 11], 7: [2, 11], 8: [2, 11], 9: [2, 11], 10: [2, 11], 11: [2, 11], 12: [2, 11], 13: [2, 11], 14: [2, 11], 15: [2, 11], 16: [2, 11], 18: [2, 11] }, { 5: [2, 12], 6: [2, 12], 7: [2, 12], 8: [2, 12], 9: [2, 12], 10: [2, 12], 11: [2, 12], 12: [2, 12], 13: [2, 12], 14: [2, 12], 15: [2, 12], 16: [2, 12], 18: [2, 12] }, { 4: 30, 17: [1, 3], 19: [1, 4], 20: [1, 5] }, { 5: [2, 2], 6: [1, 7], 7: [2, 2], 8: [1, 8], 9: [1, 9], 10: [1, 10], 11: [1, 11], 12: [1, 12], 13: [1, 13], 14: [1, 14], 15: [1, 15], 16: [1, 16], 18: [2, 2] }],
          defaultActions: { 6: [2, 1] },
          parseError: function parseError(str, hash4) {
            throw new Error(str);
          },
          parse: function parse2(input) {
            var self2 = this, stack = [0], vstack = [null], lstack = [], table2 = this.table, yytext = "", yylineno = 0, yyleng = 0, recovering = 0, TERROR = 2, EOF = 1;
            this.lexer.setInput(input);
            this.lexer.yy = this.yy;
            this.yy.lexer = this.lexer;
            if (typeof this.lexer.yylloc == "undefined")
              this.lexer.yylloc = {};
            var yyloc = this.lexer.yylloc;
            lstack.push(yyloc);
            if (typeof this.yy.parseError === "function")
              this.parseError = this.yy.parseError;
            function popStack(n2) {
              stack.length = stack.length - 2 * n2;
              vstack.length = vstack.length - n2;
              lstack.length = lstack.length - n2;
            }
            function lex() {
              var token;
              token = self2.lexer.lex() || 1;
              if (typeof token !== "number") {
                token = self2.symbols_[token] || token;
              }
              return token;
            }
            var symbol, preErrorSymbol, state, action, a4, r3, yyval = {}, p4, len, newState, expected;
            while (true) {
              state = stack[stack.length - 1];
              if (this.defaultActions[state]) {
                action = this.defaultActions[state];
              } else {
                if (symbol == null)
                  symbol = lex();
                action = table2[state] && table2[state][symbol];
              }
              _handle_error:
                if (typeof action === "undefined" || !action.length || !action[0]) {
                  if (!recovering) {
                    expected = [];
                    for (p4 in table2[state])
                      if (this.terminals_[p4] && p4 > 2) {
                        expected.push("'" + this.terminals_[p4] + "'");
                      }
                    var errStr = "";
                    if (this.lexer.showPosition) {
                      errStr = "Parse error on line " + (yylineno + 1) + ":\n" + this.lexer.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + this.terminals_[symbol] + "'";
                    } else {
                      errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == 1 ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
                    }
                    this.parseError(
                      errStr,
                      { text: this.lexer.match, token: this.terminals_[symbol] || symbol, line: this.lexer.yylineno, loc: yyloc, expected }
                    );
                  }
                  if (recovering == 3) {
                    if (symbol == EOF) {
                      throw new Error(errStr || "Parsing halted.");
                    }
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    symbol = lex();
                  }
                  while (1) {
                    if (TERROR.toString() in table2[state]) {
                      break;
                    }
                    if (state == 0) {
                      throw new Error(errStr || "Parsing halted.");
                    }
                    popStack(1);
                    state = stack[stack.length - 1];
                  }
                  preErrorSymbol = symbol;
                  symbol = TERROR;
                  state = stack[stack.length - 1];
                  action = table2[state] && table2[state][TERROR];
                  recovering = 3;
                }
              if (action[0] instanceof Array && action.length > 1) {
                throw new Error("Parse Error: multiple actions possible at state: " + state + ", token: " + symbol);
              }
              switch (action[0]) {
                case 1:
                  stack.push(symbol);
                  vstack.push(this.lexer.yytext);
                  lstack.push(this.lexer.yylloc);
                  stack.push(action[1]);
                  symbol = null;
                  if (!preErrorSymbol) {
                    yyleng = this.lexer.yyleng;
                    yytext = this.lexer.yytext;
                    yylineno = this.lexer.yylineno;
                    yyloc = this.lexer.yylloc;
                    if (recovering > 0)
                      recovering--;
                  } else {
                    symbol = preErrorSymbol;
                    preErrorSymbol = null;
                  }
                  break;
                case 2:
                  len = this.productions_[action[1]][1];
                  yyval.$ = vstack[vstack.length - len];
                  yyval._$ = {
                    first_line: lstack[lstack.length - (len || 1)].first_line,
                    last_line: lstack[lstack.length - 1].last_line,
                    first_column: lstack[lstack.length - (len || 1)].first_column,
                    last_column: lstack[lstack.length - 1].last_column
                  };
                  r3 = this.performAction.call(yyval, yytext, yyleng, yylineno, this.yy, action[1], vstack, lstack);
                  if (typeof r3 !== "undefined") {
                    return r3;
                  }
                  if (len) {
                    stack = stack.slice(0, -1 * len * 2);
                    vstack = vstack.slice(0, -1 * len);
                    lstack = lstack.slice(0, -1 * len);
                  }
                  stack.push(this.productions_[action[1]][0]);
                  vstack.push(yyval.$);
                  lstack.push(yyval._$);
                  newState = table2[stack[stack.length - 2]][stack[stack.length - 1]];
                  stack.push(newState);
                  break;
                case 3:
                  return true;
              }
            }
            return true;
          }
        };
        var lexer = function() {
          var lexer2 = {
            EOF: 1,
            parseError: function parseError(str, hash4) {
              if (this.yy.parseError) {
                this.yy.parseError(str, hash4);
              } else {
                throw new Error(str);
              }
            },
            setInput: function(input) {
              this._input = input;
              this._more = this._less = this.done = false;
              this.yylineno = this.yyleng = 0;
              this.yytext = this.matched = this.match = "";
              this.conditionStack = ["INITIAL"];
              this.yylloc = { first_line: 1, first_column: 0, last_line: 1, last_column: 0 };
              return this;
            },
            input: function() {
              var ch = this._input[0];
              this.yytext += ch;
              this.yyleng++;
              this.match += ch;
              this.matched += ch;
              var lines = ch.match(/\n/);
              if (lines)
                this.yylineno++;
              this._input = this._input.slice(1);
              return ch;
            },
            unput: function(ch) {
              this._input = ch + this._input;
              return this;
            },
            more: function() {
              this._more = true;
              return this;
            },
            pastInput: function() {
              var past = this.matched.substr(0, this.matched.length - this.match.length);
              return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
            },
            upcomingInput: function() {
              var next = this.match;
              if (next.length < 20) {
                next += this._input.substr(0, 20 - next.length);
              }
              return (next.substr(0, 20) + (next.length > 20 ? "..." : "")).replace(/\n/g, "");
            },
            showPosition: function() {
              var pre = this.pastInput();
              var c4 = new Array(pre.length + 1).join("-");
              return pre + this.upcomingInput() + "\n" + c4 + "^";
            },
            next: function() {
              if (this.done) {
                return this.EOF;
              }
              if (!this._input)
                this.done = true;
              var token, match6, col, lines;
              if (!this._more) {
                this.yytext = "";
                this.match = "";
              }
              var rules = this._currentRules();
              for (var i4 = 0; i4 < rules.length; i4++) {
                match6 = this._input.match(this.rules[rules[i4]]);
                if (match6) {
                  lines = match6[0].match(/\n.*/g);
                  if (lines)
                    this.yylineno += lines.length;
                  this.yylloc = {
                    first_line: this.yylloc.last_line,
                    last_line: this.yylineno + 1,
                    first_column: this.yylloc.last_column,
                    last_column: lines ? lines[lines.length - 1].length - 1 : this.yylloc.last_column + match6[0].length
                  };
                  this.yytext += match6[0];
                  this.match += match6[0];
                  this.matches = match6;
                  this.yyleng = this.yytext.length;
                  this._more = false;
                  this._input = this._input.slice(match6[0].length);
                  this.matched += match6[0];
                  token = this.performAction.call(this, this.yy, this, rules[i4], this.conditionStack[this.conditionStack.length - 1]);
                  if (token)
                    return token;
                  else
                    return;
                }
              }
              if (this._input === "") {
                return this.EOF;
              } else {
                this.parseError(
                  "Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(),
                  { text: "", token: null, line: this.yylineno }
                );
              }
            },
            lex: function lex() {
              var r3 = this.next();
              if (typeof r3 !== "undefined") {
                return r3;
              } else {
                return this.lex();
              }
            },
            begin: function begin(condition) {
              this.conditionStack.push(condition);
            },
            popState: function popState() {
              return this.conditionStack.pop();
            },
            _currentRules: function _currentRules() {
              return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
            },
            topState: function() {
              return this.conditionStack[this.conditionStack.length - 2];
            },
            pushState: function begin(condition) {
              this.begin(condition);
            }
          };
          lexer2.performAction = function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
            var YYSTATE = YY_START;
            switch ($avoiding_name_collisions) {
              case 0:
                break;
              case 1:
                return 20;
                break;
              case 2:
                return 19;
                break;
              case 3:
                return 8;
                break;
              case 4:
                return 9;
                break;
              case 5:
                return 6;
                break;
              case 6:
                return 7;
                break;
              case 7:
                return 11;
                break;
              case 8:
                return 13;
                break;
              case 9:
                return 10;
                break;
              case 10:
                return 12;
                break;
              case 11:
                return 14;
                break;
              case 12:
                return 15;
                break;
              case 13:
                return 16;
                break;
              case 14:
                return 17;
                break;
              case 15:
                return 18;
                break;
              case 16:
                return 5;
                break;
              case 17:
                return "INVALID";
                break;
            }
          };
          lexer2.rules = [/^\s+/, /^[0-9]+(\.[0-9]+)?\b/, /^n\b/, /^\|\|/, /^&&/, /^\?/, /^:/, /^<=/, /^>=/, /^</, /^>/, /^!=/, /^==/, /^%/, /^\(/, /^\)/, /^$/, /^./];
          lexer2.conditions = { "INITIAL": { "rules": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17], "inclusive": true } };
          return lexer2;
        }();
        parser.lexer = lexer;
        return parser;
      }();
      if (typeof exports !== "undefined") {
        if (typeof module !== "undefined" && module.exports) {
          exports = module.exports = Jed2;
        }
        exports.Jed = Jed2;
      } else {
        if (typeof define === "function" && define.amd) {
          define(function() {
            return Jed2;
          });
        }
        root["Jed"] = Jed2;
      }
    })(exports);
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/dist/preact.module.js
function s(n2, l3) {
  for (var u4 in l3)
    n2[u4] = l3[u4];
  return n2;
}
function a(n2) {
  var l3 = n2.parentNode;
  l3 && l3.removeChild(n2);
}
function h(l3, u4, i4) {
  var t4, o3, r3, f3 = {};
  for (r3 in u4)
    "key" == r3 ? t4 = u4[r3] : "ref" == r3 ? o3 = u4[r3] : f3[r3] = u4[r3];
  if (arguments.length > 2 && (f3.children = arguments.length > 3 ? n.call(arguments, 2) : i4), "function" == typeof l3 && null != l3.defaultProps)
    for (r3 in l3.defaultProps)
      void 0 === f3[r3] && (f3[r3] = l3.defaultProps[r3]);
  return v(l3, f3, t4, o3, null);
}
function v(n2, i4, t4, o3, r3) {
  var f3 = { type: n2, props: i4, key: t4, ref: o3, __k: null, __: null, __b: 0, __e: null, __d: void 0, __c: null, __h: null, constructor: void 0, __v: null == r3 ? ++u : r3 };
  return null == r3 && null != l.vnode && l.vnode(f3), f3;
}
function y() {
  return { current: null };
}
function p2(n2) {
  return n2.children;
}
function d(n2, l3) {
  this.props = n2, this.context = l3;
}
function _(n2, l3) {
  if (null == l3)
    return n2.__ ? _(n2.__, n2.__.__k.indexOf(n2) + 1) : null;
  for (var u4; l3 < n2.__k.length; l3++)
    if (null != (u4 = n2.__k[l3]) && null != u4.__e)
      return u4.__e;
  return "function" == typeof n2.type ? _(n2) : null;
}
function k(n2) {
  var l3, u4;
  if (null != (n2 = n2.__) && null != n2.__c) {
    for (n2.__e = n2.__c.base = null, l3 = 0; l3 < n2.__k.length; l3++)
      if (null != (u4 = n2.__k[l3]) && null != u4.__e) {
        n2.__e = n2.__c.base = u4.__e;
        break;
      }
    return k(n2);
  }
}
function b(n2) {
  (!n2.__d && (n2.__d = true) && t.push(n2) && !g.__r++ || o !== l.debounceRendering) && ((o = l.debounceRendering) || setTimeout)(g);
}
function g() {
  for (var n2; g.__r = t.length; )
    n2 = t.sort(function(n3, l3) {
      return n3.__v.__b - l3.__v.__b;
    }), t = [], n2.some(function(n3) {
      var l3, u4, i4, t4, o3, r3;
      n3.__d && (o3 = (t4 = (l3 = n3).__v).__e, (r3 = l3.__P) && (u4 = [], (i4 = s({}, t4)).__v = t4.__v + 1, j(r3, t4, i4, l3.__n, void 0 !== r3.ownerSVGElement, null != t4.__h ? [o3] : null, u4, null == o3 ? _(t4) : o3, t4.__h), z(u4, t4), t4.__e != o3 && k(t4)));
    });
}
function w(n2, l3, u4, i4, t4, o3, r3, c4, s4, a4) {
  var h3, y4, d4, k5, b4, g4, w5, x5 = i4 && i4.__k || e, C3 = x5.length;
  for (u4.__k = [], h3 = 0; h3 < l3.length; h3++)
    if (null != (k5 = u4.__k[h3] = null == (k5 = l3[h3]) || "boolean" == typeof k5 ? null : "string" == typeof k5 || "number" == typeof k5 || "bigint" == typeof k5 ? v(null, k5, null, null, k5) : Array.isArray(k5) ? v(p2, { children: k5 }, null, null, null) : k5.__b > 0 ? v(k5.type, k5.props, k5.key, k5.ref ? k5.ref : null, k5.__v) : k5)) {
      if (k5.__ = u4, k5.__b = u4.__b + 1, null === (d4 = x5[h3]) || d4 && k5.key == d4.key && k5.type === d4.type)
        x5[h3] = void 0;
      else
        for (y4 = 0; y4 < C3; y4++) {
          if ((d4 = x5[y4]) && k5.key == d4.key && k5.type === d4.type) {
            x5[y4] = void 0;
            break;
          }
          d4 = null;
        }
      j(n2, k5, d4 = d4 || f, t4, o3, r3, c4, s4, a4), b4 = k5.__e, (y4 = k5.ref) && d4.ref != y4 && (w5 || (w5 = []), d4.ref && w5.push(d4.ref, null, k5), w5.push(y4, k5.__c || b4, k5)), null != b4 ? (null == g4 && (g4 = b4), "function" == typeof k5.type && k5.__k === d4.__k ? k5.__d = s4 = m(k5, s4, n2) : s4 = A2(n2, k5, d4, x5, b4, s4), "function" == typeof u4.type && (u4.__d = s4)) : s4 && d4.__e == s4 && s4.parentNode != n2 && (s4 = _(d4));
    }
  for (u4.__e = g4, h3 = C3; h3--; )
    null != x5[h3] && N(x5[h3], x5[h3]);
  if (w5)
    for (h3 = 0; h3 < w5.length; h3++)
      M2(w5[h3], w5[++h3], w5[++h3]);
}
function m(n2, l3, u4) {
  for (var i4, t4 = n2.__k, o3 = 0; t4 && o3 < t4.length; o3++)
    (i4 = t4[o3]) && (i4.__ = n2, l3 = "function" == typeof i4.type ? m(i4, l3, u4) : A2(u4, i4, i4, t4, i4.__e, l3));
  return l3;
}
function x(n2, l3) {
  return l3 = l3 || [], null == n2 || "boolean" == typeof n2 || (Array.isArray(n2) ? n2.some(function(n3) {
    x(n3, l3);
  }) : l3.push(n2)), l3;
}
function A2(n2, l3, u4, i4, t4, o3) {
  var r3, f3, e4;
  if (void 0 !== l3.__d)
    r3 = l3.__d, l3.__d = void 0;
  else if (null == u4 || t4 != o3 || null == t4.parentNode)
    n:
      if (null == o3 || o3.parentNode !== n2)
        n2.appendChild(t4), r3 = null;
      else {
        for (f3 = o3, e4 = 0; (f3 = f3.nextSibling) && e4 < i4.length; e4 += 1)
          if (f3 == t4)
            break n;
        n2.insertBefore(t4, o3), r3 = o3;
      }
  return void 0 !== r3 ? r3 : t4.nextSibling;
}
function C(n2, l3, u4, i4, t4) {
  var o3;
  for (o3 in u4)
    "children" === o3 || "key" === o3 || o3 in l3 || H(n2, o3, null, u4[o3], i4);
  for (o3 in l3)
    t4 && "function" != typeof l3[o3] || "children" === o3 || "key" === o3 || "value" === o3 || "checked" === o3 || u4[o3] === l3[o3] || H(n2, o3, l3[o3], u4[o3], i4);
}
function $(n2, l3, u4) {
  "-" === l3[0] ? n2.setProperty(l3, u4) : n2[l3] = null == u4 ? "" : "number" != typeof u4 || c.test(l3) ? u4 : u4 + "px";
}
function H(n2, l3, u4, i4, t4) {
  var o3;
  n:
    if ("style" === l3)
      if ("string" == typeof u4)
        n2.style.cssText = u4;
      else {
        if ("string" == typeof i4 && (n2.style.cssText = i4 = ""), i4)
          for (l3 in i4)
            u4 && l3 in u4 || $(n2.style, l3, "");
        if (u4)
          for (l3 in u4)
            i4 && u4[l3] === i4[l3] || $(n2.style, l3, u4[l3]);
      }
    else if ("o" === l3[0] && "n" === l3[1])
      o3 = l3 !== (l3 = l3.replace(/Capture$/, "")), l3 = l3.toLowerCase() in n2 ? l3.toLowerCase().slice(2) : l3.slice(2), n2.l || (n2.l = {}), n2.l[l3 + o3] = u4, u4 ? i4 || n2.addEventListener(l3, o3 ? T : I2, o3) : n2.removeEventListener(l3, o3 ? T : I2, o3);
    else if ("dangerouslySetInnerHTML" !== l3) {
      if (t4)
        l3 = l3.replace(/xlink(H|:h)/, "h").replace(/sName$/, "s");
      else if ("href" !== l3 && "list" !== l3 && "form" !== l3 && "tabIndex" !== l3 && "download" !== l3 && l3 in n2)
        try {
          n2[l3] = null == u4 ? "" : u4;
          break n;
        } catch (n3) {
        }
      "function" == typeof u4 || (null == u4 || false === u4 && -1 == l3.indexOf("-") ? n2.removeAttribute(l3) : n2.setAttribute(l3, u4));
    }
}
function I2(n2) {
  this.l[n2.type + false](l.event ? l.event(n2) : n2);
}
function T(n2) {
  this.l[n2.type + true](l.event ? l.event(n2) : n2);
}
function j(n2, u4, i4, t4, o3, r3, f3, e4, c4) {
  var a4, h3, v3, y4, _3, k5, b4, g4, m4, x5, A5, C3, $3, H4, I5, T5 = u4.type;
  if (void 0 !== u4.constructor)
    return null;
  null != i4.__h && (c4 = i4.__h, e4 = u4.__e = i4.__e, u4.__h = null, r3 = [e4]), (a4 = l.__b) && a4(u4);
  try {
    n:
      if ("function" == typeof T5) {
        if (g4 = u4.props, m4 = (a4 = T5.contextType) && t4[a4.__c], x5 = a4 ? m4 ? m4.props.value : a4.__ : t4, i4.__c ? b4 = (h3 = u4.__c = i4.__c).__ = h3.__E : ("prototype" in T5 && T5.prototype.render ? u4.__c = h3 = new T5(g4, x5) : (u4.__c = h3 = new d(g4, x5), h3.constructor = T5, h3.render = O), m4 && m4.sub(h3), h3.props = g4, h3.state || (h3.state = {}), h3.context = x5, h3.__n = t4, v3 = h3.__d = true, h3.__h = [], h3._sb = []), null == h3.__s && (h3.__s = h3.state), null != T5.getDerivedStateFromProps && (h3.__s == h3.state && (h3.__s = s({}, h3.__s)), s(h3.__s, T5.getDerivedStateFromProps(g4, h3.__s))), y4 = h3.props, _3 = h3.state, v3)
          null == T5.getDerivedStateFromProps && null != h3.componentWillMount && h3.componentWillMount(), null != h3.componentDidMount && h3.__h.push(h3.componentDidMount);
        else {
          if (null == T5.getDerivedStateFromProps && g4 !== y4 && null != h3.componentWillReceiveProps && h3.componentWillReceiveProps(g4, x5), !h3.__e && null != h3.shouldComponentUpdate && false === h3.shouldComponentUpdate(g4, h3.__s, x5) || u4.__v === i4.__v) {
            for (h3.props = g4, h3.state = h3.__s, u4.__v !== i4.__v && (h3.__d = false), h3.__v = u4, u4.__e = i4.__e, u4.__k = i4.__k, u4.__k.forEach(function(n3) {
              n3 && (n3.__ = u4);
            }), A5 = 0; A5 < h3._sb.length; A5++)
              h3.__h.push(h3._sb[A5]);
            h3._sb = [], h3.__h.length && f3.push(h3);
            break n;
          }
          null != h3.componentWillUpdate && h3.componentWillUpdate(g4, h3.__s, x5), null != h3.componentDidUpdate && h3.__h.push(function() {
            h3.componentDidUpdate(y4, _3, k5);
          });
        }
        if (h3.context = x5, h3.props = g4, h3.__v = u4, h3.__P = n2, C3 = l.__r, $3 = 0, "prototype" in T5 && T5.prototype.render) {
          for (h3.state = h3.__s, h3.__d = false, C3 && C3(u4), a4 = h3.render(h3.props, h3.state, h3.context), H4 = 0; H4 < h3._sb.length; H4++)
            h3.__h.push(h3._sb[H4]);
          h3._sb = [];
        } else
          do {
            h3.__d = false, C3 && C3(u4), a4 = h3.render(h3.props, h3.state, h3.context), h3.state = h3.__s;
          } while (h3.__d && ++$3 < 25);
        h3.state = h3.__s, null != h3.getChildContext && (t4 = s(s({}, t4), h3.getChildContext())), v3 || null == h3.getSnapshotBeforeUpdate || (k5 = h3.getSnapshotBeforeUpdate(y4, _3)), I5 = null != a4 && a4.type === p2 && null == a4.key ? a4.props.children : a4, w(n2, Array.isArray(I5) ? I5 : [I5], u4, i4, t4, o3, r3, f3, e4, c4), h3.base = u4.__e, u4.__h = null, h3.__h.length && f3.push(h3), b4 && (h3.__E = h3.__ = null), h3.__e = false;
      } else
        null == r3 && u4.__v === i4.__v ? (u4.__k = i4.__k, u4.__e = i4.__e) : u4.__e = L2(i4.__e, u4, i4, t4, o3, r3, f3, c4);
    (a4 = l.diffed) && a4(u4);
  } catch (n3) {
    u4.__v = null, (c4 || null != r3) && (u4.__e = e4, u4.__h = !!c4, r3[r3.indexOf(e4)] = null), l.__e(n3, u4, i4);
  }
}
function z(n2, u4) {
  l.__c && l.__c(u4, n2), n2.some(function(u5) {
    try {
      n2 = u5.__h, u5.__h = [], n2.some(function(n3) {
        n3.call(u5);
      });
    } catch (n3) {
      l.__e(n3, u5.__v);
    }
  });
}
function L2(l3, u4, i4, t4, o3, r3, e4, c4) {
  var s4, h3, v3, y4 = i4.props, p4 = u4.props, d4 = u4.type, k5 = 0;
  if ("svg" === d4 && (o3 = true), null != r3) {
    for (; k5 < r3.length; k5++)
      if ((s4 = r3[k5]) && "setAttribute" in s4 == !!d4 && (d4 ? s4.localName === d4 : 3 === s4.nodeType)) {
        l3 = s4, r3[k5] = null;
        break;
      }
  }
  if (null == l3) {
    if (null === d4)
      return document.createTextNode(p4);
    l3 = o3 ? document.createElementNS("http://www.w3.org/2000/svg", d4) : document.createElement(d4, p4.is && p4), r3 = null, c4 = false;
  }
  if (null === d4)
    y4 === p4 || c4 && l3.data === p4 || (l3.data = p4);
  else {
    if (r3 = r3 && n.call(l3.childNodes), h3 = (y4 = i4.props || f).dangerouslySetInnerHTML, v3 = p4.dangerouslySetInnerHTML, !c4) {
      if (null != r3)
        for (y4 = {}, k5 = 0; k5 < l3.attributes.length; k5++)
          y4[l3.attributes[k5].name] = l3.attributes[k5].value;
      (v3 || h3) && (v3 && (h3 && v3.__html == h3.__html || v3.__html === l3.innerHTML) || (l3.innerHTML = v3 && v3.__html || ""));
    }
    if (C(l3, p4, y4, o3, c4), v3)
      u4.__k = [];
    else if (k5 = u4.props.children, w(l3, Array.isArray(k5) ? k5 : [k5], u4, i4, t4, o3 && "foreignObject" !== d4, r3, e4, r3 ? r3[0] : i4.__k && _(i4, 0), c4), null != r3)
      for (k5 = r3.length; k5--; )
        null != r3[k5] && a(r3[k5]);
    c4 || ("value" in p4 && void 0 !== (k5 = p4.value) && (k5 !== l3.value || "progress" === d4 && !k5 || "option" === d4 && k5 !== y4.value) && H(l3, "value", k5, y4.value, false), "checked" in p4 && void 0 !== (k5 = p4.checked) && k5 !== l3.checked && H(l3, "checked", k5, y4.checked, false));
  }
  return l3;
}
function M2(n2, u4, i4) {
  try {
    "function" == typeof n2 ? n2(u4) : n2.current = u4;
  } catch (n3) {
    l.__e(n3, i4);
  }
}
function N(n2, u4, i4) {
  var t4, o3;
  if (l.unmount && l.unmount(n2), (t4 = n2.ref) && (t4.current && t4.current !== n2.__e || M2(t4, null, u4)), null != (t4 = n2.__c)) {
    if (t4.componentWillUnmount)
      try {
        t4.componentWillUnmount();
      } catch (n3) {
        l.__e(n3, u4);
      }
    t4.base = t4.__P = null, n2.__c = void 0;
  }
  if (t4 = n2.__k)
    for (o3 = 0; o3 < t4.length; o3++)
      t4[o3] && N(t4[o3], u4, i4 || "function" != typeof n2.type);
  i4 || null == n2.__e || a(n2.__e), n2.__ = n2.__e = n2.__d = void 0;
}
function O(n2, l3, u4) {
  return this.constructor(n2, u4);
}
function P(u4, i4, t4) {
  var o3, r3, e4;
  l.__ && l.__(u4, i4), r3 = (o3 = "function" == typeof t4) ? null : t4 && t4.__k || i4.__k, e4 = [], j(i4, u4 = (!o3 && t4 || i4).__k = h(p2, null, [u4]), r3 || f, f, void 0 !== i4.ownerSVGElement, !o3 && t4 ? [t4] : r3 ? null : i4.firstChild ? n.call(i4.childNodes) : null, e4, !o3 && t4 ? t4 : r3 ? r3.__e : i4.firstChild, o3), z(e4, u4);
}
function S2(n2, l3) {
  P(n2, l3, S2);
}
function q(l3, u4, i4) {
  var t4, o3, r3, f3 = s({}, l3.props);
  for (r3 in u4)
    "key" == r3 ? t4 = u4[r3] : "ref" == r3 ? o3 = u4[r3] : f3[r3] = u4[r3];
  return arguments.length > 2 && (f3.children = arguments.length > 3 ? n.call(arguments, 2) : i4), v(l3.type, f3, t4 || l3.key, o3 || l3.ref, null);
}
function B(n2, l3) {
  var u4 = { __c: l3 = "__cC" + r++, __: n2, Consumer: function(n3, l4) {
    return n3.children(l4);
  }, Provider: function(n3) {
    var u5, i4;
    return this.getChildContext || (u5 = [], (i4 = {})[l3] = this, this.getChildContext = function() {
      return i4;
    }, this.shouldComponentUpdate = function(n4) {
      this.props.value !== n4.value && u5.some(b);
    }, this.sub = function(n4) {
      u5.push(n4);
      var l4 = n4.componentWillUnmount;
      n4.componentWillUnmount = function() {
        u5.splice(u5.indexOf(n4), 1), l4 && l4.call(n4);
      };
    }), n3.children;
  } };
  return u4.Provider.__ = u4.Consumer.contextType = u4;
}
var n, l, u, i, t, o, r, f, e, c;
var init_preact_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/dist/preact.module.js"() {
    f = {};
    e = [];
    c = /acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i;
    n = e.slice, l = { __e: function(n2, l3, u4, i4) {
      for (var t4, o3, r3; l3 = l3.__; )
        if ((t4 = l3.__c) && !t4.__)
          try {
            if ((o3 = t4.constructor) && null != o3.getDerivedStateFromError && (t4.setState(o3.getDerivedStateFromError(n2)), r3 = t4.__d), null != t4.componentDidCatch && (t4.componentDidCatch(n2, i4 || {}), r3 = t4.__d), r3)
              return t4.__E = t4;
          } catch (l4) {
            n2 = l4;
          }
      throw n2;
    } }, u = 0, i = function(n2) {
      return null != n2 && void 0 === n2.constructor;
    }, d.prototype.setState = function(n2, l3) {
      var u4;
      u4 = null != this.__s && this.__s !== this.state ? this.__s : this.__s = s({}, this.state), "function" == typeof n2 && (n2 = n2(s({}, u4), this.props)), n2 && s(u4, n2), null != n2 && this.__v && (l3 && this._sb.push(l3), b(this));
    }, d.prototype.forceUpdate = function(n2) {
      this.__v && (this.__e = true, n2 && this.__h.push(n2), b(this));
    }, d.prototype.render = p2, t = [], g.__r = 0, r = 0;
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/hooks/dist/hooks.module.js
function d2(t4, u4) {
  l.__h && l.__h(r2, t4, o2 || u4), o2 = 0;
  var i4 = r2.__H || (r2.__H = { __: [], __h: [] });
  return t4 >= i4.__.length && i4.__.push({ __V: c2 }), i4.__[t4];
}
function p3(n2) {
  return o2 = 1, y2(B2, n2);
}
function y2(n2, u4, i4) {
  var o3 = d2(t2++, 2);
  if (o3.t = n2, !o3.__c && (o3.__ = [i4 ? i4(u4) : B2(void 0, u4), function(n3) {
    var t4 = o3.__N ? o3.__N[0] : o3.__[0], r3 = o3.t(t4, n3);
    t4 !== r3 && (o3.__N = [r3, o3.__[1]], o3.__c.setState({}));
  }], o3.__c = r2, !r2.u)) {
    r2.u = true;
    var f3 = r2.shouldComponentUpdate;
    r2.shouldComponentUpdate = function(n3, t4, r3) {
      if (!o3.__c.__H)
        return true;
      var u5 = o3.__c.__H.__.filter(function(n4) {
        return n4.__c;
      });
      if (u5.every(function(n4) {
        return !n4.__N;
      }))
        return !f3 || f3.call(this, n3, t4, r3);
      var i5 = false;
      return u5.forEach(function(n4) {
        if (n4.__N) {
          var t5 = n4.__[0];
          n4.__ = n4.__N, n4.__N = void 0, t5 !== n4.__[0] && (i5 = true);
        }
      }), !(!i5 && o3.__c.props === n3) && (!f3 || f3.call(this, n3, t4, r3));
    };
  }
  return o3.__N || o3.__;
}
function h2(u4, i4) {
  var o3 = d2(t2++, 3);
  !l.__s && z2(o3.__H, i4) && (o3.__ = u4, o3.i = i4, r2.__H.__h.push(o3));
}
function s2(u4, i4) {
  var o3 = d2(t2++, 4);
  !l.__s && z2(o3.__H, i4) && (o3.__ = u4, o3.i = i4, r2.__h.push(o3));
}
function _2(n2) {
  return o2 = 5, F(function() {
    return { current: n2 };
  }, []);
}
function A3(n2, t4, r3) {
  o2 = 6, s2(function() {
    return "function" == typeof n2 ? (n2(t4()), function() {
      return n2(null);
    }) : n2 ? (n2.current = t4(), function() {
      return n2.current = null;
    }) : void 0;
  }, null == r3 ? r3 : r3.concat(n2));
}
function F(n2, r3) {
  var u4 = d2(t2++, 7);
  return z2(u4.__H, r3) ? (u4.__V = n2(), u4.i = r3, u4.__h = n2, u4.__V) : u4.__;
}
function T2(n2, t4) {
  return o2 = 8, F(function() {
    return n2;
  }, t4);
}
function q2(n2) {
  var u4 = r2.context[n2.__c], i4 = d2(t2++, 9);
  return i4.c = n2, u4 ? (null == i4.__ && (i4.__ = true, u4.sub(r2)), u4.props.value) : n2.__;
}
function x2(t4, r3) {
  l.useDebugValue && l.useDebugValue(r3 ? r3(t4) : t4);
}
function P2(n2) {
  var u4 = d2(t2++, 10), i4 = p3();
  return u4.__ = n2, r2.componentDidCatch || (r2.componentDidCatch = function(n3, t4) {
    u4.__ && u4.__(n3, t4), i4[1](n3);
  }), [i4[0], function() {
    i4[1](void 0);
  }];
}
function V() {
  var n2 = d2(t2++, 11);
  if (!n2.__) {
    for (var u4 = r2.__v; null !== u4 && !u4.__m && null !== u4.__; )
      u4 = u4.__;
    var i4 = u4.__m || (u4.__m = [0, 0]);
    n2.__ = "P" + i4[0] + "-" + i4[1]++;
  }
  return n2.__;
}
function b2() {
  for (var t4; t4 = f2.shift(); )
    if (t4.__P && t4.__H)
      try {
        t4.__H.__h.forEach(k2), t4.__H.__h.forEach(w2), t4.__H.__h = [];
      } catch (r3) {
        t4.__H.__h = [], l.__e(r3, t4.__v);
      }
}
function j2(n2) {
  var t4, r3 = function() {
    clearTimeout(u4), g2 && cancelAnimationFrame(t4), setTimeout(n2);
  }, u4 = setTimeout(r3, 100);
  g2 && (t4 = requestAnimationFrame(r3));
}
function k2(n2) {
  var t4 = r2, u4 = n2.__c;
  "function" == typeof u4 && (n2.__c = void 0, u4()), r2 = t4;
}
function w2(n2) {
  var t4 = r2;
  n2.__c = n2.__(), r2 = t4;
}
function z2(n2, t4) {
  return !n2 || n2.length !== t4.length || t4.some(function(t5, r3) {
    return t5 !== n2[r3];
  });
}
function B2(n2, t4) {
  return "function" == typeof t4 ? t4(n2) : t4;
}
var t2, r2, u2, i2, o2, f2, c2, e2, a2, v2, l2, m2, g2;
var init_hooks_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/hooks/dist/hooks.module.js"() {
    init_preact_module();
    o2 = 0;
    f2 = [];
    c2 = [];
    e2 = l.__b;
    a2 = l.__r;
    v2 = l.diffed;
    l2 = l.__c;
    m2 = l.unmount;
    l.__b = function(n2) {
      r2 = null, e2 && e2(n2);
    }, l.__r = function(n2) {
      a2 && a2(n2), t2 = 0;
      var i4 = (r2 = n2.__c).__H;
      i4 && (u2 === r2 ? (i4.__h = [], r2.__h = [], i4.__.forEach(function(n3) {
        n3.__N && (n3.__ = n3.__N), n3.__V = c2, n3.__N = n3.i = void 0;
      })) : (i4.__h.forEach(k2), i4.__h.forEach(w2), i4.__h = [])), u2 = r2;
    }, l.diffed = function(t4) {
      v2 && v2(t4);
      var o3 = t4.__c;
      o3 && o3.__H && (o3.__H.__h.length && (1 !== f2.push(o3) && i2 === l.requestAnimationFrame || ((i2 = l.requestAnimationFrame) || j2)(b2)), o3.__H.__.forEach(function(n2) {
        n2.i && (n2.__H = n2.i), n2.__V !== c2 && (n2.__ = n2.__V), n2.i = void 0, n2.__V = c2;
      })), u2 = r2 = null;
    }, l.__c = function(t4, r3) {
      r3.some(function(t5) {
        try {
          t5.__h.forEach(k2), t5.__h = t5.__h.filter(function(n2) {
            return !n2.__ || w2(n2);
          });
        } catch (u4) {
          r3.some(function(n2) {
            n2.__h && (n2.__h = []);
          }), r3 = [], l.__e(u4, t5.__v);
        }
      }), l2 && l2(t4, r3);
    }, l.unmount = function(t4) {
      m2 && m2(t4);
      var r3, u4 = t4.__c;
      u4 && u4.__H && (u4.__H.__.forEach(function(n2) {
        try {
          k2(n2);
        } catch (n3) {
          r3 = n3;
        }
      }), u4.__H = void 0, r3 && l.__e(r3, u4.__v));
    };
    g2 = "function" == typeof requestAnimationFrame;
  }
});

// ../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/compat/dist/compat.module.js
var compat_module_exports = {};
__export(compat_module_exports, {
  Children: () => O2,
  Component: () => d,
  Fragment: () => p2,
  PureComponent: () => w3,
  StrictMode: () => vn2,
  Suspense: () => D3,
  SuspenseList: () => V2,
  __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: () => rn,
  cloneElement: () => cn,
  createContext: () => B,
  createElement: () => h,
  createFactory: () => on,
  createPortal: () => j3,
  createRef: () => y,
  default: () => bn,
  findDOMNode: () => an,
  flushSync: () => hn,
  forwardRef: () => k3,
  hydrate: () => q3,
  isValidElement: () => ln,
  lazy: () => M3,
  memo: () => R,
  render: () => Y2,
  startTransition: () => dn,
  unmountComponentAtNode: () => fn,
  unstable_batchedUpdates: () => sn,
  useCallback: () => T2,
  useContext: () => q2,
  useDebugValue: () => x2,
  useDeferredValue: () => pn,
  useEffect: () => h2,
  useErrorBoundary: () => P2,
  useId: () => V,
  useImperativeHandle: () => A3,
  useInsertionEffect: () => yn,
  useLayoutEffect: () => s2,
  useMemo: () => F,
  useReducer: () => y2,
  useRef: () => _2,
  useState: () => p3,
  useSyncExternalStore: () => _n,
  useTransition: () => mn,
  version: () => un
});
function g3(n2, t4) {
  for (var e4 in t4)
    n2[e4] = t4[e4];
  return n2;
}
function C2(n2, t4) {
  for (var e4 in n2)
    if ("__source" !== e4 && !(e4 in t4))
      return true;
  for (var r3 in t4)
    if ("__source" !== r3 && n2[r3] !== t4[r3])
      return true;
  return false;
}
function E(n2, t4) {
  return n2 === t4 && (0 !== n2 || 1 / n2 == 1 / t4) || n2 != n2 && t4 != t4;
}
function w3(n2) {
  this.props = n2;
}
function R(n2, e4) {
  function r3(n3) {
    var t4 = this.props.ref, r4 = t4 == n3.ref;
    return !r4 && t4 && (t4.call ? t4(null) : t4.current = null), e4 ? !e4(this.props, n3) || !r4 : C2(this.props, n3);
  }
  function u4(e5) {
    return this.shouldComponentUpdate = r3, h(n2, e5);
  }
  return u4.displayName = "Memo(" + (n2.displayName || n2.name) + ")", u4.prototype.isReactComponent = true, u4.__f = true, u4;
}
function k3(n2) {
  function t4(t5) {
    var e4 = g3({}, t5);
    return delete e4.ref, n2(e4, t5.ref || null);
  }
  return t4.$$typeof = N2, t4.render = t4, t4.prototype.isReactComponent = t4.__f = true, t4.displayName = "ForwardRef(" + (n2.displayName || n2.name) + ")", t4;
}
function L3(n2, t4, e4) {
  return n2 && (n2.__c && n2.__c.__H && (n2.__c.__H.__.forEach(function(n3) {
    "function" == typeof n3.__c && n3.__c();
  }), n2.__c.__H = null), null != (n2 = g3({}, n2)).__c && (n2.__c.__P === e4 && (n2.__c.__P = t4), n2.__c = null), n2.__k = n2.__k && n2.__k.map(function(n3) {
    return L3(n3, t4, e4);
  })), n2;
}
function U(n2, t4, e4) {
  return n2 && (n2.__v = null, n2.__k = n2.__k && n2.__k.map(function(n3) {
    return U(n3, t4, e4);
  }), n2.__c && n2.__c.__P === t4 && (n2.__e && e4.insertBefore(n2.__e, n2.__d), n2.__c.__e = true, n2.__c.__P = e4)), n2;
}
function D3() {
  this.__u = 0, this.t = null, this.__b = null;
}
function F2(n2) {
  var t4 = n2.__.__c;
  return t4 && t4.__a && t4.__a(n2);
}
function M3(n2) {
  var e4, r3, u4;
  function o3(o4) {
    if (e4 || (e4 = n2()).then(function(n3) {
      r3 = n3.default || n3;
    }, function(n3) {
      u4 = n3;
    }), u4)
      throw u4;
    if (!r3)
      throw e4;
    return h(r3, o4);
  }
  return o3.displayName = "Lazy", o3.__f = true, o3;
}
function V2() {
  this.u = null, this.o = null;
}
function P3(n2) {
  return this.getChildContext = function() {
    return n2.context;
  }, n2.children;
}
function $2(n2) {
  var e4 = this, r3 = n2.i;
  e4.componentWillUnmount = function() {
    P(null, e4.l), e4.l = null, e4.i = null;
  }, e4.i && e4.i !== r3 && e4.componentWillUnmount(), n2.__v ? (e4.l || (e4.i = r3, e4.l = { nodeType: 1, parentNode: r3, childNodes: [], appendChild: function(n3) {
    this.childNodes.push(n3), e4.i.appendChild(n3);
  }, insertBefore: function(n3, t4) {
    this.childNodes.push(n3), e4.i.appendChild(n3);
  }, removeChild: function(n3) {
    this.childNodes.splice(this.childNodes.indexOf(n3) >>> 1, 1), e4.i.removeChild(n3);
  } }), P(h(P3, { context: e4.context }, n2.__v), e4.l)) : e4.l && e4.componentWillUnmount();
}
function j3(n2, e4) {
  var r3 = h($2, { __v: n2, i: e4 });
  return r3.containerInfo = e4, r3;
}
function Y2(n2, t4, e4) {
  return null == t4.__k && (t4.textContent = ""), P(n2, t4), "function" == typeof e4 && e4(), n2 ? n2.__c : null;
}
function q3(n2, t4, e4) {
  return S2(n2, t4), "function" == typeof e4 && e4(), n2 ? n2.__c : null;
}
function J() {
}
function K3() {
  return this.cancelBubble;
}
function Q() {
  return this.defaultPrevented;
}
function on(n2) {
  return h.bind(null, n2);
}
function ln(n2) {
  return !!n2 && n2.$$typeof === z3;
}
function cn(n2) {
  return ln(n2) ? q.apply(null, arguments) : n2;
}
function fn(n2) {
  return !!n2.__k && (P(null, n2), true);
}
function an(n2) {
  return n2 && (n2.base || 1 === n2.nodeType && n2) || null;
}
function dn(n2) {
  n2();
}
function pn(n2) {
  return n2;
}
function mn() {
  return [false, dn];
}
function _n(n2, t4) {
  var e4 = t4(), r3 = p3({ h: { __: e4, v: t4 } }), u4 = r3[0].h, o3 = r3[1];
  return s2(function() {
    u4.__ = e4, u4.v = t4, E(u4.__, t4()) || o3({ h: u4 });
  }, [n2, e4, t4]), h2(function() {
    return E(u4.__, u4.v()) || o3({ h: u4 }), n2(function() {
      E(u4.__, u4.v()) || o3({ h: u4 });
    });
  }, [n2]), e4;
}
var x3, N2, A4, O2, T3, I3, W, z3, B3, H2, Z2, G, X2, nn, tn, en, rn, un, sn, hn, vn2, yn, bn;
var init_compat_module = __esm({
  "../../node_modules/.pnpm/preact@10.11.3/node_modules/preact/compat/dist/compat.module.js"() {
    init_preact_module();
    init_preact_module();
    init_hooks_module();
    init_hooks_module();
    (w3.prototype = new d()).isPureReactComponent = true, w3.prototype.shouldComponentUpdate = function(n2, t4) {
      return C2(this.props, n2) || C2(this.state, t4);
    };
    x3 = l.__b;
    l.__b = function(n2) {
      n2.type && n2.type.__f && n2.ref && (n2.props.ref = n2.ref, n2.ref = null), x3 && x3(n2);
    };
    N2 = "undefined" != typeof Symbol && Symbol.for && Symbol.for("react.forward_ref") || 3911;
    A4 = function(n2, t4) {
      return null == n2 ? null : x(x(n2).map(t4));
    };
    O2 = { map: A4, forEach: A4, count: function(n2) {
      return n2 ? x(n2).length : 0;
    }, only: function(n2) {
      var t4 = x(n2);
      if (1 !== t4.length)
        throw "Children.only";
      return t4[0];
    }, toArray: x };
    T3 = l.__e;
    l.__e = function(n2, t4, e4, r3) {
      if (n2.then) {
        for (var u4, o3 = t4; o3 = o3.__; )
          if ((u4 = o3.__c) && u4.__c)
            return null == t4.__e && (t4.__e = e4.__e, t4.__k = e4.__k), u4.__c(n2, t4);
      }
      T3(n2, t4, e4, r3);
    };
    I3 = l.unmount;
    l.unmount = function(n2) {
      var t4 = n2.__c;
      t4 && t4.__R && t4.__R(), t4 && true === n2.__h && (n2.type = null), I3 && I3(n2);
    }, (D3.prototype = new d()).__c = function(n2, t4) {
      var e4 = t4.__c, r3 = this;
      null == r3.t && (r3.t = []), r3.t.push(e4);
      var u4 = F2(r3.__v), o3 = false, i4 = function() {
        o3 || (o3 = true, e4.__R = null, u4 ? u4(l3) : l3());
      };
      e4.__R = i4;
      var l3 = function() {
        if (!--r3.__u) {
          if (r3.state.__a) {
            var n3 = r3.state.__a;
            r3.__v.__k[0] = U(n3, n3.__c.__P, n3.__c.__O);
          }
          var t5;
          for (r3.setState({ __a: r3.__b = null }); t5 = r3.t.pop(); )
            t5.forceUpdate();
        }
      }, c4 = true === t4.__h;
      r3.__u++ || c4 || r3.setState({ __a: r3.__b = r3.__v.__k[0] }), n2.then(i4, i4);
    }, D3.prototype.componentWillUnmount = function() {
      this.t = [];
    }, D3.prototype.render = function(n2, e4) {
      if (this.__b) {
        if (this.__v.__k) {
          var r3 = document.createElement("div"), o3 = this.__v.__k[0].__c;
          this.__v.__k[0] = L3(this.__b, r3, o3.__O = o3.__P);
        }
        this.__b = null;
      }
      var i4 = e4.__a && h(p2, null, n2.fallback);
      return i4 && (i4.__h = null), [h(p2, null, e4.__a ? null : n2.children), i4];
    };
    W = function(n2, t4, e4) {
      if (++e4[1] === e4[0] && n2.o.delete(t4), n2.props.revealOrder && ("t" !== n2.props.revealOrder[0] || !n2.o.size))
        for (e4 = n2.u; e4; ) {
          for (; e4.length > 3; )
            e4.pop()();
          if (e4[1] < e4[0])
            break;
          n2.u = e4 = e4[2];
        }
    };
    (V2.prototype = new d()).__a = function(n2) {
      var t4 = this, e4 = F2(t4.__v), r3 = t4.o.get(n2);
      return r3[0]++, function(u4) {
        var o3 = function() {
          t4.props.revealOrder ? (r3.push(u4), W(t4, n2, r3)) : u4();
        };
        e4 ? e4(o3) : o3();
      };
    }, V2.prototype.render = function(n2) {
      this.u = null, this.o = /* @__PURE__ */ new Map();
      var t4 = x(n2.children);
      n2.revealOrder && "b" === n2.revealOrder[0] && t4.reverse();
      for (var e4 = t4.length; e4--; )
        this.o.set(t4[e4], this.u = [1, 0, this.u]);
      return n2.children;
    }, V2.prototype.componentDidUpdate = V2.prototype.componentDidMount = function() {
      var n2 = this;
      this.o.forEach(function(t4, e4) {
        W(n2, e4, t4);
      });
    };
    z3 = "undefined" != typeof Symbol && Symbol.for && Symbol.for("react.element") || 60103;
    B3 = /^(?:accent|alignment|arabic|baseline|cap|clip(?!PathU)|color|dominant|fill|flood|font|glyph(?!R)|horiz|image|letter|lighting|marker(?!H|W|U)|overline|paint|pointer|shape|stop|strikethrough|stroke|text(?!L)|transform|underline|unicode|units|v|vector|vert|word|writing|x(?!C))[A-Z]/;
    H2 = "undefined" != typeof document;
    Z2 = function(n2) {
      return ("undefined" != typeof Symbol && "symbol" == typeof Symbol() ? /fil|che|rad/i : /fil|che|ra/i).test(n2);
    };
    d.prototype.isReactComponent = {}, ["componentWillMount", "componentWillReceiveProps", "componentWillUpdate"].forEach(function(t4) {
      Object.defineProperty(d.prototype, t4, { configurable: true, get: function() {
        return this["UNSAFE_" + t4];
      }, set: function(n2) {
        Object.defineProperty(this, t4, { configurable: true, writable: true, value: n2 });
      } });
    });
    G = l.event;
    l.event = function(n2) {
      return G && (n2 = G(n2)), n2.persist = J, n2.isPropagationStopped = K3, n2.isDefaultPrevented = Q, n2.nativeEvent = n2;
    };
    nn = { configurable: true, get: function() {
      return this.class;
    } };
    tn = l.vnode;
    l.vnode = function(n2) {
      var t4 = n2.type, e4 = n2.props, u4 = e4;
      if ("string" == typeof t4) {
        var o3 = -1 === t4.indexOf("-");
        for (var i4 in u4 = {}, e4) {
          var l3 = e4[i4];
          H2 && "children" === i4 && "noscript" === t4 || "value" === i4 && "defaultValue" in e4 && null == l3 || ("defaultValue" === i4 && "value" in e4 && null == e4.value ? i4 = "value" : "download" === i4 && true === l3 ? l3 = "" : /ondoubleclick/i.test(i4) ? i4 = "ondblclick" : /^onchange(textarea|input)/i.test(i4 + t4) && !Z2(e4.type) ? i4 = "oninput" : /^onfocus$/i.test(i4) ? i4 = "onfocusin" : /^onblur$/i.test(i4) ? i4 = "onfocusout" : /^on(Ani|Tra|Tou|BeforeInp|Compo)/.test(i4) ? i4 = i4.toLowerCase() : o3 && B3.test(i4) ? i4 = i4.replace(/[A-Z0-9]/g, "-$&").toLowerCase() : null === l3 && (l3 = void 0), /^oninput$/i.test(i4) && (i4 = i4.toLowerCase(), u4[i4] && (i4 = "oninputCapture")), u4[i4] = l3);
        }
        "select" == t4 && u4.multiple && Array.isArray(u4.value) && (u4.value = x(e4.children).forEach(function(n3) {
          n3.props.selected = -1 != u4.value.indexOf(n3.props.value);
        })), "select" == t4 && null != u4.defaultValue && (u4.value = x(e4.children).forEach(function(n3) {
          n3.props.selected = u4.multiple ? -1 != u4.defaultValue.indexOf(n3.props.value) : u4.defaultValue == n3.props.value;
        })), n2.props = u4, e4.class != e4.className && (nn.enumerable = "className" in e4, null != e4.className && (u4.class = e4.className), Object.defineProperty(u4, "className", nn));
      }
      n2.$$typeof = z3, tn && tn(n2);
    };
    en = l.__r;
    l.__r = function(n2) {
      en && en(n2), X2 = n2.__c;
    };
    rn = { ReactCurrentDispatcher: { current: { readContext: function(n2) {
      return X2.__n[n2.__c].props.value;
    } } } };
    un = "17.0.2";
    sn = function(n2, t4) {
      return n2(t4);
    };
    hn = function(n2, t4) {
      return n2(t4);
    };
    vn2 = p2;
    yn = s2;
    bn = { useState: p3, useId: V, useReducer: y2, useEffect: h2, useLayoutEffect: s2, useInsertionEffect: yn, useTransition: mn, useDeferredValue: pn, useSyncExternalStore: _n, startTransition: dn, useRef: _2, useImperativeHandle: A3, useMemo: F, useCallback: T2, useContext: q2, useDebugValue: x2, version: "17.0.2", Children: O2, render: Y2, hydrate: q3, unmountComponentAtNode: fn, createPortal: j3, createElement: h, createContext: B, createFactory: on, cloneElement: cn, createRef: y, Fragment: p2, isValidElement: ln, findDOMNode: an, Component: d, PureComponent: w3, memo: R, forwardRef: k3, flushSync: hn, unstable_batchedUpdates: sn, StrictMode: vn2, Suspense: D3, SuspenseList: V2, lazy: M3, __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: rn };
  }
});

// ../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/cjs/use-sync-external-store-shim.production.min.js
var require_use_sync_external_store_shim_production_min = __commonJS({
  "../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/cjs/use-sync-external-store-shim.production.min.js"(exports) {
    "use strict";
    var e4 = (init_compat_module(), __toCommonJS(compat_module_exports));
    function h3(a4, b4) {
      return a4 === b4 && (0 !== a4 || 1 / a4 === 1 / b4) || a4 !== a4 && b4 !== b4;
    }
    var k5 = "function" === typeof Object.is ? Object.is : h3;
    var l3 = e4.useState;
    var m4 = e4.useEffect;
    var n2 = e4.useLayoutEffect;
    var p4 = e4.useDebugValue;
    function q5(a4, b4) {
      var d4 = b4(), f3 = l3({ inst: { value: d4, getSnapshot: b4 } }), c4 = f3[0].inst, g4 = f3[1];
      n2(function() {
        c4.value = d4;
        c4.getSnapshot = b4;
        r3(c4) && g4({ inst: c4 });
      }, [a4, d4, b4]);
      m4(function() {
        r3(c4) && g4({ inst: c4 });
        return a4(function() {
          r3(c4) && g4({ inst: c4 });
        });
      }, [a4]);
      p4(d4);
      return d4;
    }
    function r3(a4) {
      var b4 = a4.getSnapshot;
      a4 = a4.value;
      try {
        var d4 = b4();
        return !k5(a4, d4);
      } catch (f3) {
        return true;
      }
    }
    function t4(a4, b4) {
      return b4();
    }
    var u4 = "undefined" === typeof window || "undefined" === typeof window.document || "undefined" === typeof window.document.createElement ? t4 : q5;
    exports.useSyncExternalStore = void 0 !== e4.useSyncExternalStore ? e4.useSyncExternalStore : u4;
  }
});

// ../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/shim/index.js
var require_shim = __commonJS({
  "../../node_modules/.pnpm/use-sync-external-store@1.2.0_react@18.3.1/node_modules/use-sync-external-store/shim/index.js"(exports, module) {
    "use strict";
    if (true) {
      module.exports = require_use_sync_external_store_shim_production_min();
    } else {
      module.exports = null;
    }
  }
});

// ../taler-util/lib/nacl-fast.js
var gf = function(init = []) {
  const r3 = new Float64Array(16);
  if (init)
    for (let i4 = 0; i4 < init.length; i4++)
      r3[i4] = init[i4];
  return r3;
};
var randombytes = function(x5, n2) {
  throw new Error("no PRNG");
};
var _9 = new Uint8Array(32);
_9[0] = 9;
var gf0 = gf();
var gf1 = gf([1]);
var _121665 = gf([56129, 1]);
var D = gf([
  30883,
  4953,
  19914,
  30187,
  55467,
  16705,
  2637,
  112,
  59544,
  30585,
  16505,
  36039,
  65139,
  11119,
  27886,
  20995
]);
var D2 = gf([
  61785,
  9906,
  39828,
  60374,
  45398,
  33411,
  5274,
  224,
  53552,
  61171,
  33010,
  6542,
  64743,
  22239,
  55772,
  9222
]);
var X = gf([
  54554,
  36645,
  11616,
  51542,
  42930,
  38181,
  51040,
  26924,
  56412,
  64982,
  57905,
  49316,
  21502,
  52590,
  14035,
  8553
]);
var Y = gf([
  26200,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214,
  26214
]);
var I = gf([
  41136,
  18958,
  6951,
  50414,
  58488,
  44335,
  6150,
  12099,
  55207,
  15867,
  153,
  11085,
  57099,
  20417,
  9344,
  11139
]);
function ts64(x5, i4, h3, l3) {
  x5[i4] = h3 >> 24 & 255;
  x5[i4 + 1] = h3 >> 16 & 255;
  x5[i4 + 2] = h3 >> 8 & 255;
  x5[i4 + 3] = h3 & 255;
  x5[i4 + 4] = l3 >> 24 & 255;
  x5[i4 + 5] = l3 >> 16 & 255;
  x5[i4 + 6] = l3 >> 8 & 255;
  x5[i4 + 7] = l3 & 255;
}
function vn(x5, xi, y4, yi, n2) {
  let i4, d4 = 0;
  for (i4 = 0; i4 < n2; i4++)
    d4 |= x5[xi + i4] ^ y4[yi + i4];
  return (1 & d4 - 1 >>> 8) - 1;
}
function crypto_verify_32(x5, xi, y4, yi) {
  return vn(x5, xi, y4, yi, 32);
}
function core_salsa20(o3, p4, k5, c4) {
  var j0 = c4[0] & 255 | (c4[1] & 255) << 8 | (c4[2] & 255) << 16 | (c4[3] & 255) << 24, j1 = k5[0] & 255 | (k5[1] & 255) << 8 | (k5[2] & 255) << 16 | (k5[3] & 255) << 24, j22 = k5[4] & 255 | (k5[5] & 255) << 8 | (k5[6] & 255) << 16 | (k5[7] & 255) << 24, j32 = k5[8] & 255 | (k5[9] & 255) << 8 | (k5[10] & 255) << 16 | (k5[11] & 255) << 24, j4 = k5[12] & 255 | (k5[13] & 255) << 8 | (k5[14] & 255) << 16 | (k5[15] & 255) << 24, j5 = c4[4] & 255 | (c4[5] & 255) << 8 | (c4[6] & 255) << 16 | (c4[7] & 255) << 24, j6 = p4[0] & 255 | (p4[1] & 255) << 8 | (p4[2] & 255) << 16 | (p4[3] & 255) << 24, j7 = p4[4] & 255 | (p4[5] & 255) << 8 | (p4[6] & 255) << 16 | (p4[7] & 255) << 24, j8 = p4[8] & 255 | (p4[9] & 255) << 8 | (p4[10] & 255) << 16 | (p4[11] & 255) << 24, j9 = p4[12] & 255 | (p4[13] & 255) << 8 | (p4[14] & 255) << 16 | (p4[15] & 255) << 24, j10 = c4[8] & 255 | (c4[9] & 255) << 8 | (c4[10] & 255) << 16 | (c4[11] & 255) << 24, j11 = k5[16] & 255 | (k5[17] & 255) << 8 | (k5[18] & 255) << 16 | (k5[19] & 255) << 24, j12 = k5[20] & 255 | (k5[21] & 255) << 8 | (k5[22] & 255) << 16 | (k5[23] & 255) << 24, j13 = k5[24] & 255 | (k5[25] & 255) << 8 | (k5[26] & 255) << 16 | (k5[27] & 255) << 24, j14 = k5[28] & 255 | (k5[29] & 255) << 8 | (k5[30] & 255) << 16 | (k5[31] & 255) << 24, j15 = c4[12] & 255 | (c4[13] & 255) << 8 | (c4[14] & 255) << 16 | (c4[15] & 255) << 24;
  var x0 = j0, x1 = j1, x22 = j22, x32 = j32, x42 = j4, x5 = j5, x6 = j6, x7 = j7, x8 = j8, x9 = j9, x10 = j10, x11 = j11, x12 = j12, x13 = j13, x14 = j14, x15 = j15, u4;
  for (var i4 = 0; i4 < 20; i4 += 2) {
    u4 = x0 + x12 | 0;
    x42 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x42 + x0 | 0;
    x8 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x8 + x42 | 0;
    x12 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x12 + x8 | 0;
    x0 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x5 + x1 | 0;
    x9 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x9 + x5 | 0;
    x13 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x13 + x9 | 0;
    x1 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x1 + x13 | 0;
    x5 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x10 + x6 | 0;
    x14 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x14 + x10 | 0;
    x22 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x22 + x14 | 0;
    x6 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x6 + x22 | 0;
    x10 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x15 + x11 | 0;
    x32 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x32 + x15 | 0;
    x7 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x7 + x32 | 0;
    x11 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x11 + x7 | 0;
    x15 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x0 + x32 | 0;
    x1 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x1 + x0 | 0;
    x22 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x22 + x1 | 0;
    x32 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x32 + x22 | 0;
    x0 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x5 + x42 | 0;
    x6 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x6 + x5 | 0;
    x7 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x7 + x6 | 0;
    x42 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x42 + x7 | 0;
    x5 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x10 + x9 | 0;
    x11 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x11 + x10 | 0;
    x8 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x8 + x11 | 0;
    x9 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x9 + x8 | 0;
    x10 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x15 + x14 | 0;
    x12 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x12 + x15 | 0;
    x13 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x13 + x12 | 0;
    x14 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x14 + x13 | 0;
    x15 ^= u4 << 18 | u4 >>> 32 - 18;
  }
  x0 = x0 + j0 | 0;
  x1 = x1 + j1 | 0;
  x22 = x22 + j22 | 0;
  x32 = x32 + j32 | 0;
  x42 = x42 + j4 | 0;
  x5 = x5 + j5 | 0;
  x6 = x6 + j6 | 0;
  x7 = x7 + j7 | 0;
  x8 = x8 + j8 | 0;
  x9 = x9 + j9 | 0;
  x10 = x10 + j10 | 0;
  x11 = x11 + j11 | 0;
  x12 = x12 + j12 | 0;
  x13 = x13 + j13 | 0;
  x14 = x14 + j14 | 0;
  x15 = x15 + j15 | 0;
  o3[0] = x0 >>> 0 & 255;
  o3[1] = x0 >>> 8 & 255;
  o3[2] = x0 >>> 16 & 255;
  o3[3] = x0 >>> 24 & 255;
  o3[4] = x1 >>> 0 & 255;
  o3[5] = x1 >>> 8 & 255;
  o3[6] = x1 >>> 16 & 255;
  o3[7] = x1 >>> 24 & 255;
  o3[8] = x22 >>> 0 & 255;
  o3[9] = x22 >>> 8 & 255;
  o3[10] = x22 >>> 16 & 255;
  o3[11] = x22 >>> 24 & 255;
  o3[12] = x32 >>> 0 & 255;
  o3[13] = x32 >>> 8 & 255;
  o3[14] = x32 >>> 16 & 255;
  o3[15] = x32 >>> 24 & 255;
  o3[16] = x42 >>> 0 & 255;
  o3[17] = x42 >>> 8 & 255;
  o3[18] = x42 >>> 16 & 255;
  o3[19] = x42 >>> 24 & 255;
  o3[20] = x5 >>> 0 & 255;
  o3[21] = x5 >>> 8 & 255;
  o3[22] = x5 >>> 16 & 255;
  o3[23] = x5 >>> 24 & 255;
  o3[24] = x6 >>> 0 & 255;
  o3[25] = x6 >>> 8 & 255;
  o3[26] = x6 >>> 16 & 255;
  o3[27] = x6 >>> 24 & 255;
  o3[28] = x7 >>> 0 & 255;
  o3[29] = x7 >>> 8 & 255;
  o3[30] = x7 >>> 16 & 255;
  o3[31] = x7 >>> 24 & 255;
  o3[32] = x8 >>> 0 & 255;
  o3[33] = x8 >>> 8 & 255;
  o3[34] = x8 >>> 16 & 255;
  o3[35] = x8 >>> 24 & 255;
  o3[36] = x9 >>> 0 & 255;
  o3[37] = x9 >>> 8 & 255;
  o3[38] = x9 >>> 16 & 255;
  o3[39] = x9 >>> 24 & 255;
  o3[40] = x10 >>> 0 & 255;
  o3[41] = x10 >>> 8 & 255;
  o3[42] = x10 >>> 16 & 255;
  o3[43] = x10 >>> 24 & 255;
  o3[44] = x11 >>> 0 & 255;
  o3[45] = x11 >>> 8 & 255;
  o3[46] = x11 >>> 16 & 255;
  o3[47] = x11 >>> 24 & 255;
  o3[48] = x12 >>> 0 & 255;
  o3[49] = x12 >>> 8 & 255;
  o3[50] = x12 >>> 16 & 255;
  o3[51] = x12 >>> 24 & 255;
  o3[52] = x13 >>> 0 & 255;
  o3[53] = x13 >>> 8 & 255;
  o3[54] = x13 >>> 16 & 255;
  o3[55] = x13 >>> 24 & 255;
  o3[56] = x14 >>> 0 & 255;
  o3[57] = x14 >>> 8 & 255;
  o3[58] = x14 >>> 16 & 255;
  o3[59] = x14 >>> 24 & 255;
  o3[60] = x15 >>> 0 & 255;
  o3[61] = x15 >>> 8 & 255;
  o3[62] = x15 >>> 16 & 255;
  o3[63] = x15 >>> 24 & 255;
}
function core_hsalsa20(o3, p4, k5, c4) {
  var j0 = c4[0] & 255 | (c4[1] & 255) << 8 | (c4[2] & 255) << 16 | (c4[3] & 255) << 24, j1 = k5[0] & 255 | (k5[1] & 255) << 8 | (k5[2] & 255) << 16 | (k5[3] & 255) << 24, j22 = k5[4] & 255 | (k5[5] & 255) << 8 | (k5[6] & 255) << 16 | (k5[7] & 255) << 24, j32 = k5[8] & 255 | (k5[9] & 255) << 8 | (k5[10] & 255) << 16 | (k5[11] & 255) << 24, j4 = k5[12] & 255 | (k5[13] & 255) << 8 | (k5[14] & 255) << 16 | (k5[15] & 255) << 24, j5 = c4[4] & 255 | (c4[5] & 255) << 8 | (c4[6] & 255) << 16 | (c4[7] & 255) << 24, j6 = p4[0] & 255 | (p4[1] & 255) << 8 | (p4[2] & 255) << 16 | (p4[3] & 255) << 24, j7 = p4[4] & 255 | (p4[5] & 255) << 8 | (p4[6] & 255) << 16 | (p4[7] & 255) << 24, j8 = p4[8] & 255 | (p4[9] & 255) << 8 | (p4[10] & 255) << 16 | (p4[11] & 255) << 24, j9 = p4[12] & 255 | (p4[13] & 255) << 8 | (p4[14] & 255) << 16 | (p4[15] & 255) << 24, j10 = c4[8] & 255 | (c4[9] & 255) << 8 | (c4[10] & 255) << 16 | (c4[11] & 255) << 24, j11 = k5[16] & 255 | (k5[17] & 255) << 8 | (k5[18] & 255) << 16 | (k5[19] & 255) << 24, j12 = k5[20] & 255 | (k5[21] & 255) << 8 | (k5[22] & 255) << 16 | (k5[23] & 255) << 24, j13 = k5[24] & 255 | (k5[25] & 255) << 8 | (k5[26] & 255) << 16 | (k5[27] & 255) << 24, j14 = k5[28] & 255 | (k5[29] & 255) << 8 | (k5[30] & 255) << 16 | (k5[31] & 255) << 24, j15 = c4[12] & 255 | (c4[13] & 255) << 8 | (c4[14] & 255) << 16 | (c4[15] & 255) << 24;
  var x0 = j0, x1 = j1, x22 = j22, x32 = j32, x42 = j4, x5 = j5, x6 = j6, x7 = j7, x8 = j8, x9 = j9, x10 = j10, x11 = j11, x12 = j12, x13 = j13, x14 = j14, x15 = j15, u4;
  for (var i4 = 0; i4 < 20; i4 += 2) {
    u4 = x0 + x12 | 0;
    x42 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x42 + x0 | 0;
    x8 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x8 + x42 | 0;
    x12 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x12 + x8 | 0;
    x0 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x5 + x1 | 0;
    x9 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x9 + x5 | 0;
    x13 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x13 + x9 | 0;
    x1 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x1 + x13 | 0;
    x5 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x10 + x6 | 0;
    x14 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x14 + x10 | 0;
    x22 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x22 + x14 | 0;
    x6 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x6 + x22 | 0;
    x10 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x15 + x11 | 0;
    x32 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x32 + x15 | 0;
    x7 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x7 + x32 | 0;
    x11 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x11 + x7 | 0;
    x15 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x0 + x32 | 0;
    x1 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x1 + x0 | 0;
    x22 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x22 + x1 | 0;
    x32 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x32 + x22 | 0;
    x0 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x5 + x42 | 0;
    x6 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x6 + x5 | 0;
    x7 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x7 + x6 | 0;
    x42 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x42 + x7 | 0;
    x5 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x10 + x9 | 0;
    x11 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x11 + x10 | 0;
    x8 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x8 + x11 | 0;
    x9 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x9 + x8 | 0;
    x10 ^= u4 << 18 | u4 >>> 32 - 18;
    u4 = x15 + x14 | 0;
    x12 ^= u4 << 7 | u4 >>> 32 - 7;
    u4 = x12 + x15 | 0;
    x13 ^= u4 << 9 | u4 >>> 32 - 9;
    u4 = x13 + x12 | 0;
    x14 ^= u4 << 13 | u4 >>> 32 - 13;
    u4 = x14 + x13 | 0;
    x15 ^= u4 << 18 | u4 >>> 32 - 18;
  }
  o3[0] = x0 >>> 0 & 255;
  o3[1] = x0 >>> 8 & 255;
  o3[2] = x0 >>> 16 & 255;
  o3[3] = x0 >>> 24 & 255;
  o3[4] = x5 >>> 0 & 255;
  o3[5] = x5 >>> 8 & 255;
  o3[6] = x5 >>> 16 & 255;
  o3[7] = x5 >>> 24 & 255;
  o3[8] = x10 >>> 0 & 255;
  o3[9] = x10 >>> 8 & 255;
  o3[10] = x10 >>> 16 & 255;
  o3[11] = x10 >>> 24 & 255;
  o3[12] = x15 >>> 0 & 255;
  o3[13] = x15 >>> 8 & 255;
  o3[14] = x15 >>> 16 & 255;
  o3[15] = x15 >>> 24 & 255;
  o3[16] = x6 >>> 0 & 255;
  o3[17] = x6 >>> 8 & 255;
  o3[18] = x6 >>> 16 & 255;
  o3[19] = x6 >>> 24 & 255;
  o3[20] = x7 >>> 0 & 255;
  o3[21] = x7 >>> 8 & 255;
  o3[22] = x7 >>> 16 & 255;
  o3[23] = x7 >>> 24 & 255;
  o3[24] = x8 >>> 0 & 255;
  o3[25] = x8 >>> 8 & 255;
  o3[26] = x8 >>> 16 & 255;
  o3[27] = x8 >>> 24 & 255;
  o3[28] = x9 >>> 0 & 255;
  o3[29] = x9 >>> 8 & 255;
  o3[30] = x9 >>> 16 & 255;
  o3[31] = x9 >>> 24 & 255;
}
var sigma = new Uint8Array([
  101,
  120,
  112,
  97,
  110,
  100,
  32,
  51,
  50,
  45,
  98,
  121,
  116,
  101,
  32,
  107
]);
function crypto_stream_salsa20_xor(c4, cpos, m4, mpos, b4, n2, k5) {
  var z5 = new Uint8Array(16), x5 = new Uint8Array(64);
  var u4, i4;
  for (i4 = 0; i4 < 16; i4++)
    z5[i4] = 0;
  for (i4 = 0; i4 < 8; i4++)
    z5[i4] = n2[i4];
  while (b4 >= 64) {
    core_salsa20(x5, z5, k5, sigma);
    for (i4 = 0; i4 < 64; i4++)
      c4[cpos + i4] = m4[mpos + i4] ^ x5[i4];
    u4 = 1;
    for (i4 = 8; i4 < 16; i4++) {
      u4 = u4 + (z5[i4] & 255) | 0;
      z5[i4] = u4 & 255;
      u4 >>>= 8;
    }
    b4 -= 64;
    cpos += 64;
    mpos += 64;
  }
  if (b4 > 0) {
    core_salsa20(x5, z5, k5, sigma);
    for (i4 = 0; i4 < b4; i4++)
      c4[cpos + i4] = m4[mpos + i4] ^ x5[i4];
  }
  return 0;
}
function crypto_stream_xor(c4, cpos, m4, mpos, d4, n2, k5) {
  var s4 = new Uint8Array(32);
  core_hsalsa20(s4, n2, k5, sigma);
  var sn2 = new Uint8Array(8);
  for (var i4 = 0; i4 < 8; i4++)
    sn2[i4] = n2[i4 + 16];
  return crypto_stream_salsa20_xor(c4, cpos, m4, mpos, d4, sn2, s4);
}
var poly1305 = class {
  constructor(key) {
    this.buffer = new Uint8Array(16);
    this.r = new Uint16Array(10);
    this.h = new Uint16Array(10);
    this.pad = new Uint16Array(8);
    this.leftover = 0;
    this.fin = 0;
    var t0, t1, t22, t32, t4, t5, t6, t7;
    t0 = key[0] & 255 | (key[1] & 255) << 8;
    this.r[0] = t0 & 8191;
    t1 = key[2] & 255 | (key[3] & 255) << 8;
    this.r[1] = (t0 >>> 13 | t1 << 3) & 8191;
    t22 = key[4] & 255 | (key[5] & 255) << 8;
    this.r[2] = (t1 >>> 10 | t22 << 6) & 7939;
    t32 = key[6] & 255 | (key[7] & 255) << 8;
    this.r[3] = (t22 >>> 7 | t32 << 9) & 8191;
    t4 = key[8] & 255 | (key[9] & 255) << 8;
    this.r[4] = (t32 >>> 4 | t4 << 12) & 255;
    this.r[5] = t4 >>> 1 & 8190;
    t5 = key[10] & 255 | (key[11] & 255) << 8;
    this.r[6] = (t4 >>> 14 | t5 << 2) & 8191;
    t6 = key[12] & 255 | (key[13] & 255) << 8;
    this.r[7] = (t5 >>> 11 | t6 << 5) & 8065;
    t7 = key[14] & 255 | (key[15] & 255) << 8;
    this.r[8] = (t6 >>> 8 | t7 << 8) & 8191;
    this.r[9] = t7 >>> 5 & 127;
    this.pad[0] = key[16] & 255 | (key[17] & 255) << 8;
    this.pad[1] = key[18] & 255 | (key[19] & 255) << 8;
    this.pad[2] = key[20] & 255 | (key[21] & 255) << 8;
    this.pad[3] = key[22] & 255 | (key[23] & 255) << 8;
    this.pad[4] = key[24] & 255 | (key[25] & 255) << 8;
    this.pad[5] = key[26] & 255 | (key[27] & 255) << 8;
    this.pad[6] = key[28] & 255 | (key[29] & 255) << 8;
    this.pad[7] = key[30] & 255 | (key[31] & 255) << 8;
  }
  blocks(m4, mpos, bytes) {
    var hibit = this.fin ? 0 : 1 << 11;
    var t0, t1, t22, t32, t4, t5, t6, t7, c4;
    var d0, d1, d23, d32, d4, d5, d6, d7, d8, d9;
    var h0 = this.h[0], h1 = this.h[1], h22 = this.h[2], h3 = this.h[3], h4 = this.h[4], h5 = this.h[5], h6 = this.h[6], h7 = this.h[7], h8 = this.h[8], h9 = this.h[9];
    var r0 = this.r[0], r1 = this.r[1], r22 = this.r[2], r3 = this.r[3], r4 = this.r[4], r5 = this.r[5], r6 = this.r[6], r7 = this.r[7], r8 = this.r[8], r9 = this.r[9];
    while (bytes >= 16) {
      t0 = m4[mpos + 0] & 255 | (m4[mpos + 1] & 255) << 8;
      h0 += t0 & 8191;
      t1 = m4[mpos + 2] & 255 | (m4[mpos + 3] & 255) << 8;
      h1 += (t0 >>> 13 | t1 << 3) & 8191;
      t22 = m4[mpos + 4] & 255 | (m4[mpos + 5] & 255) << 8;
      h22 += (t1 >>> 10 | t22 << 6) & 8191;
      t32 = m4[mpos + 6] & 255 | (m4[mpos + 7] & 255) << 8;
      h3 += (t22 >>> 7 | t32 << 9) & 8191;
      t4 = m4[mpos + 8] & 255 | (m4[mpos + 9] & 255) << 8;
      h4 += (t32 >>> 4 | t4 << 12) & 8191;
      h5 += t4 >>> 1 & 8191;
      t5 = m4[mpos + 10] & 255 | (m4[mpos + 11] & 255) << 8;
      h6 += (t4 >>> 14 | t5 << 2) & 8191;
      t6 = m4[mpos + 12] & 255 | (m4[mpos + 13] & 255) << 8;
      h7 += (t5 >>> 11 | t6 << 5) & 8191;
      t7 = m4[mpos + 14] & 255 | (m4[mpos + 15] & 255) << 8;
      h8 += (t6 >>> 8 | t7 << 8) & 8191;
      h9 += t7 >>> 5 | hibit;
      c4 = 0;
      d0 = c4;
      d0 += h0 * r0;
      d0 += h1 * (5 * r9);
      d0 += h22 * (5 * r8);
      d0 += h3 * (5 * r7);
      d0 += h4 * (5 * r6);
      c4 = d0 >>> 13;
      d0 &= 8191;
      d0 += h5 * (5 * r5);
      d0 += h6 * (5 * r4);
      d0 += h7 * (5 * r3);
      d0 += h8 * (5 * r22);
      d0 += h9 * (5 * r1);
      c4 += d0 >>> 13;
      d0 &= 8191;
      d1 = c4;
      d1 += h0 * r1;
      d1 += h1 * r0;
      d1 += h22 * (5 * r9);
      d1 += h3 * (5 * r8);
      d1 += h4 * (5 * r7);
      c4 = d1 >>> 13;
      d1 &= 8191;
      d1 += h5 * (5 * r6);
      d1 += h6 * (5 * r5);
      d1 += h7 * (5 * r4);
      d1 += h8 * (5 * r3);
      d1 += h9 * (5 * r22);
      c4 += d1 >>> 13;
      d1 &= 8191;
      d23 = c4;
      d23 += h0 * r22;
      d23 += h1 * r1;
      d23 += h22 * r0;
      d23 += h3 * (5 * r9);
      d23 += h4 * (5 * r8);
      c4 = d23 >>> 13;
      d23 &= 8191;
      d23 += h5 * (5 * r7);
      d23 += h6 * (5 * r6);
      d23 += h7 * (5 * r5);
      d23 += h8 * (5 * r4);
      d23 += h9 * (5 * r3);
      c4 += d23 >>> 13;
      d23 &= 8191;
      d32 = c4;
      d32 += h0 * r3;
      d32 += h1 * r22;
      d32 += h22 * r1;
      d32 += h3 * r0;
      d32 += h4 * (5 * r9);
      c4 = d32 >>> 13;
      d32 &= 8191;
      d32 += h5 * (5 * r8);
      d32 += h6 * (5 * r7);
      d32 += h7 * (5 * r6);
      d32 += h8 * (5 * r5);
      d32 += h9 * (5 * r4);
      c4 += d32 >>> 13;
      d32 &= 8191;
      d4 = c4;
      d4 += h0 * r4;
      d4 += h1 * r3;
      d4 += h22 * r22;
      d4 += h3 * r1;
      d4 += h4 * r0;
      c4 = d4 >>> 13;
      d4 &= 8191;
      d4 += h5 * (5 * r9);
      d4 += h6 * (5 * r8);
      d4 += h7 * (5 * r7);
      d4 += h8 * (5 * r6);
      d4 += h9 * (5 * r5);
      c4 += d4 >>> 13;
      d4 &= 8191;
      d5 = c4;
      d5 += h0 * r5;
      d5 += h1 * r4;
      d5 += h22 * r3;
      d5 += h3 * r22;
      d5 += h4 * r1;
      c4 = d5 >>> 13;
      d5 &= 8191;
      d5 += h5 * r0;
      d5 += h6 * (5 * r9);
      d5 += h7 * (5 * r8);
      d5 += h8 * (5 * r7);
      d5 += h9 * (5 * r6);
      c4 += d5 >>> 13;
      d5 &= 8191;
      d6 = c4;
      d6 += h0 * r6;
      d6 += h1 * r5;
      d6 += h22 * r4;
      d6 += h3 * r3;
      d6 += h4 * r22;
      c4 = d6 >>> 13;
      d6 &= 8191;
      d6 += h5 * r1;
      d6 += h6 * r0;
      d6 += h7 * (5 * r9);
      d6 += h8 * (5 * r8);
      d6 += h9 * (5 * r7);
      c4 += d6 >>> 13;
      d6 &= 8191;
      d7 = c4;
      d7 += h0 * r7;
      d7 += h1 * r6;
      d7 += h22 * r5;
      d7 += h3 * r4;
      d7 += h4 * r3;
      c4 = d7 >>> 13;
      d7 &= 8191;
      d7 += h5 * r22;
      d7 += h6 * r1;
      d7 += h7 * r0;
      d7 += h8 * (5 * r9);
      d7 += h9 * (5 * r8);
      c4 += d7 >>> 13;
      d7 &= 8191;
      d8 = c4;
      d8 += h0 * r8;
      d8 += h1 * r7;
      d8 += h22 * r6;
      d8 += h3 * r5;
      d8 += h4 * r4;
      c4 = d8 >>> 13;
      d8 &= 8191;
      d8 += h5 * r3;
      d8 += h6 * r22;
      d8 += h7 * r1;
      d8 += h8 * r0;
      d8 += h9 * (5 * r9);
      c4 += d8 >>> 13;
      d8 &= 8191;
      d9 = c4;
      d9 += h0 * r9;
      d9 += h1 * r8;
      d9 += h22 * r7;
      d9 += h3 * r6;
      d9 += h4 * r5;
      c4 = d9 >>> 13;
      d9 &= 8191;
      d9 += h5 * r4;
      d9 += h6 * r3;
      d9 += h7 * r22;
      d9 += h8 * r1;
      d9 += h9 * r0;
      c4 += d9 >>> 13;
      d9 &= 8191;
      c4 = (c4 << 2) + c4 | 0;
      c4 = c4 + d0 | 0;
      d0 = c4 & 8191;
      c4 = c4 >>> 13;
      d1 += c4;
      h0 = d0;
      h1 = d1;
      h22 = d23;
      h3 = d32;
      h4 = d4;
      h5 = d5;
      h6 = d6;
      h7 = d7;
      h8 = d8;
      h9 = d9;
      mpos += 16;
      bytes -= 16;
    }
    this.h[0] = h0;
    this.h[1] = h1;
    this.h[2] = h22;
    this.h[3] = h3;
    this.h[4] = h4;
    this.h[5] = h5;
    this.h[6] = h6;
    this.h[7] = h7;
    this.h[8] = h8;
    this.h[9] = h9;
  }
  finish(mac, macpos) {
    var g4 = new Uint16Array(10);
    var c4, mask, f3, i4;
    if (this.leftover) {
      i4 = this.leftover;
      this.buffer[i4++] = 1;
      for (; i4 < 16; i4++)
        this.buffer[i4] = 0;
      this.fin = 1;
      this.blocks(this.buffer, 0, 16);
    }
    c4 = this.h[1] >>> 13;
    this.h[1] &= 8191;
    for (i4 = 2; i4 < 10; i4++) {
      this.h[i4] += c4;
      c4 = this.h[i4] >>> 13;
      this.h[i4] &= 8191;
    }
    this.h[0] += c4 * 5;
    c4 = this.h[0] >>> 13;
    this.h[0] &= 8191;
    this.h[1] += c4;
    c4 = this.h[1] >>> 13;
    this.h[1] &= 8191;
    this.h[2] += c4;
    g4[0] = this.h[0] + 5;
    c4 = g4[0] >>> 13;
    g4[0] &= 8191;
    for (i4 = 1; i4 < 10; i4++) {
      g4[i4] = this.h[i4] + c4;
      c4 = g4[i4] >>> 13;
      g4[i4] &= 8191;
    }
    g4[9] -= 1 << 13;
    mask = (c4 ^ 1) - 1;
    for (i4 = 0; i4 < 10; i4++)
      g4[i4] &= mask;
    mask = ~mask;
    for (i4 = 0; i4 < 10; i4++)
      this.h[i4] = this.h[i4] & mask | g4[i4];
    this.h[0] = (this.h[0] | this.h[1] << 13) & 65535;
    this.h[1] = (this.h[1] >>> 3 | this.h[2] << 10) & 65535;
    this.h[2] = (this.h[2] >>> 6 | this.h[3] << 7) & 65535;
    this.h[3] = (this.h[3] >>> 9 | this.h[4] << 4) & 65535;
    this.h[4] = (this.h[4] >>> 12 | this.h[5] << 1 | this.h[6] << 14) & 65535;
    this.h[5] = (this.h[6] >>> 2 | this.h[7] << 11) & 65535;
    this.h[6] = (this.h[7] >>> 5 | this.h[8] << 8) & 65535;
    this.h[7] = (this.h[8] >>> 8 | this.h[9] << 5) & 65535;
    f3 = this.h[0] + this.pad[0];
    this.h[0] = f3 & 65535;
    for (i4 = 1; i4 < 8; i4++) {
      f3 = (this.h[i4] + this.pad[i4] | 0) + (f3 >>> 16) | 0;
      this.h[i4] = f3 & 65535;
    }
    mac[macpos + 0] = this.h[0] >>> 0 & 255;
    mac[macpos + 1] = this.h[0] >>> 8 & 255;
    mac[macpos + 2] = this.h[1] >>> 0 & 255;
    mac[macpos + 3] = this.h[1] >>> 8 & 255;
    mac[macpos + 4] = this.h[2] >>> 0 & 255;
    mac[macpos + 5] = this.h[2] >>> 8 & 255;
    mac[macpos + 6] = this.h[3] >>> 0 & 255;
    mac[macpos + 7] = this.h[3] >>> 8 & 255;
    mac[macpos + 8] = this.h[4] >>> 0 & 255;
    mac[macpos + 9] = this.h[4] >>> 8 & 255;
    mac[macpos + 10] = this.h[5] >>> 0 & 255;
    mac[macpos + 11] = this.h[5] >>> 8 & 255;
    mac[macpos + 12] = this.h[6] >>> 0 & 255;
    mac[macpos + 13] = this.h[6] >>> 8 & 255;
    mac[macpos + 14] = this.h[7] >>> 0 & 255;
    mac[macpos + 15] = this.h[7] >>> 8 & 255;
  }
  update(m4, mpos, bytes) {
    let i4;
    let want;
    if (this.leftover) {
      want = 16 - this.leftover;
      if (want > bytes)
        want = bytes;
      for (i4 = 0; i4 < want; i4++)
        this.buffer[this.leftover + i4] = m4[mpos + i4];
      bytes -= want;
      mpos += want;
      this.leftover += want;
      if (this.leftover < 16)
        return;
      this.blocks(this.buffer, 0, 16);
      this.leftover = 0;
    }
    if (bytes >= 16) {
      want = bytes - bytes % 16;
      this.blocks(m4, mpos, want);
      mpos += want;
      bytes -= want;
    }
    if (bytes) {
      for (i4 = 0; i4 < bytes; i4++)
        this.buffer[this.leftover + i4] = m4[mpos + i4];
      this.leftover += bytes;
    }
  }
};
function crypto_onetimeauth(out, outpos, m4, mpos, n2, k5) {
  var s4 = new poly1305(k5);
  s4.update(m4, mpos, n2);
  s4.finish(out, outpos);
  return 0;
}
function crypto_secretbox(c4, m4, d4, n2, k5) {
  var i4;
  if (d4 < 32)
    return -1;
  crypto_stream_xor(c4, 0, m4, 0, d4, n2, k5);
  crypto_onetimeauth(c4, 16, c4, 32, d4 - 32, c4);
  for (i4 = 0; i4 < 16; i4++)
    c4[i4] = 0;
  return 0;
}
function set25519(r3, a4) {
  let i4;
  for (i4 = 0; i4 < 16; i4++)
    r3[i4] = a4[i4] | 0;
}
function car25519(o3) {
  let i4, v3, c4 = 1;
  for (i4 = 0; i4 < 16; i4++) {
    v3 = o3[i4] + c4 + 65535;
    c4 = Math.floor(v3 / 65536);
    o3[i4] = v3 - c4 * 65536;
  }
  o3[0] += c4 - 1 + 37 * (c4 - 1);
}
function sel25519(p4, q5, b4) {
  let t4;
  const c4 = ~(b4 - 1);
  for (let i4 = 0; i4 < 16; i4++) {
    t4 = c4 & (p4[i4] ^ q5[i4]);
    p4[i4] ^= t4;
    q5[i4] ^= t4;
  }
}
function pack25519(o3, n2) {
  let i4, j4, b4;
  const m4 = gf(), t4 = gf();
  for (i4 = 0; i4 < 16; i4++)
    t4[i4] = n2[i4];
  car25519(t4);
  car25519(t4);
  car25519(t4);
  for (j4 = 0; j4 < 2; j4++) {
    m4[0] = t4[0] - 65517;
    for (i4 = 1; i4 < 15; i4++) {
      m4[i4] = t4[i4] - 65535 - (m4[i4 - 1] >> 16 & 1);
      m4[i4 - 1] &= 65535;
    }
    m4[15] = t4[15] - 32767 - (m4[14] >> 16 & 1);
    b4 = m4[15] >> 16 & 1;
    m4[14] &= 65535;
    sel25519(t4, m4, 1 - b4);
  }
  for (i4 = 0; i4 < 16; i4++) {
    o3[2 * i4] = t4[i4] & 255;
    o3[2 * i4 + 1] = t4[i4] >> 8;
  }
}
function neq25519(a4, b4) {
  const c4 = new Uint8Array(32), d4 = new Uint8Array(32);
  pack25519(c4, a4);
  pack25519(d4, b4);
  return crypto_verify_32(c4, 0, d4, 0);
}
function par25519(a4) {
  const d4 = new Uint8Array(32);
  pack25519(d4, a4);
  return d4[0] & 1;
}
function unpack25519(o3, n2) {
  let i4;
  for (i4 = 0; i4 < 16; i4++)
    o3[i4] = n2[2 * i4] + (n2[2 * i4 + 1] << 8);
  o3[15] &= 32767;
}
function A(o3, a4, b4) {
  for (let i4 = 0; i4 < 16; i4++)
    o3[i4] = a4[i4] + b4[i4];
}
function Z(o3, a4, b4) {
  for (let i4 = 0; i4 < 16; i4++)
    o3[i4] = a4[i4] - b4[i4];
}
function M(o3, a4, b4) {
  let v3, c4, t0 = 0, t1 = 0, t22 = 0, t32 = 0, t4 = 0, t5 = 0, t6 = 0, t7 = 0, t8 = 0, t9 = 0, t10 = 0, t11 = 0, t12 = 0, t13 = 0, t14 = 0, t15 = 0, t16 = 0, t17 = 0, t18 = 0, t19 = 0, t20 = 0, t21 = 0, t222 = 0, t23 = 0, t24 = 0, t25 = 0, t26 = 0, t27 = 0, t28 = 0, t29 = 0, t30 = 0;
  const b0 = b4[0], b1 = b4[1], b22 = b4[2], b32 = b4[3], b42 = b4[4], b5 = b4[5], b6 = b4[6], b7 = b4[7], b8 = b4[8], b9 = b4[9], b10 = b4[10], b11 = b4[11], b12 = b4[12], b13 = b4[13], b14 = b4[14], b15 = b4[15];
  v3 = a4[0];
  t0 += v3 * b0;
  t1 += v3 * b1;
  t22 += v3 * b22;
  t32 += v3 * b32;
  t4 += v3 * b42;
  t5 += v3 * b5;
  t6 += v3 * b6;
  t7 += v3 * b7;
  t8 += v3 * b8;
  t9 += v3 * b9;
  t10 += v3 * b10;
  t11 += v3 * b11;
  t12 += v3 * b12;
  t13 += v3 * b13;
  t14 += v3 * b14;
  t15 += v3 * b15;
  v3 = a4[1];
  t1 += v3 * b0;
  t22 += v3 * b1;
  t32 += v3 * b22;
  t4 += v3 * b32;
  t5 += v3 * b42;
  t6 += v3 * b5;
  t7 += v3 * b6;
  t8 += v3 * b7;
  t9 += v3 * b8;
  t10 += v3 * b9;
  t11 += v3 * b10;
  t12 += v3 * b11;
  t13 += v3 * b12;
  t14 += v3 * b13;
  t15 += v3 * b14;
  t16 += v3 * b15;
  v3 = a4[2];
  t22 += v3 * b0;
  t32 += v3 * b1;
  t4 += v3 * b22;
  t5 += v3 * b32;
  t6 += v3 * b42;
  t7 += v3 * b5;
  t8 += v3 * b6;
  t9 += v3 * b7;
  t10 += v3 * b8;
  t11 += v3 * b9;
  t12 += v3 * b10;
  t13 += v3 * b11;
  t14 += v3 * b12;
  t15 += v3 * b13;
  t16 += v3 * b14;
  t17 += v3 * b15;
  v3 = a4[3];
  t32 += v3 * b0;
  t4 += v3 * b1;
  t5 += v3 * b22;
  t6 += v3 * b32;
  t7 += v3 * b42;
  t8 += v3 * b5;
  t9 += v3 * b6;
  t10 += v3 * b7;
  t11 += v3 * b8;
  t12 += v3 * b9;
  t13 += v3 * b10;
  t14 += v3 * b11;
  t15 += v3 * b12;
  t16 += v3 * b13;
  t17 += v3 * b14;
  t18 += v3 * b15;
  v3 = a4[4];
  t4 += v3 * b0;
  t5 += v3 * b1;
  t6 += v3 * b22;
  t7 += v3 * b32;
  t8 += v3 * b42;
  t9 += v3 * b5;
  t10 += v3 * b6;
  t11 += v3 * b7;
  t12 += v3 * b8;
  t13 += v3 * b9;
  t14 += v3 * b10;
  t15 += v3 * b11;
  t16 += v3 * b12;
  t17 += v3 * b13;
  t18 += v3 * b14;
  t19 += v3 * b15;
  v3 = a4[5];
  t5 += v3 * b0;
  t6 += v3 * b1;
  t7 += v3 * b22;
  t8 += v3 * b32;
  t9 += v3 * b42;
  t10 += v3 * b5;
  t11 += v3 * b6;
  t12 += v3 * b7;
  t13 += v3 * b8;
  t14 += v3 * b9;
  t15 += v3 * b10;
  t16 += v3 * b11;
  t17 += v3 * b12;
  t18 += v3 * b13;
  t19 += v3 * b14;
  t20 += v3 * b15;
  v3 = a4[6];
  t6 += v3 * b0;
  t7 += v3 * b1;
  t8 += v3 * b22;
  t9 += v3 * b32;
  t10 += v3 * b42;
  t11 += v3 * b5;
  t12 += v3 * b6;
  t13 += v3 * b7;
  t14 += v3 * b8;
  t15 += v3 * b9;
  t16 += v3 * b10;
  t17 += v3 * b11;
  t18 += v3 * b12;
  t19 += v3 * b13;
  t20 += v3 * b14;
  t21 += v3 * b15;
  v3 = a4[7];
  t7 += v3 * b0;
  t8 += v3 * b1;
  t9 += v3 * b22;
  t10 += v3 * b32;
  t11 += v3 * b42;
  t12 += v3 * b5;
  t13 += v3 * b6;
  t14 += v3 * b7;
  t15 += v3 * b8;
  t16 += v3 * b9;
  t17 += v3 * b10;
  t18 += v3 * b11;
  t19 += v3 * b12;
  t20 += v3 * b13;
  t21 += v3 * b14;
  t222 += v3 * b15;
  v3 = a4[8];
  t8 += v3 * b0;
  t9 += v3 * b1;
  t10 += v3 * b22;
  t11 += v3 * b32;
  t12 += v3 * b42;
  t13 += v3 * b5;
  t14 += v3 * b6;
  t15 += v3 * b7;
  t16 += v3 * b8;
  t17 += v3 * b9;
  t18 += v3 * b10;
  t19 += v3 * b11;
  t20 += v3 * b12;
  t21 += v3 * b13;
  t222 += v3 * b14;
  t23 += v3 * b15;
  v3 = a4[9];
  t9 += v3 * b0;
  t10 += v3 * b1;
  t11 += v3 * b22;
  t12 += v3 * b32;
  t13 += v3 * b42;
  t14 += v3 * b5;
  t15 += v3 * b6;
  t16 += v3 * b7;
  t17 += v3 * b8;
  t18 += v3 * b9;
  t19 += v3 * b10;
  t20 += v3 * b11;
  t21 += v3 * b12;
  t222 += v3 * b13;
  t23 += v3 * b14;
  t24 += v3 * b15;
  v3 = a4[10];
  t10 += v3 * b0;
  t11 += v3 * b1;
  t12 += v3 * b22;
  t13 += v3 * b32;
  t14 += v3 * b42;
  t15 += v3 * b5;
  t16 += v3 * b6;
  t17 += v3 * b7;
  t18 += v3 * b8;
  t19 += v3 * b9;
  t20 += v3 * b10;
  t21 += v3 * b11;
  t222 += v3 * b12;
  t23 += v3 * b13;
  t24 += v3 * b14;
  t25 += v3 * b15;
  v3 = a4[11];
  t11 += v3 * b0;
  t12 += v3 * b1;
  t13 += v3 * b22;
  t14 += v3 * b32;
  t15 += v3 * b42;
  t16 += v3 * b5;
  t17 += v3 * b6;
  t18 += v3 * b7;
  t19 += v3 * b8;
  t20 += v3 * b9;
  t21 += v3 * b10;
  t222 += v3 * b11;
  t23 += v3 * b12;
  t24 += v3 * b13;
  t25 += v3 * b14;
  t26 += v3 * b15;
  v3 = a4[12];
  t12 += v3 * b0;
  t13 += v3 * b1;
  t14 += v3 * b22;
  t15 += v3 * b32;
  t16 += v3 * b42;
  t17 += v3 * b5;
  t18 += v3 * b6;
  t19 += v3 * b7;
  t20 += v3 * b8;
  t21 += v3 * b9;
  t222 += v3 * b10;
  t23 += v3 * b11;
  t24 += v3 * b12;
  t25 += v3 * b13;
  t26 += v3 * b14;
  t27 += v3 * b15;
  v3 = a4[13];
  t13 += v3 * b0;
  t14 += v3 * b1;
  t15 += v3 * b22;
  t16 += v3 * b32;
  t17 += v3 * b42;
  t18 += v3 * b5;
  t19 += v3 * b6;
  t20 += v3 * b7;
  t21 += v3 * b8;
  t222 += v3 * b9;
  t23 += v3 * b10;
  t24 += v3 * b11;
  t25 += v3 * b12;
  t26 += v3 * b13;
  t27 += v3 * b14;
  t28 += v3 * b15;
  v3 = a4[14];
  t14 += v3 * b0;
  t15 += v3 * b1;
  t16 += v3 * b22;
  t17 += v3 * b32;
  t18 += v3 * b42;
  t19 += v3 * b5;
  t20 += v3 * b6;
  t21 += v3 * b7;
  t222 += v3 * b8;
  t23 += v3 * b9;
  t24 += v3 * b10;
  t25 += v3 * b11;
  t26 += v3 * b12;
  t27 += v3 * b13;
  t28 += v3 * b14;
  t29 += v3 * b15;
  v3 = a4[15];
  t15 += v3 * b0;
  t16 += v3 * b1;
  t17 += v3 * b22;
  t18 += v3 * b32;
  t19 += v3 * b42;
  t20 += v3 * b5;
  t21 += v3 * b6;
  t222 += v3 * b7;
  t23 += v3 * b8;
  t24 += v3 * b9;
  t25 += v3 * b10;
  t26 += v3 * b11;
  t27 += v3 * b12;
  t28 += v3 * b13;
  t29 += v3 * b14;
  t30 += v3 * b15;
  t0 += 38 * t16;
  t1 += 38 * t17;
  t22 += 38 * t18;
  t32 += 38 * t19;
  t4 += 38 * t20;
  t5 += 38 * t21;
  t6 += 38 * t222;
  t7 += 38 * t23;
  t8 += 38 * t24;
  t9 += 38 * t25;
  t10 += 38 * t26;
  t11 += 38 * t27;
  t12 += 38 * t28;
  t13 += 38 * t29;
  t14 += 38 * t30;
  c4 = 1;
  v3 = t0 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t0 = v3 - c4 * 65536;
  v3 = t1 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t1 = v3 - c4 * 65536;
  v3 = t22 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t22 = v3 - c4 * 65536;
  v3 = t32 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t32 = v3 - c4 * 65536;
  v3 = t4 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t4 = v3 - c4 * 65536;
  v3 = t5 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t5 = v3 - c4 * 65536;
  v3 = t6 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t6 = v3 - c4 * 65536;
  v3 = t7 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t7 = v3 - c4 * 65536;
  v3 = t8 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t8 = v3 - c4 * 65536;
  v3 = t9 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t9 = v3 - c4 * 65536;
  v3 = t10 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t10 = v3 - c4 * 65536;
  v3 = t11 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t11 = v3 - c4 * 65536;
  v3 = t12 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t12 = v3 - c4 * 65536;
  v3 = t13 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t13 = v3 - c4 * 65536;
  v3 = t14 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t14 = v3 - c4 * 65536;
  v3 = t15 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t15 = v3 - c4 * 65536;
  t0 += c4 - 1 + 37 * (c4 - 1);
  c4 = 1;
  v3 = t0 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t0 = v3 - c4 * 65536;
  v3 = t1 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t1 = v3 - c4 * 65536;
  v3 = t22 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t22 = v3 - c4 * 65536;
  v3 = t32 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t32 = v3 - c4 * 65536;
  v3 = t4 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t4 = v3 - c4 * 65536;
  v3 = t5 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t5 = v3 - c4 * 65536;
  v3 = t6 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t6 = v3 - c4 * 65536;
  v3 = t7 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t7 = v3 - c4 * 65536;
  v3 = t8 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t8 = v3 - c4 * 65536;
  v3 = t9 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t9 = v3 - c4 * 65536;
  v3 = t10 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t10 = v3 - c4 * 65536;
  v3 = t11 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t11 = v3 - c4 * 65536;
  v3 = t12 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t12 = v3 - c4 * 65536;
  v3 = t13 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t13 = v3 - c4 * 65536;
  v3 = t14 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t14 = v3 - c4 * 65536;
  v3 = t15 + c4 + 65535;
  c4 = Math.floor(v3 / 65536);
  t15 = v3 - c4 * 65536;
  t0 += c4 - 1 + 37 * (c4 - 1);
  o3[0] = t0;
  o3[1] = t1;
  o3[2] = t22;
  o3[3] = t32;
  o3[4] = t4;
  o3[5] = t5;
  o3[6] = t6;
  o3[7] = t7;
  o3[8] = t8;
  o3[9] = t9;
  o3[10] = t10;
  o3[11] = t11;
  o3[12] = t12;
  o3[13] = t13;
  o3[14] = t14;
  o3[15] = t15;
}
function S(o3, a4) {
  M(o3, a4, a4);
}
function inv25519(o3, i4) {
  const c4 = gf();
  let a4;
  for (a4 = 0; a4 < 16; a4++)
    c4[a4] = i4[a4];
  for (a4 = 253; a4 >= 0; a4--) {
    S(c4, c4);
    if (a4 !== 2 && a4 !== 4)
      M(c4, c4, i4);
  }
  for (a4 = 0; a4 < 16; a4++)
    o3[a4] = c4[a4];
}
function pow2523(o3, i4) {
  const c4 = gf();
  let a4;
  for (a4 = 0; a4 < 16; a4++)
    c4[a4] = i4[a4];
  for (a4 = 250; a4 >= 0; a4--) {
    S(c4, c4);
    if (a4 !== 1)
      M(c4, c4, i4);
  }
  for (a4 = 0; a4 < 16; a4++)
    o3[a4] = c4[a4];
}
var K = [
  1116352408,
  3609767458,
  1899447441,
  602891725,
  3049323471,
  3964484399,
  3921009573,
  2173295548,
  961987163,
  4081628472,
  1508970993,
  3053834265,
  2453635748,
  2937671579,
  2870763221,
  3664609560,
  3624381080,
  2734883394,
  310598401,
  1164996542,
  607225278,
  1323610764,
  1426881987,
  3590304994,
  1925078388,
  4068182383,
  2162078206,
  991336113,
  2614888103,
  633803317,
  3248222580,
  3479774868,
  3835390401,
  2666613458,
  4022224774,
  944711139,
  264347078,
  2341262773,
  604807628,
  2007800933,
  770255983,
  1495990901,
  1249150122,
  1856431235,
  1555081692,
  3175218132,
  1996064986,
  2198950837,
  2554220882,
  3999719339,
  2821834349,
  766784016,
  2952996808,
  2566594879,
  3210313671,
  3203337956,
  3336571891,
  1034457026,
  3584528711,
  2466948901,
  113926993,
  3758326383,
  338241895,
  168717936,
  666307205,
  1188179964,
  773529912,
  1546045734,
  1294757372,
  1522805485,
  1396182291,
  2643833823,
  1695183700,
  2343527390,
  1986661051,
  1014477480,
  2177026350,
  1206759142,
  2456956037,
  344077627,
  2730485921,
  1290863460,
  2820302411,
  3158454273,
  3259730800,
  3505952657,
  3345764771,
  106217008,
  3516065817,
  3606008344,
  3600352804,
  1432725776,
  4094571909,
  1467031594,
  275423344,
  851169720,
  430227734,
  3100823752,
  506948616,
  1363258195,
  659060556,
  3750685593,
  883997877,
  3785050280,
  958139571,
  3318307427,
  1322822218,
  3812723403,
  1537002063,
  2003034995,
  1747873779,
  3602036899,
  1955562222,
  1575990012,
  2024104815,
  1125592928,
  2227730452,
  2716904306,
  2361852424,
  442776044,
  2428436474,
  593698344,
  2756734187,
  3733110249,
  3204031479,
  2999351573,
  3329325298,
  3815920427,
  3391569614,
  3928383900,
  3515267271,
  566280711,
  3940187606,
  3454069534,
  4118630271,
  4000239992,
  116418474,
  1914138554,
  174292421,
  2731055270,
  289380356,
  3203993006,
  460393269,
  320620315,
  685471733,
  587496836,
  852142971,
  1086792851,
  1017036298,
  365543100,
  1126000580,
  2618297676,
  1288033470,
  3409855158,
  1501505948,
  4234509866,
  1607167915,
  987167468,
  1816402316,
  1246189591
];
function crypto_hashblocks_hl(hh, hl, m4, n2) {
  const wh = new Int32Array(16), wl = new Int32Array(16);
  let bh0, bh1, bh2, bh3, bh4, bh5, bh6, bh7, bl0, bl1, bl2, bl3, bl4, bl5, bl6, bl7, th, tl, i4, j4, h3, l3, a4, b4, c4, d4;
  let ah0 = hh[0], ah1 = hh[1], ah2 = hh[2], ah3 = hh[3], ah4 = hh[4], ah5 = hh[5], ah6 = hh[6], ah7 = hh[7], al0 = hl[0], al1 = hl[1], al2 = hl[2], al3 = hl[3], al4 = hl[4], al5 = hl[5], al6 = hl[6], al7 = hl[7];
  let pos = 0;
  while (n2 >= 128) {
    for (i4 = 0; i4 < 16; i4++) {
      j4 = 8 * i4 + pos;
      wh[i4] = m4[j4 + 0] << 24 | m4[j4 + 1] << 16 | m4[j4 + 2] << 8 | m4[j4 + 3];
      wl[i4] = m4[j4 + 4] << 24 | m4[j4 + 5] << 16 | m4[j4 + 6] << 8 | m4[j4 + 7];
    }
    for (i4 = 0; i4 < 80; i4++) {
      bh0 = ah0;
      bh1 = ah1;
      bh2 = ah2;
      bh3 = ah3;
      bh4 = ah4;
      bh5 = ah5;
      bh6 = ah6;
      bh7 = ah7;
      bl0 = al0;
      bl1 = al1;
      bl2 = al2;
      bl3 = al3;
      bl4 = al4;
      bl5 = al5;
      bl6 = al6;
      bl7 = al7;
      h3 = ah7;
      l3 = al7;
      a4 = l3 & 65535;
      b4 = l3 >>> 16;
      c4 = h3 & 65535;
      d4 = h3 >>> 16;
      h3 = (ah4 >>> 14 | al4 << 32 - 14) ^ (ah4 >>> 18 | al4 << 32 - 18) ^ (al4 >>> 41 - 32 | ah4 << 32 - (41 - 32));
      l3 = (al4 >>> 14 | ah4 << 32 - 14) ^ (al4 >>> 18 | ah4 << 32 - 18) ^ (ah4 >>> 41 - 32 | al4 << 32 - (41 - 32));
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      h3 = ah4 & ah5 ^ ~ah4 & ah6;
      l3 = al4 & al5 ^ ~al4 & al6;
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      h3 = K[i4 * 2];
      l3 = K[i4 * 2 + 1];
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      h3 = wh[i4 % 16];
      l3 = wl[i4 % 16];
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      b4 += a4 >>> 16;
      c4 += b4 >>> 16;
      d4 += c4 >>> 16;
      th = c4 & 65535 | d4 << 16;
      tl = a4 & 65535 | b4 << 16;
      h3 = th;
      l3 = tl;
      a4 = l3 & 65535;
      b4 = l3 >>> 16;
      c4 = h3 & 65535;
      d4 = h3 >>> 16;
      h3 = (ah0 >>> 28 | al0 << 32 - 28) ^ (al0 >>> 34 - 32 | ah0 << 32 - (34 - 32)) ^ (al0 >>> 39 - 32 | ah0 << 32 - (39 - 32));
      l3 = (al0 >>> 28 | ah0 << 32 - 28) ^ (ah0 >>> 34 - 32 | al0 << 32 - (34 - 32)) ^ (ah0 >>> 39 - 32 | al0 << 32 - (39 - 32));
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      h3 = ah0 & ah1 ^ ah0 & ah2 ^ ah1 & ah2;
      l3 = al0 & al1 ^ al0 & al2 ^ al1 & al2;
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      b4 += a4 >>> 16;
      c4 += b4 >>> 16;
      d4 += c4 >>> 16;
      bh7 = c4 & 65535 | d4 << 16;
      bl7 = a4 & 65535 | b4 << 16;
      h3 = bh3;
      l3 = bl3;
      a4 = l3 & 65535;
      b4 = l3 >>> 16;
      c4 = h3 & 65535;
      d4 = h3 >>> 16;
      h3 = th;
      l3 = tl;
      a4 += l3 & 65535;
      b4 += l3 >>> 16;
      c4 += h3 & 65535;
      d4 += h3 >>> 16;
      b4 += a4 >>> 16;
      c4 += b4 >>> 16;
      d4 += c4 >>> 16;
      bh3 = c4 & 65535 | d4 << 16;
      bl3 = a4 & 65535 | b4 << 16;
      ah1 = bh0;
      ah2 = bh1;
      ah3 = bh2;
      ah4 = bh3;
      ah5 = bh4;
      ah6 = bh5;
      ah7 = bh6;
      ah0 = bh7;
      al1 = bl0;
      al2 = bl1;
      al3 = bl2;
      al4 = bl3;
      al5 = bl4;
      al6 = bl5;
      al7 = bl6;
      al0 = bl7;
      if (i4 % 16 === 15) {
        for (j4 = 0; j4 < 16; j4++) {
          h3 = wh[j4];
          l3 = wl[j4];
          a4 = l3 & 65535;
          b4 = l3 >>> 16;
          c4 = h3 & 65535;
          d4 = h3 >>> 16;
          h3 = wh[(j4 + 9) % 16];
          l3 = wl[(j4 + 9) % 16];
          a4 += l3 & 65535;
          b4 += l3 >>> 16;
          c4 += h3 & 65535;
          d4 += h3 >>> 16;
          th = wh[(j4 + 1) % 16];
          tl = wl[(j4 + 1) % 16];
          h3 = (th >>> 1 | tl << 32 - 1) ^ (th >>> 8 | tl << 32 - 8) ^ th >>> 7;
          l3 = (tl >>> 1 | th << 32 - 1) ^ (tl >>> 8 | th << 32 - 8) ^ (tl >>> 7 | th << 32 - 7);
          a4 += l3 & 65535;
          b4 += l3 >>> 16;
          c4 += h3 & 65535;
          d4 += h3 >>> 16;
          th = wh[(j4 + 14) % 16];
          tl = wl[(j4 + 14) % 16];
          h3 = (th >>> 19 | tl << 32 - 19) ^ (tl >>> 61 - 32 | th << 32 - (61 - 32)) ^ th >>> 6;
          l3 = (tl >>> 19 | th << 32 - 19) ^ (th >>> 61 - 32 | tl << 32 - (61 - 32)) ^ (tl >>> 6 | th << 32 - 6);
          a4 += l3 & 65535;
          b4 += l3 >>> 16;
          c4 += h3 & 65535;
          d4 += h3 >>> 16;
          b4 += a4 >>> 16;
          c4 += b4 >>> 16;
          d4 += c4 >>> 16;
          wh[j4] = c4 & 65535 | d4 << 16;
          wl[j4] = a4 & 65535 | b4 << 16;
        }
      }
    }
    h3 = ah0;
    l3 = al0;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[0];
    l3 = hl[0];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[0] = ah0 = c4 & 65535 | d4 << 16;
    hl[0] = al0 = a4 & 65535 | b4 << 16;
    h3 = ah1;
    l3 = al1;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[1];
    l3 = hl[1];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[1] = ah1 = c4 & 65535 | d4 << 16;
    hl[1] = al1 = a4 & 65535 | b4 << 16;
    h3 = ah2;
    l3 = al2;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[2];
    l3 = hl[2];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[2] = ah2 = c4 & 65535 | d4 << 16;
    hl[2] = al2 = a4 & 65535 | b4 << 16;
    h3 = ah3;
    l3 = al3;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[3];
    l3 = hl[3];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[3] = ah3 = c4 & 65535 | d4 << 16;
    hl[3] = al3 = a4 & 65535 | b4 << 16;
    h3 = ah4;
    l3 = al4;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[4];
    l3 = hl[4];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[4] = ah4 = c4 & 65535 | d4 << 16;
    hl[4] = al4 = a4 & 65535 | b4 << 16;
    h3 = ah5;
    l3 = al5;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[5];
    l3 = hl[5];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[5] = ah5 = c4 & 65535 | d4 << 16;
    hl[5] = al5 = a4 & 65535 | b4 << 16;
    h3 = ah6;
    l3 = al6;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[6];
    l3 = hl[6];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[6] = ah6 = c4 & 65535 | d4 << 16;
    hl[6] = al6 = a4 & 65535 | b4 << 16;
    h3 = ah7;
    l3 = al7;
    a4 = l3 & 65535;
    b4 = l3 >>> 16;
    c4 = h3 & 65535;
    d4 = h3 >>> 16;
    h3 = hh[7];
    l3 = hl[7];
    a4 += l3 & 65535;
    b4 += l3 >>> 16;
    c4 += h3 & 65535;
    d4 += h3 >>> 16;
    b4 += a4 >>> 16;
    c4 += b4 >>> 16;
    d4 += c4 >>> 16;
    hh[7] = ah7 = c4 & 65535 | d4 << 16;
    hl[7] = al7 = a4 & 65535 | b4 << 16;
    pos += 128;
    n2 -= 128;
  }
  return n2;
}
function crypto_hash(out, m4, n2) {
  const hh = new Int32Array(8);
  const hl = new Int32Array(8);
  const x5 = new Uint8Array(256);
  const b4 = n2;
  hh[0] = 1779033703;
  hh[1] = 3144134277;
  hh[2] = 1013904242;
  hh[3] = 2773480762;
  hh[4] = 1359893119;
  hh[5] = 2600822924;
  hh[6] = 528734635;
  hh[7] = 1541459225;
  hl[0] = 4089235720;
  hl[1] = 2227873595;
  hl[2] = 4271175723;
  hl[3] = 1595750129;
  hl[4] = 2917565137;
  hl[5] = 725511199;
  hl[6] = 4215389547;
  hl[7] = 327033209;
  crypto_hashblocks_hl(hh, hl, m4, n2);
  n2 %= 128;
  for (let i4 = 0; i4 < n2; i4++)
    x5[i4] = m4[b4 - n2 + i4];
  x5[n2] = 128;
  n2 = 256 - 128 * (n2 < 112 ? 1 : 0);
  x5[n2 - 9] = 0;
  ts64(x5, n2 - 8, b4 / 536870912 | 0, b4 << 3);
  crypto_hashblocks_hl(hh, hl, x5, n2);
  for (let i4 = 0; i4 < 8; i4++)
    ts64(out, 8 * i4, hh[i4], hl[i4]);
  return 0;
}
var HashState = class {
  constructor() {
    this.hh = new Int32Array(8);
    this.hl = new Int32Array(8);
    this.next = new Uint8Array(128);
    this.p = 0;
    this.total = 0;
    this.hh[0] = 1779033703;
    this.hh[1] = 3144134277;
    this.hh[2] = 1013904242;
    this.hh[3] = 2773480762;
    this.hh[4] = 1359893119;
    this.hh[5] = 2600822924;
    this.hh[6] = 528734635;
    this.hh[7] = 1541459225;
    this.hl[0] = 4089235720;
    this.hl[1] = 2227873595;
    this.hl[2] = 4271175723;
    this.hl[3] = 1595750129;
    this.hl[4] = 2917565137;
    this.hl[5] = 725511199;
    this.hl[6] = 4215389547;
    this.hl[7] = 327033209;
  }
  update(data) {
    this.total += data.length;
    let i4 = 0;
    while (i4 < data.length) {
      const r3 = 128 - this.p;
      if (r3 > data.length - i4) {
        for (let j4 = 0; i4 + j4 < data.length; j4++) {
          this.next[this.p + j4] = data[i4 + j4];
        }
        this.p += data.length - i4;
        break;
      } else {
        for (let j4 = 0; this.p + j4 < 128; j4++) {
          this.next[this.p + j4] = data[i4 + j4];
        }
        crypto_hashblocks_hl(this.hh, this.hl, this.next, 128);
        i4 += 128 - this.p;
        this.p = 0;
      }
    }
    return this;
  }
  finish() {
    const out = new Uint8Array(64);
    let n2 = this.p;
    const x5 = new Uint8Array(256);
    const b4 = this.total;
    for (let i4 = 0; i4 < n2; i4++)
      x5[i4] = this.next[i4];
    x5[n2] = 128;
    n2 = 256 - 128 * (n2 < 112 ? 1 : 0);
    x5[n2 - 9] = 0;
    ts64(x5, n2 - 8, b4 / 536870912 | 0, b4 << 3);
    crypto_hashblocks_hl(this.hh, this.hl, x5, n2);
    for (let i4 = 0; i4 < 8; i4++)
      ts64(out, 8 * i4, this.hh[i4], this.hl[i4]);
    return out;
  }
};
function add(p4, q5) {
  const a4 = gf(), b4 = gf(), c4 = gf(), d4 = gf(), e4 = gf(), f3 = gf(), g4 = gf(), h3 = gf(), t4 = gf();
  Z(a4, p4[1], p4[0]);
  Z(t4, q5[1], q5[0]);
  M(a4, a4, t4);
  A(b4, p4[0], p4[1]);
  A(t4, q5[0], q5[1]);
  M(b4, b4, t4);
  M(c4, p4[3], q5[3]);
  M(c4, c4, D2);
  M(d4, p4[2], q5[2]);
  A(d4, d4, d4);
  Z(e4, b4, a4);
  Z(f3, d4, c4);
  A(g4, d4, c4);
  A(h3, b4, a4);
  M(p4[0], e4, f3);
  M(p4[1], h3, g4);
  M(p4[2], g4, f3);
  M(p4[3], e4, h3);
}
function cswap(p4, q5, b4) {
  let i4;
  for (i4 = 0; i4 < 4; i4++) {
    sel25519(p4[i4], q5[i4], b4);
  }
}
function pack(r3, p4) {
  const tx = gf(), ty = gf(), zi = gf();
  inv25519(zi, p4[2]);
  M(tx, p4[0], zi);
  M(ty, p4[1], zi);
  pack25519(r3, ty);
  r3[31] ^= par25519(tx) << 7;
}
function scalarmult(p4, q5, s4) {
  let b4, i4;
  set25519(p4[0], gf0);
  set25519(p4[1], gf1);
  set25519(p4[2], gf1);
  set25519(p4[3], gf0);
  for (i4 = 255; i4 >= 0; --i4) {
    b4 = s4[i4 / 8 | 0] >> (i4 & 7) & 1;
    cswap(p4, q5, b4);
    add(q5, p4);
    add(p4, p4);
    cswap(p4, q5, b4);
  }
}
function scalarbase(p4, s4) {
  const q5 = [gf(), gf(), gf(), gf()];
  set25519(q5[0], X);
  set25519(q5[1], Y);
  set25519(q5[2], gf1);
  M(q5[3], X, Y);
  scalarmult(p4, q5, s4);
}
function crypto_sign_keypair(pk, sk, seeded) {
  const d4 = new Uint8Array(64);
  const p4 = [gf(), gf(), gf(), gf()];
  if (!seeded)
    randombytes(sk, 32);
  crypto_hash(d4, sk, 32);
  d4[0] &= 248;
  d4[31] &= 127;
  d4[31] |= 64;
  scalarbase(p4, d4);
  pack(pk, p4);
  for (let i4 = 0; i4 < 32; i4++)
    sk[i4 + 32] = pk[i4];
  return 0;
}
var L = new Float64Array([
  237,
  211,
  245,
  92,
  26,
  99,
  18,
  88,
  214,
  156,
  247,
  162,
  222,
  249,
  222,
  20,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  16
]);
function modL(r3, x5) {
  let carry, i4, j4, k5;
  for (i4 = 63; i4 >= 32; --i4) {
    carry = 0;
    for (j4 = i4 - 32, k5 = i4 - 12; j4 < k5; ++j4) {
      x5[j4] += carry - 16 * x5[i4] * L[j4 - (i4 - 32)];
      carry = Math.floor((x5[j4] + 128) / 256);
      x5[j4] -= carry * 256;
    }
    x5[j4] += carry;
    x5[i4] = 0;
  }
  carry = 0;
  for (j4 = 0; j4 < 32; j4++) {
    x5[j4] += carry - (x5[31] >> 4) * L[j4];
    carry = x5[j4] >> 8;
    x5[j4] &= 255;
  }
  for (j4 = 0; j4 < 32; j4++)
    x5[j4] -= carry * L[j4];
  for (i4 = 0; i4 < 32; i4++) {
    x5[i4 + 1] += x5[i4] >> 8;
    r3[i4] = x5[i4] & 255;
  }
}
function reduce(r3) {
  const x5 = new Float64Array(64);
  for (let i4 = 0; i4 < 64; i4++)
    x5[i4] = r3[i4];
  for (let i4 = 0; i4 < 64; i4++)
    r3[i4] = 0;
  modL(r3, x5);
}
function crypto_sign(sm, m4, n2, sk) {
  const d4 = new Uint8Array(64), h3 = new Uint8Array(64), r3 = new Uint8Array(64);
  let i4, j4;
  const x5 = new Float64Array(64);
  const p4 = [gf(), gf(), gf(), gf()];
  crypto_hash(d4, sk, 32);
  d4[0] &= 248;
  d4[31] &= 127;
  d4[31] |= 64;
  const smlen = n2 + 64;
  for (i4 = 0; i4 < n2; i4++)
    sm[64 + i4] = m4[i4];
  for (i4 = 0; i4 < 32; i4++)
    sm[32 + i4] = d4[32 + i4];
  crypto_hash(r3, sm.subarray(32), n2 + 32);
  reduce(r3);
  scalarbase(p4, r3);
  pack(sm, p4);
  for (i4 = 32; i4 < 64; i4++)
    sm[i4] = sk[i4];
  crypto_hash(h3, sm, n2 + 64);
  reduce(h3);
  for (i4 = 0; i4 < 64; i4++)
    x5[i4] = 0;
  for (i4 = 0; i4 < 32; i4++)
    x5[i4] = r3[i4];
  for (i4 = 0; i4 < 32; i4++) {
    for (j4 = 0; j4 < 32; j4++) {
      x5[i4 + j4] += h3[i4] * d4[j4];
    }
  }
  modL(sm.subarray(32), x5);
  return smlen;
}
function unpackpos(r3, p4) {
  const q5 = [gf(), gf(), gf(), gf()];
  if (unpackneg(q5, p4))
    return -1;
  const scalar0 = new Uint8Array(32);
  const scalar1 = new Uint8Array(32);
  scalar1[0] = 1;
  const scalarNeg1 = crypto_core_ed25519_scalar_sub(scalar0, scalar1);
  scalarmult(r3, q5, scalarNeg1);
  return 0;
}
function unpackneg(r3, p4) {
  const t4 = gf();
  const chk = gf();
  const num = gf();
  const den = gf();
  const den2 = gf();
  const den4 = gf();
  const den6 = gf();
  set25519(r3[2], gf1);
  unpack25519(r3[1], p4);
  S(num, r3[1]);
  M(den, num, D);
  Z(num, num, r3[2]);
  A(den, r3[2], den);
  S(den2, den);
  S(den4, den2);
  M(den6, den4, den2);
  M(t4, den6, num);
  M(t4, t4, den);
  pow2523(t4, t4);
  M(t4, t4, num);
  M(t4, t4, den);
  M(t4, t4, den);
  M(r3[0], t4, den);
  S(chk, r3[0]);
  M(chk, chk, den);
  if (neq25519(chk, num))
    M(r3[0], r3[0], I);
  S(chk, r3[0]);
  M(chk, chk, den);
  if (neq25519(chk, num))
    return -1;
  if (par25519(r3[0]) === p4[31] >> 7)
    Z(r3[0], gf0, r3[0]);
  M(r3[3], r3[0], r3[1]);
  return 0;
}
function crypto_scalarmult_ed25519_base_noclamp(s4) {
  const r3 = new Uint8Array(32);
  const p4 = [gf(), gf(), gf(), gf()];
  scalarbase(p4, s4);
  pack(r3, p4);
  return r3;
}
function crypto_scalarmult_ed25519_noclamp(s4, q5) {
  const r3 = new Uint8Array(32);
  const p4 = [gf(), gf(), gf(), gf()];
  const ql = [gf(), gf(), gf(), gf()];
  if (unpackpos(ql, q5))
    throw new Error();
  scalarmult(p4, ql, s4);
  pack(r3, p4);
  return r3;
}
function crypto_sign_open(m4, sm, n2, pk) {
  let i4, mlen;
  const t4 = new Uint8Array(32), h3 = new Uint8Array(64);
  const p4 = [gf(), gf(), gf(), gf()], q5 = [gf(), gf(), gf(), gf()];
  mlen = -1;
  if (n2 < 64)
    return -1;
  if (unpackneg(q5, pk))
    return -1;
  for (i4 = 0; i4 < n2; i4++)
    m4[i4] = sm[i4];
  for (i4 = 0; i4 < 32; i4++)
    m4[i4 + 32] = pk[i4];
  crypto_hash(h3, m4, n2);
  reduce(h3);
  scalarmult(p4, q5, h3);
  scalarbase(q5, sm.subarray(32));
  add(p4, q5);
  pack(t4, p4);
  n2 -= 64;
  if (crypto_verify_32(sm, 0, t4, 0)) {
    for (i4 = 0; i4 < n2; i4++)
      m4[i4] = 0;
    return -1;
  }
  for (i4 = 0; i4 < n2; i4++)
    m4[i4] = sm[i4 + 64];
  mlen = n2;
  return mlen;
}
var crypto_secretbox_KEYBYTES = 32;
var crypto_secretbox_NONCEBYTES = 24;
var crypto_secretbox_ZEROBYTES = 32;
var crypto_secretbox_BOXZEROBYTES = 16;
var crypto_sign_BYTES = 64;
var crypto_sign_PUBLICKEYBYTES = 32;
var crypto_sign_SECRETKEYBYTES = 64;
var crypto_sign_SEEDBYTES = 32;
var crypto_hash_BYTES = 64;
function checkLengths(k5, n2) {
  if (k5.length !== crypto_secretbox_KEYBYTES)
    throw new Error("bad key size");
  if (n2.length !== crypto_secretbox_NONCEBYTES)
    throw new Error("bad nonce size");
}
function checkArrayTypes(...args) {
  for (let i4 = 0; i4 < args.length; i4++) {
    if (!(args[i4] instanceof Uint8Array))
      throw new TypeError("unexpected type, use Uint8Array");
  }
}
function randomBytes(n2) {
  const b4 = new Uint8Array(n2);
  randombytes(b4, n2);
  return b4;
}
function sign(msg, secretKey) {
  checkArrayTypes(msg, secretKey);
  if (secretKey.length !== crypto_sign_SECRETKEYBYTES)
    throw new Error("bad secret key size");
  const signedMsg = new Uint8Array(crypto_sign_BYTES + msg.length);
  crypto_sign(signedMsg, msg, msg.length, secretKey);
  return signedMsg;
}
function sign_detached(msg, secretKey) {
  const signedMsg = sign(msg, secretKey);
  const sig = new Uint8Array(crypto_sign_BYTES);
  for (let i4 = 0; i4 < sig.length; i4++)
    sig[i4] = signedMsg[i4];
  return sig;
}
function crypto_sign_keyPair_fromSeed(seed) {
  checkArrayTypes(seed);
  if (seed.length !== crypto_sign_SEEDBYTES)
    throw new Error(`bad seed size: ${seed.length}`);
  const pk = new Uint8Array(crypto_sign_PUBLICKEYBYTES);
  const sk = new Uint8Array(crypto_sign_SECRETKEYBYTES);
  for (let i4 = 0; i4 < 32; i4++)
    sk[i4] = seed[i4];
  crypto_sign_keypair(pk, sk, true);
  return { publicKey: pk, secretKey: sk };
}
function hash(msg) {
  checkArrayTypes(msg);
  const h3 = new Uint8Array(crypto_hash_BYTES);
  crypto_hash(h3, msg, msg.length);
  return h3;
}
function setPRNG(fn2) {
  randombytes = fn2;
}
function secretbox(msg, nonce, key) {
  checkArrayTypes(msg, nonce, key);
  checkLengths(key, nonce);
  var m4 = new Uint8Array(crypto_secretbox_ZEROBYTES + msg.length);
  var c4 = new Uint8Array(m4.length);
  for (var i4 = 0; i4 < msg.length; i4++)
    m4[i4 + crypto_secretbox_ZEROBYTES] = msg[i4];
  crypto_secretbox(c4, m4, m4.length, nonce, key);
  return c4.subarray(crypto_secretbox_BOXZEROBYTES);
}
function crypto_core_ed25519_scalar_reduce(x5) {
  const len = x5.length;
  const z5 = new Float64Array(64);
  for (let i4 = 0; i4 < len; i4++)
    z5[i4] = x5[i4];
  const o3 = new Uint8Array(32);
  modL(o3, z5);
  return o3;
}
function crypto_core_ed25519_scalar_sub(x5, y4) {
  const z5 = new Float64Array(64);
  for (let i4 = 0; i4 < 32; i4++) {
    z5[i4] = x5[i4] - y4[i4];
  }
  const o3 = new Uint8Array(32);
  modL(o3, z5);
  return o3;
}
function crypto_edx25519_private_key_create() {
  const seed = new Uint8Array(32);
  randombytes(seed, 32);
  return crypto_edx25519_private_key_create_from_seed(seed);
}
function crypto_edx25519_private_key_create_from_seed(seed) {
  const pk = hash(seed);
  pk[0] &= 248;
  pk[31] &= 127;
  pk[31] |= 64;
  return pk;
}
function crypto_edx25519_get_public(priv) {
  return crypto_scalarmult_ed25519_base_noclamp(priv.subarray(0, 32));
}
function crypto_edx25519_sign_detached(m4, skx, pkx) {
  const n2 = m4.length;
  const h3 = new Uint8Array(64);
  const r3 = new Uint8Array(64);
  let i4, j4;
  const x5 = new Float64Array(64);
  const p4 = [gf(), gf(), gf(), gf()];
  const sm = new Uint8Array(n2 + 64);
  for (i4 = 0; i4 < n2; i4++)
    sm[64 + i4] = m4[i4];
  for (i4 = 0; i4 < 32; i4++)
    sm[32 + i4] = skx[32 + i4];
  crypto_hash(r3, sm.subarray(32), n2 + 32);
  reduce(r3);
  scalarbase(p4, r3);
  pack(sm, p4);
  for (i4 = 32; i4 < 64; i4++)
    sm[i4] = pkx[i4 - 32];
  crypto_hash(h3, sm, n2 + 64);
  reduce(h3);
  for (i4 = 0; i4 < 64; i4++)
    x5[i4] = 0;
  for (i4 = 0; i4 < 32; i4++)
    x5[i4] = r3[i4];
  for (i4 = 0; i4 < 32; i4++) {
    for (j4 = 0; j4 < 32; j4++) {
      x5[i4 + j4] += h3[i4] * skx[j4];
    }
  }
  modL(sm.subarray(32), x5);
  return sm.subarray(0, 64);
}
function crypto_edx25519_sign_detached_verify(msg, sig, publicKey) {
  checkArrayTypes(msg, sig, publicKey);
  if (sig.length !== crypto_sign_BYTES)
    throw new Error("bad signature size");
  if (publicKey.length !== crypto_sign_PUBLICKEYBYTES)
    throw new Error("bad public key size");
  const sm = new Uint8Array(crypto_sign_BYTES + msg.length);
  const m4 = new Uint8Array(crypto_sign_BYTES + msg.length);
  let i4;
  for (i4 = 0; i4 < crypto_sign_BYTES; i4++)
    sm[i4] = sig[i4];
  for (i4 = 0; i4 < msg.length; i4++)
    sm[i4 + crypto_sign_BYTES] = msg[i4];
  return crypto_sign_open(m4, sm, sm.length, publicKey) >= 0;
}

// ../taler-util/lib/prng-browser.js
function loadBrowserPrng() {
  const cr = typeof self !== "undefined" ? self.crypto || self.msCrypto : null;
  const QUOTA = 65536;
  setPRNG(function(x5, n2) {
    let i4;
    const v3 = new Uint8Array(n2);
    for (i4 = 0; i4 < n2; i4 += QUOTA) {
      cr.getRandomValues(v3.subarray(i4, i4 + Math.min(n2 - i4, QUOTA)));
    }
    for (i4 = 0; i4 < n2; i4++)
      x5[i4] = v3[i4];
    for (i4 = 0; i4 < v3.length; i4++)
      v3[i4] = 0;
  });
}

// ../taler-util/lib/punycode.js
var maxInt = 2147483647;
var base = 36;
var tMin = 1;
var tMax = 26;
var skew = 38;
var damp = 700;
var initialBias = 72;
var initialN = 128;
var delimiter = "-";
var regexPunycode = /^xn--/;
var regexNonASCII = /[^\0-\x7E]/;
var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g;
var errors = {
  overflow: "Overflow: input needs wider integers to process",
  "not-basic": "Illegal input >= 0x80 (not a basic code point)",
  "invalid-input": "Invalid input"
};
var baseMinusTMin = base - tMin;
var floor = Math.floor;
var stringFromCharCode = String.fromCharCode;
function error(type) {
  throw new RangeError(errors[type]);
}
function map(array, fn2) {
  const result = [];
  let length = array.length;
  while (length--) {
    result[length] = fn2(array[length]);
  }
  return result;
}
function mapDomain(string, fn2) {
  const parts = string.split("@");
  let result = "";
  if (parts.length > 1) {
    result = parts[0] + "@";
    string = parts[1];
  }
  string = string.replace(regexSeparators, ".");
  const labels = string.split(".");
  const encoded = map(labels, fn2).join(".");
  return result + encoded;
}
function ucs2decode(string) {
  const output = [];
  let counter2 = 0;
  const length = string.length;
  while (counter2 < length) {
    const value = string.charCodeAt(counter2++);
    if (value >= 55296 && value <= 56319 && counter2 < length) {
      const extra = string.charCodeAt(counter2++);
      if ((extra & 64512) == 56320) {
        output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
      } else {
        output.push(value);
        counter2--;
      }
    } else {
      output.push(value);
    }
  }
  return output;
}
var ucs2encode = (array) => String.fromCodePoint(...array);
var basicToDigit = function(codePoint) {
  if (codePoint - 48 < 10) {
    return codePoint - 22;
  }
  if (codePoint - 65 < 26) {
    return codePoint - 65;
  }
  if (codePoint - 97 < 26) {
    return codePoint - 97;
  }
  return base;
};
var digitToBasic = function(digit, flag) {
  return digit + 22 + 75 * Number(digit < 26) - (Number(flag != 0) << 5);
};
var adapt = function(delta, numPoints, firstTime) {
  let k5 = 0;
  delta = firstTime ? floor(delta / damp) : delta >> 1;
  delta += floor(delta / numPoints);
  for (
    ;
    /* no initialization */
    delta > baseMinusTMin * tMax >> 1;
    k5 += base
  ) {
    delta = floor(delta / baseMinusTMin);
  }
  return floor(k5 + (baseMinusTMin + 1) * delta / (delta + skew));
};
var decode = function(input) {
  const output = [];
  const inputLength = input.length;
  let i4 = 0;
  let n2 = initialN;
  let bias = initialBias;
  let basic = input.lastIndexOf(delimiter);
  if (basic < 0) {
    basic = 0;
  }
  for (let j4 = 0; j4 < basic; ++j4) {
    if (input.charCodeAt(j4) >= 128) {
      error("not-basic");
    }
    output.push(input.charCodeAt(j4));
  }
  for (let index = basic > 0 ? basic + 1 : 0; index < inputLength; ) {
    let oldi = i4;
    for (let w5 = 1, k5 = base; ; k5 += base) {
      if (index >= inputLength) {
        error("invalid-input");
      }
      const digit = basicToDigit(input.charCodeAt(index++));
      if (digit >= base || digit > floor((maxInt - i4) / w5)) {
        error("overflow");
      }
      i4 += digit * w5;
      const t4 = k5 <= bias ? tMin : k5 >= bias + tMax ? tMax : k5 - bias;
      if (digit < t4) {
        break;
      }
      const baseMinusT = base - t4;
      if (w5 > floor(maxInt / baseMinusT)) {
        error("overflow");
      }
      w5 *= baseMinusT;
    }
    const out = output.length + 1;
    bias = adapt(i4 - oldi, out, oldi == 0);
    if (floor(i4 / out) > maxInt - n2) {
      error("overflow");
    }
    n2 += floor(i4 / out);
    i4 %= out;
    output.splice(i4++, 0, n2);
  }
  return String.fromCodePoint(...output);
};
var encode = function(inputArg) {
  const output = [];
  let input = ucs2decode(inputArg);
  let inputLength = input.length;
  let n2 = initialN;
  let delta = 0;
  let bias = initialBias;
  for (const currentValue of input) {
    if (currentValue < 128) {
      output.push(stringFromCharCode(currentValue));
    }
  }
  let basicLength = output.length;
  let handledCPCount = basicLength;
  if (basicLength) {
    output.push(delimiter);
  }
  while (handledCPCount < inputLength) {
    let m4 = maxInt;
    for (const currentValue of input) {
      if (currentValue >= n2 && currentValue < m4) {
        m4 = currentValue;
      }
    }
    const handledCPCountPlusOne = handledCPCount + 1;
    if (m4 - n2 > floor((maxInt - delta) / handledCPCountPlusOne)) {
      error("overflow");
    }
    delta += (m4 - n2) * handledCPCountPlusOne;
    n2 = m4;
    for (const currentValue of input) {
      if (currentValue < n2 && ++delta > maxInt) {
        error("overflow");
      }
      if (currentValue == n2) {
        let q5 = delta;
        for (let k5 = base; ; k5 += base) {
          const t4 = k5 <= bias ? tMin : k5 >= bias + tMax ? tMax : k5 - bias;
          if (q5 < t4) {
            break;
          }
          const qMinusT = q5 - t4;
          const baseMinusT = base - t4;
          output.push(stringFromCharCode(digitToBasic(t4 + qMinusT % baseMinusT, 0)));
          q5 = floor(qMinusT / baseMinusT);
        }
        output.push(stringFromCharCode(digitToBasic(q5, 0)));
        bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
        delta = 0;
        ++handledCPCount;
      }
    }
    ++delta;
    ++n2;
  }
  return output.join("");
};
var toUnicode = function(input) {
  return mapDomain(input, function(string) {
    return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
  });
};
var toASCII = function(input) {
  return mapDomain(input, function(string) {
    return regexNonASCII.test(string) ? "xn--" + encode(string) : string;
  });
};
var punycode = {
  /**
   * A string representing the current Punycode.js version number.
   * @memberOf punycode
   * @type String
   */
  version: "2.1.0",
  /**
   * An object of methods to convert from JavaScript's internal character
   * representation (UCS-2) to Unicode code points, and back.
   * @see <https://mathiasbynens.be/notes/javascript-encoding>
   * @memberOf punycode
   * @type Object
   */
  ucs2: {
    decode: ucs2decode,
    encode: ucs2encode
  },
  decode,
  encode,
  toASCII,
  toUnicode
};

// ../taler-util/lib/whatwg-url.js
var utf8Encoder = new TextEncoder();
var utf8Decoder = new TextDecoder("utf-8", { ignoreBOM: true });
function utf8Encode(string) {
  return utf8Encoder.encode(string);
}
function utf8DecodeWithoutBOM(bytes) {
  return utf8Decoder.decode(bytes);
}
function parseUrlencoded(input) {
  const sequences = strictlySplitByteSequence(input, p("&"));
  const output = [];
  for (const bytes of sequences) {
    if (bytes.length === 0) {
      continue;
    }
    let name, value;
    const indexOfEqual = bytes.indexOf(p("="));
    if (indexOfEqual >= 0) {
      name = bytes.slice(0, indexOfEqual);
      value = bytes.slice(indexOfEqual + 1);
    } else {
      name = bytes;
      value = new Uint8Array(0);
    }
    name = replaceByteInByteSequence(name, 43, 32);
    value = replaceByteInByteSequence(value, 43, 32);
    const nameString = utf8DecodeWithoutBOM(percentDecodeBytes(name));
    const valueString = utf8DecodeWithoutBOM(percentDecodeBytes(value));
    output.push([nameString, valueString]);
  }
  return output;
}
function parseUrlencodedString(input) {
  return parseUrlencoded(utf8Encode(input));
}
function serializeUrlencoded(tuples, encodingOverride = void 0) {
  let encoding = "utf-8";
  if (encodingOverride !== void 0) {
    encoding = encodingOverride;
  }
  let output = "";
  for (const [i4, tuple] of tuples.entries()) {
    const name = utf8PercentEncodeString(tuple[0], isURLEncodedPercentEncode, true);
    let value = tuple[1];
    if (tuple.length > 2 && tuple[2] !== void 0) {
      if (tuple[2] === "hidden" && name === "_charset_") {
        value = encoding;
      } else if (tuple[2] === "file") {
        value = value.name;
      }
    }
    value = utf8PercentEncodeString(value, isURLEncodedPercentEncode, true);
    if (i4 !== 0) {
      output += "&";
    }
    output += `${name}=${value}`;
  }
  return output;
}
function strictlySplitByteSequence(buf, cp) {
  const list = [];
  let last = 0;
  let i4 = buf.indexOf(cp);
  while (i4 >= 0) {
    list.push(buf.slice(last, i4));
    last = i4 + 1;
    i4 = buf.indexOf(cp, last);
  }
  if (last !== buf.length) {
    list.push(buf.slice(last));
  }
  return list;
}
function replaceByteInByteSequence(buf, from, to) {
  let i4 = buf.indexOf(from);
  while (i4 >= 0) {
    buf[i4] = to;
    i4 = buf.indexOf(from, i4 + 1);
  }
  return buf;
}
function p(char) {
  return char.codePointAt(0);
}
function percentEncode(c4) {
  let hex = c4.toString(16).toUpperCase();
  if (hex.length === 1) {
    hex = `0${hex}`;
  }
  return `%${hex}`;
}
function percentDecodeBytes(input) {
  const output = new Uint8Array(input.byteLength);
  let outputIndex = 0;
  for (let i4 = 0; i4 < input.byteLength; ++i4) {
    const byte = input[i4];
    if (byte !== 37) {
      output[outputIndex++] = byte;
    } else if (byte === 37 && (!isASCIIHex(input[i4 + 1]) || !isASCIIHex(input[i4 + 2]))) {
      output[outputIndex++] = byte;
    } else {
      const bytePoint = parseInt(String.fromCodePoint(input[i4 + 1], input[i4 + 2]), 16);
      output[outputIndex++] = bytePoint;
      i4 += 2;
    }
  }
  return output.slice(0, outputIndex);
}
function percentDecodeString(input) {
  const bytes = utf8Encode(input);
  return percentDecodeBytes(bytes);
}
function isC0ControlPercentEncode(c4) {
  return c4 <= 31 || c4 > 126;
}
var extraFragmentPercentEncodeSet = /* @__PURE__ */ new Set([
  p(" "),
  p('"'),
  p("<"),
  p(">"),
  p("`")
]);
function isFragmentPercentEncode(c4) {
  return isC0ControlPercentEncode(c4) || extraFragmentPercentEncodeSet.has(c4);
}
var extraQueryPercentEncodeSet = /* @__PURE__ */ new Set([
  p(" "),
  p('"'),
  p("#"),
  p("<"),
  p(">")
]);
function isQueryPercentEncode(c4) {
  return isC0ControlPercentEncode(c4) || extraQueryPercentEncodeSet.has(c4);
}
function isSpecialQueryPercentEncode(c4) {
  return isQueryPercentEncode(c4) || c4 === p("'");
}
var extraPathPercentEncodeSet = /* @__PURE__ */ new Set([p("?"), p("`"), p("{"), p("}")]);
function isPathPercentEncode(c4) {
  return isQueryPercentEncode(c4) || extraPathPercentEncodeSet.has(c4);
}
var extraUserinfoPercentEncodeSet = /* @__PURE__ */ new Set([
  p("/"),
  p(":"),
  p(";"),
  p("="),
  p("@"),
  p("["),
  p("\\"),
  p("]"),
  p("^"),
  p("|")
]);
function isUserinfoPercentEncode(c4) {
  return isPathPercentEncode(c4) || extraUserinfoPercentEncodeSet.has(c4);
}
var extraComponentPercentEncodeSet = /* @__PURE__ */ new Set([
  p("$"),
  p("%"),
  p("&"),
  p("+"),
  p(",")
]);
function isComponentPercentEncode(c4) {
  return isUserinfoPercentEncode(c4) || extraComponentPercentEncodeSet.has(c4);
}
var extraURLEncodedPercentEncodeSet = /* @__PURE__ */ new Set([
  p("!"),
  p("'"),
  p("("),
  p(")"),
  p("~")
]);
function isURLEncodedPercentEncode(c4) {
  return isComponentPercentEncode(c4) || extraURLEncodedPercentEncodeSet.has(c4);
}
function utf8PercentEncodeCodePointInternal(codePoint, percentEncodePredicate) {
  const bytes = utf8Encode(codePoint);
  let output = "";
  for (const byte of bytes) {
    if (!percentEncodePredicate(byte)) {
      output += String.fromCharCode(byte);
    } else {
      output += percentEncode(byte);
    }
  }
  return output;
}
function utf8PercentEncodeCodePoint(codePoint, percentEncodePredicate) {
  return utf8PercentEncodeCodePointInternal(String.fromCodePoint(codePoint), percentEncodePredicate);
}
function utf8PercentEncodeString(input, percentEncodePredicate, spaceAsPlus = false) {
  let output = "";
  for (const codePoint of input) {
    if (spaceAsPlus && codePoint === " ") {
      output += "+";
    } else {
      output += utf8PercentEncodeCodePointInternal(codePoint, percentEncodePredicate);
    }
  }
  return output;
}
function isASCIIDigit(c4) {
  return c4 >= 48 && c4 <= 57;
}
function isASCIIAlpha(c4) {
  return c4 >= 65 && c4 <= 90 || c4 >= 97 && c4 <= 122;
}
function isASCIIAlphanumeric(c4) {
  return isASCIIAlpha(c4) || isASCIIDigit(c4);
}
function isASCIIHex(c4) {
  return isASCIIDigit(c4) || c4 >= 65 && c4 <= 70 || c4 >= 97 && c4 <= 102;
}
var URLSearchParamsImpl = class {
  constructor(init, { doNotStripQMark = false } = {}) {
    this._list = [];
    this._url = null;
    if (!doNotStripQMark && typeof init === "string" && init[0] === "?") {
      init = init.slice(1);
    }
    if (Array.isArray(init)) {
      for (const pair of init) {
        if (pair.length !== 2) {
          throw new TypeError("Failed to construct 'URLSearchParams': parameter 1 sequence's element does not contain exactly two elements.");
        }
        this._list.push([pair[0], pair[1]]);
      }
    } else if (typeof init === "object" && Object.getPrototypeOf(init) === null) {
      for (const name of Object.keys(init)) {
        const value = init[name];
        this._list.push([name, value]);
      }
    } else {
      this._list = parseUrlencodedString(init);
    }
  }
  _updateSteps() {
    if (this._url !== null) {
      let query = serializeUrlencoded(this._list);
      if (query === "") {
        query = null;
      }
      this._url._url.query = query;
    }
  }
  append(name, value) {
    this._list.push([name, value]);
    this._updateSteps();
  }
  delete(name) {
    let i4 = 0;
    while (i4 < this._list.length) {
      if (this._list[i4][0] === name) {
        this._list.splice(i4, 1);
      } else {
        i4++;
      }
    }
    this._updateSteps();
  }
  get(name) {
    for (const tuple of this._list) {
      if (tuple[0] === name) {
        return tuple[1];
      }
    }
    return null;
  }
  getAll(name) {
    const output = [];
    for (const tuple of this._list) {
      if (tuple[0] === name) {
        output.push(tuple[1]);
      }
    }
    return output;
  }
  entries() {
    return [...this._list.map((x5) => [x5[0], x5[1]])];
  }
  forEach(callbackfn, thisArg) {
    for (const tuple of this._list) {
      callbackfn.call(thisArg, tuple[1], tuple[0], this);
    }
  }
  has(name) {
    for (const tuple of this._list) {
      if (tuple[0] === name) {
        return true;
      }
    }
    return false;
  }
  set(name, value) {
    let found = false;
    let i4 = 0;
    while (i4 < this._list.length) {
      if (this._list[i4][0] === name) {
        if (found) {
          this._list.splice(i4, 1);
        } else {
          found = true;
          this._list[i4][1] = value;
          i4++;
        }
      } else {
        i4++;
      }
    }
    if (!found) {
      this._list.push([name, value]);
    }
    this._updateSteps();
  }
  sort() {
    this._list.sort((a4, b4) => {
      if (a4[0] < b4[0]) {
        return -1;
      }
      if (a4[0] > b4[0]) {
        return 1;
      }
      return 0;
    });
    this._updateSteps();
  }
  [Symbol.iterator]() {
    return this._list[Symbol.iterator]();
  }
  toString() {
    return serializeUrlencoded(this._list);
  }
};
var specialSchemes = {
  ftp: 21,
  file: null,
  http: 80,
  https: 443,
  ws: 80,
  wss: 443
};
var failure = Symbol("failure");
function countSymbols(str) {
  return [...str].length;
}
function at(input, idx) {
  const c4 = input[idx];
  return isNaN(c4) ? void 0 : String.fromCodePoint(c4);
}
function isSingleDot(buffer) {
  return buffer === "." || buffer.toLowerCase() === "%2e";
}
function isDoubleDot(buffer) {
  buffer = buffer.toLowerCase();
  return buffer === ".." || buffer === "%2e." || buffer === ".%2e" || buffer === "%2e%2e";
}
function isWindowsDriveLetterCodePoints(cp1, cp2) {
  return isASCIIAlpha(cp1) && (cp2 === p(":") || cp2 === p("|"));
}
function isWindowsDriveLetterString(string) {
  return string.length === 2 && isASCIIAlpha(string.codePointAt(0)) && (string[1] === ":" || string[1] === "|");
}
function isNormalizedWindowsDriveLetterString(string) {
  return string.length === 2 && isASCIIAlpha(string.codePointAt(0)) && string[1] === ":";
}
function containsForbiddenHostCodePoint(string) {
  return string.search(/\u0000|\u0009|\u000A|\u000D|\u0020|#|\/|:|<|>|\?|@|\[|\\|\]|\^|\|/u) !== -1;
}
function containsForbiddenDomainCodePoint(string) {
  return containsForbiddenHostCodePoint(string) || string.search(/[\u0000-\u001F]|%|\u007F/u) !== -1;
}
function isSpecialScheme(scheme) {
  return specialSchemes[scheme] !== void 0;
}
function isSpecial(url) {
  return isSpecialScheme(url.scheme);
}
function isNotSpecial(url) {
  return !isSpecialScheme(url.scheme);
}
function defaultPort(scheme) {
  return specialSchemes[scheme];
}
function parseIPv4Number(input) {
  if (input === "") {
    return failure;
  }
  let R3 = 10;
  if (input.length >= 2 && input.charAt(0) === "0" && input.charAt(1).toLowerCase() === "x") {
    input = input.substring(2);
    R3 = 16;
  } else if (input.length >= 2 && input.charAt(0) === "0") {
    input = input.substring(1);
    R3 = 8;
  }
  if (input === "") {
    return 0;
  }
  let regex = /[^0-7]/u;
  if (R3 === 10) {
    regex = /[^0-9]/u;
  }
  if (R3 === 16) {
    regex = /[^0-9A-Fa-f]/u;
  }
  if (regex.test(input)) {
    return failure;
  }
  return parseInt(input, R3);
}
function parseIPv4(input) {
  const parts = input.split(".");
  if (parts[parts.length - 1] === "") {
    if (parts.length > 1) {
      parts.pop();
    }
  }
  if (parts.length > 4) {
    return failure;
  }
  const numbers = [];
  for (const part of parts) {
    const n2 = parseIPv4Number(part);
    if (n2 === failure) {
      return failure;
    }
    numbers.push(n2);
  }
  for (let i4 = 0; i4 < numbers.length - 1; ++i4) {
    if (numbers[i4] > 255) {
      return failure;
    }
  }
  if (numbers[numbers.length - 1] >= 256 ** (5 - numbers.length)) {
    return failure;
  }
  let ipv4 = numbers.pop();
  let counter2 = 0;
  for (const n2 of numbers) {
    ipv4 += n2 * 256 ** (3 - counter2);
    ++counter2;
  }
  return ipv4;
}
function serializeIPv4(address) {
  let output = "";
  let n2 = address;
  for (let i4 = 1; i4 <= 4; ++i4) {
    output = String(n2 % 256) + output;
    if (i4 !== 4) {
      output = `.${output}`;
    }
    n2 = Math.floor(n2 / 256);
  }
  return output;
}
function parseIPv6(inputArg) {
  const address = [0, 0, 0, 0, 0, 0, 0, 0];
  let pieceIndex = 0;
  let compress3 = null;
  let pointer = 0;
  const input = Array.from(inputArg, (c4) => c4.codePointAt(0));
  if (input[pointer] === p(":")) {
    if (input[pointer + 1] !== p(":")) {
      return failure;
    }
    pointer += 2;
    ++pieceIndex;
    compress3 = pieceIndex;
  }
  while (pointer < input.length) {
    if (pieceIndex === 8) {
      return failure;
    }
    if (input[pointer] === p(":")) {
      if (compress3 !== null) {
        return failure;
      }
      ++pointer;
      ++pieceIndex;
      compress3 = pieceIndex;
      continue;
    }
    let value = 0;
    let length = 0;
    while (length < 4 && isASCIIHex(input[pointer])) {
      value = value * 16 + parseInt(at(input, pointer), 16);
      ++pointer;
      ++length;
    }
    if (input[pointer] === p(".")) {
      if (length === 0) {
        return failure;
      }
      pointer -= length;
      if (pieceIndex > 6) {
        return failure;
      }
      let numbersSeen = 0;
      while (input[pointer] !== void 0) {
        let ipv4Piece = null;
        if (numbersSeen > 0) {
          if (input[pointer] === p(".") && numbersSeen < 4) {
            ++pointer;
          } else {
            return failure;
          }
        }
        if (!isASCIIDigit(input[pointer])) {
          return failure;
        }
        while (isASCIIDigit(input[pointer])) {
          const number = parseInt(at(input, pointer));
          if (ipv4Piece === null) {
            ipv4Piece = number;
          } else if (ipv4Piece === 0) {
            return failure;
          } else {
            ipv4Piece = ipv4Piece * 10 + number;
          }
          if (ipv4Piece > 255) {
            return failure;
          }
          ++pointer;
        }
        address[pieceIndex] = address[pieceIndex] * 256 + ipv4Piece;
        ++numbersSeen;
        if (numbersSeen === 2 || numbersSeen === 4) {
          ++pieceIndex;
        }
      }
      if (numbersSeen !== 4) {
        return failure;
      }
      break;
    } else if (input[pointer] === p(":")) {
      ++pointer;
      if (input[pointer] === void 0) {
        return failure;
      }
    } else if (input[pointer] !== void 0) {
      return failure;
    }
    address[pieceIndex] = value;
    ++pieceIndex;
  }
  if (compress3 !== null) {
    let swaps = pieceIndex - compress3;
    pieceIndex = 7;
    while (pieceIndex !== 0 && swaps > 0) {
      const temp = address[compress3 + swaps - 1];
      address[compress3 + swaps - 1] = address[pieceIndex];
      address[pieceIndex] = temp;
      --pieceIndex;
      --swaps;
    }
  } else if (compress3 === null && pieceIndex !== 8) {
    return failure;
  }
  return address;
}
function serializeIPv6(address) {
  let output = "";
  const compress3 = findLongestZeroSequence(address);
  let ignore0 = false;
  for (let pieceIndex = 0; pieceIndex <= 7; ++pieceIndex) {
    if (ignore0 && address[pieceIndex] === 0) {
      continue;
    } else if (ignore0) {
      ignore0 = false;
    }
    if (compress3 === pieceIndex) {
      const separator = pieceIndex === 0 ? "::" : ":";
      output += separator;
      ignore0 = true;
      continue;
    }
    output += address[pieceIndex].toString(16);
    if (pieceIndex !== 7) {
      output += ":";
    }
  }
  return output;
}
function parseHost(input, isNotSpecialArg = false) {
  if (input[0] === "[") {
    if (input[input.length - 1] !== "]") {
      return failure;
    }
    return parseIPv6(input.substring(1, input.length - 1));
  }
  if (isNotSpecialArg) {
    return parseOpaqueHost(input);
  }
  const domain = utf8DecodeWithoutBOM(percentDecodeString(input));
  const asciiDomain = domainToASCII(domain);
  if (asciiDomain === failure) {
    return failure;
  }
  if (containsForbiddenDomainCodePoint(asciiDomain)) {
    return failure;
  }
  if (endsInANumber(asciiDomain)) {
    return parseIPv4(asciiDomain);
  }
  return asciiDomain;
}
function endsInANumber(input) {
  const parts = input.split(".");
  if (parts[parts.length - 1] === "") {
    if (parts.length === 1) {
      return false;
    }
    parts.pop();
  }
  const last = parts[parts.length - 1];
  if (parseIPv4Number(last) !== failure) {
    return true;
  }
  if (/^[0-9]+$/u.test(last)) {
    return true;
  }
  return false;
}
function parseOpaqueHost(input) {
  if (containsForbiddenHostCodePoint(input)) {
    return failure;
  }
  return utf8PercentEncodeString(input, isC0ControlPercentEncode);
}
function findLongestZeroSequence(arr) {
  let maxIdx = null;
  let maxLen = 1;
  let currStart = null;
  let currLen = 0;
  for (let i4 = 0; i4 < arr.length; ++i4) {
    if (arr[i4] !== 0) {
      if (currLen > maxLen) {
        maxIdx = currStart;
        maxLen = currLen;
      }
      currStart = null;
      currLen = 0;
    } else {
      if (currStart === null) {
        currStart = i4;
      }
      ++currLen;
    }
  }
  if (currLen > maxLen) {
    return currStart;
  }
  return maxIdx;
}
function serializeHost(host) {
  if (typeof host === "number") {
    return serializeIPv4(host);
  }
  if (host instanceof Array) {
    return `[${serializeIPv6(host)}]`;
  }
  return host;
}
function domainToASCII(domain, beStrict = false) {
  let result;
  try {
    result = punycode.toASCII(domain);
  } catch (e4) {
    return failure;
  }
  if (result === null || result === "") {
    return failure;
  }
  return result;
}
function trimControlChars(url) {
  return url.replace(/^[\u0000-\u001F\u0020]+|[\u0000-\u001F\u0020]+$/gu, "");
}
function trimTabAndNewline(url) {
  return url.replace(/\u0009|\u000A|\u000D/gu, "");
}
function shortenPath(url) {
  const { path } = url;
  if (path.length === 0) {
    return;
  }
  if (url.scheme === "file" && path.length === 1 && isNormalizedWindowsDriveLetter(path[0])) {
    return;
  }
  path.pop();
}
function includesCredentials(url) {
  return url.username !== "" || url.password !== "";
}
function cannotHaveAUsernamePasswordPort(url) {
  return url.host === null || url.host === "" || url.scheme === "file";
}
function hasAnOpaquePath(url) {
  return typeof url.path === "string";
}
function isNormalizedWindowsDriveLetter(string) {
  return /^[A-Za-z]:$/u.test(string);
}
var URLStateMachine = class {
  constructor(input, base2, encodingOverride, url, stateOverride) {
    this.table = {
      "parse scheme start": this.parseSchemeStart,
      "parse scheme": this.parseScheme,
      "parse no scheme": this.parseNoScheme,
      "parse special relative or authority": this.parseSpecialRelativeOrAuthority,
      "parse path or authority": this.parsePathOrAuthority,
      "parse relative": this.parseRelative,
      "parse relative slash": this.parseRelativeSlash,
      "parse special authority slashes": this.parseSpecialAuthoritySlashes,
      "parse special authority ignore slashes": this.parseSpecialAuthorityIgnoreSlashes,
      "parse authority": this.parseAuthority,
      "parse host": this.parseHostName,
      "parse hostname": this.parseHostName,
      "parse port": this.parsePort,
      "parse file": this.parseFile,
      "parse file slash": this.parseFileSlash,
      "parse file host": this.parseFileHost,
      "parse path start": this.parsePathStart,
      "parse path": this.parsePath,
      "parse opaque path": this.parseOpaquePath,
      "parse query": this.parseQuery,
      "parse fragment": this.parseFragment
    };
    this.pointer = 0;
    this.base = base2 || null;
    this.encodingOverride = encodingOverride || "utf-8";
    this.url = url;
    this.failure = false;
    this.parseError = false;
    if (!this.url) {
      this.url = {
        scheme: "",
        username: "",
        password: "",
        host: null,
        port: null,
        path: [],
        query: null,
        fragment: null
      };
      const res2 = trimControlChars(input);
      if (res2 !== input) {
        this.parseError = true;
      }
      input = res2;
    }
    const res = trimTabAndNewline(input);
    if (res !== input) {
      this.parseError = true;
    }
    input = res;
    this.state = stateOverride || "scheme start";
    this.buffer = "";
    this.atFlag = false;
    this.arrFlag = false;
    this.passwordTokenSeenFlag = false;
    this.input = Array.from(input, (c4) => c4.codePointAt(0));
    for (; this.pointer <= this.input.length; ++this.pointer) {
      const c4 = this.input[this.pointer];
      const cStr = isNaN(c4) ? void 0 : String.fromCodePoint(c4);
      const ret = this.table[`parse ${this.state}`].call(this, c4, cStr);
      if (!ret) {
        break;
      } else if (ret === failure) {
        this.failure = true;
        break;
      }
    }
  }
  parseSchemeStart(c4, cStr) {
    if (isASCIIAlpha(c4)) {
      this.buffer += cStr.toLowerCase();
      this.state = "scheme";
    } else if (!this.stateOverride) {
      this.state = "no scheme";
      --this.pointer;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseScheme(c4, cStr) {
    if (isASCIIAlphanumeric(c4) || c4 === p("+") || c4 === p("-") || c4 === p(".")) {
      this.buffer += cStr.toLowerCase();
    } else if (c4 === p(":")) {
      if (this.stateOverride) {
        if (isSpecial(this.url) && !isSpecialScheme(this.buffer)) {
          return false;
        }
        if (!isSpecial(this.url) && isSpecialScheme(this.buffer)) {
          return false;
        }
        if ((includesCredentials(this.url) || this.url.port !== null) && this.buffer === "file") {
          return false;
        }
        if (this.url.scheme === "file" && this.url.host === "") {
          return false;
        }
      }
      this.url.scheme = this.buffer;
      if (this.stateOverride) {
        if (this.url.port === defaultPort(this.url.scheme)) {
          this.url.port = null;
        }
        return false;
      }
      this.buffer = "";
      if (this.url.scheme === "file") {
        if (this.input[this.pointer + 1] !== p("/") || this.input[this.pointer + 2] !== p("/")) {
          this.parseError = true;
        }
        this.state = "file";
      } else if (isSpecial(this.url) && this.base !== null && this.base.scheme === this.url.scheme) {
        this.state = "special relative or authority";
      } else if (isSpecial(this.url)) {
        this.state = "special authority slashes";
      } else if (this.input[this.pointer + 1] === p("/")) {
        this.state = "path or authority";
        ++this.pointer;
      } else {
        this.url.path = [""];
        this.state = "opaque path";
      }
    } else if (!this.stateOverride) {
      this.buffer = "";
      this.state = "no scheme";
      this.pointer = -1;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseNoScheme(c4) {
    if (this.base === null || hasAnOpaquePath(this.base) && c4 !== p("#")) {
      return failure;
    } else if (hasAnOpaquePath(this.base) && c4 === p("#")) {
      this.url.scheme = this.base.scheme;
      this.url.path = this.base.path;
      this.url.query = this.base.query;
      this.url.fragment = "";
      this.state = "fragment";
    } else if (this.base.scheme === "file") {
      this.state = "file";
      --this.pointer;
    } else {
      this.state = "relative";
      --this.pointer;
    }
    return true;
  }
  parseSpecialRelativeOrAuthority(c4) {
    if (c4 === p("/") && this.input[this.pointer + 1] === p("/")) {
      this.state = "special authority ignore slashes";
      ++this.pointer;
    } else {
      this.parseError = true;
      this.state = "relative";
      --this.pointer;
    }
    return true;
  }
  parsePathOrAuthority(c4) {
    if (c4 === p("/")) {
      this.state = "authority";
    } else {
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseRelative(c4) {
    this.url.scheme = this.base.scheme;
    if (c4 === p("/")) {
      this.state = "relative slash";
    } else if (isSpecial(this.url) && c4 === p("\\")) {
      this.parseError = true;
      this.state = "relative slash";
    } else {
      this.url.username = this.base.username;
      this.url.password = this.base.password;
      this.url.host = this.base.host;
      this.url.port = this.base.port;
      this.url.path = this.base.path.slice();
      this.url.query = this.base.query;
      if (c4 === p("?")) {
        this.url.query = "";
        this.state = "query";
      } else if (c4 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      } else if (!isNaN(c4)) {
        this.url.query = null;
        this.url.path.pop();
        this.state = "path";
        --this.pointer;
      }
    }
    return true;
  }
  parseRelativeSlash(c4) {
    if (isSpecial(this.url) && (c4 === p("/") || c4 === p("\\"))) {
      if (c4 === p("\\")) {
        this.parseError = true;
      }
      this.state = "special authority ignore slashes";
    } else if (c4 === p("/")) {
      this.state = "authority";
    } else {
      this.url.username = this.base.username;
      this.url.password = this.base.password;
      this.url.host = this.base.host;
      this.url.port = this.base.port;
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseSpecialAuthoritySlashes(c4) {
    if (c4 === p("/") && this.input[this.pointer + 1] === p("/")) {
      this.state = "special authority ignore slashes";
      ++this.pointer;
    } else {
      this.parseError = true;
      this.state = "special authority ignore slashes";
      --this.pointer;
    }
    return true;
  }
  parseSpecialAuthorityIgnoreSlashes(c4) {
    if (c4 !== p("/") && c4 !== p("\\")) {
      this.state = "authority";
      --this.pointer;
    } else {
      this.parseError = true;
    }
    return true;
  }
  parseAuthority(c4, cStr) {
    if (c4 === p("@")) {
      this.parseError = true;
      if (this.atFlag) {
        this.buffer = `%40${this.buffer}`;
      }
      this.atFlag = true;
      const len = countSymbols(this.buffer);
      for (let pointer = 0; pointer < len; ++pointer) {
        const codePoint = this.buffer.codePointAt(pointer);
        if (codePoint === p(":") && !this.passwordTokenSeenFlag) {
          this.passwordTokenSeenFlag = true;
          continue;
        }
        const encodedCodePoints = utf8PercentEncodeCodePoint(codePoint, isUserinfoPercentEncode);
        if (this.passwordTokenSeenFlag) {
          this.url.password += encodedCodePoints;
        } else {
          this.url.username += encodedCodePoints;
        }
      }
      this.buffer = "";
    } else if (isNaN(c4) || c4 === p("/") || c4 === p("?") || c4 === p("#") || isSpecial(this.url) && c4 === p("\\")) {
      if (this.atFlag && this.buffer === "") {
        this.parseError = true;
        return failure;
      }
      this.pointer -= countSymbols(this.buffer) + 1;
      this.buffer = "";
      this.state = "host";
    } else {
      this.buffer += cStr;
    }
    return true;
  }
  parseHostName(c4, cStr) {
    if (this.stateOverride && this.url.scheme === "file") {
      --this.pointer;
      this.state = "file host";
    } else if (c4 === p(":") && !this.arrFlag) {
      if (this.buffer === "") {
        this.parseError = true;
        return failure;
      }
      if (this.stateOverride === "hostname") {
        return false;
      }
      const host = parseHost(this.buffer, isNotSpecial(this.url));
      if (host === failure) {
        return failure;
      }
      this.url.host = host;
      this.buffer = "";
      this.state = "port";
    } else if (isNaN(c4) || c4 === p("/") || c4 === p("?") || c4 === p("#") || isSpecial(this.url) && c4 === p("\\")) {
      --this.pointer;
      if (isSpecial(this.url) && this.buffer === "") {
        this.parseError = true;
        return failure;
      } else if (this.stateOverride && this.buffer === "" && (includesCredentials(this.url) || this.url.port !== null)) {
        this.parseError = true;
        return false;
      }
      const host = parseHost(this.buffer, isNotSpecial(this.url));
      if (host === failure) {
        return failure;
      }
      this.url.host = host;
      this.buffer = "";
      this.state = "path start";
      if (this.stateOverride) {
        return false;
      }
    } else {
      if (c4 === p("[")) {
        this.arrFlag = true;
      } else if (c4 === p("]")) {
        this.arrFlag = false;
      }
      this.buffer += cStr;
    }
    return true;
  }
  parsePort(c4, cStr) {
    if (isASCIIDigit(c4)) {
      this.buffer += cStr;
    } else if (isNaN(c4) || c4 === p("/") || c4 === p("?") || c4 === p("#") || isSpecial(this.url) && c4 === p("\\") || this.stateOverride) {
      if (this.buffer !== "") {
        const port = parseInt(this.buffer);
        if (port > 2 ** 16 - 1) {
          this.parseError = true;
          return failure;
        }
        this.url.port = port === defaultPort(this.url.scheme) ? null : port;
        this.buffer = "";
      }
      if (this.stateOverride) {
        return false;
      }
      this.state = "path start";
      --this.pointer;
    } else {
      this.parseError = true;
      return failure;
    }
    return true;
  }
  parseFile(c4) {
    this.url.scheme = "file";
    this.url.host = "";
    if (c4 === p("/") || c4 === p("\\")) {
      if (c4 === p("\\")) {
        this.parseError = true;
      }
      this.state = "file slash";
    } else if (this.base !== null && this.base.scheme === "file") {
      this.url.host = this.base.host;
      this.url.path = this.base.path.slice();
      this.url.query = this.base.query;
      if (c4 === p("?")) {
        this.url.query = "";
        this.state = "query";
      } else if (c4 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      } else if (!isNaN(c4)) {
        this.url.query = null;
        if (!startsWithWindowsDriveLetter(this.input, this.pointer)) {
          shortenPath(this.url);
        } else {
          this.parseError = true;
          this.url.path = [];
        }
        this.state = "path";
        --this.pointer;
      }
    } else {
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseFileSlash(c4) {
    if (c4 === p("/") || c4 === p("\\")) {
      if (c4 === p("\\")) {
        this.parseError = true;
      }
      this.state = "file host";
    } else {
      if (this.base !== null && this.base.scheme === "file") {
        if (!startsWithWindowsDriveLetter(this.input, this.pointer) && isNormalizedWindowsDriveLetterString(this.base.path[0])) {
          this.url.path.push(this.base.path[0]);
        }
        this.url.host = this.base.host;
      }
      this.state = "path";
      --this.pointer;
    }
    return true;
  }
  parseFileHost(c4, cStr) {
    if (isNaN(c4) || c4 === p("/") || c4 === p("\\") || c4 === p("?") || c4 === p("#")) {
      --this.pointer;
      if (!this.stateOverride && isWindowsDriveLetterString(this.buffer)) {
        this.parseError = true;
        this.state = "path";
      } else if (this.buffer === "") {
        this.url.host = "";
        if (this.stateOverride) {
          return false;
        }
        this.state = "path start";
      } else {
        let host = parseHost(this.buffer, isNotSpecial(this.url));
        if (host === failure) {
          return failure;
        }
        if (host === "localhost") {
          host = "";
        }
        this.url.host = host;
        if (this.stateOverride) {
          return false;
        }
        this.buffer = "";
        this.state = "path start";
      }
    } else {
      this.buffer += cStr;
    }
    return true;
  }
  parsePathStart(c4) {
    if (isSpecial(this.url)) {
      if (c4 === p("\\")) {
        this.parseError = true;
      }
      this.state = "path";
      if (c4 !== p("/") && c4 !== p("\\")) {
        --this.pointer;
      }
    } else if (!this.stateOverride && c4 === p("?")) {
      this.url.query = "";
      this.state = "query";
    } else if (!this.stateOverride && c4 === p("#")) {
      this.url.fragment = "";
      this.state = "fragment";
    } else if (c4 !== void 0) {
      this.state = "path";
      if (c4 !== p("/")) {
        --this.pointer;
      }
    } else if (this.stateOverride && this.url.host === null) {
      this.url.path.push("");
    }
    return true;
  }
  parsePath(c4) {
    if (isNaN(c4) || c4 === p("/") || isSpecial(this.url) && c4 === p("\\") || !this.stateOverride && (c4 === p("?") || c4 === p("#"))) {
      if (isSpecial(this.url) && c4 === p("\\")) {
        this.parseError = true;
      }
      if (isDoubleDot(this.buffer)) {
        shortenPath(this.url);
        if (c4 !== p("/") && !(isSpecial(this.url) && c4 === p("\\"))) {
          this.url.path.push("");
        }
      } else if (isSingleDot(this.buffer) && c4 !== p("/") && !(isSpecial(this.url) && c4 === p("\\"))) {
        this.url.path.push("");
      } else if (!isSingleDot(this.buffer)) {
        if (this.url.scheme === "file" && this.url.path.length === 0 && isWindowsDriveLetterString(this.buffer)) {
          this.buffer = `${this.buffer[0]}:`;
        }
        this.url.path.push(this.buffer);
      }
      this.buffer = "";
      if (c4 === p("?")) {
        this.url.query = "";
        this.state = "query";
      }
      if (c4 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      }
    } else {
      if (c4 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.buffer += utf8PercentEncodeCodePoint(c4, isPathPercentEncode);
    }
    return true;
  }
  parseOpaquePath(c4) {
    if (c4 === p("?")) {
      this.url.query = "";
      this.state = "query";
    } else if (c4 === p("#")) {
      this.url.fragment = "";
      this.state = "fragment";
    } else {
      if (!isNaN(c4) && c4 !== p("%")) {
        this.parseError = true;
      }
      if (c4 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      if (!isNaN(c4)) {
        this.url.path += utf8PercentEncodeCodePoint(c4, isC0ControlPercentEncode);
      }
    }
    return true;
  }
  parseQuery(c4, cStr) {
    if (!isSpecial(this.url) || this.url.scheme === "ws" || this.url.scheme === "wss") {
      this.encodingOverride = "utf-8";
    }
    if (!this.stateOverride && c4 === p("#") || isNaN(c4)) {
      const queryPercentEncodePredicate = isSpecial(this.url) ? isSpecialQueryPercentEncode : isQueryPercentEncode;
      this.url.query += utf8PercentEncodeString(this.buffer, queryPercentEncodePredicate);
      this.buffer = "";
      if (c4 === p("#")) {
        this.url.fragment = "";
        this.state = "fragment";
      }
    } else if (!isNaN(c4)) {
      if (c4 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.buffer += cStr;
    }
    return true;
  }
  parseFragment(c4) {
    if (!isNaN(c4)) {
      if (c4 === p("%") && (!isASCIIHex(this.input[this.pointer + 1]) || !isASCIIHex(this.input[this.pointer + 2]))) {
        this.parseError = true;
      }
      this.url.fragment += utf8PercentEncodeCodePoint(c4, isFragmentPercentEncode);
    }
    return true;
  }
};
var fileOtherwiseCodePoints = /* @__PURE__ */ new Set([p("/"), p("\\"), p("?"), p("#")]);
function startsWithWindowsDriveLetter(input, pointer) {
  const length = input.length - pointer;
  return length >= 2 && isWindowsDriveLetterCodePoints(input[pointer], input[pointer + 1]) && (length === 2 || fileOtherwiseCodePoints.has(input[pointer + 2]));
}
function serializeURL(url, excludeFragment) {
  let output = `${url.scheme}:`;
  if (url.host !== null) {
    output += "//";
    if (url.username !== "" || url.password !== "") {
      output += url.username;
      if (url.password !== "") {
        output += `:${url.password}`;
      }
      output += "@";
    }
    output += serializeHost(url.host);
    if (url.port !== null) {
      output += `:${url.port}`;
    }
  }
  if (url.host === null && !hasAnOpaquePath(url) && url.path.length > 1 && url.path[0] === "") {
    output += "/.";
  }
  output += serializePath(url);
  if (url.query !== null) {
    output += `?${url.query}`;
  }
  if (!excludeFragment && url.fragment !== null) {
    output += `#${url.fragment}`;
  }
  return output;
}
function serializeOrigin(tuple) {
  let result = `${tuple.scheme}://`;
  result += serializeHost(tuple.host);
  if (tuple.port !== null) {
    result += `:${tuple.port}`;
  }
  return result;
}
function serializePath(url) {
  if (typeof url.path === "string") {
    return url.path;
  }
  let output = "";
  for (const segment of url.path) {
    output += `/${segment}`;
  }
  return output;
}
function serializeURLOrigin(url) {
  switch (url.scheme) {
    case "blob":
      try {
        return serializeURLOrigin(parseURL(serializePath(url)));
      } catch (e4) {
        return "null";
      }
    case "ftp":
    case "http":
    case "https":
    case "ws":
    case "wss":
      return serializeOrigin({
        scheme: url.scheme,
        host: url.host,
        port: url.port
      });
    case "file":
      return "null";
    default:
      return "null";
  }
}
function basicURLParse(input, options) {
  if (options === void 0) {
    options = {};
  }
  const usm = new URLStateMachine(input, options.baseURL, options.encodingOverride, options.url, options.stateOverride);
  if (usm.failure) {
    return null;
  }
  return usm.url;
}
function setTheUsername(url, username) {
  url.username = utf8PercentEncodeString(username, isUserinfoPercentEncode);
}
function setThePassword(url, password) {
  url.password = utf8PercentEncodeString(password, isUserinfoPercentEncode);
}
function serializeInteger(integer) {
  return String(integer);
}
function parseURL(input, options) {
  if (options === void 0) {
    options = {};
  }
  return basicURLParse(input, {
    baseURL: options.baseURL,
    encodingOverride: options.encodingOverride
  });
}
var NativeURL = typeof URL !== "undefined" ? URL : void 0;
var URLImpl = class {
  //Include URL type for "url" and "base" params.
  constructor(url, base2) {
    let parsedBase = null;
    if (base2 !== void 0) {
      if (base2 instanceof URL) {
        base2 = base2.href;
      }
      parsedBase = basicURLParse(base2);
      if (parsedBase === null) {
        throw new TypeError(`Invalid base URL: ${base2}`);
      }
    }
    if (url instanceof URL) {
      url = url.href;
    }
    const parsedURL = basicURLParse(url, { baseURL: parsedBase });
    if (parsedURL === null) {
      throw new TypeError(`Invalid URL: ${url}`);
    }
    const query = parsedURL.query !== null ? parsedURL.query : "";
    this._url = parsedURL;
    this._query = new URLSearchParamsImpl(query, {
      doNotStripQMark: true
    });
    this._query._url = this;
  }
  get href() {
    return serializeURL(this._url);
  }
  set href(v3) {
    const parsedURL = basicURLParse(v3);
    if (parsedURL === null) {
      throw new TypeError(`Invalid URL: ${v3}`);
    }
    this._url = parsedURL;
    this._query._list.splice(0);
    const { query } = parsedURL;
    if (query !== null) {
      this._query._list = parseUrlencodedString(query);
    }
  }
  get origin() {
    return serializeURLOrigin(this._url);
  }
  get protocol() {
    return `${this._url.scheme}:`;
  }
  set protocol(v3) {
    basicURLParse(`${v3}:`, {
      url: this._url,
      stateOverride: "scheme start"
    });
  }
  get username() {
    return this._url.username;
  }
  set username(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    setTheUsername(this._url, v3);
  }
  get password() {
    return this._url.password;
  }
  set password(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    setThePassword(this._url, v3);
  }
  get host() {
    const url = this._url;
    if (url.host === null) {
      return "";
    }
    if (url.port === null) {
      return serializeHost(url.host);
    }
    return `${serializeHost(url.host)}:${serializeInteger(url.port)}`;
  }
  set host(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    basicURLParse(v3, { url: this._url, stateOverride: "host" });
  }
  get hostname() {
    if (this._url.host === null) {
      return "";
    }
    return serializeHost(this._url.host);
  }
  set hostname(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    basicURLParse(v3, { url: this._url, stateOverride: "hostname" });
  }
  get port() {
    if (this._url.port === null) {
      return "";
    }
    return serializeInteger(this._url.port);
  }
  set port(v3) {
    if (cannotHaveAUsernamePasswordPort(this._url)) {
      return;
    }
    if (v3 === "") {
      this._url.port = null;
    } else {
      basicURLParse(v3, { url: this._url, stateOverride: "port" });
    }
  }
  get pathname() {
    return serializePath(this._url);
  }
  set pathname(v3) {
    if (hasAnOpaquePath(this._url)) {
      return;
    }
    this._url.path = [];
    basicURLParse(v3, { url: this._url, stateOverride: "path start" });
  }
  get search() {
    if (this._url.query === null || this._url.query === "") {
      return "";
    }
    return `?${this._url.query}`;
  }
  set search(v3) {
    const url = this._url;
    if (v3 === "") {
      url.query = null;
      this._query._list = [];
      return;
    }
    const input = v3[0] === "?" ? v3.substring(1) : v3;
    url.query = "";
    basicURLParse(input, { url, stateOverride: "query" });
    this._query._list = parseUrlencodedString(input);
  }
  get searchParams() {
    return this._query;
  }
  get hash() {
    if (this._url.fragment === null || this._url.fragment === "") {
      return "";
    }
    return `#${this._url.fragment}`;
  }
  set hash(v3) {
    if (v3 === "") {
      this._url.fragment = null;
      return;
    }
    const input = v3[0] === "#" ? v3.substring(1) : v3;
    this._url.fragment = "";
    basicURLParse(input, { url: this._url, stateOverride: "fragment" });
  }
  toJSON() {
    return this.href;
  }
  static createObjectURL(blob) {
    if (!NativeURL)
      throw new Error("This method requires a native implementation, which does not exist");
    return NativeURL.createObjectURL(blob);
  }
  static revokeObjectURL(url) {
    if (!NativeURL)
      throw new Error("This method requires a native implementation, which does not exist");
    return NativeURL.revokeObjectURL(url);
  }
};

// ../taler-util/lib/url.js
(function() {
  if (typeof globalThis === "object")
    return;
  Object.defineProperty(Object.prototype, "__magic__", {
    get: function() {
      return this;
    },
    configurable: true
    // This makes it possible to `delete` the getter later.
  });
  __magic__.globalThis = __magic__;
  delete Object.prototype.__magic__;
})();
var useOwnUrlImp = true;
var _URL = globalThis.URL;
if (useOwnUrlImp || !_URL) {
  globalThis.URL = _URL = URLImpl;
  _URL = URLImpl;
}
var URL2 = _URL;
var _URLSearchParams = globalThis.URLSearchParams;
if (useOwnUrlImp || !_URLSearchParams) {
  globalThis.URLSearchParams = URLSearchParamsImpl;
  _URLSearchParams = URLSearchParamsImpl;
}
var URLSearchParams2 = _URLSearchParams;

// ../taler-util/lib/helpers.js
function canonicalizeBaseUrl(url) {
  if (!url.startsWith("http") && !url.startsWith("https")) {
    url = "https://" + url;
  }
  const x5 = new URL2(url);
  if (!x5.pathname.endsWith("/")) {
    x5.pathname = x5.pathname + "/";
  }
  x5.search = "";
  x5.hash = "";
  return x5.href;
}
function canonicalJson(obj) {
  obj = JSON.parse(JSON.stringify(obj));
  if (typeof obj === "string") {
    return JSON.stringify(obj);
  }
  if (typeof obj === "number" || typeof obj === "boolean" || obj === null) {
    return JSON.stringify(obj);
  }
  if (Array.isArray(obj)) {
    const objs = obj.map((e4) => canonicalJson(e4));
    return `[${objs.join(",")}]`;
  }
  const keys = [];
  for (const key in obj) {
    keys.push(key);
  }
  keys.sort();
  let s4 = "{";
  for (let i4 = 0; i4 < keys.length; i4++) {
    const key = keys[i4];
    s4 += JSON.stringify(key) + ":" + canonicalJson(obj[key]);
    if (i4 !== keys.length - 1) {
      s4 += ",";
    }
  }
  return s4 + "}";
}
function strcmp(s1, s23) {
  if (s1 < s23) {
    return -1;
  }
  if (s1 > s23) {
    return 1;
  }
  return 0;
}
function j2s(x5) {
  return JSON.stringify(x5, void 0, 2);
}

// ../taler-util/lib/logging.js
var isNode = typeof process !== "undefined" && typeof process.release !== "undefined" && process.release.name === "node";
var LogLevel;
(function(LogLevel2) {
  LogLevel2["Trace"] = "trace";
  LogLevel2["Message"] = "message";
  LogLevel2["Info"] = "info";
  LogLevel2["Warn"] = "warn";
  LogLevel2["Error"] = "error";
  LogLevel2["None"] = "none";
})(LogLevel || (LogLevel = {}));
var globalLogLevel = LogLevel.Info;
var byTagLogLevel = {};
var nativeLogging = false;
Error.prototype.toString = function() {
  if (this === null || typeof this !== "object" && typeof this !== "function") {
    throw new TypeError();
  }
  let name = this.name;
  name = name === void 0 ? "Error" : `${name}`;
  let msg = this.message;
  msg = msg === void 0 ? "" : `${msg}`;
  let cause = "";
  if ("cause" in this) {
    cause = `
 Caused by: ${this.cause}`;
  }
  return `${name}: ${msg}${cause}`;
};
function getGlobalLogLevel() {
  return globalLogLevel;
}
function setGlobalLogLevelFromString(logLevelStr) {
  globalLogLevel = getLevelForString(logLevelStr);
}
function getLevelForString(logLevelStr) {
  switch (logLevelStr.toLowerCase()) {
    case "trace":
      return LogLevel.Trace;
    case "info":
      return LogLevel.Info;
    case "warn":
    case "warning":
      return LogLevel.Warn;
    case "error":
      return LogLevel.Error;
    case "none":
      return LogLevel.None;
    default:
      if (isNode) {
        process.stderr.write(`Invalid log level, defaulting to WARNING
`);
      } else {
        console.warn(`Invalid log level, defaulting to WARNING`);
      }
      return LogLevel.Warn;
  }
}
function writeNativeLog(message, tag, level, args) {
  const logFn = globalThis.__nativeLog;
  if (logFn) {
    let m4;
    if (args.length == 0) {
      m4 = message;
    } else {
      m4 = message + " " + args.toString();
    }
    logFn(level, tag, message);
  }
}
function writeNodeLog(message, tag, level, args) {
  try {
    let msg = `${(/* @__PURE__ */ new Date()).toISOString()} ${tag} ${level} ${message}`;
    if (args.length != 0) {
      msg += ` ${JSON.stringify(args, void 0, 2)}
`;
    } else {
      msg += `
`;
    }
    process.stderr.write(msg);
  } catch (e4) {
    let msg = `${(/* @__PURE__ */ new Date()).toISOString()} (logger) FATAL `;
    if (e4 instanceof Error) {
      msg += `failed to write log: ${e4.message}
`;
    } else {
      msg += "failed to write log\n";
    }
    process.stderr.write(msg);
  }
}
var Logger = class {
  constructor(tag) {
    this.tag = tag;
  }
  getGlobalLogLevel() {
    return globalLogLevel;
  }
  shouldLogTrace() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
        return true;
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogInfo() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
        return true;
      case LogLevel.Warn:
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogWarn() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
        return true;
      case LogLevel.Error:
      case LogLevel.None:
        return false;
    }
  }
  shouldLogError() {
    const level = byTagLogLevel[this.tag] ?? globalLogLevel;
    switch (level) {
      case LogLevel.Trace:
      case LogLevel.Message:
      case LogLevel.Info:
      case LogLevel.Warn:
      case LogLevel.Error:
        return true;
      case LogLevel.None:
        return false;
    }
  }
  info(message, ...args) {
    if (!this.shouldLogInfo()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 2, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "INFO", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} INFO ` + message, ...args);
    }
  }
  warn(message, ...args) {
    if (!this.shouldLogWarn()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 3, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "WARN", args);
    } else {
      console.warn(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} INFO ` + message, ...args);
    }
  }
  error(message, ...args) {
    if (!this.shouldLogError()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 4, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "ERROR", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} ERROR ` + message, ...args);
    }
  }
  trace(message, ...args) {
    if (!this.shouldLogTrace()) {
      return;
    }
    if (nativeLogging) {
      writeNativeLog(message, this.tag, 1, args);
      return;
    }
    if (isNode) {
      writeNodeLog(message, this.tag, "TRACE", args);
    } else {
      console.info(`${(/* @__PURE__ */ new Date()).toISOString()} ${this.tag} TRACE ` + message, ...args);
    }
  }
  reportBreak() {
    if (!this.shouldLogError()) {
      return;
    }
    const location2 = new Error("programming error");
    this.error(`assertion failed: ${location2.stack}`);
  }
};

// ../taler-util/lib/codec.js
var logger = new Logger("codec.ts");
var DecodingError = class _DecodingError extends Error {
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, _DecodingError.prototype);
    this.name = "DecodingError";
  }
};
function renderContext(c4) {
  const p4 = c4?.path;
  if (p4) {
    return p4.join(".");
  } else {
    return "(unknown)";
  }
}
function joinContext(c4, part) {
  const path = c4?.path ?? [];
  return {
    path: path.concat([part])
  };
}
var ObjectCodecBuilder = class {
  constructor() {
    this.propList = [];
    this.deprecatedProps = /* @__PURE__ */ new Set();
    this._allowExtra = false;
  }
  /**
   * Define a property for the object.
   */
  property(x5, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.propList.push({ name: x5, codec });
    return this;
  }
  /**
   * Define a property for the object.
   */
  propertyStrict(x5, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.propList.push({ name: x5, codec });
    return this;
  }
  /**
   * Concatenate properties from @a codec.
   *
   * @param other codec to concat properties from
   *
   * FIXME: do proper union of all `other' props.
   */
  mixin(other) {
    this.propList.push(...other.getProps());
    return this;
  }
  /**
   * Define a deprecated property for the object.
   *
   * Deprecated properties won't be validated, their presence will
   * be validated in TRACE mode.
   */
  deprecatedProperty(x5) {
    this.deprecatedProps.add(x5);
    return this;
  }
  /**
   * Do not log warnings if the object has extra properties.
   */
  allowExtra() {
    this._allowExtra = true;
    return this;
  }
  /**
   * Return the built codec.
   *
   * @param objectDisplayName name of the object that this codec operates on,
   *   used in error messages.
   */
  build(objectDisplayName) {
    const propList = this.propList;
    const allowExtra = this._allowExtra;
    const deprecatedPros = this.deprecatedProps;
    return {
      decode(x5, c4) {
        if (!c4) {
          c4 = {
            path: [`(${objectDisplayName})`]
          };
        }
        if (typeof x5 !== "object") {
          throw new DecodingError(`expected object for ${objectDisplayName} at ${renderContext(c4)} but got ${typeof x5}`);
        }
        const obj = {};
        for (const prop of propList) {
          const propRawVal = x5[prop.name];
          const propVal = prop.codec.decode(propRawVal, joinContext(c4, prop.name));
          obj[prop.name] = propVal;
        }
        for (const prop in x5) {
          if (prop in obj) {
            continue;
          }
          if (allowExtra) {
            obj[prop] = x5[prop];
          } else if (deprecatedPros.has(prop)) {
            logger.trace(`Deprecated property ${prop} for ${objectDisplayName} at ${renderContext(c4)}`);
          } else {
            logger.warn(`Extra property ${prop} for ${objectDisplayName} at ${renderContext(c4)}`);
          }
        }
        return obj;
      },
      getProps() {
        return propList;
      }
    };
  }
};
var UnionCodecBuilder = class {
  constructor(discriminator, baseCodec) {
    this.discriminator = discriminator;
    this.baseCodec = baseCodec;
    this.alternatives = /* @__PURE__ */ new Map();
  }
  /**
   * Define a property for the object.
   */
  alternative(tagValue, codec) {
    if (!codec) {
      throw Error("inner codec must be defined");
    }
    this.alternatives.set(tagValue, { codec, tagValue });
    return this;
  }
  /**
   * Return the built codec.
   *
   * @param objectDisplayName name of the object that this codec operates on,
   *   used in error messages.
   */
  build(objectDisplayName) {
    const alternatives = this.alternatives;
    const discriminator = this.discriminator;
    const baseCodec = this.baseCodec;
    return {
      decode(x5, c4) {
        if (!c4) {
          c4 = {
            path: [`(${objectDisplayName})`]
          };
        }
        const d4 = x5[discriminator];
        if (d4 === void 0 && !alternatives.has(d4)) {
          throw new DecodingError(`expected tag for ${objectDisplayName} at ${renderContext(c4)}.${String(discriminator)}`);
        }
        const alt = alternatives.get(d4);
        if (!alt) {
          throw new DecodingError(`unknown tag for ${objectDisplayName} ${d4} at ${renderContext(c4)}.${String(discriminator)}`);
        }
        const altDecoded = alt.codec.decode(x5);
        if (baseCodec) {
          const baseDecoded = baseCodec.decode(x5, c4);
          return { ...baseDecoded, ...altDecoded };
        } else {
          return altDecoded;
        }
      }
    };
  }
};
var UnionCodecPreBuilder = class {
  discriminateOn(discriminator, baseCodec) {
    return new UnionCodecBuilder(discriminator, baseCodec);
  }
};
function buildCodecForObject() {
  return new ObjectCodecBuilder();
}
function buildCodecForUnion() {
  return new UnionCodecPreBuilder();
}
function codecForMap(innerCodec) {
  if (!innerCodec) {
    throw Error("inner codec must be defined");
  }
  return {
    decode(x5, c4) {
      const map2 = {};
      if (typeof x5 !== "object") {
        throw new DecodingError(`expected object at ${renderContext(c4)}`);
      }
      for (const i4 in x5) {
        map2[i4] = innerCodec.decode(x5[i4], joinContext(c4, `[${i4}]`));
      }
      return map2;
    }
  };
}
function codecForList(innerCodec) {
  if (!innerCodec) {
    throw Error("inner codec must be defined");
  }
  return {
    decode(x5, c4) {
      const arr = [];
      if (!Array.isArray(x5)) {
        throw new DecodingError(`expected array at ${renderContext(c4)}`);
      }
      for (const i4 in x5) {
        arr.push(innerCodec.decode(x5[i4], joinContext(c4, `[${i4}]`)));
      }
      return arr;
    }
  };
}
function codecForNumber() {
  return {
    decode(x5, c4) {
      if (typeof x5 === "number") {
        return x5;
      }
      throw new DecodingError(`expected number at ${renderContext(c4)} but got ${typeof x5}`);
    }
  };
}
function codecForBoolean() {
  return {
    decode(x5, c4) {
      if (typeof x5 === "boolean") {
        return x5;
      }
      throw new DecodingError(`expected boolean at ${renderContext(c4)} but got ${typeof x5}`);
    }
  };
}
function codecForString() {
  return {
    decode(x5, c4) {
      if (typeof x5 === "string") {
        return x5;
      }
      throw new DecodingError(`expected string at ${renderContext(c4)} but got ${typeof x5}`);
    }
  };
}
function codecForAny() {
  return {
    decode(x5, c4) {
      return x5;
    }
  };
}
function codecForConstString(s4) {
  return {
    decode(x5, c4) {
      if (x5 === s4) {
        return x5;
      }
      if (typeof x5 !== "string") {
        throw new DecodingError(`expected string constant "${s4}" at ${renderContext(c4)} but got ${typeof x5}`);
      }
      throw new DecodingError(`expected string constant "${s4}" at ${renderContext(c4)} but got string value "${x5}"`);
    }
  };
}
function codecOptional(innerCodec) {
  return {
    decode(x5, c4) {
      if (x5 === void 0 || x5 === null) {
        return void 0;
      }
      return innerCodec.decode(x5, c4);
    }
  };
}
function codecOptionalDefault(innerCodec, def) {
  return {
    decode(x5, c4) {
      if (x5 === void 0 || x5 === null) {
        return def;
      }
      return innerCodec.decode(x5, c4);
    }
  };
}
function codecForEither(...alts) {
  return {
    decode(x5, c4) {
      for (const alt of alts) {
        try {
          return alt.decode(x5, c4);
        } catch (e4) {
          continue;
        }
      }
      if (logger.shouldLogTrace()) {
        logger.trace(`offending value: ${j2s(x5)}`);
      }
      throw new DecodingError(`No alternative matched at at ${renderContext(c4)}`);
    }
  };
}

// ../taler-util/lib/amounts.js
var amountFractionalBase = 1e8;
var amountFractionalLength = 8;
var amountMaxValue = 2 ** 52;
var FRAC_SEPARATOR = ".";
var Amount = class _Amount {
  static from(a4) {
    return new _Amount(Amounts.parseOrThrow(a4), 0);
  }
  static zeroOfCurrency(currency) {
    return new _Amount(Amounts.zeroOfCurrency(currency), 0);
  }
  add(...a4) {
    if (this.saturated) {
      return this;
    }
    const r3 = Amounts.add(this.val, ...a4);
    return new _Amount(r3.amount, r3.saturated ? 1 : 0);
  }
  mult(n2) {
    if (this.saturated) {
      return this;
    }
    const r3 = Amounts.mult(this, n2);
    return new _Amount(r3.amount, r3.saturated ? 1 : 0);
  }
  toJson() {
    return { ...this.val };
  }
  toString() {
    return Amounts.stringify(this.val);
  }
  constructor(val, saturated) {
    this.val = val;
    this.saturated = saturated;
  }
};
function codecForAmountString() {
  return {
    decode(x5, c4) {
      if (typeof x5 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c4)} but got ${typeof x5}`);
      }
      if (Amounts.parse(x5) === void 0) {
        throw new DecodingError(`invalid amount at ${renderContext(c4)} got "${x5}"`);
      }
      return x5;
    }
  };
}
var Amounts = class _Amounts {
  constructor() {
    throw Error("not instantiable");
  }
  static currencyOf(amount) {
    const amt = _Amounts.parseOrThrow(amount);
    return amt.currency;
  }
  static zeroOfAmount(amount) {
    const amt = _Amounts.parseOrThrow(amount);
    return {
      currency: amt.currency,
      fraction: 0,
      value: 0
    };
  }
  /**
   * Get an amount that represents zero units of a currency.
   */
  static zeroOfCurrency(currency) {
    return {
      currency,
      fraction: 0,
      value: 0
    };
  }
  static jsonifyAmount(amt) {
    if (typeof amt === "string") {
      return _Amounts.parseOrThrow(amt);
    }
    if (amt instanceof Amount) {
      return amt.toJson();
    }
    return amt;
  }
  static divmod(a1, a23) {
    const am1 = _Amounts.jsonifyAmount(a1);
    const am2 = _Amounts.jsonifyAmount(a23);
    if (am1.currency != am2.currency) {
      throw Error(`incompatible currency (${am1.currency} vs${am2.currency})`);
    }
    const x1 = BigInt(am1.value) * BigInt(amountFractionalBase) + BigInt(am1.fraction);
    const x22 = BigInt(am2.value) * BigInt(amountFractionalBase) + BigInt(am2.fraction);
    const quotient = x1 / x22;
    const remainderScaled = x1 % x22;
    return {
      quotient: Number(quotient),
      remainder: {
        currency: am1.currency,
        value: Number(remainderScaled / BigInt(amountFractionalBase)),
        fraction: Number(remainderScaled % BigInt(amountFractionalBase))
      }
    };
  }
  static sum(amounts) {
    if (amounts.length <= 0) {
      throw Error("can't sum zero amounts");
    }
    const jsonAmounts = amounts.map((x5) => _Amounts.jsonifyAmount(x5));
    return _Amounts.add(jsonAmounts[0], ...jsonAmounts.slice(1));
  }
  static sumOrZero(currency, amounts) {
    if (amounts.length <= 0) {
      return {
        amount: _Amounts.zeroOfCurrency(currency),
        saturated: false
      };
    }
    const jsonAmounts = amounts.map((x5) => _Amounts.jsonifyAmount(x5));
    return _Amounts.add(jsonAmounts[0], ...jsonAmounts.slice(1));
  }
  /**
   * Add two amounts.  Return the result and whether
   * the addition overflowed.  The overflow is always handled
   * by saturating and never by wrapping.
   *
   * Throws when currencies don't match.
   */
  static add(first, ...rest) {
    const firstJ = _Amounts.jsonifyAmount(first);
    const currency = firstJ.currency;
    let value = firstJ.value + Math.floor(firstJ.fraction / amountFractionalBase);
    if (value > amountMaxValue) {
      return {
        amount: {
          currency,
          value: amountMaxValue,
          fraction: amountFractionalBase - 1
        },
        saturated: true
      };
    }
    let fraction = firstJ.fraction % amountFractionalBase;
    for (const x5 of rest) {
      const xJ = _Amounts.jsonifyAmount(x5);
      if (xJ.currency.toUpperCase() !== currency.toUpperCase()) {
        throw Error(`Mismatched currency: ${xJ.currency} and ${currency}`);
      }
      value = value + xJ.value + Math.floor((fraction + xJ.fraction) / amountFractionalBase);
      fraction = Math.floor((fraction + xJ.fraction) % amountFractionalBase);
      if (value > amountMaxValue) {
        return {
          amount: {
            currency,
            value: amountMaxValue,
            fraction: amountFractionalBase - 1
          },
          saturated: true
        };
      }
    }
    return { amount: { currency, value, fraction }, saturated: false };
  }
  /**
   * Subtract two amounts.  Return the result and whether
   * the subtraction overflowed.  The overflow is always handled
   * by saturating and never by wrapping.
   *
   * Throws when currencies don't match.
   */
  static sub(a4, ...rest) {
    const aJ = _Amounts.jsonifyAmount(a4);
    const currency = aJ.currency;
    let value = aJ.value;
    let fraction = aJ.fraction;
    for (const b4 of rest) {
      const bJ = _Amounts.jsonifyAmount(b4);
      if (bJ.currency.toUpperCase() !== aJ.currency.toUpperCase()) {
        throw Error(`Mismatched currency: ${bJ.currency} and ${currency}`);
      }
      if (fraction < bJ.fraction) {
        if (value < 1) {
          return {
            amount: { currency, value: 0, fraction: 0 },
            saturated: true
          };
        }
        value--;
        fraction += amountFractionalBase;
      }
      console.assert(fraction >= bJ.fraction);
      fraction -= bJ.fraction;
      if (value < bJ.value) {
        return { amount: { currency, value: 0, fraction: 0 }, saturated: true };
      }
      value -= bJ.value;
    }
    return { amount: { currency, value, fraction }, saturated: false };
  }
  /**
   * Compare two amounts.  Returns 0 when equal, -1 when a < b
   * and +1 when a > b.  Throws when currencies don't match.
   */
  static cmp(a4, b4) {
    a4 = _Amounts.jsonifyAmount(a4);
    b4 = _Amounts.jsonifyAmount(b4);
    if (a4.currency !== b4.currency) {
      throw Error(`Mismatched currency: ${a4.currency} and ${b4.currency}`);
    }
    const av = a4.value + Math.floor(a4.fraction / amountFractionalBase);
    const af = a4.fraction % amountFractionalBase;
    const bv = b4.value + Math.floor(b4.fraction / amountFractionalBase);
    const bf = b4.fraction % amountFractionalBase;
    switch (true) {
      case av < bv:
        return -1;
      case av > bv:
        return 1;
      case af < bf:
        return -1;
      case af > bf:
        return 1;
      case af === bf:
        return 0;
      default:
        throw Error("assertion failed");
    }
  }
  /**
   * Create a copy of an amount.
   */
  static copy(a4) {
    return {
      currency: a4.currency,
      fraction: a4.fraction,
      value: a4.value
    };
  }
  /**
   * Divide an amount.  Throws on division by zero.
   */
  static divide(a4, n2) {
    if (n2 === 0) {
      throw Error(`Division by 0`);
    }
    if (n2 === 1) {
      return { value: a4.value, fraction: a4.fraction, currency: a4.currency };
    }
    const r3 = a4.value % n2;
    return {
      currency: a4.currency,
      fraction: Math.floor((r3 * amountFractionalBase + a4.fraction) / n2),
      value: Math.floor(a4.value / n2)
    };
  }
  /**
   * Check if an amount is non-zero.
   */
  static isNonZero(a4) {
    a4 = _Amounts.jsonifyAmount(a4);
    return a4.value > 0 || a4.fraction > 0;
  }
  static isZero(a4) {
    a4 = _Amounts.jsonifyAmount(a4);
    return a4.value === 0 && a4.fraction === 0;
  }
  /**
   * Check whether a string is a valid currency for a Taler amount.
   */
  static isCurrency(s4) {
    return /^[a-zA-Z]{1,11}$/.test(s4);
  }
  /**
   * Parse an amount like 'EUR:20.5' for 20 Euros and 50 ct.
   *
   * Currency name size limit is 11 of ASCII letters
   * Fraction size limit is 8
   */
  static parse(s4) {
    const res = s4.match(/^([a-zA-Z]{1,11}):([0-9]+)([.][0-9]{1,8})?$/);
    if (!res) {
      return void 0;
    }
    const tail = res[3] || FRAC_SEPARATOR + "0";
    if (tail.length > amountFractionalLength + 1) {
      return void 0;
    }
    const value = Number.parseInt(res[2]);
    if (value > amountMaxValue) {
      return void 0;
    }
    return {
      currency: res[1].toUpperCase(),
      fraction: Math.round(amountFractionalBase * Number.parseFloat(tail)),
      value
    };
  }
  /**
   * Parse amount in standard string form (like 'EUR:20.5'),
   * throw if the input is not a valid amount.
   */
  static parseOrThrow(s4) {
    if (s4 instanceof Amount) {
      return s4.toJson();
    }
    if (typeof s4 === "object") {
      if (typeof s4.currency !== "string") {
        throw Error("invalid amount object");
      }
      if (typeof s4.value !== "number") {
        throw Error("invalid amount object");
      }
      if (typeof s4.fraction !== "number") {
        throw Error("invalid amount object");
      }
      return { currency: s4.currency, value: s4.value, fraction: s4.fraction };
    } else if (typeof s4 === "string") {
      const res = _Amounts.parse(s4);
      if (!res) {
        throw Error(`Can't parse amount: "${s4}"`);
      }
      return res;
    } else {
      throw Error("invalid amount (illegal type)");
    }
  }
  static min(a4, b4) {
    const cr = _Amounts.cmp(a4, b4);
    if (cr >= 0) {
      return _Amounts.jsonifyAmount(b4);
    } else {
      return _Amounts.jsonifyAmount(a4);
    }
  }
  static max(a4, b4) {
    const cr = _Amounts.cmp(a4, b4);
    if (cr >= 0) {
      return _Amounts.jsonifyAmount(a4);
    } else {
      return _Amounts.jsonifyAmount(b4);
    }
  }
  static mult(a4, n2) {
    a4 = this.jsonifyAmount(a4);
    if (!Number.isInteger(n2)) {
      throw Error("amount can only be multiplied by an integer");
    }
    if (n2 < 0) {
      throw Error("amount can only be multiplied by a positive integer");
    }
    if (n2 == 0) {
      return {
        amount: _Amounts.zeroOfCurrency(a4.currency),
        saturated: false
      };
    }
    let x5 = a4;
    let acc = _Amounts.zeroOfCurrency(a4.currency);
    while (n2 > 1) {
      if (n2 % 2 == 0) {
        n2 = n2 / 2;
      } else {
        n2 = (n2 - 1) / 2;
        const r23 = _Amounts.add(acc, x5);
        if (r23.saturated) {
          return r23;
        }
        acc = r23.amount;
      }
      const r22 = _Amounts.add(x5, x5);
      if (r22.saturated) {
        return r22;
      }
      x5 = r22.amount;
    }
    return _Amounts.add(acc, x5);
  }
  /**
   * Check if the argument is a valid amount in string form.
   */
  static check(a4) {
    if (typeof a4 !== "string") {
      return false;
    }
    try {
      const parsedAmount = _Amounts.parse(a4);
      return !!parsedAmount;
    } catch {
      return false;
    }
  }
  /**
   * Convert to standard human-readable string representation that's
   * also used in JSON formats.
   */
  static stringify(a4) {
    a4 = _Amounts.jsonifyAmount(a4);
    const s4 = this.stringifyValue(a4);
    return `${a4.currency}:${s4}`;
  }
  static amountHasSameCurrency(a1, a23) {
    const x1 = this.jsonifyAmount(a1);
    const x22 = this.jsonifyAmount(a23);
    return x1.currency.toUpperCase() === x22.currency.toUpperCase();
  }
  static isSameCurrency(curr1, curr2) {
    return curr1.toLowerCase() === curr2.toLowerCase();
  }
  static stringifyValue(a4, minFractional = 0) {
    const aJ = _Amounts.jsonifyAmount(a4);
    const av = aJ.value + Math.floor(aJ.fraction / amountFractionalBase);
    const af = aJ.fraction % amountFractionalBase;
    let s4 = av.toString();
    if (af || minFractional) {
      s4 = s4 + FRAC_SEPARATOR;
      let n2 = af;
      for (let i4 = 0; i4 < amountFractionalLength; i4++) {
        if (!n2 && i4 >= minFractional) {
          break;
        }
        s4 = s4 + Math.floor(n2 / amountFractionalBase * 10).toString();
        n2 = n2 * 10 % amountFractionalBase;
      }
    }
    return s4;
  }
  /**
   * Number of fractional digits needed to fully represent the amount
   * @param a amount
   * @returns
   */
  static maxFractionalDigits(a4) {
    if (a4.fraction === 0)
      return 0;
    if (a4.fraction < 0) {
      console.error("amount fraction can not be negative", a4);
      return 0;
    }
    let i4 = 0;
    let check = true;
    let rest = a4.fraction;
    while (rest > 0 && check) {
      check = rest % 10 === 0;
      rest = rest / 10;
      i4++;
    }
    return amountFractionalLength - i4 + 1;
  }
  static stringifyValueWithSpec(value, spec) {
    const strValue = _Amounts.stringifyValue(value);
    const pos = strValue.indexOf(FRAC_SEPARATOR);
    const originalPosition = pos < 0 ? strValue.length : pos;
    let currency = value.currency;
    const names2 = Object.keys(spec.alt_unit_names);
    let FRAC_POS_NEW_POSITION = originalPosition;
    if (names2.length > 0) {
      let unitIndex = "0";
      names2.forEach((index) => {
        const i4 = Number.parseInt(index, 10);
        if (Number.isNaN(i4))
          return;
        if (originalPosition - i4 <= 0)
          return;
        if (originalPosition - i4 < FRAC_POS_NEW_POSITION) {
          FRAC_POS_NEW_POSITION = originalPosition - i4;
          unitIndex = index;
        }
      });
      currency = spec.alt_unit_names[unitIndex];
    }
    if (originalPosition === FRAC_POS_NEW_POSITION) {
      const { normal: normal2, small: small2 } = splitNormalAndSmall(strValue, originalPosition, spec);
      return { currency, normal: normal2, small: small2 };
    }
    const intPart = strValue.substring(0, originalPosition);
    const fracPArt = strValue.substring(originalPosition + 1);
    const newValue = intPart.substring(0, FRAC_POS_NEW_POSITION) + FRAC_SEPARATOR + intPart.substring(FRAC_POS_NEW_POSITION) + fracPArt;
    const { normal, small } = splitNormalAndSmall(newValue, FRAC_POS_NEW_POSITION, spec);
    return { currency, normal, small };
  }
};
function splitNormalAndSmall(decimal, fracSeparatorIndex, spec) {
  let normal;
  let small;
  if (decimal.length - fracSeparatorIndex - 1 > spec.num_fractional_normal_digits) {
    const limit = fracSeparatorIndex + spec.num_fractional_normal_digits + 1;
    normal = decimal.substring(0, limit);
    small = decimal.substring(limit);
  } else {
    normal = decimal;
    small = void 0;
  }
  return { normal, small };
}

// ../taler-util/lib/http-impl.missing.js
var HttpLibImpl = class {
  fetch(url, opt) {
    throw new Error("Method not implemented.");
  }
};

// ../taler-util/lib/taler-error-codes.js
var TalerErrorCode;
(function(TalerErrorCode2) {
  TalerErrorCode2[TalerErrorCode2["NONE"] = 0] = "NONE";
  TalerErrorCode2[TalerErrorCode2["INVALID"] = 1] = "INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CLIENT_INTERNAL_ERROR"] = 2] = "GENERIC_CLIENT_INTERNAL_ERROR";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CLIENT_UNSUPPORTED_PROTOCOL_VERSION"] = 3] = "GENERIC_CLIENT_UNSUPPORTED_PROTOCOL_VERSION";
  TalerErrorCode2[TalerErrorCode2["GENERIC_INVALID_RESPONSE"] = 10] = "GENERIC_INVALID_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TIMEOUT"] = 11] = "GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_VERSION_MALFORMED"] = 12] = "GENERIC_VERSION_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_REPLY_MALFORMED"] = 13] = "GENERIC_REPLY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CONFIGURATION_INVALID"] = 14] = "GENERIC_CONFIGURATION_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UNEXPECTED_REQUEST_ERROR"] = 15] = "GENERIC_UNEXPECTED_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_PERMISSION_INSUFFICIENT"] = 16] = "GENERIC_TOKEN_PERMISSION_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_METHOD_INVALID"] = 20] = "GENERIC_METHOD_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_ENDPOINT_UNKNOWN"] = 21] = "GENERIC_ENDPOINT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_JSON_INVALID"] = 22] = "GENERIC_JSON_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_HTTP_HEADERS_MALFORMED"] = 23] = "GENERIC_HTTP_HEADERS_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PAYTO_URI_MALFORMED"] = 24] = "GENERIC_PAYTO_URI_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARAMETER_MISSING"] = 25] = "GENERIC_PARAMETER_MISSING";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARAMETER_MALFORMED"] = 26] = "GENERIC_PARAMETER_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_RESERVE_PUB_MALFORMED"] = 27] = "GENERIC_RESERVE_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_COMPRESSION_INVALID"] = 28] = "GENERIC_COMPRESSION_INVALID";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PATH_SEGMENT_MALFORMED"] = 29] = "GENERIC_PATH_SEGMENT_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CURRENCY_MISMATCH"] = 30] = "GENERIC_CURRENCY_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["GENERIC_URI_TOO_LONG"] = 31] = "GENERIC_URI_TOO_LONG";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UPLOAD_EXCEEDS_LIMIT"] = 32] = "GENERIC_UPLOAD_EXCEEDS_LIMIT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_UNAUTHORIZED"] = 40] = "GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_UNKNOWN"] = 41] = "GENERIC_TOKEN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_EXPIRED"] = 42] = "GENERIC_TOKEN_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_TOKEN_MALFORMED"] = 43] = "GENERIC_TOKEN_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FORBIDDEN"] = 44] = "GENERIC_FORBIDDEN";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_SETUP_FAILED"] = 50] = "GENERIC_DB_SETUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_START_FAILED"] = 51] = "GENERIC_DB_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_STORE_FAILED"] = 52] = "GENERIC_DB_STORE_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_FETCH_FAILED"] = 53] = "GENERIC_DB_FETCH_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_COMMIT_FAILED"] = 54] = "GENERIC_DB_COMMIT_FAILED";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_SOFT_FAILURE"] = 55] = "GENERIC_DB_SOFT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_DB_INVARIANT_FAILURE"] = 56] = "GENERIC_DB_INVARIANT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_INTERNAL_INVARIANT_FAILURE"] = 60] = "GENERIC_INTERNAL_INVARIANT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_COMPUTE_JSON_HASH"] = 61] = "GENERIC_FAILED_COMPUTE_JSON_HASH";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_COMPUTE_AMOUNT"] = 62] = "GENERIC_FAILED_COMPUTE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["GENERIC_PARSER_OUT_OF_MEMORY"] = 70] = "GENERIC_PARSER_OUT_OF_MEMORY";
  TalerErrorCode2[TalerErrorCode2["GENERIC_ALLOCATION_FAILURE"] = 71] = "GENERIC_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_JSON_ALLOCATION_FAILURE"] = 72] = "GENERIC_JSON_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_CURL_ALLOCATION_FAILURE"] = 73] = "GENERIC_CURL_ALLOCATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_TO_LOAD_TEMPLATE"] = 74] = "GENERIC_FAILED_TO_LOAD_TEMPLATE";
  TalerErrorCode2[TalerErrorCode2["GENERIC_FAILED_TO_EXPAND_TEMPLATE"] = 75] = "GENERIC_FAILED_TO_EXPAND_TEMPLATE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_BAD_CONFIGURATION"] = 1e3] = "EXCHANGE_GENERIC_BAD_CONFIGURATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_OPERATION_UNKNOWN"] = 1001] = "EXCHANGE_GENERIC_OPERATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_WRONG_NUMBER_OF_SEGMENTS"] = 1002] = "EXCHANGE_GENERIC_WRONG_NUMBER_OF_SEGMENTS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_CONFLICTING_DENOMINATION_KEY"] = 1003] = "EXCHANGE_GENERIC_COIN_CONFLICTING_DENOMINATION_KEY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COINS_INVALID_COIN_PUB"] = 1004] = "EXCHANGE_GENERIC_COINS_INVALID_COIN_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_KEY_UNKNOWN"] = 1005] = "EXCHANGE_GENERIC_DENOMINATION_KEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_SIGNATURE_INVALID"] = 1006] = "EXCHANGE_DENOMINATION_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KEYS_MISSING"] = 1007] = "EXCHANGE_GENERIC_KEYS_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_VALIDITY_IN_FUTURE"] = 1008] = "EXCHANGE_GENERIC_DENOMINATION_VALIDITY_IN_FUTURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_EXPIRED"] = 1009] = "EXCHANGE_GENERIC_DENOMINATION_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_DENOMINATION_REVOKED"] = 1010] = "EXCHANGE_GENERIC_DENOMINATION_REVOKED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_SECMOD_TIMEOUT"] = 1011] = "EXCHANGE_GENERIC_SECMOD_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_INSUFFICIENT_FUNDS"] = 1012] = "EXCHANGE_GENERIC_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_HISTORY_COMPUTATION_FAILED"] = 1013] = "EXCHANGE_GENERIC_COIN_HISTORY_COMPUTATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_HISTORY_DB_ERROR_INSUFFICIENT_FUNDS"] = 1014] = "EXCHANGE_GENERIC_HISTORY_DB_ERROR_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_CONFLICTING_AGE_HASH"] = 1015] = "EXCHANGE_GENERIC_COIN_CONFLICTING_AGE_HASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_INVALID_DENOMINATION_CIPHER_FOR_OPERATION"] = 1016] = "EXCHANGE_GENERIC_INVALID_DENOMINATION_CIPHER_FOR_OPERATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_CIPHER_MISMATCH"] = 1017] = "EXCHANGE_GENERIC_CIPHER_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_NEW_DENOMS_ARRAY_SIZE_EXCESSIVE"] = 1018] = "EXCHANGE_GENERIC_NEW_DENOMS_ARRAY_SIZE_EXCESSIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_COIN_UNKNOWN"] = 1019] = "EXCHANGE_GENERIC_COIN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_CLOCK_SKEW"] = 1020] = "EXCHANGE_GENERIC_CLOCK_SKEW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AMOUNT_EXCEEDS_DENOMINATION_VALUE"] = 1021] = "EXCHANGE_GENERIC_AMOUNT_EXCEEDS_DENOMINATION_VALUE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_GLOBAL_FEES_MISSING"] = 1022] = "EXCHANGE_GENERIC_GLOBAL_FEES_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_WIRE_FEES_MISSING"] = 1023] = "EXCHANGE_GENERIC_WIRE_FEES_MISSING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_PUB_MALFORMED"] = 1024] = "EXCHANGE_GENERIC_PURSE_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_UNKNOWN"] = 1025] = "EXCHANGE_GENERIC_PURSE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_EXPIRED"] = 1026] = "EXCHANGE_GENERIC_PURSE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_RESERVE_UNKNOWN"] = 1027] = "EXCHANGE_GENERIC_RESERVE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_REQUIRED"] = 1028] = "EXCHANGE_GENERIC_KYC_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_CONFLICTING_ATTEST_VS_AGE_COMMITMENT"] = 1029] = "EXCHANGE_PURSE_DEPOSIT_COIN_CONFLICTING_ATTEST_VS_AGE_COMMITMENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_AGE_ATTESTATION_FAILURE"] = 1030] = "EXCHANGE_PURSE_DEPOSIT_COIN_AGE_ATTESTATION_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_PURSE_DELETED"] = 1031] = "EXCHANGE_GENERIC_PURSE_DELETED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_PUB_MALFORMED"] = 1032] = "EXCHANGE_GENERIC_AML_OFFICER_PUB_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_GET_SIGNATURE_INVALID"] = 1033] = "EXCHANGE_GENERIC_AML_OFFICER_GET_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_OFFICER_ACCESS_DENIED"] = 1034] = "EXCHANGE_GENERIC_AML_OFFICER_ACCESS_DENIED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_PENDING"] = 1035] = "EXCHANGE_GENERIC_AML_PENDING";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_FROZEN"] = 1036] = "EXCHANGE_GENERIC_AML_FROZEN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_CONVERTER_FAILED"] = 1037] = "EXCHANGE_GENERIC_KYC_CONVERTER_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_FAILED"] = 1038] = "EXCHANGE_GENERIC_KYC_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_FALLBACK_FAILED"] = 1039] = "EXCHANGE_GENERIC_KYC_FALLBACK_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_FALLBACK_UNKNOWN"] = 1040] = "EXCHANGE_GENERIC_KYC_FALLBACK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_BANK_ACCOUNT_UNKNOWN"] = 1041] = "EXCHANGE_GENERIC_BANK_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_AML_PROGRAM_RECURSION_DETECTED"] = 1042] = "EXCHANGE_GENERIC_AML_PROGRAM_RECURSION_DETECTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GENERIC_KYC_SANCTION_LIST_CHECK_FAILED"] = 1043] = "EXCHANGE_GENERIC_KYC_SANCTION_LIST_CHECK_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_NOT_FOUND"] = 1100] = "EXCHANGE_DEPOSITS_GET_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_H_WIRE"] = 1101] = "EXCHANGE_DEPOSITS_GET_INVALID_H_WIRE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_MERCHANT_PUB"] = 1102] = "EXCHANGE_DEPOSITS_GET_INVALID_MERCHANT_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_H_CONTRACT_TERMS"] = 1103] = "EXCHANGE_DEPOSITS_GET_INVALID_H_CONTRACT_TERMS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_COIN_PUB"] = 1104] = "EXCHANGE_DEPOSITS_GET_INVALID_COIN_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_INVALID_SIGNATURE_BY_EXCHANGE"] = 1105] = "EXCHANGE_DEPOSITS_GET_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_GET_MERCHANT_SIGNATURE_INVALID"] = 1106] = "EXCHANGE_DEPOSITS_GET_MERCHANT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSITS_POLICY_NOT_ACCEPTED"] = 1107] = "EXCHANGE_DEPOSITS_POLICY_NOT_ACCEPTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_INSUFFICIENT_FUNDS"] = 1150] = "EXCHANGE_WITHDRAW_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_INSUFFICIENT_FUNDS"] = 1151] = "EXCHANGE_AGE_WITHDRAW_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_AMOUNT_FEE_OVERFLOW"] = 1152] = "EXCHANGE_WITHDRAW_AMOUNT_FEE_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_SIGNATURE_FAILED"] = 1153] = "EXCHANGE_WITHDRAW_SIGNATURE_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_RESERVE_SIGNATURE_INVALID"] = 1154] = "EXCHANGE_WITHDRAW_RESERVE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVE_HISTORY_ERROR_INSUFFICIENT_FUNDS"] = 1155] = "EXCHANGE_RESERVE_HISTORY_ERROR_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_GET_RESERVE_HISTORY_ERROR_INSUFFICIENT_BALANCE"] = 1156] = "EXCHANGE_GET_RESERVE_HISTORY_ERROR_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_DENOMINATION_KEY_LOST"] = 1158] = "EXCHANGE_WITHDRAW_DENOMINATION_KEY_LOST";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_UNBLIND_FAILURE"] = 1159] = "EXCHANGE_WITHDRAW_UNBLIND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_NONCE_REUSE"] = 1160] = "EXCHANGE_WITHDRAW_NONCE_REUSE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_COMMITMENT_UNKNOWN"] = 1161] = "EXCHANGE_WITHDRAW_COMMITMENT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_AMOUNT_OVERFLOW"] = 1162] = "EXCHANGE_WITHDRAW_AMOUNT_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AGE_WITHDRAW_AMOUNT_INCORRECT"] = 1163] = "EXCHANGE_AGE_WITHDRAW_AMOUNT_INCORRECT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_REVEAL_INVALID_HASH"] = 1164] = "EXCHANGE_WITHDRAW_REVEAL_INVALID_HASH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_MAXIMUM_AGE_TOO_LARGE"] = 1165] = "EXCHANGE_WITHDRAW_MAXIMUM_AGE_TOO_LARGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WITHDRAW_IDEMPOTENT_PLANCHET"] = 1175] = "EXCHANGE_WITHDRAW_IDEMPOTENT_PLANCHET";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_COIN_SIGNATURE_INVALID"] = 1205] = "EXCHANGE_DEPOSIT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_CONFLICTING_CONTRACT"] = 1206] = "EXCHANGE_DEPOSIT_CONFLICTING_CONTRACT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_NEGATIVE_VALUE_AFTER_FEE"] = 1207] = "EXCHANGE_DEPOSIT_NEGATIVE_VALUE_AFTER_FEE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_REFUND_DEADLINE_AFTER_WIRE_DEADLINE"] = 1208] = "EXCHANGE_DEPOSIT_REFUND_DEADLINE_AFTER_WIRE_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_WIRE_DEADLINE_IS_NEVER"] = 1209] = "EXCHANGE_DEPOSIT_WIRE_DEADLINE_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_JSON"] = 1210] = "EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_JSON";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_CONTRACT_HASH_CONFLICT"] = 1211] = "EXCHANGE_DEPOSIT_INVALID_WIRE_FORMAT_CONTRACT_HASH_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_INVALID_SIGNATURE_BY_EXCHANGE"] = 1221] = "EXCHANGE_DEPOSIT_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DEPOSIT_FEE_ABOVE_AMOUNT"] = 1222] = "EXCHANGE_DEPOSIT_FEE_ABOVE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_EXTENSIONS_INVALID_FULFILLMENT"] = 1240] = "EXCHANGE_EXTENSIONS_INVALID_FULFILLMENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_COIN_HISTORY_BAD_SIGNATURE"] = 1251] = "EXCHANGE_COIN_HISTORY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVE_HISTORY_BAD_SIGNATURE"] = 1252] = "EXCHANGE_RESERVE_HISTORY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_FEES_EXCEED_CONTRIBUTION"] = 1302] = "EXCHANGE_MELT_FEES_EXCEED_CONTRIBUTION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_COIN_SIGNATURE_INVALID"] = 1303] = "EXCHANGE_MELT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_COIN_EXPIRED_NO_ZOMBIE"] = 1305] = "EXCHANGE_MELT_COIN_EXPIRED_NO_ZOMBIE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MELT_INVALID_SIGNATURE_BY_EXCHANGE"] = 1306] = "EXCHANGE_MELT_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_COMMITMENT_VIOLATION"] = 1353] = "EXCHANGE_REFRESHES_REVEAL_COMMITMENT_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_SIGNING_ERROR"] = 1354] = "EXCHANGE_REFRESHES_REVEAL_SIGNING_ERROR";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_SESSION_UNKNOWN"] = 1355] = "EXCHANGE_REFRESHES_REVEAL_SESSION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_CNC_TRANSFER_ARRAY_SIZE_INVALID"] = 1356] = "EXCHANGE_REFRESHES_REVEAL_CNC_TRANSFER_ARRAY_SIZE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_NEW_DENOMS_ARRAY_SIZE_MISMATCH"] = 1358] = "EXCHANGE_REFRESHES_REVEAL_NEW_DENOMS_ARRAY_SIZE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_COST_CALCULATION_OVERFLOW"] = 1359] = "EXCHANGE_REFRESHES_REVEAL_COST_CALCULATION_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AMOUNT_INSUFFICIENT"] = 1360] = "EXCHANGE_REFRESHES_REVEAL_AMOUNT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_LINK_SIGNATURE_INVALID"] = 1361] = "EXCHANGE_REFRESHES_REVEAL_LINK_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_INVALID_RCH"] = 1362] = "EXCHANGE_REFRESHES_REVEAL_INVALID_RCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_OPERATION_INVALID"] = 1363] = "EXCHANGE_REFRESHES_REVEAL_OPERATION_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_NOT_SUPPORTED"] = 1364] = "EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_COMMITMENT_INVALID"] = 1365] = "EXCHANGE_REFRESHES_REVEAL_AGE_RESTRICTION_COMMITMENT_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_LINK_COIN_UNKNOWN"] = 1400] = "EXCHANGE_LINK_COIN_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WTID_MALFORMED"] = 1450] = "EXCHANGE_TRANSFERS_GET_WTID_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WTID_NOT_FOUND"] = 1451] = "EXCHANGE_TRANSFERS_GET_WTID_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WIRE_FEE_NOT_FOUND"] = 1452] = "EXCHANGE_TRANSFERS_GET_WIRE_FEE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TRANSFERS_GET_WIRE_FEE_INCONSISTENT"] = 1453] = "EXCHANGE_TRANSFERS_GET_WIRE_FEE_INCONSISTENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSES_INVALID_WAIT_TARGET"] = 1475] = "EXCHANGE_PURSES_INVALID_WAIT_TARGET";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSES_GET_INVALID_SIGNATURE_BY_EXCHANGE"] = 1476] = "EXCHANGE_PURSES_GET_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_COIN_NOT_FOUND"] = 1500] = "EXCHANGE_REFUND_COIN_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_CONFLICT_DEPOSIT_INSUFFICIENT"] = 1501] = "EXCHANGE_REFUND_CONFLICT_DEPOSIT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_DEPOSIT_NOT_FOUND"] = 1502] = "EXCHANGE_REFUND_DEPOSIT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_ALREADY_PAID"] = 1503] = "EXCHANGE_REFUND_MERCHANT_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_FEE_TOO_LOW"] = 1504] = "EXCHANGE_REFUND_FEE_TOO_LOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_FEE_ABOVE_AMOUNT"] = 1505] = "EXCHANGE_REFUND_FEE_ABOVE_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_SIGNATURE_INVALID"] = 1506] = "EXCHANGE_REFUND_MERCHANT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_MERCHANT_SIGNING_FAILED"] = 1507] = "EXCHANGE_REFUND_MERCHANT_SIGNING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INVALID_SIGNATURE_BY_EXCHANGE"] = 1508] = "EXCHANGE_REFUND_INVALID_SIGNATURE_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INVALID_FAILURE_PROOF_BY_EXCHANGE"] = 1509] = "EXCHANGE_REFUND_INVALID_FAILURE_PROOF_BY_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_REFUND_INCONSISTENT_AMOUNT"] = 1510] = "EXCHANGE_REFUND_INCONSISTENT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_SIGNATURE_INVALID"] = 1550] = "EXCHANGE_RECOUP_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_WITHDRAW_NOT_FOUND"] = 1551] = "EXCHANGE_RECOUP_WITHDRAW_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_COIN_BALANCE_ZERO"] = 1552] = "EXCHANGE_RECOUP_COIN_BALANCE_ZERO";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_BLINDING_FAILED"] = 1553] = "EXCHANGE_RECOUP_BLINDING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_COIN_BALANCE_NEGATIVE"] = 1554] = "EXCHANGE_RECOUP_COIN_BALANCE_NEGATIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_NOT_ELIGIBLE"] = 1555] = "EXCHANGE_RECOUP_NOT_ELIGIBLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_SIGNATURE_INVALID"] = 1575] = "EXCHANGE_RECOUP_REFRESH_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_MELT_NOT_FOUND"] = 1576] = "EXCHANGE_RECOUP_REFRESH_MELT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_BLINDING_FAILED"] = 1578] = "EXCHANGE_RECOUP_REFRESH_BLINDING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RECOUP_REFRESH_NOT_ELIGIBLE"] = 1580] = "EXCHANGE_RECOUP_REFRESH_NOT_ELIGIBLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KEYS_TIMETRAVEL_FORBIDDEN"] = 1600] = "EXCHANGE_KEYS_TIMETRAVEL_FORBIDDEN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_SIGNATURE_INVALID"] = 1650] = "EXCHANGE_WIRE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_NO_ACCOUNTS_CONFIGURED"] = 1651] = "EXCHANGE_WIRE_NO_ACCOUNTS_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_INVALID_PAYTO_CONFIGURED"] = 1652] = "EXCHANGE_WIRE_INVALID_PAYTO_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_WIRE_FEES_NOT_CONFIGURED"] = 1653] = "EXCHANGE_WIRE_FEES_NOT_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_CREATE_CONFLICTING_META_DATA"] = 1675] = "EXCHANGE_RESERVES_PURSE_CREATE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_MERGE_CONFLICTING_META_DATA"] = 1676] = "EXCHANGE_RESERVES_PURSE_MERGE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_CREATE_INSUFFICIENT_FUNDS"] = 1677] = "EXCHANGE_RESERVES_PURSE_CREATE_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_FEE_TOO_LOW"] = 1678] = "EXCHANGE_RESERVES_PURSE_FEE_TOO_LOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DELETE_ALREADY_DECIDED"] = 1679] = "EXCHANGE_PURSE_DELETE_ALREADY_DECIDED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DELETE_SIGNATURE_INVALID"] = 1680] = "EXCHANGE_PURSE_DELETE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_AGE_RESTRICTION_REQUIRED"] = 1681] = "EXCHANGE_RESERVES_AGE_RESTRICTION_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_UNAVAILABLE"] = 1700] = "EXCHANGE_DENOMINATION_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_BUG"] = 1701] = "EXCHANGE_DENOMINATION_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_DENOMINATION_HELPER_TOO_EARLY"] = 1702] = "EXCHANGE_DENOMINATION_HELPER_TOO_EARLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_EXCHANGE_SIGNATURE_INVALID"] = 1725] = "EXCHANGE_PURSE_DEPOSIT_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_UNAVAILABLE"] = 1750] = "EXCHANGE_SIGNKEY_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_BUG"] = 1751] = "EXCHANGE_SIGNKEY_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_SIGNKEY_HELPER_TOO_EARLY"] = 1752] = "EXCHANGE_SIGNKEY_HELPER_TOO_EARLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_EXPIRATION_BEFORE_NOW"] = 1775] = "EXCHANGE_RESERVES_PURSE_EXPIRATION_BEFORE_NOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_EXPIRATION_IS_NEVER"] = 1776] = "EXCHANGE_RESERVES_PURSE_EXPIRATION_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_PURSE_MERGE_SIGNATURE_INVALID"] = 1777] = "EXCHANGE_RESERVES_PURSE_MERGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_RESERVE_MERGE_SIGNATURE_INVALID"] = 1778] = "EXCHANGE_RESERVES_RESERVE_MERGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_OPEN_BAD_SIGNATURE"] = 1785] = "EXCHANGE_RESERVES_OPEN_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_CLOSE_BAD_SIGNATURE"] = 1786] = "EXCHANGE_RESERVES_CLOSE_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_ATTEST_BAD_SIGNATURE"] = 1787] = "EXCHANGE_RESERVES_ATTEST_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_CLOSE_NO_TARGET_ACCOUNT"] = 1788] = "EXCHANGE_RESERVES_CLOSE_NO_TARGET_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_RESERVES_OPEN_INSUFFICIENT_FUNDS"] = 1789] = "EXCHANGE_RESERVES_OPEN_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_NOT_FOUND"] = 1800] = "EXCHANGE_MANAGEMENT_AUDITOR_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_MORE_RECENT_PRESENT"] = 1801] = "EXCHANGE_MANAGEMENT_AUDITOR_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_ADD_SIGNATURE_INVALID"] = 1802] = "EXCHANGE_MANAGEMENT_AUDITOR_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AUDITOR_DEL_SIGNATURE_INVALID"] = 1803] = "EXCHANGE_MANAGEMENT_AUDITOR_DEL_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_DENOMINATION_REVOKE_SIGNATURE_INVALID"] = 1804] = "EXCHANGE_MANAGEMENT_DENOMINATION_REVOKE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_SIGNKEY_REVOKE_SIGNATURE_INVALID"] = 1805] = "EXCHANGE_MANAGEMENT_SIGNKEY_REVOKE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_MORE_RECENT_PRESENT"] = 1806] = "EXCHANGE_MANAGEMENT_WIRE_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_UNKNOWN"] = 1807] = "EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_DETAILS_SIGNATURE_INVALID"] = 1808] = "EXCHANGE_MANAGEMENT_WIRE_DETAILS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_ADD_SIGNATURE_INVALID"] = 1809] = "EXCHANGE_MANAGEMENT_WIRE_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_DEL_SIGNATURE_INVALID"] = 1810] = "EXCHANGE_MANAGEMENT_WIRE_DEL_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_NOT_FOUND"] = 1811] = "EXCHANGE_MANAGEMENT_WIRE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_FEE_SIGNATURE_INVALID"] = 1812] = "EXCHANGE_MANAGEMENT_WIRE_FEE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_WIRE_FEE_MISMATCH"] = 1813] = "EXCHANGE_MANAGEMENT_WIRE_FEE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_DENOMKEY_ADD_SIGNATURE_INVALID"] = 1814] = "EXCHANGE_MANAGEMENT_KEYS_DENOMKEY_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_ADD_SIGNATURE_INVALID"] = 1815] = "EXCHANGE_MANAGEMENT_KEYS_SIGNKEY_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_GLOBAL_FEE_MISMATCH"] = 1816] = "EXCHANGE_MANAGEMENT_GLOBAL_FEE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_GLOBAL_FEE_SIGNATURE_INVALID"] = 1817] = "EXCHANGE_MANAGEMENT_GLOBAL_FEE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_DRAIN_PROFITS_SIGNATURE_INVALID"] = 1818] = "EXCHANGE_MANAGEMENT_DRAIN_PROFITS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_ADD_SIGNATURE_INVALID"] = 1825] = "EXCHANGE_AML_DECISION_ADD_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_INVALID_OFFICER"] = 1826] = "EXCHANGE_AML_DECISION_INVALID_OFFICER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_MORE_RECENT_PRESENT"] = 1827] = "EXCHANGE_AML_DECISION_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AML_DECISION_UNKNOWN_CHECK"] = 1828] = "EXCHANGE_AML_DECISION_UNKNOWN_CHECK";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_UPDATE_AML_OFFICER_SIGNATURE_INVALID"] = 1830] = "EXCHANGE_MANAGEMENT_UPDATE_AML_OFFICER_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_AML_OFFICERS_MORE_RECENT_PRESENT"] = 1831] = "EXCHANGE_MANAGEMENT_AML_OFFICERS_MORE_RECENT_PRESENT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_CONFLICTING_DENOMINATION_META_DATA"] = 1832] = "EXCHANGE_MANAGEMENT_CONFLICTING_DENOMINATION_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_CONFLICTING_SIGNKEY_META_DATA"] = 1833] = "EXCHANGE_MANAGEMENT_CONFLICTING_SIGNKEY_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA"] = 1850] = "EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_CONFLICTING_CONTRACT_STORED"] = 1851] = "EXCHANGE_PURSE_CREATE_CONFLICTING_CONTRACT_STORED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_COIN_SIGNATURE_INVALID"] = 1852] = "EXCHANGE_PURSE_CREATE_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXPIRATION_BEFORE_NOW"] = 1853] = "EXCHANGE_PURSE_CREATE_EXPIRATION_BEFORE_NOW";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXPIRATION_IS_NEVER"] = 1854] = "EXCHANGE_PURSE_CREATE_EXPIRATION_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_SIGNATURE_INVALID"] = 1855] = "EXCHANGE_PURSE_CREATE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_ECONTRACT_SIGNATURE_INVALID"] = 1856] = "EXCHANGE_PURSE_ECONTRACT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_CREATE_EXCHANGE_SIGNATURE_INVALID"] = 1857] = "EXCHANGE_PURSE_CREATE_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA"] = 1858] = "EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA"] = 1859] = "EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CREATE_PURSE_NEGATIVE_VALUE_AFTER_FEE"] = 1860] = "EXCHANGE_CREATE_PURSE_NEGATIVE_VALUE_AFTER_FEE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_INVALID_MERGE_SIGNATURE"] = 1876] = "EXCHANGE_PURSE_MERGE_INVALID_MERGE_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_INVALID_RESERVE_SIGNATURE"] = 1877] = "EXCHANGE_PURSE_MERGE_INVALID_RESERVE_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_NOT_FULL"] = 1878] = "EXCHANGE_PURSE_NOT_FULL";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_MERGE_EXCHANGE_SIGNATURE_INVALID"] = 1879] = "EXCHANGE_PURSE_MERGE_EXCHANGE_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MERGE_PURSE_PARTNER_UNKNOWN"] = 1880] = "EXCHANGE_MERGE_PURSE_PARTNER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_ADD_PARTNER_SIGNATURE_INVALID"] = 1890] = "EXCHANGE_MANAGEMENT_ADD_PARTNER_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_MANAGEMENT_ADD_PARTNER_DATA_CONFLICT"] = 1891] = "EXCHANGE_MANAGEMENT_ADD_PARTNER_DATA_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_SIGNATURE_INVALID"] = 1900] = "EXCHANGE_AUDITORS_AUDITOR_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_UNKNOWN"] = 1901] = "EXCHANGE_AUDITORS_AUDITOR_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_AUDITORS_AUDITOR_INACTIVE"] = 1902] = "EXCHANGE_AUDITORS_AUDITOR_INACTIVE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_AML_PROGRAM_TIMEOUT"] = 1918] = "EXCHANGE_KYC_GENERIC_AML_PROGRAM_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_INFO_AUTHORIZATION_FAILED"] = 1919] = "EXCHANGE_KYC_INFO_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_RECURSIVE_RULE_DETECTED"] = 1920] = "EXCHANGE_KYC_RECURSIVE_RULE_DETECTED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_AML_FORM_INCOMPLETE"] = 1921] = "EXCHANGE_KYC_AML_FORM_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_AML_PROGRAM_GONE"] = 1922] = "EXCHANGE_KYC_GENERIC_AML_PROGRAM_GONE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_NOT_A_FORM"] = 1923] = "EXCHANGE_KYC_NOT_A_FORM";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_CHECK_GONE"] = 1924] = "EXCHANGE_KYC_GENERIC_CHECK_GONE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_WALLET_SIGNATURE_INVALID"] = 1925] = "EXCHANGE_KYC_WALLET_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_INVALID_RESPONSE"] = 1926] = "EXCHANGE_KYC_PROOF_BACKEND_INVALID_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_ERROR"] = 1927] = "EXCHANGE_KYC_PROOF_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_BACKEND_AUTHORIZATION_FAILED"] = 1928] = "EXCHANGE_KYC_PROOF_BACKEND_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_PROOF_REQUEST_UNKNOWN"] = 1929] = "EXCHANGE_KYC_PROOF_REQUEST_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_CHECK_AUTHORIZATION_FAILED"] = 1930] = "EXCHANGE_KYC_CHECK_AUTHORIZATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_UNKNOWN"] = 1931] = "EXCHANGE_KYC_GENERIC_LOGIC_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_GONE"] = 1932] = "EXCHANGE_KYC_GENERIC_LOGIC_GONE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_LOGIC_BUG"] = 1933] = "EXCHANGE_KYC_GENERIC_LOGIC_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_ACCESS_REFUSED"] = 1934] = "EXCHANGE_KYC_GENERIC_PROVIDER_ACCESS_REFUSED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_TIMEOUT"] = 1935] = "EXCHANGE_KYC_GENERIC_PROVIDER_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_UNEXPECTED_REPLY"] = 1936] = "EXCHANGE_KYC_GENERIC_PROVIDER_UNEXPECTED_REPLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_RATE_LIMIT_EXCEEDED"] = 1937] = "EXCHANGE_KYC_GENERIC_PROVIDER_RATE_LIMIT_EXCEEDED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_WEBHOOK_UNAUTHORIZED"] = 1938] = "EXCHANGE_KYC_WEBHOOK_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_CHECK_REQUEST_UNKNOWN"] = 1939] = "EXCHANGE_KYC_CHECK_REQUEST_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_CHECK_AUTHORIZATION_KEY_UNKNOWN"] = 1940] = "EXCHANGE_KYC_CHECK_AUTHORIZATION_KEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_FORM_ALREADY_UPLOADED"] = 1941] = "EXCHANGE_KYC_FORM_ALREADY_UPLOADED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_MEASURES_MALFORMED"] = 1942] = "EXCHANGE_KYC_MEASURES_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_MEASURE_INDEX_INVALID"] = 1943] = "EXCHANGE_KYC_MEASURE_INDEX_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_INVALID_LOGIC_TO_CHECK"] = 1944] = "EXCHANGE_KYC_INVALID_LOGIC_TO_CHECK";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_AML_PROGRAM_FAILURE"] = 1945] = "EXCHANGE_KYC_AML_PROGRAM_FAILURE";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_AML_PROGRAM_MALFORMED_RESULT"] = 1946] = "EXCHANGE_KYC_AML_PROGRAM_MALFORMED_RESULT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_REPLY"] = 1947] = "EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_REPLY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_CONTEXT"] = 1948] = "EXCHANGE_KYC_GENERIC_PROVIDER_INCOMPLETE_CONTEXT";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_GENERIC_AML_LOGIC_BUG"] = 1949] = "EXCHANGE_KYC_GENERIC_AML_LOGIC_BUG";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_UNKNOWN"] = 1950] = "EXCHANGE_CONTRACTS_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_INVALID_CONTRACT_PUB"] = 1951] = "EXCHANGE_CONTRACTS_INVALID_CONTRACT_PUB";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_DECRYPTION_FAILED"] = 1952] = "EXCHANGE_CONTRACTS_DECRYPTION_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_SIGNATURE_INVALID"] = 1953] = "EXCHANGE_CONTRACTS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_CONTRACTS_DECODING_FAILED"] = 1954] = "EXCHANGE_CONTRACTS_DECODING_FAILED";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_COIN_SIGNATURE_INVALID"] = 1975] = "EXCHANGE_PURSE_DEPOSIT_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_PURSE_DEPOSIT_DECIDED_ALREADY"] = 1976] = "EXCHANGE_PURSE_DEPOSIT_DECIDED_ALREADY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_KYC_INFO_BUSY"] = 1977] = "EXCHANGE_KYC_INFO_BUSY";
  TalerErrorCode2[TalerErrorCode2["EXCHANGE_TOTP_KEY_INVALID"] = 1980] = "EXCHANGE_TOTP_KEY_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_INSTANCE_UNKNOWN"] = 2e3] = "MERCHANT_GENERIC_INSTANCE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_HOLE_IN_WIRE_FEE_STRUCTURE"] = 2001] = "MERCHANT_GENERIC_HOLE_IN_WIRE_FEE_STRUCTURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_WIRE_REQUEST_FAILED"] = 2002] = "MERCHANT_GENERIC_EXCHANGE_WIRE_REQUEST_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CATEGORY_UNKNOWN"] = 2003] = "MERCHANT_GENERIC_CATEGORY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_ORDER_UNKNOWN"] = 2005] = "MERCHANT_GENERIC_ORDER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_PRODUCT_UNKNOWN"] = 2006] = "MERCHANT_GENERIC_PRODUCT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_REWARD_ID_UNKNOWN"] = 2007] = "MERCHANT_GENERIC_REWARD_ID_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_DB_CONTRACT_CONTENT_INVALID"] = 2008] = "MERCHANT_GENERIC_DB_CONTRACT_CONTENT_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CONTRACT_HASH_DOES_NOT_MATCH_ORDER"] = 2009] = "MERCHANT_GENERIC_CONTRACT_HASH_DOES_NOT_MATCH_ORDER";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_KEYS_FAILURE"] = 2010] = "MERCHANT_GENERIC_EXCHANGE_KEYS_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_TIMEOUT"] = 2011] = "MERCHANT_GENERIC_EXCHANGE_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_CONNECT_FAILURE"] = 2012] = "MERCHANT_GENERIC_EXCHANGE_CONNECT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_REPLY_MALFORMED"] = 2013] = "MERCHANT_GENERIC_EXCHANGE_REPLY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_UNEXPECTED_STATUS"] = 2014] = "MERCHANT_GENERIC_EXCHANGE_UNEXPECTED_STATUS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_UNAUTHORIZED"] = 2015] = "MERCHANT_GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_INSTANCE_DELETED"] = 2016] = "MERCHANT_GENERIC_INSTANCE_DELETED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TRANSFER_UNKNOWN"] = 2017] = "MERCHANT_GENERIC_TRANSFER_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TEMPLATE_UNKNOWN"] = 2018] = "MERCHANT_GENERIC_TEMPLATE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_WEBHOOK_UNKNOWN"] = 2019] = "MERCHANT_GENERIC_WEBHOOK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_PENDING_WEBHOOK_UNKNOWN"] = 2020] = "MERCHANT_GENERIC_PENDING_WEBHOOK_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_OTP_DEVICE_UNKNOWN"] = 2021] = "MERCHANT_GENERIC_OTP_DEVICE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_ACCOUNT_UNKNOWN"] = 2022] = "MERCHANT_GENERIC_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_H_WIRE_MALFORMED"] = 2023] = "MERCHANT_GENERIC_H_WIRE_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_CURRENCY_MISMATCH"] = 2024] = "MERCHANT_GENERIC_CURRENCY_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_EXCHANGE_UNTRUSTED"] = 2025] = "MERCHANT_GENERIC_EXCHANGE_UNTRUSTED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TOKEN_FAMILY_UNKNOWN"] = 2026] = "MERCHANT_GENERIC_TOKEN_FAMILY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_TOKEN_KEY_UNKNOWN"] = 2027] = "MERCHANT_GENERIC_TOKEN_KEY_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GENERIC_DONAU_NOT_CONFIGURED"] = 2028] = "MERCHANT_GENERIC_DONAU_NOT_CONFIGURED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_EXCHANGE_TRACKING_FAILURE"] = 2100] = "MERCHANT_GET_ORDERS_EXCHANGE_TRACKING_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_EXCHANGE_REQUEST_FAILURE"] = 2103] = "MERCHANT_GET_ORDERS_ID_EXCHANGE_REQUEST_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_EXCHANGE_LOOKUP_START_FAILURE"] = 2104] = "MERCHANT_GET_ORDERS_ID_EXCHANGE_LOOKUP_START_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_TOKEN"] = 2105] = "MERCHANT_GET_ORDERS_ID_INVALID_TOKEN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_HASH"] = 2106] = "MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_HASH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_VERSION"] = 2107] = "MERCHANT_GET_ORDERS_ID_INVALID_CONTRACT_VERSION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_FUNDS"] = 2150] = "MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_NOT_FOUND"] = 2151] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_AUDITOR_FAILURE"] = 2152] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_KEY_AUDITOR_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AMOUNT_OVERFLOW"] = 2153] = "MERCHANT_POST_ORDERS_ID_PAY_AMOUNT_OVERFLOW";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_FEES_EXCEED_PAYMENT"] = 2154] = "MERCHANT_POST_ORDERS_ID_PAY_FEES_EXCEED_PAYMENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_DUE_TO_FEES"] = 2155] = "MERCHANT_POST_ORDERS_ID_PAY_INSUFFICIENT_DUE_TO_FEES";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_PAYMENT_INSUFFICIENT"] = 2156] = "MERCHANT_POST_ORDERS_ID_PAY_PAYMENT_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_COIN_SIGNATURE_INVALID"] = 2157] = "MERCHANT_POST_ORDERS_ID_PAY_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_LOOKUP_FAILED"] = 2158] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUND_DEADLINE_PAST_WIRE_TRANSFER_DEADLINE"] = 2159] = "MERCHANT_POST_ORDERS_ID_PAY_REFUND_DEADLINE_PAST_WIRE_TRANSFER_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_ALREADY_PAID"] = 2160] = "MERCHANT_POST_ORDERS_ID_PAY_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_OFFER_EXPIRED"] = 2161] = "MERCHANT_POST_ORDERS_ID_PAY_OFFER_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_MERCHANT_FIELD_MISSING"] = 2162] = "MERCHANT_POST_ORDERS_ID_PAY_MERCHANT_FIELD_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_WIRE_HASH_UNKNOWN"] = 2163] = "MERCHANT_POST_ORDERS_ID_PAY_WIRE_HASH_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_DEPOSIT_EXPIRED"] = 2165] = "MERCHANT_POST_ORDERS_ID_PAY_DENOMINATION_DEPOSIT_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_WIRE_FEE_ADDITION_FAILED"] = 2166] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_WIRE_FEE_ADDITION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUNDED"] = 2167] = "MERCHANT_POST_ORDERS_ID_PAY_REFUNDED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_REFUNDS_EXCEED_PAYMENTS"] = 2168] = "MERCHANT_POST_ORDERS_ID_PAY_REFUNDS_EXCEED_PAYMENTS";
  TalerErrorCode2[TalerErrorCode2["DEAD_QQQ_PAY_MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE"] = 2169] = "DEAD_QQQ_PAY_MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_FAILED"] = 2170] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_MISSING"] = 2171] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_SIZE_MISMATCH"] = 2172] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_SIZE_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_VERIFICATION_FAILED"] = 2173] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_VERIFICATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_HASH_MISSING"] = 2174] = "MERCHANT_POST_ORDERS_ID_PAY_AGE_COMMITMENT_HASH_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_WIRE_METHOD_UNSUPPORTED"] = 2175] = "MERCHANT_POST_ORDERS_ID_PAY_WIRE_METHOD_UNSUPPORTED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_MISSING"] = 2176] = "MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_MISSING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_OUT_OF_BOUNDS"] = 2177] = "MERCHANT_POST_ORDERS_ID_PAY_CHOICE_INDEX_OUT_OF_BOUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_INPUT_TOKENS_MISMATCH"] = 2178] = "MERCHANT_POST_ORDERS_ID_PAY_INPUT_TOKENS_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ISSUE_SIG_INVALID"] = 2179] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ISSUE_SIG_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_USE_SIG_INVALID"] = 2180] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_USE_SIG_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_COUNT_MISMATCH"] = 2181] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_COUNT_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ENVELOPE_COUNT_MISMATCH"] = 2182] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_ENVELOPE_COUNT_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_TOKEN_INVALID"] = 2183] = "MERCHANT_POST_ORDERS_ID_PAY_TOKEN_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_TRANSACTION_LIMIT_VIOLATION"] = 2184] = "MERCHANT_POST_ORDERS_ID_PAY_EXCHANGE_TRANSACTION_LIMIT_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAID_CONTRACT_HASH_MISMATCH"] = 2200] = "MERCHANT_POST_ORDERS_ID_PAID_CONTRACT_HASH_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_PAID_COIN_SIGNATURE_INVALID"] = 2201] = "MERCHANT_POST_ORDERS_ID_PAID_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_TOKEN_FAMILY_CONFLICT"] = 2225] = "MERCHANT_POST_TOKEN_FAMILY_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PATCH_TOKEN_FAMILY_NOT_FOUND"] = 2226] = "MERCHANT_PATCH_TOKEN_FAMILY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_REFUND_FAILED"] = 2251] = "MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_REFUND_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_LOOKUP_FAILED"] = 2252] = "MERCHANT_POST_ORDERS_ID_ABORT_EXCHANGE_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_NOT_FOUND"] = 2253] = "MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE"] = 2254] = "MERCHANT_POST_ORDERS_ID_ABORT_REFUND_REFUSED_PAYMENT_COMPLETE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_HASH_MISSMATCH"] = 2255] = "MERCHANT_POST_ORDERS_ID_ABORT_CONTRACT_HASH_MISSMATCH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_ABORT_COINS_ARRAY_EMPTY"] = 2256] = "MERCHANT_POST_ORDERS_ID_ABORT_COINS_ARRAY_EMPTY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_AWAITING_KEYS"] = 2258] = "MERCHANT_EXCHANGE_TRANSFERS_AWAITING_KEYS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_AWAITING_LIST"] = 2259] = "MERCHANT_EXCHANGE_TRANSFERS_AWAITING_LIST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_FATAL_NO_EXCHANGE"] = 2260] = "MERCHANT_EXCHANGE_TRANSFERS_FATAL_NO_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_FATAL_NOT_FOUND"] = 2261] = "MERCHANT_EXCHANGE_TRANSFERS_FATAL_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_RATE_LIMITED"] = 2262] = "MERCHANT_EXCHANGE_TRANSFERS_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_TRANSIENT_FAILURE"] = 2263] = "MERCHANT_EXCHANGE_TRANSFERS_TRANSIENT_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_HARD_FAILURE"] = 2264] = "MERCHANT_EXCHANGE_TRANSFERS_HARD_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_NOT_FOUND"] = 2300] = "MERCHANT_POST_ORDERS_ID_CLAIM_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_ALREADY_CLAIMED"] = 2301] = "MERCHANT_POST_ORDERS_ID_CLAIM_ALREADY_CLAIMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_CLAIM_CLIENT_INTERNAL_FAILURE"] = 2302] = "MERCHANT_POST_ORDERS_ID_CLAIM_CLIENT_INTERNAL_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_REFUND_SIGNATURE_FAILED"] = 2350] = "MERCHANT_POST_ORDERS_ID_REFUND_SIGNATURE_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_UNBLIND_FAILURE"] = 2400] = "MERCHANT_REWARD_PICKUP_UNBLIND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_EXCHANGE_ERROR"] = 2403] = "MERCHANT_REWARD_PICKUP_EXCHANGE_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_SUMMATION_FAILED"] = 2404] = "MERCHANT_REWARD_PICKUP_SUMMATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_HAS_EXPIRED"] = 2405] = "MERCHANT_REWARD_PICKUP_HAS_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_AMOUNT_EXCEEDS_REWARD_REMAINING"] = 2406] = "MERCHANT_REWARD_PICKUP_AMOUNT_EXCEEDS_REWARD_REMAINING";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_REWARD_PICKUP_DENOMINATION_UNKNOWN"] = 2407] = "MERCHANT_REWARD_PICKUP_DENOMINATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_INSTANCE_CONFIGURATION_LACKS_WIRE"] = 2500] = "MERCHANT_PRIVATE_POST_ORDERS_INSTANCE_CONFIGURATION_LACKS_WIRE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_LOCALTIME"] = 2501] = "MERCHANT_PRIVATE_POST_ORDERS_NO_LOCALTIME";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_PROPOSAL_PARSE_ERROR"] = 2502] = "MERCHANT_PRIVATE_POST_ORDERS_PROPOSAL_PARSE_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ALREADY_EXISTS"] = 2503] = "MERCHANT_PRIVATE_POST_ORDERS_ALREADY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_REFUND_AFTER_WIRE_DEADLINE"] = 2504] = "MERCHANT_PRIVATE_POST_ORDERS_REFUND_AFTER_WIRE_DEADLINE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_DELIVERY_DATE_IN_PAST"] = 2505] = "MERCHANT_PRIVATE_POST_ORDERS_DELIVERY_DATE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_WIRE_DEADLINE_IS_NEVER"] = 2506] = "MERCHANT_PRIVATE_POST_ORDERS_WIRE_DEADLINE_IS_NEVER";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_PAY_DEADLINE_IN_PAST"] = 2507] = "MERCHANT_PRIVATE_POST_ORDERS_PAY_DEADLINE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_REFUND_DEADLINE_IN_PAST"] = 2508] = "MERCHANT_PRIVATE_POST_ORDERS_REFUND_DEADLINE_IN_PAST";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGES_FOR_WIRE_METHOD"] = 2509] = "MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGES_FOR_WIRE_METHOD";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_SYNTAX_INCORRECT"] = 2510] = "MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_SYNTAX_INCORRECT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_NOT_FORGETTABLE"] = 2511] = "MERCHANT_PRIVATE_PATCH_ORDERS_ID_FORGET_PATH_NOT_FORGETTABLE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_ORDERS_ID_REFUND_EXCHANGE_TRANSACTION_LIMIT_VIOLATION"] = 2512] = "MERCHANT_POST_ORDERS_ID_REFUND_EXCHANGE_TRANSACTION_LIMIT_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_AMOUNT_EXCEEDS_LEGAL_LIMITS"] = 2513] = "MERCHANT_PRIVATE_POST_ORDERS_AMOUNT_EXCEEDS_LEGAL_LIMITS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGE_FOR_CURRENCY"] = 2514] = "MERCHANT_PRIVATE_POST_ORDERS_NO_EXCHANGE_FOR_CURRENCY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_ORDERS_AWAITING_PAYMENT"] = 2520] = "MERCHANT_PRIVATE_DELETE_ORDERS_AWAITING_PAYMENT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_ORDERS_ALREADY_PAID"] = 2521] = "MERCHANT_PRIVATE_DELETE_ORDERS_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_INCONSISTENT_AMOUNT"] = 2530] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_INCONSISTENT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_ORDER_UNPAID"] = 2531] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_ORDER_UNPAID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_NOT_ALLOWED_BY_CONTRACT"] = 2532] = "MERCHANT_PRIVATE_POST_ORDERS_ID_REFUND_NOT_ALLOWED_BY_CONTRACT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_SLUG_UNKNOWN"] = 2533] = "MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_SLUG_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_NOT_VALID"] = 2534] = "MERCHANT_PRIVATE_POST_ORDERS_TOKEN_FAMILY_NOT_VALID";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_EXCHANGE_UNKNOWN"] = 2550] = "MERCHANT_PRIVATE_POST_TRANSFERS_EXCHANGE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_REQUEST_ERROR"] = 2551] = "MERCHANT_PRIVATE_POST_TRANSFERS_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_TRANSFERS"] = 2552] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_TRANSFERS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_REPORTS"] = 2553] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_REPORTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_BAD_WIRE_FEE"] = 2554] = "MERCHANT_PRIVATE_POST_TRANSFERS_BAD_WIRE_FEE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_ACCOUNT_NOT_FOUND"] = 2555] = "MERCHANT_PRIVATE_POST_TRANSFERS_ACCOUNT_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_TRANSFERS_ALREADY_CONFIRMED"] = 2556] = "MERCHANT_PRIVATE_DELETE_TRANSFERS_ALREADY_CONFIRMED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_SUBMISSION"] = 2557] = "MERCHANT_PRIVATE_POST_TRANSFERS_CONFLICTING_SUBMISSION";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_EXCHANGE_TRANSFERS_CONFLICTING_TRANSFERS"] = 2563] = "MERCHANT_EXCHANGE_TRANSFERS_CONFLICTING_TRANSFERS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_ALREADY_EXISTS"] = 2600] = "MERCHANT_PRIVATE_POST_INSTANCES_ALREADY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_BAD_AUTH"] = 2601] = "MERCHANT_PRIVATE_POST_INSTANCES_BAD_AUTH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCE_AUTH_BAD_AUTH"] = 2602] = "MERCHANT_PRIVATE_POST_INSTANCE_AUTH_BAD_AUTH";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_INSTANCES_PURGE_REQUIRED"] = 2603] = "MERCHANT_PRIVATE_POST_INSTANCES_PURGE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_INSTANCES_PURGE_REQUIRED"] = 2625] = "MERCHANT_PRIVATE_PATCH_INSTANCES_PURGE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_ACCOUNT_DELETE_UNKNOWN_ACCOUNT"] = 2626] = "MERCHANT_PRIVATE_ACCOUNT_DELETE_UNKNOWN_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_ACCOUNT_EXISTS"] = 2627] = "MERCHANT_PRIVATE_ACCOUNT_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PRODUCTS_CONFLICT_PRODUCT_EXISTS"] = 2650] = "MERCHANT_PRIVATE_POST_PRODUCTS_CONFLICT_PRODUCT_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_CATEGORIES_CONFLICT_CATEGORY_EXISTS"] = 2651] = "MERCHANT_PRIVATE_POST_CATEGORIES_CONFLICT_CATEGORY_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_REDUCED"] = 2660] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_EXCEEDS_STOCKS"] = 2661] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_LOST_EXCEEDS_STOCKS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_STOCKED_REDUCED"] = 2662] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_STOCKED_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_SOLD_REDUCED"] = 2663] = "MERCHANT_PRIVATE_PATCH_PRODUCTS_TOTAL_SOLD_REDUCED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PRODUCTS_LOCK_INSUFFICIENT_STOCKS"] = 2670] = "MERCHANT_PRIVATE_POST_PRODUCTS_LOCK_INSUFFICIENT_STOCKS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_PRODUCTS_CONFLICTING_LOCK"] = 2680] = "MERCHANT_PRIVATE_DELETE_PRODUCTS_CONFLICTING_LOCK";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_RESERVES_UNSUPPORTED_WIRE_METHOD"] = 2700] = "MERCHANT_PRIVATE_POST_RESERVES_UNSUPPORTED_WIRE_METHOD";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_RESERVES_REWARDS_NOT_ALLOWED"] = 2701] = "MERCHANT_PRIVATE_POST_RESERVES_REWARDS_NOT_ALLOWED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_DELETE_RESERVES_NO_SUCH_RESERVE"] = 2710] = "MERCHANT_PRIVATE_DELETE_RESERVES_NO_SUCH_RESERVE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_EXPIRED"] = 2750] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_UNKNOWN"] = 2751] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_INSUFFICIENT_FUNDS"] = 2752] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_INSUFFICIENT_FUNDS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_NOT_FOUND"] = 2753] = "MERCHANT_PRIVATE_POST_REWARD_AUTHORIZE_RESERVE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_GET_ORDERS_ID_AMOUNT_ARITHMETIC_FAILURE"] = 2800] = "MERCHANT_PRIVATE_GET_ORDERS_ID_AMOUNT_ARITHMETIC_FAILURE";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_TEMPLATES_CONFLICT_TEMPLATE_EXISTS"] = 2850] = "MERCHANT_PRIVATE_POST_TEMPLATES_CONFLICT_TEMPLATE_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_OTP_DEVICES_CONFLICT_OTP_DEVICE_EXISTS"] = 2851] = "MERCHANT_PRIVATE_POST_OTP_DEVICES_CONFLICT_OTP_DEVICE_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_AMOUNT_CONFLICT_TEMPLATES_CONTRACT_AMOUNT"] = 2860] = "MERCHANT_POST_USING_TEMPLATES_AMOUNT_CONFLICT_TEMPLATES_CONTRACT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_SUMMARY_CONFLICT_TEMPLATES_CONTRACT_SUBJECT"] = 2861] = "MERCHANT_POST_USING_TEMPLATES_SUMMARY_CONFLICT_TEMPLATES_CONTRACT_SUBJECT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_NO_AMOUNT"] = 2862] = "MERCHANT_POST_USING_TEMPLATES_NO_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_POST_USING_TEMPLATES_NO_SUMMARY"] = 2863] = "MERCHANT_POST_USING_TEMPLATES_NO_SUMMARY";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_WEBHOOKS_CONFLICT_WEBHOOK_EXISTS"] = 2900] = "MERCHANT_PRIVATE_POST_WEBHOOKS_CONFLICT_WEBHOOK_EXISTS";
  TalerErrorCode2[TalerErrorCode2["MERCHANT_PRIVATE_POST_PENDING_WEBHOOKS_CONFLICT_PENDING_WEBHOOK_EXISTS"] = 2910] = "MERCHANT_PRIVATE_POST_PENDING_WEBHOOKS_CONFLICT_PENDING_WEBHOOK_EXISTS";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_GENERIC_UNAUTHORIZED"] = 3001] = "AUDITOR_GENERIC_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_GENERIC_METHOD_NOT_ALLOWED"] = 3002] = "AUDITOR_GENERIC_METHOD_NOT_ALLOWED";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_DEPOSIT_CONFIRMATION_SIGNATURE_INVALID"] = 3100] = "AUDITOR_DEPOSIT_CONFIRMATION_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_EXCHANGE_SIGNING_KEY_REVOKED"] = 3101] = "AUDITOR_EXCHANGE_SIGNING_KEY_REVOKED";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_RESOURCE_NOT_FOUND"] = 3102] = "AUDITOR_RESOURCE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["AUDITOR_URI_MISSING_PATH_COMPONENT"] = 3103] = "AUDITOR_URI_MISSING_PATH_COMPONENT";
  TalerErrorCode2[TalerErrorCode2["BANK_SAME_ACCOUNT"] = 5101] = "BANK_SAME_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_UNALLOWED_DEBIT"] = 5102] = "BANK_UNALLOWED_DEBIT";
  TalerErrorCode2[TalerErrorCode2["BANK_NEGATIVE_NUMBER_AMOUNT"] = 5103] = "BANK_NEGATIVE_NUMBER_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_NUMBER_TOO_BIG"] = 5104] = "BANK_NUMBER_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_ACCOUNT"] = 5106] = "BANK_UNKNOWN_ACCOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSACTION_NOT_FOUND"] = 5107] = "BANK_TRANSACTION_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["BANK_BAD_FORMAT_AMOUNT"] = 5108] = "BANK_BAD_FORMAT_AMOUNT";
  TalerErrorCode2[TalerErrorCode2["BANK_REJECT_NO_RIGHTS"] = 5109] = "BANK_REJECT_NO_RIGHTS";
  TalerErrorCode2[TalerErrorCode2["BANK_UNMANAGED_EXCEPTION"] = 5110] = "BANK_UNMANAGED_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["BANK_SOFT_EXCEPTION"] = 5111] = "BANK_SOFT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSFER_REQUEST_UID_REUSED"] = 5112] = "BANK_TRANSFER_REQUEST_UID_REUSED";
  TalerErrorCode2[TalerErrorCode2["BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT"] = 5113] = "BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_DUPLICATE_RESERVE_PUB_SUBJECT"] = 5114] = "BANK_DUPLICATE_RESERVE_PUB_SUBJECT";
  TalerErrorCode2[TalerErrorCode2["BANK_ANCIENT_TRANSACTION_GONE"] = 5115] = "BANK_ANCIENT_TRANSACTION_GONE";
  TalerErrorCode2[TalerErrorCode2["BANK_ABORT_CONFIRM_CONFLICT"] = 5116] = "BANK_ABORT_CONFIRM_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_CONFIRM_ABORT_CONFLICT"] = 5117] = "BANK_CONFIRM_ABORT_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_CONFLICT"] = 5118] = "BANK_REGISTER_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_POST_WITHDRAWAL_OPERATION_REQUIRED"] = 5119] = "BANK_POST_WITHDRAWAL_OPERATION_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["BANK_RESERVED_USERNAME_CONFLICT"] = 5120] = "BANK_RESERVED_USERNAME_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_USERNAME_REUSE"] = 5121] = "BANK_REGISTER_USERNAME_REUSE";
  TalerErrorCode2[TalerErrorCode2["BANK_REGISTER_PAYTO_URI_REUSE"] = 5122] = "BANK_REGISTER_PAYTO_URI_REUSE";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_BALANCE_NOT_ZERO"] = 5123] = "BANK_ACCOUNT_BALANCE_NOT_ZERO";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_CREDITOR"] = 5124] = "BANK_UNKNOWN_CREDITOR";
  TalerErrorCode2[TalerErrorCode2["BANK_UNKNOWN_DEBTOR"] = 5125] = "BANK_UNKNOWN_DEBTOR";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_IS_EXCHANGE"] = 5126] = "BANK_ACCOUNT_IS_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_IS_NOT_EXCHANGE"] = 5127] = "BANK_ACCOUNT_IS_NOT_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_BAD_CONVERSION"] = 5128] = "BANK_BAD_CONVERSION";
  TalerErrorCode2[TalerErrorCode2["BANK_MISSING_TAN_INFO"] = 5129] = "BANK_MISSING_TAN_INFO";
  TalerErrorCode2[TalerErrorCode2["BANK_CONFIRM_INCOMPLETE"] = 5130] = "BANK_CONFIRM_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_RATE_LIMITED"] = 5131] = "BANK_TAN_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHANNEL_NOT_SUPPORTED"] = 5132] = "BANK_TAN_CHANNEL_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHANNEL_SCRIPT_FAILED"] = 5133] = "BANK_TAN_CHANNEL_SCRIPT_FAILED";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHALLENGE_FAILED"] = 5134] = "BANK_TAN_CHALLENGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_LEGAL_NAME"] = 5135] = "BANK_NON_ADMIN_PATCH_LEGAL_NAME";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_DEBT_LIMIT"] = 5136] = "BANK_NON_ADMIN_PATCH_DEBT_LIMIT";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_MISSING_OLD_PASSWORD"] = 5137] = "BANK_NON_ADMIN_PATCH_MISSING_OLD_PASSWORD";
  TalerErrorCode2[TalerErrorCode2["BANK_PATCH_BAD_OLD_PASSWORD"] = 5138] = "BANK_PATCH_BAD_OLD_PASSWORD";
  TalerErrorCode2[TalerErrorCode2["BANK_PATCH_ADMIN_EXCHANGE"] = 5139] = "BANK_PATCH_ADMIN_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_CASHOUT"] = 5140] = "BANK_NON_ADMIN_PATCH_CASHOUT";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_PATCH_CONTACT"] = 5141] = "BANK_NON_ADMIN_PATCH_CONTACT";
  TalerErrorCode2[TalerErrorCode2["BANK_ADMIN_CREDITOR"] = 5142] = "BANK_ADMIN_CREDITOR";
  TalerErrorCode2[TalerErrorCode2["BANK_CHALLENGE_NOT_FOUND"] = 5143] = "BANK_CHALLENGE_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["BANK_TAN_CHALLENGE_EXPIRED"] = 5144] = "BANK_TAN_CHALLENGE_EXPIRED";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_SET_TAN_CHANNEL"] = 5145] = "BANK_NON_ADMIN_SET_TAN_CHANNEL";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_SET_MIN_CASHOUT"] = 5146] = "BANK_NON_ADMIN_SET_MIN_CASHOUT";
  TalerErrorCode2[TalerErrorCode2["BANK_CONVERSION_AMOUNT_TO_SMALL"] = 5147] = "BANK_CONVERSION_AMOUNT_TO_SMALL";
  TalerErrorCode2[TalerErrorCode2["BANK_AMOUNT_DIFFERS"] = 5148] = "BANK_AMOUNT_DIFFERS";
  TalerErrorCode2[TalerErrorCode2["BANK_AMOUNT_REQUIRED"] = 5149] = "BANK_AMOUNT_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["BANK_PASSWORD_TOO_SHORT"] = 5150] = "BANK_PASSWORD_TOO_SHORT";
  TalerErrorCode2[TalerErrorCode2["BANK_PASSWORD_TOO_LONG"] = 5151] = "BANK_PASSWORD_TOO_LONG";
  TalerErrorCode2[TalerErrorCode2["BANK_ACCOUNT_LOCKED"] = 5152] = "BANK_ACCOUNT_LOCKED";
  TalerErrorCode2[TalerErrorCode2["BANK_UPDATE_ABORT_CONFLICT"] = 5153] = "BANK_UPDATE_ABORT_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["BANK_TRANSFER_WTID_REUSED"] = 5154] = "BANK_TRANSFER_WTID_REUSED";
  TalerErrorCode2[TalerErrorCode2["BANK_NON_ADMIN_SET_CONVERSION_RATE_CLASS"] = 5155] = "BANK_NON_ADMIN_SET_CONVERSION_RATE_CLASS";
  TalerErrorCode2[TalerErrorCode2["BANK_CONVERSION_RATE_CLASS_UNKNOWN"] = 5156] = "BANK_CONVERSION_RATE_CLASS_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["BANK_NAME_REUSE"] = 5157] = "BANK_NAME_REUSE";
  TalerErrorCode2[TalerErrorCode2["SYNC_ACCOUNT_UNKNOWN"] = 6100] = "SYNC_ACCOUNT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_IF_NONE_MATCH"] = 6101] = "SYNC_BAD_IF_NONE_MATCH";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_IF_MATCH"] = 6102] = "SYNC_BAD_IF_MATCH";
  TalerErrorCode2[TalerErrorCode2["SYNC_BAD_SYNC_SIGNATURE"] = 6103] = "SYNC_BAD_SYNC_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["SYNC_INVALID_SIGNATURE"] = 6104] = "SYNC_INVALID_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["SYNC_MALFORMED_CONTENT_LENGTH"] = 6105] = "SYNC_MALFORMED_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_EXCESSIVE_CONTENT_LENGTH"] = 6106] = "SYNC_EXCESSIVE_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_OUT_OF_MEMORY_ON_CONTENT_LENGTH"] = 6107] = "SYNC_OUT_OF_MEMORY_ON_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_INVALID_UPLOAD"] = 6108] = "SYNC_INVALID_UPLOAD";
  TalerErrorCode2[TalerErrorCode2["SYNC_PAYMENT_GENERIC_TIMEOUT"] = 6109] = "SYNC_PAYMENT_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["SYNC_PAYMENT_CREATE_BACKEND_ERROR"] = 6110] = "SYNC_PAYMENT_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["SYNC_PREVIOUS_BACKUP_UNKNOWN"] = 6111] = "SYNC_PREVIOUS_BACKUP_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["SYNC_MISSING_CONTENT_LENGTH"] = 6112] = "SYNC_MISSING_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["SYNC_GENERIC_BACKEND_ERROR"] = 6113] = "SYNC_GENERIC_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["SYNC_GENERIC_BACKEND_TIMEOUT"] = 6114] = "SYNC_GENERIC_BACKEND_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_PROTOCOL_VERSION_INCOMPATIBLE"] = 7e3] = "WALLET_EXCHANGE_PROTOCOL_VERSION_INCOMPATIBLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_UNEXPECTED_EXCEPTION"] = 7001] = "WALLET_UNEXPECTED_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["WALLET_RECEIVED_MALFORMED_RESPONSE"] = 7002] = "WALLET_RECEIVED_MALFORMED_RESPONSE";
  TalerErrorCode2[TalerErrorCode2["WALLET_NETWORK_ERROR"] = 7003] = "WALLET_NETWORK_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_HTTP_REQUEST_THROTTLED"] = 7004] = "WALLET_HTTP_REQUEST_THROTTLED";
  TalerErrorCode2[TalerErrorCode2["WALLET_UNEXPECTED_REQUEST_ERROR"] = 7005] = "WALLET_UNEXPECTED_REQUEST_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_DENOMINATIONS_INSUFFICIENT"] = 7006] = "WALLET_EXCHANGE_DENOMINATIONS_INSUFFICIENT";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_API_OPERATION_UNKNOWN"] = 7007] = "WALLET_CORE_API_OPERATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["WALLET_INVALID_TALER_PAY_URI"] = 7008] = "WALLET_INVALID_TALER_PAY_URI";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_COIN_SIGNATURE_INVALID"] = 7009] = "WALLET_EXCHANGE_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_WITHDRAW_RESERVE_UNKNOWN_AT_EXCHANGE"] = 7010] = "WALLET_EXCHANGE_WITHDRAW_RESERVE_UNKNOWN_AT_EXCHANGE";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_NOT_AVAILABLE"] = 7011] = "WALLET_CORE_NOT_AVAILABLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_OPERATION_ABORTED_BY_BANK"] = 7012] = "WALLET_WITHDRAWAL_OPERATION_ABORTED_BY_BANK";
  TalerErrorCode2[TalerErrorCode2["WALLET_HTTP_REQUEST_GENERIC_TIMEOUT"] = 7013] = "WALLET_HTTP_REQUEST_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["WALLET_ORDER_ALREADY_CLAIMED"] = 7014] = "WALLET_ORDER_ALREADY_CLAIMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_GROUP_INCOMPLETE"] = 7015] = "WALLET_WITHDRAWAL_GROUP_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["WALLET_REWARD_COIN_SIGNATURE_INVALID"] = 7016] = "WALLET_REWARD_COIN_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_BANK_INTEGRATION_PROTOCOL_VERSION_INCOMPATIBLE"] = 7017] = "WALLET_BANK_INTEGRATION_PROTOCOL_VERSION_INCOMPATIBLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_BASE_URL_MISMATCH"] = 7018] = "WALLET_CONTRACT_TERMS_BASE_URL_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_SIGNATURE_INVALID"] = 7019] = "WALLET_CONTRACT_TERMS_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["WALLET_CONTRACT_TERMS_MALFORMED"] = 7020] = "WALLET_CONTRACT_TERMS_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PENDING_OPERATION_FAILED"] = 7021] = "WALLET_PENDING_OPERATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PAY_MERCHANT_SERVER_ERROR"] = 7022] = "WALLET_PAY_MERCHANT_SERVER_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_CRYPTO_WORKER_ERROR"] = 7023] = "WALLET_CRYPTO_WORKER_ERROR";
  TalerErrorCode2[TalerErrorCode2["WALLET_CRYPTO_WORKER_BAD_REQUEST"] = 7024] = "WALLET_CRYPTO_WORKER_BAD_REQUEST";
  TalerErrorCode2[TalerErrorCode2["WALLET_WITHDRAWAL_KYC_REQUIRED"] = 7025] = "WALLET_WITHDRAWAL_KYC_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["WALLET_DEPOSIT_GROUP_INSUFFICIENT_BALANCE"] = 7026] = "WALLET_DEPOSIT_GROUP_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PUSH_PAYMENT_INSUFFICIENT_BALANCE"] = 7027] = "WALLET_PEER_PUSH_PAYMENT_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PULL_PAYMENT_INSUFFICIENT_BALANCE"] = 7028] = "WALLET_PEER_PULL_PAYMENT_INSUFFICIENT_BALANCE";
  TalerErrorCode2[TalerErrorCode2["WALLET_REFRESH_GROUP_INCOMPLETE"] = 7029] = "WALLET_REFRESH_GROUP_INCOMPLETE";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_BASE_URL_MISMATCH"] = 7030] = "WALLET_EXCHANGE_BASE_URL_MISMATCH";
  TalerErrorCode2[TalerErrorCode2["WALLET_ORDER_ALREADY_PAID"] = 7031] = "WALLET_ORDER_ALREADY_PAID";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_UNAVAILABLE"] = 7032] = "WALLET_EXCHANGE_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_USED"] = 7033] = "WALLET_EXCHANGE_ENTRY_USED";
  TalerErrorCode2[TalerErrorCode2["WALLET_DB_UNAVAILABLE"] = 7034] = "WALLET_DB_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["WALLET_TALER_URI_MALFORMED"] = 7035] = "WALLET_TALER_URI_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_REQUEST_CANCELLED"] = 7036] = "WALLET_CORE_REQUEST_CANCELLED";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_TOS_NOT_ACCEPTED"] = 7037] = "WALLET_EXCHANGE_TOS_NOT_ACCEPTED";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_UPDATE_CONFLICT"] = 7038] = "WALLET_EXCHANGE_ENTRY_UPDATE_CONFLICT";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_OUTDATED"] = 7039] = "WALLET_EXCHANGE_ENTRY_OUTDATED";
  TalerErrorCode2[TalerErrorCode2["WALLET_PAY_MERCHANT_KYC_MISSING"] = 7040] = "WALLET_PAY_MERCHANT_KYC_MISSING";
  TalerErrorCode2[TalerErrorCode2["WALLET_PEER_PULL_DEBIT_PURSE_GONE"] = 7041] = "WALLET_PEER_PULL_DEBIT_PURSE_GONE";
  TalerErrorCode2[TalerErrorCode2["WALLET_TRANSACTION_ABORTED_BY_USER"] = 7042] = "WALLET_TRANSACTION_ABORTED_BY_USER";
  TalerErrorCode2[TalerErrorCode2["WALLET_TRANSACTION_ABANDONED_BY_USER"] = 7043] = "WALLET_TRANSACTION_ABANDONED_BY_USER";
  TalerErrorCode2[TalerErrorCode2["WALLET_PAY_MERCHANT_ORDER_GONE"] = 7044] = "WALLET_PAY_MERCHANT_ORDER_GONE";
  TalerErrorCode2[TalerErrorCode2["WALLET_EXCHANGE_ENTRY_NOT_FOUND"] = 7045] = "WALLET_EXCHANGE_ENTRY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["WALLET_REQUEST_TRANSACTION_STATE_UNSUPPORTED"] = 7046] = "WALLET_REQUEST_TRANSACTION_STATE_UNSUPPORTED";
  TalerErrorCode2[TalerErrorCode2["WALLET_TRANSACTION_PROTOCOL_VIOLATION"] = 7047] = "WALLET_TRANSACTION_PROTOCOL_VIOLATION";
  TalerErrorCode2[TalerErrorCode2["WALLET_CORE_API_BAD_REQUEST"] = 7048] = "WALLET_CORE_API_BAD_REQUEST";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_BACKEND_TIMEOUT"] = 8e3] = "ANASTASIS_GENERIC_BACKEND_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_INVALID_PAYMENT_REQUEST"] = 8001] = "ANASTASIS_GENERIC_INVALID_PAYMENT_REQUEST";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_BACKEND_ERROR"] = 8002] = "ANASTASIS_GENERIC_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_MISSING_CONTENT_LENGTH"] = 8003] = "ANASTASIS_GENERIC_MISSING_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_MALFORMED_CONTENT_LENGTH"] = 8004] = "ANASTASIS_GENERIC_MALFORMED_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_ORDER_CREATE_BACKEND_ERROR"] = 8005] = "ANASTASIS_GENERIC_ORDER_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PAYMENT_CHECK_UNAUTHORIZED"] = 8006] = "ANASTASIS_GENERIC_PAYMENT_CHECK_UNAUTHORIZED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PAYMENT_CHECK_START_FAILED"] = 8007] = "ANASTASIS_GENERIC_PAYMENT_CHECK_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_GENERIC_PROVIDER_UNREACHABLE"] = 8008] = "ANASTASIS_GENERIC_PROVIDER_UNREACHABLE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_PAYMENT_GENERIC_TIMEOUT"] = 8009] = "ANASTASIS_PAYMENT_GENERIC_TIMEOUT";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UNKNOWN"] = 8108] = "ANASTASIS_TRUTH_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_AUTHORIZATION_METHOD_NO_LONGER_SUPPORTED"] = 8109] = "ANASTASIS_TRUTH_AUTHORIZATION_METHOD_NO_LONGER_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_RESPONSE_REQUIRED"] = 8110] = "ANASTASIS_TRUTH_CHALLENGE_RESPONSE_REQUIRED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_FAILED"] = 8111] = "ANASTASIS_TRUTH_CHALLENGE_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_UNKNOWN"] = 8112] = "ANASTASIS_TRUTH_CHALLENGE_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_AUTHORIZATION_START_FAILED"] = 8114] = "ANASTASIS_TRUTH_AUTHORIZATION_START_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_KEY_SHARE_GONE"] = 8115] = "ANASTASIS_TRUTH_KEY_SHARE_GONE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_ORDER_DISAPPEARED"] = 8116] = "ANASTASIS_TRUTH_ORDER_DISAPPEARED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_BACKEND_EXCHANGE_BAD"] = 8117] = "ANASTASIS_TRUTH_BACKEND_EXCHANGE_BAD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UNEXPECTED_PAYMENT_STATUS"] = 8118] = "ANASTASIS_TRUTH_UNEXPECTED_PAYMENT_STATUS";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_PAYMENT_CREATE_BACKEND_ERROR"] = 8119] = "ANASTASIS_TRUTH_PAYMENT_CREATE_BACKEND_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_DECRYPTION_FAILED"] = 8120] = "ANASTASIS_TRUTH_DECRYPTION_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_RATE_LIMITED"] = 8121] = "ANASTASIS_TRUTH_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_CHALLENGE_WRONG_METHOD"] = 8123] = "ANASTASIS_TRUTH_CHALLENGE_WRONG_METHOD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UPLOAD_UUID_EXISTS"] = 8150] = "ANASTASIS_TRUTH_UPLOAD_UUID_EXISTS";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TRUTH_UPLOAD_METHOD_NOT_SUPPORTED"] = 8151] = "ANASTASIS_TRUTH_UPLOAD_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_PHONE_INVALID"] = 8200] = "ANASTASIS_SMS_PHONE_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_HELPER_EXEC_FAILED"] = 8201] = "ANASTASIS_SMS_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_SMS_HELPER_COMMAND_FAILED"] = 8202] = "ANASTASIS_SMS_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_INVALID"] = 8210] = "ANASTASIS_EMAIL_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_HELPER_EXEC_FAILED"] = 8211] = "ANASTASIS_EMAIL_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_EMAIL_HELPER_COMMAND_FAILED"] = 8212] = "ANASTASIS_EMAIL_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_INVALID"] = 8220] = "ANASTASIS_POST_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_HELPER_EXEC_FAILED"] = 8221] = "ANASTASIS_POST_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POST_HELPER_COMMAND_FAILED"] = 8222] = "ANASTASIS_POST_HELPER_COMMAND_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_IBAN_INVALID"] = 8230] = "ANASTASIS_IBAN_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_IBAN_MISSING_TRANSFER"] = 8231] = "ANASTASIS_IBAN_MISSING_TRANSFER";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TOTP_KEY_MISSING"] = 8240] = "ANASTASIS_TOTP_KEY_MISSING";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_TOTP_KEY_INVALID"] = 8241] = "ANASTASIS_TOTP_KEY_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_IF_NONE_MATCH"] = 8301] = "ANASTASIS_POLICY_BAD_IF_NONE_MATCH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_OUT_OF_MEMORY_ON_CONTENT_LENGTH"] = 8304] = "ANASTASIS_POLICY_OUT_OF_MEMORY_ON_CONTENT_LENGTH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_SIGNATURE"] = 8305] = "ANASTASIS_POLICY_BAD_SIGNATURE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_BAD_IF_MATCH"] = 8306] = "ANASTASIS_POLICY_BAD_IF_MATCH";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_INVALID_UPLOAD"] = 8307] = "ANASTASIS_POLICY_INVALID_UPLOAD";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_POLICY_NOT_FOUND"] = 8350] = "ANASTASIS_POLICY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_ACTION_INVALID"] = 8400] = "ANASTASIS_REDUCER_ACTION_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_STATE_INVALID"] = 8401] = "ANASTASIS_REDUCER_STATE_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_INVALID"] = 8402] = "ANASTASIS_REDUCER_INPUT_INVALID";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_AUTHENTICATION_METHOD_NOT_SUPPORTED"] = 8403] = "ANASTASIS_REDUCER_AUTHENTICATION_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_INVALID_FOR_STATE"] = 8404] = "ANASTASIS_REDUCER_INPUT_INVALID_FOR_STATE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_BACKEND_FAILURE"] = 8405] = "ANASTASIS_REDUCER_BACKEND_FAILURE";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_RESOURCE_MALFORMED"] = 8406] = "ANASTASIS_REDUCER_RESOURCE_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_RESOURCE_MISSING"] = 8407] = "ANASTASIS_REDUCER_RESOURCE_MISSING";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_REGEX_FAILED"] = 8408] = "ANASTASIS_REDUCER_INPUT_REGEX_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INPUT_VALIDATION_FAILED"] = 8409] = "ANASTASIS_REDUCER_INPUT_VALIDATION_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_POLICY_LOOKUP_FAILED"] = 8410] = "ANASTASIS_REDUCER_POLICY_LOOKUP_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_BACKUP_PROVIDER_FAILED"] = 8411] = "ANASTASIS_REDUCER_BACKUP_PROVIDER_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDER_CONFIG_FAILED"] = 8412] = "ANASTASIS_REDUCER_PROVIDER_CONFIG_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_POLICY_MALFORMED"] = 8413] = "ANASTASIS_REDUCER_POLICY_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_NETWORK_FAILED"] = 8414] = "ANASTASIS_REDUCER_NETWORK_FAILED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_SECRET_MALFORMED"] = 8415] = "ANASTASIS_REDUCER_SECRET_MALFORMED";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_CHALLENGE_DATA_TOO_BIG"] = 8416] = "ANASTASIS_REDUCER_CHALLENGE_DATA_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_SECRET_TOO_BIG"] = 8417] = "ANASTASIS_REDUCER_SECRET_TOO_BIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDER_INVALID_CONFIG"] = 8418] = "ANASTASIS_REDUCER_PROVIDER_INVALID_CONFIG";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_INTERNAL_ERROR"] = 8419] = "ANASTASIS_REDUCER_INTERNAL_ERROR";
  TalerErrorCode2[TalerErrorCode2["ANASTASIS_REDUCER_PROVIDERS_ALREADY_SYNCED"] = 8420] = "ANASTASIS_REDUCER_PROVIDERS_ALREADY_SYNCED";
  TalerErrorCode2[TalerErrorCode2["DONAU_GENERIC_KEYS_MISSING"] = 8607] = "DONAU_GENERIC_KEYS_MISSING";
  TalerErrorCode2[TalerErrorCode2["DONAU_CHARITY_SIGNATURE_INVALID"] = 8608] = "DONAU_CHARITY_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["DONAU_CHARITY_NOT_FOUND"] = 8609] = "DONAU_CHARITY_NOT_FOUND";
  TalerErrorCode2[TalerErrorCode2["DONAU_EXCEEDING_DONATION_LIMIT"] = 8610] = "DONAU_EXCEEDING_DONATION_LIMIT";
  TalerErrorCode2[TalerErrorCode2["DONAU_GENERIC_DONATION_UNIT_UNKNOWN"] = 8611] = "DONAU_GENERIC_DONATION_UNIT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["DONAU_DONATION_UNIT_HELPER_UNAVAILABLE"] = 8612] = "DONAU_DONATION_UNIT_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["DONAU_SIGNKEY_HELPER_UNAVAILABLE"] = 8613] = "DONAU_SIGNKEY_HELPER_UNAVAILABLE";
  TalerErrorCode2[TalerErrorCode2["DONAU_SIGNKEY_HELPER_BUG"] = 8614] = "DONAU_SIGNKEY_HELPER_BUG";
  TalerErrorCode2[TalerErrorCode2["DONAU_GENERIC_WRONG_NUMBER_OF_SEGMENTS"] = 8615] = "DONAU_GENERIC_WRONG_NUMBER_OF_SEGMENTS";
  TalerErrorCode2[TalerErrorCode2["DONAU_DONATION_RECEIPT_SIGNATURE_INVALID"] = 8616] = "DONAU_DONATION_RECEIPT_SIGNATURE_INVALID";
  TalerErrorCode2[TalerErrorCode2["DONAU_DONOR_IDENTIFIER_NONCE_REUSE"] = 8617] = "DONAU_DONOR_IDENTIFIER_NONCE_REUSE";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_NEXUS_GENERIC_ERROR"] = 9e3] = "LIBEUFIN_NEXUS_GENERIC_ERROR";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_NEXUS_UNCAUGHT_EXCEPTION"] = 9001] = "LIBEUFIN_NEXUS_UNCAUGHT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_SANDBOX_GENERIC_ERROR"] = 9500] = "LIBEUFIN_SANDBOX_GENERIC_ERROR";
  TalerErrorCode2[TalerErrorCode2["LIBEUFIN_SANDBOX_UNCAUGHT_EXCEPTION"] = 9501] = "LIBEUFIN_SANDBOX_UNCAUGHT_EXCEPTION";
  TalerErrorCode2[TalerErrorCode2["TALDIR_METHOD_NOT_SUPPORTED"] = 9600] = "TALDIR_METHOD_NOT_SUPPORTED";
  TalerErrorCode2[TalerErrorCode2["TALDIR_REGISTER_RATE_LIMITED"] = 9601] = "TALDIR_REGISTER_RATE_LIMITED";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_CLIENT_UNKNOWN"] = 9750] = "CHALLENGER_GENERIC_CLIENT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_CLIENT_FORBIDDEN_BAD_REDIRECT_URI"] = 9751] = "CHALLENGER_GENERIC_CLIENT_FORBIDDEN_BAD_REDIRECT_URI";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_HELPER_EXEC_FAILED"] = 9752] = "CHALLENGER_HELPER_EXEC_FAILED";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GRANT_UNKNOWN"] = 9753] = "CHALLENGER_GRANT_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_BAD_CODE"] = 9754] = "CHALLENGER_CLIENT_FORBIDDEN_BAD_CODE";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_GENERIC_VALIDATION_UNKNOWN"] = 9755] = "CHALLENGER_GENERIC_VALIDATION_UNKNOWN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_INVALID_CODE"] = 9756] = "CHALLENGER_CLIENT_FORBIDDEN_INVALID_CODE";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_TOO_MANY_ATTEMPTS"] = 9757] = "CHALLENGER_TOO_MANY_ATTEMPTS";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_INVALID_PIN"] = 9758] = "CHALLENGER_INVALID_PIN";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_MISSING_ADDRESS"] = 9759] = "CHALLENGER_MISSING_ADDRESS";
  TalerErrorCode2[TalerErrorCode2["CHALLENGER_CLIENT_FORBIDDEN_READ_ONLY"] = 9760] = "CHALLENGER_CLIENT_FORBIDDEN_READ_ONLY";
  TalerErrorCode2[TalerErrorCode2["END"] = 9999] = "END";
})(TalerErrorCode || (TalerErrorCode = {}));

// ../taler-util/lib/time.js
var opaque_AbsoluteTime = Symbol("opaque_AbsoluteTime");
var TalerPreciseTimestamp;
(function(TalerPreciseTimestamp2) {
  function now() {
    const absNow = AbsoluteTime.now();
    return AbsoluteTime.toPreciseTimestamp(absNow);
  }
  TalerPreciseTimestamp2.now = now;
  function round(t4) {
    return {
      t_s: t4.t_s
    };
  }
  TalerPreciseTimestamp2.round = round;
  function fromSeconds(s4) {
    return {
      t_s: Math.floor(s4),
      off_us: Math.floor((s4 - Math.floor(s4)) / 1e3 / 1e3)
    };
  }
  TalerPreciseTimestamp2.fromSeconds = fromSeconds;
  function fromMilliseconds(ms) {
    return {
      t_s: Math.floor(ms / 1e3),
      off_us: Math.floor((ms - Math.floor(ms / 1e3) * 1e3) * 1e3)
    };
  }
  TalerPreciseTimestamp2.fromMilliseconds = fromMilliseconds;
})(TalerPreciseTimestamp || (TalerPreciseTimestamp = {}));
var TalerProtocolDuration;
(function(TalerProtocolDuration3) {
  function fromSpec(d4) {
    return Duration.toTalerProtocolDuration(Duration.fromSpec(d4));
  }
  TalerProtocolDuration3.fromSpec = fromSpec;
  function forever() {
    return {
      d_us: "forever"
    };
  }
  TalerProtocolDuration3.forever = forever;
})(TalerProtocolDuration || (TalerProtocolDuration = {}));
var TalerProtocolTimestamp;
(function(TalerProtocolTimestamp3) {
  function now() {
    return AbsoluteTime.toProtocolTimestamp(AbsoluteTime.now());
  }
  TalerProtocolTimestamp3.now = now;
  function zero() {
    return {
      t_s: 0
    };
  }
  TalerProtocolTimestamp3.zero = zero;
  function never() {
    return {
      t_s: "never"
    };
  }
  TalerProtocolTimestamp3.never = never;
  function isNever(t4) {
    return t4.t_s === "never";
  }
  TalerProtocolTimestamp3.isNever = isNever;
  function fromSeconds(s4) {
    return {
      t_s: s4
    };
  }
  TalerProtocolTimestamp3.fromSeconds = fromSeconds;
  function min(t1, t22) {
    if (t1.t_s === "never") {
      return { t_s: t22.t_s };
    }
    if (t22.t_s === "never") {
      return { t_s: t1.t_s };
    }
    return { t_s: Math.min(t1.t_s, t22.t_s) };
  }
  TalerProtocolTimestamp3.min = min;
  function max(t1, t22) {
    if (t1.t_s === "never" || t22.t_s === "never") {
      return { t_s: "never" };
    }
    return { t_s: Math.max(t1.t_s, t22.t_s) };
  }
  TalerProtocolTimestamp3.max = max;
})(TalerProtocolTimestamp || (TalerProtocolTimestamp = {}));
var timeshift = 0;
var Duration;
(function(Duration2) {
  function toMilliseconds(d4) {
    if (d4.d_ms === "forever") {
      return Number.MAX_VALUE;
    }
    return d4.d_ms;
  }
  Duration2.toMilliseconds = toMilliseconds;
  function getRemaining(deadline, now = AbsoluteTime.now()) {
    if (deadline.t_ms === "never") {
      return { d_ms: "forever" };
    }
    if (now.t_ms === "never") {
      throw Error("invalid argument for 'now'");
    }
    if (deadline.t_ms < now.t_ms) {
      return { d_ms: 0 };
    }
    return { d_ms: deadline.t_ms - now.t_ms };
  }
  Duration2.getRemaining = getRemaining;
  function fromPrettyString(s4) {
    let dMs = 0;
    let currentNum = "";
    let parsingNum = true;
    for (let i4 = 0; i4 < s4.length; i4++) {
      const cc = s4.charCodeAt(i4);
      if (cc >= "0".charCodeAt(0) && cc <= "9".charCodeAt(0)) {
        if (!parsingNum) {
          throw Error("invalid duration, unexpected number");
        }
        currentNum += s4[i4];
        continue;
      }
      if (s4[i4] == " ") {
        if (currentNum != "") {
          parsingNum = false;
        }
        continue;
      }
      if (currentNum == "") {
        throw Error("invalid duration, missing number");
      }
      if (s4[i4] === "s") {
        if (s4.startsWith("seconds", i4)) {
          i4 += "seconds".length - 1;
        }
        dMs += 1e3 * Number.parseInt(currentNum, 10);
      } else if (s4[i4] === "m") {
        if (s4.startsWith("minutes", i4)) {
          i4 += "minutes".length - 1;
        }
        dMs += 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else if (s4[i4] === "h") {
        if (s4.startsWith("hours", i4)) {
          i4 += "hours".length - 1;
        }
        dMs += 60 * 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else if (s4[i4] === "d") {
        if (s4.startsWith("days", i4)) {
          i4 += "days".length - 1;
        }
        dMs += 24 * 60 * 60 * 1e3 * Number.parseInt(currentNum, 10);
      } else {
        throw Error("invalid duration, unsupported unit");
      }
      currentNum = "";
      parsingNum = true;
    }
    return {
      d_ms: dMs
    };
  }
  Duration2.fromPrettyString = fromPrettyString;
  function cmp(d1, d23) {
    if (d1.d_ms === "forever") {
      if (d23.d_ms === "forever") {
        return 0;
      }
      return 1;
    }
    if (d23.d_ms === "forever") {
      return -1;
    }
    if (d1.d_ms == d23.d_ms) {
      return 0;
    }
    if (d1.d_ms > d23.d_ms) {
      return 1;
    }
    return -1;
  }
  Duration2.cmp = cmp;
  function max(d1, d23) {
    return durationMax(d1, d23);
  }
  Duration2.max = max;
  function min(d1, d23) {
    return durationMin(d1, d23);
  }
  Duration2.min = min;
  function multiply(d1, n2) {
    return durationMul(d1, n2);
  }
  Duration2.multiply = multiply;
  function toIntegerYears(d4) {
    if (typeof d4.d_ms !== "number") {
      throw Error("infinite duration");
    }
    return Math.ceil(d4.d_ms / 1e3 / 60 / 60 / 24 / 365);
  }
  Duration2.toIntegerYears = toIntegerYears;
  function fromSpec(spec) {
    let d_ms = 0;
    d_ms += (spec.seconds ?? 0) * SECONDS;
    d_ms += (spec.minutes ?? 0) * MINUTES;
    d_ms += (spec.hours ?? 0) * HOURS;
    d_ms += (spec.days ?? 0) * DAYS;
    d_ms += (spec.months ?? 0) * MONTHS;
    d_ms += (spec.years ?? 0) * YEARS;
    return { d_ms };
  }
  Duration2.fromSpec = fromSpec;
  function fromSpecOrUndefined(spec) {
    if (spec.seconds == void 0 && spec.minutes == void 0 && spec.hours == void 0 && spec.days == void 0 && spec.months == void 0 && spec.years == void 0) {
      return void 0;
    }
    return Duration2.fromSpec(spec);
  }
  Duration2.fromSpecOrUndefined = fromSpecOrUndefined;
  function toSpec({ d_ms }) {
    if (d_ms === "forever")
      return void 0;
    const ms = d_ms > 0 ? d_ms : 0;
    const Y_rest = ms % YEARS;
    const M_rest = Y_rest % MONTHS;
    const D_rest = M_rest % DAYS;
    const h_rest = D_rest % HOURS;
    const m_rest = h_rest % MINUTES;
    const millis = m_rest % SECONDS;
    return {
      years: (ms - Y_rest) / YEARS,
      month: (Y_rest - M_rest) / MONTHS,
      days: (M_rest - D_rest) / DAYS,
      hours: (D_rest - h_rest) / HOURS,
      minutes: (h_rest - m_rest) / MINUTES,
      seconds: (m_rest - millis) / SECONDS
    };
  }
  Duration2.toSpec = toSpec;
  function getForever() {
    return { d_ms: "forever" };
  }
  Duration2.getForever = getForever;
  function getZero() {
    return { d_ms: 0 };
  }
  Duration2.getZero = getZero;
  function fromTalerProtocolDuration(d4) {
    if (d4.d_us === "forever") {
      return {
        d_ms: "forever"
      };
    }
    return {
      d_ms: Math.floor(d4.d_us / 1e3)
    };
  }
  Duration2.fromTalerProtocolDuration = fromTalerProtocolDuration;
  function toTalerProtocolDuration(d4) {
    if (d4.d_ms === "forever") {
      return {
        d_us: "forever"
      };
    }
    return {
      d_us: d4.d_ms * 1e3
    };
  }
  Duration2.toTalerProtocolDuration = toTalerProtocolDuration;
  function fromMilliseconds(ms) {
    return {
      d_ms: ms
    };
  }
  Duration2.fromMilliseconds = fromMilliseconds;
  function clamp(args) {
    return durationMax(durationMin(args.value, args.upper), args.lower);
  }
  Duration2.clamp = clamp;
})(Duration || (Duration = {}));
var AbsoluteTime;
(function(AbsoluteTime3) {
  function getStampMsNow() {
    return (/* @__PURE__ */ new Date()).getTime();
  }
  AbsoluteTime3.getStampMsNow = getStampMsNow;
  function getStampMsNever() {
    return Number.MAX_SAFE_INTEGER;
  }
  AbsoluteTime3.getStampMsNever = getStampMsNever;
  function now() {
    return {
      t_ms: (/* @__PURE__ */ new Date()).getTime() + timeshift,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.now = now;
  function never() {
    return {
      t_ms: "never",
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.never = never;
  function fromMilliseconds(ms) {
    return {
      t_ms: ms,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromMilliseconds = fromMilliseconds;
  function cmp(t1, t22) {
    if (t1.t_ms === "never") {
      if (t22.t_ms === "never") {
        return 0;
      }
      return 1;
    }
    if (t22.t_ms === "never") {
      return -1;
    }
    if (t1.t_ms == t22.t_ms) {
      return 0;
    }
    if (t1.t_ms > t22.t_ms) {
      return 1;
    }
    return -1;
  }
  AbsoluteTime3.cmp = cmp;
  function min(t1, t22) {
    if (t1.t_ms === "never") {
      return { t_ms: t22.t_ms, [opaque_AbsoluteTime]: true };
    }
    if (t22.t_ms === "never") {
      return { t_ms: t22.t_ms, [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.min(t1.t_ms, t22.t_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.min = min;
  function max(t1, t22) {
    if (t1.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    if (t22.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.max(t1.t_ms, t22.t_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.max = max;
  function difference(t1, t22) {
    if (t1.t_ms === "never") {
      return { d_ms: "forever" };
    }
    if (t22.t_ms === "never") {
      return { d_ms: "forever" };
    }
    return { d_ms: Math.abs(t1.t_ms - t22.t_ms) };
  }
  AbsoluteTime3.difference = difference;
  function isExpired(t4) {
    return cmp(t4, now()) <= 0;
  }
  AbsoluteTime3.isExpired = isExpired;
  function isNever(t4) {
    return t4.t_ms === "never";
  }
  AbsoluteTime3.isNever = isNever;
  function fromProtocolTimestamp(t4) {
    if (t4.t_s === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return {
      t_ms: t4.t_s * 1e3,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromProtocolTimestamp = fromProtocolTimestamp;
  function fromStampMs(stampMs) {
    return {
      t_ms: stampMs,
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromStampMs = fromStampMs;
  function fromPreciseTimestamp(t4) {
    if (t4.t_s === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    const offsetUs = t4.off_us ?? 0;
    return {
      t_ms: t4.t_s * 1e3 + Math.floor(offsetUs / 1e3),
      [opaque_AbsoluteTime]: true
    };
  }
  AbsoluteTime3.fromPreciseTimestamp = fromPreciseTimestamp;
  function toStampMs(at2) {
    if (at2.t_ms === "never") {
      return Number.MAX_SAFE_INTEGER;
    }
    return at2.t_ms;
  }
  AbsoluteTime3.toStampMs = toStampMs;
  function toPreciseTimestamp(at2) {
    if (at2.t_ms == "never") {
      return {
        t_s: "never"
      };
    }
    const t_s = Math.floor(at2.t_ms / 1e3);
    const off_us = Math.floor(1e3 * (at2.t_ms - t_s * 1e3));
    return {
      t_s,
      off_us
    };
  }
  AbsoluteTime3.toPreciseTimestamp = toPreciseTimestamp;
  function toProtocolTimestamp(at2) {
    if (at2.t_ms === "never") {
      return { t_s: "never" };
    }
    return {
      t_s: Math.floor(at2.t_ms / 1e3)
    };
  }
  AbsoluteTime3.toProtocolTimestamp = toProtocolTimestamp;
  function isBetween(t4, start, end) {
    if (cmp(t4, start) < 0) {
      return false;
    }
    if (cmp(t4, end) > 0) {
      return false;
    }
    return true;
  }
  AbsoluteTime3.isBetween = isBetween;
  function toIsoString(t4) {
    if (t4.t_ms === "never") {
      return "<never>";
    } else {
      return new Date(t4.t_ms).toISOString();
    }
  }
  AbsoluteTime3.toIsoString = toIsoString;
  function addDuration(t1, d4) {
    if (t1.t_ms === "never" || d4.d_ms === "forever") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    return { t_ms: t1.t_ms + d4.d_ms, [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.addDuration = addDuration;
  function remaining(t1) {
    if (t1.t_ms === "never") {
      return Duration.getForever();
    }
    const stampNow = now();
    if (stampNow.t_ms === "never") {
      throw Error("invariant violated");
    }
    return Duration.fromMilliseconds(Math.max(0, t1.t_ms - stampNow.t_ms));
  }
  AbsoluteTime3.remaining = remaining;
  function subtractDuraction(t1, d4) {
    if (t1.t_ms === "never") {
      return { t_ms: "never", [opaque_AbsoluteTime]: true };
    }
    if (d4.d_ms === "forever") {
      return { t_ms: 0, [opaque_AbsoluteTime]: true };
    }
    return { t_ms: Math.max(0, t1.t_ms - d4.d_ms), [opaque_AbsoluteTime]: true };
  }
  AbsoluteTime3.subtractDuraction = subtractDuraction;
  function stringify(t4) {
    if (t4.t_ms === "never") {
      return "never";
    }
    return new Date(t4.t_ms).toISOString();
  }
  AbsoluteTime3.stringify = stringify;
})(AbsoluteTime || (AbsoluteTime = {}));
var SECONDS = 1e3;
var MINUTES = SECONDS * 60;
var HOURS = MINUTES * 60;
var DAYS = HOURS * 24;
var MONTHS = DAYS * 30;
var YEARS = DAYS * 365;
function durationMin(d1, d23) {
  if (d1.d_ms === "forever") {
    return { d_ms: d23.d_ms };
  }
  if (d23.d_ms === "forever") {
    return { d_ms: d1.d_ms };
  }
  return { d_ms: Math.min(d1.d_ms, d23.d_ms) };
}
function durationMax(d1, d23) {
  if (d1.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  if (d23.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  return { d_ms: Math.max(d1.d_ms, d23.d_ms) };
}
function durationMul(d4, n2) {
  if (d4.d_ms === "forever") {
    return { d_ms: "forever" };
  }
  return { d_ms: Math.round(d4.d_ms * n2) };
}
var codecForAbsoluteTime = {
  decode(x5, c4) {
    if (x5 === void 0) {
      throw Error(`got undefined and expected absolute time at ${renderContext(c4)}`);
    }
    const t_ms = x5.t_ms;
    if (typeof t_ms === "string") {
      if (t_ms === "never") {
        return { t_ms: "never", [opaque_AbsoluteTime]: true };
      }
    } else if (typeof t_ms === "number") {
      return { t_ms, [opaque_AbsoluteTime]: true };
    }
    throw Error(`expected timestamp at ${renderContext(c4)}`);
  }
};
var codecForTimestamp = {
  decode(x5, c4) {
    if (x5 === void 0) {
      throw Error(`got undefined and expected timestamp at ${renderContext(c4)}`);
    }
    const t_ms = x5.t_ms;
    if (typeof t_ms === "string") {
      if (t_ms === "never") {
        return { t_s: "never" };
      }
    } else if (typeof t_ms === "number") {
      return { t_s: Math.floor(t_ms / 1e3) };
    }
    const t_s = x5.t_s;
    if (typeof t_s === "string") {
      if (t_s === "never") {
        return { t_s: "never" };
      }
      throw Error(`expected timestamp at ${renderContext(c4)}`);
    }
    if (typeof t_s === "number") {
      return { t_s };
    }
    throw Error(`expected protocol timestamp at ${renderContext(c4)}`);
  }
};
var codecForDuration = {
  decode(x5, c4) {
    const d_us = x5.d_us;
    if (typeof d_us === "string") {
      if (d_us === "forever") {
        return { d_us: "forever" };
      }
      throw Error(`expected duration at ${renderContext(c4)}`);
    }
    if (typeof d_us === "number") {
      return { d_us };
    }
    throw Error(`expected duration at ${renderContext(c4)}`);
  }
};

// ../taler-util/lib/http-common.js
var textEncoder = new TextEncoder();
var logger2 = new Logger("http.ts");
var DEFAULT_REQUEST_TIMEOUT_MS = 6e4;
var HeadersImpl = class {
  constructor() {
    this.headerMap = /* @__PURE__ */ new Map();
  }
  get(name) {
    const r3 = this.headerMap.get(name.toLowerCase());
    if (r3) {
      return r3;
    }
    return null;
  }
  set(name, value) {
    const normalizedName = name.toLowerCase();
    const existing = this.headerMap.get(normalizedName);
    if (existing !== void 0) {
      this.headerMap.set(normalizedName, existing + "," + value);
    } else {
      this.headerMap.set(normalizedName, value);
    }
  }
  toJSON() {
    const m4 = {};
    this.headerMap.forEach((v3, k5) => m4[k5] = v3);
    return m4;
  }
};
async function readTalerErrorResponse(httpResponse) {
  const contentType = httpResponse.headers.get("content-type");
  if (contentType !== "application/json") {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      contentType: contentType || "<null>"
    }, "Error response did not even contain JSON. The request URL might be wrong or the service might be unavailable.");
  }
  let errJson;
  try {
    errJson = await httpResponse.json();
  } catch (e4) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e4 instanceof Error ? e4.message : String(e4)
    }, "Couldn't parse JSON format from error response");
  }
  const talerErrorCode = errJson.code;
  if (typeof talerErrorCode !== "number") {
    logger2.warn(`malformed error response (status ${httpResponse.status}): ${j2s(errJson)}`);
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text()
    }, "Error response did not contain error code");
  }
  return errJson;
}
async function readSuccessResponseJsonOrErrorCode(httpResponse, codec) {
  if (!(httpResponse.status >= 200 && httpResponse.status < 300)) {
    return {
      isError: true,
      talerErrorResponse: await readTalerErrorResponse(httpResponse)
    };
  }
  let respJson;
  try {
    respJson = await httpResponse.json();
  } catch (e4) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e4 instanceof Error ? e4.message : String(e4)
    }, "Couldn't parse JSON format from response");
  }
  let parsedResponse;
  try {
    parsedResponse = codec.decode(respJson);
  } catch (e4) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e4 instanceof Error ? e4.message : String(e4)
    }, "Response invalid");
  }
  return {
    isError: false,
    response: parsedResponse
  };
}
async function readResponseJsonOrThrow(httpResponse, codec) {
  let respJson;
  try {
    respJson = await httpResponse.json();
  } catch (e4) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e4 instanceof Error ? e4.message : String(e4)
    }, "Couldn't parse JSON format from response");
  }
  let parsedResponse;
  try {
    parsedResponse = codec.decode(respJson);
  } catch (e4) {
    throw TalerError.fromDetail(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE, {
      requestUrl: httpResponse.requestUrl,
      requestMethod: httpResponse.requestMethod,
      httpStatusCode: httpResponse.status,
      response: await httpResponse.text(),
      validationError: e4 instanceof Error ? e4.message : String(e4)
    }, "Response invalid");
  }
  return parsedResponse;
}
function throwUnexpectedRequestError(httpResponse, talerErrorResponse) {
  const errorDetails = {
    requestUrl: httpResponse.requestUrl,
    requestMethod: httpResponse.requestMethod,
    httpStatusCode: httpResponse.status,
    errorResponse: talerErrorResponse
  };
  logger2.trace(`unexpected request error: ${j2s(errorDetails)}`);
  throw TalerError.fromDetail(TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR, errorDetails, `Unexpected HTTP status ${httpResponse.status} in response`);
}
async function readSuccessResponseJsonOrThrow(httpResponse, codec) {
  const r3 = await readSuccessResponseJsonOrErrorCode(httpResponse, codec);
  if (!r3.isError) {
    return r3.response;
  }
  throwUnexpectedRequestError(httpResponse, r3.talerErrorResponse);
}
function encodeBody(body) {
  if (body == null) {
    return new ArrayBuffer(0);
  }
  if (typeof body === "string") {
    return textEncoder.encode(body).buffer;
  } else if (ArrayBuffer.isView(body)) {
    return body.buffer;
  } else if (body instanceof ArrayBuffer) {
    return body;
  } else if (body instanceof URLSearchParams) {
    return textEncoder.encode(body.toString()).buffer;
  } else if (typeof body === "object" && body.constructor.name === "FormData") {
    return body;
  } else if (typeof body === "object") {
    return textEncoder.encode(JSON.stringify(body)).buffer;
  }
  throw new TypeError("unsupported request body type");
}
function getDefaultHeaders(method) {
  const headers = {};
  if (method === "POST" || method === "PUT" || method === "PATCH") {
    headers["Content-Type"] = "application/json";
  }
  headers["Accept"] = "application/json";
  return headers;
}

// ../taler-util/lib/http.js
function createPlatformHttpLib(args) {
  return new HttpLibImpl(args);
}

// ../taler-util/lib/bank-api-client.js
var logger3 = new Logger("bank-api-client.ts");
var CreditDebitIndicator;
(function(CreditDebitIndicator2) {
  CreditDebitIndicator2["Credit"] = "credit";
  CreditDebitIndicator2["Debit"] = "debit";
})(CreditDebitIndicator || (CreditDebitIndicator = {}));

// ../taler-util/lib/taler-crypto.js
var import_big_integer = __toESM(require_BigInteger(), 1);

// ../taler-util/lib/sha256.js
var digestLength = 32;
var blockSize = 64;
var K2 = new Uint32Array([
  1116352408,
  1899447441,
  3049323471,
  3921009573,
  961987163,
  1508970993,
  2453635748,
  2870763221,
  3624381080,
  310598401,
  607225278,
  1426881987,
  1925078388,
  2162078206,
  2614888103,
  3248222580,
  3835390401,
  4022224774,
  264347078,
  604807628,
  770255983,
  1249150122,
  1555081692,
  1996064986,
  2554220882,
  2821834349,
  2952996808,
  3210313671,
  3336571891,
  3584528711,
  113926993,
  338241895,
  666307205,
  773529912,
  1294757372,
  1396182291,
  1695183700,
  1986661051,
  2177026350,
  2456956037,
  2730485921,
  2820302411,
  3259730800,
  3345764771,
  3516065817,
  3600352804,
  4094571909,
  275423344,
  430227734,
  506948616,
  659060556,
  883997877,
  958139571,
  1322822218,
  1537002063,
  1747873779,
  1955562222,
  2024104815,
  2227730452,
  2361852424,
  2428436474,
  2756734187,
  3204031479,
  3329325298
]);
function hashBlocks(w5, v3, p4, pos, len) {
  let a4, b4, c4, d4, e4, f3, g4, h3, u4, i4, j4, t1, t22;
  while (len >= 64) {
    a4 = v3[0];
    b4 = v3[1];
    c4 = v3[2];
    d4 = v3[3];
    e4 = v3[4];
    f3 = v3[5];
    g4 = v3[6];
    h3 = v3[7];
    for (i4 = 0; i4 < 16; i4++) {
      j4 = pos + i4 * 4;
      w5[i4] = (p4[j4] & 255) << 24 | (p4[j4 + 1] & 255) << 16 | (p4[j4 + 2] & 255) << 8 | p4[j4 + 3] & 255;
    }
    for (i4 = 16; i4 < 64; i4++) {
      u4 = w5[i4 - 2];
      t1 = (u4 >>> 17 | u4 << 32 - 17) ^ (u4 >>> 19 | u4 << 32 - 19) ^ u4 >>> 10;
      u4 = w5[i4 - 15];
      t22 = (u4 >>> 7 | u4 << 32 - 7) ^ (u4 >>> 18 | u4 << 32 - 18) ^ u4 >>> 3;
      w5[i4] = (t1 + w5[i4 - 7] | 0) + (t22 + w5[i4 - 16] | 0);
    }
    for (i4 = 0; i4 < 64; i4++) {
      t1 = (((e4 >>> 6 | e4 << 32 - 6) ^ (e4 >>> 11 | e4 << 32 - 11) ^ (e4 >>> 25 | e4 << 32 - 25)) + (e4 & f3 ^ ~e4 & g4) | 0) + (h3 + (K2[i4] + w5[i4] | 0) | 0) | 0;
      t22 = ((a4 >>> 2 | a4 << 32 - 2) ^ (a4 >>> 13 | a4 << 32 - 13) ^ (a4 >>> 22 | a4 << 32 - 22)) + (a4 & b4 ^ a4 & c4 ^ b4 & c4) | 0;
      h3 = g4;
      g4 = f3;
      f3 = e4;
      e4 = d4 + t1 | 0;
      d4 = c4;
      c4 = b4;
      b4 = a4;
      a4 = t1 + t22 | 0;
    }
    v3[0] += a4;
    v3[1] += b4;
    v3[2] += c4;
    v3[3] += d4;
    v3[4] += e4;
    v3[5] += f3;
    v3[6] += g4;
    v3[7] += h3;
    pos += 64;
    len -= 64;
  }
  return pos;
}
var HashSha256 = class {
  constructor() {
    this.digestLength = digestLength;
    this.blockSize = blockSize;
    this.state = new Int32Array(8);
    this.temp = new Int32Array(64);
    this.buffer = new Uint8Array(128);
    this.bufferLength = 0;
    this.bytesHashed = 0;
    this.finished = false;
    this.reset();
  }
  // Resets hash state making it possible
  // to reuse this instance to hash other data.
  reset() {
    this.state[0] = 1779033703;
    this.state[1] = 3144134277;
    this.state[2] = 1013904242;
    this.state[3] = 2773480762;
    this.state[4] = 1359893119;
    this.state[5] = 2600822924;
    this.state[6] = 528734635;
    this.state[7] = 1541459225;
    this.bufferLength = 0;
    this.bytesHashed = 0;
    this.finished = false;
    return this;
  }
  // Cleans internal buffers and re-initializes hash state.
  clean() {
    for (let i4 = 0; i4 < this.buffer.length; i4++) {
      this.buffer[i4] = 0;
    }
    for (let i4 = 0; i4 < this.temp.length; i4++) {
      this.temp[i4] = 0;
    }
    this.reset();
  }
  // Updates hash state with the given data.
  //
  // Optionally, length of the data can be specified to hash
  // fewer bytes than data.length.
  //
  // Throws error when trying to update already finalized hash:
  // instance must be reset to use it again.
  update(data, dataLength = data.length) {
    if (this.finished) {
      throw new Error("SHA256: can't update because hash was finished.");
    }
    let dataPos = 0;
    this.bytesHashed += dataLength;
    if (this.bufferLength > 0) {
      while (this.bufferLength < 64 && dataLength > 0) {
        this.buffer[this.bufferLength++] = data[dataPos++];
        dataLength--;
      }
      if (this.bufferLength === 64) {
        hashBlocks(this.temp, this.state, this.buffer, 0, 64);
        this.bufferLength = 0;
      }
    }
    if (dataLength >= 64) {
      dataPos = hashBlocks(this.temp, this.state, data, dataPos, dataLength);
      dataLength %= 64;
    }
    while (dataLength > 0) {
      this.buffer[this.bufferLength++] = data[dataPos++];
      dataLength--;
    }
    return this;
  }
  // Finalizes hash state and puts hash into out.
  //
  // If hash was already finalized, puts the same value.
  finish(out) {
    if (!this.finished) {
      const bytesHashed = this.bytesHashed;
      const left = this.bufferLength;
      const bitLenHi = bytesHashed / 536870912 | 0;
      const bitLenLo = bytesHashed << 3;
      const padLength = bytesHashed % 64 < 56 ? 64 : 128;
      this.buffer[left] = 128;
      for (let i4 = left + 1; i4 < padLength - 8; i4++) {
        this.buffer[i4] = 0;
      }
      this.buffer[padLength - 8] = bitLenHi >>> 24 & 255;
      this.buffer[padLength - 7] = bitLenHi >>> 16 & 255;
      this.buffer[padLength - 6] = bitLenHi >>> 8 & 255;
      this.buffer[padLength - 5] = bitLenHi >>> 0 & 255;
      this.buffer[padLength - 4] = bitLenLo >>> 24 & 255;
      this.buffer[padLength - 3] = bitLenLo >>> 16 & 255;
      this.buffer[padLength - 2] = bitLenLo >>> 8 & 255;
      this.buffer[padLength - 1] = bitLenLo >>> 0 & 255;
      hashBlocks(this.temp, this.state, this.buffer, 0, padLength);
      this.finished = true;
    }
    for (let i4 = 0; i4 < 8; i4++) {
      out[i4 * 4 + 0] = this.state[i4] >>> 24 & 255;
      out[i4 * 4 + 1] = this.state[i4] >>> 16 & 255;
      out[i4 * 4 + 2] = this.state[i4] >>> 8 & 255;
      out[i4 * 4 + 3] = this.state[i4] >>> 0 & 255;
    }
    return this;
  }
  // Returns the final hash digest.
  digest() {
    const out = new Uint8Array(this.digestLength);
    this.finish(out);
    return out;
  }
  // Internal function for use in HMAC for optimization.
  _saveState(out) {
    for (let i4 = 0; i4 < this.state.length; i4++) {
      out[i4] = this.state[i4];
    }
  }
  // Internal function for use in HMAC for optimization.
  _restoreState(from, bytesHashed) {
    for (let i4 = 0; i4 < this.state.length; i4++) {
      this.state[i4] = from[i4];
    }
    this.bytesHashed = bytesHashed;
    this.finished = false;
    this.bufferLength = 0;
  }
};
function sha256(data) {
  const h3 = new HashSha256().update(data);
  const digest = h3.digest();
  h3.clean();
  return digest;
}

// ../taler-util/lib/kdf.js
function sha512(data) {
  return hash(data);
}
function hmac(digest, blockSize2, key, message) {
  if (key.byteLength > blockSize2) {
    key = digest(key);
  }
  if (key.byteLength < blockSize2) {
    const k5 = key;
    key = new Uint8Array(blockSize2);
    key.set(k5, 0);
  }
  const okp = new Uint8Array(blockSize2);
  const ikp = new Uint8Array(blockSize2);
  for (let i4 = 0; i4 < blockSize2; i4++) {
    ikp[i4] = key[i4] ^ 54;
    okp[i4] = key[i4] ^ 92;
  }
  const b1 = new Uint8Array(blockSize2 + message.byteLength);
  b1.set(ikp, 0);
  b1.set(message, blockSize2);
  const h0 = digest(b1);
  const b22 = new Uint8Array(blockSize2 + h0.length);
  b22.set(okp, 0);
  b22.set(h0, blockSize2);
  return digest(b22);
}
function hmacSha512(key, message) {
  return hmac(sha512, 128, key, message);
}
function hmacSha256(key, message) {
  return hmac(sha256, 64, key, message);
}

// ../taler-util/lib/types-taler-common.js
var codecForURLString = codecForString;
var codecForCurrencyName = codecForString;
var codecForEddsaPublicKey = codecForString;
var codecForEddsaSignature = codecForString;
var codecForInternationalizedString = () => codecForMap(codecForString());
var codecForCurrencySpecificiation = () => buildCodecForObject().property("name", codecForString()).property("num_fractional_input_digits", codecForNumber()).property("num_fractional_normal_digits", codecForNumber()).property("num_fractional_trailing_zero_digits", codecForNumber()).property("alt_unit_names", codecForMap(codecForString())).deprecatedProperty("currency").build("CurrencySpecification");
var codecForTalerCommonConfigResponse = () => buildCodecForObject().allowExtra().property("name", codecForString()).property("version", codecForString()).allowExtra().build("TalerCommonConfigResponse");
var ExchangeProtocolVersion;
(function(ExchangeProtocolVersion2) {
  ExchangeProtocolVersion2[ExchangeProtocolVersion2["V12"] = 12] = "V12";
})(ExchangeProtocolVersion || (ExchangeProtocolVersion = {}));
var MerchantProtocolVersion;
(function(MerchantProtocolVersion2) {
  MerchantProtocolVersion2[MerchantProtocolVersion2["V3"] = 3] = "V3";
})(MerchantProtocolVersion || (MerchantProtocolVersion = {}));
var codecForAccessToken = codecForString;
var codecForURN = codecForString;

// ../taler-util/lib/types-taler-exchange.js
var DenominationPubKey;
(function(DenominationPubKey2) {
  function cmp(p1, p22) {
    if (p1.cipher < p22.cipher) {
      return -1;
    } else if (p1.cipher > p22.cipher) {
      return 1;
    } else if (p1.cipher === DenomKeyType.Rsa && p22.cipher === DenomKeyType.Rsa) {
      if ((p1.age_mask ?? 0) < (p22.age_mask ?? 0)) {
        return -1;
      } else if ((p1.age_mask ?? 0) > (p22.age_mask ?? 0)) {
        return 1;
      }
      return strcmp(p1.rsa_public_key, p22.rsa_public_key);
    } else if (p1.cipher === DenomKeyType.ClauseSchnorr && p22.cipher === DenomKeyType.ClauseSchnorr) {
      if ((p1.age_mask ?? 0) < (p22.age_mask ?? 0)) {
        return -1;
      } else if ((p1.age_mask ?? 0) > (p22.age_mask ?? 0)) {
        return 1;
      }
      return strcmp(p1.cs_public_key, p22.cs_public_key);
    } else {
      throw Error("unsupported cipher");
    }
  }
  DenominationPubKey2.cmp = cmp;
})(DenominationPubKey || (DenominationPubKey = {}));
var codecForNgDenominations = codecForAny();
var DenomKeyType;
(function(DenomKeyType2) {
  DenomKeyType2["Rsa"] = "RSA";
  DenomKeyType2["ClauseSchnorr"] = "CS";
})(DenomKeyType || (DenomKeyType = {}));
(function(DenomKeyType2) {
  function toIntTag(t4) {
    switch (t4) {
      case DenomKeyType2.Rsa:
        return 1;
      case DenomKeyType2.ClauseSchnorr:
        return 2;
    }
  }
  DenomKeyType2.toIntTag = toIntTag;
})(DenomKeyType || (DenomKeyType = {}));
var codecForRsaBlindedDenominationSignature = () => buildCodecForObject().property("cipher", codecForConstString(DenomKeyType.Rsa)).property("blinded_rsa_signature", codecForString()).build("RsaBlindedDenominationSignature");
var codecForBlindedDenominationSignature = () => buildCodecForUnion().discriminateOn("cipher").alternative(DenomKeyType.Rsa, codecForRsaBlindedDenominationSignature()).build("BlindedDenominationSignature");
var codecForExchangeWithdrawResponse = () => buildCodecForObject().property("ev_sigs", codecForList(codecForBlindedDenominationSignature())).build("WithdrawResponse");
var codecForExchangeMeltResponse = () => buildCodecForObject().property("exchange_pub", codecForEddsaPublicKey()).property("exchange_sig", codecForEddsaSignature()).property("noreveal_index", codecForNumber()).property("refresh_base_url", codecOptional(codecForString())).build("ExchangeMeltResponse");
var codecForExchangeGetContractResponse = () => buildCodecForObject().property("purse_pub", codecForString()).property("econtract_sig", codecForString()).property("econtract", codecForString()).build("ExchangeGetContractResponse");
var codecForExchangeMergeSuccessResponse = () => buildCodecForObject().property("merge_amount", codecForAmountString()).property("exchange_timestamp", codecForTimestamp).property("exchange_sig", codecForEddsaSignature()).property("exchange_pub", codecForEddsaPublicKey()).build("ExchangeMergeSuccessResponse");
var codecForExchangeMergeConflictResponse = () => buildCodecForObject().property("merge_timestamp", codecForTimestamp).property("merge_sig", codecForEddsaSignature()).property("reserve_pub", codecForEddsaPublicKey()).property("partner_url", codecOptional(codecForString())).build("ExchangeMergeConflictResponse");
var codecForExchangePurseStatus = () => buildCodecForObject().property("balance", codecForAmountString()).property("deposit_timestamp", codecOptional(codecForTimestamp)).property("merge_timestamp", codecOptional(codecForTimestamp)).build("ExchangePurseStatus");
var AmlSpaDialect;
(function(AmlSpaDialect2) {
  AmlSpaDialect2["TOPS"] = "tops";
  AmlSpaDialect2["GLS"] = "gls";
  AmlSpaDialect2["TESTING"] = "testing";
})(AmlSpaDialect || (AmlSpaDialect = {}));
var LimitOperationType;
(function(LimitOperationType2) {
  LimitOperationType2["withdraw"] = "WITHDRAW";
  LimitOperationType2["deposit"] = "DEPOSIT";
  LimitOperationType2["merge"] = "MERGE";
  LimitOperationType2["aggregate"] = "AGGREGATE";
  LimitOperationType2["balance"] = "BALANCE";
  LimitOperationType2["refund"] = "REFUND";
  LimitOperationType2["close"] = "CLOSE";
  LimitOperationType2["transaction"] = "TRANSACTION";
})(LimitOperationType || (LimitOperationType = {}));
var AmlState;
(function(AmlState2) {
  AmlState2[AmlState2["normal"] = 0] = "normal";
  AmlState2[AmlState2["pending"] = 1] = "pending";
  AmlState2[AmlState2["frozen"] = 2] = "frozen";
})(AmlState || (AmlState = {}));
var codecForAmlSpaDialect = codecForEither(codecForConstString(AmlSpaDialect.GLS), codecForConstString(AmlSpaDialect.TOPS), codecForConstString(AmlSpaDialect.TESTING));
var codecForExchangeConfig = () => buildCodecForObject().property("version", codecForString()).property("name", codecForConstString("taler-exchange")).property("implementation", codecOptional(codecForURN())).property("currency", codecForString()).property("currency_specification", codecForCurrencySpecificiation()).property("supported_kyc_requirements", codecForList(codecForString())).property("aml_spa_dialect", codecOptional(codecForAmlSpaDialect)).deprecatedProperty("shopping_url").deprecatedProperty("wallet_balance_limit_without_kyc").build("TalerExchangeApi.ExchangeVersionResponse");
var codecForExchangeKeysResponse = () => buildCodecForObject().property("version", codecForString()).property("base_url", codecForString()).property("currency", codecForString()).property("accounts", codecForAny()).property("asset_type", codecForAny()).property("auditors", codecForAny()).property("currency_specification", codecForAny()).property("zero_limits", codecForAny()).property("hard_limits", codecForAny()).property("denominations", codecForAny()).property("exchange_pub", codecForAny()).property("exchange_sig", codecForAny()).property("extensions", codecForAny()).property("extensions_sig", codecForAny()).property("global_fees", codecForAny()).property("list_issue_date", codecForAny()).property("master_public_key", codecForAny()).property("recoup", codecForAny()).property("reserve_closing_delay", codecForAny()).property("signkeys", codecForAny()).property("stefan_abs", codecForAny()).property("stefan_lin", codecForAny()).property("stefan_log", codecForAny()).property("wads", codecForAny()).property("wallet_balance_limit_without_kyc", codecForAny()).property("wire_fees", codecForAny()).property("kyc_enabled", codecOptional(codecForBoolean())).property("shopping_url", codecOptional(codecForString())).property("tiny_amount", codecOptional(codecForAmountString())).property("bank_compliance_language", codecOptional(codecForString())).deprecatedProperty("rewards_allowed").build("TalerExchangeApi.ExchangeKeysResponse");
var codecForAmlStatisticsResponse = () => buildCodecForObject().property("statistics", codecForList(codecForEventCounter())).build("TalerExchangeApi.AmlStatisticsResponse");
var codecForEventCounter = () => buildCodecForObject().property("name", codecForString()).property("counter", codecForNumber()).build("TalerExchangeApi.EventCounter");
var codecForLegitimizationMeasuresList = () => buildCodecForObject().property("measures", codecForList(codecForLegitimizationMeasureDetails())).build("TalerExchangeApi.LegitimizationMeasuresList");
var codecForLegitimizationMeasureDetails = () => buildCodecForObject().property("h_payto", codecForAny()).property("rowid", codecForAny()).property("start_time", codecForAny()).property("measures", codecForAny()).property("is_finished", codecForAny()).build("TalerExchangeApi.LegitimizationMeasureDetails");
var codecForAvailableMeasureSummary = () => buildCodecForObject().property("checks", codecForMap(codecForKycCheckInformation())).property("programs", codecForMap(codecForAmlProgramRequirement())).property("roots", codecForMap(codecForMeasureInformation())).property("default_rules", codecForList(codecForKycRules())).build("TalerExchangeApi.AvailableMeasureSummary");
var codecForAmlProgramRequirement = () => buildCodecForObject().property("description", codecForString()).property("context", codecForList(codecForString())).property("inputs", codecForList(codecForString())).build("TalerExchangeApi.AmlProgramRequirement");
var codecForKycCheckInformation = () => buildCodecForObject().property("description", codecForString()).property("description_i18n", codecOptional(codecForInternationalizedString())).property("fallback", codecForString()).property("outputs", codecForList(codecForString())).property("requires", codecForList(codecForString())).build("TalerExchangeApi.KycCheckInformation");
var codecForMeasureInformation = () => buildCodecForObject().property("prog_name", codecOptional(codecForString())).property("check_name", codecForString()).property("context", codecForAny()).property("operation_type", codecOptional(codecForOperationType)).property("voluntary", codecOptional(codecForBoolean())).build("TalerExchangeApi.MeasureInformation");
var codecForAmlDecisionsResponse = () => buildCodecForObject().property("records", codecForList(codecForAmlDecision())).build("TalerExchangeApi.AmlDecisionsResponse");
var codecForAmlDecision = () => buildCodecForObject().property("h_payto", codecForString()).property("full_payto", codecOptional(codecForString())).property("rowid", codecForNumber()).property("is_wallet", codecForBoolean()).property("justification", codecOptional(codecForString())).property("decision_time", codecForTimestamp).property("properties", codecOptional(codecForAccountProperties())).property("limits", codecForLegitimizationRuleSet()).property("to_investigate", codecForBoolean()).property("is_active", codecForBoolean()).build("TalerExchangeApi.AmlDecision");
var codecForAccountProperties = () => buildCodecForObject().property("pep", codecOptional(codecForBoolean())).property("sanctioned", codecOptional(codecForBoolean())).property("high_risk", codecOptional(codecForBoolean())).property("business_domain", codecOptional(codecForString())).property("is_frozen", codecOptional(codecForBoolean())).property("was_reported", codecOptional(codecForBoolean())).allowExtra().build("TalerExchangeApi.AccountProperties");
var codecForLegitimizationRuleSet = () => buildCodecForObject().property("expiration_time", codecForTimestamp).property("successor_measure", codecOptional(codecForString())).property("rules", codecForList(codecForKycRules())).property("custom_measures", codecForMap(codecForMeasureInformation())).build("TalerExchangeApi.LegitimizationRuleSet");
var codecForKycRules = () => buildCodecForObject().property("operation_type", codecForOperationType).property("threshold", codecForAmountString()).property("timeframe", codecForDuration).property("measures", codecForList(codecForString())).property("display_priority", codecForNumber()).property("exposed", codecOptional(codecForBoolean())).property("is_and_combinator", codecOptional(codecForBoolean())).property("rule_name", codecOptional(codecForString())).build("TalerExchangeApi.KycRule");
var codecForAmlKycAttributes = () => buildCodecForObject().property("details", codecForList(codecForKycAttributeCollectionEvent())).build("TalerExchangeApi.KycAttributes");
var codecForKycAttributeCollectionEvent = () => buildCodecForObject().property("rowid", codecForNumber()).property("provider_name", codecOptional(codecForString())).property("collection_time", codecForTimestamp).property("attributes", codecOptional(codecForAny())).build("TalerExchangeApi.KycAttributeCollectionEvent");
var codecForAmlWalletKycCheckResponse = () => buildCodecForObject().property("next_threshold", codecOptional(codecForAmountString())).property("expiration_time", codecForTimestamp).build("TalerExchangeApi.WalletKycCheckResponse");
var codecForLegitimizationNeededResponse = () => buildCodecForObject().property("code", codecForNumber()).property("hint", codecOptional(codecForString())).property("h_payto", codecForString()).property("account_pub", codecOptional(codecForEddsaPublicKey())).property("requirement_row", codecForNumber()).property("bad_kyc_auth", codecOptional(codecForBoolean())).build("TalerExchangeApi.LegitimizationNeededResponse");
var codecForAccountKycStatus = () => buildCodecForObject().property("aml_review", codecForBoolean()).property("access_token", codecForAccessToken()).property("limits", codecOptional(codecForList(codecForAccountLimit()))).property("rule_gen", codecForNumber()).build("TalerExchangeApi.AccountKycStatus");
var codecForOperationType = codecForEither(codecForConstString(LimitOperationType.withdraw), codecForConstString(LimitOperationType.deposit), codecForConstString(LimitOperationType.merge), codecForConstString(LimitOperationType.balance), codecForConstString(LimitOperationType.close), codecForConstString(LimitOperationType.aggregate), codecForConstString(LimitOperationType.transaction), codecForConstString(LimitOperationType.refund));
var codecForAccountLimit = () => buildCodecForObject().property("operation_type", codecForOperationType).property("timeframe", codecForDuration).property("threshold", codecForAmountString()).property("soft_limit", codecOptional(codecForBoolean())).property("rule_name", codecOptional(codecForString())).build("TalerExchangeApi.AccountLimit");
var codecForKycRequirementInformationId = () => codecForString();
var codecForKycFormId = () => codecForString();
var codecForKycRequirementInformation = () => buildCodecForObject().property("form", codecForEither(codecForConstString("LINK"), codecForConstString("INFO"), codecForKycFormId())).property("description", codecForString()).property("context", codecOptional(codecForAny())).property("description_i18n", codecOptional(codecForInternationalizedString())).property("id", codecOptional(codecForKycRequirementInformationId())).build("TalerExchangeApi.KycRequirementInformation");
var codecForKycProcessClientInformation = () => buildCodecForObject().property("requirements", codecOptionalDefault(codecForList(codecForKycRequirementInformation()), [])).property("is_and_combinator", codecOptional(codecForBoolean())).property("voluntary_measures", codecOptional(codecForList(codecForKycRequirementInformation()))).build("TalerExchangeApi.KycProcessClientInformation");
var codecForExchangeTransferList = () => buildCodecForObject().property("transfers", codecForList(codecForExchangeTransferListEntry())).build("TalerExchangeApi.ExchangeTransferList");
var codecForExchangeTransferListEntry = () => buildCodecForObject().property("rowid", codecForNumber()).property("payto_uri", codecForPaytoString()).property("amount", codecForAmountString()).property("execution_time", codecForTimestamp).build("TalerExchangeApi.ExchangeTransferListEntry");
var codecForKycProcessStartInformation = () => buildCodecForObject().property("redirect_url", codecForURLString()).build("TalerExchangeApi.KycProcessStartInformation");
var TransactionHistoryType;
(function(TransactionHistoryType2) {
  TransactionHistoryType2["setup"] = "SETUP";
  TransactionHistoryType2["withdraw"] = "WITHDRAW";
  TransactionHistoryType2["ageWithdraw"] = "AGEWITHDRAW";
  TransactionHistoryType2["credit"] = "CREDIT";
  TransactionHistoryType2["closing"] = "CLOSING";
  TransactionHistoryType2["open"] = "OPEN";
  TransactionHistoryType2["close"] = "CLOSE";
  TransactionHistoryType2["merge"] = "MERGE";
})(TransactionHistoryType || (TransactionHistoryType = {}));
var codecForPurseConflict = () => buildCodecForUnion().discriminateOn("code").alternative(TalerErrorCode.EXCHANGE_GENERIC_INSUFFICIENT_FUNDS, codecForDepositDoubleSpendError()).alternative(TalerErrorCode.EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA, codecForPurseCreateConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA, codecForPurseDepositConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA, codecForPurseContractConflict()).build("PurseConflict");
var codecForPurseConflictPartial = () => buildCodecForUnion().discriminateOn("code").alternative(TalerErrorCode.EXCHANGE_PURSE_CREATE_CONFLICTING_META_DATA, codecForPurseCreateConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_DEPOSIT_CONFLICTING_META_DATA, codecForPurseDepositConflict()).alternative(TalerErrorCode.EXCHANGE_PURSE_ECONTRACT_CONFLICTING_META_DATA, codecForPurseContractConflict()).build("PurseConflictPartial");
var codecForDepositDoubleSpendError = () => buildCodecForObject().property("code", codecForNumber()).property("hint", codecForString()).property("coin_pub", codecForString()).build("DepositDoubleSpendError");
var codecForPurseCreateConflict = () => buildCodecForObject().property("code", codecForNumber()).property("amount", codecForAmountString()).property("min_age", codecForNumber()).property("purse_expiration", codecForTimestamp).property("purse_sig", codecForString()).property("h_contract_terms", codecForString()).property("merge_pub", codecForString()).build("PurseCreateConflict");
var codecForPurseDepositConflict = () => buildCodecForObject().property("code", codecForNumber()).property("coin_pub", codecForString()).property("partner_url", codecOptional(codecForString())).property("amount", codecForAmountString()).build("PurseDepositConflict");
var codecForPurseContractConflict = () => buildCodecForObject().property("code", codecForNumber()).property("h_econtract", codecForString()).property("econtract_sig", codecForString()).property("contract_pub", codecForString()).build("PurseContractConflict");

// ../taler-util/lib/taler-crypto.js
var isEddsaPubP = Symbol("isEddsaPubP");
var isEddsaPrivP = Symbol("isEddsaPrivP");
var isEddsaSigP = Symbol("isEddsaSigP");
var isEdx25519PublicKey = Symbol("isEdx25519PublicKey");
var isEdx25519PrivateKey = Symbol("isEdx25519PrivateKey");
var isEcdhePrivP = Symbol("isEcdhePrivP");
var isEdx25519Signature = Symbol("isEdx25519Signature");
var isEdx25519PublicKeyEnc = Symbol("isEdx25519PublicKeyEnc");
var isEdx25519PrivateKeyEnc = Symbol("isEdx25519PrivateKeyEnc");
var isEncryptionNonce = Symbol("isEncryptionNone");
function getRandomBytes(n2) {
  return randomBytes(n2);
}
var useNative = true;
var tart;
if (useNative) {
  tart = globalThis._tart;
}
var encTable = "0123456789ABCDEFGHJKMNPQRSTVWXYZ";
var EncodingError = class _EncodingError extends Error {
  constructor() {
    super("Encoding error");
    Object.setPrototypeOf(this, _EncodingError.prototype);
  }
};
function getValue(chr) {
  let a4 = chr;
  switch (chr) {
    case "O":
    case "o":
      a4 = "0";
      break;
    case "i":
    case "I":
    case "l":
    case "L":
      a4 = "1";
      break;
    case "u":
    case "U":
      a4 = "V";
  }
  if (a4 >= "0" && a4 <= "9") {
    return a4.charCodeAt(0) - "0".charCodeAt(0);
  }
  if (a4 >= "a" && a4 <= "z")
    a4 = a4.toUpperCase();
  let dec = 0;
  if (a4 >= "A" && a4 <= "Z") {
    if ("I" < a4)
      dec++;
    if ("L" < a4)
      dec++;
    if ("O" < a4)
      dec++;
    if ("U" < a4)
      dec++;
    return a4.charCodeAt(0) - "A".charCodeAt(0) + 10 - dec;
  }
  throw new EncodingError();
}
function encodeCrock(data) {
  if (tart) {
    return tart.encodeCrock(data);
  }
  const dataBytes = new Uint8Array(data);
  let sb = "";
  const size = data.byteLength;
  let bitBuf = 0;
  let numBits = 0;
  let pos = 0;
  while (pos < size || numBits > 0) {
    if (pos < size && numBits < 5) {
      const d4 = dataBytes[pos++];
      bitBuf = bitBuf << 8 | d4;
      numBits += 8;
    }
    if (numBits < 5) {
      bitBuf = bitBuf << 5 - numBits;
      numBits = 5;
    }
    const v3 = bitBuf >>> numBits - 5 & 31;
    sb += encTable[v3];
    numBits -= 5;
  }
  return sb;
}
function kdf(outputLength, ikm, salt, info) {
  if (tart) {
    return tart.kdf(outputLength, ikm, salt, info);
  }
  salt = salt ?? new Uint8Array(64);
  const prk = hmacSha512(salt, ikm);
  info = info ?? new Uint8Array(0);
  const N3 = Math.ceil(outputLength / 32);
  const output = new Uint8Array(N3 * 32);
  for (let i4 = 0; i4 < N3; i4++) {
    let buf;
    if (i4 == 0) {
      buf = new Uint8Array(info.byteLength + 1);
      buf.set(info, 0);
    } else {
      buf = new Uint8Array(info.byteLength + 1 + 32);
      for (let j4 = 0; j4 < 32; j4++) {
        buf[j4] = output[(i4 - 1) * 32 + j4];
      }
      buf.set(info, 32);
    }
    buf[buf.length - 1] = i4 + 1;
    const chunk = hmacSha256(prk, buf);
    output.set(chunk, i4 * 32);
  }
  return output.slice(0, outputLength);
}
function kdfKw(args) {
  return kdf(args.outputLength, args.ikm, args.salt, args.info);
}
function decodeCrock(encoded) {
  if (tart) {
    return tart.decodeCrock(encoded);
  }
  const size = encoded.length;
  let bitpos = 0;
  let bitbuf = 0;
  let readPosition = 0;
  const outLen = Math.floor(size * 5 / 8);
  const out = new Uint8Array(outLen);
  let outPos = 0;
  while (readPosition < size || bitpos > 0) {
    if (readPosition < size) {
      const v3 = getValue(encoded[readPosition++]);
      bitbuf = bitbuf << 5 | v3;
      bitpos += 5;
    }
    while (bitpos >= 8) {
      const d4 = bitbuf >>> bitpos - 8 & 255;
      out[outPos++] = d4;
      bitpos -= 8;
    }
    if (readPosition == size && bitpos > 0) {
      bitbuf = bitbuf << 8 - bitpos & 255;
      bitpos = bitbuf == 0 ? 0 : 8;
    }
  }
  return out;
}
function eddsaGetPublic(eddsaPriv) {
  if (tart) {
    return tart.eddsaGetPublic(eddsaPriv);
  }
  const pair = crypto_sign_keyPair_fromSeed(eddsaPriv);
  return pair.publicKey;
}
var encoder;
function stringToBytes(s4) {
  if (!encoder) {
    encoder = new TextEncoder();
  }
  return encoder.encode(s4);
}
function typedArrayConcat(chunks) {
  let payloadLen = 0;
  for (const c4 of chunks) {
    payloadLen += c4.byteLength;
  }
  const buf = new ArrayBuffer(payloadLen);
  const u8buf = new Uint8Array(buf);
  let p4 = 0;
  for (const c4 of chunks) {
    u8buf.set(c4, p4);
    p4 += c4.byteLength;
  }
  return u8buf;
}
function createEddsaKeyPair() {
  const eddsaPriv = randomBytes(32);
  const eddsaPub = eddsaGetPublic(eddsaPriv);
  return { eddsaPriv, eddsaPub };
}
function hash2(d4) {
  if (tart) {
    return tart.hash(d4);
  }
  return hash(d4);
}
var logger4 = new Logger("talerCrypto.ts");
function eddsaSign(msg, eddsaPriv) {
  if (tart) {
    return tart.eddsaSign(msg, eddsaPriv);
  }
  const pair = crypto_sign_keyPair_fromSeed(eddsaPriv);
  return sign_detached(msg, pair.secretKey);
}
function bufferForUint32(n2) {
  const arrBuf = new ArrayBuffer(4);
  const buf = new Uint8Array(arrBuf);
  const dv = new DataView(arrBuf);
  dv.setUint32(0, n2);
  return buf;
}
function bufferForUint64(n2) {
  const arrBuf = new ArrayBuffer(8);
  const buf = new Uint8Array(arrBuf);
  const dv = new DataView(arrBuf);
  if (n2 < 0 || !Number.isInteger(n2)) {
    throw Error("non-negative integer expected");
  }
  dv.setBigUint64(0, BigInt(n2));
  return buf;
}
var TalerSignaturePurpose;
(function(TalerSignaturePurpose2) {
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_TRACK_TRANSACTION"] = 1103] = "MERCHANT_TRACK_TRANSACTION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_WITHDRAW"] = 1200] = "WALLET_RESERVE_WITHDRAW";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_RESERVE_HISTORY"] = 1208] = "WALLET_RESERVE_HISTORY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_DEPOSIT"] = 1201] = "WALLET_COIN_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["GLOBAL_FEES"] = 1022] = "GLOBAL_FEES";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_DENOMINATION_KEY_VALIDITY"] = 1025] = "MASTER_DENOMINATION_KEY_VALIDITY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_WIRE_FEES"] = 1028] = "MASTER_WIRE_FEES";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_WIRE_DETAILS"] = 1030] = "MASTER_WIRE_DETAILS";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_MELT"] = 1202] = "WALLET_COIN_MELT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["TEST"] = 4242] = "TEST";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_PAYMENT_OK"] = 1104] = "MERCHANT_PAYMENT_OK";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_CONTRACT"] = 1101] = "MERCHANT_CONTRACT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MERCHANT_REFUND"] = 1102] = "MERCHANT_REFUND";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_RECOUP"] = 1203] = "WALLET_COIN_RECOUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_LINK"] = 1204] = "WALLET_COIN_LINK";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_ACCOUNT_SETUP"] = 1205] = "WALLET_ACCOUNT_SETUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_RECOUP_REFRESH"] = 1206] = "WALLET_COIN_RECOUP_REFRESH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_AGE_ATTESTATION"] = 1207] = "WALLET_AGE_ATTESTATION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_CREATE"] = 1210] = "WALLET_PURSE_CREATE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_DEPOSIT"] = 1211] = "WALLET_PURSE_DEPOSIT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_MERGE"] = 1213] = "WALLET_PURSE_MERGE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_ACCOUNT_MERGE"] = 1214] = "WALLET_ACCOUNT_MERGE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_ECONTRACT"] = 1216] = "WALLET_PURSE_ECONTRACT";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_PURSE_DELETE"] = 1220] = "WALLET_PURSE_DELETE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_TOKEN_USE"] = 1222] = "WALLET_TOKEN_USE";
  TalerSignaturePurpose2[TalerSignaturePurpose2["WALLET_COIN_HISTORY"] = 1209] = "WALLET_COIN_HISTORY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_RECOUP"] = 1039] = "EXCHANGE_CONFIRM_RECOUP";
  TalerSignaturePurpose2[TalerSignaturePurpose2["EXCHANGE_CONFIRM_RECOUP_REFRESH"] = 1041] = "EXCHANGE_CONFIRM_RECOUP_REFRESH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["AML_DECISION"] = 1350] = "AML_DECISION";
  TalerSignaturePurpose2[TalerSignaturePurpose2["AML_QUERY"] = 1351] = "AML_QUERY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["MASTER_AML_KEY"] = 1017] = "MASTER_AML_KEY";
  TalerSignaturePurpose2[TalerSignaturePurpose2["KYC_AUTH"] = 1360] = "KYC_AUTH";
  TalerSignaturePurpose2[TalerSignaturePurpose2["ANASTASIS_POLICY_UPLOAD"] = 1400] = "ANASTASIS_POLICY_UPLOAD";
  TalerSignaturePurpose2[TalerSignaturePurpose2["ANASTASIS_POLICY_DOWNLOAD"] = 1401] = "ANASTASIS_POLICY_DOWNLOAD";
  TalerSignaturePurpose2[TalerSignaturePurpose2["SYNC_BACKUP_UPLOAD"] = 1450] = "SYNC_BACKUP_UPLOAD";
})(TalerSignaturePurpose || (TalerSignaturePurpose = {}));
var WalletAccountMergeFlags;
(function(WalletAccountMergeFlags2) {
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["None"] = 0] = "None";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["MergeFullyPaidPurse"] = 1] = "MergeFullyPaidPurse";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["CreateFromPurseQuota"] = 2] = "CreateFromPurseQuota";
  WalletAccountMergeFlags2[WalletAccountMergeFlags2["CreateWithPurseFee"] = 3] = "CreateWithPurseFee";
})(WalletAccountMergeFlags || (WalletAccountMergeFlags = {}));
var SignaturePurposeBuilder = class {
  constructor(purposeNum) {
    this.purposeNum = purposeNum;
    this.chunks = [];
  }
  put(bytes) {
    this.chunks.push(Uint8Array.from(bytes));
    return this;
  }
  build() {
    let payloadLen = 0;
    for (const c4 of this.chunks) {
      payloadLen += c4.byteLength;
    }
    const buf = new ArrayBuffer(4 + 4 + payloadLen);
    const u8buf = new Uint8Array(buf);
    let p4 = 8;
    for (const c4 of this.chunks) {
      u8buf.set(c4, p4);
      p4 += c4.byteLength;
    }
    const dvbuf = new DataView(buf);
    dvbuf.setUint32(0, payloadLen + 4 + 4);
    dvbuf.setUint32(4, this.purposeNum);
    return u8buf;
  }
};
function buildSigPS(purposeNum) {
  return new SignaturePurposeBuilder(purposeNum);
}
function bigintToNaclArr(x5, size) {
  const byteArr = new Uint8Array(size);
  const arr = x5.toArray(256).value.reverse();
  byteArr.set(arr, 0);
  return byteArr;
}
function bigintFromNaclArr(arr) {
  let rev = new Uint8Array(arr);
  rev = rev.reverse();
  return import_big_integer.default.fromArray(Array.from(rev), 256, false);
}
var Edx25519;
(function(Edx255192) {
  const revL = [
    237,
    211,
    245,
    92,
    26,
    99,
    18,
    88,
    214,
    156,
    247,
    162,
    222,
    249,
    222,
    20,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    16
  ];
  const L5 = import_big_integer.default.fromArray(revL.reverse(), 256, false);
  async function keyCreateFromSeed(seed) {
    return crypto_edx25519_private_key_create_from_seed(seed);
  }
  Edx255192.keyCreateFromSeed = keyCreateFromSeed;
  async function keyCreate() {
    return crypto_edx25519_private_key_create();
  }
  Edx255192.keyCreate = keyCreate;
  async function getPublic(priv) {
    return crypto_edx25519_get_public(priv);
  }
  Edx255192.getPublic = getPublic;
  function sign2(msg, key) {
    throw Error("not implemented");
  }
  Edx255192.sign = sign2;
  async function deriveFactor(pub, seed) {
    const res = kdfKw({
      outputLength: 64,
      ikm: pub,
      salt: stringToBytes("edx25519-derivation"),
      info: seed
    });
    return res;
  }
  async function privateKeyDerive(priv, seed) {
    const pub = await getPublic(priv);
    const privDec = priv;
    const a4 = bigintFromNaclArr(privDec.subarray(0, 32));
    const factorEnc = await deriveFactor(pub, seed);
    const factorModL = bigintFromNaclArr(factorEnc).mod(L5);
    const aPrime = a4.divide(8).multiply(factorModL).mod(L5).multiply(8).mod(L5);
    const bPrime = hash(typedArrayConcat([privDec.subarray(32, 64), factorEnc])).subarray(0, 32);
    const newPriv = typedArrayConcat([bigintToNaclArr(aPrime, 32), bPrime]);
    return newPriv;
  }
  Edx255192.privateKeyDerive = privateKeyDerive;
  async function publicKeyDerive(pub, seed) {
    const factorEnc = await deriveFactor(pub, seed);
    const factorReduced = crypto_core_ed25519_scalar_reduce(factorEnc);
    const res = crypto_scalarmult_ed25519_noclamp(factorReduced, pub);
    return res;
  }
  Edx255192.publicKeyDerive = publicKeyDerive;
})(Edx25519 || (Edx25519 = {}));
function invariant(cond) {
  if (!cond) {
    throw Error("invariant failed");
  }
}
var AgeRestriction;
(function(AgeRestriction2) {
  AgeRestriction2.AGE_UNRESTRICTED = 32;
  function hashCommitment(ac) {
    const hc = new HashState();
    for (const pub of ac.publicKeys) {
      hc.update(decodeCrock(pub));
    }
    return encodeCrock(hc.finish().subarray(0, 32));
  }
  AgeRestriction2.hashCommitment = hashCommitment;
  function countAgeGroups(mask) {
    let count = 0;
    let m4 = mask;
    while (m4 > 0) {
      count += m4 & 1;
      m4 = m4 >> 1;
    }
    return count;
  }
  AgeRestriction2.countAgeGroups = countAgeGroups;
  function getAgeGroupsFromMask(mask) {
    const groups = [];
    let age = 1;
    let m4 = mask >> 1;
    while (m4 > 0) {
      if (m4 & 1) {
        groups.push(age);
      }
      m4 = m4 >> 1;
      age++;
    }
    return groups;
  }
  AgeRestriction2.getAgeGroupsFromMask = getAgeGroupsFromMask;
  function getAgeGroupIndex(mask, age) {
    invariant((mask & 1) === 1);
    let i4 = 0;
    let m4 = mask;
    let a4 = age;
    while (m4 > 0) {
      if (a4 <= 0) {
        break;
      }
      m4 = m4 >> 1;
      i4 += m4 & 1;
      a4--;
    }
    return i4;
  }
  AgeRestriction2.getAgeGroupIndex = getAgeGroupIndex;
  function ageGroupSpecToMask(ageGroupSpec) {
    throw Error("not implemented");
  }
  AgeRestriction2.ageGroupSpecToMask = ageGroupSpecToMask;
  async function restrictionCommit(ageMask, age) {
    invariant((ageMask & 1) === 1);
    const numPubs = countAgeGroups(ageMask) - 1;
    const numPrivs = getAgeGroupIndex(ageMask, age);
    const pubs = [];
    const privs = [];
    for (let i4 = 0; i4 < numPubs; i4++) {
      const priv = await Edx25519.keyCreate();
      const pub = await Edx25519.getPublic(priv);
      pubs.push(pub);
      if (i4 < numPrivs) {
        privs.push(priv);
      }
    }
    return {
      commitment: {
        mask: ageMask,
        publicKeys: pubs.map((x5) => encodeCrock(x5))
      },
      proof: {
        privateKeys: privs.map((x5) => encodeCrock(x5))
      }
    };
  }
  AgeRestriction2.restrictionCommit = restrictionCommit;
  const PublishedAgeRestrictionBaseKey = decodeCrock("CH0VKFDZ2GWRWHQBBGEK9MWV5YDQVJ0RXEE0KYT3NMB69F0R96TG");
  async function restrictionCommitSeeded(ageMask, age, seed) {
    invariant((ageMask & 1) === 1);
    const numPubs = countAgeGroups(ageMask) - 1;
    const numPrivs = getAgeGroupIndex(ageMask, age);
    const pubs = [];
    const privs = [];
    for (let i4 = 0; i4 < numPrivs; i4++) {
      const privSeed = await kdfKw({
        outputLength: 32,
        ikm: seed,
        info: stringToBytes("age-commitment"),
        salt: bufferForUint32(i4)
      });
      const priv = await Edx25519.keyCreateFromSeed(privSeed);
      const pub = await Edx25519.getPublic(priv);
      pubs.push(pub);
      privs.push(priv);
    }
    for (let i4 = numPrivs; i4 < numPubs; i4++) {
      const deriveSeed = await kdfKw({
        outputLength: 32,
        ikm: seed,
        info: stringToBytes("age-factor"),
        salt: bufferForUint32(i4)
      });
      const pub = await Edx25519.publicKeyDerive(PublishedAgeRestrictionBaseKey, deriveSeed);
      pubs.push(pub);
    }
    return {
      commitment: {
        mask: ageMask,
        publicKeys: pubs.map((x5) => encodeCrock(x5))
      },
      proof: {
        privateKeys: privs.map((x5) => encodeCrock(x5))
      }
    };
  }
  AgeRestriction2.restrictionCommitSeeded = restrictionCommitSeeded;
  async function commitCompare(c1, c22, salt) {
    if (c1.publicKeys.length != c22.publicKeys.length) {
      return false;
    }
    for (let i4 = 0; i4 < c1.publicKeys.length; i4++) {
      const k1 = decodeCrock(c1.publicKeys[i4]);
      const k22 = await Edx25519.publicKeyDerive(decodeCrock(c22.publicKeys[i4]), salt);
      if (k1 != k22) {
        return false;
      }
    }
    return true;
  }
  AgeRestriction2.commitCompare = commitCompare;
  async function commitmentDerive(commitmentProof, salt) {
    const newPrivs = [];
    const newPubs = [];
    for (const oldPub of commitmentProof.commitment.publicKeys) {
      newPubs.push(await Edx25519.publicKeyDerive(decodeCrock(oldPub), salt));
    }
    for (const oldPriv of commitmentProof.proof.privateKeys) {
      newPrivs.push(await Edx25519.privateKeyDerive(decodeCrock(oldPriv), salt));
    }
    return {
      commitment: {
        mask: commitmentProof.commitment.mask,
        publicKeys: newPubs.map((x5) => encodeCrock(x5))
      },
      proof: {
        privateKeys: newPrivs.map((x5) => encodeCrock(x5))
      }
    };
  }
  AgeRestriction2.commitmentDerive = commitmentDerive;
  function commitmentAttest(commitmentProof, age) {
    const d4 = buildSigPS(TalerSignaturePurpose.WALLET_AGE_ATTESTATION).put(bufferForUint32(commitmentProof.commitment.mask)).put(bufferForUint32(age)).build();
    const group = getAgeGroupIndex(commitmentProof.commitment.mask, age);
    if (group === 0) {
      return new Uint8Array(64);
    }
    const priv = commitmentProof.proof.privateKeys[group - 1];
    const pub = commitmentProof.commitment.publicKeys[group - 1];
    const sig = crypto_edx25519_sign_detached(d4, decodeCrock(priv), decodeCrock(pub));
    return sig;
  }
  AgeRestriction2.commitmentAttest = commitmentAttest;
  function commitmentVerify(commitment, sig, age) {
    const d4 = buildSigPS(TalerSignaturePurpose.WALLET_AGE_ATTESTATION).put(bufferForUint32(commitment.mask)).put(bufferForUint32(age)).build();
    const group = getAgeGroupIndex(commitment.mask, age);
    if (group === 0) {
      return true;
    }
    const pub = commitment.publicKeys[group - 1];
    return crypto_edx25519_sign_detached_verify(d4, decodeCrock(sig), decodeCrock(pub));
  }
  AgeRestriction2.commitmentVerify = commitmentVerify;
})(AgeRestriction || (AgeRestriction = {}));
async function deriveKey(keySeed, nonce, salt) {
  return kdfKw({
    outputLength: 32,
    salt: nonce,
    ikm: keySeed,
    info: stringToBytes(salt)
  });
}
async function encryptWithDerivedKey(nonce, keySeed, plaintext, salt) {
  const key = await deriveKey(keySeed, nonce, salt);
  const cipherText = secretbox(plaintext, nonce, key);
  return typedArrayConcat([nonce, cipherText]);
}
var ContractFormatTag;
(function(ContractFormatTag2) {
  ContractFormatTag2[ContractFormatTag2["PaymentOffer"] = 0] = "PaymentOffer";
  ContractFormatTag2[ContractFormatTag2["PaymentRequest"] = 1] = "PaymentRequest";
})(ContractFormatTag || (ContractFormatTag = {}));
function bufferFromAmount(amount) {
  const amountJ = Amounts.jsonifyAmount(amount);
  const buffer = new ArrayBuffer(8 + 4 + 12);
  const dvbuf = new DataView(buffer);
  const u8buf = new Uint8Array(buffer);
  const curr = stringToBytes(amountJ.currency);
  if (typeof dvbuf.setBigUint64 !== "undefined") {
    dvbuf.setBigUint64(0, BigInt(amountJ.value));
  } else {
    const arr = (0, import_big_integer.default)(amountJ.value).toArray(2 ** 8).value;
    let offset = 8 - arr.length;
    for (let i4 = 0; i4 < arr.length; i4++) {
      dvbuf.setUint8(offset++, arr[i4]);
    }
  }
  dvbuf.setUint32(8, amountJ.fraction);
  u8buf.set(curr, 8 + 4);
  return u8buf;
}
var foreverNum = 2n ** 64n - 1n;
function timestampRoundedToBuffer(ts) {
  const b4 = new ArrayBuffer(8);
  const v3 = new DataView(b4);
  const numVal = ts.t_s === "never" ? foreverNum : BigInt(ts.t_s) * 1000n * 1000n;
  if (typeof v3.setBigUint64 !== "undefined") {
    v3.setBigUint64(0, numVal);
  } else {
    const s4 = ts.t_s === "never" ? (0, import_big_integer.default)(foreverNum) : (0, import_big_integer.default)(ts.t_s).multiply(1e3 * 1e3);
    const arr = s4.toArray(2 ** 8).value;
    let offset = 8 - arr.length;
    for (let i4 = 0; i4 < arr.length; i4++) {
      v3.setUint8(offset++, arr[i4]);
    }
  }
  return new Uint8Array(b4);
}

// ../taler-util/lib/CancellationToken.js
var NOOP = () => {
};
var CancellationToken = class _CancellationToken {
  /**
   * Whether the token has been cancelled.
   */
  get isCancelled() {
    return this._isCancelled;
  }
  /**
   * Whether the token can be cancelled.
   */
  get canBeCancelled() {
    return this._canBeCancelled;
  }
  /**
   * Why this token has been cancelled.
   */
  get reason() {
    if (this.isCancelled) {
      return this._reason;
    } else {
      throw new Error("This token is not cancelled.");
    }
  }
  /**
   * Make a promise that resolves when the async operation resolves,
   * or rejects when the operation is rejected or this token is cancelled.
   */
  racePromise(asyncOperation) {
    if (!this.canBeCancelled) {
      return asyncOperation;
    }
    return new Promise((resolve, reject) => {
      const unregister = this.onCancelled((reason) => reject(new _CancellationToken.CancellationError(reason)));
      asyncOperation.then((value) => {
        resolve(value);
        unregister();
      }, (err) => {
        reject(err);
        unregister();
      });
    });
  }
  /**
   * Throw a {CancellationToken.CancellationError} if this token is cancelled.
   */
  throwIfCancelled() {
    if (this._isCancelled) {
      throw new _CancellationToken.CancellationError(this._reason);
    }
  }
  /**
   * Invoke the callback when this token is cancelled.
   * If this token is already cancelled, the callback is invoked immediately.
   * Returns a function that unregisters the cancellation callback.
   */
  onCancelled(cb) {
    if (!this.canBeCancelled) {
      return NOOP;
    }
    if (this.isCancelled) {
      cb(this.reason);
      return NOOP;
    }
    this._callbacks?.add(cb);
    return () => this._callbacks?.delete(cb);
  }
  constructor(_isCancelled, _canBeCancelled) {
    this._isCancelled = _isCancelled;
    this._canBeCancelled = _canBeCancelled;
    this._callbacks = /* @__PURE__ */ new Set();
  }
  /**
   * Create a {CancellationTokenSource}.
   */
  static create() {
    const token = new _CancellationToken(false, true);
    const cancel = (reason) => {
      if (token._isCancelled)
        return;
      token._isCancelled = true;
      token._reason = reason;
      token._callbacks?.forEach((cb) => cb(reason));
      dispose();
    };
    const dispose = () => {
      token._canBeCancelled = token.isCancelled;
      delete token._callbacks;
    };
    return { token, cancel, dispose };
  }
  /**
   * Create a {CancellationTokenSource}.
   * The token will be cancelled automatically after the specified timeout in milliseconds.
   */
  static timeout(ms) {
    const { token, cancel: originalCancel, dispose: originalDispose } = _CancellationToken.create();
    let timer2;
    timer2 = setTimeout(() => originalCancel(`CancellationToken.timeout ${ms}`), ms);
    const disposeTimer = () => {
      if (timer2 == null)
        return;
      clearTimeout(timer2);
      timer2 = null;
    };
    const cancel = (reason) => {
      disposeTimer();
      originalCancel(reason);
    };
    const dispose = () => {
      disposeTimer();
      originalDispose();
    };
    return { token, cancel, dispose };
  }
  /**
   * Create a {CancellationToken} that is cancelled when all of the given tokens are cancelled.
   *
   * This is like {Promise<T>.all} for {CancellationToken}s.
   */
  static all(...tokens) {
    if (tokens.some((token) => !token.canBeCancelled)) {
      return _CancellationToken.CONTINUE;
    }
    const combined = _CancellationToken.create();
    let countdown = tokens.length;
    const handleNextTokenCancelled = () => {
      if (--countdown === 0) {
        const reasons = tokens.map((token) => token._reason);
        combined.cancel(reasons);
      }
    };
    tokens.forEach((token) => token.onCancelled(handleNextTokenCancelled));
    return combined.token;
  }
  /**
   * Create a {CancellationToken} that is cancelled when at least one of the given tokens is cancelled.
   *
   * This is like {Promise<T>.race} for {CancellationToken}s.
   */
  static race(...tokens) {
    for (const token of tokens) {
      if (token._isCancelled) {
        return token;
      }
    }
    const combined = _CancellationToken.create();
    let unregistrations;
    const handleAnyTokenCancelled = (reason) => {
      unregistrations.forEach((unregister) => unregister());
      combined.cancel(reason);
    };
    unregistrations = tokens.map((token) => token.onCancelled(handleAnyTokenCancelled));
    return combined.token;
  }
};
CancellationToken.CANCELLED = new CancellationToken(true, true);
CancellationToken.CONTINUE = new CancellationToken(false, false);
(function(CancellationToken2) {
  class CancellationError extends Error {
    constructor(reason) {
      super("Operation cancelled");
      this.reason = reason;
      Object.setPrototypeOf(this, CancellationError.prototype);
    }
  }
  CancellationToken2.CancellationError = CancellationError;
})(CancellationToken || (CancellationToken = {}));

// ../taler-util/lib/errors.js
function makeErrorDetail(code, detail, hint) {
  if (!hint && !detail.hint) {
    hint = getDefaultTalerErrorHint(code);
  }
  const when = AbsoluteTime.now();
  return { code, when, hint, ...detail };
}
function getDefaultTalerErrorHint(code) {
  const errName = TalerErrorCode[code];
  if (errName) {
    return `Error (${errName})`;
  } else {
    return `Error (<unknown>)`;
  }
}
var TalerError = class _TalerError extends Error {
  constructor(d4, cause) {
    super(d4.hint ?? `Error (code ${d4.code})`);
    this.errorDetail = d4;
    this.cause = cause;
    Object.setPrototypeOf(this, _TalerError.prototype);
  }
  static fromDetail(code, detail, hint, cause) {
    if (!hint) {
      hint = getDefaultTalerErrorHint(code);
    }
    const when = AbsoluteTime.now();
    return new _TalerError({ code, when, hint, ...detail }, cause);
  }
  static fromUncheckedDetail(d4, c4) {
    return new _TalerError({ ...d4 }, c4);
  }
  static fromException(e4) {
    const errDetail = getErrorDetailFromException(e4);
    return new _TalerError(errDetail, e4);
  }
  hasErrorCode(code) {
    return this.errorDetail.code === code;
  }
  toString() {
    return `TalerError: ${JSON.stringify(this.errorDetail)}`;
  }
};
function getErrorDetailFromException(e4) {
  if (e4 instanceof TalerError) {
    return e4.errorDetail;
  }
  if (e4 instanceof CancellationToken.CancellationError) {
    const err2 = makeErrorDetail(TalerErrorCode.WALLET_CORE_REQUEST_CANCELLED, {});
    return err2;
  }
  if (e4 instanceof Error) {
    const err2 = makeErrorDetail(TalerErrorCode.WALLET_UNEXPECTED_EXCEPTION, {
      stack: e4.stack
    }, `unexpected exception (message: ${e4.message})`);
    return err2;
  }
  let excString;
  try {
    excString = e4.toString();
  } catch (e5) {
    excString = "can't stringify exception";
  }
  const err = makeErrorDetail(TalerErrorCode.WALLET_UNEXPECTED_EXCEPTION, {}, `unexpected exception (not an exception, ${excString})`);
  return err;
}
function assertUnreachable(x5) {
  throw new Error("Didn't expect to get here");
}

// ../taler-util/lib/types-taler-merchant.js
var MerchantContractVersion;
(function(MerchantContractVersion2) {
  MerchantContractVersion2[MerchantContractVersion2["V0"] = 0] = "V0";
  MerchantContractVersion2[MerchantContractVersion2["V1"] = 1] = "V1";
})(MerchantContractVersion || (MerchantContractVersion = {}));
var MerchantContractInputType;
(function(MerchantContractInputType2) {
  MerchantContractInputType2["Token"] = "token";
})(MerchantContractInputType || (MerchantContractInputType = {}));
var MerchantContractOutputType;
(function(MerchantContractOutputType2) {
  MerchantContractOutputType2["Token"] = "token";
  MerchantContractOutputType2["TaxReceipt"] = "tax-receipt";
})(MerchantContractOutputType || (MerchantContractOutputType = {}));
var MerchantContractTokenKind;
(function(MerchantContractTokenKind2) {
  MerchantContractTokenKind2["Subscription"] = "subscription";
  MerchantContractTokenKind2["Discount"] = "discount";
})(MerchantContractTokenKind || (MerchantContractTokenKind = {}));
var MerchantTanChannel;
(function(MerchantTanChannel2) {
  MerchantTanChannel2["SMS"] = "sms";
  MerchantTanChannel2["EMAIL"] = "email";
})(MerchantTanChannel || (MerchantTanChannel = {}));
var KycStatusLongPollingReason;
(function(KycStatusLongPollingReason2) {
  KycStatusLongPollingReason2[KycStatusLongPollingReason2["AUTH_TRANSFER"] = 1] = "AUTH_TRANSFER";
  KycStatusLongPollingReason2[KycStatusLongPollingReason2["AML_INVESTIGATION"] = 2] = "AML_INVESTIGATION";
  KycStatusLongPollingReason2[KycStatusLongPollingReason2["TO_BE_OK"] = 3] = "TO_BE_OK";
})(KycStatusLongPollingReason || (KycStatusLongPollingReason = {}));
var LoginTokenScope;
(function(LoginTokenScope2) {
  LoginTokenScope2["ReadOnly"] = "readonly";
  LoginTokenScope2["All"] = "all";
  LoginTokenScope2["OrderSimple"] = "order-simple";
  LoginTokenScope2["OrderPos"] = "order-pos";
  LoginTokenScope2["OrderManagement"] = "order-mgmt";
  LoginTokenScope2["OrderFull"] = "order-full";
  LoginTokenScope2["ReadOnly_Refreshable"] = "readonly:refreshable";
  LoginTokenScope2["All_Refreshable"] = "all:refreshable";
  LoginTokenScope2["OrderSimple_Refreshable"] = "order-simple:refreshable";
  LoginTokenScope2["OrderPos_Refreshable"] = "order-pos:refreshable";
  LoginTokenScope2["OrderManagement_Refreshable"] = "order-mgmt:refreshable";
  LoginTokenScope2["OrderFull_Refreshable"] = "order-full:refreshable";
})(LoginTokenScope || (LoginTokenScope = {}));
var MerchantAuthMethod;
(function(MerchantAuthMethod2) {
  MerchantAuthMethod2["TOKEN"] = "token";
})(MerchantAuthMethod || (MerchantAuthMethod = {}));
var MerchantAccountKycStatus;
(function(MerchantAccountKycStatus2) {
  MerchantAccountKycStatus2["NO_EXCHANGE_KEY"] = "no-exchange-keys";
  MerchantAccountKycStatus2["KYC_WIRE_IMPOSSIBLE"] = "kyc-wire-impossible";
  MerchantAccountKycStatus2["KYC_WIRE_REQUIRED"] = "kyc-wire-required";
  MerchantAccountKycStatus2["KYC_REQUIRED"] = "kyc-required";
  MerchantAccountKycStatus2["AWAITING_AML_REVIEW"] = "awaiting-aml-review";
  MerchantAccountKycStatus2["READY"] = "ready";
  MerchantAccountKycStatus2["LOGIC_BUG"] = "logic-bug";
  MerchantAccountKycStatus2["EXCHANGE_INTERNAL_ERROR"] = "exchange-internal-error";
  MerchantAccountKycStatus2["EXCHANGE_GATEWAY_TIMEOUT"] = "exchange-gateway-timeout";
  MerchantAccountKycStatus2["EXCHANGE_UNREACHABLE"] = "exchange-unreachable";
  MerchantAccountKycStatus2["EXCHANGE_STATUS_INVALID"] = "exchange-status-invalid";
})(MerchantAccountKycStatus || (MerchantAccountKycStatus = {}));
var MerchantAccountKycStatusSimplified;
(function(MerchantAccountKycStatusSimplified2) {
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["OK"] = 0] = "OK";
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["ACTION_REQUIRED"] = 100] = "ACTION_REQUIRED";
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["WARNING"] = 200] = "WARNING";
  MerchantAccountKycStatusSimplified2[MerchantAccountKycStatusSimplified2["ERROR"] = 300] = "ERROR";
})(MerchantAccountKycStatusSimplified || (MerchantAccountKycStatusSimplified = {}));
var TokenFamilyKind;
(function(TokenFamilyKind2) {
  TokenFamilyKind2["Discount"] = "discount";
  TokenFamilyKind2["Subscription"] = "subscription";
})(TokenFamilyKind || (TokenFamilyKind = {}));
var OrderInputType;
(function(OrderInputType2) {
  OrderInputType2["Token"] = "token";
})(OrderInputType || (OrderInputType = {}));
var OrderOutputType;
(function(OrderOutputType2) {
  OrderOutputType2["Token"] = "token";
  OrderOutputType2["TaxReceipt"] = "tax-receipt";
})(OrderOutputType || (OrderOutputType = {}));
var OrderVersion;
(function(OrderVersion2) {
  OrderVersion2[OrderVersion2["V0"] = 0] = "V0";
  OrderVersion2[OrderVersion2["V1"] = 1] = "V1";
})(OrderVersion || (OrderVersion = {}));
var codecForMerchantAuthMethod = codecForEither(codecForConstString(MerchantAuthMethod.TOKEN));
var codecForMerchantAccountKycStatus = codecForEither(codecForConstString(MerchantAccountKycStatus.AWAITING_AML_REVIEW), codecForConstString(MerchantAccountKycStatus.EXCHANGE_GATEWAY_TIMEOUT), codecForConstString(MerchantAccountKycStatus.EXCHANGE_INTERNAL_ERROR), codecForConstString(MerchantAccountKycStatus.EXCHANGE_STATUS_INVALID), codecForConstString(MerchantAccountKycStatus.EXCHANGE_UNREACHABLE), codecForConstString(MerchantAccountKycStatus.KYC_REQUIRED), codecForConstString(MerchantAccountKycStatus.KYC_WIRE_IMPOSSIBLE), codecForConstString(MerchantAccountKycStatus.KYC_WIRE_REQUIRED), codecForConstString(MerchantAccountKycStatus.LOGIC_BUG), codecForConstString(MerchantAccountKycStatus.NO_EXCHANGE_KEY), codecForConstString(MerchantAccountKycStatus.READY));
var codecForTokenScope = codecForEither(codecForConstString(LoginTokenScope.All), codecForConstString(LoginTokenScope.OrderFull), codecForConstString(LoginTokenScope.OrderManagement), codecForConstString(LoginTokenScope.OrderPos), codecForConstString(LoginTokenScope.OrderSimple), codecForConstString(LoginTokenScope.ReadOnly), codecForConstString(LoginTokenScope.All_Refreshable), codecForConstString(LoginTokenScope.OrderFull_Refreshable), codecForConstString(LoginTokenScope.OrderManagement_Refreshable), codecForConstString(LoginTokenScope.OrderPos_Refreshable), codecForConstString(LoginTokenScope.OrderSimple_Refreshable), codecForConstString(LoginTokenScope.ReadOnly_Refreshable));
var codecForTokenFamilyKind = codecForEither(codecForConstString(TokenFamilyKind.Discount), codecForConstString(TokenFamilyKind.Subscription));

// ../taler-util/lib/contract-terms.js
var logger5 = new Logger("contractTerms.ts");
var ContractTermsUtil;
(function(ContractTermsUtil2) {
  function forgetAllImpl(anyJson, path, pred) {
    const dup = JSON.parse(JSON.stringify(anyJson));
    if (Array.isArray(dup)) {
      for (let i4 = 0; i4 < dup.length; i4++) {
        dup[i4] = forgetAllImpl(dup[i4], [...path, `${i4}`], pred);
      }
    } else if (typeof dup === "object" && dup != null) {
      if (typeof dup.$forgettable === "object") {
        for (const x5 of Object.keys(dup.$forgettable)) {
          if (!pred([...path, x5])) {
            continue;
          }
          if (!dup.$forgotten) {
            dup.$forgotten = {};
          }
          if (!dup.$forgotten[x5]) {
            const membValCanon = stringToBytes(canonicalJson(scrub(dup[x5])) + "\0");
            const membSalt = stringToBytes(dup.$forgettable[x5] + "\0");
            const h3 = kdf(64, membValCanon, membSalt, new Uint8Array([]));
            dup.$forgotten[x5] = encodeCrock(h3);
          }
          delete dup[x5];
          delete dup.$forgettable[x5];
        }
        if (Object.keys(dup.$forgettable).length === 0) {
          delete dup.$forgettable;
        }
      }
      for (const x5 of Object.keys(dup)) {
        if (x5.startsWith("$")) {
          continue;
        }
        dup[x5] = forgetAllImpl(dup[x5], [...path, x5], pred);
      }
    }
    return dup;
  }
  ContractTermsUtil2.forgetAllImpl = forgetAllImpl;
  function scrub(anyJson) {
    return forgetAllImpl(anyJson, [], () => true);
  }
  ContractTermsUtil2.scrub = scrub;
  function forgetAll(anyJson, pred) {
    return forgetAllImpl(anyJson, [], pred);
  }
  ContractTermsUtil2.forgetAll = forgetAll;
  function saltForgettable(anyJson) {
    const dup = JSON.parse(JSON.stringify(anyJson));
    if (Array.isArray(dup)) {
      for (let i4 = 0; i4 < dup.length; i4++) {
        dup[i4] = saltForgettable(dup[i4]);
      }
    } else if (typeof dup === "object" && dup !== null) {
      if (typeof dup.$forgettable === "object") {
        for (const k5 of Object.keys(dup.$forgettable)) {
          if (dup.$forgettable[k5] === true) {
            dup.$forgettable[k5] = encodeCrock(getRandomBytes(32));
          }
        }
      }
      for (const x5 of Object.keys(dup)) {
        if (x5.startsWith("$")) {
          continue;
        }
        dup[x5] = saltForgettable(dup[x5]);
      }
    }
    return dup;
  }
  ContractTermsUtil2.saltForgettable = saltForgettable;
  const nameRegex = /^[0-9A-Za-z_]+$/;
  function validateForgettable(anyJson) {
    if (anyJson === void 0) {
      return true;
    }
    if (typeof anyJson === "string") {
      return true;
    }
    if (typeof anyJson === "number") {
      return Number.isInteger(anyJson) && anyJson >= Number.MIN_SAFE_INTEGER && anyJson <= Number.MAX_SAFE_INTEGER;
    }
    if (typeof anyJson === "boolean") {
      return true;
    }
    if (anyJson === null) {
      return true;
    }
    if (Array.isArray(anyJson)) {
      return anyJson.every((x5) => validateForgettable(x5));
    }
    if (typeof anyJson === "object") {
      for (const k5 of Object.keys(anyJson)) {
        if (k5.match(nameRegex)) {
          if (validateForgettable(anyJson[k5])) {
            continue;
          } else {
            return false;
          }
        }
        if (k5 === "$forgettable") {
          const fga = anyJson.$forgettable;
          if (!fga || typeof fga !== "object") {
            return false;
          }
          for (const fk of Object.keys(fga)) {
            if (!fk.match(nameRegex)) {
              return false;
            }
            if (!(fk in anyJson)) {
              return false;
            }
            const fv = anyJson.$forgettable[fk];
            if (typeof fv !== "string") {
              return false;
            }
          }
        } else if (k5 === "$forgotten") {
          const fgo = anyJson.$forgotten;
          if (!fgo || typeof fgo !== "object") {
            return false;
          }
          for (const fk of Object.keys(fgo)) {
            if (!fk.match(nameRegex)) {
              return false;
            }
            if (fk in anyJson) {
              return false;
            }
            const fv = anyJson.$forgotten[fk];
            if (typeof fv !== "string") {
              return false;
            }
            try {
              const decFv = decodeCrock(fv);
              if (decFv.length != 64) {
                return false;
              }
            } catch (e4) {
              return false;
            }
            if (anyJson.$forgettable?.[k5] !== void 0) {
              return false;
            }
          }
        } else {
          return false;
        }
      }
      return true;
    }
    return false;
  }
  ContractTermsUtil2.validateForgettable = validateForgettable;
  function validateNothingForgotten(contractTerms) {
    throw Error("not implemented yet");
  }
  ContractTermsUtil2.validateNothingForgotten = validateNothingForgotten;
  function validateParsed(contractTerms) {
    if (contractTerms.version === MerchantContractVersion.V1) {
      const regex = new RegExp("^(\\*\\.)?([\\w\\d]+\\.)+[\\w\\d]+$");
      for (const slug in contractTerms.token_families) {
        const family = contractTerms.token_families[slug];
        var domains = [];
        switch (family.details.class) {
          case MerchantContractTokenKind.Subscription:
            domains.push(...family.details.trusted_domains);
            break;
          case MerchantContractTokenKind.Discount:
            domains.push(...family.details.expected_domains);
            break;
          default:
            assertUnreachable(family.details);
        }
        for (const domain in domains) {
          if (domain !== "*" && !regex.test(domain)) {
            return false;
          }
        }
      }
    }
    return true;
  }
  ContractTermsUtil2.validateParsed = validateParsed;
  function hashContractTerms(contractTerms) {
    const cleaned = scrub(contractTerms);
    const canon = canonicalJson(cleaned) + "\0";
    const bytes = stringToBytes(canon);
    return encodeCrock(hash2(bytes));
  }
  ContractTermsUtil2.hashContractTerms = hashContractTerms;
  function extractAmounts(contractTerms, choiceIndex) {
    let amountRaw;
    let maxFee;
    switch (contractTerms.version) {
      case void 0:
      case MerchantContractVersion.V0:
        amountRaw = contractTerms.amount;
        maxFee = contractTerms.max_fee;
        break;
      case MerchantContractVersion.V1:
        if (choiceIndex === void 0) {
          logger5.trace("choice index not specified for contract v1");
          return {
            available: false,
            amountRaw: void 0,
            maxFee: void 0
          };
        }
        if (contractTerms.choices[choiceIndex] === void 0)
          throw Error(`invalid choice index ${choiceIndex}`);
        amountRaw = contractTerms.choices[choiceIndex].amount;
        maxFee = contractTerms.choices[choiceIndex].max_fee;
        break;
      default:
        assertUnreachable(contractTerms);
    }
    return {
      available: true,
      amountRaw,
      maxFee
    };
  }
  ContractTermsUtil2.extractAmounts = extractAmounts;
  function getV0CompatChoiceIndex(terms) {
    let firstGood = void 0;
    for (let i4 = 0; i4 < terms.choices.length; i4++) {
      if (terms.choices[i4].inputs.length == 0) {
        firstGood = i4;
        break;
      }
    }
    if (firstGood != null) {
      return firstGood;
    }
    return void 0;
  }
  ContractTermsUtil2.getV0CompatChoiceIndex = getV0CompatChoiceIndex;
  function downgradeContractTerms(terms) {
    if (terms.version == MerchantContractVersion.V0) {
      return terms;
    }
    if (terms.version !== MerchantContractVersion.V1) {
      return void 0;
    }
    const firstGood = getV0CompatChoiceIndex(terms);
    if (firstGood == null) {
      return void 0;
    }
    return {
      amount: terms.choices[firstGood].amount,
      exchanges: terms.exchanges,
      h_wire: terms.h_wire,
      max_fee: terms.choices[firstGood].max_fee,
      merchant: terms.merchant,
      merchant_base_url: terms.merchant_base_url,
      merchant_pub: terms.merchant_pub,
      nonce: terms.nonce,
      order_id: terms.order_id,
      pay_deadline: terms.pay_deadline,
      refund_deadline: terms.refund_deadline,
      summary: terms.summary,
      timestamp: terms.timestamp,
      wire_method: terms.wire_method,
      wire_transfer_deadline: terms.wire_transfer_deadline,
      auto_refund: terms.auto_refund,
      delivery_date: terms.delivery_date,
      delivery_location: terms.delivery_location,
      extra: terms.extra,
      fulfillment_message: terms.fulfillment_message,
      fulfillment_message_i18n: terms.fulfillment_message_i18n,
      fulfillment_url: terms.fulfillment_url,
      minimum_age: terms.minimum_age,
      products: terms.products,
      public_reorder_url: terms.public_reorder_url,
      summary_i18n: terms.summary_i18n,
      version: MerchantContractVersion.V0
    };
  }
  ContractTermsUtil2.downgradeContractTerms = downgradeContractTerms;
})(ContractTermsUtil || (ContractTermsUtil = {}));

// ../taler-util/lib/fnutils.js
var fnutil;
(function(fnutil2) {
  function all(arr, f3) {
    for (const x5 of arr) {
      if (!f3(x5)) {
        return false;
      }
    }
    return true;
  }
  fnutil2.all = all;
  function any(arr, f3) {
    for (const x5 of arr) {
      if (f3(x5)) {
        return true;
      }
    }
    return false;
  }
  fnutil2.any = any;
})(fnutil || (fnutil = {}));

// ../taler-util/lib/http-status-codes.js
var HttpStatusCode;
(function(HttpStatusCode2) {
  HttpStatusCode2[HttpStatusCode2["Continue"] = 100] = "Continue";
  HttpStatusCode2[HttpStatusCode2["SwitchingProtocols"] = 101] = "SwitchingProtocols";
  HttpStatusCode2[HttpStatusCode2["Processing"] = 102] = "Processing";
  HttpStatusCode2[HttpStatusCode2["Ok"] = 200] = "Ok";
  HttpStatusCode2[HttpStatusCode2["Created"] = 201] = "Created";
  HttpStatusCode2[HttpStatusCode2["Accepted"] = 202] = "Accepted";
  HttpStatusCode2[HttpStatusCode2["NonAuthoritativeInformation"] = 203] = "NonAuthoritativeInformation";
  HttpStatusCode2[HttpStatusCode2["NoContent"] = 204] = "NoContent";
  HttpStatusCode2[HttpStatusCode2["ResetContent"] = 205] = "ResetContent";
  HttpStatusCode2[HttpStatusCode2["PartialContent"] = 206] = "PartialContent";
  HttpStatusCode2[HttpStatusCode2["MultiStatus"] = 207] = "MultiStatus";
  HttpStatusCode2[HttpStatusCode2["AlreadyReported"] = 208] = "AlreadyReported";
  HttpStatusCode2[HttpStatusCode2["ImUsed"] = 226] = "ImUsed";
  HttpStatusCode2[HttpStatusCode2["MultipleChoices"] = 300] = "MultipleChoices";
  HttpStatusCode2[HttpStatusCode2["MovedPermanently"] = 301] = "MovedPermanently";
  HttpStatusCode2[HttpStatusCode2["Found"] = 302] = "Found";
  HttpStatusCode2[HttpStatusCode2["SeeOther"] = 303] = "SeeOther";
  HttpStatusCode2[HttpStatusCode2["NotModified"] = 304] = "NotModified";
  HttpStatusCode2[HttpStatusCode2["UseProxy"] = 305] = "UseProxy";
  HttpStatusCode2[HttpStatusCode2["SwitchProxy"] = 306] = "SwitchProxy";
  HttpStatusCode2[HttpStatusCode2["TemporaryRedirect"] = 307] = "TemporaryRedirect";
  HttpStatusCode2[HttpStatusCode2["PermanentRedirect"] = 308] = "PermanentRedirect";
  HttpStatusCode2[HttpStatusCode2["BadRequest"] = 400] = "BadRequest";
  HttpStatusCode2[HttpStatusCode2["Unauthorized"] = 401] = "Unauthorized";
  HttpStatusCode2[HttpStatusCode2["PaymentRequired"] = 402] = "PaymentRequired";
  HttpStatusCode2[HttpStatusCode2["Forbidden"] = 403] = "Forbidden";
  HttpStatusCode2[HttpStatusCode2["NotFound"] = 404] = "NotFound";
  HttpStatusCode2[HttpStatusCode2["MethodNotAllowed"] = 405] = "MethodNotAllowed";
  HttpStatusCode2[HttpStatusCode2["NotAcceptable"] = 406] = "NotAcceptable";
  HttpStatusCode2[HttpStatusCode2["ProxyAuthenticationRequired"] = 407] = "ProxyAuthenticationRequired";
  HttpStatusCode2[HttpStatusCode2["RequestTimeout"] = 408] = "RequestTimeout";
  HttpStatusCode2[HttpStatusCode2["Conflict"] = 409] = "Conflict";
  HttpStatusCode2[HttpStatusCode2["Gone"] = 410] = "Gone";
  HttpStatusCode2[HttpStatusCode2["LengthRequired"] = 411] = "LengthRequired";
  HttpStatusCode2[HttpStatusCode2["PreconditionFailed"] = 412] = "PreconditionFailed";
  HttpStatusCode2[HttpStatusCode2["PayloadTooLarge"] = 413] = "PayloadTooLarge";
  HttpStatusCode2[HttpStatusCode2["UriTooLong"] = 414] = "UriTooLong";
  HttpStatusCode2[HttpStatusCode2["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
  HttpStatusCode2[HttpStatusCode2["RangeNotSatisfiable"] = 416] = "RangeNotSatisfiable";
  HttpStatusCode2[HttpStatusCode2["ExpectationFailed"] = 417] = "ExpectationFailed";
  HttpStatusCode2[HttpStatusCode2["IAmATeapot"] = 418] = "IAmATeapot";
  HttpStatusCode2[HttpStatusCode2["MisdirectedRequest"] = 421] = "MisdirectedRequest";
  HttpStatusCode2[HttpStatusCode2["UnprocessableEntity"] = 422] = "UnprocessableEntity";
  HttpStatusCode2[HttpStatusCode2["Locked"] = 423] = "Locked";
  HttpStatusCode2[HttpStatusCode2["FailedDependency"] = 424] = "FailedDependency";
  HttpStatusCode2[HttpStatusCode2["TooEarly"] = 425] = "TooEarly";
  HttpStatusCode2[HttpStatusCode2["UpgradeRequired"] = 426] = "UpgradeRequired";
  HttpStatusCode2[HttpStatusCode2["PreconditionRequired"] = 428] = "PreconditionRequired";
  HttpStatusCode2[HttpStatusCode2["TooManyRequests"] = 429] = "TooManyRequests";
  HttpStatusCode2[HttpStatusCode2["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
  HttpStatusCode2[HttpStatusCode2["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
  HttpStatusCode2[HttpStatusCode2["InternalServerError"] = 500] = "InternalServerError";
  HttpStatusCode2[HttpStatusCode2["NotImplemented"] = 501] = "NotImplemented";
  HttpStatusCode2[HttpStatusCode2["BadGateway"] = 502] = "BadGateway";
  HttpStatusCode2[HttpStatusCode2["ServiceUnavailable"] = 503] = "ServiceUnavailable";
  HttpStatusCode2[HttpStatusCode2["GatewayTimeout"] = 504] = "GatewayTimeout";
  HttpStatusCode2[HttpStatusCode2["HttpVersionNotSupported"] = 505] = "HttpVersionNotSupported";
  HttpStatusCode2[HttpStatusCode2["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
  HttpStatusCode2[HttpStatusCode2["InsufficientStorage"] = 507] = "InsufficientStorage";
  HttpStatusCode2[HttpStatusCode2["LoopDetected"] = 508] = "LoopDetected";
  HttpStatusCode2[HttpStatusCode2["NotExtended"] = 510] = "NotExtended";
  HttpStatusCode2[HttpStatusCode2["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
})(HttpStatusCode || (HttpStatusCode = {}));

// ../taler-util/lib/libtool-version.js
var LibtoolVersion;
(function(LibtoolVersion2) {
  function compare2(me, other) {
    const meVer = parseVersion(me);
    const otherVer = parseVersion(other);
    if (!(meVer && otherVer)) {
      return void 0;
    }
    const compatible = meVer.current - meVer.age <= otherVer.current && meVer.current >= otherVer.current - otherVer.age;
    const currentCmp = Math.sign(meVer.current - otherVer.current);
    return { compatible, currentCmp };
  }
  LibtoolVersion2.compare = compare2;
  function parseVersionOrThrow(v3) {
    const res = parseVersion(v3);
    if (!res) {
      throw Error("invalid libtool version");
    }
    return res;
  }
  LibtoolVersion2.parseVersionOrThrow = parseVersionOrThrow;
  function parseVersion(v3) {
    const [currentStr, revisionStr, ageStr, ...rest] = v3.split(":");
    if (rest.length !== 0) {
      return void 0;
    }
    const current = Number.parseInt(currentStr);
    const revision = Number.parseInt(revisionStr);
    const age = Number.parseInt(ageStr);
    if (Number.isNaN(current)) {
      return void 0;
    }
    if (Number.isNaN(revision)) {
      return void 0;
    }
    if (Number.isNaN(age)) {
      return void 0;
    }
    return { current, revision, age };
  }
  LibtoolVersion2.parseVersion = parseVersion;
})(LibtoolVersion || (LibtoolVersion = {}));

// ../taler-util/lib/operation.js
async function opSuccessFromHttp(resp, codec) {
  const body = await readSuccessResponseJsonOrThrow(resp, codec);
  return { type: "ok", case: "ok", body };
}
function opFixedSuccess(body) {
  return { type: "ok", case: "ok", body };
}
function opEmptySuccess() {
  return { type: "ok", case: "ok", body: void 0 };
}
function opKnownFailure(case_) {
  return { type: "fail", case: case_ };
}
async function opKnownAlternativeHttpFailure(resp, s4, codec) {
  const body = await readResponseJsonOrThrow(resp, codec);
  return { type: "fail", case: s4, body };
}
async function opKnownHttpFailure(_case, resp, detail) {
  if (!detail) {
    detail = await readTalerErrorResponse(resp);
  }
  return { type: "fail", case: _case, detail };
}
async function opUnknownHttpFailure(resp, detail) {
  if (!detail) {
    detail = await readTalerErrorResponse(resp);
  }
  throw TalerError.fromDetail(TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR, {
    requestUrl: resp.requestUrl,
    requestMethod: resp.requestMethod,
    httpStatusCode: resp.status,
    errorResponse: detail
  }, `Unexpected HTTP status ${resp.status} in response`);
}
function opKnownTalerFailure(_case, detail) {
  return { type: "fail", case: _case, detail };
}
function opUnknownFailure(error2) {
  throw TalerError.fromException(error2);
}

// ../taler-util/lib/payto.js
function codecForPaytoString() {
  return {
    decode(x5, c4) {
      if (typeof x5 !== "string") {
        throw new DecodingError(`expected string at ${renderContext(c4)} but got ${typeof x5}`);
      }
      if (!x5.startsWith(paytoPfx)) {
        throw new DecodingError(`expected start with payto at ${renderContext(c4)} but got "${x5}"`);
      }
      return x5;
    }
  };
}
var paytoPfx = "payto://";

// ../taler-util/lib/types-taler-wallet.js
var ScopeType;
(function(ScopeType2) {
  ScopeType2["Global"] = "global";
  ScopeType2["Exchange"] = "exchange";
  ScopeType2["Auditor"] = "auditor";
})(ScopeType || (ScopeType = {}));
var TransactionAmountMode;
(function(TransactionAmountMode2) {
  TransactionAmountMode2["Effective"] = "effective";
  TransactionAmountMode2["Raw"] = "raw";
})(TransactionAmountMode || (TransactionAmountMode = {}));
var codecForConvertAmountRequest = buildCodecForObject().property("amount", codecForAmountString()).property("depositPaytoUri", codecForPaytoString()).property("type", codecForEither(codecForConstString(TransactionAmountMode.Raw), codecForConstString(TransactionAmountMode.Effective))).build("ConvertAmountRequest");
var BalanceFlag;
(function(BalanceFlag2) {
  BalanceFlag2["IncomingKyc"] = "incoming-kyc";
  BalanceFlag2["IncomingAml"] = "incoming-aml";
  BalanceFlag2["IncomingConfirmation"] = "incoming-confirmation";
  BalanceFlag2["OutgoingKyc"] = "outgoing-kyc";
})(BalanceFlag || (BalanceFlag = {}));
var CoinStatus;
(function(CoinStatus2) {
  CoinStatus2["Fresh"] = "fresh";
  CoinStatus2["DenomLoss"] = "denom-loss";
  CoinStatus2["FreshSuspended"] = "fresh-suspended";
  CoinStatus2["Dormant"] = "dormant";
})(CoinStatus || (CoinStatus = {}));
var ConfirmPayResultType;
(function(ConfirmPayResultType2) {
  ConfirmPayResultType2["Done"] = "done";
  ConfirmPayResultType2["Pending"] = "pending";
})(ConfirmPayResultType || (ConfirmPayResultType = {}));
var codecForTalerErrorDetail = () => buildCodecForObject().property("code", codecForNumber()).property("when", codecOptional(codecForAbsoluteTime)).property("hint", codecOptional(codecForString())).build("TalerErrorDetail");
var PreparePayResultType;
(function(PreparePayResultType2) {
  PreparePayResultType2["PaymentPossible"] = "payment-possible";
  PreparePayResultType2["InsufficientBalance"] = "insufficient-balance";
  PreparePayResultType2["AlreadyConfirmed"] = "already-confirmed";
  PreparePayResultType2["ChoiceSelection"] = "choice-selection";
})(PreparePayResultType || (PreparePayResultType = {}));
var InsufficientBalanceHint;
(function(InsufficientBalanceHint2) {
  InsufficientBalanceHint2["MerchantAcceptInsufficient"] = "merchant-accept-insufficient";
  InsufficientBalanceHint2["MerchantDepositInsufficient"] = "merchant-deposit-insufficient";
  InsufficientBalanceHint2["AgeRestricted"] = "age-restricted";
  InsufficientBalanceHint2["WalletBalanceMaterialInsufficient"] = "wallet-balance-material-insufficient";
  InsufficientBalanceHint2["WalletBalanceAvailableInsufficient"] = "wallet-balance-available-insufficient";
  InsufficientBalanceHint2["ExchangeMissingGlobalFees"] = "exchange-missing-global-fees";
  InsufficientBalanceHint2["FeesNotCovered"] = "fees-not-covered";
})(InsufficientBalanceHint || (InsufficientBalanceHint = {}));
var TokenAvailabilityHint;
(function(TokenAvailabilityHint2) {
  TokenAvailabilityHint2["WalletTokensAvailableInsufficient"] = "wallet-tokens-available-insufficient";
  TokenAvailabilityHint2["MerchantUnexpected"] = "merchant-unexpected";
  TokenAvailabilityHint2["MerchantUntrusted"] = "merchant-untrusted";
})(TokenAvailabilityHint || (TokenAvailabilityHint = {}));
var RefreshReason;
(function(RefreshReason2) {
  RefreshReason2["Manual"] = "manual";
  RefreshReason2["PayMerchant"] = "pay-merchant";
  RefreshReason2["PayDeposit"] = "pay-deposit";
  RefreshReason2["PayPeerPush"] = "pay-peer-push";
  RefreshReason2["PayPeerPull"] = "pay-peer-pull";
  RefreshReason2["Refund"] = "refund";
  RefreshReason2["AbortPay"] = "abort-pay";
  RefreshReason2["AbortDeposit"] = "abort-deposit";
  RefreshReason2["AbortPeerPushDebit"] = "abort-peer-push-debit";
  RefreshReason2["AbortPeerPullDebit"] = "abort-peer-pull-debit";
  RefreshReason2["Recoup"] = "recoup";
  RefreshReason2["BackupRestored"] = "backup-restored";
  RefreshReason2["Scheduled"] = "scheduled";
})(RefreshReason || (RefreshReason = {}));
var ExchangeTosStatus;
(function(ExchangeTosStatus2) {
  ExchangeTosStatus2["Pending"] = "pending";
  ExchangeTosStatus2["Proposed"] = "proposed";
  ExchangeTosStatus2["Accepted"] = "accepted";
  ExchangeTosStatus2["MissingTos"] = "missing-tos";
})(ExchangeTosStatus || (ExchangeTosStatus = {}));
var ExchangeEntryStatus;
(function(ExchangeEntryStatus2) {
  ExchangeEntryStatus2["Preset"] = "preset";
  ExchangeEntryStatus2["Ephemeral"] = "ephemeral";
  ExchangeEntryStatus2["Used"] = "used";
})(ExchangeEntryStatus || (ExchangeEntryStatus = {}));
var ExchangeUpdateStatus;
(function(ExchangeUpdateStatus2) {
  ExchangeUpdateStatus2["Initial"] = "initial";
  ExchangeUpdateStatus2["InitialUpdate"] = "initial-update";
  ExchangeUpdateStatus2["Suspended"] = "suspended";
  ExchangeUpdateStatus2["UnavailableUpdate"] = "unavailable-update";
  ExchangeUpdateStatus2["Ready"] = "ready";
  ExchangeUpdateStatus2["ReadyUpdate"] = "ready-update";
  ExchangeUpdateStatus2["OutdatedUpdate"] = "outdated-update";
})(ExchangeUpdateStatus || (ExchangeUpdateStatus = {}));
var ExchangeWalletKycStatus;
(function(ExchangeWalletKycStatus2) {
  ExchangeWalletKycStatus2["Done"] = "done";
  ExchangeWalletKycStatus2["LegiInit"] = "legi-init";
  ExchangeWalletKycStatus2["Legi"] = "legi";
})(ExchangeWalletKycStatus || (ExchangeWalletKycStatus = {}));
var ChoiceSelectionDetailType;
(function(ChoiceSelectionDetailType2) {
  ChoiceSelectionDetailType2["PaymentPossible"] = "payment-possible";
  ChoiceSelectionDetailType2["InsufficientBalance"] = "insufficient-balance";
})(ChoiceSelectionDetailType || (ChoiceSelectionDetailType = {}));
var RecoveryMergeStrategy;
(function(RecoveryMergeStrategy2) {
  RecoveryMergeStrategy2["Ours"] = "ours";
  RecoveryMergeStrategy2["Theirs"] = "theirs";
})(RecoveryMergeStrategy || (RecoveryMergeStrategy = {}));
var AttentionPriority;
(function(AttentionPriority2) {
  AttentionPriority2["High"] = "high";
  AttentionPriority2["Medium"] = "medium";
  AttentionPriority2["Low"] = "low";
})(AttentionPriority || (AttentionPriority = {}));
var AttentionType;
(function(AttentionType2) {
  AttentionType2["KycWithdrawal"] = "kyc-withdrawal";
  AttentionType2["BackupUnpaid"] = "backup-unpaid";
  AttentionType2["BackupExpiresSoon"] = "backup-expires-soon";
  AttentionType2["MerchantRefund"] = "merchant-refund";
  AttentionType2["ExchangeTosChanged"] = "exchange-tos-changed";
  AttentionType2["ExchangeKeyExpired"] = "exchange-key-expired";
  AttentionType2["ExchangeKeyExpiresSoon"] = "exchange-key-expires-soon";
  AttentionType2["ExchangeDenominationsExpired"] = "exchange-denominations-expired";
  AttentionType2["ExchangeDenominationsExpiresSoon"] = "exchange-denominations-expires-soon";
  AttentionType2["AuditorTosChanged"] = "auditor-tos-changed";
  AttentionType2["AuditorKeyExpires"] = "auditor-key-expires";
  AttentionType2["AuditorDenominationsExpires"] = "auditor-denominations-expires";
  AttentionType2["PullPaymentPaid"] = "pull-payment-paid";
  AttentionType2["PushPaymentReceived"] = "push-payment-withdrawn";
})(AttentionType || (AttentionType = {}));
var UserAttentionPriority = {
  "kyc-withdrawal": AttentionPriority.Medium,
  "backup-unpaid": AttentionPriority.High,
  "backup-expires-soon": AttentionPriority.Medium,
  "merchant-refund": AttentionPriority.Medium,
  "exchange-tos-changed": AttentionPriority.Medium,
  "exchange-key-expired": AttentionPriority.High,
  "exchange-key-expires-soon": AttentionPriority.Medium,
  "exchange-denominations-expired": AttentionPriority.High,
  "exchange-denominations-expires-soon": AttentionPriority.Medium,
  "auditor-tos-changed": AttentionPriority.Medium,
  "auditor-key-expires": AttentionPriority.Medium,
  "auditor-denominations-expires": AttentionPriority.Medium,
  "pull-payment-paid": AttentionPriority.High,
  "push-payment-withdrawn": AttentionPriority.High
};
var ProviderPaymentType;
(function(ProviderPaymentType2) {
  ProviderPaymentType2["Unpaid"] = "unpaid";
  ProviderPaymentType2["Pending"] = "pending";
  ProviderPaymentType2["InsufficientBalance"] = "insufficient-balance";
  ProviderPaymentType2["Paid"] = "paid";
  ProviderPaymentType2["TermsChanged"] = "terms-changed";
})(ProviderPaymentType || (ProviderPaymentType = {}));
var codecForEmptyObject = () => buildCodecForObject().build("EmptyObject");

// ../taler-util/lib/http-client/utils.js
function addPaginationParams(url, pagination) {
  if (!pagination)
    return;
  if (pagination.offset) {
    url.searchParams.set("offset", pagination.offset);
  }
  const order = !pagination || pagination.order === "asc" ? 1 : -1;
  const limit = !pagination || !pagination.limit || pagination.limit === 0 ? 5 : Math.abs(pagination.limit);
  url.searchParams.set("limit", String(order * limit));
}
function addLongPollingParam(url, param) {
  if (!param)
    return;
  if (param.timeoutMs) {
    url.searchParams.set("timeout_ms", String(param.timeoutMs));
  }
}
var nullEvictor = {
  notifySuccess: () => Promise.resolve()
};

// ../taler-util/lib/http-client/bank-conversion.js
var TalerBankConversionCacheEviction;
(function(TalerBankConversionCacheEviction3) {
  TalerBankConversionCacheEviction3[TalerBankConversionCacheEviction3["UPDATE_RATE"] = 0] = "UPDATE_RATE";
})(TalerBankConversionCacheEviction || (TalerBankConversionCacheEviction = {}));

// ../taler-util/lib/types-taler-corebank.js
var MonitorTimeframeParam;
(function(MonitorTimeframeParam2) {
  MonitorTimeframeParam2[MonitorTimeframeParam2["hour"] = 0] = "hour";
  MonitorTimeframeParam2[MonitorTimeframeParam2["day"] = 1] = "day";
  MonitorTimeframeParam2[MonitorTimeframeParam2["month"] = 2] = "month";
  MonitorTimeframeParam2[MonitorTimeframeParam2["year"] = 3] = "year";
  MonitorTimeframeParam2[MonitorTimeframeParam2["decade"] = 4] = "decade";
})(MonitorTimeframeParam || (MonitorTimeframeParam = {}));
var TanChannel;
(function(TanChannel2) {
  TanChannel2["SMS"] = "sms";
  TanChannel2["EMAIL"] = "email";
})(TanChannel || (TanChannel = {}));
var codecForIntegrationBankConfig = () => buildCodecForObject().property("name", codecForConstString("taler-bank-integration")).property("version", codecForString()).property("currency", codecForString()).property("currency_specification", codecForCurrencySpecificiation()).property("implementation", codecOptional(codecForString())).build("TalerCorebankApi.IntegrationConfig");

// ../taler-util/lib/http-client/bank-core.js
var TalerCoreBankCacheEviction;
(function(TalerCoreBankCacheEviction3) {
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["DELETE_ACCOUNT"] = 0] = "DELETE_ACCOUNT";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["CREATE_ACCOUNT"] = 1] = "CREATE_ACCOUNT";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["UPDATE_ACCOUNT"] = 2] = "UPDATE_ACCOUNT";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["UPDATE_PASSWORD"] = 3] = "UPDATE_PASSWORD";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["CREATE_TRANSACTION"] = 4] = "CREATE_TRANSACTION";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["CONFIRM_WITHDRAWAL"] = 5] = "CONFIRM_WITHDRAWAL";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["ABORT_WITHDRAWAL"] = 6] = "ABORT_WITHDRAWAL";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["CREATE_WITHDRAWAL"] = 7] = "CREATE_WITHDRAWAL";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["CREATE_CASHOUT"] = 8] = "CREATE_CASHOUT";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["CREATE_CONVERSION_RATE_CLASS"] = 9] = "CREATE_CONVERSION_RATE_CLASS";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["UPDATE_CONVERSION_RATE_CLASS"] = 10] = "UPDATE_CONVERSION_RATE_CLASS";
  TalerCoreBankCacheEviction3[TalerCoreBankCacheEviction3["DELETE_CONVERSION_RATE_CLASS"] = 11] = "DELETE_CONVERSION_RATE_CLASS";
})(TalerCoreBankCacheEviction || (TalerCoreBankCacheEviction = {}));

// ../taler-util/lib/types-taler-bank-integration.js
var codecForBankWithdrawalOperationStatus = () => buildCodecForObject().property("status", codecForEither(codecForConstString("pending"), codecForConstString("selected"), codecForConstString("aborted"), codecForConstString("confirmed"))).property("currency", codecOptional(codecForCurrencyName())).property("amount", codecOptional(codecForAmountString())).property("suggested_amount", codecOptional(codecForAmountString())).property("min_amount", codecOptional(codecForAmountString())).property("max_amount", codecOptional(codecForAmountString())).property("card_fees", codecOptional(codecForAmountString())).property("sender_wire", codecOptional(codecForPaytoString())).property("suggested_exchange", codecOptional(codecForURLString())).property("required_exchange", codecOptional(codecForURLString())).property("confirm_transfer_url", codecOptional(codecForURLString())).property("wire_types", codecForList(codecForString())).property("selected_reserve_pub", codecOptional(codecForString())).property("selected_exchange_account", codecOptional(codecForString())).property("no_amount_to_wallet", codecOptional(codecForBoolean())).deprecatedProperty("aborted").deprecatedProperty("selection_done").deprecatedProperty("transfer_done").build("TalerBankIntegrationApi.BankWithdrawalOperationStatus");
var codecForBankWithdrawalOperationPostResponse = () => buildCodecForObject().property("status", codecForEither(codecForConstString("selected"), codecForConstString("aborted"), codecForConstString("confirmed"))).property("confirm_transfer_url", codecOptional(codecForURLString())).deprecatedProperty("transfer_done").build("TalerBankIntegrationApi.BankWithdrawalOperationPostResponse");

// ../taler-util/lib/http-client/bank-integration.js
var logger6 = new Logger("bank-integration.ts");
var TalerBankIntegrationHttpClient = class _TalerBankIntegrationHttpClient {
  constructor(baseUrl, httpClient) {
    this.baseUrl = baseUrl;
    this.PROTOCOL_VERSION = _TalerBankIntegrationHttpClient.PROTOCOL_VERSION;
    this.httpLib = httpClient ?? createPlatformHttpLib();
  }
  isCompatible(version) {
    const compare2 = LibtoolVersion.compare(this.PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  /**
   * https://docs.taler.net/core/api-bank-integration.html#get--config
   *
   */
  async getConfig() {
    const url = new URL(`config`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForIntegrationBankConfig());
      default:
        logger6.warn(`config request failed, status ${resp.status}`);
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-integration.html#get--withdrawal-operation-$WITHDRAWAL_ID
   *
   */
  async getWithdrawalOperationById(woid, params) {
    const url = new URL(`withdrawal-operation/${woid}`, this.baseUrl);
    addLongPollingParam(url, params);
    if (params) {
      url.searchParams.set("old_state", !params.old_state ? "pending" : params.old_state);
    }
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET"
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankWithdrawalOperationStatus());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * FIXME: This is a misnomer!
   *
   * https://docs.taler.net/core/api-bank-integration.html#post-$BANK_API_BASE_URL-withdrawal-operation-$wopid
   */
  async completeWithdrawalOperationById(woid, body) {
    const url = new URL(`withdrawal-operation/${woid}`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForBankWithdrawalOperationPostResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict: {
        const body2 = await readTalerErrorResponse(resp);
        const details = codecForTalerErrorDetail().decode(body2);
        switch (details.code) {
          case TalerErrorCode.BANK_WITHDRAWAL_OPERATION_RESERVE_SELECTION_CONFLICT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_DUPLICATE_RESERVE_PUB_SUBJECT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNKNOWN_ACCOUNT:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_ACCOUNT_IS_NOT_EXCHANGE:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_AMOUNT_DIFFERS:
            return opKnownTalerFailure(details.code, details);
          case TalerErrorCode.BANK_UNALLOWED_DEBIT:
            return opKnownTalerFailure(details.code, details);
          default:
            return opUnknownHttpFailure(resp, details);
        }
      }
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-bank-integration.html#post-$BANK_API_BASE_URL-withdrawal-operation-$wopid
   *
   */
  async abortWithdrawalOperationById(woid) {
    const url = new URL(`withdrawal-operation/${woid}/abort`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST"
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
TalerBankIntegrationHttpClient.PROTOCOL_VERSION = "2:0:1";

// ../taler-util/lib/http-client/challenger.js
var ChallengerCacheEviction;
(function(ChallengerCacheEviction3) {
  ChallengerCacheEviction3[ChallengerCacheEviction3["CREATE_CHALLENGE"] = 0] = "CREATE_CHALLENGE";
  ChallengerCacheEviction3[ChallengerCacheEviction3["SOLVE_CHALLENGE"] = 1] = "SOLVE_CHALLENGE";
})(ChallengerCacheEviction || (ChallengerCacheEviction = {}));

// ../taler-util/lib/http-client/exchange-client.js
var TalerExchangeCacheEviction;
(function(TalerExchangeCacheEviction3) {
  TalerExchangeCacheEviction3[TalerExchangeCacheEviction3["UPLOAD_KYC_FORM"] = 0] = "UPLOAD_KYC_FORM";
  TalerExchangeCacheEviction3[TalerExchangeCacheEviction3["MAKE_AML_DECISION"] = 1] = "MAKE_AML_DECISION";
})(TalerExchangeCacheEviction || (TalerExchangeCacheEviction = {}));
var TalerExchangeHttpClient = class _TalerExchangeHttpClient {
  constructor(baseUrl, params = {}) {
    this.baseUrl = baseUrl;
    this.httpLib = params.httpClient ?? createPlatformHttpLib();
    this.cacheEvictor = params.cacheEvictor ?? nullEvictor;
    this.preventCompression = !!params.preventCompression;
    this.cancelationToken = params.cancelationToken ?? CancellationToken.CONTINUE;
    this.longPollQueue = params.longPollQueue ?? new LongpollQueue();
  }
  isCompatible(version) {
    const compare2 = LibtoolVersion.compare(_TalerExchangeHttpClient.SUPPORTED_EXCHANGE_PROTOCOL_VERSION, version);
    return compare2?.compatible ?? false;
  }
  async fetch(url_or_path, opts = {}, longpoll = false) {
    const url = typeof url_or_path == "string" ? new URL(url_or_path, this.baseUrl) : url_or_path;
    if (longpoll || url.searchParams.has("timeout_ms")) {
      return this.longPollQueue.run(url, this.cancelationToken, async (timeoutMs) => {
        url.searchParams.set("timeout_ms", String(timeoutMs));
        return this.httpLib.fetch(url.href, {
          cancellationToken: this.cancelationToken,
          ...opts
        });
      });
    } else {
      return this.httpLib.fetch(url.href, {
        cancellationToken: this.cancelationToken,
        ...opts
      });
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--seed
   *
   */
  async getSeed() {
    const resp = await this.fetch("seed");
    switch (resp.status) {
      case HttpStatusCode.Ok:
        const buffer = await resp.bytes();
        const uintar = new Uint8Array(buffer);
        return opFixedSuccess(uintar);
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--config
   *
   */
  async getConfig() {
    const resp = await this.fetch("config");
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        const minBody = await readSuccessResponseJsonOrThrow(resp, codecForTalerCommonConfigResponse());
        const expectedName = "taler-exchange";
        if (minBody.name !== expectedName) {
          throw TalerError.fromUncheckedDetail({
            code: TalerErrorCode.GENERIC_UNEXPECTED_REQUEST_ERROR,
            requestUrl: resp.requestUrl,
            httpStatusCode: resp.status,
            detail: `Unexpected server component name (got ${minBody.name}, expected ${expectedName}})`
          });
        }
        if (!this.isCompatible(minBody.version)) {
          throw TalerError.fromUncheckedDetail({
            code: TalerErrorCode.GENERIC_CLIENT_UNSUPPORTED_PROTOCOL_VERSION,
            requestUrl: resp.requestUrl,
            httpStatusCode: resp.status,
            detail: `Unsupported protocol version, client supports ${_TalerExchangeHttpClient.SUPPORTED_EXCHANGE_PROTOCOL_VERSION}, server supports ${minBody.version}`
          });
        }
        const body = await readSuccessResponseJsonOrThrow(resp, codecForExchangeConfig());
        return opFixedSuccess(body);
      }
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-merchant.html#get--config
   *
   * PARTIALLY IMPLEMENTED!!
   */
  async getKeys() {
    const resp = await this.fetch("keys");
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeKeysResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // WALLET TO WALLET
  /**
   * https://docs.taler.net/core/api-exchange.html#get--purses-$PURSE_PUB-merge
   *
   */
  async getPurseStatusAtMerge(pursePub, longpoll = false) {
    const resp = await this.fetch(`purses/${pursePub}/merge`, {}, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangePurseStatus());
      case HttpStatusCode.Gone:
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--purses-$PURSE_PUB-deposit
   *
   */
  async getPurseStatusAtDeposit(pursePub, longpoll = false) {
    const resp = await this.fetch(`purses/${pursePub}/deposit`, {}, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangePurseStatus());
      case HttpStatusCode.Gone:
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--purses-$PURSE_PUB-create
   *
   */
  async createPurseFromDeposit(pursePub, body) {
    const resp = await this.fetch(`purses/${pursePub}/create`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.Conflict:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPurseConflict());
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.TooEarly:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#delete--purses-$PURSE_PUB
   *
   */
  async deletePurse(pursePub, purseSig) {
    const resp = await this.fetch(`purses/${pursePub}`, {
      method: "DELETE",
      headers: {
        "taler-purse-signature": purseSig
      }
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * POST /purses/$PURSE_PUB/merge
   *
   * https://docs.taler.net/core/api-exchange.html#post--purses-$PURSE_PUB-merge
   */
  async postPurseMerge(pursePub, body) {
    const resp = await this.fetch(`purses/${pursePub}/merge`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeMergeSuccessResponse());
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForLegitimizationNeededResponse());
      case HttpStatusCode.Conflict:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForExchangeMergeConflictResponse());
      case HttpStatusCode.Gone:
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--reserves-$RESERVE_PUB-purse
   *
   */
  async createPurseFromReserve(pursePub, body) {
    const resp = await this.fetch(`reserves/${pursePub}/purse`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.PaymentRequired:
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.Conflict:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPurseConflictPartial());
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForLegitimizationNeededResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--contracts-$CONTRACT_PUB
   *
   */
  async getContract(pursePub) {
    const resp = await this.fetch(`contracts/${pursePub}`);
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeGetContractResponse());
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--purses-$PURSE_PUB-deposit
   *
   */
  async depositIntoPurse(pursePub, body) {
    const resp = await this.fetch(`purses/${pursePub}/deposit`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAny());
      case HttpStatusCode.Conflict:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForPurseConflict());
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Gone:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  // WADS
  /**
   * https://docs.taler.net/core/api-exchange.html#get--wads-$WAD_ID
   *
   */
  async getWadInfo() {
    throw Error("not yet implemented");
  }
  //
  // KYC
  //
  /**
   * https://docs.taler.net/core/api-exchange.html#post--kyc-wallet
   *
   */
  async notifyKycBalanceLimit(body) {
    const url = new URL(`kyc-wallet`, this.baseUrl);
    const resp = await this.httpLib.fetch(url.href, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAmlWalletKycCheckResponse());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.UnavailableForLegalReasons:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForLegitimizationNeededResponse());
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--kyc-check-$H_NORMALIZED_PAYTO
   *
   */
  async checkKycStatus(args) {
    const { paytoHash, accountPub, accountSig, longpoll, awaitAuth } = args;
    const url = new URL(`kyc-check/${paytoHash}`, this.baseUrl);
    if (awaitAuth !== void 0) {
      url.searchParams.set("await_auth", awaitAuth ? "YES" : "NO");
    }
    const resp = await this.fetch(url, {
      headers: {
        "Account-Owner-Signature": accountSig,
        "Account-Owner-Pub": accountPub
      }
    }, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForAccountKycStatus());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * Do a /kyc-check request, but don't specify
   * the account pub explicitly.
   *
   * Deprecated, but used in tests.
   */
  async testingCheckKycStatusNoPub(args) {
    const { paytoHash, accountSig, longpoll, awaitAuth } = args;
    const url = new URL(`kyc-check/${paytoHash}`, this.baseUrl);
    if (awaitAuth !== void 0) {
      url.searchParams.set("await_auth", awaitAuth ? "YES" : "NO");
    }
    const resp = await this.fetch(url, {
      headers: {
        "Account-Owner-Signature": accountSig
      }
    }, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
      case HttpStatusCode.Accepted:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForAccountKycStatus());
      case HttpStatusCode.NoContent:
        return opEmptySuccess();
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--kyc-info-$ACCESS_TOKEN
   *
   */
  async checkKycInfo(token, known = [], longpoll = false) {
    const resp = await this.fetch(`kyc-info/${token}`, {
      method: "GET",
      headers: {
        "If-None-Match": known.length ? known.join(",") : void 0
      }
    }, longpoll);
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForKycProcessClientInformation());
      case HttpStatusCode.Accepted:
      case HttpStatusCode.NoContent:
        return opKnownAlternativeHttpFailure(resp, resp.status, codecForEmptyObject());
      case HttpStatusCode.NotModified:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * SPA-Specific version of checkKycInfo
   */
  async checkKycInfoSpa(token, etag, params = {}) {
    const url = new URL(`kyc-info/${token}`, this.baseUrl);
    addLongPollingParam(url, params);
    const resp = await this.httpLib.fetch(url.href, {
      method: "GET",
      headers: {
        "If-None-Match": etag
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok: {
        const etag2 = resp.headers.get("etag") ?? void 0;
        const body = await readSuccessResponseJsonOrThrow(resp, codecForKycProcessClientInformation());
        return opFixedSuccess({
          ...body,
          etag: etag2
        });
      }
      case HttpStatusCode.Accepted:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NoContent:
        return opKnownHttpFailure(resp.status, resp);
      case HttpStatusCode.NotModified:
        return opKnownFailure(resp.status);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--kyc-upload-$ID
   *
   */
  async uploadKycForm(requirement, body) {
    const resp = await this.fetch(`kyc-upload/${requirement}`, {
      method: "POST",
      body,
      compress: this.preventCompression ? void 0 : "deflate"
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerExchangeCacheEviction.UPLOAD_KYC_FORM);
        return opEmptySuccess();
      }
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
      case HttpStatusCode.PayloadTooLarge:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--kyc-start-$ID
   *
   */
  async startExternalKycProcess(requirement, body = {}) {
    const resp = await this.fetch(`kyc-start/${requirement}`, {
      method: "POST",
      body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForKycProcessStartInformation());
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
      case HttpStatusCode.PayloadTooLarge:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--kyc-proof-$PROVIDER_NAME?state=$H_PAYTO
   *
   */
  async completeExternalKycProcess(provider, state, code) {
    const resp = await this.fetch(`kyc-proof/${provider}?state=${state}&code=${code}`, {
      method: "GET",
      redirect: "manual"
    });
    switch (resp.status) {
      case HttpStatusCode.SeeOther:
        return opEmptySuccess();
      case HttpStatusCode.NotFound:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  //
  // AML operations
  //
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-measures
   *
   */
  async getAmlMeasures(auth) {
    const resp = await this.fetch(`aml/${auth.id}/measures`, {
      method: "GET",
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAvailableMeasureSummary());
      case HttpStatusCode.Conflict:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-kyc-statistics-$NAMES
   *
   */
  async getAmlKycStatistics(auth, names2, filter = {}) {
    const url = new URL(`aml/${auth.id}/kyc-statistics/${names2.join(" ")}`, this.baseUrl);
    if (filter.since !== void 0 && filter.since.t_ms !== "never") {
      url.searchParams.set("start_date", String(filter.since.t_ms));
    }
    if (filter.until !== void 0 && filter.until.t_ms !== "never") {
      url.searchParams.set("end_date", String(filter.until.t_ms));
    }
    const resp = await this.fetch(url, {
      method: "GET",
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAmlStatisticsResponse());
      case HttpStatusCode.Conflict:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-decisions
   *
   */
  async getAmlDecisions(auth, params = {}) {
    const url = new URL(`aml/${auth.id}/decisions`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.account !== void 0) {
      url.searchParams.set("h_payto", params.account);
    }
    if (params.active !== void 0) {
      url.searchParams.set("active", params.active ? "YES" : "NO");
    }
    if (params.investigation !== void 0) {
      url.searchParams.set("investigation", params.investigation ? "YES" : "NO");
    }
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAmlDecisionsResponse());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ records: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-legitimizations
   */
  async getAmlLegitimizations(officer, params = {}) {
    const url = new URL(`aml/${officer.id}/legitimizations`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.account !== void 0) {
      url.searchParams.set("h_payto", params.account);
    }
    if (params.active !== void 0) {
      url.searchParams.set("active", params.active ? "YES" : "NO");
    }
    const resp = await this.httpLib.fetch(url.href, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(officer.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForLegitimizationMeasuresList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({
          measures: []
        });
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-attributes-$H_PAYTO
   *
   */
  async getAmlAttributesForAccount(auth, account, params = {}) {
    const url = new URL(`aml/${auth.id}/attributes/${account}`, this.baseUrl);
    addPaginationParams(url, params);
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForAmlKycAttributes());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ details: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#post--aml-$OFFICER_PUB-decision
   *
   */
  async makeAmlDesicion(auth, decision) {
    const body = {
      officer_sig: encodeCrock(signAmlDecision(auth.signingKey, decision)),
      ...decision
    };
    const resp = await this.fetch(`aml/${auth.id}/decision`, {
      method: "POST",
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      },
      body,
      compress: this.preventCompression ? void 0 : "deflate"
    });
    switch (resp.status) {
      case HttpStatusCode.NoContent: {
        this.cacheEvictor.notifySuccess(TalerExchangeCacheEviction.MAKE_AML_DECISION);
        return opEmptySuccess();
      }
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-transfers-credit
   *
   */
  async getTransfersCredit(auth, params = {}) {
    const url = new URL(`aml/${auth.id}/transfers-credit`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.threshold) {
      url.searchParams.set("threshold", Amounts.stringify(params.threshold));
    }
    if (params.account) {
      url.searchParams.set("h_payto", params.account);
    }
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeTransferList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ transfers: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-transfers-debit
   *
   */
  async getTransfersDebit(auth, params = {}) {
    const url = new URL(`aml/${auth.id}/transfers-debit`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.threshold) {
      url.searchParams.set("threshold", Amounts.stringify(params.threshold));
    }
    if (params.account) {
      url.searchParams.set("h_payto", params.account);
    }
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeTransferList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ transfers: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * https://docs.taler.net/core/api-exchange.html#get--aml-$OFFICER_PUB-transfers-kycauth
   *
   */
  async getTransfersKycAuth(auth, params = {}) {
    const url = new URL(`aml/${auth.id}/transfers-kycauth`, this.baseUrl);
    addPaginationParams(url, params);
    if (params.threshold) {
      url.searchParams.set("threshold", Amounts.stringify(params.threshold));
    }
    if (params.account) {
      url.searchParams.set("h_payto", params.account);
    }
    const resp = await this.fetch(url, {
      headers: {
        "Taler-AML-Officer-Signature": encodeCrock(signAmlQuery(auth.signingKey))
      }
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeTransferList());
      case HttpStatusCode.NoContent:
        return opFixedSuccess({ transfers: [] });
      case HttpStatusCode.Forbidden:
      case HttpStatusCode.NotFound:
      case HttpStatusCode.Conflict:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * Request: POST /withdraw
   *
   * https://docs.taler.net/core/api-exchange.html#withdrawal
   */
  async withdraw(args) {
    const url = new URL(`withdraw`, this.baseUrl);
    const resp = await this.fetch(url, {
      method: "POST",
      body: args.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeWithdrawResponse());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  /**
   * Request: POST /melt
   *
   * https://docs.taler.net/core/api-exchange.html#post--melt
   */
  async postMelt(args) {
    const url = new URL(`melt`, this.baseUrl);
    const resp = await this.fetch(url, {
      method: "POST",
      body: args.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeMeltResponse());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
  async postRevealMelt(args) {
    const url = new URL(`reveal-melt`, this.baseUrl);
    const resp = await this.fetch(url, {
      method: "POST",
      body: args.body
    });
    switch (resp.status) {
      case HttpStatusCode.Ok:
        return opSuccessFromHttp(resp, codecForExchangeWithdrawResponse());
      case HttpStatusCode.Forbidden:
        return opKnownHttpFailure(resp.status, resp);
      default:
        return opUnknownHttpFailure(resp);
    }
  }
};
TalerExchangeHttpClient.SUPPORTED_EXCHANGE_PROTOCOL_VERSION = "27:0:2";

// ../taler-util/lib/http-client/merchant.js
var TalerMerchantInstanceCacheEviction;
(function(TalerMerchantInstanceCacheEviction3) {
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_ORDER"] = 0] = "CREATE_ORDER";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_ORDER"] = 1] = "UPDATE_ORDER";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_ORDER"] = 2] = "DELETE_ORDER";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_CURRENT_INSTANCE"] = 3] = "UPDATE_CURRENT_INSTANCE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_CURRENT_INSTANCE"] = 4] = "DELETE_CURRENT_INSTANCE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_BANK_ACCOUNT"] = 5] = "CREATE_BANK_ACCOUNT";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_BANK_ACCOUNT"] = 6] = "UPDATE_BANK_ACCOUNT";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_BANK_ACCOUNT"] = 7] = "DELETE_BANK_ACCOUNT";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_PRODUCT"] = 8] = "CREATE_PRODUCT";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_PRODUCT"] = 9] = "UPDATE_PRODUCT";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_PRODUCT"] = 10] = "DELETE_PRODUCT";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_CATEGORY"] = 11] = "CREATE_CATEGORY";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_CATEGORY"] = 12] = "UPDATE_CATEGORY";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_CATEGORY"] = 13] = "DELETE_CATEGORY";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_TRANSFER"] = 14] = "CREATE_TRANSFER";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_TRANSFER"] = 15] = "DELETE_TRANSFER";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_DEVICE"] = 16] = "CREATE_DEVICE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_DEVICE"] = 17] = "UPDATE_DEVICE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_DEVICE"] = 18] = "DELETE_DEVICE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_TEMPLATE"] = 19] = "CREATE_TEMPLATE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_TEMPLATE"] = 20] = "UPDATE_TEMPLATE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_TEMPLATE"] = 21] = "DELETE_TEMPLATE";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_WEBHOOK"] = 22] = "CREATE_WEBHOOK";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_WEBHOOK"] = 23] = "UPDATE_WEBHOOK";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_WEBHOOK"] = 24] = "DELETE_WEBHOOK";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_TOKENFAMILY"] = 25] = "CREATE_TOKENFAMILY";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["UPDATE_TOKENFAMILY"] = 26] = "UPDATE_TOKENFAMILY";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_TOKENFAMILY"] = 27] = "DELETE_TOKENFAMILY";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["CREATE_ACCESSTOKEN"] = 28] = "CREATE_ACCESSTOKEN";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["DELETE_ACCESSTOKEN"] = 29] = "DELETE_ACCESSTOKEN";
  TalerMerchantInstanceCacheEviction3[TalerMerchantInstanceCacheEviction3["LAST"] = 30] = "LAST";
})(TalerMerchantInstanceCacheEviction || (TalerMerchantInstanceCacheEviction = {}));
var TalerMerchantManagementCacheEviction;
(function(TalerMerchantManagementCacheEviction3) {
  TalerMerchantManagementCacheEviction3[TalerMerchantManagementCacheEviction3["CREATE_INSTANCE"] = 31] = "CREATE_INSTANCE";
  TalerMerchantManagementCacheEviction3[TalerMerchantManagementCacheEviction3["UPDATE_INSTANCE"] = 32] = "UPDATE_INSTANCE";
  TalerMerchantManagementCacheEviction3[TalerMerchantManagementCacheEviction3["DELETE_INSTANCE"] = 33] = "DELETE_INSTANCE";
})(TalerMerchantManagementCacheEviction || (TalerMerchantManagementCacheEviction = {}));

// ../taler-util/lib/http-client/officer-account.js
async function createNewWalletKycAccount(extraNonce, password) {
  const { eddsaPriv, eddsaPub } = createEddsaKeyPair();
  const mergedRnd = extraNonce && password ? kdf(24, stringToBytes("aml-officer"), extraNonce, getRandomBytes(24)) : getRandomBytes(24);
  const protectedPrivKey = password ? await encryptWithDerivedKey(mergedRnd, stringToBytes(password), eddsaPriv, password) : void 0;
  const signingKey = eddsaPriv;
  const accountId = encodeCrock(eddsaPub);
  const safe = protectedPrivKey ? encodeCrock(protectedPrivKey) : void 0;
  return { id: accountId, signingKey, safe };
}

// ../taler-util/lib/i18n.js
var jedLib = __toESM(require_jed(), 1);
var logger7 = new Logger("i18n/index.ts");
var jed = void 0;
function setupI18n(lang, strings2) {
  lang = lang.replace("_", "-");
  if (!strings2[lang]) {
    strings2[lang] = {};
  }
  jed = new jedLib.Jed(strings2[lang]);
}
function toI18nString(stringSeq) {
  let s4 = "";
  for (let i4 = 0; i4 < stringSeq.length; i4++) {
    s4 += stringSeq[i4];
    if (i4 < stringSeq.length - 1) {
      s4 += `%${i4 + 1}$s`;
    }
  }
  return s4;
}
function singular(stringSeq, ...values) {
  const s4 = toI18nString(stringSeq);
  if (!s4)
    return "";
  const tr = jed.translate(s4).ifPlural(1, s4).fetch(...values);
  return tr;
}
function withContext(ctx) {
  return function(t4, ...v3) {
    const s4 = toI18nString(t4);
    const tr = jed.translate(s4).withContext(ctx).ifPlural(1, s4).fetch(...v3);
    return tr;
  };
}
function translate(stringSeq, ...values) {
  const s4 = toI18nString(stringSeq);
  if (!s4)
    return [];
  const translation = jed.ngettext(s4, s4, 1);
  return replacePlaceholderWithValues(translation, values);
}
function Translate({ children, debug, context: ctx }) {
  const c4 = [].concat(children);
  const s4 = stringifyArray(c4);
  if (!s4)
    return [];
  const translation = ctx ? jed.npgettext(ctx, s4, s4, 1) : jed.ngettext(s4, s4, 1);
  if (debug) {
    console.log("looking for ", s4, "got", translation);
  }
  return replacePlaceholderWithValues(translation, c4);
}
function replacePlaceholderWithValues(translation, childArray) {
  const tr = translation.split(/%(\d+)\$s/);
  const placeholderChildren = [];
  for (let i4 = 0; i4 < childArray.length; i4++) {
    const x5 = childArray[i4];
    if (x5 === void 0) {
      continue;
    } else if (typeof x5 === "string") {
      continue;
    } else {
      placeholderChildren.push(x5);
    }
  }
  const result = [];
  for (let i4 = 0; i4 < tr.length; i4++) {
    if (i4 % 2 == 0) {
      result.push(tr[i4]);
    } else {
      const childIdx = Number.parseInt(tr[i4]) - 1;
      result.push(placeholderChildren[childIdx]);
    }
  }
  return result;
}
function stringifyArray(children) {
  let n2 = 1;
  const ss = children.map((c4) => {
    if (typeof c4 === "string") {
      return c4;
    }
    return `%${n2++}$s`;
  });
  const s4 = ss.join("").replace(/ +/g, " ").trim();
  return s4;
}
var i18n = {
  str: singular,
  ctx: withContext,
  singular,
  Translate,
  translate
};

// ../taler-util/lib/iban.js
var IbanError;
(function(IbanError2) {
  IbanError2[IbanError2["INVALID_COUNTRY"] = 0] = "INVALID_COUNTRY";
  IbanError2[IbanError2["TOO_LONG"] = 1] = "TOO_LONG";
  IbanError2[IbanError2["TOO_SHORT"] = 2] = "TOO_SHORT";
  IbanError2[IbanError2["INVALID_CHARSET"] = 3] = "INVALID_CHARSET";
  IbanError2[IbanError2["INVALID_CHECKSUM"] = 4] = "INVALID_CHECKSUM";
})(IbanError || (IbanError = {}));
var ccZero = "0".charCodeAt(0);
var ccNine = "9".charCodeAt(0);
var ccA = "A".charCodeAt(0);
var ccZ = "Z".charCodeAt(0);

// ../taler-util/lib/longpool-queue.js
var logger8 = new Logger("longpoll-queue.ts");
var PERMITS = 20;
var LongpollQueue = class {
  constructor() {
    this.idCounter = 0;
    this.queue = [];
    this.permits = PERMITS;
  }
  async run(url, cancellationToken, f3) {
    const hostname = url.hostname;
    const rid = this.idCounter++;
    const triggerNextLongpoll = () => {
      logger8.trace(`cleaning up after long-poll ${rid} to ${hostname}`);
      const next = this.queue.shift();
      if (next != null) {
        next();
      } else {
        this.permits++;
      }
    };
    const doRunLongpoll = async () => {
      const numWaiting = this.queue.length;
      const numConcurrent = PERMITS - this.permits;
      logger8.info(`running long-poll ${rid} to ${hostname} with ${numWaiting} waiting and ${numConcurrent} running`);
      try {
        const timeoutMs = Math.round(Math.max(1e4, 3e4 / (numWaiting + 1)));
        return await f3(timeoutMs);
      } finally {
        triggerNextLongpoll();
      }
    };
    if (this.permits > 0) {
      this.permits--;
      return doRunLongpoll();
    } else {
      logger8.info(`long-poll ${rid} to ${hostname} queued`);
      const promcap = openPromise();
      this.queue.push(promcap.resolve);
      try {
        await cancellationToken.racePromise(promcap.promise);
      } finally {
        logger8.info(`long-poll ${rid} to ${hostname} cancelled while queued`);
        triggerNextLongpoll();
      }
      return doRunLongpoll();
    }
  }
};

// ../taler-util/lib/notifications.js
var NotificationType;
(function(NotificationType2) {
  NotificationType2["BalanceChange"] = "balance-change";
  NotificationType2["BankAccountChange"] = "bank-account-change";
  NotificationType2["BackupOperationError"] = "backup-error";
  NotificationType2["TransactionStateTransition"] = "transaction-state-transition";
  NotificationType2["ExchangeStateTransition"] = "exchange-state-transition";
  NotificationType2["Idle"] = "idle";
  NotificationType2["TaskObservabilityEvent"] = "task-observability-event";
  NotificationType2["RequestObservabilityEvent"] = "request-observability-event";
})(NotificationType || (NotificationType = {}));
var ObservabilityEventType;
(function(ObservabilityEventType2) {
  ObservabilityEventType2["HttpFetchStart"] = "http-fetch-start";
  ObservabilityEventType2["HttpFetchFinishError"] = "http-fetch-finish-error";
  ObservabilityEventType2["HttpFetchFinishSuccess"] = "http-fetch-finish-success";
  ObservabilityEventType2["DbQueryStart"] = "db-query-start";
  ObservabilityEventType2["DbQueryFinishSuccess"] = "db-query-finish-success";
  ObservabilityEventType2["DbQueryFinishError"] = "db-query-finish-error";
  ObservabilityEventType2["RequestStart"] = "request-start";
  ObservabilityEventType2["RequestFinishSuccess"] = "request-finish-success";
  ObservabilityEventType2["RequestFinishError"] = "request-finish-error";
  ObservabilityEventType2["TaskStart"] = "task-start";
  ObservabilityEventType2["TaskStop"] = "task-stop";
  ObservabilityEventType2["TaskReset"] = "task-reset";
  ObservabilityEventType2["ShepherdTaskResult"] = "shepherd-task-result";
  ObservabilityEventType2["DeclareTaskDependency"] = "declare-task-dependency";
  ObservabilityEventType2["CryptoStart"] = "crypto-start";
  ObservabilityEventType2["CryptoFinishSuccess"] = "crypto-finish-success";
  ObservabilityEventType2["CryptoFinishError"] = "crypto-finish-error";
  ObservabilityEventType2["Message"] = "message";
  ObservabilityEventType2["DeclareConcernsTransaction"] = "declare-concerns-transaction";
})(ObservabilityEventType || (ObservabilityEventType = {}));

// ../taler-util/lib/observability.js
var seqId = 1e3;
var ObservableHttpClientLibrary = class {
  constructor(impl, oc) {
    this.impl = impl;
    this.oc = oc;
    this.cancelatorById = /* @__PURE__ */ new Map();
  }
  cancelRequest(id) {
    const cancelator = this.cancelatorById.get(id);
    if (!cancelator)
      return;
    cancelator.cancel();
  }
  async fetch(url, opt) {
    const id = `req-${seqId}`;
    seqId = seqId + 1;
    const cancelator = CancellationToken.create();
    if (opt?.cancellationToken) {
      opt.cancellationToken.onCancelled(cancelator.cancel);
    }
    this.cancelatorById.set(id, cancelator);
    this.oc.observe({
      id,
      when: AbsoluteTime.now(),
      type: ObservabilityEventType.HttpFetchStart,
      url
    });
    const optsWithCancel = opt ?? {};
    optsWithCancel.cancellationToken = cancelator.token;
    try {
      const res = await this.impl.fetch(url, optsWithCancel);
      this.oc.observe({
        id,
        when: AbsoluteTime.now(),
        type: ObservabilityEventType.HttpFetchFinishSuccess,
        url,
        status: res.status
      });
      return res;
    } catch (e4) {
      this.oc.observe({
        id,
        when: AbsoluteTime.now(),
        type: ObservabilityEventType.HttpFetchFinishError,
        url,
        error: getErrorDetailFromException(e4)
      });
      throw e4;
    } finally {
      this.cancelatorById.delete(id);
    }
  }
};

// ../taler-util/lib/promises.js
function openPromise() {
  let resolve = null;
  let promiseReject = null;
  const promise = new Promise((res, rej) => {
    resolve = res;
    promiseReject = rej;
  });
  if (!(resolve && promiseReject)) {
    throw Error("JS implementation is broken");
  }
  const result = { resolve, reject: promiseReject, promise };
  function saveLastError(reason) {
    result.lastError = reason;
    promiseReject(reason);
  }
  result.reject = saveLastError;
  return result;
}

// ../taler-util/lib/RequestThrottler.js
var logger9 = new Logger("RequestThrottler.ts");
var MAX_PER_SECOND = 100;
var MAX_PER_MINUTE = 500;
var MAX_PER_HOUR = 2e3;
var OriginState = class {
  constructor() {
    this.tokensSecond = MAX_PER_SECOND;
    this.tokensMinute = MAX_PER_MINUTE;
    this.tokensHour = MAX_PER_HOUR;
    this.lastUpdate = AbsoluteTime.now();
  }
  refill() {
    const now = AbsoluteTime.now();
    if (AbsoluteTime.cmp(now, this.lastUpdate) < 0) {
      this.lastUpdate = now;
      return;
    }
    const d4 = AbsoluteTime.difference(now, this.lastUpdate);
    if (d4.d_ms === "forever") {
      throw Error("assertion failed");
    }
    this.tokensSecond = Math.min(MAX_PER_SECOND, this.tokensSecond + d4.d_ms / 1e3);
    this.tokensMinute = Math.min(MAX_PER_MINUTE, this.tokensMinute + d4.d_ms / 1e3 / 60);
    this.tokensHour = Math.min(MAX_PER_HOUR, this.tokensHour + d4.d_ms / 1e3 / 60 / 60);
    this.lastUpdate = now;
  }
  /**
   * Return true if the request for this origin should be throttled.
   * Otherwise, take a token out of the respective buckets.
   */
  applyThrottle() {
    this.refill();
    if (this.tokensSecond < 1) {
      logger9.warn("request throttled (per second limit exceeded)");
      return true;
    }
    if (this.tokensMinute < 1) {
      logger9.warn("request throttled (per minute limit exceeded)");
      return true;
    }
    if (this.tokensHour < 1) {
      logger9.warn("request throttled (per hour limit exceeded)");
      return true;
    }
    this.tokensSecond--;
    this.tokensMinute--;
    this.tokensHour--;
    return false;
  }
};
var RequestThrottler = class {
  constructor() {
    this.perOriginInfo = {};
  }
  /**
   * Get the throttling state for an origin, or
   * initialize if no state is associated with the
   * origin yet.
   */
  getState(origin) {
    const s4 = this.perOriginInfo[origin];
    if (s4) {
      return s4;
    }
    const ns = this.perOriginInfo[origin] = new OriginState();
    return ns;
  }
  /**
   * Apply throttling to a request.
   *
   * @returns whether the request should be throttled.
   */
  applyThrottle(requestUrl) {
    const origin = new URL(requestUrl).origin;
    return this.getState(origin).applyThrottle();
  }
  /**
   * Get the throttle statistics for a particular URL.
   */
  getThrottleStats(requestUrl) {
    const origin = new URL(requestUrl).origin;
    const state = this.getState(origin);
    return {
      tokensHour: state.tokensHour,
      tokensMinute: state.tokensMinute,
      tokensSecond: state.tokensSecond,
      maxTokensHour: MAX_PER_HOUR,
      maxTokensMinute: MAX_PER_MINUTE,
      maxTokensSecond: MAX_PER_SECOND
    };
  }
};

// ../taler-util/lib/ReserveTransaction.js
var ReserveTransactionType;
(function(ReserveTransactionType2) {
  ReserveTransactionType2["Withdraw"] = "WITHDRAW";
  ReserveTransactionType2["Credit"] = "CREDIT";
  ReserveTransactionType2["Recoup"] = "RECOUP";
  ReserveTransactionType2["Closing"] = "CLOSING";
})(ReserveTransactionType || (ReserveTransactionType = {}));

// ../taler-util/lib/result.js
var Result = {
  of(value) {
    return { tag: "ok", value };
  },
  error(error2) {
    return { tag: "error", error: error2 };
  }
};

// ../taler-util/lib/taleruri.js
function parseWithdrawUriWithError(s4) {
  const pi = parseProtoInfoWithError(s4, "withdraw");
  if (pi.tag === "error") {
    return pi;
  }
  const c4 = pi.value.rest.split("?", 2);
  const path = c4[0];
  const q5 = new URLSearchParams2(c4[1] ?? "");
  const parts = path.split("/");
  if (parts.length < 2) {
    return Result.error(TalerErrorCode.WALLET_TALER_URI_MALFORMED);
  }
  const host = parts[0].toLowerCase();
  const pathSegments = parts.slice(1, parts.length - 1);
  const withdrawId = parts[parts.length - 1];
  const p4 = [host, ...pathSegments].join("/");
  const result = {
    type: TalerUriAction.Withdraw,
    bankIntegrationApiBaseUrl: canonicalizeBaseUrl(`${pi.value.innerProto}://${p4}/`),
    withdrawalOperationId: withdrawId,
    externalConfirmation: q5.get("external-confirmation") == "1"
  };
  return Result.of(result);
}
function parseWithdrawUri(s4) {
  const r3 = parseWithdrawUriWithError(s4);
  if (r3.tag === "error")
    return void 0;
  return r3.value;
}
function parseAddExchangeUriWithError(s4) {
  const pi = parseProtoInfoWithError(s4, "add-exchange");
  if (pi.tag === "error") {
    return pi;
  }
  const parts = pi.value.rest.split("/");
  if (parts.length < 2) {
    return Result.error(TalerErrorCode.WALLET_TALER_URI_MALFORMED);
  }
  const host = parts[0].toLowerCase();
  const pathSegments = parts.slice(1, parts.length - 1);
  const p4 = [host, ...pathSegments].join("/");
  const result = {
    type: TalerUriAction.AddExchange,
    exchangeBaseUrl: canonicalizeBaseUrl(`${pi.value.innerProto}://${p4}/`)
  };
  return Result.of(result);
}
function parseAddExchangeUri(s4) {
  const r3 = parseAddExchangeUriWithError(s4);
  if (r3.tag === "error")
    return void 0;
  return r3.value;
}
var TalerUriType;
(function(TalerUriType2) {
  TalerUriType2["TalerPay"] = "taler-pay";
  TalerUriType2["TalerTemplate"] = "taler-template";
  TalerUriType2["TalerPayTemplate"] = "taler-pay-template";
  TalerUriType2["TalerWithdraw"] = "taler-withdraw";
  TalerUriType2["TalerTip"] = "taler-tip";
  TalerUriType2["TalerRefund"] = "taler-refund";
  TalerUriType2["TalerPayPush"] = "taler-pay-push";
  TalerUriType2["TalerPayPull"] = "taler-pay-pull";
  TalerUriType2["TalerRecovery"] = "taler-recovery";
  TalerUriType2["TalerDevExperiment"] = "taler-dev-experiment";
  TalerUriType2["Unknown"] = "unknown";
})(TalerUriType || (TalerUriType = {}));
var TalerUriAction;
(function(TalerUriAction2) {
  TalerUriAction2["Pay"] = "pay";
  TalerUriAction2["Withdraw"] = "withdraw";
  TalerUriAction2["Refund"] = "refund";
  TalerUriAction2["PayPull"] = "pay-pull";
  TalerUriAction2["PayPush"] = "pay-push";
  TalerUriAction2["PayTemplate"] = "pay-template";
  TalerUriAction2["Restore"] = "restore";
  TalerUriAction2["DevExperiment"] = "dev-experiment";
  TalerUriAction2["WithdrawExchange"] = "withdraw-exchange";
  TalerUriAction2["AddExchange"] = "add-exchange";
})(TalerUriAction || (TalerUriAction = {}));
function parseProtoInfo(s4, action) {
  const pfxPlain = `taler://${action}/`;
  const pfxHttp = `taler+http://${action}/`;
  if (s4.toLowerCase().startsWith(pfxPlain)) {
    return {
      innerProto: "https",
      rest: s4.substring(pfxPlain.length)
    };
  } else if (s4.toLowerCase().startsWith(pfxHttp)) {
    return {
      innerProto: "http",
      rest: s4.substring(pfxHttp.length)
    };
  } else {
    return void 0;
  }
}
function parseProtoInfoWithError(s4, action) {
  if (!s4.toLowerCase().startsWith("taler://") && !s4.toLowerCase().startsWith("taler+http://")) {
    return Result.error(TalerErrorCode.WALLET_TALER_URI_MALFORMED);
  }
  const pfxPlain = `taler://${action}/`;
  const pfxHttp = `taler+http://${action}/`;
  if (s4.toLowerCase().startsWith(pfxPlain)) {
    return Result.of({
      innerProto: "https",
      rest: s4.substring(pfxPlain.length)
    });
  } else if (s4.toLowerCase().startsWith(pfxHttp)) {
    return Result.of({
      innerProto: "http",
      rest: s4.substring(pfxHttp.length)
    });
  } else {
    return Result.error(TalerErrorCode.WALLET_TALER_URI_MALFORMED);
  }
}
var parsers = {
  [TalerUriAction.Pay]: parsePayUri,
  [TalerUriAction.PayPull]: parsePayPullUri,
  [TalerUriAction.PayPush]: parsePayPushUri,
  [TalerUriAction.PayTemplate]: parsePayTemplateUri,
  [TalerUriAction.Restore]: parseRestoreUri,
  [TalerUriAction.Refund]: parseRefundUri,
  [TalerUriAction.Withdraw]: parseWithdrawUri,
  [TalerUriAction.DevExperiment]: parseDevExperimentUri,
  [TalerUriAction.WithdrawExchange]: parseWithdrawExchangeUri,
  [TalerUriAction.AddExchange]: parseAddExchangeUri
};
function stringifyTalerUri(uri) {
  switch (uri.type) {
    case TalerUriAction.DevExperiment: {
      return stringifyDevExperimentUri(uri);
    }
    case TalerUriAction.Pay: {
      return stringifyPayUri(uri);
    }
    case TalerUriAction.PayPull: {
      return stringifyPayPullUri(uri);
    }
    case TalerUriAction.PayPush: {
      return stringifyPayPushUri(uri);
    }
    case TalerUriAction.PayTemplate: {
      return stringifyPayTemplateUri(uri);
    }
    case TalerUriAction.Restore: {
      return stringifyRestoreUri(uri);
    }
    case TalerUriAction.Refund: {
      return stringifyRefundUri(uri);
    }
    case TalerUriAction.Withdraw: {
      return stringifyWithdrawUri(uri);
    }
    case TalerUriAction.WithdrawExchange: {
      return stringifyWithdrawExchange(uri);
    }
    case TalerUriAction.AddExchange: {
      return stringifyAddExchange(uri);
    }
  }
}
function parsePayUri(s4) {
  const pi = parseProtoInfo(s4, "pay");
  if (!pi) {
    return void 0;
  }
  const c4 = pi?.rest.split("?");
  const q5 = new URLSearchParams2(c4[1] ?? "");
  const claimToken = q5.get("c") ?? void 0;
  const noncePriv = q5.get("n") ?? void 0;
  const parts = c4[0].split("/");
  if (parts.length < 3) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const sessionId = parts[parts.length - 1];
  const orderId = parts[parts.length - 2];
  const pathSegments = parts.slice(1, parts.length - 2);
  const p4 = [host, ...pathSegments].join("/");
  const merchantBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${p4}/`);
  return {
    type: TalerUriAction.Pay,
    merchantBaseUrl,
    orderId,
    sessionId,
    claimToken,
    noncePriv
  };
}
function parsePayTemplateUri(uriString) {
  const pi = parseProtoInfo(uriString, TalerUriAction.PayTemplate);
  if (!pi) {
    return void 0;
  }
  const c4 = pi.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const q5 = new URLSearchParams2(c4[1] ?? "");
  const params = {};
  q5.forEach((v3, k5) => {
    params[k5] = v3;
  });
  const host = parts[0].toLowerCase();
  const templateId = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const merchantBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${hostAndSegments}/`);
  return {
    type: TalerUriAction.PayTemplate,
    merchantBaseUrl,
    templateId
  };
}
function parsePayPushUri(s4) {
  const pi = parseProtoInfo(s4, TalerUriAction.PayPush);
  if (!pi) {
    return void 0;
  }
  const c4 = pi?.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const contractPriv = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const exchangeBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${hostAndSegments}/`);
  return {
    type: TalerUriAction.PayPush,
    exchangeBaseUrl,
    contractPriv
  };
}
function parsePayPullUri(s4) {
  const pi = parseProtoInfo(s4, TalerUriAction.PayPull);
  if (!pi) {
    return void 0;
  }
  const c4 = pi?.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const contractPriv = parts[parts.length - 1];
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const exchangeBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${hostAndSegments}/`);
  return {
    type: TalerUriAction.PayPull,
    exchangeBaseUrl,
    contractPriv
  };
}
function parseWithdrawExchangeUri(s4) {
  const pi = parseProtoInfo(s4, "withdraw-exchange");
  if (!pi) {
    return void 0;
  }
  const c4 = pi?.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 1) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const lastPathComponent = parts.length > 1 ? parts[parts.length - 1] : void 0;
  if (lastPathComponent) {
    return void 0;
  }
  const pathSegments = parts.slice(1, parts.length - 1);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const exchangeBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${hostAndSegments}/`);
  const q5 = new URLSearchParams2(c4[1] ?? "");
  const amount = q5.get("a") ?? void 0;
  return {
    type: TalerUriAction.WithdrawExchange,
    exchangeBaseUrl,
    amount
  };
}
function parseRefundUri(s4) {
  const pi = parseProtoInfo(s4, "refund");
  if (!pi) {
    return void 0;
  }
  const c4 = pi?.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 3) {
    return void 0;
  }
  const host = parts[0].toLowerCase();
  const sessionId = parts[parts.length - 1];
  const orderId = parts[parts.length - 2];
  const pathSegments = parts.slice(1, parts.length - 2);
  const hostAndSegments = [host, ...pathSegments].join("/");
  const merchantBaseUrl = canonicalizeBaseUrl(`${pi.innerProto}://${hostAndSegments}/`);
  return {
    type: TalerUriAction.Refund,
    merchantBaseUrl,
    orderId
  };
}
function parseDevExperimentUri(s4) {
  const pi = parseProtoInfo(s4, "dev-experiment");
  const c4 = pi?.rest.split("?");
  if (!c4) {
    return void 0;
  }
  const parts = c4[0].split("/");
  return {
    type: TalerUriAction.DevExperiment,
    devExperimentId: parts[0],
    query: new URLSearchParams2(c4[1] ?? "")
  };
}
function parseRestoreUri(uri) {
  const pi = parseProtoInfo(uri, "restore");
  if (!pi) {
    return void 0;
  }
  const c4 = pi.rest.split("?");
  const parts = c4[0].split("/");
  if (parts.length < 2) {
    return void 0;
  }
  const walletRootPriv = parts[0];
  if (!walletRootPriv)
    return void 0;
  const providers = new Array();
  parts[1].split(",").map((name) => {
    const url = canonicalizeBaseUrl(`${pi.innerProto}://${decodeURIComponent(name)}/`);
    providers.push(url);
  });
  return {
    type: TalerUriAction.Restore,
    walletRootPriv,
    providers
  };
}
function stringifyPayUri({ merchantBaseUrl, orderId, sessionId, claimToken, noncePriv }) {
  const { proto, path, query } = getUrlInfo(merchantBaseUrl, {
    c: claimToken,
    n: noncePriv
  });
  return `${proto}://pay/${path}${orderId}/${sessionId}${query}`;
}
function stringifyPayPullUri({ contractPriv, exchangeBaseUrl }) {
  const { proto, path } = getUrlInfo(exchangeBaseUrl);
  return `${proto}://pay-pull/${path}${contractPriv}`;
}
function stringifyPayPushUri({ contractPriv, exchangeBaseUrl }) {
  const { proto, path } = getUrlInfo(exchangeBaseUrl);
  return `${proto}://pay-push/${path}${contractPriv}`;
}
function stringifyRestoreUri({ providers, walletRootPriv }) {
  const list = providers.map((url) => `${encodeURIComponent(new URL2(url).href)}`).join(",");
  return `taler://restore/${walletRootPriv}/${list}`;
}
function stringifyWithdrawExchange({ exchangeBaseUrl, amount }) {
  const { proto, path, query } = getUrlInfo(exchangeBaseUrl, {
    a: amount
  });
  return `${proto}://withdraw-exchange/${path}${query}`;
}
function stringifyAddExchange({ exchangeBaseUrl }) {
  const { proto, path } = getUrlInfo(exchangeBaseUrl);
  return `${proto}://add-exchange/${path}`;
}
function stringifyDevExperimentUri({ devExperimentId }) {
  return `taler://dev-experiment/${devExperimentId}`;
}
function stringifyPayTemplateUri({ merchantBaseUrl, templateId }) {
  const { proto, path, query } = getUrlInfo(merchantBaseUrl);
  return `${proto}://pay-template/${path}${templateId}${query}`;
}
function stringifyRefundUri({ merchantBaseUrl, orderId }) {
  const { proto, path } = getUrlInfo(merchantBaseUrl);
  return `${proto}://refund/${path}${orderId}/`;
}
function stringifyWithdrawUri({ bankIntegrationApiBaseUrl, withdrawalOperationId }) {
  const { proto, path } = getUrlInfo(bankIntegrationApiBaseUrl);
  return `${proto}://withdraw/${path}${withdrawalOperationId}`;
}
function getUrlInfo(baseUrl, params = {}) {
  const url = new URL2(baseUrl);
  let proto;
  if (url.protocol === "https:") {
    proto = "taler";
  } else if (url.protocol === "http:") {
    proto = "taler+http";
  } else {
    throw Error(`Unsupported URL protocol in ${baseUrl}`);
  }
  let path = url.hostname;
  if (url.port) {
    path = path + ":" + url.port;
  }
  if (url.pathname) {
    path = path + url.pathname;
  }
  if (!path.endsWith("/")) {
    path = path + "/";
  }
  const qp = new URLSearchParams2();
  let withParams = false;
  Object.entries(params).forEach(([name, value]) => {
    if (value !== void 0) {
      withParams = true;
      qp.append(name, value);
    }
  });
  const query = withParams ? "?" + qp.toString() : "";
  return { proto, path, query };
}

// ../taler-util/lib/TaskThrottler.js
var logger10 = new Logger("OperationThrottler.ts");

// ../taler-util/lib/timer.js
var logger11 = new Logger("timer.ts");
var IntervalHandle = class {
  constructor(h3) {
    this.h = h3;
  }
  clear() {
    clearInterval(this.h);
  }
  /**
   * Make sure the event loop exits when the timer is the
   * only event left.  Has no effect in the browser.
   */
  unref() {
    if (typeof this.h === "object" && "unref" in this.h) {
      this.h.unref();
    }
  }
};
var TimeoutHandle = class {
  constructor(h3) {
    this.h = h3;
  }
  clear() {
    clearTimeout(this.h);
  }
  /**
   * Make sure the event loop exits when the timer is the
   * only event left.  Has no effect in the browser.
   */
  unref() {
    if (typeof this.h === "object" && "unref" in this.h) {
      this.h.unref();
    }
  }
};
var performanceNow = (() => {
  if (typeof process !== "undefined" && process.hrtime) {
    return () => {
      return process.hrtime.bigint();
    };
  }
  if (typeof performance !== "undefined") {
    return () => BigInt(Math.floor(performance.now() * 1e3)) * BigInt(1e3);
  }
  return () => BigInt((/* @__PURE__ */ new Date()).getTime()) * BigInt(1e3) * BigInt(1e3);
})();
var SetTimeoutTimerAPI = class {
  /**
   * Call a function every time the delay given in milliseconds passes.
   */
  every(delayMs2, callback) {
    return new IntervalHandle(setInterval(callback, delayMs2));
  }
  /**
   * Call a function after the delay given in milliseconds passes.
   */
  after(delayMs2, callback) {
    return new TimeoutHandle(setTimeout(callback, delayMs2));
  }
};
var timer = new SetTimeoutTimerAPI();

// ../taler-util/lib/types-taler-wallet-transactions.js
var TransactionMajorState;
(function(TransactionMajorState2) {
  TransactionMajorState2["None"] = "none";
  TransactionMajorState2["Pending"] = "pending";
  TransactionMajorState2["Done"] = "done";
  TransactionMajorState2["Aborting"] = "aborting";
  TransactionMajorState2["Aborted"] = "aborted";
  TransactionMajorState2["Dialog"] = "dialog";
  TransactionMajorState2["Finalizing"] = "finalizing";
  TransactionMajorState2["Suspended"] = "suspended";
  TransactionMajorState2["SuspendedFinalizing"] = "suspended-finalizing";
  TransactionMajorState2["SuspendedAborting"] = "suspended-aborting";
  TransactionMajorState2["Failed"] = "failed";
  TransactionMajorState2["Expired"] = "expired";
  TransactionMajorState2["Deleted"] = "deleted";
})(TransactionMajorState || (TransactionMajorState = {}));
var TransactionMinorState;
(function(TransactionMinorState2) {
  TransactionMinorState2["Unknown"] = "unknown";
  TransactionMinorState2["Deposit"] = "deposit";
  TransactionMinorState2["KycRequired"] = "kyc";
  TransactionMinorState2["KycInit"] = "kyc-init";
  TransactionMinorState2["MergeKycRequired"] = "merge-kyc";
  TransactionMinorState2["BalanceKycRequired"] = "balance-kyc";
  TransactionMinorState2["BalanceKycInit"] = "balance-kyc-init";
  TransactionMinorState2["KycAuthRequired"] = "kyc-auth";
  TransactionMinorState2["Track"] = "track";
  TransactionMinorState2["SubmitPayment"] = "submit-payment";
  TransactionMinorState2["RebindSession"] = "rebind-session";
  TransactionMinorState2["Refresh"] = "refresh";
  TransactionMinorState2["Pickup"] = "pickup";
  TransactionMinorState2["AutoRefund"] = "auto-refund";
  TransactionMinorState2["User"] = "user";
  TransactionMinorState2["Bank"] = "bank";
  TransactionMinorState2["Exchange"] = "exchange";
  TransactionMinorState2["ClaimProposal"] = "claim-proposal";
  TransactionMinorState2["CheckRefund"] = "check-refund";
  TransactionMinorState2["CreatePurse"] = "create-purse";
  TransactionMinorState2["DeletePurse"] = "delete-purse";
  TransactionMinorState2["RefreshExpired"] = "refresh-expired";
  TransactionMinorState2["Ready"] = "ready";
  TransactionMinorState2["Merge"] = "merge";
  TransactionMinorState2["Repurchase"] = "repurchase";
  TransactionMinorState2["BankRegisterReserve"] = "bank-register-reserve";
  TransactionMinorState2["BankConfirmTransfer"] = "bank-confirm-transfer";
  TransactionMinorState2["WithdrawCoins"] = "withdraw-coins";
  TransactionMinorState2["ExchangeWaitReserve"] = "exchange-wait-reserve";
  TransactionMinorState2["AbortingBank"] = "aborting-bank";
  TransactionMinorState2["Aborting"] = "aborting";
  TransactionMinorState2["Refused"] = "refused";
  TransactionMinorState2["Withdraw"] = "withdraw";
  TransactionMinorState2["MerchantOrderProposed"] = "merchant-order-proposed";
  TransactionMinorState2["Proposed"] = "proposed";
  TransactionMinorState2["RefundAvailable"] = "refund-available";
  TransactionMinorState2["AcceptRefund"] = "accept-refund";
  TransactionMinorState2["PaidByOther"] = "paid-by-other";
  TransactionMinorState2["CompletedByOtherWallet"] = "completed-by-other-wallet";
})(TransactionMinorState || (TransactionMinorState = {}));
var TransactionAction;
(function(TransactionAction2) {
  TransactionAction2["Delete"] = "delete";
  TransactionAction2["Suspend"] = "suspend";
  TransactionAction2["Resume"] = "resume";
  TransactionAction2["Abort"] = "abort";
  TransactionAction2["Fail"] = "fail";
  TransactionAction2["Retry"] = "retry";
})(TransactionAction || (TransactionAction = {}));
var TransactionType;
(function(TransactionType2) {
  TransactionType2["Withdrawal"] = "withdrawal";
  TransactionType2["InternalWithdrawal"] = "internal-withdrawal";
  TransactionType2["Payment"] = "payment";
  TransactionType2["Refund"] = "refund";
  TransactionType2["Refresh"] = "refresh";
  TransactionType2["Deposit"] = "deposit";
  TransactionType2["PeerPushDebit"] = "peer-push-debit";
  TransactionType2["PeerPushCredit"] = "peer-push-credit";
  TransactionType2["PeerPullDebit"] = "peer-pull-debit";
  TransactionType2["PeerPullCredit"] = "peer-pull-credit";
  TransactionType2["Recoup"] = "recoup";
  TransactionType2["DenomLoss"] = "denom-loss";
})(TransactionType || (TransactionType = {}));
var WithdrawalType;
(function(WithdrawalType2) {
  WithdrawalType2["TalerBankIntegrationApi"] = "taler-bank-integration-api";
  WithdrawalType2["ManualTransfer"] = "manual-transfer";
})(WithdrawalType || (WithdrawalType = {}));
var DenomLossEventType;
(function(DenomLossEventType2) {
  DenomLossEventType2["DenomExpired"] = "denom-expired";
  DenomLossEventType2["DenomVanished"] = "denom-vanished";
  DenomLossEventType2["DenomUnoffered"] = "denom-unoffered";
})(DenomLossEventType || (DenomLossEventType = {}));
var PaymentStatus;
(function(PaymentStatus2) {
  PaymentStatus2["Aborted"] = "aborted";
  PaymentStatus2["Failed"] = "failed";
  PaymentStatus2["Paid"] = "paid";
  PaymentStatus2["Accepted"] = "accepted";
})(PaymentStatus || (PaymentStatus = {}));

// ../taler-util/lib/transaction-test-data.js
var sampleWalletCoreTransactions = [
  {
    type: TransactionType.Payment,
    txState: {
      major: TransactionMajorState.Done
    },
    amountRaw: "KUDOS:10",
    amountEffective: "KUDOS:10",
    totalRefundRaw: "KUDOS:0",
    totalRefundEffective: "KUDOS:0",
    status: PaymentStatus.Paid,
    refundPending: void 0,
    posConfirmation: void 0,
    pending: false,
    refunds: [],
    timestamp: {
      t_s: 1677166045
    },
    transactionId: "txn:payment:NRRD9KJ8970P5HDAGPW1MBA6HZHB1XMFKF5M3CNR6WA0GT98DHY0",
    proposalId: "NRRD9KJ8970P5HDAGPW1MBA6HZHB1XMFKF5M3CNR6WA0GT98DHY0",
    info: {
      merchant: {
        name: "woocommerce",
        website: "woocommerce.demo.taler.net",
        email: "foo@example.com",
        address: {},
        jurisdiction: {}
      },
      orderId: "wc_order_KQCRldghIgDRB-100",
      products: [
        {
          description: "Using GCC",
          quantity: 1,
          price: "KUDOS:10",
          product_id: "28"
        }
      ],
      summary: "WooTalerShop #100",
      contractTermsHash: "A02E1M6ARWKBJ87K2TV4S6WQ4X5YH7BRVR6MYCHCTVAED8MBXTFD6PZ5Q50Y7Z5K18PYBTDA14NQ56XPC1VCQW1EVRWTSB7ZYT65B5G",
      fulfillmentUrl: "https://woocommerce.demo.taler.net/?wc-api=wc_gnutaler_gateway&order_id=wc_order_KQCRldghIgDRB-100"
    },
    refundQueryActive: false,
    frozen: false
  },
  {
    type: TransactionType.Refresh,
    txState: {
      major: TransactionMajorState.Pending
    },
    refreshReason: RefreshReason.PayMerchant,
    amountEffective: "KUDOS:0",
    amountRaw: "KUDOS:0",
    refreshInputAmount: "KUDOS:1.5",
    refreshOutputAmount: "KUDOS:1.4",
    originatingTransactionId: "txn:proposal:ZCGBZFE8KZ1CBYYGSC3ZC8E40KVJWV16VYCTHGC8FFSVZ5HD24BG",
    pending: true,
    timestamp: {
      t_s: 1681376214
    },
    transactionId: "txn:refresh:QQSWHHXCRQ269G0E3RW14JMC6F7NFDYDW26NSFHRTXSKDS6CMCZ0",
    frozen: false,
    error: {
      code: 7029,
      when: {
        t_ms: 1681376473665
      },
      hint: "Error (WALLET_REFRESH_GROUP_INCOMPLETE)",
      numErrors: 1,
      errors: [
        {
          code: 7001,
          when: {
            t_ms: 1681376473189
          },
          hint: "unexpected exception (message: exchange wire fee signature invalid)",
          stack: "    at validateWireInfo (../taler-wallet-core-qjs.mjs:23166)\n"
        }
      ]
    }
  }
];

// ../taler-util/lib/taler-signatures.js
function signAmlDecision(priv, decision) {
  const builder = buildSigPS(TalerSignaturePurpose.AML_DECISION);
  const flags = decision.keep_investigating ? 1 : 0;
  builder.put(timestampRoundedToBuffer(decision.decision_time));
  builder.put(timestampRoundedToBuffer(decision.attributes_expiration ?? TalerProtocolTimestamp.fromSeconds(0)));
  builder.put(decodeCrock(decision.h_payto));
  builder.put(hash2(stringToBytes(decision.justification)));
  builder.put(hash2(stringToBytes(canonicalJson(decision.properties) + "\0")));
  builder.put(hash2(stringToBytes(canonicalJson(decision.new_rules) + "\0")));
  if (decision.new_measures != null) {
    builder.put(hash2(stringToBytes(decision.new_measures)));
  } else {
    builder.put(new Uint8Array(64));
  }
  if (decision.attributes != null) {
    builder.put(hash2(stringToBytes(canonicalJson(decision.attributes) + "\0")));
  } else {
    builder.put(new Uint8Array(64));
  }
  builder.put(bufferForUint64(flags));
  const sigBlob = builder.build();
  return eddsaSign(sigBlob, priv);
}
function signAmlQuery(key) {
  const sigBlob = buildSigPS(TalerSignaturePurpose.AML_QUERY).build();
  return eddsaSign(sigBlob, key);
}
function signWalletAccountSetup(key, balance) {
  const sigBlob = buildSigPS(TalerSignaturePurpose.WALLET_ACCOUNT_SETUP).put(bufferFromAmount(balance)).build();
  return eddsaSign(sigBlob, key);
}
function signKycAuth(key) {
  const sigBlob = buildSigPS(TalerSignaturePurpose.KYC_AUTH).build();
  return eddsaSign(sigBlob, key);
}

// ../taler-util/lib/taler-account-properties.js
var TalerAmlProperties = {
  /**
   * Description: Current note on the GWG file.
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  FILE_NOTE: "FILE_NOTE",
  /**
   * Description: Customer name or internal alias.
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  CUSTOMER_LABEL: "CUSTOMER_LABEL",
  /**
   * Description: Boolean flag indicating whether the account has been opened. The definition of opening an account is deployment-specific.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  ACCOUNT_OPEN: "ACCOUNT_OPEN",
  /**
   * Description: True if the customer is a domestic PEP.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  PEP_DOMESTIC: "PEP_DOMESTIC",
  /**
   * Description: True if the customer is a foreign PEP.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  PEP_FOREIGN: "PEP_FOREIGN",
  /**
   * Description: True if the customer is a international organization PEP.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  PEP_INTERNATIONAL_ORGANIZATION: "PEP_INTERNATIONAL_ORGANIZATION",
  /**
   * Description: True if the customer is a  high-risk business.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  HIGH_RISK_CUSTOMER: "HIGH_RISK_CUSTOMER",
  /**
   * Description: True if the customer is associated with a high-risk country.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  HIGH_RISK_COUNTRY: "HIGH_RISK_COUNTRY",
  /**
   * Description: The account has been marked as idle.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  ACCOUNT_IDLE: "ACCOUNT_IDLE",
  /**
   * Description: The MROS reporting state for the account.
   *
   * GANA Type: 'NONE' | 'INVESTIGATION_PENDING' | 'INVESTIGATION_COMPLETED_WITHOUT_SUSPICION' | 'REPORTED_SUSPICION_SIMPLE' | 'REPORTED_SUSPICION_SUBSTANTIATED'
   * Deployment: TOPS
   */
  INVESTIGATION_STATE: "INVESTIGATION_STATE",
  /**
   * Description: Informal reason why the AML investigation was triggered. Examples include suspicious transaction or (automated) sanction list match
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  INVESTIGATION_TRIGGER: "INVESTIGATION_TRIGGER",
  /**
   * Description: Identifies the sanction list entry that the account matched against (best match, does not mean it was a good match)
   *
   * GANA Type: String
   * Deployment: TOPS
   */
  SANCTION_LIST_BEST_MATCH: "SANCTION_LIST_BEST_MATCH",
  /**
   * Description: Score for how good the sanction list match was (0: none, 10**9: perfect match)
   *
   * GANA Type: Integer
   * Deployment: TOPS
   */
  SANCTION_LIST_RATING: "SANCTION_LIST_RATING",
  /**
   * Description: Score for how much supporting data we had for the sanction list match (0: none, 10**9: all fields available)
   *
   * GANA Type: Integer
   * Deployment: TOPS
   */
  SANCTION_LIST_CONFIDENCE: "SANCTION_LIST_CONFIDENCE",
  /**
   * Description: Suppress flagging this account when it creates a hit on a sanctions list, this is a false-positive.
   *
   * GANA Type: Boolean
   * Deployment: TOPS
   */
  SANCTION_LIST_SUPPRESS: "SANCTION_LIST_SUPPRESS"
};

// ../taler-util/lib/taler-form-attributes.js
var TalerFormAttributes = {
  /**
   * Description: Suppress flagging this account when it creates a hit on a sanctions list, this is a false-positive.
   *
   * GANA Type: Boolean
   */
  SANCTION_LIST_SUPPRESS: "SANCTION_LIST_SUPPRESS",
  /**
   * Description: Date for the signature.
   *
   * GANA Type: AbsoluteDateTime
   */
  SIGN_DATE: "SIGN_DATE",
  /**
   * Description: Name of the contracting party for the purpose of signing.
   *
   * GANA Type: String
   */
  SIGNATURE: "SIGNATURE",
  /**
   * Description: Basic customer type classification to distinguish which basic info is relevant.
   *
   * GANA Type: 'NATURAL_PERSON' | 'LEGAL_ENTITY'
   */
  CUSTOMER_TYPE: "CUSTOMER_TYPE",
  /**
   * Description: Date of birth for natural persons. It should be in the past and less than 120 years.
   *
   * GANA Type: ISO Date
   */
  DATE_OF_BIRTH: "DATE_OF_BIRTH",
  /**
   * Description: If the customer is a natural person.
   *
   * GANA Type: File
   */
  PERSONAL_IDENTIFICATION_DOCUMENT_COPY: "PERSONAL_IDENTIFICATION_DOCUMENT_COPY",
  /**
   * Description: Is the customer a sole proprietor?
   *
   * GANA Type: Boolean
   */
  CUSTOMER_IS_SOLE_PROPRIETOR: "CUSTOMER_IS_SOLE_PROPRIETOR",
  /**
   * Description: If the customer is a natural person.
   *
   * GANA Type: String
   */
  COMPANY_NAME: "COMPANY_NAME",
  /**
   * Description:
   *
   * GANA Type: String
   */
  REGISTERED_OFFICE_ADDRESS: "REGISTERED_OFFICE_ADDRESS",
  /**
   * Description: Digital copy of the identification document for a legal entity.
   *
   * GANA Type: FileUpload
   */
  LEGAL_ENTITY_IDENTIFICATION_DOCUMENT_COPY: "LEGAL_ENTITY_IDENTIFICATION_DOCUMENT_COPY",
  /**
   * Description: Full name of the contact person.
   *
   * GANA Type: String
   */
  CONTACT_PERSON_NAME: "CONTACT_PERSON_NAME",
  /**
   * Description: Free-form description.
   *
   * GANA Type: String
   */
  DESCRIPTION: "DESCRIPTION",
  /**
   * Description:
   *
   * GANA Type: FileUpload[]
   */
  FILE: "FILE",
  /**
   * Description: List of founder with the fields below.
   *
   * GANA Type: Form<VQF_902_1_founder>[]
   */
  ESTABLISHER_LIST: "ESTABLISHER_LIST",
  /**
   * Description: Full name of a natural person.
   *
   * GANA Type: String
   */
  FULL_NAME: "FULL_NAME",
  /**
   * Description: Domicile address. A domicile is a place where you live, an address is just a place where you receive mail. A residential address is somewhere you live but not necessarily your primary place.
   *
   * GANA Type: ResidentialAddress
   */
  DOMICILE_ADDRESS: "DOMICILE_ADDRESS",
  /**
   * Description: Nationality, expressed as a country code.
   *
   * GANA Type: CountryCode
   */
  NATIONALITY: "NATIONALITY",
  /**
   * Description: Signatory of representation (single, collective two, ...)
   *
   * GANA Type: String
   */
  SIGNING_AUTHORITY_TYPE: "SIGNING_AUTHORITY_TYPE",
  /**
   * Description: Signatory of representation (other type)
   *
   * GANA Type: String
   */
  SIGNING_AUTHORITY_TYPE_OTHER: "SIGNING_AUTHORITY_TYPE_OTHER",
  /**
   * Description:
   *
   * GANA Type: 'CR' | 'MANDATE' | 'OTHER'
   */
  SIGNING_AUTHORITY_EVIDENCE: "SIGNING_AUTHORITY_EVIDENCE",
  /**
   * Description:
   *
   * GANA Type: String
   */
  SIGNING_AUTHORITY_EVIDENCE_OTHER: "SIGNING_AUTHORITY_EVIDENCE_OTHER",
  /**
   * Description:
   *
   * GANA Type: File
   */
  SIGNING_AUTHORITY_EVIDENCE_DOCUMENT_COPY: "SIGNING_AUTHORITY_EVIDENCE_DOCUMENT_COPY",
  /**
   * Description: Conclusion of the conract
   *
   * GANA Type: AbsoluteDate
   */
  ACCEPTANCE_DATE: "ACCEPTANCE_DATE",
  /**
   * Description:
   *
   * GANA Type: 'FACE_TO_FACE' | 'AUTHENTICATED_COPY' | 'RESIDENTIAL_ADDRESS_VALIDATED'
   */
  ACCEPTANCE_METHOD: "ACCEPTANCE_METHOD",
  /**
   * Description: Correspondence language of the customer.
   *
   * GANA Type: LangCode
   */
  CORRESPONDENCE_LANGUAGE: "CORRESPONDENCE_LANGUAGE",
  /**
   * Description: Further information on the acceptance of a customer.
   *
   * GANA Type: String
   */
  ACCEPTANCE_FURTHER_INFO: "ACCEPTANCE_FURTHER_INFO",
  /**
   * Description: Customer type under the VQF classification. Establishment of the beneficial owner of the assets and/or controlling person
   *
   * GANA Type: 'NATURAL_PERSON' | 'OPERATIONAL' | 'FOUNDATION' | 'TRUST' | 'LIFE_INSURANCE' | 'OTHER'
   */
  CUSTOMER_TYPE_VQF: "CUSTOMER_TYPE_VQF",
  /**
   * Description: Verification whether the customer, beneficial owners of the assets, controlling persons, authorised representatives or other involved persons are listed on an embargo-/terrorism list (date of verification/result)
   *
   * GANA Type: Paragraph
   */
  EMBARGO_TERRORISM_INFO: "EMBARGO_TERRORISM_INFO",
  /**
   * Description: Verification date in the sancations lists. It should be in the past and less than 120 years.
   *
   * GANA Type: Date
   */
  EMBARGO_TERRORISM_CHECK_DATE: "EMBARGO_TERRORISM_CHECK_DATE",
  /**
   * Description: Verification date.
   *
   * GANA Type: 'NOT_LISTED' | 'LISTED'
   */
  EMBARGO_TERRORISM_CHECK_RESULT: "EMBARGO_TERRORISM_CHECK_RESULT",
  /**
   * Description: True if the person is a PEP defined by 'Art 7 lit. g numeral 1'
   *
   * GANA Type: Boolean
   */
  PEP_FOREIGN: "PEP_FOREIGN",
  /**
   * Description: True if the person is a PEP defined by 'Art 7 lit. g numeral 2'
   *
   * GANA Type: Boolean
   */
  PEP_DOMESTIC: "PEP_DOMESTIC",
  /**
   * Description: True if the person is a PEP defined by 'Art 7 lit. g numeral 3'
   *
   * GANA Type: Boolean
   */
  PEP_INTERNATIONAL_ORGANIZATION: "PEP_INTERNATIONAL_ORGANIZATION",
  /**
   * Description: The decision of the Senior executive body on the acceptance of a business relationsip was obtained on ___. It should be in the past and less than 120 years.
   *
   * GANA Type: AbsoluteDateTime
   */
  PEP_ACCEPTANCE_DATE: "PEP_ACCEPTANCE_DATE",
  /**
   * Description: True if the person is in a country for which FATF requires increased dilegence.
   *
   * GANA Type: Boolean
   */
  HIGH_RISK_COUNTRY: "HIGH_RISK_COUNTRY",
  /**
   * Description: The decision of the Senior executive body on the acceptance of a business relationsip was obtained on ___. It should be in the past and less than 120 years.
   *
   * GANA Type: AbsoluteDateTime
   */
  HIGH_RISK_ACCEPTANCE_DATE: "HIGH_RISK_ACCEPTANCE_DATE",
  /**
   * Description:
   *
   * GANA Type: 'NATIONALITY_CUSTOMER' | 'NATIONALITY_OWNER' | 'DOMICILE_CUSTOMER' | 'DOMICILE_OWNER' | 'DOMICILE_CONTROLLING'
   */
  COUNTRY_RISK_NATIONALITY_TYPE: "COUNTRY_RISK_NATIONALITY_TYPE",
  /**
   * Description: Based on 902.4.1 country list
   *
   * GANA Type: 'LOW' | 'MEDIUM' | 'HIGH'
   */
  COUNTRY_RISK_NATIONALITY_LEVEL: "COUNTRY_RISK_NATIONALITY_LEVEL",
  /**
   * Description:
   *
   * GANA Type: 'CUSTOMER' | 'OWNER'
   */
  COUNTRY_RISK_BUSINESS_TYPE: "COUNTRY_RISK_BUSINESS_TYPE",
  /**
   * Description: Based on 902.4.1 country list
   *
   * GANA Type: 'LOW' | 'MEDIUM' | 'HIGH'
   */
  COUNTRY_RISK_BUSINESS_LEVEL: "COUNTRY_RISK_BUSINESS_LEVEL",
  /**
   * Description:
   *
   * GANA Type: 'CUSTOMER' | 'OWNER'
   */
  INDUSTRY_RISK_TYPE: "INDUSTRY_RISK_TYPE",
  /**
   * Description:
   *
   * GANA Type: 'TRANSPARENT' | 'HIGH_CASH_TRANSACTION' | 'NOT_WELL_KNOWN' | 'HIGH_RISK_TRADE' | 'UNKNOWN_INDUSTRY'
   */
  INDUSTRY_RISK_LEVEL: "INDUSTRY_RISK_LEVEL",
  /**
   * Description: Based on 902.4.1 country list
   *
   * GANA Type: 'LOW' | 'MEDIUM' | 'HIGH'
   */
  CONTACT_RISK_LEVEL: "CONTACT_RISK_LEVEL",
  /**
   * Description:
   *
   * GANA Type: 'EASY' | 'SOPHISTICATED' | 'OFFSHORE' | 'COMPLEX_STRUCTURE' | 'LARGE_NUMBER_OF_ACCOUNTS' | 'COMPLEX_SERVICE' | 'FREQ_TRANS_WITH_HIGH_RISK'
   */
  PRODUCT_RISK_LEVEL: "PRODUCT_RISK_LEVEL",
  /**
   * Description:
   *
   * GANA Type: 'HIGH_RISK' | 'NO_HIGH_RISK'
   */
  RISK_CLASSIFICATION_LEVEL: "RISK_CLASSIFICATION_LEVEL",
  /**
   * Description: Justification for differing risk assessment
   *
   * GANA Type: Paragraph
   */
  RISK_RATIONALE: "RISK_RATIONALE",
  /**
   * Description: The decision of the Senior executive body on the acceptance of a business relationsip was obtained on ___. It should be in the past and less than 120 years.
   *
   * GANA Type: AbsoluteDateTime
   */
  RISK_ACCEPTANCE_DATE: "RISK_ACCEPTANCE_DATE",
  /**
   * Description: Profession, business activities, etc. (former, current, potentially planned)
   *
   * GANA Type: String
   */
  BIZREL_PROFESSION: "BIZREL_PROFESSION",
  /**
   * Description: Income and assets, liabilities (estimated)
   *
   * GANA Type: String
   */
  BIZREL_INCOME: "BIZREL_INCOME",
  /**
   * Description: Does the customer have assets that will be deposited?
   *
   * GANA Type: Boolean
   */
  BIZREL_HAVE_ASSETS: "BIZREL_HAVE_ASSETS",
  /**
   * Description: Nature of the involved assets (amount, currency, ...).
   *
   * GANA Type: String
   */
  BIZREL_ORIGIN_NATURE: "BIZREL_ORIGIN_NATURE",
  /**
   * Description:
   *
   * GANA Type: 'SAVINGS' | 'OWN_BUSINESS' | 'INHERITANCE' | 'OTHER'
   */
  BIZREL_ORIGIN_CATEGORY: "BIZREL_ORIGIN_CATEGORY",
  /**
   * Description:
   *
   * GANA Type: String
   */
  BIZREL_ORIGIN_CATEGORY_OTHER: "BIZREL_ORIGIN_CATEGORY_OTHER",
  /**
   * Description: Detailed description of the origins.
   *
   * GANA Type: Paragraph
   */
  BIZREL_ORIGIN_DETAIL: "BIZREL_ORIGIN_DETAIL",
  /**
   * Description: Purpose of the business relationship.
   *
   * GANA Type: String
   */
  BIZREL_PURPOSE: "BIZREL_PURPOSE",
  /**
   * Description: Information on the planned development of the business relationship and the assets.
   *
   * GANA Type: String
   */
  BIZREL_DEVELOPMENT: "BIZREL_DEVELOPMENT",
  /**
   * Description: In the case of cash or money and asset transfer transacction with regular customer
   *
   * GANA Type: String
   */
  BIZREL_FINANCIAL_VOLUME: "BIZREL_FINANCIAL_VOLUME",
  /**
   * Description: Relation of the customer to the beneficial owner, controlling persons, authorised signatories and other persons involved in the business relationship.
   *
   * GANA Type: String
   */
  BIZREL_THIRDPARTY_RELATIONSHIP: "BIZREL_THIRDPARTY_RELATIONSHIP",
  /**
   * Description: Relation to other AMLA-files.
   *
   * GANA Type: String
   */
  BIZREL_THIRDPARTY_AMLA_FILES: "BIZREL_THIRDPARTY_AMLA_FILES",
  /**
   * Description: Introducer / agents / references.
   *
   * GANA Type: String
   */
  BIZREL_THIRDPARTY_REFERENCES: "BIZREL_THIRDPARTY_REFERENCES",
  /**
   * Description: Other relevant information.
   *
   * GANA Type: String
   */
  BIZREL_FURTHER_INFO: "BIZREL_FURTHER_INFO",
  /**
   * Description:
   *
   * GANA Type: Paragraph
   */
  IDENTITY_CONTRACTING_PARTNER: "IDENTITY_CONTRACTING_PARTNER",
  /**
   * Description:
   *
   * GANA Type: File
   */
  ATTACHMENT_SIGNED_DOCUMENT: "ATTACHMENT_SIGNED_DOCUMENT",
  /**
   * Description: The beneficial owners of the assets involved in the business relationship.
   *
   * GANA Type: Form<VQF_902_9_identity>[]
   */
  IDENTITY_LIST: "IDENTITY_LIST",
  /**
   * Description: Party that is filling out the form.
   *
   * GANA Type: 'AML_OFFICER' | 'CUSTOMER'
   */
  SUBMITTED_BY: "SUBMITTED_BY",
  /**
   * Description:
   *
   * GANA Type: 'HAS_25_MORE_RIGHTS' | 'OTHER_WAY' | 'DIRECTOR'
   */
  CONTROL_REASON: "CONTROL_REASON",
  /**
   * Description: Is a third person the beneficial owner of the assets?
   *
   * GANA Type: Boolean
   */
  THIRD_PARTY_OWNERSHIP: "THIRD_PARTY_OWNERSHIP",
  /**
   * Description: Description of the circumstances/transactions, which triggered the special clarifications
   *
   * GANA Type: String
   */
  INCRISK_REASON: "INCRISK_REASON",
  /**
   * Description:
   *
   * GANA Type: 'GATHERING' | 'CONSULTATION' | 'ENQUIRIES' | 'OTHER'
   */
  INCRISK_MEANS: "INCRISK_MEANS",
  /**
   * Description:
   *
   * GANA Type: String
   */
  INCRISK_MEANS_OTHER: "INCRISK_MEANS_OTHER",
  /**
   * Description:
   *
   * GANA Type: Paragraph
   */
  INCRISK_SUMMARY: "INCRISK_SUMMARY",
  /**
   * Description: Gathered or consulted documents
   *
   * GANA Type: Paragraph
   */
  INCRISK_DOCUMENTS: "INCRISK_DOCUMENTS",
  /**
   * Description:
   *
   * GANA Type: 'NO_SUSPICION' | 'REASONABLE_SUSPICION' | 'SIMPLE_SUSPICION' | 'OTHER'
   */
  INCRISK_RESULT: "INCRISK_RESULT",
  /**
   * Description:
   *
   * GANA Type: String
   */
  INCRISK_RESULT_OTHER: "INCRISK_RESULT_OTHER",
  /**
   * Description: First name(s) as on the identity document.
   *
   * GANA Type: String
   */
  PERSON_FIRST_NAMES: "PERSON_FIRST_NAMES",
  /**
   * Description: Last name of an individual as on the identity document.
   *
   * GANA Type: String
   */
  PERSON_LAST_NAME: "PERSON_LAST_NAME",
  /**
   * Description: Identification number or string of national identity card.
   *
   * GANA Type: String
   */
  PERSON_NATIONAL_ID: "PERSON_NATIONAL_ID",
  /**
   * Description: Scan of a recognized national identity card of an individual.
   *
   * GANA Type: File
   */
  PERSON_NATIONAL_ID_SCAN: "PERSON_NATIONAL_ID_SCAN",
  /**
   * Description: Nationality of an individual. Format is 2-letter ISO country-code.
   *
   * GANA Type: CountryCode
   */
  PERSON_NATIONALITY: "PERSON_NATIONALITY",
  /**
   * Description: Confirmation that the wallet user is a private customer, not a business.
   *
   * GANA Type: Boolean
   */
  WALLET_USER_IS_PRIVATE_CUSTOMER: "WALLET_USER_IS_PRIVATE_CUSTOMER",
  /**
   * Description: Name of the company or business.
   *
   * GANA Type: String
   */
  BUSINESS_DISPLAY_NAME: "BUSINESS_DISPLAY_NAME",
  /**
   * Description: Type of company form or business (selection from fixed list).
   *
   * GANA Type: String
   */
  BUSINESS_TYPE: "BUSINESS_TYPE",
  /**
   * Description: Type of company form or business (free-form entry for OTHER).
   *
   * GANA Type: String
   */
  BUSINESS_TYPE_OTHER: "BUSINESS_TYPE_OTHER",
  /**
   * Description: Registration id on legal entity of the company or business.
   *
   * GANA Type: String
   */
  COMMERCIAL_REGISTER_NUMBER: "COMMERCIAL_REGISTER_NUMBER",
  /**
   * Description: City or location where the company or business is registered.
   *
   * GANA Type: String
   */
  REGISTER_COURT_LOCATION: "REGISTER_COURT_LOCATION",
  /**
   * Description: Registration founding date of the company or business. It should be in the past and less than 120 years.
   *
   * GANA Type: AbsoluteDate
   */
  FOUNDING_DATE: "FOUNDING_DATE",
  /**
   * Description: True if the company or business is a non-profit.
   *
   * GANA Type: Boolean
   */
  BUSINESS_IS_NON_PROFIT: "BUSINESS_IS_NON_PROFIT",
  /**
   * Description: Industry in which the company or business mainly operate.
   *
   * GANA Type: String
   */
  BUSINESS_INDUSTRY: "BUSINESS_INDUSTRY",
  /**
   * Description: Free-form industry, when BUSINESS_INDUSTRY is OTHER.
   *
   * GANA Type: String
   */
  BUSINESS_INDUSTRY_OTHER: "BUSINESS_INDUSTRY_OTHER",
  /**
   * Description: List of natural persons that are legal representatives or shareholders.
   *
   * GANA Type: GLS_BusinessRepresentative[]
   */
  BUSINESS_PERSONS: "BUSINESS_PERSONS",
  /**
   * Description: List of natural persons that are legal representatives or shareholders.
   *
   * GANA Type: LEGAL_REPRESENTATIVE | SHAREHOLDER_GT_25_PERCENT | AUTHORIZED_EMPLOYEE
   */
  REPRESENTATIVE_TYPE: "REPRESENTATIVE_TYPE",
  /**
   * Description: DNS domain name owned by the individual or business.
   *
   * GANA Type: Hostname
   */
  CONTACT_DNS_DOMAIN: "CONTACT_DNS_DOMAIN",
  /**
   * Description: Web site owned by the individual or business.
   *
   * GANA Type: HttpHostnamePath
   */
  CONTACT_WEBSITE: "CONTACT_WEBSITE",
  /**
   * Description: E-mail address to contact the individual or business. Can be validated via E-mail with TAN.
   *
   * GANA Type: Email
   */
  CONTACT_EMAIL: "CONTACT_EMAIL",
  /**
   * Description: Phone number to contact the individual or business. Can be validated via SMS-TAN or phone call.
   *
   * GANA Type: Phone
   */
  CONTACT_PHONE: "CONTACT_PHONE",
  /**
   * Description: Natural person full-name or name of the business to contact.
   *
   * GANA Type: String
   */
  CONTACT_NAME: "CONTACT_NAME",
  /**
   * Description: Country where the individual or business resides. Format is 2-letter ISO country-code.
   *
   * GANA Type: CountryCode
   */
  ADDRESS_COUNTRY: "ADDRESS_COUNTRY",
  /**
   * Description: Street address name of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_STREET_NAME: "ADDRESS_STREET_NAME",
  /**
   * Description: Street address number of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_STREET_NUMBER: "ADDRESS_STREET_NUMBER",
  /**
   * Description: Additional address information of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_LINES: "ADDRESS_LINES",
  /**
   * Description: Building name of the of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_BUILDING_NAME: "ADDRESS_BUILDING_NAME",
  /**
   * Description: Building number of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_BUILDING_NUMBER: "ADDRESS_BUILDING_NUMBER",
  /**
   * Description: Postal code of the city where the individual or business resides.
   *
   * GANA Type: String
   */
  ADDRESS_ZIPCODE: "ADDRESS_ZIPCODE",
  /**
   * Description: Town location of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_TOWN_LOCATION: "ADDRESS_TOWN_LOCATION",
  /**
   * Description: Town district of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_TOWN_DISTRICT: "ADDRESS_TOWN_DISTRICT",
  /**
   * Description: Country subdivision of the individual or business.
   *
   * GANA Type: String
   */
  ADDRESS_COUNTRY_SUBDIVISION: "ADDRESS_COUNTRY_SUBDIVISION",
  /**
   * Description: Country name of of the individual or business.
   *
   * GANA Type: CountryCode
   */
  TAX_COUNTRY: "TAX_COUNTRY",
  /**
   * Description: Tax identifier of the individual or business.
   *
   * GANA Type: String
   */
  TAX_ID: "TAX_ID",
  /**
   * Description: Is business founded or under USA law.
   *
   * GANA Type: Boolean
   */
  TAX_IS_USA_LAW: "TAX_IS_USA_LAW",
  /**
   * Description: Is the individual or business economically active or passive.
   *
   * GANA Type: Boolean
   */
  TAX_IS_ACTIVE: "TAX_IS_ACTIVE",
  /**
   * Description: Is the business entitled to deduct input tax.
   *
   * GANA Type: Boolean
   */
  TAX_IS_DEDUCTED: "TAX_IS_DEDUCTED",
  /**
   * Description: Wirtschafts-Identifikationsnummer / Steuernummer.
   *
   * GANA Type: Boolean
   */
  DE_BUSINESS_OR_TAX_ID: "DE_BUSINESS_OR_TAX_ID",
  /**
   * Description: Name of the version of the terms of service accepted by the customer.
   *
   * GANA Type: Boolean
   */
  ACCEPTED_TERMS_OF_SERVICE: "ACCEPTED_TERMS_OF_SERVICE",
  /**
   * Description: True if the customer read or downloaded the terms of service. It should be set automatically.
   *
   * GANA Type: Boolean
   */
  DOWNLOADED_TERMS_OF_SERVICE: "DOWNLOADED_TERMS_OF_SERVICE",
  /**
   * Description: Name of the form completed by the user.
   *
   * GANA Type: String
   */
  FORM_ID: "FORM_ID",
  /**
   * Description: Version of the form completed by the user.
   *
   * GANA Type: Number
   */
  FORM_VERSION: "FORM_VERSION",
  /**
   * Description: High entropy value used in forms where hash is going to be stored in plain text.
   *
   * GANA Type: String
   */
  FORM_SALT: "FORM_SALT",
  /**
   * Description: List of supplemental file attachments.
   *
   * GANA Type: List of records, usually the file upload and a description.
   */
  SUPPLEMENTAL_FILES_LIST: "SUPPLEMENTAL_FILES_LIST",
  /**
   * Description: Generic note description
   *
   * GANA Type: String
   */
  NOTE_TEXT: "NOTE_TEXT",
  /**
   * Description: Context for form submitted by the user.
   *
   * GANA Type: JSON
   */
  FORM_CONTEXT: "FORM_CONTEXT",
  /**
   * Description: Map of uploaded files.
   *
   * GANA Type: MapStrFile
   */
  FILE_MAP: "FILE_MAP"
};

// ../taler-util/lib/aml/properties.js
var TOPS_AccountProperties = [
  TalerAmlProperties.FILE_NOTE,
  TalerAmlProperties.CUSTOMER_LABEL,
  TalerAmlProperties.ACCOUNT_OPEN,
  TalerAmlProperties.PEP_DOMESTIC,
  TalerAmlProperties.PEP_FOREIGN,
  TalerAmlProperties.PEP_INTERNATIONAL_ORGANIZATION,
  TalerAmlProperties.HIGH_RISK_CUSTOMER,
  TalerAmlProperties.HIGH_RISK_COUNTRY,
  TalerAmlProperties.ACCOUNT_IDLE,
  TalerAmlProperties.INVESTIGATION_TRIGGER,
  TalerAmlProperties.INVESTIGATION_STATE,
  TalerAmlProperties.SANCTION_LIST_BEST_MATCH,
  TalerAmlProperties.SANCTION_LIST_RATING,
  TalerAmlProperties.SANCTION_LIST_CONFIDENCE,
  TalerAmlProperties.SANCTION_LIST_SUPPRESS
];
var GLS_AccountProperties = [TalerAmlProperties.FILE_NOTE];
var KnownForms;
(function(KnownForms3) {
  KnownForms3[KnownForms3["vqf_902_1_customer"] = 0] = "vqf_902_1_customer";
  KnownForms3[KnownForms3["vqf_902_1_officer"] = 1] = "vqf_902_1_officer";
  KnownForms3[KnownForms3["vqf_902_4"] = 2] = "vqf_902_4";
  KnownForms3[KnownForms3["vqf_902_5"] = 3] = "vqf_902_5";
  KnownForms3[KnownForms3["vqf_902_9_customer"] = 4] = "vqf_902_9_customer";
  KnownForms3[KnownForms3["vqf_902_9_officer"] = 5] = "vqf_902_9_officer";
  KnownForms3[KnownForms3["vqf_902_11_customer"] = 6] = "vqf_902_11_customer";
  KnownForms3[KnownForms3["vqf_902_11_officer"] = 7] = "vqf_902_11_officer";
  KnownForms3[KnownForms3["vqf_902_12"] = 8] = "vqf_902_12";
  KnownForms3[KnownForms3["vqf_902_13"] = 9] = "vqf_902_13";
  KnownForms3[KnownForms3["vqf_902_14"] = 10] = "vqf_902_14";
  KnownForms3[KnownForms3["vqf_902_15"] = 11] = "vqf_902_15";
})(KnownForms || (KnownForms = {}));

// ../taler-util/lib/aml/events.js
var TOPS_AmlEventsName;
(function(TOPS_AmlEventsName2) {
  TOPS_AmlEventsName2["INCR_ACCOUNT_OPEN"] = "INCR_ACCOUNT_OPEN";
  TOPS_AmlEventsName2["DECR_ACCOUNT_OPEN"] = "DECR_ACCOUNT_OPEN";
  TOPS_AmlEventsName2["INCR_HIGH_RISK_CUSTOMER"] = "INCR_HIGH_RISK_CUSTOMER";
  TOPS_AmlEventsName2["DECR_HIGH_RISK_CUSTOMER"] = "DECR_HIGH_RISK_CUSTOMER";
  TOPS_AmlEventsName2["INCR_HIGH_RISK_COUNTRY"] = "INCR_HIGH_RISK_COUNTRY";
  TOPS_AmlEventsName2["DECR_HIGH_RISK_COUNTRY"] = "DECR_HIGH_RISK_COUNTRY";
  TOPS_AmlEventsName2["INCR_PEP"] = "INCR_PEP";
  TOPS_AmlEventsName2["DECR_PEP"] = "DECR_PEP";
  TOPS_AmlEventsName2["INCR_PEP_FOREIGN"] = "INCR_PEP_FOREIGN";
  TOPS_AmlEventsName2["DECR_PEP_FOREIGN"] = "DECR_PEP_FOREIGN";
  TOPS_AmlEventsName2["INCR_PEP_DOMESTIC"] = "INCR_PEP_DOMESTIC";
  TOPS_AmlEventsName2["DECR_PEP_DOMESTIC"] = "DECR_PEP_DOMESTIC";
  TOPS_AmlEventsName2["INCR_PEP_INTERNATIONAL_ORGANIZATION"] = "INCR_PEP_INTERNATIONAL_ORGANIZATION";
  TOPS_AmlEventsName2["DECR_PEP_INTERNATIONAL_ORGANIZATION"] = "DECR_PEP_INTERNATIONAL_ORGANIZATION";
  TOPS_AmlEventsName2["MROS_REPORTED_SUSPICION_SIMPLE"] = "MROS_REPORTED_SUSPICION_SIMPLE";
  TOPS_AmlEventsName2["MROS_REPORTED_SUSPICION_SUBSTANTIATED"] = "MROS_REPORTED_SUSPICION_SUBSTANTIATED";
  TOPS_AmlEventsName2["INCR_INVESTIGATION_CONCLUDED"] = "INCR_INVESTIGATION_CONCLUDED";
  TOPS_AmlEventsName2["DECR_INVESTIGATION_CONCLUDED"] = "DECR_INVESTIGATION_CONCLUDED";
})(TOPS_AmlEventsName || (TOPS_AmlEventsName = {}));
var GLS_AmlEventsName;
(function(GLS_AmlEventsName2) {
  GLS_AmlEventsName2["ACCOUNT_OPENED"] = "ACCOUNT_OPENED";
  GLS_AmlEventsName2["ACCOUNT_CLOSED"] = "ACCOUNT_CLOSED";
})(GLS_AmlEventsName || (GLS_AmlEventsName = {}));
var KnownForms2;
(function(KnownForms3) {
  KnownForms3[KnownForms3["vqf_902_1_customer"] = 0] = "vqf_902_1_customer";
  KnownForms3[KnownForms3["vqf_902_1_officer"] = 1] = "vqf_902_1_officer";
  KnownForms3[KnownForms3["vqf_902_4"] = 2] = "vqf_902_4";
  KnownForms3[KnownForms3["vqf_902_5"] = 3] = "vqf_902_5";
  KnownForms3[KnownForms3["vqf_902_9_customer"] = 4] = "vqf_902_9_customer";
  KnownForms3[KnownForms3["vqf_902_9_officer"] = 5] = "vqf_902_9_officer";
  KnownForms3[KnownForms3["vqf_902_11_customer"] = 6] = "vqf_902_11_customer";
  KnownForms3[KnownForms3["vqf_902_11_officer"] = 7] = "vqf_902_11_officer";
  KnownForms3[KnownForms3["vqf_902_12"] = 8] = "vqf_902_12";
  KnownForms3[KnownForms3["vqf_902_13"] = 9] = "vqf_902_13";
  KnownForms3[KnownForms3["vqf_902_14"] = 10] = "vqf_902_14";
  KnownForms3[KnownForms3["vqf_902_15"] = 11] = "vqf_902_15";
})(KnownForms2 || (KnownForms2 = {}));

// ../taler-util/lib/aml/reporting.js
var EventReporting_TOPS_queries = {
  // Number of accounts that are opened
  accounts_open_incr: {
    event: TOPS_AmlEventsName.INCR_ACCOUNT_OPEN,
    start: void 0,
    end: void 0
  },
  accounts_open_decr: {
    event: TOPS_AmlEventsName.DECR_ACCOUNT_OPEN,
    start: void 0,
    end: void 0
  },
  // Number of new GwG files in the last year
  gwg_files_new_last_year: {
    event: TOPS_AmlEventsName.INCR_ACCOUNT_OPEN,
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  },
  // Number of GwG files closed in the last year
  gwg_files_closed_last_year: {
    event: TOPS_AmlEventsName.DECR_ACCOUNT_OPEN,
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  },
  // Number of GwG files of high-risk customers
  gwg_files_high_risk_incr: {
    event: TOPS_AmlEventsName.INCR_HIGH_RISK_CUSTOMER,
    //FIXME: spec refers to INCR_HIGH_RISK
    start: void 0,
    end: void 0
  },
  gwg_files_high_risk_decr: {
    event: TOPS_AmlEventsName.DECR_HIGH_RISK_CUSTOMER,
    start: void 0,
    end: void 0
  },
  // Number of GwG files managed with “increased risk” due to PEP status
  gwg_files_pep_incr: {
    event: TOPS_AmlEventsName.INCR_PEP,
    start: void 0,
    end: void 0
  },
  gwg_files_pep_decr: {
    event: TOPS_AmlEventsName.DECR_PEP,
    start: void 0,
    end: void 0
  },
  // Number of MROS reports based on Art 9 Abs. 1 GwG (per year)
  mros_reports_art9_last_year: {
    event: TOPS_AmlEventsName.MROS_REPORTED_SUSPICION_SUBSTANTIATED,
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  },
  // Number of MROS reports based on Art 305ter Abs. 2 StGB (per year)
  mros_reports_art305_last_year: {
    event: TOPS_AmlEventsName.MROS_REPORTED_SUSPICION_SIMPLE,
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  },
  // Number of customers involved in proceedings for which Art 6 GwG did apply
  accounts_involed_in_proceedings_last_year: {
    event: TOPS_AmlEventsName.INCR_INVESTIGATION_CONCLUDED,
    //FIXME: spec refers to INCR_INVESTIGATION
    start: AbsoluteTime.addDuration(AbsoluteTime.now(), Duration.fromSpec({ years: -1 })),
    end: AbsoluteTime.now()
  }
};

// ../taler-util/lib/iso-3166.js
var countryNamesByCode = {
  [
    "AF"
    /* CountryCode.AF */
  ]: (i18n2) => i18n2.str`Afghanistan`,
  [
    "AL"
    /* CountryCode.AL */
  ]: (i18n2) => i18n2.str`Albania`,
  [
    "DZ"
    /* CountryCode.DZ */
  ]: (i18n2) => i18n2.str`Algeria`,
  [
    "US"
    /* CountryCode.US */
  ]: (i18n2) => i18n2.str`United States`,
  [
    "AD"
    /* CountryCode.AD */
  ]: (i18n2) => i18n2.str`Andorra`,
  [
    "AO"
    /* CountryCode.AO */
  ]: (i18n2) => i18n2.str`Angola`,
  [
    "AG"
    /* CountryCode.AG */
  ]: (i18n2) => i18n2.str`Antigua and Barbuda`,
  [
    "AR"
    /* CountryCode.AR */
  ]: (i18n2) => i18n2.str`Argentina`,
  [
    "AM"
    /* CountryCode.AM */
  ]: (i18n2) => i18n2.str`Armenia`,
  [
    "AU"
    /* CountryCode.AU */
  ]: (i18n2) => i18n2.str`Australia`,
  [
    "AT"
    /* CountryCode.AT */
  ]: (i18n2) => i18n2.str`Austria`,
  [
    "AZ"
    /* CountryCode.AZ */
  ]: (i18n2) => i18n2.str`Azerbaijan`,
  [
    "BS"
    /* CountryCode.BS */
  ]: (i18n2) => i18n2.str`Bahamas`,
  [
    "BH"
    /* CountryCode.BH */
  ]: (i18n2) => i18n2.str`Bahrain`,
  [
    "BD"
    /* CountryCode.BD */
  ]: (i18n2) => i18n2.str`Bangladesh`,
  [
    "BB"
    /* CountryCode.BB */
  ]: (i18n2) => i18n2.str`Barbados`,
  [
    "BW"
    /* CountryCode.BW */
  ]: (i18n2) => i18n2.str`Botswana`,
  [
    "BY"
    /* CountryCode.BY */
  ]: (i18n2) => i18n2.str`Belarus`,
  [
    "BE"
    /* CountryCode.BE */
  ]: (i18n2) => i18n2.str`Belgium`,
  [
    "BZ"
    /* CountryCode.BZ */
  ]: (i18n2) => i18n2.str`Belize`,
  [
    "BJ"
    /* CountryCode.BJ */
  ]: (i18n2) => i18n2.str`Benin`,
  [
    "BT"
    /* CountryCode.BT */
  ]: (i18n2) => i18n2.str`Bhutan`,
  [
    "BO"
    /* CountryCode.BO */
  ]: (i18n2) => i18n2.str`Bolivia`,
  [
    "BA"
    /* CountryCode.BA */
  ]: (i18n2) => i18n2.str`Bosnia and Herzegovina`,
  [
    "BR"
    /* CountryCode.BR */
  ]: (i18n2) => i18n2.str`Brazil`,
  [
    "GB"
    /* CountryCode.GB */
  ]: (i18n2) => i18n2.str`United Kingdom`,
  [
    "BN"
    /* CountryCode.BN */
  ]: (i18n2) => i18n2.str`Brunei`,
  [
    "BG"
    /* CountryCode.BG */
  ]: (i18n2) => i18n2.str`Bulgaria`,
  [
    "BF"
    /* CountryCode.BF */
  ]: (i18n2) => i18n2.str`Burkina Faso`,
  [
    "MM"
    /* CountryCode.MM */
  ]: (i18n2) => i18n2.str`Myanmar`,
  [
    "BI"
    /* CountryCode.BI */
  ]: (i18n2) => i18n2.str`Burundi`,
  [
    "KH"
    /* CountryCode.KH */
  ]: (i18n2) => i18n2.str`Cambodia`,
  [
    "CM"
    /* CountryCode.CM */
  ]: (i18n2) => i18n2.str`Cameroon`,
  [
    "CA"
    /* CountryCode.CA */
  ]: (i18n2) => i18n2.str`Canada`,
  [
    "CV"
    /* CountryCode.CV */
  ]: (i18n2) => i18n2.str`Cape Verde`,
  [
    "CF"
    /* CountryCode.CF */
  ]: (i18n2) => i18n2.str`Central African Republic`,
  [
    "TD"
    /* CountryCode.TD */
  ]: (i18n2) => i18n2.str`Chad`,
  [
    "CL"
    /* CountryCode.CL */
  ]: (i18n2) => i18n2.str`Chile`,
  [
    "CN"
    /* CountryCode.CN */
  ]: (i18n2) => i18n2.str`China`,
  [
    "CO"
    /* CountryCode.CO */
  ]: (i18n2) => i18n2.str`Colombia`,
  [
    "KM"
    /* CountryCode.KM */
  ]: (i18n2) => i18n2.str`Comoros`,
  [
    "CD"
    /* CountryCode.CD */
  ]: (i18n2) => i18n2.str`Democratic Republic of the Congo`,
  [
    "CG"
    /* CountryCode.CG */
  ]: (i18n2) => i18n2.str`Republic of the Congo`,
  [
    "CR"
    /* CountryCode.CR */
  ]: (i18n2) => i18n2.str`Costa Rica`,
  [
    "HR"
    /* CountryCode.HR */
  ]: (i18n2) => i18n2.str`Croatia`,
  [
    "CU"
    /* CountryCode.CU */
  ]: (i18n2) => i18n2.str`Cuba`,
  [
    "CY"
    /* CountryCode.CY */
  ]: (i18n2) => i18n2.str`Cyprus`,
  [
    "CZ"
    /* CountryCode.CZ */
  ]: (i18n2) => i18n2.str`Czech Republic`,
  [
    "DK"
    /* CountryCode.DK */
  ]: (i18n2) => i18n2.str`Denmark`,
  [
    "DJ"
    /* CountryCode.DJ */
  ]: (i18n2) => i18n2.str`Djibouti`,
  [
    "DO"
    /* CountryCode.DO */
  ]: (i18n2) => i18n2.str`Dominican Republic`,
  [
    "NL"
    /* CountryCode.NL */
  ]: (i18n2) => i18n2.str`Netherlands`,
  [
    "TL"
    /* CountryCode.TL */
  ]: (i18n2) => i18n2.str`Timor-Leste`,
  [
    "EC"
    /* CountryCode.EC */
  ]: (i18n2) => i18n2.str`Ecuador`,
  [
    "EG"
    /* CountryCode.EG */
  ]: (i18n2) => i18n2.str`Egypt`,
  [
    "AE"
    /* CountryCode.AE */
  ]: (i18n2) => i18n2.str`United Arab Emirates`,
  [
    "GQ"
    /* CountryCode.GQ */
  ]: (i18n2) => i18n2.str`Equatorial Guinea`,
  [
    "ER"
    /* CountryCode.ER */
  ]: (i18n2) => i18n2.str`Eritrea`,
  [
    "EE"
    /* CountryCode.EE */
  ]: (i18n2) => i18n2.str`Estonia`,
  [
    "ET"
    /* CountryCode.ET */
  ]: (i18n2) => i18n2.str`Ethiopia`,
  [
    "FJ"
    /* CountryCode.FJ */
  ]: (i18n2) => i18n2.str`Fiji`,
  [
    "PH"
    /* CountryCode.PH */
  ]: (i18n2) => i18n2.str`Philippines`,
  [
    "FI"
    /* CountryCode.FI */
  ]: (i18n2) => i18n2.str`Finland`,
  [
    "FR"
    /* CountryCode.FR */
  ]: (i18n2) => i18n2.str`France`,
  [
    "GA"
    /* CountryCode.GA */
  ]: (i18n2) => i18n2.str`Gabon`,
  [
    "GM"
    /* CountryCode.GM */
  ]: (i18n2) => i18n2.str`Gambia`,
  [
    "GE"
    /* CountryCode.GE */
  ]: (i18n2) => i18n2.str`Georgia`,
  [
    "DE"
    /* CountryCode.DE */
  ]: (i18n2) => i18n2.str`Germany`,
  [
    "GH"
    /* CountryCode.GH */
  ]: (i18n2) => i18n2.str`Ghana`,
  [
    "GR"
    /* CountryCode.GR */
  ]: (i18n2) => i18n2.str`Greece`,
  [
    "GD"
    /* CountryCode.GD */
  ]: (i18n2) => i18n2.str`Grenada`,
  [
    "GT"
    /* CountryCode.GT */
  ]: (i18n2) => i18n2.str`Guatemala`,
  [
    "GW"
    /* CountryCode.GW */
  ]: (i18n2) => i18n2.str`Guinea-Bissau`,
  [
    "GN"
    /* CountryCode.GN */
  ]: (i18n2) => i18n2.str`Guinea`,
  [
    "GY"
    /* CountryCode.GY */
  ]: (i18n2) => i18n2.str`Guyana`,
  [
    "HT"
    /* CountryCode.HT */
  ]: (i18n2) => i18n2.str`Haiti`,
  [
    "HN"
    /* CountryCode.HN */
  ]: (i18n2) => i18n2.str`Honduras`,
  [
    "HU"
    /* CountryCode.HU */
  ]: (i18n2) => i18n2.str`Hungary`,
  [
    "KI"
    /* CountryCode.KI */
  ]: (i18n2) => i18n2.str`Kiribati`,
  [
    "IS"
    /* CountryCode.IS */
  ]: (i18n2) => i18n2.str`Iceland`,
  [
    "IN"
    /* CountryCode.IN */
  ]: (i18n2) => i18n2.str`India`,
  [
    "ID"
    /* CountryCode.ID */
  ]: (i18n2) => i18n2.str`Indonesia`,
  [
    "IR"
    /* CountryCode.IR */
  ]: (i18n2) => i18n2.str`Iran`,
  [
    "IQ"
    /* CountryCode.IQ */
  ]: (i18n2) => i18n2.str`Iraq`,
  [
    "IE"
    /* CountryCode.IE */
  ]: (i18n2) => i18n2.str`Ireland`,
  [
    "IL"
    /* CountryCode.IL */
  ]: (i18n2) => i18n2.str`Israel`,
  [
    "IT"
    /* CountryCode.IT */
  ]: (i18n2) => i18n2.str`Italy`,
  [
    "CI"
    /* CountryCode.CI */
  ]: (i18n2) => i18n2.str`Ivory Coast`,
  [
    "JM"
    /* CountryCode.JM */
  ]: (i18n2) => i18n2.str`Jamaica`,
  [
    "JP"
    /* CountryCode.JP */
  ]: (i18n2) => i18n2.str`Japan`,
  [
    "JO"
    /* CountryCode.JO */
  ]: (i18n2) => i18n2.str`Jordan`,
  [
    "KZ"
    /* CountryCode.KZ */
  ]: (i18n2) => i18n2.str`Kazakhstan`,
  [
    "KE"
    /* CountryCode.KE */
  ]: (i18n2) => i18n2.str`Kenya`,
  [
    "KN"
    /* CountryCode.KN */
  ]: (i18n2) => i18n2.str`Saint Kitts and Nevis`,
  [
    "KW"
    /* CountryCode.KW */
  ]: (i18n2) => i18n2.str`Kuwait`,
  [
    "KG"
    /* CountryCode.KG */
  ]: (i18n2) => i18n2.str`Kyrgyzstan`,
  [
    "LA"
    /* CountryCode.LA */
  ]: (i18n2) => i18n2.str`Laos`,
  [
    "LV"
    /* CountryCode.LV */
  ]: (i18n2) => i18n2.str`Latvia`,
  [
    "LB"
    /* CountryCode.LB */
  ]: (i18n2) => i18n2.str`Lebanon`,
  [
    "LR"
    /* CountryCode.LR */
  ]: (i18n2) => i18n2.str`Liberia`,
  [
    "LY"
    /* CountryCode.LY */
  ]: (i18n2) => i18n2.str`Libya`,
  [
    "LI"
    /* CountryCode.LI */
  ]: (i18n2) => i18n2.str`Liechtenstein`,
  [
    "LT"
    /* CountryCode.LT */
  ]: (i18n2) => i18n2.str`Lithuania`,
  [
    "LU"
    /* CountryCode.LU */
  ]: (i18n2) => i18n2.str`Luxembourg`,
  [
    "MK"
    /* CountryCode.MK */
  ]: (i18n2) => i18n2.str`North Macedonia`,
  [
    "MG"
    /* CountryCode.MG */
  ]: (i18n2) => i18n2.str`Madagascar`,
  [
    "MW"
    /* CountryCode.MW */
  ]: (i18n2) => i18n2.str`Malawi`,
  [
    "MY"
    /* CountryCode.MY */
  ]: (i18n2) => i18n2.str`Malaysia`,
  [
    "MV"
    /* CountryCode.MV */
  ]: (i18n2) => i18n2.str`Maldives`,
  [
    "ML"
    /* CountryCode.ML */
  ]: (i18n2) => i18n2.str`Mali`,
  [
    "MT"
    /* CountryCode.MT */
  ]: (i18n2) => i18n2.str`Malta`,
  [
    "MH"
    /* CountryCode.MH */
  ]: (i18n2) => i18n2.str`Marshall Islands`,
  [
    "MR"
    /* CountryCode.MR */
  ]: (i18n2) => i18n2.str`Mauritania`,
  [
    "MU"
    /* CountryCode.MU */
  ]: (i18n2) => i18n2.str`Mauritius`,
  [
    "MX"
    /* CountryCode.MX */
  ]: (i18n2) => i18n2.str`Mexico`,
  [
    "FM"
    /* CountryCode.FM */
  ]: (i18n2) => i18n2.str`Micronesia`,
  [
    "MD"
    /* CountryCode.MD */
  ]: (i18n2) => i18n2.str`Moldova`,
  [
    "MC"
    /* CountryCode.MC */
  ]: (i18n2) => i18n2.str`Monaco`,
  [
    "MN"
    /* CountryCode.MN */
  ]: (i18n2) => i18n2.str`Mongolia`,
  [
    "MA"
    /* CountryCode.MA */
  ]: (i18n2) => i18n2.str`Morocco`,
  [
    "LS"
    /* CountryCode.LS */
  ]: (i18n2) => i18n2.str`Lesotho`,
  [
    "MZ"
    /* CountryCode.MZ */
  ]: (i18n2) => i18n2.str`Mozambique`,
  [
    "NA"
    /* CountryCode.NA */
  ]: (i18n2) => i18n2.str`Namibia`,
  [
    "NR"
    /* CountryCode.NR */
  ]: (i18n2) => i18n2.str`Nauru`,
  [
    "NP"
    /* CountryCode.NP */
  ]: (i18n2) => i18n2.str`Nepal`,
  [
    "NZ"
    /* CountryCode.NZ */
  ]: (i18n2) => i18n2.str`New Zealand`,
  [
    "VU"
    /* CountryCode.VU */
  ]: (i18n2) => i18n2.str`Vanuatu`,
  [
    "NI"
    /* CountryCode.NI */
  ]: (i18n2) => i18n2.str`Nicaragua`,
  [
    "NG"
    /* CountryCode.NG */
  ]: (i18n2) => i18n2.str`Nigeria`,
  [
    "NE"
    /* CountryCode.NE */
  ]: (i18n2) => i18n2.str`Niger`,
  [
    "KP"
    /* CountryCode.KP */
  ]: (i18n2) => i18n2.str`North Korea`,
  [
    "NO"
    /* CountryCode.NO */
  ]: (i18n2) => i18n2.str`Norway`,
  [
    "OM"
    /* CountryCode.OM */
  ]: (i18n2) => i18n2.str`Oman`,
  [
    "PK"
    /* CountryCode.PK */
  ]: (i18n2) => i18n2.str`Pakistan`,
  [
    "PW"
    /* CountryCode.PW */
  ]: (i18n2) => i18n2.str`Palau`,
  [
    "PA"
    /* CountryCode.PA */
  ]: (i18n2) => i18n2.str`Panama`,
  [
    "PG"
    /* CountryCode.PG */
  ]: (i18n2) => i18n2.str`Papua New Guinea`,
  [
    "PY"
    /* CountryCode.PY */
  ]: (i18n2) => i18n2.str`Paraguay`,
  [
    "PE"
    /* CountryCode.PE */
  ]: (i18n2) => i18n2.str`Peru`,
  [
    "PL"
    /* CountryCode.PL */
  ]: (i18n2) => i18n2.str`Poland`,
  [
    "PT"
    /* CountryCode.PT */
  ]: (i18n2) => i18n2.str`Portugal`,
  [
    "QA"
    /* CountryCode.QA */
  ]: (i18n2) => i18n2.str`Qatar`,
  [
    "RO"
    /* CountryCode.RO */
  ]: (i18n2) => i18n2.str`Romania`,
  [
    "RU"
    /* CountryCode.RU */
  ]: (i18n2) => i18n2.str`Russia`,
  [
    "RW"
    /* CountryCode.RW */
  ]: (i18n2) => i18n2.str`Rwanda`,
  [
    "LC"
    /* CountryCode.LC */
  ]: (i18n2) => i18n2.str`Saint Lucia`,
  [
    "SV"
    /* CountryCode.SV */
  ]: (i18n2) => i18n2.str`El Salvador`,
  [
    "WS"
    /* CountryCode.WS */
  ]: (i18n2) => i18n2.str`Samoa`,
  [
    "SM"
    /* CountryCode.SM */
  ]: (i18n2) => i18n2.str`San Marino`,
  [
    "ST"
    /* CountryCode.ST */
  ]: (i18n2) => i18n2.str`São Tomé and Príncipe`,
  [
    "SA"
    /* CountryCode.SA */
  ]: (i18n2) => i18n2.str`Saudi Arabia`,
  [
    "SN"
    /* CountryCode.SN */
  ]: (i18n2) => i18n2.str`Senegal`,
  [
    "RS"
    /* CountryCode.RS */
  ]: (i18n2) => i18n2.str`Serbia`,
  [
    "SC"
    /* CountryCode.SC */
  ]: (i18n2) => i18n2.str`Seychelles`,
  [
    "SL"
    /* CountryCode.SL */
  ]: (i18n2) => i18n2.str`Sierra Leone`,
  [
    "SG"
    /* CountryCode.SG */
  ]: (i18n2) => i18n2.str`Singapore`,
  [
    "SK"
    /* CountryCode.SK */
  ]: (i18n2) => i18n2.str`Slovakia`,
  [
    "SI"
    /* CountryCode.SI */
  ]: (i18n2) => i18n2.str`Slovenia`,
  [
    "SB"
    /* CountryCode.SB */
  ]: (i18n2) => i18n2.str`Solomon Islands`,
  [
    "SO"
    /* CountryCode.SO */
  ]: (i18n2) => i18n2.str`Somalia`,
  [
    "ZA"
    /* CountryCode.ZA */
  ]: (i18n2) => i18n2.str`South Africa`,
  [
    "KR"
    /* CountryCode.KR */
  ]: (i18n2) => i18n2.str`South Korea`,
  [
    "ES"
    /* CountryCode.ES */
  ]: (i18n2) => i18n2.str`Spain`,
  [
    "LK"
    /* CountryCode.LK */
  ]: (i18n2) => i18n2.str`Sri Lanka`,
  [
    "SD"
    /* CountryCode.SD */
  ]: (i18n2) => i18n2.str`Sudan`,
  [
    "SR"
    /* CountryCode.SR */
  ]: (i18n2) => i18n2.str`Suriname`,
  [
    "SZ"
    /* CountryCode.SZ */
  ]: (i18n2) => i18n2.str`Eswatini`,
  [
    "SE"
    /* CountryCode.SE */
  ]: (i18n2) => i18n2.str`Sweden`,
  [
    "CH"
    /* CountryCode.CH */
  ]: (i18n2) => i18n2.str`Switzerland`,
  [
    "SY"
    /* CountryCode.SY */
  ]: (i18n2) => i18n2.str`Syria`,
  [
    "TW"
    /* CountryCode.TW */
  ]: (i18n2) => i18n2.str`Taiwan`,
  [
    "TJ"
    /* CountryCode.TJ */
  ]: (i18n2) => i18n2.str`Tajikistan`,
  [
    "TZ"
    /* CountryCode.TZ */
  ]: (i18n2) => i18n2.str`Tanzania`,
  [
    "TH"
    /* CountryCode.TH */
  ]: (i18n2) => i18n2.str`Thailand`,
  [
    "TG"
    /* CountryCode.TG */
  ]: (i18n2) => i18n2.str`Togo`,
  [
    "TO"
    /* CountryCode.TO */
  ]: (i18n2) => i18n2.str`Tonga`,
  [
    "TT"
    /* CountryCode.TT */
  ]: (i18n2) => i18n2.str`Trinidad and Tobago`,
  [
    "TN"
    /* CountryCode.TN */
  ]: (i18n2) => i18n2.str`Tunisia`,
  [
    "TR"
    /* CountryCode.TR */
  ]: (i18n2) => i18n2.str`Turkey`,
  [
    "TV"
    /* CountryCode.TV */
  ]: (i18n2) => i18n2.str`Tuvalu`,
  [
    "UG"
    /* CountryCode.UG */
  ]: (i18n2) => i18n2.str`Uganda`,
  [
    "UA"
    /* CountryCode.UA */
  ]: (i18n2) => i18n2.str`Ukraine`,
  [
    "UY"
    /* CountryCode.UY */
  ]: (i18n2) => i18n2.str`Uruguay`,
  [
    "UZ"
    /* CountryCode.UZ */
  ]: (i18n2) => i18n2.str`Uzbekistan`,
  [
    "VE"
    /* CountryCode.VE */
  ]: (i18n2) => i18n2.str`Venezuela`,
  [
    "VN"
    /* CountryCode.VN */
  ]: (i18n2) => i18n2.str`Vietnam`,
  [
    "YE"
    /* CountryCode.YE */
  ]: (i18n2) => i18n2.str`Yemen`,
  [
    "ZM"
    /* CountryCode.ZM */
  ]: (i18n2) => i18n2.str`Zambia`,
  [
    "ZW"
    /* CountryCode.ZW */
  ]: (i18n2) => i18n2.str`Zimbabwe`
};
var countryNationalitiesByCode = {
  [
    "AF"
    /* CountryCode.AF */
  ]: (i18n2) => i18n2.str`Afghan`,
  [
    "AL"
    /* CountryCode.AL */
  ]: (i18n2) => i18n2.str`Albanian`,
  [
    "DZ"
    /* CountryCode.DZ */
  ]: (i18n2) => i18n2.str`Algerian`,
  [
    "US"
    /* CountryCode.US */
  ]: (i18n2) => i18n2.str`American`,
  [
    "AD"
    /* CountryCode.AD */
  ]: (i18n2) => i18n2.str`Andorran`,
  [
    "AO"
    /* CountryCode.AO */
  ]: (i18n2) => i18n2.str`Angolan`,
  [
    "AG"
    /* CountryCode.AG */
  ]: (i18n2) => i18n2.str`Antiguan`,
  [
    "AR"
    /* CountryCode.AR */
  ]: (i18n2) => i18n2.str`Argentinean`,
  [
    "AM"
    /* CountryCode.AM */
  ]: (i18n2) => i18n2.str`Armenian`,
  [
    "AU"
    /* CountryCode.AU */
  ]: (i18n2) => i18n2.str`Australian`,
  [
    "AT"
    /* CountryCode.AT */
  ]: (i18n2) => i18n2.str`Austrian`,
  [
    "AZ"
    /* CountryCode.AZ */
  ]: (i18n2) => i18n2.str`Azerbaijani`,
  [
    "BS"
    /* CountryCode.BS */
  ]: (i18n2) => i18n2.str`Bahamian`,
  [
    "BH"
    /* CountryCode.BH */
  ]: (i18n2) => i18n2.str`Bahraini`,
  [
    "BD"
    /* CountryCode.BD */
  ]: (i18n2) => i18n2.str`Bangladeshi`,
  [
    "BB"
    /* CountryCode.BB */
  ]: (i18n2) => i18n2.str`Barbadian`,
  [
    "BW"
    /* CountryCode.BW */
  ]: (i18n2) => i18n2.str`Batswana`,
  [
    "BY"
    /* CountryCode.BY */
  ]: (i18n2) => i18n2.str`Belarusian`,
  [
    "BE"
    /* CountryCode.BE */
  ]: (i18n2) => i18n2.str`Belgian`,
  [
    "BZ"
    /* CountryCode.BZ */
  ]: (i18n2) => i18n2.str`Belizean`,
  [
    "BJ"
    /* CountryCode.BJ */
  ]: (i18n2) => i18n2.str`Beninese`,
  [
    "BT"
    /* CountryCode.BT */
  ]: (i18n2) => i18n2.str`Bhutanese`,
  [
    "BO"
    /* CountryCode.BO */
  ]: (i18n2) => i18n2.str`Bolivian`,
  [
    "BA"
    /* CountryCode.BA */
  ]: (i18n2) => i18n2.str`Bosnian`,
  [
    "BR"
    /* CountryCode.BR */
  ]: (i18n2) => i18n2.str`Brazilian`,
  [
    "GB"
    /* CountryCode.GB */
  ]: (i18n2) => i18n2.str`British`,
  [
    "BN"
    /* CountryCode.BN */
  ]: (i18n2) => i18n2.str`Bruneian`,
  [
    "BG"
    /* CountryCode.BG */
  ]: (i18n2) => i18n2.str`Bulgarian`,
  [
    "BF"
    /* CountryCode.BF */
  ]: (i18n2) => i18n2.str`Burkinabe`,
  [
    "MM"
    /* CountryCode.MM */
  ]: (i18n2) => i18n2.str`Burmese`,
  [
    "BI"
    /* CountryCode.BI */
  ]: (i18n2) => i18n2.str`Burundian`,
  [
    "KH"
    /* CountryCode.KH */
  ]: (i18n2) => i18n2.str`Cambodian`,
  [
    "CM"
    /* CountryCode.CM */
  ]: (i18n2) => i18n2.str`Cameroonian`,
  [
    "CA"
    /* CountryCode.CA */
  ]: (i18n2) => i18n2.str`Canadian`,
  [
    "CV"
    /* CountryCode.CV */
  ]: (i18n2) => i18n2.str`Cape Verdean`,
  [
    "CF"
    /* CountryCode.CF */
  ]: (i18n2) => i18n2.str`Central African`,
  [
    "TD"
    /* CountryCode.TD */
  ]: (i18n2) => i18n2.str`Chadian`,
  [
    "CL"
    /* CountryCode.CL */
  ]: (i18n2) => i18n2.str`Chilean`,
  [
    "CN"
    /* CountryCode.CN */
  ]: (i18n2) => i18n2.str`Chinese`,
  [
    "CO"
    /* CountryCode.CO */
  ]: (i18n2) => i18n2.str`Colombian`,
  [
    "KM"
    /* CountryCode.KM */
  ]: (i18n2) => i18n2.str`Comoran`,
  [
    "CD"
    /* CountryCode.CD */
  ]: (i18n2) => i18n2.str`Congolese`,
  [
    "CG"
    /* CountryCode.CG */
  ]: (i18n2) => i18n2.str`Congolese`,
  [
    "CR"
    /* CountryCode.CR */
  ]: (i18n2) => i18n2.str`Costa Rican`,
  [
    "HR"
    /* CountryCode.HR */
  ]: (i18n2) => i18n2.str`Croatian`,
  [
    "CU"
    /* CountryCode.CU */
  ]: (i18n2) => i18n2.str`Cuban`,
  [
    "CY"
    /* CountryCode.CY */
  ]: (i18n2) => i18n2.str`Cypriot`,
  [
    "CZ"
    /* CountryCode.CZ */
  ]: (i18n2) => i18n2.str`Czech`,
  [
    "DK"
    /* CountryCode.DK */
  ]: (i18n2) => i18n2.str`Danish`,
  [
    "DJ"
    /* CountryCode.DJ */
  ]: (i18n2) => i18n2.str`Djiboutian`,
  [
    "DO"
    /* CountryCode.DO */
  ]: (i18n2) => i18n2.str`Dominican`,
  [
    "NL"
    /* CountryCode.NL */
  ]: (i18n2) => i18n2.str`Dutch`,
  [
    "TL"
    /* CountryCode.TL */
  ]: (i18n2) => i18n2.str`East Timorese`,
  [
    "EC"
    /* CountryCode.EC */
  ]: (i18n2) => i18n2.str`Ecuadorean`,
  [
    "EG"
    /* CountryCode.EG */
  ]: (i18n2) => i18n2.str`Egyptian`,
  [
    "AE"
    /* CountryCode.AE */
  ]: (i18n2) => i18n2.str`Emirati`,
  [
    "GQ"
    /* CountryCode.GQ */
  ]: (i18n2) => i18n2.str`Equatorial Guinean`,
  [
    "ER"
    /* CountryCode.ER */
  ]: (i18n2) => i18n2.str`Eritrean`,
  [
    "EE"
    /* CountryCode.EE */
  ]: (i18n2) => i18n2.str`Estonian`,
  [
    "ET"
    /* CountryCode.ET */
  ]: (i18n2) => i18n2.str`Ethiopian`,
  [
    "FJ"
    /* CountryCode.FJ */
  ]: (i18n2) => i18n2.str`Fijian`,
  [
    "PH"
    /* CountryCode.PH */
  ]: (i18n2) => i18n2.str`Filipino`,
  [
    "FI"
    /* CountryCode.FI */
  ]: (i18n2) => i18n2.str`Finnish`,
  [
    "FR"
    /* CountryCode.FR */
  ]: (i18n2) => i18n2.str`French`,
  [
    "GA"
    /* CountryCode.GA */
  ]: (i18n2) => i18n2.str`Gabonese`,
  [
    "GM"
    /* CountryCode.GM */
  ]: (i18n2) => i18n2.str`Gambian`,
  [
    "GE"
    /* CountryCode.GE */
  ]: (i18n2) => i18n2.str`Georgian`,
  [
    "DE"
    /* CountryCode.DE */
  ]: (i18n2) => i18n2.str`German`,
  [
    "GH"
    /* CountryCode.GH */
  ]: (i18n2) => i18n2.str`Ghanaian`,
  [
    "GR"
    /* CountryCode.GR */
  ]: (i18n2) => i18n2.str`Greek`,
  [
    "GD"
    /* CountryCode.GD */
  ]: (i18n2) => i18n2.str`Grenadian`,
  [
    "GT"
    /* CountryCode.GT */
  ]: (i18n2) => i18n2.str`Guatemalan`,
  [
    "GW"
    /* CountryCode.GW */
  ]: (i18n2) => i18n2.str`Guinea-Bissauan`,
  [
    "GN"
    /* CountryCode.GN */
  ]: (i18n2) => i18n2.str`Guinean`,
  [
    "GY"
    /* CountryCode.GY */
  ]: (i18n2) => i18n2.str`Guyanese`,
  [
    "HT"
    /* CountryCode.HT */
  ]: (i18n2) => i18n2.str`Haitian`,
  [
    "HN"
    /* CountryCode.HN */
  ]: (i18n2) => i18n2.str`Honduran`,
  [
    "HU"
    /* CountryCode.HU */
  ]: (i18n2) => i18n2.str`Hungarian`,
  [
    "KI"
    /* CountryCode.KI */
  ]: (i18n2) => i18n2.str`I-Kiribati`,
  [
    "IS"
    /* CountryCode.IS */
  ]: (i18n2) => i18n2.str`Icelander`,
  [
    "IN"
    /* CountryCode.IN */
  ]: (i18n2) => i18n2.str`Indian`,
  [
    "ID"
    /* CountryCode.ID */
  ]: (i18n2) => i18n2.str`Indonesian`,
  [
    "IR"
    /* CountryCode.IR */
  ]: (i18n2) => i18n2.str`Iranian`,
  [
    "IQ"
    /* CountryCode.IQ */
  ]: (i18n2) => i18n2.str`Iraqi`,
  [
    "IE"
    /* CountryCode.IE */
  ]: (i18n2) => i18n2.str`Irish`,
  [
    "IL"
    /* CountryCode.IL */
  ]: (i18n2) => i18n2.str`Israeli`,
  [
    "IT"
    /* CountryCode.IT */
  ]: (i18n2) => i18n2.str`Italian`,
  [
    "CI"
    /* CountryCode.CI */
  ]: (i18n2) => i18n2.str`Ivorian`,
  [
    "JM"
    /* CountryCode.JM */
  ]: (i18n2) => i18n2.str`Jamaican`,
  [
    "JP"
    /* CountryCode.JP */
  ]: (i18n2) => i18n2.str`Japanese`,
  [
    "JO"
    /* CountryCode.JO */
  ]: (i18n2) => i18n2.str`Jordanian`,
  [
    "KZ"
    /* CountryCode.KZ */
  ]: (i18n2) => i18n2.str`Kazakhstani`,
  [
    "KE"
    /* CountryCode.KE */
  ]: (i18n2) => i18n2.str`Kenyan`,
  [
    "KN"
    /* CountryCode.KN */
  ]: (i18n2) => i18n2.str`Kittian and Nevisian`,
  [
    "KW"
    /* CountryCode.KW */
  ]: (i18n2) => i18n2.str`Kuwaiti`,
  [
    "KG"
    /* CountryCode.KG */
  ]: (i18n2) => i18n2.str`Kyrgyz`,
  [
    "LA"
    /* CountryCode.LA */
  ]: (i18n2) => i18n2.str`Laotian`,
  [
    "LV"
    /* CountryCode.LV */
  ]: (i18n2) => i18n2.str`Latvian`,
  [
    "LB"
    /* CountryCode.LB */
  ]: (i18n2) => i18n2.str`Lebanese`,
  [
    "LR"
    /* CountryCode.LR */
  ]: (i18n2) => i18n2.str`Liberian`,
  [
    "LY"
    /* CountryCode.LY */
  ]: (i18n2) => i18n2.str`Libyan`,
  [
    "LI"
    /* CountryCode.LI */
  ]: (i18n2) => i18n2.str`Liechtensteiner`,
  [
    "LT"
    /* CountryCode.LT */
  ]: (i18n2) => i18n2.str`Lithuanian`,
  [
    "LU"
    /* CountryCode.LU */
  ]: (i18n2) => i18n2.str`Luxembourger`,
  [
    "MK"
    /* CountryCode.MK */
  ]: (i18n2) => i18n2.str`Macedonian`,
  [
    "MG"
    /* CountryCode.MG */
  ]: (i18n2) => i18n2.str`Malagasy`,
  [
    "MW"
    /* CountryCode.MW */
  ]: (i18n2) => i18n2.str`Malawian`,
  [
    "MY"
    /* CountryCode.MY */
  ]: (i18n2) => i18n2.str`Malaysian`,
  [
    "MV"
    /* CountryCode.MV */
  ]: (i18n2) => i18n2.str`Maldivian`,
  [
    "ML"
    /* CountryCode.ML */
  ]: (i18n2) => i18n2.str`Malian`,
  [
    "MT"
    /* CountryCode.MT */
  ]: (i18n2) => i18n2.str`Maltese`,
  [
    "MH"
    /* CountryCode.MH */
  ]: (i18n2) => i18n2.str`Marshallese`,
  [
    "MR"
    /* CountryCode.MR */
  ]: (i18n2) => i18n2.str`Mauritanian`,
  [
    "MU"
    /* CountryCode.MU */
  ]: (i18n2) => i18n2.str`Mauritian`,
  [
    "MX"
    /* CountryCode.MX */
  ]: (i18n2) => i18n2.str`Mexican`,
  [
    "FM"
    /* CountryCode.FM */
  ]: (i18n2) => i18n2.str`Micronesian`,
  [
    "MD"
    /* CountryCode.MD */
  ]: (i18n2) => i18n2.str`Moldovan`,
  [
    "MC"
    /* CountryCode.MC */
  ]: (i18n2) => i18n2.str`Monacan`,
  [
    "MN"
    /* CountryCode.MN */
  ]: (i18n2) => i18n2.str`Mongolian`,
  [
    "MA"
    /* CountryCode.MA */
  ]: (i18n2) => i18n2.str`Moroccan`,
  [
    "LS"
    /* CountryCode.LS */
  ]: (i18n2) => i18n2.str`Mosotho`,
  [
    "MZ"
    /* CountryCode.MZ */
  ]: (i18n2) => i18n2.str`Mozambican`,
  [
    "NA"
    /* CountryCode.NA */
  ]: (i18n2) => i18n2.str`Namibian`,
  [
    "NR"
    /* CountryCode.NR */
  ]: (i18n2) => i18n2.str`Nauruan`,
  [
    "NP"
    /* CountryCode.NP */
  ]: (i18n2) => i18n2.str`Nepalese`,
  [
    "NZ"
    /* CountryCode.NZ */
  ]: (i18n2) => i18n2.str`New Zealander`,
  [
    "VU"
    /* CountryCode.VU */
  ]: (i18n2) => i18n2.str`Ni-Vanuatu`,
  [
    "NI"
    /* CountryCode.NI */
  ]: (i18n2) => i18n2.str`Nicaraguan`,
  [
    "NG"
    /* CountryCode.NG */
  ]: (i18n2) => i18n2.str`Nigerian`,
  [
    "NE"
    /* CountryCode.NE */
  ]: (i18n2) => i18n2.str`Nigerien`,
  [
    "KP"
    /* CountryCode.KP */
  ]: (i18n2) => i18n2.str`North Korean`,
  [
    "NO"
    /* CountryCode.NO */
  ]: (i18n2) => i18n2.str`Norwegian`,
  [
    "OM"
    /* CountryCode.OM */
  ]: (i18n2) => i18n2.str`Omani`,
  [
    "PK"
    /* CountryCode.PK */
  ]: (i18n2) => i18n2.str`Pakistani`,
  [
    "PW"
    /* CountryCode.PW */
  ]: (i18n2) => i18n2.str`Palauan`,
  [
    "PA"
    /* CountryCode.PA */
  ]: (i18n2) => i18n2.str`Panamanian`,
  [
    "PG"
    /* CountryCode.PG */
  ]: (i18n2) => i18n2.str`Papua New Guinean`,
  [
    "PY"
    /* CountryCode.PY */
  ]: (i18n2) => i18n2.str`Paraguayan`,
  [
    "PE"
    /* CountryCode.PE */
  ]: (i18n2) => i18n2.str`Peruvian`,
  [
    "PL"
    /* CountryCode.PL */
  ]: (i18n2) => i18n2.str`Polish`,
  [
    "PT"
    /* CountryCode.PT */
  ]: (i18n2) => i18n2.str`Portuguese`,
  [
    "QA"
    /* CountryCode.QA */
  ]: (i18n2) => i18n2.str`Qatari`,
  [
    "RO"
    /* CountryCode.RO */
  ]: (i18n2) => i18n2.str`Romanian`,
  [
    "RU"
    /* CountryCode.RU */
  ]: (i18n2) => i18n2.str`Russian`,
  [
    "RW"
    /* CountryCode.RW */
  ]: (i18n2) => i18n2.str`Rwandan`,
  [
    "LC"
    /* CountryCode.LC */
  ]: (i18n2) => i18n2.str`Saint Lucian`,
  [
    "SV"
    /* CountryCode.SV */
  ]: (i18n2) => i18n2.str`Salvadoran`,
  [
    "WS"
    /* CountryCode.WS */
  ]: (i18n2) => i18n2.str`Samoan`,
  [
    "SM"
    /* CountryCode.SM */
  ]: (i18n2) => i18n2.str`San Marinese`,
  [
    "ST"
    /* CountryCode.ST */
  ]: (i18n2) => i18n2.str`Sao Tomean`,
  [
    "SA"
    /* CountryCode.SA */
  ]: (i18n2) => i18n2.str`Saudi`,
  [
    "SN"
    /* CountryCode.SN */
  ]: (i18n2) => i18n2.str`Senegalese`,
  [
    "RS"
    /* CountryCode.RS */
  ]: (i18n2) => i18n2.str`Serbian`,
  [
    "SC"
    /* CountryCode.SC */
  ]: (i18n2) => i18n2.str`Seychellois`,
  [
    "SL"
    /* CountryCode.SL */
  ]: (i18n2) => i18n2.str`Sierra Leonean`,
  [
    "SG"
    /* CountryCode.SG */
  ]: (i18n2) => i18n2.str`Singaporean`,
  [
    "SK"
    /* CountryCode.SK */
  ]: (i18n2) => i18n2.str`Slovakian`,
  [
    "SI"
    /* CountryCode.SI */
  ]: (i18n2) => i18n2.str`Slovenian`,
  [
    "SB"
    /* CountryCode.SB */
  ]: (i18n2) => i18n2.str`Solomon Islander`,
  [
    "SO"
    /* CountryCode.SO */
  ]: (i18n2) => i18n2.str`Somali`,
  [
    "ZA"
    /* CountryCode.ZA */
  ]: (i18n2) => i18n2.str`South African`,
  [
    "KR"
    /* CountryCode.KR */
  ]: (i18n2) => i18n2.str`South Korean`,
  [
    "ES"
    /* CountryCode.ES */
  ]: (i18n2) => i18n2.str`Spanish`,
  [
    "LK"
    /* CountryCode.LK */
  ]: (i18n2) => i18n2.str`Sri Lankan`,
  [
    "SD"
    /* CountryCode.SD */
  ]: (i18n2) => i18n2.str`Sudanese`,
  [
    "SR"
    /* CountryCode.SR */
  ]: (i18n2) => i18n2.str`Surinamer`,
  [
    "SZ"
    /* CountryCode.SZ */
  ]: (i18n2) => i18n2.str`Swazi`,
  [
    "SE"
    /* CountryCode.SE */
  ]: (i18n2) => i18n2.str`Swedish`,
  [
    "CH"
    /* CountryCode.CH */
  ]: (i18n2) => i18n2.str`Swiss`,
  [
    "SY"
    /* CountryCode.SY */
  ]: (i18n2) => i18n2.str`Syrian`,
  [
    "TW"
    /* CountryCode.TW */
  ]: (i18n2) => i18n2.str`Taiwanese`,
  [
    "TJ"
    /* CountryCode.TJ */
  ]: (i18n2) => i18n2.str`Tajik`,
  [
    "TZ"
    /* CountryCode.TZ */
  ]: (i18n2) => i18n2.str`Tanzanian`,
  [
    "TH"
    /* CountryCode.TH */
  ]: (i18n2) => i18n2.str`Thai`,
  [
    "TG"
    /* CountryCode.TG */
  ]: (i18n2) => i18n2.str`Togolese`,
  [
    "TO"
    /* CountryCode.TO */
  ]: (i18n2) => i18n2.str`Tongan`,
  [
    "TT"
    /* CountryCode.TT */
  ]: (i18n2) => i18n2.str`Trinidadian or Tobagonian`,
  [
    "TN"
    /* CountryCode.TN */
  ]: (i18n2) => i18n2.str`Tunisian`,
  [
    "TR"
    /* CountryCode.TR */
  ]: (i18n2) => i18n2.str`Turkish`,
  [
    "TV"
    /* CountryCode.TV */
  ]: (i18n2) => i18n2.str`Tuvaluan`,
  [
    "UG"
    /* CountryCode.UG */
  ]: (i18n2) => i18n2.str`Ugandan`,
  [
    "UA"
    /* CountryCode.UA */
  ]: (i18n2) => i18n2.str`Ukrainian`,
  [
    "UY"
    /* CountryCode.UY */
  ]: (i18n2) => i18n2.str`Uruguayan`,
  [
    "UZ"
    /* CountryCode.UZ */
  ]: (i18n2) => i18n2.str`Uzbekistani`,
  [
    "VE"
    /* CountryCode.VE */
  ]: (i18n2) => i18n2.str`Venezuelan`,
  [
    "VN"
    /* CountryCode.VN */
  ]: (i18n2) => i18n2.str`Vietnamese`,
  [
    "YE"
    /* CountryCode.YE */
  ]: (i18n2) => i18n2.str`Yemenite`,
  [
    "ZM"
    /* CountryCode.ZM */
  ]: (i18n2) => i18n2.str`Zambian`,
  [
    "ZW"
    /* CountryCode.ZW */
  ]: (i18n2) => i18n2.str`Zimbabwean`
};

// ../taler-util/lib/index.browser.js
loadBrowserPrng();

// ../web-util/lib/index.browser.mjs
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_compat_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_hooks_module();
init_preact_module();
init_preact_module();
init_preact_module();
init_hooks_module();
var __defProp2 = Object.defineProperty;
var __export2 = (target, all) => {
  for (var name in all)
    __defProp2(target, name, { get: all[name], enumerable: true });
};
var utils_exports = {};
__export2(utils_exports, {
  compose: () => compose,
  composeRef: () => composeRef,
  doAutoFocus: () => doAutoFocus,
  doAutoFocusWithScroll: () => doAutoFocusWithScroll,
  onComponentUnload: () => onComponentUnload,
  preconnectAs: () => preconnectAs,
  recursive: () => recursive,
  saveRef: () => saveRef,
  saveVNodeForInspection: () => saveVNodeForInspection
});
function compose(hook, viewMap) {
  function withHook(stateHook) {
    function ComposedComponent() {
      const state = stateHook();
      if (typeof state === "function") {
        const subComponent = withHook(state);
        return h(subComponent, {});
      }
      const statusName = state.status;
      const viewComponent = viewMap[statusName];
      return h(viewComponent, state);
    }
    return ComposedComponent;
  }
  return (p4) => {
    const h53 = withHook(() => hook(p4));
    return h53();
  };
}
function recursive(hook) {
  function withHook(stateHook) {
    function ComposedComponent() {
      const state = stateHook();
      if (typeof state === "function") {
        const subComponent = withHook(state);
        return h(subComponent, {});
      }
      return state;
    }
    return ComposedComponent;
  }
  return (p4) => {
    const h53 = withHook(() => hook(p4));
    return h53();
  };
}
function onComponentUnload(callback) {
  const ref = _2();
  ref.current = callback;
  h2(() => {
    return () => {
      ref.current();
    };
  }, []);
}
var ownerDocument = typeof document === "undefined" ? null : document;
var preconnectsSet = /* @__PURE__ */ new Set();
function preconnectAs(pre) {
  if (ownerDocument) {
    pre.forEach(({ rel, href, crossOrigin }) => {
      const key = `${rel}${href}${crossOrigin}`;
      if (preconnectsSet.has(key))
        return;
      preconnectsSet.add(key);
      const instance = ownerDocument.createElement("link");
      instance.setAttribute("rel", rel);
      instance.setAttribute("crossOrigin", crossOrigin);
      instance.setAttribute("href", href);
      ownerDocument.head.appendChild(instance);
    });
  }
}
function composeRef(...fn2) {
  return (element) => {
    fn2.forEach((handler) => {
      handler(element);
    });
  };
}
function saveRef(ref) {
  return (element) => {
    if (element) {
      ref.current = element;
    }
  };
}
function doAutoFocus(element) {
  if (element) {
    setTimeout(() => {
      element.focus({ preventScroll: true });
    }, 100);
  }
}
function doAutoFocusWithScroll(element) {
  if (element) {
    setTimeout(() => {
      element.focus({ preventScroll: true });
      element.scrollIntoView({
        behavior: "smooth",
        block: "center",
        inline: "center"
      });
    }, 100);
  }
}
function saveVNodeForInspection(obj) {
  window["showVNodeInfo"] = function showVNodeInfo() {
    inspect(obj);
  };
  return obj;
}
function inspect(obj) {
  if (!obj)
    return;
  if (obj.__c && obj.__c.__H) {
    const componentName = obj.__c.constructor.name;
    const hookState = obj.__c.__H;
    const stateList = hookState.__;
    console.log("==============", componentName);
    stateList.forEach((hook) => {
      const { __: value, c: context, __h: factory, __H: args } = hook;
      if (typeof context !== "undefined") {
        const { __c: contextId } = context;
        console.log("context:", contextId, hook);
      } else if (typeof factory === "function") {
        console.log("memo:", value, "deps:", args);
      } else if (typeof value === "function") {
        const effectName = value.name;
        console.log("effect:", effectName, "deps:", args);
      } else if (typeof value.current !== "undefined") {
        const ref = value.current;
        console.log("ref:", ref instanceof Element ? ref.outerHTML : ref);
      } else if (value instanceof Array) {
        console.log("state:", value[0]);
      } else {
        console.log(hook);
      }
    });
  }
  const children = obj.__k;
  if (children instanceof Array) {
    children.forEach((e22) => inspect(e22));
  } else {
    inspect(children);
  }
}
function Attention({ type = "info", title, children, onClose, timeout = Duration.getForever() }) {
  return /* @__PURE__ */ h("div", { class: `group attention-${type} mt-2 shadow-lg` }, /* @__PURE__ */ h("div", { "data-timed": timeout.d_ms !== "forever", class: "rounded-md data-[timed=true]:rounded-b-none group-[.attention-info]:bg-blue-50 group-[.attention-low]:bg-gray-100 group-[.attention-warning]:bg-yellow-50 group-[.attention-danger]:bg-red-50 group-[.attention-success]:bg-green-50 p-4 shadow" }, /* @__PURE__ */ h("div", { class: "flex" }, /* @__PURE__ */ h("div", null, type === "low" ? void 0 : /* @__PURE__ */ h("svg", { xmlns: "http://www.w3.org/2000/svg", stroke: "none", viewBox: "0 0 24 24", fill: "currentColor", class: "w-8 h-8 group-[.attention-info]:text-blue-400 group-[.attention-warning]:text-yellow-400 group-[.attention-danger]:text-red-400 group-[.attention-success]:text-green-400" }, (() => {
    switch (type) {
      case "info":
        return /* @__PURE__ */ h("path", { "fill-rule": "evenodd", d: "M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a.75.75 0 000 1.5h.253a.25.25 0 01.244.304l-.459 2.066A1.75 1.75 0 0010.747 15H11a.75.75 0 000-1.5h-.253a.25.25 0 01-.244-.304l.459-2.066A1.75 1.75 0 009.253 9H9z" });
      case "warning":
        return /* @__PURE__ */ h("path", { "fill-rule": "evenodd", d: "M9.401 3.003c1.155-2 4.043-2 5.197 0l7.355 12.748c1.154 2-.29 4.5-2.599 4.5H4.645c-2.309 0-3.752-2.5-2.598-4.5L9.4 3.003zM12 8.25a.75.75 0 01.75.75v3.75a.75.75 0 01-1.5 0V9a.75.75 0 01.75-.75zm0 8.25a.75.75 0 100-1.5.75.75 0 000 1.5z" });
      case "danger":
        return /* @__PURE__ */ h("path", { "fill-rule": "evenodd", d: "M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12zM12 8.25a.75.75 0 01.75.75v3.75a.75.75 0 01-1.5 0V9a.75.75 0 01.75-.75zm0 8.25a.75.75 0 100-1.5.75.75 0 000 1.5z" });
      case "success":
        return /* @__PURE__ */ h("path", { "fill-rule": "evenodd", d: "M7.493 18.75c-.425 0-.82-.236-.975-.632A7.48 7.48 0 016 15.375c0-1.75.599-3.358 1.602-4.634.151-.192.373-.309.6-.397.473-.183.89-.514 1.212-.924a9.042 9.042 0 012.861-2.4c.723-.384 1.35-.956 1.653-1.715a4.498 4.498 0 00.322-1.672V3a.75.75 0 01.75-.75 2.25 2.25 0 012.25 2.25c0 1.152-.26 2.243-.723 3.218-.266.558.107 1.282.725 1.282h3.126c1.026 0 1.945.694 2.054 1.715.045.422.068.85.068 1.285a11.95 11.95 0 01-2.649 7.521c-.388.482-.987.729-1.605.729H14.23c-.483 0-.964-.078-1.423-.23l-3.114-1.04a4.501 4.501 0 00-1.423-.23h-.777zM2.331 10.977a11.969 11.969 0 00-.831 4.398 12 12 0 00.52 3.507c.26.85 1.084 1.368 1.973 1.368H4.9c.445 0 .72-.498.523-.898a8.963 8.963 0 01-.924-3.977c0-1.708.476-3.305 1.302-4.666.245-.403-.028-.959-.5-.959H4.25c-.832 0-1.612.453-1.918 1.227z" });
      default:
        assertUnreachable(type);
    }
  })())), /* @__PURE__ */ h("div", { class: "ml-3 w-full" }, /* @__PURE__ */ h("h3", { class: "text-sm font-bold group-[.attention-info]:text-blue-800 group-[.attention-success]:text-green-800 group-[.attention-warning]:text-yellow-800 group-[.attention-danger]:text-red-800" }, title), /* @__PURE__ */ h("div", { class: "mt-2 text-sm group-[.attention-info]:text-blue-700 group-[.attention-warning]:text-yellow-700 group-[.attention-danger]:text-red-700 group-[.attention-success]:text-green-700" }, children)), onClose && /* @__PURE__ */ h("div", null, /* @__PURE__ */ h(
    "button",
    {
      type: "button",
      class: "font-semibold items-center rounded bg-transparent px-2 py-1 text-xs text-gray-900  hover:bg-gray-50",
      onClick: (e22) => {
        e22.preventDefault();
        onClose();
      }
    },
    /* @__PURE__ */ h("svg", { class: "h-5 w-5", viewBox: "0 0 20 20", fill: "currentColor", "aria-hidden": "true" }, /* @__PURE__ */ h("path", { d: "M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z" }))
  )))), timeout.d_ms === "forever" ? void 0 : /* @__PURE__ */ h("div", { class: "meter group-[.attention-info]:bg-blue-50 group-[.attention-low]:bg-gray-100 group-[.attention-warning]:bg-yellow-50 group-[.attention-danger]:bg-red-50 group-[.attention-success]:bg-green-50 h-1 relative overflow-hidden -mt-1" }, /* @__PURE__ */ h("span", { class: "w-full h-full block" }, /* @__PURE__ */ h("span", { class: "h-full block progress group-[.attention-info]:bg-blue-600 group-[.attention-low]:bg-gray-600 group-[.attention-warning]:bg-yellow-600 group-[.attention-danger]:bg-red-600 group-[.attention-success]:bg-green-600" }))));
}
function ErrorLoading({ error: error2, showDetail }) {
  const { i18n: i18n4 } = useTranslationContext();
  switch (error2.errorDetail.code) {
    case TalerErrorCode.GENERIC_TIMEOUT: {
      if (error2.hasErrorCode(TalerErrorCode.GENERIC_TIMEOUT)) {
        const { requestMethod, requestUrl, timeoutMs } = error2.errorDetail;
        return /* @__PURE__ */ h(Attention, { type: "danger", title: i18n4.str`The request reached a timeout, check your connection.` }, error2.message, showDetail && /* @__PURE__ */ h("pre", { class: "whitespace-break-spaces " }, JSON.stringify({ requestMethod, requestUrl, timeoutMs }, void 0, 2)));
      }
      assertUnreachable(1);
    }
    case TalerErrorCode.GENERIC_CLIENT_INTERNAL_ERROR: {
      if (error2.hasErrorCode(TalerErrorCode.GENERIC_CLIENT_INTERNAL_ERROR)) {
        const { requestMethod, requestUrl, timeoutMs } = error2.errorDetail;
        return /* @__PURE__ */ h(Attention, { type: "danger", title: i18n4.str`The request was cancelled.` }, error2.message, showDetail && /* @__PURE__ */ h("pre", { class: "whitespace-break-spaces " }, JSON.stringify({ requestMethod, requestUrl, timeoutMs }, void 0, 2)));
      }
      assertUnreachable(1);
    }
    case TalerErrorCode.WALLET_HTTP_REQUEST_GENERIC_TIMEOUT: {
      if (error2.hasErrorCode(TalerErrorCode.WALLET_HTTP_REQUEST_GENERIC_TIMEOUT)) {
        const { requestMethod, requestUrl, timeoutMs } = error2.errorDetail;
        return /* @__PURE__ */ h(Attention, { type: "danger", title: i18n4.str`The request reached a timeout, check your connection.` }, error2.message, showDetail && /* @__PURE__ */ h("pre", { class: "whitespace-break-spaces " }, JSON.stringify({ requestMethod, requestUrl, timeoutMs }, void 0, 2)));
      }
      assertUnreachable(1);
    }
    case TalerErrorCode.WALLET_HTTP_REQUEST_THROTTLED: {
      if (error2.hasErrorCode(TalerErrorCode.WALLET_HTTP_REQUEST_THROTTLED)) {
        const { requestMethod, requestUrl, throttleStats } = error2.errorDetail;
        return /* @__PURE__ */ h(Attention, { type: "danger", title: i18n4.str`Too many requests were made to the server, and this action was throttled.` }, error2.message, showDetail && /* @__PURE__ */ h("pre", { class: "whitespace-break-spaces " }, JSON.stringify({ requestMethod, requestUrl, throttleStats }, void 0, 2)));
      }
      assertUnreachable(1);
    }
    case TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE: {
      if (error2.hasErrorCode(TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE)) {
        const { requestMethod, requestUrl, httpStatusCode, validationError } = error2.errorDetail;
        return /* @__PURE__ */ h(Attention, { type: "danger", title: i18n4.str`The server's response was malformed.` }, error2.message, showDetail && /* @__PURE__ */ h("pre", { class: "whitespace-break-spaces " }, JSON.stringify({ requestMethod, requestUrl, httpStatusCode, validationError }, void 0, 2)));
      }
      assertUnreachable(1);
    }
    case TalerErrorCode.WALLET_NETWORK_ERROR: {
      if (error2.hasErrorCode(TalerErrorCode.WALLET_NETWORK_ERROR)) {
        const { requestMethod, requestUrl } = error2.errorDetail;
        return /* @__PURE__ */ h(Attention, { type: "danger", title: i18n4.str`Could not complete the request due to a network problem.` }, error2.message, showDetail && /* @__PURE__ */ h("pre", { class: "whitespace-break-spaces " }, JSON.stringify({ requestMethod, requestUrl }, void 0, 2)));
      }
      assertUnreachable(1);
    }
    case TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR: {
      if (error2.hasErrorCode(TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR)) {
        const { requestMethod, requestUrl, httpStatusCode, errorResponse } = error2.errorDetail;
        return /* @__PURE__ */ h(Attention, { type: "danger", title: i18n4.str`Unexpected request error` }, error2.message, showDetail && /* @__PURE__ */ h("pre", { class: "whitespace-break-spaces " }, JSON.stringify({ requestMethod, requestUrl, httpStatusCode, errorResponse }, void 0, 2)));
      }
      assertUnreachable(1);
    }
    default:
      return /* @__PURE__ */ h(Attention, { type: "danger", title: i18n4.str`Unexpected error` }, error2.message, showDetail && /* @__PURE__ */ h("pre", { class: "whitespace-break-spaces " }, JSON.stringify(error2.errorDetail, void 0, 2)));
  }
}
var lang_default = 'data:image/svg+xml,<?xml version="1.0" encoding="utf-8"?>%0A<!-- Generator: Adobe Illustrator 19.1.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->%0A<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"%0A%09 viewBox="0 0 2411.2 2794" style="enable-background:new 0 0 2411.2 2794;" xml:space="preserve">%0A<style type="text/css">%0A%09.st0{fill:%23FFFFFF;}%0A%09.st1{fill-rule:evenodd;clip-rule:evenodd;}%0A%09.st2{fill-rule:evenodd;clip-rule:evenodd;fill:%23FFFFFF;}%0A</style>%0A<g id="Layer_2">%0A</g>%0A<g id="Layer_x5F_1_x5F_1">%0A%09<g>%0A%09%09<polygon points="1204.6,359.2 271.8,30 271.8,2060.1 1204.6,1758.3 %09%09"/>%0A%09%09<polygon class="st0" points="1182.2,358.1 2150.6,29 2150.6,2059 1182.2,1757.3 %09%09"/>%0A%09%09<polygon class="st0" points="30,2415.4 1182.2,2031.4 1182.2,357.9 30,742 %09%09"/>%0A%09%09<polygon points="1707.2,2440.7 1870.5,2709.4 1956.6,2459.8 %09%09"/>%0A%09%09<g>%0A%09%09%09<path d="M421.7,934.8c-6.1-6,8,49.1,27.6,68.9c34.8,35.1,61.9,39.6,76.4,40.2c32,1.3,71.5-8,94.9-17.8%0A%09%09%09%09c22.7-9.7,62.4-30,77.5-59.6c3.2-6.3,11.9-17,6.4-43.2c-4.2-20.2-17-27.3-32.7-26.2c-15.7,1.1-63.2,13.7-86.1,20.8%0A%09%09%09%09c-23,7-70.3,21.4-90.9,25.8C474.3,948.2,429,941.7,421.7,934.8z"/>%0A%09%09%09<path d="M1003.1,1593.7c-9.1-3.3-196.9-81.1-223.6-93.9c-21.8-10.5-75.2-33.1-100.4-43.3c70.8-109.2,115.5-191.6,121.5-204.1%0A%09%09%09%09c11-23,86-169.6,87.7-178.7c1.7-9.1,3.8-42.9,2.2-51c-1.7-8.2-29.1,7.6-66.4,20.2c-37.4,12.6-108.4,58.8-135.8,64.6%0A%09%09%09%09c-27.5,5.7-115.5,39.1-160.5,54c-45,14.9-130.2,40.9-165.2,50.4c-35.1,9.5-65.7,10.2-85.3,16.2c0,0,2.6,27.5,7.8,35.7%0A%09%09%09%09c5.2,8.2,23.7,28.4,45.3,34.1c21.6,5.7,57.3,3.4,73.6-0.3c16.3-3.8,44.4-17.5,48.2-23.6c3.8-6.1-2-24.9,4.5-30.6%0A%09%09%09%09c6.5-5.6,92.2-25.7,124.6-35.4c32.4-10,156.3-52.6,173.1-50.5c-5.3,17.7-105,215.1-137.1,274c-32.1,58.9-218.6,318-258.3,363.6%0A%09%09%09%09c-30.1,34.7-103.2,123.5-128.5,143.6c6.4,1.8,51.6-2.1,59.9-7.2c51.3-31.6,136.9-138.1,164.4-170.5%0A%09%09%09%09c81.9-96,153.8-196.8,210.8-283.4h0.1c11.1,4.6,100.9,77.8,124.4,94c23.4,16.2,115.9,67.8,136,76.4c20,8.7,97.1,44.2,100.3,32.2%0A%09%09%09%09C1029.4,1668,1012.2,1597.1,1003.1,1593.7z"/>%0A%09%09</g>%0A%09%09<path class="st1" d="M569,2572c18,11,35,20,54,29c38,19,81,39,122,54c56,21,112,38,168,51c31,7,65,13,98,18c3,0,92,11,110,11h90%0A%09%09%09c35-3,68-5,103-10c28-4,59-9,89-16c22-5,45-10,67-17c21-6,45-14,68-22c15-5,31-12,47-18c13-6,29-13,44-19c18-8,39-19,59-29%0A%09%09%09c16-8,34-18,51-28c13-7,43-30,59-30c18,0,30,16,30,30c0,29-39,38-57,51c-19,13-42,23-62,34c-40,21-81,39-120,54%0A%09%09%09c-51,19-107,37-157,49c-19,4-38,9-57,12c-10,2-114,18-143,18h-132c-35-3-72-7-107-12c-31-5-64-11-95-18c-24-5-50-12-73-19%0A%09%09%09c-40-11-79-25-117-40c-69-26-141-60-209-105c-12-8-13-16-13-25c0-15,11-29,29-29C531,2546,563,2569,569,2572z"/>%0A%09%09<path class="st1" d="M1151,2009L61,2372V764l1090-363V2009z M1212,354v1680c-1,5-3,10-7,15c-2,3-6,7-9,8c-25,10-1151,388-1166,388%0A%09%09%09c-12,0-23-8-29-21c0-1-1-2-1-4V739c2-5,3-12,7-16c8-11,22-13,31-16c17-6,1126-378,1142-378C1190,329,1212,336,1212,354z"/>%0A%09%09<path class="st1" d="M2120,2017l-907-282V380l907-308V2017z M2181,32v2023c-1,23-17,33-32,33c-13,0-107-32-123-37%0A%09%09%09c-126-39-253-78-378-117c-28-9-57-18-84-27c-24-7-50-15-74-23c-107-33-216-66-323-102c-4-1-14-15-14-18V351c2-5,4-11,9-15%0A%09%09%09c8-9,351-123,486-168c36-13,487-168,501-168C2167,0,2181,13,2181,32z"/>%0A%09%09<polygon points="2411.2,2440.7 1199.5,2054.5 1204.6,373.2 2411.2,757.2 %09%09"/>%0A%09%09<g>%0A%09%09%09<path class="st2" d="M1800.3,1124.6L1681.4,1412l218.6,66.3L1800.3,1124.6z M1729,853.2l156.1,47.3l284.4,1025l-160.3-48.7%0A%09%09%09%09l-57.6-210.4L1620.2,1566l-71.3,171.4l-160.4-48.7L1729,853.2z"/>%0A%09%09</g>%0A%09</g>%0A</g>%0A</svg>%0A';
var names = {
  uk: "\u0423\u043A\u0440\u0430\u0457\u043D\u0441\u044C\u043A\u0430 [uk]",
  tr: "T\xFCrk\xE7e [tr]",
  ru: "\u0420\u0443\u0301\u0441\u0441\u043A\u0438\u0439 \u044F\u0437\u044B\u0301\u043A [ru]",
  sv: "Svenska [sv]",
  it: "Italiano [it]",
  fr: "Fran\xE7ais [fr]",
  es: "Espa\xF1ol [es]",
  de: "Deutsch [de]",
  en: "English [en]"
};
function getLangName(s32) {
  if (names[s32])
    return names[s32];
  return String(s32);
}
function LangSelector({
  type = "select"
}) {
  const { lang, changeLanguage, completeness, supportedLang: supportedLang22 } = useTranslationContext();
  const [hidden, setHidden] = p3(true);
  h2(() => {
    function bodyKeyPress(event) {
      if (event.code === "Escape")
        setHidden(true);
    }
    function bodyOnClick(event) {
      setHidden(true);
    }
    document.body.addEventListener("click", bodyOnClick);
    document.body.addEventListener("keydown", bodyKeyPress);
    return () => {
      document.body.removeEventListener("keydown", bodyKeyPress);
      document.body.removeEventListener("click", bodyOnClick);
    };
  }, []);
  return /* @__PURE__ */ h(p2, null, function() {
    switch (type) {
      case "select": {
        return /* @__PURE__ */ h(
          "button",
          {
            type: "button",
            class: "relative w-full   rounded-md bg-white py-1.5 pl-3 pr-10 text-left text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-600 sm:text-sm sm:leading-6",
            "aria-haspopup": "listbox",
            "aria-expanded": "true",
            "aria-labelledby": "listbox-label",
            onClick: (e22) => {
              setHidden(!hidden);
              e22.stopPropagation();
            }
          },
          /* @__PURE__ */ h("span", { class: "flex items-center" }, /* @__PURE__ */ h(
            "img",
            {
              alt: "language",
              class: "h-5 w-5 flex-shrink-0 rounded-full",
              src: lang_default
            }
          ), /* @__PURE__ */ h("span", { class: "ml-3 block truncate" }, getLangName(lang))),
          /* @__PURE__ */ h("span", { class: "pointer-events-none absolute inset-y-0 right-0 flex items-center pr-2" }, /* @__PURE__ */ h(
            "svg",
            {
              class: "h-5 w-5 text-gray-400",
              viewBox: "0 0 20 20",
              fill: "currentColor",
              "aria-hidden": "true"
            },
            /* @__PURE__ */ h(
              "path",
              {
                "fill-rule": "evenodd",
                d: "M10 3a.75.75 0 01.55.24l3.25 3.5a.75.75 0 11-1.1 1.02L10 4.852 7.3 7.76a.75.75 0 01-1.1-1.02l3.25-3.5A.75.75 0 0110 3zm-3.76 9.2a.75.75 0 011.06.04l2.7 2.908 2.7-2.908a.75.75 0 111.1 1.02l-3.25 3.5a.75.75 0 01-1.1 0l-3.25-3.5a.75.75 0 01.04-1.06z",
                "clip-rule": "evenodd"
              }
            )
          ))
        );
      }
      case "icon": {
        return /* @__PURE__ */ h(
          "button",
          {
            type: "button",
            class: "relative w-full  rounded-md bg-white p-2 text-left text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 focus:outline-none focus:ring-2 focus:ring-indigo-600",
            onClick: (e22) => {
              setHidden(!hidden);
              e22.stopPropagation();
            }
          },
          /* @__PURE__ */ h("div", { class: "flex h-7 w-7" }, /* @__PURE__ */ h(
            "img",
            {
              alt: "language",
              class: "h-7 w-7 flex-shrink-0 rounded-full",
              src: lang_default
            }
          ))
        );
      }
    }
  }(), !hidden && /* @__PURE__ */ h(
    "ul",
    {
      class: "absolute z-10 mt-1 max-h-60 w-full overflow-auto rounded-md bg-white py-1 text-base shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none sm:text-sm",
      style: type === "icon" ? { right: 0, width: 200 } : {},
      tabIndex: -1,
      role: "listbox",
      "aria-labelledby": "listbox-label",
      "aria-activedescendant": "listbox-option-3"
    },
    type === "icon" ? /* @__PURE__ */ h(p2, null, /* @__PURE__ */ h(
      "li",
      {
        class: "text-gray-900 relative border-b boder-gray-200 select-none py-2 pl-3 pr-9",
        role: "option"
      },
      /* @__PURE__ */ h("span", { class: "font-normal truncate flex justify-between " }, /* @__PURE__ */ h("span", null, getLangName(lang)), /* @__PURE__ */ h("span", null, completeness[lang], "%")),
      /* @__PURE__ */ h("span", { class: "text-indigo-600 absolute inset-y-0 right-0 flex items-center pr-4" })
    )) : /* @__PURE__ */ h(p2, null),
    Object.keys(supportedLang22).filter((l3) => l3 !== lang).map((lang2) => /* @__PURE__ */ h(
      "li",
      {
        class: "text-gray-900 hover:bg-indigo-600 hover:text-white cursor-pointer relative select-none py-2 pl-3 pr-9",
        role: "option",
        onClick: () => {
          changeLanguage(lang2);
          setHidden(true);
        }
      },
      /* @__PURE__ */ h("span", { class: "font-normal truncate flex justify-between " }, /* @__PURE__ */ h("span", null, getLangName(lang2)), /* @__PURE__ */ h("span", null, completeness[lang2], "%")),
      /* @__PURE__ */ h("span", { class: "text-indigo-600 absolute inset-y-0 right-0 flex items-center pr-4" })
    ))
  ));
}
function Loading() {
  return /* @__PURE__ */ h(
    "div",
    {
      class: "columns is-centered is-vcentered",
      style: {
        width: "100%",
        height: "200px",
        display: "flex",
        margin: "auto",
        justifyContent: "center"
      }
    },
    /* @__PURE__ */ h(Spinner, null)
  );
}
function Spinner() {
  return /* @__PURE__ */ h("div", { class: "lds-ring m-auto" }, /* @__PURE__ */ h("div", null), /* @__PURE__ */ h("div", null), /* @__PURE__ */ h("div", null), /* @__PURE__ */ h("div", null));
}
var logo_2021_default = 'data:image/svg+xml,<?xml version="1.0" encoding="UTF-8" standalone="no"?>%0A<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 201 90">%0A  <g fill="%230042b3" fill-rule="evenodd" stroke-width=".3">%0A    <path d="M86.7 1.1c15.6 0 29 9.4 36 23.2h-5.9A35.1 35.1 0 0086.7 6.5C67 6.5 51 23.6 51 44.7c0 10.4 3.8 19.7 10 26.6a31.4 31.4 0 01-4.2 3A45.2 45.2 0 0146 44.7c0-24 18.2-43.6 40.7-43.6zm35.8 64.3a40.4 40.4 0 01-39 22.8c3-1.5 6-3.5 8.6-5.7a35.6 35.6 0 0024.6-17.1z" />%0A    <path d="M64.2 1.1l3.1.1c-3 1.6-5.9 3.5-8.5 5.8a37.5 37.5 0 00-30.2 37.7c0 14.3 7.3 26.7 18 33.3a29.6 29.6 0 01-8.5.2c-9-8-14.6-20-14.6-33.5 0-24 18.2-43.6 40.7-43.6zm5.4 81.4a35.6 35.6 0 0024.6-17.1h5.9a40.4 40.4 0 01-39 22.8c3-1.5 5.9-3.5 8.5-5.7zm24.8-58.2a37 37 0 00-12.6-12.8 29.6 29.6 0 018.5-.2c4 3.6 7.4 8 9.9 13z" />%0A    <path d="M41.8 1.1c1 0 2 0 3.1.2-3 1.5-5.9 3.4-8.5 5.6A37.5 37.5 0 006.1 44.7c0 21.1 16 38.3 35.7 38.3 12.6 0 23.6-7 30-17.6h5.8a40.4 40.4 0 01-35.8 23C19.3 88.4 1 68.8 1 44.7c0-24 18.2-43.6 40.7-43.6zm30.1 23.2a38.1 38.1 0 00-4.5-6.1c1.3-1.2 2.7-2.2 4.3-3 2.3 2.7 4.4 5.8 6 9.1z" />%0A  </g>%0A  <path d="M76.1 34.4h9.2v-5H61.9v5H71v26h5.1zM92.6 52.9h13.7l3 7.4h5.3l-12.7-31.2h-4.7L84.5 60.3h5.2zm11.8-4.9h-9.9l5-12.4zM123.8 29.4h-4.6v31h20.6v-5h-16zM166.5 29.4H145v31h21.6v-5H150v-8.3h14.5v-4.9h-14.5v-8h16.4zM191.2 39.5c0 1.6-.5 2.8-1.6 3.8s-2.6 1.4-4.4 1.4h-7.4V34.3h7.4c1.9 0 3.4.4 4.4 1.3 1 .9 1.6 2.2 1.6 3.9zm6 20.8l-7.7-11.7c1-.3 1.9-.7 2.7-1.3a8.8 8.8 0 003.6-4.6c.4-1 .5-2.2.5-3.5 0-1.5-.2-2.9-.7-4.1a8.4 8.4 0 00-2.1-3.1c-1-.8-2-1.5-3.4-2-1.3-.4-2.8-.6-4.5-.6h-12.9v31h5V49.4h6.5l7 10.8z" />%0A</svg>';
function Header({
  title,
  profileURL,
  notificationURL,
  iconLinkURL,
  sites,
  onLogout,
  children
}) {
  const { i18n: i18n4 } = useTranslationContext();
  const [open, setOpen] = p3(false);
  const ns = useNotifications();
  return /* @__PURE__ */ h(p2, null, /* @__PURE__ */ h("header", { class: "bg-indigo-600 w-full mx-auto px-2 border-b border-opacity-25 border-indigo-400" }, /* @__PURE__ */ h("div", { class: "flex flex-row h-16 items-center " }, /* @__PURE__ */ h("div", { class: "flex px-2 justify-start" }, /* @__PURE__ */ h("div", { class: "flex-shrink-0 bg-white rounded-lg" }, /* @__PURE__ */ h("a", { href: iconLinkURL ?? "#", name: "logo" }, /* @__PURE__ */ h(
    "img",
    {
      class: "h-8 w-auto m-1",
      src: logo_2021_default,
      alt: "GNU Taler"
    }
  ))), /* @__PURE__ */ h("span", { class: "flex items-center text-white text-lg font-bold ml-4" }, title)), /* @__PURE__ */ h("div", { class: "flex-1 ml-6 " }, /* @__PURE__ */ h("div", { class: "flex flex-1 space-x-4" }, sites.map((site) => {
    if (site.length !== 2)
      return;
    const [name, url] = site;
    return /* @__PURE__ */ h(
      "a",
      {
        href: url,
        name: `site header ${name}`,
        class: "hidden sm:block text-white hover:bg-indigo-500 hover:bg-opacity-75 rounded-md py-2 px-3 text-sm font-medium"
      },
      name
    );
  }))), /* @__PURE__ */ h("div", { class: "flex justify-end" }, !notificationURL ? void 0 : /* @__PURE__ */ h(
    "a",
    {
      href: notificationURL,
      name: "notifications",
      class: "relative inline-flex items-center justify-center rounded-md bg-indigo-600 p-1 mr-2 text-indigo-200 hover:bg-indigo-500 hover:bg-opacity-75 hover:text-white focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-indigo-600",
      "aria-controls": "mobile-menu",
      "aria-expanded": "false"
    },
    /* @__PURE__ */ h("span", { class: "absolute -inset-0.5" }),
    /* @__PURE__ */ h("span", { class: "sr-only" }, /* @__PURE__ */ h(i18n4.Translate, null, "Show notifications")),
    ns.length > 0 ? /* @__PURE__ */ h(
      "svg",
      {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 24 24",
        fill: "currentColor",
        class: "w-10 h-10"
      },
      /* @__PURE__ */ h("path", { d: "M5.85 3.5a.75.75 0 0 0-1.117-1 9.719 9.719 0 0 0-2.348 4.876.75.75 0 0 0 1.479.248A8.219 8.219 0 0 1 5.85 3.5ZM19.267 2.5a.75.75 0 1 0-1.118 1 8.22 8.22 0 0 1 1.987 4.124.75.75 0 0 0 1.48-.248A9.72 9.72 0 0 0 19.266 2.5Z" }),
      /* @__PURE__ */ h(
        "path",
        {
          "fill-rule": "evenodd",
          d: "M12 2.25A6.75 6.75 0 0 0 5.25 9v.75a8.217 8.217 0 0 1-2.119 5.52.75.75 0 0 0 .298 1.206c1.544.57 3.16.99 4.831 1.243a3.75 3.75 0 1 0 7.48 0 24.583 24.583 0 0 0 4.83-1.244.75.75 0 0 0 .298-1.205 8.217 8.217 0 0 1-2.118-5.52V9A6.75 6.75 0 0 0 12 2.25ZM9.75 18c0-.034 0-.067.002-.1a25.05 25.05 0 0 0 4.496 0l.002.1a2.25 2.25 0 1 1-4.5 0Z",
          "clip-rule": "evenodd"
        }
      )
    ) : /* @__PURE__ */ h(
      "svg",
      {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        "stroke-width": "1.5",
        stroke: "currentColor",
        class: "w-10 h-10"
      },
      /* @__PURE__ */ h(
        "path",
        {
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          d: "M14.857 17.082a23.848 23.848 0 0 0 5.454-1.31A8.967 8.967 0 0 1 18 9.75V9A6 6 0 0 0 6 9v.75a8.967 8.967 0 0 1-2.312 6.022c1.733.64 3.56 1.085 5.455 1.31m5.714 0a24.255 24.255 0 0 1-5.714 0m5.714 0a3 3 0 1 1-5.714 0"
        }
      )
    )
  ), !profileURL ? void 0 : /* @__PURE__ */ h(
    "a",
    {
      href: profileURL,
      name: "profile",
      class: "relative inline-flex items-center justify-center rounded-md bg-indigo-600 p-1 mr-2 text-indigo-200 hover:bg-indigo-500 hover:bg-opacity-75 hover:text-white focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-indigo-600",
      "aria-controls": "mobile-menu",
      "aria-expanded": "false"
    },
    /* @__PURE__ */ h("span", { class: "absolute -inset-0.5" }),
    /* @__PURE__ */ h("span", { class: "sr-only" }, /* @__PURE__ */ h(i18n4.Translate, null, "Open profile")),
    /* @__PURE__ */ h(
      "svg",
      {
        xmlns: "http://www.w3.org/2000/svg",
        fill: "none",
        viewBox: "0 0 24 24",
        "stroke-width": "1.5",
        stroke: "currentColor",
        class: "w-10 h-10"
      },
      /* @__PURE__ */ h(
        "path",
        {
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          d: "M17.982 18.725A7.488 7.488 0 0 0 12 15.75a7.488 7.488 0 0 0-5.982 2.975m11.963 0a9 9 0 1 0-11.963 0m11.963 0A8.966 8.966 0 0 1 12 21a8.966 8.966 0 0 1-5.982-2.275M15 9.75a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z"
        }
      )
    )
  ), /* @__PURE__ */ h(LangSelector, { type: "icon" }), /* @__PURE__ */ h(
    "button",
    {
      type: "button",
      name: "toggle sidebar",
      class: "relative inline-flex items-center justify-center rounded-md bg-indigo-600 p-1 text-indigo-200 hover:bg-indigo-500 hover:bg-opacity-75 hover:text-white focus:outline-none focus:ring-2 focus:ring-white focus:ring-offset-2 focus:ring-offset-indigo-600",
      "aria-controls": "mobile-menu",
      "aria-expanded": "false",
      onClick: (e22) => {
        setOpen(!open);
      }
    },
    /* @__PURE__ */ h("span", { class: "absolute -inset-0.5" }),
    /* @__PURE__ */ h("span", { class: "sr-only" }, /* @__PURE__ */ h(i18n4.Translate, null, "Open settings")),
    /* @__PURE__ */ h(
      "svg",
      {
        class: "block h-10 w-10",
        fill: "none",
        viewBox: "0 0 24 24",
        "stroke-width": "2",
        stroke: "currentColor",
        "aria-hidden": "true"
      },
      /* @__PURE__ */ h(
        "path",
        {
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          d: "M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5"
        }
      )
    )
  )))), open && /* @__PURE__ */ h(
    "div",
    {
      class: "relative z-10",
      name: "sidebar overlay",
      "aria-labelledby": "slide-over-title",
      role: "dialog",
      "aria-modal": "true",
      onClick: () => {
        setOpen(false);
      }
    },
    /* @__PURE__ */ h("div", { class: "fixed inset-0" }),
    /* @__PURE__ */ h("div", { class: "fixed inset-0 overflow-hidden" }, /* @__PURE__ */ h("div", { class: "absolute inset-0 overflow-hidden" }, /* @__PURE__ */ h("div", { class: "pointer-events-none fixed inset-y-0 right-0 flex max-w-full pl-10" }, /* @__PURE__ */ h("div", { class: "pointer-events-auto w-screen max-w-md" }, /* @__PURE__ */ h(
      "div",
      {
        class: "flex h-full flex-col overflow-y-scroll bg-white py-6 shadow-xl",
        onClick: (e22) => {
          e22.stopPropagation();
        }
      },
      /* @__PURE__ */ h("div", { class: "px-4 sm:px-6" }, /* @__PURE__ */ h("div", { class: "flex items-start justify-between" }, /* @__PURE__ */ h(
        "h2",
        {
          class: "text-base font-semibold leading-6 text-gray-900",
          id: "slide-over-title"
        },
        /* @__PURE__ */ h(i18n4.Translate, null, "Menu")
      ), /* @__PURE__ */ h("div", { class: "ml-3 flex h-7 items-center" }, /* @__PURE__ */ h(
        "button",
        {
          type: "button",
          name: "close sidebar",
          class: "relative rounded-md bg-white text-gray-400 hover:text-gray-500 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2",
          onClick: (e22) => {
            setOpen(false);
          }
        },
        /* @__PURE__ */ h("span", { class: "absolute -inset-2.5" }),
        /* @__PURE__ */ h("span", { class: "sr-only" }, /* @__PURE__ */ h(i18n4.Translate, null, "Close panel")),
        /* @__PURE__ */ h(
          "svg",
          {
            class: "h-6 w-6",
            fill: "none",
            viewBox: "0 0 24 24",
            "stroke-width": "1.5",
            stroke: "currentColor",
            "aria-hidden": "true"
          },
          /* @__PURE__ */ h(
            "path",
            {
              "stroke-linecap": "round",
              "stroke-linejoin": "round",
              d: "M6 18L18 6M6 6l12 12"
            }
          )
        )
      )))),
      /* @__PURE__ */ h("div", { class: "relative mt-6 flex-1 px-4 sm:px-6" }, /* @__PURE__ */ h("nav", { class: "flex flex-1 flex-col", "aria-label": "Sidebar" }, /* @__PURE__ */ h("ul", { role: "list", class: "flex flex-1 flex-col gap-y-7" }, onLogout ? /* @__PURE__ */ h("li", null, /* @__PURE__ */ h(
        "a",
        {
          href: "#",
          name: "logout",
          class: "text-gray-700 hover:text-indigo-600 hover:bg-gray-100 group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold",
          onClick: () => {
            onLogout();
            setOpen(false);
          }
        },
        /* @__PURE__ */ h(
          "svg",
          {
            class: "h-6 w-6 shrink-0 text-indigo-600",
            fill: "none",
            viewBox: "0 0 24 24",
            "stroke-width": "1.5",
            stroke: "currentColor",
            "aria-hidden": "true"
          },
          /* @__PURE__ */ h(
            "path",
            {
              "stroke-linecap": "round",
              "stroke-linejoin": "round",
              d: "M2.25 12l8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25"
            }
          )
        ),
        /* @__PURE__ */ h(i18n4.Translate, null, "Log out")
      )) : void 0, /* @__PURE__ */ h("li", null, /* @__PURE__ */ h(LangSelector, null)), children, sites.length > 0 ? /* @__PURE__ */ h("li", { class: "block sm:hidden" }, /* @__PURE__ */ h("div", { class: "text-xs font-semibold leading-6 text-gray-400" }, /* @__PURE__ */ h(i18n4.Translate, null, "Sites")), /* @__PURE__ */ h("ul", { role: "list", class: "space-y-1" }, sites.map(([name, url]) => {
        return /* @__PURE__ */ h("li", null, /* @__PURE__ */ h(
          "a",
          {
            href: url,
            name: `site ${name}`,
            target: "_blank",
            rel: "noopener noreferrer",
            class: "text-gray-700 hover:text-indigo-600 hover:bg-gray-100 group flex gap-x-3 rounded-md p-2 text-sm leading-6 font-semibold"
          },
          /* @__PURE__ */ h("span", { class: "flex h-6 w-6 shrink-0 items-center justify-center rounded-lg border text-[0.625rem] font-medium bg-white text-gray-400 border-gray-200 group-hover:border-indigo-600 group-hover:text-indigo-600" }, ">"),
          /* @__PURE__ */ h("span", { class: "truncate" }, name)
        ));
      }))) : void 0)))
    )))))
  ));
}
function Footer({
  testingUrlKey,
  VERSION: VERSION2,
  GIT_HASH: GIT_HASH2
}) {
  const { i18n: i18n4 } = useTranslationContext();
  const testingUrl = testingUrlKey && typeof localStorage !== "undefined" && localStorage.getItem(testingUrlKey) ? localStorage.getItem(testingUrlKey) ?? void 0 : void 0;
  const versionText = VERSION2 ? GIT_HASH2 ? /* @__PURE__ */ h(
    "a",
    {
      href: `https://git.taler.net/wallet-core.git/tree/?id=${GIT_HASH2}`,
      target: "_blank",
      rel: "noreferrer noopener"
    },
    "Version ",
    VERSION2,
    " (",
    GIT_HASH2.substring(0, 8),
    ")"
  ) : VERSION2 : "";
  return /* @__PURE__ */ h("footer", { class: "bottom-4 my-4 mx-8 bg-slate-200" }, /* @__PURE__ */ h("div", null, /* @__PURE__ */ h("p", { class: "text-xs leading-5 text-gray-400" }, /* @__PURE__ */ h(i18n4.Translate, null, "Learn more about", " ", /* @__PURE__ */ h(
    "a",
    {
      target: "_blank",
      rel: "noreferrer noopener",
      class: "font-semibold text-gray-500 hover:text-gray-400",
      href: "https://taler.net"
    },
    "GNU Taler"
  )))), /* @__PURE__ */ h("div", { style: "flex-grow:1" }), /* @__PURE__ */ h("p", { class: "text-xs leading-5 text-gray-400" }, "Copyright \xA9 2014\u20142025 Taler Systems SA. ", versionText, " "), testingUrlKey && testingUrl && /* @__PURE__ */ h("p", { class: "text-xs leading-5 text-gray-300" }, "Testing with ", testingUrl, " ", /* @__PURE__ */ h(
    "a",
    {
      href: "",
      onClick: (e22) => {
        e22.preventDefault();
        localStorage.removeItem(testingUrlKey);
        window.location.reload();
      }
    },
    "stop testing"
  )));
}
function Button({
  handler,
  children,
  disabled,
  onClick: clickEvent,
  ...rest
}) {
  const { i18n: i18n4 } = useTranslationContext();
  const [running, setRunning] = p3(false);
  return /* @__PURE__ */ h(
    "button",
    {
      ...rest,
      disabled: disabled || running,
      onClick: (e22) => {
        e22.preventDefault();
        if (!handler) {
          return;
        }
        setRunning(true);
        handler.onClick().finally(() => {
          setRunning(false);
        });
      }
    },
    running ? /* @__PURE__ */ h(Wait, null) : children
  );
}
function Wait() {
  return /* @__PURE__ */ h(p2, null, /* @__PURE__ */ h("div", { id: "l1" }));
}
function LocalNotificationBanner({ notification, showDebug }) {
  if (!notification)
    return /* @__PURE__ */ h(p2, null);
  switch (notification.message.type) {
    case "error":
      return /* @__PURE__ */ h("div", { class: "relative" }, /* @__PURE__ */ h("div", { class: "fixed top-0 left-0 right-0 z-20 w-full p-4" }, /* @__PURE__ */ h(Attention, { type: "danger", title: notification.message.title, onClose: () => {
        notification.acknowledge();
      } }, notification.message.description && /* @__PURE__ */ h("div", { class: "mt-2 text-sm text-red-700" }, notification.message.description), showDebug && /* @__PURE__ */ h("pre", { class: "whitespace-break-spaces " }, notification.message.debug))));
    case "info":
      return /* @__PURE__ */ h("div", { class: "relative" }, /* @__PURE__ */ h("div", { class: "fixed top-0 left-0 right-0 z-20 w-full p-4" }, /* @__PURE__ */ h(Attention, { type: "success", title: notification.message.title, onClose: () => {
        notification.acknowledge();
      } })));
  }
}
function ToastBanner({ debug }) {
  const notifs = useNotifications();
  if (notifs.length === 0)
    return /* @__PURE__ */ h(p2, null);
  const show = notifs.filter((e22) => !e22.message.ack && !e22.message.timeout);
  if (show.length === 0)
    return /* @__PURE__ */ h(p2, null);
  return /* @__PURE__ */ h(AttentionByType, { msg: show[0], debug });
}
function AttentionByType({
  msg,
  debug
}) {
  switch (msg.message.type) {
    case "error":
      return /* @__PURE__ */ h(
        Attention,
        {
          type: "danger",
          title: msg.message.title,
          onClose: () => {
            msg.acknowledge();
          },
          timeout: debug ? Duration.getForever() : GLOBAL_NOTIFICATION_TIMEOUT
        },
        msg.message.description && /* @__PURE__ */ h("div", { class: "mt-2 text-sm text-red-700" }, msg.message.description),
        !debug ? void 0 : /* @__PURE__ */ h("pre", null, msg.message.debug)
      );
    case "info":
      return /* @__PURE__ */ h(
        Attention,
        {
          type: "success",
          title: msg.message.title,
          onClose: () => {
            msg.acknowledge();
          },
          timeout: GLOBAL_NOTIFICATION_TIMEOUT
        }
      );
  }
}
function toInteger(dirtyNumber) {
  if (dirtyNumber === null || dirtyNumber === true || dirtyNumber === false) {
    return NaN;
  }
  var number = Number(dirtyNumber);
  if (isNaN(number)) {
    return number;
  }
  return number < 0 ? Math.ceil(number) : Math.floor(number);
}
function requiredArgs(required, args) {
  if (args.length < required) {
    throw new TypeError(required + " argument" + (required > 1 ? "s" : "") + " required, but only " + args.length + " present");
  }
}
function _typeof(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof(obj);
}
function toDate(argument) {
  requiredArgs(1, arguments);
  var argStr = Object.prototype.toString.call(argument);
  if (argument instanceof Date || _typeof(argument) === "object" && argStr === "[object Date]") {
    return new Date(argument.getTime());
  } else if (typeof argument === "number" || argStr === "[object Number]") {
    return new Date(argument);
  } else {
    if ((typeof argument === "string" || argStr === "[object String]") && typeof console !== "undefined") {
      console.warn("Starting with v2.0.0-beta.1 date-fns doesn't accept strings as date arguments. Please use `parseISO` to parse strings. See: https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#string-arguments");
      console.warn(new Error().stack);
    }
    return /* @__PURE__ */ new Date(NaN);
  }
}
function addDays(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var amount = toInteger(dirtyAmount);
  if (isNaN(amount)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  date.setDate(date.getDate() + amount);
  return date;
}
function addMonths(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var amount = toInteger(dirtyAmount);
  if (isNaN(amount)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  var dayOfMonth = date.getDate();
  var endOfDesiredMonth = new Date(date.getTime());
  endOfDesiredMonth.setMonth(date.getMonth() + amount + 1, 0);
  var daysInMonth = endOfDesiredMonth.getDate();
  if (dayOfMonth >= daysInMonth) {
    return endOfDesiredMonth;
  } else {
    date.setFullYear(endOfDesiredMonth.getFullYear(), endOfDesiredMonth.getMonth(), dayOfMonth);
    return date;
  }
}
function _typeof2(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof2 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof2 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof2(obj);
}
function add2(dirtyDate, duration) {
  requiredArgs(2, arguments);
  if (!duration || _typeof2(duration) !== "object")
    return /* @__PURE__ */ new Date(NaN);
  var years = duration.years ? toInteger(duration.years) : 0;
  var months = duration.months ? toInteger(duration.months) : 0;
  var weeks = duration.weeks ? toInteger(duration.weeks) : 0;
  var days = duration.days ? toInteger(duration.days) : 0;
  var hours = duration.hours ? toInteger(duration.hours) : 0;
  var minutes = duration.minutes ? toInteger(duration.minutes) : 0;
  var seconds = duration.seconds ? toInteger(duration.seconds) : 0;
  var date = toDate(dirtyDate);
  var dateWithMonths = months || years ? addMonths(date, months + years * 12) : date;
  var dateWithDays = days || weeks ? addDays(dateWithMonths, days + weeks * 7) : dateWithMonths;
  var minutesToAdd = minutes + hours * 60;
  var secondsToAdd = seconds + minutesToAdd * 60;
  var msToAdd = secondsToAdd * 1e3;
  var finalDate = new Date(dateWithDays.getTime() + msToAdd);
  return finalDate;
}
function addMilliseconds(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var timestamp = toDate(dirtyDate).getTime();
  var amount = toInteger(dirtyAmount);
  return new Date(timestamp + amount);
}
var defaultOptions = {};
function getDefaultOptions() {
  return defaultOptions;
}
function startOfWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setDate(date.getDate() - diff);
  date.setHours(0, 0, 0, 0);
  return date;
}
function getTimezoneOffsetInMilliseconds(date) {
  var utcDate = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds()));
  utcDate.setUTCFullYear(date.getFullYear());
  return date.getTime() - utcDate.getTime();
}
function startOfDay(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  date.setHours(0, 0, 0, 0);
  return date;
}
var MILLISECONDS_IN_DAY = 864e5;
function differenceInCalendarDays(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var startOfDayLeft = startOfDay(dirtyDateLeft);
  var startOfDayRight = startOfDay(dirtyDateRight);
  var timestampLeft = startOfDayLeft.getTime() - getTimezoneOffsetInMilliseconds(startOfDayLeft);
  var timestampRight = startOfDayRight.getTime() - getTimezoneOffsetInMilliseconds(startOfDayRight);
  return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_DAY);
}
function compareAsc(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var diff = dateLeft.getTime() - dateRight.getTime();
  if (diff < 0) {
    return -1;
  } else if (diff > 0) {
    return 1;
  } else {
    return diff;
  }
}
var daysInYear = 365.2425;
var maxTime = Math.pow(10, 8) * 24 * 60 * 60 * 1e3;
var millisecondsInMinute = 6e4;
var millisecondsInHour = 36e5;
var millisecondsInSecond = 1e3;
var minTime = -maxTime;
var secondsInHour = 3600;
var secondsInDay = secondsInHour * 24;
var secondsInWeek = secondsInDay * 7;
var secondsInYear = secondsInDay * daysInYear;
var secondsInMonth = secondsInYear / 12;
var secondsInQuarter = secondsInMonth * 3;
function isSameDay(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeftStartOfDay = startOfDay(dirtyDateLeft);
  var dateRightStartOfDay = startOfDay(dirtyDateRight);
  return dateLeftStartOfDay.getTime() === dateRightStartOfDay.getTime();
}
function _typeof3(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof3 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof3 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof3(obj);
}
function isDate(value) {
  requiredArgs(1, arguments);
  return value instanceof Date || _typeof3(value) === "object" && Object.prototype.toString.call(value) === "[object Date]";
}
function isValid(dirtyDate) {
  requiredArgs(1, arguments);
  if (!isDate(dirtyDate) && typeof dirtyDate !== "number") {
    return false;
  }
  var date = toDate(dirtyDate);
  return !isNaN(Number(date));
}
function differenceInCalendarMonths(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var yearDiff = dateLeft.getFullYear() - dateRight.getFullYear();
  var monthDiff = dateLeft.getMonth() - dateRight.getMonth();
  return yearDiff * 12 + monthDiff;
}
function differenceInCalendarYears(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  return dateLeft.getFullYear() - dateRight.getFullYear();
}
function compareLocalAsc(dateLeft, dateRight) {
  var diff = dateLeft.getFullYear() - dateRight.getFullYear() || dateLeft.getMonth() - dateRight.getMonth() || dateLeft.getDate() - dateRight.getDate() || dateLeft.getHours() - dateRight.getHours() || dateLeft.getMinutes() - dateRight.getMinutes() || dateLeft.getSeconds() - dateRight.getSeconds() || dateLeft.getMilliseconds() - dateRight.getMilliseconds();
  if (diff < 0) {
    return -1;
  } else if (diff > 0) {
    return 1;
  } else {
    return diff;
  }
}
function differenceInDays(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var sign2 = compareLocalAsc(dateLeft, dateRight);
  var difference = Math.abs(differenceInCalendarDays(dateLeft, dateRight));
  dateLeft.setDate(dateLeft.getDate() - sign2 * difference);
  var isLastDayNotFull = Number(compareLocalAsc(dateLeft, dateRight) === -sign2);
  var result = sign2 * (difference - isLastDayNotFull);
  return result === 0 ? 0 : result;
}
function differenceInMilliseconds(dateLeft, dateRight) {
  requiredArgs(2, arguments);
  return toDate(dateLeft).getTime() - toDate(dateRight).getTime();
}
var roundingMap = {
  ceil: Math.ceil,
  round: Math.round,
  floor: Math.floor,
  trunc: function trunc(value) {
    return value < 0 ? Math.ceil(value) : Math.floor(value);
  }
  // Math.trunc is not supported by IE
};
var defaultRoundingMethod = "trunc";
function getRoundingMethod(method) {
  return method ? roundingMap[method] : roundingMap[defaultRoundingMethod];
}
function differenceInHours(dateLeft, dateRight, options) {
  requiredArgs(2, arguments);
  var diff = differenceInMilliseconds(dateLeft, dateRight) / millisecondsInHour;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function differenceInMinutes(dateLeft, dateRight, options) {
  requiredArgs(2, arguments);
  var diff = differenceInMilliseconds(dateLeft, dateRight) / millisecondsInMinute;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function endOfDay(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  date.setHours(23, 59, 59, 999);
  return date;
}
function endOfMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var month = date.getMonth();
  date.setFullYear(date.getFullYear(), month + 1, 0);
  date.setHours(23, 59, 59, 999);
  return date;
}
function isLastDayOfMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  return endOfDay(date).getTime() === endOfMonth(date).getTime();
}
function differenceInMonths(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var sign2 = compareAsc(dateLeft, dateRight);
  var difference = Math.abs(differenceInCalendarMonths(dateLeft, dateRight));
  var result;
  if (difference < 1) {
    result = 0;
  } else {
    if (dateLeft.getMonth() === 1 && dateLeft.getDate() > 27) {
      dateLeft.setDate(30);
    }
    dateLeft.setMonth(dateLeft.getMonth() - sign2 * difference);
    var isLastMonthNotFull = compareAsc(dateLeft, dateRight) === -sign2;
    if (isLastDayOfMonth(toDate(dirtyDateLeft)) && difference === 1 && compareAsc(dirtyDateLeft, dateRight) === 1) {
      isLastMonthNotFull = false;
    }
    result = sign2 * (difference - Number(isLastMonthNotFull));
  }
  return result === 0 ? 0 : result;
}
function differenceInSeconds(dateLeft, dateRight, options) {
  requiredArgs(2, arguments);
  var diff = differenceInMilliseconds(dateLeft, dateRight) / 1e3;
  return getRoundingMethod(options === null || options === void 0 ? void 0 : options.roundingMethod)(diff);
}
function differenceInYears(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  var sign2 = compareAsc(dateLeft, dateRight);
  var difference = Math.abs(differenceInCalendarYears(dateLeft, dateRight));
  dateLeft.setFullYear(1584);
  dateRight.setFullYear(1584);
  var isLastYearNotFull = compareAsc(dateLeft, dateRight) === -sign2;
  var result = sign2 * (difference - Number(isLastYearNotFull));
  return result === 0 ? 0 : result;
}
function eachDayOfInterval(dirtyInterval, options) {
  var _options$step;
  requiredArgs(1, arguments);
  var interval = dirtyInterval || {};
  var startDate = toDate(interval.start);
  var endDate = toDate(interval.end);
  var endTime = endDate.getTime();
  if (!(startDate.getTime() <= endTime)) {
    throw new RangeError("Invalid interval");
  }
  var dates = [];
  var currentDate = startDate;
  currentDate.setHours(0, 0, 0, 0);
  var step = Number((_options$step = options === null || options === void 0 ? void 0 : options.step) !== null && _options$step !== void 0 ? _options$step : 1);
  if (step < 1 || isNaN(step))
    throw new RangeError("`options.step` must be a number greater than 1");
  while (currentDate.getTime() <= endTime) {
    dates.push(toDate(currentDate));
    currentDate.setDate(currentDate.getDate() + step);
    currentDate.setHours(0, 0, 0, 0);
  }
  return dates;
}
function startOfMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  date.setDate(1);
  date.setHours(0, 0, 0, 0);
  return date;
}
function endOfWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getDay();
  var diff = (day < weekStartsOn ? -7 : 0) + 6 - (day - weekStartsOn);
  date.setDate(date.getDate() + diff);
  date.setHours(23, 59, 59, 999);
  return date;
}
function subMilliseconds(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addMilliseconds(dirtyDate, -amount);
}
var MILLISECONDS_IN_DAY2 = 864e5;
function getUTCDayOfYear(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var timestamp = date.getTime();
  date.setUTCMonth(0, 1);
  date.setUTCHours(0, 0, 0, 0);
  var startOfYearTimestamp = date.getTime();
  var difference = timestamp - startOfYearTimestamp;
  return Math.floor(difference / MILLISECONDS_IN_DAY2) + 1;
}
function startOfUTCISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  var weekStartsOn = 1;
  var date = toDate(dirtyDate);
  var day = date.getUTCDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setUTCDate(date.getUTCDate() - diff);
  date.setUTCHours(0, 0, 0, 0);
  return date;
}
function getUTCISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getUTCFullYear();
  var fourthOfJanuaryOfNextYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfNextYear.setUTCFullYear(year + 1, 0, 4);
  fourthOfJanuaryOfNextYear.setUTCHours(0, 0, 0, 0);
  var startOfNextYear = startOfUTCISOWeek(fourthOfJanuaryOfNextYear);
  var fourthOfJanuaryOfThisYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfThisYear.setUTCFullYear(year, 0, 4);
  fourthOfJanuaryOfThisYear.setUTCHours(0, 0, 0, 0);
  var startOfThisYear = startOfUTCISOWeek(fourthOfJanuaryOfThisYear);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}
function startOfUTCISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var year = getUTCISOWeekYear(dirtyDate);
  var fourthOfJanuary = /* @__PURE__ */ new Date(0);
  fourthOfJanuary.setUTCFullYear(year, 0, 4);
  fourthOfJanuary.setUTCHours(0, 0, 0, 0);
  var date = startOfUTCISOWeek(fourthOfJanuary);
  return date;
}
var MILLISECONDS_IN_WEEK = 6048e5;
function getUTCISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var diff = startOfUTCISOWeek(date).getTime() - startOfUTCISOWeekYear(date).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK) + 1;
}
function startOfUTCWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getUTCDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setUTCDate(date.getUTCDate() - diff);
  date.setUTCHours(0, 0, 0, 0);
  return date;
}
function getUTCWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getUTCFullYear();
  var defaultOptions2 = getDefaultOptions();
  var firstWeekContainsDate = toInteger((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var firstWeekOfNextYear = /* @__PURE__ */ new Date(0);
  firstWeekOfNextYear.setUTCFullYear(year + 1, 0, firstWeekContainsDate);
  firstWeekOfNextYear.setUTCHours(0, 0, 0, 0);
  var startOfNextYear = startOfUTCWeek(firstWeekOfNextYear, options);
  var firstWeekOfThisYear = /* @__PURE__ */ new Date(0);
  firstWeekOfThisYear.setUTCFullYear(year, 0, firstWeekContainsDate);
  firstWeekOfThisYear.setUTCHours(0, 0, 0, 0);
  var startOfThisYear = startOfUTCWeek(firstWeekOfThisYear, options);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}
function startOfUTCWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var firstWeekContainsDate = toInteger((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  var year = getUTCWeekYear(dirtyDate, options);
  var firstWeek = /* @__PURE__ */ new Date(0);
  firstWeek.setUTCFullYear(year, 0, firstWeekContainsDate);
  firstWeek.setUTCHours(0, 0, 0, 0);
  var date = startOfUTCWeek(firstWeek, options);
  return date;
}
var MILLISECONDS_IN_WEEK2 = 6048e5;
function getUTCWeek(dirtyDate, options) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var diff = startOfUTCWeek(date, options).getTime() - startOfUTCWeekYear(date, options).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK2) + 1;
}
function addLeadingZeros(number, targetLength) {
  var sign2 = number < 0 ? "-" : "";
  var output = Math.abs(number).toString();
  while (output.length < targetLength) {
    output = "0" + output;
  }
  return sign2 + output;
}
var formatters = {
  // Year
  y: function y3(date, token) {
    var signedYear = date.getUTCFullYear();
    var year = signedYear > 0 ? signedYear : 1 - signedYear;
    return addLeadingZeros(token === "yy" ? year % 100 : year, token.length);
  },
  // Month
  M: function M4(date, token) {
    var month = date.getUTCMonth();
    return token === "M" ? String(month + 1) : addLeadingZeros(month + 1, 2);
  },
  // Day of the month
  d: function d3(date, token) {
    return addLeadingZeros(date.getUTCDate(), token.length);
  },
  // AM or PM
  a: function a3(date, token) {
    var dayPeriodEnumValue = date.getUTCHours() / 12 >= 1 ? "pm" : "am";
    switch (token) {
      case "a":
      case "aa":
        return dayPeriodEnumValue.toUpperCase();
      case "aaa":
        return dayPeriodEnumValue;
      case "aaaaa":
        return dayPeriodEnumValue[0];
      case "aaaa":
      default:
        return dayPeriodEnumValue === "am" ? "a.m." : "p.m.";
    }
  },
  // Hour [1-12]
  h: function h12(date, token) {
    return addLeadingZeros(date.getUTCHours() % 12 || 12, token.length);
  },
  // Hour [0-23]
  H: function H3(date, token) {
    return addLeadingZeros(date.getUTCHours(), token.length);
  },
  // Minute
  m: function m3(date, token) {
    return addLeadingZeros(date.getUTCMinutes(), token.length);
  },
  // Second
  s: function s3(date, token) {
    return addLeadingZeros(date.getUTCSeconds(), token.length);
  },
  // Fraction of second
  S: function S3(date, token) {
    var numberOfDigits = token.length;
    var milliseconds = date.getUTCMilliseconds();
    var fractionalSeconds = Math.floor(milliseconds * Math.pow(10, numberOfDigits - 3));
    return addLeadingZeros(fractionalSeconds, token.length);
  }
};
var lightFormatters_default = formatters;
var dayPeriodEnum = {
  am: "am",
  pm: "pm",
  midnight: "midnight",
  noon: "noon",
  morning: "morning",
  afternoon: "afternoon",
  evening: "evening",
  night: "night"
};
var formatters2 = {
  // Era
  G: function G2(date, token, localize52) {
    var era = date.getUTCFullYear() > 0 ? 1 : 0;
    switch (token) {
      case "G":
      case "GG":
      case "GGG":
        return localize52.era(era, {
          width: "abbreviated"
        });
      case "GGGGG":
        return localize52.era(era, {
          width: "narrow"
        });
      case "GGGG":
      default:
        return localize52.era(era, {
          width: "wide"
        });
    }
  },
  // Year
  y: function y22(date, token, localize52) {
    if (token === "yo") {
      var signedYear = date.getUTCFullYear();
      var year = signedYear > 0 ? signedYear : 1 - signedYear;
      return localize52.ordinalNumber(year, {
        unit: "year"
      });
    }
    return lightFormatters_default.y(date, token);
  },
  // Local week-numbering year
  Y: function Y3(date, token, localize52, options) {
    var signedWeekYear = getUTCWeekYear(date, options);
    var weekYear = signedWeekYear > 0 ? signedWeekYear : 1 - signedWeekYear;
    if (token === "YY") {
      var twoDigitYear = weekYear % 100;
      return addLeadingZeros(twoDigitYear, 2);
    }
    if (token === "Yo") {
      return localize52.ordinalNumber(weekYear, {
        unit: "year"
      });
    }
    return addLeadingZeros(weekYear, token.length);
  },
  // ISO week-numbering year
  R: function R2(date, token) {
    var isoWeekYear = getUTCISOWeekYear(date);
    return addLeadingZeros(isoWeekYear, token.length);
  },
  // Extended year. This is a single number designating the year of this calendar system.
  // The main difference between `y` and `u` localizers are B.C. years:
  // | Year | `y` | `u` |
  // |------|-----|-----|
  // | AC 1 |   1 |   1 |
  // | BC 1 |   1 |   0 |
  // | BC 2 |   2 |  -1 |
  // Also `yy` always returns the last two digits of a year,
  // while `uu` pads single digit years to 2 characters and returns other years unchanged.
  u: function u3(date, token) {
    var year = date.getUTCFullYear();
    return addLeadingZeros(year, token.length);
  },
  // Quarter
  Q: function Q2(date, token, localize52) {
    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
    switch (token) {
      case "Q":
        return String(quarter);
      case "QQ":
        return addLeadingZeros(quarter, 2);
      case "Qo":
        return localize52.ordinalNumber(quarter, {
          unit: "quarter"
        });
      case "QQQ":
        return localize52.quarter(quarter, {
          width: "abbreviated",
          context: "formatting"
        });
      case "QQQQQ":
        return localize52.quarter(quarter, {
          width: "narrow",
          context: "formatting"
        });
      case "QQQQ":
      default:
        return localize52.quarter(quarter, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone quarter
  q: function q4(date, token, localize52) {
    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
    switch (token) {
      case "q":
        return String(quarter);
      case "qq":
        return addLeadingZeros(quarter, 2);
      case "qo":
        return localize52.ordinalNumber(quarter, {
          unit: "quarter"
        });
      case "qqq":
        return localize52.quarter(quarter, {
          width: "abbreviated",
          context: "standalone"
        });
      case "qqqqq":
        return localize52.quarter(quarter, {
          width: "narrow",
          context: "standalone"
        });
      case "qqqq":
      default:
        return localize52.quarter(quarter, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // Month
  M: function M22(date, token, localize52) {
    var month = date.getUTCMonth();
    switch (token) {
      case "M":
      case "MM":
        return lightFormatters_default.M(date, token);
      case "Mo":
        return localize52.ordinalNumber(month + 1, {
          unit: "month"
        });
      case "MMM":
        return localize52.month(month, {
          width: "abbreviated",
          context: "formatting"
        });
      case "MMMMM":
        return localize52.month(month, {
          width: "narrow",
          context: "formatting"
        });
      case "MMMM":
      default:
        return localize52.month(month, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone month
  L: function L4(date, token, localize52) {
    var month = date.getUTCMonth();
    switch (token) {
      case "L":
        return String(month + 1);
      case "LL":
        return addLeadingZeros(month + 1, 2);
      case "Lo":
        return localize52.ordinalNumber(month + 1, {
          unit: "month"
        });
      case "LLL":
        return localize52.month(month, {
          width: "abbreviated",
          context: "standalone"
        });
      case "LLLLL":
        return localize52.month(month, {
          width: "narrow",
          context: "standalone"
        });
      case "LLLL":
      default:
        return localize52.month(month, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // Local week of year
  w: function w4(date, token, localize52, options) {
    var week = getUTCWeek(date, options);
    if (token === "wo") {
      return localize52.ordinalNumber(week, {
        unit: "week"
      });
    }
    return addLeadingZeros(week, token.length);
  },
  // ISO week of year
  I: function I4(date, token, localize52) {
    var isoWeek = getUTCISOWeek(date);
    if (token === "Io") {
      return localize52.ordinalNumber(isoWeek, {
        unit: "week"
      });
    }
    return addLeadingZeros(isoWeek, token.length);
  },
  // Day of the month
  d: function d22(date, token, localize52) {
    if (token === "do") {
      return localize52.ordinalNumber(date.getUTCDate(), {
        unit: "date"
      });
    }
    return lightFormatters_default.d(date, token);
  },
  // Day of year
  D: function D4(date, token, localize52) {
    var dayOfYear = getUTCDayOfYear(date);
    if (token === "Do") {
      return localize52.ordinalNumber(dayOfYear, {
        unit: "dayOfYear"
      });
    }
    return addLeadingZeros(dayOfYear, token.length);
  },
  // Day of week
  E: function E2(date, token, localize52) {
    var dayOfWeek = date.getUTCDay();
    switch (token) {
      case "E":
      case "EE":
      case "EEE":
        return localize52.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "EEEEE":
        return localize52.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "EEEEEE":
        return localize52.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "EEEE":
      default:
        return localize52.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Local day of week
  e: function e3(date, token, localize52, options) {
    var dayOfWeek = date.getUTCDay();
    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      case "e":
        return String(localDayOfWeek);
      case "ee":
        return addLeadingZeros(localDayOfWeek, 2);
      case "eo":
        return localize52.ordinalNumber(localDayOfWeek, {
          unit: "day"
        });
      case "eee":
        return localize52.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "eeeee":
        return localize52.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "eeeeee":
        return localize52.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "eeee":
      default:
        return localize52.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone local day of week
  c: function c3(date, token, localize52, options) {
    var dayOfWeek = date.getUTCDay();
    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      case "c":
        return String(localDayOfWeek);
      case "cc":
        return addLeadingZeros(localDayOfWeek, token.length);
      case "co":
        return localize52.ordinalNumber(localDayOfWeek, {
          unit: "day"
        });
      case "ccc":
        return localize52.day(dayOfWeek, {
          width: "abbreviated",
          context: "standalone"
        });
      case "ccccc":
        return localize52.day(dayOfWeek, {
          width: "narrow",
          context: "standalone"
        });
      case "cccccc":
        return localize52.day(dayOfWeek, {
          width: "short",
          context: "standalone"
        });
      case "cccc":
      default:
        return localize52.day(dayOfWeek, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // ISO day of week
  i: function i3(date, token, localize52) {
    var dayOfWeek = date.getUTCDay();
    var isoDayOfWeek = dayOfWeek === 0 ? 7 : dayOfWeek;
    switch (token) {
      case "i":
        return String(isoDayOfWeek);
      case "ii":
        return addLeadingZeros(isoDayOfWeek, token.length);
      case "io":
        return localize52.ordinalNumber(isoDayOfWeek, {
          unit: "day"
        });
      case "iii":
        return localize52.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "iiiii":
        return localize52.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "iiiiii":
        return localize52.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "iiii":
      default:
        return localize52.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // AM or PM
  a: function a22(date, token, localize52) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
    switch (token) {
      case "a":
      case "aa":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "aaa":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "aaaaa":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "aaaa":
      default:
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // AM, PM, midnight, noon
  b: function b3(date, token, localize52) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue;
    if (hours === 12) {
      dayPeriodEnumValue = dayPeriodEnum.noon;
    } else if (hours === 0) {
      dayPeriodEnumValue = dayPeriodEnum.midnight;
    } else {
      dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
    }
    switch (token) {
      case "b":
      case "bb":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "bbb":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "bbbbb":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "bbbb":
      default:
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // in the morning, in the afternoon, in the evening, at night
  B: function B4(date, token, localize52) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue;
    if (hours >= 17) {
      dayPeriodEnumValue = dayPeriodEnum.evening;
    } else if (hours >= 12) {
      dayPeriodEnumValue = dayPeriodEnum.afternoon;
    } else if (hours >= 4) {
      dayPeriodEnumValue = dayPeriodEnum.morning;
    } else {
      dayPeriodEnumValue = dayPeriodEnum.night;
    }
    switch (token) {
      case "B":
      case "BB":
      case "BBB":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "BBBBB":
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "BBBB":
      default:
        return localize52.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Hour [1-12]
  h: function h13(date, token, localize52) {
    if (token === "ho") {
      var hours = date.getUTCHours() % 12;
      if (hours === 0)
        hours = 12;
      return localize52.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return lightFormatters_default.h(date, token);
  },
  // Hour [0-23]
  H: function H22(date, token, localize52) {
    if (token === "Ho") {
      return localize52.ordinalNumber(date.getUTCHours(), {
        unit: "hour"
      });
    }
    return lightFormatters_default.H(date, token);
  },
  // Hour [0-11]
  K: function K4(date, token, localize52) {
    var hours = date.getUTCHours() % 12;
    if (token === "Ko") {
      return localize52.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return addLeadingZeros(hours, token.length);
  },
  // Hour [1-24]
  k: function k4(date, token, localize52) {
    var hours = date.getUTCHours();
    if (hours === 0)
      hours = 24;
    if (token === "ko") {
      return localize52.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return addLeadingZeros(hours, token.length);
  },
  // Minute
  m: function m22(date, token, localize52) {
    if (token === "mo") {
      return localize52.ordinalNumber(date.getUTCMinutes(), {
        unit: "minute"
      });
    }
    return lightFormatters_default.m(date, token);
  },
  // Second
  s: function s22(date, token, localize52) {
    if (token === "so") {
      return localize52.ordinalNumber(date.getUTCSeconds(), {
        unit: "second"
      });
    }
    return lightFormatters_default.s(date, token);
  },
  // Fraction of second
  S: function S22(date, token) {
    return lightFormatters_default.S(date, token);
  },
  // Timezone (ISO-8601. If offset is 0, output is always `'Z'`)
  X: function X3(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    if (timezoneOffset === 0) {
      return "Z";
    }
    switch (token) {
      case "X":
        return formatTimezoneWithOptionalMinutes(timezoneOffset);
      case "XXXX":
      case "XX":
        return formatTimezone(timezoneOffset);
      case "XXXXX":
      case "XXX":
      default:
        return formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (ISO-8601. If offset is 0, output is `'+00:00'` or equivalent)
  x: function x4(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "x":
        return formatTimezoneWithOptionalMinutes(timezoneOffset);
      case "xxxx":
      case "xx":
        return formatTimezone(timezoneOffset);
      case "xxxxx":
      case "xxx":
      default:
        return formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (GMT)
  O: function O3(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "O":
      case "OO":
      case "OOO":
        return "GMT" + formatTimezoneShort(timezoneOffset, ":");
      case "OOOO":
      default:
        return "GMT" + formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (specific non-location)
  z: function z4(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "z":
      case "zz":
      case "zzz":
        return "GMT" + formatTimezoneShort(timezoneOffset, ":");
      case "zzzz":
      default:
        return "GMT" + formatTimezone(timezoneOffset, ":");
    }
  },
  // Seconds timestamp
  t: function t3(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timestamp = Math.floor(originalDate.getTime() / 1e3);
    return addLeadingZeros(timestamp, token.length);
  },
  // Milliseconds timestamp
  T: function T4(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timestamp = originalDate.getTime();
    return addLeadingZeros(timestamp, token.length);
  }
};
function formatTimezoneShort(offset, dirtyDelimiter) {
  var sign2 = offset > 0 ? "-" : "+";
  var absOffset = Math.abs(offset);
  var hours = Math.floor(absOffset / 60);
  var minutes = absOffset % 60;
  if (minutes === 0) {
    return sign2 + String(hours);
  }
  var delimiter2 = dirtyDelimiter || "";
  return sign2 + String(hours) + delimiter2 + addLeadingZeros(minutes, 2);
}
function formatTimezoneWithOptionalMinutes(offset, dirtyDelimiter) {
  if (offset % 60 === 0) {
    var sign2 = offset > 0 ? "-" : "+";
    return sign2 + addLeadingZeros(Math.abs(offset) / 60, 2);
  }
  return formatTimezone(offset, dirtyDelimiter);
}
function formatTimezone(offset, dirtyDelimiter) {
  var delimiter2 = dirtyDelimiter || "";
  var sign2 = offset > 0 ? "-" : "+";
  var absOffset = Math.abs(offset);
  var hours = addLeadingZeros(Math.floor(absOffset / 60), 2);
  var minutes = addLeadingZeros(absOffset % 60, 2);
  return sign2 + hours + delimiter2 + minutes;
}
var formatters_default = formatters2;
var dateLongFormatter = function dateLongFormatter2(pattern, formatLong62) {
  switch (pattern) {
    case "P":
      return formatLong62.date({
        width: "short"
      });
    case "PP":
      return formatLong62.date({
        width: "medium"
      });
    case "PPP":
      return formatLong62.date({
        width: "long"
      });
    case "PPPP":
    default:
      return formatLong62.date({
        width: "full"
      });
  }
};
var timeLongFormatter = function timeLongFormatter2(pattern, formatLong62) {
  switch (pattern) {
    case "p":
      return formatLong62.time({
        width: "short"
      });
    case "pp":
      return formatLong62.time({
        width: "medium"
      });
    case "ppp":
      return formatLong62.time({
        width: "long"
      });
    case "pppp":
    default:
      return formatLong62.time({
        width: "full"
      });
  }
};
var dateTimeLongFormatter = function dateTimeLongFormatter2(pattern, formatLong62) {
  var matchResult = pattern.match(/(P+)(p+)?/) || [];
  var datePattern = matchResult[1];
  var timePattern = matchResult[2];
  if (!timePattern) {
    return dateLongFormatter(pattern, formatLong62);
  }
  var dateTimeFormat;
  switch (datePattern) {
    case "P":
      dateTimeFormat = formatLong62.dateTime({
        width: "short"
      });
      break;
    case "PP":
      dateTimeFormat = formatLong62.dateTime({
        width: "medium"
      });
      break;
    case "PPP":
      dateTimeFormat = formatLong62.dateTime({
        width: "long"
      });
      break;
    case "PPPP":
    default:
      dateTimeFormat = formatLong62.dateTime({
        width: "full"
      });
      break;
  }
  return dateTimeFormat.replace("{{date}}", dateLongFormatter(datePattern, formatLong62)).replace("{{time}}", timeLongFormatter(timePattern, formatLong62));
};
var longFormatters = {
  p: timeLongFormatter,
  P: dateTimeLongFormatter
};
var longFormatters_default = longFormatters;
var protectedDayOfYearTokens = ["D", "DD"];
var protectedWeekYearTokens = ["YY", "YYYY"];
function isProtectedDayOfYearToken(token) {
  return protectedDayOfYearTokens.indexOf(token) !== -1;
}
function isProtectedWeekYearToken(token) {
  return protectedWeekYearTokens.indexOf(token) !== -1;
}
function throwProtectedError(token, format22, input) {
  if (token === "YYYY") {
    throw new RangeError("Use `yyyy` instead of `YYYY` (in `".concat(format22, "`) for formatting years to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "YY") {
    throw new RangeError("Use `yy` instead of `YY` (in `".concat(format22, "`) for formatting years to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "D") {
    throw new RangeError("Use `d` instead of `D` (in `".concat(format22, "`) for formatting days of the month to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "DD") {
    throw new RangeError("Use `dd` instead of `DD` (in `".concat(format22, "`) for formatting days of the month to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  }
}
var formatDistanceLocale = {
  lessThanXSeconds: {
    one: "less than a second",
    other: "less than {{count}} seconds"
  },
  xSeconds: {
    one: "1 second",
    other: "{{count}} seconds"
  },
  halfAMinute: "half a minute",
  lessThanXMinutes: {
    one: "less than a minute",
    other: "less than {{count}} minutes"
  },
  xMinutes: {
    one: "1 minute",
    other: "{{count}} minutes"
  },
  aboutXHours: {
    one: "about 1 hour",
    other: "about {{count}} hours"
  },
  xHours: {
    one: "1 hour",
    other: "{{count}} hours"
  },
  xDays: {
    one: "1 day",
    other: "{{count}} days"
  },
  aboutXWeeks: {
    one: "about 1 week",
    other: "about {{count}} weeks"
  },
  xWeeks: {
    one: "1 week",
    other: "{{count}} weeks"
  },
  aboutXMonths: {
    one: "about 1 month",
    other: "about {{count}} months"
  },
  xMonths: {
    one: "1 month",
    other: "{{count}} months"
  },
  aboutXYears: {
    one: "about 1 year",
    other: "about {{count}} years"
  },
  xYears: {
    one: "1 year",
    other: "{{count}} years"
  },
  overXYears: {
    one: "over 1 year",
    other: "over {{count}} years"
  },
  almostXYears: {
    one: "almost 1 year",
    other: "almost {{count}} years"
  }
};
var formatDistance = function formatDistance2(token, count, options) {
  var result;
  var tokenValue = formatDistanceLocale[token];
  if (typeof tokenValue === "string") {
    result = tokenValue;
  } else if (count === 1) {
    result = tokenValue.one;
  } else {
    result = tokenValue.other.replace("{{count}}", count.toString());
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "in " + result;
    } else {
      return result + " ago";
    }
  }
  return result;
};
var formatDistance_default = formatDistance;
function buildFormatLongFn(args) {
  return function() {
    var options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    var width = options.width ? String(options.width) : args.defaultWidth;
    var format22 = args.formats[width] || args.formats[args.defaultWidth];
    return format22;
  };
}
var dateFormats = {
  full: "EEEE, MMMM do, y",
  long: "MMMM do, y",
  medium: "MMM d, y",
  short: "MM/dd/yyyy"
};
var timeFormats = {
  full: "h:mm:ss a zzzz",
  long: "h:mm:ss a z",
  medium: "h:mm:ss a",
  short: "h:mm a"
};
var dateTimeFormats = {
  full: "{{date}} 'at' {{time}}",
  long: "{{date}} 'at' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong = {
  date: buildFormatLongFn({
    formats: dateFormats,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn({
    formats: timeFormats,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn({
    formats: dateTimeFormats,
    defaultWidth: "full"
  })
};
var formatLong_default = formatLong;
var formatRelativeLocale = {
  lastWeek: "'last' eeee 'at' p",
  yesterday: "'yesterday at' p",
  today: "'today at' p",
  tomorrow: "'tomorrow at' p",
  nextWeek: "eeee 'at' p",
  other: "P"
};
var formatRelative = function formatRelative2(token, _date, _baseDate, _options) {
  return formatRelativeLocale[token];
};
var formatRelative_default = formatRelative;
function buildLocalizeFn(args) {
  return function(dirtyIndex, options) {
    var context = options !== null && options !== void 0 && options.context ? String(options.context) : "standalone";
    var valuesArray;
    if (context === "formatting" && args.formattingValues) {
      var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
      var width = options !== null && options !== void 0 && options.width ? String(options.width) : defaultWidth;
      valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
    } else {
      var _defaultWidth = args.defaultWidth;
      var _width = options !== null && options !== void 0 && options.width ? String(options.width) : args.defaultWidth;
      valuesArray = args.values[_width] || args.values[_defaultWidth];
    }
    var index = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex;
    return valuesArray[index];
  };
}
var eraValues = {
  narrow: ["B", "A"],
  abbreviated: ["BC", "AD"],
  wide: ["Before Christ", "Anno Domini"]
};
var quarterValues = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["Q1", "Q2", "Q3", "Q4"],
  wide: ["1st quarter", "2nd quarter", "3rd quarter", "4th quarter"]
};
var monthValues = {
  narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
  abbreviated: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
  wide: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]
};
var dayValues = {
  narrow: ["S", "M", "T", "W", "T", "F", "S"],
  short: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
  abbreviated: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
  wide: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
};
var dayPeriodValues = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  }
};
var formattingDayPeriodValues = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  }
};
var ordinalNumber = function ordinalNumber2(dirtyNumber, _options) {
  var number = Number(dirtyNumber);
  var rem100 = number % 100;
  if (rem100 > 20 || rem100 < 10) {
    switch (rem100 % 10) {
      case 1:
        return number + "st";
      case 2:
        return number + "nd";
      case 3:
        return number + "rd";
    }
  }
  return number + "th";
};
var localize = {
  ordinalNumber,
  era: buildLocalizeFn({
    values: eraValues,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn({
    values: quarterValues,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback(quarter) {
      return quarter - 1;
    }
  }),
  month: buildLocalizeFn({
    values: monthValues,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn({
    values: dayValues,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn({
    values: dayPeriodValues,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues,
    defaultFormattingWidth: "wide"
  })
};
var localize_default = localize;
function buildMatchFn(args) {
  return function(string) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var width = options.width;
    var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
    var matchResult = string.match(matchPattern);
    if (!matchResult) {
      return null;
    }
    var matchedString = matchResult[0];
    var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
    var key = Array.isArray(parsePatterns) ? findIndex(parsePatterns, function(pattern) {
      return pattern.test(matchedString);
    }) : findKey(parsePatterns, function(pattern) {
      return pattern.test(matchedString);
    });
    var value;
    value = args.valueCallback ? args.valueCallback(key) : key;
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value,
      rest
    };
  };
}
function findKey(object, predicate) {
  for (var key in object) {
    if (object.hasOwnProperty(key) && predicate(object[key])) {
      return key;
    }
  }
  return void 0;
}
function findIndex(array, predicate) {
  for (var key = 0; key < array.length; key++) {
    if (predicate(array[key])) {
      return key;
    }
  }
  return void 0;
}
function buildMatchPatternFn(args) {
  return function(string) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var matchResult = string.match(args.matchPattern);
    if (!matchResult)
      return null;
    var matchedString = matchResult[0];
    var parseResult = string.match(args.parsePattern);
    if (!parseResult)
      return null;
    var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value,
      rest
    };
  };
}
var matchOrdinalNumberPattern = /^(\d+)(th|st|nd|rd)?/i;
var parseOrdinalNumberPattern = /\d+/i;
var matchEraPatterns = {
  narrow: /^(b|a)/i,
  abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
  wide: /^(before christ|before common era|anno domini|common era)/i
};
var parseEraPatterns = {
  any: [/^b/i, /^(a|c)/i]
};
var matchQuarterPatterns = {
  narrow: /^[1234]/i,
  abbreviated: /^q[1234]/i,
  wide: /^[1234](th|st|nd|rd)? quarter/i
};
var parseQuarterPatterns = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
  wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
};
var parseMonthPatterns = {
  narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
  any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
};
var matchDayPatterns = {
  narrow: /^[smtwf]/i,
  short: /^(su|mo|tu|we|th|fr|sa)/i,
  abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
  wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
};
var parseDayPatterns = {
  narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
  any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
};
var matchDayPeriodPatterns = {
  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
};
var parseDayPeriodPatterns = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mi/i,
    noon: /^no/i,
    morning: /morning/i,
    afternoon: /afternoon/i,
    evening: /evening/i,
    night: /night/i
  }
};
var match = {
  ordinalNumber: buildMatchPatternFn({
    matchPattern: matchOrdinalNumberPattern,
    parsePattern: parseOrdinalNumberPattern,
    valueCallback: function valueCallback(value) {
      return parseInt(value, 10);
    }
  }),
  era: buildMatchFn({
    matchPatterns: matchEraPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn({
    matchPatterns: matchQuarterPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns,
    defaultParseWidth: "any",
    valueCallback: function valueCallback2(index) {
      return index + 1;
    }
  }),
  month: buildMatchFn({
    matchPatterns: matchMonthPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn({
    matchPatterns: matchDayPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn({
    matchPatterns: matchDayPeriodPatterns,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns,
    defaultParseWidth: "any"
  })
};
var match_default = match;
var locale = {
  code: "en-US",
  formatDistance: formatDistance_default,
  formatLong: formatLong_default,
  formatRelative: formatRelative_default,
  localize: localize_default,
  match: match_default,
  options: {
    weekStartsOn: 0,
    firstWeekContainsDate: 1
  }
};
var en_US_default = locale;
var defaultLocale_default = en_US_default;
var formattingTokensRegExp = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
var longFormattingTokensRegExp = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
var escapedStringRegExp = /^'([^]*?)'?$/;
var doubleQuoteRegExp = /''/g;
var unescapedLatinCharacterRegExp = /[a-zA-Z]/;
function format(dirtyDate, dirtyFormatStr, options) {
  var _ref, _options$locale, _ref2, _ref3, _ref4, _options$firstWeekCon, _options$locale2, _options$locale2$opti, _defaultOptions$local, _defaultOptions$local2, _ref5, _ref6, _ref7, _options$weekStartsOn, _options$locale3, _options$locale3$opti, _defaultOptions$local3, _defaultOptions$local4;
  requiredArgs(2, arguments);
  var formatStr = String(dirtyFormatStr);
  var defaultOptions2 = getDefaultOptions();
  var locale62 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref !== void 0 ? _ref : defaultLocale_default;
  var firstWeekContainsDate = toInteger((_ref2 = (_ref3 = (_ref4 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale2 = options.locale) === null || _options$locale2 === void 0 ? void 0 : (_options$locale2$opti = _options$locale2.options) === null || _options$locale2$opti === void 0 ? void 0 : _options$locale2$opti.firstWeekContainsDate) !== null && _ref4 !== void 0 ? _ref4 : defaultOptions2.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var weekStartsOn = toInteger((_ref5 = (_ref6 = (_ref7 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale3 = options.locale) === null || _options$locale3 === void 0 ? void 0 : (_options$locale3$opti = _options$locale3.options) === null || _options$locale3$opti === void 0 ? void 0 : _options$locale3$opti.weekStartsOn) !== null && _ref7 !== void 0 ? _ref7 : defaultOptions2.weekStartsOn) !== null && _ref6 !== void 0 ? _ref6 : (_defaultOptions$local3 = defaultOptions2.locale) === null || _defaultOptions$local3 === void 0 ? void 0 : (_defaultOptions$local4 = _defaultOptions$local3.options) === null || _defaultOptions$local4 === void 0 ? void 0 : _defaultOptions$local4.weekStartsOn) !== null && _ref5 !== void 0 ? _ref5 : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  if (!locale62.localize) {
    throw new RangeError("locale must contain localize property");
  }
  if (!locale62.formatLong) {
    throw new RangeError("locale must contain formatLong property");
  }
  var originalDate = toDate(dirtyDate);
  if (!isValid(originalDate)) {
    throw new RangeError("Invalid time value");
  }
  var timezoneOffset = getTimezoneOffsetInMilliseconds(originalDate);
  var utcDate = subMilliseconds(originalDate, timezoneOffset);
  var formatterOptions = {
    firstWeekContainsDate,
    weekStartsOn,
    locale: locale62,
    _originalDate: originalDate
  };
  var result = formatStr.match(longFormattingTokensRegExp).map(function(substring) {
    var firstCharacter = substring[0];
    if (firstCharacter === "p" || firstCharacter === "P") {
      var longFormatter = longFormatters_default[firstCharacter];
      return longFormatter(substring, locale62.formatLong);
    }
    return substring;
  }).join("").match(formattingTokensRegExp).map(function(substring) {
    if (substring === "''") {
      return "'";
    }
    var firstCharacter = substring[0];
    if (firstCharacter === "'") {
      return cleanEscapedString(substring);
    }
    var formatter = formatters_default[firstCharacter];
    if (formatter) {
      if (!(options !== null && options !== void 0 && options.useAdditionalWeekYearTokens) && isProtectedWeekYearToken(substring)) {
        throwProtectedError(substring, dirtyFormatStr, String(dirtyDate));
      }
      if (!(options !== null && options !== void 0 && options.useAdditionalDayOfYearTokens) && isProtectedDayOfYearToken(substring)) {
        throwProtectedError(substring, dirtyFormatStr, String(dirtyDate));
      }
      return formatter(utcDate, substring, locale62.localize, formatterOptions);
    }
    if (firstCharacter.match(unescapedLatinCharacterRegExp)) {
      throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
    }
    return substring;
  }).join("");
  return result;
}
function cleanEscapedString(input) {
  var matched = input.match(escapedStringRegExp);
  if (!matched) {
    return input;
  }
  return matched[1].replace(doubleQuoteRegExp, "'");
}
function assign(target, object) {
  if (target == null) {
    throw new TypeError("assign requires that input parameter not be null or undefined");
  }
  for (var property in object) {
    if (Object.prototype.hasOwnProperty.call(object, property)) {
      ;
      target[property] = object[property];
    }
  }
  return target;
}
function getMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var month = date.getMonth();
  return month;
}
function getYear(dirtyDate) {
  requiredArgs(1, arguments);
  return toDate(dirtyDate).getFullYear();
}
function intervalToDuration(interval) {
  requiredArgs(1, arguments);
  var start = toDate(interval.start);
  var end = toDate(interval.end);
  if (isNaN(start.getTime()))
    throw new RangeError("Start Date is invalid");
  if (isNaN(end.getTime()))
    throw new RangeError("End Date is invalid");
  var duration = {};
  duration.years = Math.abs(differenceInYears(end, start));
  var sign2 = compareAsc(end, start);
  var remainingMonths = add2(start, {
    years: sign2 * duration.years
  });
  duration.months = Math.abs(differenceInMonths(end, remainingMonths));
  var remainingDays = add2(remainingMonths, {
    months: sign2 * duration.months
  });
  duration.days = Math.abs(differenceInDays(end, remainingDays));
  var remainingHours = add2(remainingDays, {
    days: sign2 * duration.days
  });
  duration.hours = Math.abs(differenceInHours(end, remainingHours));
  var remainingMinutes = add2(remainingHours, {
    hours: sign2 * duration.hours
  });
  duration.minutes = Math.abs(differenceInMinutes(end, remainingMinutes));
  var remainingSeconds = add2(remainingMinutes, {
    minutes: sign2 * duration.minutes
  });
  duration.seconds = Math.abs(differenceInSeconds(end, remainingSeconds));
  return duration;
}
function isFuture(dirtyDate) {
  requiredArgs(1, arguments);
  return toDate(dirtyDate).getTime() > Date.now();
}
function _typeof4(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof4 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof4 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof4(obj);
}
function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf(subClass, superClass);
}
function _setPrototypeOf(o3, p4) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf(o3, p4);
}
function _createSuper(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn(this, result);
  };
}
function _possibleConstructorReturn(self2, call) {
  if (call && (_typeof4(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized(self2);
}
function _assertThisInitialized(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf(o3) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf(o3);
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  return Constructor;
}
function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var TIMEZONE_UNIT_PRIORITY = 10;
var Setter = /* @__PURE__ */ function() {
  function Setter2() {
    _classCallCheck(this, Setter2);
    _defineProperty(this, "subPriority", 0);
  }
  _createClass(Setter2, [{
    key: "validate",
    value: function validate(_utcDate, _options) {
      return true;
    }
  }]);
  return Setter2;
}();
var ValueSetter = /* @__PURE__ */ function(_Setter) {
  _inherits(ValueSetter2, _Setter);
  var _super = _createSuper(ValueSetter2);
  function ValueSetter2(value, validateValue, setValue, priority, subPriority) {
    var _this;
    _classCallCheck(this, ValueSetter2);
    _this = _super.call(this);
    _this.value = value;
    _this.validateValue = validateValue;
    _this.setValue = setValue;
    _this.priority = priority;
    if (subPriority) {
      _this.subPriority = subPriority;
    }
    return _this;
  }
  _createClass(ValueSetter2, [{
    key: "validate",
    value: function validate(utcDate, options) {
      return this.validateValue(utcDate, this.value, options);
    }
  }, {
    key: "set",
    value: function set(utcDate, flags, options) {
      return this.setValue(utcDate, flags, this.value, options);
    }
  }]);
  return ValueSetter2;
}(Setter);
var DateToSystemTimezoneSetter = /* @__PURE__ */ function(_Setter2) {
  _inherits(DateToSystemTimezoneSetter2, _Setter2);
  var _super2 = _createSuper(DateToSystemTimezoneSetter2);
  function DateToSystemTimezoneSetter2() {
    var _this2;
    _classCallCheck(this, DateToSystemTimezoneSetter2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this2 = _super2.call.apply(_super2, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this2), "priority", TIMEZONE_UNIT_PRIORITY);
    _defineProperty(_assertThisInitialized(_this2), "subPriority", -1);
    return _this2;
  }
  _createClass(DateToSystemTimezoneSetter2, [{
    key: "set",
    value: function set(date, flags) {
      if (flags.timestampIsSet) {
        return date;
      }
      var convertedDate = /* @__PURE__ */ new Date(0);
      convertedDate.setFullYear(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate());
      convertedDate.setHours(date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds(), date.getUTCMilliseconds());
      return convertedDate;
    }
  }]);
  return DateToSystemTimezoneSetter2;
}(Setter);
function _classCallCheck2(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties2(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass2(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties2(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties2(Constructor, staticProps);
  return Constructor;
}
var Parser = /* @__PURE__ */ function() {
  function Parser2() {
    _classCallCheck2(this, Parser2);
  }
  _createClass2(Parser2, [{
    key: "run",
    value: function run(dateString, token, match52, options) {
      var result = this.parse(dateString, token, match52, options);
      if (!result) {
        return null;
      }
      return {
        setter: new ValueSetter(result.value, this.validate, this.set, this.priority, this.subPriority),
        rest: result.rest
      };
    }
  }, {
    key: "validate",
    value: function validate(_utcDate, _value, _options) {
      return true;
    }
  }]);
  return Parser2;
}();
function _typeof5(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof5 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof5 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof5(obj);
}
function _classCallCheck3(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties3(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass3(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties3(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties3(Constructor, staticProps);
  return Constructor;
}
function _inherits2(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf2(subClass, superClass);
}
function _setPrototypeOf2(o3, p4) {
  _setPrototypeOf2 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf2(o3, p4);
}
function _createSuper2(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct2();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf2(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf2(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn2(this, result);
  };
}
function _possibleConstructorReturn2(self2, call) {
  if (call && (_typeof5(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized2(self2);
}
function _assertThisInitialized2(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct2() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf2(o3) {
  _getPrototypeOf2 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf2(o3);
}
function _defineProperty2(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var EraParser = /* @__PURE__ */ function(_Parser) {
  _inherits2(EraParser2, _Parser);
  var _super = _createSuper2(EraParser2);
  function EraParser2() {
    var _this;
    _classCallCheck3(this, EraParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty2(_assertThisInitialized2(_this), "priority", 140);
    _defineProperty2(_assertThisInitialized2(_this), "incompatibleTokens", ["R", "u", "t", "T"]);
    return _this;
  }
  _createClass3(EraParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "G":
        case "GG":
        case "GGG":
          return match52.era(dateString, {
            width: "abbreviated"
          }) || match52.era(dateString, {
            width: "narrow"
          });
        case "GGGGG":
          return match52.era(dateString, {
            width: "narrow"
          });
        case "GGGG":
        default:
          return match52.era(dateString, {
            width: "wide"
          }) || match52.era(dateString, {
            width: "abbreviated"
          }) || match52.era(dateString, {
            width: "narrow"
          });
      }
    }
  }, {
    key: "set",
    value: function set(date, flags, value) {
      flags.era = value;
      date.setUTCFullYear(value, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return EraParser2;
}(Parser);
var numericPatterns = {
  month: /^(1[0-2]|0?\d)/,
  // 0 to 12
  date: /^(3[0-1]|[0-2]?\d)/,
  // 0 to 31
  dayOfYear: /^(36[0-6]|3[0-5]\d|[0-2]?\d?\d)/,
  // 0 to 366
  week: /^(5[0-3]|[0-4]?\d)/,
  // 0 to 53
  hour23h: /^(2[0-3]|[0-1]?\d)/,
  // 0 to 23
  hour24h: /^(2[0-4]|[0-1]?\d)/,
  // 0 to 24
  hour11h: /^(1[0-1]|0?\d)/,
  // 0 to 11
  hour12h: /^(1[0-2]|0?\d)/,
  // 0 to 12
  minute: /^[0-5]?\d/,
  // 0 to 59
  second: /^[0-5]?\d/,
  // 0 to 59
  singleDigit: /^\d/,
  // 0 to 9
  twoDigits: /^\d{1,2}/,
  // 0 to 99
  threeDigits: /^\d{1,3}/,
  // 0 to 999
  fourDigits: /^\d{1,4}/,
  // 0 to 9999
  anyDigitsSigned: /^-?\d+/,
  singleDigitSigned: /^-?\d/,
  // 0 to 9, -0 to -9
  twoDigitsSigned: /^-?\d{1,2}/,
  // 0 to 99, -0 to -99
  threeDigitsSigned: /^-?\d{1,3}/,
  // 0 to 999, -0 to -999
  fourDigitsSigned: /^-?\d{1,4}/
  // 0 to 9999, -0 to -9999
};
var timezonePatterns = {
  basicOptionalMinutes: /^([+-])(\d{2})(\d{2})?|Z/,
  basic: /^([+-])(\d{2})(\d{2})|Z/,
  basicOptionalSeconds: /^([+-])(\d{2})(\d{2})((\d{2}))?|Z/,
  extended: /^([+-])(\d{2}):(\d{2})|Z/,
  extendedOptionalSeconds: /^([+-])(\d{2}):(\d{2})(:(\d{2}))?|Z/
};
function mapValue(parseFnResult, mapFn) {
  if (!parseFnResult) {
    return parseFnResult;
  }
  return {
    value: mapFn(parseFnResult.value),
    rest: parseFnResult.rest
  };
}
function parseNumericPattern(pattern, dateString) {
  var matchResult = dateString.match(pattern);
  if (!matchResult) {
    return null;
  }
  return {
    value: parseInt(matchResult[0], 10),
    rest: dateString.slice(matchResult[0].length)
  };
}
function parseTimezonePattern(pattern, dateString) {
  var matchResult = dateString.match(pattern);
  if (!matchResult) {
    return null;
  }
  if (matchResult[0] === "Z") {
    return {
      value: 0,
      rest: dateString.slice(1)
    };
  }
  var sign2 = matchResult[1] === "+" ? 1 : -1;
  var hours = matchResult[2] ? parseInt(matchResult[2], 10) : 0;
  var minutes = matchResult[3] ? parseInt(matchResult[3], 10) : 0;
  var seconds = matchResult[5] ? parseInt(matchResult[5], 10) : 0;
  return {
    value: sign2 * (hours * millisecondsInHour + minutes * millisecondsInMinute + seconds * millisecondsInSecond),
    rest: dateString.slice(matchResult[0].length)
  };
}
function parseAnyDigitsSigned(dateString) {
  return parseNumericPattern(numericPatterns.anyDigitsSigned, dateString);
}
function parseNDigits(n2, dateString) {
  switch (n2) {
    case 1:
      return parseNumericPattern(numericPatterns.singleDigit, dateString);
    case 2:
      return parseNumericPattern(numericPatterns.twoDigits, dateString);
    case 3:
      return parseNumericPattern(numericPatterns.threeDigits, dateString);
    case 4:
      return parseNumericPattern(numericPatterns.fourDigits, dateString);
    default:
      return parseNumericPattern(new RegExp("^\\d{1," + n2 + "}"), dateString);
  }
}
function parseNDigitsSigned(n2, dateString) {
  switch (n2) {
    case 1:
      return parseNumericPattern(numericPatterns.singleDigitSigned, dateString);
    case 2:
      return parseNumericPattern(numericPatterns.twoDigitsSigned, dateString);
    case 3:
      return parseNumericPattern(numericPatterns.threeDigitsSigned, dateString);
    case 4:
      return parseNumericPattern(numericPatterns.fourDigitsSigned, dateString);
    default:
      return parseNumericPattern(new RegExp("^-?\\d{1," + n2 + "}"), dateString);
  }
}
function dayPeriodEnumToHours(dayPeriod) {
  switch (dayPeriod) {
    case "morning":
      return 4;
    case "evening":
      return 17;
    case "pm":
    case "noon":
    case "afternoon":
      return 12;
    case "am":
    case "midnight":
    case "night":
    default:
      return 0;
  }
}
function normalizeTwoDigitYear(twoDigitYear, currentYear) {
  var isCommonEra = currentYear > 0;
  var absCurrentYear = isCommonEra ? currentYear : 1 - currentYear;
  var result;
  if (absCurrentYear <= 50) {
    result = twoDigitYear || 100;
  } else {
    var rangeEnd = absCurrentYear + 50;
    var rangeEndCentury = Math.floor(rangeEnd / 100) * 100;
    var isPreviousCentury = twoDigitYear >= rangeEnd % 100;
    result = twoDigitYear + rangeEndCentury - (isPreviousCentury ? 100 : 0);
  }
  return isCommonEra ? result : 1 - result;
}
function isLeapYearIndex(year) {
  return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
}
function _typeof6(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof6 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof6 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof6(obj);
}
function _classCallCheck4(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties4(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass4(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties4(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties4(Constructor, staticProps);
  return Constructor;
}
function _inherits3(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf3(subClass, superClass);
}
function _setPrototypeOf3(o3, p4) {
  _setPrototypeOf3 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf3(o3, p4);
}
function _createSuper3(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct3();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf3(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf3(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn3(this, result);
  };
}
function _possibleConstructorReturn3(self2, call) {
  if (call && (_typeof6(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized3(self2);
}
function _assertThisInitialized3(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct3() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf3(o3) {
  _getPrototypeOf3 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf3(o3);
}
function _defineProperty3(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var YearParser = /* @__PURE__ */ function(_Parser) {
  _inherits3(YearParser2, _Parser);
  var _super = _createSuper3(YearParser2);
  function YearParser2() {
    var _this;
    _classCallCheck4(this, YearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty3(_assertThisInitialized3(_this), "priority", 130);
    _defineProperty3(_assertThisInitialized3(_this), "incompatibleTokens", ["Y", "R", "u", "w", "I", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass4(YearParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      var valueCallback92 = function valueCallback102(year) {
        return {
          year,
          isTwoDigitYear: token === "yy"
        };
      };
      switch (token) {
        case "y":
          return mapValue(parseNDigits(4, dateString), valueCallback92);
        case "yo":
          return mapValue(match52.ordinalNumber(dateString, {
            unit: "year"
          }), valueCallback92);
        default:
          return mapValue(parseNDigits(token.length, dateString), valueCallback92);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value.isTwoDigitYear || value.year > 0;
    }
  }, {
    key: "set",
    value: function set(date, flags, value) {
      var currentYear = date.getUTCFullYear();
      if (value.isTwoDigitYear) {
        var normalizedTwoDigitYear = normalizeTwoDigitYear(value.year, currentYear);
        date.setUTCFullYear(normalizedTwoDigitYear, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      }
      var year = !("era" in flags) || flags.era === 1 ? value.year : 1 - value.year;
      date.setUTCFullYear(year, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return YearParser2;
}(Parser);
function _typeof7(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof7 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof7 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof7(obj);
}
function _classCallCheck5(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties5(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass5(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties5(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties5(Constructor, staticProps);
  return Constructor;
}
function _inherits4(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf4(subClass, superClass);
}
function _setPrototypeOf4(o3, p4) {
  _setPrototypeOf4 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf4(o3, p4);
}
function _createSuper4(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct4();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf4(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf4(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn4(this, result);
  };
}
function _possibleConstructorReturn4(self2, call) {
  if (call && (_typeof7(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized4(self2);
}
function _assertThisInitialized4(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct4() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf4(o3) {
  _getPrototypeOf4 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf4(o3);
}
function _defineProperty4(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var LocalWeekYearParser = /* @__PURE__ */ function(_Parser) {
  _inherits4(LocalWeekYearParser2, _Parser);
  var _super = _createSuper4(LocalWeekYearParser2);
  function LocalWeekYearParser2() {
    var _this;
    _classCallCheck5(this, LocalWeekYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty4(_assertThisInitialized4(_this), "priority", 130);
    _defineProperty4(_assertThisInitialized4(_this), "incompatibleTokens", ["y", "R", "u", "Q", "q", "M", "L", "I", "d", "D", "i", "t", "T"]);
    return _this;
  }
  _createClass5(LocalWeekYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      var valueCallback92 = function valueCallback102(year) {
        return {
          year,
          isTwoDigitYear: token === "YY"
        };
      };
      switch (token) {
        case "Y":
          return mapValue(parseNDigits(4, dateString), valueCallback92);
        case "Yo":
          return mapValue(match52.ordinalNumber(dateString, {
            unit: "year"
          }), valueCallback92);
        default:
          return mapValue(parseNDigits(token.length, dateString), valueCallback92);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value.isTwoDigitYear || value.year > 0;
    }
  }, {
    key: "set",
    value: function set(date, flags, value, options) {
      var currentYear = getUTCWeekYear(date, options);
      if (value.isTwoDigitYear) {
        var normalizedTwoDigitYear = normalizeTwoDigitYear(value.year, currentYear);
        date.setUTCFullYear(normalizedTwoDigitYear, 0, options.firstWeekContainsDate);
        date.setUTCHours(0, 0, 0, 0);
        return startOfUTCWeek(date, options);
      }
      var year = !("era" in flags) || flags.era === 1 ? value.year : 1 - value.year;
      date.setUTCFullYear(year, 0, options.firstWeekContainsDate);
      date.setUTCHours(0, 0, 0, 0);
      return startOfUTCWeek(date, options);
    }
  }]);
  return LocalWeekYearParser2;
}(Parser);
function _typeof8(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof8 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof8 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof8(obj);
}
function _classCallCheck6(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties6(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass6(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties6(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties6(Constructor, staticProps);
  return Constructor;
}
function _inherits5(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf5(subClass, superClass);
}
function _setPrototypeOf5(o3, p4) {
  _setPrototypeOf5 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf5(o3, p4);
}
function _createSuper5(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct5();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf5(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf5(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn5(this, result);
  };
}
function _possibleConstructorReturn5(self2, call) {
  if (call && (_typeof8(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized5(self2);
}
function _assertThisInitialized5(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct5() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf5(o3) {
  _getPrototypeOf5 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf5(o3);
}
function _defineProperty5(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var ISOWeekYearParser = /* @__PURE__ */ function(_Parser) {
  _inherits5(ISOWeekYearParser2, _Parser);
  var _super = _createSuper5(ISOWeekYearParser2);
  function ISOWeekYearParser2() {
    var _this;
    _classCallCheck6(this, ISOWeekYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty5(_assertThisInitialized5(_this), "priority", 130);
    _defineProperty5(_assertThisInitialized5(_this), "incompatibleTokens", ["G", "y", "Y", "u", "Q", "q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass6(ISOWeekYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      if (token === "R") {
        return parseNDigitsSigned(4, dateString);
      }
      return parseNDigitsSigned(token.length, dateString);
    }
  }, {
    key: "set",
    value: function set(_date, _flags, value) {
      var firstWeekOfYear = /* @__PURE__ */ new Date(0);
      firstWeekOfYear.setUTCFullYear(value, 0, 4);
      firstWeekOfYear.setUTCHours(0, 0, 0, 0);
      return startOfUTCISOWeek(firstWeekOfYear);
    }
  }]);
  return ISOWeekYearParser2;
}(Parser);
function _typeof9(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof9 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof9 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof9(obj);
}
function _classCallCheck7(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties7(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass7(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties7(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties7(Constructor, staticProps);
  return Constructor;
}
function _inherits6(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf6(subClass, superClass);
}
function _setPrototypeOf6(o3, p4) {
  _setPrototypeOf6 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf6(o3, p4);
}
function _createSuper6(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct6();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf6(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf6(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn6(this, result);
  };
}
function _possibleConstructorReturn6(self2, call) {
  if (call && (_typeof9(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized6(self2);
}
function _assertThisInitialized6(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct6() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf6(o3) {
  _getPrototypeOf6 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf6(o3);
}
function _defineProperty6(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var ExtendedYearParser = /* @__PURE__ */ function(_Parser) {
  _inherits6(ExtendedYearParser2, _Parser);
  var _super = _createSuper6(ExtendedYearParser2);
  function ExtendedYearParser2() {
    var _this;
    _classCallCheck7(this, ExtendedYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty6(_assertThisInitialized6(_this), "priority", 130);
    _defineProperty6(_assertThisInitialized6(_this), "incompatibleTokens", ["G", "y", "Y", "R", "w", "I", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass7(ExtendedYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      if (token === "u") {
        return parseNDigitsSigned(4, dateString);
      }
      return parseNDigitsSigned(token.length, dateString);
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCFullYear(value, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return ExtendedYearParser2;
}(Parser);
function _typeof10(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof10 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof10 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof10(obj);
}
function _classCallCheck8(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties8(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass8(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties8(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties8(Constructor, staticProps);
  return Constructor;
}
function _inherits7(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf7(subClass, superClass);
}
function _setPrototypeOf7(o3, p4) {
  _setPrototypeOf7 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf7(o3, p4);
}
function _createSuper7(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct7();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf7(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf7(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn7(this, result);
  };
}
function _possibleConstructorReturn7(self2, call) {
  if (call && (_typeof10(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized7(self2);
}
function _assertThisInitialized7(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct7() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf7(o3) {
  _getPrototypeOf7 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf7(o3);
}
function _defineProperty7(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var QuarterParser = /* @__PURE__ */ function(_Parser) {
  _inherits7(QuarterParser2, _Parser);
  var _super = _createSuper7(QuarterParser2);
  function QuarterParser2() {
    var _this;
    _classCallCheck8(this, QuarterParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty7(_assertThisInitialized7(_this), "priority", 120);
    _defineProperty7(_assertThisInitialized7(_this), "incompatibleTokens", ["Y", "R", "q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass8(QuarterParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "Q":
        case "QQ":
          return parseNDigits(token.length, dateString);
        case "Qo":
          return match52.ordinalNumber(dateString, {
            unit: "quarter"
          });
        case "QQQ":
          return match52.quarter(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "QQQQQ":
          return match52.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "QQQQ":
        default:
          return match52.quarter(dateString, {
            width: "wide",
            context: "formatting"
          }) || match52.quarter(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 4;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCMonth((value - 1) * 3, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return QuarterParser2;
}(Parser);
function _typeof11(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof11 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof11 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof11(obj);
}
function _classCallCheck9(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties9(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass9(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties9(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties9(Constructor, staticProps);
  return Constructor;
}
function _inherits8(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf8(subClass, superClass);
}
function _setPrototypeOf8(o3, p4) {
  _setPrototypeOf8 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf8(o3, p4);
}
function _createSuper8(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct8();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf8(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf8(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn8(this, result);
  };
}
function _possibleConstructorReturn8(self2, call) {
  if (call && (_typeof11(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized8(self2);
}
function _assertThisInitialized8(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct8() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf8(o3) {
  _getPrototypeOf8 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf8(o3);
}
function _defineProperty8(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var StandAloneQuarterParser = /* @__PURE__ */ function(_Parser) {
  _inherits8(StandAloneQuarterParser2, _Parser);
  var _super = _createSuper8(StandAloneQuarterParser2);
  function StandAloneQuarterParser2() {
    var _this;
    _classCallCheck9(this, StandAloneQuarterParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty8(_assertThisInitialized8(_this), "priority", 120);
    _defineProperty8(_assertThisInitialized8(_this), "incompatibleTokens", ["Y", "R", "Q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass9(StandAloneQuarterParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "q":
        case "qq":
          return parseNDigits(token.length, dateString);
        case "qo":
          return match52.ordinalNumber(dateString, {
            unit: "quarter"
          });
        case "qqq":
          return match52.quarter(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match52.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "qqqqq":
          return match52.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "qqqq":
        default:
          return match52.quarter(dateString, {
            width: "wide",
            context: "standalone"
          }) || match52.quarter(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match52.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 4;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCMonth((value - 1) * 3, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneQuarterParser2;
}(Parser);
function _typeof12(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof12 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof12 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof12(obj);
}
function _classCallCheck10(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties10(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass10(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties10(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties10(Constructor, staticProps);
  return Constructor;
}
function _inherits9(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf9(subClass, superClass);
}
function _setPrototypeOf9(o3, p4) {
  _setPrototypeOf9 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf9(o3, p4);
}
function _createSuper9(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct9();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf9(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf9(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn9(this, result);
  };
}
function _possibleConstructorReturn9(self2, call) {
  if (call && (_typeof12(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized9(self2);
}
function _assertThisInitialized9(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct9() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf9(o3) {
  _getPrototypeOf9 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf9(o3);
}
function _defineProperty9(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var MonthParser = /* @__PURE__ */ function(_Parser) {
  _inherits9(MonthParser2, _Parser);
  var _super = _createSuper9(MonthParser2);
  function MonthParser2() {
    var _this;
    _classCallCheck10(this, MonthParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty9(_assertThisInitialized9(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "L", "w", "I", "D", "i", "e", "c", "t", "T"]);
    _defineProperty9(_assertThisInitialized9(_this), "priority", 110);
    return _this;
  }
  _createClass10(MonthParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      var valueCallback92 = function valueCallback102(value) {
        return value - 1;
      };
      switch (token) {
        case "M":
          return mapValue(parseNumericPattern(numericPatterns.month, dateString), valueCallback92);
        case "MM":
          return mapValue(parseNDigits(2, dateString), valueCallback92);
        case "Mo":
          return mapValue(match52.ordinalNumber(dateString, {
            unit: "month"
          }), valueCallback92);
        case "MMM":
          return match52.month(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "MMMMM":
          return match52.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "MMMM":
        default:
          return match52.month(dateString, {
            width: "wide",
            context: "formatting"
          }) || match52.month(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCMonth(value, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return MonthParser2;
}(Parser);
function _typeof13(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof13 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof13 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof13(obj);
}
function _classCallCheck11(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties11(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass11(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties11(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties11(Constructor, staticProps);
  return Constructor;
}
function _inherits10(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf10(subClass, superClass);
}
function _setPrototypeOf10(o3, p4) {
  _setPrototypeOf10 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf10(o3, p4);
}
function _createSuper10(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct10();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf10(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf10(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn10(this, result);
  };
}
function _possibleConstructorReturn10(self2, call) {
  if (call && (_typeof13(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized10(self2);
}
function _assertThisInitialized10(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct10() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf10(o3) {
  _getPrototypeOf10 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf10(o3);
}
function _defineProperty10(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var StandAloneMonthParser = /* @__PURE__ */ function(_Parser) {
  _inherits10(StandAloneMonthParser2, _Parser);
  var _super = _createSuper10(StandAloneMonthParser2);
  function StandAloneMonthParser2() {
    var _this;
    _classCallCheck11(this, StandAloneMonthParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty10(_assertThisInitialized10(_this), "priority", 110);
    _defineProperty10(_assertThisInitialized10(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "M", "w", "I", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass11(StandAloneMonthParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      var valueCallback92 = function valueCallback102(value) {
        return value - 1;
      };
      switch (token) {
        case "L":
          return mapValue(parseNumericPattern(numericPatterns.month, dateString), valueCallback92);
        case "LL":
          return mapValue(parseNDigits(2, dateString), valueCallback92);
        case "Lo":
          return mapValue(match52.ordinalNumber(dateString, {
            unit: "month"
          }), valueCallback92);
        case "LLL":
          return match52.month(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match52.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "LLLLL":
          return match52.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "LLLL":
        default:
          return match52.month(dateString, {
            width: "wide",
            context: "standalone"
          }) || match52.month(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match52.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCMonth(value, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneMonthParser2;
}(Parser);
function setUTCWeek(dirtyDate, dirtyWeek, options) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var week = toInteger(dirtyWeek);
  var diff = getUTCWeek(date, options) - week;
  date.setUTCDate(date.getUTCDate() - diff * 7);
  return date;
}
function _typeof14(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof14 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof14 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof14(obj);
}
function _classCallCheck12(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties12(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass12(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties12(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties12(Constructor, staticProps);
  return Constructor;
}
function _inherits11(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf11(subClass, superClass);
}
function _setPrototypeOf11(o3, p4) {
  _setPrototypeOf11 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf11(o3, p4);
}
function _createSuper11(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct11();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf11(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf11(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn11(this, result);
  };
}
function _possibleConstructorReturn11(self2, call) {
  if (call && (_typeof14(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized11(self2);
}
function _assertThisInitialized11(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct11() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf11(o3) {
  _getPrototypeOf11 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf11(o3);
}
function _defineProperty11(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var LocalWeekParser = /* @__PURE__ */ function(_Parser) {
  _inherits11(LocalWeekParser2, _Parser);
  var _super = _createSuper11(LocalWeekParser2);
  function LocalWeekParser2() {
    var _this;
    _classCallCheck12(this, LocalWeekParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty11(_assertThisInitialized11(_this), "priority", 100);
    _defineProperty11(_assertThisInitialized11(_this), "incompatibleTokens", ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "i", "t", "T"]);
    return _this;
  }
  _createClass12(LocalWeekParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "w":
          return parseNumericPattern(numericPatterns.week, dateString);
        case "wo":
          return match52.ordinalNumber(dateString, {
            unit: "week"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 53;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value, options) {
      return startOfUTCWeek(setUTCWeek(date, value, options), options);
    }
  }]);
  return LocalWeekParser2;
}(Parser);
function setUTCISOWeek(dirtyDate, dirtyISOWeek) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var isoWeek = toInteger(dirtyISOWeek);
  var diff = getUTCISOWeek(date) - isoWeek;
  date.setUTCDate(date.getUTCDate() - diff * 7);
  return date;
}
function _typeof15(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof15 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof15 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof15(obj);
}
function _classCallCheck13(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties13(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass13(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties13(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties13(Constructor, staticProps);
  return Constructor;
}
function _inherits12(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf12(subClass, superClass);
}
function _setPrototypeOf12(o3, p4) {
  _setPrototypeOf12 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf12(o3, p4);
}
function _createSuper12(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct12();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf12(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf12(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn12(this, result);
  };
}
function _possibleConstructorReturn12(self2, call) {
  if (call && (_typeof15(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized12(self2);
}
function _assertThisInitialized12(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct12() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf12(o3) {
  _getPrototypeOf12 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf12(o3);
}
function _defineProperty12(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var ISOWeekParser = /* @__PURE__ */ function(_Parser) {
  _inherits12(ISOWeekParser2, _Parser);
  var _super = _createSuper12(ISOWeekParser2);
  function ISOWeekParser2() {
    var _this;
    _classCallCheck13(this, ISOWeekParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty12(_assertThisInitialized12(_this), "priority", 100);
    _defineProperty12(_assertThisInitialized12(_this), "incompatibleTokens", ["y", "Y", "u", "q", "Q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass13(ISOWeekParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "I":
          return parseNumericPattern(numericPatterns.week, dateString);
        case "Io":
          return match52.ordinalNumber(dateString, {
            unit: "week"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 53;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      return startOfUTCISOWeek(setUTCISOWeek(date, value));
    }
  }]);
  return ISOWeekParser2;
}(Parser);
function _typeof16(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof16 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof16 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof16(obj);
}
function _classCallCheck14(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties14(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass14(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties14(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties14(Constructor, staticProps);
  return Constructor;
}
function _inherits13(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf13(subClass, superClass);
}
function _setPrototypeOf13(o3, p4) {
  _setPrototypeOf13 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf13(o3, p4);
}
function _createSuper13(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct13();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf13(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf13(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn13(this, result);
  };
}
function _possibleConstructorReturn13(self2, call) {
  if (call && (_typeof16(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized13(self2);
}
function _assertThisInitialized13(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct13() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf13(o3) {
  _getPrototypeOf13 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf13(o3);
}
function _defineProperty13(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var DAYS_IN_MONTH = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
var DAYS_IN_MONTH_LEAP_YEAR = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
var DateParser = /* @__PURE__ */ function(_Parser) {
  _inherits13(DateParser2, _Parser);
  var _super = _createSuper13(DateParser2);
  function DateParser2() {
    var _this;
    _classCallCheck14(this, DateParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty13(_assertThisInitialized13(_this), "priority", 90);
    _defineProperty13(_assertThisInitialized13(_this), "subPriority", 1);
    _defineProperty13(_assertThisInitialized13(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "w", "I", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass14(DateParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "d":
          return parseNumericPattern(numericPatterns.date, dateString);
        case "do":
          return match52.ordinalNumber(dateString, {
            unit: "date"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(date, value) {
      var year = date.getUTCFullYear();
      var isLeapYear = isLeapYearIndex(year);
      var month = date.getUTCMonth();
      if (isLeapYear) {
        return value >= 1 && value <= DAYS_IN_MONTH_LEAP_YEAR[month];
      } else {
        return value >= 1 && value <= DAYS_IN_MONTH[month];
      }
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCDate(value);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return DateParser2;
}(Parser);
function _typeof17(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof17 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof17 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof17(obj);
}
function _classCallCheck15(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties15(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass15(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties15(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties15(Constructor, staticProps);
  return Constructor;
}
function _inherits14(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf14(subClass, superClass);
}
function _setPrototypeOf14(o3, p4) {
  _setPrototypeOf14 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf14(o3, p4);
}
function _createSuper14(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct14();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf14(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf14(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn14(this, result);
  };
}
function _possibleConstructorReturn14(self2, call) {
  if (call && (_typeof17(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized14(self2);
}
function _assertThisInitialized14(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct14() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf14(o3) {
  _getPrototypeOf14 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf14(o3);
}
function _defineProperty14(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var DayOfYearParser = /* @__PURE__ */ function(_Parser) {
  _inherits14(DayOfYearParser2, _Parser);
  var _super = _createSuper14(DayOfYearParser2);
  function DayOfYearParser2() {
    var _this;
    _classCallCheck15(this, DayOfYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty14(_assertThisInitialized14(_this), "priority", 90);
    _defineProperty14(_assertThisInitialized14(_this), "subpriority", 1);
    _defineProperty14(_assertThisInitialized14(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "M", "L", "w", "I", "d", "E", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass15(DayOfYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "D":
        case "DD":
          return parseNumericPattern(numericPatterns.dayOfYear, dateString);
        case "Do":
          return match52.ordinalNumber(dateString, {
            unit: "date"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(date, value) {
      var year = date.getUTCFullYear();
      var isLeapYear = isLeapYearIndex(year);
      if (isLeapYear) {
        return value >= 1 && value <= 366;
      } else {
        return value >= 1 && value <= 365;
      }
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCMonth(0, value);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return DayOfYearParser2;
}(Parser);
function setUTCDay(dirtyDate, dirtyDay, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(2, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = toInteger(dirtyDay);
  var currentDay = date.getUTCDay();
  var remainder = day % 7;
  var dayIndex = (remainder + 7) % 7;
  var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
  date.setUTCDate(date.getUTCDate() + diff);
  return date;
}
function _typeof18(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof18 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof18 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof18(obj);
}
function _classCallCheck16(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties16(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass16(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties16(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties16(Constructor, staticProps);
  return Constructor;
}
function _inherits15(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf15(subClass, superClass);
}
function _setPrototypeOf15(o3, p4) {
  _setPrototypeOf15 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf15(o3, p4);
}
function _createSuper15(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct15();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf15(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf15(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn15(this, result);
  };
}
function _possibleConstructorReturn15(self2, call) {
  if (call && (_typeof18(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized15(self2);
}
function _assertThisInitialized15(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct15() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf15(o3) {
  _getPrototypeOf15 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf15(o3);
}
function _defineProperty15(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var DayParser = /* @__PURE__ */ function(_Parser) {
  _inherits15(DayParser2, _Parser);
  var _super = _createSuper15(DayParser2);
  function DayParser2() {
    var _this;
    _classCallCheck16(this, DayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty15(_assertThisInitialized15(_this), "priority", 90);
    _defineProperty15(_assertThisInitialized15(_this), "incompatibleTokens", ["D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass16(DayParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "E":
        case "EE":
        case "EEE":
          return match52.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEEE":
          return match52.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEEEE":
          return match52.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEE":
        default:
          return match52.day(dateString, {
            width: "wide",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 6;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value, options) {
      date = setUTCDay(date, value, options);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return DayParser2;
}(Parser);
function _typeof19(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof19 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof19 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof19(obj);
}
function _classCallCheck17(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties17(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass17(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties17(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties17(Constructor, staticProps);
  return Constructor;
}
function _inherits16(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf16(subClass, superClass);
}
function _setPrototypeOf16(o3, p4) {
  _setPrototypeOf16 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf16(o3, p4);
}
function _createSuper16(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct16();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf16(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf16(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn16(this, result);
  };
}
function _possibleConstructorReturn16(self2, call) {
  if (call && (_typeof19(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized16(self2);
}
function _assertThisInitialized16(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct16() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf16(o3) {
  _getPrototypeOf16 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf16(o3);
}
function _defineProperty16(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var LocalDayParser = /* @__PURE__ */ function(_Parser) {
  _inherits16(LocalDayParser2, _Parser);
  var _super = _createSuper16(LocalDayParser2);
  function LocalDayParser2() {
    var _this;
    _classCallCheck17(this, LocalDayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty16(_assertThisInitialized16(_this), "priority", 90);
    _defineProperty16(_assertThisInitialized16(_this), "incompatibleTokens", ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "E", "i", "c", "t", "T"]);
    return _this;
  }
  _createClass17(LocalDayParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52, options) {
      var valueCallback92 = function valueCallback102(value) {
        var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
        return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
      };
      switch (token) {
        case "e":
        case "ee":
          return mapValue(parseNDigits(token.length, dateString), valueCallback92);
        case "eo":
          return mapValue(match52.ordinalNumber(dateString, {
            unit: "day"
          }), valueCallback92);
        case "eee":
          return match52.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "eeeee":
          return match52.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "eeeeee":
          return match52.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "eeee":
        default:
          return match52.day(dateString, {
            width: "wide",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 6;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value, options) {
      date = setUTCDay(date, value, options);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return LocalDayParser2;
}(Parser);
function _typeof20(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof20 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof20 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof20(obj);
}
function _classCallCheck18(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties18(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass18(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties18(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties18(Constructor, staticProps);
  return Constructor;
}
function _inherits17(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf17(subClass, superClass);
}
function _setPrototypeOf17(o3, p4) {
  _setPrototypeOf17 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf17(o3, p4);
}
function _createSuper17(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct17();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf17(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf17(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn17(this, result);
  };
}
function _possibleConstructorReturn17(self2, call) {
  if (call && (_typeof20(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized17(self2);
}
function _assertThisInitialized17(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct17() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf17(o3) {
  _getPrototypeOf17 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf17(o3);
}
function _defineProperty17(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var StandAloneLocalDayParser = /* @__PURE__ */ function(_Parser) {
  _inherits17(StandAloneLocalDayParser2, _Parser);
  var _super = _createSuper17(StandAloneLocalDayParser2);
  function StandAloneLocalDayParser2() {
    var _this;
    _classCallCheck18(this, StandAloneLocalDayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty17(_assertThisInitialized17(_this), "priority", 90);
    _defineProperty17(_assertThisInitialized17(_this), "incompatibleTokens", ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "E", "i", "e", "t", "T"]);
    return _this;
  }
  _createClass18(StandAloneLocalDayParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52, options) {
      var valueCallback92 = function valueCallback102(value) {
        var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
        return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
      };
      switch (token) {
        case "c":
        case "cc":
          return mapValue(parseNDigits(token.length, dateString), valueCallback92);
        case "co":
          return mapValue(match52.ordinalNumber(dateString, {
            unit: "day"
          }), valueCallback92);
        case "ccc":
          return match52.day(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match52.day(dateString, {
            width: "short",
            context: "standalone"
          }) || match52.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "ccccc":
          return match52.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "cccccc":
          return match52.day(dateString, {
            width: "short",
            context: "standalone"
          }) || match52.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "cccc":
        default:
          return match52.day(dateString, {
            width: "wide",
            context: "standalone"
          }) || match52.day(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match52.day(dateString, {
            width: "short",
            context: "standalone"
          }) || match52.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 6;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value, options) {
      date = setUTCDay(date, value, options);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneLocalDayParser2;
}(Parser);
function setUTCISODay(dirtyDate, dirtyDay) {
  requiredArgs(2, arguments);
  var day = toInteger(dirtyDay);
  if (day % 7 === 0) {
    day = day - 7;
  }
  var weekStartsOn = 1;
  var date = toDate(dirtyDate);
  var currentDay = date.getUTCDay();
  var remainder = day % 7;
  var dayIndex = (remainder + 7) % 7;
  var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
  date.setUTCDate(date.getUTCDate() + diff);
  return date;
}
function _typeof21(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof21 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof21 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof21(obj);
}
function _classCallCheck19(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties19(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass19(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties19(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties19(Constructor, staticProps);
  return Constructor;
}
function _inherits18(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf18(subClass, superClass);
}
function _setPrototypeOf18(o3, p4) {
  _setPrototypeOf18 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf18(o3, p4);
}
function _createSuper18(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct18();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf18(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf18(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn18(this, result);
  };
}
function _possibleConstructorReturn18(self2, call) {
  if (call && (_typeof21(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized18(self2);
}
function _assertThisInitialized18(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct18() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf18(o3) {
  _getPrototypeOf18 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf18(o3);
}
function _defineProperty18(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var ISODayParser = /* @__PURE__ */ function(_Parser) {
  _inherits18(ISODayParser2, _Parser);
  var _super = _createSuper18(ISODayParser2);
  function ISODayParser2() {
    var _this;
    _classCallCheck19(this, ISODayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty18(_assertThisInitialized18(_this), "priority", 90);
    _defineProperty18(_assertThisInitialized18(_this), "incompatibleTokens", ["y", "Y", "u", "q", "Q", "M", "L", "w", "d", "D", "E", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass19(ISODayParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      var valueCallback92 = function valueCallback102(value) {
        if (value === 0) {
          return 7;
        }
        return value;
      };
      switch (token) {
        case "i":
        case "ii":
          return parseNDigits(token.length, dateString);
        case "io":
          return match52.ordinalNumber(dateString, {
            unit: "day"
          });
        case "iii":
          return mapValue(match52.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback92);
        case "iiiii":
          return mapValue(match52.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback92);
        case "iiiiii":
          return mapValue(match52.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback92);
        case "iiii":
        default:
          return mapValue(match52.day(dateString, {
            width: "wide",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match52.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback92);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 7;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date = setUTCISODay(date, value);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return ISODayParser2;
}(Parser);
function _typeof22(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof22 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof22 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof22(obj);
}
function _classCallCheck20(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties20(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass20(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties20(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties20(Constructor, staticProps);
  return Constructor;
}
function _inherits19(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf19(subClass, superClass);
}
function _setPrototypeOf19(o3, p4) {
  _setPrototypeOf19 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf19(o3, p4);
}
function _createSuper19(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct19();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf19(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf19(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn19(this, result);
  };
}
function _possibleConstructorReturn19(self2, call) {
  if (call && (_typeof22(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized19(self2);
}
function _assertThisInitialized19(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct19() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf19(o3) {
  _getPrototypeOf19 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf19(o3);
}
function _defineProperty19(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var AMPMParser = /* @__PURE__ */ function(_Parser) {
  _inherits19(AMPMParser2, _Parser);
  var _super = _createSuper19(AMPMParser2);
  function AMPMParser2() {
    var _this;
    _classCallCheck20(this, AMPMParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty19(_assertThisInitialized19(_this), "priority", 80);
    _defineProperty19(_assertThisInitialized19(_this), "incompatibleTokens", ["b", "B", "H", "k", "t", "T"]);
    return _this;
  }
  _createClass20(AMPMParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "a":
        case "aa":
        case "aaa":
          return match52.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "aaaaa":
          return match52.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "aaaa":
        default:
          return match52.dayPeriod(dateString, {
            width: "wide",
            context: "formatting"
          }) || match52.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
      return date;
    }
  }]);
  return AMPMParser2;
}(Parser);
function _typeof23(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof23 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof23 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof23(obj);
}
function _classCallCheck21(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties21(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass21(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties21(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties21(Constructor, staticProps);
  return Constructor;
}
function _inherits20(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf20(subClass, superClass);
}
function _setPrototypeOf20(o3, p4) {
  _setPrototypeOf20 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf20(o3, p4);
}
function _createSuper20(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct20();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf20(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf20(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn20(this, result);
  };
}
function _possibleConstructorReturn20(self2, call) {
  if (call && (_typeof23(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized20(self2);
}
function _assertThisInitialized20(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct20() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf20(o3) {
  _getPrototypeOf20 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf20(o3);
}
function _defineProperty20(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var AMPMMidnightParser = /* @__PURE__ */ function(_Parser) {
  _inherits20(AMPMMidnightParser2, _Parser);
  var _super = _createSuper20(AMPMMidnightParser2);
  function AMPMMidnightParser2() {
    var _this;
    _classCallCheck21(this, AMPMMidnightParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty20(_assertThisInitialized20(_this), "priority", 80);
    _defineProperty20(_assertThisInitialized20(_this), "incompatibleTokens", ["a", "B", "H", "k", "t", "T"]);
    return _this;
  }
  _createClass21(AMPMMidnightParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "b":
        case "bb":
        case "bbb":
          return match52.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "bbbbb":
          return match52.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "bbbb":
        default:
          return match52.dayPeriod(dateString, {
            width: "wide",
            context: "formatting"
          }) || match52.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
      return date;
    }
  }]);
  return AMPMMidnightParser2;
}(Parser);
function _typeof24(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof24 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof24 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof24(obj);
}
function _classCallCheck22(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties22(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass22(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties22(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties22(Constructor, staticProps);
  return Constructor;
}
function _inherits21(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf21(subClass, superClass);
}
function _setPrototypeOf21(o3, p4) {
  _setPrototypeOf21 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf21(o3, p4);
}
function _createSuper21(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct21();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf21(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf21(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn21(this, result);
  };
}
function _possibleConstructorReturn21(self2, call) {
  if (call && (_typeof24(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized21(self2);
}
function _assertThisInitialized21(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct21() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf21(o3) {
  _getPrototypeOf21 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf21(o3);
}
function _defineProperty21(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var DayPeriodParser = /* @__PURE__ */ function(_Parser) {
  _inherits21(DayPeriodParser2, _Parser);
  var _super = _createSuper21(DayPeriodParser2);
  function DayPeriodParser2() {
    var _this;
    _classCallCheck22(this, DayPeriodParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty21(_assertThisInitialized21(_this), "priority", 80);
    _defineProperty21(_assertThisInitialized21(_this), "incompatibleTokens", ["a", "b", "t", "T"]);
    return _this;
  }
  _createClass22(DayPeriodParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "B":
        case "BB":
        case "BBB":
          return match52.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "BBBBB":
          return match52.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "BBBB":
        default:
          return match52.dayPeriod(dateString, {
            width: "wide",
            context: "formatting"
          }) || match52.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match52.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
      return date;
    }
  }]);
  return DayPeriodParser2;
}(Parser);
function _typeof25(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof25 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof25 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof25(obj);
}
function _classCallCheck23(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties23(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass23(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties23(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties23(Constructor, staticProps);
  return Constructor;
}
function _inherits22(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf22(subClass, superClass);
}
function _setPrototypeOf22(o3, p4) {
  _setPrototypeOf22 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf22(o3, p4);
}
function _createSuper22(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct22();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf22(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf22(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn22(this, result);
  };
}
function _possibleConstructorReturn22(self2, call) {
  if (call && (_typeof25(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized22(self2);
}
function _assertThisInitialized22(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct22() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf22(o3) {
  _getPrototypeOf22 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf22(o3);
}
function _defineProperty22(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var Hour1to12Parser = /* @__PURE__ */ function(_Parser) {
  _inherits22(Hour1to12Parser2, _Parser);
  var _super = _createSuper22(Hour1to12Parser2);
  function Hour1to12Parser2() {
    var _this;
    _classCallCheck23(this, Hour1to12Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty22(_assertThisInitialized22(_this), "priority", 70);
    _defineProperty22(_assertThisInitialized22(_this), "incompatibleTokens", ["H", "K", "k", "t", "T"]);
    return _this;
  }
  _createClass23(Hour1to12Parser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "h":
          return parseNumericPattern(numericPatterns.hour12h, dateString);
        case "ho":
          return match52.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 12;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      var isPM = date.getUTCHours() >= 12;
      if (isPM && value < 12) {
        date.setUTCHours(value + 12, 0, 0, 0);
      } else if (!isPM && value === 12) {
        date.setUTCHours(0, 0, 0, 0);
      } else {
        date.setUTCHours(value, 0, 0, 0);
      }
      return date;
    }
  }]);
  return Hour1to12Parser2;
}(Parser);
function _typeof26(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof26 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof26 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof26(obj);
}
function _classCallCheck24(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties24(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass24(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties24(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties24(Constructor, staticProps);
  return Constructor;
}
function _inherits23(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf23(subClass, superClass);
}
function _setPrototypeOf23(o3, p4) {
  _setPrototypeOf23 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf23(o3, p4);
}
function _createSuper23(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct23();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf23(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf23(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn23(this, result);
  };
}
function _possibleConstructorReturn23(self2, call) {
  if (call && (_typeof26(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized23(self2);
}
function _assertThisInitialized23(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct23() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf23(o3) {
  _getPrototypeOf23 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf23(o3);
}
function _defineProperty23(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var Hour0to23Parser = /* @__PURE__ */ function(_Parser) {
  _inherits23(Hour0to23Parser2, _Parser);
  var _super = _createSuper23(Hour0to23Parser2);
  function Hour0to23Parser2() {
    var _this;
    _classCallCheck24(this, Hour0to23Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty23(_assertThisInitialized23(_this), "priority", 70);
    _defineProperty23(_assertThisInitialized23(_this), "incompatibleTokens", ["a", "b", "h", "K", "k", "t", "T"]);
    return _this;
  }
  _createClass24(Hour0to23Parser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "H":
          return parseNumericPattern(numericPatterns.hour23h, dateString);
        case "Ho":
          return match52.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 23;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCHours(value, 0, 0, 0);
      return date;
    }
  }]);
  return Hour0to23Parser2;
}(Parser);
function _typeof27(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof27 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof27 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof27(obj);
}
function _classCallCheck25(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties25(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass25(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties25(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties25(Constructor, staticProps);
  return Constructor;
}
function _inherits24(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf24(subClass, superClass);
}
function _setPrototypeOf24(o3, p4) {
  _setPrototypeOf24 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf24(o3, p4);
}
function _createSuper24(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct24();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf24(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf24(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn24(this, result);
  };
}
function _possibleConstructorReturn24(self2, call) {
  if (call && (_typeof27(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized24(self2);
}
function _assertThisInitialized24(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct24() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf24(o3) {
  _getPrototypeOf24 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf24(o3);
}
function _defineProperty24(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var Hour0To11Parser = /* @__PURE__ */ function(_Parser) {
  _inherits24(Hour0To11Parser2, _Parser);
  var _super = _createSuper24(Hour0To11Parser2);
  function Hour0To11Parser2() {
    var _this;
    _classCallCheck25(this, Hour0To11Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty24(_assertThisInitialized24(_this), "priority", 70);
    _defineProperty24(_assertThisInitialized24(_this), "incompatibleTokens", ["h", "H", "k", "t", "T"]);
    return _this;
  }
  _createClass25(Hour0To11Parser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "K":
          return parseNumericPattern(numericPatterns.hour11h, dateString);
        case "Ko":
          return match52.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      var isPM = date.getUTCHours() >= 12;
      if (isPM && value < 12) {
        date.setUTCHours(value + 12, 0, 0, 0);
      } else {
        date.setUTCHours(value, 0, 0, 0);
      }
      return date;
    }
  }]);
  return Hour0To11Parser2;
}(Parser);
function _typeof28(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof28 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof28 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof28(obj);
}
function _classCallCheck26(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties26(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass26(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties26(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties26(Constructor, staticProps);
  return Constructor;
}
function _inherits25(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf25(subClass, superClass);
}
function _setPrototypeOf25(o3, p4) {
  _setPrototypeOf25 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf25(o3, p4);
}
function _createSuper25(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct25();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf25(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf25(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn25(this, result);
  };
}
function _possibleConstructorReturn25(self2, call) {
  if (call && (_typeof28(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized25(self2);
}
function _assertThisInitialized25(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct25() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf25(o3) {
  _getPrototypeOf25 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf25(o3);
}
function _defineProperty25(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var Hour1To24Parser = /* @__PURE__ */ function(_Parser) {
  _inherits25(Hour1To24Parser2, _Parser);
  var _super = _createSuper25(Hour1To24Parser2);
  function Hour1To24Parser2() {
    var _this;
    _classCallCheck26(this, Hour1To24Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty25(_assertThisInitialized25(_this), "priority", 70);
    _defineProperty25(_assertThisInitialized25(_this), "incompatibleTokens", ["a", "b", "h", "H", "K", "t", "T"]);
    return _this;
  }
  _createClass26(Hour1To24Parser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "k":
          return parseNumericPattern(numericPatterns.hour24h, dateString);
        case "ko":
          return match52.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 24;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      var hours = value <= 24 ? value % 24 : value;
      date.setUTCHours(hours, 0, 0, 0);
      return date;
    }
  }]);
  return Hour1To24Parser2;
}(Parser);
function _typeof29(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof29 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof29 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof29(obj);
}
function _classCallCheck27(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties27(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass27(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties27(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties27(Constructor, staticProps);
  return Constructor;
}
function _inherits26(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf26(subClass, superClass);
}
function _setPrototypeOf26(o3, p4) {
  _setPrototypeOf26 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf26(o3, p4);
}
function _createSuper26(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct26();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf26(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf26(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn26(this, result);
  };
}
function _possibleConstructorReturn26(self2, call) {
  if (call && (_typeof29(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized26(self2);
}
function _assertThisInitialized26(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct26() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf26(o3) {
  _getPrototypeOf26 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf26(o3);
}
function _defineProperty26(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var MinuteParser = /* @__PURE__ */ function(_Parser) {
  _inherits26(MinuteParser2, _Parser);
  var _super = _createSuper26(MinuteParser2);
  function MinuteParser2() {
    var _this;
    _classCallCheck27(this, MinuteParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty26(_assertThisInitialized26(_this), "priority", 60);
    _defineProperty26(_assertThisInitialized26(_this), "incompatibleTokens", ["t", "T"]);
    return _this;
  }
  _createClass27(MinuteParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "m":
          return parseNumericPattern(numericPatterns.minute, dateString);
        case "mo":
          return match52.ordinalNumber(dateString, {
            unit: "minute"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 59;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCMinutes(value, 0, 0);
      return date;
    }
  }]);
  return MinuteParser2;
}(Parser);
function _typeof30(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof30 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof30 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof30(obj);
}
function _classCallCheck28(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties28(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass28(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties28(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties28(Constructor, staticProps);
  return Constructor;
}
function _inherits27(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf27(subClass, superClass);
}
function _setPrototypeOf27(o3, p4) {
  _setPrototypeOf27 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf27(o3, p4);
}
function _createSuper27(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct27();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf27(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf27(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn27(this, result);
  };
}
function _possibleConstructorReturn27(self2, call) {
  if (call && (_typeof30(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized27(self2);
}
function _assertThisInitialized27(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct27() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf27(o3) {
  _getPrototypeOf27 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf27(o3);
}
function _defineProperty27(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var SecondParser = /* @__PURE__ */ function(_Parser) {
  _inherits27(SecondParser2, _Parser);
  var _super = _createSuper27(SecondParser2);
  function SecondParser2() {
    var _this;
    _classCallCheck28(this, SecondParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty27(_assertThisInitialized27(_this), "priority", 50);
    _defineProperty27(_assertThisInitialized27(_this), "incompatibleTokens", ["t", "T"]);
    return _this;
  }
  _createClass28(SecondParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match52) {
      switch (token) {
        case "s":
          return parseNumericPattern(numericPatterns.second, dateString);
        case "so":
          return match52.ordinalNumber(dateString, {
            unit: "second"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 59;
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCSeconds(value, 0);
      return date;
    }
  }]);
  return SecondParser2;
}(Parser);
function _typeof31(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof31 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof31 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof31(obj);
}
function _classCallCheck29(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties29(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass29(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties29(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties29(Constructor, staticProps);
  return Constructor;
}
function _inherits28(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf28(subClass, superClass);
}
function _setPrototypeOf28(o3, p4) {
  _setPrototypeOf28 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf28(o3, p4);
}
function _createSuper28(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct28();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf28(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf28(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn28(this, result);
  };
}
function _possibleConstructorReturn28(self2, call) {
  if (call && (_typeof31(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized28(self2);
}
function _assertThisInitialized28(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct28() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf28(o3) {
  _getPrototypeOf28 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf28(o3);
}
function _defineProperty28(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var FractionOfSecondParser = /* @__PURE__ */ function(_Parser) {
  _inherits28(FractionOfSecondParser2, _Parser);
  var _super = _createSuper28(FractionOfSecondParser2);
  function FractionOfSecondParser2() {
    var _this;
    _classCallCheck29(this, FractionOfSecondParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty28(_assertThisInitialized28(_this), "priority", 30);
    _defineProperty28(_assertThisInitialized28(_this), "incompatibleTokens", ["t", "T"]);
    return _this;
  }
  _createClass29(FractionOfSecondParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      var valueCallback92 = function valueCallback102(value) {
        return Math.floor(value * Math.pow(10, -token.length + 3));
      };
      return mapValue(parseNDigits(token.length, dateString), valueCallback92);
    }
  }, {
    key: "set",
    value: function set(date, _flags, value) {
      date.setUTCMilliseconds(value);
      return date;
    }
  }]);
  return FractionOfSecondParser2;
}(Parser);
function _typeof32(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof32 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof32 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof32(obj);
}
function _classCallCheck30(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties30(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass30(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties30(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties30(Constructor, staticProps);
  return Constructor;
}
function _inherits29(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf29(subClass, superClass);
}
function _setPrototypeOf29(o3, p4) {
  _setPrototypeOf29 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf29(o3, p4);
}
function _createSuper29(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct29();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf29(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf29(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn29(this, result);
  };
}
function _possibleConstructorReturn29(self2, call) {
  if (call && (_typeof32(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized29(self2);
}
function _assertThisInitialized29(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct29() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf29(o3) {
  _getPrototypeOf29 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf29(o3);
}
function _defineProperty29(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var ISOTimezoneWithZParser = /* @__PURE__ */ function(_Parser) {
  _inherits29(ISOTimezoneWithZParser2, _Parser);
  var _super = _createSuper29(ISOTimezoneWithZParser2);
  function ISOTimezoneWithZParser2() {
    var _this;
    _classCallCheck30(this, ISOTimezoneWithZParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty29(_assertThisInitialized29(_this), "priority", 10);
    _defineProperty29(_assertThisInitialized29(_this), "incompatibleTokens", ["t", "T", "x"]);
    return _this;
  }
  _createClass30(ISOTimezoneWithZParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      switch (token) {
        case "X":
          return parseTimezonePattern(timezonePatterns.basicOptionalMinutes, dateString);
        case "XX":
          return parseTimezonePattern(timezonePatterns.basic, dateString);
        case "XXXX":
          return parseTimezonePattern(timezonePatterns.basicOptionalSeconds, dateString);
        case "XXXXX":
          return parseTimezonePattern(timezonePatterns.extendedOptionalSeconds, dateString);
        case "XXX":
        default:
          return parseTimezonePattern(timezonePatterns.extended, dateString);
      }
    }
  }, {
    key: "set",
    value: function set(date, flags, value) {
      if (flags.timestampIsSet) {
        return date;
      }
      return new Date(date.getTime() - value);
    }
  }]);
  return ISOTimezoneWithZParser2;
}(Parser);
function _typeof33(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof33 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof33 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof33(obj);
}
function _classCallCheck31(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties31(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass31(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties31(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties31(Constructor, staticProps);
  return Constructor;
}
function _inherits30(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf30(subClass, superClass);
}
function _setPrototypeOf30(o3, p4) {
  _setPrototypeOf30 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf30(o3, p4);
}
function _createSuper30(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct30();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf30(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf30(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn30(this, result);
  };
}
function _possibleConstructorReturn30(self2, call) {
  if (call && (_typeof33(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized30(self2);
}
function _assertThisInitialized30(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct30() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf30(o3) {
  _getPrototypeOf30 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf30(o3);
}
function _defineProperty30(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var ISOTimezoneParser = /* @__PURE__ */ function(_Parser) {
  _inherits30(ISOTimezoneParser2, _Parser);
  var _super = _createSuper30(ISOTimezoneParser2);
  function ISOTimezoneParser2() {
    var _this;
    _classCallCheck31(this, ISOTimezoneParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty30(_assertThisInitialized30(_this), "priority", 10);
    _defineProperty30(_assertThisInitialized30(_this), "incompatibleTokens", ["t", "T", "X"]);
    return _this;
  }
  _createClass31(ISOTimezoneParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      switch (token) {
        case "x":
          return parseTimezonePattern(timezonePatterns.basicOptionalMinutes, dateString);
        case "xx":
          return parseTimezonePattern(timezonePatterns.basic, dateString);
        case "xxxx":
          return parseTimezonePattern(timezonePatterns.basicOptionalSeconds, dateString);
        case "xxxxx":
          return parseTimezonePattern(timezonePatterns.extendedOptionalSeconds, dateString);
        case "xxx":
        default:
          return parseTimezonePattern(timezonePatterns.extended, dateString);
      }
    }
  }, {
    key: "set",
    value: function set(date, flags, value) {
      if (flags.timestampIsSet) {
        return date;
      }
      return new Date(date.getTime() - value);
    }
  }]);
  return ISOTimezoneParser2;
}(Parser);
function _typeof34(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof34 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof34 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof34(obj);
}
function _classCallCheck32(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties32(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass32(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties32(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties32(Constructor, staticProps);
  return Constructor;
}
function _inherits31(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf31(subClass, superClass);
}
function _setPrototypeOf31(o3, p4) {
  _setPrototypeOf31 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf31(o3, p4);
}
function _createSuper31(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct31();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf31(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf31(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn31(this, result);
  };
}
function _possibleConstructorReturn31(self2, call) {
  if (call && (_typeof34(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized31(self2);
}
function _assertThisInitialized31(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct31() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf31(o3) {
  _getPrototypeOf31 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf31(o3);
}
function _defineProperty31(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var TimestampSecondsParser = /* @__PURE__ */ function(_Parser) {
  _inherits31(TimestampSecondsParser2, _Parser);
  var _super = _createSuper31(TimestampSecondsParser2);
  function TimestampSecondsParser2() {
    var _this;
    _classCallCheck32(this, TimestampSecondsParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty31(_assertThisInitialized31(_this), "priority", 40);
    _defineProperty31(_assertThisInitialized31(_this), "incompatibleTokens", "*");
    return _this;
  }
  _createClass32(TimestampSecondsParser2, [{
    key: "parse",
    value: function parse2(dateString) {
      return parseAnyDigitsSigned(dateString);
    }
  }, {
    key: "set",
    value: function set(_date, _flags, value) {
      return [new Date(value * 1e3), {
        timestampIsSet: true
      }];
    }
  }]);
  return TimestampSecondsParser2;
}(Parser);
function _typeof35(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof35 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof35 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof35(obj);
}
function _classCallCheck33(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties33(target, props) {
  for (var i22 = 0; i22 < props.length; i22++) {
    var descriptor = props[i22];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass33(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties33(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties33(Constructor, staticProps);
  return Constructor;
}
function _inherits32(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });
  if (superClass)
    _setPrototypeOf32(subClass, superClass);
}
function _setPrototypeOf32(o3, p4) {
  _setPrototypeOf32 = Object.setPrototypeOf || function _setPrototypeOf33(o22, p22) {
    o22.__proto__ = p22;
    return o22;
  };
  return _setPrototypeOf32(o3, p4);
}
function _createSuper32(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct32();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf32(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf32(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn32(this, result);
  };
}
function _possibleConstructorReturn32(self2, call) {
  if (call && (_typeof35(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized32(self2);
}
function _assertThisInitialized32(self2) {
  if (self2 === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self2;
}
function _isNativeReflectConstruct32() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e22) {
    return false;
  }
}
function _getPrototypeOf32(o3) {
  _getPrototypeOf32 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf33(o22) {
    return o22.__proto__ || Object.getPrototypeOf(o22);
  };
  return _getPrototypeOf32(o3);
}
function _defineProperty32(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, { value, enumerable: true, configurable: true, writable: true });
  } else {
    obj[key] = value;
  }
  return obj;
}
var TimestampMillisecondsParser = /* @__PURE__ */ function(_Parser) {
  _inherits32(TimestampMillisecondsParser2, _Parser);
  var _super = _createSuper32(TimestampMillisecondsParser2);
  function TimestampMillisecondsParser2() {
    var _this;
    _classCallCheck33(this, TimestampMillisecondsParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty32(_assertThisInitialized32(_this), "priority", 20);
    _defineProperty32(_assertThisInitialized32(_this), "incompatibleTokens", "*");
    return _this;
  }
  _createClass33(TimestampMillisecondsParser2, [{
    key: "parse",
    value: function parse2(dateString) {
      return parseAnyDigitsSigned(dateString);
    }
  }, {
    key: "set",
    value: function set(_date, _flags, value) {
      return [new Date(value), {
        timestampIsSet: true
      }];
    }
  }]);
  return TimestampMillisecondsParser2;
}(Parser);
var parsers2 = {
  G: new EraParser(),
  y: new YearParser(),
  Y: new LocalWeekYearParser(),
  R: new ISOWeekYearParser(),
  u: new ExtendedYearParser(),
  Q: new QuarterParser(),
  q: new StandAloneQuarterParser(),
  M: new MonthParser(),
  L: new StandAloneMonthParser(),
  w: new LocalWeekParser(),
  I: new ISOWeekParser(),
  d: new DateParser(),
  D: new DayOfYearParser(),
  E: new DayParser(),
  e: new LocalDayParser(),
  c: new StandAloneLocalDayParser(),
  i: new ISODayParser(),
  a: new AMPMParser(),
  b: new AMPMMidnightParser(),
  B: new DayPeriodParser(),
  h: new Hour1to12Parser(),
  H: new Hour0to23Parser(),
  K: new Hour0To11Parser(),
  k: new Hour1To24Parser(),
  m: new MinuteParser(),
  s: new SecondParser(),
  S: new FractionOfSecondParser(),
  X: new ISOTimezoneWithZParser(),
  x: new ISOTimezoneParser(),
  t: new TimestampSecondsParser(),
  T: new TimestampMillisecondsParser()
};
function _typeof36(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof36 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof36 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof36(obj);
}
function _createForOfIteratorHelper(o3, allowArrayLike) {
  var it;
  if (typeof Symbol === "undefined" || o3[Symbol.iterator] == null) {
    if (Array.isArray(o3) || (it = _unsupportedIterableToArray(o3)) || allowArrayLike && o3 && typeof o3.length === "number") {
      if (it)
        o3 = it;
      var i22 = 0;
      var F3 = function F22() {
      };
      return { s: F3, n: function n2() {
        if (i22 >= o3.length)
          return { done: true };
        return { done: false, value: o3[i22++] };
      }, e: function e22(_e) {
        throw _e;
      }, f: F3 };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var normalCompletion = true, didErr = false, err;
  return { s: function s32() {
    it = o3[Symbol.iterator]();
  }, n: function n2() {
    var step = it.next();
    normalCompletion = step.done;
    return step;
  }, e: function e22(_e2) {
    didErr = true;
    err = _e2;
  }, f: function f3() {
    try {
      if (!normalCompletion && it.return != null)
        it.return();
    } finally {
      if (didErr)
        throw err;
    }
  } };
}
function _unsupportedIterableToArray(o3, minLen) {
  if (!o3)
    return;
  if (typeof o3 === "string")
    return _arrayLikeToArray(o3, minLen);
  var n2 = Object.prototype.toString.call(o3).slice(8, -1);
  if (n2 === "Object" && o3.constructor)
    n2 = o3.constructor.name;
  if (n2 === "Map" || n2 === "Set")
    return Array.from(o3);
  if (n2 === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n2))
    return _arrayLikeToArray(o3, minLen);
}
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length)
    len = arr.length;
  for (var i22 = 0, arr2 = new Array(len); i22 < len; i22++) {
    arr2[i22] = arr[i22];
  }
  return arr2;
}
var formattingTokensRegExp2 = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
var longFormattingTokensRegExp2 = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
var escapedStringRegExp2 = /^'([^]*?)'?$/;
var doubleQuoteRegExp2 = /''/g;
var notWhitespaceRegExp = /\S/;
var unescapedLatinCharacterRegExp2 = /[a-zA-Z]/;
function parse(dirtyDateString, dirtyFormatString, dirtyReferenceDate, options) {
  var _ref, _options$locale, _ref2, _ref3, _ref4, _options$firstWeekCon, _options$locale2, _options$locale2$opti, _defaultOptions$local, _defaultOptions$local2, _ref5, _ref6, _ref7, _options$weekStartsOn, _options$locale3, _options$locale3$opti, _defaultOptions$local3, _defaultOptions$local4;
  requiredArgs(3, arguments);
  var dateString = String(dirtyDateString);
  var formatString = String(dirtyFormatString);
  var defaultOptions2 = getDefaultOptions();
  var locale62 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref !== void 0 ? _ref : defaultLocale_default;
  if (!locale62.match) {
    throw new RangeError("locale must contain match property");
  }
  var firstWeekContainsDate = toInteger((_ref2 = (_ref3 = (_ref4 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale2 = options.locale) === null || _options$locale2 === void 0 ? void 0 : (_options$locale2$opti = _options$locale2.options) === null || _options$locale2$opti === void 0 ? void 0 : _options$locale2$opti.firstWeekContainsDate) !== null && _ref4 !== void 0 ? _ref4 : defaultOptions2.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var weekStartsOn = toInteger((_ref5 = (_ref6 = (_ref7 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale3 = options.locale) === null || _options$locale3 === void 0 ? void 0 : (_options$locale3$opti = _options$locale3.options) === null || _options$locale3$opti === void 0 ? void 0 : _options$locale3$opti.weekStartsOn) !== null && _ref7 !== void 0 ? _ref7 : defaultOptions2.weekStartsOn) !== null && _ref6 !== void 0 ? _ref6 : (_defaultOptions$local3 = defaultOptions2.locale) === null || _defaultOptions$local3 === void 0 ? void 0 : (_defaultOptions$local4 = _defaultOptions$local3.options) === null || _defaultOptions$local4 === void 0 ? void 0 : _defaultOptions$local4.weekStartsOn) !== null && _ref5 !== void 0 ? _ref5 : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  if (formatString === "") {
    if (dateString === "") {
      return toDate(dirtyReferenceDate);
    } else {
      return /* @__PURE__ */ new Date(NaN);
    }
  }
  var subFnOptions = {
    firstWeekContainsDate,
    weekStartsOn,
    locale: locale62
  };
  var setters = [new DateToSystemTimezoneSetter()];
  var tokens = formatString.match(longFormattingTokensRegExp2).map(function(substring) {
    var firstCharacter = substring[0];
    if (firstCharacter in longFormatters_default) {
      var longFormatter = longFormatters_default[firstCharacter];
      return longFormatter(substring, locale62.formatLong);
    }
    return substring;
  }).join("").match(formattingTokensRegExp2);
  var usedTokens = [];
  var _iterator = _createForOfIteratorHelper(tokens), _step;
  try {
    var _loop = function _loop2() {
      var token = _step.value;
      if (!(options !== null && options !== void 0 && options.useAdditionalWeekYearTokens) && isProtectedWeekYearToken(token)) {
        throwProtectedError(token, formatString, dirtyDateString);
      }
      if (!(options !== null && options !== void 0 && options.useAdditionalDayOfYearTokens) && isProtectedDayOfYearToken(token)) {
        throwProtectedError(token, formatString, dirtyDateString);
      }
      var firstCharacter = token[0];
      var parser = parsers2[firstCharacter];
      if (parser) {
        var incompatibleTokens = parser.incompatibleTokens;
        if (Array.isArray(incompatibleTokens)) {
          var incompatibleToken = usedTokens.find(function(usedToken) {
            return incompatibleTokens.includes(usedToken.token) || usedToken.token === firstCharacter;
          });
          if (incompatibleToken) {
            throw new RangeError("The format string mustn't contain `".concat(incompatibleToken.fullToken, "` and `").concat(token, "` at the same time"));
          }
        } else if (parser.incompatibleTokens === "*" && usedTokens.length > 0) {
          throw new RangeError("The format string mustn't contain `".concat(token, "` and any other token at the same time"));
        }
        usedTokens.push({
          token: firstCharacter,
          fullToken: token
        });
        var parseResult = parser.run(dateString, token, locale62.match, subFnOptions);
        if (!parseResult) {
          return {
            v: /* @__PURE__ */ new Date(NaN)
          };
        }
        setters.push(parseResult.setter);
        dateString = parseResult.rest;
      } else {
        if (firstCharacter.match(unescapedLatinCharacterRegExp2)) {
          throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
        }
        if (token === "''") {
          token = "'";
        } else if (firstCharacter === "'") {
          token = cleanEscapedString2(token);
        }
        if (dateString.indexOf(token) === 0) {
          dateString = dateString.slice(token.length);
        } else {
          return {
            v: /* @__PURE__ */ new Date(NaN)
          };
        }
      }
    };
    for (_iterator.s(); !(_step = _iterator.n()).done; ) {
      var _ret = _loop();
      if (_typeof36(_ret) === "object")
        return _ret.v;
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  if (dateString.length > 0 && notWhitespaceRegExp.test(dateString)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  var uniquePrioritySetters = setters.map(function(setter2) {
    return setter2.priority;
  }).sort(function(a32, b22) {
    return b22 - a32;
  }).filter(function(priority, index, array) {
    return array.indexOf(priority) === index;
  }).map(function(priority) {
    return setters.filter(function(setter2) {
      return setter2.priority === priority;
    }).sort(function(a32, b22) {
      return b22.subPriority - a32.subPriority;
    });
  }).map(function(setterArray) {
    return setterArray[0];
  });
  var date = toDate(dirtyReferenceDate);
  if (isNaN(date.getTime())) {
    return /* @__PURE__ */ new Date(NaN);
  }
  var utcDate = subMilliseconds(date, getTimezoneOffsetInMilliseconds(date));
  var flags = {};
  var _iterator2 = _createForOfIteratorHelper(uniquePrioritySetters), _step2;
  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done; ) {
      var setter = _step2.value;
      if (!setter.validate(utcDate, subFnOptions)) {
        return /* @__PURE__ */ new Date(NaN);
      }
      var result = setter.set(utcDate, flags, subFnOptions);
      if (Array.isArray(result)) {
        utcDate = result[0];
        assign(flags, result[1]);
      } else {
        utcDate = result;
      }
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }
  return utcDate;
}
function cleanEscapedString2(input) {
  return input.match(escapedStringRegExp2)[1].replace(doubleQuoteRegExp2, "'");
}
function isSameMonth(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyDateLeft);
  var dateRight = toDate(dirtyDateRight);
  return dateLeft.getFullYear() === dateRight.getFullYear() && dateLeft.getMonth() === dateRight.getMonth();
}
function subDays(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addDays(dirtyDate, -amount);
}
function parseISO(argument, options) {
  var _options$additionalDi;
  requiredArgs(1, arguments);
  var additionalDigits = toInteger((_options$additionalDi = options === null || options === void 0 ? void 0 : options.additionalDigits) !== null && _options$additionalDi !== void 0 ? _options$additionalDi : 2);
  if (additionalDigits !== 2 && additionalDigits !== 1 && additionalDigits !== 0) {
    throw new RangeError("additionalDigits must be 0, 1 or 2");
  }
  if (!(typeof argument === "string" || Object.prototype.toString.call(argument) === "[object String]")) {
    return /* @__PURE__ */ new Date(NaN);
  }
  var dateStrings = splitDateString(argument);
  var date;
  if (dateStrings.date) {
    var parseYearResult = parseYear(dateStrings.date, additionalDigits);
    date = parseDate(parseYearResult.restDateString, parseYearResult.year);
  }
  if (!date || isNaN(date.getTime())) {
    return /* @__PURE__ */ new Date(NaN);
  }
  var timestamp = date.getTime();
  var time = 0;
  var offset;
  if (dateStrings.time) {
    time = parseTime(dateStrings.time);
    if (isNaN(time)) {
      return /* @__PURE__ */ new Date(NaN);
    }
  }
  if (dateStrings.timezone) {
    offset = parseTimezone(dateStrings.timezone);
    if (isNaN(offset)) {
      return /* @__PURE__ */ new Date(NaN);
    }
  } else {
    var dirtyDate = new Date(timestamp + time);
    var result = /* @__PURE__ */ new Date(0);
    result.setFullYear(dirtyDate.getUTCFullYear(), dirtyDate.getUTCMonth(), dirtyDate.getUTCDate());
    result.setHours(dirtyDate.getUTCHours(), dirtyDate.getUTCMinutes(), dirtyDate.getUTCSeconds(), dirtyDate.getUTCMilliseconds());
    return result;
  }
  return new Date(timestamp + time + offset);
}
var patterns = {
  dateTimeDelimiter: /[T ]/,
  timeZoneDelimiter: /[Z ]/i,
  timezone: /([Z+-].*)$/
};
var dateRegex = /^-?(?:(\d{3})|(\d{2})(?:-?(\d{2}))?|W(\d{2})(?:-?(\d{1}))?|)$/;
var timeRegex = /^(\d{2}(?:[.,]\d*)?)(?::?(\d{2}(?:[.,]\d*)?))?(?::?(\d{2}(?:[.,]\d*)?))?$/;
var timezoneRegex = /^([+-])(\d{2})(?::?(\d{2}))?$/;
function splitDateString(dateString) {
  var dateStrings = {};
  var array = dateString.split(patterns.dateTimeDelimiter);
  var timeString;
  if (array.length > 2) {
    return dateStrings;
  }
  if (/:/.test(array[0])) {
    timeString = array[0];
  } else {
    dateStrings.date = array[0];
    timeString = array[1];
    if (patterns.timeZoneDelimiter.test(dateStrings.date)) {
      dateStrings.date = dateString.split(patterns.timeZoneDelimiter)[0];
      timeString = dateString.substr(dateStrings.date.length, dateString.length);
    }
  }
  if (timeString) {
    var token = patterns.timezone.exec(timeString);
    if (token) {
      dateStrings.time = timeString.replace(token[1], "");
      dateStrings.timezone = token[1];
    } else {
      dateStrings.time = timeString;
    }
  }
  return dateStrings;
}
function parseYear(dateString, additionalDigits) {
  var regex = new RegExp("^(?:(\\d{4}|[+-]\\d{" + (4 + additionalDigits) + "})|(\\d{2}|[+-]\\d{" + (2 + additionalDigits) + "})$)");
  var captures = dateString.match(regex);
  if (!captures)
    return {
      year: NaN,
      restDateString: ""
    };
  var year = captures[1] ? parseInt(captures[1]) : null;
  var century = captures[2] ? parseInt(captures[2]) : null;
  return {
    year: century === null ? year : century * 100,
    restDateString: dateString.slice((captures[1] || captures[2]).length)
  };
}
function parseDate(dateString, year) {
  if (year === null)
    return /* @__PURE__ */ new Date(NaN);
  var captures = dateString.match(dateRegex);
  if (!captures)
    return /* @__PURE__ */ new Date(NaN);
  var isWeekDate = !!captures[4];
  var dayOfYear = parseDateUnit(captures[1]);
  var month = parseDateUnit(captures[2]) - 1;
  var day = parseDateUnit(captures[3]);
  var week = parseDateUnit(captures[4]);
  var dayOfWeek = parseDateUnit(captures[5]) - 1;
  if (isWeekDate) {
    if (!validateWeekDate(year, week, dayOfWeek)) {
      return /* @__PURE__ */ new Date(NaN);
    }
    return dayOfISOWeekYear(year, week, dayOfWeek);
  } else {
    var date = /* @__PURE__ */ new Date(0);
    if (!validateDate(year, month, day) || !validateDayOfYearDate(year, dayOfYear)) {
      return /* @__PURE__ */ new Date(NaN);
    }
    date.setUTCFullYear(year, month, Math.max(dayOfYear, day));
    return date;
  }
}
function parseDateUnit(value) {
  return value ? parseInt(value) : 1;
}
function parseTime(timeString) {
  var captures = timeString.match(timeRegex);
  if (!captures)
    return NaN;
  var hours = parseTimeUnit(captures[1]);
  var minutes = parseTimeUnit(captures[2]);
  var seconds = parseTimeUnit(captures[3]);
  if (!validateTime(hours, minutes, seconds)) {
    return NaN;
  }
  return hours * millisecondsInHour + minutes * millisecondsInMinute + seconds * 1e3;
}
function parseTimeUnit(value) {
  return value && parseFloat(value.replace(",", ".")) || 0;
}
function parseTimezone(timezoneString) {
  if (timezoneString === "Z")
    return 0;
  var captures = timezoneString.match(timezoneRegex);
  if (!captures)
    return 0;
  var sign2 = captures[1] === "+" ? -1 : 1;
  var hours = parseInt(captures[2]);
  var minutes = captures[3] && parseInt(captures[3]) || 0;
  if (!validateTimezone(hours, minutes)) {
    return NaN;
  }
  return sign2 * (hours * millisecondsInHour + minutes * millisecondsInMinute);
}
function dayOfISOWeekYear(isoWeekYear, week, day) {
  var date = /* @__PURE__ */ new Date(0);
  date.setUTCFullYear(isoWeekYear, 0, 4);
  var fourthOfJanuaryDay = date.getUTCDay() || 7;
  var diff = (week - 1) * 7 + day + 1 - fourthOfJanuaryDay;
  date.setUTCDate(date.getUTCDate() + diff);
  return date;
}
var daysInMonths = [31, null, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
function isLeapYearIndex2(year) {
  return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
}
function validateDate(year, month, date) {
  return month >= 0 && month <= 11 && date >= 1 && date <= (daysInMonths[month] || (isLeapYearIndex2(year) ? 29 : 28));
}
function validateDayOfYearDate(year, dayOfYear) {
  return dayOfYear >= 1 && dayOfYear <= (isLeapYearIndex2(year) ? 366 : 365);
}
function validateWeekDate(_year, week, day) {
  return week >= 1 && week <= 53 && day >= 0 && day <= 6;
}
function validateTime(hours, minutes, seconds) {
  if (hours === 24) {
    return minutes === 0 && seconds === 0;
  }
  return seconds >= 0 && seconds < 60 && minutes >= 0 && minutes < 60 && hours >= 0 && hours < 25;
}
function validateTimezone(_hours, minutes) {
  return minutes >= 0 && minutes <= 59;
}
function setYear(dirtyDate, dirtyYear) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var year = toInteger(dirtyYear);
  if (isNaN(date.getTime())) {
    return /* @__PURE__ */ new Date(NaN);
  }
  date.setFullYear(year);
  return date;
}
function subMonths(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addMonths(dirtyDate, -amount);
}
function _typeof37(obj) {
  "@babel/helpers - typeof";
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof37 = function _typeof382(obj2) {
      return typeof obj2;
    };
  } else {
    _typeof37 = function _typeof382(obj2) {
      return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
    };
  }
  return _typeof37(obj);
}
function sub(date, duration) {
  requiredArgs(2, arguments);
  if (!duration || _typeof37(duration) !== "object")
    return /* @__PURE__ */ new Date(NaN);
  var years = duration.years ? toInteger(duration.years) : 0;
  var months = duration.months ? toInteger(duration.months) : 0;
  var weeks = duration.weeks ? toInteger(duration.weeks) : 0;
  var days = duration.days ? toInteger(duration.days) : 0;
  var hours = duration.hours ? toInteger(duration.hours) : 0;
  var minutes = duration.minutes ? toInteger(duration.minutes) : 0;
  var seconds = duration.seconds ? toInteger(duration.seconds) : 0;
  var dateWithoutMonths = subMonths(date, months + years * 12);
  var dateWithoutDays = subDays(dateWithoutMonths, days + weeks * 7);
  var minutestoSub = minutes + hours * 60;
  var secondstoSub = seconds + minutestoSub * 60;
  var mstoSub = secondstoSub * 1e3;
  var finalDate = new Date(dateWithoutDays.getTime() - mstoSub);
  return finalDate;
}
var utf8Encoder2 = new TextEncoder();
var utf8Decoder2 = new TextDecoder("utf-8", { ignoreBOM: true });
function base64encode(str) {
  return base64EncArr(strToUTF8Arr(str));
}
function uint6ToB64(nUint6) {
  return nUint6 < 26 ? nUint6 + 65 : nUint6 < 52 ? nUint6 + 71 : nUint6 < 62 ? nUint6 - 4 : nUint6 === 62 ? 43 : nUint6 === 63 ? 47 : 65;
}
function base64EncArr(aBytes) {
  let nMod3 = 2;
  let sB64Enc = "";
  const nLen = aBytes.length;
  let nUint24 = 0;
  for (let nIdx = 0; nIdx < nLen; nIdx++) {
    nMod3 = nIdx % 3;
    nUint24 |= aBytes[nIdx] << (16 >>> nMod3 & 24);
    if (nMod3 === 2 || aBytes.length - nIdx === 1) {
      sB64Enc += String.fromCodePoint(
        uint6ToB64(nUint24 >>> 18 & 63),
        uint6ToB64(nUint24 >>> 12 & 63),
        uint6ToB64(nUint24 >>> 6 & 63),
        uint6ToB64(nUint24 & 63)
      );
      nUint24 = 0;
    }
  }
  return sB64Enc.substring(0, sB64Enc.length - 2 + nMod3) + (nMod3 === 2 ? "" : nMod3 === 1 ? "=" : "==");
}
function strToUTF8Arr(sDOMStr) {
  let nChr;
  const nStrLen = sDOMStr.length;
  let nArrLen = 0;
  for (let nMapIdx = 0; nMapIdx < nStrLen; nMapIdx++) {
    nChr = sDOMStr.codePointAt(nMapIdx);
    if (nChr === void 0) {
      throw Error(
        `No char at ${nMapIdx} on string with length: ${sDOMStr.length}`
      );
    }
    if (nChr >= 65536) {
      nMapIdx++;
    }
    nArrLen += nChr < 128 ? 1 : nChr < 2048 ? 2 : nChr < 65536 ? 3 : nChr < 2097152 ? 4 : nChr < 67108864 ? 5 : 6;
  }
  const aBytes = new Uint8Array(nArrLen);
  let nIdx = 0;
  let nChrIdx = 0;
  while (nIdx < nArrLen) {
    nChr = sDOMStr.codePointAt(nChrIdx);
    if (nChr === void 0) {
      throw Error(
        `No char at ${nChrIdx} on string with length: ${sDOMStr.length}`
      );
    }
    if (nChr < 128) {
      aBytes[nIdx++] = nChr;
    } else if (nChr < 2048) {
      aBytes[nIdx++] = 192 + (nChr >>> 6);
      aBytes[nIdx++] = 128 + (nChr & 63);
    } else if (nChr < 65536) {
      aBytes[nIdx++] = 224 + (nChr >>> 12);
      aBytes[nIdx++] = 128 + (nChr >>> 6 & 63);
      aBytes[nIdx++] = 128 + (nChr & 63);
    } else if (nChr < 2097152) {
      aBytes[nIdx++] = 240 + (nChr >>> 18);
      aBytes[nIdx++] = 128 + (nChr >>> 12 & 63);
      aBytes[nIdx++] = 128 + (nChr >>> 6 & 63);
      aBytes[nIdx++] = 128 + (nChr & 63);
      nChrIdx++;
    } else if (nChr < 67108864) {
      aBytes[nIdx++] = 248 + (nChr >>> 24);
      aBytes[nIdx++] = 128 + (nChr >>> 18 & 63);
      aBytes[nIdx++] = 128 + (nChr >>> 12 & 63);
      aBytes[nIdx++] = 128 + (nChr >>> 6 & 63);
      aBytes[nIdx++] = 128 + (nChr & 63);
      nChrIdx++;
    } else {
      aBytes[nIdx++] = 252 + (nChr >>> 30);
      aBytes[nIdx++] = 128 + (nChr >>> 24 & 63);
      aBytes[nIdx++] = 128 + (nChr >>> 18 & 63);
      aBytes[nIdx++] = 128 + (nChr >>> 12 & 63);
      aBytes[nIdx++] = 128 + (nChr >>> 6 & 63);
      aBytes[nIdx++] = 128 + (nChr & 63);
      nChrIdx++;
    }
    nChrIdx++;
  }
  return aBytes;
}
async function defaultRequestHandler(baseUrl, endpoint, options = {}) {
  const requestHeaders = {};
  if (options.token) {
    requestHeaders.Authorization = `Bearer secret-token:${options.token}`;
  } else if (options.basicAuth) {
    requestHeaders.Authorization = `Basic ${base64encode(
      `${options.basicAuth.username}:${options.basicAuth.password}`
    )}`;
  }
  requestHeaders["Content-Type"] = !options.contentType || options.contentType === "json" ? "application/json" : "text/plain";
  if (options.talerAmlOfficerSignature) {
    requestHeaders["Taler-AML-Officer-Signature"] = options.talerAmlOfficerSignature;
  }
  const requestMethod = options?.method ?? "GET";
  const requestBody = options?.data;
  const requestTimeout = options?.timeout ?? 5 * 1e3;
  const requestParams = options.params ?? {};
  const requestPreventCache = options.preventCache ?? false;
  const requestPreventCors = options.preventCors ?? false;
  const validURL = validateURL(baseUrl, endpoint);
  if (!validURL) {
    const error2 = {
      info: {
        url: `${baseUrl}${endpoint}`,
        payload: {},
        hasToken: !!options.token,
        status: 0,
        options
      },
      type: 4,
      exception: void 0,
      loading: false,
      message: `invalid URL: "${baseUrl}${endpoint}"`
    };
    throw new RequestError(error2);
  }
  Object.entries(requestParams).forEach(([key, value]) => {
    validURL.searchParams.set(key, String(value));
  });
  let payload = void 0;
  if (requestBody != null) {
    if (typeof requestBody === "string") {
      payload = requestBody;
    } else if (requestBody instanceof ArrayBuffer) {
      payload = requestBody;
    } else if (ArrayBuffer.isView(requestBody)) {
      payload = requestBody;
    } else if (typeof requestBody === "object") {
      payload = JSON.stringify(requestBody);
    } else {
      const error2 = {
        info: {
          url: validURL.href,
          payload: {},
          hasToken: !!options.token,
          status: 0,
          options
        },
        type: 4,
        exception: void 0,
        loading: false,
        message: `unsupported request body type: "${typeof requestBody}"`
      };
      throw new RequestError(error2);
    }
  }
  const controller = new AbortController();
  const timeoutId = setTimeout(() => {
    controller.abort("HTTP_REQUEST_TIMEOUT");
  }, requestTimeout);
  let response;
  try {
    response = await fetch(validURL.href, {
      headers: requestHeaders,
      method: requestMethod,
      credentials: "omit",
      mode: requestPreventCors ? "no-cors" : "cors",
      cache: requestPreventCache ? "no-cache" : "default",
      body: payload,
      signal: controller.signal
    });
  } catch (ex) {
    const info = {
      payload,
      url: validURL.href,
      hasToken: !!options.token,
      status: 0,
      options
    };
    if (ex instanceof Error) {
      if (ex.message === "HTTP_REQUEST_TIMEOUT") {
        const error22 = {
          info,
          type: 3,
          message: "request timeout"
        };
        throw new RequestError(error22);
      }
    }
    const error2 = {
      info,
      type: 4,
      exception: ex,
      loading: false,
      message: ex instanceof Error ? ex.message : ""
    };
    throw new RequestError(error2);
  }
  if (timeoutId) {
    clearTimeout(timeoutId);
  }
  const headerMap = new Headers();
  response.headers.forEach((value, key) => {
    headerMap.set(key, value);
  });
  if (response.ok) {
    const result = await buildRequestOk(
      response,
      validURL.href,
      payload,
      !!options.token,
      options
    );
    return result;
  } else {
    const dataTxt = await response.text();
    const error2 = buildRequestFailed(
      validURL.href,
      dataTxt,
      response.status,
      payload,
      options
    );
    throw new RequestError(error2);
  }
}
var RequestError = class extends Error {
  constructor(d32) {
    super(d32.message);
    this.info = d32;
    this.cause = d32;
  }
};
async function buildRequestOk(response, url, payload, hasToken, options) {
  const dataTxt = await response.text();
  const data = dataTxt ? JSON.parse(dataTxt) : void 0;
  return {
    ok: true,
    data,
    info: {
      payload,
      url,
      hasToken,
      options,
      status: response.status
    }
  };
}
function buildRequestFailed(url, dataTxt, status, payload, maybeOptions) {
  const options = maybeOptions ?? {};
  const info = {
    payload,
    url,
    hasToken: !!options.token,
    options,
    status: status || 0
  };
  try {
    const data = dataTxt ? JSON.parse(dataTxt) : void 0;
    const errorCode = !data || !data.code ? "" : `(code: ${data.code})`;
    const errorHint = !data || !data.hint ? "Not hint." : `${data.hint} ${errorCode}`;
    if (status && status >= 400 && status < 500) {
      const message = data === void 0 ? `Client error (${status}) without data.` : errorHint;
      const error2 = {
        type: 0,
        status,
        info,
        message,
        payload: data
      };
      return error2;
    }
    if (status && status >= 500 && status < 600) {
      const message = data === void 0 ? `Server error (${status}) without data.` : errorHint;
      const error2 = {
        type: 1,
        status,
        info,
        message,
        payload: data
      };
      return error2;
    }
    return {
      info,
      loading: false,
      type: 4,
      status,
      exception: void 0,
      message: `http status code not handled: ${status}`
    };
  } catch (ex) {
    const error2 = {
      info,
      loading: false,
      status,
      type: 2,
      exception: ex,
      body: dataTxt,
      message: "Could not parse body as json"
    };
    return error2;
  }
}
function validateURL(baseUrl, endpoint) {
  try {
    return new URL(`${baseUrl}${endpoint}`);
  } catch (ex) {
    return void 0;
  }
}
var Context = B({ request: defaultRequestHandler });
function useAsync(callback, deps = []) {
  const [data, setData] = p3();
  const [error2, setError] = p3();
  h2(() => {
    let unloaded = false;
    if (callback) {
      callback().then((resp) => {
        if (unloaded)
          return;
        setData(resp);
      }).catch((error22) => {
        if (unloaded)
          return;
        setError(error22);
      });
    }
    return () => {
      unloaded = true;
    };
  }, deps);
  if (error2)
    return opUnknownFailure(error2);
  if (!data)
    return void 0;
  return data;
}
function useLongPolling(first, shouldRetryFn, retryFn, deps = [], opts = {}) {
  const mt = opts?.minTime ?? 1e3;
  const [retry, setRetry] = p3({
    count: 0,
    fn: void 0,
    startMs: (/* @__PURE__ */ new Date()).getTime()
  });
  const result = useAsync(retry.fn, [retry.count, ...deps]);
  const body = result ?? first;
  h2(() => {
    if (!body)
      return;
    const _body = body;
    function doChceck() {
      const rt = shouldRetryFn(_body, retry.count);
      if (!rt)
        return;
      setRetry((lt) => ({
        count: lt.count + 1,
        fn: () => retryFn(rt),
        startMs: (/* @__PURE__ */ new Date()).getTime()
      }));
    }
    const diff = (/* @__PURE__ */ new Date()).getTime() - retry.startMs;
    if (diff < mt) {
      delayMs(mt - diff).then(doChceck);
    } else {
      doChceck();
    }
  }, [body]);
  return body;
}
async function delayMs(ms) {
  return new Promise((resolve, reject) => {
    setTimeout(() => resolve(), ms);
  });
}
function useAsyncAsHook(fn2, deps) {
  const [result, setHookResponse] = p3(void 0);
  const args = F(
    () => ({
      fn: fn2
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }),
    deps || []
  );
  async function doAsync() {
    try {
      const response = await args.fn();
      if (response === false)
        return;
      setHookResponse({ hasError: false, response });
    } catch (e22) {
      if (e22 instanceof Error) {
        setHookResponse({
          hasError: true,
          operational: false,
          message: e22.message
        });
      }
    }
  }
  h2(() => {
    doAsync();
  }, [args]);
  if (!result)
    return void 0;
  return { ...result, retry: doAsync };
}
var FormModelImpl = class {
  constructor() {
    this.fieldHandlers = {};
    this.hiddenSections = /* @__PURE__ */ new Set();
  }
  getHandlerForUiField(fieldId) {
    return this.fieldHandlers[fieldId];
  }
  getHandlerForAttributeKey(attributeKey) {
    for (const h53 of Object.values(this.fieldHandlers)) {
      if (h53.name === attributeKey) {
        return h53;
      }
    }
    throw Error(`no handler for attribute path ${attributeKey}`);
  }
  isSectionHidden(sectionName) {
    return this.hiddenSections.has(sectionName);
  }
};
function useFormMeta(form, formContext, initialValue) {
  let formDesign;
  if (typeof form.config === "function") {
    const config = form.config;
    formDesign = F(() => config(formContext), [form, formContext]);
  } else {
    formDesign = form.config;
  }
  return useForm(formDesign, initialValue);
}
function useForm(design, initialValue) {
  const { i18n: i18n4 } = useTranslationContext();
  const [formValue, formUpdateHandler] = p3(initialValue);
  const { model, result, errors: errors2 } = constructFormHandler(
    design,
    formValue,
    formUpdateHandler,
    i18n4
  );
  const status = {
    status: errors2 === void 0 ? "ok" : "fail",
    result,
    errors: errors2
  };
  return {
    model,
    status,
    update: (f3) => {
      formUpdateHandler(f3);
    },
    design
  };
}
function getValueFromPath(object, path, fallbackValue) {
  if (path.length === 0)
    return object;
  const [head, ...rest] = path;
  if (!head) {
    return getValueFromPath(object, rest, fallbackValue);
  }
  if (object === void 0) {
    return fallbackValue;
  }
  return getValueFromPath(object[head], rest, fallbackValue);
}
function setValueIntoPath(object, path, value) {
  if (path.length === 0)
    return value;
  const [head, ...rest] = path;
  if (!head) {
    return setValueIntoPath(object, rest, value);
  }
  if (object === void 0) {
    return undefinedIfEmpty({ [head]: setValueIntoPath({}, rest, value) });
  }
  return undefinedIfEmpty({
    ...object,
    [head]: setValueIntoPath(object[head] ?? {}, rest, value)
  });
}
function undefinedIfEmpty(obj) {
  if (obj === void 0)
    return void 0;
  return Object.keys(obj).some(
    (k22) => obj[k22] !== void 0
  ) ? obj : void 0;
}
function checkFormFieldIsValid(formElement, currentValue, i18n4, secitonTitle, form) {
  if (!("id" in formElement)) {
    return void 0;
  }
  if (formElement.required && currentValue === void 0) {
    return {
      label: formElement.label,
      message: i18n4.str`required`,
      section: secitonTitle
    };
  } else if (formElement.validator) {
    try {
      const message = formElement.validator(currentValue, form);
      if (message !== void 0) {
        return {
          label: formElement.label,
          message,
          section: secitonTitle
        };
      }
    } catch (e22) {
      console.error(e22);
      const message = i18n4.str`Validation function failed. Contact developers ${String(
        e22
      )}`;
      console.log(message);
      return {
        label: formElement.label,
        message,
        section: secitonTitle
      };
    }
  }
  return void 0;
}
function constructFormHandler(design, formValue, onValueChange, i18n4) {
  let model = new FormModelImpl();
  let result = {};
  let errors2 = void 0;
  function createFieldHandler(formElement, hiddenSection, handlerUiPath, secitonTitle) {
    let field;
    if ("id" in formElement) {
      let updater2 = function(newValue) {
        const updated = setValueIntoPath(formValue, path, newValue) ?? {};
        onValueChange(updated);
      };
      var updater = updater2;
      const path = formElement.id.split(".");
      const currentValue = getValueFromPath(formValue, path, void 0);
      const hidden = hiddenSection || formElement.hidden || formElement.hide && formElement.hide(currentValue, result);
      const currentError = !hidden ? checkFormFieldIsValid(
        formElement,
        currentValue,
        i18n4,
        secitonTitle,
        formValue
      ) : void 0;
      if (currentError !== void 0) {
        errors2 = setValueIntoPath(errors2, path, currentError);
      }
      field = {
        name: formElement.id,
        error: currentError?.message,
        value: currentValue,
        onChange: updater2,
        formRootResult: result,
        hidden
      };
      if (!hidden) {
        result = setValueIntoPath(result, path, field.value) ?? {};
      }
    } else {
      const hidden = hiddenSection || formElement.hidden || formElement.hide && formElement.hide({}, result);
      field = {
        name: "<none>",
        value: void 0,
        onChange: () => {
        },
        formRootResult: result,
        hidden
      };
    }
    model.fieldHandlers[handlerUiPath] = field;
  }
  switch (design.type) {
    case "double-column": {
      design.sections.forEach((sec, secIndex) => {
        const hidden = sec.hide && sec.hide(result);
        if (hidden) {
          model.hiddenSections.add(`${secIndex}`);
        }
        sec.fields.forEach(
          (f3, fieldIndex) => createFieldHandler(f3, hidden, `${secIndex}.${fieldIndex}`, sec.title)
        );
      });
      break;
    }
    case "single-column": {
      design.fields.forEach(
        (f3, fieldIndex) => createFieldHandler(f3, void 0, `root.${fieldIndex}`, void 0)
      );
      break;
    }
    default: {
      assertUnreachable(design);
    }
  }
  return { model, result, errors: errors2 };
}
function memoryMap(backend = /* @__PURE__ */ new Map()) {
  const obs = new EventTarget();
  const theMemoryMap = {
    onAnyUpdate: (handler) => {
      obs.addEventListener(`update`, handler);
      obs.addEventListener(`clear`, handler);
      return () => {
        obs.removeEventListener(`update`, handler);
        obs.removeEventListener(`clear`, handler);
      };
    },
    onUpdate: (key, handler) => {
      obs.addEventListener(`update-${key}`, handler);
      obs.addEventListener(`clear`, handler);
      return () => {
        obs.removeEventListener(`update-${key}`, handler);
        obs.removeEventListener(`clear`, handler);
      };
    },
    delete: (key) => {
      const result = backend.delete(key);
      theMemoryMap.size = backend.length;
      obs.dispatchEvent(new Event(`update-${key}`));
      obs.dispatchEvent(new Event(`update`));
      return result;
    },
    set: (key, value) => {
      backend.set(key, value);
      theMemoryMap.size = backend.length;
      obs.dispatchEvent(new Event(`update-${key}`));
      obs.dispatchEvent(new Event(`update`));
      return theMemoryMap;
    },
    clear: () => {
      backend.clear();
      obs.dispatchEvent(new Event(`clear`));
    },
    entries: backend.entries.bind(backend),
    forEach: backend.forEach.bind(backend),
    get: backend.get.bind(backend),
    has: backend.has.bind(backend),
    keys: backend.keys.bind(backend),
    size: backend.size,
    values: backend.values.bind(backend),
    [Symbol.iterator]: backend[Symbol.iterator],
    [Symbol.toStringTag]: "theMemoryMap"
  };
  return theMemoryMap;
}
function localStorageMap() {
  const obs = new EventTarget();
  const theLocalStorageMap = {
    onAnyUpdate: (handler) => {
      obs.addEventListener(`update`, handler);
      obs.addEventListener(`clear`, handler);
      window.addEventListener("storage", handler);
      return () => {
        window.removeEventListener("storage", handler);
        obs.removeEventListener(`update`, handler);
        obs.removeEventListener(`clear`, handler);
      };
    },
    onUpdate: (key, handler) => {
      obs.addEventListener(`update-${key}`, handler);
      obs.addEventListener(`clear`, handler);
      function handleStorageEvent(ev) {
        if (ev.key === null || ev.key === key) {
          handler();
        }
      }
      window.addEventListener("storage", handleStorageEvent);
      return () => {
        window.removeEventListener("storage", handleStorageEvent);
        obs.removeEventListener(`update-${key}`, handler);
        obs.removeEventListener(`clear`, handler);
      };
    },
    delete: (key) => {
      const exists = localStorage.getItem(key) !== null;
      localStorage.removeItem(key);
      theLocalStorageMap.size = localStorage.length;
      obs.dispatchEvent(new Event(`update-${key}`));
      obs.dispatchEvent(new Event(`update`));
      return exists;
    },
    set: (key, v3) => {
      localStorage.setItem(key, v3);
      theLocalStorageMap.size = localStorage.length;
      obs.dispatchEvent(new Event(`update-${key}`));
      obs.dispatchEvent(new Event(`update`));
      return theLocalStorageMap;
    },
    clear: () => {
      localStorage.clear();
      obs.dispatchEvent(new Event(`clear`));
    },
    entries: () => {
      let index = 0;
      const total = localStorage.length;
      return {
        next() {
          if (index === total)
            return { done: true, value: void 0 };
          const key = localStorage.key(index);
          if (key === null) {
            throw Error("key cant be null");
          }
          const item = localStorage.getItem(key);
          if (item === null) {
            throw Error("value cant be null");
          }
          index = index + 1;
          return { done: false, value: [key, item] };
        },
        [Symbol.iterator]() {
          return this;
        }
      };
    },
    forEach: (cb) => {
      for (let index = 0; index < localStorage.length; index++) {
        const key = localStorage.key(index);
        if (key === null) {
          throw Error("key cant be null");
        }
        const item = localStorage.getItem(key);
        if (item === null) {
          throw Error("value cant be null");
        }
        cb(key, item, theLocalStorageMap);
      }
    },
    get: (key) => {
      const item = localStorage.getItem(key);
      if (item === null)
        return void 0;
      return item;
    },
    has: (key) => {
      return localStorage.getItem(key) === null;
    },
    keys: () => {
      let index = 0;
      const total = localStorage.length;
      return {
        next() {
          if (index === total)
            return { done: true, value: void 0 };
          const key = localStorage.key(index);
          if (key === null) {
            throw Error("key cant be null");
          }
          index = index + 1;
          return { done: false, value: key };
        },
        [Symbol.iterator]() {
          return this;
        }
      };
    },
    size: localStorage.length,
    values: () => {
      let index = 0;
      const total = localStorage.length;
      return {
        next() {
          if (index === total)
            return { done: true, value: void 0 };
          const key = localStorage.key(index);
          if (key === null) {
            throw Error("key cant be null");
          }
          const item = localStorage.getItem(key);
          if (item === null) {
            throw Error("value cant be null");
          }
          index = index + 1;
          return { done: false, value: item };
        },
        [Symbol.iterator]() {
          return this;
        }
      };
    },
    [Symbol.iterator]: function() {
      return theLocalStorageMap.entries();
    },
    [Symbol.toStringTag]: "theLocalStorageMap"
  };
  return theLocalStorageMap;
}
var isFirefox = typeof window !== "undefined" && typeof window["InstallTrigger"] !== "undefined";
async function getAllContent() {
  if (isFirefox) {
    return browser.storage.local.get();
  } else {
    return chrome.storage.local.get();
  }
}
async function updateContent(obj) {
  if (isFirefox) {
    return browser.storage.local.set(obj);
  } else {
    return chrome.storage.local.set(obj);
  }
}
function onBrowserStorageUpdate(cb) {
  if (isFirefox) {
    browser.storage.local.onChanged.addListener(cb);
  } else {
    chrome.storage.local.onChanged.addListener(cb);
  }
}
function browserStorageMap(backend) {
  getAllContent().then((content) => {
    Object.entries(content ?? {}).forEach(([k22, v3]) => {
      backend.set(k22, v3);
    });
  });
  backend.onAnyUpdate(async () => {
    const result = {};
    for (const [key, value] of backend.entries()) {
      result[key] = value;
    }
    await updateContent(result);
  });
  onBrowserStorageUpdate((changes) => {
    const changedItems = Object.keys(changes);
    if (changedItems.length === 0) {
      backend.clear();
    } else {
      for (const key of changedItems) {
        if (!changes[key].newValue) {
          backend.delete(key);
        } else {
          if (changes[key].newValue !== changes[key].oldValue) {
            backend.set(key, changes[key].newValue);
          }
        }
      }
    }
  });
  return backend;
}
function buildStorageKey(name, codec) {
  return {
    id: name,
    codec: codec ?? codecForString()
  };
}
var supportLocalStorage = typeof window !== "undefined";
var supportBrowserStorage = typeof chrome !== "undefined" && typeof chrome.storage !== "undefined";
var storage = function buildStorage() {
  if (supportBrowserStorage) {
    if (supportLocalStorage) {
      return browserStorageMap(localStorageMap());
    } else {
      return browserStorageMap(memoryMap());
    }
  } else if (supportLocalStorage) {
    return localStorageMap();
  } else {
    return memoryMap();
  }
}();
function useLocalStorage(key, defaultValue) {
  const current = convert(storage.get(key.id), key, defaultValue);
  const [_3, setStoredValue] = p3(AbsoluteTime.now().t_ms);
  h2(() => {
    return storage.onUpdate(key.id, () => {
      setStoredValue(AbsoluteTime.now().t_ms);
    });
  }, [key.id]);
  const setValue = (value) => {
    if (value === void 0) {
      storage.delete(key.id);
    } else {
      storage.set(
        key.id,
        key.codec ? JSON.stringify(value) : value
      );
    }
  };
  return {
    value: current,
    update: setValue,
    reset: () => {
      setValue(defaultValue);
    }
  };
}
function convert(updated, key, defaultValue) {
  if (updated === void 0)
    return defaultValue;
  try {
    return key.codec.decode(JSON.parse(updated));
  } catch (e22) {
    console.error("Decoding error", e22);
    return defaultValue;
  }
}
var MIN_LANG_COVERAGE_THRESHOLD = 90;
function getBrowserLang(completeness) {
  if (typeof window === "undefined")
    return void 0;
  if (window.navigator.language) {
    if (completeness[window.navigator.language] >= MIN_LANG_COVERAGE_THRESHOLD) {
      return window.navigator.language;
    }
  }
  if (window.navigator.languages) {
    const match52 = Object.entries(completeness).filter(([code, value]) => {
      if (value < MIN_LANG_COVERAGE_THRESHOLD)
        return false;
      return window.navigator.languages.findIndex((l3) => l3.startsWith(code)) !== -1;
    }).map(([code, value]) => ({ code, value }));
    if (match52.length > 0) {
      let max = match52[0];
      match52.forEach((v3) => {
        if (v3.value > max.value) {
          max = v3;
        }
      });
      return max.code;
    }
  }
  ;
  return void 0;
}
var langPreferenceKey = buildStorageKey("lang-preference");
function useLang(initial22, completeness) {
  const defaultValue = (getBrowserLang(completeness) || initial22 || "en").substring(0, 2);
  return useLocalStorage(langPreferenceKey, defaultValue);
}
var storage2 = memoryMap();
var storage3 = memoryMap();
var NOTIFICATION_KEY = "notification";
var GLOBAL_NOTIFICATION_TIMEOUT = Duration.fromSpec({
  seconds: 5
});
function updateInStorage(n2) {
  const h53 = hash3(n2);
  const mem = storage3.get(NOTIFICATION_KEY) ?? /* @__PURE__ */ new Map();
  const newState = new Map(mem);
  newState.set(h53, n2);
  storage3.set(NOTIFICATION_KEY, newState);
}
function notify(notif) {
  const currentState = storage3.get(NOTIFICATION_KEY) ?? /* @__PURE__ */ new Map();
  const newState = currentState.set(hash3(notif), notif);
  if (GLOBAL_NOTIFICATION_TIMEOUT.d_ms !== "forever") {
    setTimeout(() => {
      notif.timeout = true;
      updateInStorage(notif);
    }, GLOBAL_NOTIFICATION_TIMEOUT.d_ms);
  }
  storage3.set(NOTIFICATION_KEY, newState);
}
function notifyError(title, description, debug) {
  notify({
    type: "error",
    title,
    description,
    debug,
    when: AbsoluteTime.now()
  });
}
function notifyException(title, ex) {
  notify({
    type: "error",
    title,
    description: ex.message,
    debug: ex.stack,
    when: AbsoluteTime.now()
  });
}
function notifyInfo(title) {
  notify({
    type: "info",
    title,
    when: AbsoluteTime.now()
  });
}
function useNotifications() {
  const [, setLastUpdate] = p3();
  const value = storage3.get(NOTIFICATION_KEY) ?? /* @__PURE__ */ new Map();
  h2(() => {
    return storage3.onUpdate(NOTIFICATION_KEY, () => {
      setLastUpdate(Date.now());
    });
  });
  return Array.from(value.values()).map((message, idx) => {
    return {
      message,
      acknowledge: () => {
        message.ack = true;
        updateInStorage(message);
      }
    };
  });
}
function hashCode(str) {
  if (str.length === 0)
    return "0";
  let hash22 = 0;
  let chr;
  for (let i22 = 0; i22 < str.length; i22++) {
    chr = str.charCodeAt(i22);
    hash22 = (hash22 << 5) - hash22 + chr;
    hash22 |= 0;
  }
  return hash22.toString(16);
}
function hash3(msg) {
  let str = msg.type + ":" + msg.title;
  if (msg.type === "error") {
    if (msg.description) {
      str += ":" + msg.description;
    }
    if (msg.debug) {
      str += ":" + msg.debug;
    }
  }
  return hashCode(str);
}
function useLocalNotificationHandler() {
  const { i18n: i18n4 } = useTranslationContext();
  const [value, setter] = p3();
  const notif = !value ? void 0 : {
    message: value,
    acknowledge: () => {
      setter(void 0);
    }
  };
  function makeHandler(doAction, onOperationSuccess, onOperationFail, onOperationComplete) {
    const onNotification = setter;
    return {
      onClick: async () => {
        try {
          const resp = await doAction();
          if (resp) {
            if (resp.type === "ok") {
              const result = resp;
              const msg = onOperationSuccess(result);
              if (msg) {
                notifyInfo(msg);
              }
            }
            if (resp.type === "fail") {
              const d32 = "detail" in resp ? resp.detail : void 0;
              const title = !onOperationFail ? i18n4.str`Unexpected error` : onOperationFail(resp);
              onNotification({
                title,
                type: "error",
                description: d32 && d32.hint ? d32.hint : void 0,
                debug: d32,
                when: AbsoluteTime.now()
              });
            }
          }
          if (onOperationComplete) {
            onOperationComplete();
          }
          return resp;
        } catch (error2) {
          console.error(error2);
          if (error2 instanceof TalerError) {
            onNotification(buildUnifiedRequestErrorMessage(i18n4, error2));
          } else {
            const description = error2 instanceof Error ? error2.message : String(error2);
            onNotification({
              title: i18n4.str`Operation failed`,
              type: "error",
              description,
              when: AbsoluteTime.now()
            });
          }
          if (onOperationComplete) {
            onOperationComplete();
          }
          return void 0;
        }
      }
    };
  }
  return [notif, makeHandler, setter];
}
function buildUnifiedRequestErrorMessage(i18n4, cause) {
  let result;
  switch (cause.errorDetail.code) {
    case TalerErrorCode.GENERIC_TIMEOUT: {
      result = {
        type: "error",
        title: i18n4.str`Request timeout`,
        description: cause.message,
        debug: JSON.stringify(cause.errorDetail, void 0, 2),
        when: AbsoluteTime.now()
      };
      break;
    }
    case TalerErrorCode.GENERIC_CLIENT_INTERNAL_ERROR: {
      result = {
        type: "error",
        title: i18n4.str`Request cancelled`,
        description: cause.message,
        debug: JSON.stringify(cause.errorDetail, void 0, 2),
        when: AbsoluteTime.now()
      };
      break;
    }
    case TalerErrorCode.WALLET_HTTP_REQUEST_GENERIC_TIMEOUT: {
      result = {
        type: "error",
        title: i18n4.str`Request timeout`,
        description: cause.message,
        debug: JSON.stringify(cause.errorDetail, void 0, 2),
        when: AbsoluteTime.now()
      };
      break;
    }
    case TalerErrorCode.WALLET_HTTP_REQUEST_THROTTLED: {
      result = {
        type: "error",
        title: i18n4.str`Request throttled`,
        description: cause.message,
        debug: JSON.stringify(cause.errorDetail, void 0, 2),
        when: AbsoluteTime.now()
      };
      break;
    }
    case TalerErrorCode.WALLET_RECEIVED_MALFORMED_RESPONSE: {
      result = {
        type: "error",
        title: i18n4.str`Malformed response`,
        description: cause.message,
        debug: JSON.stringify(cause.errorDetail, void 0, 2),
        when: AbsoluteTime.now()
      };
      break;
    }
    case TalerErrorCode.WALLET_NETWORK_ERROR: {
      result = {
        type: "error",
        title: i18n4.str`Network error`,
        description: cause.message,
        debug: JSON.stringify(cause.errorDetail, void 0, 2),
        when: AbsoluteTime.now()
      };
      break;
    }
    case TalerErrorCode.WALLET_UNEXPECTED_REQUEST_ERROR: {
      result = {
        type: "error",
        title: i18n4.str`Unexpected request error`,
        description: cause.message,
        debug: JSON.stringify(cause.errorDetail, void 0, 2),
        when: AbsoluteTime.now()
      };
      break;
    }
    default: {
      result = {
        type: "error",
        title: i18n4.str`Unexpected error`,
        description: cause.message,
        debug: JSON.stringify(cause.errorDetail, void 0, 2),
        when: AbsoluteTime.now()
      };
      break;
    }
  }
  return result;
}
var formatDistanceLocale2 = {
  lessThanXSeconds: {
    standalone: {
      one: "weniger als 1 Sekunde",
      other: "weniger als {{count}} Sekunden"
    },
    withPreposition: {
      one: "weniger als 1 Sekunde",
      other: "weniger als {{count}} Sekunden"
    }
  },
  xSeconds: {
    standalone: {
      one: "1 Sekunde",
      other: "{{count}} Sekunden"
    },
    withPreposition: {
      one: "1 Sekunde",
      other: "{{count}} Sekunden"
    }
  },
  halfAMinute: {
    standalone: "halbe Minute",
    withPreposition: "halben Minute"
  },
  lessThanXMinutes: {
    standalone: {
      one: "weniger als 1 Minute",
      other: "weniger als {{count}} Minuten"
    },
    withPreposition: {
      one: "weniger als 1 Minute",
      other: "weniger als {{count}} Minuten"
    }
  },
  xMinutes: {
    standalone: {
      one: "1 Minute",
      other: "{{count}} Minuten"
    },
    withPreposition: {
      one: "1 Minute",
      other: "{{count}} Minuten"
    }
  },
  aboutXHours: {
    standalone: {
      one: "etwa 1 Stunde",
      other: "etwa {{count}} Stunden"
    },
    withPreposition: {
      one: "etwa 1 Stunde",
      other: "etwa {{count}} Stunden"
    }
  },
  xHours: {
    standalone: {
      one: "1 Stunde",
      other: "{{count}} Stunden"
    },
    withPreposition: {
      one: "1 Stunde",
      other: "{{count}} Stunden"
    }
  },
  xDays: {
    standalone: {
      one: "1 Tag",
      other: "{{count}} Tage"
    },
    withPreposition: {
      one: "1 Tag",
      other: "{{count}} Tagen"
    }
  },
  aboutXWeeks: {
    standalone: {
      one: "etwa 1 Woche",
      other: "etwa {{count}} Wochen"
    },
    withPreposition: {
      one: "etwa 1 Woche",
      other: "etwa {{count}} Wochen"
    }
  },
  xWeeks: {
    standalone: {
      one: "1 Woche",
      other: "{{count}} Wochen"
    },
    withPreposition: {
      one: "1 Woche",
      other: "{{count}} Wochen"
    }
  },
  aboutXMonths: {
    standalone: {
      one: "etwa 1 Monat",
      other: "etwa {{count}} Monate"
    },
    withPreposition: {
      one: "etwa 1 Monat",
      other: "etwa {{count}} Monaten"
    }
  },
  xMonths: {
    standalone: {
      one: "1 Monat",
      other: "{{count}} Monate"
    },
    withPreposition: {
      one: "1 Monat",
      other: "{{count}} Monaten"
    }
  },
  aboutXYears: {
    standalone: {
      one: "etwa 1 Jahr",
      other: "etwa {{count}} Jahre"
    },
    withPreposition: {
      one: "etwa 1 Jahr",
      other: "etwa {{count}} Jahren"
    }
  },
  xYears: {
    standalone: {
      one: "1 Jahr",
      other: "{{count}} Jahre"
    },
    withPreposition: {
      one: "1 Jahr",
      other: "{{count}} Jahren"
    }
  },
  overXYears: {
    standalone: {
      one: "mehr als 1 Jahr",
      other: "mehr als {{count}} Jahre"
    },
    withPreposition: {
      one: "mehr als 1 Jahr",
      other: "mehr als {{count}} Jahren"
    }
  },
  almostXYears: {
    standalone: {
      one: "fast 1 Jahr",
      other: "fast {{count}} Jahre"
    },
    withPreposition: {
      one: "fast 1 Jahr",
      other: "fast {{count}} Jahren"
    }
  }
};
var formatDistance3 = function formatDistance4(token, count, options) {
  var result;
  var tokenValue = options !== null && options !== void 0 && options.addSuffix ? formatDistanceLocale2[token].withPreposition : formatDistanceLocale2[token].standalone;
  if (typeof tokenValue === "string") {
    result = tokenValue;
  } else if (count === 1) {
    result = tokenValue.one;
  } else {
    result = tokenValue.other.replace("{{count}}", String(count));
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "in " + result;
    } else {
      return "vor " + result;
    }
  }
  return result;
};
var formatDistance_default2 = formatDistance3;
var dateFormats2 = {
  full: "EEEE, do MMMM y",
  // Montag, 7. Januar 2018
  long: "do MMMM y",
  // 7. Januar 2018
  medium: "do MMM y",
  // 7. Jan. 2018
  short: "dd.MM.y"
  // 07.01.2018
};
var timeFormats2 = {
  full: "HH:mm:ss zzzz",
  long: "HH:mm:ss z",
  medium: "HH:mm:ss",
  short: "HH:mm"
};
var dateTimeFormats2 = {
  full: "{{date}} 'um' {{time}}",
  long: "{{date}} 'um' {{time}}",
  medium: "{{date}} {{time}}",
  short: "{{date}} {{time}}"
};
var formatLong2 = {
  date: buildFormatLongFn({
    formats: dateFormats2,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn({
    formats: timeFormats2,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn({
    formats: dateTimeFormats2,
    defaultWidth: "full"
  })
};
var formatLong_default2 = formatLong2;
var formatRelativeLocale2 = {
  lastWeek: "'letzten' eeee 'um' p",
  yesterday: "'gestern um' p",
  today: "'heute um' p",
  tomorrow: "'morgen um' p",
  nextWeek: "eeee 'um' p",
  other: "P"
};
var formatRelative3 = function formatRelative4(token, _date, _baseDate, _options) {
  return formatRelativeLocale2[token];
};
var formatRelative_default2 = formatRelative3;
var eraValues2 = {
  narrow: ["v.Chr.", "n.Chr."],
  abbreviated: ["v.Chr.", "n.Chr."],
  wide: ["vor Christus", "nach Christus"]
};
var quarterValues2 = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["Q1", "Q2", "Q3", "Q4"],
  wide: ["1. Quartal", "2. Quartal", "3. Quartal", "4. Quartal"]
};
var monthValues2 = {
  narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
  abbreviated: ["Jan", "Feb", "M\xE4r", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"],
  wide: ["Januar", "Februar", "M\xE4rz", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]
};
var formattingMonthValues = {
  narrow: monthValues2.narrow,
  abbreviated: ["Jan.", "Feb.", "M\xE4rz", "Apr.", "Mai", "Juni", "Juli", "Aug.", "Sep.", "Okt.", "Nov.", "Dez."],
  wide: monthValues2.wide
};
var dayValues2 = {
  narrow: ["S", "M", "D", "M", "D", "F", "S"],
  short: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
  abbreviated: ["So.", "Mo.", "Di.", "Mi.", "Do.", "Fr.", "Sa."],
  wide: ["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]
};
var dayPeriodValues2 = {
  narrow: {
    am: "vm.",
    pm: "nm.",
    midnight: "Mitternacht",
    noon: "Mittag",
    morning: "Morgen",
    afternoon: "Nachm.",
    evening: "Abend",
    night: "Nacht"
  },
  abbreviated: {
    am: "vorm.",
    pm: "nachm.",
    midnight: "Mitternacht",
    noon: "Mittag",
    morning: "Morgen",
    afternoon: "Nachmittag",
    evening: "Abend",
    night: "Nacht"
  },
  wide: {
    am: "vormittags",
    pm: "nachmittags",
    midnight: "Mitternacht",
    noon: "Mittag",
    morning: "Morgen",
    afternoon: "Nachmittag",
    evening: "Abend",
    night: "Nacht"
  }
};
var formattingDayPeriodValues2 = {
  narrow: {
    am: "vm.",
    pm: "nm.",
    midnight: "Mitternacht",
    noon: "Mittag",
    morning: "morgens",
    afternoon: "nachm.",
    evening: "abends",
    night: "nachts"
  },
  abbreviated: {
    am: "vorm.",
    pm: "nachm.",
    midnight: "Mitternacht",
    noon: "Mittag",
    morning: "morgens",
    afternoon: "nachmittags",
    evening: "abends",
    night: "nachts"
  },
  wide: {
    am: "vormittags",
    pm: "nachmittags",
    midnight: "Mitternacht",
    noon: "Mittag",
    morning: "morgens",
    afternoon: "nachmittags",
    evening: "abends",
    night: "nachts"
  }
};
var ordinalNumber3 = function ordinalNumber4(dirtyNumber) {
  var number = Number(dirtyNumber);
  return number + ".";
};
var localize2 = {
  ordinalNumber: ordinalNumber3,
  era: buildLocalizeFn({
    values: eraValues2,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn({
    values: quarterValues2,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback2(quarter) {
      return quarter - 1;
    }
  }),
  month: buildLocalizeFn({
    values: monthValues2,
    formattingValues: formattingMonthValues,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn({
    values: dayValues2,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn({
    values: dayPeriodValues2,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues2,
    defaultFormattingWidth: "wide"
  })
};
var localize_default2 = localize2;
var matchOrdinalNumberPattern2 = /^(\d+)(\.)?/i;
var parseOrdinalNumberPattern2 = /\d+/i;
var matchEraPatterns2 = {
  narrow: /^(v\.? ?Chr\.?|n\.? ?Chr\.?)/i,
  abbreviated: /^(v\.? ?Chr\.?|n\.? ?Chr\.?)/i,
  wide: /^(vor Christus|vor unserer Zeitrechnung|nach Christus|unserer Zeitrechnung)/i
};
var parseEraPatterns2 = {
  any: [/^v/i, /^n/i]
};
var matchQuarterPatterns2 = {
  narrow: /^[1234]/i,
  abbreviated: /^q[1234]/i,
  wide: /^[1234](\.)? Quartal/i
};
var parseQuarterPatterns2 = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns2 = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(j[aä]n|feb|mär[z]?|apr|mai|jun[i]?|jul[i]?|aug|sep|okt|nov|dez)\.?/i,
  wide: /^(januar|februar|märz|april|mai|juni|juli|august|september|oktober|november|dezember)/i
};
var parseMonthPatterns2 = {
  narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
  any: [/^j[aä]/i, /^f/i, /^mär/i, /^ap/i, /^mai/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
};
var matchDayPatterns2 = {
  narrow: /^[smdmf]/i,
  short: /^(so|mo|di|mi|do|fr|sa)/i,
  abbreviated: /^(son?|mon?|die?|mit?|don?|fre?|sam?)\.?/i,
  wide: /^(sonntag|montag|dienstag|mittwoch|donnerstag|freitag|samstag)/i
};
var parseDayPatterns2 = {
  any: [/^so/i, /^mo/i, /^di/i, /^mi/i, /^do/i, /^f/i, /^sa/i]
};
var matchDayPeriodPatterns2 = {
  narrow: /^(vm\.?|nm\.?|Mitternacht|Mittag|morgens|nachm\.?|abends|nachts)/i,
  abbreviated: /^(vorm\.?|nachm\.?|Mitternacht|Mittag|morgens|nachm\.?|abends|nachts)/i,
  wide: /^(vormittags|nachmittags|Mitternacht|Mittag|morgens|nachmittags|abends|nachts)/i
};
var parseDayPeriodPatterns2 = {
  any: {
    am: /^v/i,
    pm: /^n/i,
    midnight: /^Mitte/i,
    noon: /^Mitta/i,
    morning: /morgens/i,
    afternoon: /nachmittags/i,
    // will never be matched. Afternoon is matched by `pm`
    evening: /abends/i,
    night: /nachts/i
    // will never be matched. Night is matched by `pm`
  }
};
var match2 = {
  ordinalNumber: buildMatchPatternFn({
    matchPattern: matchOrdinalNumberPattern2,
    parsePattern: parseOrdinalNumberPattern2,
    valueCallback: function valueCallback3(value) {
      return parseInt(value);
    }
  }),
  era: buildMatchFn({
    matchPatterns: matchEraPatterns2,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns2,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn({
    matchPatterns: matchQuarterPatterns2,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns2,
    defaultParseWidth: "any",
    valueCallback: function valueCallback4(index) {
      return index + 1;
    }
  }),
  month: buildMatchFn({
    matchPatterns: matchMonthPatterns2,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns2,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn({
    matchPatterns: matchDayPatterns2,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns2,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn({
    matchPatterns: matchDayPeriodPatterns2,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPeriodPatterns2,
    defaultParseWidth: "any"
  })
};
var match_default2 = match2;
var locale2 = {
  code: "de",
  formatDistance: formatDistance_default2,
  formatLong: formatLong_default2,
  formatRelative: formatRelative_default2,
  localize: localize_default2,
  match: match_default2,
  options: {
    weekStartsOn: 1,
    firstWeekContainsDate: 4
  }
};
var de_default = locale2;
var dateFormats3 = {
  full: "EEEE, d MMMM yyyy",
  long: "d MMMM yyyy",
  medium: "d MMM yyyy",
  short: "dd/MM/yyyy"
};
var timeFormats3 = {
  full: "HH:mm:ss zzzz",
  long: "HH:mm:ss z",
  medium: "HH:mm:ss",
  short: "HH:mm"
};
var dateTimeFormats3 = {
  full: "{{date}} 'at' {{time}}",
  long: "{{date}} 'at' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong3 = {
  date: buildFormatLongFn({
    formats: dateFormats3,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn({
    formats: timeFormats3,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn({
    formats: dateTimeFormats3,
    defaultWidth: "full"
  })
};
var formatLong_default3 = formatLong3;
var locale3 = {
  code: "en-GB",
  formatDistance: formatDistance_default,
  formatLong: formatLong_default3,
  formatRelative: formatRelative_default,
  localize: localize_default,
  match: match_default,
  options: {
    weekStartsOn: 1,
    firstWeekContainsDate: 4
  }
};
var en_GB_default = locale3;
var formatDistanceLocale3 = {
  lessThanXSeconds: {
    one: "menos de un segundo",
    other: "menos de {{count}} segundos"
  },
  xSeconds: {
    one: "1 segundo",
    other: "{{count}} segundos"
  },
  halfAMinute: "medio minuto",
  lessThanXMinutes: {
    one: "menos de un minuto",
    other: "menos de {{count}} minutos"
  },
  xMinutes: {
    one: "1 minuto",
    other: "{{count}} minutos"
  },
  aboutXHours: {
    one: "alrededor de 1 hora",
    other: "alrededor de {{count}} horas"
  },
  xHours: {
    one: "1 hora",
    other: "{{count}} horas"
  },
  xDays: {
    one: "1 d\xEDa",
    other: "{{count}} d\xEDas"
  },
  aboutXWeeks: {
    one: "alrededor de 1 semana",
    other: "alrededor de {{count}} semanas"
  },
  xWeeks: {
    one: "1 semana",
    other: "{{count}} semanas"
  },
  aboutXMonths: {
    one: "alrededor de 1 mes",
    other: "alrededor de {{count}} meses"
  },
  xMonths: {
    one: "1 mes",
    other: "{{count}} meses"
  },
  aboutXYears: {
    one: "alrededor de 1 a\xF1o",
    other: "alrededor de {{count}} a\xF1os"
  },
  xYears: {
    one: "1 a\xF1o",
    other: "{{count}} a\xF1os"
  },
  overXYears: {
    one: "m\xE1s de 1 a\xF1o",
    other: "m\xE1s de {{count}} a\xF1os"
  },
  almostXYears: {
    one: "casi 1 a\xF1o",
    other: "casi {{count}} a\xF1os"
  }
};
var formatDistance5 = function formatDistance6(token, count, options) {
  var result;
  var tokenValue = formatDistanceLocale3[token];
  if (typeof tokenValue === "string") {
    result = tokenValue;
  } else if (count === 1) {
    result = tokenValue.one;
  } else {
    result = tokenValue.other.replace("{{count}}", count.toString());
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "en " + result;
    } else {
      return "hace " + result;
    }
  }
  return result;
};
var formatDistance_default3 = formatDistance5;
var dateFormats4 = {
  full: "EEEE, d 'de' MMMM 'de' y",
  long: "d 'de' MMMM 'de' y",
  medium: "d MMM y",
  short: "dd/MM/y"
};
var timeFormats4 = {
  full: "HH:mm:ss zzzz",
  long: "HH:mm:ss z",
  medium: "HH:mm:ss",
  short: "HH:mm"
};
var dateTimeFormats4 = {
  full: "{{date}} 'a las' {{time}}",
  long: "{{date}} 'a las' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong4 = {
  date: buildFormatLongFn({
    formats: dateFormats4,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn({
    formats: timeFormats4,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn({
    formats: dateTimeFormats4,
    defaultWidth: "full"
  })
};
var formatLong_default4 = formatLong4;
var formatRelativeLocale3 = {
  lastWeek: "'el' eeee 'pasado a la' p",
  yesterday: "'ayer a la' p",
  today: "'hoy a la' p",
  tomorrow: "'ma\xF1ana a la' p",
  nextWeek: "eeee 'a la' p",
  other: "P"
};
var formatRelativeLocalePlural = {
  lastWeek: "'el' eeee 'pasado a las' p",
  yesterday: "'ayer a las' p",
  today: "'hoy a las' p",
  tomorrow: "'ma\xF1ana a las' p",
  nextWeek: "eeee 'a las' p",
  other: "P"
};
var formatRelative5 = function formatRelative6(token, date, _baseDate, _options) {
  if (date.getUTCHours() !== 1) {
    return formatRelativeLocalePlural[token];
  } else {
    return formatRelativeLocale3[token];
  }
};
var formatRelative_default3 = formatRelative5;
var eraValues3 = {
  narrow: ["AC", "DC"],
  abbreviated: ["AC", "DC"],
  wide: ["antes de cristo", "despu\xE9s de cristo"]
};
var quarterValues3 = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["T1", "T2", "T3", "T4"],
  wide: ["1\xBA trimestre", "2\xBA trimestre", "3\xBA trimestre", "4\xBA trimestre"]
};
var monthValues3 = {
  narrow: ["e", "f", "m", "a", "m", "j", "j", "a", "s", "o", "n", "d"],
  abbreviated: ["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"],
  wide: ["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]
};
var dayValues3 = {
  narrow: ["d", "l", "m", "m", "j", "v", "s"],
  short: ["do", "lu", "ma", "mi", "ju", "vi", "s\xE1"],
  abbreviated: ["dom", "lun", "mar", "mi\xE9", "jue", "vie", "s\xE1b"],
  wide: ["domingo", "lunes", "martes", "mi\xE9rcoles", "jueves", "viernes", "s\xE1bado"]
};
var dayPeriodValues3 = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mn",
    noon: "md",
    morning: "ma\xF1ana",
    afternoon: "tarde",
    evening: "tarde",
    night: "noche"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "medianoche",
    noon: "mediodia",
    morning: "ma\xF1ana",
    afternoon: "tarde",
    evening: "tarde",
    night: "noche"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "medianoche",
    noon: "mediodia",
    morning: "ma\xF1ana",
    afternoon: "tarde",
    evening: "tarde",
    night: "noche"
  }
};
var formattingDayPeriodValues3 = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mn",
    noon: "md",
    morning: "de la ma\xF1ana",
    afternoon: "de la tarde",
    evening: "de la tarde",
    night: "de la noche"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "medianoche",
    noon: "mediodia",
    morning: "de la ma\xF1ana",
    afternoon: "de la tarde",
    evening: "de la tarde",
    night: "de la noche"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "medianoche",
    noon: "mediodia",
    morning: "de la ma\xF1ana",
    afternoon: "de la tarde",
    evening: "de la tarde",
    night: "de la noche"
  }
};
var ordinalNumber5 = function ordinalNumber6(dirtyNumber, _options) {
  var number = Number(dirtyNumber);
  return number + "\xBA";
};
var localize3 = {
  ordinalNumber: ordinalNumber5,
  era: buildLocalizeFn({
    values: eraValues3,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn({
    values: quarterValues3,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback3(quarter) {
      return Number(quarter) - 1;
    }
  }),
  month: buildLocalizeFn({
    values: monthValues3,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn({
    values: dayValues3,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn({
    values: dayPeriodValues3,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues3,
    defaultFormattingWidth: "wide"
  })
};
var localize_default3 = localize3;
var matchOrdinalNumberPattern3 = /^(\d+)(º)?/i;
var parseOrdinalNumberPattern3 = /\d+/i;
var matchEraPatterns3 = {
  narrow: /^(ac|dc|a|d)/i,
  abbreviated: /^(a\.?\s?c\.?|a\.?\s?e\.?\s?c\.?|d\.?\s?c\.?|e\.?\s?c\.?)/i,
  wide: /^(antes de cristo|antes de la era com[uú]n|despu[eé]s de cristo|era com[uú]n)/i
};
var parseEraPatterns3 = {
  any: [/^ac/i, /^dc/i],
  wide: [/^(antes de cristo|antes de la era com[uú]n)/i, /^(despu[eé]s de cristo|era com[uú]n)/i]
};
var matchQuarterPatterns3 = {
  narrow: /^[1234]/i,
  abbreviated: /^T[1234]/i,
  wide: /^[1234](º)? trimestre/i
};
var parseQuarterPatterns3 = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns3 = {
  narrow: /^[efmajsond]/i,
  abbreviated: /^(ene|feb|mar|abr|may|jun|jul|ago|sep|oct|nov|dic)/i,
  wide: /^(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre)/i
};
var parseMonthPatterns3 = {
  narrow: [/^e/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
  any: [/^en/i, /^feb/i, /^mar/i, /^abr/i, /^may/i, /^jun/i, /^jul/i, /^ago/i, /^sep/i, /^oct/i, /^nov/i, /^dic/i]
};
var matchDayPatterns3 = {
  narrow: /^[dlmjvs]/i,
  short: /^(do|lu|ma|mi|ju|vi|s[áa])/i,
  abbreviated: /^(dom|lun|mar|mi[ée]|jue|vie|s[áa]b)/i,
  wide: /^(domingo|lunes|martes|mi[ée]rcoles|jueves|viernes|s[áa]bado)/i
};
var parseDayPatterns3 = {
  narrow: [/^d/i, /^l/i, /^m/i, /^m/i, /^j/i, /^v/i, /^s/i],
  any: [/^do/i, /^lu/i, /^ma/i, /^mi/i, /^ju/i, /^vi/i, /^sa/i]
};
var matchDayPeriodPatterns3 = {
  narrow: /^(a|p|mn|md|(de la|a las) (mañana|tarde|noche))/i,
  any: /^([ap]\.?\s?m\.?|medianoche|mediodia|(de la|a las) (mañana|tarde|noche))/i
};
var parseDayPeriodPatterns3 = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mn/i,
    noon: /^md/i,
    morning: /mañana/i,
    afternoon: /tarde/i,
    evening: /tarde/i,
    night: /noche/i
  }
};
var match3 = {
  ordinalNumber: buildMatchPatternFn({
    matchPattern: matchOrdinalNumberPattern3,
    parsePattern: parseOrdinalNumberPattern3,
    valueCallback: function valueCallback5(value) {
      return parseInt(value, 10);
    }
  }),
  era: buildMatchFn({
    matchPatterns: matchEraPatterns3,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns3,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn({
    matchPatterns: matchQuarterPatterns3,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns3,
    defaultParseWidth: "any",
    valueCallback: function valueCallback6(index) {
      return index + 1;
    }
  }),
  month: buildMatchFn({
    matchPatterns: matchMonthPatterns3,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns3,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn({
    matchPatterns: matchDayPatterns3,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns3,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn({
    matchPatterns: matchDayPeriodPatterns3,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns3,
    defaultParseWidth: "any"
  })
};
var match_default3 = match3;
var locale4 = {
  code: "es",
  formatDistance: formatDistance_default3,
  formatLong: formatLong_default4,
  formatRelative: formatRelative_default3,
  localize: localize_default3,
  match: match_default3,
  options: {
    weekStartsOn: 1,
    firstWeekContainsDate: 1
  }
};
var es_default = locale4;
var formatDistanceLocale4 = {
  lessThanXSeconds: {
    one: "moins d\u2019une seconde",
    other: "moins de {{count}} secondes"
  },
  xSeconds: {
    one: "1 seconde",
    other: "{{count}} secondes"
  },
  halfAMinute: "30 secondes",
  lessThanXMinutes: {
    one: "moins d\u2019une minute",
    other: "moins de {{count}} minutes"
  },
  xMinutes: {
    one: "1 minute",
    other: "{{count}} minutes"
  },
  aboutXHours: {
    one: "environ 1 heure",
    other: "environ {{count}} heures"
  },
  xHours: {
    one: "1 heure",
    other: "{{count}} heures"
  },
  xDays: {
    one: "1 jour",
    other: "{{count}} jours"
  },
  aboutXWeeks: {
    one: "environ 1 semaine",
    other: "environ {{count}} semaines"
  },
  xWeeks: {
    one: "1 semaine",
    other: "{{count}} semaines"
  },
  aboutXMonths: {
    one: "environ 1 mois",
    other: "environ {{count}} mois"
  },
  xMonths: {
    one: "1 mois",
    other: "{{count}} mois"
  },
  aboutXYears: {
    one: "environ 1 an",
    other: "environ {{count}} ans"
  },
  xYears: {
    one: "1 an",
    other: "{{count}} ans"
  },
  overXYears: {
    one: "plus d\u2019un an",
    other: "plus de {{count}} ans"
  },
  almostXYears: {
    one: "presqu\u2019un an",
    other: "presque {{count}} ans"
  }
};
var formatDistance7 = function formatDistance8(token, count, options) {
  var result;
  var form = formatDistanceLocale4[token];
  if (typeof form === "string") {
    result = form;
  } else if (count === 1) {
    result = form.one;
  } else {
    result = form.other.replace("{{count}}", String(count));
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "dans " + result;
    } else {
      return "il y a " + result;
    }
  }
  return result;
};
var formatDistance_default4 = formatDistance7;
var dateFormats5 = {
  full: "EEEE d MMMM y",
  long: "d MMMM y",
  medium: "d MMM y",
  short: "dd/MM/y"
};
var timeFormats5 = {
  full: "HH:mm:ss zzzz",
  long: "HH:mm:ss z",
  medium: "HH:mm:ss",
  short: "HH:mm"
};
var dateTimeFormats5 = {
  full: "{{date}} '\xE0' {{time}}",
  long: "{{date}} '\xE0' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong5 = {
  date: buildFormatLongFn({
    formats: dateFormats5,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn({
    formats: timeFormats5,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn({
    formats: dateTimeFormats5,
    defaultWidth: "full"
  })
};
var formatLong_default5 = formatLong5;
var formatRelativeLocale4 = {
  lastWeek: "eeee 'dernier \xE0' p",
  yesterday: "'hier \xE0' p",
  today: "'aujourd\u2019hui \xE0' p",
  tomorrow: "'demain \xE0' p'",
  nextWeek: "eeee 'prochain \xE0' p",
  other: "P"
};
var formatRelative7 = function formatRelative8(token, _date, _baseDate, _options) {
  return formatRelativeLocale4[token];
};
var formatRelative_default4 = formatRelative7;
var eraValues4 = {
  narrow: ["av. J.-C", "ap. J.-C"],
  abbreviated: ["av. J.-C", "ap. J.-C"],
  wide: ["avant J\xE9sus-Christ", "apr\xE8s J\xE9sus-Christ"]
};
var quarterValues4 = {
  narrow: ["T1", "T2", "T3", "T4"],
  abbreviated: ["1er trim.", "2\xE8me trim.", "3\xE8me trim.", "4\xE8me trim."],
  wide: ["1er trimestre", "2\xE8me trimestre", "3\xE8me trimestre", "4\xE8me trimestre"]
};
var monthValues4 = {
  narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
  abbreviated: ["janv.", "f\xE9vr.", "mars", "avr.", "mai", "juin", "juil.", "ao\xFBt", "sept.", "oct.", "nov.", "d\xE9c."],
  wide: ["janvier", "f\xE9vrier", "mars", "avril", "mai", "juin", "juillet", "ao\xFBt", "septembre", "octobre", "novembre", "d\xE9cembre"]
};
var dayValues4 = {
  narrow: ["D", "L", "M", "M", "J", "V", "S"],
  short: ["di", "lu", "ma", "me", "je", "ve", "sa"],
  abbreviated: ["dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam."],
  wide: ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"]
};
var dayPeriodValues4 = {
  narrow: {
    am: "AM",
    pm: "PM",
    midnight: "minuit",
    noon: "midi",
    morning: "mat.",
    afternoon: "ap.m.",
    evening: "soir",
    night: "mat."
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "minuit",
    noon: "midi",
    morning: "matin",
    afternoon: "apr\xE8s-midi",
    evening: "soir",
    night: "matin"
  },
  wide: {
    am: "AM",
    pm: "PM",
    midnight: "minuit",
    noon: "midi",
    morning: "du matin",
    afternoon: "de l\u2019apr\xE8s-midi",
    evening: "du soir",
    night: "du matin"
  }
};
var ordinalNumber7 = function ordinalNumber8(dirtyNumber, options) {
  var number = Number(dirtyNumber);
  var unit = options === null || options === void 0 ? void 0 : options.unit;
  if (number === 0)
    return "0";
  var feminineUnits = ["year", "week", "hour", "minute", "second"];
  var suffix;
  if (number === 1) {
    suffix = unit && feminineUnits.includes(unit) ? "\xE8re" : "er";
  } else {
    suffix = "\xE8me";
  }
  return number + suffix;
};
var localize4 = {
  ordinalNumber: ordinalNumber7,
  era: buildLocalizeFn({
    values: eraValues4,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn({
    values: quarterValues4,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback4(quarter) {
      return quarter - 1;
    }
  }),
  month: buildLocalizeFn({
    values: monthValues4,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn({
    values: dayValues4,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn({
    values: dayPeriodValues4,
    defaultWidth: "wide"
  })
};
var localize_default4 = localize4;
var matchOrdinalNumberPattern4 = /^(\d+)(ième|ère|ème|er|e)?/i;
var parseOrdinalNumberPattern4 = /\d+/i;
var matchEraPatterns4 = {
  narrow: /^(av\.J\.C|ap\.J\.C|ap\.J\.-C)/i,
  abbreviated: /^(av\.J\.-C|av\.J-C|apr\.J\.-C|apr\.J-C|ap\.J-C)/i,
  wide: /^(avant Jésus-Christ|après Jésus-Christ)/i
};
var parseEraPatterns4 = {
  any: [/^av/i, /^ap/i]
};
var matchQuarterPatterns4 = {
  narrow: /^T?[1234]/i,
  abbreviated: /^[1234](er|ème|e)? trim\.?/i,
  wide: /^[1234](er|ème|e)? trimestre/i
};
var parseQuarterPatterns4 = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns4 = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(janv|févr|mars|avr|mai|juin|juill|juil|août|sept|oct|nov|déc)\.?/i,
  wide: /^(janvier|février|mars|avril|mai|juin|juillet|août|septembre|octobre|novembre|décembre)/i
};
var parseMonthPatterns4 = {
  narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
  any: [/^ja/i, /^f/i, /^mar/i, /^av/i, /^ma/i, /^juin/i, /^juil/i, /^ao/i, /^s/i, /^o/i, /^n/i, /^d/i]
};
var matchDayPatterns4 = {
  narrow: /^[lmjvsd]/i,
  short: /^(di|lu|ma|me|je|ve|sa)/i,
  abbreviated: /^(dim|lun|mar|mer|jeu|ven|sam)\.?/i,
  wide: /^(dimanche|lundi|mardi|mercredi|jeudi|vendredi|samedi)/i
};
var parseDayPatterns4 = {
  narrow: [/^d/i, /^l/i, /^m/i, /^m/i, /^j/i, /^v/i, /^s/i],
  any: [/^di/i, /^lu/i, /^ma/i, /^me/i, /^je/i, /^ve/i, /^sa/i]
};
var matchDayPeriodPatterns4 = {
  narrow: /^(a|p|minuit|midi|mat\.?|ap\.?m\.?|soir|nuit)/i,
  any: /^([ap]\.?\s?m\.?|du matin|de l'après[-\s]midi|du soir|de la nuit)/i
};
var parseDayPeriodPatterns4 = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^min/i,
    noon: /^mid/i,
    morning: /mat/i,
    afternoon: /ap/i,
    evening: /soir/i,
    night: /nuit/i
  }
};
var match4 = {
  ordinalNumber: buildMatchPatternFn({
    matchPattern: matchOrdinalNumberPattern4,
    parsePattern: parseOrdinalNumberPattern4,
    valueCallback: function valueCallback7(value) {
      return parseInt(value);
    }
  }),
  era: buildMatchFn({
    matchPatterns: matchEraPatterns4,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns4,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn({
    matchPatterns: matchQuarterPatterns4,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns4,
    defaultParseWidth: "any",
    valueCallback: function valueCallback8(index) {
      return index + 1;
    }
  }),
  month: buildMatchFn({
    matchPatterns: matchMonthPatterns4,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns4,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn({
    matchPatterns: matchDayPatterns4,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns4,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn({
    matchPatterns: matchDayPeriodPatterns4,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns4,
    defaultParseWidth: "any"
  })
};
var match_default4 = match4;
var locale5 = {
  code: "fr",
  formatDistance: formatDistance_default4,
  formatLong: formatLong_default5,
  formatRelative: formatRelative_default4,
  localize: localize_default4,
  match: match_default4,
  options: {
    weekStartsOn: 1,
    firstWeekContainsDate: 4
  }
};
var fr_default = locale5;
var supportedLang = {
  es: "Espanol [es]",
  en: "English [en]",
  fr: "Francais [fr]",
  de: "Deutsch [de]",
  sv: "Svenska [sv]",
  it: "Italiane [it]"
};
var initial = {
  lang: "en",
  supportedLang,
  changeLanguage: () => {
  },
  i18n,
  dateLocale: en_GB_default,
  completeness: {
    de: 0,
    en: 0,
    es: 0,
    fr: 0,
    it: 0,
    sv: 0
  }
};
var Context2 = B(initial);
var TranslationProvider = ({
  initial: initial22,
  children,
  forceLang__testing: forceLang,
  source,
  completeness: completenessProp
}) => {
  const completeness = {
    en: 100,
    de: !completenessProp || !completenessProp["de"] ? 0 : completenessProp["de"],
    es: !completenessProp || !completenessProp["es"] ? 0 : completenessProp["es"],
    fr: !completenessProp || !completenessProp["fr"] ? 0 : completenessProp["fr"],
    it: !completenessProp || !completenessProp["it"] ? 0 : completenessProp["it"],
    sv: !completenessProp || !completenessProp["sv"] ? 0 : completenessProp["sv"]
  };
  const { value: lang, update: changeLanguage } = useLang(
    initial22,
    completeness
  );
  h2(() => {
    if (forceLang) {
      changeLanguage(forceLang);
    }
  }, [forceLang]);
  h2(() => {
    setupI18n(lang, source);
  }, [lang]);
  if (forceLang) {
    setupI18n(forceLang, source);
  } else {
    setupI18n(lang, source);
  }
  const dateLocale = lang === "es" ? es_default : lang === "fr" ? fr_default : lang === "de" ? de_default : en_GB_default;
  return h(Context2.Provider, {
    value: {
      lang,
      changeLanguage,
      supportedLang,
      i18n,
      dateLocale,
      completeness
    },
    children
  });
};
var useTranslationContext = () => q2(Context2);
var ActiviyTracker = class {
  constructor() {
    this.observers = new Array();
    this.notify = this.notify.bind(this);
    this.subscribe = this.subscribe.bind(this);
  }
  notify(data) {
    this.observers.forEach((observer) => observer(data));
  }
  subscribe(func) {
    this.observers.push(func);
    return () => {
      this.observers.forEach((observer, index) => {
        if (observer === func) {
          this.observers.splice(index, 1);
        }
      });
    };
  }
};
var BankContext = B(void 0);
var ChallengerContext = B(void 0);
var MerchantContext = B(void 0);
var ExchangeContext = B(void 0);
var useExchangeApiContext = () => q2(ExchangeContext);
var CONFIG_FAIL_TRY_AGAIN_MS4 = 5e3;
var ExchangeApiProvider = ({
  baseUrl,
  children,
  evictors = {},
  frameOnError,
  preventCompression
}) => {
  const [checked, setChecked] = p3();
  const { i18n: i18n4 } = useTranslationContext();
  const { getRemoteConfig, VERSION: VERSION2, lib, cancelRequest, onActivity } = buildExchangeApiClient(baseUrl, evictors, !!preventCompression);
  h2(() => {
    let keepRetrying = true;
    async function testConfig() {
      try {
        const config = await getRemoteConfig();
        if (LibtoolVersion.compare(VERSION2, config.config.version)) {
          setChecked({ type: "ok", config, hints: [] });
        } else {
          setChecked({
            type: "incompatible",
            result: config,
            supported: VERSION2
          });
        }
      } catch (error2) {
        if (error2 instanceof TalerError) {
          if (keepRetrying) {
            setTimeout(() => {
              testConfig();
            }, CONFIG_FAIL_TRY_AGAIN_MS4);
          }
          setChecked({ type: "error", error: error2 });
        } else {
          setChecked({ type: "error", error: TalerError.fromException(error2) });
        }
      }
    }
    testConfig();
    return () => {
      keepRetrying = false;
    };
  }, []);
  if (checked === void 0) {
    return h(frameOnError, {
      children: h("div", {}, "checking compatibility with server...")
    });
  }
  if (checked.type === "error") {
    return h(frameOnError, {
      children: h(ErrorLoading, { error: checked.error, showDetail: true })
    });
  }
  if (checked.type === "incompatible") {
    return h(frameOnError, {
      children: h(
        "div",
        {},
        i18n4.str`The server version is not supported. Supported version "${checked.supported}", server version "${checked.result.config.version}"`
      )
    });
  }
  const { lib: unthrottledApi } = buildExchangeApiClient(
    baseUrl,
    evictors,
    !!preventCompression,
    true
  );
  const value = {
    url: baseUrl,
    config: checked.config,
    onActivity,
    lib,
    unthrottledApi,
    cancelRequest,
    hints: checked.hints
  };
  return h(ExchangeContext.Provider, {
    value,
    children
  });
};
function buildExchangeApiClient(url, evictors, preventCompression, disableThrottling) {
  const httpFetch = new BrowserFetchHttpLib({
    enableThrottling: !disableThrottling,
    requireTls: false
  });
  const tracker = new ActiviyTracker();
  const httpLib = new ObservableHttpClientLibrary(httpFetch, {
    observe(ev) {
      tracker.notify(ev);
    }
  });
  const ex = new TalerExchangeHttpClient(url.href, {
    httpClient: httpLib,
    cacheEvictor: evictors.exchange,
    preventCompression
  });
  async function getRemoteConfig() {
    const configResp = await ex.getConfig();
    if (configResp.type === "fail") {
      if (configResp.detail) {
        throw TalerError.fromUncheckedDetail(configResp.detail);
      } else {
        throw TalerError.fromException(
          new Error("failed to get exchange remote config")
        );
      }
    }
    const keysResp = await ex.getKeys();
    return {
      config: configResp.body,
      keys: keysResp.body
    };
  }
  return {
    getRemoteConfig,
    VERSION: TalerExchangeHttpClient.SUPPORTED_EXCHANGE_PROTOCOL_VERSION,
    lib: {
      exchange: ex
    },
    onActivity: tracker.subscribe,
    cancelRequest: httpLib.cancelRequest
  };
}
function urlPattern(pattern, reverse) {
  const url = reverse;
  return {
    pattern: new RegExp(pattern),
    url
  };
}
var nullRountDef = {
  pattern: new RegExp(/.*/),
  url: () => ""
};
function findMatch(pagesMap, pageList, path, params) {
  for (let idx = 0; idx < pageList.length; idx++) {
    const name = pageList[idx];
    const found = pagesMap[name].pattern.exec(path);
    if (found !== null) {
      const values = {};
      if (found.groups !== void 0) {
        Object.entries(found.groups).forEach(([key, value]) => {
          values[key] = value;
        });
      }
      return { name, parent: pagesMap, values, params };
    }
  }
  return { name: void 0, parent: pagesMap, values: {}, params };
}
var Context3 = B(void 0);
var useNavigationContext = () => q2(Context3);
function useCurrentLocation(pagesMap) {
  const pageList = Object.keys(pagesMap);
  const { path, params } = useNavigationContext();
  return findMatch(pagesMap, pageList, path, params);
}
function getPathAndParamsFromWindow() {
  const path = typeof window !== "undefined" ? window.location.hash.substring(1) : "/";
  const params = {};
  if (typeof window !== "undefined") {
    for (const [key, value] of new URLSearchParams(window.location.search)) {
      if (!params[key]) {
        params[key] = [];
      }
      params[key].push(value);
    }
  }
  return { path, params };
}
var { path: initialPath, params: initialParams } = getPathAndParamsFromWindow();
var PopStateEventType = "popstate";
var BrowserHashNavigationProvider = ({
  children
}) => {
  const [{ path, params }, setState] = p3({
    path: initialPath,
    params: initialParams
  });
  if (typeof window === "undefined") {
    throw Error(
      "Can't use BrowserHashNavigationProvider if there is no window object"
    );
  }
  function navigateTo(path2) {
    const { params: params2 } = getPathAndParamsFromWindow();
    setState({ path: path2, params: params2 });
    window.location.href = path2;
  }
  h2(() => {
    function eventListener() {
      setState(getPathAndParamsFromWindow());
    }
    window.addEventListener(PopStateEventType, eventListener);
    return () => {
      window.removeEventListener(PopStateEventType, eventListener);
    };
  }, []);
  return h(Context3.Provider, {
    value: { path, params, navigateTo },
    children
  });
};
function createHeadMetaTag(uri, onNotFound) {
  const meta = document.createElement("meta");
  meta.setAttribute("name", "taler-uri");
  meta.setAttribute("content", stringifyTalerUri(uri));
  document.head.appendChild(meta);
  let walletFound = false;
  window.addEventListener("beforeunload", () => {
    walletFound = true;
  });
  setTimeout(() => {
    if (!walletFound && onNotFound) {
      onNotFound();
    }
  }, 10);
}
var Context4 = B(void 0);
var TalerWalletIntegrationBrowserProvider = ({
  children
}) => {
  const value = {
    publishTalerAction: createHeadMetaTag
  };
  return h(Context4.Provider, {
    value,
    children
  });
};
function acceptTos(i18n4, context) {
  const myFields = [];
  if (context.link_only) {
    myFields.push({
      type: "external-link",
      id: TalerFormAttributes.DOWNLOADED_TERMS_OF_SERVICE,
      required: true,
      url: context.tos_url,
      label: i18n4.str`Terms of service`,
      help: i18n4.str`You must open/download the terms of service to proceed`
    });
  } else {
    myFields.push(
      {
        type: "external-link",
        id: TalerFormAttributes.DOWNLOADED_TERMS_OF_SERVICE,
        required: true,
        url: context.tos_url,
        label: i18n4.str`View in Browser`
      },
      {
        type: "download-link",
        id: TalerFormAttributes.DOWNLOADED_TERMS_OF_SERVICE,
        url: context.tos_url,
        label: i18n4.str`Download PDF version`,
        required: true,
        media: "application/pdf",
        help: i18n4.str`You must download to proceed`
      }
    );
  }
  return {
    type: "single-column",
    fields: [
      ...myFields,
      {
        type: "toggle",
        id: TalerFormAttributes.ACCEPTED_TERMS_OF_SERVICE,
        required: true,
        trueValue: context.tos_version ?? context.tosVersion,
        onlyTrueValue: true,
        label: i18n4.str`Do you accept the terms of service?`
      }
    ]
  };
}
var form_challenger_email = (i18n4) => ({
  label: i18n4.str`Challenger EMAIL`,
  description: i18n4.str`Challenge email ownership.`,
  id: "challenger-email",
  version: 0,
  config: design_challenger_email(i18n4)
});
function design_challenger_email(i18n4) {
  const today = format(/* @__PURE__ */ new Date(), "yyyy-MM-dd");
  return {
    type: "single-column",
    fields: [
      {
        id: TalerFormAttributes.CONTACT_EMAIL,
        label: i18n4.str`E-Mail`,
        type: "text",
        required: true,
        disabled: true
      }
    ]
  };
}
var form_challenger_postal = (i18n4) => ({
  label: i18n4.str`Challenger POSTAL`,
  description: i18n4.str`Challenge address ownership.`,
  id: "challenger-postal",
  version: 0,
  config: design_challenger_postal(i18n4)
});
function design_challenger_postal(i18n4) {
  const today = format(/* @__PURE__ */ new Date(), "yyyy-MM-dd");
  return {
    type: "single-column",
    fields: [
      {
        id: TalerFormAttributes.CONTACT_NAME,
        label: i18n4.str`Name`,
        type: "text",
        required: true,
        disabled: true
      },
      {
        id: TalerFormAttributes.ADDRESS_LINES,
        label: i18n4.str`Address`,
        type: "textArea",
        required: true,
        disabled: true
      },
      {
        id: TalerFormAttributes.ADDRESS_COUNTRY,
        label: i18n4.str`Country`,
        type: "selectOne",
        choices: countryNameList(i18n4),
        required: true,
        disabled: true
      }
    ]
  };
}
var form_challenger_sms = (i18n4) => ({
  label: i18n4.str`Challenger SMS`,
  description: i18n4.str`Challenge phone number ownership.`,
  id: "challenger-sms",
  version: 0,
  config: design_challenger_phone(i18n4)
});
function design_challenger_phone(i18n4) {
  const today = format(/* @__PURE__ */ new Date(), "yyyy-MM-dd");
  return {
    type: "single-column",
    fields: [
      {
        id: TalerFormAttributes.CONTACT_PHONE,
        label: i18n4.str`Phone`,
        type: "text",
        required: true,
        disabled: true
      }
    ]
  };
}
var form_generic_note = (i18n4) => ({
  label: i18n4.str`Generic note`,
  description: i18n4.str`Free-form, generic note`,
  id: "generic_note",
  version: 1,
  config: design_generic_note(i18n4)
});
function design_generic_note(i18n4) {
  const today = format(/* @__PURE__ */ new Date(), "yyyy-MM-dd");
  return {
    type: "double-column",
    sections: [
      {
        title: i18n4.str`Note / Memorandum`,
        fields: [
          {
            id: TalerFormAttributes.NOTE_TEXT,
            label: i18n4.str`Free-form notes`,
            type: "textArea",
            required: true
          }
        ]
      },
      {
        title: i18n4.str`Supplemental File Upload`,
        description: i18n4.str`Optional supplemental information for the establishment of the business relationship with the customer.`,
        fields: [
          {
            id: TalerFormAttributes.SUPPLEMENTAL_FILES_LIST,
            label: i18n4.str`Supplemental Files`,
            type: "array",
            labelFieldId: "FILE.FILENAME",
            required: false,
            fields: [
              {
                id: TalerFormAttributes.DESCRIPTION,
                label: i18n4.str`Description`,
                type: "textArea",
                required: true
              },
              {
                id: TalerFormAttributes.FILE,
                label: i18n4.str`File (PDF)`,
                type: "file",
                accept: "application/pdf",
                required: true
              }
            ]
          }
        ]
      }
    ]
  };
}
function countryNameList(i18n4) {
  return Object.entries(countryNamesByCode).map(([value, translator]) => ({
    value,
    label: translator(i18n4)
  }));
}
function countryNationalityList(i18n4) {
  return Object.entries(countryNationalitiesByCode).map(
    ([value, translator]) => ({
      value,
      label: translator(i18n4)
    })
  );
}
var germanBusinessTypesList = {
  DE_GMBH: (i18n4) => i18n4.str`GmbH`,
  DE_GMBH_IG: (i18n4) => i18n4.str`GmbH i.G.`,
  DE_UG: (i18n4) => i18n4.str`UG`,
  DE_UG_IG: (i18n4) => i18n4.str`UG i.G.`,
  DE_OHG: (i18n4) => i18n4.str`UHG`,
  DE_KG: (i18n4) => i18n4.str`KG`,
  DE_EV: (i18n4) => i18n4.str`e.V.`,
  DE_EV_IG: (i18n4) => i18n4.str`e.V. i.G.`,
  DE_EG: (i18n4) => i18n4.str`eG`,
  DE_EG_IG: (i18n4) => i18n4.str`eG i.G.`,
  DE_PARTG: (i18n4) => i18n4.str`PartG`,
  DE_EK: (i18n4) => i18n4.str`e.K.`,
  DE_AG_UNLISTED: (i18n4) => i18n4.str`AG (nicht börsennotiert)`,
  DE_AG_LISTED: (i18n4) => i18n4.str`AG (börsennotiert)`,
  DE_GBR: (i18n4) => i18n4.str`GbR`,
  DE_NEV: (i18n4) => i18n4.str`n.e.V.`,
  DE_PARTEI: (i18n4) => i18n4.str`Partei`,
  DE_WEG: (i18n4) => i18n4.str`WEG`,
  OTHER: (i18n4) => i18n4.str`Anderes`
};
function germanBusinessTypes(i18n4) {
  return Object.entries(germanBusinessTypesList).map(([value, translator]) => ({
    value,
    label: translator(i18n4)
  }));
}
var drilldownGlsIndustries = {
  "Land- und Forstwirtschaft, Fischerei": {
    "Landwirtschaft, Jagd": {
      Pflanzenbau: "aaa",
      Tierhaltung: "aab",
      "Gemischte Landwirtschaft": "aac",
      "Erbringung von landwirtschaftlichen und g\xE4rtnerischen Dienstleistungen": "aad",
      Jagd: "aae"
    },
    "Forstwirtschaft, Fischerei, Fischzucht": {
      "Erbringung von forstwirtschaftlichen Dienstleistungen": "aba",
      Fischerei: "abb"
    }
  },
  "Bergbau und Gewinnung von Steinen und Erden": {
    "Kohlenbergbau, Torfgewinnung, Erd\xF6l, Erdgas, Erzbergbau": {
      "Steinkohlenbergbau und -brikettherstellung": "baa",
      "Gewinnung von Erd\xF6l und Erdgas": "bab",
      Eisenerzbergbau: "bac"
    },
    "Gewinnung von Steinen und Erden, sonstiger Bergbau": {
      "Gewinnung von Natursteinen": "bba",
      "Gewinnung von Kies, Sand, Ton und Kaolin": "bbb",
      "Gewinnung von Mineralien f\xFCr die Herstellung von chemischen Erzeugnissen": "bbc",
      "Gewinnung von Salz": "bbd",
      "Gewinnung von Steinen und Erden, anderweitig nicht genannt, sonstiger Bergbau": "bbe"
    }
  },
  "Verarbeitendes Gewerbe": {
    Ern\u00E4hrungsgewerbe: {
      "Schlachten und Fleischverarbeitung": "caa",
      Fischverarbeitung: "cab",
      "Obst- und Gem\xFCseverarbeitung": "cac",
      "Herstellung von pflanzlichen und tierischen \xD6len und Fetten": "cad",
      "Milchverarbeitung, Herstellung von Speiseeis": "cae",
      "Mahl- und Sch\xE4lm\xFChlen, Herstellung von St\xE4rke und St\xE4rkeerzeugnissen": "caf",
      "Herstellung von Futtermitteln": "cag",
      "Sonstiges Ern\xE4hrungsgewerbe (ohne Getr\xE4nkeherstellung)": "cah",
      "Herstellung von Getr\xE4nken": "cai"
    },
    "Textil-, Bekleidungs-, Ledergewerbe": {
      "Spinnstoffaufbereitung und Spinnerei": "cba",
      Weberei: "cbb",
      Textilveredlung: "cbc",
      "Herstellung von konfektionierten Textilwaren (ohne Bekleidung)": "cbd",
      "Sonstiges Textilgewerbe (ohne Herstellung von Maschenware)": "cbe",
      "Herstellung von gewirktem und gestricktem Stoff": "cbf",
      "Herstellung von gewirkten und gestrickten Fertigerzeugnissen": "cbg",
      "Herstellung von Lederbekleidung": "cbh",
      "Herstellung von Bekleidung (ohne Lederbekleidung)": "cbi",
      "Zurichtung und F\xE4rben von Fellen, Herstellung von Pelzwaren": "cbj",
      "Herstellung von Leder und Lederfaserstoff": "cbk",
      "Lederverarbeitung (ohne Herstellung von Lederbekleidung und Schuhen)": "cbl",
      "Herstellung von Schuhen": "cbm"
    },
    "Holzgewerbe (ohne Herstellung von M\xF6beln)": {
      "S\xE4ge-, Hobel- und Holzimpr\xE4gnierwerke": "cca",
      "Herstellung von Furnier-, Sperrholz-, Holzfaser- und Holzspanplatten": "ccb",
      "Herstellung von Konstruktionsteilen, Fertigbauteilen, Ausbauelementen und Fertigteilbauten aus Holz": "ccc",
      "Herstellung von Verpackungsmitteln, Lagerbeh\xE4ltern und Ladungstr\xE4gern aus Holz": "ccd",
      "Herstellung von Holzwaren, anderweitig nicht genannt, sowie von Kork-, Flecht- und Korbwaren (ohne Herstellung von M\xF6beln)": "cce"
    },
    "Papier-, Verlags-, Druckgewerbe": {
      "Herstellung von Holz- und Zellstoff, Papier, Karton und Pappe": "cda",
      "Herstellung von Waren aus Papier, Karton und Pappe": "cdb",
      Verlagsgewerbe: "cdc",
      Druckgewerbe: "cdd",
      "Vervielf\xE4ltigung von bespielten Ton-, Bild- und Datentr\xE4gern": "cde"
    },
    "Kokerei, Mineral\xF6lverarbeitung": {
      Kokerei: "cea",
      Mineral\u00F6lverarbeitung: "ceb"
    },
    "Herstellung von chemischen und pharmazeutischen Erzeugnissen": {
      "Herstellung von chemischen Grundstoffen": "cfa",
      "Herstellung von Sch\xE4dlingsbek\xE4mpfungs-, Pflanzenschutz- und Desinfektionsmitteln": "cfb",
      "Herstellung von Anstrichmitteln, Druckfarben und Kitten": "cfc",
      "Herstellung von pharmazeutischen Erzeugnissen": "cfd",
      "Herstellung von Seifen, Wasch-, Reinigungs- und K\xF6rperpflegemitteln sowie von Duftstoffen": "cfe",
      "Herstellung von sonstigen chemischen Erzeugnissen": "cff",
      "Herstellung von Chemiefasern": "cfg"
    },
    "Herstellung von Gummi- und Kunststoffwaren": {
      "Herstellung von Gummiwaren": "cga",
      "Herstellung von Kunststoffwaren": "cgb"
    },
    "Herstellung von Glas und Glaswaren, Keramik, Verarbeitung von Steinen und Erden": {
      "Herstellung von Glas und Glaswaren": "cha",
      "Herstellung von keramischen Erzeugnissen (ohne Herstellung von Ziegeln und Baukeramik)": "chb",
      "Herstellung von keramischen Wand- und Bodenfliesen und -platten": "chc",
      "Herstellung von Ziegeln und sonstiger Baukeramik": "chd",
      "Herstellung von Zement, Kalk und gebranntem Gips": "che",
      "Herstellung von Erzeugnissen aus Beton, Zement und Gips": "chf",
      "Be- und Verarbeitung von Naturwerksteinen und Natursteinen, anderweitig nicht genannt": "chg",
      "Herstellung von sonstigen Erzeugnissen aus nicht metallischen Mineralien": "chh"
    },
    "Metallerzeugung und -bearbeitung": {
      "Erzeugung von Roheisen, Stahl und Ferrolegierungen": "cia",
      "Herstellung von Rohren": "cib",
      "Sonstige erste Bearbeitung von Eisen und Stahl": "cic",
      "Erzeugung und erste Bearbeitung von NE-Metallen": "cid",
      Gie\u00DFereien: "cie"
    },
    "Herstellung von Metallerzeugnissen": {
      "Stahl- und Leichtmetallbau": "cja",
      "Herstellung von Metallbeh\xE4ltern mit einem Fassungsverm\xF6gen von mehr als 300 l, Herstellung von Heizk\xF6rpern und -kesseln f\xFCr Zentralheizungen": "cjb",
      "Herstellung von Dampfkesseln (ohne Zentralheizungskessel)": "cjc",
      "Herstellung von Schmiede-, Press-, Zieh- und Stanzteilen, gewalzten Ringen und pulvermetallurgischen Erzeugnissen": "cjd",
      "Oberfl\xE4chenveredlung und W\xE4rmebehandlung, Mechanik, anderweitig nicht genannt": "cje",
      "Herstellung von Schneidwaren, Werkzeugen, Schl\xF6ssern und Beschl\xE4gen aus unedlen Metallen": "cjf",
      "Herstellung von sonstigen Metallwaren": "cjg"
    },
    Maschinenbau: {
      "Herstellung von Maschinen f\xFCr die Erzeugung und Nutzung von mechanischer Energie (ohne Motoren f\xFCr Luft- und Stra\xDFenfahrzeuge)": "cka",
      "Herstellung von sonstigen nicht wirtschaftszweigspezifischen Maschinen": "ckb",
      "Herstellung von land- und forstwirtschaftlichen Maschinen": "ckc",
      "Herstellung von Werkzeugmaschinen": "ckd",
      "Herstellung von Maschinen f\xFCr sonstige bestimmte Wirtschaftszweige": "cke",
      "Herstellung von Haushaltsger\xE4ten, anderweitig nicht genannt": "ckf",
      "Reparatur von sonstigen Ausr\xFCstungen": "ckg"
    },
    "Herstellung von B\xFCromaschinen, Datenverarbeitungsger\xE4ten und -einrichtungen": {
      "Herstellung von B\xFCromaschinen": "cla",
      "Herstellung von Datenverarbeitungsger\xE4ten und -einrichtungen": "clb",
      "Reparatur von Datenverarbeitungs- und Telekommunikationsger\xE4ten": "clc"
    },
    "Herstellung von Ger\xE4ten der Elektrizit\xE4tserzeugung, -verteilung": {
      "Herstellung von Elektromotoren, Generatoren und Transformatoren": "cma",
      "Herstellung von Elektrizit\xE4tsverteilungs- und -schalteinrichtungen": "cmb",
      "Herstellung von isolierten Elektrokabeln, -leitungen und -dr\xE4hten": "cmc",
      "Herstellung von Akkumulatoren und Batterien": "cmd",
      "Herstellung von elektrischen Lampen und Leuchten": "cme",
      "Herstellung von elektrischen Ausr\xFCstungen, anderweitig nicht genannt": "cmf"
    },
    "Rundfunk- und Nachrichtentechnik": {
      "Herstellung von elektronischen Bauelementen": "cna",
      "Herstellung von Ger\xE4ten und Einrichtungen der Telekommunikationstechnik": "cnb",
      "Herstellung von Rundfunkger\xE4ten sowie phono- und videotechnischen Ger\xE4ten": "cnc"
    },
    "Medizin-, Mess-, Steuer- und Regelungstechnik, Optik, Herstellung von Uhren": {
      "Herstellung von medizinischen Ger\xE4ten und orthop\xE4dischen Erzeugnissen": "coa",
      "Herstellung von Mess-, Kontroll-, Navigations- u.\xE4. Instrumenten und Vorrichtungen": "cob",
      "Herstellung von industriellen Prozesssteuerungseinrichtungen": "coc",
      "Herstellung von optischen und fotografischen Ger\xE4ten": "cod",
      "Herstellung von Uhren": "coe",
      "Reparatur von Haushaltswaren und Ziergegenst\xE4nden aus Glas, Ton, Steinzeug und Porzellan": "cof"
    },
    "Herstellung von Kraftwagen, Kraftwagenteilen": {
      "Herstellung von Kraftwagen und Kraftwagenmotoren": "cpa",
      "Herstellung von Karosserien, Aufbauten und Anh\xE4ngern": "cpb",
      "Herstellung von Teilen und Zubeh\xF6r f\xFCr Kraftwagen und Kraftwagenmotoren": "cpc"
    },
    "Sonstiger Fahrzeugbau": {
      "Schiff- und Bootsbau": "cqa",
      Bahnindustrie: "cqb",
      "Luft- und Raumfahrzeugbau": "cqc",
      "Herstellung von Kraftr\xE4dern, Fahrr\xE4dern und Behindertenfahrzeugen": "cqd",
      "Fahrzeugbau, anderweitig nicht genannt": "cqe"
    },
    "Herstellung von M\xF6beln, Schmuck, Musikinstrumenten, Sportger\xE4ten, Spielwaren, sonstigen Erzeugnissen": {
      "Herstellung von M\xF6beln": "cra",
      "Herstellung von Schmuck u.\xE4. Erzeugnissen": "crb",
      "Herstellung von Musikinstrumenten": "crc",
      "Herstellung von Sportger\xE4ten": "crd",
      "Herstellung von Spielwaren": "cre",
      "Herstellung von sonstigen Erzeugnissen": "crf"
    },
    Recycling: {
      "Recycling von metallischen Altmaterialien und Reststoffen": "csa",
      "Recycling von nicht metallischen Altmaterialien und Reststoffen": "csb"
    }
  },
  "Energie- und Wasserversorgung, Baugewerbe": {
    Energieversorgung: {
      Elektrizit\u00E4tsversorgung: "daa",
      Gasversorgung: "dab",
      W\u00E4rmeversorgung: "dac"
    },
    Wasserversorgung: {
      "Wassergewinnung mit Fremdbezug zur Verteilung": "dba",
      "Wassergewinnung ohne Fremdbezug zur Verteilung": "dbb"
    },
    Baugewerbe: {
      "Vorbereitende Baustellenarbeiten": "dca",
      "Hoch- und Tiefbau": "dcb",
      Bauinstallation: "dcc",
      "Sonstiges Ausbaugewerbe": "dcd",
      "Vermietung von Baumaschinen und -ger\xE4ten mit Bedienungspersonal": "dce"
    }
  },
  "Handel, Instandhaltung und Reparatur von Kraftfahrzeugen, Tankstellen": {
    "Kraftfahrzeughandel, Instandhaltung und Reparatur von Kraftfahrzeugen, Tankstellen": {
      "Handel mit Kraftwagen": "eaa",
      "Instandhaltung und Reparatur von Kraftwagen": "eab",
      "Handel mit Kraftwagenteilen und -zubeh\xF6r": "eac",
      "Handel mit Kraftr\xE4dern, Kraftradteilen und -zubeh\xF6r, Instandhaltung und Reparatur von Kraftr\xE4dern": "ead",
      Tankstellen: "eae"
    },
    "Handelsvermittlung, Gro\xDFhandel": {
      Handelsvermittlung: "eba",
      "Gro\xDFhandel mit landwirtschaftlichen Grundstoffen und lebenden Tieren": "ebb",
      "Gro\xDFhandel mit Nahrungsmitteln, Getr\xE4nken und Tabakwaren": "ebc",
      "Gro\xDFhandel mit Gebrauchs- und Verbrauchsg\xFCtern": "ebd",
      "Gro\xDFhandel mit nicht landwirtschaftlichen Halbwaren, Altmaterialien und Reststoffen": "ebe",
      "Gro\xDFhandel mit Maschinen, Ausr\xFCstungen und Zubeh\xF6r": "ebf",
      "Sonstiger Gro\xDFhandel": "ebg"
    },
    Einzelhandel: {
      "Einzelhandel mit Waren verschiedener Art (in Verkaufsr\xE4umen)": "eca",
      "Facheinzelhandel mit Nahrungsmitteln, Getr\xE4nken und Tabakwaren (in Verkaufsr\xE4umen)": "ecb",
      "Apotheken, Facheinzelhandel mit medizinischen, orthop\xE4dischen und kosmetischen Artikeln (in Verkaufsr\xE4umen)": "ecc",
      "Sonstiger Facheinzelhandel (in Verkaufsr\xE4umen)": "ecd",
      "Einzelhandel mit Antiquit\xE4ten und Gebrauchtwaren (in Verkaufsr\xE4umen)": "ece",
      "Einzelhandel (nicht in Verkaufsr\xE4umen)": "ecf",
      "Reparatur von Gebrauchsg\xFCtern": "ecg"
    }
  },
  Gastgewerbe: {
    Beherbergung: {
      Hotellerie: "faa",
      "Sonstiges Beherbergungsgewerbe": "fab"
    },
    Gastronomie: {
      "Speisengepr\xE4gte Gastronomie": "fba",
      "Getr\xE4nkegepr\xE4gte Gastronomie": "fbb",
      "Kantinen und Caterer": "fbc"
    }
  },
  "Verkehr und Lagerei": {
    "Landverkehr, Transport in Rohrfernleitungen": {
      Eisenbahnverkehr: "gaa",
      "Sonstiger Landverkehr": "gab",
      "Transport in Rohrfernleitungen": "gac",
      "Deutsche Bahn AG": "gad"
    },
    "Schifffahrt, Luftfahrt": {
      "See- und K\xFCstenschifffahrt": "gba",
      Binnenschifffahrt: "gbb",
      Linienflugverkehr: "gbc"
    },
    "Lagerei sowie Erbringung von sonstigen Dienstleistungen f\xFCr den Verkehr": {
      "Frachtumschlag und Lagerei": "gca",
      "Sonstige Hilfs- und Nebent\xE4tigkeiten f\xFCr den Verkehr": "gcb",
      "Reiseb\xFCros und Reiseveranstalter": "gcc",
      "Spedition, sonstige Verkehrsvermittlung": "gcd"
    },
    "Post-, Kurier- und Expressdienste": {
      "Postverwaltung und private Post- und Kurierdienste": "gda",
      Fernmeldedienste: "gdb",
      "Telekom AG": "gdc",
      "Deutsche Post AG": "gdd"
    }
  },
  "Erbringung von Finanz- und Versicherungsdienstleistungen": {
    "Kreditgewerbe, Versicherungsgewerbe": {
      Wertpapierfirma: "haa",
      "Sonstige Finanzierungsinstitutionen": "hab",
      "Fonds von Kapitalgesellschaften": "hac",
      "Ausl\xE4nd. Finanzges. Als Kreditinst. Gem. \xA71Abs.1KWG": "had",
      Geldmarktfonds: "hae",
      "Sonstiges Versicherungsgewerbe": "hag"
    },
    "Mit Finanz- und Versicherungsdienstleistungen verbundene T\xE4tigkeiten": {
      "Mit dem Kreditgewerbe verbundene T\xE4tigkeiten": "hba",
      "Mit dem Versicherungsgewerbe verbundene T\xE4tigkeiten": "hbb",
      "B\xF6rseneinrichtungen mit t\xE4gl. Einsch\xFCssen": "hbc",
      Postgiro\u00E4mter: "hae",
      "Zust\xE4ndige genossenschaftliche Zentralbank": "hbg",
      "Andere Genossenschaftliche Zentralbanken": "hbh",
      "Angeschlossene Kreditgenoss.(nur f\xFCr genoss. Zentralbanken)": "hbi",
      "Sonstige mindestreservepflichtige Kreditinstitute": "hbj",
      "Ausl\xE4ndische Kreditinstitute gem. \xA7 53 KWG": "hbk",
      "Internationale Organisationen im Bereich KI": "hbl",
      "Multilaterale Entwicklungsbanken nicht mindestreservefrei und ohne Nullgewichtung": "hbm",
      "LbNRW/InvB Berlin/Hessen/WK/LaBo/BremAB": "hbo",
      "Multilaterale Entwicklungsbanken nicht mindestreservefrei mit Nullgewichtung": "hbp",
      "Sonstige mindestreservefreie Kreditinstitute": "hbq",
      "Internat. Organisationen im Bereich KI (AMR-frei)": "hbr",
      "Europ\xE4ische Investitionsbank": "hbs",
      "Multilaterale Entwicklungsbanken (AMR-frei)": "hbt",
      "Multilaterale Entwicklungsbanken mindestreservefrei und mit Nullgewichtung": "hbu"
    }
  },
  "Grundst\xFCcks- und Wohnungswesen, Vermietung (inkl. Bewegl. Sachen)": {
    "Grundst\xFCcks- und Wohnungswesen, Vermietung n. bewegl. Sachen": {
      "Erschlie\xDFung, Kauf und Verkauf von Grundst\xFCcken, Geb\xE4uden und Wohnungen": "iaa",
      "Vermietung und Verpachtung von eigenen Grundst\xFCcken, Geb\xE4uden und Wohnungen": "iab",
      "Vermittlung und Verwaltung von fremden Grundst\xFCcken, Geb\xE4uden und Wohnungen": "iac",
      "Vermietung und Verpachtung von eigenen Grundst\xFCcken und Nichtwohngeb\xE4uden und Bautr\xE4ger f\xFCr Nichtwohngeb\xE4ude": "iad"
    },
    "Vermietung beweglicher Sachen": {
      "Vermietung von Kraftwagen bis 3,5 t Gesamtgewicht": "iba",
      "Vermietung von Maschinen und Ger\xE4ten": "ibb",
      "Vermietung von Gebrauchsg\xFCtern, anderweitig nicht genannt": "ibc",
      "Leasing von nichtfinanziellen immatriellen Verm\xF6gensgegenst\xE4nden (ohne Copyrights)": "ibd"
    }
  },
  "Informations- und Datenverarbeitung, Forschung und Entwicklung": {
    Informationsdienstleistungen: {
      Hardwareberatung: "jaa",
      Softwareh\u00E4user: "jab"
    },
    Datenverarbeitung: {
      Datenverarbeitungsdienste: "jba",
      Datenbanken: "jbb",
      "Instandhaltung und Reparatur von B\xFCromaschinen, Datenverarbeitungsger\xE4ten und -einrichtungen": "jbc",
      "Sonstige mit der Datenverarbeitung verbundene T\xE4tigkeiten und Rundfunkveranstalter": "jbd"
    },
    "Forschung und Entwicklung": {
      "Forschung und Entwicklung im Bereich Natur-, Ingenieur-, Agrarwissenschaften und Medizin": "jca",
      "Forschung und Entwicklung im Bereich Rechts-, Wirtschafts- und Sozialwissenschaften sowie im Bereich Sprach-, Kultur- und Kunstwissenschaften": "jcb"
    }
  },
  "Erbringung von freiberuflichen, wirtschaftlichen und technischen Dienstleistungen": {
    "Freiberufliche Dienstleistungen": {
      "Rechts-, Steuer- und Unternehmensberatung, Wirtschaftspr\xFCfung, Buchf\xFChrung, Markt- und Meinungsforschung, Managementt\xE4tigkeiten von Holdinggesellschaften": "kaa",
      "Architektur- und Ingenieurb\xFCros": "kab",
      Werbung: "kac",
      "Personal- und Stellenvermittlung, \xDCberlassung von Arbeitskr\xE4ften": "kad",
      "Wach- und Sicherheitsdienste sowie Detekteien": "kae"
    },
    "Technische Dienstleistungen": {
      "Technische, physikalische und chemische Untersuchung": "kba",
      "Reinigung von Geb\xE4uden, Inventar und Verkehrsmitteln": "kbb"
    },
    "Wirtschaftliche Dienstleistungen": {
      "Erbringung von sonstigen wirtschaftlichen Dienstleistungen, anderweitig nicht genannt": "kca"
    }
  },
  "\xD6ffentliche Verwaltung, Verteidigung, Sozialversicherung": {
    "Verwaltung, Verteidigung, Sozialversicherung": {
      "\xD6ffentliche Verwaltung": "laa",
      "Ausw\xE4rtige Angelegenheiten, Verteidigung, Rechtspflege, \xF6ffentliche Sicherheit und Ordnung": "lab",
      "Sozialversicherung und Arbeitsf\xF6rderung": "lac"
    },
    Bund: {
      "Fonds Deutsche Einheit / Erblastentilgungsfonds": "lba",
      "ERP-Sonderverm\xF6gen": "lbb",
      Bundeseisenbahnverm\u00F6gen: "lbc"
    },
    L\u00E4nder: {
      Gemeinden: "lcb",
      "Kommunale Zweckverb\xE4nde": "lcc",
      "Sonstige ausl\xE4ndische Gebietsk\xF6rperschaften": "lcd"
    }
  },
  "Gesundheits-, Veterin\xE4r- und Sozialwesen, Erziehung und Unterricht": {
    "Erziehung und Unterricht": {
      "Kinderg\xE4rten, Vor- und Grundschulen": "maa",
      "Weiterf\xFChrende Schulen": "mab",
      "Hochschulen und andere Bildungseinrichtungen des Terti\xE4rsbereichs": "mac",
      "Erwachsenenbildung und sonstiger Unterricht": "mad"
    },
    "Gesundheits-, Veterin\xE4r- und Sozialwesen": {
      Gesundheitswesen: "mba",
      Veterin\u00E4rwesen: "mbb",
      Sozialwesen: "mbc"
    }
  },
  "Abwasser- und Abfallentsorgung, Private Haushalte": {
    Abwasserentsorgung: {
      Abwasserbeseitigung: "naa"
    },
    Abfallbeseitigung: {
      Abfallbeseitigung: "nba"
    },
    "Private Haushalte": {
      "Private Haushalte mit sonstigem Hauspersonal": "nca"
    }
  },
  "Interessenvertretungen sowie kirchliche und sonstige Vereinigungen, Organisationen": {
    Interessenvertretungen: {
      "Wirtschafts- und Arbeitgeberverb\xE4nde": "oaa",
      Gewerkschaften: "oab",
      Berufsorganisationen: "oac"
    },
    "Kirchliche und sonstige Vereinigungen": {
      "Kirchliche und sonstige religi\xF6se Vereinigungen": "oba",
      "Politische Parteien und Vereinigungen": "obb",
      "Interessenvertretungen und Vereinigungen, anderweitig nicht genannt": "obc"
    },
    Organisationen: {
      "Organisationen der freien Wohlfahrts-/Jugendpflege": "oca",
      "Organisationen der Bildung/Wissenschaft/Forsch./Kultur": "ocb",
      "Organisationen des Sports und Gesundheitswesens": "occ",
      "Kommunale Spitzen- und Regionalverb\xE4nde": "ocd",
      "Sonstige Organisationen ohne Erwerbszweck": "oce"
    }
  },
  "Kunst, Unterhaltung und Erholung, Erbringung von sonstigen Dienstleistungen": {
    "Kunst, Unterhaltung und Erholung": {
      "Film- und Videofilmherstellung, -verleih und -vertrieb, Kinos": "paa",
      "Rundfunkveranstalter, Herstellung von H\xF6rfunk- und Fernsehprogrammen": "pab",
      "Erbringung von sonstigen kulturellen und unterhaltenden Leistungen": "pac",
      "Korrespondenz- und Nachrichtenb\xFCros, selbstst\xE4ndige Journalistinnen und Journalisten": "pad",
      "Bibliotheken, Archive, Museen, botanische und zoologische G\xE4rten": "pae",
      Sport: "paf",
      "Erbringung von sonstigen Dienstleistungen f\xFCr Unterhaltung, Erholung und Freizeit": "pag"
    },
    "Erbringung von sonstigen Dienstleistungen": {
      "W\xE4scherei und chemische Reinigung": "pba",
      "Fris\xF6r- und Kosmetiksalons": "pbb",
      Bestattungswesen: "pbc",
      "Saunas, Solarien, Fitnesszentren u.\xE4.": "pbd",
      "Erbringung von Dienstleistungen, anderweitig nicht genannt": "pbe"
    }
  }
};
var form_gls_merchant_onboarding = (i18n4) => ({
  config: gls_merchant_onboarding(i18n4, {}),
  id: "gls-merchant-onboarding",
  label: "GLS Merchant Onboarding",
  version: 1
});
function validateDateOfBirth(i18n4, text, _form) {
  const time = parse(text, "yyyy-MM-dd", /* @__PURE__ */ new Date());
  if (!isValid(time)) {
    return i18n4.str`invalid format`;
  }
  if (isFuture(time)) {
    return i18n4.str`it can't be in the future`;
  }
  const { years } = intervalToDuration({
    start: time,
    end: /* @__PURE__ */ new Date()
  });
  if (years && years > 120) {
    return i18n4.str`it can't be greater than 120 years`;
  }
  return void 0;
}
function validateFoundingDate(i18n4, text, _form) {
  const time = parse(text, "yyyy-MM-dd", /* @__PURE__ */ new Date());
  if (!isValid(time)) {
    return i18n4.str`invalid format`;
  }
  if (isFuture(time)) {
    return i18n4.str`it can't be in the future`;
  }
  const { years } = intervalToDuration({
    start: time,
    end: /* @__PURE__ */ new Date()
  });
  if (years && years > 120) {
    return i18n4.str`it can't be greater than 120 years`;
  }
  return void 0;
}
function validateEmail(i18n4, text, _form) {
  const re = /^\S+@\S+\.\S+$/;
  if (re.test(text)) {
    return void 0;
  }
  return i18n4.str`Invalid e-mail address`;
}
function validatePhone(i18n4, text, _form) {
  const re = /^[+]?([0-9]+[. ]*)+$/;
  if (re.test(text)) {
    return void 0;
  }
  return i18n4.str`Invalid phone number`;
}
function gls_merchant_onboarding(i18n4, context) {
  return {
    type: "double-column",
    title: "Merchant Onboarding Information",
    sections: [
      {
        title: i18n4.str`Personal Details`,
        description: i18n4.str`Personal details of the authorised representative.`,
        fields: [
          {
            id: TalerFormAttributes.PERSON_FIRST_NAMES,
            label: i18n4.str`First name(s)`,
            help: i18n4.str`As on your ID document`,
            type: "text",
            required: true
          },
          {
            id: TalerFormAttributes.PERSON_LAST_NAME,
            label: i18n4.str`Last name`,
            type: "text",
            required: true
          },
          {
            id: TalerFormAttributes.DATE_OF_BIRTH,
            label: i18n4.str`Date of birth`,
            type: "isoDateText",
            placeholder: "dd.MM.yyyy",
      