public class YourTestBed {
    public static void main(String[] args) throws Throwable {

	//**********************************************************
	//**** to use JEL we first have to define the namespace ****

	// we shall export the static methods of java.lang.Math
	Class[] stLib=new Class[1];
	stLib[0]=java.lang.Math.class;

	// we shall enable access to the global context
	Class[] dynLib=new Class[1];
	dynLib[0]=GlobalContext.class;

	// we shall allow dot operators on strings and data
	Class[] dotLib=new Class[2];
	dotLib[0]=Data.class;
	dotLib[1]=java.lang.String.class;
	
	// finally, the namespace is defined by constructing the library class
	gnu.jel.Library lib=new gnu.jel.Library(stLib,dynLib,dotLib);


	//**********************************************************
	//******** Now we setup the global context and data  *******

	Object[] context=new Object[1];
	GlobalContext gc=new GlobalContext(0.2,new Data(2),new Data(10));
	context[0]=gc;


	//**********************************************************
	//******** We are ready to compile some expressions  *******
	gnu.jel.CompiledExpression expr;

	// constant expression
	expr=gnu.jel.Evaluator.compile("2*2",lib);
	System.out.println("2*2="+expr.evaluate(context));

	// expression accessing the variables
	expr=gnu.jel.Evaluator.compile("x",lib);
	System.out.println("x="+expr.evaluate(context));

	// three expressions accessing the variables with dot operator
	expr=gnu.jel.Evaluator.compile("d1.value",lib);
	System.out.println("d1.value="+expr.evaluate(context));
	
	//
	expr=gnu.jel.Evaluator.compile("d2.value",lib);
	System.out.println("d2.value="+expr.evaluate(context));

	//
	expr=gnu.jel.Evaluator.compile("(d1.value+d2.value)*x*10",lib);
	System.out.println("(d1.value+d2.value)*x*10="+expr.evaluate(context));

	// also using static functions
	expr=gnu.jel.Evaluator.compile("round((d1.value+d2.value)*x*10)",lib);
	System.out.println("round((d1.value+d2.value)*x*10)="+expr.evaluate(context));

	// You can add more expressions here
    };
    
};


