// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
using namespace std;
namespace ost {
#endif

void VPBTrunk::initSyms(void)
{
	setConst(SYM_NETWORK, "soft");
	setConst(SYM_INTERFACE, "analog");
	setSymbol(SYM_BUFFER, "12000");
}

bool VPBTrunk::idleHandler(TrunkEvent *event)
{
	char script[256];
	int argc = 0;
	const char *start = NULL;
	const char *data;
	const char *value;
	TrunkGroup *grp = NULL;
	char *sp;
	unsigned chk;
	Request *req;
	char **argv;

	switch(event->id)
	{
	case TRUNK_ENTER_STATE:
		synctimer = exittimer = 0;
		enterState("idle");
		setIdle(true);
		tgi.pid = 0;
		digits = 0;
		disjoin();

		vpb_play_set_gain(handle, outgain);
		vpb_record_set_gain(handle, inpgain);

		vpb_sethook_async(handle, VPB_ONHOOK);
		setDTMFDetect(false);
		flags.dsp = DSP_MODE_INACTIVE;
		flags.offhook = false;

		switch(flags.trunk)
		{
		case TRUNK_MODE_OUTGOING:
			group->decOutgoing();
			break;
		case TRUNK_MODE_INCOMING:
			group->decIncoming();
		}

		flags.trunk = TRUNK_MODE_INACTIVE;
		status[id] = '-';
		time(&idletime);
		ScriptSymbol::purge();
		rings = 0;
		value = group->chkRequest();
		if(!atoi(value) && stricmp(value, "hangup"))
			return true;
		chk = atoi(value);
		if(chk < group->getReady())
			chk = group->getReady();
		setTimer(chk);
		return true;
	case TRUNK_STOP_DISCONNECT:
	case TRUNK_LINE_WINK:
	case TRUNK_CPA_DIALTONE:
	case TRUNK_MAKE_IDLE:
		return true;
	case TRUNK_MAKE_BUSY:
		endTimer();
		handler = &VPBTrunk::busyHandler;
		return true;
	case TRUNK_TIMER_EXPIRED:	
		flags.ready = true;
		req = group->getRequest();
		if(req)
		{
			setConst(SYM_PARENT, req->getParent());
			argv = req->getList();
			start = *(argv++);
			if(attach(start))
			{
				flags.trunk = TRUNK_MODE_OUTGOING;
				setList(argv);
				flags.ready = false;
				endTimer();
				handler = &VPBTrunk::seizeHandler;
				group->incOutgoing();
				delete req;
				return true;
			}
			ScriptSymbol::purge();
			delete req;
		}
		chk = atoi(group->chkRequest());
		if(chk)
			setTimer(chk);
		return true;
	case TRUNK_START_SCRIPT:
		flags.trunk = TRUNK_MODE_OUTGOING;
		slog(Slog::levelInfo) <<__FILE__<<__LINE__<< "DR - OUTGOING!" << endl;

	case TRUNK_RING_START:
		start = event->parm.argv[0];
		if(start)
		{
			if(strchr(start, '='))
				start = group->getSchedule(script);
			else
				++argc;
		}
		if(flags.trunk == TRUNK_MODE_INACTIVE)
			flags.trunk = TRUNK_MODE_INCOMING;
		rings = 0;
		if(!start)
			start = group->getSchedule(script);
		if(attach(start))
		{
			setList(&event->parm.argv[argc]);
			flags.ready = false;
			endTimer();		
			if(flags.trunk == TRUNK_MODE_OUTGOING)
			{
				handler = &VPBTrunk::seizeHandler;
				group->incOutgoing();
			}
			else
			{
				handler = &VPBTrunk::stepHandler;
				group->incIncoming();
			}
			return true;
		}
		ScriptSymbol::purge();
		flags.trunk = TRUNK_MODE_INACTIVE;
	
		return true;		
	case TRUNK_RING_REDIRECT:
		start = group->getRedirect(event->parm.argv[0], script);
		rings = 0;
		if(attach(start))
		{
			setConst(SYM_REDIRECT, event->parm.argv[0]);
			setList(&event->parm.argv[1]);
			flags.ready = false;
			flags.trunk = TRUNK_MODE_INCOMING;
			endTimer();
			handler = &VPBTrunk::stepHandler;
			group->incIncoming();		
			return true;
		}
		ScriptInterp::purge();
		slog(Slog::levelError) << name << ": " << event->parm.argv[0] << ": unable to redirect" << endl;
		return true;
	case TRUNK_RINGING_ON:
		if(!group->getAnswer())
			return true;
		rings = 1;
		flags.trunk = TRUNK_MODE_INCOMING;
		flags.ready = false;
		endTimer();
		group->incIncoming();
		handler = &VPBTrunk::ringHandler;
		return true;
	}
	return false;
}

#ifdef	CCXX_NAMESPACES
};
#endif
