/*
 * This program is an implementation of the ISAKMP Internet Standard.
 * Copyright (C) 1997 Angelos D. Keromytis.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * This code was written while the author was in Greece, in May/June
 * 1997.
 *
 * You may contact the author by:
 *   e-mail: angelos@dsl.cis.upenn.edu
 *  US-mail: Angelos D. Keromytis
 *           Distributed Systems Lab
 *           Computer and Information Science Department
 *           University of Pennsylvania
 *           Moore Building
 *           200 South 33rd Street
 *           Philadelphia, PA 19104	   
 */

/*
 * This file defines the state and the event objects
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <time.h>
#include "gmp.h"

struct event
{
    time_t          ev_time;
    u_int32_t       ev_type;        /* Event type */
    void           *ev_ptr;         /* Pointer to event specific structure */
    u_int32_t       ev_ptr_len;     /* Length of ptr, where applicable */
    struct event   *ev_next;        /* Pointer to next event */
};

struct state
{
    time_t             st_expire;	       /* When this SA expires  */
    u_int16_t          st_hash;		       /* Hash algorithm */
    u_int16_t          st_enc;                 /* Encryption algorithm */
    u_int16_t          st_prf;		       /* PRF */
    u_int16_t          st_auth;		       /* Authentication method */
    u_int32_t          st_group;	       /* Oakley group */
    u_int32_t          st_doi;
    u_int32_t          st_situation;
    u_int32_t          st_goal;                /* What am i trying to get */
    u_int32_t          st_msgid;	       /* MSG-ID from header */
    u_int8_t           st_shared_in_use;
    u_int8_t           st_gi_in_use;	       /* 1 if st_gi is allocated */
    u_int8_t           st_gr_in_use;           /* Ditto for st_gr */
    u_int8_t           st_sec_in_use;          /* Same for st_sec */
    u_char             st_icookie[COOKIE_SIZE];
    u_char             st_rcookie[COOKIE_SIZE];/* I/R cookies */
    struct sockaddr    st_peer;                /* Peer's address */
    u_int32_t          st_state;               /* State of exchange */
    u_char            *st_packet;              /* Transmitted packet */
    u_int32_t          st_packet_len;          /* Size of transmitted packet */
    u_int16_t          st_retransmit;          /* Number of retransmitts */
    u_int8_t           st_myidentity_type;     /* Type of identity */
    u_int8_t           st_peeridentity_type;
    u_char            *st_proposal;            /* Proposal accepted */
    u_char            *st_sa;		       /* SA from initiator */
    u_char            *st_ni;                  /* Ni nonce */
    u_char            *st_nr;                  /* Nr nonce */
    u_char            *st_skeyid;              /* Key material */
    u_char            *st_skeyid_d;
    u_char            *st_skeyid_a;
    u_char            *st_skeyid_e;
    u_char            *st_myidentity;          /* My identity */
    u_char            *st_peeridentity;
    u_char            *st_iv;		       /* IV for encryption */
    u_char            *st_lastblock;	       /* Last block of Phase 1 */
    u_int32_t          st_skeyid_len;	       /* Respective lengths */
    u_int32_t          st_skeyid_d_len;
    u_int32_t          st_skeyid_a_len;
    u_int32_t          st_skeyid_e_len;
    u_int16_t          st_myidentity_len;      /* Length of identity */
    u_int16_t          st_peeridentity_len;
    u_int16_t          st_iv_len;
    u_int16_t          st_lastblock_len;
    MP_INT             st_gi;		       /* Initiator public value */
    MP_INT             st_gr;		       /* Responder public value */
    MP_INT             st_sec;		       /* Our secret value */
    MP_INT             st_shared;	       /* Derived shared secret */
    struct event      *st_event;               /* Pointer to some event */
    struct state      *st_next;                /* Next in list */
    struct state      *st_prev;		       /* Previous in list */
};
