

/*

________________________________________________________________

        tilde_expand.c
        $Id: tilde_expand.c,v 1.26 1996/01/25 11:35:17 svein Exp $
        Copyright 1990, Blab, UiO
        Image processing lab, Department of Informatics
        University of Oslo
        E-mail: blab@ifi.uio.no
________________________________________________________________
  
  Permission to use, copy, modify and distribute this software and its
  documentation for any purpose and without fee is hereby granted, 
  provided that this copyright notice appear in all copies and that 
  both that copyright notice and this permission notice appear in supporting
  documentation and that the name of B-lab, Department of Informatics or
  University of Oslo not be used in advertising or publicity pertaining 
  to distribution of the software without specific, written prior permission.

  B-LAB DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL B-LAB
  BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
  OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 

*/

static char *Id = "$Id: tilde_expand.c,v 1.26 1996/01/25 11:35:17 svein Exp $, Blab, UiO";



/*F:tilde_expand*

________________________________________________________________

		tilde_expand
________________________________________________________________

Name:		tilde_expand - expand tilde and environment variables
                in filenames.
Syntax:         | #include <xite/utils.h>
		|
                | char *tilde_expand( char* filename );
Description:    Expand ~ (tilde) and environment variables in filename.
Return value:   The expanded name of the file (or NULL).
                The required memory is allocated by this function and
		should be freed (with 'free(3)') when no longer needed.
Authors:	Ellen Sentovich, Rick Spickelmier
Modifications:  Otto Milvang, Svein Be
Id:             $Id: tilde_expand.c,v 1.26 1996/01/25 11:35:17 svein Exp $
________________________________________________________________

*/

#include <xite/includes.h>
#include <xite/utils.h>
#include XITE_STDIO_H
#include XITE_STRING_H
#include <stdlib.h>
#include XITE_UNISTD_H

#ifndef MSDOS
#include <sys/param.h> 
#include <pwd.h>
#endif

#define USER_NAME_SIZE 32

#ifndef FUNCPROTO
char *tilde_expand(filename)
char *filename;    /* file name, possibly with a '~'             */
#else /* FUNCPROTO */
char *tilde_expand(char *filename)
                   /* file name, possibly with a '~'             */
#endif /* FUNCPROTO */
/*
 * tilde expand a file name
 *
 *   returns: the expanded name of the file (memory-allocated)
 *            or NIL(char) 
 */
{
#ifdef aiws
  int current_path_len = MAXPATH;
#else
  int current_path_len = MAXPATHLEN;
#endif /* aiws */
  char username[USER_NAME_SIZE], *loc;
#ifndef MSDOS
  struct passwd *pw;
#endif
  char *path = NULL;
  
  if ((filename == NULL) || strcmp(filename, "") == 0) {
    return(NULL);
  }
  
  path = (char *) calloc(current_path_len+1, sizeof(char)); /* All zeros. */
  if (path == NULL) {
    Warning(1, "tilde_expand: Cannot allocate space.\n");
    return(0);
  }
  
  if (filename[0] != '~' && filename[0] != '$') {
    (void) strcpy(path, filename);
    return(path);
  }
  
  if (filename[0] == '$') {
    char *env;
    
    if ((loc = (char *) strchr(filename, '/')) == NULL) {
      loc = filename; loc++;
      if ((env = getenv(loc)) == NULL) {
	free(path);
	return(NULL);
      }
      strcpy(path, env);
      return(path);
    }
    (void) strncpy(username, &filename[1], loc - &filename[1]);
    username[loc - &filename[1]] = '\0';
    if ((env = getenv(username)) == NULL) {
      free(path);
      return(NULL);
    }
    (void) sprintf(path, "%s%s", env, loc);
    return(path);
  }
  
#ifdef MSDOS
  free(path);
  return(NULL);
#else
  
  /* tilde at the beginning now */
  if (filename[1] == '\0' || filename[1] == '/') {
    /* current user */
    char *home;
    
    if ((home = getenv("HOME")) == NULL) {
      /* fall back on /etc/passwd */
      if ((pw = getpwuid(getuid())) == (struct passwd *) 0) {
	free(path);
	return(NULL);
      }
      (void) sprintf(path, "%s%s", pw->pw_dir, &filename[1]);
    } else {
      (void) sprintf(path, "%s%s", home, &filename[1]);
    }
    
  } else {
    if ((loc = (char *) strchr(filename, '/')) == NULL) {
      /* user directory */
      (void) strcpy(username, &filename[1]);
    } else {
      (void) strncpy(username, &filename[1], loc - &filename[1]);
      username[loc - &filename[1]] = '\0';
    }
    if ((pw = getpwnam(username)) == (struct passwd *) 0) {
      free(path);
      return(NULL);
    }
    if (loc) (void) sprintf(path, "%s%s", pw->pw_dir, loc);
    else (void) sprintf(path, "%s", pw->pw_dir);
  }
  return(path);
#endif
}





#ifdef TEST


main()
{
  char test[80];
  printf("Enter a filename: ");
  gets(test);
  printf("%s -> %s\n", test, tilde_expand(test));
}

#endif

