/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *     Copyright (c) 1990,1991,1992,1993 Bellcore           *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *     dfs@bellcore.com      dcook@stat.rutgers.edu         *
 *      (201) 829-4263                                      *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"

/* Functions used in this file */
void reset_rows_in_plot(), plot_once();
/* */

int
glyph_color_pointtype(xg, rownum)
  xgobidata *xg;
  int rownum;
{
  int i;
  int pointtype = -1;
/*
 * Fold the color, glyph and erase information into a single
 * identifier.  In this way, 4 times as much brushing information
 * can be sent.
*/

  if (mono)
  {
    pointtype = 1000 * (xg->glyph_now[rownum].size - 1) +
                 100 * (xg->glyph_now[rownum].type - 1) +
             ncolors * xg->erased[rownum];
  }
  else
  {
    for (i=0; i<ncolors; i++)
    {
      if (xg->color_now[rownum] == color_nums[i])
      {
        pointtype = 1000 * (xg->glyph_now[rownum].size - 1) +
                     100 * (xg->glyph_now[rownum].type - 1) +
                 ncolors * xg->erased[rownum] +
                           i ;
      }
    }
  }

  return(pointtype);
}

static void
senddata_to_glyphs_and_colors(xg, pointtypes, rownums, npts)
  xgobidata *xg;
  long *pointtypes;
  int *rownums;
  int npts;
{
  int n, rownum, pointtype;
  int remainder;

  for (n=0; n<npts; n++)
  {
    rownum = rownums[n];
    pointtype = (int) pointtypes[n];

    xg->glyph_now[rownum].size = pointtype / 1000 + 1 ;
    if (xg->glyph_now[rownum].size < 1 ||
        xg->glyph_now[rownum].size > NGLYPHSIZES)
    {
      (void) fprintf(stderr, "impossible point size\n");
    }

    remainder = pointtype % 1000 ;
    xg->glyph_now[rownum].type = remainder / 100 + 1 ;
    if (xg->glyph_now[rownum].type < 1 ||
        xg->glyph_now[rownum].type > NGLYPHTYPES)
    {
      (void) fprintf(stderr, "impossible point type\n");
    }

    remainder = remainder % 100 ;
    xg->erased[rownum] = remainder / ncolors ;
    if (xg->erased[rownum] != 0 &&
        xg->erased[rownum] != 1)
    {
      (void) fprintf(stderr, "impossible value for erase\n");
    }

    if (!mono)
    {
      remainder = remainder % ncolors ;
      xg->color_now[rownum] = color_nums[remainder] ;
    }
  }
}

/* ARGSUSED */
XtSelectionDoneProc
pack_brush_done(w, selection, target)
  Widget w;
  Atom *selection;
  Atom *target;
{
/*
 * This routine does nothing; its only purpose in life is to
 * prevent the Intrinsics from freeing the selection value.
*/
}

/* ARGSUSED  */
XtLoseSelectionProc
pack_brush_lose(w, selection, xgobi)
  Widget w;
  Atom *selection;
  XtPointer xgobi;
{
/*
 * This routine does nothing; its only purpose in life is to
 * prevent the Intrinsics from freeing the selection value.
*/
}

void
announce_brush_data(xg)
  xgobidata *xg;
{
/*
 * This sends an event to tell other XGobi windows to
 * execute XtGetSelection().  It sends no data.
*/
  XChangeProperty( display,
    RootWindowOfScreen(XtScreen(xg->shell)),
    XG_NEWPAINT_ANNC, XG_NEWPAINT_ANNC_TYPE,
    (int) 32, (int) PropModeReplace,
    (unsigned char *) NULL, 0);
}

/* ARGSUSED */
XtConvertSelectionProc
pack_brush_data(w, selection, target,
type_ret, retdata, length_ret, format_ret )
  Widget w;          /* owning widget, xg->workspace */
  Atom *selection;   /* XG_NEWPAINT */
  Atom *target;      /* XG_NEWPAINT_TYPE */
  Atom *type_ret;    /* XG_NEWPAINT_TYPE again */
  XtPointer *retdata;         /* brushing data itself */
  unsigned long *length_ret;  /* length of retdata */
  int *format_ret;            /* type of retdata */
{
/*
 * When another XGobi requests the brushing data from the server,
 * this function is executed by the active XGobi.  It provides
 * the brushing data to the requestor.
 * It is declared by the call to XtOwnSelection().
*/
  extern xgobidata xgobi;

  if (*target == XG_NEWPAINT_TYPE)
  {
    xgobi.senddata[0] = (unsigned long) xgobi.nrows;
    xgobi.senddata[1] = (unsigned long) xgobi.nrows_in_plot;
    xgobi.senddata[2] = (unsigned long) xgobi.is_transient;

    *type_ret = XG_NEWPAINT_TYPE ;
    *retdata = (XtPointer) xgobi.senddata ;
    *length_ret = (unsigned long) (2*xgobi.nrows_in_plot + 3) ;
    *format_ret = (int) 32 ;
  }
}


/* ARGSUSED */
XtSelectionCallbackProc
unpack_brush_data(w, xgobiptr, atom, atom_type, retdata, lendata, fmt)
  Widget w;
  XtPointer xgobiptr;
  Atom *atom;         /* should be XG_NEWPAINT */
  Atom *atom_type;    /* should be XG_NEWPAINT_TYPE */
  XtPointer retdata;
  unsigned long *lendata;
  int *fmt;           /* should be 32 */
{
  xgobidata *xg = (xgobidata *) xgobiptr;
  long i;
  int j, npts, trans, nr;
  int *brushed;
  unsigned long *rdata;

  if (*atom == XG_NEWPAINT &&
      *atom_type &&
      /**atom_type != NULL &&*/
      *atom_type != XT_CONVERT_FAIL)
  {
    if (*lendata > 0)
    {
      rdata = (unsigned long *) retdata;

      nr = (int) *rdata++ ;
      npts = (int) *rdata++ ;
      trans = (int) *rdata++ ;

      if (nr == xg->nrows && npts > 0)
      {
        brushed = (int *) XtMalloc((Cardinal) npts * sizeof(int));

        /*
         * Assign the new values to the current arrays.
        */
        for (i=0; i<npts; i++)
          brushed[i] = (int) *rdata++;
        senddata_to_glyphs_and_colors(xg,
          (long *) rdata, brushed, npts);

        /*
         * If the painting mode of the sending window is
         * persistent or undo, then make these changes permanent.
         * The changes aren't fully permanet unless they're in
         * senddata[], but I'll do that when a ButtonPress is
         * received, so it should be ok.
        */
        if (!trans)
        {
          for (i=0; i<npts; i++)
          {
            j = brushed[i];
            xg->glyph_ids[j].type = xg->glyph_now[j].type;
            xg->glyph_ids[j].size = xg->glyph_now[j].size;
            xg->color_ids[j] = xg->color_now[j];
          }
        }
        XtFree((XtPointer) brushed);
        xg->got_new_paint = 1;
        plot_once(xg);
      }
    }
  }
  XtFree((XtPointer) retdata);
  xg->nevents = 0;
}

void
read_paint(xg)
  xgobidata *xg;
{
    XtGetSelectionValue(
      xg->workspace,
      (Atom) XG_NEWPAINT,
      (Atom) XG_NEWPAINT_TYPE,
      (XtSelectionCallbackProc) unpack_brush_data,
      (XtPointer) xg,
      (Time) XtLastTimestampProcessed(display) );
      /*(Time) CurrentTime );*/
}

void
announce_rows_in_plot(xg)
  xgobidata *xg;
{
/*
 * This sends an event to tell other XGobi windows to
 * execute XtGetSelection().  It sends no data.
*/
  XChangeProperty( display,
    RootWindowOfScreen(XtScreen(xg->shell)),
    XG_ROWSINPLOT_ANNC, XG_ROWSINPLOT_ANNC_TYPE,
    (int) 32, (int) PropModeReplace,
    (unsigned char *) NULL, 0);
}

/* ARGSUSED */
XtConvertSelectionProc
pack_rowsinplot_data(w, selection, target,
type_ret, retdata, length_ret, format_ret )
  Widget w;          /* owning widget, xg->workspace */
  Atom *selection;   /* XG_ROWSINPLOT */
  Atom *target;      /* XG_ROWSINPLOT_TYPE */
  Atom *type_ret;    /* XG_ROWSINPLOT_TYPE again */
  XtPointer *retdata;         /* brushing data itself */
  unsigned long *length_ret;  /* length of retdata */
  int *format_ret;            /* type of retdata */
{
/*
 * When another XGobi requests the brushing data from the server,
 * this function is executed by the active XGobi.  It provides
 * the rows_in_plot[] data to the requestor.
 * It is declared by the call to XtOwnSelection().
*/
  extern xgobidata xgobi;

  if (*target == XG_ROWSINPLOT_TYPE)
  {
    xgobi.senddata[0] = (unsigned long) xgobi.nrows;
    xgobi.senddata[1] = (unsigned long) xgobi.nrows_in_plot;
    xgobi.senddata[2] = (unsigned long) xgobi.is_transient;

    *type_ret = XG_ROWSINPLOT_TYPE ;
    *retdata = (XtPointer) xgobi.senddata ;
    *length_ret = (unsigned long) (xgobi.nrows_in_plot + 3) ;
    *format_ret = (int) 32 ;
  }
}

/* ARGSUSED */
XtSelectionCallbackProc
unpack_rowsinplot_data(w, xgobiptr, atom, atom_type, retdata, lendata, fmt)
  Widget w;
  XtPointer xgobiptr;
  Atom *atom;         /* should be XG_ROWSINPLOT */
  Atom *atom_type;    /* should be XG_ROWSINPLOT_TYPE */
  XtPointer retdata;
  unsigned long *lendata;
  int *fmt;           /* should be 32 */
{
  xgobidata *xg = (xgobidata *) xgobiptr;
  long i;
  int npts, nr;
  unsigned long *rdata;

  if (*atom == XG_ROWSINPLOT &&
      *atom_type &&
      /**atom_type != NULL &&*/
      *atom_type == XG_ROWSINPLOT_TYPE )
  {
    if (*lendata > 0)
    {
      rdata = (unsigned long *) retdata;

      nr = (int) *rdata++ ;
      npts = (int) *rdata++ ;
      *rdata++ ;    /* skip over is_transient */

      if (nr == xg->nrows && npts > 0)
      {
        /*
         * Assign the new values to the current arrays.
        */
        xg->nrows_in_plot = npts;
        for (i=0; i<xg->nrows_in_plot; i++)
          xg->rows_in_plot[i] = (int) *rdata++;

        reset_rows_in_plot(xg, True);
        plot_once(xg);
      }
    }
  }
  XtFree((XtPointer) retdata);
}

void
read_rows_in_plot(xg)
  xgobidata *xg;
{
    XtGetSelectionValue(
      xg->workspace,
      (Atom) XG_ROWSINPLOT,
      (Atom) XG_ROWSINPLOT_TYPE,
      (XtSelectionCallbackProc) unpack_rowsinplot_data,
      (XtPointer) xg,
      (Time) XtLastTimestampProcessed(display) );
      /*(Time) CurrentTime );*/
}
