/***********************************************************************
*                           tools.c                                    *
*                                                                      *
*  Copyright (C) 1995 by Heikki Tienari. See tis.doc for more info.    *
*                                                                      *
*  This module contains really hard code to master all                 *
*  TIS tools functions.                                                *
*                                                                      *
*  090495 -HT- WorkStyle() and WorkPixel() were clipped from main.c.   *
*              (Great reorganization work done.)                       *
*  100495 -HT- First version of GetArea().                             *
*  110495 -HT- Seems to work. Border is always black at the moment.    *
*              Returned coords are relative to image not to window.    *
*  120495 -HT- Rectangle and Filled rectangle works. Some bugs in      *
*              WorkPixel() are fixed.                                  *
*  250495 -HT- One bug in GetArea() fixed.                             *
*  040595 -HT- Another bug in GetArea() fixed.                         *
*  110595 -HT- No more Illegal starting point errors in GetArea(), we  *
*              are calculating new coords if error reason occurs.      *
*  160595 -HT- Makefile support.                                       *
*  230595 -HT- Little bug in rectangle fixed.                          *
***********************************************************************/

#include <X11/Xlib.h>
#include "image.h"
#include "externs.h"

WorkStyle( x, y, nro )
int x, y, nro;
{
  int cx, cy;

  switch( style )
  {
    case 1:
      for( cy=y; cy<y+20; cy++ )
        for( cx=x; cx<x+20; cx++ )
          WorkPixel( cx, cy, nro );
      break;
    case 2:
      for( cy=y; cy<y+5; cy++ )
        for( cx=x; cx<x+5; cx++ )
          WorkPixel( cx, cy, nro );
      break;
    case 3:
      for( cy=y; cy<y+10; cy+=2 )
        for( cx=x; cx<x+10; cx+=2 )
          WorkPixel( cx, cy, nro );
      break;
    case 4:
      for( cy=y; cy<=y+6; cy+=3 )
        for( cx=x; cx<=x+6; cx+=3 )
          WorkPixel( cx, cy, nro );
      break;
    case 5:
      WorkPixel( x, y, nro );
      break;
    default:
      Quit("Illegal style\n");
      break;
  }
}

/* WorkPixel():  Coords are relative to window origo (=0,MARGIN),   *
*                not to image (as someone could think it to be).   */
WorkPixel( x, y, nro )
int x, y, nro;
{
  int sx, sy;
  unsigned char colr;
  unsigned long theCurPixel;

  if( mode==1 )
  {
  if( nro==1 )
    {
    sx = x-offs_X[1];
    sy = y-offs_Y[1];
    if( x>=offs_X[3] && x<One_Image[3].width+offs_X[3] && y>=offs_Y[3] && 
        y<One_Image[3].height+offs_Y[3] && x>=0 && y>=0 )
      {
        if( sx>=0 && sy>=0 && sx<One_Image[1].width && sy<One_Image[1].height )
        {
        One_Image[3].data.map_lines[y-offs_Y[3]][x-offs_X[3]] = 
           One_Image[1].data.map_lines[sy][sx];
        XSetForeground( theDisplay, theGC, 
           colormap[One_Image[3].data.map_lines[y-offs_Y[3]][x-offs_X[3]]] );
        XDrawPoint( theDisplay, theWindow, theGC, x, y+MARGIN );
        if( One_Image[3].Colour_Map_Size>0 )
          XPutPixel(image_xi[3],x-offs_X[3],y-offs_Y[3],colormap[One_Image[3].data.map_lines[y-offs_Y[Cur_Image]][x-offs_X[Cur_Image]]]);
        else      
          XPutPixel(image_xi[3],x,y,colormap[
            (int)(One_Image[3].data.rgb_lines[y].red[x]/42.5)*36
            +(int)(One_Image[3].data.rgb_lines[y].green[x]/42.5)*6
            +(int)(One_Image[3].data.rgb_lines[y].blue[x]/42.5)]);
        }
      }
    }
  else
    {
    sx = x-offs_X[2];
    sy = y-offs_Y[2];
    if( x>=offs_X[3] && x<One_Image[3].width+offs_X[3] && y>=offs_Y[3] && 
        y<One_Image[3].height+offs_Y[3] && x>=0 && y>=0 )
      {
      if( sx>=0 && sy>=0 && sx<One_Image[2].width && sy<One_Image[2].height )
        {
        One_Image[3].data.map_lines[y-offs_Y[3]][x-offs_X[3]] = 
           One_Image[2].data.map_lines[sy][sx];
        XSetForeground( theDisplay, theGC, 
           colormap[One_Image[3].data.map_lines[y-offs_Y[3]][x-offs_X[3]]] );
        XDrawPoint( theDisplay, theWindow, theGC, x, y+MARGIN );
        if( One_Image[3].Colour_Map_Size>0 )
          XPutPixel(image_xi[3],x,y,colormap[One_Image[3].data.map_lines[y][x]]);
        else      
          XPutPixel(image_xi[3],x,y,colormap[
            (int)(One_Image[3].data.rgb_lines[y].red[x]/42.5)*36
            +(int)(One_Image[3].data.rgb_lines[y].green[x]/42.5)*6
            +(int)(One_Image[3].data.rgb_lines[y].blue[x]/42.5)]);
        }
      }
    }
  }
  else if( mode==2 )
  {
  if( x>=offs_X[Cur_Image] && x<One_Image[Cur_Image].width+offs_X[Cur_Image] && 
      y>=offs_Y[Cur_Image] && y<One_Image[Cur_Image].height+offs_Y[Cur_Image] && 
      x>=0 && y>=0 )
    {
    if( nro==1 )
      {
      theCurPixel = theWhitePixel;
      colr = 0;
      }
    else
      {
      theCurPixel = theBlackPixel;
      colr = 1;
      }
    XSetForeground( theDisplay, theGC, theCurPixel );
    XDrawPoint( theDisplay, theWindow, theGC, x, y+MARGIN );
    if( One_Image[Cur_Image].Colour_Map_Size>0 )
      {
      One_Image[Cur_Image].data.map_lines[y-offs_Y[Cur_Image]][x-offs_X[Cur_Image]] = colr;
      XPutPixel(image_xi[Cur_Image],x-offs_X[Cur_Image],y-offs_Y[Cur_Image],
                theCurPixel );
      }
    else     /* Following code is not in use, it is for possible color vers */ 
      XPutPixel(image_xi[Cur_Image],x,y,colormap[
         (int)(One_Image[Cur_Image].data.rgb_lines[y].red[x]/42.5)*36
         +(int)(One_Image[Cur_Image].data.rgb_lines[y].green[x]/42.5)*6
         +(int)(One_Image[Cur_Image].data.rgb_lines[y].blue[x]/42.5)]);
    }
  }
}

Rectangle( sx1, sy1, bt, filled )
short sx1, sy1;
unsigned char bt, filled;  /* bt = Mouse button, filled = filled */
{
  short sx2, sy2, x, y, step, bordr;

  if( GetArea( &sx1, &sy1, &sx2, &sy2 ) ) {
    printf("Illegal starting point.\n");
    return;
    }
    
  printf("Rectangle: %d,%d-%d,%d\n", sx1, sy1, sx2, sy2 );

  switch( style )
    {
    case 1:
      step=1; bordr=20;
      break;
    case 2:
      step=1; bordr=5;
      break;
    case 3:
      step=2; bordr=10;
      break;
    case 4:
      step=3; bordr=9;
      break;
    case 5:
      step=1; bordr=1;
      break;
    }

  for( x=sx1; x<=sx2; x+=step )
    for( y=sy1; y<=sy2; y+=step )
      if( y<sy1+bordr || y>sy2-bordr )
        WorkPixel( x+offs_X[Cur_Image], y+offs_Y[Cur_Image], bt );
      else if( (x<sx1+bordr || x>sx2-bordr) || filled )
        WorkPixel( x+offs_X[Cur_Image], y+offs_Y[Cur_Image], bt );
}

GetArea( ax1, ay1, ax2, ay2 )
short *ax1, *ay1, *ax2, *ay2;
{
  XWindowAttributes theAttributes;
  unsigned char virgin=True;
  short ww, wh, x1, y1, x2, y2, gx1, gy1, gx2, gy2;

  gx2=gx1=x1=*ax1;
  gy2=gy1=y1=*ay1;

  XGetWindowAttributes( theDisplay, theWindow, &theAttributes );
  ww = theAttributes.width;
  wh = theAttributes.height;

  if( x1<0 ) x1=0;
  if( y1<MARGIN ) y1=MARGIN;
  if( x1>=One_Image[Cur_Image].width+offs_X[Cur_Image] ) x1=One_Image[Cur_Image].width+offs_X[Cur_Image]-1;
  if( y1>=MARGIN+One_Image[Cur_Image].height+offs_Y[Cur_Image] ) y1=MARGIN+One_Image[Cur_Image].height+offs_Y[Cur_Image]-1;
  if( x1<offs_X[Cur_Image] ) x1=offs_X[Cur_Image];
  if( y1<offs_Y[Cur_Image]+MARGIN ) y1=offs_Y[Cur_Image]+MARGIN;
  if( x1>ww ) x1=ww;
  if( y1>wh ) y1=wh;
  /*if( x1<0 || y1-MARGIN<0 || x1>=One_Image[Cur_Image].width+offs_X[Cur_Image] ||
      y1-MARGIN>=One_Image[Cur_Image].height+offs_Y[Cur_Image] ||
      x1<offs_X[Cur_Image] || y1-MARGIN<offs_Y[Cur_Image] || x1>ww || y1>wh )
    return(1);*/          /* Illegal starting point. */

  while(1)
    {
    XNextEvent( theDisplay, &theEvent );

    switch( theEvent.type )
      {
      case Expose:
        printf("Expose event! How did you made that?\n");
        break;
      case ConfigureNotify:
        printf("ConfigureNotify event! How did you made that?\n");
        break;
      case KeyPress:
        printf("Please, do not touch the keyboard buttons.\n");
        break;
      case ButtonPress:
        printf("Hey, this is impossible.\n");
        break;
      case MotionNotify:
        if( !virgin )
          {
          /* Draw disturbed parts of image */
          if( x2>=x1 ) {
            gx1=x1; gx2=x2; } 
          else {
            gx1=x2; gx2=x1; }
          if( y2>=y1 ) {
            gy1=y1; gy2=y2; } 
          else {
            gy1=y2; gy2=y1; }
          XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
                    gx1-offs_X[Cur_Image], gy1-offs_Y[Cur_Image]-MARGIN, 
                    gx1, gy1, gx2-gx1+1, 1 );
          XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
                    gx1-offs_X[Cur_Image], gy1-offs_Y[Cur_Image]-MARGIN, 
                    gx1, gy1, 1, gy2-gy1+1 );
          XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
                    gx2-offs_X[Cur_Image], gy1-offs_Y[Cur_Image]-MARGIN, 
                    gx2, gy1, 1, gy2-gy1+1 );
          XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
                    gx1-offs_X[Cur_Image], gy2-offs_Y[Cur_Image]-MARGIN, 
                    gx1, gy2, gx2-gx1+1, 1 );
          }
        /* Make the frame */
        x2 = theEvent.xbutton.x;
        y2 = theEvent.xbutton.y;
        if( x2<0 ) x2=0;
        if( x2<offs_X[Cur_Image] ) x2=offs_X[Cur_Image ];
        if( x2>=ww-1 ) x2=ww-1;
        if( x2>=One_Image[Cur_Image].width+offs_X[Cur_Image]-1 ) x2=One_Image[Cur_Image].width+offs_X[Cur_Image]-1;
        if( y2<MARGIN ) y2=MARGIN;
        if( y2<offs_Y[Cur_Image]+MARGIN ) y2=offs_Y[Cur_Image]+MARGIN;
        if( y2>=wh-1 ) y2=wh-1;
        if( y2>=One_Image[Cur_Image].height+offs_Y[Cur_Image]-1+MARGIN ) y2=One_Image[Cur_Image].height+offs_Y[Cur_Image]-1+MARGIN;
        XSetForeground( theDisplay, theGC, theBlackPixel );
        XDrawLine( theDisplay, theWindow, theGC, x1, y1, x2, y1 );
        XDrawLine( theDisplay, theWindow, theGC, x1, y1, x1, y2 );
        XDrawLine( theDisplay, theWindow, theGC, x2, y1, x2, y2 );
        XDrawLine( theDisplay, theWindow, theGC, x1, y2, x2, y2 );
        virgin=False;
        break;
      case ButtonRelease:
        if( !virgin )
          {
          /* Draw disturbed parts of image */
          if( x2>=x1 ) {
            gx1=x1; gx2=x2; } 
          else {
            gx1=x2; gx2=x1; }
          if( y2>=y1 ) {
            gy1=y1; gy2=y2; } 
          else {
            gy1=y2; gy2=y1; }
          XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
                    gx1-offs_X[Cur_Image], gy1-offs_Y[Cur_Image]-MARGIN, 
                    gx1, gy1, gx2-gx1+1, 1 );
          XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
                    gx1-offs_X[Cur_Image], gy1-offs_Y[Cur_Image]-MARGIN, 
                    gx1, gy1, 1, gy2-gy1+1 );
          XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
                    gx2-offs_X[Cur_Image], gy1-offs_Y[Cur_Image]-MARGIN, 
                    gx2, gy1, 1, gy2-gy1+1 );
          XPutImage(theDisplay, theWindow, theGC, image_xi[Cur_Image],
                    gx1-offs_X[Cur_Image], gy2-offs_Y[Cur_Image]-MARGIN, 
                    gx1, gy2, gx2-gx1+1, 1 );
          }
        *ax1=gx1-offs_X[Cur_Image];
        *ay1=gy1-MARGIN-offs_Y[Cur_Image];
        *ax2=gx2-offs_X[Cur_Image];
        *ay2=gy2-MARGIN-offs_Y[Cur_Image];
        return(0);
        break;
      }
    }
}
