/*======================================================================
                    T R A C E . M 
                    doc: Tue Sep 10 11:59:03 1991
                    dlm: Mon Nov 11 16:44:28 1991
                    (c) 1991 A.M.J. Thurnherr
                    uE-Info: 8 9 FALSE 0 0 72 2 2 ofnI
======================================================================*/
/* MPL */
#include	<stdio.h>
#include	"types.h"
#include	"intersect.h"
#include	"xform.h"
#include	"utilities.h"
#include	"ppm.h"
#include	"world.h"
#include	"lmodel.h"

#define	ORI(dir) 	(frust[NEAR][PA][dir]+u*udNear[dir]+v*vdNear[dir])
#define	TRG(dir) 	(frust[FAR][PA][dir]+u*udFar[dir]+v*vdFar[dir])

void trace()	
{
	Vec3	udNear,udFar,vdNear,vdFar;
	Isect	*is;
	int	u,v;
	Ray	r;
	Col	pix;

	makeFrust();
	defDvec3(udNear,frust[NEAR][PA],frust[NEAR][PB],xSize);
	defDvec3(vdNear,frust[NEAR][PA],frust[NEAR][PD],ySize);
	defDvec3(udFar,frust[FAR][PA],frust[FAR][PB],xSize);
	defDvec3(vdFar,frust[FAR][PA],frust[FAR][PD],ySize);
	for (u=0; u<xSize; u++) {				/* Primary rays x-dir */
	    putchar('.'); fflush(stdout);
	    for (v=0; v<ySize; v++) {				/* Primary rays y-dir */
		setPnt3(r.ori,ORI(VX),ORI(VY),ORI(VZ));
		defVec3(r.dir,r.ori,TRG(VX),TRG(VY),TRG(VZ));
		nrmVec3(r.dir,r.len);
		is = (rayBoxP(r,world.bBox,EPS,r.len)) ? rayWorld(r,EPS,r.len) : NULL;
		if (is == NULL) {				/* no intersection */
		    ppmPixel(world.ambient);
		} else {					/* check shadows */
		    lighten(is,r.dir,pix);			/* light model */
		    clampCol(pix);				/* clamp to range */
		    ppmPixel(pix);
		}
	    }
	}
	putchar('\n');
}
