/*

                              DISCLAIMER
                              ==========

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   

    If the software is modified by someone else and passed on, we, the authors
    want its recipients to know that what they have is not the original, so
    that any problems introduced by others will not reflect on the original
    authors' reputations.
*/                                            

/*
** Test program for transforms module.
** W.T. Hewitt.
*/

#include "nurbh.h"

#define LINE printf("*************************************\n")

PR_nurb c1, c2, c3, c4;
PR_nurb s1, s2, s3, s4;
Ppoint3 pt;

Pint ee,ii,nsteps,i,j,nxpt,nypt;
Pfloat txpts[100];
Pfloat typts[100];

Pfloat dt,t1,t2,tol;
Pmatrix3 xx;
PR_dir  tnew= {0};
FILE *fp;

void putpoint3(C(FILE *)fp, C(Ppoint3)xx)
PreANSI(FILE *fp)
PreANSI(Ppoint3 xx)
{
fprintf(fp,"%12.4g%12.4g%12.4g",xx.x,xx.y,xx.z);
}

main()
{
  printf("Testing NURBS\n");

  nrb_clear(&c1);
  nrb_clear(&c2);
  nrb_clear(&c3);
  nrb_clear(&c4);

  nrb_clear(&s1);
  nrb_clear(&s2);
  nrb_clear(&s3);
  nrb_clear(&s4);

  LINE;
  tol = 0.05;

  fp =fopen("pts2d.dat","r");

  while (fscanf(fp,"%d%d",&nxpt,&nypt)>0){
    nrb_init(4,nxpt+4,4,nypt+4,&s1);
    nrb_makeknots(0.0,1.0,&s1.pf_u);
    nrb_makeknots(0.0,1.0,&s1.pf_v);
    nrb_allocatepts(nxpt*nypt,&s1.pf_ppp);

    for (i=0; i< nxpt;i++) txpts[i] = (Pfloat)(i)/ (Pfloat)(nxpt-1);
    for (i=0; i< nypt;i++) typts[i] = (Pfloat)(i)/ (Pfloat)(nypt-1);

    for (j=1; j <=nypt;j++) {
         for (i=0; i <= nxpt;i++) {
           fscanf(fp,"%f%f%f",&pt.x,&pt.y,&pt.z);
           s1.pf_ppp->pts[nrb_index(i,j,nxpt)-1] = ptk_pt3topt4(&pt);
         }
    }
    LINE;
    printf("Dump before nrb_interpolate\n");
    nrb_dump(stdout,&s1);
    nrb_interpolate(&s1,tol,&s2);
    LINE;
    printf("Dump after 1st nrb_interpolate\n");
    nrb_dump(stdout,&s2);

    nrb_interpolate(&s2,tol,&s3);
    LINE;
    printf("Dump after 2nd nrb_interpolate\n");
    nrb_dump(stdout,&s3);
    LINE;
    LINE;

    printf("Dump after 1st nrb_spli2d\n");
    nrb_spli2d(&s1,2,txpts,&s2);
    nrb_dump(stdout,&s2);
    LINE;

    printf("Dump after 2nd nrb_spli2d\n");
    nrb_spli2d(&s2,2,typts,&s3);
    nrb_dump(stdout,&s3);

  }

  LINE;
  nrb_stats(stdout);
  nrb_dumplists(stdout);

  printf("End of NURBs test.\n");
  return 0;
}

/* End. */

