/*
 * file:     imageMenu.c
 * author:   Wes Barris
 * date:     10/19/93
 * purpose:  creates File menu
 *
 * copyright info:
 *
 *    @Copyright 1993
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "icop.h"
#include "proto.h"
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/ToggleB.h>

extern ICOP	icop;

Widget		imageType[5];

static void
ImageTypeCB(Widget w, XtPointer client_data, char *call_data)
{
   if (!((XmToggleButtonCallbackStruct *)call_data)->set)
      return;
   ShowImageCB(icop.image.w, (XtPointer)NULL, (char *)NULL);
}

static struct {
   char   *name;         /* name of menu item widget */
   void   (*func)(Widget, XtPointer, char*);      /* callback function */
   } list[] = {
      { "legal",	ImageTypeCB},
      { "illegal",	ImageTypeCB},
      { "correctp",	ImageTypeCB},
      { "correcti",	ImageTypeCB},
      { "original",	ImageTypeCB},
      };

void
ImageMenuInit(Widget parent)
{
   int		i, n;
   Arg		arg[10];
   Widget	imageMenu, w;
/*
 * Create pulldown menu.
 */
   n = 0;
   XtSetArg(arg[n], XmNradioBehavior, True); n++;
   imageMenu = XmCreatePulldownMenu(parent, "imageMenu", arg, n);
/*
 * Create the entries for the image menu.
 */
   for (i = 0; i < XtNumber(list); i++) {
      if (list[i].name != NULL) {
         imageType[i] = XmCreateToggleButton(imageMenu, list[i].name, arg, 0);
         XtAddCallback(imageType[i], XmNvalueChangedCallback, (XtCallbackProc)list[i].func, list[i].name);
         }
      else 
         imageType[i] = XmCreateSeparator(imageMenu, "sep", arg, 0);
      XtManageChild(imageType[i]);
      }
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, imageMenu); n++;
   w = XmCreateCascadeButton(parent, "image", arg, n);
   XtManageChild(w);
}
