/****************************************************************************\
*                                                                            *
*  THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE  *
*     WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR     *
*   PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.   *
*                                                                            *
*     In no event will the supplier be liable for any lost revenue           *
*   or profits or other special, indirect and consequential damages, even    *
*    if the supplier has been advised of the possibility of such damages.    *
*                                                                            *
*             Users may copy or modify this file without charge,             *
*       but are NOT authorized to license or sell it to anyone.              *
*                                                                            *
\****************************************************************************/

/****************************************************************************\
*                                                                            *
*    If you modify this software, you should include a notice giving the     *
* name of the person performing the modification, the date of modification,  *
* and the reason for such modification.  Bug reports or fixes should be sent *
*        to the author, who may or may not act on them as he desires:        *
*                                                                            *
* Internet: raytrace@cutmcvax.cs.curtin.edu.au                               *
*                                                                            *
* Mail   : School of Computer Science         | Tel: 619 351 7680            *
*          Curtin University of Technology    | Fax: 619 351 2819            *
*          Kent Street, Bentley                                              *
*          Western Australia, 6102                                           *
*                                                                            *
\****************************************************************************/

/*
 Copyright (c) 1991 Andrew Marriott.
 */

#include "face_data.h"
extern int debug;

#ifdef DEBUG
main()
{
	foreground();noport();
	winopen("fred");
#else
init_for_cmode()
{
#endif
	set_col_indices(  iris , " iris" );
	set_col_indices(  flesh , " flesh" ) ;
	set_col_indices(  lips , " lips" ) ;
	set_col_indices(  eyelash , " eyelash" ) ;
	set_col_indices(  teeth , " teeth" ) ;
	set_col_indices(  pupil , " pupil" ) ;
	set_col_indices(  fringe , " fringe" ) ;
	set_col_indices(  eyewhite , " eyewhite" ) ;
}

static short red[256],green[256],blue[256];
set_col_indices(mat,array_name)
float mat[];
char *array_name;
{
register int i;
static int first=1;
int S_index= -1, D_index= -1, A_index= -1, C_index = -1;

	if(debug)printf("%s:\n",array_name);

	if(first)
	{
		for(i=0;i<256; i++)
			getmcolor(i, red+i, green+i, blue+i);
		first=0;
	}

	for(i=0;mat[i] !=LMNULL;i++)
	{
	  switch((int)mat[i])
	  {
	  case SPECULAR:
		S_index=i+1;
		i+=3;
		break;
	  case DIFFUSE:
		D_index=i+1;
		i+=3;
		break;
	  case AMBIENT:
		A_index=i+1;
		i+=3;
		break;
	  case SHININESS:
		i++;
		break;
	  case COLORINDEXES:
		C_index= i+1;
		i+=3;
		break;
	  }
	}
	if(debug)
		printf("\tAMBIENT: ");
	check(&mat[A_index],&A_index,0);
	if(debug)
		printf("\tDIFFUSE: ");
	check(&mat[D_index],&D_index,A_index);
	if(debug)
		printf("\tSPECULAR:");
	check(&mat[S_index],&S_index,D_index);
	mat[C_index  ] = A_index;
	mat[C_index+1] = D_index;
	mat[C_index+2] = S_index;
	if ((A_index > D_index) || (D_index >S_index))
		printf("Problem with indices\n");
}

check(in,index,start_index)
float in[3];
int start_index,*index;
{
float out[3];
int tmp,dist;
int dist_index;
register int r,g,b;
register int i;
static int cl_index=16;

	r=255*in[0];
	g=255*in[1];
	b=255*in[2];
	mapcolor(cl_index,r,g,b);

	*index= cl_index++;

	return;


	dist_index= start_index;
	dist=
		(r-red[start_index])*(r-red[start_index])+
		(g-green[start_index])*(g-green[start_index])+
		(b-blue[start_index])*(b-blue[start_index]);
	for(i=start_index+1;i<256; i++)
	{
	  tmp=
		(r-red[i])*(r-red[i])+
		(g-green[i])*(g-green[i])+
		(b-blue[i])*(b-blue[i]);
	  if(tmp ==0)
	  {
		dist_index=i;
		break;
	  }
	  if(tmp<dist)
	  {
		dist=tmp;
		dist_index=i;
	  }
	}
	out[0]=red[dist_index]/255.0;
	out[1]=green[dist_index]/255.0;
	out[2]=blue[dist_index]/255.0;
	*index=dist_index;
	if(debug)
	    printf("Closest to %4.2lf %4.2lf %4.2lf is %4.2lf,%4.2lf,%4.2lf = %3d\n",
		in[0],in[1],in[2],out[0],out[1],out[2],dist_index);
}
