#include "salem.h"

int    set_shade();

initialize_shading()
{
	register_client("smooth", set_shade, "smooth [objname]");
	register_client("flat", set_shade, "flat [objname]");
	register_client("wire", set_shade, "wire [objname]");
	register_client("mixed",set_shade, "mixed [objname gst gend cst cend]");
}

static int default_shading = GOURAUD;

set_shade(argc,argv)
int argc;
char **argv;
{
	object_t *obj;
	int shade, gst, gend, cst, cend, lp;

	if (strcmp(argv[0],"smooth") == 0)	shade = GOURAUD;
	else if (strcmp(argv[0],"flat") == 0)	shade = FLAT;
	else if (strcmp(argv[0],"wire") == 0)	shade = WIREFRAME;
	else if (strcmp(argv[0],"mixed") == 0)	shade = MIXED;
	else	return;

	if (argc == 1)		{
		default_shading = shade;	
		return;
		}
	else 	{
		if (NULL == (obj = get_object(argv[1]))) return;
		obj->shading = shade;
		}
	if (shade == MIXED)     {
		lp = obj->n_polygons - 1 ;
		if (argc != 6)  {
			gst = 0 ;
			gend = lp;
			cst = atoi(argv[2]);
			cend = atoi(argv[3]);
			if ((cst < (-lp)) || (cst > lp)) cst = 0;
			if ((cend < (-lp)) || (cend > lp)) cend = 0;
			}
		else    {
			gst = atoi(argv[2]);
			gend = atoi(argv[3]);
			cst = atoi(argv[4]);
			cend = atoi(argv[4]);
			if ((gst < 0) || (gst > lp)) gst = 0;
			if ((gend < 0) || (gend > lp)) gend = lp;
			if ((cst < (-lp)) || (cst > lp)) cst = 0;
			if ((cend < (-lp)) || (cend > lp)) cend = 0;
			}
	obj->g_st = gst;
	obj->g_end = gend;
	obj->c_st = cst;
	obj->c_end = cend;
		}
}

/*
 *  These procedures implement the hierarchical object "directories."
 *  This includes name lookup, and object and link creation and deletion.
 */

parse_path(buf,elt)
char	*buf,**elt;
{
	int	nc = 0 ;
	char	*name_elt;

	name_elt = strtok(buf,"/");
	while (name_elt) {
		elt[nc++] = name_elt;
		name_elt = strtok((char*)0,"/");
		}
	return nc;
}

objlink_t* get_link(parent,child)
object_t	*parent,*child;
{
	objlink_t	*link;

	for (link = child->parent_list; link; link = link->p_next)
		if (link->parent == parent) break;
	return link;
}

static object_t* get_object_by_name(parent,cname)
object_t	*parent;
char		*cname;
{
	objlink_t	*link;
	object_t	*rv;

	for (link = parent->child_list; link; link = link->c_next)
		if (!strcmp(link->child->name,cname)) break;
	if (link) rv = link->child; else rv = NULL;
	return rv;
}

object_t* get_subobject(arg_name,parent) 
char		*arg_name;
object_t	*parent;
{
	int		i,nc;
	char		buf[MAXLINE],*name_elt,*elt[128];
	object_t	*obj;

	nc = parse_path(strcpy(buf,arg_name),elt);
	obj = parent;
	for (i = 0; obj && (i < nc); i++)
		obj = get_object_by_name(obj,elt[i]);
	return obj;
}

object_t* get_object(arg_name)
char		*arg_name;
{
	return(get_subobject(arg_name, (arg_name[0] != '/') ? World : Root ));
}

make_link(parent,child)
object_t	*parent,*child;
{
	objlink_t	*link = NEW(objlink_t);
	
	link->parent	= parent;
	link->child	= child;
	link->c_prev	= NULL;
	link->c_next	= parent->child_list;
	link->p_prev	= NULL;
	link->p_next	= child->parent_list;

	if (child->parent_list) child->parent_list->p_prev = link;
	if (parent->child_list) parent->child_list->c_prev = link;
	parent->child_list = link;
	child->parent_list = link;
}

zap_link(link)
objlink_t	*link;
{
	if (link->c_next) link->c_next->c_prev = link->c_prev;
	if (link->p_next) link->p_next->p_prev = link->p_prev;

	if (link->c_prev) link->c_prev->c_next = link->c_next;
	else link->parent->child_list = link->c_next;
	if (link->p_prev) link->p_prev->p_next = link->p_next;
	else link->child->parent_list = link->p_next;
}

delete_link(link)
objlink_t	*link;
{
	object_t	*child = link->child;
	zap_link(link);
	if (child->parent_list == NULL) delete_object(child);
}


/*
 * this assumes that it really is safe to create the object.
 * the caller guarantees there will be no duplicates, etc.
 */
static object_t* internal_newobj(name,parent,argc,argv)
char		*name;
object_t	*parent;
int		argc;
char		**argv;
{
	char		buf[MAXLINE];
	object_t	*rv;
	int		i,j;

	rv 			= NEW(object_t);
	rv->name		= strdup(name);
	rv->owner = parent;
	rv->parent_list		= NULL;
	rv->child_list		= NULL;
	if (parent)
		make_link(parent,rv);
	emu_copy_matrix(rv->v, Identity);

	rv->displayed = 1.0;
	rv->shading		= default_shading ;
	rv->user		= NULL;
	rv->creation_string 	= strdup(varcat(argc,argv,buf));
	rv->mark 		= FALSE;
	rv->flags		= SL_RUNNABLE | SL_MOVABLE | SL_REMOVABLE;

	rv->tick		= NULL;
	rv->editfn		= NULL;
	rv->n_patches		= 0;
	rv->patches		= NULL;
	rv->n_polygons		= 0;
	rv->polygons		= NULL;
	rv->n_vertices		= 0;
	rv->v_list		= NULL;

	return rv;
}

/*
 * create a new object.  this always succeeds.  the path is created if it does
 * not already exist.  if the named object already exists, a new version is
 * created, shades of TENEX from beyond the grave.
 *
 * if parent == NULL, a new root object is created.
 */
object_t *new_subobject(objname,parent,argc,argv)
char		*objname;
object_t	*parent;
int 		argc;
char 		**argv;
{
	int		i,nc;
	char		buf[MAXLINE],leaf_name[MAXLINE],*elt[128];
	object_t	*rv,*mypar,*obj;

	if (parent == NULL) return internal_newobj(objname,parent,argc,argv);

	nc = parse_path(strcpy(buf,objname),elt);
	mypar = parent;
	for (i = 0; i < nc - 1; i++) {
		obj = get_object_by_name(mypar,elt[i]);
		if (obj == NULL) obj = internal_newobj(elt[i],mypar,argc,argv);
		mypar = obj;
	}

	
	strcpy(leaf_name,elt[nc - 1]);
	i = 0;
	while (get_object_by_name(mypar,leaf_name))
		sprintf(leaf_name,"%s.%d",elt[nc-1],i++);

	rv = internal_newobj(leaf_name,mypar,argc,argv);
	return rv;
}

object_t *new_object(objname,argc,argv)
char		*objname;
int 		argc;
char		*argv;
{
	return new_subobject(objname,(objname[0]=='/')?Root:World,argc,argv);
}

undangle_obj(obj)
object_t	*obj;
{
	int			i;
	motion_t	*m;
	for (i = 0; i < MAXWINDOWS; i++)
		if (Window[i].cluster == obj) Window[i].cluster = NULL;
	for (m = Motions; m; m = m->next) {
		if ((m->moving_obj == obj) || (m->axes_obj == obj)
			|| (m->center_obj == obj)) stop_motion(m);
	}
	if (Selected.object == obj) Selected.object = NULL;
	if (obj->win) {
		for (i = 0; i < MAXWINDOWS; i++) {
			if ((Window[i].flags & WINDOW_EXISTS) && (Window[i].obj == obj))
				Window[i].flags &= ~WINDOW_EXISTS;
		}
	}
}

/* delete_object:
 * completely remove an object and its links.
 */
delete_object(obj)
object_t	*obj;
{
	int		i;
	objlink_t	*link,*next;

	if (!(obj->flags & SL_REMOVABLE))
		ERR_RET_2("cannot delete",obj->name);
	
	undangle_obj(obj);
	for (link = obj->child_list; link; link = next) {
		next = link->c_next;
		delete_link(link);
		}
	for (link = obj->parent_list; link; link = next) {
		next = link->p_next;
		zap_link(link);
		}

	/* delete vertices, polygons */
	for (i = 0; i < obj->n_polygons; i++)
		free(obj->polygons[i].v);
	if (obj->polygons) free(obj->polygons);
	if (obj->v_list) free(obj->v_list);
	if (obj->patches) free(obj->patches);
	free(obj->name);
	free(obj);
}

/* prints the name of an object onto a character string */
char* get_objname(buf,obj)
char		*buf;
object_t	*obj;
{
	int		i;
	char		*p,*q;
	object_t	*path[256];
	
	i = 0;
	while (obj && (obj != Root)) {
		path[i++] = obj;
		obj = obj->owner;
	}
	p = buf;
	while (i--) {
		q = path[i]->name;
		*p++ = '/';
		while (*p = *q++) p++;
	}
	return buf;
}

get_position(M, obj)
Matrix M;
object_t *obj;
{
	if (obj == World)
		emu_copy_matrix(M, Identity);
	else {
		get_position(M, obj->owner);
		emu_mult(M, obj->v);
	}
}
