#include "salem.h"

int do_transform(), stop();
initialize_motion()
{
	Motions = (motion_t *) 0;
	register_client("transform", do_transform, "transform object axes center rotate|translate|ztranslate x y z");
	register_client("movement", do_transform, "movement object axes center rotate|translate|ztranslate x y z");
	register_client("stop",stop,"stop [object [axes [center [transformation]]]]");
/*	register_client("Position", do_position, "Position object ref_object [center|xaxis|yaxis|zaxis|matrix] args...");*/
}

#define MULTIPLY 27
#define DIVIDE 113
double etof(s)
char *s;
{
	double val = 1;
	int op = MULTIPLY;
	if (!*s) return 0;
	while (*s) {
		while (*s == '-') {
			val = -val;
			s++;
		}
		if (op == MULTIPLY) val *= atof(s);
		else val /= atof(s);
		while (*s && *s != '/' && *s != '*')
			s++;
		if (*s == '/') { op = DIVIDE; s++; }
		if (*s == '*') { op = MULTIPLY; s++; }
	}
	return val;
}

int myrotate(), mytranslate(), ztranslate();
int translate_to();
#define TRANSFORM 't'
#define MOVEMENT 'm'
do_transform(argc,argv)
int	argc;
char	**argv;
{
	motion_t motion;

	if (argc != 8) {
		fprintf(stderr, "Usage: %s object axes center rotate|translate|ztranslate x y z\n",argv[0]);
		return;
		}
	motion.moving_obj = get_object(argv[1]);
	motion.axes_obj = get_object(argv[2]);
	motion.center_obj = get_object(argv[3]);
	if (motion.moving_obj == NULL) {
		fprintf(stderr,"object %s does not exist\n",argv[1]);
		return;
	}
	if (motion.moving_obj->flags & SL_MOVABLE == FALSE)	{
		fprintf(stderr,"don't have permission to move %s\n",argv[1]);
		return;
	}
	if (!motion.axes_obj)
		motion.axes_obj = motion.moving_obj;
	if (!motion.center_obj)
		motion.center_obj = motion.moving_obj;
	if (argv[4][0] == 'r')
		motion.local_transform_func = myrotate;
	else if (argv[4][0] == 't')
		motion.local_transform_func = mytranslate;
	else
		motion.local_transform_func = ztranslate;
	
	motion.amount[0] = etof(argv[5]);
	motion.amount[1] = etof(argv[6]);
	motion.amount[2] = etof(argv[7]);
	
	if (argv[0][0] == TRANSFORM)
		apply_motion(&motion);
	else
		repeat_motion(&motion,
			argv[5][0] == '\0', argv[6][0] == '\0', argv[7][0] == '\0');
}

stop(argc,argv)
int argc;
char **argv;
{
	motion_t motion;
	if (argc > 5) {
		printf("Usage: stop [obj [axes_obj [center_obj [transformation]]]]");
		return;
	}
	motion.moving_obj = argc > 1 ? get_object(argv[1]) : 0;
	motion.axes_obj = argc > 2 ? get_object(argv[2]) : 0;
	motion.center_obj = argc > 3 ? get_object(argv[3]) : 0;
	if (argc > 4)
		if (argv[4][0] == 'r')
			motion.local_transform_func = myrotate;
		else if (argv[4][0] == 't')
			motion.local_transform_func = mytranslate;
		else
			motion.local_transform_func = ztranslate;
	else
		motion.local_transform_func = 0;
	stop_motion(&motion);
}

apply_motion(m)
motion_t *m;
{
	Matrix M;
	Matrix T_o, T_x, T_p;
	Matrix T_c, T_L, T, S;
	float pos[4];
	get_position(T_o, m->moving_obj);
	get_position(T_x, m->axes_obj);
	get_position(T_p, m->center_obj);
	
	invert_matrix(T_x, S);
	emu_mult(S,T_p);
	pos[0]=S[3][0]; pos[1]=S[3][1]; pos[2]=S[3][2]; pos[3]=S[3][3];
	emu_copy_matrix(T_c,T_x);
	translate_to(S, pos);
	emu_mult(T_c, S);

	invert_matrix(T_c, T);
	emu_mult(T, T_o);
	pos[0]=T[3][0]; pos[1]=T[3][1]; pos[2]=T[3][2]; pos[3]=T[3][3];
	(m->local_transform_func)(T_L, m->amount, pos);

	invert_matrix(T, S);
	emu_copy_matrix(M, S);
	emu_mult(M, T_L);
	emu_mult(M, T);

	if (m->moving_obj->editfn)
		(m->moving_obj->editfn)(m->moving_obj, M);
	else
		emu_mult(m->moving_obj->v,M);
}

do_motion() {
	motion_t *m;
	int redraw = FALSE;
	for (m = Motions; m; m = m->next) {
		if (m->moving_obj->win)
			m->moving_obj->win->flags |= REDRAW;
		else
			redraw = TRUE;
		apply_motion(m);
	}
	return redraw;
}

objcmp(o1,o2)
object_t *o1, *o2;
{
	return (o1 && o2 && (o1 != o2));
}

repeat_motion(m, ignore0,ignore1,ignore2)
motion_t *m;
Boolean ignore0,ignore1,ignore2;
{
	motion_t *s;
	for (s = Motions; s; s = s->next)
		if (!objcmp(s->moving_obj, m->moving_obj)
		 && !objcmp(s->axes_obj, m->axes_obj)
		 && !objcmp(s->center_obj, m->center_obj)
		 && s->local_transform_func ==  m->local_transform_func)
			break;
	if (!s) {
		s = (motion_t *) malloc(sizeof(motion_t));
		s->next = Motions;
		Motions = s;
	} else {
		if (ignore0) m->amount[0] = s->amount[0];
		if (ignore1) m->amount[1] = s->amount[1];
		if (ignore2) m->amount[2] = s->amount[2];
	}
	m->next = s->next;
	*s = *m;
}

stop_motion(m)
motion_t *m;
{
	motion_t **s, *t;
	for (s = &Motions; *s; ) {
		if (!objcmp((*s)->moving_obj, m->moving_obj)
		 && !objcmp((*s)->axes_obj, m->axes_obj)
		 && !objcmp((*s)->center_obj, m->center_obj)
		 && (!m->local_transform_func || (*s)->local_transform_func == m->local_transform_func)) {
			t = *s;
			*s = (*s)->next;
			free(t);
		} else *s = (*s)->next;
	}
}

myrotate(M, amount, pos)
Matrix M;
Coord amount[3];
Coord pos[4];
{
	emu_copy_matrix(M, Identity);
	emu_rot(M, amount[0], 1, 2);
	emu_rot(M, amount[1], 2, 0);
	emu_rot(M, amount[2], 0, 1);
}

mytranslate(M, amount, pos)
Matrix M;
Coord amount[3];
Coord pos[4];
{
	Coord npos[4];
	if (Geometry_type == EUCLIDEAN) {
		npos[0] = amount[0];
		npos[1] = amount[1];
		npos[2] = amount[2]; 
		npos[3] = 1;
	} else if (Geometry_type == PROJECTIVE) {
		npos[0] = sin(amount[0]);
		npos[1] = sin(amount[1]);
		npos[2] = sin(amount[2]);
		npos[3] = cos(amount[0]) * cos(amount[1]) * cos(amount[2]);
	} else if (Geometry_type == HYPERBOLIC) {
		npos[0] = sinh(amount[0]);
		npos[1] = sinh(amount[1]);
		npos[2] = sinh(amount[2]);
		npos[3] = cosh(amount[0]) * cosh(amount[1]) * cosh(amount[2]);
	}
	translate_to(M, npos);
}

geom_translate(M, x,y,z)
Matrix M;
Coord x,y,z;
{
	Coord amount[3];
	Coord pos[4];
	amount[0] = x; amount[1] = y; amount[2] = z;
	pos[0] = pos[1] = pos[2] = pos[3] = 0;
	mytranslate(M, amount, pos);
}

/* rotate_from gives a matrix such that M (pos) = (x,0,0,y). */
rotate_from(M, pos)
Matrix M;
Coord pos[4];
{
	Coord t;
	Coord r = pos[0];
	Matrix N;

	emu_copy_matrix(M, Identity);
	r = sqrt(pos[1]*pos[1] + r*r);
	if (r != 0) {
		M[0][0] = M[1][1] = pos[0]/r;
		M[1][0] = -(M[0][1] = pos[1]/r);
	}
	emu_copy_matrix(N, Identity);
	r = sqrt(pos[2]*pos[2] + r*r);
	if (r != 0) {
		N[0][0] = N[2][2] = sqrt(pos[0]*pos[0]+pos[1]*pos[1])/r;
		N[2][0] = -(N[0][2] = pos[2]/r);
	}
	emu_mult(M,N);
}

translate_to(M, pos)
Matrix M;
Coord pos[4];
{
	Matrix R,T;
	if (Geometry_type == EUCLIDEAN) {
		emu_copy_matrix(M, Identity);
		M[3][0] = pos[0];
		M[3][1] = pos[1];
		M[3][2] = pos[2];
	} else if (Geometry_type == HYPERBOLIC) {
		rotate_from(R, pos);
		emu_copy_matrix(M, R);
		emu_copy_matrix(T, Identity);
		T[0][3]=T[3][0] = sqrt(pos[0]*pos[0] + pos[1]*pos[1] + pos[2]*pos[2]);
		T[0][0]=T[3][3] = pos[3];
		emu_mult(M, T);
		invert_matrix(R,T);
		emu_mult(M, T);
	} else { /* Geometry_type == PROJECTIVE */
		emu_copy_matrix(M, Identity);
		rotate_from(R, pos);
		emu_copy_matrix(M, R);
		emu_copy_matrix(T, Identity);
		T[0][0] = T[3][3] = pos[3];
		T[0][3] = -(T[3][0] = sqrt(pos[0]*pos[0]+pos[1]*pos[1]+pos[2]*pos[2]));
		emu_mult(M, T);
		invert_matrix(R,T);
		emu_mult(M, T);
	}
}

ztranslate(M, amount, pos)
Matrix M;
Coord amount[3];
Coord pos[4];
{
	Coord f;
	if (Geometry_type == EUCLIDEAN) {
		emu_copy_matrix(M, Identity);
		f = exp(amount[2]);
		if (f == 1) {
			M[3][0] = pos[2] * amount[0];
			M[3][1] = pos[2] * amount[1];
		} else {
			M[3][2] = pos[2] * (f - 1);
			M[3][0] = (amount[0] / amount[2]) * M[3][2];
			M[3][1] = (amount[1] / amount[2]) * M[3][2];
		}
	} else /* ztranslate isn't very useful in non-euclidean spaces. */
		mytranslate(M, amount, pos);
}
