#include "salem.h"

perspective_view(M, win,eye)
Matrix M;
window_t* win;
int		eye;
{
	Matrix			T;
	projection_t	*p = &(win->proj);
	int				xsize,ysize;
	Coord			zoom;

	getsize(&xsize, &ysize);
	zoom = p->zoom;
	emu_copy_matrix(M,Identity);
	M[0][0] = 1/zoom;
	M[1][1] = xsize / (zoom * ysize);
	if (p->type == PERSPECTIVE) {
		M[2][2] = 1; M[2][3] = 1;
		M[3][2] = -.01; M[3][3] = 0;
		}
	/* !! try ortho and see what's wrong */
		M[2][2] = .1;
	if (eye) {
		emu_copy_matrix(T, Identity);
		T[2][0] = eye*win->fe/win->fp;
		T[3][0] = win->fe;
		emu_mult(M, T);
	}
}

char *GeomUsage = "Usage: geometry type (Projective | Euclidean | Hyperbolic)";
set_geometry(argc,argv)
int argc;
char **argv;
{
	char 	*junk;
	
	if (argc != 2) 	{
		switch (Geometry_type)	{
			case PROJECTIVE : junk = "Projective"; break;
			case EUCLIDEAN  : junk = "Euclidean" ; break;
			case HYPERBOLIC : junk = "Hyperbolic"; break;
			}
		printf(" geometry type is %s\n",junk);
		}
	else switch(argv[1][0]) {
			case 'p': case 'P': Geometry_type = PROJECTIVE; break;
			case 'e': case 'E': Geometry_type = EUCLIDEAN; break;
			case 'h': case 'H': Geometry_type = HYPERBOLIC; break;
			default: ERR_RET(GeomUsage);
			}
}

initialize_linear()
{
	register_client("geometry", set_geometry, GeomUsage);
}

emu_copy_matrix(M,N)
Matrix M,N;
{
	register int i,j;
	for (i = 0; i < 4; i++)
		for (j = 0; j < 4; j++)
			M[i][j] = N[i][j];
}

emu_mult(M,N)
Matrix M,N;
{
	Matrix tmp;
        register int i, j, k;

        for(i = 0; i < 4; i++) {
                for(j = 0; j < 4;j++) {
                        tmp[j][i] = 0.;
                        for(k = 0; k < 4;k++)
                                tmp[j][i] += M[k][i]*N[j][k];
                }
        }
        emu_copy_matrix(M, tmp);
}

emu_scale(M,x,y,z)
Matrix	M; double x,y,z;
{
	Matrix N;
	emu_copy_matrix(N,Identity);
	N[0][0] = x;
	N[1][1] = y;
	N[2][2] = z;
	emu_mult(M,N);
}

emu_rot(M,theta, a1, a2)
Matrix M; double theta;
{
	Matrix N;
	emu_copy_matrix(N,Identity);
	N[a1][a1] = N[a2][a2] = cos(theta);
	N[a2][a1] = - (N[a1][a2] = sin(theta));
	emu_mult(M,N);
}

emu_rotx(M, theta) Matrix M; double theta; { emu_rot(M, theta, 1, 2); }
emu_roty(M, theta) Matrix M; double theta; { emu_rot(M, theta, 2, 0); }
emu_rotz(M, theta) Matrix M; double theta; { emu_rot(M, theta, 0, 1); }

emu_translate(M,x,y,z)
Matrix M; double x,y,z;
{
	Matrix N;
	emu_copy_matrix(N,Identity);
	N[3][0] = x;
	N[3][1] = y;
	N[3][2] = z;
	emu_mult(M,N);
}

Coord det2(m,i1,i2,j1,j2)
Matrix m;
int i1,i2,j1,j2;
{
	return (m[i1][j1] * m[i2][j2] - m[i2][j1] * m[i1][j2]);
}

#define EPSILON 10e-20
invert_matrix(m, mi)
Matrix m, mi;
{
	int i, j;
	int k;
	double x;
	int largest;
	Matrix t;
	double f;
	emu_copy_matrix(t, m);
	emu_copy_matrix(mi, Identity);
	for (i = 0; i < 4; i++) {
		largest = i;
		for (j = i+1; j < 4; j++)
			if (fabs(t[j][i]) > fabs(t[largest][i]))
				largest = j;
		/* swap t[i][] with t[largest][] */
		for (k = 0; k < 4; k++) {
			x = t[i][k]; t[i][k] = t[largest][k]; t[largest][k] = x;
			x = mi[i][k]; mi[i][k] = mi[largest][k]; mi[largest][k] = x;
		}
		for (j = i+1; j < 4; j++) {
			f = t[j][i] / t[i][i];
			/* subtract f*t[i][] from t[j][] */
			for (k = 0; k < 4; k++) {
				t[j][k] -= f*t[i][k];
				mi[j][k] -= f*mi[i][k];
			}
		}
	}
	for (i = 0; i < 4; i++) {
		f = t[i][i];
		for (k = 0; k < 4; k++) {
			t[i][k] /= f;
			mi[i][k] /= f;
		}
	}
	for (i = 3; i >= 0; i--)
		for (j = i-1; j >= 0; j--) {
			f = t[j][i];
			for (k = 0; k < 4; k++) {
				t[j][k] -= f*t[i][k];
				mi[j][k] -= f*mi[i][k];
			}
		}
				
}

print_vectors(m,d)
Matrix m;
Coord d;
{
	Matrix BB;
	int i, j;
	for (i = 0; i < 4; i++) for (j = 0; j < 4; j++) BB[i][j] = 0;
	BB[0][3] = 1;
	BB[1][2] = -1; BB[1][3] = 1;
	BB[2][1] = 1; BB[2][3] = 1;
	emu_mult(BB, m);
	printf("dist: %lf\n", d);
	printf("eye: %lf %lf %lf\n", BB[0][0], BB[0][1], BB[0][2]);
	printf("obj: %lf %lf %lf\n", BB[1][0], BB[1][1], BB[1][2]);
	printf("up: %lf %lf %lf\n", BB[2][0], BB[2][1], BB[2][2]);
}
print_matrix(s, V)
char *s;
Matrix V;
{
	int i,j;
	printf("%s\n", s);
	for (i = 0; i < 4; i++) {
		for (j = 0; j < 4; j++)
			printf("%10f",V[i][j]);
		printf("\n");
	}
}
